/////////////////////////////////////////////////////////////////////////////
// Name:        Utils.h
// Purpose:     Miscellaneous utilities
// Author:      Alex Thuering
// Created:		06.04.2008
// RCS-ID:      $Id: Utils.h,v 1.3 2010/04/03 21:46:36 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef UTILS_H
#define UTILS_H

#include <wxSVGXML/svgxml.h>
#include <wx/arrstr.h>

const wxString DATAFORMAT_ACTION =  wxT("application/dvdstyler-action");
const wxString DATAFORMAT_MENU =  wxT("application/dvdstyler-menu");
const wxString DATAFORMAT_MENU_OBJECT =  wxT("application/dvdstyler-menu-object");

/**
 * Copies given xml node to the clipboard.
 * Data Format: application/dvdstyler
 */
void CopyXmlToClipboard(wxSvgXmlNode* node, wxString dataFormatId);
/**
 * Gets xml node from clipboard.
 * Data Format: application/dvdstyler
 */
bool GetXmlFromClipboard(wxString dataFormatId, wxSvgXmlDocument& doc);
/**
 * Gets text from clipboard.
 */
wxString GetTextFromClipboard();
/**
 * Sorts string arrays by value
 */
int Sort(wxArrayString& keys, wxArrayString& values, const wxString& selectedKey = wxEmptyString);

#endif // UTILS_H
