/////////////////////////////////////////////////////////////////////////////
// Name:        Languages.cpp
// Purpose:     Languages dialog
// Author:      Alex Thuering
// Created:	23.05.2003
// Remarks:	Based on LangChoice from audacity
// RCS-ID:      $Id: Languages.cpp,v 1.10 2010/06/30 20:05:05 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "Languages.h"
#include <wxVillaLib/utils.h>
#include <wx/defs.h>
#include <wx/button.h>
#include <wx/choice.h>
#include <wx/dialog.h>
#include <wx/intl.h>
#include <wx/sizer.h>
#include <wx/stattext.h>

// languages supported by dvdstyler
// arrays: langNames, langIds
#include "../locale/langs.h"

wxArrayString s_langNamesArr;

const wxArrayString& GetLangNames() {
	if (s_langNamesArr.size() == 0) {
		for (int i = 0; i < (int) WXSIZEOF(langNames); i++)
			s_langNamesArr.Add(wxString(langNames[i], wxConvUTF8));
	}
	return s_langNamesArr;
}

int GetLangCode(int index) {
	return langIds[index];
}

wxString GetLangName(int code) {
	for (unsigned int i = 0; i < GetLangNames().size(); i++)
		if (code == langIds[i])
			return GetLangNames()[i];
	return GetLangName(wxLANGUAGE_ENGLISH);
}

int ChooseLanguage() {
	wxSingleChoiceDialog dlg(NULL, _T("Choose Language for DVDStyler to use:"),
			_T("DVDStyler First Run"), GetLangNames());
	for (int i = 0; i < (int) WXSIZEOF(langIds); i++)
		if (langIds[i] == wxLocale::GetSystemLanguage())
			dlg.SetSelection(i);
	if (dlg.ShowModal() == wxID_OK)
		return langIds[dlg.GetSelection()];
	return wxLANGUAGE_ENGLISH;
}

const BitmapArray& GetLangBitmaps() {
	return GetLangBitmapArray();
}
