/////////////////////////////////////////////////////////////////////////////
// Name:        TemplateDlg.cpp
// Purpose:     Select DVD menu template dialog
// Author:      Alex Thuering
// Created:     20.10.2009
// RCS-ID:      $Id: TemplateDlg.cpp,v 1.4 2010/02/22 22:47:18 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "TemplateDlg.h"
#include "wxVillaLib/utils.h"
#include "wxVillaLib/rc/loading.png.h"
#include <wx/filename.h>

// begin wxGlade: ::extracode

// end wxGlade

#define TEMPLATES_DIR wxFindDataDirectory(_T("templates"))

BEGIN_EVENT_TABLE(TemplateDlg, wxDialog)
	EVT_THUMBNAILS_DCLICK(wxID_ANY, TemplateDlg::OnThumbDoubleClick)	
END_EVENT_TABLE()

TemplateDlg::TemplateDlg(wxWindow* parent): wxDialog(parent, wxID_ANY, wxEmptyString,
		wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER) {
    // begin wxGlade: TemplateDlg::TemplateDlg
    m_titleLabel = new wxStaticText(this, wxID_ANY, _("Title:"));
    m_titleText = new wxTextCtrl(this, wxID_ANY, _("Disc Title"));
    m_thumbnails = new wxThumbnails(this, wxID_ANY);
    m_staticLine = new wxStaticLine(this, wxID_ANY);
    m_okBt = new wxButton(this, wxID_OK, wxEmptyString);
    m_cancelBt = new wxButton(this, wxID_CANCEL, _("&No template"));

    set_properties();
    do_layout();
    // end wxGlade
    
    m_thumbnails->SetCaption(_("Templates"));
    m_thumbnails->SetThumbImageSize(145, 58);
    m_thumbnails->SetThumbnailOutlineSelectedColor(wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHT));
    m_thumbnails->SetThumbnailImageSelectedColor(wxColour());
    
    // load templates
	wxString fname = wxFindFirstFile(TEMPLATES_DIR + _T("*.dvdt"));
	while (!fname.IsEmpty()) {
		wxLogNull log;
		wxImage img;
		img.LoadFile(fname.BeforeLast(wxT('.')) + wxT(".png"));
		wxThumb* thumb = new wxThumb(img, wxFileName(fname).GetFullName().BeforeLast(wxT('.')), fname);
		m_thumbnails->InsertItem(thumb);
		fname = wxFindNextFile();
	}
	m_thumbnails->SortItems();
	
	if (m_thumbnails->GetItemCount() > 0)
		m_thumbnails->SetSelected(0);
	
	m_titleText->SetFocus();
}


void TemplateDlg::set_properties() {
    // begin wxGlade: TemplateDlg::set_properties
    SetTitle(_("Select template for DVD menus"));
    SetSize(wxSize(500, 300));
    m_okBt->SetDefault();
    // end wxGlade
}


void TemplateDlg::do_layout() {
    // begin wxGlade: TemplateDlg::do_layout
    wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* btSizer = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* propGridSizer = new wxFlexGridSizer(1, 2, 4, 4);
    propGridSizer->Add(m_titleLabel, 0, wxALIGN_CENTER_VERTICAL, 0);
    propGridSizer->Add(m_titleText, 0, wxEXPAND, 0);
    propGridSizer->AddGrowableCol(1);
    mainSizer->Add(propGridSizer, 0, wxALL|wxEXPAND, 4);
    mainSizer->Add(m_thumbnails, 1, wxALL|wxEXPAND, 2);
    mainSizer->Add(m_staticLine, 0, wxEXPAND, 0);
    btSizer->Add(10, 10, 1, 0, 0);
    btSizer->Add(m_okBt, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 8);
    btSizer->Add(8, 10, 0, 0, 0);
    btSizer->Add(m_cancelBt, 0, 0, 0);
    btSizer->Add(10, 10, 1, 0, 0);
    mainSizer->Add(btSizer, 0, wxALL|wxEXPAND, 10);
    SetSizer(mainSizer);
    Layout();
    Centre();
    // end wxGlade
}

wxString TemplateDlg::GetTemplate() {
	return m_thumbnails->GetSelectedItem()->GetFilename();
}

wxString TemplateDlg::GetTitle() {
	return m_titleText->GetValue();
}

void TemplateDlg::OnThumbDoubleClick(wxCommandEvent& event) {
	EndModal(wxID_OK);
}
