/////////////////////////////////////////////////////////////////////////////
// Name:        TemplateDlg.h
// Purpose:     Select DVD menu template dialog
// Author:      Alex Thuering
// Created:     20.10.2009
// RCS-ID:      $Id: TemplateDlg.h,v 1.1 2009/11/21 12:27:22 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#include <wx/wx.h>
#include <wx/image.h>
#include "wxVillaLib/Thumbnails.h"

#ifndef TEMPLATE_DLG_H
#define TEMPLATE_DLG_H

// begin wxGlade: ::dependencies
#include <wx/statline.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade


class TemplateDlg: public wxDialog {
public:
    // begin wxGlade: TemplateDlg::ids
    // end wxGlade
    TemplateDlg(wxWindow* parent);
    wxString GetTemplate();
    wxString GetTitle();

protected:
    // begin wxGlade: TemplateDlg::attributes
    wxStaticText* m_titleLabel;
    wxTextCtrl* m_titleText;
    wxThumbnails* m_thumbnails;
    wxStaticLine* m_staticLine;
    wxButton* m_okBt;
    wxButton* m_cancelBt;
    // end wxGlade
    
private:
    // begin wxGlade: TemplateDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    void OnThumbDoubleClick(wxCommandEvent& event);
    DECLARE_EVENT_TABLE()
}; // wxGlade: end class


#endif // TEMPLATE_DLG_H
