/////////////////////////////////////////////////////////////////////////////
// Name:        MenuPalettes.h
// Purpose:     The class to create and store menu palettes 
// Author:      Alex Thuering
// Created:	04.11.2006
// RCS-ID:      $Id: MenuPalettes.h,v 1.2 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef MENU_PALETTES_H
#define MENU_PALETTES_H

#include "Menu.h"
#include <wx/palette.h>
#include <wx/hashmap.h>
#include <wx/hashset.h>

WX_DECLARE_HASH_SET(int, wxIntegerHash, wxIntegerEqual, IntHashSet);

class Palette: public wxPalette
{
  private:
    int coloursCount;
    wxColour m_transpColour;
    
  public:
    Palette() { coloursCount = 0; }
    virtual ~Palette() {}
    bool Create(IntHashSet& colours, const wxColour& transpColour);    
    bool Apply(const unsigned char* pixel, unsigned char *dest) const;
};

WX_DECLARE_HASH_MAP(int, Palette, wxIntegerHash, wxIntegerEqual, PaletteMap);
WX_DECLARE_HASH_MAP(int, PaletteMap, wxIntegerHash, wxIntegerEqual, Palette2DMap);

class MenuPalettes
{
  private:
    Palette m_palette1;
    PaletteMap m_palette2;
    Palette2DMap m_palette3;
    wxColour m_transpColour;
    int GetKey(const unsigned char* pixel);
    
  public:
    /** Constructor. Creates palettes */
	MenuPalettes(MenuObject& obj, const wxColour& transpColour);
	
	/** Returns rgb value for first image (buttons normal) */
	bool Apply(const unsigned char* pixel1, unsigned char *dest);
	/** Returns rgb value for second image (buttons highlighted) */
	bool Apply(const unsigned char* pixel1, const unsigned char* pixel2,
	  unsigned char *dest);
	/** Returns rgb value for third image (buttons selected) */
	bool Apply(const unsigned char* pixel1, const unsigned char*  pixel2,
	  const unsigned char* pixel3, unsigned char *dest);
};

#endif // MENU_PALETTES_H
