/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * OCL Compiler                                                      *
 * Copyright (C) 1999, 2000 Frank Finger (frank@finger.org).         *
 * All rights reserved.                                              *
 *                                                                   *
 * This work was done as a diploma project at the Chair for Software *
 * Technology, Dresden University Of Technology, Germany             *
 * (http://www-st.inf.tu-dresden.de).  It is understood that any     *
 * modification not identified as such is not covered by the         *
 * preceding statement.                                              *
 *                                                                   *
 * This work is free software; you can redistribute it and/or        *
 * modify it under the terms of the GNU Library General Public       *
 * License as published by the Free Software Foundation; either      *
 * version 2 of the License, or (at your option) any later version.  *
 *                                                                   *
 * This work is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU *
 * Library General Public License for more details.                  *
 *                                                                   *
 * You should have received a copy of the GNU Library General Public *
 * License along with this library; if not, write to the             *
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,      *
 * Boston, MA  02111-1307, USA.                                      *
 *                                                                   *
 * To submit a bug report, send a comment, or get the latest news on *
 * this project and other projects, please visit the web site:       *
 * http://www-st.inf.tu-dresden.de/ (Chair home page) or             *
 * http://www-st.inf.tu-dresden.de/ocl/ (project home page)          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
// FILE: d:/java/classes/de/tudresden/ocl/OclUnsortedCollection.java

package tudresden.ocl.lib;
import java.util.*;

/** This class is not defined in the OCL specification. It is necessary since
 *  the operation <CODE>intersection</CODE> is defined for both Set and Bag,
 *  but not for Sequence.
 *
 *  @author Frank Finger
 */
public abstract class OclUnsortedCollection extends OclCollection {

  protected OclUnsortedCollection(Collection c) {
    super(c);
  }

  /** constructor for undefined OCL collection
   */
  protected OclUnsortedCollection(int dummy, String reason) {
    super(dummy, reason);
  }

  /** @return an OclBag according to the shorthand notation for <CODE>collect</CODE>
   *
   *  @see OclCollection#getFeature(String name)
   */
  public OclRoot getFeature(final String name)  {
    if(isUndefined()) 
      return this;
    final OclIterator iter;
    return (OclBag) this.collect(
      iter=this.getIterator(),
      new OclRootEvaluatable() {
        public OclRoot evaluate() {
          return iter.getValue().getFeature(name);
        }
      }
    );
  }

  /** The OCL types Bag and Set have this operation defined.
   *
   *  @return the intersection of this collection and the OclBag given as argument
   */
  public abstract OclUnsortedCollection intersection(OclBag coll);

  /** The OCL types Bag and Set have this operation defined.
   *
   *  @return the intersection of this collection and the OclSet given as
   */
  public abstract OclSet intersection(OclSet coll);

} /* end class OclUnsortedCollection */

