/*
Copyright (C) 2000  Steffen Zschaler

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * PropertyPageContainerTester.java
 *
 * Created on 13. September 2000, 14:20
 */
 
package tudresden.ocl.injection.reverseeng.propertypages;

import tudresden.ocl.injection.reverseeng.propertypages.events.*;

import javax.swing.*;

/** 
  * Test application for {@link PropertyPageContainer}.
  *
  * @author  sz9 (Steffen Zschaler)
  * @version 1.0
  */
public class PropertyPageContainerTester extends javax.swing.JDialog {

  /** Creates new form PropertyPageContainerTester */
  public PropertyPageContainerTester(java.awt.Frame parent,boolean modal) {
    super (parent, modal);
    initComponents ();
    
    DefaultListModel dlm = new DefaultListModel();
    dlm.addElement ("No properties");
    dlm.addElement ("Simple label");
    dlm.addElement ("Two pages");
    dlm.addElement ("Three pages");
    m_jlLeft.setModel (dlm);
    
    pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jSplitPane1 = new javax.swing.JSplitPane ();
    m_jlLeft = new javax.swing.JList ();
    m_ppcProperties = new tudresden.ocl.injection.reverseeng.propertypages.PropertyPageContainer ();
    getContentPane ().setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );


      m_jlLeft.addListSelectionListener (new javax.swing.event.ListSelectionListener () {
        public void valueChanged (javax.swing.event.ListSelectionEvent evt) {
          m_jlLeftValueChanged (evt);
        }
      }
      );
  
      jSplitPane1.setLeftComponent (m_jlLeft);
  
      java.awt.GridBagConstraints gridBagConstraints2;
  
      jSplitPane1.setRightComponent (m_ppcProperties);
  

    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.gridheight = 0;
    gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
    gridBagConstraints1.weightx = 1.0;
    gridBagConstraints1.weighty = 1.0;
    getContentPane ().add (jSplitPane1, gridBagConstraints1);

  }//GEN-END:initComponents

  private void m_jlLeftValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_m_jlLeftValueChanged
    switch (((JList) evt.getSource()).getSelectedIndex()) {
    case 0:
      m_ppcProperties.removeAllPropertyPages();
      break;
    case 1:
      m_ppcProperties.addPropertyPage (new DefaultPropertyPage ("Test", new JLabel ("Test")));
      break;
    case 2:
      m_ppcProperties.replacePropertyPages (new PropertyPage[] {
        new DefaultPropertyPage ("One", new JLabel ("One")),
        new DefaultPropertyPage ("Two", new JLabel ("Two"))
      });
      break;
    case 3:
      m_ppcProperties.replacePropertyPages (new PropertyPage[] {
        new DefaultPropertyPage ("OneNew", new JLabel ("One")),
        new DefaultPropertyPage ("TwoNew", new JLabel ("Two")),
        new DefaultPropertyPage ("ThreeNew", new JLabel ("Three"))
      });
      break;
    }
  }//GEN-LAST:event_m_jlLeftValueChanged

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
    
    System.exit (0);
  }//GEN-LAST:event_closeDialog

  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new PropertyPageContainerTester (new javax.swing.JFrame (), true).show ();
  }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JSplitPane jSplitPane1;
  private javax.swing.JList m_jlLeft;
  private tudresden.ocl.injection.reverseeng.propertypages.PropertyPageContainer m_ppcProperties;
  // End of variables declaration//GEN-END:variables

}