/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIDV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgDeleteValue(const char * const name);

	Delete any occurance of the value from the current section.
	If name == NULL, only the current value is deleted.

	Return: cfg error code

ob(ject): cfgDeleteValue
su(bsystem): inifile/3
sh(ort description): Delete a value from the current section
lo(ng description): Delete all values of the current section from the INI file
 with the specified name.\par
 If \para{name} == NULL, only the currently selected value is deleted.
re(lated to):
fi(le): cfgidv.c
in(itialized by):

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIDV.C 1.4 2001/02/27 01:27:26 ska Exp ska $";
#endif

int cfgDeleteValue(const char * const name)
{	DBG_ENTER("cfgDeleteValue", Suppl_inifile3)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	if(!hasKey(usrini))			/* no key --> no value --> success */
		DBG_RETURN_I( CFG_ERR_NONE)

	DBG_RETURN_BI( cfgi_replaceValue(name, 0, 0, 0))
}
