/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* Test dfnsplit() and dfnmerge() */

#include <stdio.h>
#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#endif
#define SUPPL_DBG_HEAP
#define SUPPL_LOG_MEMORY
#define SUPPL_LOG_FUNCTION
#include "suppldbg.h"

#include "dfn.h"

void hlpScreen()
{	exit(127);
}

FILE *logf = NULL;

void logx(const char * const msg)
{
	if(!logf) {
		if((logf = fopen("T.TST", "wt")) == NULL) {
			puts("Cannot create logfile T.TST");
			exit(40);
		}
		chkHeap
	}

	fputs(msg, stdout);
	fputs(msg, logf);
}

void log(const char * const msg)
{
	logx(msg);
	logx("\n");
}
void log2(const char * const msg, const char * const fnam)
{
	logx(msg);
	logx("\"");
	logx(fnam);
	log("\"");
}
void logN(const char * const msg, const char * const fnam)
{
	logx("\t");
	logx(msg);
	logx("            " + strlen(msg));
	if(fnam) {
		logx(": \"");
		logx(fnam);
		log("\"");
	} else {
		log(": <<none>>");
	}
}

void test(char *fnam)
{
	char *dr, *pa, *na, *ex, *fn;

	chkHeap
	log("\n==============================");
	log2("Input filename: ", fnam);
	chkHeap
	if(!dfnsplit(fnam, &dr, &pa, &na, &ex))
		log(">>>Out of memory error in dfnsplit()");
	else {
		chkHeap
		logN("drive", dr);
		logN("path", pa);
		logN("name", na);
		logN("extension", ex);
		if((fn = dfnmerge(NULL, dr, pa, na, ex)) == NULL)
			log(">>>Out of memory error in dfnmerge()");
		else {
			chkHeap
			log2("Re-merged name: ", fn);
			if(strcmp(fnam, fn))
				log("Warning: merged path differs from original one!");
			free(fn);
		}
		chkHeap
		free(dr);
		chkHeap
		free(pa);
		chkHeap
		free(na);
		chkHeap
		free(ex);
	}
	chkHeap
}



main(int argc, char **argv)
{
	/** The DBG_ENTER() macro is used in its broken up format
		in order to have the opening of "main" to be logged **/
	DBG_ENTER1
		/* log everything incl. SUPPL library */
	DBG_CHANGE_STATE("l+;C+,+SUPPL")
	DBG_ENTER2("main", "usr")
	openlog("T", 0, 0);					/* memory logger */

	chkHeap

	if(argc == 1) {
		/* run internal test */
		test("D:\\path\\name.ext");
		chkHeap
		test("D:\\path1\\path2\\name.ext");
		chkHeap
		test("\\path1\\path2\\name.ext");
		chkHeap
		test("path1\\path2\\name.ext");
		chkHeap
		test("name.ext");
		chkHeap
		test("name");
		chkHeap
		test("D:\\path1\\path2\\");
		chkHeap
		test("D:\\path1\\path2");
		chkHeap
		test("D:");
		chkHeap
		test("D:\\");
		chkHeap
		test("D:\\name.exe");
		chkHeap
		test("D:path1\\path2\\name.ext");
		chkHeap
		test("D:name.ext");
		chkHeap
		test("D:.");
		chkHeap
		test("D:\\.");
		chkHeap
		test("D:\\path1\\.");
		chkHeap
		test("D:\\path\\....name");
		chkHeap
		test("D:\\path\\....name.ext");
		chkHeap
		test("\\");
		chkHeap
		test(".");
		chkHeap
	} else {
		int i;

		for(i = 1; argv[i]; ++i) {
			test(argv[i]);
			chkHeap
		}
	}
	DBG_RETURN_I(0)
}
