/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGISV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgSetValue(char * name, const char * const data
	 , const char * const comment, int type, int trustlevel);

	This is a combination of DeleteValue(name) and AddValue(name,...),
	except if name == NULL, the value is not added, but replaces
	the current value only.

	If data == NULL, the value(s) are removed rather than replaced
	by a new value.

	If name == NULL, type and/or trustlevel may be CFG_TDEFAULT/
	CFG_DEFAULT_TRUSTLEVEL, in which case the respective setting
	from the currently selected value is used.

ob(ject): cfgSetValue
su(bsystem): inifile/3
sh(ort description): Create/Replace/Remove a value
lo(ng description): Remove all occurances of the value with the specified
	name, then, if \para{data} != NULL, a new line is appended to the
	section with the value.\par
	If \para{name} == NULL, \para{type} == CFG_TDEFAULT or \para{trustlevel}
	== CFG_DEFAULT_TRUSTLEVEL, the particular setting is taken from the
	current value.
re(lated to): cfgAddValue
fi(le): cfgisv.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGISV.C 1.3 1999/12/13 02:22:26 ska Exp ska $";
#endif

int cfgSetValue(const char * const name, const char * const data
 , const char * const comment, int type , int trustlevel)
{
	DBG_ENTER("cfgSetValue", Suppl_inifile3)
	DBG_ARGUMENTS( ("name=\"%s\", data=\"%s\", cmt=\"%s\", typ=%d, lvl=%d", name, data, comment, type, trustlevel) )

	if(!hasKey(usrini))			/* no key --> cannot add value */
		DBG_RETURN_I( CFG_ERR_KEY)

	DBG_RETURN_BI( cfgi_replaceValue(name, cfgi_packData(data, comment, 1)
	 , type, trustlevel))
}
