/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIHUS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgHasUserSection(const char * const name);

	Search the user INI file, if a section "name" exists.
	If so, the current file position is the first line behind the
	section.

	Return:
		0: key found

ob(ject): cfgHasUserSection
su(bsystem): inifile/2
sh(ort description): Search the user INI file for a section
lo(ng description): Search the user INI file for a section and set
	the file position behind the line containing the section ID.
re(lated to): 
fi(le): cfgihus.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIHUS.C 1.3 1999/12/13 02:22:24 ska Exp ska $";
#endif

int cfgHasUserSection(const char * const name)
{	DBG_ENTER("cfgHasUserSection", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	if(!hasFile(usrini))			/* has user INI file at all? */
		DBG_RETURN_I( CFG_ERR_KEY)

	chkHeap
	DBG_RETURN_BI( cfgi_findSec(usrini.cfgi_fp, name))
}
