#!/bin/bash
#
#  userful-command-tool.sh
#
############################
ProgramName=`basename $0`

###############
# usage()
###############
function usage()
{
	echo ""
	echo "Usage: $ProgramName COMMAND [command_opts] [command_args]"
	echo ""
	echo -e "\tCOMMAND:"
	echo -e "\t\t-h"
	echo -e "\t\t-help\t\t- Print this help message"
	echo -e "\t\txconfig\t\t- Handling of X config file"
	echo -e "\t\tvideo\t\t- Video cards control"
	echo -e "\t\tinput\t\t- Input devices control"
	echo -e "\t\tdebug\t\t- Submitting debug info"
	echo -e "\t\tlicense\t\t- Getting/displaying license"
	echo -e "\t\tdriver\t\t- Handling video driver"
	echo -e "\t\tmultistation\t- Toggling between multi-station and single-station"
	echo -e "\t\tctrlaltbreak\t- Enable/disable Ctrl-Alt-Break function"
	echo ""
	exit 1
}

[[ -z $1 ]] && usage
COMMAND=$1
shift

##############################################
# Parse COMMAND part and execute real command
##############################################
case "$COMMAND" in
	"-h"|"-help")
		usage
		;;

	"xconfig")
		exec /opt/userful/bin/userful-xconfig-command.sh $*
		;;

	"video")
		exec /opt/userful/bin/userful-video-command.sh $*
		;;

	"input")
		exec /opt/userful/bin/userful-input-command.sh $*
		;;

	"debug")
		exec /opt/userful/bin/userful-debug-command.sh $*
		;;

	"license")
		echo -e "\n\"$COMMAND\" command is not implemented yet.\n"
		;;

	"driver")
		exec /opt/userful/bin/userful-driver-command.sh $*
		;;

	"multistation")
		exec /opt/userful/bin/userful-multistation-command.sh $*
		;;

	"ctrlaltbreak")
		exec /opt/userful/bin/userful-ctrlaltbreak-command.sh $*
		;;

	*)
		echo -e "\nError: Invalid command name - $COMMAND\n"
		usage
		;;
esac
