#!/bin/bash
#
# dm-config-mga-driver.sh
#
#    Configure mag_drv.o based on current X type.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
## need to update mga driver because built-in and Matrox's proprietary 
## driver use the same driver name, mga.

# Configure the mga driver based on current X type
if [ "$1" = "single" ]; then
	## for X11R6
	if [ -d /usr/X11R6/lib64/modules/drivers -a \
	   ! -e /usr/X11R6/lib64/modules/drivers/mga_drv.o ]; then
		mv -f /usr/X11R6/lib64/modules/drivers/mga_drv.o.multi-save \
			  /usr/X11R6/lib64/modules/drivers/mga_drv.o 2> /dev/null
	fi
	if [ -d /usr/X11R6/lib/modules/drivers -a \
       ! -e /usr/X11R6/lib/modules/drivers/mga_drv.o ]; then
		mv -f /usr/X11R6/lib/modules/drivers/mga_drv.o.multi-save \
			  /usr/X11R6/lib/modules/drivers/mga_drv.o 2> /dev/null
	fi

	## for X11R7
	if [ -d /usr/lib64/xorg/modules/drivers -a \
	   ! -e /usr/lib64/xorg/modules/drivers/mga_drv.so ]; then
		mv -f /usr/lib64/xorg/modules/drivers/mga_drv.so.multi-save \
			  /usr/lib64/xorg/modules/drivers/mga_drv.so 2> /dev/null
	fi
	if [ -d /usr/lib/xorg/modules/drivers -a \
	   ! -e /usr/lib/xorg/modules/drivers/mga_drv.so ]; then
		mv -f /usr/lib/xorg/modules/drivers/mga_drv.so.multi-save \
			  /usr/lib/xorg/modules/drivers/mga_drv.so 2> /dev/null
	fi

elif [ "$1" = "multi" ]; then
	## For MX11R6

	# rename mga_drv.o in /usr/X11R6/lib64/modules/drivers/ to mga_drv.o.multi-save,
	# then use mga_drv.o in /opt/MX11R6/lib64 directory
	if [ -d /usr/X11R6/lib64/modules/drivers -a \
	   ! -e /usr/X11R6/lib64/modules/drivers/mga_drv.o.multi-save ]; then
		mv -f /usr/X11R6/lib64/modules/drivers/mga_drv.o \
			  /usr/X11R6/lib64/modules/drivers/mga_drv.o.multi-save 2> /dev/null
	# For MGA proprietary driver,  use new drvier in /usr/X11R6/lib64 directory
	elif [ -d /usr/X11R6/lib64/modules/drivers -a \
		   -e /usr/X11R6/lib64/modules/drivers/mga_drv.o -a \
		   -e /usr/X11R6/lib64/modules/drivers/mga_drv.o.multi-save ]; then 
			 mv -f /opt/MX11R6/lib64/modules/drivers/mga_drv.o \
			 	   /opt/MX11R6/lib64/modules/drivers/mga_drv.o.multi-save 2> /dev/null
	fi
	# use driver in /opt/MX11R6/lib directory
	if [ -d /usr/X11R6/lib/modules/drivers -a \
	   ! -e /usr/X11R6/lib/modules/drivers/mga_drv.o.multi-save ]; then
			mv -f /usr/X11R6/lib/modules/drivers/mga_drv.o \
				  /usr/X11R6/lib/modules/drivers/mga_drv.o.multi-save 2> /dev/null
	# For MGA proprietary driver,  use new drvier in /usr/X11R6/lib directory
	elif [ -d /usr/X11R6/lib/modules/drivers -a \
		   -e /usr/X11R6/lib/modules/drivers/mga_drv.o -a \
		   -e /usr/X11R6/lib/modules/drivers/mga_drv.o.multi-save ]; then 
			 mv -f /opt/MX11R6/lib/modules/drivers/mga_drv.o \
			 	   /opt/MX11R6/lib/modules/drivers/mga_drv.o.multi-save 2> /dev/null
	fi

	## For MX11R7
	# rename mga_drv.so in /usr/lib64/xorg/modules/drivers/ to mga_drv.so.multi-save,
	# then use mga_drv.so in /opt/MX11R6/lib64 directory
	if [ -d /usr/lib64/xorg/modules/drivers -a \
	   ! -e /usr/lib64/xorg/modules/drivers/mga_drv.so.multi-save ]; then
		mv -f /usr/lib64/xorg/modules/drivers/mga_drv.so \
			  /usr/lib64/xorg/modules/drivers/mga_drv.so.multi-save 2> /dev/null
	# For MGA proprietary driver,  use new drvier in /usr/X11R6/lib64 directory
	elif [ -d /usr/lib64/xorg/modules/drivers -a \
		   -e /usr/lib64/xorg/modules/drivers/mga_drv.so -a \
		   -e /usr/lib64/xorg/modules/drivers/mga_drv.so.multi-save ]; then 
			 mv -f /opt/MX11R7/lib64/xorg/modules/drivers/mga_drv.so \
			 	   /opt/MX11R7/lib64/xorg/modules/drivers/mga_drv.so.multi-save 2> /dev/null
	fi
	# then use mga_drv.so in /opt/MX11R6/lib directory
	if [ -d /usr/lib/xorg/modules/drivers -a \
	   ! -e /usr/lib/xorg/modules/drivers/mga_drv.so.multi-save ]; then
		mv -f /usr/lib/xorg/modules/drivers/mga_drv.so \
			  /usr/lib/xorg/modules/drivers/mga_drv.so.multi-save 2> /dev/null
	# For MGA proprietary driver,  use new drvier in /usr/X11R6/lib64 directory
	elif [ -d /usr/lib/xorg/modules/drivers -a \
		   -e /usr/lib/xorg/modules/drivers/mga_drv.so -a \
		   -e /usr/lib/xorg/modules/drivers/mga_drv.so.multi-save ]; then 
			 mv -f /opt/MX11R7/lib/xorg/modules/drivers/mga_drv.so \
			 	   /opt/MX11R7/lib/xorg/modules/drivers/mga_drv.so.multi-save 2> /dev/null
	fi
fi
