/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __XMATRIX_H
#define __XMATRIX_H

#ifndef __XPOOL_H
#include "xpool.h"
#endif

#ifndef __XMACROS_H
#include "xmacros.h"
#endif

template <class T>
class XMatrix :
   public XPool
{
   Private( int, Width );
   Private( int, Height );

   public:
   XMatrix():
      XPool(),
      Width(0),
      Height(0)
      {};

   XMatrix( unsigned width, unsigned height ):
      XPool(),
      Width(0),
      Height(0)
      {
         Create( width, height );
      };

   Bool  Create( unsigned width, unsigned height )
   {
      if (XPool::Create(width*height*sizeof(T)))
      {  Width  = width;
         Height = height;
         return TRUE;
      }
      RETFALSE;
   };

   void  Destroy()
   {  Width =0;
      Height =0;
      XPool::Destroy();
   };

   T& Get( int i, int j ) const
   {
      assert( i >= 0 );
      assert( j >= 0 );
      assert( i < Height );
      assert( j < Width );
      return *(((T*)GetData()) + i*Width + j );
   };
   operator T*()  const {  return (T*)(GetData()); };
	Bool  operator !() const { return GetData() == NULL; };
	Bool  IsEmpty() { return (Width==0) || (Height==0); };
};
#endif
