/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "internal.h"
#pragma hdrstop

#include "std.h"

#ifdef WIN32
   #include <wingdi.h>
   #include <winuser.h>
#endif

STD_FUNC( void ) stdAssert(const char *__cond, const char *__file, int __line)
{

#if defined( _WINDOWS )||defined( _Windows )
        char mess[512];
   sprintf( mess,
      " %s file %s, line %d\n Continue (Yes),Breakpoint(No) or Cancel?",
                                __cond, __file, __line);

   switch( MessageBox(NULL,mess,"Assertion failed:",MB_YESNOCANCEL ))
   {  case 0      :  case IDCANCEL:  exit(0);
      case IDNO   :  _asm int 3;break;
      case IDYES  :   break;
        };
#else
   printf( "\nAssertion failed: %s file %s, line %d\n", __cond, __file, __line );
   printf( "\nPress <Space> to continue,<Enter> to break, <Esc> to abort" );
   char c;

     do {
    c = getchar();
      } while ((c != 32)&&( c != 27 )&&(c!=13));
        if (c == 27)
                exit(0);
if ( c == 13){
#if defined (_MSC_VER)
           _asm int 3
#else
           abort();
#endif
               }
  printf("..OK");
#endif
}
