/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __USERDICT_FUNCS_H__
#define __USERDICT_FUNCS_H__

#if _MSC_VER > 1000
   #pragma once
#endif // _MSC_VER > 1000

#include "cttypes.h"
#include "udictest.h"

 DWORD        LoadUserDict( CHAR      *DictName,
                            CHAR      *pool,
                            DWORD     pool_size,
                            voc_state *user_dict);

 DWORD InitializeNewUserDict ( CHAR *    pool,
                               DWORD      pool_size,
                               voc_state *user_dict);
 void  ResetUserDict(voc_state * user_dict);

 INT _IsUserDict (CHAR  *FileName);

 BOOL CloseUserDictionary (BYTE * DictName, voc_state *user_dict);
 INT  AddWordToUserDictionary ( BYTE * word, INT weight,voc_state * user_dict);
 INT  DeleteWordFromUserDictionary ( BYTE * word, voc_state * user_dict);
 INT  IsWordInUserDictionary ( BYTE * word, voc_state * user_dict);
 INT  SplitWordRecord(BYTE * str);
 INT  voc_init (voc_state * voc);
 INT  next_word_from_voc ( BYTE *str, voc_state *voc);

#endif   //#ifndef __USERDICT_FUNCS_H__
