/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#ifndef _EMBBOX_DEFINED
#define _EMBBOX_DEFINED

#define WBOX          3
#define HBOX          5
#define NBBOX         16 // 7

#include "struct.h"
#include "cutstr.h"

#define iFINE_CONST  4

typedef struct elidx
 {
 BYTE ltr;                  // the letter
 BYTE vnum;                 // the number of the classes
 WORD numel;                // the number of the first class
 } indBOX;

typedef struct eltab
 {
 BYTE ltr;                  // the letter
 BYTE fnt;                  // the font number
 WORD list;                 // next of same letter
 WORD bnd;                  // the bound of the typeface
 WORD vect[15];             // the vector of the letter
 } elmBOX;

struct res_recog
 {
 CHAR best_lets[NBBOX+1];      // best letters
 CHAR best_font[NBBOX+1];
 WORD ibest_cosinus[NBBOX+1];  // best cosinus
 WORD icurr_cosinus;
 BYTE curr_ltr;
 BYTE curr_font;
 CHAR n_rsn[NBBOX+1]; // number of letter from all same letters
 };

struct t_m_3_5
 {
 WORD isq_rt;
 WORD vect[WBOX*HBOX];
 };
typedef struct t_m_3_5 t_mBOX;

struct str_servBOX
 {
 INT up_row,left_col;       // left upper corner coordinates
 INT math_row, math_col;    // same after deskewing
 INT rast_h,rast_w;         // height, width
 CHAR dens;                 // density in 1/8-ths
 t_mBOX matrBOX;
 t_answer best_BOX[NBBOX+1];
 };
typedef struct str_servBOX servBOX;

#define mBOX SBOX.matrBOX.vect
#define vmBOX SBOX->matrBOX.vect

#endif
