(** Colour Spaces *)

(** A Tristimulus Point *)
type point = float * float * float

(** ICC Based Colour Spaces *)
type iccbased =
 {icc_n : int;
  icc_alternate : colourspace;
  icc_range : float array;
  icc_metadata : Pdf.pdfobject option;
  icc_stream : Pdf.pdfobject}

(** Colour spaces *)
and colourspace =
  | DeviceGray
  | DeviceRGB
  | DeviceCMYK
  | CalGray of point * point * float (* White, Black, Gamma *)
  | CalRGB of point * point * float array * float array (* White, Black, Gamma, Matrix *)
  | Lab of point * point * float array (* White, Black, Range *)
  | ICCBased of iccbased
  | Indexed of colourspace * (int, int list) Hashtbl.t (* Base colourspace, lookup table *)
  | Pattern
  | Separation of string * colourspace * Pdffun.pdf_fun
  | DeviceN of string array * colourspace * Pdffun.pdf_fun * Pdf.pdfobject

(** Produce a debug string *)
val string_of_colourspace : colourspace -> string

(** Read a colourspace from a PDF given a document, page resources dictionary and the colourspace object *)
val read_colourspace : Pdf.pdfdoc -> Pdf.pdfobject -> Pdf.pdfobject -> colourspace

