/* Copyright status: this file is in the public domain. */

#include <stdio.h>
#include <strings.h>
#include <sound/sound.h>

#include "blockade-snd.h"
#include "blockade-snddata.h"

extern char **argvec;

static SNDSoundStruct *s[N_SOUNDS];
static int tag = 0;

void setup_sound(void)
{
 char *ptr;
 int size;
 int width;
 int n;
 int rv;

 for (n=0;n<N_SOUNDS;n++)
  { rv = SNDAlloc(&s[n],*blockade_sound_sizes[n],SND_FORMAT_MULAW_8,SND_RATE_CODEC,1,4);
    if (rv != SND_ERR_NONE)
     { fprintf(stderr,"%s: SNDAlloc: %s\n",argvec[0],SNDSoundError(rv));
       return;
     }
    rv = SNDGetDataPointer(s[n],&ptr,&size,&width);
    if (rv != SND_ERR_NONE)
     { fprintf(stderr,"%s: SNDGetDataPointer: %s\n",argvec[0],SNDSoundError(rv));
       return;
     }
    bcopy(blockade_sounds[n],ptr,*blockade_sound_sizes[n]);
  }
 tag = 1;
}

void playsound(int n)
{
 int rv;

 if ((n < 0) || (n >= N_SOUNDS)) abort();
 if (tag == 0) return;
 /*SNDWait(tag);*/
 tag ++;
 rv = SNDStartPlaying(s[n],tag,0,0,SND_NULL_FUN,SND_NULL_FUN);
 if (rv != SND_ERR_NONE)
  { fprintf(stderr,"%s: SNDStartPlaying: %s\n",argvec[0],SNDSoundError(rv));
    return;
  }
}
