/*
 *  str_format.h -- BabyTrans ( Babylon Translator front-end for GTK )
 *
 *  Copyright (C) 1999  Frederic Jolliton -- <fjolliton@fnac.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* WARNING: You need a recent compiler (gcc 2.95.2) to use template
   members functions */

#ifndef FORMAT_H
#define FORMAT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iostream>
#include "fred_sstream"

#ifdef HONOR_STD
using std::ostringstream ;
using std::string ;
using std::ostream ;
#endif

class str_format
{
    string              fmt ;
    int                 arg_count ;
public:
                        str_format( const string& _fmt )
                            : fmt( _fmt ) , arg_count( 1 ) { }
                        str_format( const char* _fmt )
                            : fmt( _fmt ) , arg_count( 1 ) { }
                        operator string() { return fmt ; }
                        operator const char*() { return fmt.c_str() ; }
    string              str() const { return fmt ; }
#ifdef SUPPORT_TEMPLATE_MEMBER
    template< typename T >
    str_format&         with( const T& t ) ;
#else
	str_format&			with( const string& t ) ;
	str_format&			with( size_t t ) ;
#endif
} ;

#ifdef SUPPORT_TEMPLATE_MEMBER
template< typename T >
str_format&
str_format::with( const T& t )
{
    ostringstream       id ;
    id << '%' << ( arg_count ++ ) ;

    size_t              id_size = id.str().size() ;

    ostringstream       new_fmt ;
    string::size_type   i ;
    string::size_type   i_last = 0 ;
    while ( ( i = fmt.find( id.str() , i_last ) ) != fmt.npos ) {
        if ( i != i_last )
            new_fmt << fmt.substr( i_last , i - i_last ) ;
        new_fmt << t ;
        i_last = i + id_size ;
    }
    new_fmt << fmt.substr( i_last ) ;
    fmt = new_fmt.str() ;
    return *this ;
}
#else
inline
str_format&
str_format::with( size_t t )
{
    ostringstream       str ;
    str << t ;
    this->with( str.str() ) ;
}
inline
str_format&
str_format::with( const string& t )
{
    ostringstream       id ;
    id << '%' << ( arg_count ++ ) ;

    size_t              id_size = id.str().size() ;

    ostringstream       new_fmt ;
    string::size_type   i ;
    string::size_type   i_last = 0 ;
    while ( ( i = fmt.find( id.str() , i_last ) ) != fmt.npos ) {
        if ( i != i_last )
            new_fmt << fmt.substr( i_last , i - i_last ) ;
        new_fmt << t ;
        i_last = i + id_size ;
    }
    new_fmt << fmt.substr( i_last ) ;
    fmt = new_fmt.str() ;
    return *this ;
}
#endif

inline
ostream&
operator<<( ostream& os , const str_format& f )
{
    os << f.str() ;
    return os ;
}

#endif
