/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.AndAnnotationTypePattern;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.TypePattern;

public class AndTypePattern
extends TypePattern {
    private TypePattern left;
    private TypePattern right;

    public AndTypePattern(TypePattern left, TypePattern right) {
        super(false, false);
        this.left = left;
        this.right = right;
        this.setLocation(left.getSourceContext(), left.getStart(), right.getEnd());
    }

    protected boolean couldEverMatchSameTypesAs(TypePattern other) {
        return true;
    }

    public FuzzyBoolean matchesInstanceof(ResolvedTypeX type) {
        return this.left.matchesInstanceof(type).and(this.right.matchesInstanceof(type));
    }

    protected boolean matchesExactly(ResolvedTypeX type) {
        return this.left.matchesExactly(type) && this.right.matchesExactly(type);
    }

    protected boolean matchesExactly(ResolvedTypeX type, ResolvedTypeX annotatedType) {
        return this.left.matchesExactly(type, annotatedType) && this.right.matchesExactly(type, annotatedType);
    }

    public boolean matchesStatically(Class type) {
        return this.left.matchesStatically(type) && this.right.matchesStatically(type);
    }

    public FuzzyBoolean matchesInstanceof(Class type) {
        return this.left.matchesInstanceof(type).and(this.right.matchesInstanceof(type));
    }

    protected boolean matchesExactly(Class type) {
        return this.left.matchesExactly(type) && this.right.matchesExactly(type);
    }

    public boolean matchesStatically(ResolvedTypeX type) {
        return this.left.matchesStatically(type) && this.right.matchesStatically(type);
    }

    public void setIsVarArgs(boolean isVarArgs) {
        this.isVarArgs = isVarArgs;
        this.left.setIsVarArgs(isVarArgs);
        this.right.setIsVarArgs(isVarArgs);
    }

    public void setAnnotationTypePattern(AnnotationTypePattern annPatt) {
        if (annPatt == AnnotationTypePattern.ANY) {
            return;
        }
        if (this.left.annotationPattern == AnnotationTypePattern.ANY) {
            this.left.setAnnotationTypePattern(annPatt);
        } else {
            this.left.setAnnotationTypePattern(new AndAnnotationTypePattern(this.left.annotationPattern, annPatt));
        }
        if (this.right.annotationPattern == AnnotationTypePattern.ANY) {
            this.right.setAnnotationTypePattern(annPatt);
        } else {
            this.right.setAnnotationTypePattern(new AndAnnotationTypePattern(this.right.annotationPattern, annPatt));
        }
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(8);
        this.left.write(s);
        this.right.write(s);
        this.writeLocation(s);
    }

    public static TypePattern read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        AndTypePattern ret = new AndTypePattern(TypePattern.read(s, context), TypePattern.read(s, context));
        ret.readLocation(context, s);
        if (ret.left.isVarArgs && ret.right.isVarArgs) {
            ret.isVarArgs = true;
        }
        return ret;
    }

    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        if (requireExactType) {
            return this.notExactType(scope);
        }
        this.left = this.left.resolveBindings(scope, bindings, false, false);
        this.right = this.right.resolveBindings(scope, bindings, false, false);
        return this;
    }

    public TypePattern resolveBindingsFromRTTI(boolean allowBinding, boolean requireExactType) {
        if (requireExactType) {
            return TypePattern.NO;
        }
        this.left = this.left.resolveBindingsFromRTTI(allowBinding, requireExactType);
        this.right = this.right.resolveBindingsFromRTTI(allowBinding, requireExactType);
        return this;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append('(');
            buff.append(this.annotationPattern.toString());
            buff.append(' ');
        }
        buff.append('(');
        buff.append(this.left.toString());
        buff.append(" && ");
        buff.append(this.right.toString());
        buff.append(')');
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append(')');
        }
        return buff.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AndTypePattern)) {
            return false;
        }
        AndTypePattern atp = (AndTypePattern)obj;
        return this.left.equals(atp.left) && this.right.equals(atp.right);
    }

    public int hashCode() {
        int ret = 17;
        ret += 37 * this.left.hashCode();
        return ret += 37 * this.right.hashCode();
    }
}

