/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ataspectj.Aj5Attributes;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.Utility;

final class BcelMethod
extends ResolvedMember {
    private Method method;
    private boolean isAjSynthetic;
    private ShadowMunger associatedShadowMunger;
    private ResolvedPointcutDefinition preResolvedPointcut;
    private ResolvedTypeX[] annotationTypes = null;
    private AnnotationX[] annotations = null;
    private AjAttribute.EffectiveSignatureAttribute effectiveSignature;
    private AjAttribute.MethodDeclarationLineNumberAttribute declarationLineNumber;
    private ResolvedTypeX[] resolvedAnnotations;
    private World world;

    BcelMethod(BcelObjectType declaringType, Method method) {
        super(method.getName().equals("<init>") ? Member.CONSTRUCTOR : (method.getName().equals("<clinit>") ? Member.STATIC_INITIALIZATION : Member.METHOD), declaringType.getResolvedTypeX(), declaringType.isInterface() ? method.getAccessFlags() | 0x200 : method.getAccessFlags(), method.getName(), method.getSignature());
        this.method = method;
        this.sourceContext = declaringType.getResolvedTypeX().getSourceContext();
        this.world = declaringType.getResolvedTypeX().getWorld();
        this.unpackAjAttributes(this.world);
        this.unpackJavaAttributes();
    }

    private void unpackJavaAttributes() {
        ExceptionTable exnTable = this.method.getExceptionTable();
        this.checkedExceptions = exnTable == null ? TypeX.NONE : TypeX.forNames(exnTable.getExceptionNames());
        LocalVariableTable varTable = this.method.getLocalVariableTable();
        int len = this.getArity();
        if (varTable == null) {
            this.parameterNames = Utility.makeArgNames(len);
        } else {
            TypeX[] paramTypes = this.getParameterTypes();
            String[] paramNames = new String[len];
            int index = this.isStatic() ? 0 : 1;
            for (int i = 0; i < len; ++i) {
                LocalVariable lv = varTable.getLocalVariable(index);
                paramNames[i] = lv == null ? "arg" + i : lv.getName();
                index += paramTypes[i].getSize();
            }
            this.parameterNames = paramNames;
        }
    }

    private void unpackAjAttributes(World world) {
        this.associatedShadowMunger = null;
        List as = BcelAttributes.readAjAttributes(this.getDeclaringType().getClassName(), this.method.getAttributes(), this.getSourceContext(world), world.getMessageHandler());
        this.processAttributes(world, as);
        as = Aj5Attributes.readAj5MethodAttributes(this.method, world.resolve(this.getDeclaringType()), this.preResolvedPointcut, this.getSourceContext(world), world.getMessageHandler());
        this.processAttributes(world, as);
    }

    private void processAttributes(World world, List as) {
        Iterator iter = as.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.MethodDeclarationLineNumberAttribute) {
                this.declarationLineNumber = (AjAttribute.MethodDeclarationLineNumberAttribute)a;
                continue;
            }
            if (a instanceof AjAttribute.AdviceAttribute) {
                this.associatedShadowMunger = ((AjAttribute.AdviceAttribute)a).reify(this, world);
                continue;
            }
            if (a instanceof AjAttribute.AjSynthetic) {
                this.isAjSynthetic = true;
                continue;
            }
            if (a instanceof AjAttribute.EffectiveSignatureAttribute) {
                this.effectiveSignature = (AjAttribute.EffectiveSignatureAttribute)a;
                continue;
            }
            if (a instanceof AjAttribute.PointcutDeclarationAttribute) {
                this.preResolvedPointcut = ((AjAttribute.PointcutDeclarationAttribute)a).reify();
                continue;
            }
            throw new BCException("weird method attribute " + a);
        }
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    public ShadowMunger getAssociatedShadowMunger() {
        return this.associatedShadowMunger;
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        return this.effectiveSignature;
    }

    public boolean hasDeclarationLineNumberInfo() {
        return this.declarationLineNumber != null;
    }

    public int getDeclarationLineNumber() {
        if (this.declarationLineNumber != null) {
            return this.declarationLineNumber.getLineNumber();
        }
        return -1;
    }

    public ISourceLocation getSourceLocation() {
        ISourceLocation ret = super.getSourceLocation();
        if ((ret == null || ret.getLine() == 0) && this.hasDeclarationLineNumberInfo()) {
            ISourceContext isc = this.getSourceContext();
            ret = isc != null ? isc.makeSourceLocation(this.getDeclarationLineNumber()) : new SourceLocation(null, this.getDeclarationLineNumber());
        }
        return ret;
    }

    public Member.Kind getKind() {
        if (this.associatedShadowMunger != null) {
            return Member.ADVICE;
        }
        return super.getKind();
    }

    public boolean hasAnnotation(TypeX ofType) {
        this.ensureAnnotationTypesRetrieved();
        for (int i = 0; i < this.annotationTypes.length; ++i) {
            ResolvedTypeX aType = this.annotationTypes[i];
            if (!aType.equals(ofType)) continue;
            return true;
        }
        return false;
    }

    public AnnotationX[] getAnnotations() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotations;
    }

    public ResolvedTypeX[] getAnnotationTypes() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotationTypes;
    }

    public void addAnnotation(AnnotationX annotation) {
        this.ensureAnnotationTypesRetrieved();
        int len = this.annotations.length;
        AnnotationX[] ret = new AnnotationX[len + 1];
        System.arraycopy(this.annotations, 0, ret, 0, len);
        ret[len] = annotation;
        this.annotations = ret;
        len = this.annotationTypes.length;
        ResolvedTypeX[] ret2 = new ResolvedTypeX[len + 1];
        System.arraycopy(this.annotationTypes, 0, ret2, 0, len);
        ret2[len] = this.world.resolve(TypeX.forName(annotation.getTypeName()));
        this.annotationTypes = ret2;
        this.method.addAnnotation(annotation.getBcelAnnotation());
    }

    private void ensureAnnotationTypesRetrieved() {
        if (this.annotationTypes == null || this.method.getAnnotations().length != this.annotations.length) {
            Annotation[] annos = this.method.getAnnotations();
            this.annotationTypes = new ResolvedTypeX[annos.length];
            this.annotations = new AnnotationX[annos.length];
            for (int i = 0; i < annos.length; ++i) {
                ResolvedTypeX rtx;
                Annotation annotation = annos[i];
                this.annotationTypes[i] = rtx = this.world.resolve(TypeX.forName(annotation.getTypeName()));
                this.annotations[i] = new AnnotationX(annotation, this.world);
            }
        }
    }
}

