/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment environment) {
        super(environment);
    }

    boolean areMethodsEqual(MethodBinding one, MethodBinding substituteTwo) {
        TypeBinding[] oneParams = one.parameters;
        TypeBinding[] twoParams = substituteTwo.parameters;
        boolean checkParameters = false;
        if (oneParams != twoParams) {
            int length = oneParams.length;
            if (length != twoParams.length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (oneParams[i] != twoParams[i]) {
                    checkParameters |= oneParams[i].leafComponentType().isParameterizedType();
                    if (!this.areTypesEqual(oneParams[i], twoParams[i])) {
                        while (!checkParameters && ++i < length) {
                            checkParameters |= oneParams[i].leafComponentType().isParameterizedType();
                        }
                        if (one.areParameterErasuresEqual(substituteTwo)) {
                            this.detectNameClash(one, substituteTwo, checkParameters);
                        }
                        return false;
                    }
                }
                ++i;
            }
        }
        return !this.detectNameClash(one, substituteTwo, checkParameters);
    }

    boolean areReturnTypesEqual(MethodBinding one, MethodBinding substituteTwo) {
        if (one.returnType == substituteTwo.returnType) {
            return true;
        }
        if (one.declaringClass.isClass() || one.declaringClass.implementsInterface(substituteTwo.declaringClass, true)) {
            return one.returnType.isCompatibleWith(substituteTwo.returnType);
        }
        if (substituteTwo.declaringClass.implementsInterface(one.declaringClass, true)) {
            return substituteTwo.returnType.isCompatibleWith(one.returnType);
        }
        return one.returnType.isCompatibleWith(substituteTwo.returnType) || substituteTwo.returnType.isCompatibleWith(one.returnType);
    }

    boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        switch (one.kind()) {
            case 132: 
            case 516: {
                return one.isEquivalentTo(two);
            }
        }
        return false;
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == TypeConstants.NoSuperInterfaces;
    }

    boolean canSkipInheritedMethods(MethodBinding one, MethodBinding two) {
        return two == null || one.declaringClass == two.declaringClass && !one.declaringClass.isParameterizedType();
    }

    void checkForBridgeMethod(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        MethodBinding[] toCheck;
        MethodBinding originalInherited = inheritedMethod.original();
        if (inheritedMethod != originalInherited && (toCheck = (MethodBinding[])this.currentMethods.get(currentMethod.selector)).length > 1) {
            int i = 0;
            int length = toCheck.length;
            while (i < length) {
                if (currentMethod != toCheck[i] && toCheck[i].areParameterErasuresEqual(originalInherited)) {
                    this.problemReporter(toCheck[i]).methodNameClash(toCheck[i], originalInherited);
                    return;
                }
                ++i;
            }
        }
        if (originalInherited.returnType != currentMethod.returnType) {
            TypeBinding originalReturnType = originalInherited.returnType.leafComponentType();
            switch (originalReturnType.kind()) {
                case 1028: {
                    if (originalReturnType != originalInherited.declaringClass || !inheritedMethod.returnType.leafComponentType().isParameterizedType()) break;
                }
                case 132: {
                    if (currentMethod.returnType.leafComponentType().isParameterizedType() || currentMethod.returnType.leafComponentType().isRawType() && inheritedMethod.returnType.leafComponentType().isRawType()) break;
                    this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, originalInherited, ((MethodDeclaration)currentMethod.sourceMethod()).returnType);
                    break;
                }
                case 2052: {
                    TypeBinding returnType;
                    if (((TypeVariableBinding)originalReturnType).declaringElement != originalInherited || (returnType = currentMethod.returnType.leafComponentType()).isTypeVariable() && ((TypeVariableBinding)returnType).declaringElement == currentMethod) break;
                    this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, originalInherited, ((MethodDeclaration)currentMethod.sourceMethod()).returnType);
                }
            }
        }
        this.type.addSyntheticBridgeMethod(originalInherited, currentMethod);
    }

    void checkInheritedMethods(MethodBinding[] methods, int length) {
        int count = length;
        int i = 0;
        int l = length - 1;
        block0: while (i < l) {
            MethodBinding method = methods[i++];
            int j = i;
            while (j <= l) {
                if (method.declaringClass == methods[j].declaringClass && this.doesMethodOverride(method, methods[j])) {
                    this.problemReporter().duplicateInheritedMethods(this.type, method, methods[j]);
                    --count;
                    methods[i - 1] = null;
                    continue block0;
                }
                ++j;
            }
        }
        if (count < length) {
            if (count == 1) {
                return;
            }
            MethodBinding[] newMethods = new MethodBinding[count];
            int i2 = length;
            while (--i2 >= 0) {
                if (methods[i2] == null) continue;
                newMethods[--count] = methods[i2];
            }
            methods = newMethods;
            length = newMethods.length;
        }
        super.checkInheritedMethods(methods, length);
    }

    MethodBinding computeSubstituteMethod(MethodBinding inheritedMethod, MethodBinding currentMethod) {
        TypeVariableBinding[] inheritedTypeVariables;
        if (inheritedMethod == null) {
            return null;
        }
        if (currentMethod.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)currentMethod.declaringClass).resolveTypesFor(currentMethod);
        }
        if (inheritedMethod.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)inheritedMethod.declaringClass).resolveTypesFor(inheritedMethod);
        }
        if ((inheritedTypeVariables = inheritedMethod.typeVariables()) == TypeConstants.NoTypeVariables) {
            return inheritedMethod;
        }
        TypeVariableBinding[] typeVariables = currentMethod == null ? TypeConstants.NoTypeVariables : currentMethod.typeVariables;
        int inheritedLength = inheritedTypeVariables.length;
        int length = typeVariables.length;
        TypeBinding[] arguments = new TypeBinding[inheritedLength];
        if (inheritedLength <= length) {
            System.arraycopy(typeVariables, 0, arguments, 0, inheritedLength);
        } else {
            System.arraycopy(typeVariables, 0, arguments, 0, length);
            int i = length;
            while (i < inheritedLength) {
                arguments[i] = inheritedTypeVariables[i].erasure();
                ++i;
            }
        }
        ParameterizedGenericMethodBinding substitute = new ParameterizedGenericMethodBinding(inheritedMethod, arguments, this.environment);
        int i = 0;
        while (i < inheritedLength) {
            if (!inheritedTypeVariables[i].boundCheck(substitute, arguments[i])) {
                return inheritedMethod;
            }
            ++i;
        }
        return substitute;
    }

    boolean detectNameClash(MethodBinding one, MethodBinding substituteTwo, boolean checkParameters) {
        if (this.doTypeVariablesClash(one, substituteTwo) || checkParameters && this.doParametersClash(one, substituteTwo)) {
            if (this.type == one.declaringClass) {
                this.problemReporter(one).methodNameClash(one, substituteTwo);
            } else {
                this.problemReporter().inheritedMethodsHaveNameClash(this.type, one, substituteTwo);
            }
            return true;
        }
        return false;
    }

    public boolean doesMethodOverride(MethodBinding method, MethodBinding inheritedMethod) {
        return super.doesMethodOverride(method, this.computeSubstituteMethod(inheritedMethod, method));
    }

    boolean doParametersClash(MethodBinding one, MethodBinding substituteTwo) {
        TypeBinding[] oneParams = one.parameters;
        TypeBinding[] twoParams = substituteTwo.parameters;
        int i = 0;
        int l = oneParams.length;
        while (i < l) {
            if (!(oneParams[i] == twoParams[i] || !oneParams[i].leafComponentType().isParameterizedType() || twoParams[i].leafComponentType().isParameterizedType() && oneParams[i].isEquivalentTo(twoParams[i]) && twoParams[i].isEquivalentTo(oneParams[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean doTypeVariablesClash(MethodBinding one, MethodBinding substituteTwo) {
        TypeVariableBinding[] currentVars = one.typeVariables;
        TypeVariableBinding[] inheritedVars = substituteTwo.original().typeVariables;
        return currentVars.length != inheritedVars.length && currentVars.length > 0;
    }

    boolean isInterfaceMethodImplemented(MethodBinding inheritedMethod, MethodBinding existingMethod, ReferenceBinding superType) {
        inheritedMethod = this.computeSubstituteMethod(inheritedMethod, existingMethod);
        return inheritedMethod.returnType == existingMethod.returnType && super.isInterfaceMethodImplemented(inheritedMethod, existingMethod, superType);
    }
}

