/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ObjectCache;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ExceptionHandlingFlowContext
extends FlowContext {
    public ReferenceBinding[] handledExceptions;
    public static final int BitCacheSize = 32;
    int[] isReached;
    int[] isNeeded;
    UnconditionalFlowInfo[] initsOnExceptions;
    ObjectCache indexes = new ObjectCache();
    boolean isMethodContext;
    public UnconditionalFlowInfo initsOnReturn;
    public ArrayList extendedExceptions;

    public ExceptionHandlingFlowContext(FlowContext parent, ASTNode associatedNode, ReferenceBinding[] handledExceptions, BlockScope scope, UnconditionalFlowInfo flowInfo) {
        super(parent, associatedNode);
        this.isMethodContext = scope == scope.methodScope();
        this.handledExceptions = handledExceptions;
        int count = handledExceptions.length;
        int cacheSize = count / 32 + 1;
        this.isReached = new int[cacheSize];
        this.isNeeded = new int[cacheSize];
        this.initsOnExceptions = new UnconditionalFlowInfo[count];
        int i = 0;
        while (i < count) {
            this.indexes.put(handledExceptions[i], i);
            boolean isUnchecked = scope.compareUncheckedException(handledExceptions[i]) != 0;
            int cacheIndex = i / 32;
            int bitMask = 1 << i % 32;
            if (isUnchecked) {
                int n = cacheIndex;
                this.isReached[n] = this.isReached[n] | bitMask;
                this.initsOnExceptions[i] = flowInfo.copy().unconditionalInits();
            } else {
                this.initsOnExceptions[i] = FlowInfo.DEAD_END;
            }
            ++i;
        }
        System.arraycopy(this.isReached, 0, this.isNeeded, 0, cacheSize);
        this.initsOnReturn = FlowInfo.DEAD_END;
    }

    public void complainIfUnusedExceptionHandlers(AbstractMethodDeclaration method) {
        MethodScope scope = method.scope;
        if ((method.binding.modifiers & 0x30000000) != 0 && !scope.environment().options.reportUnusedDeclaredThrownExceptionWhenOverriding) {
            return;
        }
        int i = 0;
        int count = this.handledExceptions.length;
        while (i < count) {
            int bitMask;
            int index = this.indexes.get(this.handledExceptions[i]);
            int cacheIndex = index / 32;
            if ((this.isReached[cacheIndex] & (bitMask = 1 << index % 32)) == 0) {
                scope.problemReporter().unusedDeclaredThrownException(this.handledExceptions[index], method, method.thrownExceptions[index]);
            }
            ++i;
        }
    }

    public void complainIfUnusedExceptionHandlers(BlockScope scope, TryStatement tryStatement) {
        int i = 0;
        int count = this.handledExceptions.length;
        while (i < count) {
            int bitMask;
            int index = this.indexes.get(this.handledExceptions[i]);
            int cacheIndex = index / 32;
            if ((this.isReached[cacheIndex] & (bitMask = 1 << index % 32)) == 0) {
                scope.problemReporter().unreachableCatchBlock(this.handledExceptions[index], tryStatement.catchArguments[index].type);
            } else if ((this.isNeeded[cacheIndex] & bitMask) == 0) {
                scope.problemReporter().hiddenCatchBlock(this.handledExceptions[index], tryStatement.catchArguments[index].type);
            }
            ++i;
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Exception flow context");
        int length = this.handledExceptions.length;
        int i = 0;
        while (i < length) {
            int cacheIndex = i / 32;
            int bitMask = 1 << i % 32;
            buffer.append('[').append(this.handledExceptions[i].readableName());
            if ((this.isReached[cacheIndex] & bitMask) != 0) {
                if ((this.isNeeded[cacheIndex] & bitMask) == 0) {
                    buffer.append("-masked");
                } else {
                    buffer.append("-reached");
                }
            } else {
                buffer.append("-not reached");
            }
            buffer.append('-').append(this.initsOnExceptions[i].toString()).append(']');
            ++i;
        }
        buffer.append("[initsOnReturn -").append(this.initsOnReturn.toString()).append(']');
        return buffer.toString();
    }

    public UnconditionalFlowInfo initsOnException(ReferenceBinding exceptionType) {
        int index = this.indexes.get(exceptionType);
        if (index < 0) {
            return FlowInfo.DEAD_END;
        }
        return this.initsOnExceptions[index];
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return this.initsOnReturn;
    }

    public void recordHandlingException(ReferenceBinding exceptionType, UnconditionalFlowInfo flowInfo, TypeBinding raisedException, ASTNode invocationSite, boolean wasAlreadyDefinitelyCaught) {
        int index = this.indexes.get(exceptionType);
        int cacheIndex = index / 32;
        int bitMask = 1 << index % 32;
        if (!wasAlreadyDefinitelyCaught) {
            int n = cacheIndex;
            this.isNeeded[n] = this.isNeeded[n] | bitMask;
        }
        int n = cacheIndex;
        this.isReached[n] = this.isReached[n] | bitMask;
        this.initsOnExceptions[index] = this.initsOnExceptions[index] == FlowInfo.DEAD_END ? flowInfo.copy().unconditionalInits() : this.initsOnExceptions[index].mergedWith(flowInfo.copy().unconditionalInits());
    }

    public void recordReturnFrom(FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.initsOnReturn = this.initsOnReturn == FlowInfo.DEAD_END ? flowInfo.copy().unconditionalInits() : this.initsOnReturn.mergedWith(flowInfo.copy().unconditionalInits());
    }

    public void mergeUnhandledException(TypeBinding newException) {
        if (this.extendedExceptions == null) {
            this.extendedExceptions = new ArrayList(5);
            int i = 0;
            while (i < this.handledExceptions.length) {
                this.extendedExceptions.add(this.handledExceptions[i]);
                ++i;
            }
        }
        boolean isRedundant = false;
        int i = this.extendedExceptions.size() - 1;
        while (i >= 0) {
            switch (Scope.compareTypes(newException, (TypeBinding)this.extendedExceptions.get(i))) {
                case 1: {
                    this.extendedExceptions.remove(i);
                    break;
                }
                case -1: {
                    isRedundant = true;
                    break;
                }
            }
            --i;
        }
        if (!isRedundant) {
            this.extendedExceptions.add(newException);
        }
    }
}

