/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CastExpression
extends Expression {
    public Expression expression;
    public Expression type;
    public TypeBinding expectedType;

    public CastExpression(Expression expression, Expression type) {
        this.expression = expression;
        this.type = type;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
    }

    public static void checkNeedForEnclosingInstanceCast(BlockScope scope, Expression enclosingInstance, TypeBinding enclosingInstanceType, TypeBinding memberType) {
        if (scope.environment().options.getSeverity(0x4000000L) == -1) {
            return;
        }
        TypeBinding castedExpressionType = ((CastExpression)enclosingInstance).expression.resolvedType;
        if (castedExpressionType == null) {
            return;
        }
        if (castedExpressionType == enclosingInstanceType) {
            scope.problemReporter().unnecessaryCast((CastExpression)enclosingInstance);
        } else {
            if (castedExpressionType == BaseTypes.NullBinding) {
                return;
            }
            TypeBinding alternateEnclosingInstanceType = castedExpressionType;
            if (castedExpressionType.isBaseType() || castedExpressionType.isArrayType()) {
                return;
            }
            if (memberType == scope.getMemberType(memberType.sourceName(), (ReferenceBinding)alternateEnclosingInstanceType)) {
                scope.problemReporter().unnecessaryCast((CastExpression)enclosingInstance);
            }
        }
    }

    public static void checkNeedForArgumentCast(BlockScope scope, int operator, int operatorSignature, Expression expression, int expressionTypeId) {
        if (scope.environment().options.getSeverity(0x4000000L) == -1) {
            return;
        }
        int alternateLeftTypeId = expressionTypeId;
        if ((expression.bits & 0x4000) == 0 && expression.resolvedType.isBaseType()) {
            return;
        }
        TypeBinding alternateLeftType = ((CastExpression)expression).expression.resolvedType;
        if (alternateLeftType == null) {
            return;
        }
        alternateLeftTypeId = alternateLeftType.id;
        if (alternateLeftTypeId == expressionTypeId) {
            scope.problemReporter().unnecessaryCast((CastExpression)expression);
            return;
        }
        if (alternateLeftTypeId == 12) {
            alternateLeftTypeId = expressionTypeId;
            return;
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope scope, Expression receiver, TypeBinding receiverType, MethodBinding binding, Expression[] arguments, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        if (scope.environment().options.getSeverity(0x4000000L) == -1) {
            return;
        }
        int length = argumentTypes.length;
        TypeBinding[] rawArgumentTypes = argumentTypes;
        int i = 0;
        while (i < length) {
            Expression argument = arguments[i];
            if (argument instanceof CastExpression && ((argument.bits & 0x4000) != 0 || !argument.resolvedType.isBaseType())) {
                TypeBinding castedExpressionType = ((CastExpression)argument).expression.resolvedType;
                if (castedExpressionType == null) {
                    return;
                }
                if (castedExpressionType == argumentTypes[i]) {
                    scope.problemReporter().unnecessaryCast((CastExpression)argument);
                } else if (castedExpressionType != BaseTypes.NullBinding) {
                    if (rawArgumentTypes == argumentTypes) {
                        TypeBinding[] typeBindingArray = rawArgumentTypes;
                        rawArgumentTypes = new TypeBinding[length];
                        System.arraycopy(typeBindingArray, 0, rawArgumentTypes, 0, length);
                    }
                    rawArgumentTypes[i] = castedExpressionType;
                }
            }
            ++i;
        }
        if (rawArgumentTypes != argumentTypes) {
            CastExpression.checkAlternateBinding(scope, receiver, receiverType, binding, arguments, argumentTypes, rawArgumentTypes, invocationSite);
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope scope, int operator, int operatorSignature, Expression left, int leftTypeId, boolean leftIsCast, Expression right, int rightTypeId, boolean rightIsCast) {
        if (scope.environment().options.getSeverity(0x4000000L) == -1) {
            return;
        }
        int alternateLeftTypeId = leftTypeId;
        if (leftIsCast) {
            if ((left.bits & 0x4000) == 0 && left.resolvedType.isBaseType()) {
                leftIsCast = false;
            } else {
                TypeBinding alternateLeftType = ((CastExpression)left).expression.resolvedType;
                if (alternateLeftType == null) {
                    return;
                }
                alternateLeftTypeId = alternateLeftType.id;
                if (alternateLeftTypeId == leftTypeId) {
                    scope.problemReporter().unnecessaryCast((CastExpression)left);
                    leftIsCast = false;
                } else if (alternateLeftTypeId == 12) {
                    alternateLeftTypeId = leftTypeId;
                    leftIsCast = false;
                }
            }
        }
        int alternateRightTypeId = rightTypeId;
        if (rightIsCast) {
            if ((right.bits & 0x4000) == 0 && right.resolvedType.isBaseType()) {
                rightIsCast = false;
            } else {
                TypeBinding alternateRightType = ((CastExpression)right).expression.resolvedType;
                if (alternateRightType == null) {
                    return;
                }
                alternateRightTypeId = alternateRightType.id;
                if (alternateRightTypeId == rightTypeId) {
                    scope.problemReporter().unnecessaryCast((CastExpression)right);
                    rightIsCast = false;
                } else if (alternateRightTypeId == 12) {
                    alternateRightTypeId = rightTypeId;
                    rightIsCast = false;
                }
            }
        }
        if (leftIsCast || rightIsCast) {
            if (alternateLeftTypeId > 15 || alternateRightTypeId > 15) {
                if (alternateLeftTypeId == 11) {
                    alternateRightTypeId = 1;
                } else if (alternateRightTypeId == 11) {
                    alternateLeftTypeId = 1;
                } else {
                    return;
                }
            }
            int alternateOperatorSignature = OperatorExpression.OperatorSignatures[operator][(alternateLeftTypeId << 4) + alternateRightTypeId];
            int CompareMASK = 986895;
            if ((operatorSignature & 0xF0F0F) == (alternateOperatorSignature & 0xF0F0F)) {
                if (leftIsCast) {
                    scope.problemReporter().unnecessaryCastForArgument((CastExpression)left, TypeBinding.wellKnownType(scope, (left.implicitConversion & 0xFF) >> 4));
                }
                if (rightIsCast) {
                    scope.problemReporter().unnecessaryCastForArgument((CastExpression)right, TypeBinding.wellKnownType(scope, (right.implicitConversion & 0xFF) >> 4));
                }
            }
        }
    }

    private static void checkAlternateBinding(BlockScope scope, Expression receiver, TypeBinding receiverType, MethodBinding binding, Expression[] arguments, TypeBinding[] originalArgumentTypes, TypeBinding[] alternateArgumentTypes, final InvocationSite invocationSite) {
        MethodBinding bindingIfNoCast;
        InvocationSite fakeInvocationSite = new InvocationSite(){

            public TypeBinding[] genericTypeArguments() {
                return null;
            }

            public boolean isSuperAccess() {
                return invocationSite.isSuperAccess();
            }

            public boolean isTypeAccess() {
                return invocationSite.isTypeAccess();
            }

            public void setActualReceiverType(ReferenceBinding actualReceiverType) {
            }

            public void setDepth(int depth) {
            }

            public void setFieldIndex(int depth) {
            }

            public int sourceStart() {
                return 0;
            }

            public int sourceEnd() {
                return 0;
            }
        };
        if (binding.isConstructor()) {
            bindingIfNoCast = scope.getConstructor((ReferenceBinding)receiverType, alternateArgumentTypes, fakeInvocationSite);
        } else {
            MethodBinding methodBinding = bindingIfNoCast = receiver.isImplicitThis() ? scope.getImplicitMethod(binding.selector, alternateArgumentTypes, fakeInvocationSite) : scope.getMethod(receiverType, binding.selector, alternateArgumentTypes, fakeInvocationSite);
        }
        if (bindingIfNoCast == binding) {
            int i = 0;
            int length = originalArgumentTypes.length;
            while (i < length) {
                if (originalArgumentTypes[i] != alternateArgumentTypes[i]) {
                    scope.problemReporter().unnecessaryCastForArgument((CastExpression)arguments[i], binding.parameters[i]);
                }
                ++i;
            }
        }
    }

    public boolean checkUnsafeCast(Scope scope, TypeBinding castType, TypeBinding expressionType, TypeBinding match, boolean isNarrowing) {
        if (match == castType) {
            if (!isNarrowing && castType == this.resolvedType.leafComponentType()) {
                this.tagAsUnnecessaryCast(scope, castType);
            }
            return true;
        }
        if (castType.isBoundParameterizedType() || castType.isGenericType()) {
            if (match.isProvablyDistinctFrom(isNarrowing ? expressionType : castType, 0)) {
                this.reportIllegalCast(scope, castType, expressionType);
                return false;
            }
            if (isNarrowing ? !expressionType.isEquivalentTo(match) : !match.isEquivalentTo(castType)) {
                scope.problemReporter().unsafeCast(this, scope);
                return true;
            }
            if ((castType.tagBits & 0x40000000L) == 0L && (!match.isParameterizedType() && !match.isGenericType() || expressionType.isRawType())) {
                scope.problemReporter().unsafeCast(this, scope);
                return true;
            }
        } else if (isNarrowing && castType.isTypeVariable()) {
            scope.problemReporter().unsafeCast(this, scope);
            return true;
        }
        if (!isNarrowing && castType == this.resolvedType.leafComponentType()) {
            this.tagAsUnnecessaryCast(scope, castType);
        }
        return true;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        boolean needRuntimeCheckcast;
        int pc = codeStream.position;
        boolean bl = needRuntimeCheckcast = (this.bits & 0x40) != 0;
        if (this.constant != ASTNode.NotAConstant) {
            if (valueRequired || needRuntimeCheckcast) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                if (needRuntimeCheckcast) {
                    codeStream.checkcast(this.resolvedType);
                    if (valueRequired) {
                        codeStream.generateImplicitConversion(this.implicitConversion);
                    } else {
                        codeStream.pop();
                    }
                }
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        this.expression.generateCode(currentScope, codeStream, valueRequired || needRuntimeCheckcast);
        if (needRuntimeCheckcast) {
            codeStream.checkcast(this.resolvedType);
            if (valueRequired) {
                codeStream.generateImplicitConversion(this.implicitConversion);
            } else {
                codeStream.pop();
            }
        } else if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public Expression innermostCastedExpression() {
        Expression current = this.expression;
        while (current instanceof CastExpression) {
            current = ((CastExpression)current).expression;
        }
        return current;
    }

    public LocalVariableBinding localVariableBinding() {
        return this.expression.localVariableBinding();
    }

    public int nullStatus(FlowInfo flowInfo) {
        return this.expression.nullStatus(flowInfo);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('(');
        this.type.print(0, output).append(") ");
        return this.expression.printExpression(0, output);
    }

    public void reportIllegalCast(Scope scope, TypeBinding castType, TypeBinding expressionType) {
        scope.problemReporter().typeCastError(this, castType, expressionType);
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        this.implicitConversion = 0;
        if (this.type instanceof TypeReference || this.type instanceof NameReference && (this.type.bits & 0x1FE00000) >> 21 == 0) {
            this.resolvedType = this.type.resolveType(scope);
            this.expression.setExpectedType(this.resolvedType);
            TypeBinding expressionType = this.expression.resolveType(scope);
            if (this.resolvedType != null && expressionType != null) {
                this.checkCastTypesCompatibility(scope, this.resolvedType, expressionType, this.expression);
                this.expression.computeConversion(scope, this.resolvedType, expressionType);
                if ((this.bits & 0x4000) != 0 && (this.bits & 0x20) == 0 && !this.usedForGenericMethodReturnTypeInference()) {
                    scope.problemReporter().unnecessaryCast(this);
                }
            }
            return this.resolvedType;
        }
        TypeBinding expressionType = this.expression.resolveType(scope);
        if (expressionType == null) {
            return null;
        }
        scope.problemReporter().invalidTypeReference(this.type);
        return null;
    }

    public void setExpectedType(TypeBinding expectedType) {
        this.expectedType = expectedType;
    }

    private boolean usedForGenericMethodReturnTypeInference() {
        MethodBinding method;
        if (this.expression instanceof MessageSend && (method = ((MessageSend)this.expression).binding) instanceof ParameterizedGenericMethodBinding && ((ParameterizedGenericMethodBinding)method).inferredReturnType) {
            if (this.expectedType == null) {
                return true;
            }
            if (this.resolvedType != this.expectedType) {
                return true;
            }
        }
        return false;
    }

    public void tagAsNeedCheckCast() {
        this.bits |= 0x40;
    }

    public void tagAsUnnecessaryCast(Scope scope, TypeBinding castType) {
        if (this.expression.resolvedType == null) {
            return;
        }
        this.bits |= 0x4000;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.type.traverse(visitor, blockScope);
            this.expression.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

