/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RefreshJob
extends WorkspaceJob {
    private static final long UPDATE_DELAY = 200L;
    private final List fRequests = new ArrayList(1);

    public RefreshJob() {
        super(Messages.refresh_jobName);
    }

    private synchronized void addRequest(IResource resource) {
        IPath toAdd = resource.getFullPath();
        Iterator it = this.fRequests.iterator();
        while (it.hasNext()) {
            IPath request = ((IResource)it.next()).getFullPath();
            if (toAdd.isPrefixOf(request)) {
                it.remove();
                continue;
            }
            if (!request.isPrefixOf(toAdd)) continue;
            return;
        }
        this.fRequests.add(resource);
    }

    private synchronized void addRequests(List list) {
        this.fRequests.addAll(0, list);
    }

    public boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_AUTO_REFRESH;
    }

    private List collectChildrenToDepth(IResource resource, ArrayList children, int depth) throws CoreException {
        if (resource.getType() == 1) {
            return children;
        }
        IResource[] members = ((IContainer)resource).members();
        int i = 0;
        while (i < members.length) {
            if (members[i].getType() != 1) {
                if (depth <= 1) {
                    children.add(members[i]);
                } else {
                    this.collectChildrenToDepth(members[i], children, depth - 1);
                }
            }
            ++i;
        }
        return children;
    }

    private synchronized IResource nextRequest() {
        int len = this.fRequests.size();
        if (len == 0) {
            return null;
        }
        return (IResource)this.fRequests.remove(len - 1);
    }

    public void refresh(IResource resource) {
        if (resource == null) {
            return;
        }
        this.addRequest(resource);
        this.schedule(200L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) {
        MultiStatus errors;
        block15: {
            long start = System.currentTimeMillis();
            String msg = Messages.refresh_refreshErr;
            errors = new MultiStatus("org.eclipse.core.resources", 1, msg, null);
            long longestRefresh = 0L;
            try {
                IResource toRefresh;
                if (RefreshManager.DEBUG) {
                    Policy.debug("Auto-refresh:  starting refresh job");
                }
                int refreshCount = 0;
                int depth = 2;
                monitor.beginTask("", -1);
                while ((toRefresh = this.nextRequest()) != null) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        ++refreshCount;
                        long refreshTime = -System.currentTimeMillis();
                        toRefresh.refreshLocal(1000 + depth, null);
                        if ((refreshTime += System.currentTimeMillis()) > longestRefresh) {
                            longestRefresh = refreshTime;
                        }
                        if (refreshCount % 100 == 0) {
                            monitor.subTask(NLS.bind((String)Messages.refresh_task, (Object)Integer.toString(this.fRequests.size())));
                        }
                        if (refreshCount % 1000 == 0) {
                            Thread.yield();
                            if (longestRefresh > 2000L && depth > 1) {
                                depth = 1;
                            }
                            if (longestRefresh < 1000L) {
                                depth *= 2;
                            }
                            longestRefresh = 0L;
                        }
                        this.addRequests(this.collectChildrenToDepth(toRefresh, new ArrayList(), depth));
                    }
                    catch (CoreException e) {
                        errors.merge(e.getStatus());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                monitor.done();
                if (RefreshManager.DEBUG) {
                    System.out.println("Auto-refresh:  finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
                }
                throw throwable;
            }
            {
                Object var13_13 = null;
                monitor.done();
                if (!RefreshManager.DEBUG) break block15;
                System.out.println("Auto-refresh:  finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        if (!errors.isOK()) {
            return errors;
        }
        return Status.OK_STATUS;
    }

    public synchronized boolean shouldRun() {
        return !this.fRequests.isEmpty();
    }

    public void start() {
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  enabling auto-refresh");
        }
    }

    public void stop() {
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  disabling auto-refresh");
        }
        this.cancel();
    }
}

