/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IField;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatus;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.aspectj.org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.aspectj.org.eclipse.jdt.internal.core.CreateTypeMemberOperation;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jface.text.IDocument;

public class CreateFieldOperation
extends CreateTypeMemberOperation {
    public CreateFieldOperation(IType parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, ICompilationUnit cu) throws JavaModelException {
        ASTNode node = super.generateElementAST(rewriter, document, cu);
        if (node.getNodeType() != 23) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return node;
    }

    protected IJavaElement generateResultHandle() {
        return this.getType().getField(this.getASTNodeName());
    }

    public String getMainTaskName() {
        return Messages.operation_createFieldProgress;
    }

    protected void initializeDefaultPosition() {
        IType parentElement = this.getType();
        try {
            IField[] fields = parentElement.getFields();
            if (fields != null && fields.length > 0) {
                IField lastField = fields[fields.length - 1];
                if (parentElement.isEnum()) {
                    IField field = lastField;
                    if (!field.isEnumConstant()) {
                        this.createAfter(lastField);
                    }
                } else {
                    this.createAfter(lastField);
                }
            } else {
                IJavaElement[] elements = parentElement.getChildren();
                if (elements != null && elements.length > 0) {
                    this.createBefore(elements[0]);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected IJavaModelStatus verifyNameCollision() {
        String fieldName;
        IType type;
        if (this.createdNode != null && (type = this.getType()).getField(fieldName = this.getASTNodeName()).exists()) {
            return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, fieldName));
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    private String getASTNodeName() {
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)((FieldDeclaration)this.createdNode).fragments().iterator().next();
        return fragment.getName().getIdentifier();
    }

    protected SimpleName rename(ASTNode node, SimpleName newName) {
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)((FieldDeclaration)node).fragments().iterator().next();
        SimpleName oldName = fragment.getName();
        fragment.setName(newName);
        return oldName;
    }
}

