# -.- coding: utf-8 -.-

# Zeitgeist
#
# Copyright © Collabora 2011
#                 Authored by Seif Lotfy <seif@lotfy.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 2.1 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, sys
import time
import dbus
import dbus.service
import logging

import gi
from gi.repository import Tracker

import gobject

from _zeitgeist.engine.extension import Extension
from _zeitgeist.engine import constants
from _zeitgeist.engine.sql import get_default_cursor
from zeitgeist.datamodel import Interpretation

logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger("zeitgeist.tracker")

INDEX_FILE = os.path.join(constants.DATA_PATH, "tracker.index")

class TrackerNotifier (Extension):
    """
    Notify Tracker to index
    """
    PUBLIC_METHODS = []

    def __init__ (self, engine):
        Extension.__init__(self, engine)
        self.conn = Tracker.SparqlConnection.get (None)
        self._engine = engine
        self.cursor = get_default_cursor()
        if not (os.path.exists(INDEX_FILE)):
            gobject.idle_add (self._reindex)

    def _reindex(self):
        log.info("Empty index detected. Doing full rebuild")

        for uri in self.cursor.execute("SELECT value FROM uri"):
            self.index(uri[0])
            f = open(INDEX_FILE,"w")
            timestamp = str(time.time())
            f.write(timestamp)
            f.close()

    def post_insert_event(self, event, sender):
        if event.interpretation in (Interpretation.MODIFY_EVENT, Interpretation.CREATE_EVENT):
            for subject in event.subjects:
                self.index(subject.uri, True)

    def index(self, uri, save=False):
        if uri.startswith("file://"):
            uri = uri.replace("%20", " ")
            if os.path.exists(uri[7:]):
                log.debug("Indexing %s"%uri)
                os.system("""tracker-control --index-file "%s" """ %uri)
                if save:
                    f = open(INDEX_FILE,"w")
                    timestamp = str(time.time())
                    f.write(timestamp)

