# -.- coding: utf-8 -.-

# Zeitgeist - Geolocation Extension
#
# Copyright © 2010 Markus Korn <thekorn@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import dbus
import dbus.service
import sys

from StringIO import StringIO

from _zeitgeist.engine.extension import Extension
from _zeitgeist.engine import constants
from _zeitgeist.singleton import SingletonApplication

from pympler.tracker import ClassTracker
from pympler.tracker.stats import ConsoleStats

DBUS_OBJECT_PATH = "/org/gnome/zeitgeist/memory_profiler"

class Stream(object):
    
    def __init__(self):
        self.data = StringIO()
        
    def write(self, data):
        sys.stdout.write(data)
        self.data.write(data)
        
    def dump(self):
        return self.data.getvalue()
        

class MemoryProfiler(Extension, dbus.service.Object):
    PUBLIC_METHODS = []
    
    def __init__(self, engine):
        Extension.__init__(self, engine)
        dbus.service.Object.__init__(self, dbus.SessionBus(), DBUS_OBJECT_PATH)
        self.tracker = ClassTracker()
        self.tracker.track_object(engine)
        self.tracker.track_object(engine._cursor)
        iface = getattr(engine, "_remote_iface", None)
        if iface is not None:
            self.tracker.track_object(iface)
        
    @dbus.service.method(constants.DBUS_INTERFACE, out_signature="s")
    def MakeSnapShot(self):
        self.tracker.create_snapshot()
        stream = Stream()
        ConsoleStats(stream=stream, tracker=self.tracker).print_summary()
        return stream.dump()
