#!/usr/bin/env python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2010-2011 Bryce Harrington bryce@canonical.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.

import DistUtilsExtra.auto
import glob

DistUtilsExtra.auto.setup(
    name         = 'xdiagnose',
    version      = '1.1',
    license      = 'GPL-3',
    author       = 'Bryce Harrington',
    author_email = 'bryce@ubuntu.com',
    description  = 'Tool for diagnosing various X tribulations',
    packages     = [
        'xdiagnose',
        ],
    data_files   = [
        ('share/xdiagnose/workloads',
         glob.glob('workloads/*')
         ),
        ('share/xdiagnose',
         glob.glob('failsafe*')
         ),
        ],
    scripts      = [
        'bin/dpkg-log-summary',
        'bin/xdiagnose',
        'bin/xrandr-tool',
        ],
    )
