/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace Xapian {

using System;
using System.Runtime.InteropServices;

class XapianPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [DllImport("_XapianSharp", EntryPoint="SWIGRegisterExceptionCallbacks_Xapian")]
    public static extern void SWIGRegisterExceptionCallbacks_Xapian(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [DllImport("_XapianSharp", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_Xapian")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_Xapian(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_Xapian(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_Xapian(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [ThreadStatic]
    private static Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(Exception e) {
      if (pendingException != null)
        throw new ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(XapianPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static Exception Retrieve() {
      Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(XapianPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [DllImport("_XapianSharp", EntryPoint="SWIGRegisterStringCallback_Xapian")]
    public static extern void SWIGRegisterStringCallback_Xapian(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_Xapian(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  [DllImport("_XapianSharp", EntryPoint="CSharp_Version_String")]
  public static extern string Version_String();

  [DllImport("_XapianSharp", EntryPoint="CSharp_Version_Major")]
  public static extern int Version_Major();

  [DllImport("_XapianSharp", EntryPoint="CSharp_Version_Minor")]
  public static extern int Version_Minor();

  [DllImport("_XapianSharp", EntryPoint="CSharp_Version_Revision")]
  public static extern int Version_Revision();

  [DllImport("_XapianSharp", EntryPoint="CSharp_BAD_VALUENO_get")]
  public static extern uint BAD_VALUENO_get();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_PositionIterator__SWIG_0")]
  public static extern IntPtr new_PositionIterator__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_PositionIterator__SWIG_1")]
  public static extern IntPtr new_PositionIterator__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_PositionIterator")]
  public static extern void delete_PositionIterator(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PositionIterator_GetTermPos")]
  public static extern uint PositionIterator_GetTermPos(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PositionIterator_Next")]
  public static extern IntPtr PositionIterator_Next(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PositionIterator_Equals")]
  public static extern bool PositionIterator_Equals(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PositionIterator_SkipTo")]
  public static extern void PositionIterator_SkipTo(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PositionIterator_GetDescription")]
  public static extern string PositionIterator_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_PostingIterator__SWIG_0")]
  public static extern IntPtr new_PostingIterator__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_PostingIterator")]
  public static extern void delete_PostingIterator(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_PostingIterator__SWIG_1")]
  public static extern IntPtr new_PostingIterator__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_SkipTo")]
  public static extern void PostingIterator_SkipTo(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_GetDocLength")]
  public static extern uint PostingIterator_GetDocLength(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_GetWdf")]
  public static extern uint PostingIterator_GetWdf(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_PositionListBegin")]
  public static extern IntPtr PostingIterator_PositionListBegin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_PositionListEnd")]
  public static extern IntPtr PostingIterator_PositionListEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_GetDescription")]
  public static extern string PostingIterator_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_GetDocId")]
  public static extern uint PostingIterator_GetDocId(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_Next")]
  public static extern IntPtr PostingIterator_Next(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingIterator_Equals")]
  public static extern bool PostingIterator_Equals(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_TermIterator__SWIG_0")]
  public static extern IntPtr new_TermIterator__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_TermIterator__SWIG_1")]
  public static extern IntPtr new_TermIterator__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_TermIterator")]
  public static extern void delete_TermIterator(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_GetTerm")]
  public static extern string TermIterator_GetTerm(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_Next")]
  public static extern IntPtr TermIterator_Next(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_Equals")]
  public static extern bool TermIterator_Equals(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_SkipTo")]
  public static extern void TermIterator_SkipTo(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_GetWdf")]
  public static extern uint TermIterator_GetWdf(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_GetTermFreq")]
  public static extern uint TermIterator_GetTermFreq(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_PositionListBegin")]
  public static extern IntPtr TermIterator_PositionListBegin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_PositionListEnd")]
  public static extern IntPtr TermIterator_PositionListEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermIterator_GetDescription")]
  public static extern string TermIterator_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValueIterator__SWIG_0")]
  public static extern IntPtr new_ValueIterator__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValueIterator__SWIG_1")]
  public static extern IntPtr new_ValueIterator__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ValueIterator")]
  public static extern void delete_ValueIterator(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueIterator_GetValue")]
  public static extern string ValueIterator_GetValue(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueIterator_Next")]
  public static extern IntPtr ValueIterator_Next(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueIterator_Equals")]
  public static extern bool ValueIterator_Equals(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueIterator_GetDocId")]
  public static extern uint ValueIterator_GetDocId(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueIterator_GetValueNo")]
  public static extern uint ValueIterator_GetValueNo(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueIterator_SkipTo")]
  public static extern void ValueIterator_SkipTo(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueIterator_Check")]
  public static extern bool ValueIterator_Check(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueIterator_GetDescription")]
  public static extern string ValueIterator_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Document__SWIG_0")]
  public static extern IntPtr new_Document__SWIG_0(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Document__SWIG_1")]
  public static extern IntPtr new_Document__SWIG_1();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Document")]
  public static extern void delete_Document(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_GetValue")]
  public static extern string Document_GetValue(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_AddValue")]
  public static extern void Document_AddValue(HandleRef jarg1, uint jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_RemoveValue")]
  public static extern void Document_RemoveValue(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_ClearValues")]
  public static extern void Document_ClearValues(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_GetData")]
  public static extern string Document_GetData(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_SetData")]
  public static extern void Document_SetData(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_AddPosting__SWIG_0")]
  public static extern void Document_AddPosting__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3, uint jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_AddPosting__SWIG_1")]
  public static extern void Document_AddPosting__SWIG_1(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_AddTerm__SWIG_0")]
  public static extern void Document_AddTerm__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_AddTerm__SWIG_1")]
  public static extern void Document_AddTerm__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_AddBooleanTerm")]
  public static extern void Document_AddBooleanTerm(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_RemovePosting__SWIG_0")]
  public static extern void Document_RemovePosting__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3, uint jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_RemovePosting__SWIG_1")]
  public static extern void Document_RemovePosting__SWIG_1(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_RemoveTerm")]
  public static extern void Document_RemoveTerm(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_ClearTerms")]
  public static extern void Document_ClearTerms(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_TermListCount")]
  public static extern uint Document_TermListCount(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_TermListBegin")]
  public static extern IntPtr Document_TermListBegin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_TermListEnd")]
  public static extern IntPtr Document_TermListEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_ValuesCount")]
  public static extern uint Document_ValuesCount(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_ValuesBegin")]
  public static extern IntPtr Document_ValuesBegin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_ValuesEnd")]
  public static extern IntPtr Document_ValuesEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_GetDocId")]
  public static extern uint Document_GetDocId(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_Serialise")]
  public static extern string Document_Serialise(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_Unserialise")]
  public static extern IntPtr Document_Unserialise(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Document_GetDescription")]
  public static extern string Document_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_PostingSource")]
  public static extern IntPtr new_PostingSource();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_PostingSource")]
  public static extern void delete_PostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetTermfreqMin")]
  public static extern uint PostingSource_GetTermfreqMin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetTermfreqEst")]
  public static extern uint PostingSource_GetTermfreqEst(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetTermfreqMax")]
  public static extern uint PostingSource_GetTermfreqMax(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetMaxweight")]
  public static extern double PostingSource_GetMaxweight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetWeight")]
  public static extern double PostingSource_GetWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetWeightSwigExplicitPostingSource")]
  public static extern double PostingSource_GetWeightSwigExplicitPostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetDocId")]
  public static extern uint PostingSource_GetDocId(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_Next")]
  public static extern void PostingSource_Next(HandleRef jarg1, double jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_SkipTo")]
  public static extern void PostingSource_SkipTo(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_SkipToSwigExplicitPostingSource")]
  public static extern void PostingSource_SkipToSwigExplicitPostingSource(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_Check")]
  public static extern bool PostingSource_Check(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_CheckSwigExplicitPostingSource")]
  public static extern bool PostingSource_CheckSwigExplicitPostingSource(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_AtEnd")]
  public static extern bool PostingSource_AtEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_Name")]
  public static extern string PostingSource_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_NameSwigExplicitPostingSource")]
  public static extern string PostingSource_NameSwigExplicitPostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_Init")]
  public static extern void PostingSource_Init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetDescription")]
  public static extern string PostingSource_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_GetDescriptionSwigExplicitPostingSource")]
  public static extern string PostingSource_GetDescriptionSwigExplicitPostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_PostingSource_director_connect")]
  public static extern void PostingSource_director_connect(HandleRef jarg1, PostingSource.SwigDelegatePostingSource_0 delegate0, PostingSource.SwigDelegatePostingSource_1 delegate1, PostingSource.SwigDelegatePostingSource_2 delegate2, PostingSource.SwigDelegatePostingSource_3 delegate3, PostingSource.SwigDelegatePostingSource_4 delegate4, PostingSource.SwigDelegatePostingSource_5 delegate5, PostingSource.SwigDelegatePostingSource_6 delegate6, PostingSource.SwigDelegatePostingSource_7 delegate7, PostingSource.SwigDelegatePostingSource_8 delegate8, PostingSource.SwigDelegatePostingSource_9 delegate9, PostingSource.SwigDelegatePostingSource_10 delegate10, PostingSource.SwigDelegatePostingSource_11 delegate11);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValuePostingSource")]
  public static extern IntPtr new_ValuePostingSource(uint jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_GetTermfreqMin")]
  public static extern uint ValuePostingSource_GetTermfreqMin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_GetTermfreqEst")]
  public static extern uint ValuePostingSource_GetTermfreqEst(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_GetTermfreqMax")]
  public static extern uint ValuePostingSource_GetTermfreqMax(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_Next")]
  public static extern void ValuePostingSource_Next(HandleRef jarg1, double jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_SkipTo")]
  public static extern void ValuePostingSource_SkipTo(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_Check")]
  public static extern bool ValuePostingSource_Check(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_AtEnd")]
  public static extern bool ValuePostingSource_AtEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_GetDocId")]
  public static extern uint ValuePostingSource_GetDocId(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSource_Init")]
  public static extern void ValuePostingSource_Init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ValuePostingSource")]
  public static extern void delete_ValuePostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValueWeightPostingSource")]
  public static extern IntPtr new_ValueWeightPostingSource(uint jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueWeightPostingSource_GetWeight")]
  public static extern double ValueWeightPostingSource_GetWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueWeightPostingSource_Name")]
  public static extern string ValueWeightPostingSource_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueWeightPostingSource_Init")]
  public static extern void ValueWeightPostingSource_Init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueWeightPostingSource_GetDescription")]
  public static extern string ValueWeightPostingSource_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ValueWeightPostingSource")]
  public static extern void delete_ValueWeightPostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DecreasingValueWeightPostingSource__SWIG_0")]
  public static extern IntPtr new_DecreasingValueWeightPostingSource__SWIG_0(uint jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DecreasingValueWeightPostingSource__SWIG_1")]
  public static extern IntPtr new_DecreasingValueWeightPostingSource__SWIG_1(uint jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DecreasingValueWeightPostingSource__SWIG_2")]
  public static extern IntPtr new_DecreasingValueWeightPostingSource__SWIG_2(uint jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DecreasingValueWeightPostingSource_GetWeight")]
  public static extern double DecreasingValueWeightPostingSource_GetWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DecreasingValueWeightPostingSource_Name")]
  public static extern string DecreasingValueWeightPostingSource_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DecreasingValueWeightPostingSource_Init")]
  public static extern void DecreasingValueWeightPostingSource_Init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DecreasingValueWeightPostingSource_Next")]
  public static extern void DecreasingValueWeightPostingSource_Next(HandleRef jarg1, double jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DecreasingValueWeightPostingSource_SkipTo")]
  public static extern void DecreasingValueWeightPostingSource_SkipTo(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DecreasingValueWeightPostingSource_Check")]
  public static extern bool DecreasingValueWeightPostingSource_Check(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DecreasingValueWeightPostingSource_GetDescription")]
  public static extern string DecreasingValueWeightPostingSource_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_DecreasingValueWeightPostingSource")]
  public static extern void delete_DecreasingValueWeightPostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValueMapPostingSource")]
  public static extern IntPtr new_ValueMapPostingSource(uint jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueMapPostingSource_AddMapping")]
  public static extern void ValueMapPostingSource_AddMapping(HandleRef jarg1, string jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueMapPostingSource_ClearMappings")]
  public static extern void ValueMapPostingSource_ClearMappings(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueMapPostingSource_SetDefaultWeight")]
  public static extern void ValueMapPostingSource_SetDefaultWeight(HandleRef jarg1, double jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueMapPostingSource_GetWeight")]
  public static extern double ValueMapPostingSource_GetWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueMapPostingSource_Name")]
  public static extern string ValueMapPostingSource_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueMapPostingSource_Init")]
  public static extern void ValueMapPostingSource_Init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueMapPostingSource_GetDescription")]
  public static extern string ValueMapPostingSource_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ValueMapPostingSource")]
  public static extern void delete_ValueMapPostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_FixedWeightPostingSource")]
  public static extern IntPtr new_FixedWeightPostingSource(double jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_GetTermfreqMin")]
  public static extern uint FixedWeightPostingSource_GetTermfreqMin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_GetTermfreqEst")]
  public static extern uint FixedWeightPostingSource_GetTermfreqEst(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_GetTermfreqMax")]
  public static extern uint FixedWeightPostingSource_GetTermfreqMax(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_GetWeight")]
  public static extern double FixedWeightPostingSource_GetWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_Next")]
  public static extern void FixedWeightPostingSource_Next(HandleRef jarg1, double jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_SkipTo")]
  public static extern void FixedWeightPostingSource_SkipTo(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_Check")]
  public static extern bool FixedWeightPostingSource_Check(HandleRef jarg1, uint jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_AtEnd")]
  public static extern bool FixedWeightPostingSource_AtEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_GetDocId")]
  public static extern uint FixedWeightPostingSource_GetDocId(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_Name")]
  public static extern string FixedWeightPostingSource_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_Init")]
  public static extern void FixedWeightPostingSource_Init(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSource_GetDescription")]
  public static extern string FixedWeightPostingSource_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_FixedWeightPostingSource")]
  public static extern void delete_FixedWeightPostingSource(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_MSet__SWIG_0")]
  public static extern IntPtr new_MSet__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_MSet__SWIG_1")]
  public static extern IntPtr new_MSet__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_MSet")]
  public static extern void delete_MSet(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_Fetch__SWIG_0")]
  public static extern void MSet_Fetch__SWIG_0(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_Fetch__SWIG_1")]
  public static extern void MSet_Fetch__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_Fetch__SWIG_2")]
  public static extern void MSet_Fetch__SWIG_2(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_ConvertToPercent__SWIG_0")]
  public static extern int MSet_ConvertToPercent__SWIG_0(HandleRef jarg1, double jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_ConvertToPercent__SWIG_1")]
  public static extern int MSet_ConvertToPercent__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetTermFreq")]
  public static extern uint MSet_GetTermFreq(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetTermWeight")]
  public static extern double MSet_GetTermWeight(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetFirstItem")]
  public static extern uint MSet_GetFirstItem(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetMatchesLowerBound")]
  public static extern uint MSet_GetMatchesLowerBound(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetMatchesEstimated")]
  public static extern uint MSet_GetMatchesEstimated(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetMatchesUpperBound")]
  public static extern uint MSet_GetMatchesUpperBound(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetUncollapsedMatchesLowerBound")]
  public static extern uint MSet_GetUncollapsedMatchesLowerBound(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetUncollapsedMatchesEstimated")]
  public static extern uint MSet_GetUncollapsedMatchesEstimated(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetUncollapsedMatchesUpperBound")]
  public static extern uint MSet_GetUncollapsedMatchesUpperBound(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetMaxPossible")]
  public static extern double MSet_GetMaxPossible(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetMaxAttained")]
  public static extern double MSet_GetMaxAttained(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_Size")]
  public static extern uint MSet_Size(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_Empty")]
  public static extern bool MSet_Empty(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_Begin")]
  public static extern IntPtr MSet_Begin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_End")]
  public static extern IntPtr MSet_End(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_Back")]
  public static extern IntPtr MSet_Back(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetHit")]
  public static extern IntPtr MSet_GetHit(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetDocumentPercentage")]
  public static extern int MSet_GetDocumentPercentage(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetDocument")]
  public static extern IntPtr MSet_GetDocument(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetDocId")]
  public static extern uint MSet_GetDocId(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSet_GetDescription")]
  public static extern string MSet_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_MSetIterator__SWIG_0")]
  public static extern IntPtr new_MSetIterator__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_MSetIterator__SWIG_1")]
  public static extern IntPtr new_MSetIterator__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_MSetIterator")]
  public static extern void delete_MSetIterator(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_GetDocId")]
  public static extern uint MSetIterator_GetDocId(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_Next")]
  public static extern IntPtr MSetIterator_Next(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_Prev")]
  public static extern IntPtr MSetIterator_Prev(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_Equals")]
  public static extern bool MSetIterator_Equals(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_GetDocument")]
  public static extern IntPtr MSetIterator_GetDocument(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_GetRank")]
  public static extern uint MSetIterator_GetRank(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_GetWeight")]
  public static extern double MSetIterator_GetWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_GetCollapseKey")]
  public static extern string MSetIterator_GetCollapseKey(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_GetCollapseCount")]
  public static extern uint MSetIterator_GetCollapseCount(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_GetPercent")]
  public static extern int MSetIterator_GetPercent(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MSetIterator_GetDescription")]
  public static extern string MSetIterator_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ESet__SWIG_0")]
  public static extern IntPtr new_ESet__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ESet__SWIG_1")]
  public static extern IntPtr new_ESet__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ESet")]
  public static extern void delete_ESet(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESet_GetEbound")]
  public static extern uint ESet_GetEbound(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESet_Size")]
  public static extern uint ESet_Size(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESet_Empty")]
  public static extern bool ESet_Empty(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESet_Begin")]
  public static extern IntPtr ESet_Begin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESet_End")]
  public static extern IntPtr ESet_End(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESet_Back")]
  public static extern IntPtr ESet_Back(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESet_GetDescription")]
  public static extern string ESet_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ESetIterator__SWIG_0")]
  public static extern IntPtr new_ESetIterator__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ESetIterator__SWIG_1")]
  public static extern IntPtr new_ESetIterator__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ESetIterator")]
  public static extern void delete_ESetIterator(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESetIterator_GetTerm")]
  public static extern string ESetIterator_GetTerm(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESetIterator_Next")]
  public static extern IntPtr ESetIterator_Next(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESetIterator_Prev")]
  public static extern IntPtr ESetIterator_Prev(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESetIterator_Equals")]
  public static extern bool ESetIterator_Equals(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESetIterator_GetWeight")]
  public static extern double ESetIterator_GetWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ESetIterator_GetDescription")]
  public static extern string ESetIterator_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_RSet__SWIG_0")]
  public static extern IntPtr new_RSet__SWIG_0(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_RSet__SWIG_1")]
  public static extern IntPtr new_RSet__SWIG_1();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_RSet")]
  public static extern void delete_RSet(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_Size")]
  public static extern uint RSet_Size(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_Empty")]
  public static extern bool RSet_Empty(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_AddDocument__SWIG_0")]
  public static extern void RSet_AddDocument__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_AddDocument__SWIG_1")]
  public static extern void RSet_AddDocument__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_RemoveDocument__SWIG_0")]
  public static extern void RSet_RemoveDocument__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_RemoveDocument__SWIG_1")]
  public static extern void RSet_RemoveDocument__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_Contains__SWIG_0")]
  public static extern bool RSet_Contains__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_Contains__SWIG_1")]
  public static extern bool RSet_Contains__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_RSet_GetDescription")]
  public static extern string RSet_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchDecider_Apply")]
  public static extern bool MatchDecider_Apply(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_MatchDecider")]
  public static extern void delete_MatchDecider(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_MatchDecider")]
  public static extern IntPtr new_MatchDecider();

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchDecider_director_connect")]
  public static extern void MatchDecider_director_connect(HandleRef jarg1, MatchDecider.SwigDelegateMatchDecider_0 delegate0);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ExpandDecider_Apply")]
  public static extern bool ExpandDecider_Apply(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ExpandDecider")]
  public static extern void delete_ExpandDecider(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ExpandDecider")]
  public static extern IntPtr new_ExpandDecider();

  [DllImport("_XapianSharp", EntryPoint="CSharp_ExpandDecider_director_connect")]
  public static extern void ExpandDecider_director_connect(HandleRef jarg1, ExpandDecider.SwigDelegateExpandDecider_0 delegate0);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Enquire")]
  public static extern IntPtr new_Enquire(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Enquire")]
  public static extern void delete_Enquire(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetQuery__SWIG_0")]
  public static extern void Enquire_SetQuery__SWIG_0(HandleRef jarg1, HandleRef jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetQuery__SWIG_1")]
  public static extern void Enquire_SetQuery__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetQuery")]
  public static extern IntPtr Enquire_GetQuery(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_AddMatchspy")]
  public static extern void Enquire_AddMatchspy(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_ClearMatchspies")]
  public static extern void Enquire_ClearMatchspies(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetWeightingScheme")]
  public static extern void Enquire_SetWeightingScheme(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetCollapseKey__SWIG_0")]
  public static extern void Enquire_SetCollapseKey__SWIG_0(HandleRef jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetCollapseKey__SWIG_1")]
  public static extern void Enquire_SetCollapseKey__SWIG_1(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetDocidOrder")]
  public static extern void Enquire_SetDocidOrder(HandleRef jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetCutoff__SWIG_0")]
  public static extern void Enquire_SetCutoff__SWIG_0(HandleRef jarg1, int jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetCutoff__SWIG_1")]
  public static extern void Enquire_SetCutoff__SWIG_1(HandleRef jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByRelevance")]
  public static extern void Enquire_SetSortByRelevance(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByValue__SWIG_0")]
  public static extern void Enquire_SetSortByValue__SWIG_0(HandleRef jarg1, uint jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByValue__SWIG_1")]
  public static extern void Enquire_SetSortByValue__SWIG_1(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByValueThenRelevance__SWIG_0")]
  public static extern void Enquire_SetSortByValueThenRelevance__SWIG_0(HandleRef jarg1, uint jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByValueThenRelevance__SWIG_1")]
  public static extern void Enquire_SetSortByValueThenRelevance__SWIG_1(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByRelevanceThenValue__SWIG_0")]
  public static extern void Enquire_SetSortByRelevanceThenValue__SWIG_0(HandleRef jarg1, uint jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByRelevanceThenValue__SWIG_1")]
  public static extern void Enquire_SetSortByRelevanceThenValue__SWIG_1(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByKey__SWIG_0")]
  public static extern void Enquire_SetSortByKey__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByKey__SWIG_1")]
  public static extern void Enquire_SetSortByKey__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByKeyThenRelevance__SWIG_0")]
  public static extern void Enquire_SetSortByKeyThenRelevance__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByKeyThenRelevance__SWIG_1")]
  public static extern void Enquire_SetSortByKeyThenRelevance__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByRelevanceThenKey__SWIG_0")]
  public static extern void Enquire_SetSortByRelevanceThenKey__SWIG_0(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_SetSortByRelevanceThenKey__SWIG_1")]
  public static extern void Enquire_SetSortByRelevanceThenKey__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_INCLUDE_QUERY_TERMS_get")]
  public static extern int Enquire_INCLUDE_QUERY_TERMS_get();

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_USE_EXACT_TERMFREQ_get")]
  public static extern int Enquire_USE_EXACT_TERMFREQ_get();

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMSet__SWIG_0")]
  public static extern IntPtr Enquire_GetMSet__SWIG_0(HandleRef jarg1, uint jarg2, uint jarg3, uint jarg4, HandleRef jarg5, HandleRef jarg6, HandleRef jarg7);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMSet__SWIG_1")]
  public static extern IntPtr Enquire_GetMSet__SWIG_1(HandleRef jarg1, uint jarg2, uint jarg3, uint jarg4, HandleRef jarg5, HandleRef jarg6);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMSet__SWIG_2")]
  public static extern IntPtr Enquire_GetMSet__SWIG_2(HandleRef jarg1, uint jarg2, uint jarg3, uint jarg4, HandleRef jarg5);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMSet__SWIG_3")]
  public static extern IntPtr Enquire_GetMSet__SWIG_3(HandleRef jarg1, uint jarg2, uint jarg3, uint jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMSet__SWIG_4")]
  public static extern IntPtr Enquire_GetMSet__SWIG_4(HandleRef jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMSet__SWIG_5")]
  public static extern IntPtr Enquire_GetMSet__SWIG_5(HandleRef jarg1, uint jarg2, uint jarg3, HandleRef jarg4, HandleRef jarg5);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMSet__SWIG_6")]
  public static extern IntPtr Enquire_GetMSet__SWIG_6(HandleRef jarg1, uint jarg2, uint jarg3, HandleRef jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetESet__SWIG_0")]
  public static extern IntPtr Enquire_GetESet__SWIG_0(HandleRef jarg1, uint jarg2, HandleRef jarg3, int jarg4, double jarg5, HandleRef jarg6);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetESet__SWIG_1")]
  public static extern IntPtr Enquire_GetESet__SWIG_1(HandleRef jarg1, uint jarg2, HandleRef jarg3, int jarg4, double jarg5);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetESet__SWIG_2")]
  public static extern IntPtr Enquire_GetESet__SWIG_2(HandleRef jarg1, uint jarg2, HandleRef jarg3, int jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetESet__SWIG_3")]
  public static extern IntPtr Enquire_GetESet__SWIG_3(HandleRef jarg1, uint jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetESet__SWIG_4")]
  public static extern IntPtr Enquire_GetESet__SWIG_4(HandleRef jarg1, uint jarg2, HandleRef jarg3, int jarg4, double jarg5, HandleRef jarg6, double jarg7);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetESet__SWIG_5")]
  public static extern IntPtr Enquire_GetESet__SWIG_5(HandleRef jarg1, uint jarg2, HandleRef jarg3, HandleRef jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMatchingTermsBegin__SWIG_0")]
  public static extern IntPtr Enquire_GetMatchingTermsBegin__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMatchingTermsEnd__SWIG_0")]
  public static extern IntPtr Enquire_GetMatchingTermsEnd__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMatchingTermsBegin__SWIG_1")]
  public static extern IntPtr Enquire_GetMatchingTermsBegin__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetMatchingTermsEnd__SWIG_1")]
  public static extern IntPtr Enquire_GetMatchingTermsEnd__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Enquire_GetDescription")]
  public static extern string Enquire_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Registry__SWIG_0")]
  public static extern IntPtr new_Registry__SWIG_0(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Registry__SWIG_1")]
  public static extern IntPtr new_Registry__SWIG_1();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Registry")]
  public static extern void delete_Registry(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Registry_RegisterWeightingScheme")]
  public static extern void Registry_RegisterWeightingScheme(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Registry_GetWeightingScheme")]
  public static extern IntPtr Registry_GetWeightingScheme(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Registry_RegisterPostingSource")]
  public static extern void Registry_RegisterPostingSource(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Registry_GetPostingSource")]
  public static extern IntPtr Registry_GetPostingSource(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Registry_RegisterMatchSpy")]
  public static extern void Registry_RegisterMatchSpy(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Registry_GetMatchSpy")]
  public static extern IntPtr Registry_GetMatchSpy(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Weight")]
  public static extern void delete_Weight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Weight_Name")]
  public static extern string Weight_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Weight_GetSumPart")]
  public static extern double Weight_GetSumPart(HandleRef jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Weight_GetMaxPart")]
  public static extern double Weight_GetMaxPart(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Weight_GetSumExtra")]
  public static extern double Weight_GetSumExtra(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Weight_GetMaxExtra")]
  public static extern double Weight_GetMaxExtra(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Weight_GetSumpartNeedsDoclength")]
  public static extern bool Weight_GetSumpartNeedsDoclength(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Weight_GetSumpartNeedsWdf")]
  public static extern bool Weight_GetSumpartNeedsWdf(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_BoolWeight")]
  public static extern IntPtr new_BoolWeight();

  [DllImport("_XapianSharp", EntryPoint="CSharp_BoolWeight_Name")]
  public static extern string BoolWeight_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BoolWeight_GetSumPart")]
  public static extern double BoolWeight_GetSumPart(HandleRef jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BoolWeight_GetMaxPart")]
  public static extern double BoolWeight_GetMaxPart(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BoolWeight_GetSumExtra")]
  public static extern double BoolWeight_GetSumExtra(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BoolWeight_GetMaxExtra")]
  public static extern double BoolWeight_GetMaxExtra(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_BoolWeight")]
  public static extern void delete_BoolWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_BM25Weight__SWIG_0")]
  public static extern IntPtr new_BM25Weight__SWIG_0(double jarg1, double jarg2, double jarg3, double jarg4, double jarg5);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_BM25Weight__SWIG_1")]
  public static extern IntPtr new_BM25Weight__SWIG_1();

  [DllImport("_XapianSharp", EntryPoint="CSharp_BM25Weight_Name")]
  public static extern string BM25Weight_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BM25Weight_GetSumPart")]
  public static extern double BM25Weight_GetSumPart(HandleRef jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BM25Weight_GetMaxPart")]
  public static extern double BM25Weight_GetMaxPart(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BM25Weight_GetSumExtra")]
  public static extern double BM25Weight_GetSumExtra(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BM25Weight_GetMaxExtra")]
  public static extern double BM25Weight_GetMaxExtra(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_BM25Weight")]
  public static extern void delete_BM25Weight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_TradWeight__SWIG_0")]
  public static extern IntPtr new_TradWeight__SWIG_0(double jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_TradWeight__SWIG_1")]
  public static extern IntPtr new_TradWeight__SWIG_1();

  [DllImport("_XapianSharp", EntryPoint="CSharp_TradWeight_Name")]
  public static extern string TradWeight_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TradWeight_GetSumPart")]
  public static extern double TradWeight_GetSumPart(HandleRef jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TradWeight_GetMaxPart")]
  public static extern double TradWeight_GetMaxPart(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TradWeight_GetSumExtra")]
  public static extern double TradWeight_GetSumExtra(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TradWeight_GetMaxExtra")]
  public static extern double TradWeight_GetMaxExtra(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_TradWeight")]
  public static extern void delete_TradWeight(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_MatchSpy")]
  public static extern IntPtr new_MatchSpy();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_MatchSpy")]
  public static extern void delete_MatchSpy(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchSpy_Apply")]
  public static extern void MatchSpy_Apply(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchSpy_Name")]
  public static extern string MatchSpy_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchSpy_NameSwigExplicitMatchSpy")]
  public static extern string MatchSpy_NameSwigExplicitMatchSpy(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchSpy_MergeResults")]
  public static extern void MatchSpy_MergeResults(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchSpy_MergeResultsSwigExplicitMatchSpy")]
  public static extern void MatchSpy_MergeResultsSwigExplicitMatchSpy(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchSpy_GetDescription")]
  public static extern string MatchSpy_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchSpy_GetDescriptionSwigExplicitMatchSpy")]
  public static extern string MatchSpy_GetDescriptionSwigExplicitMatchSpy(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MatchSpy_director_connect")]
  public static extern void MatchSpy_director_connect(HandleRef jarg1, MatchSpy.SwigDelegateMatchSpy_0 delegate0, MatchSpy.SwigDelegateMatchSpy_1 delegate1, MatchSpy.SwigDelegateMatchSpy_2 delegate2, MatchSpy.SwigDelegateMatchSpy_3 delegate3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValueCountMatchSpy__SWIG_0")]
  public static extern IntPtr new_ValueCountMatchSpy__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValueCountMatchSpy__SWIG_1")]
  public static extern IntPtr new_ValueCountMatchSpy__SWIG_1(uint jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_GetTotal")]
  public static extern uint ValueCountMatchSpy_GetTotal(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_ValuesBegin")]
  public static extern IntPtr ValueCountMatchSpy_ValuesBegin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_ValuesEnd")]
  public static extern IntPtr ValueCountMatchSpy_ValuesEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_TopValuesBegin")]
  public static extern IntPtr ValueCountMatchSpy_TopValuesBegin(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_TopValuesEnd")]
  public static extern IntPtr ValueCountMatchSpy_TopValuesEnd(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_Apply")]
  public static extern void ValueCountMatchSpy_Apply(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_Name")]
  public static extern string ValueCountMatchSpy_Name(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_MergeResults")]
  public static extern void ValueCountMatchSpy_MergeResults(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpy_GetDescription")]
  public static extern string ValueCountMatchSpy_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ValueCountMatchSpy")]
  public static extern void delete_ValueCountMatchSpy(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_AddDatabase")]
  public static extern void Database_AddDatabase(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Database__SWIG_0")]
  public static extern IntPtr new_Database__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Database__SWIG_1")]
  public static extern IntPtr new_Database__SWIG_1(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Database")]
  public static extern void delete_Database(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Database__SWIG_2")]
  public static extern IntPtr new_Database__SWIG_2(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_Reopen")]
  public static extern void Database_Reopen(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_Close")]
  public static extern void Database_Close(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetDescription")]
  public static extern string Database_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_PostListBegin")]
  public static extern IntPtr Database_PostListBegin(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_PostListEnd")]
  public static extern IntPtr Database_PostListEnd(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_TermListBegin")]
  public static extern IntPtr Database_TermListBegin(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_TermListEnd")]
  public static extern IntPtr Database_TermListEnd(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_PositionListBegin")]
  public static extern IntPtr Database_PositionListBegin(HandleRef jarg1, uint jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_PositionListEnd")]
  public static extern IntPtr Database_PositionListEnd(HandleRef jarg1, uint jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_AllTermsBegin__SWIG_0")]
  public static extern IntPtr Database_AllTermsBegin__SWIG_0(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_AllTermsEnd__SWIG_0")]
  public static extern IntPtr Database_AllTermsEnd__SWIG_0(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_AllTermsBegin__SWIG_1")]
  public static extern IntPtr Database_AllTermsBegin__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_AllTermsEnd__SWIG_1")]
  public static extern IntPtr Database_AllTermsEnd__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetDocCount")]
  public static extern uint Database_GetDocCount(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetLastDocId")]
  public static extern uint Database_GetLastDocId(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetAvLength")]
  public static extern double Database_GetAvLength(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetTermFreq")]
  public static extern uint Database_GetTermFreq(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_TermExists")]
  public static extern bool Database_TermExists(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetCollectionFreq")]
  public static extern uint Database_GetCollectionFreq(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetValueFreq")]
  public static extern uint Database_GetValueFreq(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetValueLowerBound")]
  public static extern string Database_GetValueLowerBound(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetValueUpperBound")]
  public static extern string Database_GetValueUpperBound(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetDoclengthLowerBound")]
  public static extern uint Database_GetDoclengthLowerBound(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetDoclengthUpperBound")]
  public static extern uint Database_GetDoclengthUpperBound(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetWdfUpperBound")]
  public static extern uint Database_GetWdfUpperBound(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_ValuestreamBegin")]
  public static extern IntPtr Database_ValuestreamBegin(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_ValuestreamEnd")]
  public static extern IntPtr Database_ValuestreamEnd(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetDocLength")]
  public static extern double Database_GetDocLength(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_KeepAlive")]
  public static extern void Database_KeepAlive(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetDocument")]
  public static extern IntPtr Database_GetDocument(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetSpellingSuggestion__SWIG_0")]
  public static extern string Database_GetSpellingSuggestion__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetSpellingSuggestion__SWIG_1")]
  public static extern string Database_GetSpellingSuggestion__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_SpellingsBegin")]
  public static extern IntPtr Database_SpellingsBegin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_SpellingsEnd")]
  public static extern IntPtr Database_SpellingsEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_SynonymsBegin")]
  public static extern IntPtr Database_SynonymsBegin(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_SynonymsEnd")]
  public static extern IntPtr Database_SynonymsEnd(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_SynonymKeysBegin__SWIG_0")]
  public static extern IntPtr Database_SynonymKeysBegin__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_SynonymKeysBegin__SWIG_1")]
  public static extern IntPtr Database_SynonymKeysBegin__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_SynonymKeysEnd__SWIG_0")]
  public static extern IntPtr Database_SynonymKeysEnd__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_SynonymKeysEnd__SWIG_1")]
  public static extern IntPtr Database_SynonymKeysEnd__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetMetadata")]
  public static extern string Database_GetMetadata(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_MetadataKeysBegin__SWIG_0")]
  public static extern IntPtr Database_MetadataKeysBegin__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_MetadataKeysBegin__SWIG_1")]
  public static extern IntPtr Database_MetadataKeysBegin__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_MetadataKeysEnd__SWIG_0")]
  public static extern IntPtr Database_MetadataKeysEnd__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_MetadataKeysEnd__SWIG_1")]
  public static extern IntPtr Database_MetadataKeysEnd__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Database_GetUuid")]
  public static extern string Database_GetUuid(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_WritableDatabase")]
  public static extern void delete_WritableDatabase(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_WritableDatabase__SWIG_0")]
  public static extern IntPtr new_WritableDatabase__SWIG_0();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_WritableDatabase__SWIG_1")]
  public static extern IntPtr new_WritableDatabase__SWIG_1(string jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_WritableDatabase__SWIG_2")]
  public static extern IntPtr new_WritableDatabase__SWIG_2(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_Commit")]
  public static extern void WritableDatabase_Commit(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_Flush")]
  public static extern void WritableDatabase_Flush(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_BeginTransaction__SWIG_0")]
  public static extern void WritableDatabase_BeginTransaction__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_BeginTransaction__SWIG_1")]
  public static extern void WritableDatabase_BeginTransaction__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_CommitTransaction")]
  public static extern void WritableDatabase_CommitTransaction(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_CancelTransaction")]
  public static extern void WritableDatabase_CancelTransaction(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_AddDocument")]
  public static extern uint WritableDatabase_AddDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_DeleteDocument__SWIG_0")]
  public static extern void WritableDatabase_DeleteDocument__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_ReplaceDocument__SWIG_0")]
  public static extern void WritableDatabase_ReplaceDocument__SWIG_0(HandleRef jarg1, uint jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_DeleteDocument__SWIG_1")]
  public static extern void WritableDatabase_DeleteDocument__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_ReplaceDocument__SWIG_1")]
  public static extern uint WritableDatabase_ReplaceDocument__SWIG_1(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_AddSpelling__SWIG_0")]
  public static extern void WritableDatabase_AddSpelling__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_AddSpelling__SWIG_1")]
  public static extern void WritableDatabase_AddSpelling__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_RemoveSpelling__SWIG_0")]
  public static extern void WritableDatabase_RemoveSpelling__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_RemoveSpelling__SWIG_1")]
  public static extern void WritableDatabase_RemoveSpelling__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_AddSynonym")]
  public static extern void WritableDatabase_AddSynonym(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_RemoveSynonym")]
  public static extern void WritableDatabase_RemoveSynonym(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_ClearSynonyms")]
  public static extern void WritableDatabase_ClearSynonyms(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_SetMetadata")]
  public static extern void WritableDatabase_SetMetadata(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabase_GetDescription")]
  public static extern string WritableDatabase_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DB_CREATE_OR_OPEN_get")]
  public static extern int DB_CREATE_OR_OPEN_get();

  [DllImport("_XapianSharp", EntryPoint="CSharp_DB_CREATE_get")]
  public static extern int DB_CREATE_get();

  [DllImport("_XapianSharp", EntryPoint="CSharp_DB_CREATE_OR_OVERWRITE_get")]
  public static extern int DB_CREATE_OR_OVERWRITE_get();

  [DllImport("_XapianSharp", EntryPoint="CSharp_DB_OPEN_get")]
  public static extern int DB_OPEN_get();

  [DllImport("_XapianSharp", EntryPoint="CSharp_Auto_OpenStub")]
  public static extern IntPtr Auto_OpenStub(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Brass_Open__SWIG_0")]
  public static extern IntPtr Brass_Open__SWIG_0(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Brass_Open__SWIG_1")]
  public static extern IntPtr Brass_Open__SWIG_1(string jarg1, int jarg2, int jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Brass_Open__SWIG_2")]
  public static extern IntPtr Brass_Open__SWIG_2(string jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Chert_Open__SWIG_0")]
  public static extern IntPtr Chert_Open__SWIG_0(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Chert_Open__SWIG_1")]
  public static extern IntPtr Chert_Open__SWIG_1(string jarg1, int jarg2, int jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Chert_Open__SWIG_2")]
  public static extern IntPtr Chert_Open__SWIG_2(string jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Flint_Open__SWIG_0")]
  public static extern IntPtr Flint_Open__SWIG_0(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Flint_Open__SWIG_1")]
  public static extern IntPtr Flint_Open__SWIG_1(string jarg1, int jarg2, int jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Flint_Open__SWIG_2")]
  public static extern IntPtr Flint_Open__SWIG_2(string jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_InMemory_Open")]
  public static extern IntPtr InMemory_Open();

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_Open__SWIG_0")]
  public static extern IntPtr Remote_Open__SWIG_0(string jarg1, uint jarg2, uint jarg3, uint jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_Open__SWIG_1")]
  public static extern IntPtr Remote_Open__SWIG_1(string jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_Open__SWIG_2")]
  public static extern IntPtr Remote_Open__SWIG_2(string jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_OpenWritable__SWIG_0")]
  public static extern IntPtr Remote_OpenWritable__SWIG_0(string jarg1, uint jarg2, uint jarg3, uint jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_OpenWritable__SWIG_1")]
  public static extern IntPtr Remote_OpenWritable__SWIG_1(string jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_OpenWritable__SWIG_2")]
  public static extern IntPtr Remote_OpenWritable__SWIG_2(string jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_Open__SWIG_3")]
  public static extern IntPtr Remote_Open__SWIG_3(string jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_Open__SWIG_4")]
  public static extern IntPtr Remote_Open__SWIG_4(string jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_OpenWritable__SWIG_3")]
  public static extern IntPtr Remote_OpenWritable__SWIG_3(string jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Remote_OpenWritable__SWIG_4")]
  public static extern IntPtr Remote_OpenWritable__SWIG_4(string jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_0")]
  public static extern IntPtr new_Query__SWIG_0(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_1")]
  public static extern IntPtr new_Query__SWIG_1();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Query")]
  public static extern void delete_Query(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_2")]
  public static extern IntPtr new_Query__SWIG_2(string jarg1, uint jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_3")]
  public static extern IntPtr new_Query__SWIG_3(string jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_4")]
  public static extern IntPtr new_Query__SWIG_4(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_5")]
  public static extern IntPtr new_Query__SWIG_5(int jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_6")]
  public static extern IntPtr new_Query__SWIG_6(int jarg1, string jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_9")]
  public static extern IntPtr new_Query__SWIG_9(int jarg1, HandleRef jarg2, double jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_10")]
  public static extern IntPtr new_Query__SWIG_10(int jarg1, uint jarg2, string jarg3, string jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_11")]
  public static extern IntPtr new_Query__SWIG_11(int jarg1, uint jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_12")]
  public static extern IntPtr new_Query__SWIG_12(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Query_GetLength")]
  public static extern uint Query_GetLength(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Query_GetTermsBegin")]
  public static extern IntPtr Query_GetTermsBegin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Query_GetTermsEnd")]
  public static extern IntPtr Query_GetTermsEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Query_Empty")]
  public static extern bool Query_Empty(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Query_Serialise")]
  public static extern string Query_Serialise(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Query_Unserialise__SWIG_0")]
  public static extern IntPtr Query_Unserialise__SWIG_0(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Query_Unserialise__SWIG_1")]
  public static extern IntPtr Query_Unserialise__SWIG_1(string jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Query_GetDescription")]
  public static extern string Query_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_13")]
  public static extern IntPtr new_Query__SWIG_13(int jarg1, HandleRef jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_14")]
  public static extern IntPtr new_Query__SWIG_14(int jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_15")]
  public static extern IntPtr new_Query__SWIG_15(int jarg1, HandleRef jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Query__SWIG_16")]
  public static extern IntPtr new_Query__SWIG_16(int jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Stopper_Apply")]
  public static extern bool Stopper_Apply(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Stopper")]
  public static extern void delete_Stopper(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Stopper_GetDescription")]
  public static extern string Stopper_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Stopper_GetDescriptionSwigExplicitStopper")]
  public static extern string Stopper_GetDescriptionSwigExplicitStopper(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Stopper")]
  public static extern IntPtr new_Stopper();

  [DllImport("_XapianSharp", EntryPoint="CSharp_Stopper_director_connect")]
  public static extern void Stopper_director_connect(HandleRef jarg1, Stopper.SwigDelegateStopper_0 delegate0, Stopper.SwigDelegateStopper_1 delegate1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_SimpleStopper")]
  public static extern IntPtr new_SimpleStopper();

  [DllImport("_XapianSharp", EntryPoint="CSharp_SimpleStopper_Add")]
  public static extern void SimpleStopper_Add(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_SimpleStopper_Apply")]
  public static extern bool SimpleStopper_Apply(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_SimpleStopper_GetDescription")]
  public static extern string SimpleStopper_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_SimpleStopper")]
  public static extern void delete_SimpleStopper(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ValueRangeProcessor")]
  public static extern void delete_ValueRangeProcessor(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueRangeProcessor_Apply")]
  public static extern uint ValueRangeProcessor_Apply(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValueRangeProcessor")]
  public static extern IntPtr new_ValueRangeProcessor();

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueRangeProcessor_director_connect")]
  public static extern void ValueRangeProcessor_director_connect(HandleRef jarg1, ValueRangeProcessor.SwigDelegateValueRangeProcessor_0 delegate0);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_StringValueRangeProcessor__SWIG_0")]
  public static extern IntPtr new_StringValueRangeProcessor__SWIG_0(uint jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_StringValueRangeProcessor__SWIG_1")]
  public static extern IntPtr new_StringValueRangeProcessor__SWIG_1(uint jarg1, string jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_StringValueRangeProcessor__SWIG_2")]
  public static extern IntPtr new_StringValueRangeProcessor__SWIG_2(uint jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_StringValueRangeProcessor_Apply")]
  public static extern uint StringValueRangeProcessor_Apply(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_StringValueRangeProcessor")]
  public static extern void delete_StringValueRangeProcessor(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DateValueRangeProcessor__SWIG_0")]
  public static extern IntPtr new_DateValueRangeProcessor__SWIG_0(uint jarg1, bool jarg2, int jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DateValueRangeProcessor__SWIG_1")]
  public static extern IntPtr new_DateValueRangeProcessor__SWIG_1(uint jarg1, bool jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DateValueRangeProcessor__SWIG_2")]
  public static extern IntPtr new_DateValueRangeProcessor__SWIG_2(uint jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DateValueRangeProcessor__SWIG_3")]
  public static extern IntPtr new_DateValueRangeProcessor__SWIG_3(uint jarg1, string jarg2, bool jarg3, bool jarg4, int jarg5);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DateValueRangeProcessor__SWIG_4")]
  public static extern IntPtr new_DateValueRangeProcessor__SWIG_4(uint jarg1, string jarg2, bool jarg3, bool jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DateValueRangeProcessor__SWIG_5")]
  public static extern IntPtr new_DateValueRangeProcessor__SWIG_5(uint jarg1, string jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_DateValueRangeProcessor__SWIG_6")]
  public static extern IntPtr new_DateValueRangeProcessor__SWIG_6(uint jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DateValueRangeProcessor_Apply")]
  public static extern uint DateValueRangeProcessor_Apply(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_DateValueRangeProcessor")]
  public static extern void delete_DateValueRangeProcessor(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_NumberValueRangeProcessor__SWIG_0")]
  public static extern IntPtr new_NumberValueRangeProcessor__SWIG_0(uint jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_NumberValueRangeProcessor__SWIG_1")]
  public static extern IntPtr new_NumberValueRangeProcessor__SWIG_1(uint jarg1, string jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_NumberValueRangeProcessor__SWIG_2")]
  public static extern IntPtr new_NumberValueRangeProcessor__SWIG_2(uint jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_NumberValueRangeProcessor_Apply")]
  public static extern uint NumberValueRangeProcessor_Apply(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_NumberValueRangeProcessor")]
  public static extern void delete_NumberValueRangeProcessor(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_QueryParser")]
  public static extern IntPtr new_QueryParser();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_QueryParser")]
  public static extern void delete_QueryParser(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_SetStemmer")]
  public static extern void QueryParser_SetStemmer(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_SetStemmingStrategy")]
  public static extern void QueryParser_SetStemmingStrategy(HandleRef jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_SetStopper__SWIG_0")]
  public static extern void QueryParser_SetStopper__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_SetStopper__SWIG_1")]
  public static extern void QueryParser_SetStopper__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_SetDefaultOp")]
  public static extern void QueryParser_SetDefaultOp(HandleRef jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_GetDefaultOp")]
  public static extern int QueryParser_GetDefaultOp(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_SetDatabase")]
  public static extern void QueryParser_SetDatabase(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_ParseQuery__SWIG_0")]
  public static extern IntPtr QueryParser_ParseQuery__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3, string jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_ParseQuery__SWIG_1")]
  public static extern IntPtr QueryParser_ParseQuery__SWIG_1(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_ParseQuery__SWIG_2")]
  public static extern IntPtr QueryParser_ParseQuery__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_AddPrefix")]
  public static extern void QueryParser_AddPrefix(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_AddBooleanPrefix__SWIG_0")]
  public static extern void QueryParser_AddBooleanPrefix__SWIG_0(HandleRef jarg1, string jarg2, string jarg3, bool jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_AddBooleanPrefix__SWIG_1")]
  public static extern void QueryParser_AddBooleanPrefix__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_StopListBegin")]
  public static extern IntPtr QueryParser_StopListBegin(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_StopListEnd")]
  public static extern IntPtr QueryParser_StopListEnd(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_UnstemBegin")]
  public static extern IntPtr QueryParser_UnstemBegin(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_UnstemEnd")]
  public static extern IntPtr QueryParser_UnstemEnd(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_AddValuerangeprocessor")]
  public static extern void QueryParser_AddValuerangeprocessor(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_GetCorrectedQueryString")]
  public static extern string QueryParser_GetCorrectedQueryString(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_QueryParser_GetDescription")]
  public static extern string QueryParser_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_SortableSerialise")]
  public static extern string SortableSerialise(double jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_SortableUnserialise")]
  public static extern double SortableUnserialise(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_StemImplementation")]
  public static extern void delete_StemImplementation(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_StemImplementation_Apply")]
  public static extern string StemImplementation_Apply(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_StemImplementation_GetDescription")]
  public static extern string StemImplementation_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_StemImplementation")]
  public static extern IntPtr new_StemImplementation();

  [DllImport("_XapianSharp", EntryPoint="CSharp_StemImplementation_director_connect")]
  public static extern void StemImplementation_director_connect(HandleRef jarg1, StemImplementation.SwigDelegateStemImplementation_0 delegate0, StemImplementation.SwigDelegateStemImplementation_1 delegate1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Stem__SWIG_0")]
  public static extern IntPtr new_Stem__SWIG_0(string jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Stem__SWIG_1")]
  public static extern IntPtr new_Stem__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Stem")]
  public static extern void delete_Stem(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Stem_Apply")]
  public static extern string Stem_Apply(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Stem_GetDescription")]
  public static extern string Stem_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Stem_GetAvailableLanguages")]
  public static extern string Stem_GetAvailableLanguages();

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_TermGenerator")]
  public static extern IntPtr new_TermGenerator();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_TermGenerator")]
  public static extern void delete_TermGenerator(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_SetStemmer")]
  public static extern void TermGenerator_SetStemmer(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_SetStopper__SWIG_0")]
  public static extern void TermGenerator_SetStopper__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_SetStopper__SWIG_1")]
  public static extern void TermGenerator_SetStopper__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_SetDocument")]
  public static extern void TermGenerator_SetDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_GetDocument")]
  public static extern IntPtr TermGenerator_GetDocument(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_SetDatabase")]
  public static extern void TermGenerator_SetDatabase(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_SetFlags__SWIG_0")]
  public static extern int TermGenerator_SetFlags__SWIG_0(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_SetFlags__SWIG_1")]
  public static extern int TermGenerator_SetFlags__SWIG_1(HandleRef jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_IndexText__SWIG_0")]
  public static extern void TermGenerator_IndexText__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3, string jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_IndexText__SWIG_1")]
  public static extern void TermGenerator_IndexText__SWIG_1(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_IndexText__SWIG_2")]
  public static extern void TermGenerator_IndexText__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_IndexTextWithoutPositions__SWIG_0")]
  public static extern void TermGenerator_IndexTextWithoutPositions__SWIG_0(HandleRef jarg1, string jarg2, uint jarg3, string jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_IndexTextWithoutPositions__SWIG_1")]
  public static extern void TermGenerator_IndexTextWithoutPositions__SWIG_1(HandleRef jarg1, string jarg2, uint jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_IndexTextWithoutPositions__SWIG_2")]
  public static extern void TermGenerator_IndexTextWithoutPositions__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_IncreaseTermpos__SWIG_0")]
  public static extern void TermGenerator_IncreaseTermpos__SWIG_0(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_IncreaseTermpos__SWIG_1")]
  public static extern void TermGenerator_IncreaseTermpos__SWIG_1(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_GetTermPos")]
  public static extern uint TermGenerator_GetTermPos(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_SetTermpos")]
  public static extern void TermGenerator_SetTermpos(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TermGenerator_GetDescription")]
  public static extern string TermGenerator_GetDescription(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_KeyMaker_Apply")]
  public static extern string KeyMaker_Apply(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_KeyMaker")]
  public static extern void delete_KeyMaker(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_KeyMaker")]
  public static extern IntPtr new_KeyMaker();

  [DllImport("_XapianSharp", EntryPoint="CSharp_KeyMaker_director_connect")]
  public static extern void KeyMaker_director_connect(HandleRef jarg1, KeyMaker.SwigDelegateKeyMaker_0 delegate0);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_MultiValueKeyMaker")]
  public static extern IntPtr new_MultiValueKeyMaker();

  [DllImport("_XapianSharp", EntryPoint="CSharp_MultiValueKeyMaker_Apply")]
  public static extern string MultiValueKeyMaker_Apply(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MultiValueKeyMaker_AddValue__SWIG_0")]
  public static extern void MultiValueKeyMaker_AddValue__SWIG_0(HandleRef jarg1, uint jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MultiValueKeyMaker_AddValue__SWIG_1")]
  public static extern void MultiValueKeyMaker_AddValue__SWIG_1(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_MultiValueKeyMaker")]
  public static extern void delete_MultiValueKeyMaker(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Sorter")]
  public static extern void delete_Sorter(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_MultiValueSorter")]
  public static extern IntPtr new_MultiValueSorter();

  [DllImport("_XapianSharp", EntryPoint="CSharp_MultiValueSorter_Apply")]
  public static extern string MultiValueSorter_Apply(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MultiValueSorter_Add__SWIG_0")]
  public static extern void MultiValueSorter_Add__SWIG_0(HandleRef jarg1, uint jarg2, bool jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MultiValueSorter_Add__SWIG_1")]
  public static extern void MultiValueSorter_Add__SWIG_1(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_MultiValueSorter")]
  public static extern void delete_MultiValueSorter(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_ValueSetMatchDecider")]
  public static extern IntPtr new_ValueSetMatchDecider(uint jarg1, bool jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueSetMatchDecider_AddValue")]
  public static extern void ValueSetMatchDecider_AddValue(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueSetMatchDecider_RemoveValue")]
  public static extern void ValueSetMatchDecider_RemoveValue(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueSetMatchDecider_Apply")]
  public static extern bool ValueSetMatchDecider_Apply(HandleRef jarg1, HandleRef jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_ValueSetMatchDecider")]
  public static extern void delete_ValueSetMatchDecider(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_new_Compactor")]
  public static extern IntPtr new_Compactor();

  [DllImport("_XapianSharp", EntryPoint="CSharp_delete_Compactor")]
  public static extern void delete_Compactor(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_SetBlockSize")]
  public static extern void Compactor_SetBlockSize(HandleRef jarg1, uint jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_SetRenumber")]
  public static extern void Compactor_SetRenumber(HandleRef jarg1, bool jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_SetMultipass")]
  public static extern void Compactor_SetMultipass(HandleRef jarg1, bool jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_SetCompactionLevel")]
  public static extern void Compactor_SetCompactionLevel(HandleRef jarg1, int jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_SetDestdir")]
  public static extern void Compactor_SetDestdir(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_AddSource")]
  public static extern void Compactor_AddSource(HandleRef jarg1, string jarg2);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_Compact")]
  public static extern void Compactor_Compact(HandleRef jarg1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_SetStatus")]
  public static extern void Compactor_SetStatus(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_SetStatusSwigExplicitCompactor")]
  public static extern void Compactor_SetStatusSwigExplicitCompactor(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_ResolveDuplicateMetadata")]
  public static extern string Compactor_ResolveDuplicateMetadata(HandleRef jarg1, string jarg2, uint jarg3, HandleRef jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_ResolveDuplicateMetadataSwigExplicitCompactor")]
  public static extern string Compactor_ResolveDuplicateMetadataSwigExplicitCompactor(HandleRef jarg1, string jarg2, uint jarg3, HandleRef jarg4);

  [DllImport("_XapianSharp", EntryPoint="CSharp_Compactor_director_connect")]
  public static extern void Compactor_director_connect(HandleRef jarg1, Compactor.SwigDelegateCompactor_0 delegate0, Compactor.SwigDelegateCompactor_1 delegate1);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValuePostingSourceUpcast")]
  public static extern IntPtr ValuePostingSourceUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueWeightPostingSourceUpcast")]
  public static extern IntPtr ValueWeightPostingSourceUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DecreasingValueWeightPostingSourceUpcast")]
  public static extern IntPtr DecreasingValueWeightPostingSourceUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueMapPostingSourceUpcast")]
  public static extern IntPtr ValueMapPostingSourceUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_FixedWeightPostingSourceUpcast")]
  public static extern IntPtr FixedWeightPostingSourceUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BoolWeightUpcast")]
  public static extern IntPtr BoolWeightUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_BM25WeightUpcast")]
  public static extern IntPtr BM25WeightUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_TradWeightUpcast")]
  public static extern IntPtr TradWeightUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueCountMatchSpyUpcast")]
  public static extern IntPtr ValueCountMatchSpyUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_WritableDatabaseUpcast")]
  public static extern IntPtr WritableDatabaseUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_SimpleStopperUpcast")]
  public static extern IntPtr SimpleStopperUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_StringValueRangeProcessorUpcast")]
  public static extern IntPtr StringValueRangeProcessorUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_DateValueRangeProcessorUpcast")]
  public static extern IntPtr DateValueRangeProcessorUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_NumberValueRangeProcessorUpcast")]
  public static extern IntPtr NumberValueRangeProcessorUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MultiValueKeyMakerUpcast")]
  public static extern IntPtr MultiValueKeyMakerUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_SorterUpcast")]
  public static extern IntPtr SorterUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_MultiValueSorterUpcast")]
  public static extern IntPtr MultiValueSorterUpcast(IntPtr objectRef);

  [DllImport("_XapianSharp", EntryPoint="CSharp_ValueSetMatchDeciderUpcast")]
  public static extern IntPtr ValueSetMatchDeciderUpcast(IntPtr objectRef);
}

}
