/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.FontDeclaration;
import writer2latex.office.FormsReader;
import writer2latex.office.ListStyle;
import writer2latex.office.LoftReader;
import writer2latex.office.MasterPage;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.PageLayout;
import writer2latex.office.PropertySet;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableReader;
import writer2latex.office.TocReader;
import writer2latex.util.Misc;
import writer2latex.xmerge.OfficeDocument;

public class OfficeReader {
    private OfficeDocument oooDoc = null;
    private OfficeStyleFamily font = new OfficeStyleFamily(class$writer2latex$office$FontDeclaration == null ? (class$writer2latex$office$FontDeclaration = OfficeReader.class$("writer2latex.office.FontDeclaration")) : class$writer2latex$office$FontDeclaration);
    private OfficeStyleFamily text = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily par = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily section = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily table = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily column = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily row = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily cell = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily frame = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily presentation = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily drawingPage = new OfficeStyleFamily(class$writer2latex$office$StyleWithProperties == null ? (class$writer2latex$office$StyleWithProperties = OfficeReader.class$("writer2latex.office.StyleWithProperties")) : class$writer2latex$office$StyleWithProperties);
    private OfficeStyleFamily list = new OfficeStyleFamily(class$writer2latex$office$ListStyle == null ? (class$writer2latex$office$ListStyle = OfficeReader.class$("writer2latex.office.ListStyle")) : class$writer2latex$office$ListStyle);
    private OfficeStyleFamily pageLayout = new OfficeStyleFamily(class$writer2latex$office$PageLayout == null ? (class$writer2latex$office$PageLayout = OfficeReader.class$("writer2latex.office.PageLayout")) : class$writer2latex$office$PageLayout);
    private OfficeStyleFamily masterPage = new OfficeStyleFamily(class$writer2latex$office$MasterPage == null ? (class$writer2latex$office$MasterPage = OfficeReader.class$("writer2latex.office.MasterPage")) : class$writer2latex$office$MasterPage);
    private ListStyle outline = new ListStyle();
    private PropertySet footnotes = null;
    private PropertySet endnotes = null;
    private StyleWithProperties[] heading = new StyleWithProperties[11];
    private MasterPage firstMasterPage = null;
    private Hashtable indexes = new Hashtable();
    private HashSet indexSourceStyles = new HashSet();
    private HashSet figureSequenceNames = new HashSet();
    private HashSet tableSequenceNames = new HashSet();
    private String sAutoFigureSequenceName = null;
    private String sAutoTableSequenceName = null;
    private Hashtable sequenceNames = new Hashtable();
    private Hashtable seqrefNames = new Hashtable();
    private HashSet footnoteRef = new HashSet();
    private HashSet endnoteRef = new HashSet();
    private HashSet referenceRef = new HashSet();
    private HashSet bookmarkRef = new HashSet();
    private HashSet sequenceRef = new HashSet();
    private HashSet links = new HashSet();
    private FormsReader forms = new FormsReader();
    private Element content = null;
    private boolean bOpenDocument = false;
    private boolean bText = false;
    private boolean bSpreadsheet = false;
    private boolean bPresentation = false;
    static /* synthetic */ Class class$writer2latex$office$FontDeclaration;
    static /* synthetic */ Class class$writer2latex$office$StyleWithProperties;
    static /* synthetic */ Class class$writer2latex$office$ListStyle;
    static /* synthetic */ Class class$writer2latex$office$PageLayout;
    static /* synthetic */ Class class$writer2latex$office$MasterPage;

    public static boolean isTextElement(Node node) {
        return node.getNodeType() == 1 && node.getNodeName().startsWith("text:");
    }

    public static boolean isTableElement(Node node) {
        return node.getNodeType() == 1 && node.getNodeName().startsWith("table:");
    }

    public static boolean isDrawElement(Node node) {
        return node.getNodeType() == 1 && node.getNodeName().startsWith("draw:");
    }

    public static boolean isNoteElement(Node node) {
        return node.getNodeType() == 1 && (node.getNodeName().equals("text:note") || node.getNodeName().equals("text:footnote") || node.getNodeName().equals("text:endnote"));
    }

    public static boolean isSingleParagraph(Node node) {
        boolean bFoundPar = false;
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("text:p")) {
                    if (bFoundPar) {
                        return false;
                    }
                    bFoundPar = true;
                } else {
                    return false;
                }
            }
            child = child.getNextSibling();
        }
        return bFoundPar;
    }

    public static boolean isWhitespaceContent(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 ? (child.getNodeName().equals("text:span") ? !OfficeReader.isWhitespaceContent(child) : (child.getNodeName().equals("text:a") ? !OfficeReader.isWhitespaceContent(child) : !OfficeReader.isTextElement(child))) : child.getNodeType() == 3 && !OfficeReader.isWhitespace(child.getNodeValue())) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    public static boolean isWhitespace(String s) {
        int nLen = s.length();
        int i = 0;
        while (i < nLen) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int getCharacterCount(Node node) {
        Node child = node.getFirstChild();
        int nCount = 0;
        while (child != null) {
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 3: {
                    nCount += child.getNodeValue().length();
                    break;
                }
                case 1: {
                    String sName = child.getNodeName();
                    if (sName.equals("text:s")) {
                        nCount += Misc.getPosInteger(Misc.getAttribute(child, "text:c"), 1);
                        break;
                    }
                    if (sName.equals("text:tab-stop")) {
                        ++nCount;
                        break;
                    }
                    if (sName.equals("text:tab")) {
                        ++nCount;
                        break;
                    }
                    if (OfficeReader.isNoteElement(child) || !OfficeReader.isTextElement(child)) break;
                    nCount += OfficeReader.getCharacterCount(child);
                }
            }
            child = child.getNextSibling();
        }
        return nCount;
    }

    public String getTextContent(Node node) {
        String s = "";
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                s = s + this.getTextContent(child);
            } else if (child.getNodeType() == 3) {
                s = s + child.getNodeValue();
            }
            child = child.getNextSibling();
        }
        return s;
    }

    public boolean isPackageFormat() {
        return this.oooDoc.isPackageFormat();
    }

    public boolean isInPackage(String sUrl) {
        if (!this.bOpenDocument && sUrl.startsWith("#")) {
            return true;
        }
        if (sUrl.startsWith("./")) {
            sUrl = sUrl.substring(2);
        }
        return this.oooDoc.getEmbeddedObject(sUrl) != null;
    }

    public OfficeStyleFamily getFontDeclarations() {
        return this.font;
    }

    public FontDeclaration getFontDeclaration(String sName) {
        return (FontDeclaration)this.font.getStyle(sName);
    }

    public OfficeStyleFamily getTextStyles() {
        return this.text;
    }

    public StyleWithProperties getTextStyle(String sName) {
        return (StyleWithProperties)this.text.getStyle(sName);
    }

    public OfficeStyleFamily getParStyles() {
        return this.par;
    }

    public StyleWithProperties getParStyle(String sName) {
        return (StyleWithProperties)this.par.getStyle(sName);
    }

    public StyleWithProperties getDefaultParStyle() {
        return (StyleWithProperties)this.par.getDefaultStyle();
    }

    public OfficeStyleFamily getSectionStyles() {
        return this.section;
    }

    public StyleWithProperties getSectionStyle(String sName) {
        return (StyleWithProperties)this.section.getStyle(sName);
    }

    public OfficeStyleFamily getTableStyles() {
        return this.table;
    }

    public StyleWithProperties getTableStyle(String sName) {
        return (StyleWithProperties)this.table.getStyle(sName);
    }

    public OfficeStyleFamily getColumnStyles() {
        return this.column;
    }

    public StyleWithProperties getColumnStyle(String sName) {
        return (StyleWithProperties)this.column.getStyle(sName);
    }

    public OfficeStyleFamily getRowStyles() {
        return this.row;
    }

    public StyleWithProperties getRowStyle(String sName) {
        return (StyleWithProperties)this.row.getStyle(sName);
    }

    public OfficeStyleFamily getCellStyles() {
        return this.cell;
    }

    public StyleWithProperties getCellStyle(String sName) {
        return (StyleWithProperties)this.cell.getStyle(sName);
    }

    public StyleWithProperties getDefaultCellStyle() {
        return (StyleWithProperties)this.cell.getDefaultStyle();
    }

    public OfficeStyleFamily getFrameStyles() {
        return this.frame;
    }

    public StyleWithProperties getFrameStyle(String sName) {
        return (StyleWithProperties)this.frame.getStyle(sName);
    }

    public StyleWithProperties getDefaultFrameStyle() {
        return (StyleWithProperties)this.frame.getDefaultStyle();
    }

    public OfficeStyleFamily getPresentationStyles() {
        return this.presentation;
    }

    public StyleWithProperties getPresentationStyle(String sName) {
        return (StyleWithProperties)this.presentation.getStyle(sName);
    }

    public StyleWithProperties getDefaultPresentationStyle() {
        return (StyleWithProperties)this.presentation.getDefaultStyle();
    }

    public OfficeStyleFamily getDrawingPageStyles() {
        return this.drawingPage;
    }

    public StyleWithProperties getDrawingPageStyle(String sName) {
        return (StyleWithProperties)this.drawingPage.getStyle(sName);
    }

    public StyleWithProperties getDefaultDrawingPageStyle() {
        return (StyleWithProperties)this.drawingPage.getDefaultStyle();
    }

    public OfficeStyleFamily getListStyles() {
        return this.list;
    }

    public ListStyle getListStyle(String sName) {
        return (ListStyle)this.list.getStyle(sName);
    }

    public OfficeStyleFamily getPageLayouts() {
        return this.pageLayout;
    }

    public PageLayout getPageLayout(String sName) {
        return (PageLayout)this.pageLayout.getStyle(sName);
    }

    public OfficeStyleFamily getMasterPages() {
        return this.masterPage;
    }

    public MasterPage getMasterPage(String sName) {
        return (MasterPage)this.masterPage.getStyle(sName);
    }

    public ListStyle getOutlineStyle() {
        return this.outline;
    }

    public PropertySet getFootnotesConfiguration() {
        return this.footnotes;
    }

    public PropertySet getEndnotesConfiguration() {
        return this.endnotes;
    }

    public StyleWithProperties getHeadingStyle(int nLevel) {
        return 1 <= nLevel && nLevel <= 10 ? this.heading[nLevel] : null;
    }

    public MasterPage getFirstMasterPage() {
        return this.firstMasterPage;
    }

    public TocReader getTocReader(Element onode) {
        if (this.indexes.containsKey(onode)) {
            return (TocReader)this.indexes.get(onode);
        }
        return null;
    }

    public boolean isIndexSourceStyle(String sStyleName) {
        return this.indexSourceStyles.contains(sStyleName);
    }

    public boolean isFigureSequenceName(String sName) {
        return this.figureSequenceNames.contains(sName);
    }

    public boolean isTableSequenceName(String sName) {
        return this.tableSequenceNames.contains(sName);
    }

    public void addTableSequenceName(String sName) {
        this.tableSequenceNames.add(sName);
    }

    public void addFigureSequenceName(String sName) {
        this.figureSequenceNames.add(sName);
    }

    public String getSequenceName(Element par) {
        return this.sequenceNames.containsKey(par) ? (String)this.sequenceNames.get(par) : null;
    }

    public String getSequenceFromRef(String sRefName) {
        return (String)this.seqrefNames.get(sRefName);
    }

    public boolean hasFootnoteRefTo(String sId) {
        return this.footnoteRef.contains(sId);
    }

    public boolean hasEndnoteRefTo(String sId) {
        return this.endnoteRef.contains(sId);
    }

    public boolean hasReferenceRefTo(String sName) {
        return this.referenceRef.contains(sName);
    }

    public boolean hasBookmarkRefTo(String sName) {
        return this.bookmarkRef.contains(sName);
    }

    public boolean hasSequenceRefTo(String sId) {
        return this.sequenceRef.contains(sId);
    }

    public boolean hasLinkTo(String sName) {
        return this.links.contains(sName);
    }

    public boolean isOpenDocument() {
        return this.bOpenDocument;
    }

    public boolean isText() {
        return this.bText;
    }

    public boolean isSpreadsheet() {
        return this.bSpreadsheet;
    }

    public boolean isPresentation() {
        return this.bPresentation;
    }

    public Element getContent() {
        return this.content;
    }

    public FormsReader getForms() {
        return this.forms;
    }

    public TableReader getTableReader(Element node) {
        return new TableReader(this, node);
    }

    public OfficeReader(OfficeDocument oooDoc, boolean bAllParagraphsAreSoft) {
        this.oooDoc = oooDoc;
        this.loadStylesFromDOM(oooDoc.getStyleDOM(), oooDoc.getContentDOM(), bAllParagraphsAreSoft);
        this.loadContentFromDOM(oooDoc.getContentDOM());
    }

    private void loadStylesFromDOM(Node node, boolean bAllParagraphsAreSoft) {
        boolean bAutomatic = "office:automatic-styles".equals(node.getNodeName());
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = nl.item(i);
                if (child.getNodeType() == 1) {
                    String sFamily;
                    if (child.getNodeName().equals("style:style")) {
                        sFamily = Misc.getAttribute(child, "style:family");
                        if ("text".equals(sFamily)) {
                            this.text.loadStyleFromDOM(child, bAutomatic);
                        } else if ("paragraph".equals(sFamily)) {
                            this.par.loadStyleFromDOM(child, bAutomatic && !bAllParagraphsAreSoft);
                        } else if ("section".equals(sFamily)) {
                            this.section.loadStyleFromDOM(child, bAutomatic);
                        } else if ("table".equals(sFamily)) {
                            this.table.loadStyleFromDOM(child, bAutomatic);
                        } else if ("table-column".equals(sFamily)) {
                            this.column.loadStyleFromDOM(child, bAutomatic);
                        } else if ("table-row".equals(sFamily)) {
                            this.row.loadStyleFromDOM(child, bAutomatic);
                        } else if ("table-cell".equals(sFamily)) {
                            this.cell.loadStyleFromDOM(child, bAutomatic);
                        } else if ("graphics".equals(sFamily)) {
                            this.frame.loadStyleFromDOM(child, bAutomatic);
                        } else if ("graphic".equals(sFamily)) {
                            this.frame.loadStyleFromDOM(child, bAutomatic);
                        } else if ("presentation".equals(sFamily)) {
                            this.presentation.loadStyleFromDOM(child, bAutomatic);
                        } else if ("drawing-page".equals(sFamily) && this.drawingPage.getStyle(Misc.getAttribute(child, "style:name")) == null) {
                            this.drawingPage.loadStyleFromDOM(child, bAutomatic);
                        }
                    } else if (child.getNodeName().equals("style:page-master")) {
                        this.pageLayout.loadStyleFromDOM(child, bAutomatic);
                    } else if (child.getNodeName().equals("style:page-layout")) {
                        this.pageLayout.loadStyleFromDOM(child, bAutomatic);
                    } else if (child.getNodeName().equals("style:master-page")) {
                        this.masterPage.loadStyleFromDOM(child, bAutomatic);
                        if (this.firstMasterPage == null) {
                            this.firstMasterPage = (MasterPage)this.masterPage.getStyle(Misc.getAttribute(child, "style:name"));
                        }
                    } else if (child.getNodeName().equals("text:list-style")) {
                        this.list.loadStyleFromDOM(child, bAutomatic);
                    } else if (child.getNodeName().equals("text:outline-style")) {
                        this.outline.loadStyleFromDOM(child);
                    } else if (child.getNodeName().equals("style:default-style")) {
                        sFamily = Misc.getAttribute(child, "style:family");
                        if ("paragraph".equals(sFamily)) {
                            StyleWithProperties defaultPar = new StyleWithProperties();
                            defaultPar.loadStyleFromDOM(child);
                            this.par.setDefaultStyle(defaultPar);
                        } else if ("graphics".equals(sFamily) || "graphic".equals(sFamily)) {
                            StyleWithProperties defaultFrame = new StyleWithProperties();
                            defaultFrame.loadStyleFromDOM(child);
                            this.frame.setDefaultStyle(defaultFrame);
                        } else if ("table-cell".equals(sFamily)) {
                            StyleWithProperties defaultCell = new StyleWithProperties();
                            defaultCell.loadStyleFromDOM(child);
                            this.cell.setDefaultStyle(defaultCell);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void loadStylesFromDOM(Document stylesDOM, Document contentDOM, boolean bAllParagraphsAreSoft) {
        Node node;
        NodeList list = stylesDOM == null ? contentDOM.getElementsByTagName("office:font-decls") : stylesDOM.getElementsByTagName("office:font-decls");
        if (list.getLength() == 0) {
            list = stylesDOM == null ? contentDOM.getElementsByTagName("office:font-face-decls") : stylesDOM.getElementsByTagName("office:font-face-decls");
        }
        if (list.getLength() != 0 && (node = list.item(0)).hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = nl.item(i);
                if (child.getNodeType() == 1) {
                    if (child.getNodeName().equals("style:font-decl")) {
                        this.font.loadStyleFromDOM(child, false);
                    } else if (child.getNodeName().equals("style:font-face")) {
                        this.font.loadStyleFromDOM(child, false);
                    }
                }
                ++i;
            }
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("office:styles") : stylesDOM.getElementsByTagName("office:styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("office:master-styles") : stylesDOM.getElementsByTagName("office:master-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if (stylesDOM != null && (list = stylesDOM.getElementsByTagName("office:automatic-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = contentDOM.getElementsByTagName("office:automatic-styles")).getLength() != 0) {
            this.loadStylesFromDOM(list.item(0), bAllParagraphsAreSoft);
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("text:footnotes-configuration") : stylesDOM.getElementsByTagName("text:footnotes-configuration")).getLength() != 0) {
            this.footnotes = new PropertySet();
            this.footnotes.loadFromDOM(list.item(0));
        }
        if ((list = stylesDOM == null ? contentDOM.getElementsByTagName("text:endnotes-configuration") : stylesDOM.getElementsByTagName("text:endnotes-configuration")).getLength() != 0) {
            this.endnotes = new PropertySet();
            this.endnotes.loadFromDOM(list.item(0));
        }
        if (this.footnotes == null || this.endnotes == null) {
            list = stylesDOM == null ? contentDOM.getElementsByTagName("text:notes-configuration") : stylesDOM.getElementsByTagName("text:notes-configuration");
            int nLen = list.getLength();
            int i = 0;
            while (i < nLen) {
                String sClass = Misc.getAttribute(list.item(i), "text:note-class");
                if ("endnote".equals(sClass)) {
                    this.endnotes = new PropertySet();
                    this.endnotes.loadFromDOM(list.item(i));
                } else {
                    this.footnotes = new PropertySet();
                    this.footnotes.loadFromDOM(list.item(i));
                }
                ++i;
            }
        }
    }

    private void loadContentFromDOM(Document contentDOM) {
        NodeList list = contentDOM.getElementsByTagName("office:body");
        if (list.getLength() > 0) {
            Element body = (Element)list.item(0);
            this.content = Misc.getChildByTagName(body, "office:text");
            if (this.content != null) {
                this.bOpenDocument = true;
                this.bText = true;
            } else {
                this.content = Misc.getChildByTagName(body, "office:spreadsheet");
                if (this.content != null) {
                    this.bOpenDocument = true;
                    this.bSpreadsheet = true;
                } else {
                    this.content = Misc.getChildByTagName(body, "office:presentation");
                    if (this.content != null) {
                        this.bOpenDocument = true;
                        this.bPresentation = true;
                    } else {
                        this.content = body;
                        this.bSpreadsheet = true;
                        this.bPresentation = false;
                        Node child = body.getFirstChild();
                        while (child != null) {
                            if (child.getNodeType() == 1) {
                                String sName = child.getNodeName();
                                if ("text:p".equals(sName)) {
                                    this.bSpreadsheet = false;
                                } else if ("text:h".equals(sName)) {
                                    this.bSpreadsheet = false;
                                } else if ("text:ordered-list".equals(sName)) {
                                    this.bSpreadsheet = false;
                                } else if ("text:ordered-list".equals(sName)) {
                                    this.bSpreadsheet = false;
                                } else if ("text:section".equals(sName)) {
                                    this.bSpreadsheet = false;
                                } else if ("draw:page".equals(sName)) {
                                    this.bPresentation = true;
                                    this.bSpreadsheet = false;
                                } else if ("draw:page".equals(sName)) {
                                    this.bSpreadsheet = false;
                                }
                            }
                            child = child.getNextSibling();
                        }
                        this.bText = !this.bSpreadsheet && !this.bPresentation;
                    }
                }
            }
            this.traverseContent(body);
            if (this.sAutoFigureSequenceName != null) {
                this.addFigureSequenceName(this.sAutoFigureSequenceName);
            }
            if (this.sAutoTableSequenceName != null) {
                this.addTableSequenceName(this.sAutoTableSequenceName);
            }
        }
    }

    private Element getParagraph(Element node) {
        Element parent = (Element)node.getParentNode();
        if (parent.getTagName().equals("text:p") || parent.getTagName().equals("text:h")) {
            return parent;
        }
        return this.getParagraph(parent);
    }

    private void traverseContent(Element node) {
        String sName = node.getTagName();
        if (!sName.equals("text:p")) {
            if (sName.equals("text:h")) {
                int nLevel = Misc.getPosInteger(node.getAttribute("text:level"), 1);
                StyleWithProperties style = this.getParStyle(node.getAttribute("text:style-name"));
                if (1 <= nLevel && nLevel <= 10 && this.heading[nLevel] == null) {
                    this.heading[nLevel] = style != null && style.isAutomatic() ? this.getParStyle(style.getParentName()) : null;
                }
            } else if (sName.equals("text:sequence")) {
                String sSeqName = Misc.getAttribute(node, "text:name");
                String sRefName = Misc.getAttribute(node, "text:ref-name");
                if (sSeqName != null) {
                    Element par = this.getParagraph(node);
                    if (!this.sequenceNames.containsKey(par)) {
                        this.sequenceNames.put(par, sSeqName);
                    }
                    if (sRefName != null) {
                        this.seqrefNames.put(sRefName, sSeqName);
                    }
                }
            } else if (sName.equals("text:footnote-ref")) {
                this.collectRefName(this.footnoteRef, node);
            } else if (sName.equals("text:endnote-ref")) {
                this.collectRefName(this.endnoteRef, node);
            } else if (sName.equals("text:note-ref")) {
                String sClass = Misc.getAttribute(node, "text:note-class");
                if ("footnote".equals(sClass)) {
                    this.collectRefName(this.footnoteRef, node);
                } else if ("endnote".equals(sClass)) {
                    this.collectRefName(this.endnoteRef, node);
                }
            } else if (sName.equals("text:reference-ref")) {
                this.collectRefName(this.referenceRef, node);
            } else if (sName.equals("text:bookmark-ref")) {
                this.collectRefName(this.bookmarkRef, node);
            } else if (sName.equals("text:sequence-ref")) {
                this.collectRefName(this.sequenceRef, node);
            } else if (sName.equals("text:a")) {
                String sHref = node.getAttribute("xlink:href");
                if (sHref != null && sHref.startsWith("#")) {
                    this.links.add(sHref.substring(1));
                }
            } else if (sName.equals("office:forms")) {
                this.forms.read(node);
            } else if (sName.equals("text:table-of-content")) {
                TocReader tocReader = new TocReader(node);
                this.indexes.put(node, tocReader);
                this.indexSourceStyles.addAll(tocReader.getIndexSourceStyles());
            } else if (sName.equals("text:table-index") || sName.equals("text:illustration-index")) {
                LoftReader loftReader = new LoftReader(node);
                this.indexes.put(node, loftReader);
                if (loftReader.useCaption()) {
                    if (loftReader.isTableIndex()) {
                        this.tableSequenceNames.add(loftReader.getCaptionSequenceName());
                    } else {
                        this.figureSequenceNames.add(loftReader.getCaptionSequenceName());
                    }
                }
            }
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                this.traverseContent((Element)child);
            }
            child = child.getNextSibling();
        }
        if ((this.sAutoFigureSequenceName == null || this.sAutoTableSequenceName == null) && sName.equals("text:p")) {
            String sStyleName = this.getParStyles().getDisplayName(node.getAttribute("text:style-name"));
            if (this.sAutoFigureSequenceName == null && "Illustration".equals(sStyleName)) {
                this.sAutoFigureSequenceName = this.getSequenceName(node);
            }
            if (this.sAutoTableSequenceName == null && "Table".equals(sStyleName)) {
                this.sAutoTableSequenceName = this.getSequenceName(node);
            }
        }
    }

    private void collectRefName(HashSet ref, Element node) {
        String sRefName = node.getAttribute("text:ref-name");
        if (sRefName != null && sRefName.length() > 0) {
            ref.add(sRefName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

