/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "propertypanel.h"

#include <QLayout>
#include <QLabel>
#include <QLineEdit>
#include <QFrame>

using namespace WebIssues;

PropertyPanel::PropertyPanel( QWidget* parent ) : QWidget( parent )
{
    m_layout = new QGridLayout( this );
    m_layout->setAlignment( Qt::AlignTop );
    m_layout->setColumnStretch( 1, 1 );
}

PropertyPanel::~PropertyPanel()
{
}

void PropertyPanel::clear()
{
    QList<QWidget*> widgets = findChildren<QWidget*>();
    for ( int i = 0; i < widgets.count(); i++ )
        delete widgets.at( i );

    m_labelMap.clear();
}

void PropertyPanel::addProperty( const QString& key, const QString& name )
{
    int row = m_layout->rowCount();

    QLabel* label = new QLabel( name, this );
    m_layout->addWidget( label, row, 0 );

    QLabel* valueLabel = new QLabel( this );
    m_layout->addWidget( valueLabel, row, 1 );

    if ( isVisible() ) {
        label->show();
        valueLabel->show();
    }

    m_labelMap.insert( key, valueLabel );
}

void PropertyPanel::addSeparator()
{
    int row = m_layout->rowCount();

    QFrame* separator = new QFrame( this );
    separator->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    m_layout->addWidget( separator, row, 0, 1, 2 );

    if ( isVisible() )
        separator->show();
}

void PropertyPanel::clearValues()
{
    QList<QLabel*> labels = m_labelMap.values();
    for ( int i = 0; i < labels.count(); i++ )
        labels.at( i )->clear();
}

void PropertyPanel::setValue( const QString& key, const QString& value )
{
    m_labelMap.value( key )->setText( value );
}

void PropertyPanel::setInnerMargin( int margin )
{
    m_layout->setMargin( margin );
}

#include "propertypanel.moc"
