/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>

class QCheckBox;
class QComboBox;
class QSpinBox;

namespace WebIssues
{

/**
* Dialog for modifying application settings.
*/
class SettingsDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    SettingsDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~SettingsDialog();

public: // overrides
    void accept();

private slots:
    void apply();

    void dockChanged();

private:
    QCheckBox* m_dockCheckBox;
    QComboBox* m_showComboBox;
    QComboBox* m_reconnectComboBox;

    QSpinBox* m_intervalSpin;
    QComboBox* m_actionComboBox;
    QSpinBox* m_cacheSpin;
    QSpinBox* m_warnSpin;

#if defined( Q_WS_WIN )
    QCheckBox* m_autoStartCheckBox;
#endif
};

}

#endif
