/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef DEFINITIONPARSER_H
#define DEFINITIONPARSER_H

#include <QRegExp>

#include "definitioninfo.h"

namespace WebIssues
{

/**
* Attribute definition parser.
*
* This class converts an attribute definition string according to the WebIssues protocol
* to a DefinitionInfo value.
*
* @see DefinitionBuilder
*/
class DefinitionParser
{
public:
    /**
    * Default constructor.
    */
    DefinitionParser();

    /**
    * Destructor.
    */
    ~DefinitionParser();

public:
    /**
    * Parse attribute definition.
    *
    * @param definition Attribute definition string to parse.
    *
    * @return Parsed definition or an invalid definition if the string cannot be parsed.
    */
    DefinitionInfo parse( const QString& definition );

private:
    DefinitionInfo::Type parseType( const QString& value );

    QStringList parseStringArray( const QString& value );
    QString parseString( const QString& value );

private:
    QRegExp m_string;
    QRegExp m_attribute;

    QMap<QString, DefinitionInfo::Type> m_types;
};

}

#endif
