// ==UserScript==
// @include        https://mail.google.com/*
// @require        utils.js
// @require        google-common.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);
var pane = null;

function isCorrectPage() {
    var i, ids = ['hist_frame', 'js_frame'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function getNumber(str) {
    try {
        var onlyNumber = str.match(/\(([0-9]|,)+\)/)[0].match(/([0-9]|,)+/)[0];

        return onlyNumber.replace(/,/g, "");
    } catch (x) {
        return '0';
    }
}

function getLabels() {
    var i, res = [];

    var snapshot = document.evaluate('//div[2]/div/div/div[5]/div/*/div/div/div[2]/span/a',
                                     pane, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);

    for (i = 0; i < snapshot.snapshotLength; i++) {
        var node = snapshot.snapshotItem(i);

        res.push({ name: node.textContent.match(/^[^(]+/)[0],
                   count: getNumber(node.textContent),
                   link: node.href });
    }

    return res;
}

function doMatrixIntegration() {
    doMainMenuIntegration(document);

    var i, labels = getLabels();
    for (i = 0; i < labels.length; i++) {
        Unity.addAction('/' + labels[i].name, makeRedirector(labels[i].link));
    }
}

function checkMessangesCount() {
    var tag = document.evaluate('//div[@aria-label="Navigate to"]/span', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;

    if (tag.textContent != 'Gmail') {
        return;
    }

    var inboxLink = document.evaluate('//div[@role="navigation"]/div/div/div/div/div/div/div/div/div/span/a', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
    var numMessanges = getNumber(inboxLink.text);

    var indicators = [];
    indicators.push({ name: _("Inbox"),
		      count: numMessanges,
		      callback: makeRedirector(inboxLink.href) });
    var i, labels = getLabels();
    for (i = 0; i < labels.length; i++) {
	indicators.push({ name: labels[i].name, count: labels[i].count, callback: makeRedirector(labels[i].link) });
    }
    showIndicators(indicators);
    Unity.Launcher.setCount(Number(numMessanges));
}


function unityLoaded() {
    var composeNewMessage = wrapCallback(function () {
        var compose = document.evaluate('//div[@role="navigation"]/div[1]/div[1]/div[1][@role="button"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;

        click(compose);
    });

    Unity.MessagingIndicator.addAction(_("Compose New Message"),
                                       composeNewMessage);
    Unity.Launcher.addAction(_("Compose New Message"),
			     composeNewMessage);

    setInterval(wrapCallback(checkMessangesCount), 2000);
    checkMessangesCount();

    doMatrixIntegration();
}

if (isCorrectPage()) {
    setTimeout(wrapCallback(function wait() {
        pane = document.evaluate('//div[@role="navigation"]',
				 document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;

        if (!pane || !document.getElementsByClassName("nU")) {
            setTimeout(wait, 1000);
            return;
        }
	try {
            var gmaillogin = document.evaluate('//div[@role="navigation"]/div/div[1]/div[3]/div/ol/li[4]/div/div/div/div[2]/span[2]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.textContent;
        } catch(err) {
	    var gmaillogin = "";
	}
				
	try {
	    var gappslogin = document.evaluate('//div[@role=navigation]/div/div[1]/div[3]/div/ol/li[4]/div/div/div/div[3]/span[2]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.textContent;
	}catch(err) {
	    var gappslogin = "";
	}
	login = gmaillogin.indexOf("@") != -1 ? gmaillogin : gappslogin.indexOf("@") != -1 ? gappslogin : "";

        Unity.init({ name: "GMail",
                     login: login,
		     iconUrl: "icon://unity-webapps-gmail",
		     homepage: 'https://mail.google.com',
		     domain: 'mail.google.com',
                     onInit: wrapCallback(unityLoaded) });
    }), 2000);
}
