function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (this._state === 0) {
            setTimeout(function () {
                this._browser.invokeCallback('Unity.MediaPlayer.onNext');
                setTimeout(function () {
                    this._browser.finish();
                }.bind(this), 3000);
            }.bind(this), 3000);
        }

        this._state++;
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Unity.MediaPlayer.init', log[1].func, 'Unity.MediaPlayer.init');
        assertEquals('Unity.MediaPlayer.setTrack', log[6].func, 'Unity.MediaPlayer.setTrack');

        var titles = {}, i;
        for (i = 0; i < log.length; i++) {
            if (log[i].func === 'Unity.MediaPlayer.setTrack') {
              var title = log[i].args[0].title;
              if (title && title.length !== 0)
                titles[log[i].args[0].title] = 1;
            }
        }

        var count = 0;
        for (i in titles) {
            if (titles.hasOwnProperty(i)) {
                count++;
            }
        }
        assertEquals('Unity.MediaPlayer.setTrack', count, 2);
    },

    scriptName: 'LibreFm/LibreFm.user.js'
};
