/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* dav.sql */

static const char *proc0 = 
"create procedure WS.WS.\"OPTIONS\" (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"http_header (concat (\'Content-Type: text/plain\\r\\n\',\n"
"\'Allow: OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPFIND, PROPPATCH, COPY, MOVE, LOCK, UNLOCK\\r\\n\',\n"
"\'DAV: 1,2,<http://www.openlinksw.com/virtuoso/webdav/1.0>\\r\\n\',\n"
"\'MS-Author-Via: DAV\\r\\n\'));\n"
"}\n"
"--src dav.sql:25\n";

static const char *proc1 = 
"create procedure WS.WS.PROPFIND (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare _mod_time datetime;\n"
"declare _cr_time datetime;\n"
"declare _depth integer;\n"
"declare st, _temp varchar;\n"
"declare _ms_date integer;\n"
"declare _lpath, _body, _ses, _props, _ppath, _perms varchar;\n"
"declare uname, upwd varchar;\n"
"declare id any;\n"
"declare _u_id, _g_id, rc integer;\n"
"\n"
"_ses := aref_set_0 (params, 1);\n"
"_body := string_output_string (_ses);\n"
"\n"
"_lpath := http_path ();\n"
"_ppath := http_physical_path ();\n"
"if (_lpath = \'\')\n"
"_lpath := \'/\';\n"
"\n"
"\n"
"\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"st := \'C\';\n"
"else\n"
"{\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"if (id is not null)\n"
"st := \'R\';\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return;\n"
"}\n"
"}\n"
"_u_id := null;\n"
"_g_id := null;\n"
"if (st = \'C\')\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (id, st, \'1__\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (DAV_GET_PARENT (id, st, _ppath), \'C\', \'1__\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"}\n"
"\n"
"if (rc < 0)\n"
"{\n"
"if ((rc = -12) or (rc = -13))\n"
"{\n"
"http_request_status (\'HTTP/1.1 403 Forbidden\');\n"
"return;\n"
"}\n"
"return;\n"
"}\n"
"if (strstr (WS.WS.FINDPARAM (lines, \'User-Agent:\'), \'Microsoft\') is not null)\n"
"_ms_date := 1;\n"
"else\n"
"_ms_date := 0;\n"
"\n"
"_temp := WS.WS.FINDPARAM (lines, \'Depth:\');\n"
"if (_temp <> \'\' and _temp <> \'infinity\')\n"
"_depth := atoi (_temp);\n"
"else\n"
"_depth := -1;\n"
"\n"
"{\n"
"declare test_tree any;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"http_request_status (\'HTTP/1.1 400 Bad Request\');\n"
"return;\n"
"};\n"
"if (length (_body) > 0)\n"
"test_tree := xml_tree (_body);\n"
"}\n"
"\n"
"if (st = \'C\' and aref (_lpath, length (_lpath) - 1) <> ascii (\'/\'))\n"
"_lpath := concat (_lpath, \'/\');\n"
"\n"
"\n"
"_props := WS.WS.PROPNAMES (_body);\n"
"if (isarray (_props) and length (_props) = 1 and\n"
"(aref (_props, 0) = \'propname\'))\n"
"{\n"
"WS.WS.CUSTOM_PROP (_lpath, _props, _depth, st);\n"
"return;\n"
"}\n"
"\n"
"\n"
"http_request_status (\'HTTP/1.1 207 Multi-Status\');\n"
"http_header (\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\\n\');\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\" xmlns:M=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\">\\n\');\n"
"if (-13 = WS.WS.PROPFIND_RESPONSE (_lpath, _ppath, _depth, st, _ms_date, _props, _u_id))\n"
"{\n"
"_u_id := null;\n"
"_g_id := null;\n"
"\n"
"http_rewrite ();\n"
"WS.WS.GET_DAV_AUTH (lines, 0, 1, uname, upwd, _u_id, _g_id, _perms);\n"
"return;\n"
"}\n"
"http (\'</D:multistatus>\\n\');\n"
"}\n"
"--src dav.sql:34\n";

static const char *proc2 = 
"create function WS.WS.PROPFIND_RESPONSE (in lpath varchar,\n"
"in ppath varchar,\n"
"in depth integer,\n"
"in st char (1),\n"
"in ms_date integer,\n"
"in propnames any,\n"
"in u_id integer) returns integer\n"
"{\n"
"declare all_prop, ppath_len integer;\n"
"declare dirlist any;\n"
"declare add_not_found, _this_col integer;\n"
"\n"
"\n"
"all_prop := 0;\n"
"add_not_found := 1;\n"
"\n"
"if (not isstring (lpath) or not isstring (ppath))\n"
"return -28;\n"
"\n"
"if (st = \'C\' and aref (ppath, length (ppath) - 1) <> ascii (\'/\'))\n"
"ppath := concat (ppath, \'/\');\n"
"ppath_len := length (ppath);\n"
"\n"
"if (not isarray (propnames))\n"
"{\n"
"if (ms_date)\n"
"{\n"
"propnames := vector (\':getlastmodified\', \':creationdate\',\n"
"\':lastaccessed\', \':getcontentlength\', \':resourcetype\', \':supportedlock\');\n"
"add_not_found := 0;\n"
"}\n"
"else\n"
"propnames := vector (\':getlastmodified\', \':getcontentlength\', \':resourcetype\');\n"
"}\n"
"else if (aref (propnames, 0) = \'allprop\')\n"
"{\n"
"propnames := vector (\':getlastmodified\', \':creationdate\', \':getetag\', \':getcontenttype\',\n"
"\':getcontentlength\', \':resourcetype\', \':lockdiscovery\', \':supportedlock\');\n"
"all_prop := 1;\n"
"}\n"
"\n"
"dirlist := DAV_DIR_LIST_INT (ppath, -1, \'%\', null, null, u_id);\n"
"if (isinteger (dirlist))\n"
"{\n"
"if (dirlist = -13)\n"
"{\n"
"if (u_id > 0)\n"
"dirlist := vector ();\n"
"else\n"
"return dirlist;\n"
"}\n"
"else\n"
"dirlist := vector ();\n"
"}\n"
"if (length (dirlist) = 0)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT (lpath, dirlist, 0, ms_date, propnames, all_prop, add_not_found, 0, u_id);\n"
"\n"
"\n"
"if (depth = 1 and st = \'C\')\n"
"{\n"
"dirlist := DAV_DIR_LIST_INT (ppath, 0, \'%\', null, null, u_id);\n"
"\n"
"if (isinteger (dirlist))\n"
"{\n"
"if (dirlist = -13)\n"
"{\n"
"if (u_id > 0)\n"
"dirlist := vector ();\n"
"else\n"
"return dirlist;\n"
"}\n"
"else\n"
"dirlist := vector ();\n"
"}\n"
"\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT (lpath, dirlist, 1, ms_date, propnames, all_prop, add_not_found, 0, u_id);\n"
"}\n"
"else if (((depth = -1) or (depth > 1)) and (st = \'C\'))\n"
"{\n"
"dirlist := DAV_DIR_LIST_INT (ppath, 0, \'%\', null, null, u_id);\n"
"if (isinteger (dirlist))\n"
"{\n"
"if (dirlist = -13)\n"
"{\n"
"if (u_id > 0)\n"
"dirlist := vector ();\n"
"else\n"
"return dirlist;\n"
"}\n"
"else\n"
"dirlist := vector ();\n"
"}\n"
"WS.WS.PROPFIND_RESPONSE_FORMAT (lpath, dirlist, case (depth) when -1 then -1 else depth-1 end, ms_date, propnames, all_prop, add_not_found, 1, u_id);\n"
"foreach (any itm in dirlist) do\n"
"{\n"
"if (\'C\' = itm[1])\n"
"{\n"
"if (-13 = WS.WS.PROPFIND_RESPONSE (lpath || itm[10] || \'/\', ppath || itm[10] || \'/\', -1, \'C\', ms_date, propnames, u_id))\n"
"return -13;\n"
"}\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav.sql:145\n";

static const char *proc3 = 
"create procedure WS.WS.PROPFIND_RESPONSE_FORMAT (in lpath varchar,\n"
"in dirlist any,\n"
"in append_name_to_href integer,\n"
"in ms_date integer,\n"
"in propnames any,\n"
"in all_prop integer,\n"
"in add_not_found integer,\n"
"in resources_only integer,\n"
"in _u_id integer)\n"
"{\n"
"declare dir_len, dir_ctr, ix, len, dt_flag, iso_dt_flag, res_len, parent_col, id, found_cprop, found_sprop, mix integer;\n"
"declare crt, modt datetime;\n"
"declare name, mime_type, prop, prop1, dt_ms, mis_prop varchar;\n"
"declare st char(1);\n"
"declare diritm, prop_raw_val, prop_val, href any;\n"
"declare perms, uid, gid any;\n"
"\n"
"\n"
"if (ms_date)\n"
"{\n"
"dt_flag := 1;\n"
"iso_dt_flag := 1;\n"
"dt_ms := \' M:dt=\"dateTime.rfc1123\"\';\n"
"}\n"
"else\n"
"{\n"
"dt_flag := 1;\n"
"iso_dt_flag := 0;\n"
"dt_ms := \'\';\n"
"}\n"
"\n"
"dir_ctr := 0;\n"
"dir_len := length (dirlist);\n"
"\n"
"next_response:\n"
"if (dir_ctr >= dir_len)\n"
"return;\n"
"diritm := dirlist[dir_ctr];\n"
"\n"
"st := diritm[1];\n"
"if ((\'R\' <> st) and resources_only)\n"
"{\n"
"dir_ctr := dir_ctr + 1;\n"
"goto next_response;\n"
"}\n"
"res_len := diritm[2];\n"
"modt := diritm[3];\n"
"id := diritm[4];\n"
"crt := diritm[8];\n"
"mime_type := diritm[9];\n"
"name := diritm[10];\n"
"perms := diritm[5];\n"
"uid := diritm[7];\n"
"gid := diritm[6];\n"
"\n"
"found_sprop := 0;\n"
"mis_prop := \'\';\n"
"mix := 0;\n"
"\n"
"if (__tag (crt) <> 211)\n"
"crt := now ();\n"
"if (__tag (modt) <> 211)\n"
"modt := now ();\n"
"\n"
"href := case append_name_to_href when 0 then lpath else DAV_CONCAT_PATH (lpath, name) end;\n"
"if (st = \'C\' and href not like \'%/\')\n"
"href := href || \'/\';\n"
"http (\'<D:response xmlns:lp0=\"DAV:\" xmlns:i0=\"DAV:\" xmlns:V=\"http://www.openlinksw.com/virtuoso/webdav/1.0/\">\\n\');\n"
"http (\'<D:href>\');\n"
"http_dav_url (\n"
"charset_recode (\n"
"href,\n"
"null, \'UTF-8\' ) );\n"
"http (\'</D:href>\\n\');\n"
"http (\'<D:propstat>\\n\');\n"
"http (\'<D:prop>\\n\');\n"
"ix := 0;\n"
"len := length (propnames);\n"
"while (ix < len)\n"
"{\n"
"prop := aref (propnames, ix);\n"
"\n"
"if (prop = \':getlastmodified\')\n"
"{\n"
"http (concat(sprintf (\'<lp0:getlastmodified%s>\', dt_ms), soap_print_box (modt, \'\', dt_flag) , \'</lp0:getlastmodified>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':creationdate\')\n"
"{\n"
"http (concat(sprintf (\'<lp0:creationdate%s>\', dt_ms), soap_print_box (crt, \'\', iso_dt_flag) , \'</lp0:creationdate>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':lastaccessed\')\n"
"{\n"
"http (concat(sprintf (\'<D:lastaccessed%s>\', dt_ms), soap_print_box (modt, \'\', dt_flag) , \'</D:lastaccessed>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':getetag\' and st = \'R\')\n"
"{\n"
"http (concat(\'<lp0:getetag>\"\', WS.WS.ETAG (name, parent_col), \'\"</lp0:getetag>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':getcontenttype\')\n"
"{\n"
"http (concat(\'<D:getcontenttype>\', mime_type, \'</D:getcontenttype>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':getcontentlength\' and st = \'R\')\n"
"{\n"
"http (concat (\'<lp0:getcontentlength>\', cast (res_len as varchar), \'</lp0:getcontentlength>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':resourcetype\')\n"
"{\n"
"if (st = \'C\')\n"
"http (\'<D:resourcetype><D:collection/></D:resourcetype>\\n\');\n"
"else\n"
"http (\'<D:resourcetype/>\\n\');\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':lockdiscovery\')\n"
"{\n"
"declare lock_ctr, locks_count integer;\n"
"declare locks any;\n"
"locks := DAV_LIST_LOCKS (id, st);\n"
"lock_ctr := 0;\n"
"locks_count := length (locks);\n"
"while (lock_ctr < locks_count)\n"
"{\n"
"declare lck any;\n"
"declare l_type, l_scope, l_token, l_oinfo varchar;\n"
"declare l_owner, l_timeout integer;\n"
"lck := locks[lock_ctr];\n"
"l_type := lck[0];\n"
"l_scope := lck[1];\n"
"l_token := lck[2];\n"
"l_timeout := lck[3];\n"
"l_owner := lck[4];\n"
"l_oinfo := coalesce (lck[5], \'\');\n"
"if (lock_ctr = 0)\n"
"http (\'<D:lockdiscovery>\');\n"
"http (\'<D:activelock>\\n\');\n"
"http (\'<D:locktype><D:write/></D:locktype>\\n\');\n"
"if (l_scope = \'X\')\n"
"http (\'<D:lockscope><D:exclusive/></D:lockscope>\\n\');\n"
"else\n"
"http (\'<D:lockscope><D:shared/></D:lockscope>\\n\');\n"
"http (\'<D:depth>infinity</D:depth>\\n\');\n"
"http (sprintf (\'%s<D:timeout>Second-%d</D:timeout>\\n\', l_oinfo, l_timeout));\n"
"http (sprintf (\'<D:locktoken><D:href>opaquelocktoken:%s</D:href></D:locktoken>\\n\', l_token));\n"
"http (\'</D:activelock>\\n\');\n"
"lock_ctr := lock_ctr + 1;\n"
"}\n"
"if (lock_ctr > 0)\n"
"http (\'</D:lockdiscovery>\\n\');\n"
"else\n"
"http (\'<D:lockdiscovery/>\\n\');\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':supportedlock\')\n"
"{\n"
"http (\'<D:supportedlock>\\n<D:lockentry>\\n<D:lockscope><D:exclusive/></D:lockscope>\\n<D:locktype><D:write/></D:locktype>\\n</D:lockentry>\\n<D:lockentry>\\n<D:lockscope><D:shared/></D:lockscope>\\n<D:locktype><D:write/></D:locktype>\\n</D:lockentry>\\n</D:supportedlock>\\n\');\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':virtpermissions\')\n"
"{\n"
"perms := trim (perms, \'\\r\\n \');\n"
"http (concat(\'<V:virtpermissions>\', perms, \'</V:virtpermissions>\\n\'));\n"
"found_sprop := 1;\n"
"}\n"
"else if (prop = \':virtowneruid\')\n"
"{\n"
"declare tmp varchar;\n"
"tmp := (select U_NAME from DB.DBA.SYS_USERS where U_ID = uid);\n"
"if (tmp is not null)\n"
"{\n"
"http (sprintf (\'<V:virtowneruid>%U</V:virtowneruid>\\n\', tmp));\n"
"found_sprop := 1;\n"
"}\n"
"else\n"
"{\n"
"mis_prop := concat (mis_prop, \'<V:virtowneruid />\\n\');\n"
"}\n"
"}\n"
"else if (prop = \':virtownergid\')\n"
"{\n"
"declare tmp varchar;\n"
"tmp := (select U_NAME from DB.DBA.SYS_USERS where U_ID = gid);\n"
"if (tmp is not null)\n"
"{\n"
"http (sprintf (\'<V:virtownergid>%U</V:virtownergid>\\n\', tmp));\n"
"found_sprop := 1;\n"
"}\n"
"else\n"
"{\n"
"mis_prop := concat (mis_prop, \'<V:virtownergid />\\n\');\n"
"}\n"
"}\n"
"else if (all_prop = 0)\n"
"{\n"
"if (aref (prop, 0) = ascii (\':\'))\n"
"prop1 := substring (prop, 2, length (prop));\n"
"else\n"
"prop1 := prop;\n"
"found_cprop := 0;\n"
"prop_raw_val := DAV_HIDE_ERROR (DAV_PROP_GET_INT (id, st, prop1, 0), null);\n"
"if (prop_raw_val is not null)\n"
"{\n"
"prop_val := deserialize (prop_raw_val);\n"
"if (isarray (prop_val))\n"
"{\n"
"prop_val := xml_tree_doc (prop_val);\n"
"if (xpath_eval (\'[xmlns:virt=\"virt\"] /virt:rdf\', prop_val) is null)\n"
"http_value (prop_val);\n"
"else\n"
"{\n"
"\n"
" ;\n"
"}\n"
"}\n"
"else if (isstring (prop_raw_val))\n"
"http (concat (\'<V:\',prop1,\'>\', prop_raw_val,\'</V:\', prop1,\'>\\n\'));\n"
"else\n"
"http (concat (\'<V:\',prop1,\'/>\\n\'));\n"
"\n"
"found_cprop := 1;\n"
"found_sprop := 1;\n"
"}\n"
"if (add_not_found and not found_cprop)\n"
"{\n"
"declare names, namep varchar;\n"
"declare colon any;\n"
"colon := strrchr (prop, \':\');\n"
"if (colon and colon > 0)\n"
"{\n"
"namep := substring (prop, colon + 1, length (prop));\n"
"names := substring (prop, 1, colon);\n"
"mix := mix + 1;\n"
"mis_prop := concat (mis_prop, sprintf (\'<i%d%s xmlns:i%d=\"%s\" />\\n\', mix, namep, mix, names));\n"
"}\n"
"else\n"
"mis_prop := concat (mis_prop, sprintf (\'<i0%s />\\n\', prop));\n"
"}\n"
"}\n"
"ix := ix + 1;\n"
"}\n"
"if (all_prop = 1)\n"
"{\n"
"declare props, prp any;\n"
"declare props_count, prop_idx integer;\n"
"props := DAV_PROP_LIST_INT (id, st, \'%\', 0);\n"
"props_count := length (props);\n"
"prop_idx := 0;\n"
"while (prop_idx < props_count)\n"
"{\n"
"prp := props[prop_idx];\n"
"prop1 := prp[0];\n"
"prop_raw_val := prp[1];\n"
"prop_val := deserialize (prop_raw_val);\n"
"if (isarray (prop_val))\n"
"{\n"
"prop_val := xml_tree_doc (prop_val);\n"
"if (xpath_eval (\'[xmlns:virt=\"virt\"] /virt:rdf\', prop_val) is null)\n"
"http_value (prop_val);\n"
"else\n"
"{\n"
"\n"
" ;\n"
"}\n"
"}\n"
"else if (isstring (prop_raw_val))\n"
"http (concat (\'<V:\',prop1,\'>\', prop_raw_val ,\'</V:\', prop1,\'>\\n\'));\n"
"else\n"
"http (concat (\'<V:\',prop1,\'/>\\n\'));\n"
"prop_idx := prop_idx + 1;\n"
"}\n"
"}\n"
"if (found_sprop)\n"
"{\n"
"http (\'</D:prop>\\n\');\n"
"http (\'<D:status>HTTP/1.1 200 OK</D:status>\\n\');\n"
"http (\'</D:propstat>\\n\');\n"
"}\n"
"if (mis_prop <> \'\')\n"
"{\n"
"if (found_sprop)\n"
"http (\'<D:propstat>\\n<D:prop>\\n\');\n"
"http (mis_prop);\n"
"http (\'</D:prop>\\n<D:status>HTTP/1.1 404 Not Found</D:status>\\n</D:propstat>\\n\');\n"
"\n"
"}\n"
"http (\'</D:response>\\n\');\n"
"\n"
"dir_ctr := dir_ctr + 1;\n"
"goto next_response;\n"
"\n"
"}\n"
"--src dav.sql:256\n";

static const char *proc4 = 
"create procedure WS.WS.PROPNAMES (in _body varchar)\n"
"{\n"
"declare prop, propname, allprop, tree, tmp, ret any;\n"
"declare ix, len, sc integer;\n"
"declare name varchar;\n"
"\n"
"if (not isstring(_body) or _body = \'\')\n"
"return null;\n"
"\n"
"prop := string_output ();\n"
"propname := string_output ();\n"
"allprop := string_output ();\n"
"tree := xml_tree_doc (xml_expand_refs (xml_tree (_body)));\n"
"http_value (xpath_eval (\'//propfind/prop\', tree , 1), null, prop);\n"
"http_value (xpath_eval (\'//propfind/propname\', tree , 1), null, propname);\n"
"http_value (xpath_eval (\'//propfind/allprop\', tree , 1), null, allprop);\n"
"prop := string_output_string (prop);\n"
"propname := string_output_string (propname);\n"
"allprop := string_output_string (allprop);\n"
"\n"
"ret := null;\n"
"\n"
"if (allprop <> \'\')\n"
"return vector (\'allprop\');\n"
"else if (propname <> \'\')\n"
"return vector (\'propname\');\n"
"else if (prop <> \'\')\n"
"{\n"
"declare xp any;\n"
"tree := xtree_doc (prop);\n"
"xp := xpath_eval(\'/prop/*\', tree, 0);\n"
"foreach (any elm in xp) do\n"
"{\n"
"name := cast (xpath_eval (\'name()\', elm) as varchar);\n"
"sc := strrchr (name, \':\');\n"
"if (sc is not null and (name like \'DAV::%\'\n"
"or name like \'http://www.openlinksw.com/virtuoso/webdav/1.0/:%\'))\n"
"name := subseq (name, sc, length (name));\n"
"if (ret is null)\n"
"ret := vector (name);\n"
"else\n"
"ret := vector_concat (ret, vector (name));\n"
"}\n"
"}\n"
"\n"
"return ret;\n"
"}\n"
"--src dav.sql:555\n";

static const char *proc5 = 
"create procedure WS.WS.CUSTOM_PROP (in lpath any, in prop any, in depth integer, in st char (1))\n"
"{\n"
"declare _name, _lmask, _prop, _ltype, _lscope, _lown, _ltoken, _tp, _pname varchar;\n"
"declare _id, _ltimeout, _sc integer;\n"
"declare c cursor for select COL_NAME, COL_ID from WS.WS.SYS_DAV_COL where COL_ID = DAV_HIDE_ERROR_OR_DET (DAV_SEARCH_PATH (_lmask, \'C\'), null, null);\n"
"declare r cursor for select RES_NAME, RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = _lmask;\n"
"declare p cursor for select PROP_NAME from WS.WS.SYS_DAV_PROP where PROP_TYPE = _tp and PROP_PARENT_ID = _id;\n"
"\n"
"\n"
"_name := \'\';\n"
"\n"
"_prop := aref (prop, 0);\n"
"if (_prop <> \'propname\')\n"
"{\n"
"http_request_status (\'HTTP/1.1 501 Not Implemented\');\n"
"return;\n"
"}\n"
"_lmask := http_physical_path ();\n"
"if (st = \'C\' and aref (_lmask, length (_lmask) - 1) <> ascii (\'/\'))\n"
"_lmask := concat (_lmask, \'/\');\n"
"\n"
"whenever not found goto nf;\n"
"if (st = \'C\')\n"
"{\n"
"_tp := \'C\';\n"
"open c (prefetch 1);\n"
"fetch c into _name, _id;\n"
"close c;\n"
"}\n"
"else\n"
"{\n"
"_tp := \'R\';\n"
"open r (prefetch 1);\n"
"fetch r into _name, _id;\n"
"close r;\n"
"}\n"
"nf:\n"
"\n"
"http_request_status (\'HTTP/1.1 207 Multi-Status\');\n"
"http_header (\'Content-type: text/xml\\r\\n\');\n"
"http (\'<?xml version=\"1.0\"?>\\n\');\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\" xmlns:V=\"http://www.openlinksw.com/virtuoso/webdav/1.0/\">\\n\');\n"
"http (\'<D:response xmlns:lp0=\"DAV:\" xmlns:i0=\"DAV:\">\\n\');\n"
"http (\'<D:href>\'); http_dav_url (lpath); http (\'</D:href>\\n\');\n"
"http (\'<D:propstat>\\n\');\n"
"http (\'<D:prop>\\n\');\n"
"if (_prop = \'propname\')\n"
"{\n"
"if (st = \'R\')\n"
"http (\'<D:getcontenttype/>\\n<lp0:getcontentlength/>\\n<lp0:getetag/>\\n\');\n"
"http (\'<lp0:creationdate/>\\n<lp0:getlastmodified/>\\n\');\n"
"http (\'<D:lockdiscovery/>\\n<D:supportedlock/>\\n<D:resourcetype/>\\n\');\n"
"whenever not found goto nfp;\n"
"open p (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch p into _pname;\n"
"_sc := strrchr (_pname, \':\');\n"
"if (_sc is not null)\n"
"_pname := subseq (_pname, _sc + 1, length(_pname));\n"
"http (concat (\'<V:\', cast (_pname as varchar),\'/>\\n\'));\n"
"}\n"
"nfp:\n"
"close p;\n"
"}\n"
"http (\'</D:prop>\\n\');\n"
"http (\'<D:status>HTTP/1.1 200 OK</D:status>\');\n"
"http (\'</D:propstat>\\n\');\n"
"http (\'</D:response>\\n\');\n"
"http (\'</D:multistatus>\\n\');\n"
"}\n"
"--src dav.sql:604\n";

static const char *proc6 = 
"create procedure WS.WS.PROPPATCH (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare _u_id, _g_id, _slen, _len, _ix, id, _pid, _ix1 integer;\n"
"declare uname, upwd, st, _perms, _body, _name varchar;\n"
"declare _ses, _set, _del, _tmp, _val any;\n"
"declare rc, acc, _proprc, xtree any;\n"
"\n"
"\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"st := \'C\';\n"
"else\n"
"{\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"if (id is not null)\n"
"st := \'R\';\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return;\n"
"}\n"
"}\n"
"_u_id := null;\n"
"_g_id := null;\n"
"rc := DAV_AUTHENTICATE_HTTP (id, st, \'11_\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"return;\n"
"rc := string_output ();\n"
"_ses := aref_set_0 (params, 1);\n"
"_body := string_output_string (_ses);\n"
"\n"
"xtree := xml_tree (_body, 0);\n"
"if (not isarray (xtree))\n"
"{\n"
"http_request_status (\'HTTP/1.1 400 Bad Request\');\n"
"return (0);\n"
"}\n"
"xte_nodebld_init (acc);\n"
"\n"
"if (WS.WS.ISLOCKED (vector_concat (vector (\'\'), path), lines, _u_id))\n"
"{\n"
"http_request_status (\'HTTP/1.1 423 Locked\');\n"
"return;\n"
"}\n"
"\n"
"http_request_status (\'HTTP/1.1 207 Multi-Status\');\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\\n\', rc);\n"
"http (\'<D:multistatus xmlns:D=\"DAV:\">\\n\', rc);\n"
"http (\'<D:response>\\n\', rc);\n"
"http (\'<D:propstat>\\n\', rc);\n"
"\n"
"declare xtd, prop_set any;\n"
"declare i, l integer;\n"
"\n"
"xtd := xml_tree_doc (xtree);\n"
"\n"
"\n"
"prop_set := xpath_eval(\'//set/prop/*\',xtd,0);\n"
"\n"
"\n"
"\n"
"l := length (prop_set);\n"
"if (l > 0)\n"
"{\n"
"i := 0;\n"
"while (i < l)\n"
"{\n"
"declare pa, pn, pns, pv, ps, _prop_name any;\n"
"pa := prop_set[i];\n"
"\n"
"pn := cast (xpath_eval (\'local-name(.)\', pa) as varchar);\n"
"_prop_name := pn;\n"
"pns := cast(xpath_eval (\'namespace-uri(.)\', pa) as varchar);\n"
"\n"
"ps := string_output ();\n"
"http_value (pa, null, ps);\n"
"pv := xml_tree (string_output_string (ps));\n"
"\n"
"if (length (pns) > 0)\n"
"pn := concat (pns, \':\', pn);\n"
"\n"
"xte_nodebld_acc (acc, xte_node (xte_head (pn)));\n"
"\n"
"if (pns = \'http://www.openlinksw.com/virtuoso/webdav/1.0/\'\n"
"and _prop_name in (\'virtpermissions\', \'virtowneruid\', \'virtownergid\'))\n"
"{\n"
"declare tmp, tmp_id any;\n"
"tmp := cast (xpath_eval (\'string()\', pa) as varchar);\n"
"if (_prop_name = \'virtpermissions\')\n"
"{\n"
"\n"
"if ((tmp like \'__1%\' or tmp like \'_____1%\' or tmp like \'________1%\') and _u_id <> http_dav_uid ())\n"
"goto skip_perm_update;\n"
"\n"
"\n"
"if (regexp_match (DB.DBA.DAV_REGEXP_PATTERN_FOR_PERM (), tmp) is null)\n"
"goto skip_perm_update;\n"
"\n"
"if (st = \'R\')\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = tmp where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = tmp where COL_ID = id;\n"
"\n"
"skip_perm_update:;\n"
"}\n"
"else if (_prop_name = \'virtowneruid\')\n"
"{\n"
"tmp_id := (select U_ID from DB.DBA.SYS_USERS where U_NAME = tmp);\n"
"if (st = \'R\')\n"
"update WS.WS.SYS_DAV_RES set RES_OWNER = tmp_id where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_GROUP = tmp_id where COL_ID = id;\n"
"}\n"
"else if (_prop_name = \'virtownergid\')\n"
"{\n"
"tmp_id := (select U_ID from DB.DBA.SYS_USERS where U_NAME = tmp);\n"
"if (st = \'R\')\n"
"update WS.WS.SYS_DAV_RES set RES_GROUP = tmp_id where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_GROUP = tmp_id where COL_ID = id;\n"
"}\n"
"}\n"
"else if (not exists (select 1 from WS.WS.SYS_DAV_PROP\n"
"where PROP_NAME = pn and PROP_TYPE = st and PROP_PARENT_ID = id))\n"
"{\n"
"_pid := WS.WS.GETID (\'P\');\n"
"insert into WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_TYPE, PROP_PARENT_ID, PROP_VALUE)\n"
"values (_pid, pn, st, id, serialize(pv[1]));\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = serialize(pv[1])\n"
"where PROP_PARENT_ID = id and PROP_TYPE = st and PROP_NAME = pn;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n"
"\n"
"prop_set := xpath_eval(\'//remove/prop/*\',xtd,0);\n"
"\n"
"l := length (prop_set);\n"
"if (l > 0)\n"
"{\n"
"i := 0;\n"
"while (i < l)\n"
"{\n"
"declare pa, pn, pns any;\n"
"pa := prop_set[i];\n"
"\n"
"pn := cast (xpath_eval (\'local-name(.)\', pa) as varchar);\n"
"pns := cast(xpath_eval (\'namespace-uri(.)\', pa) as varchar);\n"
"\n"
"\n"
"if (length (pns) > 0)\n"
"pn := concat (pns, \':\', pn);\n"
"\n"
"xte_nodebld_acc (acc, xte_node (xte_head (pn)));\n"
"delete from WS.WS.SYS_DAV_PROP\n"
"where PROP_PARENT_ID = id and PROP_TYPE = st and PROP_NAME = pn;\n"
"i := i + 1;\n"
"}\n"
"}\n"
"acc := xte_nodebld_final (acc);\n"
"_proprc := xte_node_from_nodebld (xte_head (\'DAV::prop\'), acc);\n"
"\n"
"http_value (xml_tree_doc (_proprc), null, rc);\n"
"http (\'<D:status>HTTP/1.1 200 OK</D:status>\\n\', rc);\n"
"http (\'</D:propstat>\\n\', rc);\n"
"http (\'</D:response>\\n\', rc);\n"
"http (\'</D:multistatus>\\n\', rc);\n"
"http_header (\'Content-Type: text/xml\\r\\n\');\n"
"http (string_output_string (rc));\n"
"}\n"
"--src dav.sql:677\n";

static const char *proc7 = 
"create procedure WS.WS.FINDPARAM (inout params varchar, in pkey varchar)\n"
"{\n"
"declare ret any;\n"
"declare i, l integer;\n"
"if (pkey is null)\n"
"return \'\';\n"
"i := 0; l := length (params);\n"
"pkey := rtrim (pkey,\': \');\n"
"while (i < l)\n"
"{\n"
"ret := http_request_header (vector (params[i]), pkey, NULL, NULL);\n"
"if (ret is not null)\n"
"return ret;\n"
"i := i + 1;\n"
"}\n"
"return \'\';\n"
"}\n"
"--src dav.sql:853\n";

static const char *proc8 = 
"create procedure WS.WS.MKCOL (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare _parent_name varchar;\n"
"declare _col_id, rc integer;\n"
"declare _perms varchar;\n"
"declare _col_parent_id integer;\n"
"declare uname, upwd varchar;\n"
"declare _u_id, _g_id integer;\n"
"declare ses, ses_str any;\n"
"\n"
"\n"
"_col_parent_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'P\'));\n"
"_col_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"_u_id := null;\n"
"_g_id := null;\n"
"if (_col_parent_id is not null)\n"
"{\n"
"\n"
"rc := DAV_AUTHENTICATE_HTTP (_col_parent_id, \'C\', \'11_\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"return;\n"
"}\n"
"ses := aref_set_0 (params, 1);\n"
"ses_str := string_output_string (ses);\n"
"if (length (ses_str) > 0)\n"
"{\n"
"\n"
"http_request_status (\'HTTP/1.1 415 Unsupported Media Type\');\n"
"return;\n"
"}\n"
"rc := DAV_COL_CREATE_INT (\'/\' || DAV_CONCAT_PATH (path, \'/\'), _perms, null, null, null, null, 1, 0, 1, _u_id, _g_id);\n"
"\n"
"if ((not isinteger (rc)) or (rc > 0))\n"
"{\n"
"commit work;\n"
"\n"
"http_request_status (\'HTTP/1.1 201 Created\');\n"
"return;\n"
"}\n"
"if (rc = -24)\n"
"return;\n"
"if (rc = -25)\n"
"{\n"
"http_request_status (\'HTTP/1.1 409 Conflict\');\n"
"return;\n"
"}\n"
"if (rc = -8)\n"
"{\n"
"http_request_status (\'HTTP/1.1 423 Locked\');\n"
"return;\n"
"}\n"
"if ((rc = -12) or (rc = -13))\n"
"{\n"
"http_request_status (\'HTTP/1.1 403 Forbidden\');\n"
"return;\n"
"}\n"
"http_request_status (\'HTTP/1.1 405 Method Not Allowed\');\n"
"}\n"
"--src dav.sql:872\n";

static const char *proc9 = 
"create procedure WS.WS.FINDCOL (in path any, out col integer)\n"
"{\n"
"declare inx integer;\n"
"declare depth integer;\n"
"declare parent_id integer;\n"
"declare det, cname varchar;\n"
"inx := 0;\n"
"depth := length (path);\n"
"whenever not found goto not_found;\n"
"while (inx < depth)\n"
"{\n"
"cname := aref (path, inx);\n"
"select COL_ID, COL_DET into parent_id, det from WS.WS.SYS_DAV_COL where COL_NAME = cname and COL_PARENT = parent_id;\n"
"if (det is not NULL)\n"
"signal (\'37000\', sprintf (\'WS.WS.FINDCOL() is used to access special DAV collection of type \"%s\"\', det));\n"
"col := parent_id;\n"
"inx := inx + 1;\n"
"}\n"
"not_found:\n"
"return inx;\n"
"}\n"
"--src dav.sql:934\n";

static const char *proc10 = 
"create procedure WS.WS.FINDRES (in path varchar,out _col integer, out _name varchar)\n"
"{\n"
"declare depth integer;\n"
"declare col integer;\n"
"declare name varchar;\n"
"declare rc integer;\n"
"declare res_inx integer;\n"
"declare id integer;\n"
"\n"
"rc := 0;\n"
"res_inx := length (path);\n"
"col := 0;\n"
"name := aref (path, res_inx - 1);\n"
"if (res_inx < 1) rc := 0;\n"
"depth := WS.WS.FINDCOL (path, col);\n"
"if (depth = res_inx)\n"
"return 0;\n"
"if (depth < res_inx - 1)\n"
"return -1;\n"
"\n"
"whenever not found goto not_found;\n"
"select RES_ID into id from WS.WS.SYS_DAV_RES where RES_NAME = name and RES_COL = col;\n"
"\n"
"if (id is null)\n"
"return 0;\n"
"\n"
"if (id > 0)\n"
"{\n"
"rc := 1;\n"
"_col := col;\n"
"_name := name;\n"
"}\n"
"not_found:\n"
"return rc;\n"
"}\n"
"--src dav.sql:958\n";

static const char *proc11 = 
"create procedure WS.WS.DELCHILDREN (in id integer, in lines varchar)\n"
"{\n"
"declare col, res, r_id, n_locks, rc integer;\n"
"declare name, if_token varchar;\n"
"declare icol integer;\n"
"declare cname varchar;\n"
"declare c_cur cursor for select COL_ID, COL_NAME from WS.WS.SYS_DAV_COL where COL_PARENT = id;\n"
"declare r_cur cursor for select RES_ID, RES_NAME from WS.WS.SYS_DAV_RES where RES_COL = id;\n"
"select count (COL_ID) into col from WS.WS.SYS_DAV_COL where COL_PARENT = id;\n"
"select count (RES_ID) into res from WS.WS.SYS_DAV_RES where RES_COL = id;\n"
"if_token := WS.WS.FINDPARAM (lines, \'If:\');\n"
"if (isnull (if_token))\n"
"if_token := \'\';\n"
"if (res > 0)\n"
"{\n"
"whenever not found goto del_res_end;\n"
"open r_cur;\n"
"while (1)\n"
"{\n"
"fetch r_cur into r_id, name;\n"
"select count (LOCK_TOKEN) into n_locks from WS.WS.SYS_DAV_LOCK where\n"
"LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = r_id and isnull (strstr (if_token, LOCK_TOKEN));\n"
"if (n_locks > 0)\n"
"{\n"
"http_header (\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (concat (\n"
"\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\',\n"
"\'<d:multistatus xmlns:d=\"DAV:\">\',\n"
"\'<d:response>\',\n"
"\'<d:href>\')); http_dav_url (name); http(concat (\'</d:href>\',\n"
"\'<d:status>HTTP/1.1 423 Locked</d:status>\',\n"
"\'</d:response>\',\n"
"\'</d:multistatus>\'\n"
"));\n"
"return 1;\n"
"}\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = r_id;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = r_id;\n"
"}\n"
"del_res_end:\n"
"close r_cur;\n"
"}\n"
"\n"
"if (col > 0)\n"
"{\n"
"whenever not found goto del_col_end;\n"
"open c_cur;\n"
"while (1)\n"
"{\n"
"fetch c_cur into icol, cname;\n"
"select count (LOCK_TOKEN) into n_locks from WS.WS.SYS_DAV_LOCK where\n"
"LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = icol and isnull (strstr (if_token, LOCK_TOKEN));\n"
"if (n_locks > 0)\n"
"{\n"
"http_header (\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\');\n"
"http (concat (\n"
"\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\',\n"
"\'<d:multistatus xmlns:d=\"DAV:\">\',\n"
"\'<d:response>\',\n"
"\'<d:href>\')); http_dav_url (cname); http(concat (\'</d:href>\',\n"
"\'<d:status>HTTP/1.1 423 Locked</d:status>\',\n"
"\'</d:response>\',\n"
"\'</d:multistatus>\'\n"
"));\n"
"return 1;\n"
"}\n"
"rc := WS.WS.DELCHILDREN (icol, lines);\n"
"if (rc > 0)\n"
"{\n"
"return 1;\n"
"}\n"
"delete from WS.WS.SYS_DAV_COL where COL_PARENT = id and COL_NAME = cname;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = icol;\n"
"}\n"
"del_col_end:\n"
"close c_cur;\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav.sql:996\n";

static const char *proc12 = 
"create procedure WS.WS.\"DELETE\" (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare depth,len integer;\n"
"declare src_id any;\n"
"declare uname, upwd, _perms varchar;\n"
"declare rc, err integer;\n"
"declare res integer;\n"
"declare u_id, g_id integer;\n"
"declare p_comm, msg, stat,st varchar;\n"
"uname := null;\n"
"upwd := null;\n"
"u_id := null;\n"
"g_id := null;\n"
"\n"
"set isolation = \'serializable\';\n"
"if ((length(path) > 1) and (\'\' = path[length(path)-1]))\n"
"{\n"
"st := \'C\';\n"
"src_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"}\n"
"else\n"
"{\n"
"src_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (src_id is not null)\n"
"{\n"
"st := \'C\';\n"
"path := vector_concat (path, vector (\'\'));\n"
"}\n"
"else\n"
"{\n"
"st := \'R\';\n"
"src_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"}\n"
"}\n"
"\n"
"if (src_id is null)\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return;\n"
"}\n"
"rc := DAV_AUTHENTICATE_HTTP (src_id, st, \'11_\', 1, lines, uname, upwd, u_id, g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"{\n"
"return;\n"
"}\n"
"\n"
"rc := DAV_DELETE_INT (DAV_CONCAT_PATH (\'/\', path), 1, null, null, 0);\n"
"\n"
"if (rc >= 0)\n"
"{\n"
"http_request_status (\'HTTP/1.1 204 No Content\');\n"
"return;\n"
"}\n"
"if (rc = -8)\n"
"{\n"
"http_request_status (\'HTTP/1.1 423 Locked\');\n"
"return;\n"
"}\n"
"http_request_status (\'HTTP/1.1 500 Internal Server Error\');\n"
"return;\n"
"}\n"
"--src dav.sql:1078\n";

static const char *proc13 = 
"create procedure WS.WS.ISCOL (in path varchar)\n"
"{\n"
"declare depth, len, col integer;\n"
"depth := WS.WS.FINDCOL (path, col);\n"
"len := length (path);\n"
"if (depth = len)\n"
"return 1;\n"
"else\n"
"return 0;\n"
"}\n"
"--src dav.sql:1144\n";

static const char *proc14 = 
"create procedure WS.WS.ISRES (in path varchar)\n"
"{\n"
"declare col, rc integer;\n"
"declare name varchar;\n"
"rc := WS.WS.FINDRES (path, col, name);\n"
"if (rc < 0)\n"
"rc := 0;\n"
"return (rc);\n"
"}\n"
"--src dav.sql:1158\n";

static const char *proc15 = 
"create procedure WS.WS.ETAG (in name varchar, in col integer)\n"
"{\n"
"declare etag, full_path varchar;\n"
"declare mtime datetime;\n"
"declare msize integer;\n"
"declare id integer;\n"
"etag := sprintf (\'%d-%s-%d\',rnd(1000),cast (now() as varchar), rnd (1000));\n"
"whenever not found goto etag_err;\n"
"select RES_ID, RES_MOD_TIME, length (RES_CONTENT), RES_FULL_PATH into\n"
"id, mtime, msize, full_path from WS.WS.SYS_DAV_RES where RES_NAME = name and RES_COL = col;\n"
"etag := sprintf (\'%d-%s-%d-%s-%s\', id, cast (mtime as varchar), msize, name, full_path);\n"
"etag_err:\n"
"etag := md5 (etag);\n"
"return etag;\n"
"}\n"
"--src dav.sql:1170\n";

static const char *proc16 = 
"create procedure WS.WS.HEAD (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"\n"
"WS.WS.GET (path, params, lines);\n"
"return;\n"
"}\n"
"--src dav.sql:1188\n";

static const char *proc17 = 
"create procedure DAV_SET_HTTP_REQUEST_STATUS (in rc integer)\n"
"{\n"
"if (rc = -1)	{ http_request_status (\'HTTP/1.1 409 Invalid path\');	return; }\n"
"if (rc = -2)	{ http_request_status (\'HTTP/1.1 409 Conflict: the destination (path) is not valid\');		return; }\n"
"if (rc = -3)	{ http_request_status (\'HTTP/1.1 412 Precondition Failed: overwrite flag is not set and destination exists\');	return; }\n"
"if (rc = -8)	{ http_request_status (\'HTTP/1.1 423 Locked\');		return; }\n"
"if (rc = -12)	{ http_request_status (\'HTTP/1.1 403 Forbidden: authentication has failed\');	return; }\n"
"if (rc = -13) { http_request_status (\'HTTP/1.1 403 Forbidden: insufficient user permissions\');	return; }\n"
"if (rc = -25)	{ http_request_status (\'HTTP/1.1 409 Conflict: can not create collection if a resource with same name exists\');	return; }\n"
"if (rc = -26)	{ http_request_status (\'HTTP/1.1 409 Conflict: can not create resource if a collection with same name exists\');	return; }\n"
"if (rc = -24) return;\n"
"if (rc = -28)	{ http_request_status (\'HTTP/1.1 599 Internal server error\');	return; }\n"
"if (rc = -29) { http_request_status (\'HTTP/1.1 599 Internal server error\');	return; }\n"
"if (rc = -41) { http_request_status (\'HTTP/1.1 507 Insufficient storage\');	return; }\n"
"http_request_status (\'HTTP/1.1 405 Method Not Allowed\');\n"
"return;\n"
"}\n"
"--src dav.sql:1197\n";

static const char *proc18 = 
"create procedure WS.WS.PUT (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare _col_parent_id integer;\n"
"declare id integer;\n"
"declare content varchar;\n"
"declare content_type varchar;\n"
"declare rc, err, inc, end_inc, inc_col, inc_id integer;\n"
"declare _col integer;\n"
"declare _name varchar;\n"
"declare _cont_len integer;\n"
"declare temp varchar;\n"
"declare full_path, _perms, _vsp, uname, upwd varchar;\n"
"declare _u_id, _g_id, _is_xper, is_sparql integer;\n"
"declare p_name, p_text, p_comm, stat, msg, p_inc, p_root, inc_name, inc_cont, str, location, inh varchar;\n"
"declare ses any;\n"
"\n"
"\n"
"ses := aref_set_0 (params, 1);\n"
"\n"
"whenever sqlstate \'*\' goto error_ret;\n"
"\n"
"\n"
"\n"
"\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"path := WS.WS.FIXPATH (path);\n"
"full_path := DAV_CONCAT_PATH (\'/\', path);\n"
"_vsp := aref (path, length (path) - 1);\n"
"_u_id := null;\n"
"_g_id := null;\n"
"is_sparql := 0;\n"
"_col_parent_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'P\'));\n"
"if (_col_parent_id is not null)\n"
"{\n"
"\n"
"rc := DAV_AUTHENTICATE_HTTP (_col_parent_id, \'C\', \'11_\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"goto error_ret;\n"
"}\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 409 Conflict\');\n"
"return;\n"
"}\n"
"if (WS.WS.ISLOCKED (vector_concat (vector (\'\'), path), lines, _u_id))\n"
"{\n"
"http_request_status (\'HTTP/1.1 423 Locked\');\n"
"return;\n"
"}\n"
"content_type := WS.WS.FINDPARAM (lines, \'Content-Type:\');\n"
"if (content_type = \'\')\n"
"content_type := http_mime_type (full_path);\n"
"temp :=  WS.WS.FINDPARAM (lines, \'Content-Length:\');\n"
"_cont_len := atoi (temp);\n"
"if ((full_path like \'%.vsp\' or full_path like \'%.vspx\') and _cont_len > 0)\n"
"{\n"
"content_type := \'text/html\';\n"
"}\n"
"\n"
"\n"
"if (content_type = \'application/sparql-query\')\n"
"{\n"
"WS.WS.SPARQL_QUERY_POST (full_path, ses);\n"
"is_sparql := 1;\n"
"}\n"
"\n"
"rc := -28;\n"
"rc := DAV_RES_UPLOAD_STRSES_INT (\n"
"full_path, ses, content_type, _perms,\n"
"uname, null, uname, upwd, 0,\n"
"now(), now(), null,\n"
"_u_id, _g_id, 0 );\n"
"\n"
"if ((not isinteger (rc)) or (rc > 0))\n"
"{\n"
"commit work;\n"
"http_request_status (\'HTTP/1.1 201 Created\');\n"
"if (is_sparql = 1)\n"
"http_header (\'MS-Author-Via: SPARQL\\r\\n\');\n"
"else\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>201 Created</TITLE>\',\n"
"\'</HEAD><BODY>\', \'<H1>Created</H1>\',\n"
"\'Resource \', sprintf (\'%V\', full_path),\' has been created.</BODY></HTML>\'));\n"
"return;\n"
"}\n"
"error_ret:\n"
"\n"
"\n"
"if (__SQL_STATE = \'40001\')\n"
"{\n"
"rollback work;\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"http_body_read ();\n"
"DAV_SET_HTTP_REQUEST_STATUS (rc);\n"
"}\n"
"--src dav.sql:1219\n";

static const char *proc19 = 
"create procedure WS.WS.HEX_TO_DEC (in c char)\n"
"{\n"
"if (c >= \'0\' and c <= \'9\')\n"
"return (ascii(c) - ascii(\'0\'));\n"
"if (c >= \'a\' and c <= \'f\')\n"
"return (10 + ascii(c) - ascii(\'a\'));\n"
"if (c >= \'A\' and c <= \'F\')\n"
"return (10 + ascii(c) - ascii(\'A\'));\n"
"return 0;\n"
"}\n"
"--src dav.sql:1323\n";

static const char *proc20 = 
"create procedure WS.WS.STR_TO_URI (in str varchar)\n"
"{\n"
"declare tmp varchar;\n"
"declare inx, inx1, len integer;\n"
"declare escapes varchar;\n"
"declare c char;\n"
"escapes := \';?:@&=+ \"#%<>\';\n"
"len := length (str);\n"
"if (len = 0)\n"
"return \'\';\n"
"inx := 0;\n"
"inx1 := 0;\n"
"tmp := repeat (\' \', len * 3);\n"
"\n"
"while (inx < len)\n"
"{\n"
"c := chr (aref (str, inx));\n"
"if (not isnull (strchr (escapes, c)))\n"
"{\n"
"aset (tmp, inx1, ascii(\'%\'));\n"
"aset (tmp, inx1 + 1, WS.WS.HEX_DIGIT (ascii(c) / 16));\n"
"aset (tmp, inx1 + 2, WS.WS.HEX_DIGIT (mod (ascii(c), 16)));\n"
"inx1 := inx1 + 2;\n"
"}\n"
"else\n"
"aset (tmp, inx1, ascii(c));\n"
"inx1 := inx1 + 1;\n"
"inx := inx + 1;\n"
"}\n"
"return trim(tmp);\n"
"}\n"
"--src dav.sql:1335\n";

static const char *proc21 = 
"create procedure WS.WS.PATHREF (in path varchar, in elem integer, in host varchar, out name_len integer)\n"
"{\n"
"declare inx, len, pos, inx1 integer;\n"
"declare name varchar;\n"
"declare c, cd1, cd2 char;\n"
"declare nelem integer;\n"
"declare temp varchar;\n"
"declare nslash integer;\n"
"declare lastslash integer;\n"
"declare new_path varchar;\n"
"\n"
"name_len := 0;\n"
"nslash := 0;\n"
"nelem := elem;\n"
"if (host <> \'\')\n"
"nelem := nelem + 2;\n"
"temp := path;\n"
"name := \'\';\n"
"len := length (path);\n"
"inx := 0;\n"
"inx1 := 0;\n"
"lastslash := 0;\n"
"new_path := repeat (\' \', len);\n"
"while (inx < len)\n"
"{\n"
"c := chr (aref (path, inx));\n"
"aset (new_path, inx1, ascii(c));\n"
"if (c = \'%\')\n"
"{\n"
"cd1 := chr(aref (path, inx + 1));\n"
"cd2 := chr(aref (path, inx + 2));\n"
"aset (new_path, inx1, (WS.WS.HEX_TO_DEC (cd1) * 16) + WS.WS.HEX_TO_DEC (cd2));\n"
"inx := inx + 2;\n"
"}\n"
"if (c = \'/\')\n"
"{\n"
"nslash := nslash + 1;\n"
"lastslash := inx;\n"
"}\n"
"inx := inx + 1;\n"
"inx1 := inx1 + 1;\n"
"}\n"
"\n"
"temp := trim(new_path);\n"
"\n"
"\n"
"if (nelem <= nslash)\n"
"nslash := nelem;\n"
"else\n"
"return name;\n"
"\n"
"while (nslash > 0)\n"
"{\n"
"pos :=  strchr (temp , \'/\');\n"
"temp := substring (temp, pos+2, len);\n"
"nslash := nslash - 1;\n"
"}\n"
"pos := strchr (temp, \'/\');\n"
"\n"
"if (isnull(pos))\n"
"pos := length (temp);\n"
"\n"
"if ( pos > 0 )\n"
"{\n"
"name := substring (temp, 1, pos);\n"
"name_len := length (name);\n"
"}\n"
"return name;\n"
"}\n"
"--src dav.sql:1368\n";

static const char *proc22 = 
"create procedure WS.WS.IS_ACTIVE_CONTENT (in f varchar)\n"
"{\n"
"declare dot integer;\n"
"declare ext varchar;\n"
"\n"
"dot := strrchr (f, \'.\');\n"
"if (dot is null)\n"
"return 0;\n"
"ext := lower (substring (f, dot + 2, length (f)));\n"
"if (ext in (\'vsp\', \'vspx\')\n"
"or __proc_exists (concat (\'__http_handler_\' , ext), 2)\n"
"or __proc_exists (concat (\'WS.WS.__http_handler_\' , ext), 1))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src dav.sql:1439\n";

static const char *proc23 = 
"create procedure WS.WS.GET_DAV_DEFAULT_PAGE (inout path any)\n"
"{\n"
"declare _list, path1 any;\n"
"declare _all varchar;\n"
"declare idx, len, line integer;\n"
"\n"
"_all := http_map_get (\'default_page\');\n"
"if (not isstring (_all))\n"
"goto brws_check;\n"
"_list :=  split_and_decode (_all, 0, \'\\0\\0;\');\n"
"idx := 0;\n"
"len := length (_list);\n"
"\n"
"while (idx < len)\n"
"{\n"
"line := trim (_list[idx]);\n"
"path1 := vector_concat (path, vector (line));\n"
"if (DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (vector (\'/\'), path1), \'R\')) is not null)\n"
"{\n"
"path := path1;\n"
"\n"
"return line;\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"brws_check:\n"
"if (0 = http_map_get (\'browseable\'))\n"
"{\n"
"declare dp any;\n"
"if (not isstring (_all))\n"
"dp := \'\';\n"
"else\n"
"dp := sprintf (\'Default page (%s) of folder \', _all);\n"
"\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>404 Not Found</TITLE>\',\n"
"\'</HEAD><BODY>\', \'<H1>Not Found</H1>\',\n"
"sprintf (\'%V\', dp),\n"
"sprintf (\'%V\', http_path ()), \' not found.</BODY></HTML>\'));\n"
"return null;\n"
"}\n"
"\n"
"return \'\';\n"
"}\n"
"--src dav.sql:1456\n";

static const char *proc24 = 
"create procedure WS.WS.GET_DAV_CHUNKED_QUOTA () returns integer\n"
"{\n"
"declare dav_chunked_quota integer;\n"
"\n"
"dav_chunked_quota := atoi (\n"
"coalesce (\n"
"cfg_item_value (virtuoso_ini_path(), \'HTTPServer\', \'DAVChunkedQuota\'),\n"
"\'1000000\'));\n"
"if (dav_chunked_quota < 1)\n"
"dav_chunked_quota := 1000000;\n"
"return dav_chunked_quota;\n"
"}\n"
"--src dav.sql:1505\n";

static const char *proc25 = 
"create procedure WS.WS.GET (in path any, inout params any, in lines any)\n"
"{\n"
"declare col_depth, path_len integer;\n"
"declare content long varchar;\n"
"declare content_type varchar;\n"
"declare fake_content any;\n"
"declare rc, err integer;\n"
"declare _col integer;\n"
"declare _name, uname, upwd varchar;\n"
"declare _cont_len integer;\n"
"declare full_path varchar;\n"
"declare parent_path varchar;\n"
"declare cont_type varchar;\n"
"declare server_etag, client_etag varchar;\n"
"declare uid, maxres integer;\n"
"declare p_comm, stat, msg, xpr, sxtag, rxtag, resource_content, str varchar;\n"
"declare resource_owner, exec_safety_level integer;\n"
"declare _res_id , _col_id, is_admin_owned_res integer;\n"
"declare def_page varchar;\n"
"declare asmx_path any;\n"
"\n"
"\n"
"if (WS.WS.DAV_CHECK_ASMX (path, asmx_path))\n"
"path := asmx_path;\n"
"def_page := \'\';\n"
"\n"
"full_path := http_physical_path ();\n"
"if (full_path = \'\')\n"
"full_path := \'/\';\n"
"full_path := WS.WS.DAV_REMOVE_ASMX (full_path);\n"
"\n"
"\n"
"\n"
"again:\n"
"_col_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (DAV_CONCAT_PATH (\'/\', full_path), \'/\'), \'C\'));\n"
"_res_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (DAV_CONCAT_PATH (\'/\', full_path), \'R\'));\n"
"exec_safety_level := 0;\n"
"\n"
"if (_res_id is null and _col_id is null)\n"
"{\n"
"declare procname varchar;\n"
"\n"
"procname := sprintf (\'%s.%s.%s\',\n"
"http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path);\n"
"\n"
"if ( __proc_exists (procname) and\n"
"(cast (registry_get (full_path) as varchar) = \'no_vsp_recompile\') and\n"
"(http_map_get (\'noinherit\') = 1))\n"
"{\n"
"commit work;\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"call (procname)(path, params, lines);\n"
"__pop_user_id ();\n"
"return;\n"
"}\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>404 Not Found</TITLE>\',\n"
"\'</HEAD><BODY>\', \'<H1>Not Found</H1>\',\n"
"\'Resource \', sprintf (\'%V\', http_path ()), \' not found.</BODY></HTML>\'));\n"
"return;\n"
"}\n"
"\n"
"if (_col_id is not null)\n"
"{\n"
"declare fpath any;\n"
"if (http_path () not like \'%/\')\n"
"{\n"
"declare url_pars varchar;\n"
"url_pars := http_request_get (\'QUERY_STRING\');\n"
"if (length (url_pars))\n"
"url_pars := \'?\' || url_pars;\n"
"http_request_status (\'HTTP/1.1 301 Moved Permanently\');\n"
"http_header (sprintf (\'Location: %s/%s\\r\\n\', http_path (), url_pars));\n"
"return (0);\n"
"}\n"
"def_page := WS.WS.GET_DAV_DEFAULT_PAGE (path);\n"
"if (def_page is null)\n"
"return;\n"
"if (def_page <> \'\')\n"
"{\n"
"declare new_path varchar;\n"
"new_path := DAV_CONCAT_PATH (http_path (), def_page);\n"
"full_path := DAV_CONCAT_PATH (full_path, def_page);\n"
"http_internal_redirect (new_path);\n"
"goto again;\n"
"}\n"
"}\n"
"\n"
"if (not (http_map_get (\'executable\')\n"
"\n"
"))\n"
"{\n"
"declare tgt_type, perms varchar;\n"
"declare tgt_id, gid integer;\n"
"\n"
"uname := null;\n"
"upwd := null;\n"
"uid := null;\n"
"if (_col_id is not null)\n"
"{\n"
"tgt_type := \'C\';\n"
"tgt_id := _col_id;\n"
"}\n"
"else\n"
"{\n"
"tgt_type := \'R\';\n"
"tgt_id := _res_id;\n"
"}\n"
"rc := DAV_AUTHENTICATE_HTTP (tgt_id, tgt_type, \'1__\', 1, lines, uname, upwd, uid, gid, perms);\n"
"if ((rc < 0) and (rc <> -1))\n"
"{\n"
"if (-24 = rc)\n"
"return 0;\n"
"http_rewrite (0);\n"
"http_request_status (\'HTTP/1.1 403 Prohibited\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>403 Prohibited</TITLE>\',\n"
"\'</HEAD><BODY>\', \'<H1>Prohibited</H1> \',\n"
"\'You are not permitted to view the content of this location: \',\n"
"sprintf (\'%V\', http_path ()), \'.</BODY></HTML>\'));\n"
"return 0;\n"
"}\n"
"if (_col_id is null and (rc >= 0))\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (tgt_id, tgt_type, \'1_1\', 0, lines, uname, upwd, uid, gid, perms);\n"
"if (rc >= 0)\n"
"exec_safety_level := 1;\n"
"}\n"
"}\n"
"\n"
"http_rewrite (0);\n"
"\n"
"if (_col_id is not null and http_path () not like \'%/\')\n"
"{\n"
"http_request_status (\'HTTP/1.1 301 Moved Permanently\');\n"
"http_header (sprintf (\'Location: %s/\\r\\n\', http_path ()));\n"
"return (0);\n"
"};\n"
"\n"
"declare location varchar;\n"
"if (WS.WS.IS_REDIRECT_REF (path, lines, location))\n"
"{\n"
"declare host1 varchar;\n"
"http_request_status (\'HTTP/1.1 302 Found\');\n"
"host1 := http_request_header (lines, \'Host\', NULL, NULL);\n"
"if (host1 is not null and location not like \'%://%\')\n"
"host1 := concat (\'http://\', host1);\n"
"else\n"
"host1 := \'\';\n"
"http_header (sprintf (\'Location: %s%s\\r\\n\', host1, location));\n"
"return (0);\n"
"}\n"
"\n"
"http_request_status (\'HTTP/1.1 200 OK\');\n"
"\n"
"client_etag := WS.WS.FINDPARAM (lines, \'If-None-Match:\');\n"
"if (_col_id is not null)\n"
"{\n"
"declare dir_ret any;\n"
"if (0 = http_map_get (\'browseable\'))\n"
"{\n"
"http_rewrite (0);\n"
"http_request_status (\'HTTP/1.1 403 Prohibited\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>403 Prohibited</TITLE>\',\n"
"\'</HEAD><BODY>\', \'<H1>Prohibited</H1> \',\n"
"\'You are not permitted to view the directory index in this location: \',\n"
"sprintf (\'%V\', http_path ()), \'.</BODY></HTML>\'));\n"
"return;\n"
"}\n"
"dir_ret := WS.WS.DAV_DIR_LIST (full_path, http_path(), _col_id, uname, upwd, uid);\n"
"if (DAV_HIDE_ERROR (dir_ret))\n"
"{\n"
"http_rewrite (0);\n"
"http_request_status (\'HTTP/1.1 500 Internal Server Error or Misconfiguration\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>500 Internal Server Error or Misconfiguration</TITLE>\',\n"
"\'</HEAD><BODY>\', \'<H1>Internal Server Error or Misconfiguration</H1> \',\n"
"\'Failed to return the directory index in this location: \',\n"
"sprintf (\'%V\', http_path ()), \'<BR>\', DAV_PERROR (dir_ret), \'</BODY></HTML>\'));\n"
"return;\n"
"}\n"
"return;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"is_admin_owned_res := 0; rc := 0;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (isinteger (_res_id))\n"
"{\n"
"for select RES_OWNER, RES_COL, RES_NAME, RES_TYPE\n"
"from WS.WS.SYS_DAV_RES where RES_ID = _res_id do\n"
"{\n"
"_col := RES_COL;\n"
"_name := RES_NAME;\n"
"resource_owner := RES_OWNER;\n"
"cont_type := RES_TYPE;\n"
"if (resource_owner = http_dav_uid ())\n"
"is_admin_owned_res := 1;\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (http_map_get (\'executable\') or (exec_safety_level and is_admin_owned_res))\n"
"exec_safety_level := 2;\n"
"\n"
"\n"
"\n"
"if (http_map_get (\'executable\'))\n"
"connection_set (\'DAVUserID\', resource_owner);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if ((exec_safety_level > 1) and full_path like \'%.vsp\')\n"
"{\n"
"declare incstat any;\n"
"if (__proc_exists (sprintf (\'%s.%s.%s\',\n"
"http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path)) and\n"
"not WS.WS.DAV_VSP_INCLUDES_CHANGED (full_path, http_map_get (\'vsp_proc_owner\')))\n"
"{\n"
"p_comm := sprintf (\'call \"%s\".\"%s\".\"%s\" (?, ?, ?)\',\n"
"http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path);\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"commit work;\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"err := exec (p_comm, stat, msg, vector (path, params, lines));\n"
"__pop_user_id ();\n"
"\n"
"if (stat = \'00000\')\n"
"return;\n"
"goto exec_err;\n"
"\n"
"}\n"
"select blob_to_string (RES_CONTENT), RES_FULL_PATH into resource_content, full_path\n"
"from WS.WS.SYS_DAV_RES where RES_NAME = _name and RES_COL = _col;\n"
"p_comm := sprintf (\n"
"\'create procedure \"%s\".\"%s\".\"%s\" (in path varchar, in params varchar, in lines varchar) { ?>\',\n"
"http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path);\n"
"str := string_output ();\n"
"http (p_comm, str);\n"
"incstat := vector ();\n"
"WS.WS.EXPAND_INCLUDES (full_path, str, 0, 1, resource_content, incstat);\n"
"http (\'<?vsp }\', str);\n"
"str := string_output_string (str);\n"
"\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"exec (str, stat, msg);\n"
"commit work;\n"
"if (stat = \'00000\')\n"
"{\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"p_comm := sprintf (\'call \"%s\".\"%s\".\"%s\" (?, ?, ?)\',\n"
"http_map_get (\'vsp_qual\'), http_map_get (\'vsp_proc_owner\'), full_path);\n"
"exec (p_comm, stat, msg, vector (path, params, lines));\n"
"}\n"
"__pop_user_id ();\n"
"\n"
"if (stat <> \'00000\')\n"
"{\n"
"exec_err:\n"
"http (\'<html><body>\');\n"
"http (concat (\'<H3>Execution of \"\', sprintf (\'%V\', http_path()), \'\" failed.</H3>\'));\n"
"http (concat (\'<p><b>SQL Error: \', stat, \' \'));\n"
"http_value (msg);\n"
"http (\'</b></p>\');\n"
"http (\'</body></html>\');\n"
"}\n"
"else\n"
"registry_set (concat (\'__depend_\', http_map_get (\'vsp_proc_owner\'), \'_\', full_path), serialize(incstat));\n"
"return;\n"
"}\n"
"else if ((exec_safety_level > 1) and full_path like \'%.vspx\')\n"
"{\n"
"\n"
"DB.DBA.vspx_dispatch (full_path, path, params, lines);\n"
"}\n"
"else\n"
"{\n"
"declare _server_etag, _xslt_sheet, _document_q, _xml_t varchar;\n"
"declare fext, hdl_mode varchar;\n"
"declare dot integer;\n"
"declare xml_mime_type varchar;\n"
"\n"
"\n"
"set isolation=\'repeatable\';\n"
"whenever not found goto err_end;\n"
"content := string_output (http_strses_memory_size ());\n"
"rc := DAV_RES_CONTENT_INT (_res_id, content, cont_type, 1, 0);\n"
"\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"http_rewrite (0);\n"
"http_request_status (\'HTTP/1.1 500 Internal server error\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>500 Internal server error</TITLE>\',\n"
"\'</HEAD><BODY>\', \'<H1>Internal server error</H1> \',\n"
"\'Server is unable to compose the text of the resource in this location: \',\n"
"sprintf (\'%V\', http_path ()), \'.</BODY></HTML>\'));\n"
"return;\n"
"}\n"
"\n"
"_name := path [length(path)-1];\n"
"\n"
"dot := strrchr (_name, \'.\');\n"
"if (dot is not null)\n"
"{\n"
"declare is_exist integer;\n"
"is_exist := 0;\n"
"fext := ws_get_ftext (_name, dot);\n"
"if (__proc_exists (fext, 2))\n"
"is_exist := 1;\n"
"else\n"
"{\n"
"fext := concat (\'WS.WS.\', fext);\n"
"if (__proc_exists (fext, 1))\n"
"is_exist := 1;\n"
"}\n"
"\n"
"if (is_exist and exec_safety_level > 0)\n"
"{\n"
"\n"
"declare stream_params any;\n"
"fext := cast (fext as varchar);\n"
"hdl_mode := concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', full_path);\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"stream_params := __http_stream_params ();\n"
"commit work;\n"
"http (call (fext) (string_output_string (content), stream_params, lines, hdl_mode));\n"
"if (isarray (hdl_mode) and length (hdl_mode) > 1)\n"
"{\n"
"if (hdl_mode[0] <> \'\' and isstring (hdl_mode[0]))\n"
"http_request_status (hdl_mode[0]);\n"
"if (hdl_mode[1] <> \'\' and isstring (hdl_mode[1]))\n"
"http_header (hdl_mode[1]);\n"
"}\n"
"return;\n"
"}\n"
"}\n"
"_xml_t := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-template\', 0), \'\');\n"
"xml_mime_type := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-sql-mime-type\', 0), \'text/xml\');\n"
"\n"
"if (cont_type = \'text/xml\' and\n"
"(http_map_get (\'xml_templates\') or _xml_t = \'execute\')\n"
"and (exec_safety_level > 1))\n"
"{\n"
"declare new_params, _enc any;\n"
"declare _base_url varchar;\n"
"_base_url := concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', full_path);\n"
"new_params := vector_concat (params, vector (\'template\', string_output_string (content),\n"
"\'__base_url\', _base_url, \'contenttype\', xml_mime_type));\n"
"_enc := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-sql-encoding\', 0));\n"
"DB.DBA.__XML_TEMPLATE (path, new_params, lines, _enc);\n"
"return;\n"
"}\n"
"\n"
"server_etag := WS.WS.ETAG (_name, _col);\n"
"\n"
"_document_q := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-sql\', 0), \'\');\n"
"_xslt_sheet := DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xml-stylesheet\', 0), \'\');\n"
"\n"
"if (_document_q <> \'\' or _xslt_sheet <> \'\')\n"
"cont_type := \'sql/xml\';\n"
"\n"
"if (cont_type <> \'\' and cont_type <> \'sql/xml\')\n"
"{\n"
"if (cont_type <> \'xml/view\' and cont_type <> \'xml/persistent-view\')\n"
"{\n"
"declare hdr_str any;\n"
"hdr_str := http_header_get ();\n"
"hdr_str := hdr_str || \'ETag: \"\' || server_etag || \'\"\\r\\n\';\n"
"if (strcasestr (hdr_str, \'Content-Type:\') is null)\n"
"hdr_str := hdr_str || \'Content-Type: \' || cont_type || \'\\r\\n\';\n"
"http_header (hdr_str);\n"
"}\n"
"else\n"
"http_header (concat (\'Content-Type: text/xml\\r\\nETag: \"\',server_etag,\'\"\\r\\n\'));\n"
"}\n"
"\n"
"\n"
"\n"
"_server_etag := server_etag;\n"
"server_etag := concat (\'\"\', server_etag, \'\"\');\n"
"\n"
"if (client_etag <> server_etag)\n"
"{\n"
"http_request_status (\'HTTP/1.1 200 OK\');\n"
"xpr := get_keyword (\'XPATH\', params, \'/*\');\n"
"if (cont_type = \'xml/view\')\n"
"{\n"
"declare ondemand_data varchar;\n"
"declare view_name varchar;\n"
"declare meta_mode integer;\n"
"declare meta_data varchar;\n"
"declare delim1, delim2 integer;\n"
"declare zero integer;\n"
"ondemand_data := string_output_string (content);\n"
"delim1 := locate(\'{view_name}\\n\',ondemand_data);\n"
"delim2 := locate(\'{meta_mode}\\n\',ondemand_data);\n"
"if(delim1 >= delim2 or delim2 = 0)\n"
"{\n"
"view_name := ondemand_data;\n"
"meta_mode := 0;\n"
"meta_data := \'\';\n"
"} else {\n"
"view_name := substring(ondemand_data, 1, delim1-1);\n"
"delim1 := delim1 + length(\'{view_name}\\n\');\n"
"meta_mode := cast(substring(ondemand_data, delim1, delim2-delim1) as integer);\n"
"delim2 := delim2 + length(\'{meta_mode}\\n\');\n"
"meta_data := substring(ondemand_data, delim2, length(ondemand_data)+1-delim2);\n"
"}\n"
"if (xpr = \'\')\n"
"{\n"
"http (\'Error: XPATH param is empty\');\n"
"return;\n"
"}\n"
"sxtag := get_keyword (\'set_tag\', params, view_name);\n"
"maxres := atoi (get_keyword (\'maxresults\', params, \'100\'));\n"
"rxtag := get_keyword (\'result_tag\', params, \'\');\n"
"if (rxtag <> \'\')\n"
"rxtag := concat (\'__tag  \"\', rxtag, \'\"\');\n"
"p_comm := concat (\'XPATH [__http __view \"\', view_name, \'\" \', rxtag, \'] \', xpr);\n"
"stat := \'00000\';\n"
"msg := \'\';\n"
"zero := 0;\n"
"WS.WS.XML_VIEW_HEADER (view_name, sxtag, full_path, meta_mode, meta_data, zero);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"err := exec (p_comm, stat, msg, vector (), maxres);\n"
"http (concat (\'</\', sxtag, \'>\\n\'));\n"
"if (stat = \'00000\')\n"
"return;\n"
"else\n"
"{\n"
"http_header (concat (\'Content-Type: text/html\\r\\n\'));\n"
"http (concat (\'SQL Error: \', stat, \' \', msg));\n"
"return;\n"
"}\n"
"}\n"
"else if ((cont_type = \'text/xml\' or cont_type = \'xml/persistent-view\' or (cont_type = \'sql/xml\' and length (content) > 0))  and xpr <> \'/*\')\n"
"{\n"
"declare c_xml cursor for select t from WS.WS.SYS_DAV_RES where xpath_contains (RES_CONTENT, xpr, t)\n"
"and RES_NAME = _name and RES_COL = _col;\n"
"declare ht varchar;\n"
"sxtag := get_keyword (\'set_tag\', params, \'document\');\n"
"rxtag := get_keyword (\'result_tag\', params, \'\');\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\"?>\\n\', current_charset()));\n"
"http (concat (\'<\', sxtag, \'>\\n\'));\n"
"whenever not found goto end_xml;\n"
"open c_xml;\n"
"while (1)\n"
"{\n"
"fetch c_xml into ht;\n"
"if (rxtag <> \'\')\n"
"http (concat (\'<\', rxtag, \'>\\n\'));\n"
"http_value (ht);\n"
"if (rxtag <> \'\')\n"
"http (concat (\'</\', rxtag, \'>\\n\'));\n"
"}\n"
"end_xml:\n"
"close c_xml;\n"
"http (concat (\'</\', sxtag, \'>\\n\'));\n"
"}\n"
"else if (cont_type = \'application/sparql-query\')\n"
"{\n"
"WS.WS.SPARQL_QUERY_GET (content, path, lines);\n"
"}\n"
"else if (not isnull (content))\n"
"{\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'xper\', 0)) is not null)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()));\n"
"http_value (xper_cut (xml_persistent (content)));\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
"declare _http_ranges_header any;\n"
"_http_ranges_header := http_sys_parse_ranges_header (length (content));\n"
"\n"
"if (isinteger (_http_ranges_header))\n"
"{\n"
"return;\n"
"}\n"
"else if (_http_ranges_header is not null)\n"
"{\n"
"declare _http_if_range varchar;\n"
"_http_if_range := http_request_header (lines, \'If-Range\', null, \'\');\n"
"if (length (_http_if_range) > 0 and _http_if_range <> server_etag)\n"
"_http_ranges_header := NULL;\n"
"if (length (_http_ranges_header) > 2)\n"
"{\n"
"_http_ranges_header := NULL;\n"
"}\n"
"}\n"
"if (_http_ranges_header is not null)\n"
"{\n"
"http_header (concat (coalesce (http_header_get (), \'\'), sprintf (\n"
"\'Content-Length: %ld\\r\\nContent-Range: bytes %ld-%ld/%ld\\r\\n\',\n"
"_http_ranges_header[1] - _http_ranges_header[0] + 1,\n"
"_http_ranges_header[0],\n"
"_http_ranges_header[1],\n"
"length (content))));\n"
"http_request_status (\'HTTP/1.1 206 Partial content\');\n"
"\n"
"declare _left, _to_get, _start integer;\n"
"declare _chunk, _ses any;\n"
"_left := _http_ranges_header[1] - _http_ranges_header[0] + 1;\n"
"_start := _http_ranges_header[0];\n"
"_ses := http_flush (2);\n"
"\n"
"declare exit handler for sqlstate \'*\' { rollback work; return; };\n"
"\n"
"while (_left > 0)\n"
"{\n"
"_to_get := _left;\n"
"if (_to_get > 65536)\n"
"_to_get := 65536;\n"
"_chunk := subseq (content, _start, _start + _to_get);\n"
"if (__tag (_chunk) = 185)\n"
"_chunk := string_output_string (_chunk);\n"
"ses_write (_chunk, _ses);\n"
"_left := _left - _to_get;\n"
"_start := _start + _to_get;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (length (content) > WS.WS.GET_DAV_CHUNKED_QUOTA ())\n"
"http_flush (1);\n"
"http (content);\n"
"}\n"
"}\n"
"if (cont_type = \'sql/xml\')\n"
"{\n"
"declare  _root, _doc_ses, _comments varchar;\n"
"if (length (content) = 0)\n"
"{\n"
"declare _dtd, _sch, _enc varchar;\n"
"_root := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-root\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_dtd := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-dtd\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_sch := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-schema\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_comments := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-description\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_enc := (select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-encoding\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id);\n"
"_doc_ses := null;\n"
"http_rewrite ();\n"
"WS.WS.XMLSQL_TO_STRSES (_document_q, _root, _sch, _dtd, _comments, _doc_ses, _enc);\n"
"}\n"
"if (_xslt_sheet <> \'\')\n"
"http_xslt (_xslt_sheet);\n"
"else if (length (content) = 0)\n"
"http_header (http_header_get () || sprintf (\'Cache-Control: no-cache, must-revalidate\\r\\nPragma: no-cache\\r\\nExpires: %s\\r\\nContent-Type: %s\\r\\n\', soap_print_box (now (), \'\', 1), xml_mime_type));\n"
"else\n"
"http_header (http_header_get () || sprintf (\'Content-Type: %s\\r\\nETag: \"%s\"\\r\\n\', xml_mime_type, _server_etag));\n"
"}\n"
"}\n"
"}\n"
"else\n"
"http_request_status (\'HTTP/1.1 304 Not Modified\');\n"
"}\n"
"err_end:\n"
"return;\n"
"}\n"
"--src dav.sql:1521\n";

static const char *proc26 = 
"create procedure WS.WS.POST (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare _content_type any;\n"
"_content_type := http_request_header (lines, \'Content-Type\', null, \'\');\n"
"if (_content_type = \'application/vnd.syncml+wbxml\' or\n"
"_content_type = \'application/vnd.syncml+xml\')\n"
"{\n"
"if (__proc_exists (\'DB.DBA.SYNCML\'))\n"
"DB.DBA.SYNCML (path, params, lines);\n"
"else\n"
"signal (\'37000\', \'The SyncML server is not available\');\n"
"}\n"
"else if (_content_type = \'application/sparql-query\')\n"
"{\n"
"WS.WS.PUT (path, params, lines);\n"
"}\n"
"else\n"
"{\n"
"WS.WS.GET (path, params, lines);\n"
"}\n"
"}\n"
"--src dav.sql:2137\n";

static const char *proc27 = 
"create procedure WS.WS.SPARQL_QUERY_POST (in path varchar, inout ses varchar)\n"
"{\n"
"declare def_gr, full_qr, qr, cname any;\n"
"declare stat, msg, meta, data any;\n"
"ses := http_body_read ();\n"
"qr := string_output_string (ses);\n"
"cname := cfg_item_value (virtuoso_ini_path (), \'URIQA\', \'DefaultHost\');\n"
"if (cname is null)\n"
"{\n"
"declare tmp any;\n"
"tmp := sys_stat (\'st_host_name\');\n"
"if (server_http_port () <> \'80\')\n"
"tmp := tmp || \':\'|| server_http_port ();\n"
"cname := tmp;\n"
"}\n"
"def_gr := sprintf (\'http://%s%U\', cname, path);\n"
"if (lower (qr) not like \'construct %\' and lower (qr) not like \'describe %\')\n"
"full_qr := sprintf (\'SPARQL define input:default-graph-uri <%s> \', def_gr);\n"
"else\n"
"full_qr := \'SPARQL \';\n"
"full_qr := full_qr || qr;\n"
"stat := \'00000\';\n"
"exec (full_qr, stat, msg, vector (), 0, meta, data);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"if (length (data) > 0 and length (data[0]) and __tag (data[0][0]) = 214)\n"
"{\n"
"declare dict, triples any;\n"
"dict := data[0][0];\n"
"ses := string_output ();\n"
"triples := dict_list_keys (dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, ses);\n"
"ses := string_output_string (ses);\n"
"DB.DBA.TTLP (ses, \'\', def_gr);\n"
"}\n"
"ses := sprintf (\'CONSTRUCT { ?s ?p ?o } FROM <%s> WHERE { ?s ?p ?o }\', def_gr);\n"
"}\n"
"--src dav.sql:2160\n";

static const char *proc28 = 
"create procedure WS.WS.SPARQL_QUERY_GET (in content any, in path any, inout lines any)\n"
"{\n"
"declare pars any;\n"
"pars := vector (\'query\', string_output_string (content));\n"
"WS.WS.\"/!sparql/\" (path, pars, lines);\n"
"}\n"
"--src dav.sql:2199\n";

static const char *proc29 = 
"create procedure WS.WS.\"LOCK\" (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare len, tleft, tright integer;\n"
"declare id, p_id, rc any;\n"
"declare col, res, timeout, owner integer;\n"
"declare st, name, uname, upwd, _perms varchar;\n"
"declare new_token, u_token varchar;\n"
"declare owner_name varchar;\n"
"declare ltype, scope char;\n"
"declare _u_id, _g_id integer;\n"
"declare tmp, dpth varchar;\n"
"declare hdr, location varchar;\n"
"declare ses any;\n"
"\n"
"declare _iftoken, locktype varchar;\n"
"locktype := null;\n"
"_iftoken := WS.WS.FINDPARAM (lines, \'If:\');\n"
"\n"
"ses := aref_set_0 (params, 1);\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"path := WS.WS.FIXPATH (path);\n"
"\n"
"p_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'P\'));\n"
"if (p_id is null)\n"
"{\n"
"http_request_status (\'HTTP/1.1 409 Conflict\');\n"
"return;\n"
"}\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"st := \'C\';\n"
"else\n"
"{\n"
"st := \'R\';\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"}\n"
"_u_id := null;\n"
"_g_id := null;\n"
"if (id is null)\n"
"rc := DAV_AUTHENTICATE_HTTP (p_id, \'C\', \'11_\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"else\n"
"rc := DAV_AUTHENTICATE_HTTP (id, st, \'11_\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"return;\n"
"set isolation = \'serializable\';\n"
"if (st = \'R\')\n"
"dpth := \'0\';\n"
"else\n"
"dpth := \'infinity\';\n"
"\n"
"tmp := string_output_string (ses);\n"
"owner_name := \'\';\n"
"scope := \'X\';\n"
"if (tmp is not null and tmp <> \'\')\n"
"{\n"
"declare xses, xses2, xtree any;\n"
"xtree := xml_tree (tmp, 0);\n"
"if (isarray (xtree))\n"
"{\n"
"xtree := xml_tree_doc (xtree);\n"
"xses := string_output ();\n"
"http_value (xpath_eval (\'/lockinfo/owner\' , xtree, 1), null, xses);\n"
"owner_name := string_output_string (xses);\n"
"if (owner_name = \'\')\n"
"owner_name := \'\';\n"
"xses2 := string_output ();\n"
"http_value (xpath_eval (\'/lockinfo/lockscope\' , xtree, 1), null, xses2);\n"
"xses2 := string_output_string (xses2);\n"
"if (strstr (xses2, \'exclusive\') is not null)\n"
"scope := \'X\';\n"
"else\n"
"scope := \'S\';\n"
"}\n"
"}\n"
"tmp := WS.WS.FINDPARAM (lines, \'Timeout:\');\n"
"declare tima any;\n"
"tima := split_and_decode (tmp, 0, \'\\0\\0-\');\n"
"\n"
"if (length(tima) > 1 and lower(tima[0]) = \'second\')\n"
"timeout := atoi (tima[1]);\n"
"else\n"
"timeout := 0;\n"
"path := DAV_CONCAT_PATH (\'/\', path);\n"
"rc := DAV_LOCK_INT (path, id, st, locktype, scope, null, owner_name, _iftoken, dpth, timeout, null, null, _u_id);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"if (rc = -8)\n"
"{\n"
"http_request_status (\'HTTP/1.1 423 Locked\');\n"
"return;\n"
"}\n"
"http_request_status (\'HTTP/1.1 424 Failed Dependency: \' || DAV_PERROR (rc));\n"
"return;\n"
"}\n"
"http_request_status (\'HTTP/1.1 200 OK\');\n"
"hdr := concat ( \'Lock-Token: <opaquelocktoken:\', rc ,\'>\\r\\n\',\n"
"\'Content-type: text/xml; charset=\"utf-8\"\\r\\n\',\n"
"\'Keep-Alive: timeout=15, max=100\\r\\n\');\n"
"http_header (hdr);\n"
"http (concat (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\',\n"
"\'<D:prop xmlns:D=\"DAV:\">\',\n"
"\'<D:lockdiscovery>\',\n"
"\'<D:activelock>\',\n"
"\'<D:locktype><D:write/></D:locktype>\',\n"
"\'<D:lockscope>\'));  if (scope = \'X\') http (\'<D:exclusive/>\'); else http (\'<D:shared/>\');\n"
"http (sprintf (\'</D:lockscope><D:depth>%s</D:depth>\', dpth));\n"
"http (owner_name);\n"
"http (concat (\'<D:timeout>Second-\',\n"
"cast (timeout as varchar),\'</D:timeout>\',\n"
"\'<D:locktoken>\',\n"
"\'<D:href>\', \'opaquelocktoken:\', rc, \'</D:href>\',\n"
"\'</D:locktoken>\',\n"
"\'</D:activelock>\',\n"
"\'</D:lockdiscovery>\',\n"
"\'</D:prop>\'));\n"
"}\n"
"--src dav.sql:2210\n";

static const char *proc30 = 
"create procedure WS.WS.\"UNLOCK\" (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"declare uname, upwd, _perms, token, name, cur_token, location varchar;\n"
"declare st char;\n"
"declare rc, id, col, _left, _right integer;\n"
"declare _u_id, _g_id integer;\n"
"declare l_cur cursor for select LOCK_TOKEN from WS.WS.SYS_DAV_LOCK\n"
"where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = st and LOCK_TOKEN = token;\n"
"\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path, vector(\'\')), \'C\'));\n"
"if (id is not null)\n"
"st := \'C\';\n"
"else\n"
"{\n"
"st := \'R\';\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (vector(\'\'), path), \'R\'));\n"
"if (id is null)\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return;\n"
"}\n"
"}\n"
"_u_id := null;\n"
"_g_id := null;\n"
"rc := DAV_AUTHENTICATE_HTTP (id, st, \'11_\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"return;\n"
"token := WS.WS.FINDPARAM (lines, \'Lock-Token:\');\n"
"if (token = \'\')\n"
"{\n"
"http_request_status (\'HTTP/1.1 400 Bad Request\');\n"
"return;\n"
"}\n"
"rc := DAV_UNLOCK_INT (id, st, token, null, null, _u_id);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"if (rc = -27)\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return;\n"
"}\n"
"http_request_status (\'HTTP/1.1 424 Failed Dependency: \' || DAV_PERROR (rc));\n"
"return;\n"
"}\n"
"http_request_status (\'HTTP/1.1 204 No Content\');\n"
"return;\n"
"}\n"
"--src dav.sql:2329\n";

static const char *proc31 = 
"create procedure WS.WS.OPLOCKTOKEN ()\n"
"{\n"
"\n"
"return lower (uuid());\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"--src dav.sql:2382\n";

static const char *proc32 = 
"create procedure WS.WS.PARENT_PATH (in path varchar)\n"
"{\n"
"declare tmp any;\n"
"declare inx, len integer;\n"
"inx := 0;\n"
"if (__tag (path) <> 193)\n"
"return NULL;\n"
"len := length (path) - 1;\n"
"if (len < 1)\n"
"return NULL;\n"
"tmp := make_array (len, \'any\');\n"
"while (inx < len)\n"
"{\n"
"aset (tmp, inx, aref (path,inx));\n"
"inx := inx + 1;\n"
"}\n"
"return tmp;\n"
"}\n"
"--src dav.sql:2394\n";

static const char *proc33 = 
"create procedure WS.WS.HREF_TO_ARRAY (in path varchar,in host varchar)\n"
"{\n"
"declare arr, res any;\n"
"declare inx, len integer;\n"
"arr := split_and_decode (path, 0, \'%\\0/\');\n"
"if (isstring (host) and length (host) > 1)\n"
"inx := 3;\n"
"else\n"
"inx := 0;\n"
"res := vector (); len := length (arr);\n"
"while (inx < len)\n"
"{\n"
"if (length (arr[inx]) > 0)\n"
"res := vector_concat (res, vector (arr[inx]));\n"
"inx := inx + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src dav.sql:2414\n";

static const char *proc34 = 
"create procedure WS.WS.HREF_TO_PATH_ARRAY (in path varchar)\n"
"{\n"
"declare arr, res any;\n"
"declare inx, len integer;\n"
"arr := split_and_decode (path, 0, \'%\\0/\');\n"
"if (length (arr) < 1)\n"
"return arr;\n"
"if (arr[0] = \'\')\n"
"inx := 1;\n"
"else if ((length (arr) > 2) and (arr[0][length (arr[0])-1] = 58) and (arr[1] = \'\') and (arr[2] <> \'\'))\n"
"inx := 3;\n"
"else\n"
"inx := 1;\n"
"res := vector (\'\');\n"
"len := length (arr);\n"
"while (inx < len)\n"
"{\n"
"if ((inx = len-1) or (length (arr[inx]) > 0))\n"
"res := vector_concat (res, vector (arr[inx]));\n"
"inx := inx + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src dav.sql:2434\n";

static const char *proc35 = 
"create procedure WS.WS.DSTIS (in path varchar, in host varchar, out rcol integer, out rname varchar)\n"
"{\n"
"declare inx, col, res, id, name_len, depth, cols integer;\n"
"declare name varchar;\n"
"declare rc char;\n"
"\n"
"rc := \'\';\n"
"depth := 0;\n"
"inx := 1;\n"
"name := \'*\';\n"
"col := 0;\n"
"rcol := 0;\n"
"rname := \'\';\n"
"cols := 0;\n"
"\n"
"while (name <> \'\')\n"
"{\n"
"name := WS.WS.PATHREF (path,inx,host,name_len);\n"
"if (name <> \'\')\n"
"{\n"
"cols := cols + 1;\n"
"if (rc = \'\' or rc = \'C\')\n"
"{\n"
"rname := name;\n"
"whenever not found goto no_more_col;\n"
"select COL_ID into col from WS.WS.SYS_DAV_COL where COL_PARENT = col and COL_NAME = name;\n"
"rcol := col;\n"
"depth := depth + 1;\n"
"rc := \'C\';\n"
"}\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"no_more_col:\n"
"while (name <> \'\')\n"
"{\n"
"name := WS.WS.PATHREF (path,inx,host,name_len);\n"
"if (name <> \'\')\n"
"{\n"
"if (rc = \'\' or rc = \'C\')\n"
"{\n"
"rname := name;\n"
"whenever not found goto no_res;\n"
"select RES_ID into res from WS.WS.SYS_DAV_RES where RES_COL = col and RES_NAME = name;\n"
"rcol := col;\n"
"rc := \'R\';\n"
"}\n"
"cols := cols + 1;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"no_res:\n"
"if (rc = \'C\' and cols - 1 = depth)\n"
"rc := \'N\';\n"
"else if (rc = \'C\' and cols - 1 > depth )\n"
"rc := \'E\';\n"
"\n"
"return rc;\n"
"}\n"
"--src dav.sql:2460\n";

static const char *proc36 = 
"create procedure WS.WS.MOVE (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"WS.WS.COPY_OR_MOVE (path, params, lines, 0);\n"
"}\n"
"--src dav.sql:2522\n";

static const char *proc37 = 
"create procedure WS.WS.COPY (in path varchar, inout params varchar, in lines varchar)\n"
"{\n"
"WS.WS.COPY_OR_MOVE (path, params, lines, 1);\n"
"}\n"
"--src dav.sql:2528\n";

static const char *proc38 = 
"create procedure WS.WS.COPY_OR_MOVE (in path varchar, inout params varchar, in lines varchar, in is_copy integer)\n"
"{\n"
"declare _src_name, st, _dst_name varchar;\n"
"declare _host varchar;\n"
"declare _overwrite char;\n"
"declare _inx, _name_len, _res integer;\n"
"declare _len integer;\n"
"declare id, par_id, _src_id integer;\n"
"declare cont  varchar;\n"
"declare uname, upwd, type, newname, _perms varchar;\n"
"declare dstis char;\n"
"declare _u_id, _g_id integer;\n"
"declare col,res,depth,rc,inx integer;\n"
"declare name, target_path, location varchar;\n"
"declare src_id, dst_id, dst_ura, dst_host, _dst_parent any;\n"
"uname := null;\n"
"upwd := null;\n"
"_u_id := null;\n"
"_g_id := null;\n"
"\n"
"set isolation = \'serializable\';\n"
"WS.WS.IS_REDIRECT_REF (path, lines, location);\n"
"_dst_name := WS.WS.FINDPARAM (lines, \'Destination:\');\n"
"_dst_name := WS.WS.FIXPATH (_dst_name);\n"
"_host := WS.WS.FINDPARAM (lines, \'Host:\');\n"
"_overwrite := WS.WS.FINDPARAM (lines, \'Overwrite:\');\n"
"dst_ura := rfc1808_parse_uri (_dst_name);\n"
"dst_host := dst_ura[1];\n"
"dst_host := split_and_decode (dst_host, 0, \'%\');\n"
"\n"
"src_id := DAV_HIDE_ERROR (DAV_SEARCH_SOME_ID (vector_concat (vector(\'\'), path), st));\n"
"if (src_id is null)\n"
"{\n"
"src_id := DAV_HIDE_ERROR (DAV_SEARCH_SOME_ID (vector_concat (vector(\'\'), path, vector(\'\')), st));\n"
"if (src_id is not null)\n"
"{\n"
"path := vector_concat (path, vector(\'\'));\n"
"}\n"
"}\n"
"if (src_id is null)\n"
"{\n"
"\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return;\n"
"}\n"
"rc := DAV_AUTHENTICATE_HTTP (src_id, st, case (is_copy) when 1 then \'1__\' else \'11_\' end, 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"{\n"
"return;\n"
"}\n"
"\n"
"if (WS.WS.ISLOCKED (vector_concat (vector (\'\'), path), lines, _u_id))\n"
"{\n"
"http_request_status (\'HTTP/1.1 423 Locked\');\n"
"return;\n"
"}\n"
"\n"
"target_path := WS.WS.HREF_TO_PATH_ARRAY (_dst_name);\n"
"\n"
"\n"
"if (_host <> \'\' and dst_host <> \'\'\n"
"and _dst_name <> \'\'\n"
"and lower (substring (_dst_name, 1, 7)) = \'http://\'\n"
"and lower (dst_host) <> lower (_host))\n"
"{\n"
"if (is_copy)\n"
"{\n"
"\n"
"log_message (sprintf (\'Copy a WebDAV resource from %s to %s\', _host, _dst_name));\n"
"WS.WS.COPY_TO_OTHER (path, params, lines, _dst_name);\n"
"}\n"
"else\n"
"{\n"
"\n"
"log_message (sprintf (\'Moving a WebDAV resource from %s to %s\', _host, _dst_name));\n"
"if (1 = WS.WS.COPY_TO_OTHER (path, params, lines, _dst_name))\n"
"{\n"
"rc := DAV_DELETE_INT (DAV_CONCAT_PATH (\'/\', path), 0, uname, upwd, 0);\n"
"if (rc <> 1)\n"
"{\n"
"rollback work;\n"
"return rc;\n"
"}\n"
"}\n"
"}\n"
"return;\n"
"}\n"
"\n"
"if (WS.WS.ISLOCKED (target_path, lines, _u_id))\n"
"{\n"
"http_request_status (\'HTTP/1.1 423 Locked\');\n"
"return;\n"
"}\n"
"\n"
"if (\'C\' = st)\n"
"{\n"
"if (target_path[length (target_path) - 1] = \'\')\n"
"_dst_parent := DAV_HIDE_ERROR (DAV_SEARCH_ID (target_path, \'P\'));\n"
"else\n"
"{\n"
"declare tgt_res any;\n"
"tgt_res := DAV_SEARCH_ID (target_path, \'R\');\n"
"if (DAV_HIDE_ERROR (tgt_res) is not null)\n"
"{\n"
"http_request_status (\'HTTP/1.1 409 Conflict\');\n"
"return;\n"
"}\n"
"target_path := vector_concat (target_path, vector (\'\'));\n"
"_dst_parent := DAV_HIDE_ERROR (DAV_SEARCH_ID (target_path, \'P\'));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_dst_parent := DAV_HIDE_ERROR (DAV_SEARCH_ID (target_path, \'P\'));\n"
"}\n"
"if (_dst_parent is null)\n"
"{\n"
"http_request_status (\'HTTP/1.1 409 Conflict\');\n"
"return;\n"
"}\n"
"rc := DAV_AUTHENTICATE_HTTP (_dst_parent, \'C\', \'11_\', 1, lines, uname, upwd, _u_id, _g_id, _perms);\n"
"\n"
"if (rc < 0)\n"
"return;\n"
"if (is_copy)\n"
"{\n"
"rc := DAV_COPY_INT (DAV_CONCAT_PATH (\'/\', path), DAV_CONCAT_PATH (\'/\', target_path), case (_overwrite) when \'T\' then 1 else 0 end, _perms, uname, null, uname, upwd, 0, 0);\n"
"\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_MOVE_INT (DAV_CONCAT_PATH (\'/\', path), DAV_CONCAT_PATH (\'/\', target_path), case (_overwrite) when \'T\' then 1 else 0 end, uname, upwd, 0, 0);\n"
"\n"
"}\n"
"if (DAV_HIDE_ERROR (rc, null) is not null)\n"
"{\n"
"http_request_status (\'HTTP/1.1 204 No Content\');\n"
"return;\n"
"}\n"
"if (rc = 0)	{ http_request_status (\'HTTP/1.1 207 Multi-Status\');		return; }\n"
"if (rc = -2)	{ http_request_status (\'HTTP/1.1 409 Conflict\');		return; }\n"
"if (rc = -3)	{ http_request_status (\'HTTP/1.1 412 Precondition Failed\');	return; }\n"
"DAV_SET_HTTP_REQUEST_STATUS (rc);\n"
"}\n"
"--src dav.sql:2534\n";

static const char *proc39 = 
"create procedure WS.WS.ISLOCKED (in path any, in lines varchar, in _u_id integer)\n"
"{\n"
"declare name, token, if_token varchar;\n"
"declare col, id, rc, len, owner integer;\n"
"declare type, scope char;\n"
"declare l_cur cursor for select LOCK_SCOPE, LOCK_OWNER, LOCK_TOKEN from WS.WS.SYS_DAV_LOCK\n"
"where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = type;\n"
"\n"
"if (exists (select 1 from WS.WS.SYS_DAV_LOCK where datediff (\'second\', LOCK_TIME, now()) > LOCK_TIMEOUT))\n"
"{\n"
"delete from WS.WS.SYS_DAV_LOCK where datediff (\'second\', LOCK_TIME, now()) > LOCK_TIMEOUT;\n"
"\n"
"}\n"
"rc := 0;\n"
"if (path is null)\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"len := length (path);\n"
"if_token := WS.WS.FINDPARAM (lines, \'If:\');\n"
"if (isnull (if_token))\n"
"if_token := \'\';\n"
"id := DAV_HIDE_ERROR (DAV_SEARCH_SOME_ID (path, type), null);\n"
"\n"
"if (id is null)\n"
"return 0;\n"
"if (len > 1)\n"
"{\n"
"rc := WS.WS.ISLOCKED (WS.WS.PARENT_PATH (path), lines, _u_id);\n"
"if (rc > 0)\n"
"return rc;\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_IS_LOCKED\') (id, type, if_token);\n"
"return rc;\n"
"}\n"
"whenever not found goto not_locked;\n"
"open l_cur (prefetch 1);\n"
"fetch l_cur into scope, owner, token;\n"
"if (scope = \'X\')\n"
"rc := 2;\n"
"else\n"
"rc := 1;\n"
"if (not isnull (strstr (if_token, token)))\n"
"rc := 0;\n"
"not_locked:\n"
"\n"
"close l_cur;\n"
"return rc;\n"
"}\n"
"--src dav.sql:2683\n";

static const char *proc40 = 
"create procedure WS.WS.CHECK_AUTH (in lines any)\n"
"{\n"
"declare _u_group, _u_id integer;\n"
"declare _perms varchar;\n"
"_u_id := WS.WS.GET_AUTH (lines, _u_group, _perms);\n"
"return _u_id;\n"
"}\n"
"--src dav.sql:2737\n";

static const char *proc41 = 
"create procedure WS.WS.GET_IF_AUTH (in lines any, out _u_group integer, out _perms varchar)\n"
"{\n"
"declare _u_id integer;\n"
"if (\'\' <> WS.WS.FINDPARAM (lines, \'Authorization:\') and db.dba.vsp_auth_vec (lines) <> 0)\n"
"{\n"
"_u_id := WS.WS.GET_AUTH (lines, _u_group, _perms);\n"
"}\n"
"else\n"
"{\n"
"_u_id := http_nobody_uid ();\n"
"_u_group := http_nogroup_gid ();\n"
"_perms := \'110110110-\' || \'-\';\n"
"connection_set (\'DAVUserID\', _u_id);\n"
"connection_set (\'DAVBillingUserID\', _u_id);\n"
"connection_set (\'DAVGroupID\', _u_group);\n"
"}\n"
"return _u_id;\n"
"}\n"
"--src dav.sql:2747\n";

static const char *proc42 = 
"create procedure WS.WS.GET_DAV_AUTH (in lines any, in allow_anon integer, in can_write_http integer,\n"
"out _u_name varchar, out _u_password varchar, out _uid integer, out _gid integer, out _perms varchar) returns integer\n"
"{\n"
"declare auth any;\n"
"declare _user varchar;\n"
"declare our_auth_vec varchar;\n"
"declare _method, rc integer;\n"
"\n"
"_u_name := null;\n"
"_u_password := null;\n"
"_uid := null;\n"
"_gid := null;\n"
"_perms := null;\n"
"\n"
"auth := db.dba.vsp_auth_vec (lines);\n"
"\n"
"if (0 = auth)\n"
"{\n"
"goto request_auth;\n"
"}\n"
"\n"
"_user := get_keyword (\'username\', auth);\n"
"\n"
"if (_user = \'\' or isnull (_user))\n"
"{\n"
"_user := null;\n"
"goto request_auth;\n"
"}\n"
"\n"
"allow_anon := 0;\n"
"whenever not found goto request_auth;\n"
"\n"
"set isolation=\'committed\';\n"
"select U_NAME, U_PWD, U_GROUP, U_ID, U_METHODS, U_DEF_PERMS\n"
"into _u_name, _u_password, _gid, _uid, _method, _perms from WS.WS.SYS_DAV_USER\n"
"where U_NAME = _user and U_ACCOUNT_DISABLED = 0 and U_PWD is not null with (prefetch 1);\n"
"\n"
"\n"
"\n"
"rc := -1;\n"
"\n"
"if (sys_stat (\'dbev_enable\') and __proc_exists (\'DB.DBA.DBEV_DAV_LOGIN\'))\n"
"{\n"
"rc := DB.DBA.DBEV_DAV_LOGIN (_user, _u_password, auth);\n"
"}\n"
"else\n"
"{\n"
"rc := DB.DBA.LDAP_LOGIN (_user, _u_password, auth);\n"
"}\n"
"\n"
"if (rc = 0)\n"
"goto request_auth;\n"
"if (rc = 1)\n"
"goto authenticated;\n"
"\n"
"\n"
"if (_u_password is null)\n"
"goto request_auth;\n"
"\n"
"if (not db.dba.vsp_auth_verify_pass (auth, _u_name,\n"
"coalesce(get_keyword (\'realm\', auth), \'\'),\n"
"coalesce(get_keyword (\'uri\', auth), \'\'),\n"
"coalesce(get_keyword (\'nonce\', auth), \'\'),\n"
"coalesce(get_keyword (\'nc\', auth),\'\'),\n"
"coalesce(get_keyword (\'cnonce\', auth), \'\'),\n"
"coalesce(get_keyword (\'qop\', auth), \'\'),\n"
"_u_password))\n"
"goto request_auth;\n"
"\n"
"authenticated:\n"
"{\n"
"\n"
"update WS.WS.SYS_DAV_USER set U_LOGIN_TIME = now () where U_NAME = _user\n"
"and U_LOGIN_TIME < dateadd (\'minute\', -2, now ());\n"
"connection_set (\'DAVUserID\', _uid);\n"
"connection_set (\'DAVBillingUserID\', _uid);\n"
"connection_set (\'DAVGroupID\', _gid);\n"
"\n"
"commit work;\n"
"set isolation=\'repeatable\';\n"
"return _uid;\n"
"}\n"
"\n"
"request_auth:\n"
"if (allow_anon)\n"
"{\n"
"_uid := http_nobody_uid ();\n"
"_gid := http_nogroup_gid ();\n"
"connection_set (\'DAVUserID\', _uid);\n"
"connection_set (\'DAVBillingUserID\', _uid);\n"
"connection_set (\'DAVGroupID\', _gid);\n"
"_perms := \'110110110RR\';\n"
"return 0;\n"
"}\n"
"if (not can_write_http)\n"
"return -12;\n"
"db.dba.vsp_auth_get (\'DAV\', \'/DAV\',\n"
"md5 (datestring(now())),\n"
"md5 (\'opaakki\'),\n"
"\'false\', lines, 1);\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>401 Unauthorized</TITLE>\',\n"
"\'</HEAD><BODY><H1>Unauthorized</H1>\',\n"
"\'Access to page is forbidden.</BODY></HTML>\'));\n"
"return -24;\n"
"}\n"
"--src dav.sql:2767\n";

static const char *proc43 = 
"create procedure WS.WS.PERM_COMP (in perm varchar, in mask varchar)\n"
"{\n"
"declare inx integer;\n"
"inx := 0;\n"
"if (length (perm) <> 3 or length (mask) <> 3)\n"
"return 0;\n"
"\n"
"while (inx < 3)\n"
"{\n"
"if (aref (mask, inx) = ascii(\'1\') and aref (perm, inx) <> ascii(\'1\'))\n"
"{\n"
"return 0;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return 1;\n"
"}\n"
"--src dav.sql:2876\n";

static const char *proc44 = 
"create procedure WS.WS.CHECKPERM ( in path varchar, in _u_id integer, in action varchar)\n"
"{\n"
"declare g_id, _user, _group integer;\n"
"declare _perms varchar;\n"
"declare name varchar;\n"
"declare col integer;\n"
"declare temp varchar;\n"
"declare rc integer;\n"
"rc := 0;\n"
"_perms := \'000000000\';\n"
"if (_u_id > 0 and _u_id is not null)\n"
"{\n"
"g_id := connection_get (\'DAVGroupID\');\n"
"}\n"
"\n"
"if (_u_id = http_dav_uid () and action not like \'__1\')\n"
"{\n"
"connection_set (\'DAVQuota\', -1);\n"
"return 1;\n"
"}\n"
"if (WS.WS.ISCOL (path))\n"
"{\n"
"WS.WS.FINDCOL (path, col);\n"
"select COL_OWNER, COL_GROUP, COL_PERMS into _user, _group, _perms from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"}\n"
"else if (WS.WS.ISRES (path))\n"
"{\n"
"WS.WS.FINDRES (path, col, name);\n"
"select RES_OWNER, RES_GROUP, RES_PERMS into _user, _group, _perms\n"
"from WS.WS.SYS_DAV_RES where RES_COL = col and RES_NAME = name;\n"
"}\n"
"else if (not WS.WS.ISCOL(path) and not WS.WS.ISRES (path) and WS.WS.ISCOL (WS.WS.PARENT_PATH (path)))\n"
"{\n"
"if (is_http_ctx())\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return 0;\n"
"}\n"
"if (_perms is null)\n"
"return 0;\n"
"if (_u_id = _user)\n"
"{\n"
"temp := substring (cast (_perms as varchar), 1, 3);\n"
"rc := WS.WS.PERM_COMP (temp, action);\n"
"}\n"
"if (_group = g_id and rc = 0)\n"
"{\n"
"temp := substring (cast (_perms as varchar), 4, 3);\n"
"rc := WS.WS.PERM_COMP (temp, action);\n"
"}\n"
"if (rc = 0)\n"
"{\n"
"temp := substring (cast (_perms as varchar), 7, 3);\n"
"rc := WS.WS.PERM_COMP (temp, action);\n"
"}\n"
"\n"
"if (rc = 0)\n"
"{\n"
"temp := substring (cast (_perms as varchar), 4, 3);\n"
"rc := WS.WS.PERM_COMP (temp, action);\n"
"if (rc > 0 and exists (select 1 from WS.WS.SYS_DAV_USER_GROUP where UG_UID = _u_id and UG_GID = _group))\n"
"{\n"
"rc := 1;\n"
"}\n"
"else\n"
"rc := 0;\n"
"}\n"
"if (rc = 0 and is_http_ctx ())\n"
"{\n"
"http_request_status (\'HTTP/1.1 403 Forbidden\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>403 Forbidden</TITLE>\',\n"
"\'</HEAD><BODY><H1>Forbidden</H1>\',\n"
"\'Resource is forbidden.</BODY></HTML>\'));\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav.sql:2896\n";

static const char *proc45 = 
"create procedure WS.WS.ISPUBLIC (in path varchar, in ask varchar)\n"
"{\n"
"declare perms, name, given varchar;\n"
"declare res, col integer;\n"
"whenever not found goto nf;\n"
"if (WS.WS.ISCOL (path))\n"
"{\n"
"WS.WS.FINDCOL (path, col);\n"
"select COL_PERMS into perms from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"}\n"
"else if (WS.WS.ISRES (path))\n"
"{\n"
"WS.WS.FINDRES (path, col, name);\n"
"select RES_PERMS into perms from WS.WS.SYS_DAV_RES where RES_NAME = name and RES_COL = col;\n"
"}\n"
"else\n"
"return 0;\n"
"if (perms is null)\n"
"return 0;\n"
"given := substring (cast (perms as varchar), 7, 3);\n"
"return WS.WS.PERM_COMP (given, ask);\n"
"nf:\n"
"return 0;\n"
"}\n"
"--src dav.sql:2975\n";

static const char *proc46 = 
"create procedure\n"
"WS.WS.DAV_VSP_DEF_REMOVE (in path varchar)\n"
"{\n"
"if (path like \'%.vsp\')\n"
"{\n"
"declare stat, msg varchar;\n"
"stat := \'00000\'; msg := \'\';\n"
"for select P_NAME from DB.DBA.SYS_PROCEDURES where P_NAME like concat (\'%.%.\', path)\n"
"do\n"
"{\n"
"exec (sprintf (\'drop procedure \"%s\"\', P_NAME), stat, msg);\n"
"}\n"
"}\n"
"}\n"
"--src dav.sql:3001\n";

static const char *proc47 = 
"create function DAV_PERMS_SET_CHAR (in perms varchar, in ch any, in pos integer) returns varchar\n"
"{\n"
"declare l integer;\n"
"l := length (perms);\n"
"if (l < 11)\n"
"perms := perms || subseq (\'000000000--\', l);\n"
"if (isinteger (ch))\n"
"perms [pos] := ch;\n"
"else\n"
"perms[pos] := ch[0];\n"
"return perms;\n"
"}\n"
"--src dav.sql:3017\n";

static const char *proc48 = 
"create procedure DAV_PERMS_FIX (inout perms varchar, in full_perms varchar)\n"
"{\n"
"declare l integer;\n"
"l := length (perms);\n"
"if (l < 11)\n"
"perms := perms || subseq (full_perms, l);\n"
"if (ascii(\'-\') = perms [9])\n"
"perms[9] := full_perms[9];\n"
"if (ascii(\'-\') = perms [10])\n"
"perms[10] := full_perms[10];\n"
"}\n"
"--src dav.sql:3031\n";

static const char *proc49 = 
"create procedure DAV_PERMS_INHERIT (inout perms varchar, in parent_perms varchar, in force_parent integer := 0)\n"
"{\n"
"declare l integer;\n"
"l := length (perms);\n"
"if (l < 11)\n"
"perms := perms || subseq (parent_perms, l);\n"
"if ((ascii(\'-\') = perms [9]) or (force_parent and (ascii(\'T\') <> parent_perms [9])))\n"
"perms[9] := parent_perms[9];\n"
"if ((ascii(\'-\') = perms [10]) or (force_parent and (ascii(\'M\') <> parent_perms [10])))\n"
"perms[10] := parent_perms[10];\n"
"}\n"
"--src dav.sql:3044\n";

static const char *trig0 = 
"create trigger SYS_DAV_RES_FULL_PATH_I after insert on WS.WS.SYS_DAV_RES order 0 referencing new as N\n"
"{\n"
"declare full_path, name, _pflags, _rflags, _inh varchar;\n"
"declare parent_col, col, res integer;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"col := N.RES_COL;\n"
"res := N.RES_ID;\n"
"_rflags := N.RES_PERMS;\n"
"full_path := concat (\'/\', N.RES_NAME);\n"
"select COL_PERMS, COL_INHERIT into _pflags, _inh from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"if (_inh = \'R\' or _inh = \'M\')\n"
"_rflags := _pflags;\n"
"DAV_PERMS_FIX (_pflags, \'000000000TM\');\n"
"DAV_PERMS_INHERIT (_rflags, _pflags);\n"
"whenever not found goto not_found;\n"
"while (1)\n"
"{\n"
"select COL_NAME, COL_PARENT into name, parent_col from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"col := parent_col;\n"
"full_path := concat (\'/\', name, full_path);\n"
"}\n"
"not_found:\n"
"DAV_SPACE_QUOTA_RES_INSERT (full_path, length (N.RES_CONTENT));\n"
"set triggers off;\n"
"\n"
"if (_rflags <> N.RES_PERMS)\n"
"{\n"
"update WS.WS.SYS_DAV_RES set RES_FULL_PATH = full_path, RES_PERMS = _rflags where RES_ID = res;\n"
"N.RES_PERMS := _rflags;\n"
"}\n"
"else\n"
"update WS.WS.SYS_DAV_RES set RES_FULL_PATH = full_path where RES_ID = res;\n"
"\n"
"\n"
"N.RES_FULL_PATH := full_path;\n"
"\n"
"declare pub varchar;\n"
"declare uname, gname varchar;\n"
"uname := \'\'; gname := \'\';\n"
"pub := WS.WS.ISPUBL (full_path);\n"
"if (isstring (pub))\n"
"{\n"
"\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = N.RES_OWNER;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = N.RES_GROUP;\n"
"nfg:;\n"
"repl_text (pub, \'\"DB.DBA.DAV_RES_I\" (?, ?, ?, ?, ?, ?, ?)\', full_path, N.RES_CR_TIME,\n"
"uname, gname, N.RES_PERMS, N.RES_TYPE, WS.WS.BODY_ARR (N.RES_CONTENT, null));\n"
"}\n"
"\n"
"if (N.RES_TYPE = \'text/xsl\')\n"
"xslt_stale (concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', N.RES_FULL_PATH));\n"
"\n"
"}\n"
"--src dav.sql:3058\n";

static const char *trig1 = 
"create trigger SYS_DAV_RES_FULL_PATH_BU before update on WS.WS.SYS_DAV_RES referencing old as O, new as N\n"
"{\n"
"declare _pflags, _rflags, _inh varchar;\n"
"declare col integer;\n"
"\n"
"_rflags := N.RES_PERMS;\n"
"if ((O.RES_COL <> N.RES_COL) or (O.RES_PERMS <> N.RES_PERMS))\n"
"{\n"
"col := N.RES_COL;\n"
"select COL_PERMS, COL_INHERIT into _pflags, _inh from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"if (_inh = \'M\' or _inh = \'R\')\n"
"_rflags := _pflags;\n"
"DAV_PERMS_FIX (_pflags, \'000000000TM\');\n"
"DAV_PERMS_INHERIT (_rflags, _pflags, neq (O.RES_COL, N.RES_COL));\n"
"}\n"
"if (_rflags <> N.RES_PERMS)\n"
"{\n"
"set triggers off;\n"
"\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = _rflags where RES_ID = N.RES_ID;\n"
"N.RES_PERMS := _rflags;\n"
"}\n"
"\n"
"}\n"
"--src dav.sql:3124\n";

static const char *trig2 = 
"create trigger SYS_DAV_RES_FULL_PATH_U after update on WS.WS.SYS_DAV_RES referencing old as O, new as N\n"
"{\n"
"declare full_path, name varchar;\n"
"declare parent_col, col, res integer;\n"
"declare str, cont varchar;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"col := N.RES_COL;\n"
"res := N.RES_ID;\n"
"full_path := concat (\'/\', N.RES_NAME);\n"
"whenever not found goto not_found;\n"
"while (1)\n"
"{\n"
"select COL_NAME, COL_PARENT into name, parent_col from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"col := parent_col;\n"
"full_path := concat (\'/\', name, full_path);\n"
"}\n"
"not_found:\n"
"set triggers off;\n"
"DAV_SPACE_QUOTA_RES_UPDATE (O.RES_FULL_PATH, length (O.RES_CONTENT), full_path, length (N.RES_CONTENT));\n"
"\n"
"if (O.RES_FULL_PATH <> full_path)\n"
"{\n"
"update WS.WS.VFS_URL set VU_ETAG = \'\' where concat (\'/DAV/\', VU_ROOT, VU_URL) = O.RES_FULL_PATH;\n"
"\n"
"}\n"
"\n"
"WS.WS.DAV_VSP_DEF_REMOVE (O.RES_FULL_PATH);\n"
"\n"
"update WS.WS.SYS_DAV_RES set RES_FULL_PATH = full_path where RES_ID = res;\n"
"N.RES_FULL_PATH := full_path;\n"
"\n"
"\n"
"\n"
"declare pub, pub1 varchar;\n"
"declare uname, gname varchar;\n"
"uname := \'\'; gname := \'\';\n"
"pub := WS.WS.ISPUBL (O.RES_FULL_PATH);\n"
"pub1 := WS.WS.ISPUBL (full_path);\n"
"if (isstring (pub))\n"
"{\n"
"\n"
"repl_text (pub, \'\"DB.DBA.DAV_RES_D\" (?)\', O.RES_FULL_PATH);\n"
"}\n"
"\n"
"if (isstring (pub1))\n"
"{\n"
"\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = N.RES_OWNER;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = N.RES_GROUP;\n"
"nfg:;\n"
"repl_text (pub1, \'\"DB.DBA.DAV_RES_I\" (?, ?, ?, ?, ?, ?, ?)\', full_path, N.RES_MOD_TIME,\n"
"uname, gname, N.RES_PERMS, N.RES_TYPE, WS.WS.BODY_ARR (N.RES_CONTENT, null));\n"
"}\n"
"\n"
"if (N.RES_TYPE = \'text/xsl\')\n"
"xslt_stale (concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', N.RES_FULL_PATH));\n"
"\n"
"}\n"
"--src dav.sql:3150\n";

static const char *trig3 = 
"create trigger SYS_DAV_COL_U after update on WS.WS.SYS_DAV_COL referencing old as O, new as N\n"
"{\n"
"declare full_path, name, _pflags, _cflags varchar;\n"
"declare old_col_path, new_col_path varchar;\n"
"declare res, col integer;\n"
"\n"
"col := N.COL_PARENT;\n"
"res := N.COL_ID;\n"
"full_path := concat (\'/\', N.COL_NAME,\'/\');\n"
"_cflags := N.COL_PERMS;\n"
"_pflags := coalesce ((select COL_PERMS from WS.WS.SYS_DAV_COL where COL_ID = col), \'000000000TM\');\n"
"if ((O.COL_PARENT <> N.COL_PARENT) or (O.COL_PERMS <> N.COL_PERMS))\n"
"{\n"
"DAV_PERMS_FIX (_pflags, \'000000000TM\');\n"
"DAV_PERMS_INHERIT (_cflags, _pflags);\n"
"}\n"
"whenever not found goto not_found;\n"
"while (1)\n"
"{\n"
"select COL_NAME, COL_PARENT into name, col from WS.WS.SYS_DAV_COL where COL_ID = col;\n"
"full_path := concat (\'/\', name, full_path);\n"
"}\n"
"not_found:\n"
"set triggers off;\n"
"if (_cflags <> N.COL_PERMS)\n"
"{\n"
"\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = _cflags where COL_ID = res;\n"
"N.COL_PERMS := _cflags;\n"
"}\n"
"old_col_path := concat (WS.WS.COL_PATH (O.COL_PARENT), O.COL_NAME, \'/\');\n"
"new_col_path := WS.WS.COL_PATH (N.COL_ID);\n"
"if (old_col_path <> new_col_path)\n"
"{\n"
"\n"
"for\n"
"select SUBCOL_ID, SUBCOL_FULL_PATH as old_subcol_path, SUBCOL_DET\n"
"from DAV_PLAIN_SUBMOUNTS\n"
"where root_id = O.COL_ID and root_path = old_col_path and recursive=1 and subcol_auth_uid = http_dav_uid()\n"
"and not (SUBCOL_DET like \'%Filter\')\n"
"do\n"
"{\n"
"declare new_subcol_path varchar;\n"
"new_subcol_path := new_col_path || subseq (old_subcol_path, length (old_col_path));\n"
"for\n"
"select CF_ID from WS.WS.SYS_DAV_CATFILTER\n"
"where (\n"
"(\"LEFT\" (old_subcol_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH) and\n"
"(\"LEFT\" (new_subcol_path, length (CF_SEARCH_PATH)) <> CF_SEARCH_PATH) )\n"
"do\n"
"{\n"
"delete from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_CF_ID = CF_ID and CFD_DET_SUBCOL_ID = SUBCOL_ID;\n"
"}\n"
"for\n"
"select CF_ID from WS.WS.SYS_DAV_CATFILTER\n"
"where (\n"
"(\"LEFT\" (old_subcol_path, length (CF_SEARCH_PATH)) <> CF_SEARCH_PATH) and\n"
"(\"LEFT\" (new_subcol_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH) )\n"
"do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET) values (CF_ID, SUBCOL_ID, SUBCOL_DET);\n"
"}\n"
"}\n"
"}\n"
"if (\n"
"(N.COL_DET is not null or O.COL_DET is not null) and\n"
"not (N.COL_DET is not null and O.COL_DET is not null and (N.COL_DET = O.COL_DET) and (N.COL_ID = O.COL_ID) and (N.COL_PARENT = O.COL_PARENT)))\n"
"{\n"
"\n"
"delete from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_DET_SUBCOL_ID = O.COL_ID;\n"
"if (N.COL_DET is not null and not (N.COL_DET like \'%Filter\'))\n"
"{\n"
"for select CF_ID from WS.WS.SYS_DAV_CATFILTER where \"LEFT\" (new_col_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET)\n"
"values (CF_ID, N.COL_ID, N.COL_DET);\n"
"}\n"
"}\n"
"}\n"
"\n"
"declare repl varchar;\n"
"repl := null;\n"
"declare pub, pub1 varchar;\n"
"declare uname, gname varchar;\n"
"\n"
"uname := \'\'; gname := \'\';\n"
"pub := WS.WS.ISPUBL (old_col_path);\n"
"pub1 := WS.WS.ISPUBL (new_col_path);\n"
"if (isstring (pub1))\n"
"{\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = N.COL_OWNER;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = N.COL_GROUP;\n"
"nfg:;\n"
"}\n"
"if ((not isstring (pub) and isstring (pub1)) or (isstring (pub) and isstring (pub1) and pub <> pub1))\n"
"{\n"
"\n"
"repl_text (pub1, \'\"DB.DBA.DAV_COL_I\" (?, ?, ?, ?, ?, ?)\',\n"
"N.COL_NAME, new_col_path, N.COL_CR_TIME, uname, gname,\n"
"N.COL_PERMS );\n"
"repl := pub1;\n"
"}\n"
"if (isstring (pub) and isstring (pub1) and pub = pub1)\n"
"{\n"
"\n"
"repl_text (pub1, \'\"DB.DBA.DAV_COL_U\" (?, ?, ?, ?, ?, ?)\',\n"
"old_col_path, new_col_path, N.COL_CR_TIME, uname, gname,\n"
"N.COL_PERMS );\n"
"}\n"
"if ((not isstring (pub1) and isstring (pub)) or (isstring (pub) and isstring (pub1) and pub <> pub1))\n"
"{\n"
"\n"
"repl_text (pub, \'\"DB.DBA.DAV_COL_D\" (?, 1)\', old_col_path);\n"
"}\n"
"\n"
"\n"
"update WS.WS.VFS_URL set VU_ETAG = \'\' where substring (concat (\'/DAV/\', VU_ROOT, VU_URL), 1, length (old_col_path)) = old_col_path;\n"
"WS.WS.UPDCHILD (res, full_path, _pflags, repl);\n"
"set triggers on;\n"
"if (ascii(\'R\') = _pflags[9])\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = DAV_PERMS_SET_CHAR (RES_PERMS, \'T\', 9)\n"
"where (RES_FULL_PATH between full_path and DAV_COL_PATH_BOUNDARY (full_path))\n"
"and RES_PERMS[9] = ascii (\'N\');\n"
"else\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = DAV_PERMS_SET_CHAR (RES_PERMS, _pflags[9], 9)\n"
"where RES_COL = res and (case (lt (length (RES_PERMS), 10)) when 1 then 0 else RES_PERMS[9] end) <> _pflags[9];\n"
"if (ascii(\'R\') = _pflags[10])\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = DAV_PERMS_SET_CHAR (RES_PERMS, \'M\', 10)\n"
"where (RES_FULL_PATH between full_path and DAV_COL_PATH_BOUNDARY (full_path))\n"
"and RES_PERMS[10] = ascii (\'N\');\n"
"else\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = DAV_PERMS_SET_CHAR (RES_PERMS, _pflags[10], 10)\n"
"where RES_COL = res and (case (lt (length (RES_PERMS), 11)) when 1 then 0 else RES_PERMS[10] end) <> _pflags[10];\n"
"\n"
"}\n"
"--src dav.sql:3222\n";

static const char *proc50 = 
"create procedure WS.WS.UPDCHILD (in col integer, in root_path varchar, in _pflags varchar, in repl varchar)\n"
"{\n"
"declare name, new_path, str varchar;\n"
"declare id integer;\n"
"declare c_cur cursor for select COL_ID, COL_NAME, COL_MOD_TIME, COL_PERMS, COL_OWNER, COL_GROUP\n"
"from WS.WS.SYS_DAV_COL where COL_PARENT = col;\n"
"\n"
"for select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_COL = col and RES_NAME like \'%.vsp\' do\n"
"{\n"
"WS.WS.DAV_VSP_DEF_REMOVE (RES_FULL_PATH);\n"
"}\n"
"\n"
"update WS.WS.SYS_DAV_RES set RES_FULL_PATH = concat (root_path, RES_NAME) where RES_COL = col and ((RES_FULL_PATH <> concat (root_path, RES_NAME)) or RES_FULL_PATH is null);\n"
"if (ascii (\'R\') = _pflags[9])\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = DAV_PERMS_SET_CHAR (COL_PERMS, \'R\', 9)\n"
"where COL_PARENT = col and ascii (\'R\') <> COL_PERMS[9];\n"
"if (ascii (\'R\') = _pflags[10])\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = DAV_PERMS_SET_CHAR (COL_PERMS, \'R\', 10)\n"
"where COL_PARENT = col and ascii (\'R\') <> COL_PERMS[10];\n"
"\n"
"\n"
"declare _grp, _uid integer;\n"
"declare cperms varchar;\n"
"declare ctime datetime;\n"
"declare uname, gname varchar;\n"
"declare rn, rt, rc, rp varchar;\n"
"declare ro, rg integer;\n"
"declare rmt datetime;\n"
"declare chr cursor for select RES_NAME, RES_TYPE, RES_CONTENT, RES_PERMS,\n"
"RES_OWNER, RES_GROUP, RES_MOD_TIME from WS.WS.SYS_DAV_RES\n"
"where RES_COL = col;\n"
"if (repl is not null)\n"
"{\n"
"whenever not found goto er;\n"
"open chr;\n"
"while (1)\n"
"{\n"
"fetch chr into rn, rt, rc, rp, ro, rg, rmt;\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = ro;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = rg;\n"
"nfg:;\n"
"repl_text (repl, \'\"DB.DBA.DAV_RES_I\" (?, ?, ?, ?, ?, ?, ?)\', concat (root_path, rn),\n"
"rmt, uname, gname, rp, rt, WS.WS.BODY_ARR (rc, null));\n"
"}\n"
"er:\n"
"close chr;\n"
"\n"
"}\n"
"\n"
"whenever not found goto not_col;\n"
"open c_cur;\n"
"while (1)\n"
"{\n"
"fetch c_cur into id, name, ctime, cperms, _uid, _grp;\n"
"new_path := concat (root_path, name, \'/\');\n"
"\n"
"if (repl is not null)\n"
"{\n"
"whenever not found goto nfu1;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = _uid;\n"
"nfu1:;\n"
"whenever not found goto nfg1;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = _grp;\n"
"nfg1:;\n"
"repl_text (repl, \'\"DB.DBA.DAV_COL_I\" (?, ?, ?, ?, ?, ?)\',\n"
"name, new_path, ctime, uname, gname,\n"
"cperms );\n"
"}\n"
"\n"
"WS.WS.UPDCHILD (id, new_path, _pflags, repl);\n"
"}\n"
"not_col:\n"
"close c_cur;\n"
"}\n"
"--src dav.sql:3362\n";

static const char *trig4 = 
"create trigger SYS_DAV_COL_I after insert on WS.WS.SYS_DAV_COL referencing new as N\n"
"{\n"
"declare _pflags, _cflags, col_path, _inh varchar;\n"
"declare _col, _p_col integer;\n"
"\n"
"_col := N.COL_ID;\n"
"_p_col := N.COL_PARENT;\n"
"col_path := WS.WS.COL_PATH (N.COL_ID);\n"
"set triggers off;\n"
"_cflags := N.COL_PERMS;\n"
"_pflags := \'000000000NN\';\n"
"_inh := \'N\';\n"
"for select COL_PERMS, COL_INHERIT from WS.WS.SYS_DAV_COL where COL_ID = _p_col do\n"
"{\n"
"_pflags := COL_PERMS;\n"
"_inh := COL_INHERIT;\n"
"}\n"
"if (_inh = \'R\')\n"
"_cflags := _pflags;\n"
"DAV_PERMS_FIX (_cflags, _pflags);\n"
"if (_cflags <> N.COL_PERMS)\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = _cflags where COL_ID = _col;\n"
"if (N.COL_DET is not null and not (N.COL_DET like \'%Filter\'))\n"
"{\n"
"for select CF_ID from WS.WS.SYS_DAV_CATFILTER where \"LEFT\" (col_path, length (CF_SEARCH_PATH)) = CF_SEARCH_PATH do\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET)\n"
"values (CF_ID, _col, N.COL_DET);\n"
"}\n"
"}\n"
"\n"
"declare pub varchar;\n"
"declare uname, gname varchar;\n"
"uname := \'\'; gname := \'\';\n"
"pub := WS.WS.ISPUBL (col_path);\n"
"if (isstring (pub))\n"
"{\n"
"\n"
"whenever not found goto nfu;\n"
"select U_NAME into uname from WS.WS.SYS_DAV_USER where U_ID = N.COL_OWNER;\n"
"nfu:;\n"
"whenever not found goto nfg;\n"
"select G_NAME into gname from WS.WS.SYS_DAV_GROUP where G_ID = N.COL_GROUP;\n"
"nfg:;\n"
"repl_text (pub, \'\"DB.DBA.DAV_COL_I\" (?, ?, ?, ?, ?, ?)\',\n"
"N.COL_NAME, col_path, N.COL_CR_TIME, uname, gname, N.COL_PERMS );\n"
"}\n"
"\n"
"\n"
"}\n"
"--src dav.sql:3441\n";

static const char *proc51 = 
"create procedure\n"
"WS.WS.DAV_VSP_INCLUDES_CHANGED (in full_path varchar, in own varchar)\n"
"{\n"
"declare incst, dep any;\n"
"dep := null;\n"
"incst := registry_get (concat (\'__depend_\', own, \'_\', full_path));\n"
"if (isstring (incst))\n"
"dep := deserialize (incst);\n"
"if (isarray (dep))\n"
"{\n"
"declare i, l integer;\n"
"declare mt datetime;\n"
"l := length (dep); i := 0;\n"
"if (mod (l, 2))\n"
"return 1;\n"
"while (i < l)\n"
"{\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH = dep [i] and RES_MOD_TIME = stringdate(dep [i+1])))\n"
"return 1;\n"
"i := i + 2;\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav.sql:3493\n";

static const char *proc52 = 
"create procedure WS.WS.EXPAND_INCLUDES (in path varchar, inout stream varchar, in level integer,\n"
"in ct integer, in content varchar, inout st any := null)\n"
"{\n"
"declare curr_file, new_file_name, name, _perms varchar;\n"
"declare include_inx, end_tag_inx, _u_id, _grp integer;\n"
"declare apath any;\n"
"declare rc, col integer;\n"
"declare modt datetime;\n"
"\n"
"end_tag_inx := 0;\n"
"if (ct = 0)\n"
"{\n"
"apath := WS.WS.HREF_TO_ARRAY (path, \'\');\n"
"rc := WS.WS.FINDRES (apath, col, name);\n"
"}\n"
"else\n"
"{\n"
"rc := 1;\n"
"}\n"
"\n"
"if (rc < 0 and 0 <> file_stat (http_root () || path))\n"
"{\n"
"content := file_to_string (http_root () || path);\n"
"ct := 1;\n"
"rc := 1;\n"
"}\n"
"\n"
"if (isarray (rc))\n"
"signal (\'37000\', sprintf (\'The included resource \"%s\" is a special \"%s\" resource, not a plain DAV one\', path, rc[0]), \'DA010\');\n"
"if (rc < 0)\n"
"signal (\'37000\', sprintf (\'The included resource \"%s\" does not exist\', path), \'DA009\');\n"
"else\n"
"{\n"
"if (ct = 0)\n"
"{\n"
"declare exit handler for not found\n"
"{\n"
"signal (\'22023\', sprintf (\'The included resource \"%s\" does not exist\', path), \'DA009\');\n"
"};\n"
"select blob_to_string (RES_CONTENT), RES_OWNER, RES_GROUP, RES_PERMS, RES_MOD_TIME\n"
"into curr_file, _u_id, _grp, _perms, modt from WS.WS.SYS_DAV_RES\n"
"where RES_NAME = name and RES_COL = col;\n"
"if (_u_id <> http_dav_uid () or _perms like \'____1%\' or _perms like \'_______1%\')\n"
"signal (\'37000\', \'Includes can be owned only by admin & cannot be writable for others\', \'DA001\');\n"
"if (st is not null and isarray (st))\n"
"st := vector_concat (st, vector (path, datestring(modt)));\n"
"}\n"
"else\n"
"curr_file := content;\n"
"}\n"
"\n"
"include_inx := strcasestr (curr_file, \'<?include\');\n"
"while (include_inx is not null)\n"
"{\n"
"if (level > 20)\n"
"signal ( \'37000\', sprintf (\'Max nesting level (20) reached when processing %s\', path), \'DA002\');\n"
"end_tag_inx := strstr (subseq (curr_file, include_inx, length (curr_file)), \'?>\');\n"
"if (end_tag_inx is null)\n"
"signal ( \'37000\', sprintf (\'Unterminated include tag at offset %d in %s\', include_inx, path), \'DA003\');\n"
"end_tag_inx := end_tag_inx + include_inx;\n"
"if (end_tag_inx - include_inx - 9 <= 0)\n"
"signal ( \'37000\',\n"
"sprintf (\'An include tag at offset %d with no name or VSP end tag before an include tag in %s \',\n"
"include_inx, path), \'DA004\');\n"
"if (include_inx > 0)\n"
"http (subseq (curr_file, 0, include_inx), stream);\n"
"new_file_name := trim (subseq (curr_file, include_inx + 9, end_tag_inx));\n"
"if (aref (new_file_name, 0) <> ascii( \'/\'))\n"
"{\n"
"\n"
"new_file_name :=  WS.WS.EXPAND_URL (path, new_file_name);\n"
"}\n"
"WS.WS.EXPAND_INCLUDES (new_file_name, stream, level + 1, 0, \'\', st);\n"
"if (end_tag_inx + 2 <= length (curr_file))\n"
"curr_file := subseq (curr_file, end_tag_inx + 2, length (curr_file));\n"
"include_inx := strcasestr (curr_file, \'<?include\');\n"
"}\n"
"if (length (curr_file) > 0)\n"
"http (curr_file, stream);\n"
"}\n"
"--src dav.sql:3521\n";

static const char *trig5 = 
"create trigger SYS_DAV_RES_FULL_PATH_D after delete on WS.WS.SYS_DAV_RES\n"
"{\n"
"set triggers off;\n"
"\n"
"DAV_SPACE_QUOTA_RES_DELETE (RES_FULL_PATH, length (RES_CONTENT));\n"
"\n"
"\n"
"WS.WS.DAV_VSP_DEF_REMOVE (RES_FULL_PATH);\n"
"if (RES_TYPE = \'xml/persistent-view\')\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = RES_FULL_PATH;\n"
"\n"
"declare pub varchar;\n"
"pub := WS.WS.ISPUBL (RES_FULL_PATH);\n"
"if (isstring (pub))\n"
"{\n"
"\n"
"repl_text (pub, \'\"DB.DBA.DAV_RES_D\" (?)\', RES_FULL_PATH);\n"
"}\n"
"\n"
"\n"
"update WS.WS.VFS_URL set VU_ETAG = \'\' where concat (\'/DAV/\', VU_ROOT, VU_URL) = RES_FULL_PATH;\n"
"delete from WS.WS.VFS_QUEUE where concat (\'/DAV/\', VQ_ROOT, VQ_URL) = RES_FULL_PATH;\n"
"if (RES_NAME = \'index.html\')\n"
"{\n"
"delete from WS.WS.VFS_URL  where concat (\'/DAV/\', VU_ROOT, VU_URL) = WS.WS.COL_PATH (RES_COL);\n"
"if (not exists (select 1 from WS.WS.VFS_SITE where\n"
"concat (\'/DAV/\', VS_ROOT, VS_URL) = WS.WS.COL_PATH (RES_COL)))\n"
"delete from WS.WS.VFS_QUEUE where concat (\'/DAV/\', VQ_ROOT, VQ_URL) = WS.WS.COL_PATH (RES_COL);\n"
"}\n"
"if (RES_TYPE = \'text/xsl\')\n"
"xslt_stale (concat (\'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\', RES_FULL_PATH));\n"
"\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_TYPE = \'R\' and PROP_PARENT_ID = RES_ID;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'R\' and LOCK_PARENT_ID = RES_ID;\n"
"delete from WS.WS.SYS_DAV_TAG where DT_RES_ID = RES_ID;\n"
"\n"
"}\n"
"--src dav.sql:3603\n";

static const char *trig6 = 
"create trigger SYS_DAV_COL_D before delete on WS.WS.SYS_DAV_COL order 100\n"
"{\n"
"declare pub, col_path varchar;\n"
"col_path := WS.WS.COL_PATH (COL_ID);\n"
"\n"
"delete from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_DET_SUBCOL_ID = COL_ID;\n"
"\n"
"pub := WS.WS.ISPUBL (col_path);\n"
"if (isstring (pub))\n"
"{\n"
"\n"
"repl_text (pub, \'\"DB.DBA.DAV_COL_D\" (?, 0)\', col_path);\n"
"}\n"
"\n"
"if (COL_PARENT = 1)\n"
"{\n"
"update WS.WS.VFS_URL set VU_ETAG = \'\'  where VU_ROOT = COL_NAME;\n"
"delete from WS.WS.VFS_QUEUE where VQ_ROOT = COL_NAME\n"
"and VQ_URL <> (select VS_URL from WS.WS.VFS_SITE where VS_ROOT = COL_NAME);\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT\n"
"where \"RIGHT\"(SE_NAME, length (COL_NAME) + 2) = concat (\'/\', COL_NAME, \')\');\n"
"}\n"
"\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_TYPE = \'C\' and PROP_PARENT_ID = COL_ID;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = COL_ID;\n"
"\n"
"}\n"
"--src dav.sql:3642\n";

static const char *proc53 = 
"create procedure WS.WS.XML_VIEW_HEADER\n"
"(\n"
"in view_name varchar,\n"
"in top_tag varchar,\n"
"in path varchar,\n"
"in meta_mode integer,\n"
"in meta_data varchar,\n"
"inout http_body any\n"
")\n"
"{\n"
"if (meta_mode = 0)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<\',top_tag,\'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 1)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<!DOCTYPE \', top_tag, \' [\\n\'), http_body);\n"
"http (xml_view_dtd (view_name, top_tag), http_body);\n"
"http (concat (meta_data, \'] >\\n\'), http_body);\n"
"http (concat (\'<\',top_tag,\'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 2)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<!DOCTYPE \', top_tag, \' SYSTEM \"\', path, \'.dtd\">\'), http_body);\n"
"http (concat (\'<\',top_tag,\'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 3)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\"  ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<!DOCTYPE \', top_tag, \' \', meta_data, \'>\'), http_body);\n"
"http (concat (\'<\',top_tag,\'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 4)\n"
"{\n"
"signal (\'22023\', \'Unsupported type of metadata\', \'DA005\');\n"
"http (sprintf (\'<?xml version=\"1.0\"  encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<\',top_tag,\' xmlns=\"\', path, \'.xsd\" \',meta_data, \'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 5)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<\',top_tag,\' xmlns=\"\', path, \'.xsd\" \', meta_data, \'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"if (meta_mode = 6)\n"
"{\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', current_charset()), http_body);\n"
"http (concat (\'<\',top_tag ,\' \' , meta_data, \'>\\n\'), http_body);\n"
"return;\n"
"}\n"
"signal (\'22023\', \'Unsupported type of metadata\', \'DA006\');\n"
"}\n"
"--src dav.sql:3673\n";

static const char *proc54 = 
"create procedure WS.WS.XML_VIEW_EXTERNAL_META\n"
"(\n"
"in view_name varchar,\n"
"in top_tag varchar,\n"
"in meta_mode integer,\n"
"in meta_data varchar,\n"
"inout http_body any,\n"
"inout meta_path_suffix varchar,\n"
"inout mime_type varchar\n"
")\n"
"{\n"
"if (meta_mode = 2)\n"
"{\n"
"http (xml_view_dtd (view_name, top_tag), http_body);\n"
"http (meta_data, http_body);\n"
"meta_path_suffix := \'.dtd\';\n"
"mime_type := \'xml/dtd\';\n"
"return;\n"
"}\n"
"if (meta_mode = 5)\n"
"{\n"
"http (xml_view_schema (view_name, top_tag), http_body);\n"
"meta_path_suffix := \'.xsd\';\n"
"mime_type := \'xml/schema\';\n"
"return;\n"
"}\n"
"meta_path_suffix := \'\';\n"
"mime_type := \'\';\n"
"}\n"
"--src dav.sql:3736\n";

static const char *proc55 = 
"create procedure WS.WS.XML_VIEW_UPDATE (in _view varchar, in _res_id integer, in path varchar, in meta_mode integer, in meta_data varchar)\n"
"{\n"
"declare _body any;\n"
"declare _pf varchar;\n"
"declare _procprefix varchar;\n"
"_procprefix := concat (name_part (_view, 0), \'.\', name_part (_view, 1), \'.\');\n"
"_body := string_output ();\n"
"WS.WS.XML_VIEW_HEADER(_view, name_part (_view, 2), path, meta_mode, meta_data, _body);\n"
"_pf := concat (_procprefix, \'http_view_\', name_part (_view, 2));\n"
"call (_pf) (_body);\n"
"http (concat (\'</\', name_part (_view, 2), \'>\'), _body);\n"
"_body := string_output_string (_body);\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = _body, RES_MOD_TIME = now () where RES_ID = _res_id;\n"
"}\n"
"--src dav.sql:3767\n";

static const char *proc56 = 
"create procedure WS.WS.FIXPATH (in path any)\n"
"{\n"
"declare inx, len, cp, sl integer;\n"
"declare tmp, newp varchar;\n"
"declare ret any;\n"
"len := length (path);\n"
"if (__tag (path) = 193)\n"
"{\n"
"inx := 0;\n"
"tmp := \'\';\n"
"cp := aref (path, len - 1);\n"
"while (inx < length (cp))\n"
"{\n"
"if (aref (cp, inx) > 159 and aref (cp, inx) < 192)\n"
"tmp := concat (tmp, \'_\');\n"
"else if (aref (cp, inx) = ascii (\'?\'))\n"
"tmp := concat (tmp, \'_\');\n"
"else\n"
"tmp := concat (tmp, chr (aref (cp, inx)));\n"
"inx := inx + 1;\n"
"}\n"
"ret := path;\n"
"aset (ret, len - 1, tmp);\n"
"}\n"
"else if (isstring (path))\n"
"{\n"
"inx := 0;\n"
"tmp := \'\';\n"
"cp := path;\n"
"if (strstr (cp, \'http://\') = 0)\n"
"{\n"
"declare pp, lp varchar;\n"
"pp := coalesce (http_map_get (\'mounted\'), \'/DAV/\');\n"
"lp := coalesce (http_map_get (\'domain\'), \'/DAV\');\n"
"newp := subseq (cp, strstr (cp, \'://\') + 3, length (cp));\n"
"sl := strchr (newp, \'/\');\n"
"newp := subseq (newp, strchr (newp, \'/\'), length (newp));\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (strstr (newp, lp) is not null)\n"
"{\n"
"newp := substring (newp, length (lp) + 1, length (newp));\n"
"\n"
"if (aref (newp, 0) <> ascii (\'/\'))\n"
"newp := concat (\'/\', newp);\n"
"\n"
"if (aref (pp, length (pp) - 1) = ascii (\'/\'))\n"
"pp := substring (pp, 1, length (pp) - 1);\n"
"newp := concat (pp, newp);\n"
"}\n"
"else\n"
"{\n"
"newp := concat (\'/DAV\', subseq (newp, strchr (subseq (newp, 1,length (newp)), \'/\') + 1,\n"
"length (newp)));\n"
"}\n"
"cp := concat (subseq (cp, 0, sl + 7), newp);\n"
"}\n"
"while (inx < length (cp))\n"
"{\n"
"if (aref (cp, inx) > 159 and aref (cp, inx) < 192)\n"
"tmp := concat (tmp, \'_\');\n"
"else if (aref (cp, inx) = ascii (\'?\'))\n"
"tmp := concat (tmp, \'_\');\n"
"else\n"
"tmp := concat (tmp, chr (aref (cp, inx)));\n"
"inx := inx + 1;\n"
"}\n"
"ret := tmp;\n"
"}\n"
"else\n"
"ret := \'\';\n"
"return ret;\n"
"}\n"
"--src dav.sql:3783\n";

static const char *proc57 = 
"create procedure WS.WS.ISPUBL (in __path varchar)\n"
"{\n"
"declare _srv, _path varchar;\n"
"declare _ix, _len integer;\n"
"_srv := repl_this_server ();\n"
"if (__tag (__path) = 193)\n"
"{\n"
"_ix := 0;\n"
"_len := length (__path);\n"
"_path := \'/\';\n"
"while (_ix < _len)\n"
"{\n"
"_path := concat ( _path, aref (__path, _ix), \'/\');\n"
"_ix := _ix + 1;\n"
"}\n"
"}\n"
"else if (isstring (__path))\n"
"_path := __path;\n"
"else\n"
"{\n"
"signal (\'22023\', \'Function ISPUBL needs string or array as argument.\', \'DA007\');\n"
"return NULL;\n"
"}\n"
"for select TI_ITEM, TI_ACCT from DB.DBA.SYS_TP_ITEM where TI_SERVER = _srv and TI_TYPE = 1 do\n"
"{\n"
"if (TI_ITEM is not null and length (TI_ITEM) > 0)\n"
"{\n"
"if (aref (TI_ITEM, length (TI_ITEM) - 1) <> ascii (\'/\'))\n"
"{\n"
"if (_path between (TI_ITEM || \'/\') and DAV_COL_PATH_BOUNDARY (TI_ITEM || \'/\'))\n"
"return TI_ACCT;\n"
"}\n"
"else\n"
"{\n"
"if (_path between TI_ITEM and DAV_COL_PATH_BOUNDARY (TI_ITEM))\n"
"return TI_ACCT;\n"
"}\n"
"}\n"
"}\n"
"return NULL;\n"
"}\n"
"--src dav.sql:3864\n";

static const char *proc58 = 
"create procedure WS.WS.BODY_ARR (inout __ses any, in __pcs integer)\n"
"{\n"
"declare _res, _ses any;\n"
"declare _str varchar;\n"
"declare _len, _from, _pcs integer;\n"
"\n"
"if (__pcs is null)\n"
"_pcs := 1000000;\n"
"else\n"
"_pcs := __pcs;\n"
"\n"
"_res := null;\n"
"_from := 1;\n"
"\n"
"if (__tag (__ses) = 126 or __tag (__ses) = 133)\n"
"{\n"
"_ses := string_output ();\n"
"http (__ses, _ses);\n"
"_len := length (_ses);\n"
"while (_from < _len)\n"
"{\n"
"_str := substring (_ses, _from, _pcs);\n"
"if (_res is null)\n"
"_res := vector (_str);\n"
"else\n"
"_res := vector_concat (_res, vector (_str));\n"
"_from := _from + _pcs;\n"
"}\n"
"}\n"
"else if (isstring (__ses) or __tag (__ses) = 185)\n"
"{\n"
"_len := length (__ses);\n"
"while (_from < _len)\n"
"{\n"
"_str := substring (__ses, _from, _pcs);\n"
"if (_res is null)\n"
"_res := vector (_str);\n"
"else\n"
"_res := vector_concat (_res, vector (_str));\n"
"_from := _from + _pcs;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_ses := \'\';\n"
"}\n"
"\n"
"return _res;\n"
"}\n"
"--src dav.sql:3907\n";

static const char *proc59 = 
"create procedure WS.WS.XML_AUTO_SCHED (in _path varchar)\n"
"{\n"
"declare _stmt, ses, _root, _sch, _dtd, _dtd_body, _comments varchar;\n"
"declare _res_id integer;\n"
"_res_id := coalesce ((select RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = _path), 0);\n"
"if (_res_id < 1)\n"
"return;\n"
"_stmt := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xml-sql\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_root := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xml-sql-root\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'document\');\n"
"_sch := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xml-sql-schema\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_dtd := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xml-sql-dtd\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"_comments := coalesce ((select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'xml-sql-description\'\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_PARENT_ID = _res_id), \'\');\n"
"if (_stmt = \'\')\n"
"return;\n"
"ses := string_output (http_strses_memory_size ());\n"
"WS.WS.XMLSQL_TO_STRSES (_stmt, _root, _sch, _dtd, _comments, ses);\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = ses, RES_MOD_TIME = now () where RES_ID = _res_id;\n"
"}\n"
"--src dav.sql:3962\n";

static const char *proc60 = 
"create procedure WS.WS.DAV_LOGIN (in path any,\n"
"in lines any,\n"
"in __access varchar,\n"
"inout __u_id integer,\n"
"inout __grp integer,\n"
"inout __perms varchar)\n"
"{\n"
"declare auth any;\n"
"declare _access, _perms varchar;\n"
"declare _u_id, _grp integer;\n"
"\n"
"_u_id := http_nobody_uid ();\n"
"_grp := http_nogroup_gid ();\n"
"_perms := \'110110110\';\n"
"\n"
"if (upper (__access) = \'R\')\n"
"_access := \'100\';\n"
"else if ( upper (__access) = \'RW\')\n"
"_access := \'110\';\n"
"else\n"
"_access := \'100\';\n"
"\n"
"auth := DB.DBA.vsp_auth_vec (lines);\n"
"\n"
"if (not WS.WS.ISPUBLIC (path, _access) or auth <> 0)\n"
"{\n"
"_u_id := WS.WS.CHECK_AUTH (lines);\n"
"if (_u_id = http_nobody_uid ())\n"
"return _u_id;\n"
"if (not WS.WS.CHECKPERM (path, _u_id, _access))\n"
"return 0;\n"
"}\n"
"\n"
"if (_u_id <> 0)\n"
"select U_DEF_PERMS, U_GROUP into _perms, _grp from WS.WS.SYS_DAV_USER where U_ID = _u_id;\n"
"\n"
"if (__u_id is not null)\n"
"__u_id := _u_id;\n"
"if (__grp is not null)\n"
"__grp := _grp;\n"
"if (__u_id is not null)\n"
"__perms := _perms;\n"
"\n"
"return (1);\n"
"}\n"
"--src dav.sql:3994\n";

static const char *proc61 = 
"create procedure WS.WS.HTTP_RESP (in hdr any, out descr varchar)\n"
"{\n"
"declare line, code varchar;\n"
"descr := \'Bad Gateway\';\n"
"if (hdr is null or __tag (hdr) <> 193)\n"
"return (502);\n"
"if (length (hdr) < 1)\n"
"return (502);\n"
"line := aref (hdr, 0);\n"
"if (length (line) < 12)\n"
"return (502);\n"
"code := substring (line, strstr (line, \'HTTP/1.\') + 9, length (line));\n"
"while ((length (code) > 0) and (aref (code, 0) < ascii (\'0\') or aref (code, 0) > ascii (\'9\')))\n"
"code := substring (code, 2, length (code) - 1);\n"
"if (length (code) < 3)\n"
"return (502);\n"
"if (length (code) > 3)\n"
"{\n"
"descr := substring (code, 4, length (code) - 3);\n"
"descr := replace (descr, chr(10), \'\');\n"
"descr := replace (descr, chr(13), \'\');\n"
"}\n"
"code := substring (code, 1, 3);\n"
"return atoi (code);\n"
"}\n"
"--src dav.sql:4041\n";

static const char *proc62 = 
"create procedure WS.WS.COPY_TO_OTHER (in path varchar,\n"
"inout params varchar,\n"
"in lines varchar,\n"
"in __dst_name varchar)\n"
"{\n"
"declare _s_path, _ovr, _depth varchar;\n"
"declare _resp any;\n"
"declare _content, _thdr, _thost, _auth, _resp_cli, _dst_name varchar;\n"
"declare _len, _sl, _code  integer;\n"
"declare _u_id, _grp, _perms any;\n"
"\n"
"_dst_name := WS.WS.FINDPARAM (lines, \'Destination:\');\n"
"WS.WS.DAV_LOGIN (path, lines, \'R\', _u_id, _grp, _perms);\n"
"\n"
"_s_path := http_path ();\n"
"_ovr := WS.WS.FINDPARAM (lines, \'Overwrite:\');\n"
"if (_ovr = \'\')\n"
"_ovr := \'T\';\n"
"_depth := WS.WS.FINDPARAM (lines, \'Depth:\');\n"
"if (_depth = \'\')\n"
"_depth := \'infinity\';\n"
"_auth := WS.WS.FINDPARAM (lines, \'Authorization:\');\n"
"\n"
"_thost := substring (_dst_name, 8, length (_dst_name) - 8);\n"
"_sl := strchr (_thost, \'/\');\n"
"if (_sl)\n"
"_thost := substring (_thost, 1, _sl);\n"
"\n"
"if (_auth <> \'\')\n"
"_thdr := concat (\'Host: \', _thost, \'\\r\\n\',\n"
"\'Overwrite: \', _ovr, \'\\r\\n\',\n"
"\'Authorization: \', _auth, \'\\r\\n\',\n"
"\'Depth: \', _depth);\n"
"else\n"
"_thdr := concat (\'Host: \', _thost, \'\\r\\n\',\n"
"\'Overwrite: \', _ovr, \'\\r\\n\',\n"
"\'Depth: \', _depth);\n"
"\n"
"if (WS.WS.ISRES (path))\n"
"{\n"
"\n"
"select blob_to_string (RES_CONTENT), length (RES_CONTENT)\n"
"into _content, _len from WS.WS.SYS_DAV_RES where RES_FULL_PATH = _s_path;\n"
"commit work;\n"
"http_get (_dst_name, _resp, \'PUT\', _thdr, _content);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"http_request_status (sprintf (\'HTTP/1.1 %d %s\', _code, _resp_cli));\n"
"\n"
"if (_code > 199 and _code < 299)\n"
"return 1;\n"
"else\n"
"return 0;\n"
"}\n"
"else if (WS.WS.ISCOL (path))\n"
"{\n"
"\n"
"commit work;\n"
"http_get (_dst_name, _resp, \'HEAD\', _thdr);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code <> 200)\n"
"{\n"
"commit work;\n"
"http_get (_dst_name, _resp, \'MKCOL\', _thdr);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code < 200 or _code > 299)\n"
"{\n"
"http_request_status (sprintf (\'HTTP/1.1 %d %s\', _code, _resp_cli));\n"
"return 0;\n"
"}\n"
"}\n"
"for select SUBCOL_FULL_PATH\n"
"from DAV_PLAIN_SUBCOLS\n"
"where root_id = NULL and root_path = concat (_s_path, \'/\') and recursive = 1 and subcol_auth_uid = null and subcol_auth_pwd = null\n"
"order by SUBCOL_ID\n"
"do\n"
"{\n"
"commit work;\n"
"http_get (concat (\'http://\', _thost, SUBCOL_FULL_PATH), _resp, \'HEAD\', _thdr);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code <> 200)\n"
"{\n"
"http_get (concat (\'http://\', _thost, SUBCOL_FULL_PATH), _resp, \'MKCOL\', _thdr);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code < 200 or _code > 299)\n"
"{\n"
"http_request_status (sprintf (\'HTTP/1.1 %d %s\', _code, _resp_cli));\n"
"return 0;\n"
"}\n"
"}\n"
"\n"
"}\n"
"for select RES_FULL_PATH as res_path, blob_to_string (RES_CONTENT) as content\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH like concat (_s_path, \'/%\')\n"
"order by RES_ID\n"
"do\n"
"{\n"
"commit work;\n"
"http_get (concat (\'http://\', _thost, res_path), _resp, \'PUT\', _thdr, content);\n"
"_code := WS.WS.HTTP_RESP (_resp, _resp_cli);\n"
"if (_code < 200 or _code > 299)\n"
"{\n"
"http_request_status (sprintf (\'HTTP/1.1 %d %s\', _code, _resp_cli));\n"
"return 0;\n"
"}\n"
"\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src dav.sql:4069\n";

static const char *proc63 = 
"create procedure WS.WS.CHECK_READ_ACCESS (in _u_id integer, in doc_id integer)\n"
"{\n"
"declare _perms varchar;\n"
"declare g_id, _user, _group, rc integer;\n"
"if (_u_id = http_dav_uid ())\n"
"return 1;\n"
"rc := 0;\n"
"g_id := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = _u_id), 0);\n"
"whenever not found goto exit_p;\n"
"select RES_OWNER, RES_GROUP, RES_PERMS into _user, _group, _perms\n"
"from WS.WS.SYS_DAV_RES where RES_ID = doc_id;\n"
"_perms := coalesce (_perms, \'000000000\');\n"
"if (_u_id = _user)\n"
"rc := WS.WS.PERM_COMP (substring (cast (_perms as varchar), 1, 3), \'100\');\n"
"if (_group = g_id and rc = 0)\n"
"rc := WS.WS.PERM_COMP (substring (cast (_perms as varchar), 4, 3), \'100\');\n"
"if (rc = 0)\n"
"rc := WS.WS.PERM_COMP (substring (cast (_perms as varchar), 7, 3), \'100\');\n"
"exit_p:;\n"
"return rc;\n"
"}\n"
"--src dav.sql:4186\n";

static const char *proc64 = 
"create procedure WS.WS.IS_REDIRECT_REF (inout path any, in lines any, inout location varchar)\n"
"{\n"
"declare fpath, fpath1, _ref, lpath, ppath varchar;\n"
"declare rc integer;\n"
"rc := 0;\n"
"set isolation=\'committed\';\n"
"location := http_path ();\n"
"declare cr cursor for select blob_to_string (PROP_VALUE) from WS.WS.SYS_DAV_RES, WS.WS.SYS_DAV_PROP where\n"
"RES_FULL_PATH = fpath1\n"
"and PROP_PARENT_ID = RES_ID and\n"
"PROP_NAME = \'redirectref\' and PROP_TYPE = \'R\' option (order);\n"
"fpath := http_physical_path (); fpath1 := rtrim (fpath, \'/\');\n"
"whenever not found goto nfp;\n"
"open cr (prefetch 1);\n"
"fetch cr into _ref;\n"
"if (not isstring (_ref))\n"
"goto nfp;\n"
"lpath := http_path ();\n"
"location := WS.WS.EXPAND_URL (lpath, _ref);\n"
"ppath := WS.WS.EXPAND_URL (fpath, _ref);\n"
"path := WS.WS.HREF_TO_ARRAY (ppath, \'\');\n"
"rc := 1;\n"
"nfp:\n"
"close cr;\n"
"set isolation=\'repeatable\';\n"
"return rc;\n"
"}\n"
"--src dav.sql:4209\n";

static const char *proc65 = 
"create function WS.WS.DAV_DIR_LIST (in full_path varchar, in logical_root_path varchar, in col integer, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer) returns integer\n"
"{\n"
"declare _dir, _xml, _modify, fsize, _html, _b_opt, _xml_sheet any;\n"
"declare _name varchar;\n"
"declare _res_len, flen, mult, have_sheet integer;\n"
"declare _dir_len, _dir_ctr integer;\n"
"\n"
"fsize := vector (\'b\',\'K\',\'M\',\'G\',\'T\');\n"
"_xml := string_output ();\n"
"have_sheet := 0;\n"
"\n"
"\n"
"_dir := DAV_DIR_LIST_INT (full_path, 0, \'%\', auth_uname, auth_pwd, auth_uid);\n"
"\n"
"if (isinteger (_dir))\n"
"return _dir;\n"
"_dir_len := length (_dir);\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\', _xml);\n"
"http (sprintf (\'<PATH dir_name=\"%V\" physical_dir_name=\"%V\">\', cast (logical_root_path as varchar), cast (full_path as varchar)), _xml);\n"
"http (\'<DIRS>\', _xml);\n"
"\n"
"http (\'<SUBDIR modify=\"\" name=\"..\" />\\n\', _xml);\n"
"_dir_ctr := 0;\n"
"while (_dir_ctr < _dir_len)\n"
"{\n"
"declare _col any;\n"
"_col := _dir [_dir_ctr];\n"
"\n"
"if (_col [1] = \'C\')\n"
"{\n"
"_name := _col[0];\n"
"_name := subseq (_name, 0, length (_name)-1);\n"
"_name := subseq (_name, strrchr (_name, \'/\') + 1);\n"
"http (sprintf (\'<SUBDIR modify=\"%s\" name=\"\',\n"
"soap_print_box (_col[3], \'\', 2)), _xml );\n"
"http_value (charset_recode (_name, null, \'UTF-8\'), null, _xml );\n"
"http (\'\" />\\n\', _xml );\n"
"}\n"
"_dir_ctr := _dir_ctr + 1;\n"
"}\n"
"http (\'</DIRS><FILES>\', _xml);\n"
"_dir_ctr := 0;\n"
"while (_dir_ctr < _dir_len)\n"
"{\n"
"declare _res any;\n"
"_res := _dir [_dir_ctr];\n"
"\n"
"if (_res [1] = \'R\')\n"
"{\n"
"_name := _res[0];\n"
"_name := subseq (_name, strrchr (_name, \'/\') + 1);\n"
"_res_len := _res[2];\n"
"flen := _res_len;\n"
"mult := 0;\n"
"if (lower (_name) = \'folder.xsl\')\n"
"have_sheet := 1;\n"
"while ((flen / 1000) > 1)\n"
"{\n"
"mult := mult + 1;\n"
"flen := flen / 1000;\n"
"}\n"
"http (sprintf (\'<FILE modify=\"%s\" rs=\"%i\" hs=\"%d %s\" name=\"\',\n"
"soap_print_box (_res[3], \'\', 2), _res_len, flen, aref (fsize, mult)), _xml);\n"
"http_value (charset_recode (_name, null, \'UTF-8\'), null, _xml );\n"
"http (\'\" />\\n\', _xml);\n"
"}\n"
"_dir_ctr := _dir_ctr + 1;\n"
"}\n"
"http (\'</FILES></PATH>\', _xml);\n"
"\n"
"\n"
"_xml := xtree_doc (_xml);\n"
"\n"
"_b_opt := NULL;\n"
"\n"
"if (exists (select 1 from DB.DBA.HTTP_PATH\n"
"where HP_LPATH = http_map_get (\'domain\') and HP_PPATH = http_map_get (\'mounted\')))\n"
"select deserialize(HP_OPTIONS) into _b_opt from DB.DBA.HTTP_PATH\n"
"where HP_LPATH = http_map_get (\'domain\') and HP_PPATH = http_map_get (\'mounted\');\n"
"\n"
"if (_b_opt is not NULL)\n"
"_b_opt := get_keyword (\'browse_sheet\', _b_opt, \'\');\n"
"\n"
"if (have_sheet)\n"
"{\n"
"select blob_to_string (RES_CONTENT) into _xml_sheet from WS.WS.SYS_DAV_RES\n"
"where RES_NAME = \'folder.xsl\' and RES_COL = col;\n"
"xslt_sheet (\'http://local.virt/custom_dir_output\', xtree_doc (_xml_sheet));\n"
"_html := cast (xslt (\'http://local.virt/custom_dir_output\', _xml) as varchar);\n"
"}\n"
"else if (_b_opt <> \'\')\n"
"{\n"
"select blob_to_string (RES_CONTENT) into _xml_sheet from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH = _b_opt;\n"
"xslt_sheet (\'http://local.virt/custom_dir_output\', xml_tree_doc (_xml_sheet));\n"
"_html := cast (xslt (\'http://local.virt/custom_dir_output\', _xml) as varchar);\n"
"}\n"
"else\n"
"_html := cast (xslt (\'http://local.virt/dir_output\', _xml) as varchar);\n"
"\n"
"http (_html);\n"
"\n"
"return 0;\n"
"}\n"
"--src dav.sql:4239\n";

static const char *proc66 = 
"create function\n"
"WS.WS.DAV_CHECK_ASMX (in path any, out patched_path any) returns integer\n"
"{\n"
"declare temp varchar;\n"
"temp := http_path (path);\n"
"\n"
"if ((strstr (temp, \'.asmx\') is not null) and __proc_exists (\'WS.WS.__http_handler_aspx\', 1))\n"
"{\n"
"declare ret any;\n"
"declare idx integer;\n"
"idx := 0;\n"
"ret := vector ();\n"
"while (idx < length (path))\n"
"{\n"
"ret := vector_concat (ret, vector (path[idx]));\n"
"if (strstr (path[idx], \'.asmx\') is not null)\n"
"{\n"
"patched_path := ret;\n"
"return 1;\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"patched_path := path;\n"
"return 0;\n"
"}\n"
"--src dav.sql:4365\n";

static const char *proc67 = 
"create procedure\n"
"WS.WS.DAV_REMOVE_ASMX (in path any)\n"
"{\n"
"if ((strstr (path, \'.asmx\') is not null) and __proc_exists (\'WS.WS.__http_handler_aspx\', 1))\n"
"{\n"
"declare ret any;\n"
"ret := \"LEFT\" (path, strstr (path, \'.asmx\') + 5);\n"
"return ret;\n"
"}\n"
"else\n"
"return path;\n"
"}\n"
"--src dav.sql:4394\n";

static const char *proc68 = 
"create procedure WS.WS.XMLSQL_TO_STRSES (\n"
"in _q varchar,\n"
"in _root varchar,\n"
"in _sch varchar,\n"
"in _dtd varchar,\n"
"in _comments varchar,\n"
"inout ses any,\n"
"in enc varchar := null )\n"
"{\n"
"\n"
"if (length (_sch))\n"
"_dtd := \'\';\n"
"\n"
"\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"%s\" ?>\\n\', coalesce (enc, current_charset())), ses);\n"
"\n"
"if (_comments <> \'\')\n"
"http (replace (sprintf (\'<!\\-\\- %s \\-\\->\\n\', _comments), \'\\-\', \'-\'), ses);\n"
"\n"
"\n"
"if (_dtd <> \'\' and _root <> \'\')\n"
"{\n"
"if (_dtd = \'on\')\n"
"http (concat (\'<!DOCTYPE \' , _root, \' [\', xml_auto_dtd (_q, _root), \']>\\n\'), ses);\n"
"else\n"
"http (concat (\'<!DOCTYPE \' , _root, \' SYSTEM \'\'\', _dtd, \'\'\'>\\n\'), ses);\n"
"}\n"
"\n"
"\n"
"if (_root <> \'\' and _sch = \'\')\n"
"http (concat (\'<\', _root, \'>\\n\'), ses);\n"
"else if (_root <> \'\' and _sch <> \'\')\n"
"http (concat (\'<\', _root,\n"
"\' xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"\',\n"
"_sch, \'\">\\n\'), ses);\n"
"\n"
"\n"
"xml_auto (_q, vector (), ses);\n"
"\n"
"\n"
"if (_root <> \'\')\n"
"http (concat(\'</\', _root, \'>\\n\'), ses);\n"
"\n"
"return;\n"
"}\n"
"--src dav.sql:4409\n";

/* dav_api.sql */

static const char *proc69 = 
"create function DAV_PERROR (in x any)\n"
"{\n"
"declare errlist any;\n"
"if (not isinteger (x))\n"
"return NULL;\n"
"if (x >= 0)\n"
"return NULL;\n"
"if (x < -43)\n"
"return sprintf (\'(%d) Unspecified error\', x);\n"
"errlist := vector (\n"
"\'(-01) The path (target of operation) is not valid\',\n"
"\'(-02) The destination (path) is not valid\',\n"
"\'(-03) Overwrite flag is not set and destination exists\',\n"
"\'(-04) The target is resource, but source is collection (in copy move operations)\',\n"
"\'(-05) Permissions are not valid\',\n"
"\'(-06) uid is not valid\',\n"
"\'(-07) gid is not valid\',\n"
"\'(-08) Target is locked\',\n"
"\'(-09) Destination is locked\',\n"
"\'(-10) Property name is reserved (protected or private)\',\n"
"\'(-11) Property does not exist\',\n"
"\'(-12) Authentication failed\',\n"
"\'(-13) Operation is forbidden (the authenticated user do not have a permissions for the action)\',\n"
"\'(-14) the target type is not valid\',\n"
"\'(-15) The umask is not valid\',\n"
"\'(-16) The property already exists\',\n"
"\'(-17) Invalid property value\',\n"
"\'(-18) no such user\',\n"
"\'(-19) no home directory\',\n"
"\'(-20) The operation is not supported by a DET\',\n"
"\'(-21) DET can not restore the full DAV path by id\',\n"
"\'(-22) Corrupted id\',\n"
"\'(-23) The id does not correspond to any resource that exists now\',\n"
"\'(-24) Authentication failed and requested\',\n"
"\'(-25) Can not create collection if a resource with same name exists\',\n"
"\'(-26) Can not create resource if a collection with same name exists\',\n"
"\'(-27) Target is not locked\',\n"
"\'(-28) Unqualified error\',\n"
"\'(-29) Transaction deadlock at the end of resource upload, after reading from session\',\n"
"\'(-30) The target is nested into source\',\n"
"\'(-31) Built-in system account can not be changed\',\n"
"\'(-32) Property that can control execution of SQL statements can be changed only by SQL-enabled user\',\n"
"\'(-33) The DET resource or collection ID is rejected, the operation supports only plain DAV\',\n"
"\'(-34) The path (target of operation) is not valid: no parent collection exists\',\n"
"\'(-35) Failed dependency on lock operation\',\n"
"\'(-36) Appropriate property virt:Versioning-* has not been set\',\n"
"\'(-37) Operation is not supported for resource of this type\',\n"
"\'(-38) Semantics is violated\',\n"
"\'(-39) Recursive operation on CatFilter is impossible\',\n"
"\'(-40) The path (target of operation) does not match naming convention that is used by DET\',\n"
"\'(-41) The size of DAV collection subtree is out of quota\',\n"
"\'(-42) The resource is unavailable because resource owner is disabled\',\n"
"\'(-43) Access to a home DAV collection of a disabled account is blocked\'\n"
");\n"
"return errlist [-(x+1)];\n"
"}\n"
"--src dav_api.sql:50\n";

static const char *proc70 = 
"create procedure\n"
"DAV_ADD_USER_INT (in uid varchar,\n"
"in pwd varchar,\n"
"in gid any,\n"
"in perms varchar,\n"
"in disable integer,\n"
"in home varchar,\n"
"in full_name varchar,\n"
"in email varchar)\n"
"{\n"
"declare id, gd, rc integer;\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_USER where U_NAME = uid))\n"
"{\n"
"USER_CREATE (uid, pwd, vector (\'SQL_ENABLE\', 0, \'DAV_ENABLE\', 1, \'PRIMARY_GROUP\', gid,\n"
"\'HOME\', home, \'E-MAIL\', email, \'FULL_NAME\', full_name, \'PERMISSIONS\', perms, \'DISABLED\', disable));\n"
"}\n"
"else\n"
"{\n"
"id := coalesce ((select U_ID from WS.WS.SYS_DAV_USER where U_NAME = uid), NULL);\n"
"if (id < 100)\n"
"return -31;\n"
"if (isstring (gid))\n"
"gd := coalesce ((select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = gid), NULL);\n"
"else if (isinteger (gid) and exists (select 1 from WS.WS.SYS_DAV_GROUP where G_ID = gid))\n"
"gd := gid;\n"
"else\n"
"gd := NULL;\n"
"if (gid = http_nogroup_gid ())\n"
"return -31;\n"
"\n"
"if (id is not null)\n"
"{\n"
"update WS.WS.SYS_DAV_USER set\n"
"U_GROUP = gd,\n"
"U_DEF_PERMS = perms,\n"
"U_FULL_NAME = full_name,\n"
"U_PWD = pwd_magic_calc (uid, pwd),\n"
"U_E_MAIL = email,\n"
"U_ACCOUNT_DISABLED = disable,\n"
"U_HOME = home\n"
"where\n"
"U_NAME = uid;\n"
"}\n"
"}\n"
"return id;\n"
"}\n"
"--src dav_api.sql:109\n";

static const char *proc71 = 
" create procedure\n"
"DAV_ADD_USER (in uid varchar, in pwd varchar, in gid varchar,\n"
"in perms varchar, in disable integer,\n"
"in home varchar, in full_name varchar, in email varchar,\n"
"in auth_uname varchar := NULL,\n"
"in auth_pwd varchar := NULL\n"
")\n"
"{\n"
"declare rc, make_dir integer;\n"
"\n"
"if (DAV_CHECK_AUTH (auth_uname, auth_pwd, 1) < 0)\n"
"return -12;\n"
"\n"
"make_dir := 0;\n"
"\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_USER where U_NAME = uid))\n"
"make_dir := 1;\n"
"\n"
"rc := DAV_ADD_USER_INT (uid, pwd, gid, perms, disable, home, full_name, email);\n"
"if (rc < 0)\n"
"return rc;\n"
"\n"
"if (make_dir)\n"
"{\n"
"if (isstring (home))\n"
"{\n"
"if (0 > (rc := DAV_COL_CREATE (home, perms, uid, gid, auth_uname, auth_pwd)))\n"
"{\n"
"rollback work;\n"
"return rc;\n"
"}\n"
"}\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:158\n";

static const char *proc72 = 
" create procedure\n"
"DAV_DELETE_USER (in uid varchar, in auth_uname varchar := NULL, in auth_pwd varchar := NULL)\n"
"{\n"
"declare known_u_id integer;\n"
"if (DAV_CHECK_AUTH (auth_uname, auth_pwd, 1) < 0)\n"
"return -12;\n"
"known_u_id := coalesce ((select U_ID from WS.WS.SYS_DAV_USER where U_NAME = uid), NULL);\n"
"if (known_u_id < 100)\n"
"return -31;\n"
"\n"
"delete from WS.WS.SYS_DAV_TAG where DT_U_ID = known_u_id;\n"
"delete from WS.WS.SYS_DAV_USER where U_NAME = uid;\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:196\n";

static const char *proc73 = 
" create function DAV_REGEXP_PATTERN_FOR_PERM () returns varchar {\n"
"return \'^[01][01][01][01][01][01][01][01][01]([NTR-]([NMR-])?)?\\044\';\n"
"}\n"
"--src dav_api.sql:213\n";

static const char *proc74 = 
"create function DAV_REGEXP_PATTERN_FOR_UNIX_PERM () returns varchar {\n"
"return \'^[r\\\\-][w\\\\-][x\\\\-][r\\\\-][w\\\\-][x\\\\-][r\\\\-][w\\\\-][x\\\\-]([NTR-]([NMR-])?)?\\044\';\n"
"}\n"
"--src dav_api.sql:218\n";

static const char *proc75 = 
" create function\n"
"DAV_PERM_D2U (in perms varchar)\n"
"{\n"
"declare res any;\n"
"declare i int;\n"
"res := perms;\n"
"if (regexp_match (DAV_REGEXP_PATTERN_FOR_PERM (), res) is null)\n"
"signal (\'22023\', \'Not valid permissions string\');\n"
"res := \'rwxrwxrwx\' || upper (subseq (perms, 9));\n"
"while (i < 9)\n"
"{\n"
"if (perms[i] = ascii(\'0\'))\n"
"aset (res, i, ascii (\'-\'));\n"
"i := i + 1;\n"
"}\n"
"return lower(res);\n"
"}\n"
"--src dav_api.sql:224\n";

static const char *proc76 = 
" create procedure\n"
"DAV_PERM_U2D (in perms varchar)\n"
"{\n"
"declare res any;\n"
"declare i int;\n"
"res := perms;\n"
"if (regexp_match (DAV_REGEXP_PATTERN_FOR_PERM (), res) is not null)\n"
"return perms;\n"
"res := perms;\n"
"if (regexp_match (DAV_REGEXP_PATTERN_FOR_UNIX_PERM (), res) is null)\n"
"signal (\'22023\', \'Not valid permissions string\');\n"
"res := \'000000000\' || upper (subseq (perms, 9));\n"
"while (i < 9)\n"
"{\n"
"if (perms[i] <> ascii(\'-\'))\n"
"aset (res, i, ascii (\'1\'));\n"
"i := i + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src dav_api.sql:244\n";

static const char *proc77 = 
"create function\n"
"DAV_CHECK_AUTH (in auth_uname varchar := NULL, in auth_pwd varchar := NULL, in adm integer := 0) returns integer\n"
"{\n"
"declare pwd varchar;\n"
"declare uid integer;\n"
"whenever not found goto nf;\n"
"\n"
"if (adm)\n"
"select U_PWD, U_ID into pwd, uid from WS.WS.SYS_DAV_USER where U_ID = http_dav_uid () and U_NAME = auth_uname;\n"
"else\n"
"select U_PWD, U_ID into pwd, uid from WS.WS.SYS_DAV_USER where U_NAME = auth_uname;\n"
"\n"
"\n"
"if (isstring (pwd))\n"
"{\n"
"if ((pwd[0] = 0 and pwd_magic_calc (auth_uname, auth_pwd) = pwd) or (pwd[0] <> 0 and pwd = auth_pwd))\n"
"return uid;\n"
"}\n"
"\n"
"nf:\n"
"\n"
"if (auth_uname is null)\n"
"{\n"
"\n"
"return 1;\n"
"}\n"
"if (ftp_anonymous_check (auth_uname))\n"
"return 1;\n"
"\n"
"return -12;\n"
"}\n"
"--src dav_api.sql:266\n";

static const char *proc78 = 
" create function\n"
"DAV_HOME_DIR (in uid varchar) returns any\n"
"{\n"
"declare res any;\n"
"whenever not found goto er;\n"
"select U_HOME into res from WS.WS.SYS_DAV_USER where U_NAME = uid;\n"
"return coalesce (res, -19);\n"
"er:\n"
"return -18;\n"
"}\n"
"--src dav_api.sql:300\n";

static const char *proc79 = 
"create function\n"
"DAV_HOME_DIR_CREATE (in uid varchar) returns any\n"
"{\n"
"declare exit handler for sqlstate \'*\' { return -1; };\n"
"\n"
"declare rc, c_id integr;\n"
"declare host, path varchar;\n"
"\n"
"for (select U_ID, U_GROUP, U_DEF_PERMS, U_HOME from SYS_USERS where U_NAME = uid) do {\n"
"path := \'/DAV/home/\';\n"
"rc := DAV_MAKE_DIR (path, http_dav_uid (), http_admin_gid (), \'110100100R\');\n"
"if (isnull (DAV_HIDE_ERROR (rc)))\n"
"goto _end;\n"
"path := path || uid || \'/\';\n"
"rc := DAV_MAKE_DIR (path, U_ID, U_GROUP, U_DEF_PERMS);\n"
"if (isnull (DAV_HIDE_ERROR (rc)))\n"
"goto _end;\n"
"path := path || \'rdf_sink/\';\n"
"rc := DAV_MAKE_DIR (path, U_ID, U_GROUP, U_DEF_PERMS);\n"
"if (isnull (DAV_HIDE_ERROR (rc)))\n"
"goto _end;\n"
"\n"
"host := cfg_item_value (virtuoso_ini_path (), \'URIQA\', \'DefaultHost\');\n"
"if (host is null) {\n"
"host := sys_stat (\'st_host_name\');\n"
"if (server_http_port () <> \'80\')\n"
"host := host ||\':\'|| server_http_port ();\n"
"}\n"
"rc := DAV_PROP_SET_INT (path, \'virt:rdf_graph\', \'http://\' || host || path, null, null, 0, 0);\n"
"if (isnull (DAV_HIDE_ERROR (rc)))\n"
"goto _end;\n"
"rc := DAV_PROP_SET_INT (path, \'virt:rdf_sponger\', \'on\', null, null, 0, 0);\n"
"if (isnull (DAV_HIDE_ERROR (rc)))\n"
"goto _end;\n"
"}\n"
"_end:;\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:312\n";

static const char *proc80 = 
"create procedure\n"
"DAV_ADD_GROUP_INT (in gid varchar)\n"
"{\n"
"declare gd integer;\n"
"gd := coalesce ((select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = gid), 0);\n"
"if (not gd)\n"
"{\n"
"gd := USER_ROLE_CREATE (gid, 1);\n"
"}\n"
"return gd;\n"
"}\n"
"--src dav_api.sql:352\n";

static const char *proc81 = 
" create procedure\n"
"DAV_ADD_GROUP (in gid varchar, in auth_uname varchar := NULL, in auth_pwd varchar := NULL)\n"
"{\n"
"if (DAV_CHECK_AUTH (auth_uname, auth_pwd, 1) < 0)\n"
"return -12;\n"
"return DAV_ADD_GROUP_INT (gid);\n"
"}\n"
"--src dav_api.sql:366\n";

static const char *proc82 = 
" create procedure\n"
"DAV_DELETE_GROUP (in gid varchar, in auth_uname varchar := NULL, in auth_pwd varchar := NULL)\n"
"{\n"
"declare known_g_id integer;\n"
"if (DAV_CHECK_AUTH (auth_uname, auth_pwd, 1) < 0)\n"
"return -12;\n"
"known_g_id := coalesce ((select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = gid), NULL);\n"
"if (known_g_id < 100)\n"
"return -31;\n"
"delete from WS.WS.SYS_DAV_GROUP where G_NAME = gid;\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:376\n";

static const char *proc83 = 
" create procedure\n"
"DAV_DIR_LIST (in path varchar := \'/DAV/\', in recursive integer, in auth_uname varchar, in auth_pwd varchar) returns any\n"
"{\n"
"declare auth_uid integer;\n"
"auth_uid := DAV_CHECK_AUTH (auth_uname, auth_pwd, 0);\n"
"if (auth_uid < 0)\n"
"return -12;\n"
"\n"
"return DAV_DIR_LIST_INT (path, recursive, \'%\', auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"--src dav_api.sql:392\n";

static const char *proc84 = 
" create procedure\n"
"DAV_DIR_FILTER (in path varchar := \'/DAV/\', in recursive integer := 0, inout filter any, in auth_uname varchar, in auth_pwd varchar) returns any\n"
"{\n"
"declare auth_uid integer;\n"
"declare compilation any;\n"
"\n"
"auth_uid := DAV_CHECK_AUTH (auth_uname, auth_pwd, 0);\n"
"if (auth_uid < 0)\n"
"return -12;\n"
"compilation := vector (\'\', filter, \'DAV\', DAV_FC_PRINT_WHERE (filter, auth_uid));\n"
"\n"
"return DAV_DIR_FILTER_INT (path, recursive, compilation, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"--src dav_api.sql:405\n";

static const char *proc85 = 
"create function\n"
"DAV_GET_PARENT (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"st := upper (st);\n"
"if (isinteger (id))\n"
"{\n"
"if (\'R\' = st)\n"
"return coalesce ((select RES_COL from WS.WS.SYS_DAV_RES where RES_ID = id), -1);\n"
"if (\'C\' = st)\n"
"return coalesce ((select COL_PARENT from WS.WS.SYS_DAV_COL where COL_ID = id), -1);\n"
"return -14;\n"
"}\n"
"return call (cast (id[0] as varchar) || \'_DAV_GET_PARENT\') (id, st, path);\n"
"}\n"
"--src dav_api.sql:421\n";

static const char *proc86 = 
"create function\n"
"DAV_DIR_SINGLE_INT (in did any, in st char (0), in path varchar, in auth_uname varchar := null, in auth_pwd varchar := null, in auth_uid integer := null) returns any\n"
"{\n"
"declare rc integer;\n"
"\n"
"rc := DAV_AUTHENTICATE (did, st, \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc < 0)\n"
"{\n"
"declare auth_parent any;\n"
"auth_parent := DAV_GET_PARENT (did, st, path);\n"
"rc := DAV_AUTHENTICATE (auth_parent, \'C\', \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc < 0)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"}\n"
"if (auth_uid is null)\n"
"auth_uid := rc;\n"
"if (isarray (did))\n"
"{\n"
"if (\'R\' = st)\n"
"return call (cast (did[0] as varchar) || \'_DAV_DIR_SINGLE\') (did, st, path, auth_uid);\n"
"else\n"
"return call (cast (did[0] as varchar) || \'_DAV_DIR_LIST\') (did, vector (\'\'), path, \'%\', -1, auth_uid);\n"
"}\n"
"if (\'R\' = st)\n"
"{\n"
"return coalesce ((select vector (RES_FULL_PATH, \'R\', length (RES_CONTENT), RES_MOD_TIME,\n"
"RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME )\n"
"from WS.WS.SYS_DAV_RES\n"
"where\n"
"RES_ID = did ));\n"
"}\n"
"else\n"
"{\n"
"return coalesce ((select vector (WS.WS.COL_PATH (COL_ID), \'C\', 0, COL_MOD_TIME,\n"
"COL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', COL_NAME)\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_ID = did ));\n"
"}\n"
"}\n"
"--src dav_api.sql:438\n";

static const char *proc87 = 
"create function\n"
"DAV_DIR_LIST_INT (in path varchar := \'/DAV/\', in rec_depth integer := 0, in name_mask varchar, in auth_uname varchar := null, in auth_pwd varchar := null, inout auth_uid integer := null) returns any\n"
"{\n"
"declare rc, t, id, l integer;\n"
"declare path_string, st, det varchar;\n"
"declare did, detcol_id, detcol_path, det_subpath, res any;\n"
"\n"
"\n"
"path_string := path;\n"
"did := DAV_SEARCH_SOME_ID_OR_DET (path, st, det, detcol_id, detcol_path, det_subpath);\n"
"if (DAV_HIDE_ERROR (did) is null)\n"
"return did;\n"
"rc := DAV_AUTHENTICATE (did, st, \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc < 0)\n"
"{\n"
"if (rec_depth = -1)\n"
"{\n"
"declare auth_parent any;\n"
"auth_parent := DAV_GET_PARENT (did, st, path);\n"
"rc := DAV_AUTHENTICATE (auth_parent, \'C\', \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"if (rc < 0)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"}\n"
"if (auth_uid is null)\n"
"auth_uid := rc;\n"
"if (isarray (did))\n"
"{\n"
"if ((\'R\' = st) or (rec_depth = -1))\n"
"res := vector (call (cast (did[0] as varchar) || \'_DAV_DIR_SINGLE\') (did, st, path, auth_uid));\n"
"else\n"
"res := call (cast (det as varchar) || \'_DAV_DIR_LIST\') (detcol_id, det_subpath, detcol_path, name_mask, rec_depth, auth_uid);\n"
"return res;\n"
"}\n"
"vectorbld_init (res);\n"
"if (\'R\' = st)\n"
"{\n"
"for select vector (RES_FULL_PATH, \'R\', length (RES_CONTENT), RES_MOD_TIME,\n"
"RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME ) as i\n"
"from WS.WS.SYS_DAV_RES\n"
"where\n"
"RES_NAME like name_mask and RES_FULL_PATH = DAV_CONCAT_PATH (path, null) do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"else if (rec_depth = -1)\n"
"{\n"
"for select vector (WS.WS.COL_PATH (COL_ID), \'C\', 0, COL_MOD_TIME,\n"
"COL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', COL_NAME) as i\n"
"from WS.WS.SYS_DAV_COL\n"
"where\n"
"COL_ID = did do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"else if (rec_depth > 0)\n"
"{\n"
"for select SUBCOL_FULL_PATH, SUBCOL_ID, SUBCOL_NAME, SUBCOL_PARENT, SUBCOL_DET\n"
"from DB.DBA.DAV_PLAIN_SUBCOLS\n"
"where (root_id = did) and (root_path = path_string) and recursive = rec_depth and subcol_auth_uid = auth_uid and subcol_auth_pwd = auth_pwd\n"
"\n"
"do for select COL_MOD_TIME,\n"
"COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME from WS.WS.SYS_DAV_COL\n"
"where\n"
"COL_PARENT = SUBCOL_PARENT and COL_NAME = SUBCOL_NAME\n"
"do\n"
"{\n"
"vectorbld_acc (res, vector (SUBCOL_FULL_PATH, \'C\', 0, COL_MOD_TIME,\n"
"SUBCOL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', SUBCOL_NAME) );\n"
"if (SUBCOL_DET is not NULL)\n"
"vectorbld_concat_acc (res, call (SUBCOL_DET || \'_DAV_DIR_LIST\') (SUBCOL_ID, vector (\'\'), SUBCOL_FULL_PATH, name_mask, rec_depth, auth_uid));\n"
"for select vector (\n"
"\n"
"RES_FULL_PATH, \'R\', length (RES_CONTENT), RES_MOD_TIME,\n"
"\n"
"RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME) as i\n"
"from WS.WS.SYS_DAV_RES\n"
"where\n"
"RES_NAME like name_mask and RES_COL = SUBCOL_ID\n"
"do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"}\n"
"else if (det is null)\n"
"{\n"
"\n"
"for select vector (RES_FULL_PATH, \'R\', length (RES_CONTENT), RES_MOD_TIME,\n"
"RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME) as i\n"
"from WS.WS.SYS_DAV_RES\n"
"where\n"
"\n"
"RES_NAME like name_mask and RES_COL = did do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"for select vector (WS.WS.COL_PATH (COL_ID), \'C\', 0, COL_MOD_TIME,\n"
"COL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', COL_NAME) as i\n"
"from WS.WS.SYS_DAV_COL\n"
"where\n"
"\n"
"COL_PARENT = did do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"vectorbld_concat_acc (res, call (cast (det as varchar) || \'_DAV_DIR_LIST\') (did, vector (\'\'), path, name_mask, rec_depth, auth_uid));\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src dav_api.sql:483\n";

static const char *proc88 = 
"create function\n"
"DAV_DIR_FILTER_INT (in path varchar := \'/DAV/\', in rec_depth integer := 0, in compilation any, in auth_uname varchar := null, in auth_pwd varchar := null, in auth_uid integer := null) returns any\n"
"{\n"
"declare rc, t, id, uid, gid, l integer;\n"
"declare path_string, st, det, qry_text varchar;\n"
"declare did, detcol_id, detcol_path, det_subpath, res any;\n"
"\n"
"declare execstate, execmessage, execmeta, execrows any;\n"
"declare davcond varchar;\n"
"davcond := get_keyword (\'DAV\', compilation);\n"
"if (davcond is null)\n"
"{\n"
"davcond := DAV_FC_PRINT_WHERE (get_keyword (\'\', compilation), auth_uid);\n"
"compilation := vector_concat (compilation, vector (\'DAV\', davcond));\n"
"}\n"
"execstate := \'00000\';\n"
"vectorbld_init (res);\n"
"path_string := path;\n"
"did := DAV_SEARCH_SOME_ID_OR_DET (path, st, det, detcol_id, detcol_path, det_subpath);\n"
"if (isarray (did))\n"
"{\n"
"if (auth_uid is null)\n"
"uid := call (cast (did[0] as varchar) || \'_DAV_AUTHENTICATE\') (did, st, \'1__\', auth_uname, auth_pwd, uid);\n"
"else\n"
"uid := auth_uid;\n"
"if (uid < 0)\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"if (\'R\' = st)\n"
"res := vector (call (cast (did[0] as varchar) || \'_DAV_DIR_SINGLE\') (did, st, path, uid));\n"
"else\n"
"res := call (cast (det as varchar) || \'_DAV_DIR_FILTER\') (detcol_id, det_subpath, detcol_path, compilation, rec_depth, uid);\n"
"return res;\n"
"}\n"
"if (did < 0)\n"
"{\n"
"return did;\n"
"}\n"
"if (\'R\' = st or det is null)\n"
"{\n"
"if (auth_uid is null)\n"
"uid := DAV_AUTHENTICATE (did, st, \'1__\', auth_uname, auth_pwd, uid);\n"
"else\n"
"uid := auth_uid;\n"
"if (uid < 0)\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = uid), 0);\n"
"}\n"
"\n"
"if (\'R\' = st)\n"
"{\n"
"qry_text := \'\n"
"select _top.RES_FULL_PATH, \'\'R\'\', length (_top.RES_CONTENT), _top.RES_MOD_TIME,\n"
"_top.RES_ID, _top.RES_PERMS, _top.RES_GROUP, _top.RES_OWNER, _top.RES_CR_TIME, _top.RES_TYPE, _top.RES_NAME\n"
"from WS.WS.SYS_DAV_RES as _top \' || davcond || \' and\n"
"(_top.RES_FULL_PATH = DAV_CONCAT_PATH (?, null)) and\n"
"case (\n"
"DAV_CHECK_PERM (_top.RES_PERMS, \'\'1__\'\', ?, ?, _top.RES_GROUP, _top.RES_OWNER) )\n"
"when 0 then WS.WS.ACL_IS_GRANTED (_top.RES_ACL, ?, DAV_REQ_CHARS_TO_BITMASK (\'\'1__\'\'))\n"
"else 1 end\';\n"
"\n"
"exec (qry_text, execstate, execmessage,\n"
"vector (path, uid, gid, uid),\n"
"100000000, execmeta, execrows );\n"
"\n"
"if (\'00000\' <> execstate)\n"
"signal (execstate, execmessage || \' in \' || qry_text);\n"
"vectorbld_concat_acc (res, execrows);\n"
"}\n"
"else if (rec_depth = -1)\n"
"{\n"
"for select vector (WS.WS.COL_PATH (COL_ID), \'C\', 0, COL_MOD_TIME,\n"
"COL_ID, COL_PERMS, COL_GROUP, COL_OWNER, COL_CR_TIME, \'dav/unix-directory\', COL_NAME) as i\n"
"from WS.WS.SYS_DAV_COL\n"
"where\n"
"\n"
"COL_ID = did do\n"
"{\n"
"vectorbld_acc (res, i);\n"
"}\n"
"}\n"
"else if (rec_depth > 0)\n"
"{\n"
"qry_text := \'\n"
"select _top.RES_FULL_PATH, \'\'R\'\', length (_top.RES_CONTENT), _top.RES_MOD_TIME,\n"
"_top.RES_ID, _top.RES_PERMS, _top.RES_GROUP, _top.RES_OWNER, _top.RES_CR_TIME, _top.RES_TYPE, _top.RES_NAME\n"
"from WS.WS.SYS_DAV_RES as _top \' || davcond || \' and (_top.RES_FULL_PATH between ? and ?) and\n"
"case (\n"
"DAV_CHECK_PERM (_top.RES_PERMS, \'\'1__\'\', ?, ?, _top.RES_GROUP, _top.RES_OWNER) )\n"
"when 0 then WS.WS.ACL_IS_GRANTED (_top.RES_ACL, ?, DAV_REQ_CHARS_TO_BITMASK (\'\'1__\'\'))\n"
"else 1 end\';\n"
"\n"
"exec (qry_text,\n"
"execstate, execmessage,\n"
"vector (path_string, DAV_COL_PATH_BOUNDARY (path_string), uid, gid, uid), 100000000, execmeta, execrows );\n"
"\n"
"if (\'00000\' <> execstate)\n"
"signal (execstate, execmessage || \' in \' || qry_text);\n"
"vectorbld_concat_acc (res, execrows);\n"
"\n"
"for select SUBCOL_FULL_PATH, SUBCOL_ID, SUBCOL_DET\n"
"from DB.DBA.DAV_PLAIN_SUBCOLS\n"
"where SUBCOL_DET is not null and (not (SUBCOL_DET like \'%Filter\')) and recursive = rec_depth and (root_id = did) and (root_path = path_string) and subcol_auth_uid = null and subcol_auth_pwd = null\n"
"do\n"
"{\n"
"vectorbld_concat_acc (res, call (SUBCOL_DET || \'_DAV_DIR_FILTER\') (SUBCOL_ID, vector (\'\'), SUBCOL_FULL_PATH, compilation, rec_depth, auth_uid));\n"
"}\n"
"}\n"
"else if (det is null)\n"
"{\n"
"qry_text := \'\n"
"select _top.RES_FULL_PATH, \'\'R\'\', length (_top.RES_CONTENT), _top.RES_MOD_TIME,\n"
"_top.RES_ID, _top.RES_PERMS, _top.RES_GROUP, _top.RES_OWNER, _top.RES_CR_TIME, _top.RES_TYPE, _top.RES_NAME\n"
"from WS.WS.SYS_DAV_RES as _top \' || davcond || \' and (RES_COL = ?) and\n"
"case (\n"
"DAV_CHECK_PERM (_top.RES_PERMS, \'\'1__\'\', ?, ?, _top.RES_GROUP, _top.RES_OWNER) )\n"
"when 0 then WS.WS.ACL_IS_GRANTED (_top.RES_ACL, ?, DAV_REQ_CHARS_TO_BITMASK (\'\'1__\'\'))\n"
"else 1 end\';\n"
"\n"
"exec (qry_text, execstate, execmessage,\n"
"vector (did, uid, gid, uid),\n"
"100000000, execmeta, execrows );\n"
"\n"
"if (\'00000\' <> execstate)\n"
"signal (execstate, execmessage || \' in \' || qry_text);\n"
"vectorbld_concat_acc (res, execrows);\n"
"}\n"
"else\n"
"{\n"
"if (auth_uid is null)\n"
"uid := call (cast (did[0] as varchar) || \'_DAV_AUTHENTICATE\') (did, st, \'1__\', auth_uname, auth_pwd, uid);\n"
"else\n"
"uid := auth_uid;\n"
"if (uid < 0)\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"vectorbld_concat_acc (res, call (cast (det as varchar) || \'_DAV_DIR_FILTER\') (did, vector (\'\'), path, compilation, rec_depth, uid));\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src dav_api.sql:605\n";

static const char *proc89 = 
" create procedure\n"
"DAV_SEARCH_PATH (in id any, in what char (1)) returns any\n"
"{\n"
"declare res varchar;\n"
"what := upper (what);\n"
"if (isarray(id) and not isstring(id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_SEARCH_PATH\') (id, what);\n"
"if (id <= 0)\n"
"{\n"
"if (id = 0)\n"
"return \'/\';\n"
"return -22;\n"
"}\n"
"whenever not found goto en;\n"
"if (what = \'C\')\n"
"{\n"
"res :=  WS.WS.COL_PATH (id);\n"
"if (res = \'/\')\n"
"return -23;\n"
"return res;\n"
"}\n"
"else if (what = \'R\')\n"
"{\n"
"select RES_FULL_PATH into res from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"return res;\n"
"}\n"
"else\n"
"return -14;\n"
"en:\n"
"return -23;\n"
"}\n"
"--src dav_api.sql:757\n";

static const char *proc90 = 
" create function\n"
"DAV_SEARCH_ID (in path any, in what char (1)) returns any\n"
"{\n"
"declare id integer;\n"
"declare par any;\n"
"id := -1;\n"
"what := upper (what);\n"
"\n"
"if (isstring (path))\n"
"{\n"
"\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"\n"
"}\n"
"else\n"
"{\n"
"\n"
"par := path;\n"
"}\n"
"if (length (par) = 0)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (aref (par, 0) <> \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (what = \'P\')\n"
"{\n"
"if (par [length (par) - 1] = \'\')\n"
"{\n"
"if (2 = length (par))\n"
"return -1;\n"
"if (3 = length (par))\n"
"return 0;\n"
"par := vector_concat (subseq (par, 0, length (par) - 2), vector (\'\'));\n"
"}\n"
"else\n"
"{\n"
"if (2 = length (par))\n"
"return 0;\n"
"par := vector_concat (subseq (par, 0, length (par) - 1), vector (\'\'));\n"
"}\n"
"path := null;\n"
"what := \'C\';\n"
"}\n"
"\n"
"if (what = \'R\')\n"
"{\n"
"if (aref (par, length (par) - 1) = \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"id := coalesce ((select RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = path), -1);\n"
"}\n"
"else if (what = \'C\')\n"
"{\n"
"if (aref (par, length (par) - 1) <> \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"\n"
"id := -1;\n"
"}\n"
"else\n"
"{\n"
"\n"
"return -14;\n"
"}\n"
"\n"
"if (id = -1)\n"
"{\n"
"declare det_ret, detcol_id, detcol_path_parts, unreached_path_parts any;\n"
"return DAV_SEARCH_ID_OR_DET (par, what, det_ret, detcol_id, detcol_path_parts, unreached_path_parts);\n"
"}\n"
"return id;\n"
"}\n"
"--src dav_api.sql:792\n";

static const char *proc91 = 
" create function\n"
"DAV_SEARCH_SOME_ID (in path any, out what char (1)) returns any\n"
"{\n"
"declare id integer;\n"
"declare par any;\n"
"id := -1;\n"
"\n"
"if (isstring (path))\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"else\n"
"par := path;\n"
"if (aref (par, 0) <> \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (aref (par, length (par) - 1) <> \'\')\n"
"{\n"
"what := \'R\';\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"id := coalesce ((select RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = path), -1);\n"
"}\n"
"else\n"
"{\n"
"what := \'C\';\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"id := DAV_SEARCH_ID (path, \'C\');\n"
"}\n"
"\n"
"if (id = -1)\n"
"{\n"
"declare det_ret, detcol_id, detcol_path_parts, unreached_path_parts any;\n"
"return DAV_SEARCH_ID_OR_DET (par, what, det_ret, detcol_id, detcol_path_parts, unreached_path_parts);\n"
"}\n"
"return id;\n"
"}\n"
"--src dav_api.sql:880\n";

static const char *proc92 = 
" create function\n"
"DAV_HIDE_ERROR (in res any, in dflt any := null) returns any\n"
"{\n"
"if (not (isinteger (res)))\n"
"return res;\n"
"if (res >= 0)\n"
"return res;\n"
"return dflt;\n"
"}\n"
"--src dav_api.sql:921\n";

static const char *proc93 = 
" create function\n"
"DAV_HIDE_ERROR_OR_DET (in res any, in dflt_err any := null, in dflt_det any := -33) returns any\n"
"{\n"
"if (not (isinteger (res)))\n"
"return dflt_det;\n"
"if (res >= 0)\n"
"return res;\n"
"return dflt_err;\n"
"}\n"
"--src dav_api.sql:934\n";

static const char *proc94 = 
" create function DAV_CONCAT_PATH (in parts1 any, in parts2 any)\n"
"{\n"
"declare strg1, strg2 varchar;\n"
"declare len, ctr integer;\n"
"if (parts1 is null)\n"
"strg1 := \'\';\n"
"else if (isstring (parts1))\n"
"strg1 := parts1;\n"
"else\n"
"{\n"
"len := length (parts1);\n"
"if (len = 0)\n"
"strg1 := \'\';\n"
"else\n"
"{\n"
"strg1 := parts1 [0];\n"
"ctr := 1;\n"
"while (ctr < len)\n"
"{\n"
"strg1 := strg1 || \'/\' || parts1 [ctr];\n"
"ctr := ctr + 1;\n"
"}\n"
"}\n"
"}\n"
"if (parts2 is null)\n"
"strg2 := \'\';\n"
"else if (isstring (parts2))\n"
"strg2 := parts2;\n"
"else\n"
"{\n"
"len := length (parts2);\n"
"if (len = 0)\n"
"strg2 := \'\';\n"
"else\n"
"{\n"
"strg2 := parts2 [0];\n"
"ctr := 1;\n"
"while (ctr < len)\n"
"{\n"
"strg2 := strg2 || \'/\' || parts2 [ctr];\n"
"ctr := ctr + 1;\n"
"}\n"
"}\n"
"}\n"
"if (strg1 = \'\')\n"
"return strg2;\n"
"if (strg2 = \'\')\n"
"return strg1;\n"
"if (strg1 [length(strg1) - 1] = 47)\n"
"if (strg2 [0] = 47)\n"
"return strg1 || subseq (strg2, 1);\n"
"else\n"
"return strg1 || strg2;\n"
"else\n"
"if (strg2 [0] = 47)\n"
"return strg1 || strg2;\n"
"else\n"
"return strg1 || \'/\' || strg2;\n"
"}\n"
"--src dav_api.sql:947\n";

static const char *proc95 = 
"create function\n"
"DAV_SEARCH_SOME_ID_OR_DET (inout path any, out what char (1), out det_ret varchar, out detcol_id integer, out detcol_path_parts any, out unreached_path_parts any) returns integer\n"
"{\n"
"if (isstring (path))\n"
"path := split_and_decode (path, 0, \'\\0\\0/\');\n"
"else\n"
"path := path;\n"
"if (length (path) < 2)\n"
"goto bad_path_arg;\n"
"if (aref (path, 0) <> \'\')\n"
"goto bad_path_arg;\n"
"if (path [length (path) - 1] = \'\')\n"
"what := \'C\';\n"
"else\n"
"what := \'R\';\n"
"return DAV_SEARCH_ID_OR_DET (path, what, det_ret, detcol_id, detcol_path_parts, unreached_path_parts);\n"
"\n"
"bad_path_arg:\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return -1;\n"
"}\n"
"--src dav_api.sql:1009\n";

static const char *proc96 = 
"create function\n"
"DAV_SEARCH_ID_OR_DET (in path any, in what char (1), out det_ret varchar, out detcol_id integer, out detcol_path_parts any, out unreached_path_parts any) returns integer\n"
"{\n"
"declare id integer;\n"
"declare par, left_par, right_par any;\n"
"declare cname, det varchar;\n"
"declare inx, depth, cur_id, parent_id integer;\n"
"id := -1;\n"
"what := upper (what);\n"
"\n"
"if (isstring (path))\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"else\n"
"par := path;\n"
"if (length (par) < 2)\n"
"goto bad_path_arg;\n"
"if (aref (par, 0) <> \'\')\n"
"goto bad_path_arg;\n"
"if (what = \'P\')\n"
"{\n"
"if (par [length (par) - 1] = \'\')\n"
"{\n"
"if (2 = length (par))\n"
"goto bad_path_arg;\n"
"if (3 = length (par))\n"
"{\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return 0;\n"
"}\n"
"par := vector_concat (subseq (par, 0, length (par) - 2), vector (\'\'));\n"
"}\n"
"else\n"
"{\n"
"if (2 = length (par))\n"
"{\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return 0;\n"
"}\n"
"par := vector_concat (subseq (par, 0, length (par) - 1), vector (\'\'));\n"
"}\n"
"path := null;\n"
"what := \'C\';\n"
"}\n"
"if (what = \'R\')\n"
"{\n"
"if (aref (par, length (par) - 1) = \'\')\n"
"goto bad_path_arg;\n"
"if (not isstring (path))\n"
"path := DAV_CONCAT_PATH (par, null);\n"
"id := coalesce ((select RES_ID from WS.WS.SYS_DAV_RES where RES_FULL_PATH = path), -1);\n"
"if (id > 0)\n"
"goto found_plain_id;\n"
"}\n"
"else if (what = \'C\')\n"
"{\n"
"if (aref (par, length (par) - 1) <> \'\')\n"
"goto bad_path_arg;\n"
"goto descending_col_search;\n"
"}\n"
"else\n"
"return -14;\n"
"\n"
"descending_col_search:\n"
"inx := 1;\n"
"cur_id := 0;\n"
"parent_id := 0;\n"
"depth := length (par) - 1;\n"
"\n"
"whenever not found goto not_found;\n"
"while (inx < depth)\n"
"{\n"
"cname := aref (par, inx);\n"
"\n"
"select COL_ID, COL_DET into cur_id, det from WS.WS.SYS_DAV_COL where COL_NAME = cname and COL_PARENT = parent_id;\n"
"if (det is not NULL)\n"
"{\n"
"det_ret := det;\n"
"detcol_id := cur_id;\n"
"detcol_path_parts := subseq (par, 0, inx + 1);\n"
"par := subseq (par, inx + 1);\n"
"unreached_path_parts := par;\n"
"if ((what = \'C\') and (inx = depth - 1))\n"
"return cur_id;\n"
"return call (cast (det as varchar) || \'_DAV_SEARCH_ID\') (cur_id, par, what);\n"
"}\n"
"parent_id := cur_id;\n"
"inx := inx + 1;\n"
"}\n"
"if (what = \'R\')\n"
"{\n"
"return -1;\n"
"}\n"
"id := cur_id;\n"
"goto found_plain_id;\n"
"\n"
"found_plain_id:\n"
"det_ret := NULL;\n"
"detcol_id := NULL;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return id;\n"
"\n"
"not_found:\n"
"\n"
"det_ret := NULL;\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return -1;\n"
"\n"
"bad_path_arg:\n"
"\n"
"det_ret := NULL;\n"
"detcol_id := null;\n"
"detcol_path_parts := null;\n"
"unreached_path_parts := null;\n"
"return -1;\n"
"}\n"
"--src dav_api.sql:1034\n";

static const char *proc97 = 
"create procedure\n"
"DAV_OWNER_ID (in uid any, in gid any, out _uid integer, out _gid integer)\n"
"{\n"
"\n"
"if (uid is null)\n"
"_uid := http_nobody_uid();\n"
"else if (isinteger (uid))\n"
"_uid := uid;\n"
"else\n"
"_uid := coalesce (\n"
"(select U_ID from WS.WS.SYS_DAV_USER where U_NAME = uid),\n"
"case (uid) when \'anonymous\' then http_nobody_uid () else -12 end);\n"
"\n"
"if (gid is null)\n"
"_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = _uid), http_nogroup_gid ());\n"
"else if (isinteger (gid))\n"
"_gid := gid;\n"
"else\n"
"_gid := coalesce (\n"
"(select G_ID from WS.WS.SYS_DAV_GROUP where G_NAME = gid),\n"
"(select U_GROUP from WS.WS.SYS_DAV_USER where U_NAME = gid),\n"
"-12 );\n"
"\n"
"\n"
"\n"
"}\n"
"--src dav_api.sql:1159\n";

static const char *proc98 = 
"create procedure DAV_IS_LOCKED_INT (inout id any, inout type char, in owned_tokens varchar := \'\')\n"
"{\n"
"declare pid, npid, res integer;\n"
"declare scope varchar;\n"
"type := upper (type);\n"
"if (type <> \'C\' and type <> \'R\')\n"
"return -14;\n"
"if (exists (select 1 from WS.WS.SYS_DAV_LOCK where datediff (\'second\', LOCK_TIME, now()) > LOCK_TIMEOUT))\n"
"{\n"
"delete from WS.WS.SYS_DAV_LOCK where datediff (\'second\', LOCK_TIME, now()) > LOCK_TIMEOUT;\n"
"\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"return call (cast (id[0] as varchar) || \'_DAV_IS_LOCKED\') (id, type, owned_tokens);\n"
"}\n"
"if (id <= 0)\n"
"return -1;\n"
"\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_LOCK))\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"whenever not found goto nf_target_lock;\n"
"select case (LOCK_SCOPE) when \'X\' then 2 else 1 end into res from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = type and LOCK_PARENT_ID = id and strstr (owned_tokens, LOCK_TOKEN) is null;\n"
"return res;\n"
"\n"
"nf_target_lock:\n"
"\n"
"\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'C\' and strstr (owned_tokens, LOCK_TOKEN) is null))\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"if (type = \'R\')\n"
"pid := coalesce ((select RES_COL from WS.WS.SYS_DAV_RES where RES_ID = id), -1);\n"
"else if (type = \'C\')\n"
"pid := coalesce ((select COL_PARENT from WS.WS.SYS_DAV_COL where COL_ID = id), -1);\n"
"\n"
"if (pid < 0)\n"
"return -1;\n"
"\n"
"next_parent:\n"
"\n"
"whenever not found goto nf_parent_lock;\n"
"select case (LOCK_SCOPE) when \'X\' then 2 else 1 end into res from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = \'C\' and LOCK_PARENT_ID = pid and strstr (owned_tokens, LOCK_TOKEN) is null;\n"
"id := pid;\n"
"type := \'C\';\n"
"return res;\n"
"\n"
"nf_parent_lock:\n"
"whenever not found goto nf_parent;\n"
"select COL_PARENT into npid from WS.WS.SYS_DAV_COL where COL_ID = pid;\n"
"pid := npid;\n"
"goto next_parent;\n"
"nf_parent:\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:1188\n";

static const char *proc99 = 
" create function DAV_IS_LOCKED (in id any, in type char, in owned_tokens any := 1) returns integer\n"
"{\n"
"declare res integer;\n"
"if (isstring (owned_tokens))\n"
"res := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"else\n"
"res := DAV_IS_LOCKED_INT (id, type);\n"
"if (res > 0)\n"
"return -8;\n"
"return res;\n"
"}\n"
"--src dav_api.sql:1255\n";

static const char *proc100 = 
" create function DAV_LIST_LOCKS (in id any, in type char) returns any\n"
"{\n"
"return DAV_LIST_LOCKS_INT (id, type);\n"
"}\n"
"--src dav_api.sql:1269\n";

static const char *proc101 = 
"create function DAV_LIST_LOCKS_INT (in id any, in type char) returns any\n"
"{\n"
"declare res any;\n"
"type := upper (type);\n"
"\n"
"if (type <> \'C\' and type <> \'R\')\n"
"return -14;\n"
"if (isarray (id))\n"
"{\n"
"return call (cast (id[0] as varchar) || \'_DAV_LIST_LOCKS\') (id, type, 0);\n"
"}\n"
"if (id <= 0)\n"
"return -1;\n"
"res := vector ();\n"
"for select LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO\n"
"from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = type do {\n"
"res := vector_concat (res, vector (vector (LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO)));\n"
"}\n"
"return res;\n"
"}\n"
"--src dav_api.sql:1275\n";

static const char *proc102 = 
"create function DAV_LOCK (in path any, in locktype varchar, in scope varchar, in token varchar, in owner_name varchar, in owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid varchar, in auth_pwd varchar) returns any\n"
"{\n"
"declare id any;\n"
"declare st char (1);\n"
"\n"
"id := null;\n"
"st := null;\n"
"return DAV_LOCK_INT (path, id, st, locktype, scope, token, owner_name, owned_tokens, depth, timeout_sec, auth_uid, auth_pwd, NULL);\n"
"}\n"
"--src dav_api.sql:1297\n";

static const char *proc103 = 
"create function DAV_LOCK_INT (in path any, inout id any, inout st char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer) returns any\n"
"{\n"
"declare p_id any;\n"
"declare rc, id_is_bad integer;\n"
"declare u_token, old_scope, p_st varchar;\n"
"\n"
"p_id := DAV_SEARCH_ID (path, \'P\');\n"
"if (DAV_HIDE_ERROR (p_id) is null)\n"
"return case p_id when -1 then -34 else p_id end;\n"
"if (id is null)\n"
"id := DAV_SEARCH_SOME_ID (path, st);\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"if (id <> -1)\n"
"return -1;\n"
"if (\"RIGHT\" (path, 1) = \'/\')\n"
"return -1;\n"
"st := \'R\';\n"
"id_is_bad := 1;\n"
"}\n"
"else\n"
"id_is_bad := 0;\n"
"if (id_is_bad)\n"
"rc := DAV_AUTHENTICATE (p_id, \'C\', \'11_\', auth_uname, auth_pwd, auth_uid);\n"
"else\n"
"rc := DAV_AUTHENTICATE (id, st, \'11_\', auth_uname, auth_pwd, auth_uid);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"if (auth_uid is null)\n"
"auth_uid := rc;\n"
"if (owned_tokens is null)\n"
"owned_tokens := \'\';\n"
"if (token is null)\n"
"token := \'\';\n"
"if (owner_name is null)\n"
"owner_name := \'\';\n"
"if (depth is null)\n"
"{\n"
"if (st = \'R\')\n"
"depth := \'0\';\n"
"else\n"
"depth := \'infinity\';\n"
"}\n"
"if (timeout_sec is null or timeout_sec = 0)\n"
"timeout_sec := 604800;\n"
"set isolation = \'serializable\';\n"
"p_st := \'C\';\n"
"rc := DAV_IS_LOCKED_INT (p_id, p_st, owned_tokens);\n"
"if (0 <> rc)\n"
"{\n"
"if (rc < 0)\n"
"return rc;\n"
"return -8;\n"
"}\n"
"if (st = \'C\')\n"
"{\n"
"for select LOCK_TOKEN as _ctoken from WS.WS.SYS_DAV_LOCK\n"
"where\n"
"LOCK_PARENT_TYPE = \'C\' and\n"
"isnull (strstr (owned_tokens, LOCK_TOKEN)) and\n"
"((id = LOCK_PARENT_ID) or DAV_COL_IS_ANCESTOR_OF (id, LOCK_PARENT_ID))\n"
"do\n"
"{\n"
"return -8;\n"
"}\n"
"}\n"
"\n"
"u_token := \'\';\n"
"if (owned_tokens <> \'\')\n"
"{\n"
"declare tleft, tright integer;\n"
"declare tmp varchar;\n"
"if (isnull(strstr(owned_tokens, \'(<opaquelocktoken:\')))\n"
"goto failed_parsing;\n"
"tleft := strchr (owned_tokens, \':\');\n"
"\n"
"if (tleft is null)\n"
"goto failed_parsing;\n"
"tright := strchr (substring (owned_tokens, tleft + 1, length (owned_tokens)), \'>\');\n"
"if (tright is null)\n"
"goto failed_parsing;\n"
"tright := tleft + tright;\n"
"tmp := substring (owned_tokens, tleft + 2, tright - tleft - 1);\n"
"u_token := trim(tmp);\n"
"}\n"
"failed_parsing:\n"
"if (u_token = \'\')\n"
"u_token := token;\n"
"\n"
"\n"
"if (isarray (id))\n"
"{\n"
"token := u_token;\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_LOCK\') (path, id, st, locktype, scope, token, owner_name, owned_tokens, depth, timeout_sec, auth_uid);\n"
"return rc;\n"
"}\n"
"if (id_is_bad)\n"
"{\n"
"declare parent_det, new_res_name varchar;\n"
"parent_det := DAV_PROP_GET_INT (p_id, \'C\', \':virtdet\', 0);\n"
"if (parent_det is not null)\n"
"{\n"
"token := u_token;\n"
"rc := call (parent_det || \'_DAV_LOCK\') (path, id, st, locktype, scope, token, owner_name, owned_tokens, depth, timeout_sec, auth_uid);\n"
"return rc;\n"
"}\n"
"new_res_name := subseq (path, strrchr (path, \'/\') + 1);\n"
"if (exists (select top 1 1 from WS.WS.SYS_DAV_COL where COL_PARENT = p_id and COL_NAME = new_res_name))\n"
"return -26;\n"
"id := WS.WS.GETID (\'R\');\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_CR_TIME, RES_MOD_TIME, RES_OWNER, RES_PERMS, RES_GROUP)\n"
"values (id, new_res_name, p_id, now (), now (), auth_uid, \'110000000NN\', http_nogroup_gid() );\n"
"old_scope := \'\';\n"
"}\n"
"else\n"
"old_scope := coalesce ((select LOCK_SCOPE from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE = st and LOCK_PARENT_ID = id), \'\');\n"
"\n"
"if ((old_scope = \'S\' or old_scope = \'X\') and u_token <> \'\')\n"
"{\n"
"\n"
"declare c cursor for select LOCK_OWNER_INFO from WS.WS.SYS_DAV_LOCK where LOCK_TOKEN = u_token and LOCK_PARENT_TYPE = st and LOCK_PARENT_ID = id for update;\n"
"declare old_owner_name varchar;\n"
"whenever not found goto nothing_to_refresh;\n"
"open c;\n"
"fetch c into old_owner_name;\n"
"if (owner_name = \'\')\n"
"owner_name := old_owner_name;\n"
"scope := old_scope;\n"
"update WS.WS.SYS_DAV_LOCK set LOCK_TIME = now (), LOCK_TIMEOUT = timeout_sec, LOCK_OWNER_INFO = owner_name where current of c;\n"
"close c;\n"
"return u_token;\n"
"nothing_to_refresh:\n"
"close c;\n"
"return -35;\n"
"}\n"
"if ((old_scope = \'\') or (old_scope = \'S\' and scope = \'S\'))\n"
"{\n"
"if (token = \'\')\n"
"token := WS.WS.OPLOCKTOKEN();\n"
"else\n"
"{\n"
"if (exists (select top 1 1 from WS.WS.SYS_DAV_LOCK where LOCK_TOKEN = token and (LOCK_PARENT_TYPE <> st or LOCK_PARENT_ID <> id)))\n"
"return -35;\n"
"}\n"
"\n"
"insert into WS.WS.SYS_DAV_LOCK (LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_PARENT_TYPE,\n"
"LOCK_PARENT_ID, LOCK_TIME, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO)\n"
"values (locktype, scope, token, st, id, now(), timeout_sec, auth_uid, owner_name);\n"
"return token;\n"
"}\n"
"if (old_scope = \'X\' or (old_scope = \'S\' and scope = \'X\'))\n"
"return -8;\n"
"return -35;\n"
"}\n"
"--src dav_api.sql:1308\n";

static const char *proc104 = 
"create function DAV_UNLOCK (in path varchar, in token varchar, in auth_uname varchar, in auth_pwd varchar) returns any\n"
"{\n"
"declare id any;\n"
"declare st char (1);\n"
"id := DAV_SEARCH_SOME_ID (path, st);\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return -1;\n"
"return DAV_UNLOCK_INT (id, st, token, auth_uname, auth_pwd, null);\n"
"}\n"
"--src dav_api.sql:1464\n";

static const char *proc105 = 
"create function DAV_UNLOCK_INT (in id any, in st char(1), in token varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer) returns any\n"
"{\n"
"declare rc, _left, _right integer;\n"
"declare cur_token varchar;\n"
"declare l_cur cursor for select LOCK_TOKEN from WS.WS.SYS_DAV_LOCK\n"
"where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = st and LOCK_TOKEN = token;\n"
"\n"
"auth_uid := DAV_AUTHENTICATE (id, st, \'11_\', auth_uname, auth_pwd, auth_uid);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"\n"
"\n"
"_left := strstr(token,\'opaquelocktoken:\');\n"
"if (_left is not null)\n"
"{\n"
"_left := _left + 15;\n"
"_right :=  strrchr(token,\'>\');\n"
"if (_left < _right)\n"
"token := trim (substring (token, _left + 2, _right - _left - 1));\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_UNLOCK\')(id, st, token, auth_uid);\n"
"return rc;\n"
"}\n"
"whenever not found goto not_locked_t;\n"
"open l_cur (exclusive, prefetch 1);\n"
"fetch l_cur into cur_token;\n"
"delete from WS.WS.SYS_DAV_LOCK where current of l_cur;\n"
"close l_cur;\n"
"return token;\n"
"\n"
"not_locked_t:\n"
"close l_cur;\n"
"return -27;\n"
"}\n"
"--src dav_api.sql:1476\n";

static const char *proc106 = 
" create function\n"
"DAV_REQ_CHARS_TO_BITMASK (in req varchar) returns integer\n"
"{\n"
"return 4 * equ (req[0], 49) + 2 * equ (req[1], 49) + equ (req[2], 49);\n"
"}\n"
"--src dav_api.sql:1515\n";

static const char *proc107 = 
" create function\n"
"DAV_AUTHENTICATE (in id any, in what char(1), in req varchar, in a_uname varchar, in a_pwd varchar, in a_uid integer := null) returns integer\n"
"{\n"
"declare oid, ogid, puid, pgid integer;\n"
"declare opwd, pperms varchar;\n"
"declare pacl varbinary;\n"
"what := upper (what);\n"
"\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"if (a_uid is null)\n"
"{\n"
"a_uid := DAV_CHECK_AUTH (a_uname, a_pwd, 0);\n"
"\n"
"}\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"oid := http_nobody_uid ();\n"
"ogid := http_nogroup_gid ();\n"
"}\n"
"else\n"
"{\n"
"if (a_uid = http_dav_uid())\n"
"return a_uid;\n"
"oid := a_uid;\n"
"if (a_uid = http_nobody_uid ())\n"
"{\n"
"ogid := http_nogroup_gid ();\n"
"}\n"
"else\n"
"select U_GROUP into ogid from WS.WS.SYS_DAV_USER where U_ID = a_uid;\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"declare detcol_id integer;\n"
"detcol_id := id[1];\n"
"select COL_OWNER, COL_GROUP, COL_PERMS, COL_ACL into puid, pgid, pperms, pacl from WS.WS.SYS_DAV_COL where COL_ID = detcol_id;\n"
"if (not DAV_CHECK_PERM (pperms, req, oid, ogid, pgid, puid))\n"
"{\n"
"\n"
"if (not WS.WS.ACL_IS_GRANTED (pacl, oid, 4))\n"
"{\n"
"\n"
"return -13;\n"
"}\n"
"}\n"
"return call (cast (id[0] as varchar) || \'_DAV_AUTHENTICATE\') (id, what, req, a_uname, a_pwd, a_uid);\n"
"}\n"
"whenever not found goto nf_col_or_res;\n"
"if (what = \'R\')\n"
"{\n"
"select RES_OWNER, RES_GROUP, RES_PERMS, RES_ACL into puid, pgid, pperms, pacl from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"set isolation=\'committed\';\n"
"if (puid <> http_nobody_uid() and\n"
"exists (select top 1 1 from SYS_USERS\n"
"where U_ID = puid and U_ACCOUNT_DISABLED = 1 ) )\n"
"return -42;\n"
"set isolation=\'serializable\';\n"
"}\n"
"else if (what = \'C\')\n"
"select COL_OWNER, COL_GROUP, COL_PERMS, COL_ACL into puid, pgid, pperms, pacl from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"else\n"
"return -14;\n"
"if (DAV_CHECK_PERM (pperms, req, oid, ogid, pgid, puid))\n"
"{\n"
"\n"
"return a_uid;\n"
"}\n"
"if (WS.WS.ACL_IS_GRANTED (pacl, oid, DAV_REQ_CHARS_TO_BITMASK (req)))\n"
"{\n"
"\n"
"return a_uid;\n"
"}\n"
"\n"
"return -13;\n"
"nf_col_or_res:\n"
"\n"
"return -1;\n"
"}\n"
"--src dav_api.sql:1524\n";

static const char *proc108 = 
"create function\n"
"DAV_AUTHENTICATE_HTTP (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare puid, pgid integer;\n"
"declare u_password, pperms, resName, resPath varchar;\n"
"declare allow_anon integer;\n"
"declare pacl varbinary;\n"
"what := upper (what);\n"
"\n"
"\n"
"if (length (req) <> 3)\n"
"{\n"
"\n"
"return -15;\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"declare d__perms varchar;\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_AUTHENTICATE_HTTP\') (id, what, req, can_write_http, a_lines, a_uname, a_pwd, a_uid, a_gid, _perms);\n"
"if (rc >= 0)\n"
"{\n"
"rc := DAV_AUTHENTICATE_HTTP (id[1], \'C\', \'1__\', can_write_http, a_lines, a_uname, a_pwd, a_uid, a_gid, d__perms);\n"
"if (rc < 0)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"}\n"
"\n"
"return rc;\n"
"}\n"
"if (id is null)\n"
"{\n"
"pperms := \'000000000?\';\n"
"allow_anon := 0;\n"
"}\n"
"else\n"
"{\n"
"declare anon_flags varchar;\n"
"whenever not found goto nf_col_or_res;\n"
"if (what = \'R\')\n"
"select RES_NAME, RES_FULL_PATH, RES_OWNER, RES_GROUP, RES_PERMS, RES_ACL into resName, resPath, puid, pgid, pperms, pacl from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"else if (what = \'C\')\n"
"select COL_OWNER, COL_GROUP, COL_PERMS, COL_ACL into puid, pgid, pperms, pacl from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"else\n"
"{\n"
"\n"
"return -14;\n"
"}\n"
"anon_flags := substring (cast (pperms as varchar), 7, 3);\n"
"\n"
"allow_anon := WS.WS.PERM_COMP (anon_flags, req);\n"
"}\n"
"\n"
"if (a_uid is null)\n"
"{\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"{\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"{\n"
"\n"
"if (is_https_ctx () and what = \'R\' and exists (select 1 from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = id and PROP_TYPE = what and PROP_NAME = \'virt:aci_meta_n3\'))\n"
"{\n"
"declare graph, waGraph, foafIRI, foafGraph, loadIRI, localIRI any;\n"
"declare S, V, info, st, msg, data, meta any;\n"
"\n"
"foafIRI := trim (get_certificate_info (7, null, null, null, \'2.5.29.17\'));\n"
"if (not isnull (foafIRI) and (foafIRI like \'URI:%\'))\n"
"{\n"
"foafIRI := subseq (foafIRI, 4);\n"
"set_user_id (\'dba\');\n"
"\n"
"localIRI := foafIRI;\n"
"V := rfc1808_parse_uri (localIRI);\n"
"if (is_https_ctx () and cfg_item_value (virtuoso_ini_path (), \'URIQA\', \'DynamicLocal\') = \'1\' and V[1] = registry_get (\'URIQADefaultHost\'))\n"
"{\n"
"V [0] := \'local\';\n"
"V [1] := \'\';\n"
"localIRI := db.dba.vspx_uri_compose (V);\n"
"}\n"
"V := rfc1808_parse_uri (foafIRI);\n"
"V[5] := \'\';\n"
"loadIRI := DB.DBA.vspx_uri_compose (V);\n"
"foafGraph := \'http://local.virt/FOAF/\' || cast (rnd (1000) as varchar);\n"
"S := sprintf (\'sparql load <%s> into graph <%s>\', loadIRI, foafGraph);\n"
"st := \'00000\';\n"
"exec (S, st, msg, vector (), 0);\n"
"\n"
"if (st = \'00000\')\n"
"{\n"
"info := get_certificate_info (9);\n"
"S := sprintf (\' sparql define input:storage \"\" \' ||\n"
"\' prefix cert: <http://www.w3.org/ns/auth/cert#> \' ||\n"
"\' prefix rsa: <http://www.w3.org/ns/auth/rsa#> \' ||\n"
"\' select ?exp_val \' ||\n"
"\'        ?mod_val \' ||\n"
"\'   from <%s> \' ||\n"
"\'  where { \' ||\n"
"\'          ?id cert:identity <%s> ; \' ||\n"
"\'              rsa:public_exponent ?exp ; \' ||\n"
"\'              rsa:modulus ?mod . \' ||\n"
"\'          ?exp cert:decimal ?exp_val . \' ||\n"
"\'          ?mod cert:hex ?mod_val . \' ||\n"
"\'        }\',\n"
"foafGraph,\n"
"localIRI);\n"
"exec (S, st, msg, vector (), 0, meta, data);\n"
"\n"
"if (__proc_exists (fix_identifier_case (\'sioc.DBA.waGraph\')) is not null and\n"
"__proc_exists (fix_identifier_case (\'sioc.DBA.dav_res_iri\')) is not null and\n"
"st = \'00000\' and length (data) and data[0][0] = cast (info[1] as varchar) and data[0][1] = bin2hex (info[2]))\n"
"{\n"
"declare resMode varchar;\n"
"\n"
"graph := SIOC.DBA.dav_res_iri (resPath);\n"
"waGraph := sprintf (\'http://%s/webdav/webaccess\', SIOC.DBA.get_cname ());\n"
"\n"
"resMode := \'\';\n"
"if (req[2] = ascii (\'1\'))\n"
"resMode := \'Control\';\n"
"else if (req[1] = ascii (\'1\'))\n"
"resMode := \'Write\';\n"
"else if (req[0] = ascii (\'1\'))\n"
"resMode := \'Read\';\n"
"\n"
"S := sprintf (\' sparql \\n\' ||\n"
"\' define input:storage \"\" \\n\' ||\n"
"\' prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \\n\' ||\n"
"\' prefix foaf: <http://xmlns.com/foaf/0.1/> \\n\' ||\n"
"\' prefix acl: <http://www.w3.org/ns/auth/acl#> \\n\' ||\n"
"\' select * \\n\' ||\n"
"\'   from <%s> \\n\' ||\n"
"\'   from <%s> \\n\' ||\n"
"\'  where { \\n\' ||\n"
"\'          { \\n\' ||\n"
"\'            ?rule rdf:type acl:Authorization ; \\n\' ||\n"
"\'            acl:accessTo <%s> ; \\n\' ||\n"
"\'            acl:mode acl:%s ; \\n\' ||\n"
"\'            acl:agent <%s>. \\n\' ||\n"
"\'          } \\n\' ||\n"
"\'          union \\n\' ||\n"
"\'          { \\n\' ||\n"
"\'            ?rule rdf:type acl:Authorization ; \\n\' ||\n"
"\'            acl:accessTo <%s> ; \\n\' ||\n"
"\'            acl:mode acl:%s ; \\n\' ||\n"
"\'            acl:agentClass foaf:Agent. \\n\' ||\n"
"\'          } \\n\' ||\n"
"\'          union \\n\' ||\n"
"\'          { \\n\' ||\n"
"\'            ?rule rdf:type acl:Authorization ; \\n\' ||\n"
"\'              acl:accessTo <%s> ; \\n\' ||\n"
"\'              acl:mode acl:%s ; \\n\' ||\n"
"\'              acl:agentClass ?group. \\n\' ||\n"
"\'            ?group rdf:type foaf:Group ; \\n\' ||\n"
"\'              foaf:member <%s>. \\n\' ||\n"
"\'          } \\n\' ||\n"
"\'        }\\n\',\n"
"graph,\n"
"waGraph,\n"
"graph,\n"
"resMode,\n"
"foafIRI,\n"
"graph,\n"
"resMode,\n"
"graph,\n"
"resMode,\n"
"foafIRI);\n"
"commit work;\n"
"exec (S, st, msg, vector (), 0, meta, data);\n"
"\n"
"if (st = \'00000\' and length (data))\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"_perms := req || req || \'--\';\n"
"return a_uid;\n"
"}\n"
"}\n"
"}\n"
"exec (sprintf (\'SPARQL clear graph <%s>\', foafGraph), st, msg, vector (), 0);\n"
"}\n"
"}\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"\n"
"}\n"
"}\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"{\n"
"\n"
"return a_uid;\n"
"}\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"else if (a_uid = http_dav_uid())\n"
"return a_uid;\n"
"}\n"
"else\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"_perms := \'110110110--\';\n"
"}\n"
"set isolation=\'committed\';\n"
"if (\'R\' = what and\n"
"puid <> http_nobody_uid() and\n"
"exists (select top 1 1 from SYS_USERS\n"
"where U_ID = puid and U_ACCOUNT_DISABLED = 1 ) )\n"
"return -42;\n"
"set isolation=\'serializable\';\n"
"if (DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"{\n"
"\n"
"return a_uid;\n"
"}\n"
"if (WS.WS.ACL_IS_GRANTED (pacl, a_uid, DAV_REQ_CHARS_TO_BITMASK (req)))\n"
"{\n"
"\n"
"return a_uid;\n"
"}\n"
"\n"
"return -13;\n"
"\n"
"nf_col_or_res:\n"
"\n"
"return -1;\n"
"}\n"
"--src dav_api.sql:1607\n";

static const char *proc109 = 
" create procedure\n"
"DAV_COL_CREATE (\n"
"in path varchar,\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uid varchar := NULL,\n"
"in auth_pwd varchar := NULL)\n"
"{\n"
"return DAV_COL_CREATE_INT (\n"
"path, permissions, uid, gid, auth_uid, auth_pwd, 1, 1, 1, null, null);\n"
"}\n"
"--src dav_api.sql:1846\n";

static const char *proc110 = 
"create procedure\n"
"DAV_COL_CREATE_INT (\n"
"in path varchar,\n"
"in permissions varchar,\n"
"in uid varchar,\n"
"in gid varchar,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in return_error_if_already_exists integer,\n"
"in extern integer,\n"
"in check_locks any,\n"
"in ouid integer := null,\n"
"in ogid integer := null )\n"
"{\n"
"declare pid, puid, pgid, rc integer;\n"
"declare pperms, name, det varchar;\n"
"declare par any;\n"
"\n"
"rc := 0;\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"\n"
"if (aref (par, 0) <> \'\' or aref (par, length (par) - 1) <> \'\')\n"
"return -1;\n"
"\n"
"if (DAV_HIDE_ERROR ((pid := DAV_SEARCH_ID (path, \'P\'))) is null)\n"
"return pid;\n"
"\n"
"if (extern and 0 > (rc := DAV_AUTHENTICATE (pid, \'C\', \'11_\', auth_uname, auth_pwd)))\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"if (DAV_HIDE_ERROR (DAV_SEARCH_ID (subseq (par, 0, length (par) - 1), \'R\')) is not null)\n"
"{\n"
"\n"
"return -25;\n"
"}\n"
"if ((0 = return_error_if_already_exists) and (rc := DAV_HIDE_ERROR (DAV_SEARCH_ID (path, \'C\'))) is not null)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"if (check_locks and 0 <> (rc := DAV_IS_LOCKED (pid , \'C\', check_locks)))\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"\n"
"if (isarray (pid))\n"
"det := pid[0];\n"
"else if (pid > 0)\n"
"det := coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID=pid), NULL);\n"
"else\n"
"det := null;\n"
"if (det is not null)\n"
"{\n"
"declare auth_uid integer;\n"
"declare detcol_id integer;\n"
"declare detcol_path, unreached_path any;\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (pid, \'C\', \'11_\', auth_uname, auth_pwd);\n"
"if (0 > auth_uid)\n"
"return auth_uid;\n"
"}\n"
"else\n"
"auth_uid := http_nobody_uid ();\n"
"DAV_SEARCH_ID_OR_DET (par, \'C\', det, detcol_id, detcol_path, unreached_path);\n"
"return call (cast (det as varchar) || \'_DAV_COL_CREATE\') (detcol_id, unreached_path, permissions, ouid, ogid, auth_uid);\n"
"}\n"
"name := aref (par, length (par) - 2);\n"
"rc := WS.WS.GETID (\'C\');\n"
"if (ouid is null)\n"
"DAV_OWNER_ID (uid, gid, ouid, ogid);\n"
"\n"
"declare exit handler for sqlstate \'*\' { rc := -3; };\n"
"{\n"
"\n"
"insert soft WS.WS.SYS_DAV_COL (COL_ID, COL_NAME, COL_PARENT,\n"
"COL_OWNER, COL_GROUP, COL_PERMS,\n"
"COL_CR_TIME, COL_MOD_TIME)\n"
"values (rc, name, pid, ouid, ogid, permissions, now(), now ());\n"
"if (not row_count())\n"
"rc := -3;\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:1861\n";

static const char *proc111 = 
"create procedure DB.DBA.IS_REDIRECT_REF (inout path any)\n"
"{\n"
"for (select blob_to_string (PROP_VALUE) redirectRef\n"
"from WS.WS.SYS_DAV_RES,\n"
"WS.WS.SYS_DAV_PROP\n"
"where RES_FULL_PATH = path\n"
"and PROP_PARENT_ID = RES_ID\n"
"and PROP_NAME = \'redirectref\'\n"
"and PROP_TYPE = \'R\') do\n"
"{\n"
"path := redirectRef;\n"
"return 1;\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:1951\n";

static const char *proc112 = 
" create procedure\n"
"DAV_RES_UPLOAD (\n"
"in path varchar,\n"
"in content any,\n"
"in type varchar := \'\',\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uid varchar := null, in auth_pwd varchar := null, in check_locks any := 1)\n"
"{\n"
"if (not (isstring (check_locks)))\n"
"check_locks := 1;\n"
"return (DAV_RES_UPLOAD_STRSES_INT (path, content, type, permissions, uid, gid, auth_uid, auth_pwd, 1, null, null, null, null, null, check_locks));\n"
"}\n"
"--src dav_api.sql:1971\n";

static const char *proc113 = 
" create procedure\n"
"DAV_RES_UPLOAD_STRSES (\n"
"in path varchar,\n"
"inout content any,\n"
"in type varchar := \'\',\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uid varchar := null, in auth_pwd varchar := null, in check_locks any := 1)\n"
"{\n"
"if (not (isstring (check_locks)))\n"
"check_locks := 1;\n"
"return (DAV_RES_UPLOAD_STRSES_INT (path, content, type, permissions, uid, gid, auth_uid, auth_pwd, 1, null, null, null, null, null, check_locks));\n"
"}\n"
"--src dav_api.sql:1988\n";

static const char *proc114 = 
"create procedure\n"
"DAV_RES_UPLOAD_STRSES_INT (\n"
"in path varchar,\n"
"inout content any,\n"
"in type varchar := \'\',\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid any := \'dav\',\n"
"in gid any := \'administrators\',\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in cr_time datetime := null,\n"
"in mod_time datetime := null,\n"
"in _rowguid varchar := null,\n"
"in ouid integer := null,\n"
"in ogid integer := null,\n"
"in check_locks any := 1\n"
")\n"
"{\n"
"declare auth_uid, pid, puid, pgid, rc, id integer;\n"
"declare pperms, name varchar;\n"
"declare par any;\n"
"declare op char;\n"
"declare det varchar;\n"
"declare detcol_id, _is_xper_res, fake integer;\n"
"declare detcol_path, unreached_path any;\n"
"declare res_cr cursor for select RES_ID+1 from WS.WS.SYS_DAV_RES where RES_ID = id for update;\n"
"declare auto_version varchar;\n"
"declare locked int;\n"
"\n"
"\n"
"if (IS_REDIRECT_REF (path))\n"
"{\n"
"\n"
" ;\n"
"}\n"
"locked := 0;\n"
"op := \'i\';\n"
"rc := 0;\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"\n"
"if (aref (par, 0) <> \'\' or aref (par, length (par) - 1) = \'\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (ouid is null)\n"
"DAV_OWNER_ID (uid, gid, ouid, ogid);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"id := DAV_SEARCH_ID (path, \'R\');\n"
"\n"
"if (isarray (id))\n"
"{\n"
"if (extern)\n"
"{\n"
"\n"
"auth_uid := DAV_AUTHENTICATE (id, \'R\', \'11_\', auth_uname, auth_pwd);\n"
"if ((auth_uid < 0) and (auth_uid <> -1))\n"
"return auth_uid;\n"
"}\n"
"else\n"
"auth_uid := ouid;\n"
"if (check_locks)\n"
"{\n"
"rc := DAV_IS_LOCKED (id , \'R\', check_locks);\n"
"if (0 <> rc)\n"
"return rc;\n"
"}\n"
"DAV_SEARCH_ID_OR_DET (par, \'R\', det, detcol_id, detcol_path, unreached_path);\n"
"rc := call (cast (det as varchar) || \'_DAV_RES_UPLOAD\') (detcol_id, unreached_path, content, type, permissions, ouid, ogid, auth_uid);\n"
"\n"
"return rc;\n"
"}\n"
"if (0 > id)\n"
"{\n"
"pid := DAV_SEARCH_ID (path, \'P\');\n"
"if (isarray (pid))\n"
"det := pid[0];\n"
"else if (pid > 0)\n"
"det := coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID=pid), NULL);\n"
"else\n"
"{\n"
"\n"
"return pid;\n"
"}\n"
"if (extern)\n"
"{\n"
"\n"
"auth_uid := DAV_AUTHENTICATE (pid, \'C\', \'11_\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"{\n"
"\n"
"return auth_uid;\n"
"}\n"
"}\n"
"else\n"
"auth_uid := ouid;\n"
"if (check_locks)\n"
"{\n"
"rc := DAV_IS_LOCKED (pid , \'C\', check_locks);\n"
"if (0 <> rc)\n"
"return rc;\n"
"}\n"
"set isolation=\'committed\';\n"
"if ( auth_uid <> http_nobody_uid() and\n"
"(http_dav_uid () <> coalesce (connection_get (\'DAVBillingUserID\'), -12)) and\n"
"exists (select top 1 1 from SYS_USERS\n"
"where U_ID = auth_uid and U_ACCOUNT_DISABLED = 1 ) )\n"
"return -42;\n"
"set isolation=\'serializable\';\n"
"if (det is not null)\n"
"{\n"
"DAV_SEARCH_ID_OR_DET (par, \'R\', det, detcol_id, detcol_path, unreached_path);\n"
"rc := call (cast (det as varchar) || \'_DAV_RES_UPLOAD\') (detcol_id, unreached_path, content, type, permissions, ouid, ogid, auth_uid);\n"
"\n"
"return rc;\n"
"}\n"
"name := aref (par, length (par) - 1);\n"
"rc := WS.WS.GETID (\'R\');\n"
"op := \'i\';\n"
"if (cr_time is null)\n"
"cr_time := now();\n"
"}\n"
"else\n"
"{\n"
"open res_cr (exclusive, prefetch 1);\n"
"fetch res_cr into fake;\n"
"if (extern)\n"
"{\n"
"\n"
"auth_uid := DAV_AUTHENTICATE (id, \'R\', \'11_\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"{\n"
"\n"
"return auth_uid;\n"
"}\n"
"}\n"
"else\n"
"auth_uid := ouid;\n"
"auto_version := DAV_HIDE_ERROR (DB.DBA.DAV_PROP_GET_INT(DAV_SEARCH_ID (path, \'R\'), \'R\', \'DAV:auto-version\', 0));\n"
"if (check_locks)\n"
"{\n"
"rc := DAV_IS_LOCKED (id , \'R\', check_locks);\n"
"if (rc < 0)\n"
"locked := 1;\n"
"else\n"
"locked := 0;\n"
"if (auto_version is not null)\n"
"{\n"
"declare vanilla_rc int;\n"
"vanilla_rc := DAV_IS_LOCKED (id , \'R\', 1);\n"
"if (vanilla_rc < 0)\n"
"locked := 1;\n"
"if (vanilla_rc = -8 and (auto_version = \'DAV:checkout-unlocked-checkin\'))\n"
"rc := 0;\n"
"else if (vanilla_rc = -8 and (auto_version = \'DAV:locked-checkout\'))\n"
"rc := 0;\n"
"}\n"
"if (0 <> rc)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"}\n"
"rc := id;\n"
"op := \'u\';\n"
"if (cr_time is null or _rowguid is null)\n"
"{\n"
"declare _cr_time datetime;\n"
"declare __rowguid varchar;\n"
"select RES_CR_TIME, ROWGUID into _cr_time, __rowguid\n"
"from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"if (cr_time is null)\n"
"cr_time := _cr_time;\n"
"if (_rowguid is null)\n"
"_rowguid := __rowguid;\n"
"}\n"
"}\n"
"if (DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (par, vector (\'\')), \'C\')) is not null)\n"
"{\n"
"\n"
"return -26;\n"
"}\n"
"if (mod_time is null)\n"
"mod_time := now();\n"
"if (type = \'\')\n"
"type := http_mime_type (path);\n"
"\n"
"\n"
"if (type = \'text/xml\'\n"
"and exists (select 1 from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = pid and PROP_TYPE = \'C\'\n"
"and PROP_NAME = \'xper\'))\n"
"{\n"
"insert soft WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_TYPE, PROP_PARENT_ID, PROP_VALUE)\n"
"values (WS.WS.GETID (\'P\'), \'xper\', \'R\', id, \'\');\n"
"_is_xper_res := 1;\n"
"}\n"
"else if (rc <> 0)\n"
"{\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_NAME = \'xper\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = id;\n"
"_is_xper_res := 0;\n"
"}\n"
"\n"
"\n"
"whenever sqlstate \'*\' goto unhappy_upload;\n"
"\n"
"if (op = \'i\')\n"
"{\n"
"\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL,\n"
"RES_OWNER, RES_GROUP, RES_PERMS,\n"
"RES_CR_TIME, RES_MOD_TIME,\n"
"RES_TYPE, RES_CONTENT, ROWGUID)\n"
"values (rc, name, pid, ouid, ogid, permissions, cr_time, mod_time, type, content, _rowguid);\n"
"if (_is_xper_res)\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = xml_persistent (RES_CONTENT) where RES_ID = id;\n"
"}\n"
"else\n"
"{\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (id, \'R\', \'DAV:checked-in\', 0)) is not null)\n"
"{\n"
"if (auto_version = \'DAV:checkout-checkin\')\n"
"{\n"
" ;\n"
"}\n"
"else if ( (locked and (auto_version = \'DAV:checkout-unlocked-checkin\')) or\n"
"(auto_version = \'DAV:checkout\') or\n"
"(locked and (auto_version = \'DAV:locked-checkout\')) )\n"
"return \"Versioning_CHECKOUT_INT\" (id, content, type, permissions, ouid, ogid);\n"
"else if (locked or\n"
"(auto_version is null) or\n"
"((auto_version <> \'DAV:checkout-unlocked-checkin\') and\n"
"(auto_version <> \'DAV:checkout-checkin\')))\n"
"return -38;\n"
"}\n"
"\n"
"update WS.WS.SYS_DAV_RES\n"
"set RES_OWNER = ouid,\n"
"RES_GROUP = ogid,\n"
"RES_PERMS = permissions,\n"
"RES_CR_TIME = cr_time,\n"
"RES_MOD_TIME = mod_time,\n"
"RES_TYPE = type,\n"
"RES_CONTENT = content,\n"
"ROWGUID = _rowguid\n"
"where current of res_cr;\n"
"if (_is_xper_res)\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = xml_persistent (RES_CONTENT) where current of res_cr;\n"
"}\n"
"\n"
"\n"
"\n"
"declare c_id integer;\n"
"declare is_rdf integer;\n"
"declare rdf_graph, rdf_graph2, rdf_sponger any;\n"
"declare rdf_graph_resource_id, rdf_graph_resource_name, rdf_graph_resource_path, host any;\n"
"\n"
"\n"
"RDF_SINK_DELETE (path);\n"
"\n"
"\n"
"is_rdf := 0;\n"
"\n"
"\n"
"c_id := (select RES_COL from WS.WS.SYS_DAV_RES where RES_ID = rc);\n"
"\n"
"\n"
"rdf_graph := (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = c_id and PROP_TYPE = \'C\' and PROP_NAME = \'virt:rdf_graph\');\n"
"if (not DB.DBA.is_empty_or_null (rdf_graph))\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto _bad_content;\n"
"};\n"
"\n"
"rdf_graph2 := \'http://local.virt\' || path;\n"
"\n"
"content := (select RES_CONTENT from WS.WS.SYS_DAV_RES where RES_ID = rc);\n"
"rdf_sponger := coalesce((select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = c_id and PROP_TYPE = \'C\' and PROP_NAME = \'virt:rdf_sponger\'), \'on\');\n"
"\n"
"if (RDF_SINK_UPLOAD (content, type, rdf_graph, rdf_graph2, rdf_sponger))\n"
"{\n"
"rdf_graph_resource_name := replace ( replace ( replace ( replace ( replace ( replace ( replace (rdf_graph, \'/\', \'_\'), \'\\\\\', \'_\'), \':\', \'_\'), \'+\', \'_\'), \'\\\"\', \'_\'), \'[\', \'_\'), \']\', \'_\') || \'.RDF\';\n"
"rdf_graph_resource_path := WS.WS.COL_PATH (c_id) || rdf_graph_resource_name;\n"
"if (isnull (DAV_HIDE_ERROR (DAV_SEARCH_ID (rdf_graph_resource_path, \'R\'))))\n"
"{\n"
"\n"
"host := cfg_item_value (virtuoso_ini_path (), \'URIQA\', \'DefaultHost\');\n"
"if (host is null)\n"
"{\n"
"host := sys_stat (\'st_host_name\');\n"
"if (server_http_port () <> \'80\')\n"
"host := host ||\':\'|| server_http_port ();\n"
"}\n"
"rdf_graph_resource_id := WS.WS.GETID (\'R\');\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_OWNER, RES_GROUP, RES_PERMS, RES_CR_TIME, RES_MOD_TIME, RES_TYPE, RES_CONTENT)\n"
"values (rdf_graph_resource_id, rdf_graph_resource_name, c_id, ouid, ogid, \'111101101NN\', now (), now (), \'text/xml\', \'\');\n"
"DB.DBA.DAV_PROP_SET_INT (rdf_graph_resource_path, \'redirectref\', sprintf (\'http://%s/sparql?default-graph-uri=%U&query=%U&format=%U\', host, rdf_graph, \'CONSTRUCT { ?s ?p ?o} WHERE {?s ?p ?o}\', \'text/xml\'), null, null, 0, 0, 1);\n"
"}\n"
"}\n"
"_bad_content:;\n"
"}\n"
"return rc;\n"
"\n"
"unhappy_upload:\n"
"if (__SQL_STATE = \'HT507\')\n"
"return -41;\n"
"if (__SQL_STATE = \'HT508\')\n"
"return -42;\n"
"if (__SQL_STATE = \'HT509\')\n"
"return -43;\n"
"return -29;\n"
"}\n"
"--src dav_api.sql:2005\n";

static const char *proc115 = 
"create procedure RDF_SINK_UPLOAD (\n"
"inout content any,\n"
"inout type varchar,\n"
"in rdf_graph varchar,\n"
"in rdf_graph2 varchar,\n"
"in rdf_sponger varchar)\n"
"{\n"
"if (\n"
"strstr (type, \'application/rdf+xml\') is not null or\n"
"strstr (type, \'application/foaf+xml\') is not null\n"
")\n"
"{\n"
"if (rdf_sponger = \'on\')\n"
"{\n"
"declare xt any;\n"
"\n"
"xt := xtree_doc (content);\n"
"if (xpath_eval (\'[ xmlns:dv=\"http://www.w3.org/2003/g/data-view#\" ] /*[1]/@dv:transformation\', xt) is not null)\n"
"goto _grddl;\n"
"}\n"
"DB.DBA.RDF_LOAD_RDFXML (blob_to_string (content), rdf_graph2, rdf_graph2);\n"
"goto _exit;\n"
"}\n"
"if (\n"
"strstr (type, \'text/rdf+n3\') is not null or\n"
"strstr (type, \'text/rdf+ttl\') is not null or\n"
"strstr (type, \'application/rdf+n3\') is not null or\n"
"strstr (type, \'application/rdf+turtle\') is not null or\n"
"strstr (type, \'application/turtle\') is not null or\n"
"strstr (type, \'application/x-turtle\') is not null\n"
")\n"
"{\n"
"DB.DBA.TTLP (content, rdf_graph2, rdf_graph2);\n"
"goto _exit;\n"
"}\n"
"\n"
"_grddl:;\n"
"if (rdf_sponger = \'on\')\n"
"{\n"
"declare aq, ps, xrc any;\n"
"declare ret_body varchar;\n"
"\n"
"ret_body := cast (content as varchar);\n"
"ps := cfg_item_value (virtuoso_ini_path (), \'SPARQL\', \'PingService\');\n"
"aq := case when (length (ps)) then async_queue (1) else null end;\n"
"for select RM_PATTERN, RM_TYPE, RM_HOOK, RM_KEY, RM_OPTIONS from DB.DBA.SYS_RDF_MAPPERS where RM_ENABLED = 1 order by RM_ID do\n"
"{\n"
"declare val_match, pcols, npars any;\n"
"\n"
"val_match := case when (RM_TYPE = \'MIME\') then type else rdf_graph2 end;\n"
"if (isstring (val_match) and regexp_match (RM_PATTERN, val_match) is not null)\n"
"{\n"
"if (__proc_exists (RM_HOOK) is null)\n"
"goto try_next_mapper;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto try_next_mapper;\n"
"};\n"
"\n"
"pcols := DB.DBA.RDF_PROC_COLS (RM_HOOK);\n"
"npars := case when (isarray (pcols)) then length (pcols) else 8 end;\n"
"if (npars = 7)\n"
"{\n"
"xrc := call (RM_HOOK) (rdf_graph2, rdf_graph2, null, ret_body, aq, ps, RM_KEY);\n"
"} else {\n"
"xrc := call (RM_HOOK) (rdf_graph2, rdf_graph2, null, ret_body, aq, ps, RM_KEY, RM_OPTIONS);\n"
"}\n"
"if (__tag(xrc) = 193 or xrc < 0 or xrc > 0)\n"
"{\n"
"goto _exit;\n"
"}\n"
"}\n"
"try_next_mapper:;\n"
"}\n"
"}\n"
"return 0;\n"
"\n"
"_exit:\n"
"SPARQL insert in graph ?:rdf_graph { ?s ?p ?o } where { graph `iri(?:rdf_graph2)` { ?s ?p ?o } };\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:2325\n";

static const char *proc116 = 
"create procedure RDF_SINK_DELETE (\n"
"in path2 any)\n"
"{\n"
"declare c_id integer;\n"
"declare parts, path, rdf_graph, rdf_graph2 any;\n"
"\n"
"parts := split_and_decode (path2, 0, \'\\0\\0/\');\n"
"if (length (parts) <>  6)\n"
"return;\n"
"if (parts[0] <> \'\')\n"
"return;\n"
"if (parts[length (parts) - 1] = \'\')\n"
"return;\n"
"if (parts[length (parts) - 2] <> \'rdf_sink\')\n"
"return;\n"
"\n"
"rdf_graph2 := \'http://local.virt\' || path2;\n"
"\n"
"path := replace (path2, parts[length (parts) - 1], \'\');\n"
"c_id := DAV_SEARCH_ID (path, \'C\');\n"
"if (isinteger (c_id) and (c_id > 0))\n"
"{\n"
"rdf_graph := (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = c_id and PROP_TYPE = \'C\' and PROP_NAME = \'virt:rdf_graph\');\n"
"if (not DB.DBA.is_empty_or_null (rdf_graph))\n"
"{\n"
"SPARQL delete from graph ?:rdf_graph { ?s ?p ?o } where { graph `iri(?:rdf_graph2)` { ?s ?p ?o } };\n"
"}\n"
"}\n"
"\n"
"SPARQL clear graph ?:rdf_graph2;\n"
"}\n"
"--src dav_api.sql:2409\n";

static const char *proc117 = 
" create procedure\n"
"DAV_DELETE (\n"
"in path varchar,\n"
"in silent integer := 0,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar\n"
")\n"
"{\n"
"return DAV_DELETE_INT (path, silent, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:2443\n";

static const char *proc118 = 
"create procedure\n"
"DAV_DELETE_INT (\n"
"in path varchar,\n"
"in silent integer := 0,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in extern integer := 1,\n"
"in check_locks any := 1 )\n"
"{\n"
"declare id, rc integer;\n"
"declare ty char;\n"
"declare auth_uid integer;\n"
"declare par any;\n"
"whenever sqlstate \'HT508\' goto disabled_owner;\n"
"whenever sqlstate \'HT509\' goto disabled_home;\n"
"\n"
"par := split_and_decode (path, 0, \'\\0\\0/\');\n"
"if (aref (par, 0) <> \'\')\n"
"return -1;\n"
"if (aref (par, length (par) - 1) = \'\')\n"
"ty := \'C\';\n"
"else\n"
"ty := \'R\';\n"
"id := DAV_SEARCH_ID (par, ty);\n"
"if (isinteger (id) and (0 > id))\n"
"return (case when silent then 1 else id end);\n"
"\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, ty, \'11_\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return (case when silent then 1 else auth_uid end);\n"
"}\n"
"else\n"
"auth_uid := http_nobody_uid ();\n"
"if (check_locks and (0 <> (rc := DAV_IS_LOCKED (id, ty, check_locks))))\n"
"return rc;\n"
"\n"
"if (isarray (id))\n"
"{\n"
"declare det varchar;\n"
"declare detcol_id, detcol_path, unreached_path any;\n"
"DAV_SEARCH_ID_OR_DET (par, ty, det, detcol_id, detcol_path, unreached_path);\n"
"return call (cast (det as varchar) || \'_DAV_DELETE\') (detcol_id, unreached_path, ty, silent, auth_uid);\n"
"}\n"
"\n"
"if (ty = \'R\')\n"
"{\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"RDF_SINK_DELETE (path);\n"
"}\n"
"else if (ty = \'C\')\n"
"{\n"
"declare rrc integer;\n"
"for select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_COL = id do\n"
"{\n"
"rrc := DAV_DELETE_INT (RES_FULL_PATH, silent, auth_uname, auth_pwd, extern);\n"
"if (rrc <> 1)\n"
"{\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"for select COL_ID from WS.WS.SYS_DAV_COL where COL_PARENT = id do\n"
"{\n"
"rrc := DAV_DELETE_INT (WS.WS.COL_PATH(COL_ID), silent, auth_uname, auth_pwd, extern);\n"
"if (rrc <> 1)\n"
"{\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"delete from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"}\n"
"else if (not silent)\n"
"return -1;\n"
"return 1;\n"
"\n"
"disabled_owner:\n"
"return -42;\n"
"disabled_home:\n"
"return -43;\n"
"}\n"
"--src dav_api.sql:2455\n";

static const char *proc119 = 
"create function DAV_TAG_LIST (in id any, in st char (1), in uid_list any) returns any\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"whenever sqlstate \'42001\' goto unsupported;\n"
"return call (cast (id[0] as varchar) || \'_DAV_TAG_LIST\')(id, st, uid_list);\n"
"unsupported:\n"
"return -20;\n"
"}\n"
"if (\'R\' <> st)\n"
"return vector ();\n"
"if (uid_list is null)\n"
"return (select VECTOR_AGG (vector (DT_U_ID, DT_TAGS)) from Ws.WS.SYS_DAV_TAG where DT_RES_ID = id);\n"
"else\n"
"return (select VECTOR_AGG (vector (DT_U_ID, DT_TAGS)) from Ws.WS.SYS_DAV_TAG where DT_RES_ID = id and position (DT_U_ID, uid_list));\n"
"}\n"
"--src dav_api.sql:2541\n";

static const char *proc120 = 
"create function DAV_TAG_SET (in id any, in st char (1), in uid integer, in tags varchar) returns integer\n"
"{\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_USER where U_ID = uid))\n"
"return -18;\n"
"if (\'R\' <> st)\n"
"return -14;\n"
"if (exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = uid))\n"
"{\n"
"update WS.WS.SYS_DAV_TAG set DT_TAGS = tags where DT_RES_ID = id and DT_U_ID = uid;\n"
"}\n"
"else\n"
"{\n"
"insert into WS.WS.SYS_DAV_TAG (DT_RES_ID, DT_U_ID, DT_FT_ID, DT_TAGS)\n"
"values (id, uid, WS.WS.GETID (\'T\'), tags);\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:2559\n";

static const char *proc121 = 
" create procedure\n"
"DAV_COPY (in path varchar,\n"
"in destination varchar,\n"
"in overwrite integer := 0,\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar)\n"
"{\n"
"return DAV_COPY_INT (path, destination, overwrite, permissions, uid, gid, auth_uname, auth_pwd, 1);\n"
"}\n"
"--src dav_api.sql:2580\n";

static const char *proc122 = 
"create procedure\n"
"DAV_COPY_INT (in path varchar,\n"
"in destination varchar,\n"
"in overwrite integer := 0,\n"
"in permissions varchar := \'110100000RR\',\n"
"in uid varchar := \'dav\',\n"
"in gid varchar := \'administrators\',\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in ouid integer := null,\n"
"in ogid integer := null )\n"
"{\n"
"declare id, d_id, dp_id, rc integer;\n"
"declare auth_uid integer;\n"
"declare st, dp_det char;\n"
"declare sar, dar, prop_list, tag_list any;\n"
"whenever sqlstate \'HT507\' goto insufficient_storage;\n"
"whenever sqlstate \'HT508\' goto disabled_owner;\n"
"whenever sqlstate \'HT509\' goto disabled_home;\n"
"\n"
"if (IS_REDIRECT_REF(path))\n"
"{\n"
"\n"
" ;\n"
"}\n"
"\n"
"sar := split_and_decode (path, 0, \'\\0\\0/\');\n"
"dar := split_and_decode (destination, 0, \'\\0\\0/\');\n"
"\n"
"\n"
"if (aref (sar, 0) <> \'\')\n"
"return -1;\n"
"if (aref (sar, length (sar) - 1) = \'\')\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"\n"
"if (aref (dar, 0) <> \'\')\n"
"return -2;\n"
"if (aref (dar, length (dar) - 1) = \'\')\n"
"{\n"
"if (st = \'R\')\n"
"{\n"
"destination := concat (destination, sar[length (sar)-1]);\n"
"dar := split_and_decode (destination, 0, \'\\0\\0/\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (st = \'C\')\n"
"return -4;\n"
"}\n"
"id := DAV_SEARCH_ID (sar, st);\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return id;\n"
"\n"
"dp_id := DAV_SEARCH_ID (dar, \'P\');\n"
"d_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (dar, st));\n"
"if (d_id is null)\n"
"{\n"
"if (DAV_HIDE_ERROR (dp_id) is null)\n"
"return -2;\n"
"}\n"
"else\n"
"{\n"
"dp_id := DAV_SEARCH_ID (dar, \'P\');\n"
"}\n"
"if (d_id is not null and not overwrite)\n"
"return -3;\n"
"\n"
"if (d_id is not null and id = d_id)\n"
"return -2;\n"
"\n"
"\n"
"if (ouid is null)\n"
"DAV_OWNER_ID (uid, gid, ouid, ogid);\n"
"\n"
"\n"
"if (extern)\n"
"{\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (id, st, \'1__\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"if (d_id is not null)\n"
"{\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (d_id, st, \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"}\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (dp_id, \'C\', \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"}\n"
"else\n"
"auth_uid := ouid;\n"
"\n"
"if ((\'C\' = st) and DAV_HIDE_ERROR (DAV_SEARCH_ID (subseq (dar, 0, length (dar) - 1), \'R\')) is not null)\n"
"{\n"
"\n"
"return -25;\n"
"}\n"
"if ((\'R\' = st) and DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (dar, vector (\'\')), \'C\')) is not null)\n"
"{\n"
"\n"
"return -26;\n"
"}\n"
"if ((\'C\' = st) and destination between path and DAV_COL_PATH_BOUNDARY (path))\n"
"return -30;\n"
"\n"
"declare auto_version varchar;\n"
"if (st = \'R\')\n"
"auto_version := DAV_HIDE_ERROR (DB.DBA.DAV_PROP_GET_INT(d_id, \'R\', \'DAV:auto-version\', 0));\n"
"else\n"
"auto_version := NULL;\n"
"if (check_locks)\n"
"{\n"
"if (auto_version <> \'DAV:locked-checkout\')\n"
"{\n"
"if (0 <> (rc := DAV_IS_LOCKED (id , st, check_locks)))\n"
"return rc;\n"
"if (d_id is null)\n"
"rc := DAV_IS_LOCKED (dp_id , \'C\', check_locks);\n"
"else\n"
"rc := DAV_IS_LOCKED (d_id , st, check_locks);\n"
"if (0 <> rc)\n"
"return (case when rc = -8 then -9 else rc end);\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_IS_LOCKED (d_id , st, check_locks);\n"
"if (rc = -8)\n"
"{\n"
"rc := DAV_CHECKOUT_INT (d_id, null, null, 0);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"else if (0 <> rc)\n"
"return rc;\n"
"}\n"
"}\n"
"\n"
"if (isarray (dp_id))\n"
"dp_det := dp_id[0];\n"
"else\n"
"dp_det := coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID=dp_id), NULL);\n"
"if (dp_det is not null)\n"
"{\n"
"declare detcol_id integer;\n"
"declare detcol_path, unreached_path any;\n"
"DAV_SEARCH_ID_OR_DET (dar, st, dp_det, detcol_id, detcol_path, unreached_path);\n"
"return call (cast (dp_det as varchar) || \'_DAV_RES_UPLOAD_COPY\') (detcol_id, unreached_path, id, st, overwrite, permissions, ouid, ogid, auth_uid);\n"
"}\n"
"\n"
"if (st = \'R\')\n"
"{\n"
"declare newid integer;\n"
"if (d_id is not null)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"declare rt varchar;\n"
"declare rcnt any;\n"
"rcnt := string_output ();\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, rcnt, rt, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = rcnt, RES_TYPE = rt, RES_OWNER = ouid,\n"
"RES_GROUP = ogid, RES_PERMS = permissions, RES_MOD_TIME = now ()\n"
"where RES_ID = d_id;\n"
"}\n"
"else\n"
"for select RES_TYPE as rt, RES_CONTENT as rcnt from WS.WS.SYS_DAV_RES where RES_ID = id do\n"
"{\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = rcnt, RES_TYPE = rt, RES_OWNER = ouid,\n"
"RES_GROUP = ogid, RES_PERMS = permissions, RES_MOD_TIME = now ()\n"
"where RES_ID = d_id;\n"
"}\n"
"newid := d_id;\n"
"}\n"
"else\n"
"{\n"
"declare rname varchar;\n"
"rname := aref (dar, length (dar)-1);\n"
"if (rname = \'\')\n"
"return -2;\n"
"newid := WS.WS.GETID (\'R\');\n"
"if (isarray (id))\n"
"{\n"
"declare rt varchar;\n"
"declare rcnt any;\n"
"rcnt := string_output ();\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, rcnt, rt, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_FULL_PATH,\n"
"RES_OWNER, RES_GROUP, RES_PERMS,\n"
"RES_CR_TIME, RES_MOD_TIME,\n"
"RES_TYPE, RES_CONTENT)\n"
"values (newid, rname, dp_id, destination, ouid, ogid, permissions, now(), now (), rt, rcnt);\n"
"}\n"
"else\n"
"for select RES_TYPE as rt, RES_CONTENT as rcnt, RES_NAME as mname from WS.WS.SYS_DAV_RES\n"
"where RES_ID = id do\n"
"{\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_FULL_PATH,\n"
"RES_OWNER, RES_GROUP, RES_PERMS,\n"
"RES_CR_TIME, RES_MOD_TIME,\n"
"RES_TYPE, RES_CONTENT)\n"
"values (newid, rname, dp_id, destination, ouid, ogid, permissions, now(), now (), rt, rcnt);\n"
"}\n"
"}\n"
"prop_list := DAV_HIDE_ERROR (DAV_PROP_LIST_INT (id, \'R\', \'%\', 0, auth_uname, auth_pwd), vector ());\n"
"foreach (any prop in prop_list) do {\n"
"DAV_PROP_SET_INT (destination, prop[0], prop[1], null, null, 0, 0, 0, auth_uid);\n"
"}\n"
"tag_list := DAV_HIDE_ERROR (DAV_TAG_LIST (id, st, NULL), vector ());\n"
"foreach (any tagpair in tag_list) do {\n"
"DAV_TAG_SET (newid, \'R\', tagpair[0], tagpair[1]);\n"
"}\n"
"}\n"
"else if (st = \'C\')\n"
"{\n"
"declare cname varchar;\n"
"declare newid integer;\n"
"cname := aref (dar, length (dar)-1);\n"
"if (cname <> \'\')\n"
"return -2;\n"
"cname := aref (dar, length (dar)-2);\n"
"if (cname = \'\')\n"
"return -2;\n"
"if (isarray (id) and (id[0] like \'%CatFilter\'))\n"
"return -39;\n"
"if (d_id is not null)\n"
"{\n"
"declare rrc integer;\n"
"rrc := DAV_DELETE_INT (destination, 0, auth_uname, auth_pwd, 0);\n"
"if (rrc <> 1)\n"
"{\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"newid := DAV_COL_CREATE_INT (destination, permissions, uid, gid, auth_uname, auth_pwd, 0, 0, 0, ouid, ogid);\n"
"if (DAV_HIDE_ERROR (newid) is null)\n"
"{\n"
"rollback work;\n"
"return newid;\n"
"}\n"
"prop_list := DAV_HIDE_ERROR (DAV_PROP_LIST_INT (id, \'C\', \'%\', 0, auth_uname, auth_pwd), vector ());\n"
"foreach (any prop in prop_list) do {\n"
"DAV_PROP_SET_INT (destination, prop[0], prop[1], null, null, 0, 0, 0, auth_uid);\n"
"}\n"
"DAV_COPY_SUBTREE (id , newid, sar, destination, 1, ouid, ogid, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"return 1;\n"
"\n"
"insufficient_storage:\n"
"return -41;\n"
"disabled_owner:\n"
"return -42;\n"
"disabled_home:\n"
"return -43;\n"
"}\n"
"--src dav_api.sql:2595\n";

static const char *proc123 = 
"create function DAV_COPY_SUBTREE (in src any, in dst any, in sar any,\n"
"in dar any, in overwrite integer,\n"
"in ouid integer := null, in ogid integer := null,\n"
"in auth_uname varchar, in auth_pwd varchar, in auth_uid integer ) returns any\n"
"{\n"
"declare dirlist, ret, rc any;\n"
"\n"
"vectorbld_init (ret);\n"
"dirlist := DAV_DIR_LIST_INT (DAV_CONCAT_PATH (\'/\', sar), 0, \'%\', NULL, NULL, auth_uid);\n"
"foreach (any res in dirlist) do\n"
"{\n"
"if (\'R\' = res[1])\n"
"{\n"
"declare target_path varchar;\n"
"target_path := DAV_CONCAT_PATH (dar, res[10]);\n"
"rc := DAV_AUTHENTICATE (res[4], \'R\', \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"\n"
"\n"
"if (rc >= 0)\n"
"rc := DAV_COPY_INT (res[0], target_path, overwrite, res[5], res[7], res[6], auth_uname, auth_pwd, 0, 1, ouid, ogid );\n"
"vectorbld_acc (ret, vector (res[0], target_path, rc));\n"
"}\n"
"}\n"
"foreach (any res in dirlist) do\n"
"{\n"
"if (\'C\' = res[1])\n"
"{\n"
"declare target_path varchar;\n"
"target_path := DAV_CONCAT_PATH (dar, res[10]) || \'/\';\n"
"rc := DAV_AUTHENTICATE (res[4], \'C\', \'1__\', auth_uname, auth_pwd, auth_uid);\n"
"if (rc >= 0)\n"
"{\n"
"declare new_tgt_id integer;\n"
"if (isarray (res[4]) and (res[4][0] like \'%CatFilter\'))\n"
"{\n"
"vectorbld_acc (ret, vector (res[0], target_path, -39));\n"
"goto item_done; /* see below */\n"
"}\n"
"\n"
"new_tgt_id := DAV_COL_CREATE_INT (target_path, res[5], res[7], res[6], auth_uname, auth_pwd, 0, 0, 0, ouid, ogid );\n"
"vectorbld_acc (ret, vector (res[0], target_path, new_tgt_id));\n"
"if (DAV_HIDE_ERROR (new_tgt_id) is not null)\n"
"{\n"
"declare prop_list any;\n"
"prop_list := DAV_HIDE_ERROR (DAV_PROP_LIST_INT (res[4], \'C\', \'%\', 0, auth_uname, auth_pwd), vector ());\n"
"foreach (any prop in prop_list) do\n"
"{\n"
"DAV_PROP_SET_RAW (new_tgt_id, \'C\', prop[0], prop[1], 0, auth_uid);\n"
"}\n"
"}\n"
"rc := DAV_COPY_SUBTREE (res[4], new_tgt_id, res[0], target_path, overwrite, ouid, ogid, auth_uname, auth_pwd, auth_uid);\n"
"vectorbld_concat_acc (ret, rc);\n"
"item_done:;\n"
"}\n"
"}\n"
"}\n"
"vectorbld_final (ret);\n"
"return ret;\n"
"}\n"
"--src dav_api.sql:2861\n";

static const char *proc124 = 
" create procedure\n"
"DAV_MOVE (in path varchar,\n"
"in destination varchar,\n"
"in overwrite integer := 0,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar)\n"
"{\n"
"return DAV_MOVE_INT (path, destination, overwrite, auth_uname, auth_pwd, 1);\n"
"}\n"
"--src dav_api.sql:2924\n";

static const char *proc125 = 
"create procedure\n"
"DAV_MOVE_INT (in path varchar,\n"
"in destination varchar,\n"
"in overwrite integer := 0,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"in extern integer := 1,\n"
"in check_locks any := 1 )\n"
"{\n"
"declare id, d_id, dp_id, rc integer;\n"
"declare auth_uid integer;\n"
"declare st, dp_det char;\n"
"declare sar, dar, prop_list any;\n"
"whenever sqlstate \'HT507\' goto insufficient_storage;\n"
"whenever sqlstate \'HT508\' goto disabled_owner;\n"
"whenever sqlstate \'HT509\' goto disabled_home;\n"
"\n"
"\n"
"sar := split_and_decode (path, 0, \'\\0\\0/\');\n"
"dar := split_and_decode (destination, 0, \'\\0\\0/\');\n"
"\n"
"if (aref (sar, 0) <> \'\')\n"
"return -1;\n"
"if (aref (sar, length (sar) - 1) = \'\')\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"\n"
"if (aref (dar, 0) <> \'\')\n"
"return -2;\n"
"if (aref (dar, length (dar) - 1) = \'\')\n"
"{\n"
"if (st = \'R\')\n"
"{\n"
"destination := concat (destination, sar[length (sar)-1]);\n"
"dar := split_and_decode (destination, 0, \'\\0\\0/\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (st = \'C\')\n"
"return -4;\n"
"}\n"
"\n"
"id := DAV_SEARCH_ID (sar, st);\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return id;\n"
"\n"
"dp_id := DAV_SEARCH_ID (dar, \'P\');\n"
"d_id := DAV_HIDE_ERROR (DAV_SEARCH_ID (dar, st));\n"
"if (d_id is null)\n"
"{\n"
"if (DAV_HIDE_ERROR (dp_id) is null)\n"
"return -2;\n"
"}\n"
"else\n"
"{\n"
"dp_id := DAV_SEARCH_ID (dar, \'P\');\n"
"}\n"
"if (d_id is not null and not overwrite)\n"
"return -3;\n"
"\n"
"if (d_id is not null and id = d_id)\n"
"return -2;\n"
"\n"
"\n"
"if (extern)\n"
"{\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (id, st, \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"if (d_id is not null)\n"
"{\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (d_id, st, \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"}\n"
"if (0 > (auth_uid := DAV_AUTHENTICATE (dp_id, \'C\', \'11_\', auth_uname, auth_pwd)))\n"
"return auth_uid;\n"
"}\n"
"else\n"
"auth_uid := http_nobody_uid ();\n"
"\n"
"if ((\'C\' = st) and DAV_HIDE_ERROR (DAV_SEARCH_ID (subseq (dar, 0, length (dar) - 1), \'R\')) is not null)\n"
"{\n"
"\n"
"return -25;\n"
"}\n"
"if ((\'R\' = st) and (0 = overwrite) and DAV_HIDE_ERROR (DAV_SEARCH_ID (vector_concat (dar, vector (\'\')), \'C\')) is not null)\n"
"{\n"
"\n"
"return -26;\n"
"}\n"
"if ((\'C\' = st) and destination between path and DAV_COL_PATH_BOUNDARY (path))\n"
"return -30;\n"
"if (check_locks)\n"
"{\n"
"if (0 <> (rc := DAV_IS_LOCKED (id , st, check_locks)))\n"
"return rc;\n"
"if (d_id is null)\n"
"rc := DAV_IS_LOCKED (dp_id , \'C\', check_locks);\n"
"else\n"
"rc := DAV_IS_LOCKED (d_id , st, check_locks);\n"
"if (0 <> rc)\n"
"return (case when rc = -8 then -9 else rc end);\n"
"}\n"
"\n"
"if (isarray (dp_id))\n"
"dp_det := dp_id[0];\n"
"else\n"
"dp_det := coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID=dp_id), NULL);\n"
"if (dp_det is not null)\n"
"{\n"
"declare detcol_id integer;\n"
"declare detcol_path, unreached_path any;\n"
"DAV_SEARCH_ID_OR_DET (dar, st, dp_det, detcol_id, detcol_path, unreached_path);\n"
"return call (cast (dp_det as varchar) || \'_DAV_RES_UPLOAD_MOVE\') (detcol_id, unreached_path, id, st, overwrite, auth_uid);\n"
"}\n"
"\n"
"if (st = \'R\')\n"
"{\n"
"\n"
"if (d_id is not null)\n"
"{\n"
"\n"
"if (isarray (id))\n"
"{\n"
"declare rt varchar;\n"
"declare rcnt any;\n"
"declare dirsingle any;\n"
"dirsingle := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id, \'R\', path, auth_uid);\n"
"if (isinteger (dirsingle))\n"
"{\n"
"signal (\'.....\', sprintf (\'DAV_DIR_SINGLE failed during DAV_MOVE\'));\n"
"return -100;\n"
"}\n"
"rcnt := string_output ();\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, rcnt, rt, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = rcnt, RES_TYPE = rt, RES_OWNER = dirsingle[7],\n"
"RES_GROUP = dirsingle[6], RES_PERMS = dirsingle[5], RES_MOD_TIME = now ()\n"
"where RES_ID = d_id;\n"
"rc := DAV_DELETE_INT (path, 1, null, null, 0);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"else\n"
"{\n"
"declare pid integer;\n"
"declare rname, rtype varchar;\n"
"select RES_COL, RES_NAME, RES_TYPE into pid, rname, rtype from WS.WS.SYS_DAV_RES where RES_ID = d_id;\n"
"delete from WS.WS.SYS_DAV_TAG where DT_RES_ID = d_id;\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = d_id;\n"
"update WS.WS.SYS_DAV_RES set RES_COL = dp_id, RES_NAME = rname,\n"
"RES_MOD_TIME = now () where RES_ID = id;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE=\'R\' and LOCK_PARENT_ID=id;\n"
"update WS.WS.SYS_DAV_LOCK set LOCK_PARENT_ID = id where LOCK_PARENT_TYPE=\'R\' and LOCK_PARENT_ID=d_id;\n"
"\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare rname varchar;\n"
"rname := aref (dar, length (dar)-1);\n"
"if (rname = \'\')\n"
"return -3;\n"
"if (isarray (id))\n"
"{\n"
"declare rt varchar;\n"
"declare rcnt any;\n"
"declare newid integer;\n"
"declare dirsingle any;\n"
"newid := WS.WS.GETID (\'R\');\n"
"dirsingle := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id, \'R\', path, auth_uid);\n"
"if (isinteger (dirsingle))\n"
"{\n"
"signal (\'.....\', sprintf (\'DAV_DIR_SINGLE failed during DAV_MOVE\'));\n"
"return -100;\n"
"}\n"
"rcnt := string_output ();\n"
"rc := call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, rcnt, rt, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"insert into WS.WS.SYS_DAV_RES (RES_ID, RES_NAME, RES_COL, RES_FULL_PATH,\n"
"RES_OWNER, RES_GROUP, RES_PERMS,\n"
"RES_CR_TIME, RES_MOD_TIME,\n"
"RES_TYPE, RES_CONTENT)\n"
"values (newid, rname, dp_id, destination, dirsingle[7], dirsingle[6], dirsingle[5], now(), now (), rt, rcnt);\n"
"rc := DAV_DELETE_INT (path, 1, null, null, 0);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"else\n"
"update WS.WS.SYS_DAV_RES set RES_COL = dp_id, RES_NAME = rname,\n"
"RES_MOD_TIME = now () where RES_ID = id;\n"
"\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE=\'R\' and LOCK_PARENT_ID=id;\n"
"}\n"
"prop_list := DAV_HIDE_ERROR (DAV_PROP_LIST_INT (id, st, \'%\', 0, auth_uname, auth_pwd), vector ());\n"
"foreach (any prop in prop_list) do\n"
"{\n"
"\n"
"if (prop[0] not in (\'DAV:checked-in\', \'DAV:checked-out\', \'DAV:version-history\'))\n"
"DAV_PROP_SET_INT (destination, prop[0], prop[1], null, null, 0, 0, 0, auth_uid);\n"
"}\n"
"}\n"
"else if (st = \'C\')\n"
"{\n"
"declare rname varchar;\n"
"rname := aref (dar, length (dar)-1);\n"
"if (rname <> \'\')\n"
"return -3;\n"
"rname := aref (dar, length (dar)-2);\n"
"if (rname = \'\')\n"
"return -3;\n"
"if (d_id is not null)\n"
"{\n"
"declare rrc integer;\n"
"rrc := DAV_DELETE_INT (destination, 0, auth_uname, auth_pwd, 0);\n"
"if (rrc <> 1)\n"
"{\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_COL where COL_ID = id))\n"
"{\n"
"rollback work;\n"
"return -2;\n"
"}\n"
"update WS.WS.SYS_DAV_COL set COL_NAME = rname, COL_PARENT = dp_id, COL_MOD_TIME = now ()\n"
"where COL_ID = id;\n"
"delete from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_TYPE=\'C\' and LOCK_PARENT_ID=id;\n"
"if (d_id is not null)\n"
"update WS.WS.SYS_DAV_LOCK set LOCK_PARENT_ID = id where LOCK_PARENT_TYPE=\'C\' and LOCK_PARENT_ID=d_id;\n"
"}\n"
"return 1;\n"
"\n"
"insufficient_storage:\n"
"return -41;\n"
"disabled_owner:\n"
"return -42;\n"
"disabled_home:\n"
"return -43;\n"
"}\n"
"--src dav_api.sql:2936\n";

static const char *proc126 = 
"create function\n"
"DAV_GET_OWNER (in id any, in st char(1)) returns integer\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"declare diritm any;\n"
"diritm := DAV_DIR_SINGLE_INT (id, st, \'\', null, null, http_dav_uid ());\n"
"if (DAV_HIDE_ERROR (diritm) is null)\n"
"return diritm;\n"
"return diritm [7];\n"
"}\n"
"if (\'C\' = st)\n"
"return coalesce ((select COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = id), -1);\n"
"if (\'R\' = st)\n"
"return coalesce ((select RES_OWNER from WS.WS.SYS_DAV_RES where RES_ID = id), -1);\n"
"return -14;\n"
"}\n"
"--src dav_api.sql:3183\n";

static const char *proc127 = 
"create function\n"
"DAV_PREPARE_PROP_WRITE (\n"
"in path varchar,\n"
"out id any,\n"
"out st varchar,\n"
"in propname varchar,\n"
"in auth_uname varchar,\n"
"in auth_pwd varchar,\n"
"inout auth_uid integer,\n"
"in extern integer,\n"
"out auto_version varchar,\n"
"inout check_locks any,\n"
"out locked integer) returns integer\n"
"{\n"
"declare rc integer;\n"
"if ((path <> \'\') and (path[length(path)-1] = 47))\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"id := DAV_SEARCH_ID (path, st);\n"
"\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"return id;\n"
"}\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, st, \'11_\', auth_uname, auth_pwd);\n"
"if (auth_uid >= 0)\n"
"goto auth_uid_ok;\n"
"if ((auth_uid = -13) and (propname = \':virtprivatetags\'))\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, st, \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid >= 0)\n"
"goto auth_uid_ok;\n"
"}\n"
"if ((auth_uid = -13) and (propname in (\':virtpermissions\', \':virtowneruid\', \':virtownergid\', \':virtacl\')))\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, st, \'___\', auth_uname, auth_pwd);\n"
"if (auth_uid >= 0)\n"
"goto auth_uid_ok;\n"
"}\n"
"return auth_uid;\n"
"}\n"
"else if (auth_uid is null)\n"
"auth_uid := coalesce ((select U_ID from WS.WS.SYS_DAV_USER where U_NAME = auth_uname), http_nobody_uid());\n"
"\n"
"auth_uid_ok:\n"
"auto_version := DAV_HIDE_ERROR (DB.DBA.DAV_PROP_GET_INT(DAV_SEARCH_ID (path, \'R\'), \'R\', \'DAV:auto-version\', 0));\n"
"if (check_locks)\n"
"{\n"
"rc := DAV_IS_LOCKED (id , st, check_locks);\n"
"if (rc < 0)\n"
"locked := 1;\n"
"else\n"
"locked := 0;\n"
"if (rc = -8 and (auto_version = \'DAV:checkout-unlocked-checkin\'))\n"
"rc := 0;\n"
"else if (rc = -8 and (auto_version = \'DAV:locked-checkout\'))\n"
"rc := 0;\n"
"if (0 <> rc)\n"
"return rc;\n"
"}\n"
"if (\n"
"((propname like \'xml-stylesheet%\') or (propname like \'xml-sql%\')) and\n"
"((auth_uid <> 0) and (auth_uid <> http_dav_uid())) )\n"
"{\n"
"set isolation=\'committed\';\n"
"if (not exists (\n"
"select top 1 1 from DB.DBA.SYS_USERS\n"
"where U_ID = auth_uid and U_DAV_ENABLE and U_SQL_ENABLE\n"
"and not U_ACCOUNT_DISABLED ) )\n"
"return -32;\n"
"if (DAV_GET_OWNER (id, st) <> auth_uid)\n"
"return -32;\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:3203\n";

static const char *proc128 = 
" create procedure\n"
"DAV_PROP_SET (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in propvalue any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in overwrite integer := 0 )\n"
"{\n"
"return DAV_PROP_SET_INT (path, propname, propvalue, auth_uname, auth_pwd, 1, 1, overwrite);\n"
"}\n"
"--src dav_api.sql:3285\n";

static const char *proc129 = 
"create function\n"
"DAV_PROP_SET_INT (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in propvalue any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in overwrite integer := 0,\n"
"in auth_uid integer := null ) returns integer\n"
"{\n"
"declare id, rc, pid integer;\n"
"declare st, det varchar;\n"
"declare resv any;\n"
"declare locked integer;\n"
"declare auto_version varchar;\n"
"\n"
"rc := DAV_PREPARE_PROP_WRITE (path, id, st, propname, auth_uname, auth_pwd, auth_uid, extern, auto_version, check_locks, locked);\n"
"\n"
"if (rc < 0)\n"
"return rc;\n"
"if (isarray (id))\n"
"{\n"
"pid := call (cast (id[0] as varchar) || \'_DAV_PROP_SET\') (id, st, propname, propvalue, overwrite, auth_uid);\n"
"return pid;\n"
"}\n"
"return DAV_PROP_SET_RAW (id, st, propname, propvalue, overwrite, auth_uid, locked, auto_version);\n"
"}\n"
"--src dav_api.sql:3298\n";

static const char *proc130 = 
"create function\n"
"DAV_PROP_SET_RAW (\n"
"inout id integer,\n"
"in st char(0),\n"
"inout propname varchar,\n"
"inout propvalue any,\n"
"in overwrite integer,\n"
"in auth_uid integer,\n"
"in locked int:=0,\n"
"in auto_version varchar:=NULL\n"
") returns integer\n"
"{\n"
"declare pid integer;\n"
"declare resv any;\n"
"declare can_patch_access integer;\n"
"if (58 = propname[0])\n"
"{\n"
"if (\':getlastmodified\' = propname)\n"
"{\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_MOD_TIME = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_MOD_TIME = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':creationdate\' = propname)\n"
"{\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_CR_TIME = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_CR_TIME = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':getcontenttype\' = propname)\n"
"{\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_TYPE = propvalue where RES_ID = id;\n"
"else\n"
"return -10;\n"
"return 0;\n"
"}\n"
"if (auth_uid = http_dav_uid())\n"
"can_patch_access := 2;\n"
"\n"
"\n"
"else\n"
"if (\'R\' = st)\n"
"can_patch_access := coalesce ((select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = id and RES_OWNER = auth_uid), 0);\n"
"else\n"
"can_patch_access := coalesce ((select top 1 1 from WS.WS.SYS_DAV_COL where COL_ID = id and COL_OWNER = auth_uid), 0);\n"
"if (\':virtowneruid\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if (not exists (select top 1 1 from WS.WS.SYS_DAV_USER where U_ID = propvalue))\n"
"propvalue := 0;\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_OWNER = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_OWNER = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtownergid\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if (not exists (select top 1 1 from WS.WS.SYS_DAV_GROUP where G_ID = propvalue))\n"
"propvalue := 0;\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_GROUP = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_GROUP = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtpermissions\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if (regexp_match (DAV_REGEXP_PATTERN_FOR_PERM (), propvalue) is null)\n"
"return -17;\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_PERMS = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_PERMS = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtacl\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_ACL = propvalue where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_ACL = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdet\' = propname)\n"
"{\n"
"if (1 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"return -10;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_DET = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdetmount\' = propname)\n"
"{\n"
"if (1 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"return -10;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_DET = propvalue where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdetmountable\' = propname)\n"
"{\n"
"return -10;\n"
"}\n"
"if (\':virtprivatetags\' = propname)\n"
"{\n"
"if (\'R\' <> st)\n"
"return -14;\n"
"if (auth_uid = http_nobody_uid())\n"
"return -16;\n"
"if (exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid))\n"
"{\n"
"if (not overwrite)\n"
"return -16;\n"
"update WS.WS.SYS_DAV_TAG set DT_TAGS = propvalue where DT_RES_ID = id and DT_U_ID = auth_uid;\n"
"}\n"
"else\n"
"{\n"
"insert into WS.WS.SYS_DAV_TAG (DT_RES_ID, DT_U_ID, DT_FT_ID, DT_TAGS)\n"
"values (id, auth_uid, WS.WS.GETID (\'T\'), propvalue);\n"
"}\n"
"return 0;\n"
"}\n"
"if (\':virtpublictags\' = propname)\n"
"{\n"
"if (\'R\' <> st)\n"
"return -14;\n"
"if (exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid()))\n"
"{\n"
"if (not overwrite)\n"
"return -16;\n"
"update WS.WS.SYS_DAV_TAG set DT_TAGS = propvalue where DT_RES_ID = id and DT_U_ID = http_nobody_uid();\n"
"}\n"
"else\n"
"{\n"
"insert into WS.WS.SYS_DAV_TAG (DT_RES_ID, DT_U_ID, DT_FT_ID, DT_TAGS)\n"
"values (id, http_nobody_uid(), WS.WS.GETID (\'T\'), propvalue);\n"
"}\n"
"return 0;\n"
"}\n"
"return -16;\n"
"}\n"
"\n"
"if ((not overwrite) and exists (select 1 from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = st))\n"
"return -16;\n"
"\n"
"resv := vector (\'creationdate\',\'y\',\'getcontentlength\',\'y\',\'getcontenttype\',\'y\',\'getetag\',\'y\',\'getlastmodified\',\'y\',\'lockdiscovery\',\'y\',\'resourcetype\',\'y\',\'activelock\',\'y\',\'supportedlock\',\'y\');\n"
"\n"
"if (not isstring (propname) or \'y\' = get_keyword (propname, resv, \'n\'))\n"
"return -10;\n"
"\n"
"if (__tag (propvalue) = 193)\n"
"propvalue := serialize (propvalue);\n"
"else if (not isstring (propvalue))\n"
"return -17;\n"
"\n"
"pid := WS.WS.GETID (\'P\');\n"
"\n"
"if ((propname not like \'DAV:%\')\n"
"and (propname not like \'virt:%\')\n"
"and (propname[0] <> 58))\n"
"{\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (id, \'R\', \'DAV:checked-in\', 0)) is not null)\n"
"{\n"
"\n"
"return -38;\n"
"}\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (id, \'R\', \'DAV:checked-out\', 0)) is not null)\n"
"{\n"
"if ((locked and (auto_version = \'DAV:checkout-unlocked-checkin\')) or\n"
"(auto_version = \'DAV:checkout\') or\n"
"(locked and (auto_version = \'DAV:locked-checkout\')))\n"
"{\n"
"declare _res int;\n"
"_res := DAV_CHECKOUT_INT (id, null, null, 0);\n"
"if (_res < 0)\n"
"return _res;\n"
"}\n"
"}\n"
"}\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = propvalue where PROP_NAME = propname\n"
"and PROP_PARENT_ID = id and PROP_TYPE = st;\n"
"if (row_count() = 0)\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_VALUE, PROP_PARENT_ID, PROP_TYPE)\n"
"values (pid, propname, propvalue, id, st);\n"
"}\n"
"return pid;\n"
"}\n"
"--src dav_api.sql:3330\n";

static const char *proc131 = 
" create procedure\n"
"DAV_PROP_REMOVE (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null)\n"
"{\n"
"return DAV_PROP_REMOVE_INT (path, propname, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:3539\n";

static const char *proc132 = 
"create function\n"
"DAV_PROP_REMOVE_INT (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in ignore_if_missing integer := 0,\n"
"in auth_uid integer := null ) returns integer\n"
"{\n"
"declare id, rc, pid integer;\n"
"declare st, det varchar;\n"
"declare resv any;\n"
"declare locked int;\n"
"declare auto_version varchar;\n"
"\n"
"rc := DAV_PREPARE_PROP_WRITE (path, id, st, propname, auth_uname, auth_pwd, auth_uid, extern, auto_version, check_locks, locked);\n"
"\n"
"if (rc < 0)\n"
"return rc;\n"
"if (isarray (id))\n"
"{\n"
"pid := call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\') (id, st, propname, ignore_if_missing, auth_uid);\n"
"return pid;\n"
"}\n"
"return DAV_PROP_REMOVE_RAW (id, st, propname, ignore_if_missing, auth_uid, locked, auto_version);\n"
"}\n"
"--src dav_api.sql:3551\n";

static const char *proc133 = 
"create function\n"
"DAV_PROP_REMOVE_RAW (\n"
"inout id integer,\n"
"in st char(0),\n"
"inout propname varchar,\n"
"in ignore_if_missing integer,\n"
"in auth_uid integer,\n"
"in locked int:=0,\n"
"in auto_version varchar:=NULL\n"
") returns integer\n"
"{\n"
"declare pid integer;\n"
"declare resv any;\n"
"declare can_patch_access integer;\n"
"if (58 = propname[0])\n"
"{\n"
"if (propname in (\':getlastmodified\', \':creationdate\', \':getcontenttype\', \':virtowneruid\', \':virtownergid\', \':virtpermissions\', \':virtdetmountable\'))\n"
"return -10;\n"
"if (auth_uid = http_dav_uid())\n"
"can_patch_access := 2;\n"
"\n"
"\n"
"else\n"
"if (\'R\' = st)\n"
"can_patch_access := coalesce ((select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = id and RES_OWNER = auth_uid), 0);\n"
"else\n"
"can_patch_access := coalesce ((select top 1 1 from WS.WS.SYS_DAV_COL where COL_ID = id and COL_OWNER = auth_uid), 0);\n"
"if (\':virtacl\' = propname)\n"
"{\n"
"if (0 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"update WS.WS.SYS_DAV_RES set RES_ACL = NULL where RES_ID = id;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_ACL = NULL where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdet\' = propname)\n"
"{\n"
"if (1 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"return -10;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_DET = NULL where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtdetmount\' = propname)\n"
"{\n"
"if (1 >= can_patch_access)\n"
"return -13;\n"
"if (\'R\' = st)\n"
"return -10;\n"
"else\n"
"update WS.WS.SYS_DAV_COL set COL_DET = NULL where COL_ID = id;\n"
"return 0;\n"
"}\n"
"if (\':virtprivatetags\' = propname)\n"
"{\n"
"if ((\'R\' <> st) or (auth_uid = http_nobody_uid()) or (not exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid)))\n"
"goto nosuchprop;\n"
"delete from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid;\n"
"return 0;\n"
"}\n"
"if (\':virtpublictags\' = propname)\n"
"{\n"
"if ((\'R\' <> st) or (not exists (select 1 from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid())))\n"
"goto nosuchprop;\n"
"delete from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid();\n"
"return 0;\n"
"}\n"
"return -16;\n"
"}\n"
"\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id\n"
"and PROP_TYPE = st))\n"
"{\n"
"goto nosuchprop;\n"
"}\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = st;\n"
"return 0;\n"
"nosuchprop:\n"
"if (ignore_if_missing)\n"
"return 0;\n"
"else\n"
"return -11;\n"
"}\n"
"--src dav_api.sql:3582\n";

static const char *proc134 = 
" create procedure\n"
"DAV_PROP_GET (\n"
"in path varchar,\n"
"in propname varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null) returns any\n"
"{\n"
"declare st varchar;\n"
"if ((path <> \'\') and (path[length(path)-1] = 47))\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"return DAV_PROP_GET_INT (DAV_SEARCH_ID (path, st), st, propname, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:3673\n";

static const char *proc135 = 
"create procedure\n"
"DAV_PROP_GET_INT (\n"
"in id any,\n"
"in what char(0),\n"
"in propname varchar,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in auth_uid integer := null ) returns any\n"
"{\n"
"declare rc integer;\n"
"declare ret any;\n"
"\n"
"if (propname is null)\n"
"return -11;\n"
"if (not (isstring (propname)))\n"
"propname := cast (propname as varchar);\n"
"if (\'\' = propname)\n"
"return -11;\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, what, \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return -1;\n"
"if (propname[0] = 58)\n"
"{\n"
"declare idx integer;\n"
"idx := get_keyword (propname,\n"
"vector (\n"
"\':getlastmodified\', 3,\n"
"\':creationdate\', 8,\n"
"\':lastaccessed\', 3,\n"
"\':getetag\', -1,\n"
"\':getcontenttype\', 9,\n"
"\':getcontentlength\', 2,\n"
"\':resourcetype\', -1,\n"
"\':virtowneruid\', 7,\n"
"\':virtownergid\', 6,\n"
"\':virtpermissions\', 5,\n"
"\':virtacl\', -1,\n"
"\':virtdet\', -1,\n"
"\':virtdetmount\', -1,\n"
"\':virtdetmountable\', -1,\n"
"\':virtpublictags\', -1,\n"
"\':virtprivatetags\', -1,\n"
"\':virttags\', -1 ) );\n"
"if (idx is null)\n"
"return -11;\n"
"if (idx >= 0)\n"
"{\n"
"declare dirsingle any;\n"
"dirsingle := DAV_DIR_SINGLE_INT (id, what, \'fake\', auth_uname, auth_pwd, auth_uid);\n"
"if (isarray (dirsingle))\n"
"return dirsingle[idx];\n"
"return -1;\n"
"}\n"
"if (\':getetag\' = propname)\n"
"{\n"
"if (\'R\' = what)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"declare dirsingle any;\n"
"declare path varchar;\n"
"path := DAV_SEARCH_PATH (id, \'R\');\n"
"dirsingle := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id, \'R\', path, auth_uid);\n"
"return sprintf (\'%s-%s-%d-%s\', cast (id[1] as varchar), replace (cast (dirsingle[3] as varchar), \' \', \'T\'), dirsingle[2], md5 (path));\n"
"}\n"
"else\n"
"{\n"
"declare name varchar;\n"
"declare col_id integer;\n"
"select RES_NAME, RES_COL into name, col_id from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"return WS.WS.ETAG (name, col_id);\n"
"}\n"
"}\n"
"else\n"
"return null;\n"
"}\n"
"if (\':resourcetype\' = propname)\n"
"{\n"
"if (what = \'C\')\n"
"return xtree_doc (\'<D:collection/>\');\n"
"else\n"
"return null;\n"
"}\n"
"if (\':virtacl\' = propname)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"return coalesce ((select COL_ACL from WS.WS.SYS_DAV_COL where COL_ID = id[1]));\n"
"}\n"
"else\n"
"{\n"
"if (\'R\' = what)\n"
"return coalesce ((select RES_ACL from WS.WS.SYS_DAV_RES where RES_ID = id));\n"
"else\n"
"return coalesce ((select COL_ACL from WS.WS.SYS_DAV_COL where COL_ID = id));\n"
"}\n"
"}\n"
"if (\':virtdet\' = propname)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return coalesce (DAV_HIDE_ERROR (ret), id[0]);\n"
"}\n"
"else\n"
"{\n"
"if (\'R\' = what)\n"
"return null;\n"
"else\n"
"return coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = id));\n"
"}\n"
"}\n"
"if (\':virtdetmount\' = propname)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return DAV_HIDE_ERROR (ret);\n"
"}\n"
"else\n"
"{\n"
"if (\'R\' = what)\n"
"return null;\n"
"else\n"
"return coalesce ((select COL_DET from WS.WS.SYS_DAV_COL where COL_ID = id));\n"
"}\n"
"}\n"
"if (\':virtdetmountable\' = propname)\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return DAV_HIDE_ERROR (ret);\n"
"}\n"
"else\n"
"{\n"
"if (\'R\' = what)\n"
"return null;\n"
"else\n"
"return \'T\';\n"
"}\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return ret;\n"
"}\n"
"if (\':virtprivatetags\' = propname)\n"
"{\n"
"if ((\'R\' <> what) or (auth_uid = http_nobody_uid()))\n"
"return null;\n"
"return coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid));\n"
"}\n"
"if (\':virtpublictags\' = propname)\n"
"{\n"
"if (\'R\' <> what)\n"
"return null;\n"
"return coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid()));\n"
"}\n"
"if (\':virttags\' = propname)\n"
"{\n"
"if (\'R\' <> what)\n"
"return null;\n"
"if (auth_uid = http_nobody_uid())\n"
"{\n"
"return coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid()));\n"
"}\n"
"else\n"
"{\n"
"declare pub, priv varchar;\n"
"pub := coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = http_nobody_uid()), \'\');\n"
"priv := coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = id and DT_U_ID = auth_uid), \'\');\n"
"if (pub = \'\')\n"
"return priv;\n"
"if (priv = \'\')\n"
"return pub;\n"
"return pub || \', \' || priv;\n"
"}\n"
"}\n"
"}\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"return ret;\n"
"}\n"
"if (id < 0)\n"
"{\n"
"return id;\n"
"}\n"
"whenever not found goto no_prop;\n"
"select blob_to_string (PROP_VALUE) into ret from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = what;\n"
"return ret;\n"
"\n"
"no_prop:\n"
"return -11;\n"
"}\n"
"--src dav_api.sql:3690\n";

static const char *proc136 = 
" create procedure\n"
"DAV_PROP_LIST (\n"
"in path varchar,\n"
"in propmask varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null)\n"
"{\n"
"declare st varchar;\n"
"if ((path <> \'\') and (path[length(path)-1] = 47))\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"return DAV_PROP_LIST_INT (DAV_SEARCH_ID (path, st), st, propmask, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:3896\n";

static const char *proc137 = 
"create procedure\n"
"DAV_PROP_LIST_INT (\n"
"in id any,\n"
"in what char(0),\n"
"in propmask varchar,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null)\n"
"{\n"
"declare auth_uid, rc integer;\n"
"declare ret any;\n"
"\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, what, \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"\n"
"\n"
"\n"
"if (isarray (id))\n"
"{\n"
"ret := call (cast (id[0] as varchar) || \'_DAV_PROP_LIST\') (id, what, propmask, auth_uid);\n"
"return ret;\n"
"}\n"
"if (id < 0)\n"
"{\n"
"return id;\n"
"}\n"
"ret := vector ();\n"
"for select PROP_NAME, PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME like propmask and PROP_PARENT_ID = id and PROP_TYPE = what do {\n"
"ret := vector_concat (ret, vector (vector (PROP_NAME, blob_to_string (PROP_VALUE))));\n"
"}\n"
"return ret;\n"
"}\n"
"--src dav_api.sql:3912\n";

static const char *proc138 = 
"create procedure\n"
"DAV_MAKE_DIR (in path any, in own integer, in grp integer, in perms varchar)\n"
"{\n"
"declare pat any;\n"
"declare col, len, inx, t_col integer;\n"
"\n"
"pat := split_and_decode (path, 0, \'\\0\\0/\');\n"
"\n"
"if (length (pat) < 3)\n"
"return NULL;\n"
"\n"
"if (pat[1] <> \'DAV\' or pat[0] <> \'\')\n"
"signal (\'22023\', \'Not valid path string\');\n"
"\n"
"len := length (pat) - 1;\n"
"inx := 2;\n"
"t_col := 1;\n"
"whenever not found goto nf;\n"
"while (inx < len)\n"
"{\n"
"select COL_ID into col from WS.WS.SYS_DAV_COL where COL_PARENT = t_col and COL_NAME = pat[inx];\n"
"t_col := col;\n"
"inx := inx + 1;\n"
"}\n"
"nf:\n"
"while (inx < len)\n"
"{\n"
"col := WS.WS.GETID (\'C\');\n"
"insert into WS.WS.SYS_DAV_COL\n"
"(COL_ID, COL_NAME, COL_PARENT, COL_CR_TIME, COL_MOD_TIME, COL_OWNER, COL_GROUP, COL_PERMS)\n"
"values (col, pat[inx], t_col, now (), now (), own, grp, perms);\n"
"inx := inx + 1;\n"
"t_col := col;\n"
"}\n"
"return col;\n"
"}\n"
"--src dav_api.sql:3951\n";

static const char *proc139 = 
"create procedure DAV_CHECK_PERM (in perm varchar, in req varchar, in oid integer,\n"
"in ogid integer, in pgid integer, in puid integer)\n"
"{\n"
"declare up, gp, pp varchar;\n"
"\n"
"pp := substring (perm, 7, 3);\n"
"if (pp like req)\n"
"return 1;\n"
"up := substring (perm, 1, 3);\n"
"if (up like req and ((oid = puid) or (oid = 2)))\n"
"return 1;\n"
"gp := substring (perm, 4, 3);\n"
"if (gp like req and ((ogid = pgid) or (exists (select top 1 1 from WS.WS.SYS_DAV_USER_GROUP where UG_UID = oid and UG_GID = pgid))))\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:3989\n";

static const char *proc140 = 
" create procedure DAV_CHECK_USER (in uname varchar, in pwd any := null)\n"
"{\n"
"declare rc int;\n"
"declare pwd1 any;\n"
"rc := 0;\n"
"if (pwd is null)\n"
"{\n"
"rc := coalesce ((select 1 from WS.WS.SYS_DAV_USER where U_NAME = uname), 0);\n"
"}\n"
"else\n"
"{\n"
"whenever not found goto nf;\n"
"select U_PWD into pwd1 from WS.WS.SYS_DAV_USER where U_NAME = uname with (prefetch 1);\n"
"if ((pwd1[0] = 0 and pwd_magic_calc (uname, pwd) = pwd1) or (pwd1[0] <> 0 and pwd1 = pwd))\n"
"rc := 1;\n"
"nf:;\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:4010\n";

static const char *proc141 = 
" create procedure\n"
"DAV_RES_CONTENT (\n"
"in path varchar,\n"
"inout content any,\n"
"out type varchar,\n"
"in auth_uname varchar := null, in auth_pwd varchar := null)\n"
"{\n"
"return DAV_RES_CONTENT_INT (DAV_SEARCH_ID (path, \'R\'), content, type, 0, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:4033\n";

static const char *proc142 = 
" create procedure\n"
"DAV_RES_CONTENT_STRSES (\n"
"in path varchar,\n"
"inout content any,\n"
"out type varchar,\n"
"in auth_uname varchar := null, in auth_pwd varchar := null)\n"
"{\n"
"return DAV_RES_CONTENT_INT (DAV_SEARCH_ID (path, \'R\'), content, type, 1, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:4046\n";

static const char *proc143 = 
"create procedure\n"
"DAV_RES_CONTENT_INT (\n"
"in id any,\n"
"inout content any,\n"
"out type varchar,\n"
"in content_mode integer,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null, in auth_pwd varchar := null )\n"
"{\n"
"declare auth_uid, rc integer;\n"
"declare pperms, name varchar;\n"
"declare par, cont any;\n"
"declare det varchar;\n"
"declare detcol_id integer;\n"
"declare detcol_path, unreached_path any;\n"
"\n"
"if (extern)\n"
"{\n"
"auth_uid := DAV_AUTHENTICATE (id, \'R\', \'1__\', auth_uname, auth_pwd);\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"}\n"
"else\n"
"auth_uid := null;\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return id;\n"
"\n"
"\n"
"if (isarray (id))\n"
"{\n"
"return call (cast (id[0] as varchar) || \'_DAV_RES_CONTENT\') (id, content, type, content_mode);\n"
"}\n"
"rc := id;\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"select RES_CONTENT, RES_TYPE into content, type from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"else if (content_mode = 1)\n"
"{\n"
"select RES_CONTENT, RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"\n"
"if (cont is not null)\n"
"http (cont, content);\n"
"}\n"
"else if (content_mode = 3)\n"
"{\n"
"select http (RES_CONTENT), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"\n"
"}\n"
"return rc;\n"
"}\n"
"--src dav_api.sql:4057\n";

static const char *proc144 = 
"create function DAV_COL_IS_ANCESTOR_OF (in a_id integer, in d_id integer) returns integer\n"
"{\n"
"declare p_id integer;\n"
"if (a_id = 0)\n"
"return 1;\n"
"again:\n"
"\n"
"select COL_PARENT into p_id from WS.WS.SYS_DAV_COL where COL_ID = d_id and COL_PARENT < COL_ID;\n"
"if (p_id = a_id)\n"
"return 1;\n"
"if (p_id = 0)\n"
"return 0;\n"
"d_id := p_id;\n"
"goto again;\n"
"}\n"
"--src dav_api.sql:4108\n";

static const char *proc145 = 
"create function DAV_COL_PATH_BOUNDARY (in path varchar) returns varchar\n"
"{\n"
"declare res varchar;\n"
"declare len integer;\n"
"res := path;\n"
"len := length (res);\n"
"if ((len = 0) or (res[len-1] <> 47))\n"
"signal (\'.....\', sprintf (\'Bad path in DAV_COL_PATH_BOUNDARY: %s\', path));\n"
"res := res || \'\\377\\377\\377\\377\';\n"
"return res;\n"
"}\n"
"--src dav_api.sql:4125\n";

static const char *trig7 = 
"create trigger SYS_DAV_RES_WAC_I after insert on WS.WS.SYS_DAV_RES order 100 referencing new as N\n"
"{\n"
" ;\n"
"}\n"
"--src dav_api.sql:4140\n";

static const char *trig8 = 
"create trigger SYS_DAV_RES_WAC_U after update on WS.WS.SYS_DAV_RES order 100 referencing new as N, old as O\n"
"{\n"
"declare aciContent, oldPath, newPath any;\n"
"\n"
"if ((O.RES_NAME = N.RES_NAME) and (O.RES_COL = N.RES_COL))\n"
"return;\n"
"\n"
"oldPath := WS.WS.COL_PATH (O.RES_COL) || O.RES_NAME;\n"
"newPath := WS.WS.COL_PATH (N.RES_COL) || N.RES_NAME;\n"
"aciContent := (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_PARENT_ID = N.RES_ID and PROP_TYPE = \'R\' and PROP_NAME = \'virt:aci_meta_n3\');\n"
"WS.WS.WAC_DELETE (oldPath);\n"
"WS.WS.WAC_INSERT (newPath, aciContent);\n"
"}\n"
"--src dav_api.sql:4146\n";

static const char *trig9 = 
"create trigger SYS_DAV_RES_WAC_D after delete on WS.WS.SYS_DAV_RES order 100 referencing old as O\n"
"{\n"
"WS.WS.WAC_DELETE (O.RES_FULL_PATH);\n"
"}\n"
"--src dav_api.sql:4161\n";

static const char *trig10 = 
"create trigger SYS_DAV_PROP_WAC_I after insert on WS.WS.SYS_DAV_PROP order 100 referencing new as N\n"
"{\n"
"if ((N.PROP_TYPE <> \'R\') or (N.PROP_NAME <> \'virt:aci_meta_n3\'))\n"
"return;\n"
"\n"
"declare resPath any;\n"
"resPath := (select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_ID = N.PROP_PARENT_ID);\n"
"WS.WS.WAC_INSERT (resPath, N.PROP_VALUE);\n"
"}\n"
"--src dav_api.sql:4167\n";

static const char *trig11 = 
"create trigger SYS_DAV_PROP_WAC_U after update on WS.WS.SYS_DAV_PROP order 100 referencing new as N, old as O\n"
"{\n"
"if ((N.PROP_TYPE <> \'R\') or (N.PROP_NAME <> \'virt:aci_meta_n3\'))\n"
"return;\n"
"\n"
"declare resPath any;\n"
"resPath := (select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_ID = N.PROP_PARENT_ID);\n"
"WS.WS.WAC_DELETE (resPath);\n"
"WS.WS.WAC_INSERT (resPath, N.PROP_VALUE);\n"
"}\n"
"--src dav_api.sql:4178\n";

static const char *trig12 = 
"create trigger SYS_DAV_PROP_WAC_D after delete on WS.WS.SYS_DAV_PROP order 100 referencing old as O\n"
"{\n"
"if ((O.PROP_TYPE <> \'R\') or (O.PROP_NAME <> \'virt:aci_meta_n3\'))\n"
"return;\n"
"\n"
"declare resPath any;\n"
"resPath := (select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_ID = O.PROP_PARENT_ID);\n"
"WS.WS.WAC_DELETE (resPath);\n"
"}\n"
"--src dav_api.sql:4190\n";

static const char *proc146 = 
"create procedure WS.WS.WAC_INSERT (in resPath varchar, in aciContent any)\n"
"{\n"
"declare graph varchar;\n"
"\n"
"if (length (aciContent) = 0 or __proc_exists (fix_identifier_case (\'sioc.DBA.dav_res_iri\')) is null)\n"
"return;\n"
"\n"
"graph := SIOC.DBA.dav_res_iri (resPath);\n"
"{\n"
"declare continue handler for SQLSTATE \'*\'\n"
"{\n"
"\n"
"return;\n"
"};\n"
"aciContent := cast (blob_to_string (aciContent) as varchar);\n"
"\n"
"DB.DBA.TTLP (aciContent, graph, graph);\n"
"commit work;\n"
"\n"
"}\n"
"}\n"
"--src dav_api.sql:4201\n";

static const char *proc147 = 
"create procedure WS.WS.WAC_DELETE (in resPath varchar)\n"
"{\n"
"declare graph, st, msg varchar;\n"
"\n"
"if (__proc_exists (fix_identifier_case (\'sioc.DBA.dav_res_iri\')) is null)\n"
"return;\n"
"\n"
"graph := SIOC.DBA.dav_res_iri (resPath);\n"
"exec (sprintf (\'sparql clear graph <%S>\', graph), st, msg);\n"
"commit work;\n"
"\n"
"}\n"
"--src dav_api.sql:4224\n";

static const char *trig13 = 
"create trigger SYS_DAV_COL_ACL_I after insert on WS.WS.SYS_DAV_COL order 10 referencing new as NC\n"
"{\n"
"declare\n"
"N,\n"
"colID,\n"
"parentID integer;\n"
"declare\n"
"aAcl,\n"
"aParentAcl any;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE(NC.COL_ACL, \'01\', 0);\n"
"N := 0;\n"
"while (N < length(aAcl))\n"
"{\n"
"insert replacing\n"
"WS.WS.SYS_DAV_ACL_INVERSE(AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
"values(either(equ(aAcl[N][1],0), \'R\', \'G\'), NC.COL_ID, \'C\', aAcl[N][0]);\n"
"\n"
"N := N + 1;\n"
"}\n"
"\n"
"colID := NC.COL_ID;\n"
"parentID := NC.COL_PARENT;\n"
"aAcl := WS.WS.ACL_PARSE(NC.COL_ACL, \'012\', 0);\n"
"aParentAcl := (select WS.WS.ACL_PARSE(COL_ACL, \'123\', 0) from WS.WS.SYS_DAV_COL c where c.COL_ID = parentID);\n"
"if (not isnull(aParentAcl))\n"
"{\n"
"set triggers off;\n"
"update\n"
"WS.WS.SYS_DAV_COL c\n"
"set\n"
"COL_ACL = WS.WS.ACL_COMPOSE(vector_concat(aAcl, WS.WS.ACL_MAKE_INHERITED(aParentAcl)))\n"
"where\n"
"c.COL_ID = colID;\n"
"}\n"
"\n"
"}\n"
"--src dav_api.sql:4239\n";

static const char *proc148 = 
"create function WS.WS.ACL_CONTAINS_GRANTEE_AND_FLAG (inout acl any, in grantee integer, in flag char(1)) returns integer\n"
"{\n"
"declare N integer;\n"
"N := length (acl);\n"
"while (N > 0)\n"
"{\n"
"N := N - 1;\n"
"if ((grantee = acl[N][0]) and (flag = either(equ(acl[N][1],0), \'R\', \'G\')))\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:4278\n";

static const char *trig14 = 
"create trigger SYS_DAV_COL_ACL_U after update on WS.WS.SYS_DAV_COL order 10 referencing new as NC\n"
"{\n"
"declare\n"
"N,\n"
"aiGrantee integer;\n"
"declare\n"
"aiFlag varchar;\n"
"declare\n"
"aAcl any;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE(NC.COL_ACL, \'01\', 0);\n"
"\n"
"delete from WS.WS.SYS_DAV_ACL_INVERSE\n"
"where AI_PARENT_ID = NC.COL_ID\n"
"and AI_PARENT_TYPE = \'C\'\n"
"and not WS.WS.ACL_CONTAINS_GRANTEE_AND_FLAG (aAcl, AI_GRANTEE_ID, AI_FLAG);\n"
"\n"
"N := 0;\n"
"while (N < length(aAcl))\n"
"{\n"
"insert replacing\n"
"WS.WS.SYS_DAV_ACL_INVERSE(AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
"values(either(equ(aAcl[N][1],0), \'R\', \'G\'), NC.COL_ID, \'C\', aAcl[N][0]);\n"
"N := N + 1;\n"
"}\n"
"\n"
"set triggers off;\n"
"WS.WS.ACL_UPDATE (COL_ID, WS.WS.ACL_PARSE(NC.COL_ACL, \'123\', 0));\n"
"\n"
"}\n"
"--src dav_api.sql:4292\n";

static const char *trig15 = 
"create trigger SYS_DAV_COL_ACL_D after delete on WS.WS.SYS_DAV_COL order 10\n"
"{\n"
"\n"
"delete from WS.WS.SYS_DAV_ACL_INVERSE where AI_PARENT_TYPE = \'C\' and AI_PARENT_ID = COL_ID;\n"
"\n"
"}\n"
"--src dav_api.sql:4324\n";

static const char *trig16 = 
"create trigger SYS_DAV_RES_ACL_I after insert on WS.WS.SYS_DAV_RES order 10 referencing new as NR\n"
"{\n"
"declare\n"
"N,\n"
"resID integer;\n"
"declare\n"
"aAcl any;\n"
"declare\n"
"aParentAcl varbinary;\n"
"\n"
"\n"
"aAcl := WS.WS.ACL_PARSE(NR.RES_ACL, \'0\', 0);\n"
"N := 0;\n"
"while (N < length(aAcl))\n"
"{\n"
"insert replacing\n"
"WS.WS.SYS_DAV_ACL_INVERSE(AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
"values(either(equ(aAcl[N][1],0), \'R\', \'G\'), NR.RES_ID, \'R\', aAcl[N][0]);\n"
"\n"
"N := N + 1;\n"
"}\n"
"\n"
"resID := NR.RES_ID;\n"
"aParentAcl := (select WS.WS.ACL_PARSE(COL_ACL, \'123\', 0) from WS.WS.SYS_DAV_COL where COL_ID = NR.RES_COL);\n"
"if (not isnull(aParentAcl))\n"
"{\n"
"set triggers off;\n"
"update\n"
"WS.WS.SYS_DAV_RES\n"
"set\n"
"RES_ACL = WS.WS.ACL_COMPOSE(vector_concat(aAcl, WS.WS.ACL_MAKE_INHERITED(aParentAcl)))\n"
"where\n"
"RES_ID = resID;\n"
"}\n"
"\n"
"}\n"
"--src dav_api.sql:4335\n";

static const char *trig17 = 
"create trigger SYS_DAV_RES_ACL_U after update on WS.WS.SYS_DAV_RES order 10 referencing new as NR\n"
"{\n"
"declare\n"
"N,\n"
"aiGrantee integer;\n"
"declare\n"
"aiFlag varchar;\n"
"declare\n"
"aAcl any;\n"
"\n"
"\n"
"aAcl := WS.WS.ACL_PARSE(NR.RES_ACL, \'0\', 0);\n"
"\n"
"delete from WS.WS.SYS_DAV_ACL_INVERSE\n"
"where\n"
"AI_PARENT_ID = NR.RES_ID\n"
"and AI_PARENT_TYPE = \'R\'\n"
"and not WS.WS.ACL_CONTAINS_GRANTEE_AND_FLAG (aAcl, AI_GRANTEE_ID, AI_FLAG);\n"
"\n"
"N := 0;\n"
"while (N < length(aAcl))\n"
"{\n"
"insert replacing\n"
"WS.WS.SYS_DAV_ACL_INVERSE(AI_FLAG, AI_PARENT_ID, AI_PARENT_TYPE, AI_GRANTEE_ID)\n"
"values(either(equ(aAcl[N][1],0), \'R\', \'G\'), NR.RES_ID, \'R\', aAcl[N][0]);\n"
"\n"
"N := N + 1;\n"
"}\n"
"\n"
"}\n"
"--src dav_api.sql:4373\n";

static const char *trig18 = 
"create trigger SYS_DAV_RES_ACL_D after delete on WS.WS.SYS_DAV_RES order 10\n"
"{\n"
"\n"
"delete from WS.WS.SYS_DAV_ACL_INVERSE where AI_PARENT_TYPE = \'R\' and AI_PARENT_ID = RES_ID;\n"
"\n"
"}\n"
"--src dav_api.sql:4405\n";

static const char *proc149 = 
"create procedure WS.WS.ACL_UPDATE (in pId integer, in pParentAcl any)\n"
"{\n"
"declare\n"
"aNew any;\n"
"\n"
"WS.WS.ACL_MAKE_INHERITED(pParentAcl);\n"
"\n"
"for select RES_ID as iResID, WS.WS.ACL_PARSE(RES_ACL, \'0\', 0) as aAcl from WS.WS.SYS_DAV_RES where RES_COL = pId do\n"
"{\n"
"update\n"
"WS.WS.SYS_DAV_RES\n"
"set\n"
"RES_ACL = WS.WS.ACL_COMPOSE(vector_concat(aAcl, pParentAcl))\n"
"where\n"
"RES_ID = iResID;\n"
"}\n"
"\n"
"for select COL_ID as iColID, WS.WS.ACL_COMPOSE(vector_concat(WS.WS.ACL_PARSE(COL_ACL, \'012\', 0), pParentAcl)) as aAcl from WS.WS.SYS_DAV_COL where COL_PARENT = pId do\n"
"{\n"
"update\n"
"WS.WS.SYS_DAV_COL\n"
"set\n"
"COL_ACL = aAcl\n"
"where\n"
"COL_ID = iColID;\n"
"WS.WS.ACL_UPDATE(iColID, WS.WS.ACL_PARSE(aAcl, \'123\', 0));\n"
"}\n"
"}\n"
"--src dav_api.sql:4413\n";

static const char *proc150 = 
"create procedure WS.WS.ACL_MAKE_INHERITED (inout pAcl any)\n"
"{\n"
"declare\n"
"aTmp any;\n"
"declare\n"
"N integer;\n"
"\n"
"N := 0;\n"
"while (N < length(pAcl))\n"
"{\n"
"aTmp := pAcl[N];\n"
"aset(aTmp, 2, 3);\n"
"aset(pAcl, N, aTmp);\n"
"N := N + 1;\n"
"}\n"
"return pAcl;\n"
"}\n"
"--src dav_api.sql:4443\n";

static const char *proc151 = 
"create procedure WS.WS.ACL_DBG(in vb varbinary) returns varchar\n"
"{\n"
"declare\n"
"N integer;\n"
"declare\n"
"aResult varchar;\n"
"\n"
"aResult := \'\';\n"
"vb := cast(vb as varchar);\n"
"\n"
"N := 0;\n"
"while (N < length(vb))\n"
"{\n"
"aResult := concat(aResult, cast(vb[N] as varchar), \', \');\n"
"N := N + 1;\n"
"}\n"
"return aResult;\n"
"}\n"
"--src dav_api.sql:4463\n";

static const char *proc152 = 
"create procedure WS.WS.ACL_SERIALIZE_INT(in I integer) returns varbinary\n"
"{\n"
"declare\n"
"N integer;\n"
"declare\n"
"aResult varchar;\n"
"\n"
"aResult:=repeat(\'\\0\',4);\n"
"\n"
"N := bit_shift(I,-24);\n"
"if(N)\n"
"aset(aResult, 0, N);\n"
"\n"
"N := bit_shift(bit_shift(I, 8),-24);\n"
"if(N)\n"
"aset(aResult,1,N);\n"
"\n"
"N := bit_shift(bit_shift(I,16),-24);\n"
"if(N)\n"
"aset(aResult,2,N);\n"
"\n"
"N := bit_shift(bit_shift(I, 24),-24);\n"
"if(N)\n"
"aset(aResult,3,N);\n"
"\n"
"return cast(aResult as varbinary);\n"
"}\n"
"--src dav_api.sql:4485\n";

static const char *proc153 = 
"create procedure WS.WS.ACL_DESERIALIZE_INT(in vb varbinary) returns integer\n"
"{\n"
"declare\n"
"vc varchar;\n"
"\n"
"vc := cast(vb as varchar);\n"
"\n"
"return bit_or(bit_or(bit_or(bit_shift(aref(vc, 0), 24), bit_shift(aref(vc, 1), 16)), bit_shift(aref(vc, 2), 8)), aref(vc, 3));\n"
"}\n"
"--src dav_api.sql:4516\n";

static const char *proc154 = 
"create procedure WS.WS.ACL_GET_ACLLENGTH(in acl varbinary) returns integer\n"
"{\n"
"return WS.WS.ACL_DESERIALIZE_INT(cast(substring(cast(acl as varchar), 1, 4) as varbinary));\n"
"}\n"
"--src dav_api.sql:4529\n";

static const char *proc155 = 
"create procedure WS.WS.ACL_GET_ACESIZE(in acl varbinary) returns integer\n"
"{\n"
"return WS.WS.ACL_DESERIALIZE_INT(cast(substring(cast(acl as varchar), 5, 4) as varbinary));\n"
"}\n"
"--src dav_api.sql:4537\n";

static const char *proc156 = 
"create procedure WS.WS.ACL_CREATE() returns varbinary\n"
"{\n"
"return cast(concat(cast(WS.WS.ACL_SERIALIZE_INT(8) as varchar),\n"
"cast(WS.WS.ACL_SERIALIZE_INT(0) as varchar)) as varbinary);\n"
"}\n"
"--src dav_api.sql:4548\n";

static const char *proc157 = 
"create procedure WS.WS.ACL_IS_VALID (in acl varbinary) returns integer\n"
"{\n"
"declare\n"
"iAclLength,\n"
"iAceSize integer;\n"
"\n"
"\n"
"if (internal_type_name(internal_type(acl)) <> \'VARBINARY\')\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"iAclLength := WS.WS.ACL_GET_ACLLENGTH(acl);\n"
"if (iAclLength <> length(acl))\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"iAceSize := WS.WS.ACL_GET_ACESIZE(acl);\n"
"if ((iAceSize*8 + 8) <> length(acl))\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"\n"
"return 1;\n"
"}\n"
"--src dav_api.sql:4560\n";

static const char *proc158 = 
"create procedure WS.WS.ACL_ADD_ENTRY(inout acl varbinary, in uid integer, in bitmask integer, in is_grant integer, in inheritance integer := 0) returns varbinary\n"
"{\n"
"declare\n"
"N,\n"
"bFound integer;\n"
"declare\n"
"aAcl any;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE(acl);\n"
"\n"
"bFound := 0;\n"
"N := 0;\n"
"while (N < length(aAcl))\n"
"{\n"
"if ((aAcl[N][0] = uid) and (aAcl[N][2] = inheritance))\n"
"{\n"
"if (aAcl[N][1] = is_grant)\n"
"{\n"
"aset(aAcl, N, vector(aAcl[N][0], aAcl[N][1], aAcl[N][2], bitmask));\n"
"bFound := 1;\n"
"}\n"
"else\n"
"{\n"
"aset(aAcl, N, vector(aAcl[N][0], aAcl[N][1], aAcl[N][2], bit_and(aAcl[N][3], bit_not(bitmask))));\n"
"}\n"
"}\n"
"N := N + 1;\n"
"};\n"
"\n"
"if (not bFound)\n"
"aAcl := vector_concat(aAcl, vector(vector(uid, is_grant, inheritance, bitmask)));\n"
"\n"
"acl := WS.WS.ACL_COMPOSE(aAcl);\n"
"\n"
"return acl;\n"
"}\n"
"--src dav_api.sql:4597\n";

static const char *proc159 = 
"create procedure WS.WS.ACL_REMOVE_ENTRY(inout acl varbinary, in uid integer, in bitmask integer, in inheritance integer := 0) returns varbinary\n"
"{\n"
"declare\n"
"N integer;\n"
"declare\n"
"aAcl any;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE(acl);\n"
"\n"
"N := 0;\n"
"while (N < length(aAcl))\n"
"{\n"
"if ((aAcl[N][0] = uid) and (aAcl[N][2] = inheritance))\n"
"{\n"
"if (aAcl[N][1])\n"
"{\n"
"aset(aAcl, N, vector(aAcl[N][0], aAcl[N][1], aAcl[N][2], bit_and(aAcl[N][3], bit_not(bitmask))));\n"
"}\n"
"else\n"
"{\n"
"aset(aAcl, N, vector(aAcl[N][0], aAcl[N][1], aAcl[N][2], bit_and(aAcl[N][3], bitmask)));\n"
"}\n"
"}\n"
"N := N + 1;\n"
"}\n"
"acl := WS.WS.ACL_COMPOSE(aAcl);\n"
"\n"
"return acl;\n"
"}\n"
"--src dav_api.sql:4642\n";

static const char *proc160 = 
"create procedure WS.WS.ACL_IS_GRANTED(in acl varbinary, in uid integer, in bitmask integer) returns integer\n"
"{\n"
"declare\n"
"N, lenAcl integer;\n"
"declare\n"
"aAcl any;\n"
"declare ids any;\n"
"declare\n"
"or_acc integer;\n"
"\n"
"if (isnull(acl))\n"
"return 0;\n"
"\n"
"aAcl := WS.WS.ACL_PARSE(acl);\n"
"if (length(aAcl) = 0)\n"
"return 0;\n"
"ids := (select vector_concat (vector (uid), VECTOR_AGG (GI_SUB)) from DB.DBA.SYS_ROLE_GRANTS where GI_SUPER = uid);\n"
"\n"
"or_acc := 0;\n"
"N := 0;\n"
"lenAcl := length(aAcl);\n"
"for (N := 0; N < lenAcl; N := N + 1)\n"
"{\n"
"if (position (aAcl[N][0], ids))\n"
"{\n"
"declare anded integer;\n"
"anded := bit_and (aAcl[N][3], bitmask);\n"
"if (anded <> 0)\n"
"{\n"
"if (aAcl[N][1])\n"
"{\n"
"or_acc := bit_or (or_acc, anded);\n"
"}\n"
"else\n"
"return 0;\n"
"}\n"
"}\n"
"}\n"
"if (or_acc = bitmask)\n"
"return or_acc;\n"
"return 0;\n"
"}\n"
"--src dav_api.sql:4678\n";

static const char *proc161 = 
"create procedure WS.WS.ACL_SET_OWNER(inout acl varbinary, in uid integer)\n"
"{\n"
"return;\n"
"}\n"
"--src dav_api.sql:4727\n";

static const char *proc162 = 
"create procedure WS.WS.ACL_OWNER(in acl varbinary) returns integer\n"
"{\n"
"return;\n"
"}\n"
"--src dav_api.sql:4738\n";

static const char *proc163 = 
"create procedure WS.WS.ACL_PARSE(in acl varbinary, in inheritance varchar := \'0123\', in error integer := 1) returns any\n"
"{\n"
"declare\n"
"sAcl varchar;\n"
"declare\n"
"N,\n"
"I,\n"
"T,\n"
"iAceSize integer;\n"
"declare\n"
"aAcl any;\n"
"\n"
"if (acl is null)\n"
"return vector ();\n"
"if (internal_type_name(internal_type(acl)) = \'BLOB_HANDLE\')\n"
"acl := cast(blob_to_string(acl) as varbinary);\n"
"else if (internal_type_name(internal_type(acl)) = \'VARCHAR\')\n"
"acl := cast (acl as varbinary);\n"
"\n"
"if (not WS.WS.ACL_IS_VALID (acl))\n"
"{\n"
"if (error)\n"
"signal(\'ACL01\', \'Bad ACL object\');\n"
"return vector ();\n"
"}\n"
"\n"
"iAceSize := WS.WS.ACL_GET_ACESIZE(acl);\n"
"sAcl := cast(acl as varchar);\n"
"\n"
"aAcl := vector ();\n"
"N := 1;\n"
"while (N <= iAceSize)\n"
"{\n"
"T := WS.WS.ACL_DESERIALIZE_INT(cast (substring(sAcl, 8*N+5, 4) as varbinary));\n"
"I := abs(bit_and(bit_shift(T, -29), 3));\n"
"if (not isnull(strchr(inheritance, cast(I as varchar))))\n"
"aAcl := vector_concat(aAcl,\n"
"vector(vector(WS.WS.ACL_DESERIALIZE_INT(cast (substring(sAcl, 8*N+1, 4) as varbinary)),\n"
"abs(bit_shift(T, -31)),\n"
"I,\n"
"abs(bit_and(T, 536870911)))));\n"
"N := N + 1;\n"
"}\n"
"\n"
"return aAcl;\n"
"}\n"
"--src dav_api.sql:4749\n";

static const char *proc164 = 
"create procedure WS.WS.ACL_COMPOSE(in aAcl vector) returns varbinary\n"
"{\n"
"declare sAcl varchar;\n"
"declare bAcl varbinary;\n"
"declare N, I, J integer;\n"
"\n"
"sAcl := \'\';\n"
"I := 1;\n"
"while (I < 4)\n"
"{\n"
"J := 0;\n"
"while (J < 2)\n"
"{\n"
"N := 0;\n"
"while (N < length(aAcl))\n"
"{\n"
"if ((aAcl[N][1]=J) and ((aAcl[N][2]=I) or ((aAcl[N][2]=0) and (I=1))) and aAcl[N][3])\n"
"sAcl := concat(sAcl,\n"
"cast(WS.WS.ACL_SERIALIZE_INT(aAcl[N][0]) as varchar),\n"
"cast(WS.WS.ACL_SERIALIZE_INT(bit_shift(aAcl[N][1],31)+bit_shift(aAcl[N][2],29)+aAcl[N][3]) as varchar));\n"
"N := N + 1;\n"
"}\n"
"J := J + 1;\n"
"}\n"
"I := I + 1;\n"
"}\n"
"\n"
"bAcl := cast(concat(cast(WS.WS.ACL_SERIALIZE_INT(length(sAcl)+8) as varchar),\n"
"cast(WS.WS.ACL_SERIALIZE_INT(length(sAcl)/8) as varchar),\n"
"sAcl) as varbinary);\n"
"\n"
"return bAcl;\n"
"}\n"
"--src dav_api.sql:4802\n";

static const char *proc165 = 
"create function DAV_CAST_STRING_TO_INTEGER (in val varchar) returns integer\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as integer);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:4841\n";

static const char *proc166 = 
"create function DAV_CAST_STRING_TO_DATETIME (in val varchar) returns datetime\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as datetime);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:4851\n";

static const char *proc167 = 
"create function DAV_CAST_TEXT_TO_VARCHAR (in val varchar) returns varchar\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as varchar);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:4861\n";

static const char *proc168 = 
"create function DAV_CAST_TEXT_TO_INTEGER (in val varchar) returns integer\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as integer);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:4871\n";

static const char *proc169 = 
"create function DAV_CAST_TEXT_TO_DATETIME (in val varchar) returns datetime\n"
"{\n"
"if (val is null) return null;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (val as datetime);\n"
"ret_null:\n"
"return null;\n"
"}\n"
"--src dav_api.sql:4881\n";

static const char *proc170 = 
"create function DAV_FC_CONST_AS_SQL (inout val any)\n"
"{\n"
"if (193 = __tag (val))\n"
"{\n"
"declare res varchar;\n"
"res := \'\';\n"
"foreach (any item in val) do\n"
"res := concat (res, \', \', DAV_FC_CONST_AS_SQL(item));\n"
"return subseq (res, 2);\n"
"}\n"
"if (182 = __tag (val))\n"
"return replace (WS.WS.STR_SQL_APOS (val), \'^{\', \'\\\\136{\');\n"
"if (189 = __tag (val))\n"
"return sprintf (\'%d\', val);\n"
"if (211 = __tag (val))\n"
"return sprintf (\'cast (\'\'%s\'\' as datetime)\', cast (val as varchar));\n"
"signal (\'.....\', \'Internal error in DAV_DIR_FILTER: DAV_FC_CONST_AS_SQL has got bad value\');\n"
"}\n"
"--src dav_api.sql:4891\n";

static const char *proc171 = 
"create procedure DAV_FC_PRED_METAS (inout pred_metas any)\n"
"{\n"
"pred_metas := vector (\n"
"\'RES_ID\',                   vector (\'SYS_DAV_RES\'   , 0, \'integer\'  , \'RES_ID\'      ),\n"
"\'RES_ID_SERIALIZED\',        vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'serialize (RES_ID)\'  ),\n"
"\'RES_NAME\',                 vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'RES_NAME\'    ),\n"
"\'RES_FULL_PATH\',            vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'RES_FULL_PATH\'       ),\n"
"\'RES_TYPE\',                 vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'RES_TYPE\'    ),\n"
"\'RES_OWNER_ID\',             vector (\'SYS_DAV_RES\'   , 0, \'integer\'  , \'RES_OWNER\'   ),\n"
"\'RES_OWNER_NAME\',           vector (\'SYS_DAV_USER\'  , 0, \'varchar\'  , \'U_NAME\'      ),\n"
"\'RES_GROUP_ID\',             vector (\'SYS_DAV_RES\'   , 0, \'integer\'  , \'RES_GROUP\'   ),\n"
"\'RES_GROUP_NAME\',           vector (\'SYS_DAV_GROUP\' , 0, \'varchar\'  , \'G_NAME\'      ),\n"
"\'RES_COL_FULL_PATH\',        vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'subseq (RES_FULL_PATH, 0, 1 + strrchr (RES_FULL_PATH, \'\'/\'\'))\'       ),\n"
"\'RES_COL_NAME\',             vector (\'SYS_DAV_COL\'   , 0, \'varchar\'  , \'COL_NAME\'    ),\n"
"\n"
"\'RES_CR_TIME\',              vector (\'SYS_DAV_RES\'   , 0, \'datetime\' , \'RES_CR_TIME\' ),\n"
"\'RES_MOD_TIME\',             vector (\'SYS_DAV_RES\'   , 0, \'datetime\' , \'RES_MOD_TIME\'),\n"
"\'RES_PERMS\',                vector (\'SYS_DAV_RES\'   , 0, \'varchar\'  , \'RES_PERMS\'   ),\n"
"\'RES_CONTENT\',              vector (\'SYS_DAV_RES\'   , 0, \'text\'     , \'RES_CONTENT\' ),\n"
"\'PROP_NAME\',                vector (\'SYS_DAV_PROP\'  , 0, \'varchar\'  , \'PROP_NAME\'   ),\n"
"\'PROP_VALUE\',               vector (\'SYS_DAV_PROP\'  , 1, \'text\'     , \'PROP_VALUE\'  ),\n"
"\'RES_TAGS\',                 vector (\'all-tags\'      , 0, \'varchar\'  , \'DT_TAGS\'     ),\n"
"\'RES_PUBLIC_TAGS\',          vector (\'public-tags\'   , 0, \'text-tag\' , \'DT_TAGS\'     ),\n"
"\'RES_PRIVATE_TAGS\',         vector (\'private-tags\'  , 0, \'text-tag\' , \'DT_TAGS\'     ),\n"
"\'RDF_PROP\',                 vector (\'SYS_DAV_PROP\'  , 1, \'varchar\'  , NULL  ),\n"
"\'RDF_VALUE\',                vector (\'SYS_DAV_PROP\'  , 2, \'XML\'      , NULL  ),\n"
"\'RDF_OBJ_VALUE\',            vector (\'SYS_DAV_PROP\'  , 3, \'XML\'      , NULL  )\n"
");\n"
"}\n"
"--src dav_api.sql:4917\n";

static const char *proc172 = 
"create procedure DAV_FC_CMP_METAS (inout cmp_metas any)\n"
"{\n"
"cmp_metas := vector (\n"
"\'<\',                        vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ < ^{pattern}^)\'     , \'[sql-lt (^{value}^, ^{pattern}^)]\'),\n"
"\'>\',                        vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ > ^{pattern}^)\'     , \'[sql-gt (^{value}^, ^{pattern}^)]\'),\n"
"\'<=\',                       vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ <= ^{pattern}^)\'    , \'[sql-le (^{value}^, ^{pattern}^)]\'),\n"
"\'>=\',                       vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ >= ^{pattern}^)\'    , \'[sql-ge (^{value}^, ^{pattern}^)]\'),\n"
"\'=\',                        vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ = ^{pattern}^)\'     , \'[sql-equ (^{value}^, ^{pattern}^)]\'),\n"
"\'<>\',                       vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ <> ^{pattern}^)\'    , \'[sql-neq (^{value}^, ^{pattern}^)]\'),\n"
"\'!=\',                       vector (\'scalar\', \'sortable\'    , NULL, \'(^{value}^ <> ^{pattern}^)\'    , \'[sql-neq (^{value}^, ^{pattern}^)]\'),\n"
"\'between\',                  vector (\'vector\', \'sortable\'    , NULL, \'(^{value}^ between ^{pattern0}^ and ^{pattern1}^)\'     , \'[sql-ge(^{value}^, ^{pattern0}^)][sql-le (^{value}^, ^{pattern0}^)]\' ),\n"
"\'in\',                       vector (\'vector\', \'sortable\'    , NULL, \'(^{value}^ in (^{pattern}^))\'  , NULL  ),\n"
"\'member_of\',                vector (\'vector\', \'sortable\'    , NULL, \'(^{value}^ in (^{pattern}^))\'  , NULL  ),\n"
"\'like\',                     vector (\'scalar\', \'varchar\'     , NULL, \'(^{value}^ like ^{pattern}^)\'  , \'[^{value}^ like ^{pattern}^]\'),\n"
"\'regexp_match\',             vector (\'scalar\', \'varchar\'     , NULL, \'(regexp_match (^{pattern}^, ^{value}^) is not null)\'   , NULL  ),\n"
"\'is_substring_of\',          vector (\'scalar\', \'varchar\'     , NULL, \'(strstr (^{pattern}^, ^{value}^) is not null)\' ,\'[contains (^{pattern}^, ^{value}^)]\'),\n"
"\'contains_substring\',       vector (\'scalar\', \'varchar\'     , NULL, \'(strstr (^{value}^, ^{pattern}^) is not null)\' ,\'[contains (^{value}^, ^{pattern}^)]\'),\n"
"\'not_contains_substring\',   vector (\'scalar\', \'varchar\'     , NULL, \'(strstr (^{value}^, ^{pattern}^) is null)\'     ,\'[not (contains (^{value}^, ^{pattern}^)]\'     ),\n"
"\'starts_with\',              vector (\'scalar\', \'varchar\'     , NULL, \'(^{value}^ between ^{pattern}^ and (^{pattern}^ || \'\'\\\\377\\\\377\\\\377\\\\377\'\'))\' , \'[starts-with (^{value}^, ^{pattern}^)]\'),\n"
"\'not_starts_with\',          vector (\'scalar\', \'varchar\'     , NULL, \'(not (^{value}^ between ^{pattern}^ and (^{pattern}^ || \'\'\\\\377\\\\377\\\\377\\\\377\'\')))\'   , \'[not (starts-with (^{value}^, ^{pattern}^))]\'        ),\n"
"\'ends_with\',                vector (\'scalar\', \'varchar\'     , NULL, \'(case (sign (length (^{value}^) - length (^{pattern}^))) when -1 then 0 else equ (subseq (^{value}^, length (^{value}^) - length (^{pattern}^)), ^{pattern}^) end)\'    , \'[ends-with (^{value}^, ^{pattern}^)]\'),\n"
"\'not_ends_with\',            vector (\'scalar\', \'varchar\'     , NULL, \'(case (sign (length (^{value}^) - length (^{pattern}^))) when -1 then 1 else neq (subseq (^{value}^, length (^{value}^) - length (^{pattern}^)), ^{pattern}^) end)\'    , \'[not (ends-with (^{value}^, ^{pattern}^))]\'),\n"
"\'is_null\',                  vector (\'no\'    , \'any\'         , NULL, \'(^{value}^ is null)\'           , null  ),\n"
"\'is_not_null\',              vector (\'no\'    , \'any\'         , NULL, \'(^{value}^ is not null)\'       , null  ),\n"
"\'contains_tags\',            vector (\'scalar\', \'varchar\'     , NULL, NULL, NULL ),\n"
"\'may_contain_tags\',         vector (\'scalar\', \'varchar\'     , NULL, NULL, NULL ),\n"
"\'contains_text\',            vector (\'scalar\', \'text\'        , NULL, NULL, \'[text-contains (^{value}^, ^{pattern}^)]\' ),\n"
"\'may_contain_text\',         vector (\'scalar\', \'text\'        , NULL, NULL, \'[text-contains (^{value}^, ^{pattern}^)]\' ),\n"
"\n"
"\'xcontains\',                vector (\'scalar\', \'XML\'         , NULL, NULL, \'[^{pattern}^]\' )\n"
");\n"
"}\n"
"--src dav_api.sql:4955\n";

static const char *proc173 = 
"create procedure DAV_FC_TABLE_METAS (inout table_metas any)\n"
"{\n"
"table_metas := vector (\n"
"\'SYS_DAV_RES\'       , vector (      \'\'      ,\n"
"\'\'      ,\n"
"\'RES_CONTENT\'   , \'RES_CONTENT\' , \'[__quiet] /\' ),\n"
"\'SYS_DAV_COL\'       , vector (      \'\\n  inner join WS.WS.SYS_DAV_COL as ^{alias}^ on ((^{alias}^.COL_ID = _top.RES_COL)^{andpredicates}^)\' ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_COL as ^{alias}^ where (^{alias}^.COL_ID = _top.RES_COL)^{andpredicates}^)\'    ,\n"
"NULL            , NULL          , NULL  ),\n"
"\'SYS_DAV_USER\'      , vector (      \'\\n  left outer join WS.WS.SYS_DAV_USER as ^{alias}^ on ((^{alias}^.U_ID = _top.RES_OWNER)^{andpredicates}^)\'   ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_USER as ^{alias}^ where (^{alias}^.U_ID = _top.RES_OWNER)^{andpredicates}^)\'   ,\n"
"NULL            , NULL          , NULL  ),\n"
"\'SYS_DAV_GROUP\'     , vector (      \'\\n  left outer join WS.WS.SYS_DAV_GROUP as ^{alias}^ on ((^{alias}^.G_ID = _top.RES_GROUP)^{andpredicates}^)\'  ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_GROUP as ^{alias}^ where (^{alias}^.G_ID = _top.RES_GROUP)^{andpredicates}^)\'  ,\n"
"NULL            , NULL          , NULL  ),\n"
"\'SYS_DAV_PROP\'      , vector (      \'\\n  inner join WS.WS.SYS_DAV_PROP as ^{alias}^ on ((^{alias}^.PROP_PARENT_ID = _top.RES_ID) and (^{alias}^.PROP_TYPE = \'\'R\'\')^{andpredicates}^)\'       ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_PROP as ^{alias}^ where (^{alias}^.PROP_PARENT_ID = _top.RES_ID) and (^{alias}^.PROP_TYPE = \'\'R\'\')^{andpredicates}^)\'  ,\n"
"\'PROP_VALUE\'    , \'PROP_VALUE\'  , \'[__quiet __davprop xmlns:virt=\"virt\"] .\'     ),\n"
"\'public-tags\'       , vector (      \'\\n  inner join WS.WS.SYS_DAV_TAG as ^{alias}^ on ((^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = http_nobody_uid())^{andpredicates}^)\'   ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_TAG as ^{alias}^ where (^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = http_nobody_uid())^{andpredicates}^)\'      ,\n"
"\'DT_TAGS\'       , \'DT_TAGS\'     , NULL  ),\n"
"\'private-tags\'      , vector (      \'\\n  inner join WS.WS.SYS_DAV_TAG as ^{alias}^ on ((^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = ^{uid}^)^{andpredicates}^)\'     ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_TAG as ^{alias}^ where (^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = ^{uid}^)^{andpredicates}^)\'        ,\n"
"\'DT_TAGS\'       , \'DT_TAGS\'     , NULL  ),\n"
"\'all-tags\'          , vector (      \'\\n  inner join WS.WS.SYS_DAV_TAG as ^{alias}^ on ((^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = http_nobody_uid() or ^{alias}^.DT_U_ID = ^{uid}^)^{andpredicates}^)\'    ,\n"
"\'\\n  exists (select 1 from WS.WS.SYS_DAV_TAG as ^{alias}^ where (^{alias}^.DT_RES_ID = _top.RES_ID) and (^{alias}^.DT_U_ID = http_nobody_uid() or ^{alias}^.DT_U_ID = ^{uid}^)^{andpredicates}^)\'       ,\n"
"\'DT_TAGS\'       , \'DT_TAGS\'     , NULL  )\n"
");\n"
"}\n"
"--src dav_api.sql:4989\n";

static const char *proc174 = 
"create function DAV_FC_PRINT_COMPARISON (inout pred any, inout pred_metas any, inout cmp_metas any, in varname varchar, in nonsql integer) returns varchar\n"
"{\n"
"declare pred_meta any;\n"
"declare cmp_meta, pattern_sample, cuts any;\n"
"declare var_expn, cmp_type, pattern_type, cond_format varchar;\n"
"declare res varchar;\n"
"pred_meta := get_keyword (pred[0], pred_metas);\n"
"cmp_meta := get_keyword (pred[1], cmp_metas);\n"
"cond_format := cmp_meta [3 + nonsql];\n"
"if (cond_format is null)\n"
"signal (\'.....\', \'Internal error in DAV_DIR_FILTER: DAV_FC_PRINT_COMPARISON on non-comparison predicate\');\n"
"cmp_type := cmp_meta[1];\n"
"pattern_sample := pred[2];\n"
"if (\'scalar\' = cmp_meta[0])\n"
"{\n"
"if (not (__tag (pattern_sample) in (182, 189, 211)))\n"
"goto bad_pattern_datatype;\n"
"}\n"
"else if (\'vector\' = cmp_meta[0])\n"
"{\n"
"if (193 <> __tag (pattern_sample))\n"
"goto bad_pattern_datatype;\n"
"if (0 = length (pattern_sample))\n"
"goto empty_array_pattern;\n"
"pattern_sample := pattern_sample[0];\n"
"if (not (__tag (pattern_sample) in (182, 189, 211)))\n"
"goto bad_pattern_datatype;\n"
"foreach (any itm in pred[2]) do\n"
"{\n"
"if (__tag (itm) <> __tag(pred[2][0]))\n"
"goto mixed_array_pattern;\n"
"}\n"
"}\n"
"else if (\'no\' = cmp_meta[0])\n"
"{\n"
"pattern_sample := \'\';\n"
"}\n"
"else signal (\'.....\', \'Internal error in DAV_DIR_FILTER: DAV_FC_CMP_META forms bad sort of match pattern\');\n"
"if (isstring (pattern_sample))\n"
"pattern_type := \'varchar\';\n"
"else if (isinteger (pattern_sample))\n"
"pattern_type := \'integer\';\n"
"else if (211 = __tag (pattern_sample))\n"
"pattern_type := \'datetime\';\n"
"else\n"
"goto bad_pattern_datatype;\n"
"if (\'sortable\' = cmp_type)\n"
"{\n"
"\n"
"\n"
"cmp_type := pattern_type;\n"
"}\n"
"else if (\'any\' = cmp_type)\n"
"{\n"
"pattern_type := pred_meta[2];\n"
"}\n"
"else if (\n"
"(1 = nonsql) and\n"
"(\'varchar\' = pattern_type) and\n"
"((\'text\' = cmp_type) or (\'XML\' = cmp_type)) )\n"
"{\n"
"pattern_type := pred_meta[2];\n"
"}\n"
"else if (pattern_type <> cmp_type)\n"
"goto bad_pattern_datatype;\n"
"if (pred_meta[2] = pattern_type)\n"
"{\n"
"var_expn := varname;\n"
"}\n"
"else if (1 = nonsql)\n"
"{\n"
"if ((\'text\' = cmp_meta) or (\'XML\' = cmp_meta))\n"
"var_expn := varname;\n"
"else if (\'varchar\' = pattern_type)\n"
"var_expn := sprintf (\'string (%s)\', varname);\n"
"else if (\'integer\' = pattern_type)\n"
"var_expn := sprintf (\'number (%s)\', varname);\n"
"else if (\'datetime\' = pattern_type)\n"
"var_expn := sprintf (\'dateTime (%s, 1)\', varname);\n"
"else\n"
"goto type_mismatch;\n"
"}\n"
"else\n"
"{\n"
"if (\'varchar\' = pred_meta[2])\n"
"var_expn := sprintf (\'DB.DBA.DAV_CAST_STRING_TO_%s (%s)\', upper (cmp_type), varname);\n"
"else if (\'text\' = pred_meta[2])\n"
"var_expn := sprintf (\'DB.DBA.DAV_CAST_TEXT_TO_%s (%s)\', upper (cmp_type), varname);\n"
"else\n"
"goto type_mismatch;\n"
"}\n"
"if ((\'like\' = pred[1]) and (\'%\' = pred[2]))\n"
"return null;\n"
"if ((\'starts_with\' = pred[1]) and (\'\' = pred[2]))\n"
"return null;\n"
"if ((\'ends_with\' = pred[1]) and (\'\' = pred[2]))\n"
"return null;\n"
"res := \'\';\n"
"cuts := split_and_decode (cond_format, 0, \'\\0\\0^\');\n"
"foreach (varchar cut in cuts) do\n"
"{\n"
"if (cut = \'\' or (cut[0] <> \'{\'[0]))\n"
"res := res || cut;\n"
"else if (cut = \'{value}\')\n"
"res := res || var_expn;\n"
"else if (cut = \'{pattern}\')\n"
"res := res || DAV_FC_CONST_AS_SQL (pred[2]);\n"
"else if (cut = \'{pattern0}\')\n"
"{\n"
"res := res || DAV_FC_CONST_AS_SQL (pred[2][0]);\n"
"}\n"
"else if (cut = \'{pattern1}\')\n"
"{\n"
"if (length (pred[2]) < 2)\n"
"goto tooshort_array_pattern;\n"
"res := res || DAV_FC_CONST_AS_SQL (pred[2][1]);\n"
"}\n"
"else signal (\'.....\', \'Internal error in DAV_DIR_FILTER: DAV_FC_CMP_META forms bad formatting pattern\');\n"
"}\n"
"return res;\n"
"\n"
"bad_pattern_datatype:\n"
"signal (\'.....\', sprintf (\'Bad data type (%d) of pattern value in predicate \'\'%s\'\' (operation \'\'%s\'\') in filter of DAV_DIR_FILTER, \', __tag (pattern_sample), pred[0], pred[1]));\n"
"empty_array_pattern:\n"
"signal (\'.....\', sprintf (\'The pattern is an empty vector in predicate \'\'%s\'\' (operation \'\'%s\'\') in filter of DAV_DIR_FILTER, \', pred[0], pred[1]));\n"
"tooshort_array_pattern:\n"
"signal (\'.....\', sprintf (\'The pattern vector is too short in predicate \'\'%s\'\' (operation \'\'%s\'\') in filter of DAV_DIR_FILTER, \', pred[0], pred[1]));\n"
"mixed_array_pattern:\n"
"signal (\'.....\', sprintf (\'All items of the pattern vector must have same datatype in predicate \'\'%s\'\' (operation \'\'%s\'\') in filter of DAV_DIR_FILTER, \', pred[0], pred[1]));\n"
"type_mismatch:\n"
"signal (\'.....\', sprintf (\'Can not compile comparison \'\'%s %s %s\'\' due to type mismatch in predicate \'\'%s\'\' in filter of DAV_DIR_FILTER, \', pred_meta[2], pred[1], pattern_type, pred[0]));\n"
"}\n"
"--src dav_api.sql:5021\n";

static const char *proc175 = 
"create function DAV_FC_PRINT_WHERE (inout filter any, in param_uid integer) returns varchar\n"
"{\n"
"declare pred_metas, cmp_metas, table_metas any;\n"
"declare used_tables any;\n"
"\n"
"DAV_FC_PRED_METAS (pred_metas);\n"
"DAV_FC_CMP_METAS (cmp_metas);\n"
"DAV_FC_TABLE_METAS (table_metas);\n"
"used_tables := vector (\'SYS_DAV_RES\', vector (\'SYS_DAV_RES\', \'_top\', null, vector (), vector (), vector ()));\n"
"return DAV_FC_PRINT_WHERE_INT (filter, pred_metas, cmp_metas, table_metas, used_tables, param_uid);\n"
"}\n"
"--src dav_api.sql:5156\n";

static const char *proc176 = 
"create function DAV_FC_PRINT_WHERE_INT (in filter any, inout pred_metas any, inout cmp_metas any, inout table_metas any, inout used_tables any, in param_uid integer) returns varchar\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare pred_count, pred_idx, need_and, need_top_and integer;\n"
"declare table_count, table_idx, fixed_used_tables, first_ft_table_idx integer;\n"
"declare table_of_pred, ses any;\n"
"declare res_strg varchar;\n"
"pred_count := length (filter);\n"
"fixed_used_tables := length (used_tables);\n"
"if ((0 = pred_count) and (2 = fixed_used_tables))\n"
"return \'\\nwhere\\n(1=1)\\n\';\n"
"\n"
"table_of_pred := make_array (pred_count, \'any\');\n"
"pred_idx := 0;\n"
"while (pred_idx < pred_count)\n"
"{\n"
"declare pred, pred_meta, cmp_meta any;\n"
"declare pred_table_key, optext, cmp_text, ftc_text, xc_text varchar;\n"
"declare join_with_prop_name, used_table_pos integer;\n"
"pred := filter[pred_idx];\n"
"pred_meta := get_keyword (pred[0], pred_metas);\n"
"if (pred_meta is null)\n"
"{\n"
"signal (\'.....\', sprintf (\'Invalid predicate type \'\'%s\'\' in filter of DAV_DIR_FILTER\', cast (pred[0] as varchar)));\n"
"}\n"
"if (length (pred) <> 3 + pred_meta[1])\n"
"signal (\'.....\', sprintf (\'Predicate with type \'\'%s\'\' should be a vector of length %d in filter of DAV_DIR_FILTER\', pred[0], (3 + pred_meta[1])));\n"
"cmp_meta := get_keyword (pred[1], cmp_metas);\n"
"if (cmp_meta is null)\n"
"signal (\'.....\', sprintf (\'Invalid operation name \'\'%s\'\' in filter of DAV_DIR_FILTER\', pred[1]));\n"
"join_with_prop_name := 0;\n"
"if ((\'PROP_VALUE\' = pred[0]) or (\'RDF_PROP\' = pred[0]) or (\'RDF_VALUE\' = pred[0]) or (\'RDF_OBJ_VALUE\' = pred[0]))\n"
"{\n"
"if (get_keyword (pred_meta[0], used_tables) is null)\n"
"join_with_prop_name := 1;\n"
"else\n"
"{\n"
"filter := vector_concat (filter, vector (vector (\'PROP_NAME\', \'=\', pred[3])));\n"
"table_of_pred := vector_concat (table_of_pred, vector (null));\n"
"pred_count := pred_count + 1;\n"
"}\n"
"}\n"
"if (join_with_prop_name)\n"
"{\n"
"if (not isstring (pred[3]))\n"
"signal (\'.....\', sprintf (\'The DAV property name in predicate of type \'\'%s\'\' is not a string in filter of DAV_DIR_FILTER\', pred[0]));\n"
"pred_table_key := concat (pred_meta[0], \', PROP_NAME=\', pred[3]);\n"
"}\n"
"else\n"
"pred_table_key := pred_meta[0];\n"
"used_table_pos := position (pred_table_key, used_tables, 1, 2);\n"
"if (0 = used_table_pos)\n"
"{\n"
"declare cmp_checks any;\n"
"declare new_alias varchar;\n"
"used_table_pos := length (used_tables) + 1;\n"
"new_alias := sprintf (\'_sub%d\', pred_idx);\n"
"if (join_with_prop_name)\n"
"cmp_checks := sprintf (\'(%s.PROP_NAME = %s)\', new_alias, WS.WS.STR_SQL_APOS (pred[3]));\n"
"else\n"
"cmp_checks := null;\n"
"used_tables := vector_concat (used_tables, vector (pred_table_key, vector (pred_meta[0], new_alias, cmp_checks, vector (), vector (), vector ())));\n"
"}\n"
"table_of_pred [pred_idx] := used_table_pos;\n"
"cmp_text := null;\n"
"ftc_text := null;\n"
"xc_text := null;\n"
"if (pred_meta[3] = \'\')\n"
"{\n"
"if ((\'may_contain_text\' = pred[1]) or (\'may_contain_tags\' = pred[1]))\n"
"{\n"
" ;\n"
"}\n"
"else if (\'is_null\' = pred[1])\n"
"{\n"
" ;\n"
"}\n"
"else\n"
"return \'1=2\';\n"
"}\n"
"else\n"
"if (pred_meta[3] is not null and cmp_meta[3] is not null)\n"
"{\n"
"declare varname varchar;\n"
"if (strchr (pred_meta[3], \'(\') is not null)\n"
"varname := pred_meta[3];\n"
"else\n"
"{\n"
"varname := concat (used_tables[used_table_pos][1], \'.\', pred_meta[3]);\n"
"}\n"
"cmp_text := DAV_FC_PRINT_COMPARISON (pred, pred_metas, cmp_metas, varname, 0);\n"
"}\n"
"else if (\'RDF_PROP\' = pred[0])\n"
"{\n"
"optext := DAV_FC_PRINT_COMPARISON (pred, pred_metas, cmp_metas, \'name(.)\', 1);\n"
"if (optext is null)\n"
"xc_text := \'[virt:rdf/virt:top-res[virt:prop]]\';\n"
"else\n"
"xc_text := \'[virt:rdf/virt:top-res/virt:prop/*[1]\' || optext || \']\';\n"
"}\n"
"else if (\'RDF_VALUE\' = pred[0])\n"
"{\n"
"optext := DAV_FC_PRINT_COMPARISON (pred, pred_metas, cmp_metas, \'.\', 1);\n"
"if (optext is null)\n"
"xc_text := sprintf (\'[virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]][virt:value]]\', pred[4]);\n"
"else\n"
"xc_text := sprintf (\'[virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]]/virt:value%s]\', pred[4], optext);\n"
"}\n"
"else if (\'RDF_OBJ_VALUE\' = pred[0])\n"
"{\n"
"optext := DAV_FC_PRINT_COMPARISON (pred, pred_metas, cmp_metas, \'.\', 1);\n"
"if (optext is null)\n"
"xc_text := sprintf (\'[virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]]/virt:res/virt:prop[*[1][self::(!%s!)]][virt:value]]\', pred[4], pred[5]);\n"
"else\n"
"xc_text := sprintf (\'[virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]]/virt:res/virt:prop[*[1][self::(!%s!)]]/virt:value%s]\', pred[4], pred[5], optext);\n"
"}\n"
"else if ((\'contains_text\' = pred[1]) or (\'may_contain_text\' = pred[1]))\n"
"{\n"
"if (not (isstring (pred[2])))\n"
"signal (\'.....\', sprintf (\'Free text pattern in predicate of type \'\'%s\'\' is not a string in filter of DAV_DIR_FILTER\', pred[0]));\n"
"ftc_text := \'(\' || pred[2] || \')\';\n"
"}\n"
"else if ((\'contains_tags\' = pred[1]) or (\'may_contain_tags\' = pred[1]))\n"
"{\n"
"if (not (isstring (pred[2])))\n"
"signal (\'.....\', sprintf (\'String of tags in predicate of type \'\'%s\'\' is not a string in filter of DAV_DIR_FILTER\', pred[0]));\n"
"ftc_text := \'(\"\' || replace (WS.WS.DAV_TAG_NORMALIZE (pred[2]), \' \', \'\" and \"\') || \'\")\';\n"
"if (\'RES_TAGS\' = pred[0])\n"
"ftc_text := \'((\"UID^{uid}^\" or \"UID^{nobodyuid}^\") and \' || ftc_text || \')\';\n"
"else if (\'RES_PUBLIC_TAGS\' = pred[0])\n"
"ftc_text := \'(\"UID^{nobodyuid}^\" and \' || ftc_text || \')\';\n"
"else if (\'RES_PRIVATE_TAGS\' = pred[0])\n"
"ftc_text := \'(\"UID^{uid}^\" and \' || ftc_text || \')\';\n"
"}\n"
"else if (\'xcontains\' = pred[1])\n"
"{\n"
"if (not (isstring (pred[2])))\n"
"signal (\'.....\', sprintf (\'Free text pattern in predicate of type \'\'%s\'\' is not a string in filter of DAV_DIR_FILTER\', pred[0]));\n"
"\n"
"\n"
"xc_text := \'[\' || pred[2] || \']\';\n"
"}\n"
"else\n"
"signal (\'.....\', \'Internal error in DAV_DIR_FILTER: no condition text generated for a predicate\');\n"
"if (cmp_text is not null and (0 = position (cmp_text, used_tables[used_table_pos][3])))\n"
"used_tables[used_table_pos][3] := vector_concat (used_tables[used_table_pos][3], vector (cmp_text));\n"
"if (ftc_text is not null and (0 = position (ftc_text, used_tables[used_table_pos][4])))\n"
"used_tables[used_table_pos][4] := vector_concat (used_tables[used_table_pos][4], vector (ftc_text));\n"
"if (xc_text is not null and (0 = position (xc_text, used_tables[used_table_pos][5])))\n"
"used_tables[used_table_pos][5] := vector_concat (used_tables[used_table_pos][5], vector (xc_text));\n"
"pred_idx := pred_idx + 1;\n"
"}\n"
"if ((2 = length (used_tables)) and\n"
"(0 = length (used_tables[1][3])) and\n"
"(0 = length (used_tables[1][4])) and\n"
"(0 = length (used_tables[1][5])) )\n"
"return \'\\nwhere\\n(1=1)\\n\';\n"
"\n"
"ses := string_output();\n"
"table_count := length (used_tables);\n"
"first_ft_table_idx := null;\n"
"for (table_idx := 1; (table_idx < table_count) and first_ft_table_idx is null ; table_idx := table_idx + 2)\n"
"{\n"
"declare tbl any;\n"
"tbl := used_tables [table_idx];\n"
"if ((length (tbl[4]) > 0) or (length (tbl[5]) > 0))\n"
"first_ft_table_idx := table_idx;\n"
"}\n"
"for (table_idx := 1; table_idx < table_count; table_idx := table_idx + 2)\n"
"{\n"
"declare tbl, new_tbl any;\n"
"declare has_ft, has_xc integer;\n"
"tbl := used_tables [table_idx];\n"
"has_ft := length (tbl[4]);\n"
"has_xc := length (tbl[5]);\n"
"if ((has_ft and has_xc) or\n"
"((table_idx > first_ft_table_idx) and\n"
"(table_idx < fixed_used_tables) and\n"
"(has_ft or has_xc) ) )\n"
"{\n"
"declare cmp_checks any;\n"
"declare new_alias varchar;\n"
"new_alias := sprintf (\'%s_%d\', tbl[1], table_idx);\n"
"if (tbl[2] like \'(%.PROP_NAME = %)\')\n"
"cmp_checks := sprintf (\'(%s.PROP_NAME = %s.PROP_NAME)\', new_alias, tbl[1]);\n"
"else\n"
"cmp_checks := null;\n"
"new_tbl := vector (tbl[0], new_alias, cmp_checks, vector (), vector (), vector ());\n"
"if ((table_idx > first_ft_table_idx) and\n"
"(table_idx < fixed_used_tables) and\n"
"(has_ft or has_xc) )\n"
"{\n"
"new_tbl[4] := tbl[4];\n"
"new_tbl[5] := tbl[5];\n"
"tbl[4] := null;\n"
"tbl[5] := null;\n"
"}\n"
"else if (has_xc)\n"
"{\n"
"new_tbl[5] := tbl[5];\n"
"tbl[5] := null;\n"
"}\n"
"else if (has_ft)\n"
"{\n"
"new_tbl[4] := tbl[4];\n"
"tbl[4] := null;\n"
"}\n"
"else\n"
"signal (\'.....\', \'Internal error in DAV_DIR_FILTER: cannot handle a combination of free-text and xcontain predicates\');\n"
"used_tables := vector_concat (used_tables,\n"
"vector (used_tables [table_idx-1], new_tbl) );\n"
"table_count := table_count + 2;\n"
"}\n"
"}\n"
"if (first_ft_table_idx is null)\n"
"first_ft_table_idx := table_count;\n"
"\n"
"for (table_idx := fixed_used_tables + 1; table_idx < table_count ; table_idx := table_idx + 2)\n"
"{\n"
"declare tbl, tbl_meta any;\n"
"\n"
"tbl := used_tables [table_idx];\n"
"tbl_meta := get_keyword (tbl[0], table_metas);\n"
"if (tbl_meta is null)\n"
"signal (\'.....\', sprintf (\'Internal error in DAV_DIR_FILTER: bad table %s\', tbl[0]));\n"
"if ((table_idx <= first_ft_table_idx) or ((length (tbl[4]) = 0) and (length (tbl[5]) = 0)))\n"
"{\n"
"declare andpredicates, join_code varchar;\n"
"if (length (tbl[2]) > 0)\n"
"andpredicates := \' AND \' || tbl[2];\n"
"else\n"
"andpredicates := \'\';\n"
"join_code := replace (replace (tbl_meta[0], \'^{alias}^\', tbl[1]), \'^{andpredicates}^\', andpredicates);\n"
"http (join_code, ses);\n"
"}\n"
"}\n"
"http (\'\\nwhere\\n\', ses);\n"
"need_top_and := 0;\n"
"for (table_idx := 1; table_idx < table_count ; table_idx := table_idx + 2)\n"
"{\n"
"declare tbl, tbl_meta, subses any;\n"
"declare subses_strg varchar;\n"
"\n"
"tbl := used_tables [table_idx];\n"
"tbl_meta := get_keyword (tbl[0], table_metas);\n"
"subses := string_output ();\n"
"need_and := 0;\n"
"if (length (tbl[4]) > 0)\n"
"{\n"
"declare ft_field, varname, ft_pattern varchar;\n"
"declare need_ft_and integer;\n"
"ft_field := tbl_meta[2];\n"
"if (ft_field is null)\n"
"signal (\'.....\', sprintf (\'Internal error in DAV_DIR_FILTER: bad table %s for free text search\', tbl[0]));\n"
"varname := concat (tbl[1], \'.\', ft_field);\n"
"need_ft_and := 0;\n"
"ft_pattern := \'\';\n"
"foreach (varchar ft_term in tbl[4]) do\n"
"{\n"
"if (need_ft_and)\n"
"ft_pattern := ft_pattern || \' and \';\n"
"else\n"
"need_ft_and := 1;\n"
"ft_pattern := ft_pattern || ft_term;\n"
"}\n"
"if (need_and)\n"
"http (\' and\\n  \', subses);\n"
"else\n"
"need_and := 1;\n"
"http (sprintf (\'contains (%s, \', varname), subses);\n"
"http (WS.WS.STR_SQL_APOS (ft_pattern), subses);\n"
"http (\')\', subses);\n"
"}\n"
"if (length (tbl[5]) > 0)\n"
"{\n"
"declare ft_field, varname, ft_pattern varchar;\n"
"ft_field := tbl_meta[3];\n"
"if (ft_field is null)\n"
"signal (\'.....\', sprintf (\'Internal error in DAV_DIR_FILTER: bad table %s for xcontains search\', tbl[0]));\n"
"varname := concat (tbl[1], \'.\', ft_field);\n"
"ft_pattern := tbl_meta[4];\n"
"if (length (tbl[5]) = 1)\n"
"{\n"
"ft_pattern := ft_pattern || tbl[5][0];\n"
"}\n"
"else\n"
"{\n"
"foreach (varchar ft_term in tbl[5]) do\n"
"{\n"
"ft_pattern := ft_pattern || ft_term;\n"
"}\n"
"}\n"
"if (need_and)\n"
"http (\' and\\n  \', subses);\n"
"else\n"
"need_and := 1;\n"
"http (sprintf (\'xcontains (%s, \', varname), subses);\n"
"http (WS.WS.STR_SQL_APOS (ft_pattern), subses);\n"
"http (\')\', subses);\n"
"}\n"
"foreach (varchar cond in tbl[3]) do\n"
"{\n"
"if (need_and)\n"
"http (\' and\\n  \', subses);\n"
"else\n"
"need_and := 1;\n"
"http (cond, subses);\n"
"}\n"
"subses_strg := string_output_string (subses);\n"
"if (subses_strg <> \'\')\n"
"{\n"
"if (need_top_and)\n"
"http (\' and\\n  \', ses);\n"
"else\n"
"need_top_and := 1;\n"
"if ((table_idx <= first_ft_table_idx) or ((length (tbl[4]) = 0) and (length (tbl[5]) = 0)))\n"
"http (subses_strg, ses);\n"
"else\n"
"{\n"
"declare exists_code varchar;\n"
"exists_code := replace (replace (tbl_meta[1], \'^{alias}^\', tbl[1]), \'^{andpredicates}^\', \' and\\n  \' || subses_strg);\n"
"http (exists_code, ses);\n"
"}\n"
"}\n"
"}\n"
"if (not need_top_and)\n"
"http (\'(1=1) \', ses);\n"
"res_strg := string_output_string (ses);\n"
"res_strg := replace (res_strg, \'^{uid}^\', cast (param_uid as varchar));\n"
"res_strg := replace (res_strg, \'^{nobodyuid}^\', cast (http_nobody_uid() as varchar));\n"
"return res_strg;\n"
"}\n"
"--src dav_api.sql:5169\n";

static const char *proc177 = 
"create procedure\n"
"DAV_REGISTER_RDF_SCHEMA (in schema_uri varchar, in location varchar, in local_addon varchar, in mode varchar)\n"
"{\n"
"mode := lower (mode);\n"
"if (exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri))\n"
"{\n"
"if (\'into\' = mode)\n"
"signal (\'23000\', sprintf (\'Uniqueness violation: RDF schema \'\'%s\'\' is already registered\', schema_uri));\n"
"else if (\'replacing\' = mode)\n"
"insert replacing WS.WS.SYS_RDF_SCHEMAS (RS_URI, RS_LOCATION, RS_LOCAL_ADDONS, RS_DEPRECATED)\n"
"values (schema_uri, location, local_addon, 0);\n"
"else if (\'soft\' = mode)\n"
"update WS.WS.SYS_RDF_SCHEMAS set RS_LOCAL_ADDONS = local_addon, RS_DEPRECATED = 0 where RS_URI = schema_uri and RS_LOCAL_ADDONS is null;\n"
"}\n"
"else\n"
"insert replacing WS.WS.SYS_RDF_SCHEMAS (RS_URI, RS_LOCATION, RS_LOCAL_ADDONS, RS_DEPRECATED)\n"
"values (schema_uri, location, local_addon, 0);\n"
"DAV_GET_RDF_SCHEMA_N3 (schema_uri);\n"
"}\n"
"--src dav_api.sql:5513\n";

static const char *proc178 = 
" create function DAV_RDF_SCHEMA_N3_LIST_PROPERTIES (inout schema_n3 any, in classname varchar)\n"
"{\n"
"if (classname is null)\n"
"{\n"
"return xpath_eval (\'\n"
"let (\"excl\",\n"
"distinct (\n"
"for (\"dom\",\n"
"/N3\n"
"[@N3P=\"http://www.openlinksw.com/schemas/virtrdf#domain\"],\n"
"string (\\044dom/@N3S) ) ),\n"
"/N3\n"
"[@N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\"]\n"
"[@N3O=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#Property\"]\n"
"[not (@N3S = \\044excl)]\n"
"/@N3S )\',\n"
"schema_n3, 1 );\n"
"}\n"
"return xpath_eval (\'\n"
"let (\"incl\",\n"
"distinct (\n"
"for (\"dom\",\n"
"/N3\n"
"[@N3P=\"http://www.openlinksw.com/schemas/virtrdf#domain\"]\n"
"[@N3O=\\044classname],\n"
"string (\\044dom/@N3S) ) ),\n"
"/N3\n"
"[@N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\"]\n"
"[@N3O=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#Property\"]\n"
"[@N3S=\\044incl]\n"
"/@N3S )\',\n"
"schema_n3, 1, vector (\'classname\', classname) );\n"
"}\n"
"--src dav_api.sql:5536\n";

static const char *proc179 = 
"create procedure\n"
"DAV_CROP_URI_TO_CATNAME (in uri varchar)\n"
"{\n"
"declare res varchar;\n"
"declare slash integer;\n"
"uri := replace (uri, \'#\', \'/\');\n"
"again:\n"
"if (uri like \'%/\')\n"
"{\n"
"uri := subseq (uri, 0, length (uri) - 1);\n"
"goto again;\n"
"}\n"
"if (uri like \'http://%\')\n"
"{\n"
"uri := subseq (uri, 7);\n"
"goto again;\n"
"}\n"
"slash := strrchr (uri, \'/\');\n"
"if (slash is not null)\n"
"return subseq (uri, slash + 1);\n"
"return uri;\n"
"}\n"
"--src dav_api.sql:5572\n";

static const char *proc180 = 
" create procedure\n"
"DAV_GET_RDF_SCHEMA_N3 (in schema_uri varchar)\n"
"{\n"
"for (select RS_LOCATION, RS_LOCAL_ADDONS, RS_PRECOMPILED from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri) do\n"
"{\n"
"declare std_schema, local_addon, mix any;\n"
"declare schema_catname varchar;\n"
"declare prop_list, prop_catnames, prop_catnames_hash any;\n"
"if (RS_PRECOMPILED is not null)\n"
"return RS_PRECOMPILED;\n"
"if (RS_LOCATION is null)\n"
"std_schema := NULL;\n"
"else\n"
"{\n"
"std_schema := xtree_doc (XML_URI_GET_AND_CACHE (RS_LOCATION), 0, RS_LOCATION);\n"
"std_schema := xslt (\'http://local.virt/rdfxml2n3xml\', std_schema);\n"
"}\n"
"if (RS_LOCAL_ADDONS is null)\n"
"local_addon := NULL;\n"
"else\n"
"{\n"
"local_addon := xtree_doc (XML_URI_GET (\'\', RS_LOCAL_ADDONS), 0, RS_LOCAL_ADDONS);\n"
"local_addon := xslt (\'http://local.virt/rdfxml2n3xml\', local_addon);\n"
"}\n"
"mix := DAV_RDF_MERGE (std_schema, local_addon, null, -1);\n"
"\n"
"\n"
"schema_catname := xpath_eval (\'/N3[@N3S=\\044schema-uri][@N3P=\"http://www.openlinksw.com/schemas/virtrdf#catName\"]\', mix, 1, vector (UNAME\'schema-uri\', schema_uri));\n"
"if (schema_catname is not null)\n"
"{\n"
"schema_catname := replace (replace (cast (schema_catname as varchar), \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"if (not exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = schema_catname and RS_URI <> schema_uri))\n"
"goto schema_catname_complete;\n"
"}\n"
"schema_catname := xpath_eval (\'/N3[@N3S=\\044schema-uri][@N3P=\"http://www.w3.org/2000/01/rdf-schema#label\"]\', mix, 1, vector (UNAME\'schema-uri\', schema_uri));\n"
"if (schema_catname is not null)\n"
"{\n"
"schema_catname := replace (replace (cast (schema_catname as varchar), \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"if (not exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = schema_catname and RS_URI <> schema_uri))\n"
"goto schema_catname_complete;\n"
"}\n"
"schema_catname := DAV_CROP_URI_TO_CATNAME (schema_uri);\n"
"schema_catname := replace (schema_catname, \'/\', \'-\' || \'-\');\n"
"if (not exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = schema_catname and RS_URI <> schema_uri))\n"
"goto schema_catname_complete;\n"
"schema_catname := replace (replace (schema_uri, \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"while (exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = schema_catname and RS_URI <> schema_uri))\n"
"schema_catname := sprintf (\'%s--%d\', (replace (schema_uri, \'#\', \'/\') , \'/\', \'-\' || \'-\'), 10000 + rnd (90000));\n"
"\n"
"schema_catname_complete:\n"
"\n"
"vectorbld_init (prop_catnames);\n"
"prop_catnames_hash := dict_new ();\n"
"prop_list := DAV_RDF_SCHEMA_N3_LIST_PROPERTIES (mix, NULL);\n"
"foreach (varchar propname in prop_list) do\n"
"{\n"
"declare catname varchar;\n"
"declare catid integer;\n"
"catname := xpath_eval (\'/N3[@N3S=\\044propname][@N3P=\"http://www.openlinksw.com/schemas/virtrdf#catName\"]\', mix, 1, vector (UNAME\'propname\', propname));\n"
"propname := cast (propname as varchar);\n"
"if (catname is not null)\n"
"{\n"
"catname := replace (replace (cast (catname as varchar), \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"if (0 = dict_get (prop_catnames_hash, catname, 0))\n"
"goto prop_catname_complete;\n"
"}\n"
"catname := DAV_CROP_URI_TO_CATNAME (propname);\n"
"catname := replace (catname, \'/\', \'-\' || \'-\');\n"
"if (0 = dict_get (prop_catnames_hash, catname, 0))\n"
"goto prop_catname_complete;\n"
"catname := replace (replace (propname, \'#\', \'/\') , \'/\', \'-\' || \'-\');\n"
"while (dict_get (prop_catnames_hash, catname, 0))\n"
"catname := sprintf (\'%s--%d\', replace (replace (propname, \'#\', \'/\') , \'/\', \'-\' || \'-\'), 10000 + rnd (90000));\n"
"\n"
"prop_catname_complete:\n"
"catid := coalesce ((select RPN_CATID from WS.WS.SYS_RDF_PROP_NAME where RPN_URI = propname));\n"
"if (catid is null)\n"
"{\n"
"catid := WS.WS.GETID (\'RPN\');\n"
"insert into WS.WS.SYS_RDF_PROP_NAME (RPN_URI, RPN_CATID) values (propname, catid);\n"
"}\n"
"vectorbld_acc (prop_catnames, propname, catname, catid, 0, 0, 0);\n"
"dict_put (prop_catnames_hash, catname, catid);\n"
"}\n"
"vectorbld_final (prop_catnames);\n"
"update WS.WS.SYS_RDF_SCHEMAS\n"
"set\n"
"RS_PRECOMPILED = mix,\n"
"RS_COMPILATION_DATE = now (),\n"
"RS_CATNAME = schema_catname,\n"
"RS_PROP_CATNAMES = serialize (prop_catnames)\n"
"where RS_URI = schema_uri;\n"
"return mix;\n"
"}\n"
"\n"
"return xtree_doc (\'<stub/>\');\n"
"}\n"
"--src dav_api.sql:5598\n";

static const char *proc181 = 
"create procedure\n"
"DAV_DEPRECATE_RDF_SCHEMA (in schema_uri varchar)\n"
"{\n"
"update WS.WS.SYS_RDF_SCHEMAS set RS_DEPRECATED = 1 where RS_URI = schema_uri;\n"
"if (exists (select top 1 1 from WS.WS.SYS_MIME_RDFS where MR_RDF_URI = schema_uri))\n"
"{\n"
"update WS.WS.SYS_MIME_RDFS set MR_DEPRECATED = 1 where MR_RDF_URI = schema_uri;\n"
"return;\n"
"}\n"
"\n"
"delete from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri and RS_LOCAL_ADDONS is null;\n"
"}\n"
"--src dav_api.sql:5698\n";

static const char *proc182 = 
"create procedure\n"
"DAV_REGISTER_MIME_TYPE (in m_ident varchar, in descr varchar, in dflt_ext varchar, in badmagic varchar, in mode varchar)\n"
"{\n"
"\n"
"\n"
"mode := lower (mode);\n"
"if (exists (select top 1 1 from WS.WS.SYS_MIME_TYPES where MT_IDENT = m_ident))\n"
"{\n"
"if (\'into\' = mode)\n"
"signal (\'23000\', sprintf (\'Uniqueness violation: MIME type \'\'%s\'\' is already registered\', m_ident));\n"
"else if (\'replacing\' = mode)\n"
"insert replacing WS.WS.SYS_MIME_TYPES (MT_IDENT, MT_DESCRIPTION, MT_DEFAULT_EXT, MT_BADMAGIC_IDENT)\n"
"values (m_ident, descr, dflt_ext, badmagic);\n"
"else if (\'soft\' = mode)\n"
"return;\n"
"}\n"
"else\n"
"insert replacing WS.WS.SYS_MIME_TYPES (MT_IDENT, MT_DESCRIPTION, MT_DEFAULT_EXT, MT_BADMAGIC_IDENT)\n"
"values (m_ident, descr, dflt_ext, badmagic);\n"
"insert soft WS.WS.SYS_DAV_RES_TYPES (T_TYPE,T_EXT) values (m_ident, dflt_ext);\n"
"}\n"
"--src dav_api.sql:5712\n";

static const char *proc183 = 
"create procedure\n"
"DAV_REGISTER_MIME_RDF (in m_ident varchar, in schema_uri varchar)\n"
"{\n"
"insert replacing WS.WS.SYS_MIME_RDFS (MR_MIME_IDENT, MR_RDF_URI, MR_DEPRECATED)\n"
"values (m_ident, schema_uri, 0);\n"
"}\n"
"--src dav_api.sql:5735\n";

static const char *proc184 = 
"create procedure\n"
"DAV_DEPRECATE_MIME_RDF (in m_ident varchar, in schema_uri varchar)\n"
"{\n"
"update WS.WS.SYS_MIME_RDFS set MR_DEPRECATED = 1 where MR_MIME_IDENT = m_ident and MR_RDF_URI = schema_uri;\n"
"}\n"
"--src dav_api.sql:5743\n";

static const char *proc185 = 
" create function\n"
"DAV_RDF_PROP_SET (\n"
"in path varchar,\n"
"in single_schema varchar,\n"
"in rdf any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null) returns integer\n"
"{\n"
"return DAV_RDF_PROP_SET_INT (path, single_schema, rdf, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:5751\n";

static const char *proc186 = 
" create procedure\n"
"DAV_RDF_PROP_GET (\n"
"in path varchar,\n"
"in single_schema varchar,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null) returns any\n"
"{\n"
"declare st varchar;\n"
"if ((path <> \'\') and (path[length(path)-1] = 47))\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"return DAV_RDF_PROP_GET_INT (DAV_SEARCH_ID (path, st), st, single_schema, 1, auth_uname, auth_pwd);\n"
"}\n"
"--src dav_api.sql:5765\n";

static const char *proc187 = 
"create function\n"
"DAV_RDF_PREPROCESS_RDFXML_SUB (inout n3_subj_dict any, in main_res nvarchar, in mode integer, inout firsttime_subj_list any) returns any\n"
"{\n"
"\n"
"declare top_props, top_acc, top_head, top_tag any;\n"
"declare firsttime_use integer;\n"
"declare isdupe varchar;\n"
"top_props := dict_get (n3_subj_dict, main_res, 0);\n"
"xte_nodebld_init (top_acc);\n"
"firsttime_use := position (main_res, firsttime_subj_list);\n"
"if (firsttime_use > 0)\n"
"{\n"
"firsttime_subj_list [firsttime_use-1] := \'\';\n"
"isdupe := null;\n"
"}\n"
"else\n"
"isdupe := \'Y\';\n"
"if (mode = 2)\n"
"top_tag := UNAME\'virt:top-res\';\n"
"else\n"
"top_tag := UNAME\'virt:res\';\n"
"if (main_res like N\'nodeID://%\')\n"
"{\n"
"top_head := xte_head (top_tag, UNAME\'N3S\', main_res, UNAME\'N3DUPE\', isdupe);\n"
"}\n"
"else\n"
"{\n"
"top_head := xte_head (top_tag, UNAME\'N3DUPE\', isdupe);\n"
"xte_nodebld_acc (top_acc, xte_node (xte_head (main_res)));\n"
"}\n"
"if (not (isinteger (top_props)))\n"
"{\n"
"if (isinteger (top_props[0]))\n"
"{\n"
"vectorbld_final (top_props);\n"
"dict_put (n3_subj_dict, main_res, top_props);\n"
"}\n"
"foreach (any n3 in top_props) do\n"
"{\n"
"declare obj_res nvarchar;\n"
"declare obj_subtree any;\n"
"obj_res := xpath_eval (\'@N3O\', n3);\n"
"if (obj_res is null)\n"
"{\n"
"obj_subtree := xte_node (\n"
"xte_head ( UNAME\'virt:value\',\n"
"UNAME\'N3DT\', xpath_eval (\'@N3DT\', n3),\n"
"UNAME\'xml:lang\', xpath_eval (\'@xml:lang\', n3)),\n"
"xpath_eval (\'node()\', n3) );\n"
"}\n"
"else if (not (obj_res like N\'nodeID://%\'))\n"
"obj_subtree := xte_node (xte_head (UNAME\'virt:res\'), xte_node (xte_head (obj_res)));\n"
"else if (mode > 0)\n"
"obj_subtree := DAV_RDF_PREPROCESS_RDFXML_SUB (n3_subj_dict, obj_res, 0, firsttime_subj_list);\n"
"else\n"
"obj_subtree := xte_node (xte_head (UNAME\'virt:res\', UNAME\'N3S\', obj_res));\n"
"xte_nodebld_acc (top_acc,\n"
"xte_node (\n"
"xte_head (UNAME\'virt:prop\', UNAME\'N3ID\', xpath_eval(\'@N3ID\', n3)),\n"
"xte_node (xte_head (xpath_eval (\'@N3P\', n3))),\n"
"obj_subtree ) );\n"
"}\n"
"}\n"
"xte_nodebld_final (top_acc, top_head);\n"
"return top_acc;\n"
"}\n"
"--src dav_api.sql:5782\n";

static const char *proc188 = 
"create function\n"
"DAV_RDF_PREPROCESS_RDFXML (in rdfxml any, in main_res nvarchar, in already_n3 integer := 0)\n"
"{\n"
"declare n3xml, n3_list, n3_subj_dict, rdf_acc, subj_list, firsttime_subj_list any;\n"
"declare tmp varchar;\n"
"if (already_n3)\n"
"n3xml := rdfxml;\n"
"else\n"
"n3xml := xslt (\'http://local.virt/rdfxml2n3xml\', rdfxml);\n"
"n3_subj_dict := dict_new ();\n"
"n3_list := xpath_eval (\'/N3\', n3xml, 0);\n"
"foreach (any n3 in n3_list) do\n"
"{\n"
"declare pred_acc any;\n"
"declare subj varchar;\n"
"subj := xpath_eval (\'@N3S\', n3);\n"
"pred_acc := dict_get (n3_subj_dict, subj, 0);\n"
"if (isinteger (pred_acc))\n"
"vectorbld_init (pred_acc);\n"
"vectorbld_acc (pred_acc, n3);\n"
"dict_put (n3_subj_dict, subj, pred_acc);\n"
"}\n"
"subj_list := dict_list_keys (n3_subj_dict, 0);\n"
"firsttime_subj_list := subj_list;\n"
"xte_nodebld_init (rdf_acc);\n"
"xte_nodebld_acc (rdf_acc, DAV_RDF_PREPROCESS_RDFXML_SUB (n3_subj_dict, main_res, 2, firsttime_subj_list));\n"
"\n"
"foreach (nvarchar subj in subj_list) do\n"
"{\n"
"if ((subj <> main_res) and not (subj like N\'nodeID://%\'))\n"
"{\n"
"xte_nodebld_acc (rdf_acc, DAV_RDF_PREPROCESS_RDFXML_SUB (n3_subj_dict, subj, 1, firsttime_subj_list));\n"
"}\n"
"}\n"
"\n"
"foreach (nvarchar subj in subj_list) do\n"
"{\n"
"declare subj_props any;\n"
"subj_props := dict_get (n3_subj_dict, subj, 0);\n"
"if (isinteger (subj_props[0]))\n"
"xte_nodebld_acc (rdf_acc, DAV_RDF_PREPROCESS_RDFXML_SUB (n3_subj_dict, subj, 0, firsttime_subj_list));\n"
"}\n"
"xte_nodebld_final (rdf_acc, xte_head (UNAME\'virt:rdf\'));\n"
"return rdf_acc;\n"
"}\n"
"--src dav_api.sql:5851\n";

static const char *proc189 = 
"create function\n"
"DAV_RDF_PROP_SET_INT (\n"
"in path varchar,\n"
"in single_schema varchar,\n"
"in rdf any,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in extern integer := 1,\n"
"in check_locks any := 1,\n"
"in overwrite integer := 0,\n"
"in auth_uid integer := null\n"
") returns integer\n"
"{\n"
"declare n3xml, davtree any;\n"
"declare top_subj nvarchar;\n"
"if (single_schema is null)\n"
"return -20;\n"
"n3xml := xslt (\'http://local.virt/rdfxml2n3xml\', rdf);\n"
"top_subj := null;\n"
"if (xpath_eval (\'/N3[@N3S=\\044path]\', n3xml, 1, vector (UNAME\'path\', path)) is null)\n"
"top_subj := coalesce (xpath_eval (\'/N3[1]/@N3S\', n3xml), cast (path as nvarchar));\n"
"else\n"
"top_subj := cast (path as nvarchar);\n"
"davtree := DAV_RDF_PREPROCESS_RDFXML (n3xml, top_subj, 1);\n"
"return DAV_PROP_SET_INT (path, single_schema, davtree, auth_uname, auth_pwd, extern, check_locks, overwrite, auth_uid);\n"
"}\n"
"--src dav_api.sql:5899\n";

static const char *proc190 = 
"create procedure\n"
"DAV_RDF_PROP_GET_INT (\n"
"in id any,\n"
"in what char(0),\n"
"in single_schema varchar,\n"
"in extern integer := 1,\n"
"in auth_uname varchar := null,\n"
"in auth_pwd varchar := null,\n"
"in auth_uid integer := null ) returns any\n"
"{\n"
"declare davtree any;\n"
"davtree := DAV_PROP_GET_INT (id, what, single_schema, extern, auth_uname, auth_pwd, auth_uid);\n"
"if (isinteger (davtree))\n"
"return davtree;\n"
"if (isentity (davtree))\n"
"return davtree;\n"
"davtree := xml_tree_doc (deserialize (davtree));\n"
"return davtree;\n"
"}\n"
"--src dav_api.sql:5928\n";

static const char *proc191 = 
"create function DAV_RDF_MERGE (\n"
"in old_n3 any,\n"
"in patch_n3 any,\n"
"in sch_n3 any,\n"
"in wipe_old_lists integer\n"
") returns any\n"
"{\n"
"declare n3_tmp_list, new_dict, card_dict, merge_acc any;\n"
"if (old_n3 is null)\n"
"return patch_n3;\n"
"if (patch_n3 is null)\n"
"return old_n3;\n"
"card_dict := dict_new ();\n"
"if (sch_n3 is not null)\n"
"{\n"
"n3_tmp_list := xpath_eval (\'/N3[@N3P=\"http://local.virt/rdf#cardinality\"]\', sch_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"dict_put (card_dict, xpath_eval (\'@N3S\', n3), cast (n3 as varchar));\n"
"}\n"
"new_dict := dict_new ();\n"
"n3_tmp_list := xpath_eval (\'/N3\', patch_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"declare dkey, dacc any;\n"
"dkey := xpath_eval (\'vector (string (@N3S), string (@N3P), string(@xml:lang))\', n3);\n"
"dacc := dict_get (new_dict, dkey);\n"
"if (dacc is null)\n"
"vectorbld_init (dacc);\n"
"vectorbld_acc (dacc, n3);\n"
"dict_put (new_dict, dkey, dacc);\n"
"}\n"
"xte_nodebld_init (merge_acc);\n"
"n3_tmp_list := xpath_eval (\'/N3\', old_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"declare pred, card nvarchar;\n"
"declare dkey, new_set any;\n"
"declare stale, is_single integer;\n"
"dkey := xpath_eval (\'vector (string (@N3S), string (@N3P), string(@xml:lang))\', n3);\n"
"pred := xpath_eval (\'string (@N3P)\', n3);\n"
"card := dict_get (card_dict, pred);\n"
"new_set := dict_get (new_dict, dkey);\n"
"stale := 0;\n"
"if (N\'single\' = card)\n"
"is_single := 1;\n"
"else if (N\'list\' = card)\n"
"is_single := 0;\n"
"else\n"
"is_single := xpath_eval (\'not (exists (@N3O))\', n3);\n"
"if (is_single)\n"
"{\n"
"if (new_set is not null)\n"
"stale := 10;\n"
"}\n"
"else\n"
"{\n"
"if (wipe_old_lists > 0)\n"
"stale := 11;\n"
"else if (new_set is not null)\n"
"{\n"
"if (wipe_old_lists = 0)\n"
"stale := 12;\n"
"else\n"
"{\n"
"declare ctr integer;\n"
"for (ctr := new_set[0]; (ctr > 0) and not stale; ctr := ctr - 1)\n"
"{\n"
"if (xpath_eval (\'deep-equal (., \\044old)\', new_set[ctr], 1, vector (\'old\', n3)))\n"
"stale := 13;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (not stale)\n"
"xte_nodebld_acc (merge_acc, n3);\n"
"}\n"
"n3_tmp_list := xpath_eval (\'/N3\', patch_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"xte_nodebld_acc (merge_acc, n3);\n"
"}\n"
"xte_nodebld_final (merge_acc, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (merge_acc);\n"
"}\n"
"--src dav_api.sql:5950\n";

static const char *proc192 = 
"create function DAV_RDF_SUBTRACT (\n"
"in old_n3 any,\n"
"in sub_n3 any\n"
") returns any\n"
"{\n"
"declare n3_tmp_list, sub_dict, res_acc any;\n"
"sub_dict := dict_new ();\n"
"n3_tmp_list := xpath_eval (\'/N3\', sub_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"declare dkey, dacc any;\n"
"dkey := xpath_eval (\'vector (string (@N3S), string (@N3P), string (@N3O), string(@xml:lang))\', n3);\n"
"dacc := dict_get (sub_dict, dkey);\n"
"if (dacc is null)\n"
"vectorbld_init (dacc);\n"
"vectorbld_acc (dacc, xpath_eval(\'node()[1]\', n3));\n"
"dict_put (sub_dict, dkey, dacc);\n"
"}\n"
"xte_nodebld_init (res_acc);\n"
"n3_tmp_list := xpath_eval (\'/N3\', old_n3, 0);\n"
"foreach (any n3 in n3_tmp_list) do\n"
"{\n"
"declare pred, card nvarchar;\n"
"declare dkey, sub_set any;\n"
"declare stale integer;\n"
"dkey := xpath_eval (\'vector (string (@N3S), string (@N3P), string (@N3O), string(@xml:lang))\', n3);\n"
"sub_set := dict_get (sub_dict, dkey);\n"
"stale := 0;\n"
"if (sub_set is not null)\n"
"{\n"
"declare obj_val any;\n"
"declare ctr integer;\n"
"obj_val := xpath_eval(\'node()[1]\', n3);\n"
"for (ctr := sub_set[0]; (ctr > 0) and not stale; ctr := ctr - 1)\n"
"{\n"
"if (xpath_eval (\'deep-equal (., \\044old)\', sub_set[ctr], 1, vector (\'old\', obj_val)))\n"
"stale := 13;\n"
"}\n"
"}\n"
"\n"
"if (not stale)\n"
"xte_nodebld_acc (res_acc, n3);\n"
"}\n"
"xte_nodebld_final (res_acc, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res_acc);\n"
"}\n"
"--src dav_api.sql:6038\n";

static const char *trig19 = 
"create trigger SYS_DAV_RES_CONTENT_EXTRACT_RDF_I after insert on WS.WS.SYS_DAV_RES order 20 referencing new as NEWR\n"
"{\n"
"whenever sqlstate \'*\' goto no_op;\n"
"\n"
"if (length (NEWR.RES_PERMS) < 11)\n"
"goto no_op;\n"
"if (not (NEWR.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\'))))\n"
"goto no_op;\n"
"DAV_EXTRACT_AND_SAVE_RDF_INT (NEWR.RES_ID, NEWR.RES_NAME, NEWR.RES_TYPE, NEWR.RES_CONTENT);\n"
"no_op:\n"
"\n"
" ;\n"
"}\n"
"--src dav_api.sql:6087\n";

static const char *trig20 = 
"create trigger SYS_DAV_RES_CONTENT_EXTRACT_RDF_U1 after update (RES_ID, RES_NAME, RES_TYPE, RES_PERMS) on WS.WS.SYS_DAV_RES order 20 referencing new as NEWR, old as OLDR\n"
"{\n"
"\n"
"if (length (NEWR.RES_PERMS) < 11)\n"
"goto no_op;\n"
"if (not (NEWR.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\'))))\n"
"goto no_op;\n"
"if ((OLDR.RES_ID <> NEWR.RES_ID) or (OLDR.RES_TYPE <> NEWR.RES_TYPE))\n"
"goto ignore_old_res_perms;\n"
"if ((OLDR.RES_NAME <> NEWR.RES_NAME) and (DAV_GUESS_MIME_TYPE_BY_NAME (OLDR.RES_NAME) <> DAV_GUESS_MIME_TYPE_BY_NAME (NEWR.RES_NAME)))\n"
"goto ignore_old_res_perms;\n"
"if ((length (OLDR.RES_PERMS) >= 11) and (OLDR.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\'))))\n"
"goto no_op;\n"
"ignore_old_res_perms:\n"
"whenever sqlstate \'*\' goto no_op;\n"
"DAV_EXTRACT_AND_SAVE_RDF_INT (NEWR.RES_ID, NEWR.RES_NAME, NEWR.RES_TYPE, NEWR.RES_CONTENT);\n"
"no_op:\n"
"\n"
" ;\n"
"}\n"
"--src dav_api.sql:6102\n";

static const char *trig21 = 
"create trigger SYS_DAV_RES_CONTENT_EXTRACT_RDF_U2 after update (RES_ID, RES_NAME, RES_TYPE, RES_CONTENT) on WS.WS.SYS_DAV_RES order 21 referencing new as NEWR, old as OLDR\n"
"{\n"
"\n"
"if (length (NEWR.RES_PERMS) < 11)\n"
"goto no_op;\n"
"if (not (NEWR.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\'))))\n"
"goto no_op;\n"
"if ((OLDR.RES_ID <> NEWR.RES_ID) or (OLDR.RES_TYPE <> NEWR.RES_TYPE))\n"
"goto no_op;\n"
"if ((OLDR.RES_NAME <> NEWR.RES_NAME) and (DAV_GUESS_MIME_TYPE_BY_NAME (OLDR.RES_NAME) <> DAV_GUESS_MIME_TYPE_BY_NAME (NEWR.RES_NAME)))\n"
"goto no_op;\n"
"if (not ((length (OLDR.RES_PERMS) >= 11) and (OLDR.RES_PERMS[10] in (ascii (\'R\'), ascii (\'M\')))))\n"
"goto no_op;\n"
"whenever sqlstate \'*\' goto no_op;\n"
"DAV_EXTRACT_AND_SAVE_RDF_INT (NEWR.RES_ID, NEWR.RES_NAME, NEWR.RES_TYPE, NEWR.RES_CONTENT);\n"
"no_op:\n"
"\n"
" ;\n"
"}\n"
"--src dav_api.sql:6124\n";

static const char *proc193 = 
"create procedure DAV_EXTRACT_AND_SAVE_RDF (in resid integer)\n"
"{\n"
"declare resname, restype varchar;\n"
"declare rescontent any;\n"
"\n"
"select RES_NAME, RES_TYPE, RES_CONTENT into resname, restype, rescontent from WS.WS.SYS_DAV_RES where RES_ID = resid;\n"
"DAV_EXTRACT_AND_SAVE_RDF_INT (resid, resname, restype, rescontent);\n"
"\n"
"}\n"
"--src dav_api.sql:6145\n";

static const char *proc194 = 
"create procedure DAV_GET_RES_TYPE_URI_BY_MIME_TYPE(in mime_type varchar) returns varchar\n"
"{\n"
"if (mime_type = \'application/bpel+xml\')\n"
"return \'http://www.openlinksw.com/schemas/WSDL#\';\n"
"if (mime_type = \'application/doap+rdf\')\n"
"return \'http://www.openlinksw.com/schemas/doap#\';\n"
"if (mime_type = \'application/foaf+xml\')\n"
"return \'http://xmlns.com/foaf/0.1/\';\n"
"\n"
"\n"
"if (mime_type = \'application/google-base+xml\')\n"
"return \'http://www.openlinksw.com/schemas/google-base#\';\n"
"if (mime_type = \'application/license\')\n"
"return \'http://www.openlinksw.com/schemas/OplLic#\';\n"
"if (mime_type = \'application/mods+xml\')\n"
"return \'http://www.openlinksw.com/schemas/MODS#\';\n"
"if (mime_type = \'application/msexcel\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"if (mime_type = \'application/mspowerpoint\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"if (mime_type = \'application/msproject\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"if (mime_type = \'application/msword\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"if (mime_type = \'application/msword+xml\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"if (mime_type = \'application/opml+xml\')\n"
"return \'http://www.openlinksw.com/schemas/OPML#\';\n"
"if (mime_type = \'application/pdf\')\n"
"return \'http://www.openlinksw.com/schemas/Office#\';\n"
"if (mime_type = \'application/rdf+xml\')\n"
"return \'http://www.openlinksw.com/schemas/RDF#\';\n"
"if (mime_type = \'application/rss+xml\')\n"
"return \'http://purl.org/rss/1.0/\';\n"
"if (mime_type = \'application/wsdl+xml\')\n"
"return \'http://www.openlinksw.com/schemas/WSDL#\';\n"
"if (mime_type = \'application/x-openlink-image\')\n"
"return \'http://www.openlinksw.com/schemas/Image#\';\n"
"if (mime_type = \'application/x-openlink-photo\')\n"
"return \'http://www.openlinksw.com/schemas/Photo#\';\n"
"if (mime_type = \'application/x-openlinksw-vad\')\n"
"return \'http://www.openlinksw.com/schemas/VAD#\';\n"
"if (mime_type = \'application/x-openlinksw-vsp\')\n"
"return \'http://www.openlinksw.com/schemas/VSPX#\';\n"
"if (mime_type = \'application/x-openlinksw-vspx+xml\')\n"
"return \'http://www.openlinksw.com/schemas/VSPX#\';\n"
"if (mime_type = \'application/xbel+xml\')\n"
"return \'http://www.python.org/topics/xml/xbel/\';\n"
"if (mime_type = \'application/xbrl+xml\')\n"
"return \'http://www.openlinksw.com/schemas/xbrl#\';\n"
"if (mime_type = \'application/xddl+xml\')\n"
"return \'http://www.openlinksw.com/schemas/XDDL#\';\n"
"if (mime_type = \'application/zip\')\n"
"return \'http://www.openlinksw.com/schemas/Archive#\';\n"
"if (mime_type = \'text/directory\')\n"
"return \'http://www.w3.org/2001/vcard-rdf/3.0#\';\n"
"if (mime_type = \'text/eml\')\n"
"return \'http://www.openlinksw.com/schemas/Email#\';\n"
"if (mime_type = \'text/html\')\n"
"return \'http://www.openlinksw.com/schemas/XHTML#\';\n"
"if (mime_type = \'text/wiki\')\n"
"return \'http://www.openlinksw.com/schemas/Wiki#\';\n"
"}\n"
"--src dav_api.sql:6156\n";

static const char *proc195 = 
"create procedure DAV_EXTRACT_AND_SAVE_RDF_INT (inout resid integer, inout resname varchar, in restype varchar, inout _rescontent any)\n"
"{\n"
"declare resttype, res_type_uri, full_name varchar;\n"
"declare old_prop_id integer;\n"
"declare html_start, full_xml, type_tree any;\n"
"declare old_n3, addon_n3, spotlight_addon_n3 any;\n"
"declare rescontent any;\n"
"rescontent := subseq (_rescontent, 0, 10000000-1);\n"
"\n"
"html_start := null;\n"
"full_xml := null;\n"
"spotlight_addon_n3 := null;\n"
"addon_n3 := null;\n"
"\n"
"restype := DAV_GUESS_MIME_TYPE (resname, rescontent, html_start);\n"
"\n"
"if (restype is not null)\n"
"{\n"
"declare p_name varchar;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"goto addon_n3_set;\n"
"};\n"
"select RES_FULL_PATH into full_name from WS.WS.SYS_DAV_RES where RES_ID = resid;\n"
"if (full_name is null)\n"
"full_name := resname;\n"
"p_name := \'DB.DBA.DAV_EXTRACT_RDF_\' || restype;\n"
"if (__proc_exists (p_name) is not null)\n"
"{\n"
"addon_n3 := call (p_name) (full_name, rescontent, html_start);\n"
"res_type_uri := DAV_GET_RES_TYPE_URI_BY_MIME_TYPE(restype);\n"
"type_tree := xtree_doc (\'<N3 N3S=\"http://local.virt/this\" N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\" N3O=\"\' ||\n"
"res_type_uri || \'\"/>\' );\n"
"addon_n3 := DAV_RDF_MERGE (addon_n3, type_tree, null, 0);\n"
"}\n"
"\n"
"addon_n3_set: ;\n"
"}\n"
"\n"
"if (__proc_exists (\'SPOTLIGHT_METADATA\',2) is not null)\n"
"spotlight_addon_n3 := DAV_EXTRACT_SPOTLIGHT (resname, rescontent);\n"
"\n"
"if (addon_n3 is null and spotlight_addon_n3 is null)\n"
"goto no_op;\n"
"whenever not found goto no_old;\n"
"select xml_tree_doc (deserialize (blob_to_string (PROP_VALUE))), PROP_ID\n"
"into old_n3, old_prop_id\n"
"from WS.WS.SYS_DAV_PROP\n"
"where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = resid;\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', old_n3);\n"
"\n"
"if (addon_n3 is not null)\n"
"old_n3 := DAV_RDF_MERGE (old_n3, addon_n3, null, 0);\n"
"if (spotlight_addon_n3 is not null)\n"
"old_n3 := DAV_RDF_MERGE (old_n3, spotlight_addon_n3, null, 0);\n"
"\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = serialize (DAV_RDF_PREPROCESS_RDFXML (old_n3, N\'http://local.virt/this\', 1))\n"
"where PROP_ID = old_prop_id;\n"
"goto no_op;\n"
"\n"
"no_old:\n"
"if (spotlight_addon_n3 is not null)\n"
"{\n"
"if (addon_n3 is not null)\n"
"addon_n3 := DAV_RDF_MERGE (addon_n3, spotlight_addon_n3, null, 0);\n"
"else\n"
"addon_n3 := spotlight_addon_n3;\n"
"}\n"
"\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_TYPE, PROP_PARENT_ID, PROP_VALUE)\n"
"values\n"
"(WS.WS.GETID (\'P\'), \'http://local.virt/DAV-RDF\', \'R\', resid,\n"
"serialize (DAV_RDF_PREPROCESS_RDFXML (addon_n3, N\'http://local.virt/this\', 1)) );\n"
"goto no_op;\n"
"\n"
"no_op:\n"
"\n"
" ;\n"
"}\n"
"--src dav_api.sql:6222\n";

static const char *proc196 = 
"create function\n"
"DAV_HOME_DIR_UPDATE ()\n"
"{\n"
"if (isstring (registry_get (\'DAV_HOME_DIR_UPDATE\')))\n"
"return;\n"
"for (select U_NAME from SYS_USERS where U_DAV_ENABLE = 1 and U_IS_ROLE = 0 and U_NAME <> \'nobody\') do\n"
"DAV_HOME_DIR_CREATE (U_NAME);\n"
"registry_set (\'DAV_HOME_DIR_UPDATE\', \'done\');\n"
"}\n"
"--src dav_api.sql:6304\n";


static const char *other0 = 
" DAV_HOME_DIR_UPDATE ()\n";
/* dav_meta.sql */

static const char *proc197 = 
"create function DAV_GUESS_MIME_TYPE_BY_NAME (in orig_res_name varchar) returns varchar\n"
"{\n"
"declare dot_pos integer;\n"
"declare orig_res_ext, orig_res_ext_upper varchar;\n"
"\n"
"dot_pos := strrchr (orig_res_name, \'.\');\n"
"if (dot_pos is null or (0 = dot_pos))\n"
"return null;\n"
"else\n"
"orig_res_ext := subseq (orig_res_name, dot_pos);\n"
"orig_res_ext_upper := upper (orig_res_ext);\n"
"if (position (orig_res_ext_upper, vector (\'.EML\')))\n"
"return \'text/eml\';\n"
"if (position (orig_res_ext_upper, vector (\'.ODT\')))\n"
"return \'application/vnd.oasis.opendocument.text\';\n"
"if (position (orig_res_ext_upper, vector (\'.ODB\')))\n"
"return \'application/vnd.oasis.opendocument.database\';\n"
"if (position (orig_res_ext_upper, vector (\'.ODG\')))\n"
"return \'application/vnd.oasis.opendocument.graphics\';\n"
"if (position (orig_res_ext_upper, vector (\'.ODP\')))\n"
"return \'application/vnd.oasis.opendocument.presentation\';\n"
"if (position (orig_res_ext_upper, vector (\'.ODS\')))\n"
"return \'application/vnd.oasis.opendocument.spreadsheet\';\n"
"if (position (orig_res_ext_upper, vector (\'.ODC\')))\n"
"return \'application/vnd.oasis.opendocument.chart\';\n"
"if (position (orig_res_ext_upper, vector (\'.ODF\')))\n"
"return \'application/vnd.oasis.opendocument.formula\';\n"
"if (position (orig_res_ext_upper, vector (\'.ODI\')))\n"
"return \'application/vnd.oasis.opendocument.image\';\n"
"if (position (orig_res_ext_upper, vector (\'.HTM\', \'.HTML\', \'.XHTML\')))\n"
"return \'text/html\';\n"
"if (position (orig_res_ext_upper, vector (\'.XSL\', \'.XSLT\', \'.XSD\')))\n"
"return \'application/xml\';\n"
"if (position (orig_res_ext_upper, vector (\'.VCARD\', \'.VCF\', \'.ICAL\', \'.ICS\')))\n"
"return \'text/directory\';\n"
"if (position (orig_res_ext_upper, vector (\'.DTD\')))\n"
"return \'application/xml-dtd\';\n"
"if (position (orig_res_ext_upper, vector (\'.VAD\')))\n"
"return \'application/x-openlinksw-vad\';\n"
"if (position (orig_res_ext_upper, vector (\'.VSP\')))\n"
"return \'application/x-openlinksw-vsp\';\n"
"if (position (orig_res_ext_upper, vector (\'.LIC\')))\n"
"return \'application/x-openlink-license\';\n"
"if (position (orig_res_ext_upper, vector (\'.XBRL\')))\n"
"return \'application/xbrl+xml\';\n"
"if (position (orig_res_ext_upper, vector (\'.TXT\')) and\n"
"connection_get (\'oWiki Topic\') is not null and\n"
"connection_get (\'oWiki Topic\') = orig_res_name)\n"
"return \'text/wiki\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.BMP\', \'.DIB\', \'.RLE\', \'.CR2\', \'.CRW\', \'.EMF\', \'.EPS\', \'.IFF\', \'.LBM\', \'.JP2\', \'.JPX\', \'.JPK\', \'.J2K\',\n"
"\'.JPC\', \'.J2C\', \'.JPE\', \'.JIF\', \'.JFIF\', \'.JPG\', \'.JPEG\', \'.GIF\', \'.PNG\') ) )\n"
"return \'application/x-openlink-image\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.XML\', \'.RDF\', \'.RDFS\', \'.RSS\', \'.RSS2\', \'.XBEL\', \'.FOAF\', \'.OPML\', \'.WSDL\', \'.BPEL\', \'.VSPX\', \'.VSCX\', \'.XDDL\', \'.OCS\') ) )\n"
"return \'text/xml\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.TAR\') ) )\n"
"return \'application/tar\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.TAZ\') ) )\n"
"return \'application/taz\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.GZ\') ) )\n"
"return \'application/gz\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.MSI\') ) )\n"
"return \'application/msi\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.DMG\') ) )\n"
"return \'application/dmg\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.ARJ\') ) )\n"
"return \'application/arj\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.BZ\') ) )\n"
"return \'application/bz\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.BZ2\') ) )\n"
"return \'application/bz2\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.TGZ\') ) )\n"
"return \'application/tgz\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.RAR\') ) )\n"
"return \'application/rar\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.ZIP\') ) )\n"
"return \'application/zip\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.CAB\') ) )\n"
"return \'application/cab\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.LZH\') ) )\n"
"return \'application/lzh\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.ACE\') ) )\n"
"return \'application/ace\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.ISO\') ) )\n"
"return \'application/iso\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.TTL\') ) )\n"
"return \'text/rdf+ttl\';\n"
"if (position (orig_res_ext_upper,\n"
"vector (\'.N3\') ) )\n"
"return \'text/rdf+n3\';\n"
"return coalesce ((select T_TYPE from WS.WS.SYS_DAV_RES_TYPES where T_EXT = lower (subseq (orig_res_ext, 1))));\n"
"}\n"
"--src dav_meta.sql:22\n";

static const char *proc198 = 
"create function DAV_GUESS_MIME_TYPE (in orig_res_name varchar, inout content any, inout html_start any) returns varchar\n"
"{\n"
"declare content_len integer;\n"
"declare dflt_ret varchar;\n"
"\n"
"whenever sqlstate \'*\' goto no_op;\n"
"content_len := length (content);\n"
"if (__tag (content) in (125, 126, 132, 133))\n"
"{\n"
"declare beginning varchar;\n"
"if (content_len < 10000000)\n"
"beginning := blob_to_string (content);\n"
"else\n"
"beginning := null;\n"
"return DAV_GUESS_MIME_TYPE (orig_res_name, beginning, html_start);\n"
"}\n"
"dflt_ret := DAV_GUESS_MIME_TYPE_BY_NAME (orig_res_name);\n"
"if (\'text/xml\' = dflt_ret)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"return dflt_ret;\n"
"};\n"
"if (content is null)\n"
"return \'text/xml\';\n"
"if (html_start = 0)\n"
"html_start := null;\n"
"if (html_start is null)\n"
"{\n"
"if (230 = __tag (content))\n"
"html_start := content;\n"
"else\n"
"{\n"
"declare frag_len, min_frag_len, max_frag_len integer;\n"
"max_frag_len := length (content);\n"
"if (max_frag_len > 30000)\n"
"{\n"
"max_frag_len := 30000;\n"
"min_frag_len := 20000;\n"
"}\n"
"else\n"
"min_frag_len := max_frag_len;\n"
"for (frag_len := max_frag_len; (frag_len >= min_frag_len) and (html_start is null); frag_len := frag_len - 1000)\n"
"{\n"
"html_start := xtree_doc (subseq (content, 0, frag_len), 18, \'http://localdav.virt/\' || orig_res_name, \'LATIN-1\', \'x-any\',\n"
"\'Validation=DISABLE Include=DISABLE BuildStandalone=DISABLE SchemaDecl=DISABLE\' );\n"
"}\n"
"}\n"
"}\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:bm=\"http://www.w3.org/2002/01/bookmark#\"] exists (/rdf:rdf/bm:bookmark)\', html_start))\n"
"return \'application/annotea+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://usefulinc.com/ns/doap#\"] exists (/project)\', html_start) or\n"
"xpath_eval (\'[xmlns:rdf = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns=\"http://usefulinc.com/ns/doap#\"] exists (/rdf:rdf/project)\', html_start))\n"
"return \'application/doap+rdf\';\n"
"if (xpath_eval (\'[xmlns:atom=\"http://purl.org/atom/ns#\"] exists (/atom:feed[@version])\', html_start) or\n"
"xpath_eval (\'[xmlns:atom=\"http://www.w3.org/2005/Atom\"]exists (/atom:feed)\', html_start))\n"
"return \'application/atom+xml\';\n"
"if (xpath_eval (\'[xmlns:w=\"http://schemas.microsoft.com/office/word/2003/wordml\"] exists (/w:worddocument)\', html_start))\n"
"return \'application/msword+xml\';\n"
"if (xpath_eval (\'[xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"] exists (/Workbook)\', html_start))\n"
"return \'application/msexcel+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://schemas.microsoft.com/project\"] exists (/Project)\', html_start))\n"
"return \'application/msproject+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://schemas.microsoft.com/visio/2003/core\"] exists (/VisioDocument)\', html_start))\n"
"return \'application/msvisio+xml\';\n"
"if (xpath_eval (\'[xmlns:n0=\"rdf\" xmlns:n2=\"foaf\"] exists (//n2:person)\', html_start) or xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:foaf=\"http://xmlns.com/foaf/0.1/\"]exists (/rdf:rdf/foaf:*)\', html_start))\n"
"return \'application/foaf+xml\';\n"
"if (xpath_eval (\'exists (/xbel)\', html_start))\n"
"return \'application/xbel+xml\';\n"
"if (xpath_eval (\'exists (/database)\', html_start))\n"
"return \'application/xddl+xml\';\n"
"\n"
"if (xpath_eval (\'exists (/modscollection|/mods)\', html_start))\n"
"return \'application/mods+xml\';\n"
"if (xpath_eval (\'exists (/opml[@version])\', html_start))\n"
"return \'application/opml+xml\';\n"
"if (xpath_eval (\'[xmlns:rdf = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:ocs = \"http://InternetAlchemy.org/ocs/directory#\" xmlns:dc = \"http://purl.org/metadata/dublin_core#\"] exists (/rdf:rdf/rdf:description/dc:title)\', html_start))\n"
"return \'application/ocs+xml\';\n"
"if (xpath_eval (\'[xmlns:rdf = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc  = \"http://purl.org/metadata/dublin_core#\" xmlns = \"http://purl.org/ocs/directory/0.5/#\"] exists (/rdf:rdf/directory)\', html_start))\n"
"return \'application/ocs+xml\';\n"
"\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rss=\"http://purl.org/rss/1.0/\"]exists (/rdf:rdf/rss:channel)\', html_start))\n"
"return \'application/rss+xml\';\n"
"if (xpath_eval (\'exists (/rss[@version])\', html_start))\n"
"return \'application/rss+xml\';\n"
"if (xpath_eval (\'[xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"]exists (/wsdl:definitions)\', html_start))\n"
"return \'application/wsdl+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://www.w3.org/2005/Atom\" xmlns:gm=\"http://base.google.com/ns-metadata/1.0\"] exists (/entry)\', html_start))\n"
"return \'application/google-base+xml\';\n"
"if (xpath_eval (\'[xmlns:bpel=\"http://schemas.xmlsoap.org/ws/2003/03/business-process/\"]exists (/bpel:process)\', html_start))\n"
"return \'application/bpel+xml\';\n"
"if (xpath_eval (\'[xmlns:v=\"http://www.openlinksw.com/vspx/\"]exists (/v:*|//v:page)\', html_start))\n"
"return \'application/x-openlinksw-vspx+xml\';\n"
"if (xpath_eval (\'[xmlns=\"http://www.xbrl.org/2003/instance\"] exists (/xbrl)\', html_start))\n"
"return \'application/xbrl+xml\';\n"
"\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"] exists(/rdf:rdf)\', html_start))\n"
"return \'application/rdf+xml\';\n"
"return dflt_ret;\n"
"}\n"
"if (dflt_ret = \'application/x-openlink-license\')\n"
"{\n"
"declare mydata, exp_date varchar;\n"
"mydata := \"asn1_to_xml\" (content, length(blob_to_string (content)));\n"
"exp_date := cast(xpath_eval(\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"ExpireDate\"]/PRINTABLESTRING[position() > 1]/text()\', xtree_doc(mydata)) as varchar);\n"
"if (exp_date is not null and exp_date <> \'\')\n"
"{\n"
"return \'application/x-openlink-license\';\n"
"}\n"
"}\n"
"if (dflt_ret = \'application/x-openlink-image\')\n"
"{\n"
"declare image_format varchar;\n"
"image_format := \"IM GetImageBlobFormat\" (content, length(blob_to_string (content)));\n"
"if (image_format is not null)\n"
"{\n"
"image_format := \"IM GetImageBlobAttribute\" (content, length(blob_to_string (content)), \'EXIF:Model\');\n"
"if (image_format is not null and image_format <> \'\' and image_format <> \'unknown\' and image_format <> \'.\')\n"
"return \'application/x-openlink-photo\';\n"
"else\n"
"return \'application/x-openlink-image\';\n"
"}\n"
"}\n"
"no_op:\n"
"return dflt_ret;\n"
"}\n"
"--src dav_meta.sql:133\n";

static const char *proc199 = 
"create procedure file_space_fmt (in d integer) returns varchar\n"
"{\n"
"declare ret float;\n"
"if (d is null or d = 0)\n"
"return \'N/A\';\n"
"if (d >= 1024 and d < 1048576)\n"
"{\n"
"ret := d/1024;\n"
"return sprintf(\'%d KB\', ret);\n"
"}\n"
"if (d >= 1048576)\n"
"{\n"
"ret := d/1024/1024;\n"
"return sprintf(\'%d MB\', ret);\n"
"}\n"
"else\n"
"return sprintf(\'%d B\', d);\n"
"}\n"
"--src dav_meta.sql:262\n";

static const char *proc200 = 
"create function \"DAV_EXTRACT_RDF_application/x-openlink-license\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare doc, metas, res, content any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"content := blob_to_string (content1);\n"
"\n"
"xte_nodebld_init(res);\n"
"declare mydata, reg_to, con_num, serial varchar;\n"
"mydata := \"asn1_to_xml\" (content, length(blob_to_string (content)));\n"
"reg_to := cast(xpath_eval(\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"RegisteredTo\"]/PRINTABLESTRING[position() > 1]/text()\', xtree_doc(mydata)) as varchar);\n"
"con_num := cast(xpath_eval(\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"NumberOfConnections\"]/PRINTABLESTRING[position() > 1]/text()\', xtree_doc(mydata)) as varchar);\n"
"serial := cast(xpath_eval(\'//SEQUENCE/SEQUENCE/SEQUENCE/SEQUENCE[PRINTABLESTRING=\"SerialNumber\"]/PRINTABLESTRING[position() > 1]/text()\', xtree_doc(mydata)) as varchar);\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/OplLic#RegisteredTo\'), reg_to));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/OplLic#ConnectionNumber\'), con_num));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/OplLic#SerialNumber\'), serial));\n"
"xte_nodebld_final(res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:282\n";

static const char *proc201 = 
"create function \"DAV_EXTRACT_RDF_opendocument\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras, res any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"\n"
"declare meta, tmp varchar;\n"
"declare xt, xd any;\n"
"if (__proc_exists (\'UNZIP_UnzipFileFromArchive\', 2) is null)\n"
"goto errexit;\n"
"tmp := tmp_file_name (\'rdfm\', \'odt\');\n"
"string_to_file (tmp, content1, -2);\n"
"meta := UNZIP_UnzipFileFromArchive (tmp, \'meta.xml\');\n"
"file_delete (tmp, 1);\n"
"meta := replace(meta, \'\\n\', \'\');\n"
"xt := xtree_doc (meta, 0);\n"
"metas := vector (\n"
"\'http://purl.org/dc/elements/1.1/date\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:date\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/language\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:language\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/creator\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:creator\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/description\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:description\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/subject\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:subject\', NULL,\n"
"\'http://purl.org/dc/elements/1.1/title\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; //dc:title\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:creation-date\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:creation-date\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:editing-cycles\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:editing-cycles\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:editing-duration\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:editing-duration\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:generator\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:generator\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:initial-creator\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:initial-creator\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:keyword\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:keyword\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:print-date\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:print-date\', NULL,\n"
"\'urn:oasis:names:tc:opendocument:xmlns:meta:1.0:printed-by\', \'declare namespace meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"; //meta:printed-by\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (xt, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:307\n";

static const char *proc202 = 
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.text\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:345\n";

static const char *proc203 = 
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.database\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:351\n";

static const char *proc204 = 
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.graphics\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:357\n";

static const char *proc205 = 
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.presentation\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:363\n";

static const char *proc206 = 
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.spreadsheet\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:368\n";

static const char *proc207 = 
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.chart\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:373\n";

static const char *proc208 = 
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.formula\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:378\n";

static const char *proc209 = 
"create function \"DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.image\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_opendocument\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:383\n";

static const char *proc210 = 
"create function \"DAV_EXTRACT_RDF_application/x-openlink-image\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare doc, metas, res, content any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"content := blob_to_string (content1);\n"
"\n"
"xte_nodebld_init(res);\n"
"declare image_size, xsize, ysize, depth integer;\n"
"declare image_format, comments, xres, yres varchar;\n"
"image_format := \"IM GetImageBlobFormat\"(content, length(content));\n"
"image_size := length(content);\n"
"xsize := \"IM GetImageBlobWidth\"(content, length(content));\n"
"ysize := \"IM GetImageBlobHeight\"(content, length(content));\n"
"xres := \"IM GetImageBlobAttribute\"(content, length(content), \'EXIF:XResolution\');\n"
"yres := \"IM GetImageBlobAttribute\"(content, length(content), \'EXIF:YResolution\');\n"
"depth := \"IM GetImageBlobDepth\"(content, length(content));\n"
"comments := \"IM GetImageBlobAttribute\"(content, length(content), \'Comment\');\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Image#type\'), image_format));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Image#size\'), file_space_fmt(image_size)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Image#dimensions\'), sprintf(\'%dx%d\', xsize, ysize)));\n"
"if (xres is not null and yres is not null)\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Image#resolutions\'), sprintf(\'%s:%s\', xres, yres)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Image#depth\'), sprintf(\'%d\', depth)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Image#comments\'), comments));\n"
"xte_nodebld_final(res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:389\n";

static const char *proc211 = 
"create function \"DAV_EXTRACT_RDF_application/x-openlink-photo\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare doc, metas, res, content any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"content := blob_to_string (content1);\n"
"\n"
"xte_nodebld_init(res);\n"
"declare image_size, xsize, ysize, depth integer;\n"
"declare image_format, comments, xres, yres varchar;\n"
"image_format := \"IM GetImageBlobFormat\"(content, length(content));\n"
"image_size := length(content);\n"
"xsize := \"IM GetImageBlobWidth\"(content, length(content));\n"
"ysize := \"IM GetImageBlobHeight\"(content, length(content));\n"
"xres := \"IM GetImageBlobAttribute\"(content, length(content), \'EXIF:XResolution\');\n"
"yres := \"IM GetImageBlobAttribute\"(content, length(content), \'EXIF:YResolution\');\n"
"depth := \"IM GetImageBlobDepth\"(content, length(content));\n"
"comments := \"IM GetImageBlobAttribute\"(content, length(content), \'Comment\');\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Photo#type\'), image_format));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Photo#size\'), file_space_fmt(image_size)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Photo#dimensions\'), sprintf(\'%dx%d\', xsize, ysize)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Photo#resolutions\'), sprintf(\'%s:%s\', xres, yres)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Photo#depth\'), sprintf(\'%d\', depth)));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Photo#comments\'), comments));\n"
"xte_nodebld_final(res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:426\n";

static const char *proc212 = 
"create function \"DAV_EXTRACT_RDF_application/audio\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare content any;\n"
"content := blob_to_string (content1);\n"
"return xml_tree_doc (audio_to_xml (content, length (content), 1));\n"
"}\n"
"--src dav_meta.sql:462\n";

static const char *proc213 = 
"create function \"DAV_EXTRACT_RDF_audio/mpeg\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:470\n";

static const char *proc214 = 
"create function \"DAV_EXTRACT_RDF_audio/x-flac\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:476\n";

static const char *proc215 = 
"create function \"DAV_EXTRACT_RDF_audio/x-mp3\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:482\n";

static const char *proc216 = 
"create function \"DAV_EXTRACT_RDF_audio/x-m4a\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:488\n";

static const char *proc217 = 
"create function \"DAV_EXTRACT_RDF_audio/x-m4p\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:494\n";

static const char *proc218 = 
"create function \"DAV_EXTRACT_RDF_application/ogg\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/audio\" (orig_res_name, content1, html_start);\n"
"}\n"
"--src dav_meta.sql:500\n";

static const char *proc219 = 
"create function \"DAV_EXTRACT_RDF_application/msoffice+xml\" (in type_descr varchar, in orig_res_name varchar, inout content any, inout html_start any, inout docprops any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"if (docprops is null)\n"
"{\n"
"doc := xtree_doc (content, 0);\n"
"docprops := xpath_eval (\'/*/*:DocumentProperties\', doc);\n"
"}\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#Title\'        , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Title\'                                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Author\'       , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Author|o:Creator\'                           , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#LastAuthor\'   , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:LastAuthor\'                                 , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Company\'      , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Company\'                                    , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Words\'        , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Words\'                                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Pages\'        , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Pages\'                                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Lines\'        , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Lines\'                                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Last-Saved\'   , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:LastSaved|o:TimeSaved\'                      , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Last-Printed\' , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:LastPrinted|o:TimePrinted\'                  , NULL,\n"
"\'http://www.openlinksw.com/schemas/Office#Created\'      , \'declare namespace o=\"urn:schemas-microsoft-com:office:office\"; o:Created|o:TimeCreated|o:CreationDate\'       , NULL );\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  type_descr );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (docprops, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:506\n";

static const char *proc220 = 
"create function \"DAV_EXTRACT_RDF_application/msexcel\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS Excel spreadsheet\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:536\n";

static const char *proc221 = 
"create function \"DAV_EXTRACT_RDF_application/msaccess\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS Access database\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:547\n";

static const char *proc222 = 
"create function \"DAV_EXTRACT_RDF_application/msproject\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS Project document\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:558\n";

static const char *proc223 = 
"create function \"DAV_EXTRACT_RDF_application/mspowerpoint\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS PowerPoint presentation\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:570\n";

static const char *proc224 = 
"create function \"DAV_EXTRACT_RDF_application/msword\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'MS Word document\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:582\n";

static const char *proc225 = 
"create function \"DAV_EXTRACT_RDF_application/pdf\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Office#TypeDescr\'    ,  \'PDF (Acrobat)\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:594\n";

static const char *proc226 = 
"create function \"DAV_EXTRACT_RDF_application/xbrl+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/xbrl#identifier\', \'declare namespace xmlns=\"http://www.xbrl.org/2003/instance\"; /xmlns:xbrl/xmlns:context/xmlns:entity/xmlns:identifier/text()\', \'\',\n"
"\'http://www.openlinksw.com/schemas/xbrl#startDate\', \'declare namespace xmlns=\"http://www.xbrl.org/2003/instance\"; /xmlns:xbrl/xmlns:context/xmlns:period/xmlns:startDate union /xmlns:xbrl/xmlns:context/xmlns:period/xmlns:instant\', \'\',\n"
"\'http://www.openlinksw.com/schemas/xbrl#endDate\', \'declare namespace xmlns=\"http://www.xbrl.org/2003/instance\"; /xmlns:xbrl/xmlns:context/xmlns:period/xmlns:endDate union /xmlns:xbrl/xmlns:context/xmlns:period/xmlns:instant\', \'\'\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:606\n";

static const char *proc227 = 
"create function \"DAV_EXTRACT_RDF_application/doap+rdf\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/doap#title\', \'declare namespace xmlns=\"http://usefulinc.com/ns/doap#\"; //xmlns:Project/xmlns:name\', \'\',\n"
"\'http://www.openlinksw.com/schemas/doap#description\', \'declare namespace xmlns=\"http://usefulinc.com/ns/doap#\"; //xmlns:Project/xmlns:shortdesc\', \'\',\n"
"\'http://www.openlinksw.com/schemas/doap#creationDate\', \'declare namespace xmlns=\"http://usefulinc.com/ns/doap#\"; //xmlns:Project/xmlns:created\', \'\'\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:623\n";

static const char *proc228 = 
"create function \"DAV_EXTRACT_RDF_application/xddl+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/XDDL#catalog\', \'/database/catalog\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XDDL#schema\', \'/database/schema\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XDDL#table\', \'/database/tables/table/@name\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XDDL#view\', \'/database/views/view/@name\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XDDL#procedure\', \'/database/procedures/procedure/@name\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/xddl+xml\'\n"
");\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:641\n";

static const char *proc229 = 
"create function \"DAV_EXTRACT_RDF_application/archive\" (in type_descr varchar, in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/Archive#type\', type_descr);\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:663\n";

static const char *proc230 = 
"create function \"DAV_EXTRACT_RDF_application/tar\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'TAR archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:677\n";

static const char *proc231 = 
"create function \"DAV_EXTRACT_RDF_application/taz\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'TAZ archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:683\n";

static const char *proc232 = 
"create function \"DAV_EXTRACT_RDF_application/gz\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'Gzip archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:689\n";

static const char *proc233 = 
"create function \"DAV_EXTRACT_RDF_application/msi\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'Microsoft installer\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:695\n";

static const char *proc234 = 
"create function \"DAV_EXTRACT_RDF_application/dmg\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'DMG install package\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:701\n";

static const char *proc235 = 
"create function \"DAV_EXTRACT_RDF_application/arj\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'ARJ archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:707\n";

static const char *proc236 = 
"create function \"DAV_EXTRACT_RDF_application/bz\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'BZ archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:713\n";

static const char *proc237 = 
"create function \"DAV_EXTRACT_RDF_application/bz2\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'BZ2 archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:719\n";

static const char *proc238 = 
"create function \"DAV_EXTRACT_RDF_application/tgz\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'TGZ archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:725\n";

static const char *proc239 = 
"create function \"DAV_EXTRACT_RDF_application/rar\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'RAR archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:731\n";

static const char *proc240 = 
"create function \"DAV_EXTRACT_RDF_application/zip\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'ZIP archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:737\n";

static const char *proc241 = 
"create function \"DAV_EXTRACT_RDF_application/cab\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'CAB archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:743\n";

static const char *proc242 = 
"create function \"DAV_EXTRACT_RDF_application/lzh\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'LZH archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:749\n";

static const char *proc243 = 
"create function \"DAV_EXTRACT_RDF_application/ace\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'ACE archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:755\n";

static const char *proc244 = 
"create function \"DAV_EXTRACT_RDF_application/iso\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"return \"DAV_EXTRACT_RDF_application/archive\" (\'ISO image archive\', orig_res_name, content, html_start);\n"
"}\n"
"--src dav_meta.sql:761\n";

static const char *proc245 = 
"create function \"DAV_EXTRACT_RDF_application/msword+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare docprops any;\n"
"docprops := null;\n"
"return \"DAV_EXTRACT_RDF_application/msoffice+xml\" (\'Word Document\', orig_res_name, content, html_start, docprops);\n"
"}\n"
"--src dav_meta.sql:767\n";

static const char *proc246 = 
"create function \"DAV_EXTRACT_RDF_application/msexcel+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare docprops any;\n"
"docprops := null;\n"
"return \"DAV_EXTRACT_RDF_application/msoffice+xml\" (\'Excel Spreadsheet\', orig_res_name, content, html_start, docprops);\n"
"}\n"
"--src dav_meta.sql:775\n";

static const char *proc247 = 
"create function \"DAV_EXTRACT_RDF_application/msproject+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare docprops any;\n"
"docprops := null;\n"
"return \"DAV_EXTRACT_RDF_application/msoffice+xml\" (\'Project\', orig_res_name, content, html_start, docprops);\n"
"}\n"
"--src dav_meta.sql:783\n";

static const char *proc248 = 
"create function \"DAV_EXTRACT_RDF_application/msvisio+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare docprops any;\n"
"docprops := null;\n"
"return \"DAV_EXTRACT_RDF_application/msoffice+xml\" (\'Visio\', orig_res_name, content, html_start, docprops);\n"
"}\n"
"--src dav_meta.sql:791\n";

static const char *proc249 = 
"create function \"DAV_EXTRACT_RDF_application/rss+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, res any;\n"
"xte_nodebld_init (res);\n"
"\n"
"whenever sqlstate \'*\' goto final;\n"
"doc := xtree_doc (content, 0);\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rss=\"http://purl.org/rss/1.0/\"]exists (/rdf:RDF/rss:channel)\', doc))\n"
"{\n"
"declare tmp_n3, channel_props any;\n"
"declare about varchar;\n"
"tmp_n3 := xslt (\'http://local.virt/rdfxml2n3xml\', doc);\n"
"about := xpath_eval (\'/N3[@N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\"][@N3O=\"http://purl.org/rss/1.0/channel\"]/@N3S\', tmp_n3);\n"
"if (about is null)\n"
"{\n"
"goto final;\n"
"}\n"
"channel_props := xpath_eval (\'/N3[@N3S=\\044about][not (exists (@N3O))]\', tmp_n3, 0, vector (UNAME\'about\', about));\n"
"foreach (any prop in channel_props) do\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', xpath_eval (\'@N3P\', prop)),\n"
"xpath_eval (\'string (.)\', prop) ) );\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare version decimal;\n"
"declare metas, extras any;\n"
"version := xpath_eval (\'number (/rss/@version)\', doc);\n"
"if (version < 0.9)\n"
"goto final;\n"
"metas := vector (\n"
"\'http://purl.org/rss/1.0/title\', \'/rss/channel/title\', NULL,\n"
"\'http://purl.org/rss/1.0/link\', \'/rss/channel/link\', NULL,\n"
"\'http://purl.org/rss/1.0/description\', \'/rss/channel/description\', NULL,\n"
"\'http://purl.org/rss/1.0/language\', \'/rss/channel/language\', NULL,\n"
"\'http://purl.org/rss/1.0/copyright\', \'/rss/channel/copyright\', NULL,\n"
"\'http://purl.org/rss/1.0/docs\', \'/rss/channel/docs\', NULL,\n"
"\'http://purl.org/rss/1.0/lastBuildDate\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:unix-datetime-parser (/rss/channel/lastBuildDate | /rss/channel/pubDate, 0, 2)\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"final:\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"}\n"
"--src dav_meta.sql:800\n";

static const char *proc250 = 
"create function \"DAV_EXTRACT_RDF_application/atom+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"declare version decimal;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"version := xpath_eval (\'[xmlns:atom=\"http://purl.org/atom/ns#\"] number (/atom:feed/@version)\', doc);\n"
"if (version < 0.1)\n"
"goto atom2005;\n"
"metas := vector (\n"
"\'http://purl.org/rss/1.0/title\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:title\', NULL,\n"
"\'http://purl.org/rss/1.0/link\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:link/@href\', NULL,\n"
"\'http://purl.org/rss/1.0/description\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:tagline\', NULL,\n"
"\'http://purl.org/rss/1.0/language\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/@xml:lang\', NULL,\n"
"\'http://purl.org/rss/1.0/copyright\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:copyright\', NULL,\n"
"\'http://purl.org/rss/1.0/docs\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; /atom:feed/atom:info\', NULL,\n"
"\'http://purl.org/rss/1.0/lastBuildDate\', \'declare namespace atom=\"http://purl.org/atom/ns#\"; declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:unix-datetime-parser (/atom:feed/atom:modified, 0, 2)\', NULL\n"
");\n"
"atom2005:\n"
"if (xpath_eval (\'[xmlns:atom=\"http://www.w3.org/2005/Atom\"] exists (/atom:feed)\', doc))\n"
"{\n"
"metas := vector (\n"
"\'http://purl.org/rss/1.0/title\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:title\', NULL,\n"
"\'http://purl.org/rss/1.0/link\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:link/@href\', NULL,\n"
"\'http://purl.org/rss/1.0/description\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:subtitle\', NULL,\n"
"\'http://purl.org/rss/1.0/language\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/@xml:lang\', NULL,\n"
"\'http://purl.org/rss/1.0/copyright\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:rights\', NULL,\n"
"\'http://purl.org/rss/1.0/docs\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; /atom:feed/atom:summary\', NULL,\n"
"\'http://purl.org/rss/1.0/lastBuildDate\', \'declare namespace atom=\"http://www.w3.org/2005/Atom\"; declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:unix-datetime-parser (/atom:feed/atom:updated, 0, 2)\', NULL\n"
");\n"
"}\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:852\n";

static const char *proc251 = 
"create function \"DAV_EXTRACT_RDF_text/eml\" (in orig_res_name varchar, inout content1 any, inout html_start any)\n"
"{\n"
"declare doc, metas, res, content any;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"content := blob_to_string (content1);\n"
"\n"
"xte_nodebld_init(res);\n"
"declare vec any;\n"
"declare from_, subject_, date_ varchar;\n"
"vec := vector();\n"
"vec := split_and_decode(content, 1, \'=_\\n:\');\n"
"declare i, l int;\n"
"i := 0;\n"
"l := length (vec);\n"
"while (i < l)\n"
"{\n"
"if (vec[i] = \'FROM\')\n"
"from_ := trim(vec[i+1], \'\\r\\n \');\n"
"if (vec[i] = \'SUBJECT\')\n"
"subject_ := trim(vec[i+1], \'\\r\\n \');\n"
"if (vec[i] = \'DATE\')\n"
"date_ := trim(vec[i+1], \'\\r\\n \');\n"
"i := i + 2;\n"
"}\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Email#from\'), from_));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Email#subject\'), subject_));\n"
"xte_nodebld_acc(res, xte_node(xte_head(UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\',\n"
"UNAME\'N3P\', \'http://www.openlinksw.com/schemas/Email#date\'), date_));\n"
"xte_nodebld_final(res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:891\n";

static const char *proc252 = 
"create function \"DAV_EXTRACT_RDF_application/xbel+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'\"application/xbel+xml\"\', NULL,\n"
"\'http://www.openlinksw.com/virtdav#dynArchiver\', \'\"XBEL\"\', NULL,\n"
"\'http://www.python.org/topics/xml/xbel/title\', \'/xbel/title\', NULL,\n"
"\n"
"\'http://www.python.org/topics/xml/xbel/description\', \'/xbel/description\', NULL,\n"
"\n"
"\n"
"\n"
"\'http://www.python.org/topics/xml/xbel/lastBuildDate\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; for \\044v in /xbel/@added return virtbpel:unix-datetime-parser (\\044v, 0, 2)\', NULL,\n"
"\'http://www.python.org/topics/xml/xbel/folderTitle\', \'/xbel//folder/title\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:928\n";

static const char *proc253 = 
"create function \"DAV_EXTRACT_RDF_application/rdf+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/RDF#format\', \'\"RDF+XML\"\', \'RDF+XML\'\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/rdf+xml\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:953\n";

static const char *proc254 = 
"create function \"DAV_EXTRACT_RDF_text/rdf+ttl\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/RDF#format\', \'TURTLE\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:970\n";

static const char *proc255 = 
"create function \"DAV_EXTRACT_RDF_text/rdf+n3\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"doc := null;\n"
"metas := null;\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/RDF#format\', \'N3\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"}\n"
"--src dav_meta.sql:982\n";

static const char *proc256 = 
"create function \"DAV_EXTRACT_RDF_application/foaf+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, res any;\n"
"declare tmp_n3, obj1_props any;\n"
"declare about varchar;\n"
"xte_nodebld_init (res);\n"
"\n"
"whenever sqlstate \'*\' goto final;\n"
"doc := xtree_doc (content, 0);\n"
"tmp_n3 := xslt (\'http://local.virt/rdfxml2n3xml\', doc);\n"
"about := xpath_eval (\'/N3[@N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\"]/@N3S\', tmp_n3);\n"
"if (about is null or\n"
"xpath_eval (\n"
"\'/N3[@N3S=\\044about][@N3P=\"http://xmlns.com/foaf/0.1/name\"]\', tmp_n3, 1,\n"
"vector (UNAME\'about\', about) ) is null )\n"
"about := xpath_eval (\'/N3[@N3P=\"http://xmlns.com/foaf/0.1/name\"]/@N3S\', tmp_n3);\n"
"if (about is null)\n"
"{\n"
"goto final;\n"
"}\n"
"obj1_props := xpath_eval (\'/N3[@N3S=\\044about][starts-with (@N3P, \"http://xmlns.com/foaf/0.1/\")]\', tmp_n3, 0, vector (UNAME\'about\', about));\n"
"foreach (any prop in obj1_props) do\n"
"{\n"
"declare obj any;\n"
"obj := cast (xpath_eval (\'@N3O\', prop) as varchar);\n"
"if (obj is null)\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', xpath_eval (\'@N3P\', prop)),\n"
"xpath_eval (\'string (.)\', prop) ) );\n"
"}\n"
"else if ((obj like \'node%\') or (obj like \'#%\'))\n"
"{\n"
"declare obj_names any;\n"
"obj_names := xpath_eval (\'/N3[@N3S = \\044obj][@N3P=\"http://xmlns.com/foaf/0.1/name\"]\', tmp_n3, 0, vector (UNAME\'obj\', obj));\n"
"foreach (any oname in obj_names) do\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', xpath_eval (\'@N3P\', prop) || N\'-name\'),\n"
"xpath_eval (\'string (.)\', oname) ) );\n"
"}\n"
"}\n"
"else if ((obj like \'http://%\') or (obj like \'https://%\') or (obj like \'tel:%\') or (obj like \'mailto:%\') or (obj like \'urn:%\') or (obj like \'/%\'))\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', xpath_eval (\'@N3P\', prop) || N\'-uri\'),\n"
"obj ) );\n"
"}\n"
"else\n"
"{\n"
" ;\n"
"}\n"
"}\n"
"final:\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"}\n"
"--src dav_meta.sql:994\n";

static const char *proc257 = 
"create function \"DAV_EXTRACT_RDF_application/mods+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"if (xpath_eval (\'exists (/modsCollection)\', doc))\n"
"doc := xpath_eval (\'/modsCollection\', doc);\n"
"if (xpath_eval (\'count (mods)\', doc) <> 1)\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/MODS#topic\', \'mods/subject/topic\', NULL );\n"
"}\n"
"else\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/MODS#topic\', \'mods/subject/topic\', NULL,\n"
"\'http://www.openlinksw.com/schemas/MODS#title\', \'mods/titleInfo/title\', NULL,\n"
"\'http://www.openlinksw.com/schemas/MODS#subtitle\', \'mods/titleInfo/subTitle\', NULL,\n"
"\'http://www.openlinksw.com/schemas/MODS#url\', \'mods/location/url\', NULL );\n"
"}\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/mods+xml\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1057\n";

static const char *proc258 = 
"create function \"DAV_EXTRACT_RDF_application/opml+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras, result, vals, outlines any;\n"
"declare graph_uri, new_uri, title, dateCreated, dateModified, ownerName, ownerEmail, owner_iri varchar;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/OPML#title\', \'/opml/head/title\', \'Untitled OPML\',\n"
"\'http://www.openlinksw.com/schemas/OPML#dateCreated\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; for \\044d in /opml/head/dateCreated return virtbpel:unix-datetime-parser (\\044d)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/OPML#dateModified\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; for \\044d in /opml/head/dateModified return virtbpel:unix-datetime-parser (\\044d)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/OPML#ownerName\', \'/opml/head/ownerName\', \'Unknown OPML owner\',\n"
"\'http://www.openlinksw.com/schemas/OPML#ownerEmail\', \'/opml/head/ownerEmail\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/opml+xml\' );\n"
"result := \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"title := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#title\"]\', result, 1) as varchar);\n"
"dateCreated := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#dateCreated\"]\', result, 1) as varchar);\n"
"dateModified := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#dateModified\"]\', result, 1) as varchar);\n"
"ownerName := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#ownerName\"]\', result, 1) as varchar);\n"
"ownerEmail := cast(xquery_eval (\'/N3[@N3P=\"http://www.openlinksw.com/schemas/OPML#ownerEmail\"]\', result, 1) as varchar);\n"
"graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (graph_uri, orig_res_name);\n"
"if (left(orig_res_name, 4) = \'/DAV\')\n"
"orig_res_name := right(orig_res_name, length(orig_res_name) - 4);\n"
"DB.DBA.RDF_QUAD_URI (graph_uri, new_uri, \'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\', \'http://rdfs.org/sioc/ns#SubscriptionList\');\n"
"if (ownerName is not null)\n"
"{\n"
"declare s_out any;\n"
"s_out := string_output();\n"
"declare s varchar;\n"
"http_url(ownerName, null, s_out);\n"
"s := string_output_string(s_out);\n"
"owner_iri := concat(new_uri, \'#\', s);\n"
"}\n"
"if (ownerEmail is not null)\n"
"DB.DBA.RDF_QUAD_URI (graph_uri, new_uri, \'http://rdfs.org/sioc/ns#email\', \'mailto:\'|| ownerEmail);\n"
"if (title is not null)\n"
"DB.DBA.RDF_QUAD_URI_L (graph_uri, new_uri, \'http://purl.org/dc/elements/1.1/title\', title);\n"
"if (ownerName is not null)\n"
"DB.DBA.RDF_QUAD_URI_L (graph_uri, new_uri, \'http://rdfs.org/sioc/ns#has_owner\', ownerName);\n"
"if (dateModified is not null)\n"
"DB.DBA.RDF_QUAD_URI_L (graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', dateModified);\n"
"if (dateCreated is not null)\n"
"DB.DBA.RDF_QUAD_URI_L (graph_uri, new_uri, \'http://purl.org/dc/terms/created\', dateCreated);\n"
"return result;\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1088\n";

static const char *proc259 = 
"create function \"DAV_EXTRACT_RDF_application/ocs+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/OPML#title\', \'//*:directory/*:title|//*:description/*:title\', \'Untitled OCS\',\n"
"\'http://www.openlinksw.com/schemas/OPML#dateCreated\', \'//*:directory/*:date|//*:description/*:date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/OPML#dateModified\', \'//*:directory/*:date|//*:description/*:date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/OPML#ownerName\', \'//*:directory/*:publisher|//*:description/*:creator\', \'Unknown OPML owner\',\n"
"\'http://www.openlinksw.com/schemas/OPML#ownerEmail\', \'//*:directory/*:creator|//*:description/*:creator\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/ocs+xml\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1140\n";

static const char *proc260 = 
"create function \"DAV_EXTRACT_RDF_text/html\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare metas, extras any;\n"
"\n"
"if (html_start is null)\n"
"html_start := xtree_doc (content, 18, \'http://localdav.virt/\' || orig_res_name, \'LATIN-1\', \'x-any\',\n"
"\'Validation=DISABLE Include=DISABLE BuildStandalone=DISABLE SchemaDecl=DISABLE\' );\n"
"if (html_start is null)\n"
"goto errexit;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/XHTML#title\', \'/*/head/title|/*/*:head/*:title\', \'Untitled\',\n"
"\'http://www.openlinksw.com/schemas/XHTML#description\', \'(/*/head/meta[@name=\"description\" or @name=\"Description\"]/@content) | (/*/*:head/*:meta[@name=\"description\" or @name=\"Description\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XHTML#copyright\', \'(/*/head/meta[@name=\"copyright\" or @name=\"Copyright\"]/@content) | (/*/*:head/*:meta[@name=\"copyright\" or @name=\"Copyright\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XHTML#keyword\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:split-list ((/*/head/meta[@name=\"keywords\" or @name=\"KeyWords\"]/@content) | (/*/*:head/*:meta[@name=\"keywords\" or @name=\"KeyWords\"]/@content))\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XHTML#calendar\', \'(/*/div[@class=\"vevent\"]/div/abbr) | (/*/*:div[@class=\"vevent\"]/*:div/*:abbr) | (/*/div[@class=\"vjournal\"]/div/abbr) | (/*/*:div[@class=\"vjournal\"]/*:div/*:abbr) | (/*/div[@class=\"vtodo\"]/div/abbr) | (/*/*:div[@class=\"vtodo\"]/*:div/*:abbr) | (/*/div[@class=\"vfreebusy\"]/div/abbr) | (/*/*:div[@class=\"vfreebusy\"]/*:div/*:abbr)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/XHTML#contacts\', \'(/div[@class=\"vcard\"]/span/a/span[@class=\"given-name\"] | /div[@class=\"vcard\"]/span/a/span[@class=\"family-name\"] | /div[@class=\"vcard\"]/a/span/span[@class=\"given-name\"] | /div[@class=\"vcard\"]/a/span/span[@class=\"family-name\"] | /div[@class=\"vcard\"]/a/span[@class=\"given-name\"] | /div[@class=\"vcard\"]/a/span[@class=\"family-name\"] | /div[@class=\"vcard\"]/a[@class=\"url fn\"])\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (html_start, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1161\n";

static const char *proc261 = 
"create function \"DAV_EXTRACT_RDF_application/x-openlinksw-vsp\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare metas, extras any;\n"
"\n"
"if (html_start is null)\n"
"html_start := xtree_doc (content, 18, \'http://localdav.virt/\' || orig_res_name, \'LATIN-1\', \'x-any\',\n"
"\'Validation=DISABLE Include=DISABLE BuildStandalone=DISABLE SchemaDecl=DISABLE\' );\n"
"if (html_start is null)\n"
"goto errexit;\n"
"whenever sqlstate \'*\' goto errexit;\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/VSPX#title\', \'/*/head/title|/*/*:head/*:title\', \'Untitled\',\n"
"\'http://www.openlinksw.com/schemas/VSPX#description\', \'(/*/head/meta[@name=\"description\" or @name=\"Description\"]/@content) | (/*/*:head/*:meta[@name=\"description\" or @name=\"Description\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VSPX#copyright\', \'(/*/head/meta[@name=\"copyright\" or @name=\"Copyright\"]/@content) | (/*/*:head/*:meta[@name=\"copyright\" or @name=\"Copyright\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VSPX#keyword\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:split-list ((/*/head/meta[@name=\"keywords\" or @name=\"KeyWords\"]/@content) | (/*/*:head/*:meta[@name=\"keywords\" or @name=\"KeyWords\"]/@content))\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/VSPX#type\', \'VSP\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (html_start, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1188\n";

static const char *proc262 = 
"create function \"DAV_EXTRACT_RDF_application/x-openlinksw-vspx+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/VSPX#pageId\', \'declare namespace v=\"http://www.openlinksw.com/vspx/\"; //v:page/@name\', \'Unidentified\',\n"
"\'http://www.openlinksw.com/schemas/VSPX#title\', \'/*/head/title|/*/*:head/*:title\', \'Untitled\',\n"
"\'http://www.openlinksw.com/schemas/VSPX#description\', \'(/*/head/meta[@name=\"description\"]/@content) | (/*/*:head/*:meta[@name=\"description\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VSPX#copyright\', \'(/*/head/meta[@name=\"copyright\"]/@content) | (/*/*:head/*:meta[@name=\"copyright\"]/@content)\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VSPX#keyword\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; virtbpel:split-list ((/*/head/meta[@name=\"keyword\"]/@content) | (/*/*:head/*:meta[@name=\"keyword\"]/@content))\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/VSPX#type\', \'VSPX\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1214\n";

static const char *proc263 = 
"create function \"DAV_EXTRACT_RDF_application/bpel+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/WSDL#processName\', \'declare namespace bpel=\"http://schemas.xmlsoap.org/ws/2003/03/business-process/\"; /bpel:process/@name\', \'Unidentified\',\n"
"\'http://www.openlinksw.com/schemas/WSDL#targetNamespace\', \'declare namespace bpel=\"http://schemas.xmlsoap.org/ws/2003/03/business-process/\"; /bpel:process/@targetNamespace\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/WSDL#type\', \'BPEL\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1236\n";

static const char *proc264 = 
"create function \"DAV_EXTRACT_RDF_application/annotea+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/Annotea#Bookmark\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; /*/*:Bookmark/@dc:title\', \'Untitled\',\n"
"\'http://www.openlinksw.com/schemas/Annotea#Topic\', \'declare namespace dc=\"http://purl.org/dc/elements/1.1/\"; /*/*:Topic/@dc:title\', \'Untitled\'\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1255\n";

static const char *proc265 = 
"create function \"DAV_EXTRACT_RDF_application/google-kinds+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/google-kinds#title\', \'/entry/title\', \'Untitled OPML\',\n"
"\'http://www.openlinksw.com/schemas/google-kinds#published\', \'/entry/published\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-kinds#updated\', \'/entry/updated\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-kinds#author\', \'/entry/author/name\', \'Unknown author\'\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1272\n";

static const char *proc266 = 
"create function \"DAV_EXTRACT_RDF_application/wsdl+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/WSDL#processName\', \'declare namespace wsdl=\"http://schemas.xmlsoap.org/wsdl/\"; /wsdl:definitions/@name\', \'Unidentified\',\n"
"\'http://www.openlinksw.com/schemas/WSDL#targetNamespace\', \'declare namespace wsdl=\"http://schemas.xmlsoap.org/wsdl/\"; /wsdl:definitions/@targetNamespace\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/schemas/WSDL#type\', \'WSDL\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1291\n";

static const char *proc267 = 
"create function \"DAV_EXTRACT_RDF_application/google-base+xml\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras any;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"doc := xtree_doc (content, 0);\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/google-base#actor\', \'/*:entry/*:actor\', \'\',\n"
"\'http://www.openlinksw.com/schemas/google-base#adult\', \'null\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#age\', \'/*:entry/*:age\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#age_range\', \'/*:entry/*:age_range\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#agent\', \'/*:entry/*:agent\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#album\', \'/*:entry/*:album\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#apparel_type\', \'/*:entry/*:apparel_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#area\', \'/*:entry/*:area\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#artist\', \'/*:entry/*:artist\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#aspect_ratio\', \'/*:entry/*:aspect_ratio\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#author\', \'/*:entry/*:author/*:name\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#bathrooms\', \'/*:entry/*:bathrooms\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#battery_life\', \'/*:entry/*:battery_life\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#bedrooms\', \'/*:entry/*:bedrooms\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#binding\', \'/*:entry/*:binding\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#brand\', \'/*:entry/*:brand\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#broker\', \'/*:entry/*:broker\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#calories\', \'/*:entry/*:calories\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#capacity\', \'/*:entry/*:capacity\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#category\', \'/*:entry/*:category\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#cholesterol\', \'/*:entry/*:cholesterol\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#color\', \'/*:entry/*:color\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#color_output\', \'/*:entry/*:color_output\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#condition\', \'/*:entry/*:condition\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#cooking_time\', \'/*:entry/*:cooking_time\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#countries\', \'/*:entry/*:countries\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#course\', \'/*:entry/*:course\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#cuisine\', \'/*:entry/*:cuisine\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#delivery\', \'/*:entry/*:delivery\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#delivery_notes\', \'/*:entry/*:delivery_notes\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#delivery_radius\', \'/*:entry/*:delivery_radius\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#department\', \'/*:entry/*:department\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#devices\', \'/*:entry/*:devices\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#director\', \'/*:entry/*:director\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#display_type\', \'/*:entry/*:display_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#edition\', \'/*:entry/*:edition\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#education\', \'/*:entry/*:education\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#employer\', \'/*:entry/*:employer\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#ethnicity\', \'/*:entry/*:ethnicity\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#event_date_range\', \'/*:entry/*:event_date_range\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#event_parking\', \'/*:entry/*:event_parking\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#event_performer\', \'/*:entry/*:event_performer\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#event_type\', \'/*:entry/*:event_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#expiration_date\', \'/*:entry/*:expiration_date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#expiration_date\', \'/*:entry/*:expiration_date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#feature\', \'/*:entry/*:feature\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#fiber\', \'/*:entry/*:fiber\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#file_type\', \'/*:entry/*:file_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#film_type\', \'/*:entry/*:film_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#focus_type\', \'/*:entry/*:focus_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#format\', \'/*:entry/*:format\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#from_location\', \'/*:entry/*:from_location\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#functions\', \'/*:entry/*:functions\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#gender\', \'/*:entry/*:gender\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#genre\', \'/*:entry/*:genre\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#heel_height\', \'/*:entry/*:heel_height\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#height\', \'/*:entry/*:height\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#hoa_dues\', \'/*:entry/*:hoa_dues\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#immigration_status\', \'/*:entry/*:immigration_status\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#installation\', \'/*:entry/*:installation\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#interested_in\', \'/*:entry/*:interested_in\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#isbn\', \'/*:entry/*:isbn\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#job_function\', \'/*:entry/*:job_function\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#job_industry\', \'/*:entry/*:job_industry\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#job_type\', \'/*:entry/*:job_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#languages\', \'/*:entry/*:languages\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#length\', \'/*:entry/*:length\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#listing_status\', \'/*:entry/*:listing_status\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#listing_type\', \'/*:entry/*:listing_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#load_type\', \'/*:entry/*:load_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#location\', \'/*:entry/*:location\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#lot_size\', \'/*:entry/*:lot_size\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#made_in\', \'/*:entry/*:made_in\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#main_ingredient\', \'/*:entry/*:main_ingredient\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#make\', \'/*:entry/*:make\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#marital_status\', \'/*:entry/*:marital_status\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#material\', \'/*:entry/*:material\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#meal_type\', \'/*:entry/*:meal_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#megapixels\', \'/*:entry/*:megapixels\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#memory_card_slot\', \'/*:entry/*:memory_card_slot\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#mileage\', \'/*:entry/*:mileage\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#mls_listing_id\', \'/*:entry/*:mls_listing_id\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#mls_name\', \'/*:entry/*:mls_name\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#mobile_url\', \'/*:entry/*:mobile_url\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#model\', \'/*:entry/*:model\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#model_number\', \'/*:entry/*:model_number\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#name_of_item_reviewed\', \'/*:entry/*:name_of_item_reviewed\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#news_source\', \'/*:entry/*:news_source\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#occasion\', \'/*:entry/*:occasion\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#occupation\', \'/*:entry/*:occupation\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#open_house_date_range\', \'/*:entry/*:open_house_date_range\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#operating_system\', \'/*:entry/*:operating_system\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#optical_drive\', \'/*:entry/*:optical_drive\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#pages\', \'/*:entry/*:pages\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#payment\', \'/*:entry/*:payment\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#payment_notes\', \'/*:entry/*:payment_notes\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#pickup\', \'/*:entry/*:pickup\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#platform\', \'/*:entry/*:platform\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#preparation_method\', \'/*:entry/*:preparation_method\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#preparation_time\', \'/*:entry/*:preparation_time\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#price\', \'/*:entry/*:price\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#price_type\', \'/*:entry/*:price_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#price_units\', \'/*:entry/*:price_units\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#processor_speed\', \'/*:entry/*:processor_speed\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#product_type\', \'/*:entry/*:product_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#property_taxes\', \'/*:entry/*:property_taxes\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#property_type\', \'/*:entry/*:property_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#protein\', \'/*:entry/*:protein\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#provider_class\', \'/*:entry/*:provider_class\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#provider_rank\', \'/*:entry/*:provider_rank\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publication_name\', \'/*:entry/*:title\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publication_volume\', \'/*:entry/*:publication_volume\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publish_date\', \'/*:entry/*:publish_date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publish_date\', \'/*:entry/*:publish_date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publish_year\', \'/*:entry/*:publish_year\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publisher\', \'/*:entry/*:publisher\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#publisher_url\', \'/*:entry/*:publisher_url\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#quantity\', \'/*:entry/*:quantity\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#rating\', \'/*:entry/*:rating\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#recommended_usage\', \'/*:entry/*:recommended_usage\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#resolution\', \'/*:entry/*:resolution\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#review_type\', \'/*:entry/*:review_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#reviewer_type\', \'/*:entry/*:reviewer_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#salary\', \'/*:entry/*:salary\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#salary_type\', \'/*:entry/*:salary_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#saturated_fat\', \'/*:entry/*:saturated_fat\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#school\', \'/*:entry/*:school\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#school_district\', \'/*:entry/*:school_district\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#screen_size\', \'/*:entry/*:screen_size\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#season_or_occasion\', \'/*:entry/*:season_or_occasion\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#service_type\', \'/*:entry/*:service_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#servings\', \'/*:entry/*:servings\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#sexual_orientation\', \'/*:entry/*:sexual_orientation\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#shipping\', \'/*:entry/*:shipping\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#shoe_width\', \'/*:entry/*:shoe_width\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#size\', \'/*:entry/*:size\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#sodium\', \'/*:entry/*:sodium\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#style\', \'/*:entry/*:style\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#tax_percent\', \'/*:entry/*:tax_percent\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#tax_region\', \'/*:entry/*:tax_region\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#tech_spec_link\', \'/*:entry/*:tech_spec_link\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#to_location\', \'/*:entry/*:to_location\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#tone_type\', \'/*:entry/*:tone_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#total_carbs\', \'/*:entry/*:total_carbs\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#total_fat\', \'/*:entry/*:total_fat\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#travel_date_range\', \'/*:entry/*:travel_date_range\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#upc\', \'/*:entry/*:upc\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#url_of_item_reviewed\', \'/*:entry/*:url_of_item_reviewed\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#vehicle_type\', \'/*:entry/*:vehicle_type\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#vin\', \'/*:entry/*:vin\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#web_url\', \'/*:entry/*:web_url\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#weight\', \'/*:entry/*:weight\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#width\', \'/*:entry/*:width\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#wireless_interface\', \'/*:entry/*:wireless_interface\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#year\', \'/*:entry/*:year\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#zoning\', \'/*:entry/*:zoning\', NULL,\n"
"\'http://www.openlinksw.com/schemas/google-base#zoom\', \'/*:entry/*:zoom\', NULL\n"
");\n"
"extras := null;\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1310\n";

static const char *proc268 = 
"create function \"DAV_EXTRACT_RDF_application/x-openlinksw-vad\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, metas, extras, tree, cont any;\n"
"declare s1, s2, s3, s4, len1 integer;\n"
"\n"
"whenever sqlstate \'*\' goto errexit;\n"
"if (aref(subseq(content, 0, 1), 0) <> 182)\n"
"goto errexit;\n"
"if (subseq(content, 5, 8) <> \'VAD\')\n"
"goto errexit;\n"
"if (subseq(content, 87, 94) <> \'STICKER\')\n"
"goto errexit;\n"
"s4 := aref(subseq(content, 95, 96), 0);\n"
"s3 := aref(subseq(content, 96, 97), 0);\n"
"s2 := aref(subseq(content, 97, 98), 0);\n"
"s1 := aref(subseq(content, 98, 99), 0);\n"
"len1 := s1 + 256 * ( s2 + 256 * ( s3 + 256 * ( s4 )));\n"
"cont := subseq(content, 99, 99 + len1);\n"
"tree := xml_tree (cont);\n"
"doc := xml_tree_doc (tree);\n"
"declare items any;\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/VAD#packageName\', \'/sticker/caption/name/@package\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#packageTitle\', \'/sticker/caption/name/prop[@name=\"Title\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#packageDeveloper\', \'/sticker/caption/name/prop[@name=\"Developer\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#packageCopyright\', \'/sticker/caption/name/prop[@name=\"Copyright\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#packageDownload\', \'/sticker/caption/name/prop[@name=\"Download\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#versionNumber\', \'/sticker/caption/version/@package\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#versionBuild\', \'/sticker/caption/version/prop[@name=\"Build\"]/@value[1]\', NULL,\n"
"\'http://www.openlinksw.com/schemas/VAD#releaseDate\', \'/sticker/caption/version/prop[@name=\"Release Date\"]/@value[1]\', NULL\n"
");\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'application/x-openlinksw-vad\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (doc, metas, extras);\n"
"\n"
"errexit:\n"
"return xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"--src dav_meta.sql:1482\n";

static const char *proc269 = 
"create function \"DAV_EXTRACT_RDF_text/wiki\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"if (1)\n"
"{\n"
"declare _author varchar;\n"
"declare _cluster varchar;\n"
"declare _title varchar;\n"
"declare _cats, _categories any;\n"
"declare _date datetime;\n"
"\n"
"declare _res, _ent any;\n"
"_author := coalesce (connection_get (\'HTTP_CLI_UID\'), \'Unknown\');\n"
"_cluster := connection_get (\'oWiki Cluster\', \'Main\');\n"
"\n"
"_ent := xtree_doc ( \"WikiV lexer\" (blob_to_string(content) || \'\\r\\n\', \'Main\', \'DoesntMatter\', \'wiki\', null), 2);\n"
"\n"
"\n"
"declare titles any;\n"
"titles := xpath_eval (\'string(//h1/*)\', _ent, 0);\n"
"_title := NULL;\n"
"foreach (varchar t in titles) do\n"
"{\n"
"if (length (t) > length (_title))\n"
"_title := cast (t as varchar);\n"
"}\n"
"if (_title is null)\n"
"{\n"
"declare pos integer;\n"
"pos := strrchr(orig_res_name, \'/\');\n"
"if (pos > 0)\n"
"pos := pos + 1;\n"
"else\n"
"pos := 0;\n"
"_title := subseq (orig_res_name, pos, length (orig_res_name) - 4);\n"
"}\n"
"else\n"
"_title := cast (_title as varchar);\n"
"_date := now();\n"
"_cats := xpath_eval (\'//a[@style=\"wikiword\" and text() like \"Category%\"]/text()\', _ent, 0);\n"
"\n"
"vectorbld_init (_categories);\n"
"_res := XMLELEMENT (\'Wiki\',\n"
"XMLELEMENT(\'Cluster\', _cluster),\n"
"XMLELEMENT(\'Title\', _title),\n"
"XMLELEMENT(\'Author\', _author),\n"
"XMLELEMENT(\'Date\', cast (_date as varchar)));\n"
"\n"
"_ent := xpath_eval (\'/Wiki\', _res);\n"
"foreach (any _c in _cats) do\n"
"{\n"
"XMLAppendChildren (_ent, XMLELEMENT (\'Category\', cast (_c as varchar)));\n"
"}\n"
"declare metas, extras any;\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/Wiki#Cluster\', \'/Wiki/Cluster\', NULL,\n"
"\'http://www.openlinksw.com/schemas/Wiki#Title\', \'/Wiki/Title\', NULL,\n"
"\'http://www.openlinksw.com/schemas/Wiki#Author\', \'/Wiki/Author\', NULL,\n"
"\'http://www.openlinksw.com/schemas/Wiki#Date\', \'/Wiki/Date\', NULL,\n"
"\'http://www.openlinksw.com/schemas/Wiki#Category\', \'/Wiki/Category\', NULL);\n"
"extras := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'text/wiki\' );\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (_res, metas, extras);\n"
"}\n"
"}\n"
"--src dav_meta.sql:1522\n";

static const char *proc270 = 
"create function IMC_TO_XML (in _src varchar)\n"
"{\n"
"declare stack any;\n"
"declare lines any;\n"
"declare curr_IMC any;\n"
"declare line_idx, lines_count integer;\n"
"declare IMC_type varchar;\n"
"declare line, head, head_name, data, name, params varchar;\n"
"declare colon_pos, param_count, param_idx integer;\n"
"declare delims, head_parts, data_parts, line_acc any;\n"
"if (length (_src) > 2)\n"
"{\n"
"if ((_src[0] = 254) and (_src[1] = 255))\n"
"_src := charset_recode (subseq (_src, 2), \'UTF-16BE\', \'UTF-8\');\n"
"else if ((_src[0] = 255) and (_src[1] = 254))\n"
"_src := charset_recode (subseq (_src, 2), \'UTF-16LE\', \'UTF-8\');\n"
"}\n"
"IMC_type := \' root\';\n"
"stack := vector ();\n"
"xte_nodebld_init (curr_IMC);\n"
"_src := replace (_src, \'\\015\\012\', \'\\012\');\n"
"_src := replace (_src, \'\\012\\015\', \'\\012\');\n"
"_src := replace (_src, \'\\015\', \'\\012\');\n"
"_src := replace (_src, \'\\012 \', \'\');\n"
"lines := split_and_decode (_src, 0, \'\\0\\0\\n\');\n"
"lines_count := length (lines);\n"
"line_idx := 0;\n"
"while (line_idx < lines_count)\n"
"{\n"
"line := lines [line_idx];\n"
"if (line = \'\')\n"
"goto next_line;\n"
"if (regexp_match (\'^([A-Za-z0-9-]+[.])?((BEGIN)|(begin)):([A-Z]+)\\044\', line) is not null)\n"
"{\n"
"stack := vector_concat (vector (IMC_type, curr_IMC), stack);\n"
"IMC_type := upper (subseq (line, strchr (line, \':\') + 1));\n"
"xte_nodebld_init (curr_IMC);\n"
"xte_nodebld_acc (curr_IMC, \'\\n\');\n"
"goto next_line;\n"
"}\n"
"if (regexp_match (\'^([A-Za-z0-9-]+[.])?((END)|(end)):([A-Z]+)\\044\', line) is not null)\n"
"{\n"
"declare sub_IMC any;\n"
"declare close_type varchar;\n"
"if (2 > length (stack))\n"
"signal (\'22007\', sprintf (\'IMC text contains redundant \"END\" at line %d\', line_idx + 1));\n"
"close_type := upper (subseq (line, strchr (line, \':\') + 1));\n"
"if (close_type <> IMC_type)\n"
"signal (\'22007\', sprintf (\'IMC text contains \"END:%s\" instead of expected \"END:%s\" at line %d\', close_type, IMC_type, line_idx + 1));\n"
"xte_nodebld_final (curr_IMC, xte_head (\'IMC-\' || IMC_type));\n"
"sub_IMC := curr_IMC;\n"
"IMC_type := stack[0];\n"
"curr_IMC := stack[1];\n"
"stack := subseq (stack, 2);\n"
"xte_nodebld_acc (curr_IMC, sub_IMC);\n"
"xte_nodebld_acc (curr_IMC, \'\\n\');\n"
"goto next_line;\n"
"}\n"
"xte_nodebld_init (line_acc);\n"
"delims := regexp_parse (\n"
"\n"
"\'^([A-Za-z0-9-]+[.])?([A-Za-z0-9-]+)(([;][A-Za-z0-9-]+(=(([^\\001-\\037\\200-\\377\";:,]*)|(\"[^\\001-\\037\\200-\\377\"]*\"))(,(([^\\001-\\037\\200-\\377\";:,]*)|(\"[^\\001-\\037\\200-\\377\"]*\")))*)?)*)([:])([\\040-\\377]*)\\044\',\n"
"\n"
"line, 0 );\n"
"if (delims is null)\n"
"{\n"
"head := \'X-ERROR\';\n"
"data := line;\n"
"}\n"
"else\n"
"{\n"
"colon_pos := delims[7];\n"
"head := subseq (line, 0, colon_pos);\n"
"data := subseq (line, colon_pos + 1);\n"
"}\n"
"head_parts := split_and_decode (head, 0, \'\\0\\0;\');\n"
"head_name := head_parts [0];\n"
"param_idx := 1;\n"
"param_count := length (head_parts);\n"
"while (param_idx < param_count)\n"
"{\n"
"declare param_strg, param_name, param_data varchar;\n"
"declare eq_pos integer;\n"
"param_strg := head_parts [param_idx];\n"
"eq_pos := strchr (param_strg, \'=\');\n"
"if (eq_pos is null)\n"
"xte_nodebld_acc (line_acc,\n"
"xte_node (xte_head (UNAME\'TYPE\'), param_strg) );\n"
"else\n"
"{\n"
"param_name := subseq (param_strg, 0, eq_pos);\n"
"param_data := split_and_decode (subseq (param_strg, eq_pos + 1), 0, \'\\0\\0,\');\n"
"foreach (varchar pd in param_data) do\n"
"{\n"
"if (pd like \'\"%\"\')\n"
"pd := subseq (pd, 1, length (pd) - 1);\n"
"xte_nodebld_acc (line_acc,\n"
"xte_node (xte_head (param_name), pd) );\n"
"}\n"
"}\n"
"param_idx := param_idx + 1;\n"
"}\n"
"if ((length (data) > 0) and\n"
"( position (\'ENCODING=QUOTED-PRINTABLE\', head_parts) or\n"
"position (\'ENCODING=\"QUOTED-PRINTABLE\"\', head_parts) ) )\n"
"{\n"
"while ((data [length (data) - 1] = 61) and\n"
"((line_idx + 1) < lines_count) )\n"
"{\n"
"line_idx := line_idx + 1;\n"
"data := subseq (data, 0, length (data) - 1) || lines [line_idx];\n"
"}\n"
"}\n"
"\n"
"data := replace (data, \'\\\\,\', \'\\1\');\n"
"data := replace (data, \'\\\\;\', \'\\2\');\n"
"data := replace (data, \'\\\\n\', \'\\015\\012\');\n"
"data := replace (data, \'\\\\N\', \'\\015\\012\');\n"
"data := replace (data, \'\\\\\\\\\', \'\\\\\');\n"
"\n"
"if (strchr (data, \';\') is not null)\n"
"{\n"
"data_parts := split_and_decode (data, 0, \'\\0\\0;\');\n"
"\n"
"foreach (varchar datum in data_parts) do\n"
"{\n"
"declare recoded varchar;\n"
"datum := replace (datum, \'\\1\', \',\');\n"
"datum := replace (datum, \'\\2\', \';\');\n"
"recoded := charset_recode (datum, \'UTF-8\', \'_WIDE_\');\n"
"if (not (isstring (recoded)))\n"
"recoded := charset_recode (datum, NULL, \'_WIDE_\');\n"
"xte_nodebld_acc (line_acc, xte_node (xte_head (UNAME\'fld\'), recoded));\n"
"}\n"
"}\n"
"else if (strchr (data, \',\') is not null)\n"
"{\n"
"data_parts := split_and_decode (data, 0, \'\\0\\0,\');\n"
"\n"
"foreach (varchar datum in data_parts) do\n"
"{\n"
"declare recoded varchar;\n"
"datum := replace (datum, \'\\1\', \',\');\n"
"datum := replace (datum, \'\\2\', \';\');\n"
"recoded := charset_recode (datum, \'UTF-8\', \'_WIDE_\');\n"
"if (not (isstring (recoded)))\n"
"recoded := charset_recode (datum, NULL, \'_WIDE_\');\n"
"xte_nodebld_acc (line_acc, xte_node (xte_head (UNAME\'val\'), recoded));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare recoded varchar;\n"
"data := replace (data, \'\\1\', \',\');\n"
"data := replace (data, \'\\2\', \';\');\n"
"recoded := charset_recode (data, \'UTF-8\', \'_WIDE_\');\n"
"if (not (isstring (recoded)))\n"
"recoded := charset_recode (data, NULL, \'_WIDE_\');\n"
"xte_nodebld_acc (line_acc, xte_node (xte_head (UNAME\'val\'), recoded));\n"
"}\n"
"xte_nodebld_final (line_acc, xte_head (head_name));\n"
"xte_nodebld_acc (curr_IMC, line_acc, \'\\n\');\n"
"next_line:\n"
"line_idx := line_idx + 1;\n"
" ;\n"
"}\n"
"\n"
"if (0 <> length (stack))\n"
"signal (\'22007\', sprintf (\'IMC text has no closing \"END:%s\" before the end of text\', stack[0]));\n"
"xte_nodebld_final (curr_IMC, xte_head (UNAME\' root\'));\n"
"return curr_IMC;\n"
"}\n"
"--src dav_meta.sql:1590\n";

static const char *proc271 = 
"create function \"DAV_EXTRACT_RDF_text/directory\" (in orig_res_name varchar, inout content any, inout html_start any)\n"
"{\n"
"declare doc, diritems, res, metas, extras any;\n"
"xte_nodebld_init (res);\n"
"\n"
"whenever sqlstate \'*\' goto final;\n"
"if (not isstring (content))\n"
"doc := IMC_TO_XML (cast (content as varchar));\n"
"else\n"
"doc := IMC_TO_XML (content);\n"
"doc := xml_tree_doc (doc);\n"
"\n"
"diritems := xpath_eval (\'/*\', doc, 0);\n"
"foreach (any diritm in diritems) do\n"
"{\n"
"declare itemname varchar;\n"
"declare ctr, len integer;\n"
"itemname := xpath_eval (\'name(.)\', diritm);\n"
"if (itemname = \'IMC-VCARD\')\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/virtdav#dynRdfExtractor\', \'\"text/directory\"\', null,\n"
"\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#FN\', \'FN/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#NICKNAME\', \'NICKNAME/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#BDAY\', \'declare namespace virtbpel=\"http://www.openlinksw.com/virtuoso/bpel\"; for \\044v in BDAY/val return virtbpel:unix-datetime-parser (\\044v)\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#MAILER\', \'MAILER/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#GEO\', \'GEO/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#TITLE\', \'TITLE/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#ROLE\', \'ROLE/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#CATEGORIES\', \'CATEGORIES/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#N\', \'if (N/val) then concat (N/val, \";;;;\") else concat (N/fld[1], \";\", N/fld[2], \";\", N/fld[3], \";\", N/fld[4], \";\", N/fld[5])\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#SOURCE\', \'SOURCE/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#NOTE\', \'NOTE/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#PRODID\', \'PRODID/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#REV\', \'REV/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#SORT-STRING\', \'SORT-STRING/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#CLASS\', \'CLASS/val\', null,\n"
"\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#TEL\', \'for \\044v in TEL/val return concat (\\044v, for \\044t in \\044v/../TYPE return concat (\" (\", \\044t, \")\"))\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#EMAIL\', \'for \\044v in EMAIL/val return concat (\\044v, for \\044t in \\044v/../TYPE return concat (\" (\", \\044t, \")\"))\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#ADR\', \'for \\044v in ADR return concat (if (\\044v/val) then concat (\\044v/val, \";;;;;;\") else concat (\\044v/fld[1], \";\", \\044v/fld[2], \";\", \\044v/fld[3], \";\", \\044v/fld[4], \";\", \\044v/fld[5], \";\", \\044v/fld[6], \";\", \\044v/fld[7]), for \\044t in \\044v/TYPE return concat (\" (\", \\044t, \")\"))\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#LABEL\', \'for \\044v in LABEL/val return concat (\\044v, for \\044t in \\044v/../TYPE return concat (\" (\", \\044t, \")\"))\', null,\n"
"\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#UID\', \'CLASS/val\', null,\n"
"\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Family\', \'N/fld[1]|N/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Given\', \'N/fld[2]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Other\', \'N/fld[3]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Prefix\', \'N/fld[4]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Name-Suffix\', \'N/fld[5]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Pobox\', \'ADR/fld[1]|ADR/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Extadd\', \'ADR/fld[2]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Street\', \'ADR/fld[3]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Locality\', \'ADR/fld[4]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Region\', \'ADR/fld[5]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Pcode\', \'ADR/fld[6]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Address-Country\', \'ADR/fld[7]\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgname\', \'ORG/fld[1]|ORG/val\', null,\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#Org-Orgunit\', \'ORG/fld[position() > 1]\', null\n"
");\n"
"}\n"
"else if (itemname = \'IMC-VCALENDAR\')\n"
"{\n"
"\n"
"if ((length (diritems) = 1) and (xpath_eval(\'count (IMC-VEVENT)\', diritm) > 0))\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/ICS#SUMMARY\', \'IMC-VEVENT/SUMMARY/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#LOCATION\', \'IMC-VEVENT/LOCATION/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#CATEGORIES\', \'IMC-VEVENT/CATEGORIES/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#ATTENDEE\', \'IMC-VEVENT/ATTENDEE/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#ORGANIZER\', \'IMC-VEVENT/ORGANIZER/val\', null );\n"
"}\n"
"else if ((length (diritems) = 1) and (xpath_eval(\'count (IMC-VTODO)\', diritm) > 0))\n"
"{\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/ICS#SUMMARY\', \'IMC-VTODO/SUMMARY/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#LOCATION\', \'IMC-VTODO/LOCATION/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#CATEGORIES\', \'IMC-VTODO/CATEGORIES/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#ATTENDEE\', \'IMC-VTODO/ATTENDEE/val\', null,\n"
"\'http://www.openlinksw.com/schemas/ICS#ORGANIZER\', \'IMC-VTODO/ORGANIZER/val\', null);\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
"metas := vector (\n"
"\'http://www.openlinksw.com/schemas/ICS#SUMMARY\', \'IMC-VEVENT/SUMMARY/val\', null );\n"
"\n"
"}\n"
"}\n"
"else\n"
"metas := vector ();\n"
"\n"
"extras := vector ();\n"
"\n"
"return \"DAV_EXTRACT_RDF_BY_METAS\" (diritm, metas, extras);\n"
"\n"
"len := length (metas);\n"
"\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"{\n"
"declare vals varchar;\n"
"vals := xquery_eval (metas [ctr + 1], diritm, 0);\n"
"\n"
"\n"
"if (vals is not null)\n"
"{\n"
"foreach (any val in vals) do\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', metas [ctr]),\n"
"cast (val as varchar) ) );\n"
"}\n"
"}\n"
"}\n"
"\n"
"final:\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"\n"
"return xml_tree_doc (res);\n"
"}\n"
"--src dav_meta.sql:1765\n";

static const char *proc272 = 
"create function \"DAV_EXTRACT_RDF_BY_METAS\" (inout doc any, inout metas any, inout extras any)\n"
"{\n"
"declare res any;\n"
"declare ctr, len integer;\n"
"\n"
"xte_nodebld_init (res);\n"
"whenever sqlstate \'*\' goto final;\n"
"len := length (metas);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 3)\n"
"{\n"
"declare vals varchar;\n"
"vals := xquery_eval (metas [ctr + 1], doc, 0);\n"
"\n"
"if (length (vals) = 0)\n"
"{\n"
"vals := metas [ctr + 2];\n"
"if (vals is not null)\n"
"vals := vector (vals);\n"
"}\n"
"foreach (any val in vals) do\n"
"{\n"
"\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', metas [ctr]),\n"
"replace(cast (val as varchar), \'?\', \'_\') ) );\n"
"}\n"
"}\n"
"len := length (extras);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"{\n"
"declare val any;\n"
"val := extras [ctr + 1];\n"
"if (val is not null)\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\', extras [ctr]),\n"
"cast (val as varchar) ) );\n"
"}\n"
"final:\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (res);\n"
"}\n"
"--src dav_meta.sql:1891\n";

static const char *proc273 = 
"create function DB.DBA.UNIX_DATETIME_PARSER (in strg varchar, in trap_error integer := 0, in output_mode integer := 0)\n"
"{\n"
"declare m integer;\n"
"declare res varchar;\n"
"declare parts any;\n"
"declare Yr, Mo, MN, Da, hms, tz varchar;\n"
"\n"
"if (strg is null)\n"
"return null;\n"
"strg := cast (strg as varchar);\n"
"\n"
"parts := regexp_parse(\'^([A-Z][a-z][a-z]), ([ 0-3][0-9]) ([A-Z][A-Za-z][A-Za-z]) ([0-2][0-9][0-9][0-9]) ([0-2][0-9]:[0-6][0-9]:[0-6][0-9])(( [A-Z0-9:+-]+)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"Da := subseq (strg, parts[4], parts[5]);\n"
"MN := subseq (strg, parts[6], parts[7]);\n"
"Yr := subseq (strg, parts[8], parts[9]);\n"
"hms := subseq (strg, parts[10], parts[11]);\n"
"tz := subseq (strg, parts[12], parts[13]);\n"
"Mo := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([ 0-3][0-9]) ([A-Z][A-Za-z][A-Za-z]) ([0-2][0-9][0-9][0-9]) ([0-2][0-9]:[0-6][0-9]:[0-6][0-9])(( [A-Z0-9:+-]+)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"Da := subseq (strg, parts[2], parts[3]);\n"
"MN := subseq (strg, parts[4], parts[5]);\n"
"Yr := subseq (strg, parts[6], parts[7]);\n"
"hms := subseq (strg, parts[8], parts[9]);\n"
"tz := subseq (strg, parts[10], parts[11]);\n"
"Mo := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([0-2][0-9][0-9][0-9])-([ 0-1][0-9])-([ 0-3][0-9])( |T)([0-2][0-9]:[0-6][0-9]:[0-6][0-9])(([Z+-][0-9:]*)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"Yr := subseq (strg, parts[2], parts[3]);\n"
"Mo := subseq (strg, parts[4], parts[5]);\n"
"Da := subseq (strg, parts[6], parts[7]);\n"
"hms := subseq (strg, parts[10], parts[11]);\n"
"tz := subseq (strg, parts[12], parts[13]);\n"
"MN := null;\n"
"goto parts_ready;\n"
"}\n"
"parts := regexp_parse(\'^([0-2][0-9][0-9][0-9])([0-1][0-9])([0-3][0-9])(T)([0-2][0-9][0-6][0-9][0-6][0-9])(([Z+-][0-9:]*)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"Yr := subseq (strg, parts[2], parts[3]);\n"
"Mo := subseq (strg, parts[4], parts[5]);\n"
"Da := subseq (strg, parts[6], parts[7]);\n"
"hms := subseq (strg, parts[10], parts[11]);\n"
"hms := subseq (hms, 0, 2) || \':\' ||\n"
"subseq (hms, 2, 4) || \':\' ||\n"
"subseq (hms, 4, 6) ;\n"
"tz := subseq (strg, parts[12], parts[13]);\n"
"MN := null;\n"
"goto parts_ready;\n"
"}\n"
"res := DB.DBA.UNIX_DATE_PARSER (strg, 1, 0);\n"
"if (res is not null)\n"
"{\n"
"res := cast (res as datetime);\n"
"goto final_cast;\n"
"}\n"
"if (trap_error)\n"
"return NULL;\n"
"signal (\'22005\', sprintf (\'UNIX_DATETIME_PARSER has failed to parse \"%.200s\"\', strg));\n"
"\n"
"parts_ready:\n"
"if (Mo is null)\n"
"Mo := get_keyword (upper (MN), vector (\'JAN\', \'01\', \'FEB\', \'02\', \'MAR\', \'03\', \'APR\', \'04\', \'MAY\', \'05\', \'JUN\', \'06\', \'JUL\', \'07\', \'AUG\', \'08\', \'SEP\', \'09\', \'OCT\', \'10\', \'NOV\', \'11\', \'DEC\', \'12\'));\n"
"res := sprintf (\'%s-%s-%s %s\', Yr, Mo, Da, hms);\n"
"\n"
"if (trap_error)\n"
"{\n"
"whenever sqlstate \'*\' goto recov;\n"
"res := cast (res as datetime);\n"
"}\n"
"else\n"
"res := cast (res as datetime);\n"
"\n"
"final_cast:\n"
"if (output_mode = 0)\n"
"return res;\n"
"if (output_mode = 1)\n"
"return cast (res as varchar);\n"
"if (output_mode = 2)\n"
"return replace (cast (res as varchar), \' \', \'T\');\n"
"\n"
"recov:\n"
"if (output_mode = 0)\n"
"return null;\n"
"return \'?\' || strg;\n"
"}\n"
"--src dav_meta.sql:1942\n";

static const char *other1 = 
"grant execute on DB.DBA.UNIX_DATETIME_PARSER to public\n";
static const char *other2 = 
"xpf_extension (\'http://www.openlinksw.com/virtuoso/bpel:unix-datetime-parser\', fix_identifier_case (\'DB.DBA.UNIX_DATETIME_PARSER\'), 0)\n";
static const char *proc274 = 
"create function DB.DBA.UNIX_DATE_PARSER (in strg varchar, in trap_error integer := 0, in output_mode integer := 0)\n"
"{\n"
"declare m integer;\n"
"declare res varchar;\n"
"declare parts any;\n"
"declare Yr, Mo, MN, Da, tz varchar;\n"
"\n"
"if (strg is null)\n"
"return null;\n"
"strg := cast (strg as varchar);\n"
"\n"
"parts := regexp_parse(\'^([A-Z][a-z][a-z]), ([ 0-3][0-9]) ([A-Z][A-Za-z][A-Za-z]) ([0-2][0-9][0-9][0-9])(( [A-Z0-9:+-]+)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"\n"
"Da := subseq (strg, parts[4], parts[5]);\n"
"MN := subseq (strg, parts[6], parts[7]);\n"
"Yr := subseq (strg, parts[8], parts[9]);\n"
"tz := subseq (strg, parts[10], parts[11]);\n"
"Mo := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([ 0-3][0-9]) ([A-Z][A-Za-z][A-Za-z]) ([0-2][0-9][0-9][0-9])(( [A-Z0-9:+-]+)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"\n"
"Da := subseq (strg, parts[2], parts[3]);\n"
"MN := subseq (strg, parts[4], parts[5]);\n"
"Yr := subseq (strg, parts[6], parts[7]);\n"
"tz := subseq (strg, parts[8], parts[9]);\n"
"Mo := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([0-2][0-9][0-9][0-9])-([ 0-1][0-9])-([ 0-3][0-9])(([Z+-][0-9:]*)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"\n"
"Yr := subseq (strg, parts[2], parts[3]);\n"
"Mo := subseq (strg, parts[4], parts[5]);\n"
"Da := subseq (strg, parts[6], parts[7]);\n"
"tz := subseq (strg, parts[8], parts[9]);\n"
"MN := null;\n"
"goto parts_ready;\n"
"}\n"
"\n"
"parts := regexp_parse(\'^([0-2][0-9][0-9][0-9])([0-1][0-9])([0-3][0-9])(([Z+-][0-9:]*)?)\\044\', strg, 0);\n"
"if (parts is not null)\n"
"{\n"
"\n"
"Yr := subseq (strg, parts[2], parts[3]);\n"
"Mo := subseq (strg, parts[4], parts[5]);\n"
"Da := subseq (strg, parts[6], parts[7]);\n"
"tz := subseq (strg, parts[8], parts[9]);\n"
"MN := null;\n"
"goto parts_ready;\n"
"}\n"
"if (trap_error)\n"
"return NULL;\n"
"signal (\'22005\', sprintf (\'UNIX_DATE_PARSER has failed to parse \"%.200s\"\', strg));\n"
"\n"
"parts_ready:\n"
"if (Mo is null)\n"
"Mo := get_keyword (upper (MN), vector (\'JAN\', \'01\', \'FEB\', \'02\', \'MAR\', \'03\', \'APR\', \'04\', \'MAY\', \'05\', \'JUN\', \'06\', \'JUL\', \'07\', \'AUG\', \'08\', \'SEP\', \'09\', \'OCT\', \'10\', \'NOV\', \'11\', \'DEC\', \'12\'));\n"
"res := sprintf (\'%s-%s-%s\', Yr, Mo, Da);\n"
"\n"
"if (trap_error)\n"
"{\n"
"whenever sqlstate \'*\' goto recov;\n"
"res := cast (res as date);\n"
"}\n"
"else\n"
"res := cast (res as date);\n"
"if (output_mode = 0)\n"
"return res;\n"
"if (output_mode = 1)\n"
"return cast (res as varchar);\n"
"if (output_mode = 2)\n"
"return cast (res as varchar);\n"
"\n"
"recov:\n"
"if (output_mode = 0)\n"
"return null;\n"
"return \'?\' || strg;\n"
"}\n"
"--src dav_meta.sql:2051\n";

static const char *other3 = 
"grant execute on DB.DBA.UNIX_DATE_PARSER to public\n";
static const char *other4 = 
"xpf_extension (\'http://www.openlinksw.com/virtuoso/bpel:unix-date-parser\', fix_identifier_case (\'DB.DBA.UNIX_DATE_PARSER\'), 0)\n";
static const char *proc275 = 
"create function DB.DBA.BPEL_SPLIT_LIST (in strg varchar)\n"
"{\n"
"declare parts, res any;\n"
"\n"
"if (strg is null)\n"
"return null;\n"
"strg := cast (strg as varchar);\n"
"if (strchr (strg, \';\'))\n"
"parts := split_and_decode (strg, 0, \'\\0\\0;\');\n"
"else if (strchr (strg, \',\'))\n"
"parts := split_and_decode (strg, 0, \'\\0\\0,\');\n"
"else\n"
"parts := split_and_decode (strg, 0, \'\\0\\0 ,\');\n"
"if (length (parts) = 0)\n"
"return null;\n"
"xq_sequencebld_init (res);\n"
"foreach (varchar part in parts) do\n"
"{\n"
"xq_sequencebld_acc (res, charset_recode (trim (part), NULL, \'UTF-8\'));\n"
"}\n"
"xq_sequencebld_final (res);\n"
"return res;\n"
"}\n"
"--src dav_meta.sql:2151\n";

static const char *other5 = 
"grant execute on DB.DBA.BPEL_SPLIT_LIST to public\n";
static const char *other6 = 
"xpf_extension (\'http://www.openlinksw.com/virtuoso/bpel:split-list\', fix_identifier_case (\'DB.DBA.BPEL_SPLIT_LIST\'), 0)\n";
static const char *proc276 = 
"create function DAV_EXTRACT_SPOTLIGHT (in resname varchar, inout rescontent any) returns any\n"
"{\n"
"declare temp_name varchar;\n"
"declare sp_metadata, virt_metas, ret, _reg any;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{ log_message (\'SpotLight import fail: \' || __SQL_MESSAGE); return NULL; };\n"
"\n"
"if (not spotlight_status ())\n"
"return NULL;\n"
"\n"
"_reg := cast (registry_get (\'VAD_is_run\') as varchar);\n"
"if (_reg <> \'0\')\n"
"return NULL;\n"
"\n"
"sys_mkdir (\'sptmp\');\n"
"temp_name := \'sptmp/\' || resname;\n"
"\n"
"string_to_file (temp_name, blob_to_string (rescontent), -2);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"run_executable (\'/usr/bin/mdimport\', 1, \' -f \', server_root () || temp_name);\n"
"sp_metadata := SPOTLIGHT_METADATA (temp_name);\n"
"sys_unlink (temp_name);\n"
"\n"
"virt_metas := DAV_CONVERT_SPOTLIGHT_TO_VIRTUOSO (sp_metadata);\n"
"\n"
"return virt_metas;\n"
"}\n"
"--src dav_meta.sql:2183\n";

static const char *proc277 = 
"create function DAV_CONVERT_SPOTLIGHT_TO_VIRTUOSO (in sp_data any) returns any\n"
"{\n"
"declare loop_names, len, v_meta, ret, ctr, res, added integer;\n"
"\n"
"loop_names := 0;\n"
"added := 0;\n"
"len := length (sp_data);\n"
"v_meta := vector ();\n"
"xte_nodebld_init (res);\n"
"\n"
"while (len > loop_names)\n"
"{\n"
"declare line, name, vals any;\n"
"line := sp_data [loop_names];\n"
"name := line [0];\n"
"vals := line [1];\n"
"if (name in (\'kMDItemLastUsedDate\', \'kMDItemUsedDates\', \'kMDItemFSFinderFlags\',\n"
"\'kMDItemFSOwnerUserID\', \'kMDItemFSOwnerGroupID\', \'kMDItemFSTypeCode\',\n"
"\'kMDItemID\', \'kMDItemFSSize\', \'kMDItemFSCreationDate\', \'kMDItemContentCreationDate\',\n"
"\'kMDItemFSContentChangeDate\', \'kMDItemFSCreatorCode\', \'kMDItemFSLabel\',\n"
"\'kMDItemFSInvisible\', \'kMDItemFSNodeCount\', \'kMDItemAttributeChangeDate\',\n"
"\'kMDItemDisplayName\', \'kMDItemContentModificationDate\', \'kMDItemFSName\', \'kMDItemContentTypeTree\'))\n"
"goto end_loop;\n"
"\n"
"if (__tag (vals) = 193)\n"
"foreach (any val in line [1]) do\n"
"DAV_SPOTLIGHT_ADD (res, name, val);\n"
"else\n"
"DAV_SPOTLIGHT_ADD (res, name, line [1]);\n"
"\n"
"added := added + 1;\n"
"\n"
"end_loop:\n"
"loop_names := loop_names + 1;\n"
"}\n"
"\n"
"xte_nodebld_final (res, xte_head (UNAME\' root\'));\n"
"if (added)\n"
"return xml_tree_doc (res);\n"
"\n"
"return null;\n"
"}\n"
"--src dav_meta.sql:2222\n";

static const char *proc278 = 
"create procedure DAV_SPOTLIGHT_ADD (inout res any, in name varchar, inout val any)\n"
"{\n"
"xte_nodebld_acc (res,\n"
"xte_node (\n"
"xte_head (UNAME\'N3\', UNAME\'N3S\', \'http://local.virt/this\', UNAME\'N3P\',\n"
"\'http://www.apple.com/metadata#\' || name),\n"
"cast (val as nvarchar) ) );\n"
"}\n"
"--src dav_meta.sql:2267\n";

static const char *proc279 = 
" create procedure DB.DBA.XML_UNIX_DATE_TO_ISO (in unixdt integer)\n"
"{\n"
"declare ts any;\n"
"if (not isinteger (unixdt))\n"
"return \'\';\n"
"ts := dateadd (\'second\', unixdt, stringdate (\'1970-1-1\'));\n"
"ts := dt_set_tz (ts, 0);\n"
"return soap_print_box (ts, \'\', 0);\n"
"}\n"
"--src dav_meta.sql:2278\n";

static const char *other7 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME)\n"
"VALUES (\'http://www.openlinksw.com/xsltext/:unixTime2ISO\', \'DB.DBA.XML_UNIX_DATE_TO_ISO\')\n";
static const char *other8 = 
"xpf_extension (\'http://www.openlinksw.com/xsltext/:unixTime2ISO\', \'DB.DBA.XML_UNIX_DATE_TO_ISO\', 0)\n";
static const char *proc280 = 
"create procedure DAV_EXTRACT_META_AS_RDF_XML (in resname varchar, in rescontent any := null)\n"
"{\n"
"declare res_type_uri, restype varchar;\n"
"declare html_start, type_tree any;\n"
"declare addon_n3, spotlight_addon_n3, ret any;\n"
"\n"
"if (rescontent is null)\n"
"rescontent := XML_URI_GET (resname, \'\');\n"
"html_start := null;\n"
"spotlight_addon_n3 := null;\n"
"addon_n3 := null;\n"
"restype := DAV_GUESS_MIME_TYPE (resname, rescontent, html_start);\n"
"if (restype is not null)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto addon_n3_set;\n"
"};\n"
"addon_n3 := call (\'DB.DBA.DAV_EXTRACT_RDF_\' || restype)(resname, rescontent, html_start);\n"
"res_type_uri := DAV_GET_RES_TYPE_URI_BY_MIME_TYPE(restype);\n"
"type_tree := xtree_doc (\'<N3 N3S=\"http://local.virt/this\" N3P=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#type\" N3O=\"\'\n"
"|| res_type_uri || \'\"/>\' );\n"
"addon_n3 := DAV_RDF_MERGE (addon_n3, type_tree, null, 0);\n"
"addon_n3_set: ;\n"
"}\n"
"if (__proc_exists (\'SPOTLIGHT_METADATA\', 2) is not null)\n"
"spotlight_addon_n3 := DAV_EXTRACT_SPOTLIGHT (resname, rescontent);\n"
"if (addon_n3 is null and spotlight_addon_n3 is null)\n"
"goto no_op;\n"
"\n"
"no_old:\n"
"if (spotlight_addon_n3 is not null)\n"
"{\n"
"if (addon_n3 is not null)\n"
"addon_n3 := DAV_RDF_MERGE (addon_n3, spotlight_addon_n3, null, 0);\n"
"else\n"
"addon_n3 := spotlight_addon_n3;\n"
"}\n"
"ret := xslt (\'http://local.virt/davxml2rdfxml\', addon_n3, vector (\'this-real-uri\', resname));\n"
"if (xpath_eval (\'count(/RDF/*)\', ret) = 0)\n"
"goto no_op;\n"
"ret := serialize_to_UTF8_xml (ret);\n"
"\n"
"ret := replace (ret, \'http://local.virt/this\', resname);\n"
"return ret;\n"
"no_op:\n"
"return NULL;\n"
"}\n"
"--src dav_meta.sql:2296\n";

/* dav_acct.sql */

static const char *proc281 = 
"create function DAV_SPACE_QUOTA_PARENT (in res_path varchar, out _u_id integer, out _above_hy datetime, out _dav_use numeric, out _total_use numeric, out _quota numeric) returns varchar\n"
"{\n"
"declare head, tail, _home_path varchar;\n"
"declare slash_pos integer;\n"
"declare cr cursor for select DSQ_HOME_PATH, DSQ_U_ID, DSQ_ABOVE_HI_YELLOW, DSQ_DAV_USE, DSQ_TOTAL_USE, DSQ_QUOTA from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH >= head and DSQ_HOME_PATH <= res_path;\n"
"\n"
"_home_path := \'\';\n"
"head := \'/\';\n"
"tail := subseq (res_path, 1);\n"
"while (1)\n"
"{\n"
"open cr;\n"
"whenever not found goto nf;\n"
"fetch cr into _home_path, _u_id, _above_hy, _dav_use, _total_use, _quota;\n"
"close cr;\n"
"if (_home_path = \"LEFT\" (res_path, length (_home_path)))\n"
"goto done;\n"
"\n"
"nf:\n"
"close cr;\n"
"slash_pos := strchr (tail, \'/\');\n"
"if (slash_pos is null)\n"
"{\n"
"_home_path := null;\n"
"goto done;\n"
"}\n"
"head := head || \"LEFT\" (tail, slash_pos + 1);\n"
"tail := subseq (tail, slash_pos + 1);\n"
"if (head < _home_path)\n"
"goto nf;\n"
"}\n"
"\n"
"done:\n"
"\n"
"return _home_path;\n"
"}\n"
"--src dav_acct.sql:22\n";

static const char *proc282 = 
"create function DAV_ADD_SPACE_QUOTA (in _home_path varchar, in _u_id integer, in _quota numeric) returns integer\n"
"{\n"
"declare home_id any;\n"
"declare old_u_id integer;\n"
"declare reloc_path varchar;\n"
"declare reloc_dav_use, reloc_quota, old_dav_use, dav_use, old_app_use, old_max_dav_use, old_max_app_use numeric;\n"
"declare reloc_above_hy, old_above_hy datetime;\n"
"if (not exists (select top 1 1 from WS.WS.SYS_DAV_USER where U_ID = _u_id))\n"
"return -6;\n"
"home_id := DAV_SEARCH_ID (_home_path, \'C\');\n"
"if (DAV_HIDE_ERROR (home_id) is null)\n"
"return home_id;\n"
"if (not (isinteger (home_id)))\n"
"return -33;\n"
"if (_home_path <> \'/\')\n"
"{\n"
"declare parent_path varchar;\n"
"declare parent_u_id integer;\n"
"declare parent_above_hy datetime;\n"
"declare parent_dav_use, parent_total_use, parent_quota numeric;\n"
"parent_path := DAV_SPACE_QUOTA_PARENT (_home_path, parent_u_id, parent_above_hy, parent_dav_use, parent_total_use, parent_quota);\n"
"if ((parent_path is not null) and (parent_path <> _home_path))\n"
"return -38;\n"
"}\n"
"reloc_path := null;\n"
"old_app_use := 0;\n"
"old_max_app_use := 0;\n"
"if (_u_id is null)\n"
"goto no_old_home;\n"
"whenever not found goto no_old_home;\n"
"select DSQ_HOME_PATH	, DSQ_DAV_USE	, DSQ_APP_USE	, DSQ_MAX_APP_USE	, DSQ_QUOTA	, DSQ_ABOVE_HI_YELLOW\n"
"into reloc_path	, reloc_dav_use	, old_app_use	, old_max_app_use	, reloc_quota	, reloc_above_hy\n"
"from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_U_ID = _u_id;\n"
"\n"
"no_old_home:\n"
"whenever not found goto do_insert;\n"
"select DSQ_U_ID, DSQ_ABOVE_HI_YELLOW, DSQ_DAV_USE, DSQ_MAX_DAV_USE into old_u_id, old_above_hy, old_dav_use, old_max_dav_use from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = _home_path;\n"
"if (old_u_id is not null)\n"
"{\n"
"if (old_u_id <> _u_id)\n"
"return -38;\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set DSQ_QUOTA = _quota where DSQ_HOME_PATH = _home_path and DSQ_QUOTA <> _quota;\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_U_ID = _u_id, DSQ_QUOTA = _quota,\n"
"DSQ_APP_USE = old_app_use,\n"
"DSQ_MAX_APP_USE = old_max_app_use,\n"
"DSQ_MAX_TOTAL_USE = __max (DSQ_MAX_DAV_USE, DSQ_DAV_USE + DSQ_APP_USE),\n"
"DSQ_ABOVE_HI_YELLOW = null, DSQ_LAST_WARNING = null\n"
"where DSQ_HOME_PATH = _home_path;\n"
"old_above_hy := null;\n"
"}\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (_home_path, _u_id, old_above_hy, old_dav_use + old_app_use, _quota);\n"
"goto update_reloc_path;\n"
"\n"
"do_insert:\n"
"dav_use := coalesce (\n"
"(select SUM (cast (length (RES_CONTENT) as numeric))\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH between _home_path and DAV_COL_PATH_BOUNDARY (_home_path) ),\n"
"0 );\n"
"insert into WS.WS.SYS_DAV_SPACE_QUOTA\n"
"(DSQ_U_ID		, DSQ_HOME_PATH		,\n"
"DSQ_DAV_USE	, DSQ_APP_USE		, DSQ_TOTAL_USE			,\n"
"DSQ_MAX_DAV_USE	, DSQ_MAX_APP_USE	, DSQ_MAX_TOTAL_USE		,\n"
"DSQ_QUOTA		, DSQ_ABOVE_HI_YELLOW	, DSQ_LAST_WARNING	)\n"
"values\n"
"(_u_id		, _home_path		,\n"
"dav_use		, old_app_use		, dav_use + old_app_use		,\n"
"dav_use		, old_max_app_use	, dav_use + old_max_app_use	,\n"
"_quota		, NULL			, NULL			);\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (_home_path, _u_id, null, dav_use + old_app_use, _quota);\n"
"\n"
"update_reloc_path:\n"
"if ((reloc_path is not null) and (reloc_path <> _home_path))\n"
"{\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_U_ID = null, DSQ_APP_USE = 0, DSQ_TOTAL_USE = DSQ_DAV_USE,\n"
"DSQ_MAX_APP_USE = 0, DSQ_MAX_TOTAL_USE = DSQ_MAX_DAV_USE,\n"
"DSQ_LAST_WARNING = null\n"
"where DSQ_HOME_PATH = reloc_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (reloc_path, null, reloc_above_hy, reloc_dav_use, reloc_quota);\n"
"}\n"
"return home_id;\n"
"}\n"
"--src dav_acct.sql:60\n";

static const char *proc283 = 
"create function DAV_DEL_SPACE_QUOTA (in _home_path varchar) returns integer\n"
"{\n"
"declare old_u_id integer;\n"
"declare old_quota numeric;\n"
"declare old_above_hy datetime;\n"
"whenever not found goto nf;\n"
"select DSQ_U_ID, DSQ_QUOTA, DSQ_ABOVE_HI_YELLOW into old_u_id, old_quota, old_above_hy\n"
"from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = _home_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (_home_path, old_u_id, old_above_hy, 0, old_quota);\n"
"delete from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = _home_path;\n"
"return 0;\n"
"\n"
"nf:\n"
"return -1;\n"
"}\n"
"--src dav_acct.sql:149\n";

static const char *proc284 = 
"create procedure DAV_SPACE_QUOTA_YELLOW_TRACK (in _home_path varchar, in _u_id integer, in old_above_hy datetime, in total_use numeric, in _quota numeric)\n"
"{\n"
"\n"
"set isolation=\'serializable\';\n"
"if (old_above_hy is not null)\n"
"{\n"
"if (total_use < (_quota * 0.75))\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
" ;\n"
"};\n"
"DAV_SPACE_QUOTA_LO_YELLOW_DOWN (_home_path, _u_id, total_use, _quota);\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set DSQ_ABOVE_HI_YELLOW = null where DSQ_HOME_PATH = _home_path;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (total_use > (_quota * 0.90))\n"
"{\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set DSQ_ABOVE_HI_YELLOW = now() where DSQ_HOME_PATH = _home_path;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
" ;\n"
"};\n"
"DAV_SPACE_QUOTA_HI_YELLOW_UP (_home_path, _u_id, total_use, _quota);\n"
"}\n"
"}\n"
"}\n"
"--src dav_acct.sql:166\n";

static const char *proc285 = 
"create procedure DAV_SPACE_QUOTA_SIGNAL (in res_path varchar, in home_path varchar, in _u_id integer, in _total_use numeric, in _quota numeric)\n"
"{\n"
"declare u_descr, msg varchar;\n"
"declare owner_u_id, home_col_id integer;\n"
"if (http_dav_uid () = coalesce (connection_get (\'DAVBillingUserID\'), -12))\n"
"return;\n"
"if (_u_id is not null)\n"
"u_descr := coalesce ((select \'quota of user \"\' || U_NAME || \'\"\' from SYS_USERS where U_ID = _u_id), sprintf (\'quota of user #%d\', _u_id));\n"
"else\n"
"{\n"
"home_col_id := DAV_SEARCH_ID (home_path, \'C\');\n"
"if (DAV_HIDE_ERROR (home_col_id) is null)\n"
"signal (\'HT500\', sprintf (\'DAV integrity violation: ancestor collection %s not found for resource %s\', home_path, res_path));\n"
"if (not isinteger (home_col_id))\n"
"signal (\'HT500\', sprintf (\'DAV integrity violation: collection %s is a DET subcollection, can not use DAV quotas for %s\', home_path, res_path));\n"
"owner_u_id := coalesce ((select COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = home_col_id), http_hobody_uid());\n"
"u_descr := coalesce ((select \'owner \"\' || U_NAME || \'\"\' from SYS_USERS where U_ID = owner_u_id), sprintf (\'owner #%d\', owner_u_id));\n"
"}\n"
"rollback work;\n"
"msg := sprintf (\'DAV quota exceeded for collection %s (%s): only %s bytes allowed but %s required.\',\n"
"home_path, u_descr, cast (_quota as varchar), cast (_total_use as varchar) );\n"
"\n"
"signal (\'HT507\', msg);\n"
"}\n"
"--src dav_acct.sql:199\n";

static const char *proc286 = 
"create procedure DAV_OWNER_DISABLED_SIGNAL (in res_path varchar, in _u_id integer)\n"
"{\n"
"declare u_descr, msg varchar;\n"
"declare owner_u_id, home_col_id integer;\n"
"if (_u_id = http_nobody_uid())\n"
"return;\n"
"if (http_dav_uid () = coalesce (connection_get (\'DAVBillingUserID\'), -12))\n"
"return;\n"
"u_descr := coalesce ((select \'\"\' || U_NAME || \'\"\' from SYS_USERS where U_ID = _u_id), sprintf (\'#%d\', _u_id));\n"
"rollback work;\n"
"msg := sprintf (\'The resource %s is unavailable because resource owner %s is disabled.\',\n"
"res_path, u_descr );\n"
"\n"
"signal (\'HT508\', msg);\n"
"}\n"
"--src dav_acct.sql:225\n";

static const char *proc287 = 
"create procedure DAV_HOME_DISABLED_SIGNAL (in res_path varchar, in home_path varchar, in _u_id integer)\n"
"{\n"
"declare u_descr, msg varchar;\n"
"declare owner_u_id, home_col_id integer;\n"
"if (http_dav_uid () = coalesce (connection_get (\'DAVBillingUserID\'), -12))\n"
"return;\n"
"u_descr := coalesce ((select \'user \"\' || U_NAME || \'\"\' from SYS_USERS where U_ID = _u_id), sprintf (\'user #%d\', _u_id));\n"
"rollback work;\n"
"msg := sprintf (\'Access to a home DAV collection %s of a disabled account (%s) is blocked.\',\n"
"home_path, u_descr );\n"
"\n"
"signal (\'HT509\', msg);\n"
"}\n"
"--src dav_acct.sql:242\n";

static const char *proc288 = 
"create procedure DAV_SPACE_QUOTA_RES_INSERT (in newr_path varchar, in newr_len integer)\n"
"{\n"
"declare parent_path varchar;\n"
"declare parent_u_id integer;\n"
"declare parent_above_hy datetime;\n"
"declare parent_dav_use, parent_total_use, parent_quota numeric;\n"
"\n"
"parent_path := DAV_SPACE_QUOTA_PARENT (newr_path, parent_u_id, parent_above_hy, parent_dav_use, parent_total_use, parent_quota);\n"
"if (parent_path is null)\n"
"goto done;\n"
"set isolation=\'committed\';\n"
"if (parent_u_id is not null and\n"
"exists (\n"
"select top 1 1 from SYS_USERS\n"
"where U_ID = parent_u_id and U_ACCOUNT_DISABLED ) )\n"
"DAV_HOME_DISABLED_SIGNAL (newr_path, parent_path, parent_u_id);\n"
"set isolation=\'serializable\';\n"
"parent_dav_use := parent_dav_use + newr_len;\n"
"parent_total_use := parent_total_use + newr_len;\n"
"if (parent_total_use > parent_quota)\n"
"DAV_SPACE_QUOTA_SIGNAL (newr_path, parent_path, parent_u_id, parent_total_use, parent_quota);\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_DAV_USE = parent_dav_use,\n"
"DSQ_TOTAL_USE = parent_total_use,\n"
"DSQ_MAX_DAV_USE = __max (DSQ_MAX_DAV_USE, parent_dav_use),\n"
"DSQ_MAX_TOTAL_USE = __max (DSQ_MAX_TOTAL_USE, parent_total_use)\n"
"where DSQ_HOME_PATH = parent_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (parent_path, parent_u_id, parent_above_hy, parent_total_use, parent_quota);\n"
"\n"
"done:\n"
"\n"
" ;\n"
"}\n"
"--src dav_acct.sql:257\n";

static const char *proc289 = 
"create procedure DAV_SPACE_QUOTA_RES_DELETE (in oldr_path varchar, in oldr_len integer)\n"
"{\n"
"declare parent_path varchar;\n"
"declare parent_u_id integer;\n"
"declare parent_above_hy datetime;\n"
"declare parent_dav_use, parent_total_use, parent_quota numeric;\n"
"\n"
"parent_path := DAV_SPACE_QUOTA_PARENT (oldr_path, parent_u_id, parent_above_hy, parent_dav_use, parent_total_use, parent_quota);\n"
"if (parent_path is null)\n"
"goto done;\n"
"set isolation=\'committed\';\n"
"if (parent_u_id is not null and\n"
"exists (\n"
"select top 1 1 from SYS_USERS\n"
"where U_ID = parent_u_id and U_ACCOUNT_DISABLED ) )\n"
"DAV_HOME_DISABLED_SIGNAL (oldr_path, parent_path, parent_u_id);\n"
"set isolation=\'serializable\';\n"
"parent_dav_use := parent_dav_use - oldr_len;\n"
"parent_total_use := parent_total_use - oldr_len;\n"
"if ((parent_dav_use < 0) or (parent_total_use < 0))\n"
"{\n"
"\n"
"parent_dav_use := coalesce (\n"
"(select SUM (cast (length (RES_CONTENT) as numeric))\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH between parent_path and DAV_COL_PATH_BOUNDARY (parent_path) ),\n"
"0 );\n"
"parent_total_use := parent_dav_use + (select __max (DSQ_APP_USE, 0) from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = parent_path);\n"
"}\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_DAV_USE = parent_dav_use,\n"
"DSQ_TOTAL_USE = parent_total_use\n"
"where DSQ_HOME_PATH = parent_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (parent_path, parent_u_id, parent_above_hy, parent_total_use, parent_quota);\n"
"\n"
"done:\n"
"\n"
" ;\n"
"}\n"
"--src dav_acct.sql:292\n";

static const char *proc290 = 
"create procedure DAV_SPACE_QUOTA_RES_UPDATE (in oldr_path varchar, in oldr_len integer, in newr_path varchar, in newr_len integer)\n"
"{\n"
"declare src_path, tgt_path varchar;\n"
"declare src_u_id, tgt_u_id integer;\n"
"declare src_above_hy, tgt_above_hy datetime;\n"
"declare src_dav_use, src_total_use, src_quota, tgt_dav_use, tgt_total_use, tgt_quota numeric;\n"
"\n"
"src_path := DAV_SPACE_QUOTA_PARENT (oldr_path, src_u_id, src_above_hy, src_dav_use, src_total_use, src_quota);\n"
"set isolation = \'committed\';\n"
"if (src_path is not null and src_u_id is not null and\n"
"exists (\n"
"select top 1 1 from SYS_USERS\n"
"where U_ID = src_u_id and U_ACCOUNT_DISABLED ) )\n"
"DAV_HOME_DISABLED_SIGNAL (oldr_path, src_path, src_u_id);\n"
"set isolation=\'serializable\';\n"
"if ((oldr_path = newr_path) or (src_path = \"LEFT\" (newr_path, length (src_path))))\n"
"{\n"
"\n"
"if (src_path is null)\n"
"goto done;\n"
"if (oldr_len = newr_len)\n"
"goto done;\n"
"\n"
"tgt_path := src_path;\n"
"tgt_above_hy := src_above_hy;\n"
"tgt_dav_use := src_dav_use;\n"
"tgt_total_use := src_total_use;\n"
"tgt_quota := src_quota;\n"
"if (oldr_len < newr_len)\n"
"{\n"
"newr_len := newr_len - oldr_len;\n"
"src_path := null;\n"
"}\n"
"else\n"
"{\n"
"oldr_len := oldr_len - newr_len;\n"
"tgt_path := null;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"\n"
"tgt_path := DAV_SPACE_QUOTA_PARENT (newr_path, tgt_u_id, tgt_above_hy, tgt_dav_use, tgt_total_use, tgt_quota);\n"
"if (src_path is null and tgt_path is null)\n"
"goto done;\n"
"set isolation=\'committed\';\n"
"if (tgt_u_id is not null and\n"
"exists (\n"
"select top 1 1 from SYS_USERS\n"
"where U_ID = tgt_u_id and U_ACCOUNT_DISABLED ) )\n"
"DAV_HOME_DISABLED_SIGNAL (newr_path, tgt_path, tgt_u_id);\n"
"set isolation=\'serializable\';\n"
"}\n"
"if (tgt_path is not null)\n"
"{\n"
"tgt_dav_use := tgt_dav_use + newr_len;\n"
"tgt_total_use := tgt_total_use + newr_len;\n"
"if (tgt_total_use > tgt_quota)\n"
"DAV_SPACE_QUOTA_SIGNAL (newr_path, tgt_path, tgt_u_id, tgt_total_use, tgt_quota);\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_DAV_USE = tgt_dav_use,\n"
"DSQ_TOTAL_USE = tgt_total_use,\n"
"DSQ_MAX_DAV_USE = __max (DSQ_MAX_DAV_USE, tgt_dav_use),\n"
"DSQ_MAX_TOTAL_USE = __max (DSQ_MAX_TOTAL_USE, tgt_total_use)\n"
"where DSQ_HOME_PATH = tgt_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (tgt_path, tgt_u_id, tgt_above_hy, tgt_total_use, tgt_quota);\n"
"}\n"
"if (src_path is not null)\n"
"{\n"
"src_dav_use := src_dav_use - oldr_len;\n"
"src_total_use := src_total_use - oldr_len;\n"
"if ((src_dav_use < 0) or (src_total_use < 0))\n"
"{\n"
"\n"
"src_dav_use :=  coalesce (\n"
"(select SUM (cast (length (RES_CONTENT) as numeric))\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH between src_path and DAV_COL_PATH_BOUNDARY (src_path) ),\n"
"0 );\n"
"src_total_use := src_dav_use + (select __max (DSQ_APP_USE, 0) from WS.WS.SYS_DAV_SPACE_QUOTA where DSQ_HOME_PATH = src_path);\n"
"}\n"
"update WS.WS.SYS_DAV_SPACE_QUOTA set\n"
"DSQ_DAV_USE = src_dav_use,\n"
"DSQ_TOTAL_USE = src_total_use\n"
"where DSQ_HOME_PATH = src_path;\n"
"DAV_SPACE_QUOTA_YELLOW_TRACK (src_path, src_u_id, src_above_hy, src_total_use, src_quota);\n"
"}\n"
"\n"
"done:\n"
"\n"
" ;\n"
"}\n"
"--src dav_acct.sql:333\n";

/* dav_rdf_quad.sql */

static const char *proc291 = 
"create procedure DB.DBA.RDF_DELETE_ENTIRE_GRAPH (in new_dav_graph varchar, in param integer)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G = DB.DBA.RDF_MAKE_IID_OF_QNAME (new_dav_graph);\n"
"}\n"
"--src dav_rdf_quad.sql:22\n";

static const char *proc292 = 
"create function DB.DBA.DAV_FULL_PATH_TO_IRI (in dav_iri varchar, in _str varchar) returns varchar\n"
"{\n"
"declare _ses any;\n"
"_ses := string_output();\n"
"http (dav_iri, _ses);\n"
"http_escape (subseq (_str, 4), 7, _ses, 0, 1);\n"
"return string_output_string(_ses);\n"
"}\n"
"--src dav_rdf_quad.sql:28\n";

static const char *proc293 = 
"create procedure DB.DBA.DAV_AUTO_REPLICATE_TO_RDF_QUAD ()\n"
"{\n"
"declare uriqa_default_host, old_dav_graph, new_dav_graph varchar;\n"
"uriqa_default_host := cfg_item_value (virtuoso_ini_path (), \'URIQA\',\'DefaultHost\');\n"
"if (isstring (registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\')))\n"
"return;\n"
"if (uriqa_default_host is null or uriqa_default_host = \'\')\n"
"return;\n"
"DB.DBA.DAV_REPLICATE_ALL_TO_RDF_QUAD (1);\n"
"}\n"
"--src dav_rdf_quad.sql:38\n";

static const char *proc294 = 
"create procedure DB.DBA.DAV_REPLICATE_ALL_TO_RDF_QUAD (in enable integer)\n"
"{\n"
"declare uriqa_default_host, old_dav_graph, new_dav_graph varchar;\n"
"declare trx_size integer;\n"
"uriqa_default_host := cfg_item_value (virtuoso_ini_path (), \'URIQA\',\'DefaultHost\');\n"
"if (uriqa_default_host is null or uriqa_default_host = \'\')\n"
"signal (\'OBLOM\', \'No uriqa_default_host!\');\n"
"\n"
"new_dav_graph := \'local:/DAV\';\n"
"exec (\'checkpoint\');\n"
"__atomic (1);\n"
"DB.DBA.RDF_DELETE_ENTIRE_GRAPH (new_dav_graph, 1);\n"
"old_dav_graph := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (isstring (old_dav_graph) and old_dav_graph <> new_dav_graph and old_dav_graph <> \'\')\n"
"DB.DBA.RDF_DELETE_ENTIRE_GRAPH (old_dav_graph, 1);\n"
"if (not enable)\n"
"{\n"
"registry_set (\'DB.DBA.DAV_RDF_GRAPH_URI\', \'\');\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"return;\n"
"}\n"
"declare state, msg any;\n"
"declare status varchar;\n"
"state := \'00000\';\n"
"result_names (status);\n"
"state := \'00000\';\n"
"exec (\'create index SYS_DAV_RES_IID on WS.WS.SYS_DAV_RES (RES_IID)\', state, msg, vector ());\n"
"if (state <> \'00000\')\n"
"result (\'warning: index in WS.WS.SYS_DAV_RES\');\n"
"state := \'00000\';\n"
"exec (\'create index SYS_DAV_COL_IID on WS.WS.SYS_DAV_COL (COL_IID)\', state, msg, vector ());\n"
"if (state <> \'00000\')\n"
"result (\'warning: index in WS.WS.SYS_DAV_COL\');\n"
"registry_set (\'DB.DBA.DAV_RDF_GRAPH_URI\', new_dav_graph);\n"
"trx_size := 0;\n"
"for (select RES_ID, RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_PERMS[6] = 49) do\n"
"{\n"
"trx_size := trx_size + DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (RES_ID, RES_FULL_PATH);\n"
"if (trx_size > 10000)\n"
"{\n"
"commit work;\n"
"trx_size := 0;\n"
"}\n"
"}\n"
"commit work;\n"
"trx_size := 0;\n"
"for (select COL_ID from WS.WS.SYS_DAV_COL where COL_PERMS[6] = 49) do\n"
"{\n"
"trx_size := trx_size + DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (COL_ID);\n"
"if (trx_size > 10000)\n"
"{\n"
"commit work;\n"
"trx_size := 0;\n"
"}\n"
"}\n"
"commit work;\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"return;\n"
"}\n"
"--src dav_rdf_quad.sql:50\n";

static const char *proc295 = 
"create procedure DB.DBA.RDF_CBD_DELETE (inout triple_list any, in graph_id any, in local_dav_uri any)\n"
"{\n"
"declare not_deleteable, candidates any;\n"
"declare cand_ctr, cand_first_unconfirmed, cand_count integer;\n"
"\n"
"set isolation = \'committed\';\n"
"not_deleteable := dict_new ();\n"
"again:\n"
"candidates := dict_new ();\n"
"foreach (any triple in triple_list) do\n"
"{\n"
"declare obj any;\n"
"obj := triple[2];\n"
"delete from DB.DBA.RDF_QUAD where G = graph_id and S = triple[0] and P = triple[1] and equ (O, obj);\n"
"if (isiri_id (obj) and not dict_get (not_deleteable, obj, 0))\n"
"dict_put (candidates, obj, 1);\n"
"}\n"
"candidates := dict_list_keys (candidates, 1);\n"
"gvector_sort (candidates, 1, 0, 1);\n"
"cand_count := length (candidates);\n"
"cand_first_unconfirmed := 0;\n"
"for (cand_ctr := 0; cand_ctr < cand_count; cand_ctr := cand_ctr + 1)\n"
"{\n"
"declare obj any;\n"
"obj := candidates [cand_ctr];\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_QUAD where G = graph_id and S = obj))\n"
"goto non_del;\n"
"if (obj < #i1000000000)\n"
"{\n"
"declare qname varchar;\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD where P = obj))\n"
"goto non_del;\n"
"if (exists (select top 1 1 from DB.DBA.RDF_DATATYPE where RDT_IID = obj))\n"
"goto non_del;\n"
"qname := id_to_iri (obj);\n"
"\n"
"if (qname is null)\n"
"goto non_del;\n"
"if (qname >= local_dav_uri and qname < concat (local_dav_uri, \'\\377\\377\\377\\377\'))\n"
"goto non_del;\n"
"}\n"
"\n"
"\n"
"candidates [cand_first_unconfirmed] := obj;\n"
"cand_first_unconfirmed := cand_first_unconfirmed + 1;\n"
"goto next_cand;\n"
"\n"
"non_del:\n"
"dict_put (not_deleteable, obj, 1);\n"
"\n"
"next_cand: ;\n"
"}\n"
"\n"
"if (0 = cand_first_unconfirmed)\n"
"return;\n"
"\n"
"vectorbld_init (triple_list);\n"
"for (cand_ctr := 0; cand_ctr < cand_first_unconfirmed; cand_ctr := cand_ctr + 1)\n"
"{\n"
"declare obj any;\n"
"obj := candidates [cand_ctr];\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_QUAD\n"
"where G = graph_id and O = obj option (quietcast) ) )\n"
"{\n"
"for (select P,O from DB.DBA.RDF_QUAD where G = graph_id and S = obj) do\n"
"vectorbld_acc (triple_list, vector (obj,P,O));\n"
"}\n"
"}\n"
"vectorbld_final (triple_list);\n"
"if (0 <> length (triple_list))\n"
"goto again;\n"
"}\n"
"--src dav_rdf_quad.sql:113\n";

static const char *proc296 = 
"create procedure DB.DBA.DAV_RDF_URI_RESOLVE (in dav_rdf_graph_uri varchar, in iri any, in fullpath varchar, in res_type varchar) returns varchar\n"
"{\n"
"declare abs_uri varchar;\n"
"if (iri = \'http://local.virt/this\')\n"
"abs_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"\n"
"\n"
"else if (left (iri, 22) = \'http://local.virt/DAV/\')\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"abs_uri := dav_rdf_graph_uri || subseq (iri, 22);\n"
"}\n"
"else\n"
"{\n"
"declare base_uri varchar;\n"
"base_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"abs_uri := DB.DBA.XML_URI_RESOLVE_LIKE_GET (base_uri, iri);\n"
"}\n"
"return abs_uri;\n"
"}\n"
"--src dav_rdf_quad.sql:187\n";

static const char *proc297 = 
"create procedure DB.DBA.DAV_RDF_REPLICATE_INT (in res_id integer, in restype varchar, in fullpath varchar)\n"
"{\n"
"declare n3v, n3_list, dav_rdf_graph_iid any;\n"
"declare dav_rdf_graph_uri varchar;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"whenever not found goto no_op;\n"
"select xml_tree_doc (deserialize (blob_to_string (PROP_VALUE)))\n"
"into n3v\n"
"from WS.WS.SYS_DAV_PROP\n"
"where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = res_id;\n"
"n3v := xslt (\'http://local.virt/davxml2n3xml\', n3v);\n"
"n3_list := xpath_eval (\'/N3\', n3v, 0);\n"
"foreach (any n3 in n3_list) do\n"
"{\n"
"declare s, p, o, dt, lang, v varchar;\n"
"s := xpath_eval (\'@N3S\', n3);\n"
"p := xpath_eval (\'@N3P\', n3);\n"
"o := xpath_eval (\'@N3O\', n3);\n"
"s := DB.DBA.DAV_RDF_URI_RESOLVE (dav_rdf_graph_uri, s, fullpath, restype);\n"
"if (o is not null)\n"
"o := DB.DBA.DAV_RDF_URI_RESOLVE (dav_rdf_graph_uri, o, fullpath, restype);\n"
"dt := xpath_eval (\'@N3DT\', n3);\n"
"lang := xpath_eval (\'@xml:lang\', n3);\n"
"v := coalesce (xquery_eval (\'if (exists(*)) then * else string ()\', n3), \'\');\n"
"if (isarray(v))\n"
"v := v[0];\n"
"\n"
"if (o is not null)\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, s, p, o);\n"
"else\n"
"DB.DBA.RDF_QUAD_URI_L_TYPED (dav_rdf_graph_uri, s, p, v, dt, lang);\n"
"\n"
"}\n"
"no_op:;\n"
"}\n"
"--src dav_rdf_quad.sql:213\n";

static const char *proc298 = 
"create procedure DB.DBA.DAV_RDF_CBD_DELETE_PROP (in n3v any, in fullpath varchar, in restype varchar, in dav_rdf_graph_iid IRI_ID, in dav_rdf_graph_uri varchar)\n"
"{\n"
"declare n3_list, triple_list any;\n"
"\n"
"n3v := xslt (\'http://local.virt/davxml2n3xml\', n3v);\n"
"n3_list := xpath_eval (\'/N3\', n3v, 0);\n"
"vectorbld_init (triple_list);\n"
"foreach (any n3 in n3_list) do\n"
"{\n"
"declare lang, v, app_env varchar;\n"
"declare s, p, o, dt any;\n"
"s := xpath_eval (\'@N3S\', n3);\n"
"p := xpath_eval (\'@N3P\', n3);\n"
"o := xpath_eval (\'@N3O\', n3);\n"
"s := DB.DBA.DAV_RDF_URI_RESOLVE (dav_rdf_graph_uri, s, fullpath, restype);\n"
"if (o is not null)\n"
"o := DB.DBA.DAV_RDF_URI_RESOLVE (dav_rdf_graph_uri, o, fullpath, restype);\n"
"dt := xpath_eval (\'@N3DT\', n3);\n"
"lang := xpath_eval (\'@xml:lang\', n3);\n"
"v := coalesce (xquery_eval (\'if (exists(*)) then * else string ()\', n3), \'\');\n"
"if (isarray(v))\n"
"v := v[0];\n"
"\n"
"s := DB.DBA.RDF_MAKE_IID_OF_QNAME (s);\n"
"p := DB.DBA.RDF_MAKE_IID_OF_QNAME (p);\n"
"if (o is not null)\n"
"o := DB.DBA.RDF_MAKE_IID_OF_QNAME (o);\n"
"else\n"
"{\n"
"if (dt is not null)\n"
"dt := DB.DBA.RDF_MAKE_IID_OF_QNAME (dt);\n"
"o := DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (v, dt, lang);\n"
"}\n"
"vectorbld_acc (triple_list, vector (s, p, o));\n"
"}\n"
"vectorbld_final (triple_list);\n"
"DB.DBA.RDF_CBD_DELETE (triple_list, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"--src dav_rdf_quad.sql:253\n";

static const char *proc299 = 
"create function DB.DBA.DAV_MAKE_USER_IRI (in userid integer)\n"
"{\n"
"declare email varchar;\n"
"email := (select U_E_MAIL from DB.DBA.SYS_USERS where U_ID = userid);\n"
"if (email is null or email=\'\')\n"
"{\n"
"declare uriqa_default_host varchar;\n"
"uriqa_default_host := cfg_item_value (virtuoso_ini_path (), \'URIQA\',\'DefaultHost\');\n"
"if (not isstring (uriqa_default_host))\n"
"signal (\'22023\', \'Function DB.DBA.DAV_MAKE_USER_IRI() has failed to get \"DefaultHost\" parameter of [URIQA] section of Virtuoso configuration file\');\n"
"email := sprintf (\'mailto:UserId%d@%s\', userid, uriqa_default_host);\n"
"}\n"
"else\n"
"{\n"
"if (left (email, 7) <> \'mailto:\')\n"
"email := concat (\'mailto:\', email);\n"
"}\n"
"return email;\n"
"}\n"
"--src dav_rdf_quad.sql:293\n";

static const char *proc300 = 
"create procedure DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (in res_id2 integer, in fullpath varchar)\n"
"{\n"
"declare dav_rdf_graph_uri, new_uri, tags, email varchar;\n"
"declare new_iid any;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or dav_rdf_graph_uri = \'\')\n"
"return;\n"
"DB.DBA.DAV_RDF_REPLICATE_INT (res_id2, \'R\', fullpath);\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"declare cr_time, mod_time datetime;\n"
"declare len, owner integer;\n"
"select RES_CR_TIME, RES_MOD_TIME, length (RES_CONTENT), RES_OWNER into cr_time, mod_time, len, owner from WS.WS.SYS_DAV_RES where RES_ID = res_id2;\n"
"email := DB.DBA.DAV_MAKE_USER_IRI (owner);\n"
"tags := coalesce ((select DT_TAGS from WS.WS.SYS_DAV_TAG where DT_RES_ID = res_id2 and DT_U_ID = http_nobody_uid()));\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/created\', cr_time);\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', mod_time);\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/extent\', len);\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#ownerUser\', email);\n"
"if (tags is not null)\n"
"{\n"
"declare tag_list any;\n"
"tag_list := split_and_decode (tags, 0, \'\\0\\0,\');\n"
"foreach (varchar tag in tag_list) do\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#tag\', tag);\n"
"}\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_IID=new_iid where RES_ID = res_id2;\n"
"set triggers on;\n"
"}\n"
"--src dav_rdf_quad.sql:314\n";

static const char *proc301 = 
"create procedure DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (in col_id2 integer)\n"
"{\n"
"declare dav_rdf_graph_uri, fullpath, new_uri varchar;\n"
"declare new_iid any;\n"
"fullpath := DAV_SEARCH_PATH (col_id2, \'C\');\n"
"if (DAV_HIDE_ERROR (fullpath) is null)\n"
"return;\n"
"DB.DBA.DAV_RDF_REPLICATE_INT (col_id2, \'C\', fullpath);\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or dav_rdf_graph_uri = \'\')\n"
"return;\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"declare cr_time, mod_time datetime;\n"
"declare owner integer;\n"
"declare email varchar;\n"
"select COL_CR_TIME, COL_MOD_TIME, COL_OWNER into cr_time, mod_time, owner from WS.WS.SYS_DAV_COL where COL_ID = col_id2;\n"
"email := DB.DBA.DAV_MAKE_USER_IRI (owner);\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/created\', cr_time);\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', mod_time);\n"
"\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#ownerUser\', email);\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_COL set COL_IID=new_iid where COL_ID = col_id2;\n"
"set triggers on;\n"
"}\n"
"--src dav_rdf_quad.sql:346\n";

static const char *trig22 = 
"create trigger SYS_DAV_PROP_AFTER_INSERT_PROP after insert on WS.WS.SYS_DAV_PROP referencing new as N\n"
"{\n"
"declare perms varchar;\n"
"if (N.PROP_NAME = \'http://local.virt/DAV-RDF\')\n"
"{\n"
"whenever not found goto no_op;\n"
"if (N.PROP_TYPE = \'R\')\n"
"{\n"
"declare fullpath varchar;\n"
"select RES_FULL_PATH, RES_PERMS into fullpath, perms from WS.WS.SYS_DAV_RES where RES_ID = N.PROP_PARENT_ID;\n"
"if (perms[6] = 49)\n"
"DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (N.PROP_PARENT_ID, fullpath);\n"
"}\n"
"else if (N.PROP_TYPE = \'C\')\n"
"{\n"
"select COL_PERMS into perms from WS.WS.SYS_DAV_COL where COL_ID = N.PROP_PARENT_ID;\n"
"if (perms[6] = 49)\n"
"DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (N.PROP_PARENT_ID);\n"
"}\n"
"}\n"
"no_op: ;\n"
"}\n"
"--src dav_rdf_quad.sql:374\n";

static const char *trig23 = 
"create trigger SYS_DAV_PROP_RDF_QUAD_BEFORE_DELETE before delete on WS.WS.SYS_DAV_PROP referencing old as O\n"
"{\n"
"declare fullpath, perms varchar;\n"
"declare colid integer;\n"
"if (O.PROP_TYPE = \'C\')\n"
"select COL_ID, COL_PERMS into colid, perms from WS.WS.SYS_DAV_COL where COL_ID = O.PROP_PARENT_ID;\n"
"else if (O.PROP_TYPE = \'R\')\n"
"select RES_PERMS, RES_FULL_PATH into perms, fullpath from WS.WS.SYS_DAV_RES where RES_ID = O.PROP_PARENT_ID;\n"
"if (O.PROP_NAME = \'http://local.virt/DAV-RDF\')\n"
"{\n"
"declare n3_tmp_list, res_vec, dav_rdf_graph_iid any;\n"
"declare dav_rdf_graph_uri varchar;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"n3_tmp_list := xml_tree_doc (deserialize (blob_to_string (O.PROP_VALUE)));\n"
"DB.DBA.DAV_RDF_CBD_DELETE_PROP (n3_tmp_list, fullpath, O.PROP_TYPE, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:398\n";

static const char *trig24 = 
"create trigger SYS_DAV_PROP_RDF_QUAD_AFTER_UPDATE after update on WS.WS.SYS_DAV_PROP referencing new as N, old as O\n"
"{\n"
"declare fullpath, perms varchar;\n"
"declare colid integer;\n"
"if ((O.PROP_NAME <> \'http://local.virt/DAV-RDF\') and (N.PROP_NAME <> \'http://local.virt/DAV-RDF\'))\n"
"return;\n"
"if ((O.PROP_NAME = N.PROP_NAME) and (blob_to_string (O.PROP_VALUE) = blob_to_string (N.PROP_VALUE)))\n"
"return;\n"
"if (N.PROP_TYPE = \'C\')\n"
"select COL_ID, COL_PERMS into colid, perms from WS.WS.SYS_DAV_COL where COL_ID = O.PROP_PARENT_ID;\n"
"if (N.PROP_TYPE = \'R\')\n"
"select RES_PERMS, RES_FULL_PATH into perms, fullpath from WS.WS.SYS_DAV_RES where RES_ID = O.PROP_PARENT_ID;\n"
"if (perms[6] = 49)\n"
"{\n"
"if (N.PROP_TYPE = \'C\')\n"
"fullpath := DAV_SEARCH_PATH (colid, \'C\');\n"
"if (O.PROP_NAME = \'http://local.virt/DAV-RDF\')\n"
"{\n"
"declare n3_list, res_vec, dav_rdf_graph_iid any;\n"
"declare dav_rdf_graph_uri varchar;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"n3_list := xml_tree_doc (deserialize (blob_to_string (O.PROP_VALUE)));\n"
"DB.DBA.DAV_RDF_CBD_DELETE_PROP (n3_list, fullpath, O.PROP_TYPE, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"if (N.PROP_NAME = \'http://local.virt/DAV-RDF\')\n"
"{\n"
"if (N.PROP_TYPE = \'R\')\n"
"{\n"
"if (fullpath is not null)\n"
"DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (N.PROP_PARENT_ID, fullpath);\n"
"}\n"
"if (N.PROP_TYPE = \'C\')\n"
"DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (N.PROP_PARENT_ID);\n"
"}\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:420\n";

static const char *trig25 = 
"create trigger SYS_DAV_TAG_RDF_QUAD_AFTER_INSERT after insert on WS.WS.SYS_DAV_TAG referencing new as NT\n"
"{\n"
"declare tag_list any;\n"
"declare fullpath, dav_rdf_graph_uri, new_uri varchar;\n"
"if (NT.DT_U_ID <> http_nobody_uid())\n"
"return;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"whenever not found goto nf;\n"
"select RES_FULL_PATH into fullpath from WS.WS.SYS_DAV_RES where RES_ID = NT.DT_RES_ID and RES_PERMS[6] = 49;\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"tag_list := split_and_decode (NT.DT_TAGS, 0, \'\\0\\0,\');\n"
"foreach (varchar tag in tag_list) do\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#tag\', tag);\n"
"nf: ;\n"
"}\n"
"--src dav_rdf_quad.sql:462\n";

static const char *trig26 = 
"create trigger SYS_DAV_TAG_RDF_QUAD_AFTER_UPDATE after update on WS.WS.SYS_DAV_TAG referencing new as NT\n"
"{\n"
"declare tag_list, dav_rdf_graph_iid, new_iid, p_iid any;\n"
"declare fullpath, dav_rdf_graph_uri, new_uri varchar;\n"
"if (NT.DT_U_ID <> http_nobody_uid())\n"
"return;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"whenever not found goto nf;\n"
"select RES_FULL_PATH into fullpath from WS.WS.SYS_DAV_RES where RES_ID = NT.DT_RES_ID and RES_PERMS[6] = 49;\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, fullpath);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://www.openlinksw.com/schemas/DAV#tag\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"tag_list := split_and_decode (NT.DT_TAGS, 0, \'\\0\\0,\');\n"
"foreach (varchar tag in tag_list) do\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#tag\', tag);\n"
"nf: ;\n"
"}\n"
"--src dav_rdf_quad.sql:482\n";

static const char *trig27 = 
"create trigger SYS_DAV_TAG_RDF_QUAD_BEFORE_DELETE before delete on WS.WS.SYS_DAV_TAG referencing old as OT\n"
"{\n"
"declare tag_list, dav_rdf_graph_iid, old_iid, p_iid any;\n"
"declare dav_rdf_graph_uri varchar;\n"
"if (OT.DT_U_ID <> http_nobody_uid())\n"
"return;\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"whenever not found goto nf;\n"
"select RES_IID into old_iid from WS.WS.SYS_DAV_RES where RES_ID = OT.DT_RES_ID and RES_IID is not null;\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://www.openlinksw.com/schemas/DAV#tag\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = old_iid;\n"
"nf: ;\n"
"}\n"
"--src dav_rdf_quad.sql:506\n";

static const char *trig28 = 
"create trigger SYS_DAV_RES_RDF_QUAD_AFTER_INSERT after insert on WS.WS.SYS_DAV_RES order 30 referencing new as N\n"
"{\n"
"if (N.RES_PERMS[6] = 49)\n"
"DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (N.RES_ID, N.RES_FULL_PATH);\n"
"}\n"
"--src dav_rdf_quad.sql:525\n";

static const char *trig29 = 
"create trigger SYS_DAV_RES_RDF_QUAD_AFTER_UPDATE after update (RES_COL, RES_NAME, RES_FULL_PATH, RES_PERMS, RES_OWNER, RES_CONTENT, RES_CR_TIME, RES_MOD_TIME) on WS.WS.SYS_DAV_RES order 30 referencing new as NC, old as OC\n"
"{\n"
"declare new_iid, dav_rdf_graph_iid, p_iid any;\n"
"declare new_uri, dav_rdf_graph_uri varchar;\n"
"\n"
"\n"
"if (OC.RES_PERMS[6] = 49 or NC.RES_PERMS[6] = 49)\n"
"{\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"}\n"
"else\n"
"return;\n"
"if (NC.RES_PERMS[6] = 49)\n"
"{\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, NC.RES_FULL_PATH);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"}\n"
"else\n"
"new_uri := new_iid := null;\n"
"if (OC.RES_IID is null)\n"
"{\n"
"DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD (NC.RES_ID, NC.RES_FULL_PATH);\n"
"return;\n"
"}\n"
"if (new_iid is null)\n"
"{\n"
"declare spo any;\n"
"select VECTOR_AGG (vector (S, P, O)) into spo from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and S=OC.RES_IID;\n"
"RDF_CBD_DELETE (spo, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_IID=null where RES_ID=NC.RES_ID;\n"
"set triggers on;\n"
"return;\n"
"}\n"
"if (OC.RES_IID <> new_iid)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and ((isiri_id (O) and O=new_iid) or S=new_iid);\n"
"update DB.DBA.RDF_QUAD set S=new_iid where G=dav_rdf_graph_iid and S=OC.RES_IID;\n"
"update DB.DBA.RDF_QUAD set O=new_iid where G=dav_rdf_graph_iid and isiri_id (O) and O=OC.RES_IID;\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_IID=new_iid where RES_ID=NC.RES_ID;\n"
"set triggers on;\n"
"}\n"
"if (OC.RES_OWNER <> NC.RES_OWNER)\n"
"{\n"
"declare email varchar;\n"
"email := DB.DBA.DAV_MAKE_USER_IRI (NC.RES_OWNER);\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://www.openlinksw.com/schemas/DAV#ownerUser\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#ownerUser\', email);\n"
"}\n"
"if (length (OC.RES_CONTENT) <> length (NC.RES_CONTENT))\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/extent\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/extent\', length (NC.RES_CONTENT));\n"
"}\n"
"if (OC.RES_CR_TIME <> NC.RES_CR_TIME)\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/created\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/created\', NC.RES_CR_TIME);\n"
"}\n"
"if (OC.RES_MOD_TIME <> NC.RES_MOD_TIME)\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/modified\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', NC.RES_MOD_TIME);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:532\n";

static const char *trig30 = 
"create trigger SYS_DAV_RES_RDF_QUAD_BEFORE_DELETE before delete on WS.WS.SYS_DAV_RES order 30 referencing old as OC\n"
"{\n"
"declare spo, dav_rdf_graph_uri, dav_rdf_graph_iid any;\n"
"if (OC.RES_IID is not null)\n"
"{\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"select VECTOR_AGG (vector (S, P, O)) into spo from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and S=OC.RES_IID;\n"
"RDF_CBD_DELETE (spo, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:608\n";

static const char *trig31 = 
"create trigger SYS_DAV_COL_RDF_QUAD_AFTER_CREATE after insert on WS.WS.SYS_DAV_COL order 30 referencing new as NC\n"
"{\n"
"if (NC.COL_PERMS[6] = 49)\n"
"DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (NC.COL_ID);\n"
"}\n"
"--src dav_rdf_quad.sql:624\n";

static const char *proc302 = 
"create procedure DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (\n"
"in dav_rdf_graph_uri varchar, in dav_rdf_graph_iid IRI_ID,\n"
"in colid integer, in colispublic integer,\n"
"in coluri varchar, in coliid IRI_ID, in old_coliid IRI_ID )\n"
"{\n"
"if (colispublic)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and ((isiri_id (O) and O=coliid) or S=coliid);\n"
"update DB.DBA.RDF_QUAD set S=coliid where G=dav_rdf_graph_iid and S=old_coliid;\n"
"update DB.DBA.RDF_QUAD set O=coliid where G=dav_rdf_graph_iid and isiri_id (O) and O=old_coliid;\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_COL set COL_IID=coliid where COL_ID=colid;\n"
"set triggers on;\n"
"}\n"
"for (select sub.COL_ID as subid, sub.COL_NAME as subname, sub.COL_PERMS as subperms, sub.COL_IID as old_subiid\n"
"from WS.WS.SYS_DAV_COL as sub where sub.COL_PARENT = colid ) do\n"
"{\n"
"declare subispublic integer;\n"
"declare suburi_ses, subiid any;\n"
"suburi_ses := string_output ();\n"
"http (coluri, suburi_ses);\n"
"http_escape (subname, 7, suburi_ses, 0, 1);\n"
"http (\'/\', suburi_ses);\n"
"suburi_ses := string_output_string (suburi_ses);\n"
"if (subperms[6] = 49)\n"
"{\n"
"subispublic := 1;\n"
"subiid := DB.DBA.RDF_MAKE_IID_OF_QNAME (suburi_ses);\n"
"}\n"
"else\n"
"{\n"
"subispublic := 0;\n"
"subiid := NULL;\n"
"}\n"
"DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (\n"
"dav_rdf_graph_uri, dav_rdf_graph_iid,\n"
"subid, subispublic,\n"
"suburi_ses, subiid, old_subiid );\n"
"}\n"
"for (select res.RES_ID as resid, res.RES_IID as old_resiid, res.RES_FULL_PATH as resfullpath\n"
"from WS.WS.SYS_DAV_RES as res where res.RES_COL = colid and res.RES_IID is not null) do\n"
"{\n"
"declare new_uri varchar;\n"
"declare new_iid IRI_ID;\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, resfullpath);\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"if (old_resiid <> new_iid)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and ((isiri_id (O) and O=new_iid) or S=new_iid);\n"
"update DB.DBA.RDF_QUAD set S=new_iid where G=dav_rdf_graph_iid and S=old_resiid;\n"
"update DB.DBA.RDF_QUAD set O=new_iid where G=dav_rdf_graph_iid and isiri_id (O) and O=old_resiid;\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_IID=new_iid where RES_ID=resid;\n"
"set triggers on;\n"
"}\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:632\n";

static const char *trig32 = 
"create trigger SYS_DAV_COL_RDF_QUAD_AFTER_UPDATE after update (COL_NAME, COL_PARENT, COL_PERMS, COL_OWNER, COL_CR_TIME, COL_MOD_TIME) on WS.WS.SYS_DAV_COL order 30 referencing new as NC, old as OC\n"
"{\n"
"declare new_iid, dav_rdf_graph_iid, p_iid any;\n"
"declare new_uri, dav_rdf_graph_uri varchar;\n"
"declare path_change integer;\n"
"if ((OC.COL_NAME <> NC.COL_NAME) or (OC.COL_PARENT <> NC.COL_PARENT))\n"
"path_change := 1;\n"
"else\n"
"path_change := 0;\n"
"if (OC.COL_PERMS[6] = 49 or NC.COL_PERMS[6] = 49 or path_change)\n"
"{\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"}\n"
"else\n"
"return;\n"
"if (NC.COL_PERMS[6] = 49 or path_change)\n"
"{\n"
"declare new_full_path varchar;\n"
"new_full_path := DAV_SEARCH_PATH (NC.COL_ID, \'C\');\n"
"new_uri := DB.DBA.DAV_FULL_PATH_TO_IRI (dav_rdf_graph_uri, new_full_path);\n"
"if (NC.COL_PERMS[6] = 49)\n"
"new_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (new_uri);\n"
"else\n"
"new_iid := null;\n"
"}\n"
"else\n"
"new_uri := new_iid := null;\n"
"if (OC.COL_IID is null)\n"
"{\n"
"DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD (NC.COL_ID);\n"
"if (path_change)\n"
"DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (dav_rdf_graph_uri, dav_rdf_graph_iid, NC.COL_ID, 0, new_uri, new_iid, null);\n"
"return;\n"
"}\n"
"if (new_iid is null)\n"
"{\n"
"declare spo any;\n"
"select VECTOR_AGG (vector (S, P, O)) into spo from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and S=OC.COL_IID;\n"
"RDF_CBD_DELETE (spo, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_COL set COL_IID=null where COL_ID=OC.COL_ID;\n"
"set triggers on;\n"
"if (path_change)\n"
"DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (dav_rdf_graph_uri, dav_rdf_graph_iid, NC.COL_ID, 0, new_uri, new_iid, null);\n"
"return;\n"
"}\n"
"if (path_change)\n"
"DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE (dav_rdf_graph_uri, dav_rdf_graph_iid, NC.COL_ID, 1, new_uri, new_iid, OC.COL_IID);\n"
"if (OC.COL_OWNER <> NC.COL_OWNER)\n"
"{\n"
"declare email varchar;\n"
"email := DB.DBA.DAV_MAKE_USER_IRI (NC.COL_OWNER);\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://www.openlinksw.com/schemas/DAV#ownerUser\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI (dav_rdf_graph_uri, new_uri, \'http://www.openlinksw.com/schemas/DAV#ownerUser\', email);\n"
"}\n"
"if (OC.COL_CR_TIME <> NC.COL_CR_TIME)\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/created\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/created\', NC.COL_CR_TIME);\n"
"}\n"
"if (OC.COL_MOD_TIME <> NC.COL_MOD_TIME)\n"
"{\n"
"p_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (\'http://purl.org/dc/terms/modified\');\n"
"delete from DB.DBA.RDF_QUAD where P = p_iid and G = dav_rdf_graph_iid and S = new_iid;\n"
"DB.DBA.RDF_QUAD_URI_L (dav_rdf_graph_uri, new_uri, \'http://purl.org/dc/terms/modified\', NC.COL_MOD_TIME);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:692\n";

static const char *trig33 = 
"create trigger SYS_DAV_COL_RDF_QUAD_BEFORE_DELETE before delete on WS.WS.SYS_DAV_COL order 30 referencing old as OC\n"
"{\n"
"declare spo, dav_rdf_graph_uri, dav_rdf_graph_iid any;\n"
"if (OC.COL_PERMS[6] = 49)\n"
"{\n"
"dav_rdf_graph_uri := registry_get (\'DB.DBA.DAV_RDF_GRAPH_URI\');\n"
"if (not isstring (dav_rdf_graph_uri) or  dav_rdf_graph_uri = \'\')\n"
"return;\n"
"dav_rdf_graph_iid := DB.DBA.RDF_MAKE_IID_OF_QNAME (dav_rdf_graph_uri);\n"
"select VECTOR_AGG (vector (S, P, O)) into spo from DB.DBA.RDF_QUAD where G=dav_rdf_graph_iid and S=OC.COL_IID;\n"
"RDF_CBD_DELETE (spo, dav_rdf_graph_iid, dav_rdf_graph_uri);\n"
"}\n"
"}\n"
"--src dav_rdf_quad.sql:767\n";

/* vfs.sql */

static const char *proc303 = 
"create procedure WS.WS.COPY_PAGE (in _host varchar, in _urls any, in _root varchar, in _upd integer, in _dbg integer)\n"
"{\n"
"\n"
"declare exit handler for sqlstate \'*\', not found \n"
"{\n"
"rollback work;\n"
"__SQL_STATE := cast (__SQL_STATE as varchar);\n"
"if (__SQL_STATE <> \'40001\')\n"
"{\n"
"update VFS_QUEUE set VQ_STAT = \'error\', VQ_ERROR = __SQL_MESSAGE where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL in (_urls);\n"
"commit work;\n"
"ERR_MAIL_SEND (_host, _urls, _root, __SQL_STATE, __SQL_MESSAGE);\n"
"}\n"
"else\n"
"{\n"
"update VFS_QUEUE set VQ_STAT = \'waiting\' where VQ_HOST = _host and VQ_URL in (_urls) and VQ_ROOT = _root;\n"
"commit work;\n"
"}\n"
"if (__SQL_STATE <> \'40001\' and __SQL_STATE <> \'2E000\' and __SQL_STATE not like \'0800_\' and __SQL_STATE <> \'HTCLI\')\n"
"{\n"
"resignal;\n"
"}\n"
"return null;\n"
"};\n"
"return WS.WS.COPY_PAGE_1 (_host, _urls, _root, _upd, _dbg); \n"
"}\n"
"--src vfs.sql:30\n";

static const char *proc304 = 
"create procedure WS.WS.VFS_HTTP_RESP_CODE (inout _resp any)\n"
"{\n"
"declare _tmp varchar;\n"
"_tmp := WS.WS.FIND_KEYWORD (_resp, \'HTTP/1.\');\n"
"_tmp := subseq (_tmp, strchr (_tmp, \' \') + 1, length (_tmp));\n"
"_tmp := subseq (_tmp, 0, strchr (_tmp, \' \'));\n"
"return _tmp;\n"
"}\n"
"--src vfs.sql:58\n";

static const char *proc305 = 
"create procedure WS.WS.VFS_ENSURE_NEW_SITE (in _host varchar, in _root varchar, in _new_host varchar, in _new_url varchar)\n"
"{\n"
"if (not exists (select 1 from VFS_SITE where VS_HOST = _new_host and VS_ROOT = _new_host))\n"
"{\n"
"insert into VFS_SITE (VS_HOST, VS_ROOT, VS_URL, VS_SRC, VS_OWN, VS_DEL, VS_NEWER, VS_FOLLOW, VS_NFOLLOW, VS_METHOD, VS_OTHER, VS_DESCR)\n"
"select _new_host, _new_host, _new_url, VS_SRC, VS_OWN, VS_DEL, VS_NEWER, VS_FOLLOW, VS_NFOLLOW, VS_METHOD, VS_OTHER, _new_host \n"
"from VFS_SITE where VS_HOST = _host and VS_ROOT = _root;\n"
"}\n"
"}\n"
"--src vfs.sql:68\n";

static const char *proc306 = 
"create procedure WS.WS.COPY_PAGE_1 (in _host varchar, in _urls any, in _root varchar,\n"
"in _upd integer, in _dbg integer)\n"
"{\n"
"declare _header, _etag, _http_resp_code, _start_url varchar;\n"
"declare _del, _desc, _t_urls, _opts, _c_type varchar;\n"
"declare _dav_method, _d_imgs, _opage varchar;\n"
"declare _dav_enabled, _other varchar;\n"
"declare dt, redir_flag, store_flag, try_to_get_rdf integer;\n"
"declare _since datetime;\n"
"declare _udata, ext_hook, store_hook, _header_arr, _resps any;\n"
"declare n_urls int;\n"
"\n"
"n_urls := position (0, _urls) - 1;\n"
"if (n_urls < 0)\n"
"n_urls := length (_urls);\n"
"\n"
"whenever not found goto nf_opt;\n"
"select VS_NEWER, VS_OPTIONS, coalesce (VS_METHOD, \'\'), VS_URL, VS_SRC, coalesce (VS_OPAGE, \'\'),\n"
"coalesce (VS_REDIRECT, 1), coalesce (VS_STORE, 1), coalesce (VS_DLOAD_META, 0), \n"
"deserialize (VS_UDATA), VS_EXTRACT_FN, VS_STORE_FN, coalesce (VS_DEL, \'\'), coalesce (VS_OTHER, \'\')\n"
"into _since, _opts, _dav_method, _start_url, _d_imgs, _opage, \n"
"redir_flag, store_flag, try_to_get_rdf, \n"
"_udata, ext_hook, store_hook, _del, _other\n"
"from VFS_SITE where VS_HOST = _host and VS_ROOT = _root;\n"
"nf_opt:\n"
"\n"
"_header := \'\';\n"
"if (isstring (_opts) and strchr (_opts, \':\') is not null)\n"
"_header := sprintf (\'Authorization: Basic %s\\r\\n\', encode_base64(_opts));\n"
"\n"
"if (_upd = 1 and _since is not null)\n"
"_header := concat (_header, \'If-Modified-Since: \', soap_print_box (_since, \'\', 1), \'\\r\\n\');\n"
"\n"
"if (try_to_get_rdf)\n"
"_header := _header || \'Accept: application/rdf+xml, text/rdf+n3, */*\\r\\n\';\n"
"\n"
"if (_upd = 1)  \n"
"{\n"
"_header_arr := make_array (n_urls, \'any\');\n"
"for (declare i int, i := 0; i < n_urls; i := i + 1)\n"
"{\n"
"declare _url, _hdr varchar;\n"
"_url := _urls[i];\n"
"_etag := (select VU_ETAG from VFS_URL where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root);\n"
"if (_etag is not null and isstring (_etag))\n"
"_hdr := concat (_header,\'If-None-Match: \', _etag, \'\\r\\n\');\n"
"else\n"
"_hdr := _header;\n"
"_header_arr[i] := _hdr;  \n"
"}\n"
"}\n"
"else  \n"
"_header_arr := _header;\n"
"\n"
"commit work;\n"
"\n"
"if (_dav_method = \'checked\' and _upd = 0 and _opage <> \'checked\')\n"
"{\n"
"declare dav_urls, _dav_opts, _url any;\n"
"declare lev int;\n"
"if (length (_urls) <> 1)\n"
"signal (\'22023\', \'When using WebDAV methods batch size cannot be greater than 1\', \'CRAWL\');\n"
"_url := _urls[0]; \n"
"dt := msec_time ();\n"
"http_get (WS.WS.MAKE_URL (_host, _url), _dav_opts, \'OPTIONS\');\n"
"prof_sample (\'web robot GET\', msec_time () - dt, 1);\n"
"_dav_enabled := http_request_header (_dav_opts, \'DAV\', null, null);\n"
"if (0 = length (_dav_enabled))\n"
"{\n"
"update VFS_SITE set VS_METHOD = null where VS_HOST = _host and VS_ROOT = _root;\n"
"_dav_method := null;\n"
"goto html_mode;\n"
"}\n"
"dav_urls := WS.WS.DAV_PROP (WS.WS.MAKE_URL (_host, _url), _d_imgs, _header);\n"
"lev := coalesce ((select VQ_LEVEL from VFS_QUEUE where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL = _url), 0);\n"
"WS.WS.GET_URLS (_host, _url, _root, dav_urls, lev + 1);\n"
"}\n"
"\n"
"html_mode:\n"
"_t_urls := make_array (n_urls, \'any\');\n"
"for (declare i int, i := 0; i < n_urls; i := i + 1)\n"
"{\n"
"_t_urls[i] := WS.WS.MAKE_URL (_host, _urls[i]);\n"
"}\n"
"\n"
"dt := msec_time ();\n"
"{\n"
"declare retr integer;\n"
"retr := 4;\n"
"declare exit handler for sqlstate \'2E000\' {\n"
"if (retr <= 0)\n"
"resignal;\n"
"else\n"
"goto get_again;\n"
"};\n"
"declare exit handler for sqlstate \'0800*\' {\n"
"if (retr <= 0)\n"
"resignal;\n"
"else\n"
"goto get_again;\n"
"};\n"
"declare exit handler for sqlstate \'HTCLI\' {\n"
"if (retr <= 0)\n"
"resignal;\n"
"else\n"
"goto get_again;\n"
"};\n"
"\n"
"get_again:\n"
"retr := retr - 1;\n"
"\n"
"if (n_urls = 1)\n"
"{\n"
"declare _resp, _content any;\n"
"_content := http_get (_t_urls[0], _resp, \'GET\', case when _upd = 1 then _header_arr[0] else _header_arr end);\n"
"_resps := vector (vector (_content, _resp));\n"
"}\n"
"else\n"
"_resps := http_pipeline (_t_urls, \'GET\', _header_arr);\n"
"}\n"
"prof_sample (\'web robot GET\', msec_time () - dt, 1);\n"
"\n"
"if (length (_resps) <> n_urls)\n"
"signal (\'2E000\', \'Different length of requests and responces\'); \n"
"\n"
"for (declare i int, i := 0; i < n_urls; i := i + 1)\n"
"{\n"
"declare _url varchar;\n"
"declare _resp, _content any;\n"
"declare lev int;\n"
"\n"
"_url := _urls[i];\n"
"_resp := _resps[i][1];\n"
"_content := _resps[i][0];\n"
"lev := coalesce ((select VQ_LEVEL from VFS_QUEUE where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL = _url), 0);\n"
"commit work;\n"
"if (isarray(_resp) and length (_resp) and not isstring (_resp [0]))\n"
"{\n"
"signal (\'2E000\', \'Bad header received\');\n"
"}\n"
"\n"
"_http_resp_code := WS.WS.VFS_HTTP_RESP_CODE (_resp);\n"
"if (redir_flag and _http_resp_code in (\'301\', \'302\', \'303\'))\n"
"{\n"
"declare new_loc, new_url, new_host varchar;\n"
"declare ht any;\n"
"new_loc :=  http_request_header (_resp, \'Location\', null, null);\n"
"new_loc := WS.WS.EXPAND_URL (_t_urls[i], new_loc);\n"
"ht := WS.WS.PARSE_URI (new_loc);\n"
"new_host := ht[1];\n"
"ht[0] := \'\'; ht[1] := \'\'; \n"
"new_url := VFS_URI_COMPOSE (ht);\n"
"if (_host = new_host)\n"
"{\n"
"insert soft VFS_QUEUE (VQ_HOST, VQ_ROOT, VQ_URL, VQ_STAT, VQ_TS, VQ_LEVEL) \n"
"values (_host, _root, new_url, \'waiting\', now (), lev + 1);\n"
"}\n"
"else if (_other = \'checked\')\n"
"{\n"
"WS.WS.VFS_ENSURE_NEW_SITE (_host, _root, new_host, new_url);\n"
"insert soft VFS_QUEUE (VQ_HOST, VQ_TS, VQ_URL, VQ_STAT, VQ_ROOT, VQ_OTHER, VQ_LEVEL)\n"
"values (new_host, now (), new_url, \'waiting\', new_host, \'other\', lev + 1);\n"
"}\n"
"goto end_crawl;\n"
"}\n"
"\n"
"_c_type := coalesce (http_request_header (_resp, \'Content-Type\'), \'\');\n"
"_etag := http_request_header (_resp, \'ETag\', null, \'\');\n"
"\n"
"if (_http_resp_code = \'200\' and (isstring (_content) or __tag (_content) = 185))\n"
"{\n"
"if (ext_hook is not null and __proc_exists (ext_hook))\n"
"call (ext_hook) (_host, _url, _root, _content, _c_type, lev + 1);\n"
"else if ((_url like \'%.htm%\' or _url like \'%/\' or _c_type like \'text/html%\') and _dav_method <> \'checked\' and _opage <> \'checked\')\n"
"WS.WS.GET_URLS (_host, _url, _root, _content, lev + 1);\n"
"\n"
"if (store_hook is not null and __proc_exists (store_hook))\n"
"call (store_hook) (_host, _url, _root, _content, _etag, _c_type, store_flag, _udata, lev + 1);\n"
"else \n"
"{\n"
"WS.WS.LOCAL_STORE (_host, _url, _root, _content, _etag, _c_type, store_flag);\n"
"if (try_to_get_rdf)\n"
"WS.WS.VFS_EXTRACT_RDF (_host, _root, _start_url, _udata, _url, _content, _c_type, _header, _resp);\n"
"}\n"
"}\n"
"else if (_http_resp_code = \'401\')\n"
"{\n"
"signal (\'22023\', \'This site requires authentication credentials which are not supplied or incorrect.\');\n"
"}\n"
"else if (_http_resp_code = \'404\' and _upd = 1 and _del = \'checked\')\n"
"{\n"
"\n"
"WS.WS.DELETE_LOCAL_COPY (_host, _url, _root);\n"
"}\n"
"end_crawl: \n"
"if (_http_resp_code like \'2__\' or _http_resp_code like \'3__\' or _http_resp_code like \'4__\' or _http_resp_code like \'5__\')\n"
"update VFS_QUEUE set VQ_STAT = \'retrieved\'\n"
"where VQ_HOST = _host and VQ_URL = _url and VQ_ROOT = _root and VQ_STAT = \'pending\';\n"
"}\n"
"commit work;\n"
"return;\n"
"}\n"
"--src vfs.sql:79\n";

static const char *proc307 = 
"create procedure WS.WS.DELETE_LOCAL_COPY (in _host varchar, in _url varchar, in _root varchar)\n"
"{\n"
"delete from VFS_URL where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"delete from SYS_DAV_RES where RES_FULL_PATH = concat (\'/DAV/\', _root, _url);\n"
"}\n"
"--src vfs.sql:284\n";

static const char *proc308 = 
"create procedure WS.WS.SERV_QUEUE_TOP (in _tgt varchar, in _root varchar, in _upd integer,\n"
"in _dbg integer, in _fn varchar, in _clnt_data any, in threads int := 1, in batch_size int := 1)\n"
"{\n"
"declare _msg, _stat, oq varchar;\n"
"do_again:\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"exec (\'WS.WS.SERV_QUEUE (?, ?, ?, ?, ?, ?, ?, ?)\', _stat, _msg,\n"
"vector (_tgt, _root, _upd, _dbg, _fn, _clnt_data, threads, batch_size));\n"
"if (_stat = \'40001\')\n"
"{\n"
"rollback work;\n"
"goto do_again;\n"
"}\n"
"commit work;\n"
"oq := (select DB.DBA.VECTOR_AGG (vector (HOST, ROOT)) from (select distinct VQ_HOST as HOST, VQ_ROOT as ROOT \n"
"from VFS_QUEUE where VQ_STAT = \'waiting\' and VQ_OTHER = \'other\') x);\n"
"commit work;\n"
"do_again1:  \n"
"foreach (any elm in oq) do\n"
"{\n"
"_stat := \'00000\';\n"
"_msg := \'\';\n"
"exec (\'WS.WS.SERV_QUEUE (?, ?, ?, ?, ?, ?, ?, ?)\', _stat, _msg,\n"
"vector (elm[0], elm[1], _upd, _dbg, _fn, _clnt_data, threads, batch_size));\n"
"if (_stat = \'40001\')\n"
"{\n"
"rollback work;\n"
"goto do_again1;\n"
"}\n"
"commit work;\n"
"}\n"
"\n"
"}\n"
"--src vfs.sql:293\n";

static const char *proc309 = 
"create procedure WS.WS.SERV_QUEUE (in __tgt varchar, in __root varchar, in _upd integer,\n"
"in _dbg integer, in _fn varchar, in _clnt_data any, in nthreads int := 1, in batch_size int := 1)\n"
"{\n"
"declare _total, active_thread integer;\n"
"declare _rc integer;\n"
"declare _tgt_url varchar;\n"
"declare url_fn varchar;\n"
"declare _last_shut integer;\n"
"declare _tgt, _root varchar;\n"
"declare _next_url varchar;\n"
"declare _dav_method varchar;\n"
"declare aq_list, aq, url_batch any;\n"
"declare err any;\n"
"declare pid int;\n"
"\n"
"_total := 0;\n"
"_tgt := __tgt;\n"
"_root := __root;\n"
"registry_set (\'WEB_COPY\', \'X __sequence_set (\'\'WEB_COPY_SSHUT\'\', datediff (\'\'second\'\', stringdate (\'\'1980-01-01\'\'), now ()), 0)\');\n"
"_last_shut := coalesce (sequence_set (\'WEB_COPY_SSHUT\', 0, 2), 0);\n"
"\n"
"update WS.WS.VFS_QUEUE set VQ_STAT = \'waiting\'\n"
"where VQ_STAT = \'pending\' and (VQ_TS is null or datediff (\'second\', stringdate (\'1980-01-01\'), VQ_TS) < _last_shut);\n"
"commit work;\n"
"\n"
"whenever not found goto n_site;\n"
"select VS_URL, VS_METHOD into _tgt_url, _dav_method from VFS_SITE where VS_HOST = _tgt and VS_ROOT = _root;\n"
"\n"
"if (_upd = 1)\n"
"{\n"
"if (not exists (select 1 from VFS_QUEUE where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_URL <> _tgt_url))\n"
"{\n"
"for select VU_URL from VFS_URL where VU_HOST = _tgt and VU_ROOT = _root and VU_URL <> _tgt_url do\n"
"{\n"
"insert into VFS_QUEUE (VQ_HOST, VQ_ROOT, VQ_URL, VQ_STAT, VQ_TS)\n"
"values (_tgt, _root, VU_URL, \'waiting\', now ());\n"
"}\n"
"update VFS_QUEUE set VQ_STAT = \'waiting\' where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_URL = _tgt_url;\n"
"}\n"
"else if (not exists (select 1 from VFS_QUEUE where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_STAT = \'waiting\'))\n"
"{\n"
"update VFS_QUEUE set VQ_STAT = \'waiting\' where VQ_HOST = _tgt and VQ_ROOT = _root;\n"
"}\n"
"commit work;\n"
"}\n"
"if (_dav_method = \'checked\')\n"
"batch_size := 1;\n"
"\n"
"\n"
"if (WS.WS.ISEMPTY (_fn))\n"
"url_fn := \'WS.WS.URL_BY_DATE\';\n"
"else\n"
"url_fn := _fn;\n"
"\n"
"aq_list := make_array (nthreads, \'any\'); \n"
"for (declare i int, i := 0; i < nthreads; i := i + 1)\n"
"aq_list [i] := \'n\';\n"
"url_batch := make_array (batch_size, \'any\');\n"
"aq := async_queue (nthreads);\n"
"active_thread := 0;\n"
"\n"
"while (1)\n"
"{\n"
"declare found_one, ndone int;\n"
"declare exit handler for sqlstate \'*\' \n"
"{\n"
"ERR_MAIL_SEND (_tgt, vector (), _root, __SQL_STATE, __SQL_MESSAGE);\n"
"rollback work;\n"
"goto fn_end;\n"
"};\n"
"found_one := 0; ndone := 0;\n"
"for (declare i int, i := 0; i < batch_size; i := i + 1)\n"
"{\n"
"_rc := call (url_fn) (_tgt, _root, _next_url, _clnt_data);\n"
"if (_rc > 0 and isstring (_next_url))\n"
"{\n"
"found_one := 1;\n"
"url_batch [i] := _next_url;\n"
"ndone := ndone + 1;\n"
"}\n"
"else\n"
"url_batch [i] := 0;\n"
"}\n"
"commit work;\n"
"if (0 = found_one)\n"
"goto fn_end;\n"
"active_thread := position (\'n\', aq_list) - 1;\n"
"if (active_thread < 0)\n"
"{\n"
"pid := null;\n"
"\n"
"for (declare i int, i := 0; i < nthreads; i := i + 1)\n"
"{\n"
"if (pid is null or pid > aq_list[i])\n"
"{\n"
"pid := aq_list[i];\n"
"active_thread := i;\n"
"}\n"
"}\n"
"commit work;\n"
"\n"
"aq_wait (aq, pid, 1, err);\n"
"\n"
"}\n"
"if (active_thread < 0)\n"
"signal (\'42000\', \'Cannot get free thread\', \'CRAWL\');\n"
"aq_list [active_thread] := aq_request (aq, \'WS.WS.COPY_PAGE\', vector (_tgt, url_batch, _root, _upd, _dbg));\n"
"if (ndone < batch_size or not exists (select 1 from WS.WS.VFS_QUEUE where VQ_HOST = _tgt and VQ_ROOT = _root and VQ_STAT = \'waiting\'))\n"
"{\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"aq_list [active_thread] := \'n\';\n"
"}\n"
"_total := _total + ndone;\n"
"}\n"
"fn_end:;\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"\n"
"\n"
"if (_dbg = 3)\n"
"http (concat (\'<strong>Total links visited: \', cast (_total as varchar), \'</strong>\\n\'));\n"
"\n"
"n_site:;\n"
"return _total;\n"
"}\n"
"--src vfs.sql:334\n";

static const char *proc310 = 
"create procedure ERR_MAIL_SEND (in _tgt varchar, in _urls varchar, in _root varchar, in  _stat varchar, in _msg varchar)\n"
"{\n"
"declare n_urls int;\n"
"declare msg varchar;\n"
"\n"
"n_urls := position (0, _urls) - 1;\n"
"if (n_urls < 0)\n"
"n_urls := length (_urls);\n"
"\n"
"msg :=  sprintf (\n"
"\'Subject: Error importing http://%s\\r\\n\\r\\n\'||\n"
"\'(This is automatically generated message from Web Crawler)\\r\\n\'||\n"
"\'Code: %s Message: %s\\r\\n.\\r\\n\' || \n"
"\'The following URL can\'\'t be imported:\\r\\n\', _tgt, _stat, _msg);\n"
"for (declare i int, i := 0; i < n_urls; i := i + 1)\n"
"msg := msg || sprintf (\'http://%s%s -> %s\\r\\n\', _tgt, _urls[i], _root); \n"
"DB.DBA.NEW_MAIL (\'dav\', msg);\n"
"}\n"
"--src vfs.sql:462\n";

static const char *proc311 = 
"create procedure WS.WS.LOCAL_STORE (in _host varchar, in _url varchar, in _root varchar,\n"
"inout _content varchar, in _s_etag varchar, in _c_type varchar,\n"
"in store_flag int := 1)\n"
"{\n"
"declare _name, _perms, _etag, _idx, _type, _e_etag, _sl, _opage varchar;\n"
"declare _own, _col_id, _grp, _res_id integer;\n"
"declare _path any;\n"
"\n"
"if (not store_flag)\n"
"{\n"
"insert soft VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"return 0;\n"
"}\n"
"\n"
"whenever not found goto err_end;\n"
"select VS_OWN, VS_INX, VS_OPAGE into _own, _idx, _opage from VFS_SITE\n"
"where VS_HOST = _host and VS_ROOT = _root;\n"
"if (isstring (_root) and length (_root) > 0 and aref(_root, 0) = ascii (\'/\'))\n"
"_sl := \'\';\n"
"else\n"
"_sl := \'/\';\n"
"if (aref (_url, length (_url) - 1) = ascii(\'/\'))\n"
"_path := WS.WS.HREF_TO_ARRAY (concat(_sl, _root, _url,\'index.html\'),\'\');\n"
"else\n"
"_path := WS.WS.HREF_TO_ARRAY (concat(_sl, _root, _url),\'\');\n"
"_path := WS.WS.FIXPATH (_path);\n"
"if (_own is not null and _own > 0)\n"
"{\n"
"whenever not found goto default_s;\n"
"select U_GROUP, U_DEF_PERMS into _grp, _perms from SYS_DAV_USER where U_ID = _own;\n"
"}\n"
"else\n"
"{\n"
"default_s:\n"
"_own := 0;\n"
"_perms := \'110110110\';\n"
"_grp := 0;\n"
"}\n"
"\n"
"if (_opage = \'checked\')\n"
"_path := WS.WS.HREF_TO_ARRAY (_root, \'\');\n"
"\n"
"_col_id := WS.WS.MKPATH (WS.WS.PARENT_PATH (_path), _own, _grp, _perms);\n"
"if (_col_id is not null and _col_id > 1)\n"
"{\n"
"_name := aref (_path, length (_path) - 1);\n"
"if (_c_type is null or _c_type = \'\')\n"
"_type := http_mime_type (_name);\n"
"else\n"
"_type := _c_type;\n"
"whenever not found goto not_res;\n"
"select RES_ID into _res_id from SYS_DAV_RES where RES_NAME = _name and RES_COL = _col_id;\n"
"not_res:\n"
"if (_res_id is null or _res_id = 0)\n"
"{\n"
"if (__tag (_content) = 185)\n"
"{\n"
"insert into SYS_DAV_RES (RES_ID, RES_NAME, RES_CONTENT, RES_TYPE,\n"
"RES_PERMS, RES_OWNER, RES_GROUP, RES_CR_TIME, RES_MOD_TIME, RES_COL)\n"
"values (getid (\'R\'), _name, _content, _type, _perms, _own, _grp, now (), now (), _col_id);\n"
"}\n"
"else\n"
"{\n"
"insert into SYS_DAV_RES (RES_ID, RES_NAME, RES_CONTENT, RES_TYPE,\n"
"RES_PERMS, RES_OWNER, RES_GROUP, RES_CR_TIME, RES_MOD_TIME, RES_COL)\n"
"values (getid (\'R\'), _name, WS.WS.REPLACE_HREF (_host, _url, _root, _content, _type),\n"
"_type, _perms, _own, _grp, now (), now (), _col_id);\n"
"}\n"
"\n"
"insert replacing VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"}\n"
"else if (_res_id > 0)\n"
"{\n"
"whenever not found goto no_chksum;\n"
"select VU_CHKSUM, VU_ETAG into _etag, _e_etag from VFS_URL\n"
"where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"no_chksum:\n"
"if (_etag <> md5 (_content) or _s_etag <> _e_etag)\n"
"{\n"
"if (__tag (_content) = 185)\n"
"{\n"
"update SYS_DAV_RES set RES_CONTENT = _content, RES_MOD_TIME = now () where RES_ID = _res_id;\n"
"}\n"
"else\n"
"{\n"
"update SYS_DAV_RES set RES_CONTENT = WS.WS.REPLACE_HREF (_host, _url, _root, _content, _type),\n"
"RES_MOD_TIME = now () where RES_ID = _res_id;\n"
"}\n"
"\n"
"if (_etag is not null and isstring (_etag))\n"
"update VFS_URL set VU_CHKSUM = md5 (_content), VU_CPTIME = now (), VU_ETAG = _s_etag\n"
"where VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"else\n"
"insert replacing VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"}\n"
"}\n"
"}\n"
"err_end:\n"
"return 0;\n"
"}\n"
"--src vfs.sql:482\n";

static const char *proc312 = 
"create procedure WS.WS.GET_URLS (in _host varchar, in _url varchar, in _root varchar, inout _content varchar, in lev int)\n"
"{\n"
"declare _stag, _etag, _len, _inx, _htag, _sltag, _count, _t_tag1, _t_tag2, _uri_len integer;\n"
"declare _cut_pos integer;\n"
"declare _tmp, _tmp_host, _tmp_url, _t_len, _d_imgs, _other varchar;\n"
"declare _uri any;\n"
"declare _flw, _nflw, _method, _delete varchar;\n"
"declare _newer datetime;\n"
"declare _own integer;\n"
"declare frames any;\n"
"\n"
"whenever not found goto nf_img;\n"
"select VS_SRC, VS_OTHER, VS_OWN, VS_METHOD, VS_FOLLOW, VS_NFOLLOW, VS_DEL, VS_NEWER\n"
"into _d_imgs, _other, _own, _method, _flw, _nflw, _delete, _newer\n"
"from VFS_SITE where VS_HOST = _host and VS_ROOT = _root;\n"
"\n"
"nf_img:\n"
"frames := vector ();\n"
"if (isstring (_content))\n"
"_uri := WS.WS.FIND_URI (_content, _d_imgs, _host, _url, frames);\n"
"else if (__tag (_content) = 193)\n"
"_uri := _content;\n"
"if (__tag (_uri) = 193 )\n"
"{\n"
"_uri_len := length (_uri);\n"
"}\n"
"else\n"
"return;\n"
"\n"
"if ((isstring (_flw) and length (_flw) > 0) or (isstring (_nflw) and length (_nflw) > 0))\n"
"frames := vector ();\n"
"\n"
"_inx := 0;\n"
"while (_inx < _uri_len)\n"
"{\n"
"_tmp := aref (_uri, _inx);\n"
"if (_tmp is not null)\n"
"{\n"
"_cut_pos := strstr (_tmp, \'#\');\n"
"if (_cut_pos is not null)\n"
"{\n"
"if (0 <> _cut_pos)\n"
"_tmp := subseq (_tmp, 0, _cut_pos);\n"
"else\n"
"_tmp := \'./\';\n"
"}\n"
"_cut_pos := strstr (_tmp, \'?\');\n"
"if (_cut_pos is not null)\n"
"_tmp := subseq (_tmp, 0, _cut_pos);\n"
"if (strcasestr (_tmp, \'ftp://\') is null and strcasestr (_tmp, \'mailto:\') is null\n"
"and strcasestr (_tmp, \'news:\') is null and strcasestr (_tmp, \'telnet://\') is null\n"
"and strcasestr (_tmp, \'https://\') is null and _tmp <> \'http://\')\n"
"{\n"
"WS.WS.SPLIT_URL (_host, _url, _tmp, _tmp_host, _tmp_url);\n"
"\n"
"if ((get_keyword (_tmp_url, frames) is not null or WS.WS.FOLLOW (_host, _root, _tmp_url))\n"
"and _tmp_host = _host)\n"
"{\n"
"select count (*) into _count from VFS_URL where\n"
"VU_HOST = _tmp_host and VU_URL = _tmp_url and VU_ROOT = _root for update;\n"
"if (_count is null or _count = 0)\n"
"{\n"
"select count (*) into _count from VFS_QUEUE where\n"
"VQ_HOST = _tmp_host and VQ_URL = _tmp_url and VQ_ROOT = _root for update;\n"
"if (_count is null or _count = 0)\n"
"{\n"
"insert into VFS_QUEUE (VQ_HOST, VQ_TS, VQ_URL, VQ_STAT, VQ_ROOT, VQ_LEVEL)\n"
"values (_tmp_host, now (), _tmp_url, \'waiting\', _root, lev);\n"
"}\n"
"}\n"
"}\n"
"else if (WS.WS.FOLLOW (_host, _root, _tmp_url) and _tmp_host <> _host and _other = \'checked\')\n"
"{\n"
"\n"
"WS.WS.VFS_ENSURE_NEW_SITE (_host, _root, _tmp_host, _tmp_url);\n"
"\n"
"insert soft VFS_QUEUE (VQ_HOST, VQ_TS, VQ_URL, VQ_STAT, VQ_ROOT, VQ_OTHER, VQ_LEVEL)\n"
"values (_tmp_host, now (), _tmp_url, \'waiting\', _tmp_host, \'other\', lev);\n"
"}\n"
"}\n"
"}\n"
"_inx := _inx + 1;\n"
"}\n"
"return;\n"
"}\n"
"--src vfs.sql:588\n";

static const char *proc313 = 
"create procedure WS.WS.MAKE_URL (in _host varchar, in _url varchar)\n"
"{\n"
"declare hf, _res any;\n"
"hf := WS.WS.PARSE_URI (_url);\n"
"if (hf[0] = \'\')\n"
"hf[0] := \'http\';\n"
"if (hf[1] = \'\')\n"
"hf[1] := _host;\n"
"_res := WS.WS.VFS_URI_COMPOSE (hf);  \n"
"return _res;\n"
"}\n"
"--src vfs.sql:677\n";

static const char *proc314 = 
"create procedure WS.WS.SPLIT_URL (in _host varchar, in _url varchar, in _parent_url varchar,\n"
"out _o_host varchar, out _o_url varchar)\n"
"{\n"
"declare _htag, _sltag, _t_len integer;\n"
"declare _schema integer;\n"
"declare _part varchar;\n"
"_htag := strcasestr (_parent_url, \'http://\');\n"
"_schema := strcasestr (_parent_url, \'http:\');\n"
"_t_len := length (_parent_url);\n"
"if (_htag is not null)\n"
"{\n"
"_sltag := strstr (subseq (_parent_url, _htag + 8, _t_len), \'/\');\n"
"if (_sltag is not null)\n"
"{\n"
"_o_host := substring (_parent_url, _htag + 8, _sltag + 1);\n"
"if (_htag + 8 + _sltag + 2 < _t_len )\n"
"{\n"
"_o_url := substring (_parent_url, _htag + 8 + _sltag + 1 , _t_len - _sltag + 1);\n"
"}\n"
"else\n"
"_o_url := \'/\';\n"
"}\n"
"else\n"
"{\n"
"_o_host := subseq (_parent_url, _htag + 7, _t_len);\n"
"_o_url := \'/\';\n"
"}\n"
"}\n"
"else if (_schema is not null and _htag is null)\n"
"{\n"
"\n"
"_o_host := _host;\n"
"if (_schema + 5 < _t_len)\n"
"{\n"
"_part := subseq (_parent_url, _schema + 5, _t_len);\n"
"if (aref (_part, 0) = \'/\')\n"
"_o_url := _part;\n"
"else\n"
"_o_url := WS.WS.EXPAND_URL (_url, _part);\n"
"}\n"
"else\n"
"_o_url := _url;\n"
"}\n"
"else\n"
"{\n"
"_o_host := _host;\n"
"if (aref (_parent_url, 0) = ascii (\'/\'))\n"
"_o_url := _parent_url;\n"
"else\n"
"_o_url := WS.WS.EXPAND_URL (_url, _parent_url);\n"
"}\n"
"}\n"
"--src vfs.sql:691\n";

static const char *proc315 = 
"create procedure WS.WS.EXPAND_URL_OLD (in _url varchar, in _c_url varchar)\n"
"{\n"
"declare _tmp varchar;\n"
"declare _dsl, _sl, _c_len integer;\n"
"declare host_pos integer;\n"
"_tmp := _url;\n"
"\n"
"if (_url is null or not isstring (_url))\n"
"return _c_url;\n"
"\n"
"if (_c_url is null or not isstring (_c_url))\n"
"return _url;\n"
"\n"
"_c_len := length (_c_url);\n"
"if (_c_url = \'.\')\n"
"return _url;\n"
"if (_c_url is not null)\n"
"{\n"
"if (strstr (_c_url, \'://\') is not null or\n"
"(length (_c_url) > 1 and (aref (_c_url, 0) = ascii (\'/\') or aref (_c_url, 0) = ascii (\'\\\\\'))))\n"
"return _c_url;\n"
"}\n"
"\n"
"host_pos := strstr (_tmp, \'://\');\n"
"if (aref (_tmp, length (_tmp) - 1) <> ascii (\'/\'))\n"
"{\n"
"declare last_slash_pos integer;\n"
"last_slash_pos := strrchr (_tmp, \'/\');\n"
"if (last_slash_pos is not null and (last_slash_pos - host_pos > 2 or host_pos is null))\n"
"_tmp := substring (_tmp, 1, last_slash_pos + 1);\n"
"else\n"
"{\n"
"if (host_pos is null)\n"
"_tmp := \'/\';\n"
"else\n"
"_tmp := concat (_tmp, \'/\');\n"
"}\n"
"}\n"
"\n"
"_tmp := concat (_tmp, _c_url);\n"
"_tmp := replace (_tmp, \'/./\', \'/\');\n"
"_dsl := 0;\n"
"while (_dsl is not null)\n"
"{\n"
"_dsl := strstr (_tmp, \'/../\');\n"
"if (_dsl is null)\n"
"goto end_loop;\n"
"if (_dsl = 0)\n"
"{\n"
"_tmp := subseq (_tmp, 3, length (_tmp));\n"
"goto end_loop;\n"
"}\n"
"_sl := strrchr (subseq (_tmp, 0, _dsl - 1), \'/\');\n"
"_tmp := concat (subseq (_tmp, 0, _sl + 1), subseq (_tmp, _dsl + 4, length (_tmp)));\n"
"}\n"
"end_loop:\n"
"return _tmp;\n"
"}\n"
"--src vfs.sql:746\n";

static const char *proc316 = 
"create procedure WS.WS.MKPATH (in _path any, in _own integer, in _grp integer, in _perms varchar)\n"
"{\n"
"declare _col, _len, _inx, _t_col integer;\n"
"declare _name varchar;\n"
"if (__tag (_path) <> 193)\n"
"return NULL;\n"
"else if (length (_path) < 1)\n"
"return NULL;\n"
"\n"
"_len := length (_path);\n"
"_inx := 0;\n"
"_t_col := 1;\n"
"whenever not found goto not_found;\n"
"while (_inx < _len)\n"
"{\n"
"select COL_ID into _col from SYS_DAV_COL where COL_PARENT = _t_col and COL_NAME = aref (_path, _inx);\n"
"_t_col := _col;\n"
"_inx := _inx + 1;\n"
"}\n"
"not_found:\n"
"while (_inx < _len)\n"
"{\n"
"_col := getid (\'C\');\n"
"_name := aref (_path, _inx);\n"
"insert into SYS_DAV_COL (COL_ID, COL_NAME, COL_PARENT, COL_CR_TIME, COL_MOD_TIME, COL_OWNER,\n"
"COL_GROUP, COL_PERMS) values (_col, _name, _t_col, now (), now (), _own, _grp, _perms);\n"
"_inx := _inx + 1;\n"
"_t_col := _col;\n"
"}\n"
"return _col;\n"
"}\n"
"--src vfs.sql:807\n";

static const char *proc317 = 
"create procedure WS.WS.FOLLOW (in _host varchar, in _root varchar, in _t_url varchar)\n"
"{\n"
"declare _flw, _nflw any;\n"
"declare _inx, _rc, _len integer;\n"
"declare _flw_s, _nflw_s, _cond, _url, _img varchar;\n"
"\n"
"_img := null;\n"
"whenever not found goto not_ini;\n"
"select VS_FOLLOW, VS_NFOLLOW, VS_URL, VS_SRC into _flw_s, _nflw_s, _url, _img\n"
"from VFS_SITE where VS_HOST = _host and VS_ROOT = _root;\n"
"\n"
"if (_t_url = _url)\n"
"return 1;\n"
"not_ini:\n"
"\n"
"if (_img is not null and substring (http_mime_type (_t_url), 1, 6) = \'image/\')\n"
"return 1;\n"
"\n"
"if (_flw_s is null or _flw_s = \'\')\n"
"_flw_s := concat (_url, \'%\');\n"
"\n"
"if (_nflw_s is null or _nflw_s = \'\')\n"
"_nflw_s := (\'\');\n"
"_rc := 0;\n"
"_flw := split_and_decode (_flw_s, 0, \';=;\');\n"
"if (_flw is null)\n"
"goto next_step;\n"
"_len := length (_flw);\n"
"if (_len > 0)\n"
"{\n"
"_inx := 0;\n"
"while (_inx < _len)\n"
"{\n"
"_cond := aref (_flw, _inx);\n"
"if (_t_url like _cond)\n"
"{\n"
"_rc := 1;\n"
"goto next_step;\n"
"}\n"
"_inx := _inx + 1;\n"
"}\n"
"return 0;\n"
"}\n"
"next_step:\n"
"_nflw := split_and_decode (_nflw_s, 0, \';=;\');\n"
"if (_nflw is null)\n"
"goto end_step;\n"
"_len := length (_nflw);\n"
"if (_len > 0)\n"
"{\n"
"_inx := 0;\n"
"while (_inx < _len)\n"
"{\n"
"_cond := aref (_nflw, _inx);\n"
"if (_t_url like _cond)\n"
"{\n"
"_rc := 0;\n"
"goto end_step;\n"
"}\n"
"_inx := _inx + 1;\n"
"}\n"
"}\n"
"end_step:\n"
"return _rc;\n"
"}\n"
"--src vfs.sql:841\n";

static const char *proc318 = 
"create procedure WS.WS.REPLACE_HREF (in _host varchar, in _url varchar, in _root varchar,\n"
"in _content varchar, in _c_type varchar)\n"
"{\n"
"declare _str, _tree, _tree_doc any;\n"
"declare _tmp, _nhost, _nurl, _dav, _url_p varchar;\n"
"declare _lp, _rp, _len, _tp, _break, _inx integer;\n"
"if (_c_type not like \'text/html%\' or not isstring (_content))\n"
"return _content;\n"
"\n"
"_str := string_output ();\n"
"if (strrchr (_url, \'/\') = 0)\n"
"_url_p := \'/\';\n"
"else if (strrchr (_url, \'/\') is not null and strrchr (_url, \'/\') > 0)\n"
"_url_p := subseq (_url, 0, strrchr (_url, \'/\') + 1);\n"
"else\n"
"_url_p := _url;\n"
"{\n"
"declare exit handler for sqlstate \'*\' { return _content; };\n"
"_tree := xml_tree (_content, 66, WS.WS.MAKE_URL (_host, _url_p), current_charset());\n"
"}\n"
"_break := 1;\n"
"_inx := 1;\n"
"if (__tag (_tree) <> 193)\n"
"return _content;\n"
"_tree_doc := xml_tree_doc (_tree);\n"
"http_value (_tree_doc, null, _str);\n"
"_tmp := string_output_string (_str);\n"
"return _tmp;\n"
"}\n"
"--src vfs.sql:909\n";

static const char *proc319 = 
"create procedure WS.WS.FIND_URI (in _content varchar, in _d_imgs varchar,\n"
"in _host varchar, in _url varchar, out frames any)\n"
"{\n"
"declare _len, _inx integer;\n"
"declare xe, arr, arr1, ha, sa, ia, fr, ifr, sty, js any;\n"
"declare elm, _tmp_host, _tmp_url varchar;\n"
"declare _xml_tree any;\n"
"\n"
"frames := vector ();\n"
"\n"
"\n"
"\n"
"\n"
"if (not isstring (_content))\n"
"return vector ();\n"
"\n"
"_xml_tree := xml_tree (_content, 2);\n"
"if (__tag (_xml_tree) <> 193)\n"
"return WS.WS.GET_HREF_IN_ARRAY (_content, _d_imgs);\n"
"\n"
"xe := xml_tree_doc (_xml_tree);\n"
"\n"
"ha := xpath_eval (\'//@href\', xe, 0);\n"
"sa := xpath_eval (\'//@src\', xe, 0);\n"
"ia := xpath_eval (\'//@background\', xe, 0);\n"
"\n"
"fr := xpath_eval (\'//frame/@src\', xe, 0);\n"
"ifr := xpath_eval (\'//iframe/@src\', xe, 0);\n"
"sty := xpath_eval (\'/html/head/link[@rel=\"stylesheet\"]/@href\', xe, 0);\n"
"js := xpath_eval (\'//script/@src\', xe, 0);\n"
"\n"
"arr := vector_concat (ha, sa, ia);\n"
"\n"
"_inx := 0; _len := length (arr);\n"
"\n"
"arr1 := vector ();\n"
"\n"
"while (_inx < _len)\n"
"{\n"
"elm := cast (arr[_inx] as varchar);\n"
"if (isstring (elm) and strstr (http_mime_type (elm), \'image/\') is null or _d_imgs is not null)\n"
"arr1 := vector_concat (arr1, vector (elm));\n"
"_inx := _inx + 1;\n"
"}\n"
"\n"
"\n"
"if (length (arr1) < 1)\n"
"{\n"
"elm := xpath_eval (\'//meta[translate(@http-equiv,\'\'REFRESH\'\',\'\'refresh\'\')=\'\'refresh\'\']/@content\', xe, 1);\n"
"if (elm is not null)\n"
"{\n"
"elm := cast (elm as varchar);\n"
"elm := regexp_match (\'[UuRrLl=]+[^ \\t\\$\\\"]*\', elm);\n"
"if (elm is not null and length (elm) > 5)\n"
"arr1 := vector (substring (elm, 5, length (elm)));\n"
"}\n"
"}\n"
"\n"
"fr := vector_concat (fr, ifr, sty, js);\n"
"_inx := 0; _len := length (fr);\n"
"while (_inx < _len)\n"
"{\n"
"elm := cast (fr[_inx] as varchar);\n"
"WS.WS.SPLIT_URL (_host, _url, elm, _tmp_host, _tmp_url);\n"
"if (_host = _tmp_host)\n"
"frames := vector_concat (frames, vector (_tmp_url, \'\'));\n"
"_inx := _inx + 1;\n"
"}\n"
"return arr1;\n"
"}\n"
"--src vfs.sql:941\n";

static const char *proc320 = 
"create procedure WS.WS.LFS_EXP (in _host varchar, in _url varchar, in _root varchar, in _i_dst varchar)\n"
"{\n"
"declare _path, _name, _content, _dest, _tmp, _dst, _err varchar;\n"
"declare _os_path any;\n"
"declare _o_len, _n, _rc, _win integer;\n"
"declare c cursor for select RES_FULL_PATH, RES_NAME, blob_to_string (RES_CONTENT) from SYS_DAV_RES\n"
"where RES_FULL_PATH like concat (_root, \'%\');\n"
"\n"
"if (dav_root () = \'/\')\n"
"_root := concat (\'/\', _root, \'/\');\n"
"else\n"
"_root := concat (\'/\', dav_root (), \'/\', _root, \'/\');\n"
"\n"
"if (aref (_i_dst, length (_i_dst) - 1) = ascii (\'/\'))\n"
"_dst := subseq (_i_dst, 0, length (_i_dst) - 1);\n"
"else\n"
"_dst := _i_dst;\n"
"\n"
"_win := 0;\n"
"if (length (_dst) > 1)\n"
"{\n"
"if (aref (_dst, 1) = ascii (\':\') and aref (_dst, 0) <> ascii (\'/\'))\n"
"_win := 1;\n"
"}\n"
"if (_win = 1 and length (_dst) > 2)\n"
"{\n"
"if (aref (_dst, 2) = ascii (\'\\\\\'))\n"
"_dst := replace (_dst, \'\\\\\', \'/\');\n"
"if (aref (_dst, length (_dst) - 1) = ascii (\'/\'))\n"
"_dst := substring (_dst, 1, length (_dst) - 1);\n"
"}\n"
"\n"
"whenever not found goto end_exp;\n"
"open c;\n"
"while (1)\n"
"{\n"
"fetch c into _path, _name, _content;\n"
"_dest := concat (_dst, subseq (_path, strstr (_path, dav_root ()) + length (dav_root ()),length (_path)));\n"
"_os_path := WS.WS.HREF_TO_ARRAY (_dest, \'\');\n"
"_o_len := length (_os_path);\n"
"_n := 0;\n"
"if (_win = 0)\n"
"_tmp := \'/\';\n"
"else\n"
"{\n"
"_n := 1;\n"
"_tmp := concat (substring (_dst, 1, 2), \'/\');\n"
"}\n"
"while (_n < _o_len - 1)\n"
"{\n"
"if (_win = 0)\n"
"_tmp := concat (_tmp, aref (_os_path, _n), \'/\');\n"
"else\n"
"_tmp := concat (_tmp, aref (_os_path, _n));\n"
"_rc := file_stat ( _tmp);\n"
"if (_rc = 0)\n"
"{\n"
"_rc := sys_mkdir (_tmp, _err);\n"
"if (_rc <> 0)\n"
"return _err;\n"
"}\n"
"_n := _n + 1;\n"
"if (_win = 1)\n"
"_tmp := concat (_tmp, \'/\');\n"
"}\n"
"string_to_file ( _dest, _content, 0);\n"
"}\n"
"\n"
"end_exp:\n"
"close c;\n"
"return;\n"
"}\n"
"--src vfs.sql:1014\n";

static const char *proc321 = 
"create procedure WS.WS.FIND_KEYWORD (inout params varchar, in _pkey varchar)\n"
"{\n"
"declare inx integer;\n"
"declare pkey_len integer;\n"
"declare result, pkey varchar;\n"
"declare line varchar;\n"
"declare cr, lf char;\n"
"if (isnull (_pkey))\n"
"return \'\';\n"
"pkey_len := length (_pkey);\n"
"inx := length (params) - 1;\n"
"result := \'\';\n"
"pkey := ucase (_pkey);\n"
"while (inx >= 0)\n"
"{\n"
"line := aref (params, inx);\n"
"if ( pkey = ucase (substring (line, 1, pkey_len)))\n"
"{\n"
"result := substring (line, pkey_len + 1, length (line));\n"
"if ( 2 < length (result))\n"
"{\n"
"cr := chr (aref (result, length (result) - 1));\n"
"lf := chr (aref (result, length (result) - 2));\n"
"}\n"
"if ( lf = \'\\r\' or lf = \'\\n\')\n"
"result := substring (result, 1, length(result) - 2);\n"
"else if ( cr = \'\\r\' or cr = \'\\n\')\n"
"result := substring (result, 1, length(result) - 1);\n"
"result := trim (result);\n"
"goto end_find;\n"
"}\n"
"inx := inx - 1;\n"
"}\n"
"end_find:\n"
"return result;\n"
"}\n"
"--src vfs.sql:1090\n";

static const char *proc322 = 
"create procedure WS.WS.GET_HREF_IN_ARRAY (in _content varchar, in _d_imgs varchar)\n"
"{\n"
"declare _stag, _etag, _len, _inx, _htag, _sltag, _count, _t_tag1, _t_tag2, _uri_len integer;\n"
"declare _tmp, _tmp_host, _tmp_url, _t_len varchar;\n"
"declare _uri, _res any;\n"
"declare _href_c integer;\n"
"\n"
"_len := length (_content);\n"
"_href_c := 0;\n"
"_stag := 0;\n"
"_inx := 0;\n"
"_etag := _len - 1;\n"
"while (_stag is not null and _etag is not null)\n"
"{\n"
"_t_tag1 := _stag;\n"
"_t_tag2 := _stag;\n"
"_t_tag1 := _stag + strcasestr (subseq (_content, _stag, _len), \'SRC=\');\n"
"_t_tag2 := _stag + strcasestr (subseq (_content, _stag, _len), \'HREF=\');\n"
"\n"
"if (_t_tag1 is not null and _t_tag2 is not null and _t_tag1 < _t_tag2)\n"
"_stag := _t_tag1;\n"
"else if (_t_tag2 is not null)\n"
"_stag := _t_tag2;\n"
"else if (_t_tag1 is not null)\n"
"_stag := _t_tag1;\n"
"else\n"
"goto next_round;\n"
"\n"
"\n"
"_stag := _stag + strstr (subseq (_content, _stag, _len), \'\"\');\n"
"_etag := strstr (subseq (_content, _stag + 1, _len), \'\"\');\n"
"_tmp := subseq (_content, _stag + 1, _etag + _stag + 1);\n"
"if (length (_tmp) > 0 and aref (_tmp, length (_tmp) - 1) = ascii (\'\\\\\'))\n"
"_tmp := subseq (_tmp, 0, length (_tmp) - 1);\n"
"if (_stag is not null)\n"
"{\n"
"if (_tmp is not null and length (_tmp) > 0)\n"
"{\n"
"if (strstr (http_mime_type (_tmp), \'image/\') is null or _d_imgs is not null)\n"
"_href_c := _href_c + 1;\n"
"}\n"
"}\n"
"_stag := _stag + _etag + 1;\n"
"}\n"
"next_round:\n"
"if (_href_c < 1)\n"
"return vector ();\n"
"_res := make_array (_href_c, \'any\');\n"
"_href_c := 0;\n"
"_stag := 0;\n"
"_inx := 0;\n"
"_etag := _len - 1;\n"
"while (_stag is not null and _etag is not null)\n"
"{\n"
"_t_tag1 := _stag;\n"
"_t_tag2 := _stag;\n"
"_t_tag1 := _stag + strcasestr (subseq (_content, _stag, _len), \'SRC=\');\n"
"_t_tag2 := _stag + strcasestr (subseq (_content, _stag, _len), \'HREF=\');\n"
"\n"
"if (_t_tag1 is not null and _t_tag2 is not null and _t_tag1 < _t_tag2)\n"
"_stag := _t_tag1;\n"
"else if (_t_tag2 is not null)\n"
"_stag := _t_tag2;\n"
"else if (_t_tag1 is not null)\n"
"_stag := _t_tag1;\n"
"else\n"
"goto end_find;\n"
"\n"
"\n"
"_stag := _stag + strstr (subseq (_content, _stag, _len), \'\"\');\n"
"_etag := strstr (subseq (_content, _stag + 1, _len), \'\"\');\n"
"_tmp := subseq (_content, _stag + 1, _etag + _stag + 1);\n"
"if (length (_tmp) > 0 and aref (_tmp, length (_tmp) - 1) = ascii (\'\\\\\'))\n"
"_tmp := subseq (_tmp, 0, length (_tmp) - 1);\n"
"if (_stag is not null)\n"
"{\n"
"if (_tmp is not null and length (_tmp) > 0)\n"
"{\n"
"if (strstr (http_mime_type (_tmp), \'image/\') is null or _d_imgs is not null)\n"
"{\n"
"aset (_res, _href_c, _tmp);\n"
"_href_c := _href_c + 1;\n"
"}\n"
"}\n"
"}\n"
"_stag := _stag + _etag + 1;\n"
"}\n"
"end_find:\n"
"return _res;\n"
"}\n"
"--src vfs.sql:1130\n";

static const char *proc323 = 
"create procedure WS.WS.DAV_EXP (in _host varchar, in _url varchar, in _root varchar, in _i_dst varchar)\n"
"{\n"
"declare _path, _name, _content, _dest, _tmp, _etag, _dst varchar;\n"
"declare _os_path any;\n"
"declare _o_len, _n, _rc integer;\n"
"declare _d_host varchar;\n"
"declare _visited, _t_root varchar;\n"
"declare tgt_is_vis integer;\n"
"declare bm, err any;\n"
"declare c static cursor for select RES_FULL_PATH, RES_NAME, blob_to_string (RES_CONTENT) from SYS_DAV_RES\n"
"where RES_FULL_PATH like concat (_root, \'%\');\n"
"set isolation = \'committed\';\n"
"_visited := \';\';\n"
"tgt_is_vis := 0;\n"
"_t_root := _root;\n"
"if (dav_root () = \'/\')\n"
"_root := concat (\'/\', _root, \'/\');\n"
"else\n"
"_root := concat (\'/\', dav_root (), \'/\', _root, \'/\');\n"
"\n"
"if (aref (_i_dst, length (_i_dst) - 1) = ascii (\'/\'))\n"
"_dst := subseq (_i_dst, 0, length (_i_dst) - 1);\n"
"else\n"
"_dst := _i_dst;\n"
"\n"
"if (strstr (_dst,\'http://\') = 0)\n"
"_d_host := subseq (_dst, 0, strchr (subseq (_dst, strstr (_dst,\'http://\') + 7, length (_dst)),\'/\') + 7);\n"
"else\n"
"return \'The destination must begin with http:// protocol identifier\';\n"
"whenever not found goto end_exp;\n"
"open c (prefetch 1);\n"
"fetch c first into _path, _name, _content;\n"
"while (1)\n"
"{\n"
"bm := bookmark (c);\n"
"err := 0;\n"
"close c;\n"
"\n"
"commit work;\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"rollback work;\n"
"err := 1;\n"
"goto next;\n"
"};\n"
"\n"
"if (not tgt_is_vis)\n"
"{\n"
"declare tpa, tpath varchar;\n"
"declare ti, tl integer;\n"
"tpa := WS.WS.HREF_TO_ARRAY (_dst, _d_host);\n"
"_rc := 0; tl := length (tpa); ti := tl - 1;\n"
"while (ti >= 0)\n"
"{\n"
"tpath := concat (_d_host, \'/\'); _n := 0;\n"
"while (_n <= ti)\n"
"{\n"
"tpath := concat (tpath, WS.WS.STR_TO_URI (aref (tpa, _n)), \'/\');\n"
"_n := _n + 1;\n"
"}\n"
"if (not tgt_is_vis)\n"
"_rc := WS.WS.DAV_HEAD (tpath);\n"
"if (_rc = 0)\n"
"{\n"
"_visited := concat (_visited, \';\', tpath);\n"
"tgt_is_vis := 1;\n"
"}\n"
"ti := ti - 1;\n"
"}\n"
"tgt_is_vis := 1;\n"
"}\n"
"\n"
"_dest := concat (_dst, subseq (_path, strstr (_path, dav_root ()) + length (dav_root ()), length (_path)));\n"
"_os_path := WS.WS.HREF_TO_ARRAY (_dest, _d_host);\n"
"_o_len := length (_os_path);\n"
"_n := 0;\n"
"_tmp := concat (_d_host, \'/\');\n"
"while (_n < _o_len - 1)\n"
"{\n"
"_tmp := concat (_tmp, WS.WS.STR_TO_URI (aref (_os_path, _n)), \'/\');\n"
"if (strstr (_visited, _tmp) is null)\n"
"{\n"
"_rc := WS.WS.DAV_HEAD (_tmp);\n"
"if (_rc <> 0)\n"
"_rc := WS.WS.DAV_MKCOL (_tmp);\n"
"if (_rc <> 0)\n"
"return _rc;\n"
"_visited := concat (_visited, \';\', _tmp);\n"
"}\n"
"_n := _n + 1;\n"
"}\n"
"_dest := concat (_dst,\n"
"WS.WS.STR_TO_URI (\n"
"subseq (_path, strstr (_path, dav_root ()) + length (dav_root ()), length (_path))));\n"
"WS.WS.DAV_PUT (_dest, _content);\n"
"next:\n"
"open c (prefetch 1);\n"
"fetch c bookmark bm into _path, _name, _content;\n"
"fetch c next into _path, _name, _content;\n"
"}\n"
"\n"
"end_exp:\n"
"close c;\n"
"return 0;\n"
"}\n"
"--src vfs.sql:1223\n";

static const char *proc324 = 
"create procedure WS.WS.DAV_HEAD (inout _url varchar)\n"
"{\n"
"declare _res any;\n"
"declare _resp, _err varchar;\n"
"_resp := \'\'; _err := \'Cannot connect\';\n"
"http_get (_url, _res, \'HEAD\');\n"
"_resp := WS.WS.FIND_KEYWORD (_res, \'HTTP/1.\');\n"
"if (_resp is not null and _resp <> \'\')\n"
"_err := substring (_resp, 2, length (_resp) - 1);\n"
"_resp := subseq (_resp, strchr (_resp, \' \') + 1, length (_resp));\n"
"_resp := subseq (_resp, 0, strchr (_resp, \' \'));\n"
"if (_resp = \'200\')\n"
"return 0;\n"
"else\n"
"return _err;\n"
"}\n"
"--src vfs.sql:1331\n";

static const char *proc325 = 
"create procedure WS.WS.DAV_MKCOL (inout _url varchar)\n"
"{\n"
"declare _res any;\n"
"declare _resp, _err varchar;\n"
"_err := \'Cannot connect\';\n"
"http_get (_url, _res, \'MKCOL\');\n"
"_resp := WS.WS.FIND_KEYWORD (_res, \'HTTP/1.\');\n"
"if (_resp is not null and _resp <> \'\')\n"
"_err := substring (_resp, 2, length (_resp) - 1);\n"
"_resp := subseq (_resp, strchr (_resp, \' \') + 1, length (_resp));\n"
"_resp := subseq (_resp, 0, strchr (_resp, \' \'));\n"
"if (_resp = \'201\')\n"
"return 0;\n"
"else\n"
"return _err;\n"
"}\n"
"--src vfs.sql:1350\n";

static const char *proc326 = 
"create procedure WS.WS.DAV_PUT (inout _url varchar,in _content varchar)\n"
"{\n"
"declare _res any;\n"
"declare _resp varchar;\n"
"commit work;\n"
"http_get (_url, _res, \'PUT\', concat (\'Content-Type: \', http_mime_type (_url)), _content);\n"
"_resp := WS.WS.FIND_KEYWORD (_res, \'HTTP/1.\');\n"
"_resp := subseq (_resp, strchr (_resp, \' \') + 1, length (_resp));\n"
"_resp := subseq (_resp, 0, strchr (_resp, \' \'));\n"
"if (_resp = \'201\' or _resp = \'204\' or _resp = \'200\')\n"
"return 0;\n"
"else\n"
"return -1;\n"
"}\n"
"--src vfs.sql:1369\n";

static const char *proc327 = 
"create procedure WS.WS.DAV_PROP (inout _url varchar, in _d_imgs varchar, in _auth varchar)\n"
"{\n"
"declare _res , _tree, _dav, _href, _responce any;\n"
"declare _resp, _body varchar;\n"
"declare _inx integer;\n"
"if (isstring (_auth) and _auth <> \'\')\n"
"{\n"
"_body := http_get (_url, _res, \'PROPFIND\', sprintf (\'Content-Type: text/xml\\nDepth: 1\\n%s\', _auth),\n"
"\'<D:propfind xmlns:D=\"DAV:\"><D:prop><D:resourcetype/><D:getcontenttype/></D:prop></D:propfind>\');\n"
"}\n"
"else\n"
"{\n"
"_body := http_get (_url, _res, \'PROPFIND\', \'Content-Type: text/xml\\nDepth: 1\',\n"
"\'<D:propfind xmlns:D=\"DAV:\"><D:prop><D:resourcetype/><D:getcontenttype/></D:prop></D:propfind>\');\n"
"}\n"
"\n"
"\n"
"_res := WS.WS.GET_HREF_FROM_XML (_body, _d_imgs);\n"
"return _res;\n"
"}\n"
"--src vfs.sql:1386\n";

static const char *proc328 = 
"create procedure WS.WS.GET_HREF_FROM_XML (in _content varchar, in _d_imgs varchar)\n"
"{\n"
"declare _stag, _etag, _len, _inx, _htag, _sltag, _count, _t_tag1, _t_tag2, _uri_len integer;\n"
"declare _tmp, _tmp_host, _tmp_url, _t_len varchar;\n"
"declare _uri, _res any;\n"
"declare _href_c integer;\n"
"\n"
"_len := length (_content);\n"
"_href_c := 0;\n"
"_stag := 0;\n"
"_inx := 0;\n"
"_etag := _len - 1;\n"
"while (_stag is not null and _etag is not null)\n"
"{\n"
"_t_tag1 := _stag;\n"
"_t_tag2 := _stag;\n"
"_t_tag1 := NULL;\n"
"_t_tag2 := _stag + strcasestr (subseq (_content, _stag, _len), \'href>\');\n"
"\n"
"if (_t_tag1 is not null and _t_tag2 is not null and _t_tag1 < _t_tag2)\n"
"_stag := _t_tag1;\n"
"else if (_t_tag2 is not null)\n"
"_stag := _t_tag2;\n"
"else if (_t_tag1 is not null)\n"
"_stag := _t_tag1;\n"
"else\n"
"goto next_round;\n"
"\n"
"\n"
"_stag := _stag + strstr (subseq (_content, _stag, _len), \'>\');\n"
"_etag := strstr (subseq (_content, _stag + 1, _len), \'<\');\n"
"_tmp := subseq (_content, _stag + 1, _etag + _stag + 1);\n"
"if (length (_tmp) > 1)\n"
"{\n"
"if (aref (_tmp, length (_tmp) - 1) = ascii (\'\\\\\'))\n"
"_tmp := subseq (_tmp, 0, length (_tmp) - 1);\n"
"if (_stag is not null)\n"
"{\n"
"if (_tmp is not null)\n"
"{\n"
"if (length (_tmp) > 1)\n"
"{\n"
"if (strstr (http_mime_type (_tmp), \'image/\') is null or _d_imgs is not null)\n"
"_href_c := _href_c + 1;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"_stag := _stag + _etag + 1;\n"
"}\n"
"next_round:\n"
"if (_href_c < 1)\n"
"return vector ();\n"
"_res := make_array (_href_c, \'any\');\n"
"_href_c := 0;\n"
"_stag := 0;\n"
"_inx := 0;\n"
"_etag := _len - 1;\n"
"while (_stag is not null and _etag is not null)\n"
"{\n"
"_t_tag1 := _stag;\n"
"_t_tag2 := _stag;\n"
"_t_tag1 := NULL;\n"
"_t_tag2 := _stag + strcasestr (subseq (_content, _stag, _len), \'href>\');\n"
"\n"
"if (_t_tag1 is not null and _t_tag2 is not null and _t_tag1 < _t_tag2)\n"
"_stag := _t_tag1;\n"
"else if (_t_tag2 is not null)\n"
"_stag := _t_tag2;\n"
"else if (_t_tag1 is not null)\n"
"_stag := _t_tag1;\n"
"else\n"
"goto end_find;\n"
"\n"
"\n"
"_stag := _stag + strstr (subseq (_content, _stag, _len), \'>\');\n"
"_etag := strstr (subseq (_content, _stag + 1, _len), \'<\');\n"
"_tmp := subseq (_content, _stag + 1, _etag + _stag + 1);\n"
"if (length (_tmp) > 1)\n"
"{\n"
"if (aref (_tmp, length (_tmp) - 1) = ascii (\'\\\\\'))\n"
"_tmp := subseq (_tmp, 0, length (_tmp) - 1);\n"
"if (_stag is not null)\n"
"{\n"
"if (_tmp is not null)\n"
"{\n"
"if (length (_tmp) > 1)\n"
"{\n"
"if (strstr (http_mime_type (_tmp), \'image/\') is null or _d_imgs is not null)\n"
"{\n"
"aset (_res, _href_c, _tmp);\n"
"_href_c := _href_c + 1;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"_stag := _stag + _etag + 1;\n"
"}\n"
"end_find:\n"
"return _res;\n"
"}\n"
"--src vfs.sql:1410\n";

static const char *proc329 = 
"create procedure WS.WS.ISEMPTY (in x any)\n"
"{\n"
"if (\'\' = x or x is null or x = 0)\n"
"{\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"return 0;\n"
"}\n"
"}\n"
"--src vfs.sql:1515\n";

static const char *proc330 = 
"create procedure WS.WS.URL_BY_DATE (in host varchar, in coll varchar, out url varchar, in _clnt_data any)\n"
"{\n"
"declare next_url varchar;\n"
"whenever not found goto done;\n"
"declare cr cursor for select top 1 VQ_URL from WS.WS.VFS_QUEUE\n"
"where VQ_HOST = host and VQ_ROOT = coll and VQ_STAT = \'waiting\' order by VQ_HOST, VQ_ROOT, VQ_TS for update;\n"
"url := null;\n"
"open cr;\n"
"fetch cr into next_url;\n"
"update WS.WS.VFS_QUEUE set VQ_STAT = \'pending\' where VQ_HOST = host and VQ_ROOT = coll and VQ_URL = next_url;\n"
"url := next_url;\n"
"close cr;\n"
"return 1;\n"
"done:\n"
"close cr;\n"
"return 0;\n"
"}\n"
"--src vfs.sql:1537\n";

static const char *proc331 = 
"create procedure WS.WS.VFS_MAKE_ENTRY (\n"
"in url varchar,\n"
"in follow varchar := \'/*\',\n"
"in disallow varchar := \'%.zip;%.tar;%.pdf;%.tgz;%.arj;\',\n"
"in get_rdf int := 0\n"
")\n"
"{\n"
"declare hi any;\n"
"hi := rfc1808_parse_uri (url);\n"
"insert replacing WS.WS.VFS_SITE\n"
"(VS_DESCR, VS_HOST, VS_URL, VS_OWN, VS_ROOT, VS_NEWER, VS_DEL, VS_FOLLOW, VS_NFOLLOW, VS_SRC, VS_DLOAD_META)\n"
"values (hi[1], hi[1], hi[2], 2, hi[1], cast (\'1990-01-01\' as datetime),  \'checked\', follow, disallow, \'checked\', get_rdf);\n"
"\n"
"insert replacing WS.WS.VFS_QUEUE (VQ_HOST, VQ_TS, VQ_URL, VQ_ROOT, VQ_STAT)\n"
"values (hi[1], now(), hi[2], hi[1], \'waiting\');\n"
"if (get_rdf)\n"
"{\n"
"insert replacing WS.WS.VFS_SITE_RDF_MAP (VM_HOST, VM_ROOT, VM_RDF_MAP, VM_SEQ)\n"
"select hi[1], hi[1], RM_PID, RM_ID from DB.DBA.SYS_RDF_MAPPERS;\n"
"}\n"
"}\n"
"--src vfs.sql:1561\n";

static const char *proc332 = 
"create procedure WS.WS.VFS_GO (in url varchar)\n"
"{\n"
"declare hi any;\n"
"hi := rfc1808_parse_uri (url);\n"
"WS.WS.SERV_QUEUE_TOP (hi[1], hi[1], 0, 0, NULL, NULL);\n"
"}\n"
"--src vfs.sql:1584\n";

static const char *proc333 = 
"create procedure\n"
"WS.WS.VFS_URI_COMPOSE (in res any)\n"
"{\n"
"declare _full_path, _elm varchar;\n"
"declare idx integer;\n"
"\n"
"if (length (res) < 6)\n"
"signal (\'.....\', \'WS.WS.VFS_URI_COMPOSE needs a vector of strings with 6 elements\');\n"
"\n"
"idx := 0;\n"
"_elm := \'\';\n"
"_full_path := \'\';\n"
"while (idx < 6)\n"
"{\n"
"_elm := res[idx];\n"
"if (isstring (_elm) and _elm <> \'\')\n"
"{\n"
"if (idx = 0)\n"
"_full_path := concat (_elm, \':\');\n"
"else if (idx = 1)\n"
"_full_path := concat (_full_path, \'//\', _elm);\n"
"else if (idx = 2)\n"
"_full_path := concat (_full_path, _elm);\n"
"else if (idx = 3)\n"
"_full_path := concat (_full_path, \';\', _elm);\n"
"else if (idx = 4)\n"
"_full_path := concat (_full_path, \'?\', _elm);\n"
"else if (idx = 5)\n"
"_full_path := concat (_full_path, \'#\', _elm);\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return _full_path;\n"
"}\n"
"--src vfs.sql:1593\n";

static const char *proc334 = 
"create procedure WS.WS.VFS_EXTRACT_RDF (in _host varchar, in _root varchar, in _start_path varchar, in opts any, in url varchar, inout content any, in ctype varchar, inout outhdr any, inout inhdr any)\n"
"{\n"
"declare mime_type, _graph, _base, out_arr, tmp varchar;\n"
"declare html_start, xd any;\n"
"declare rc int;\n"
"\n"
"html_start := null;\n"
"\n"
"_graph := WS.WS.MAKE_URL (_host, _start_path);\n"
"_base := WS.WS.MAKE_URL (_host, url);\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return;\n"
"};\n"
"\n"
"\n"
"mime_type := DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (url, ctype, content);\n"
"\n"
"\n"
"if (1 and (get_keyword (\'meta_rdf\', opts, 0) = 1))\n"
"{\n"
"if (strstr (mime_type, \'application/rdf+xml\') is not null)\n"
"DB.DBA.RDF_LOAD_RDFXML (content, url, _graph);\n"
"else if (\n"
"strstr (mime_type, \'text/rdf+n3\') is not null or\n"
"strstr (mime_type, \'text/rdf+ttl\') is not null or\n"
"strstr (mime_type, \'application/rdf+n3\') is not null or\n"
"strstr (mime_type, \'application/rdf+turtle\') is not null or\n"
"strstr (mime_type, \'application/turtle\') is not null or\n"
"strstr (mime_type, \'application/x-turtle\') is not null\n"
")\n"
"DB.DBA.TTLP (content, url, _graph);\n"
"}\n"
"\n"
"\n"
"for select RM_PATTERN, RM_TYPE, RM_HOOK, RM_KEY, RM_OPTIONS from DB.DBA.SYS_RDF_MAPPERS, WS.WS.VFS_SITE_RDF_MAP\n"
"where RM_ENABLED = 1 and VM_RDF_MAP = RM_PID and VM_HOST = _host and VM_ROOT = _root\n"
"order by VM_SEQ\n"
"do\n"
"{\n"
"declare val_match, pcols, new_opts, aq any;\n"
"if (RM_TYPE = \'MIME\')\n"
"{\n"
"val_match := mime_type;\n"
"}\n"
"else if (RM_TYPE = \'URL\' or RM_TYPE = \'HTTP\')\n"
"{\n"
"val_match := url;\n"
"}\n"
"else\n"
"val_match := null;\n"
"aq := null;\n"
"if (isstring (val_match) and regexp_match (RM_PATTERN, val_match) is not null)\n"
"{\n"
"if (__proc_exists (RM_HOOK) is null)\n"
"goto try_next_mapper;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"goto try_next_mapper;\n"
"};\n"
"\n"
"new_opts := RM_OPTIONS;\n"
"if (RM_TYPE <> \'HTTP\')\n"
"{\n"
"rc := call (RM_HOOK) (_graph, url, null, content, aq, aq, RM_KEY, new_opts);\n"
"}\n"
"else\n"
"{\n"
"declare hf any;\n"
"hf := rfc1808_parse_uri (url);\n"
"hf[0] := \'\';\n"
"hf[1] := \'\';\n"
"hf[5] := \'\';\n"
"tmp := \'GET \'||WS.WS.VFS_URI_COMPOSE (hf)||\' HTTP/1.1\\r\\nHost: \' || _host || \'\\r\\n\' || outhdr;\n"
"tmp := replace (tmp, \'\\r\', \'\\n\');\n"
"tmp := replace (tmp, \'\\n\\n\', \'\\n\');\n"
"out_arr := split_and_decode (tmp, 0, \'\\0\\0\\n\');\n"
"rc := call (RM_HOOK) (_graph, url, null, content, aq, aq, vector (out_arr, inhdr), new_opts);\n"
"}\n"
"\n"
"if (rc < 0 or rc > 0)\n"
"return;\n"
"}\n"
"try_next_mapper:;\n"
"}\n"
"\n"
"}\n"
"--src vfs.sql:1630\n";

static const char *proc335 = 
"create procedure WS.WS.SITEMAP_ENSURE_NEW_SITE (in _host varchar, in _root varchar, in _new_host varchar, in _new_url varchar)\n"
"{\n"
"if (not exists (select 1 from WS.WS.VFS_SITE where VS_HOST = _new_host and VS_ROOT = _root))\n"
"{    \n"
"insert into WS.WS.VFS_SITE (VS_HOST, VS_ROOT, VS_URL, VS_SRC, VS_OWN, VS_DEL, VS_NEWER, VS_FOLLOW, VS_NFOLLOW, VS_METHOD, VS_OTHER, VS_DESCR)\n"
"select _new_host, _root, _new_url, VS_SRC, VS_OWN, VS_DEL, VS_NEWER, VS_FOLLOW, VS_NFOLLOW, VS_METHOD, VS_OTHER, VS_DESCR ||\':\'|| _new_host \n"
"from WS.WS.VFS_SITE where VS_HOST = _host and VS_ROOT = _root;\n"
"}    \n"
"}\n"
"--src vfs.sql:1724\n";

static const char *proc336 = 
"create procedure WS.WS.SITEMAP_URLS_REGISTER (in _host varchar, in _root varchar, inout xp any, in lev int := 0)\n"
"{\n"
"foreach (any u in xp) do\n"
"{\n"
"declare hf, host, url varchar;\n"
"\n"
"u := cast (u as varchar);\n"
"hf := WS.WS.PARSE_URI (u);\n"
"host := hf[1];\n"
"url := hf[2];\n"
"WS.WS.SITEMAP_ENSURE_NEW_SITE (_host, _root, host, url);\n"
"insert soft WS.WS.VFS_QUEUE (VQ_HOST, VQ_TS, VQ_URL, VQ_STAT, VQ_ROOT, VQ_OTHER, VQ_LEVEL) \n"
"values (host, now (), url, \'waiting\', _root, \'other\', lev); \n"
"}\n"
"commit work;\n"
"}\n"
"--src vfs.sql:1736\n";

static const char *proc337 = 
"create procedure WS.WS.SITEMAP_XML_PARSE (in _host varchar, in _url varchar, in _root varchar, inout _content varchar, \n"
"in _c_type varchar := null, in lev int := 0)\n"
"{\n"
"declare xt, xp any;\n"
"xt := null;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"return;\n"
"};\n"
"if (_url like \'%.xml.gz\')\n"
"{\n"
"_content := gzip_uncompress (_content); \n"
"}\n"
"if (_url like \'%.xml\' or _url like \'%.xml.gz\')\n"
"{\n"
"xt := xtree_doc (_content);\n"
"if (xpath_eval (\'/urlset/dataset\', xt) is not null)\n"
"{\n"
"xp := xpath_eval (\'/urlset/dataset/dataDumpLocation/text()\', xt, 0);\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, xp, lev);\n"
"}\n"
"else if (xpath_eval (\'/sitemapindex/sitemap/loc\', xt) is not null)\n"
"{\n"
"xp := xpath_eval (\'/sitemapindex/sitemap/loc/text()\', xt, 0);\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, xp, lev);\n"
"}\n"
"else if (_c_type = \'application/sparql-results+xml\')\n"
"{\n"
"xp := xpath_eval (\'/sparql/results/result/binding/uri/text()\', xt, 0);\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, xp, lev);\n"
"}\n"
"if (xpath_eval (\'/urlset/dataset/sampleURI\', xt) is not null)\n"
"{\n"
"xp := xpath_eval (\'/urlset/dataset/sampleURI/text()\', xt, 0);\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, xp, lev);\n"
"}\n"
"}\n"
"}\n"
"--src vfs.sql:1754\n";

static const char *proc338 = 
"create procedure WS.WS.SITEMAP_RDF_STORE (in _host varchar, in _url varchar, in _root varchar,\n"
"inout _content varchar, in _s_etag varchar, in _c_type varchar,\n"
"in store_flag int := 1, in udata any := null, in lev int := 0)\n"
"{\n"
"declare graph varchar;\n"
"graph := null;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"update WS.WS.VFS_QUEUE set VQ_STAT = \'error\', VQ_ERROR = __SQL_MESSAGE\n"
"where VQ_HOST = _host and VQ_ROOT = _root and VQ_URL = _url;\n"
"commit work;\n"
"return;\n"
"};\n"
"\n"
"graph := WS.WS.VFS_URI_COMPOSE (vector (\'http\', _host, _url, \'\', \'\', \'\'));\n"
"\n"
"if (_url like \'%.rdf\' or _c_type = \'application/rdf+xml\')\n"
"{\n"
"DB.DBA.RDF_LOAD_RDFXML (_content, graph, graph);\n"
"}\n"
"else if (_url like \'%.n3\' or _url like \'%.ttl\' or _url like \'%.nt\' or _c_type = \'text/n3\' or _c_type = \'text/rdf+n3\')\n"
"{\n"
"DB.DBA.TTLP (_content, graph, graph, 255);\n"
"}\n"
"if (isvector (udata) and isvector (get_keyword (\'follow-property\', udata)))\n"
"{\n"
"declare objs, arr, ids any;\n"
"arr := get_keyword (\'follow-property\', udata);\n"
"for (declare i int, i := 0; i < length (arr); i := i + 1)\n"
"{\n"
"if (not isiri_id (arr[i])) \n"
"arr[i] := iri_to_id (arr[i], 0);  \n"
"}\n"
"objs := (select DB.DBA.VECTOR_AGG (id_to_iri (O)) from DB.DBA.RDF_QUAD where G = iri_to_id (graph, 0) and P in (arr) and isiri_id (O));\n"
"WS.WS.SITEMAP_URLS_REGISTER (_host, _root, objs, lev);\n"
"} \n"
"insert soft WS.WS.VFS_URL (VU_HOST, VU_URL, VU_CHKSUM, VU_CPTIME, VU_ETAG, VU_ROOT)\n"
"values (_host, _url, md5 (_content), now (), _s_etag, _root);\n"
"if (row_count () = 0)\n"
"update WS.WS.VFS_URL set VU_CHKSUM = md5 (_content), VU_CPTIME = now (), VU_ETAG = _s_etag where\n"
"VU_HOST = _host and VU_URL = _url and VU_ROOT = _root;\n"
"commit work;\n"
"}\n"
"--src vfs.sql:1795\n";

/* davxml2rdfxml.xsl */

static const char *xsl7[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -\n"
" -  $Id: davxml2rdfxml.xsl,v 1.1 2007/03/26 14:47:01 source Exp $\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2006 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\"\n"
"  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
"  xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n"
"  xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\n"
"  xmlns:virt=\"virt\"\n"
"  xmlns:virtrdf=\"http://local.virt/rdf/\">\n"
"\n"
"<xsl:param name=\"this-stub-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"this-real-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"rdf-uri\" select=\"'http://www.w3.org/1999/02/22-rdf-syntax-ns#'\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <rdf:RDF>\n"
"    <xsl:for-each select=\"virt:rdf\">\n"
"      <xsl:apply-templates select=\"virt:res|virt:top-res\"/>\n"
"    </xsl:for-each>\n"
"    <xsl:for-each select=\"N3\"><xsl:text>\n"
"</xsl:text><rdf:Description>\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"starts-with (@N3S, 'nodeID://')\"><xsl:attribute name=\"rdf:nodeID\"><xsl:value-of select=\"substring (@N3S, 10)\"/></xsl:attribute></xsl:when>\n"
"          <xsl:otherwise><xsl:attribute name=\"rdf:about\"><xsl:value-of select=\"@N3S\"/></xsl:attribute></xsl:otherwise>\n"
"        </xsl:choose>\n"
"        <xsl:element-rdfqname name=\"{@N3P}\">\n"
"          <xsl:if test=\"exists(@N3ID)\"><xsl:attribute name=\"rdf:ID\"><xsl:value-of select=\"@N3ID\"/></xsl:attribute></xsl:if>\n"
"          <xsl:choose>\n"
"            <xsl:when test=\"starts-with (@N3O, 'nodeID://')\"><rdf:Description rdf:nodeID=\"{substring (@N3O, 10)}\"/></xsl:when>\n"
"            <xsl:when test=\"exists (@N3O)\"><rdf:Description rdf:about=\"{@N3O}\"/></xsl:when>\n"
"            <xsl:otherwise>\n"
"              <xsl:copy-of select=\"@xml:lang\"/>\n"
"              <xsl:if test=\"*\"><xsl:attribute name=\"rdf:parseType\">Literal</xsl:attribute></xsl:if>\n"
"              <xsl:if test=\"@N3DT\"><xsl:attribute name=\"rdf:datatype\"><xsl:value-of select=\"@N3DT\"/></xsl:attribute></xsl:if>\n"
"              <xsl:copy-of select=\"node()\"/>\n"
"            </xsl:otherwise>\n"
"          </xsl:choose>\n"
"        </xsl:element-rdfqname>\n"
"      </rdf:Description>\n"
"    </xsl:for-each>\n"
"  </rdf:RDF>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res|virt:top-res\" priority=\"8\">\n"
"  <xsl:variable name=\"raw-subj\" select=\"name(*[1])\"/>\n"
"<xsl:text>\n"
"</xsl:text><rdf:Description rdf:about=\"{(!if!) ($raw-subj = $this-stub-uri, $this-real-uri, $raw-subj)}\">\n"
"    <xsl:for-each select=\"virt:prop\">\n"
"      <xsl:call-template name=\"make-pred\"/>\n"
"    </xsl:for-each>\n"
"  </rdf:Description>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:apply-templates select=\"virt:res\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res[@N3S]|virt:top-res[@N3S]\" priority=\"9\">\n"
"  <xsl:variable name=\"subj\" select=\"string(@N3S)\"/>\n"
"  <xsl:text>\n"
"</xsl:text><rdf:Description rdf:nodeID=\"{$subj}\">\n"
"    <xsl:for-each select=\"virt:prop\">\n"
"      <xsl:call-template name=\"make-pred\"/>\n"
"    </xsl:for-each>\n"
"  </rdf:Description>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:apply-templates select=\"virt:res\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res[@N3DUPE]|virt:top-res[@N3DUPE]\" priority=\"10\"/>\n"
"<xsl:template match=\"virt:res[empty (virt:prop)]|virt:top-res[empty (virt:prop)]\" priority=\"10\"/>\n"
"\n"
"<xsl:template name=\"make-pred\">\n"
"<xsl:text>\n"
"</xsl:text><xsl:element-rdfqname name=\"{name(*[1])}\">\n"
"    <xsl:if test=\"exists(@N3ID)\"><xsl:attribute name=\"rdf:ID\"><xsl:value-of select=\"@N3ID\"/></xsl:attribute></xsl:if>\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"virt:res[@N3S]\"><rdf:Description rdf:nodeID=\"{virt:res/@N3S}\"/></xsl:when>\n"
"      <xsl:when test=\"virt:res\">\n"
"        <xsl:variable name=\"raw-subj\" select=\"name(virt:res/*[1])\"/>\n"
"        <rdf:Description rdf:about=\"{(!if!) ($raw-subj = $this-stub-uri, $this-real-uri, $raw-subj)}\"/></xsl:when>\n"
"      <xsl:when test=\"virt:value\">\n"
"        <xsl:copy-of select=\"virt:value/@xml:lang\"/>\n"
"        <xsl:if test=\"virt:value/*\"><xsl:attribute name=\"rdf:parseType\">Literal</xsl:attribute></xsl:if>\n"
"        <xsl:if test=\"virt:value/@N3DT\"><xsl:attribute name=\"rdf:datatype\"><xsl:value-of select=\"virt:value/@N3DT\"/></xsl:attribute></xsl:if>\n"
"        <xsl:copy-of select=\"virt:value/node()\"/></xsl:when>\n"
"      <xsl:otherwise><xsl:message terminate=\"yes\">Corrupted DAV RDF XML (virt:pred has no value and no object node)</xsl:message></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:element-rdfqname>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* davxml2n3xml.xsl */

static const char *xsl8[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -\n"
" -  $Id: davxml2n3xml.xsl,v 1.1 2007/03/26 14:47:01 source Exp $\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2006 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\" xmlns:virt=\"virt\" xmlns:virtrdf=\"http://local.virt/rdf/\">\n"
"\n"
"<xsl:param name=\"this-stub-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"this-real-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"rdf-uri\" select=\"'http://www.w3.org/1999/02/22-rdf-syntax-ns#'\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:for-each select=\"virt:rdf\">\n"
"    <xsl:apply-templates select=\"virt:res|virt:top-res\"/>\n"
"  </xsl:for-each>\n"
"  <xsl:copy-of select=\"N3\"/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res|virt:top-res\" priority=\"8\">\n"
"  <xsl:variable name=\"raw-subj\" select=\"name(*[1])\"/>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:call-template name=\"make-pred\"><xsl:with-param name=\"subj\" select=\"(!if!) ($raw-subj = $this-stub-uri, $this-real-uri, $raw-subj)\"/></xsl:call-template>\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:apply-templates select=\"virt:res\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res[@N3S]|virt:top-res[@N3S]\" priority=\"9\">\n"
"  <xsl:variable name=\"subj\" select=\"string(@N3S)\"/>\n"
"  <xsl:text>\n"
"</xsl:text>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:call-template name=\"make-pred\"><xsl:with-param name=\"subj\" select=\"$subj\"/></xsl:call-template>\n"
"  </xsl:for-each>\n"
"  <xsl:for-each select=\"virt:prop\">\n"
"    <xsl:apply-templates select=\"virt:res\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"virt:res[@N3DUPE]|virt:top-res[@N3DUPE]\" priority=\"10\"/>\n"
"\n"
"<xsl:template name=\"make-pred\">\n"
"  <xsl:param name=\"subj\" />\n"
"    <xsl:text>\n"
"</xsl:text>\n"
"  <N3 N3S=\"{$subj}\" N3P=\"{name(*[1])}\">\n"
"    <xsl:if test=\"exists(@N3ID)\">\n"
"      <xsl:attribute name=\"rdf:ID\"><xsl:value-of select=\"@N3ID\"/></xsl:attribute>\n"
"    </xsl:if>\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"virt:res[@N3S]\">\n"
"        <xsl:attribute name=\"N3O\"><xsl:value-of select=\"virt:res/@N3S\"/></xsl:attribute>\n"
"      </xsl:when>\n"
"      <xsl:when test=\"virt:res\">\n"
"        <xsl:variable name=\"raw-subj\" select=\"name(virt:res/*[1])\"/>\n"
"        <xsl:attribute name=\"N3O\"><xsl:value-of select=\"(!if!) ($raw-subj = $this-stub-uri, $this-real-uri, $raw-subj)\"/></xsl:attribute>\n"
"      </xsl:when>\n"
"      <xsl:when test=\"virt:value\">\n"
"        <xsl:copy-of select=\"virt:value/@xml:lang\"/>\n"
"        <xsl:copy-of select=\"virt:value/@N3DT\"/>\n"
"        <xsl:copy-of select=\"virt:value/node()\"/>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <xsl:message terminate=\"yes\">Corrupted DAV RDF XML (virt:pred has no value and no object node)</xsl:message>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </N3>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* rdfxml2n3xml.xsl */

static const char *xsl9[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -\n"
" -  $Id: rdfxml2n3xml.xsl,v 1.1 2007/03/26 14:47:01 source Exp $\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2006 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\"\n"
"  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n"
"  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
"  xmlns:virtrdf=\"http://local.virt/rdf/\">\n"
"\n"
"<xsl:param name=\"rdf-uri\" select=\"'http://www.w3.org/1999/02/22-rdf-syntax-ns#'\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"  <xsl:variable name=\"n3list\">\n"
"  <xsl:apply-templates select=\"*\" mode=\"top\"/>\n"
"  </xsl:variable>\n"
"  <xsl:for-each select=\"$n3list/*\"><xsl:text>\n"
"</xsl:text><xsl:copy-of select=\".\"/>\n"
"  </xsl:for-each>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"rdf:RDF\" mode=\"top\">\n"
"  <xsl:apply-templates mode=\"descrlist\"/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"top\">\n"
"  <xsl:message terminate=\"yes\">RDF file can not contain top-level elements other than rdf:RDF</xsl:message>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"descrlist\">\n"
"  <xsl:param name=\"subj-name\">\n"
"    <xsl:call-template name=\"expand-subj-name\"/>\n"
"  </xsl:param>\n"
"  <xsl:variable name=\"lang\" select=\"ancestor-or-self::*[@xml:lang][1]/@xml:lang[. != '']\" />\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"self::rdf:Description\"/>\n"
"    <xsl:otherwise>\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{resolve-uri ($rdf-uri, 'type')}\" N3O=\"{resolve-uri (namespace-uri(.), local-name(.))}\"><xsl:copy-of select=\"$lang\"/></N3>\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"  <xsl:for-each select=\"@*\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"self::xml:*|self::rdf:about|self::rdf:nodeID|self::rdf:ID\"/>\n"
"      <xsl:when test=\"self::rdf:type\">\n"
"      <xsl:variable name=\"base\">\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"          <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:variable>\n"
"        <!--TODO: carefully check composing of N3O here.\n"
"          The spec contains no explicit example of rdf:type in Property Attributes on an empty Property Element -->\n"
"        <N3 N3S=\"{$subj-name}\" N3P=\"{resolve-uri ($rdf-uri, 'type')}\" N3O=\"{resolve-uri (string ($base), .)}\"><xsl:copy-of select=\"$lang\"/></N3>\n"
"      </xsl:when>\n"
"      <xsl:when test=\"self::rdf:parseType|self::rdf:resource|self::rdf:datatype\">\n"
"        <xsl:message terminate=\"yes\">Attribute '<xsl:value-of select=\"name(.)\"/>' can appear only in predicate element but not in description element</xsl:message>\n"
"      </xsl:when>\n"
"      <xsl:otherwise>\n"
"        <N3 N3S=\"{$subj-name}\" N3P=\"{resolve-uri (namespace-uri(.), local-name(.))}\"><xsl:copy-of select=\"$lang\"/><xsl:value-of select=\".\"/></N3>\n"
"      </xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:for-each>\n"
"  <xsl:apply-templates mode=\"proplist\">\n"
"    <xsl:with-param name=\"subj-name\" select=\"$subj-name\"/>\n"
"  </xsl:apply-templates>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"*\" mode=\"proplist\">\n"
"  <xsl:variable name=\"lang\" select=\"ancestor-or-self::*[@xml:lang][1]/@xml:lang[. != '']\" />\n"
"  <xsl:variable name=\"base\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"      <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"p-name\">\n"
"    <xsl:choose>\n"
"      <xsl:when test=\"self::rdf:li\"><xsl:value-of select=\"resolve-uri ($rdf-uri, concat('_', 1 + count (preceding-sibling::rdf:li)))\"/></xsl:when>\n"
"      <xsl:otherwise><xsl:value-of select=\"resolve-uri (namespace-uri(.), local-name(.))\"/></xsl:otherwise>\n"
"    </xsl:choose>\n"
"  </xsl:variable>\n"
"  <xsl:variable name=\"p-id\">\n"
"    <xsl:if test=\"@rdf:ID\">\n"
"      <xsl:variable name=\"base\">\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"          <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:variable>\n"
"      <xsl:value-of select=\"resolve-uri(string ($base), concat('#', @rdf:ID))\"/>\n"
"    </xsl:if>\n"
"  </xsl:variable>\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"@rdf:parseType='Literal'\">\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\">\n"
"        <xsl:copy-of select=\"$lang\"/>\n"
"        <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"        <xsl:copy-of select=\"node()\"/></N3>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:parseType='Resource'\">\n"
"      <xsl:variable name=\"obj-name\"><xsl:call-template name=\"expand-subj-name\"/></xsl:variable>\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3O=\"{$obj-name}\">\n"
"        <xsl:copy-of select=\"$lang\"/>\n"
"        <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"      </N3>\n"
"      <xsl:apply-templates mode=\"proplist\">\n"
"        <xsl:with-param name=\"subj-name\" select=\"$obj-name\"/>\n"
"      </xsl:apply-templates>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:parseType='Collection'\">\n"
"            <!--TODO: Implement this [beep] -->\n"
"      <xsl:message terminate=\"yes\">RDF/XML syntax rdf:parseType='Collection' is not yet supported by Virtuoso.</xsl:message>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"exists (@rdf:parseType)\">\n"
"      <xsl:message terminate=\"yes\">Invalid value '<xsl:value-of select=\"@rdf:parseType\"/>' of attribute rdf:parseType of predicate '<xsl:value-of select=\"name(.)\"/>' with subject '<xsl:value-of select=\"$subj-name\"/>'</xsl:message>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:resource\">\n"
"      <xsl:if test=\"exists(node())\">\n"
"        <xsl:message terminate=\"yes\">Predicate '<xsl:value-of select=\"name(.)\"/>' with subject '<xsl:value-of select=\"$subj-name\"/>' has both children and rdf:resource</xsl:message>\n"
"      </xsl:if>\n"
"      <xsl:if test=\"@rdf:datatype\">\n"
"        <xsl:message terminate=\"yes\">Predicate '<xsl:value-of select=\"name(.)\"/>' with subject '<xsl:value-of select=\"$subj-name\"/>' has both rdf:resource and rdf:datatype</xsl:message>\n"
"      </xsl:if>\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3O=\"{resolve-uri (string ($base), @rdf:resource)}\">\n"
"        <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"        <xsl:copy-of select=\"$lang\"/>\n"
"      </N3>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:datatype\">\n"
"      <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3DT=\"{resolve-uri (string ($base), @rdf:datatype)}\">\n"
"        <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"        <xsl:copy-of select=\"$lang\"/>\n"
"        <xsl:copy-of select=\"node()\"/>\n"
"      </N3>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"exists(*)\">\n"
"      <xsl:for-each select=\"*\">\n"
"        <xsl:variable name=\"obj-name\"><xsl:call-template name=\"expand-subj-name\"/></xsl:variable>\n"
"        <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3O=\"{$obj-name}\">\n"
"          <xsl:copy-of select=\"$lang\"/>\n"
"        </N3>\n"
"        <xsl:apply-templates select=\".\" mode=\"descrlist\"><xsl:with-param name=\"subj-name\" select=\"$obj-name\"/></xsl:apply-templates>\n"
"      </xsl:for-each>\n"
"    </xsl:when>\n"
"    <xsl:otherwise>\n"
"      <xsl:variable name=\"obj-attrs\" select=\"@*[not self::xml:*][not self::rdf:ID][not self::rdf:type]\"/>\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"empty ($obj-attrs)\">\n"
"          <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\">\n"
"           <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"          <xsl:copy-of select=\"$lang\"/>\n"
"          <xsl:copy-of select=\"node()\"/>\n"
"          </N3>\n"
"          <xsl:for-each select=\"@rdf:type\">\n"
"            <!--TODO: carefully check composing of N3O here. -->\n"
"            <N3 N3S=\"{$obj-name}\" N3P=\"{resolve-uri ($rdf-uri, 'type')}\" N3O=\"{resolve-uri (string ($base), .)}\"><xsl:copy-of select=\"$lang\"/></N3>\n"
"          </xsl:for-each>\n"
"        </xsl:when>\n"
"        <xsl:otherwise>\n"
"          <xsl:variable name=\"obj-name\"><xsl:call-template name=\"expand-subj-name\"/></xsl:variable>\n"
"          <N3 N3S=\"{$subj-name}\" N3P=\"{$p-name}\" N3O=\"{$obj-name}\">\n"
"            <xsl:if test=\"$p-id\"><xsl:attribute name=\"N3ID\"><xsl:value-of select=\"$p-id\"/></xsl:attribute></xsl:if>\n"
"            <xsl:copy-of select=\"$lang\"/>\n"
"          </N3>\n"
"          <xsl:if test=\"exists(node())\">\n"
"            <xsl:message terminate=\"yes\">Predicate '<xsl:value-of select=\"name(.)\"/>' has both children and property attributes</xsl:message>\n"
"          </xsl:if>\n"
"          <xsl:for-each select=\"@*[not self::xml:*][not self::rdf:about][not self::rdf:nodeID][not self::rdf:ID][not self::rdf:type]\">\n"
"            <N3 N3S=\"{$obj-name}\" N3P=\"{resolve-uri (namespace-uri(.), local-name(.))}\"><xsl:copy-of select=\"$lang\"/><xsl:value-of select=\".\"/></N3>\n"
"          </xsl:for-each>\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"    </xsl:otherwise>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"\n"
"<xsl:template name=\"expand-subj-name\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"1 != count(@rdf:nodeID|@rdf:ID|@rdf:about)\">\n"
"      <xsl:choose>\n"
"        <xsl:when test=\"@rdf:nodeID|@rdf:ID|@rdf:about\">\n"
"          <xsl:message terminate=\"yes\">Element <xsl:value-of select=\"name()\"/> should have no more than one subject name attribute: rdf:about, rdf:nodeID, rdf:ID attributes</xsl:message>\n"
"        </xsl:when>\n"
"        <xsl:otherwise>\n"
"          <xsl:call-template name=\"compose-nodeID\"/>\n"
"        </xsl:otherwise>\n"
"      </xsl:choose>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:about\">\n"
"      <xsl:variable name=\"base\">\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"          <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:variable>\n"
"     <xsl:value-of select=\"resolve-uri(string ($base), @rdf:about)\"/>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:nodeID\">\n"
"      <xsl:value-of select=\"concat('nodeID://U', @rdf:nodeID)\"/>\n"
"    </xsl:when>\n"
"    <xsl:when test=\"@rdf:ID\">\n"
"      <xsl:variable name=\"base\">\n"
"        <xsl:choose>\n"
"          <xsl:when test=\"exists (ancestor-or-self::*/@xml:base)\"><xsl:value-of select=\"ancestor-or-self::*/@xml:base\"/></xsl:when>\n"
"          <xsl:otherwise><xsl:value-of select=\"document-get-uri(.)\"/></xsl:otherwise>\n"
"        </xsl:choose>\n"
"      </xsl:variable>\n"
"     <xsl:value-of select=\"resolve-uri(string ($base), concat('#', @rdf:ID))\"/>\n"
"    </xsl:when>\n"
"  </xsl:choose>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"compose-nodeID\">\n"
"  <xsl:variable name=\"srcline\" select=\"xpath-debug-srcline(.)\"/>\n"
"  <xsl:variable name=\"loc-strg\">\n"
"    <xsl:for-each select=\"ancestor-or-self::*[xpath-debug-srcline(.) = $srcline]/preceding-sibling::*[xpath-debug-srcline(.) = $srcline]\">\n"
"      <xsl:value-of select=\"serialize (.)\"/>\n"
"    </xsl:for-each>\n"
"  </xsl:variable>\n"
"  <xsl:value-of select=\"concat ('nodeID://R', $srcline, 'N', string-length ($loc-strg))\"/>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* n3xml2uriqahtml.xsl */

static const char *xsl10[]= {
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<!--\n"
" -\n"
" -  $Id: n3xml2uriqahtml.xsl,v 1.1 2007/03/26 14:47:01 source Exp $\n"
" -\n"
" -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)\n"
" -  project.\n"
" -\n"
" -  Copyright (C) 1998-2006 OpenLink Software\n"
" -\n"
" -  This project is free software; you can redistribute it and/or modify it\n"
" -  under the terms of the GNU General Public License as published by the\n"
" -  Free Software Foundation; only version 2 of the License, dated June 1991.\n"
" -\n"
" -  This program is distributed in the hope that it will be useful, but\n"
" -  WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n"
" -  General Public License for more details.\n"
" -\n"
" -  You should have received a copy of the GNU General Public License along\n"
" -  with this program; if not, write to the Free Software Foundation, Inc.,\n"
" -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
" -\n"
"-->\n"
"<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\" xmlns:virt=\"virt\" xmlns:virtrdf=\"http://local.virt/rdf/\">\n"
"<xsl:output method=\"html\" />\n"
"\n"
"<xsl:param name=\"main-uri\">http://local.virt/this</xsl:param>\n"
"<xsl:param name=\"rdf-uri\" select=\"'http://www.w3.org/1999/02/22-rdf-syntax-ns#'\"/>\n"
"\n"
"<xsl:template match=\"/\">\n"
"<html><head><title>Metadata about <xsl:value-of select=\"$main-uri\"/></title></head>\n"
"<body>\n"
"<h3>Data about <xsl:value-of select=\"$main-uri\"/> subject</h3>\n"
"<xsl:apply-templates mode=\"N3\" select=\"/N3[@N3S=$main-uri]\"><xsl:with-param name=\"hide-s\" select=\"1\"/></xsl:apply-templates>\n"
"<h3>Data about subjects that refer to <xsl:value-of select=\"$main-uri\"/> as to objects</h3>\n"
"<xsl:apply-templates mode=\"N3\" select=\"/N3[@N3O=$main-uri][@N3S!=$main-uri]\"><xsl:with-param name=\"hide-o\" select=\"1\"/></xsl:apply-templates>\n"
"<h3>Data about relations with <xsl:value-of select=\"$main-uri\"/> predicate</h3>\n"
"<xsl:apply-templates mode=\"N3\" select=\"/N3[@N3P=$main-uri][@N3S!=$main-uri][@N3O!=$main-uri]\"><xsl:with-param name=\"hide-p\" select=\"1\"/></xsl:apply-templates>\n"
"<h3>Other data</h3>\n"
"<xsl:apply-templates mode=\"N3\" select=\"/N3[@N3S!=$main-uri][@N3O!=$main-uri][@N3P!=$main-uri]\"></xsl:apply-templates>\n"
"</body>\n"
"</html>\n"
"</xsl:template>\n"
"\n"
"<xsl:template mode=\"N3\" match=\"node()\">\n"
"  <xsl:param name=\"hide-s\"/>\n"
"  <xsl:param name=\"hide-p\"/>\n"
"  <xsl:param name=\"hide-o\"/>\n"
"[\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"$hide-s\">(S)</xsl:when>\n"
"    <xsl:otherwise><xsl:call-template name=\"uri\"><xsl:with-param name=\"uri\" select=\"@N3S\"/></xsl:call-template></xsl:otherwise>\n"
"  </xsl:choose>\n"
",\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"$hide-p\">(P)</xsl:when>\n"
"    <xsl:otherwise><xsl:call-template name=\"uri\"><xsl:with-param name=\"uri\" select=\"@N3P\"/></xsl:call-template></xsl:otherwise>\n"
"  </xsl:choose>\n"
",\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"not exists (@N3O)\"><xsl:call-template name=\"value\"/></xsl:when>\n"
"    <xsl:when test=\"$hide-o\">(O)</xsl:when>\n"
"    <xsl:otherwise><xsl:call-template name=\"uri\"><xsl:with-param name=\"uri\" select=\"@N3O\"/></xsl:call-template></xsl:otherwise>\n"
"  </xsl:choose>\n"
"]\n"
"  <br/>\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"uri\">\n"
"  <xsl:choose>\n"
"    <xsl:when test=\"starts-with ($uri, concat ($main-uri, '#'))\"><a href=\"{$uri}\"><xsl:value-of select=\"substring ($uri, string-length ($main-uri) + 1)\"/></a></xsl:when>\n"
"    <xsl:when test=\"starts-with ($uri, 'http:')\"><a href=\"{$uri}\"><xsl:value-of select=\"$uri\"/></a></xsl:when>\n"
"    <xsl:otherwise><xsl:value-of select=\"$uri\"/></xsl:otherwise>\n"
"  </xsl:choose>\n"
"  (<a href=\"/uriqa/?uri={urlify($uri)}&amp;format=text/html\">meta</a>)\n"
"</xsl:template>\n"
"\n"
"<xsl:template name=\"value\">\n"
"<xsl:value-of select=\".\"/>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
"\n"
,
 NULL };

/* uriqa.sql */

static const char *tbl0 = 
"create table WS.WS.URIQA_HANDLER\n"
"(\n"
"UH_ID integer not null primary key,\n"
"UH_ORDER integer not null,\n"
"UH_NAME varchar not null unique,\n"
"UH_MATCH_COND varchar not null,\n"
"UH_MATCH_ENV any,\n"
"UH_HANDLER varchar not null,\n"
"UH_HANDLER_ENV any\n"
")\n"
"create index URIQA_HANDLER_ORDER_NAME on WS.WS.URIQA_HANDLER (UH_ORDER, UH_NAME)\n";

static const char *proc339 = 
"create function WS.WS.URIQA_CFG_ITEM_VALUE (in param_name varchar, in is_list integer, in dflt_value varchar)\n"
"{\n"
"declare ini_path varchar;\n"
"declare string_val varchar;\n"
"declare list_val any;\n"
"ini_path := virtuoso_ini_path ();\n"
"string_val := cfg_item_value (ini_path, \'URIQA\', param_name);\n"
"if (string_val is not null)\n"
"{\n"
"if (is_list)\n"
"{\n"
"declare ctr, len integer;\n"
"list_val := split_and_decode (string_val, 0, \'\\0\\0,\');\n"
"len := length (list_val);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"{\n"
"list_val[ctr] := trim (list_val[ctr]);\n"
"}\n"
"string_val := serialize (list_val);\n"
"}\n"
"if (string_val <> cast (registry_get (\'URIQA\' || param_name) as varchar))\n"
"registry_set (\'URIQA\' || param_name, string_val);\n"
"if (is_list)\n"
"return list_val;\n"
"return string_val;\n"
"}\n"
"string_val := registry_get (\'URIQA\' || param_name);\n"
"if (not isstring (string_val))\n"
"{\n"
"if (dflt_value is null)\n"
"return null;\n"
"registry_set (\'URIQA\' || param_name, dflt_value);\n"
"return dflt_value;\n"
"}\n"
"if (is_list)\n"
"return deserialize (string_val);\n"
"return string_val;\n"
"}\n"
"--src uriqa.sql:43\n";

static const char *proc340 = 
"create procedure WS.WS.URIQA_LOAD_FROM_INI ()\n"
"{\n"
"declare default_host, local_host_names, local_host_masks, our_fingerprint varchar;\n"
"declare ctr integer;\n"
"default_host		:= WS.WS.URIQA_CFG_ITEM_VALUE (\'DefaultHost\'	, 0	, \'localuriqaserver\'	);\n"
"local_host_names	:= WS.WS.URIQA_CFG_ITEM_VALUE (\'LocalHostNames\'	, 1	, null			);\n"
"local_host_masks	:= WS.WS.URIQA_CFG_ITEM_VALUE (\'LocalHostMasks\'	, 1	, null			);\n"
"our_fingerprint		:= WS.WS.URIQA_CFG_ITEM_VALUE (\'Fingerprint\'	, 0	, uuid()		);\n"
"if (local_host_names is null or length (local_host_names) = 0)\n"
"delete from WS.WS.URIQA_HANDLER where UH_ID=1;\n"
"else\n"
"{\n"
"insert soft WS.WS.URIQA_HANDLER\n"
"( UH_ID	, UH_ORDER	, UH_NAME			, UH_MATCH_COND	, UH_MATCH_ENV		, UH_HANDLER	, UH_HANDLER_ENV	)\n"
"values\n"
"( 1	, 100		, \'virt:LocalHostNames\'		, \'server in\'	, vector ()		, \'LOCALDAV\'	, null			);\n"
"update WS.WS.URIQA_HANDLER set\n"
"UH_NAME = \'virt:LocalHostNames\',\n"
"UH_MATCH_COND = \'server in\',\n"
"UH_MATCH_ENV = local_host_names\n"
"where UH_ID = 1 and (\n"
"(UH_NAME <> \'virt:LocalHostNames\') or\n"
"(UH_MATCH_COND <> \'server in\') or\n"
"serialize (UH_MATCH_ENV) <> serialize (local_host_names) );\n"
"}\n"
"if (local_host_masks is null or length (local_host_masks) = 0)\n"
"delete from WS.WS.URIQA_HANDLER where UH_ID=2;\n"
"else\n"
"{\n"
"insert soft WS.WS.URIQA_HANDLER\n"
"( UH_ID	, UH_ORDER	, UH_NAME			, UH_MATCH_COND	, UH_MATCH_ENV		, UH_HANDLER	, UH_HANDLER_ENV	)\n"
"values\n"
"( 2	, 100		, \'virt:LocalHostMasks\'		, \'server like in\'	, vector ()	, \'LOCALDAV\'	, null			);\n"
"update WS.WS.URIQA_HANDLER set\n"
"UH_NAME = \'virt:LocalHostMasks\',\n"
"UH_MATCH_COND = \'server like in\',\n"
"UH_MATCH_ENV = local_host_masks\n"
"where UH_ID = 2 and (\n"
"(UH_NAME <> \'virt:LocalHostMasks\') or\n"
"(UH_MATCH_COND <> \'server like in\') or\n"
"serialize (UH_MATCH_ENV) <> serialize (local_host_masks) );\n"
"}\n"
"insert soft WS.WS.URIQA_HANDLER\n"
"( UH_ID	, UH_ORDER	, UH_NAME		, UH_MATCH_COND	, UH_MATCH_ENV			, UH_HANDLER	, UH_HANDLER_ENV	)\n"
"values\n"
"( 100	, 999		, \'redir\'		, \'schema =\'	, \'http\'			, \'NATIVE_HTTP\'	, null			);\n"
"}\n"
"--src uriqa.sql:83\n";

static const char *other9 = 
"WS.WS.URIQA_LOAD_FROM_INI ()\n";
static const char *proc341 = 
"create function WS.WS.URIQA_FULL_URI (inout path varchar, inout params varchar, inout lines varchar, in parse_params integer, in trim_prefix integer) returns varchar\n"
"{\n"
"declare explicit_uri, host, head_uri, res varchar;\n"
"declare pairs any;\n"
"\n"
"explicit_uri := http_request_header (lines, \'URIQA-uri\');\n"
"if (isstring (explicit_uri))\n"
"return explicit_uri;\n"
"if (parse_params)\n"
"{\n"
"res := get_keyword (\'uri\', params);\n"
"if (res is not null)\n"
"goto complete;\n"
"}\n"
"\n"
"pairs := regexp_parse (\'^([A-Za-z]+)([ \\\\t]+)([^ \\\\t\\\\r\\\\n]+)(([ \\\\t]+)HTTP([^ \\\\t\\\\r\\\\n]+))?[ \\\\t\\\\r\\\\n]*\\044\', lines[0], 0);\n"
"if (pairs is null)\n"
"{\n"
"\n"
"res := NULL;\n"
"goto complete;\n"
"}\n"
"head_uri := split_and_decode (subseq (lines[0], pairs[6], pairs[7]), 0, \'%+\');\n"
"if (trim_prefix and upper (head_uri) like \'/URIQA/%\')\n"
"head_uri := subseq (head_uri, 6);\n"
"\n"
"host := http_request_header (lines, \'Host\');\n"
"if (isstring (host))\n"
"res := WS.WS.EXPAND_URL (concat (\'http://\', host, \'/\'), head_uri);\n"
"else\n"
"res := head_uri;\n"
"\n"
"complete:\n"
"\n"
"return res;\n"
"}\n"
"--src uriqa.sql:135\n";

static const char *proc342 = 
"create function WS.WS.URIQA_APPLY_TRIGGERS (in op varchar, inout uri varchar, inout body any, inout params varchar, inout lines varchar) returns any\n"
"{\n"
"declare split, err_ret any;\n"
"split := rfc1808_parse_uri (uri);\n"
"\n"
"declare is_final integer;\n"
"is_final := 0;\n"
"for (select UH_MATCH_COND, UH_MATCH_ENV, UH_HANDLER, UH_HANDLER_ENV from WS.WS.URIQA_HANDLER) do\n"
"{\n"
"if (UH_MATCH_COND = \'schema =\')\n"
"{\n"
"if (split[0] = UH_MATCH_ENV)\n"
"goto match;\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'server =\')\n"
"{\n"
"if (split[1] = UH_MATCH_ENV)\n"
"goto match;\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'server like\')\n"
"{\n"
"if (split[1] like UH_MATCH_ENV)\n"
"goto match;\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'server in\')\n"
"{\n"
"if (position (split[1], UH_MATCH_ENV))\n"
"goto match;\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'server like in\')\n"
"{\n"
"foreach (varchar srv_mask in UH_MATCH_ENV) do\n"
"{\n"
"if (split[1] like srv_mask)\n"
"goto match;\n"
"}\n"
"goto no_match;\n"
"}\n"
"if (UH_MATCH_COND = \'default\')\n"
"{\n"
"goto match;\n"
"}\n"
"return vector (\'URIQA\', 0, \'500\', sprintf (\'Configuration error: unknown UH_MATCH_COND \"%s\" in WS.WS.URIQA_HANDLER\', UH_MATCH_COND));\n"
"match:\n"
"err_ret := call (\'WS.WS.URIQA_HANDLER_\' || UH_HANDLER)(op, uri, split, body, params, lines, UH_HANDLER_ENV, is_final);\n"
"if (is_final)\n"
"return err_ret;\n"
"no_match:\n"
" ;\n"
"}\n"
"return vector (\'URIQA\', 0, \'404\', sprintf (\'URIQA server has no way to access resource \"%s\"\', uri));\n"
"}\n"
"--src uriqa.sql:173\n";

static const char *proc343 = 
"create function WS.WS.URIQA_N3_DIR_LIST (inout split any, in a_uid integer)\n"
"{\n"
"declare diritems any;\n"
"declare acc any;\n"
"declare ctr, len integer;\n"
"declare s_path, s_uri varchar;\n"
"s_path := split[2];\n"
"diritems := DAV_DIR_LIST_INT (s_path, 0, \'%\', null, null, a_uid);\n"
"if (DAV_HIDE_ERROR (diritems) is null)\n"
"return null;\n"
"xte_nodebld_init (acc);\n"
"len := length (diritems);\n"
"s_uri := concat (split[0], \'://\', split[1], s_path);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"{\n"
"declare o_uri varchar;\n"
"if (\'R\' = diritems[ctr][1])\n"
"o_uri := concat (s_uri, diritems[ctr][10]);\n"
"else\n"
"o_uri := concat (s_uri, diritems[ctr][10], \'/\');\n"
"xte_nodebld_acc (acc, xte_node (xte_head (\'N3\', \'N3S\', s_uri, \'N3P\', UNAME\'http://www.openlinksw.com/schemas/virtdav#contains\', \'N3O\', o_uri)));\n"
"}\n"
"if (length (s_path) > 1)\n"
"{\n"
"declare p_path, p_uri varchar;\n"
"declare rslash integer;\n"
"p_path := \"LEFT\" (s_path, length (s_path) - 1);\n"
"rslash := strrchr (p_path, \'/\');\n"
"p_path := \"LEFT\" (s_path, rslash+1);\n"
"p_uri := concat (split[0], \'://\', split[1], p_path);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (\'N3\', \'N3S\', p_uri, \'N3P\', UNAME\'http://www.openlinksw.com/schemas/virtdav#contains\', \'N3O\', s_uri)));\n"
"}\n"
"xte_nodebld_final (acc, xte_head (UNAME\' root\'));\n"
"return xml_tree_doc (acc);\n"
"}\n"
"--src uriqa.sql:231\n";

static const char *proc344 = 
"create function DB.DBA.\"DAV_EXTRACT_DYN_RDF_application/xbel+xml\" (in id any, inout split any, inout old_prop any, in a_uid integer) returns any\n"
"{\n"
"declare ses, tree, label, roots any;\n"
"declare cont_type, res_uri, root_uri, sub_uri varchar;\n"
"declare rc integer;\n"
"declare acc any;\n"
"\n"
"ses := string_output ();\n"
"rc := DAV_RES_CONTENT_INT (id, ses, cont_type, 1, 0);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return null;\n"
"tree := xtree_doc (ses, 0);\n"
"\n"
"res_uri := sprintf (\'%s://%s%s\', split[0], split[1], split[2]);\n"
"xte_nodebld_init (acc);\n"
"if (length (split[5]) > 0)\n"
"{\n"
"label := split_and_decode (split[5], 0, \'%+\');\n"
"root_uri := sprintf (\'%s#%U\', res_uri, label);\n"
"roots := xpath_eval (\'/xbel//*[self::folder|self::bookmark][substring (concat (@id, \"-\", title), 1, 40) = \\044label]\', tree, 0, vector (\'label\', label));\n"
"if (roots is not null)\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.openlinksw.com/virtdav#storedIn\', UNAME\'N3O\', res_uri)));\n"
"}\n"
"else\n"
"{\n"
"label := \'\';\n"
"root_uri := res_uri;\n"
"roots := xpath_eval (\'/xbel\', tree, 0);\n"
"}\n"
"foreach (any root in roots) do\n"
"{\n"
"declare rdftype, title, root_id, descr, href, parent varchar;\n"
"declare children any;\n"
"rdftype := \'http://www.python.org/topics/xml/xbel/\' || xpath_eval (\'local-name(.)\', root);\n"
"\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\', UNAME\'N3O\', rdftype)));\n"
"if (rdftype <> \'http://www.python.org/topics/xml/xbel/xbel\')\n"
"{\n"
"title := xpath_eval (\'string (title)\', root);\n"
"if (title <> \'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/title\'), title));\n"
"descr := xpath_eval (\'string (description)\', root);\n"
"if (descr <> \'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/description\'), descr));\n"
"root_id := xpath_eval (\'@id\', root);\n"
"if (root_id <> \'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/id\'), root_id));\n"
"href := xpath_eval (\'@href\', root);\n"
"if (href <> \'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/id\', UNAME\'N3O\', href)));\n"
"parent := xpath_eval (\'substring (concat (../@id, \"-\", ../title), 1, 40)\', root);\n"
"if (parent <> \'\')\n"
"{\n"
"parent := sprintf (\'%s#%U\', res_uri, parent);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', \'http://www.openlinksw.com/virtdav#parentFragment\', UNAME\'N3O\', parent)));\n"
"}\n"
"}\n"
"children := xpath_eval (\'folder|bookmark\', root, 0);\n"
"foreach (any child in children) do\n"
"{\n"
"declare c_uri varchar;\n"
"declare c_rdftype, c_title, c_id, c_href nvarchar;\n"
"c_uri := xpath_eval (\'substring (concat (@id, \"-\", title), 1, 40)\', child);\n"
"if (c_uri <> \'-\')\n"
"{\n"
"c_uri := sprintf (\'%s#%U\', res_uri, c_uri);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.openlinksw.com/virtdav#parentFragment\', UNAME\'N3O\', root_uri)));\n"
"c_rdftype := \'http://www.python.org/topics/xml/xbel/\' || xpath_eval (\'local-name(.)\', child);\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\', UNAME\'N3O\', c_rdftype)));\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', root_uri, UNAME\'N3P\', c_rdftype, UNAME\'N3O\', c_uri)));\n"
"c_title := xpath_eval (\'string(title)\', child);\n"
"if (c_title <> N\'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/title\'), c_title));\n"
"c_id := xpath_eval (\'@id\', child);\n"
"if (c_id <> N\'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/id\'), c_id));\n"
"c_href := xpath_eval (\'@href\', child);\n"
"if (c_href <> N\'\')\n"
"xte_nodebld_acc (acc, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', c_uri, UNAME\'N3P\', \'http://www.python.org/topics/xml/xbel/href\', UNAME\'N3O\', c_href)));\n"
"}\n"
"}\n"
"}\n"
"xte_nodebld_final (acc, xte_head (UNAME\' root\'));\n"
"acc := xml_tree_doc (acc);\n"
"\n"
"return acc;\n"
"\n"
"}\n"
"--src uriqa.sql:268\n";

static const char *proc345 = 
"create function WS.WS.URIQA_HANDLER_LOCALDAV (inout op varchar, inout uri varchar, inout split any, inout body any, inout params varchar, inout lines varchar, inout app_env any, inout is_final integer) returns any\n"
"{\n"
"declare id, old_prop, old_descr, rc any;\n"
"declare uid, a_uid, a_gid integer;\n"
"declare st, a_uname, a_pwd, a_perms, res_path varchar;\n"
"\n"
"old_descr := null;\n"
"res_path := split[2];\n"
"is_final := 1;\n"
"if (res_path = \'\')\n"
"{\n"
"return vector (\'URIQA\', -1, \'404\', \'Invalid URI; Ill formed or missing path to the resource\');\n"
"}\n"
"if ((split[3] <> \'\') or (split[4] <> \'\'))\n"
"{\n"
"return vector (\'URIQA\', -1, \'404\', \'Invalid URI; Virtuoso DAV does not support URIs that contain parameters\');\n"
"}\n"
"if ((split[5] <> \'\') and (\'MGET\' <> op))\n"
"return vector (\'URIQA\', -1, \'500\', \'Virtuoso DAV does not support MPUT and MDELETE on subject URIs that have fragment\');\n"
"if (\"RIGHT\"(res_path, 1) = \'/\')\n"
"st := \'C\';\n"
"else\n"
"st := \'R\';\n"
"id := DAV_SEARCH_ID (res_path, st);\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"if ((id = -1) and (st = \'R\') and (split[5] = \'\'))\n"
"{\n"
"declare id_try2 any;\n"
"id_try2 := DAV_SEARCH_ID (res_path || \'/\', \'C\');\n"
"if (DAV_HIDE_ERROR (id_try2) is not null)\n"
"{\n"
"id := id_try2;\n"
"st := \'C\';\n"
"res_path := res_path || \'/\';\n"
"split[2] := res_path;\n"
"uri := uri || \'/\';\n"
"goto id_found;\n"
"}\n"
"}\n"
"if ((id = -1) and (\'MGET\' = op))\n"
"{\n"
"declare dct any;\n"
"dct := ((sparql define output:valmode \"LONG\" describe `iri(?:uri)`));\n"
"if (dict_size (dct) > 0)\n"
"{\n"
"old_descr := dct;\n"
"dct := 0;\n"
"goto do_op;\n"
"}\n"
"}\n"
"return vector (\'URIQA\', id, NULL, DAV_PERROR (id) || sprintf (\'; path \"%s\"\', res_path));\n"
"}\n"
"id_found:\n"
"a_uid := null;\n"
"a_gid := null;\n"
"uid := DAV_AUTHENTICATE_HTTP (id, st, case (op) when \'MGET\' then \'1__\' else \'11_\' end, 1, lines, a_uname, a_pwd, a_uid, a_gid, a_perms);\n"
"if (DAV_HIDE_ERROR (uid) is null)\n"
"return vector (\'URIQA\', id, NULL, NULL);\n"
"old_prop := DAV_PROP_GET_INT (id, st, \'http://local.virt/DAV-RDF\', 0);\n"
"if (DAV_HIDE_ERROR (old_prop) is null)\n"
"{\n"
"if (-11 <> old_prop)\n"
"return vector (\'URIQA\', old_prop, NULL, NULL);\n"
"else\n"
"old_prop := xml_tree_doc (xte_node (xte_head (UNAME\' root\')));\n"
"}\n"
"else\n"
"{\n"
"declare dyn_n3 any;\n"
"declare container_type varchar;\n"
"old_prop := xml_tree_doc (deserialize (blob_to_string (old_prop)));\n"
"container_type := xpath_eval (\'[xmlns:v=\"virt\"] /v:rdf/v:top-res[name(*[1])=\"http://local.virt/this\"]/v:prop[name(*[1])=\"http://www.openlinksw.com/virtdav#dynRdfExtractor\"]/v:value\', old_prop);\n"
"if (container_type is not null)\n"
"{\n"
"container_type := cast (container_type as varchar);\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\n"
"goto dyn_n3_set;\n"
"};\n"
"dyn_n3 := call (\'DB.DBA.DAV_EXTRACT_DYN_RDF_\' || container_type)(id, split, old_prop, a_uid);\n"
"XMLAppendChildren (old_prop, dyn_n3);\n"
"dyn_n3_set: ;\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
" ;\n"
"}\n"
"}\n"
"do_op:\n"
"if (\'MGET\' = op)\n"
"{\n"
"declare fmt varchar;\n"
"if (old_descr is null)\n"
"{\n"
"declare dct any;\n"
"dct := ((sparql define output:valmode \"LONG\" describe `iri(?:uri)`));\n"
"if (dict_size (dct) > 0)\n"
"{\n"
"old_descr := dct;\n"
"dct := 0;\n"
"}\n"
"}\n"
"if (old_descr is not null)\n"
"{\n"
"declare dct_triples, descr_n3 any;\n"
"declare dct_ctr, dct_len integer;\n"
"dct_triples := dict_list_keys (old_descr, 1);\n"
"dct_len := length (dct_triples);\n"
"xte_nodebld_init (descr_n3);\n"
"for (dct_ctr := 0; dct_ctr < dct_len; dct_ctr := dct_ctr + 1)\n"
"{\n"
"declare tr, s, p any;\n"
"tr := dct_triples[dct_ctr];\n"
"s := id_to_iri (tr[0]);\n"
"p := id_to_iri (tr[1]);\n"
"if (isiri_id (tr[2]))\n"
"xte_nodebld_acc (descr_n3, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', s, UNAME\'N3P\', p, UNAME\'N3O\', id_to_iri (tr[2]))));\n"
"else\n"
"xte_nodebld_acc (descr_n3, xte_node (xte_head (UNAME\'N3\', UNAME\'N3S\', s, UNAME\'N3P\', p), DB.DBA.RDF_STRSQLVAL_OF_LONG (tr[2])));\n"
"}\n"
"xte_nodebld_final (descr_n3, xte_head (UNAME\' root\'));\n"
"if (isentity (old_prop))\n"
"{\n"
"descr_n3 := xml_tree_doc (descr_n3);\n"
"XMLAppendChildren (old_prop, descr_n3);\n"
"}\n"
"else\n"
"old_prop := xml_tree_doc (descr_n3);\n"
"}\n"
"fmt := get_keyword (\'format\', params, \'application/rdf+xml\');\n"
"if (\'C\' = st)\n"
"XMLAppendChildren (old_prop, WS.WS.URIQA_N3_DIR_LIST (split, a_uid));\n"
"if ((fmt = \'application/rdf+xml\') or (fmt = \'text/xml\'))\n"
"{\n"
"http_value (xslt (\'http://local.virt/davxml2rdfxml\', old_prop, vector (\'this-real-uri\', uri)));\n"
"http_header (http_header_get () || \'Content-Type: \' || fmt || \'\\r\\n\');\n"
"}\n"
"else if (fmt = \'text/html\')\n"
"{\n"
"declare n3, html any;\n"
"n3 := xslt (\'http://local.virt/davxml2n3xml\', old_prop, vector (\'this-real-uri\', uri));\n"
"html := xslt (\'http://local.virt/n3xml2uriqahtml\', n3, vector (\'main-uri\', uri));\n"
"http_value (html);\n"
"}\n"
"else\n"
"return vector (\'URIQA\', -1, \'500\', \'Invalid GET: Virtuoso DAV support only \"application/rdf+xml\", \"text/xml\" and \"text/html\" values for \"format\"\');\n"
"is_final := 1;\n"
"return vector (\'00000\', 0, \'200\', \'OK\');\n"
"}\n"
"if (\'MPUT\' = op)\n"
"{\n"
"declare old_n3, addon_n3 any;\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', old_prop);\n"
"\n"
"addon_n3 := xslt (\'http://local.virt/rdfxml2n3xml\', xtree_doc (body, 0));\n"
"if (addon_n3 is null)\n"
"return vector (\'URIQA\', 0, \'500\', \'Invalid MPUT: The request body contain no RDF triplets\');\n"
"if (xquery_eval (\'exists (/N3[@N3P=\"http://www.openlinksw.com/schemas/virtdav#contains\"])\', addon_n3))\n"
"return vector (\'URIQA\', 0, \'500\', \'Invalid MPUT: The request body contain triplets with read-only system predicate http://www.openlinksw.com/schemas/virtdav#contains\');\n"
"old_n3 := DAV_RDF_MERGE (old_n3, addon_n3, null, 0);\n"
"rc := DAV_PROP_SET_INT (res_path, \'http://local.virt/DAV-RDF\',\n"
"serialize (DAV_RDF_PREPROCESS_RDFXML (old_n3, N\'http://local.virt/this\', 1)),\n"
"null, null, 0, 1, 1 );\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return vector (\'URIQA\', \'400\', DAV_PERROR (rc));\n"
"is_final := 1;\n"
"return vector (\'00000\', 0, \'200\', \'OK\');\n"
"}\n"
"if (\'MDELETE\' = op)\n"
"{\n"
"declare old_n3, sub_n3 any;\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', old_prop);\n"
"\n"
"if (not xpath_eval (\'exists(/N3)\', old_n3))\n"
"goto mdelete_ok;\n"
"if (length (body) > 0)\n"
"{\n"
"sub_n3 := xslt (\'http://local.virt/rdfxml2n3xml\', xtree_doc (body, 0));\n"
"if (sub_n3 is null)\n"
"{\n"
"return vector (\'URIQA\', 0, \'500\', \'Invalid MDELETE: The request body is not empty but contain no RDF triplets\');\n"
"}\n"
"else\n"
"old_n3 := DAV_RDF_SUBTRACT (old_n3, sub_n3);\n"
"rc := DAV_PROP_SET_INT (res_path, \'http://local.virt/DAV-RDF\',\n"
"serialize (DAV_RDF_PREPROCESS_RDFXML (old_n3, N\'http://local.virt/this\', 1)),\n"
"null, null, 0, 1, 1 );\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return vector (\'URIQA\', \'400\', DAV_PERROR (rc));\n"
"}\n"
"else\n"
"{\n"
"rc := DAV_PROP_REMOVE_INT (res_path, \'http://local.virt/DAV-RDF\',\n"
"null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return vector (\'URIQA\', \'400\', DAV_PERROR (rc));\n"
"}\n"
"mdelete_ok:\n"
"is_final := 1;\n"
"return vector (\'00000\', 0, \'200\', \'OK\');\n"
"}\n"
"is_final := 1;\n"
"return vector (\'URIQA\', 0, \'500\', sprintf (\'Virtuoso DAV does not support URIQA operation \"%s\"\', op));\n"
"}\n"
"--src uriqa.sql:358\n";

static const char *proc346 = 
"create function WS.WS.URIQA_HANDLER_NATIVE_HTTP (inout op varchar, inout uri varchar, inout split any, inout body any, inout params varchar, inout lines varchar, inout app_env any, inout is_final integer) returns any\n"
"{\n"
"declare req_uri, req_header, resp_page, resp_header any;\n"
"declare param_ctr, param_count, line_ctr, line_count, our_fingerprint_ctr integer;\n"
"declare our_fingerprint varchar;\n"
"\n"
"our_fingerprint := \'Fingerprint\' || registry_get (\'URIQAFingerprint\');\n"
"req_uri := string_output ();\n"
"http (sprintf (\'%s://%s/uriqa/?uri=%U&method=%U&\', split[0], split[1], uri, op), req_uri);\n"
"param_count := length (params);\n"
"our_fingerprint_ctr := 0;\n"
"for (param_ctr := 1; param_ctr < param_count; param_ctr := param_ctr + 2)\n"
"{\n"
"declare pname, pvalue varchar;\n"
"pname := params[param_ctr-1];\n"
"pvalue := params[param_ctr];\n"
"if (pname = our_fingerprint)\n"
"our_fingerprint_ctr := our_fingerprint_ctr + 1;\n"
"if ((pname <> \'uri\') and (pname <> \'method\') and (pname <> \'Content\'))\n"
"{\n"
"if (isstring (pvalue))\n"
"http (sprintf (\'&%U=%U\', pname, pvalue), req_uri);\n"
"else\n"
"http (sprintf (\'&%U\', pname), req_uri);\n"
"}\n"
"}\n"
"if (our_fingerprint_ctr > 1)\n"
"{\n"
"is_final := 1;\n"
"return vector (\'URIQA\', 0, \'500\', \'Virtuoso tries to recursively access itself via HTTP to get metadata via URIQA (wrong config?)\');\n"
"}\n"
"http (sprintf (\'&%U=%U\', our_fingerprint, registry_get (\'URIQADefaultHost\')), req_uri);\n"
"req_uri := string_output_string (req_uri);\n"
"req_header := string_output ();\n"
"line_count := length (lines);\n"
"for (line_ctr := 1; line_ctr < line_count; line_ctr := line_ctr + 1)\n"
"{\n"
"declare line varchar;\n"
"line := trim (lines [line_ctr], concat (chr (13), chr(10)));\n"
"if (line_ctr > 1)\n"
"http (concat (chr (13), chr(10)), req_header);\n"
"http (line, req_header);\n"
"}\n"
"req_header := string_output_string (req_header);\n"
"\n"
"if (body is null)\n"
"resp_page := http_get (req_uri, resp_header, \'POST\', req_header, \'\');\n"
"else\n"
"resp_page := http_get (req_uri, resp_header, \'POST\', req_header, string_output_string (body));\n"
"\n"
"\n"
"http (resp_page);\n"
"is_final := 1;\n"
"if (length (resp_header) > 0)\n"
"{\n"
"declare resp_line varchar;\n"
"declare pairs any;\n"
"resp_line := resp_header[0];\n"
"pairs := regexp_parse (\'^HTTP[^ \\\\t\\\\r\\\\n]+[ \\\\t]+([0-9]+)[ \\\\t]+([^ \\\\t\\\\r\\\\n]+[^\\\\r\\\\n]*)[ \\\\t\\\\r\\\\n]*\\044\', resp_line, 0);\n"
"if (pairs is null)\n"
"return vector (\'URIQA\', 0, \'500\', \'The remote URIQA server returned an invalid header\');\n"
"return vector (\'00000\', 0, subseq (resp_line, pairs[2], pairs[3]), subseq (resp_line, pairs[4], pairs[5]));\n"
"}\n"
"return vector (\'URIQA\', 0, \'500\', \'The remote URIQA server returned an empty header\');\n"
"\n"
"}\n"
"--src uriqa.sql:568\n";

static const char *proc347 = 
"create procedure WS.WS.URIQA_STATUS (in err_ret any, in signal_errors integer)\n"
"{\n"
"\n"
"if (err_ret[2] is null)\n"
"err_ret[2] := \'500\';\n"
"if (err_ret[3] is null)\n"
"err_ret[3] := coalesce (DAV_PERROR (err_ret[1]), \'OK\');\n"
"if (signal_errors)\n"
"{\n"
"if (err_ret[0] <> \'00000\')\n"
"signal (err_ret[0], sprintf (\'%d %s\', err_ret[2], err_ret[3]));\n"
"return;\n"
"}\n"
"if (err_ret[0] <> \'00000\')\n"
"{\n"
"http_request_status (sprintf (\'HTTP/1.1 %s Error %s %s\', err_ret[2], err_ret[0], split_and_decode (err_ret[3], 0, \'\\0\\0\\n\')[0]));\n"
"http (concat (\'<pre>HTTP/1.1 \', err_ret[2], \' Error \', err_ret[0], \' \', err_ret[3], \'</pre>\'));\n"
"}\n"
"else if (err_ret[2] like \'HTTP/%\')\n"
"http_request_status (err_ret[2]);\n"
"else\n"
"http_request_status (sprintf (\'HTTP/1.1 %s %s\', err_ret[2], split_and_decode (err_ret[3], 0, \'\\0\\0\\n\')[0]));\n"
"}\n"
"--src uriqa.sql:636\n";

static const char *proc348 = 
"create procedure WS.WS.\"MPUT\" (inout path varchar, inout params varchar, inout lines varchar)\n"
"{\n"
"declare b, err_ret any;\n"
"declare s_uri varchar;\n"
"\n"
"b := http_body_read ();\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"WS.WS.URIQA_STATUS (vector (__SQL_STATE, 0, \'500\', __SQL_MESSAGE), 0);\n"
"};\n"
"s_uri := WS.WS.URIQA_FULL_URI (path, params, lines, 0, 0);\n"
"err_ret := WS.WS.URIQA_APPLY_TRIGGERS (\'MPUT\', s_uri, b, params, lines);\n"
"WS.WS.URIQA_STATUS (err_ret, 0);\n"
"}\n"
"--src uriqa.sql:664\n";

static const char *proc349 = 
"create procedure WS.WS.\"MGET\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare b any;\n"
"declare s_uri, err_ret varchar;\n"
"\n"
"b := http_body_read ();\n"
"\n"
"\n"
"\n"
"\n"
"s_uri := WS.WS.URIQA_FULL_URI (path, params, lines, 0, 0);\n"
"\n"
"b := null;\n"
"err_ret := WS.WS.URIQA_APPLY_TRIGGERS (\'MGET\', s_uri, b, params, lines);\n"
"WS.WS.URIQA_STATUS (err_ret, 0);\n"
"}\n"
"--src uriqa.sql:680\n";

static const char *proc350 = 
"create procedure WS.WS.\"MDELETE\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare b any;\n"
"declare s_uri, err_ret varchar;\n"
"\n"
"b := http_body_read ();\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"WS.WS.URIQA_STATUS (vector (__SQL_STATE, 0, \'500\', __SQL_MESSAGE), 0);\n"
"};\n"
"s_uri := WS.WS.URIQA_FULL_URI (path, params, lines, 0, 0);\n"
"err_ret := WS.WS.URIQA_APPLY_TRIGGERS (\'MDELETE\', s_uri, b, params, lines);\n"
"WS.WS.URIQA_STATUS (err_ret, 0);\n"
"}\n"
"--src uriqa.sql:698\n";

static const char *proc351 = 
"create procedure WS.WS.\"/!URIQA/\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"\n"
"return ;\n"
"};\n"
"declare b, err_ret any;\n"
"declare s_uri, upper_line varchar;\n"
"if (length (params) < 1)\n"
"params := __http_stream_params ();\n"
"\n"
"b := http_body_read ();\n"
"if (length (lines) > 1)\n"
"upper_line := upper(lines[0]);\n"
"else\n"
"upper_line := \'\';\n"
"if (\n"
"(upper_line like \'GET /URIQA/ HTTP/%\') or\n"
"(upper_line like \'GET /URIQA HTTP/%\') or\n"
"(trim (upper_line, \' \\r\\n\') like \'GET /URIQA/\') or\n"
"(trim (upper_line, \' \\r\\n\') like \'GET /URIQA\') )\n"
"{\n"
"http (\'<html><head><title>URIQA quick test</title></head><body>\n"
"<form method=\"GET\" action=\"/uriqa/\">\n"
"Enter URI of a resource to get metadata: <input name=\"uri\" type=\"text\"><br/>\n"
"<input name=\"format\" type=\"radio\" selected=1 value=\"application/rdf+xml\"/> RDF/XML\n"
"<input name=\"format\" type=\"radio\" selected=1 value=\"text/xml\"/> XML for HTML browsers\n"
"<input name=\"format\" type=\"radio\" value=\"text/html\"/> HTML<br/>\n"
"<input name=\"Go\" type=\"submit\" value=\"Go\">\n"
"</form>\n"
"</body></html>\' );\n"
"return;\n"
"}\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"WS.WS.URIQA_STATUS (vector (__SQL_STATE, 0, \'500\', __SQL_MESSAGE), 0);\n"
"};\n"
"s_uri := WS.WS.URIQA_FULL_URI (path, params, lines, 1, 1);\n"
"err_ret := WS.WS.URIQA_APPLY_TRIGGERS (get_keyword (\'method\', params, \'MGET\'), s_uri, b, params, lines);\n"
"WS.WS.URIQA_STATUS (err_ret, 0);\n"
"}\n"
"--src uriqa.sql:714\n";

static const char *proc352 = 
"create procedure WS.WS.URIQA_VHOST_RESET()\n"
"{\n"
"registry_set (\'/!URIQA/\', \'no_vsp_recompile\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/URIQA/\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/uriqa/\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/uriqa\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/URIQA\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/URIQA/\', ppath=>\'/!URIQA/\', is_dav=>1, vsp_user=>\'dba\', opts=>vector(\'noinherit\', 1));\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/uriqa/\', ppath=>\'/!URIQA/\', is_dav=>1, vsp_user=>\'dba\', opts=>vector(\'noinherit\', 1));\n"
"}\n"
"--src uriqa.sql:757\n";

/* DET_CatFilter.sql */

static const char *proc353 = 
"create function \"CatFilter_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath, tmp_perms varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare rc, spath_id, n integer;\n"
"\n"
"rfc_spath := null;\n"
"if (DAV_HIDE_ERROR (\"CatFilter_GET_CONDITION\" (id[1], cfc_id, rfc_spath, rfc_list_cond, rfc_del_action)) is null)\n"
"return -1;\n"
"if (not (\'110\' like req))\n"
"return -13;\n"
"spath_id := DAV_SEARCH_ID (rfc_spath, \'C\');\n"
"if (not isinteger (spath_id))\n"
"return -13;\n"
"if (DAV_HIDE_ERROR (spath_id) is null)\n"
"return spath_id;\n"
"rc := DAV_AUTHENTICATE (spath_id, \'C\', req, auth_uname, auth_pwd, auth_uid);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"if (\'C\' = what)\n"
"{\n"
"n := length (id[4]);\n"
"if ((n=0) or (mod (n, 4) = 2))\n"
"tmp_perms := \'100\';\n"
"else if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"\n"
"tmp_perms := \'100\';\n"
"}\n"
"else\n"
"tmp_perms := \'110\';\n"
"if (not (tmp_perms like req))\n"
"return -13;\n"
"return auth_uid;\n"
"}\n"
"else if (\'R\' = what)\n"
"{\n"
"return DAV_AUTHENTICATE (id [2], \'R\', req, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"return -14;\n"
"}\n"
"--src DET_CatFilter.sql:31\n";

static const char *proc354 = 
"create function \"CatFilter_GET_CONDITION\" (in detcol_id integer, out cfc_id integer, out rfc_spath varchar, out rfc_list_cond any, out rfc_del_action any)\n"
"{\n"
"\n"
"whenever not found goto nf;\n"
"if (isarray (detcol_id))\n"
"return -20;\n"
"select cast (\"ResFilter_NORM\" (PROP_VALUE) as integer) into cfc_id from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:CatFilter-ID\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"ResFilter_NORM\" (PROP_VALUE) into rfc_spath from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-SearchPath\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"ResFilter_DECODE_FILTER\" (PROP_VALUE) into rfc_list_cond from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-ListCond\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"ResFilter_DECODE_FILTER\" (PROP_VALUE) into rfc_del_action from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-DelAction\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"return 0;\n"
"nf:\n"
"return -1;\n"
"}\n"
"--src DET_CatFilter.sql:76\n";

static const char *proc355 = 
"create function \"CatFilter_ENCODE_CATVALUE\" (in val varchar) returns varchar\n"
"{\n"
"declare ses any;\n"
"declare ctr, len integer;\n"
"declare lastspace integer;\n"
"if (val is null)\n"
"return \'! property is not set !\';\n"
"if (__tag (val) = 230)\n"
"val := cast (val as varchar);\n"
"ses := string_output ();\n"
"len := length (val);\n"
"if (len > 70)\n"
"{\n"
"val := subseq (val, 0, 65);\n"
"lastspace := strrchr (val, \' \');\n"
"if (lastspace is not null)\n"
"val := subseq (val, 0, lastspace) || \' . . .\';\n"
"else\n"
"val := val || \'...\';\n"
"}\n"
"if (len = 0)\n"
"return \'! empty property value !\';\n"
"len := length (val);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"{\n"
"declare ch integer;\n"
"ch := val [ctr];\n"
"if ((ch < 32) or (ch = 47) or (ch = 92) or (ch = 37) or (ch = 58) or ((ch = 40) and (ctr = 0)))\n"
"http (sprintf (\'^%02x\', ch), ses);\n"
"else\n"
"http (chr (ch), ses);\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src DET_CatFilter.sql:93\n";

static const char *proc356 = 
"create function \"CatFilter_DECODE_CATVALUE\" (in catval varchar, out crop integer)\n"
"{\n"
"declare val varchar;\n"
"declare catvallen integer;\n"
"if (\'! empty property value !\' = catval)\n"
"{\n"
"crop := 0;\n"
"return \'\';\n"
"}\n"
"if (\'! property is not set !\' = catval)\n"
"{\n"
"crop := 4;\n"
"return null;\n"
"}\n"
"catvallen := length (catval);\n"
"if ((catvallen >= 6) and (subseq (catval, catvallen - 6) = \' . . .\'))\n"
"{\n"
"crop := 1;\n"
"catvallen := catvallen - 6;\n"
"catval := subseq (catval, 0, catvallen);\n"
"}\n"
"else\n"
"if ((catvallen >= 3) and (subseq (catval, catvallen - 3) = \'...\'))\n"
"{\n"
"crop := 2;\n"
"catvallen := catvallen - 3;\n"
"catval := subseq (catval, 0, catvallen);\n"
"}\n"
"else\n"
"crop := 0;\n"
"val := split_and_decode (catval, 0, \'^\');\n"
"return val;\n"
"}\n"
"--src DET_CatFilter.sql:130\n";

static const char *proc357 = 
"create function \"CatFilter_PATH_PARTS_TO_FILTER\" (inout path_parts any, out schema_uri varchar, out filter_data any) returns integer\n"
"{\n"
"declare prop_catnames varchar;\n"
"declare pathctr, filtctr, pathlen integer;\n"
"declare filt any;\n"
"pathlen := length (path_parts) - 1;\n"
"if (0 >= pathlen)\n"
"{\n"
"schema_uri := null;\n"
"filter_data := null;\n"
"return 0;\n"
"}\n"
"\n"
"\n"
"retry_after_recomp:\n"
"whenever not found goto no_schema;\n"
"select RS_URI, deserialize (blob_to_string(RS_PROP_CATNAMES)) into schema_uri, prop_catnames from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = path_parts[0] and RS_PROP_CATNAMES is not null;\n"
"filt := make_array (2 * (pathlen - 1), \'any\');\n"
"filtctr := 0;\n"
"for (pathctr := 1; pathctr < pathlen; pathctr := pathctr + 2)\n"
"{\n"
"declare pos integer;\n"
"pos := position (path_parts [pathctr], prop_catnames, 2, 6);\n"
"if (0 = pos)\n"
"{\n"
"\n"
"return -2;\n"
"}\n"
"filt [filtctr] := prop_catnames [pos - 2];\n"
"filt [filtctr + 1] := prop_catnames [pos];\n"
"if (pathctr < (pathlen - 1))\n"
"{\n"
"declare crop_mode integer;\n"
"filt [filtctr + 2] := \"CatFilter_DECODE_CATVALUE\" (path_parts [pathctr + 1], crop_mode);\n"
"filt [filtctr + 3] := crop_mode;\n"
"}\n"
"filtctr := filtctr + 4;\n"
"}\n"
"filter_data := filt;\n"
"return 0;\n"
"\n"
"no_schema:\n"
"\n"
"if (exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = path_parts[0] and RS_PROP_CATNAMES is null))\n"
"{\n"
"DAV_GET_RDF_SCHEMA_N3 ((select RS_URI from WS.WS.SYS_RDF_SCHEMAS where RS_CATNAME = path_parts[0]));\n"
"goto retry_after_recomp;\n"
"}\n"
"\n"
"return -1;\n"
"}\n"
"--src DET_CatFilter.sql:166\n";

static const char *proc358 = 
"create procedure \"CatFilter_ACC_FILTER_DATA\" (inout filter any, inout filter_data any)\n"
"{\n"
"declare ctr, len integer;\n"
"len := length (filter_data);\n"
"len := len - mod (len, 4);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 4)\n"
"{\n"
"declare crop_mode integer;\n"
"declare pred any;\n"
"crop_mode := filter_data [ctr + 3];\n"
"if (crop_mode = 0)\n"
"pred := vector (\'RDF_VALUE\', \'=\', filter_data [ctr + 2], \'http://local.virt/DAV-RDF\', filter_data [ctr]);\n"
"else\n"
"if (crop_mode = 4)\n"
"pred := vector (\'RDF_VALUE\', \'is_null\', \'http://local.virt/DAV-RDF\', filter_data [ctr]);\n"
"else\n"
"pred := vector (\'RDF_VALUE\', \'starts_with\', filter_data [ctr + 2], \'http://local.virt/DAV-RDF\', filter_data [ctr]);\n"
"vectorbld_acc (filter, pred);\n"
"}\n"
"}\n"
"--src DET_CatFilter.sql:220\n";

static const char *proc359 = 
"create function \"CatFilter_DAV_SEARCH_ID_IMPL\" (in detcol_id any, in path_parts any, in what char(1), inout cfc_id integer, inout rfc_spath varchar, inout rfc_list_cond any, inout rfc_del_action any, inout filter_data any) returns any\n"
"{\n"
"declare schema_catname, schema_uri, res_name, colpath, orig_fnameext varchar;\n"
"declare prop_catnames, filter, orig_id any;\n"
"declare path_len, len, ctr integer;\n"
"declare execstate, execmessage varchar;\n"
"declare execmeta, execrows any;\n"
"declare qry_text varchar;\n"
"\n"
"path_len := length (path_parts);\n"
"if (not (isstring (rfc_spath)))\n"
"{\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"}\n"
"if (0 = path_len)\n"
"return -1;\n"
"res_name := path_parts [path_len - 1];\n"
"if (\'\' = res_name)\n"
"{\n"
"if (\'R\' = what)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (\'C\' = what)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (1 = path_len)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (2 = path_len)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (1 = mod (path_len, 2))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"}\n"
"if (0 > \"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"if (\'C\' = what)\n"
"return vector (UNAME\'CatFilter\', detcol_id, null, schema_uri, case (length (filter_data)) when 0 then null else filter_data end);\n"
"\"ResFilter_FNSPLIT\" (res_name, colpath, orig_fnameext, orig_id);\n"
"\n"
"\n"
"\n"
"if (isarray (orig_id))\n"
"return orig_id;\n"
"len := length (filter_data);\n"
"vectorbld_init (filter);\n"
"\"CatFilter_ACC_FILTER_DATA\" (filter, filter_data);\n"
"vectorbld_concat_acc (filter, get_keyword (\'\', rfc_list_cond));\n"
"if (orig_id is not null)\n"
"{\n"
"if (isinteger (orig_id))\n"
"vectorbld_acc (filter, vector (\'RES_ID\', \'=\', orig_id));\n"
"else\n"
"vectorbld_acc (filter, vector (\'RES_ID_SERIALIZED\', \'=\', serialize (orig_id)));\n"
"}\n"
"vectorbld_final (filter);\n"
"\n"
"qry_text := \'\n"
"select top 2 RES_ID\n"
"from WS.WS.SYS_DAV_RES as _top \' || DAV_FC_PRINT_WHERE (filter, coalesce ((select COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = detcol_id), -1)) || \' and (_top.RES_NAME = ?) and (_top.RES_FULL_PATH between ? and ?)\';\n"
"\n"
"exec (qry_text,\n"
"execstate, execmessage, vector (orig_fnameext, rfc_spath, DAV_COL_PATH_BOUNDARY (rfc_spath)), 100000000, execmeta, execrows );\n"
"len := length (execrows);\n"
"if (len <> 1)\n"
"return -1;\n"
"return vector (UNAME\'CatFilter\', detcol_id, execrows[0][0], schema_uri, case (length (filter_data)) when 0 then null else filter_data end);\n"
"}\n"
"--src DET_CatFilter.sql:243\n";

static const char *proc360 = 
"create function \"CatFilter_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath, tmp_perms varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare rc, spath_id, n integer;\n"
"\n"
"rfc_spath := null;\n"
"rc := DAV_HIDE_ERROR (\"CatFilter_GET_CONDITION\" (id[1], cfc_id, rfc_spath, rfc_list_cond, rfc_del_action));\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"if (not (\'110\' like req))\n"
"return -13;\n"
"spath_id := DAV_SEARCH_ID (rfc_spath, \'C\');\n"
"\n"
"if (not isinteger (spath_id))\n"
"return -13;\n"
"if (DAV_HIDE_ERROR (spath_id) is null)\n"
"return spath_id;\n"
"rc := DAV_AUTHENTICATE_HTTP (spath_id, \'C\', req, can_write_http, a_lines, a_uname, a_pwd, a_uid, a_gid, _perms);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"return rc;\n"
"}\n"
"if (\'C\' = what)\n"
"{\n"
"n := length (id[4]);\n"
"if ((n=0) or (mod (n, 4) = 2))\n"
"tmp_perms := \'100\';\n"
"else if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"\n"
"tmp_perms := \'100\';\n"
"}\n"
"else\n"
"tmp_perms := \'110\';\n"
"if (not (tmp_perms like req))\n"
"return -13;\n"
"return a_uid;\n"
"}\n"
"else if (\'R\' = what)\n"
"{\n"
"return DAV_AUTHENTICATE_HTTP (id[2], \'R\', req, can_write_http, a_lines, a_uname, a_pwd, a_uid, a_gid, _perms);\n"
"}\n"
"return -14;\n"
"}\n"
"--src DET_CatFilter.sql:335\n";

static const char *proc361 = 
"create function \"CatFilter_DAV_GET_PARENT\" (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"\n"
"if (st = \'R\')\n"
"{\n"
"id [2] := null;\n"
"return id;\n"
"}\n"
"else if (st = \'C\')\n"
"{\n"
"declare vlen integer;\n"
"vlen := length (id[4]);\n"
"if (vlen = 0)\n"
"return id [1];\n"
"id [4] := subseq (id [4], 0, vlen - 1);\n"
"return id;\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:387\n";

static const char *proc362 = 
"create function \"CatFilter_DAV_COL_CREATE\" (in detcol_id any, in path_parts any, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:409\n";

static const char *proc363 = 
"create function \"CatFilter_DAV_COL_MOUNT\" (in detcol_id any, in path_parts any, in full_mount_path varchar, in mount_det varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:417\n";

static const char *proc364 = 
"create function \"CatFilter_DAV_COL_MOUNT_HERE\" (in parent_id any, in full_mount_path varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:425\n";

static const char *proc365 = 
"create function \"CatFilter_DAV_DELETE\" (in detcol_id any, in path_parts any, in what char(1), in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare cfc_id integer;\n"
"declare rfc_spath, propname varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare orig_id, filter_data, whole_rdf, vals, new_rdf any;\n"
"\n"
"rfc_spath := null;\n"
"orig_id := \"CatFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action, filter_data);\n"
"if (DAV_HIDE_ERROR (orig_id) is null)\n"
"return orig_id;\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"\n"
"return -13;\n"
"}\n"
"if (\'R\' <> what)\n"
"return -20;\n"
"whole_rdf := coalesce ((select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = orig_id [2]));\n"
"if (whole_rdf is null)\n"
"return -1;\n"
"if (not isstring (whole_rdf))\n"
"whole_rdf := blob_to_string (whole_rdf);\n"
"whole_rdf := xml_tree_doc (deserialize (whole_rdf));\n"
"propname := filter_data [length (filter_data) - 4];\n"
"\n"
"vals := xpath_eval (\n"
"\'[xmlns:virt=\"virt\"] /virt:rdf/virt:top-res/virt:prop[*[1][name(.) = \\044propname]][virt:value]\',\n"
"whole_rdf, 0, vector (\'propname\', filter_data [length (filter_data) - 4]) );\n"
"\n"
"foreach (any val in vals) do\n"
"{\n"
"declare cval, decenc_val varchar;\n"
"declare crop integer;\n"
"cval := cast (xpath_eval (\'[xmlns:virt=\"virt\"] string (virt:value)\', val, 1) as varchar);\n"
"decenc_val := \"CatFilter_DECODE_CATVALUE\" (\"CatFilter_ENCODE_CATVALUE\" (cval), crop);\n"
"\n"
"if (decenc_val = filter_data [length (filter_data) - 2])\n"
"{\n"
"\n"
"XMLReplace (whole_rdf, val, null);\n"
"}\n"
"}\n"
"new_rdf := xte_node (xte_head (UNAME\' root\'), whole_rdf);\n"
"update WS.WS.SYS_DAV_PROP set prop_value = serialize (new_rdf) where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\' and PROP_PARENT_ID = orig_id [2];\n"
"return 0;\n"
"}\n"
"--src DET_CatFilter.sql:433\n";

static const char *proc366 = 
"create function \"CatFilter_FILTER_TO_CONDITION\" (inout schema_uri varchar, inout filter_data any, inout cond any) returns integer\n"
"{\n"
"declare ctr, len integer;\n"
"if (schema_uri is null)\n"
"return -13;\n"
"len := length (filter_data);\n"
"if ((len = 0) or (0 <> mod (len, 4)))\n"
"return -13;\n"
"vectorbld_init (cond);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 4)\n"
"{\n"
"declare sample varchar;\n"
"declare crop integer;\n"
"crop := filter_data [ctr + 3];\n"
"\n"
"if (2 = crop)\n"
"return -13;\n"
"sample := filter_data [ctr + 2];\n"
"if (1 = crop)\n"
"return -13;\n"
"vectorbld_acc (cond, vector (\'RDF_VALUE\', \'=\', sample, \'http://local.virt/DAV-RDF\', filter_data [ctr]));\n"
"}\n"
"vectorbld_final (cond);\n"
"return 0;\n"
"}\n"
"--src DET_CatFilter.sql:484\n";

static const char *proc367 = 
"create function \"CatFilter_DAV_RES_UPLOAD\" (in detcol_id any, in path_parts any, inout content any, in type varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare rc integer;\n"
"declare cfc_id integer;\n"
"declare rfc_spath, propname, schema_uri, _colpath, fnameext, orig_fnameext, orig_fullpath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare orig_id, filter_data, fit_cond any;\n"
"\n"
"rfc_spath := null;\n"
"rc := \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"\n"
"return -13;\n"
"}\n"
"schema_uri := null;\n"
"rc := \"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"rc := \"CatFilter_FILTER_TO_CONDITION\" (schema_uri, filter_data, fit_cond);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"fit_cond := vector (\'\', vector_concat (fit_cond, get_keyword (\'\', rfc_list_cond)));\n"
"\n"
"fnameext := path_parts [length (path_parts) - 1];\n"
"\"ResFilter_FNSPLIT\" (fnameext, _colpath, orig_fnameext, orig_id);\n"
"orig_fullpath := null;\n"
"if (orig_id is not null)\n"
"orig_fullpath := DAV_HIDE_ERROR (DAV_SEARCH_PATH (orig_id, \'R\'));\n"
"if (orig_fullpath is null)\n"
"orig_fullpath := DAV_CONCAT_PATH (rfc_spath, orig_fnameext);\n"
"orig_id := DAV_RES_UPLOAD_STRSES_INT (\n"
"orig_fullpath,\n"
"content, \'\',\n"
"permissions, \'\', \'\',\n"
"null, null, 0,\n"
"null, null, null,\n"
"uid, gid, 1 );\n"
"\n"
"if (DAV_HIDE_ERROR (orig_id) is null)\n"
"return orig_id;\n"
"if (not (isinteger (orig_id)))\n"
"return -13;\n"
"\"ResFilter_FIT_INTO_CONDITION\" (orig_id, \'R\', fit_cond, auth_uid);\n"
"return vector (UNAME\'CatFilter\', detcol_id, orig_id, schema_uri, filter_data);\n"
"}\n"
"--src DET_CatFilter.sql:511\n";

static const char *proc368 = 
"create function \"CatFilter_DAV_PROP_REMOVE\" (in id any, in st char(0), in propname varchar, in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"\n"
"if (st <> \'R\')\n"
"return -1;\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\') (id, st, propname, silent, auth_uid);\n"
"return DAV_PROP_REMOVE_RAW (id, st, propname, silent, auth_uid);\n"
"}\n"
"--src DET_CatFilter.sql:561\n";

static const char *proc369 = 
"create function \"CatFilter_DAV_PROP_SET\" (in id any, in st char(0), in propname varchar, in propvalue any, in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"declare pid integer;\n"
"declare resv any;\n"
"\n"
"if (st <> \'R\')\n"
"return -1;\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_SET\') (id, st, propname, propvalue, overwrite, auth_uid);\n"
"return DAV_PROP_SET_RAW (id, st, propname, propvalue, overwrite, auth_uid);\n"
"}\n"
"--src DET_CatFilter.sql:574\n";

static const char *proc370 = 
"create function \"CatFilter_DAV_PROP_GET\" (in id any, in what char(0), in propname varchar, in auth_uid integer)\n"
"{\n"
"declare ret varchar;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"if (propname[0] = 58)\n"
"return DAV_PROP_GET_INT (id, what, propname, 0, null, null, auth_uid);\n"
"whenever not found goto no_prop;\n"
"select blob_to_string (PROP_VALUE) into ret from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = what;\n"
"return ret;\n"
"\n"
"no_prop:\n"
"return -11;\n"
"}\n"
"--src DET_CatFilter.sql:589\n";

static const char *proc371 = 
"create function \"CatFilter_DAV_PROP_LIST\" (in id any, in what char(0), in propmask varchar, in auth_uid integer)\n"
"{\n"
"declare ret any;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_LIST\') (id, what, propmask, auth_uid);\n"
"vectorbld_init (ret);\n"
"for select PROP_NAME, PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME like propmask and PROP_PARENT_ID = id and PROP_TYPE = what do {\n"
"vectorbld_acc (ret, vector (PROP_NAME, blob_to_string (PROP_VALUE)));\n"
"}\n"
"vectorbld_final (ret);\n"
"return ret;\n"
"}\n"
"--src DET_CatFilter.sql:608\n";

static const char *proc372 = 
"create function \"CatFilter_DAV_DIR_SINGLE\" (in id any, in what char(0), in path any, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (\'C\' = what)\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare loc_name, subcol_perms varchar;\n"
"declare set_readonly integer;\n"
"if (0 > \"CatFilter_GET_CONDITION\" (id[1], cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"subcol_perms := coalesce ((select COL_PERMS from WS.WS.SYS_DAV_COL where COL_ID = id[1]), \'000000000N\');\n"
"subcol_perms[2] := 48; subcol_perms[5] := 48; subcol_perms[8] := 48;\n"
"set_readonly := 0;\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"\n"
"set_readonly := 1;\n"
"}\n"
"else\n"
"{\n"
"declare filt_len integer;\n"
"filt_len := length (id[4]);\n"
"if ((0 = filt_len) or (mod (filt_len, 4) = 2))\n"
"set_readonly := 1;\n"
"}\n"
"if (set_readonly)\n"
"{\n"
"subcol_perms[1] := 48; subcol_perms[4] := 48; subcol_perms[7] := 48;\n"
"}\n"
"loc_name := path [length (path) - 2];\n"
"return vector (path, \'C\', 0, now (), id, subcol_perms, 0, auth_uid, now (), \'dav/unix-directory\', loc_name );\n"
"}\n"
"if (isarray (id[2]))\n"
"{\n"
"declare diritem any;\n"
"declare merged varchar;\n"
"diritem := call (cast (id[0] as varchar) || \'_DAV_DIR_SINGLE\') (id[2], what, path, auth_uid);\n"
"merged := \"ResFilter_FNMERGE\" (diritem[10], id[2]);\n"
"diritem[0] := DAV_CONCAT_PATH (path, merged);\n"
"diritem[10] := merged;\n"
"\n"
"return diritem;\n"
"}\n"
"for select RES_FULL_PATH, RES_ID, length (RES_CONTENT) as clen, RES_MOD_TIME,\n"
"RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME as r1_RES_NAME\n"
"from WS.WS.SYS_DAV_RES r1\n"
"where RES_ID = id[2]\n"
"do\n"
"{\n"
"declare merged varchar;\n"
"\n"
"if (regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', r1_RES_NAME, 0))\n"
"{\n"
"merged := \"ResFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"}\n"
"else\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action varchar;\n"
"declare tmp_comp, namesakes any;\n"
"declare namesakes_no integer;\n"
"if (0 > \"CatFilter_GET_CONDITION\" (id[1], cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"tmp_comp := vector (\'\',\n"
"vector_concat (\n"
"vector (vector (\'RES_NAME\', \'=\', r1_RES_NAME)),\n"
"get_keyword (\'\', rfc_list_cond) ) );\n"
"namesakes := DAV_DIR_FILTER_INT (rfc_spath, 1, tmp_comp, null, null, auth_uid);\n"
"namesakes_no := length (namesakes);\n"
"if (0 = namesakes_no)\n"
"return -1;\n"
"if (1 < namesakes_no)\n"
"merged := \"ResFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"else\n"
"merged := r1_RES_NAME;\n"
"}\n"
"path [length (path) - 1] := merged;\n"
"\n"
"return vector (DAV_CONCAT_PATH (\'/\', path), \'R\', clen, RES_MOD_TIME,\n"
"\n"
"id, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, merged);\n"
"}\n"
"return -1;\n"
"}\n"
"--src DET_CatFilter.sql:625\n";

static const char *proc373 = 
"create function \"CatFilter_LIST_SCHEMAS\" (in rfc_spath varchar, inout rfc_list_cond any, in auth_uid integer) returns any\n"
"{\n"
"return (select VECTOR_AGG (vector (RS_URI, RS_CATNAME)) from WS.WS.SYS_RDF_SCHEMAS);\n"
"}\n"
"--src DET_CatFilter.sql:721\n";

static const char *proc374 = 
"create function \"CatFilter_LIST_SCHEMA_PROPS\" (in rfc_spath varchar, inout rfc_list_cond any, inout schema_uri varchar, inout filter_data any, in auth_uid integer) returns any\n"
"{\n"
"declare prop_catnames, res any;\n"
"declare len, ctr integer;\n"
"\n"
"vectorbld_init (res);\n"
"\n"
"retry_after_recomp:\n"
"whenever not found goto schema_nf;\n"
"select deserialize (cast (RS_PROP_CATNAMES as varchar)) into prop_catnames from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri and RS_PROP_CATNAMES is not null;\n"
"len := length (prop_catnames);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 6)\n"
"{\n"
"if (0 = position (prop_catnames [ctr], filter_data, 1, 4))\n"
"vectorbld_acc (res, vector (prop_catnames [ctr], prop_catnames [ctr + 1]));\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"\n"
"schema_nf:\n"
"if (exists (select top 1 1 from WS.WS.SYS_RDF_SCHEMAS where RS_URI = schema_uri and RS_PROP_CATNAMES is null))\n"
"{\n"
"DAV_GET_RDF_SCHEMA_N3 (schema_uri);\n"
"goto retry_after_recomp;\n"
"}\n"
"return vector();\n"
"}\n"
"--src DET_CatFilter.sql:727\n";

static const char *proc375 = 
"create procedure \"CatFilter_GET_RDF_INVERSE_HITS_DISTVALS\" (in cfc_id integer, inout filter_data any, inout distval_dict any, in auth_uid integer)\n"
"{\n"
"declare filter_length, p0_id, p1_id, p2_id, p3_id, p4_id, res0_id, res1_id, res2_id, res3_id, res4_id, res_last_id, res_id_max integer;\n"
"declare plast_id integer;\n"
"declare p0_val, p1_val, p2_val, p3_val, p4_val, v_last, v_max varchar;\n"
"declare auth_gid integer;\n"
"declare acl_bits, hit_ids any;\n"
"declare c_last1 cursor for select             DRI_CATVALUE from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = plast_id and (v_max is null or DRI_CATVALUE > v_max) and\n"
"exists (select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = DRI_RES_ID and case (DAV_CHECK_PERM (RES_PERMS, \'1__\', auth_uid, auth_gid, RES_GROUP, RES_OWNER)) when 0 then WS.WS.ACL_IS_GRANTED (RES_ACL, auth_uid, acl_bits) else 1 end);\n"
"declare c_last2 cursor for select DRI_RES_ID, DRI_CATVALUE from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = plast_id and (v_max is null or DRI_CATVALUE > v_max) and\n"
"exists (select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = DRI_RES_ID and case (DAV_CHECK_PERM (RES_PERMS, \'1__\', auth_uid, auth_gid, RES_GROUP, RES_OWNER)) when 0 then WS.WS.ACL_IS_GRANTED (RES_ACL, auth_uid, acl_bits) else 1 end);\n"
"declare c0 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p0_id and DRI_CATVALUE = p0_val and DRI_RES_ID >= res_id_max;\n"
"declare c1 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p1_id and DRI_CATVALUE = p1_val and DRI_RES_ID >= res_id_max;\n"
"declare c2 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p2_id and DRI_CATVALUE = p2_val and DRI_RES_ID >= res_id_max;\n"
"declare c3 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p3_id and DRI_CATVALUE = p3_val and DRI_RES_ID >= res_id_max;\n"
"declare c4 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p4_id and DRI_CATVALUE = p4_val and DRI_RES_ID >= res_id_max;\n"
"\n"
"filter_length := length (filter_data);\n"
"plast_id := filter_data [filter_length - 1];\n"
"res_id_max := 0;\n"
"v_max := null;\n"
"auth_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = auth_uid), 0);\n"
"acl_bits := DAV_REQ_CHARS_TO_BITMASK (\'1__\');\n"
"\n"
"if (filter_length = 2)\n"
"{\n"
"whenever not found goto nf_c_last1;\n"
"\n"
"open c_last1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch c_last1 into v_last;\n"
"\n"
"if (v_max is null or (v_last > v_max))\n"
"{\n"
"v_max := v_last;\n"
"dict_put (distval_dict, v_last, 1);\n"
"}\n"
"}\n"
"nf_c_last1:\n"
"close c_last1;\n"
"return;\n"
"}\n"
"\n"
"res0_id := 0;\n"
"res1_id := 0;\n"
"res2_id := 0;\n"
"res3_id := 0;\n"
"res4_id := 0;\n"
"hit_ids := dict_new ();\n"
"\n"
"p0_id := filter_data [1];\n"
"p0_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [2]);\n"
"if (filter_length = 6)\n"
"{\n"
"whenever not found goto get_distincts_0;\n"
"open c0 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max)\n"
"fetch c0 into res0_id;\n"
"res_id_max := res0_id;\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"\n"
"p1_id := filter_data [4+1];\n"
"p1_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [4+2]);\n"
"if (filter_length = 10)\n"
"{\n"
"whenever not found goto get_distincts_1;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"else\n"
"res_id_max := res_id_max + 1;\n"
"\n"
"}\n"
"}\n"
"\n"
"p2_id := filter_data [8+1];\n"
"p2_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [8+2]);\n"
"if (filter_length = 14)\n"
"{\n"
"whenever not found goto get_distincts_2;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"\n"
"\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"p3_id := filter_data [12+1];\n"
"p3_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [12+2]);\n"
"if (filter_length = 18)\n"
"{\n"
"whenever not found goto get_distincts_3;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"p4_id := filter_data [16+1];\n"
"p4_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [16+2]);\n"
"if (filter_length = 22)\n"
"{\n"
"whenever not found goto get_distincts_4;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"open c4 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res4_id < res_id_max) fetch c4 into res4_id;\n"
"if (res4_id > res_id_max) res_id_max := res4_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max) and (res4_id = res_id_max))\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"\n"
"get_distincts_4:\n"
"\n"
"close c4;\n"
"get_distincts_3:\n"
"\n"
"close c3;\n"
"get_distincts_2:\n"
"\n"
"close c2;\n"
"get_distincts_1:\n"
"\n"
"close c1;\n"
"get_distincts_0:\n"
"\n"
"close c0;\n"
"\n"
"\n"
"whenever not found goto nf_c_last2;\n"
"open c_last2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch c_last2 into res_last_id, v_last;\n"
"if (v_max is null or (v_last > v_max))\n"
"{\n"
"\n"
"if (dict_get (hit_ids, res_last_id, 0))\n"
"{\n"
"\n"
"v_max := v_last;\n"
"dict_put (distval_dict, v_last, 1);\n"
"}\n"
"}\n"
"}\n"
"nf_c_last2:\n"
"close c_last2;\n"
"}\n"
"--src DET_CatFilter.sql:757\n";

static const char *proc376 = 
"create function \"CatFilter_GET_RDF_INVERSE_HITS_RES_IDS\" (in cfc_id integer, inout filter_data any, in auth_uid integer) returns any\n"
"{\n"
"declare filter_length, p0_id, p1_id, p2_id, p3_id, p4_id, res0_id, res1_id, res2_id, res3_id, res4_id, res_id_max integer;\n"
"declare acc any;\n"
"declare p0_val, p1_val, p2_val, p3_val, p4_val varchar;\n"
"declare acl_bits any;\n"
"declare auth_gid integer;\n"
"declare c0 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p0_id and DRI_CATVALUE = p0_val and DRI_RES_ID >= res_id_max and\n"
"exists (select top 1 1 from WS.WS.SYS_DAV_RES where RES_ID = DRI_RES_ID and case (DAV_CHECK_PERM (RES_PERMS, \'1__\', auth_uid, auth_gid, RES_GROUP, RES_OWNER)) when 0 then WS.WS.ACL_IS_GRANTED (RES_ACL, auth_uid, acl_bits) else 1 end);\n"
"declare c1 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p1_id and DRI_CATVALUE = p1_val and DRI_RES_ID >= res_id_max;\n"
"declare c2 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p2_id and DRI_CATVALUE = p2_val and DRI_RES_ID >= res_id_max;\n"
"declare c3 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p3_id and DRI_CATVALUE = p3_val and DRI_RES_ID >= res_id_max;\n"
"declare c4 cursor for select DRI_RES_ID from WS.WS.SYS_DAV_RDF_INVERSE where DRI_CATF_ID = cfc_id and DRI_PROP_CATID = p4_id and DRI_CATVALUE = p4_val and DRI_RES_ID >= res_id_max;\n"
"\n"
"filter_length := length (filter_data);\n"
"vectorbld_init (acc);\n"
"\n"
"res0_id := -1;\n"
"res1_id := -1;\n"
"res2_id := -1;\n"
"res3_id := -1;\n"
"res4_id := -1;\n"
"res_id_max := 0;\n"
"\n"
"auth_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = auth_uid), 0);\n"
"acl_bits := DAV_REQ_CHARS_TO_BITMASK (\'1__\');\n"
"\n"
"p0_id := filter_data [1];\n"
"p0_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [2]);\n"
"if (filter_length = 4)\n"
"{\n"
"whenever not found goto get_distincts_0;\n"
"open c0 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max)\n"
"fetch c0 into res0_id;\n"
"res_id_max := res0_id;\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"}\n"
"}\n"
"\n"
"p1_id := filter_data [4+1];\n"
"p1_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [4+2]);\n"
"if (filter_length = 8)\n"
"{\n"
"whenever not found goto get_distincts_1;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p2_id := filter_data [8+1];\n"
"p2_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [8+2]);\n"
"if (filter_length = 12)\n"
"{\n"
"whenever not found goto get_distincts_2;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p3_id := filter_data [12+1];\n"
"p3_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [12+2]);\n"
"if (filter_length = 16)\n"
"{\n"
"whenever not found goto get_distincts_3;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p4_id := filter_data [16+1];\n"
"p4_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [16+2]);\n"
"if (filter_length = 20)\n"
"{\n"
"whenever not found goto get_distincts_4;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"open c4 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res4_id < res_id_max) fetch c4 into res4_id;\n"
"if (res4_id > res_id_max) res_id_max := res4_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max) and (res4_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"get_distincts_4:\n"
"close c4;\n"
"get_distincts_3:\n"
"close c3;\n"
"get_distincts_2:\n"
"close c2;\n"
"get_distincts_1:\n"
"close c1;\n"
"get_distincts_0:\n"
"close c0;\n"
"\n"
"finalize:\n"
"vectorbld_final (acc);\n"
"\n"
"return acc;\n"
"}\n"
"--src DET_CatFilter.sql:972\n";

static const char *proc377 = 
"create function \"CatFilter_LIST_PROP_DISTVALS_AUX\" (inout dict any, inout rfp varchar, inout vals any)\n"
"{\n"
"\n"
"foreach (any val in vals) do\n"
"{\n"
"\n"
"dict_put (dict, \"CatFilter_ENCODE_CATVALUE\" (cast (val as varchar)), 1);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_CatFilter.sql:1140\n";

static const char *proc378 = 
"create function \"CatFilter_LIST_PROP_DISTVALS\" (in detcol_id integer, in cfc_id integer, in rfc_spath varchar, inout rfc_list_cond any, inout schema_uri varchar, inout filter_data any, in auth_uid integer) returns any\n"
"{\n"
"declare prop_catnames, filter, res any;\n"
"\n"
"declare len, ctr integer;\n"
"declare execstate, execmessage varchar;\n"
"declare execmeta, execrows any;\n"
"declare qry_ft, qry_where, qry_text varchar;\n"
"\n"
"declare pred_metas, cmp_metas, table_metas any;\n"
"declare used_tables any;\n"
"declare dict any;\n"
"declare auth_gid integer;\n"
"\n"
"\n"
"dict := dict_new ();\n"
"\n"
"if ((length (get_keyword (\'\', rfc_list_cond)) = 0) and (length (filter_data) > 0) and (length (filter_data) <= 22))\n"
"{\n"
"\"CatFilter_GET_RDF_INVERSE_HITS_DISTVALS\" (cfc_id, filter_data, dict, auth_uid);\n"
"goto plain_resources_passed;\n"
"}\n"
"\n"
"len := length (filter_data);\n"
"vectorbld_init (filter);\n"
"\"CatFilter_ACC_FILTER_DATA\" (filter, filter_data);\n"
"vectorbld_concat_acc (filter, get_keyword (\'\', rfc_list_cond));\n"
"vectorbld_final (filter);\n"
"\n"
"\n"
"DAV_FC_PRED_METAS (pred_metas);\n"
"DAV_FC_CMP_METAS (cmp_metas);\n"
"DAV_FC_TABLE_METAS (table_metas);\n"
"qry_ft := sprintf (\'virt:rdf/virt:top-res/virt:prop[*[1][self::(!%s!)]]/virt:value\', filter_data [len-2]);\n"
"used_tables := vector (\n"
"\'SYS_DAV_RES\', vector (\'SYS_DAV_RES\', \'_top\', null, vector(), vector(), vector()),\n"
"\'SYS_DAV_PROP, PROP_NAME=http://local.virt/DAV-RDF\', vector (\'SYS_DAV_PROP\', \'_rdf\', \'(_rdf.PROP_NAME = \'\'http://local.virt/DAV-RDF\'\')\', vector(), vector(), vector(\'[\' || qry_ft || \']\'))\n"
");\n"
"qry_where := DAV_FC_PRINT_WHERE_INT (filter, pred_metas, cmp_metas, table_metas, used_tables,\n"
"coalesce ((select COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = detcol_id), -1) );\n"
"\n"
"auth_gid := coalesce ((select U_GROUP from WS.WS.SYS_DAV_USER where U_ID = auth_uid), 0);\n"
"\n"
"\n"
"qry_text := \'\n"
"select count ( \"CatFilter_LIST_PROP_DISTVALS_AUX\" (?, _top.RES_FULL_PATH,\n"
"xpath_eval (\'\'[xmlns:virt=\"virt\"] /\' || qry_ft ||\'\'\',\n"
"xml_tree_doc (deserialize (cast (_rdf.PROP_VALUE as varchar))),\n"
"0 ) ) )\n"
"from WS.WS.SYS_DAV_RES as _top\n"
"\' || qry_where || \' and\n"
"(_top.RES_FULL_PATH between \' || WS.WS.STR_SQL_APOS (rfc_spath) || \' and \' || WS.WS.STR_SQL_APOS (DAV_COL_PATH_BOUNDARY (rfc_spath)) || \') and\n"
"case (DAV_CHECK_PERM (_top.RES_PERMS, \'\'1__\'\', ?, ?, _top.RES_GROUP, _top.RES_OWNER)) when 0 then WS.WS.ACL_IS_GRANTED (_top.RES_ACL, ?, DAV_REQ_CHARS_TO_BITMASK (\'\'1__\'\')) else 1 end\n"
"\';\n"
"\n"
"exec (qry_text,\n"
"execstate, execmessage, vector (dict, auth_uid, auth_gid, auth_uid), 1, execmeta, execrows );\n"
"\n"
"\n"
"plain_resources_passed:\n"
"for\n"
"select CFD_DET_SUBCOL_ID, CFD_DET from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_CF_ID = cfc_id\n"
"do\n"
"{\n"
"if (exists (select top 1 1 from SYS_PROCEDURES where P_NAME = fix_identifier_case(\'DB.DBA.\') || CFD_DET || \'_CF_LIST_PROP_DISTVALS\'))\n"
"call (CFD_DET || \'_CF_LIST_PROP_DISTVALS\') (CFD_DET_SUBCOL_ID, cfc_id, rfc_spath, rfc_list_cond, schema_uri, filter_data, dict, auth_uid);\n"
"}\n"
"return dict_list_keys (dict, 1);\n"
"}\n"
"--src DET_CatFilter.sql:1152\n";

static const char *proc379 = 
"create function \"CatFilter_DAV_DIR_LIST\" (in detcol_id any, in path_parts any, in detcol_path varchar, in name_mask varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare davpath, prev_raw_name, schema_uri, subcol_perms varchar;\n"
"declare depth integer;\n"
"declare res, resources, itm, reps, filter_data any;\n"
"declare ctr, itm_ctr, itm_count, prev_is_patched, set_readonly integer;\n"
"declare filter any;\n"
"\n"
"vectorbld_init (res);\n"
"filter_data := null;\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"goto final_res;\n"
"}\n"
"subcol_perms := coalesce ((select COL_PERMS from WS.WS.SYS_DAV_COL where COL_ID = detcol_id), \'000000000N\');\n"
"subcol_perms[2] := 48; subcol_perms[5] := 48; subcol_perms[8] := 48;\n"
"if (1 < length(path_parts))\n"
"{\n"
"if (\"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data) < 0)\n"
"{\n"
"\n"
"goto final_res;\n"
"}\n"
"}\n"
"else\n"
"filter_data := null;\n"
"set_readonly := 0;\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"\n"
"set_readonly := 1;\n"
"}\n"
"else\n"
"if (-1 = recursive)\n"
"{\n"
"if ((2 = length(path_parts)) or (mod (length (filter_data), 4) = 2))\n"
"set_readonly := 1;\n"
"}\n"
"else\n"
"{\n"
"if ((1 = length(path_parts)) or (mod (length (filter_data), 4) = 0))\n"
"set_readonly := 1;\n"
"}\n"
"if (set_readonly)\n"
"{\n"
"subcol_perms[1] := 48; subcol_perms[4] := 48; subcol_perms[7] := 48;\n"
"}\n"
"depth := length(path_parts);\n"
"\n"
"if (1 = length(path_parts))\n"
"{\n"
"declare schemas any;\n"
"\n"
"if (\'\' <> path_parts[0])\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"schemas := \"CatFilter_LIST_SCHEMAS\" (rfc_spath, rfc_list_cond, auth_uid);\n"
"foreach (any sch in schemas) do\n"
"{\n"
"declare subcol_fullpath varchar;\n"
"subcol_fullpath := DAV_CONCAT_PATH (detcol_path, sch[1] || \'/\');\n"
"vectorbld_acc (res,\n"
"vector (subcol_fullpath, \'C\', 0, now (),\n"
"vector (UNAME\'CatFilter\', detcol_id, null, sch[0], null),\n"
"subcol_perms, 0, auth_uid, now (), \'dav/unix-directory\', sch[1]) );\n"
"if (recursive > 0)\n"
"vectorbld_concat_acc (res,\n"
"\"CatFilter_DAV_DIR_LIST\" (detcol_id,\n"
"vector_concat (subseq (path_parts, 0, length (path_parts) - 1), vector (sch[1], \'\')),\n"
"detcol_path,\n"
"name_mask, recursive, auth_uid ) );\n"
"}\n"
"goto final_res;\n"
"}\n"
"if (\"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data) < 0)\n"
"{\n"
"\n"
"goto final_res;\n"
"}\n"
"\n"
"\n"
"if (mod (length (filter_data), 4) = 2)\n"
"{\n"
"declare distvals any;\n"
"\n"
"distvals := \"CatFilter_LIST_PROP_DISTVALS\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, schema_uri, filter_data, auth_uid);\n"
"if (-1 = recursive)\n"
"{\n"
"\n"
"\n"
"return vector (\n"
"vector (DAV_CONCAT_PATH (detcol_path, path_parts), \'C\', 0, now (),\n"
"vector (UNAME\'CatFilter\', detcol_id, null, schema_uri, filter_data),\n"
"subcol_perms, 0, auth_uid, now (), \'dav/unix-directory\', path_parts [depth - 2] ) );\n"
"}\n"
"foreach (varchar val in distvals) do\n"
"{\n"
"declare subcol_fullpath varchar;\n"
"subcol_fullpath := DAV_CONCAT_PATH ( DAV_CONCAT_PATH (detcol_path, path_parts), val || \'/\');\n"
"vectorbld_acc (res,\n"
"vector (subcol_fullpath, \'C\', 0, now (),\n"
"vector (UNAME\'CatFilter\', detcol_id, null, schema_uri, vector_concat (filter_data, vector (val))),\n"
"subcol_perms, 0, auth_uid, now (), \'dav/unix-directory\', val) );\n"
"if (recursive > 0)\n"
"vectorbld_concat_acc (res,\n"
"\"CatFilter_DAV_DIR_LIST\" (detcol_id,\n"
"vector_concat (subseq (path_parts, 0, length (path_parts) - 1), vector (val, \'\')),\n"
"detcol_path,\n"
"name_mask, recursive, auth_uid ) );\n"
"}\n"
"goto final_res;\n"
"}\n"
"else if (length (filter_data) <= 16)\n"
"{\n"
"declare sch_props any;\n"
"\n"
"sch_props := \"CatFilter_LIST_SCHEMA_PROPS\" (rfc_spath, rfc_list_cond, schema_uri, filter_data, auth_uid);\n"
"if (-1 = recursive)\n"
"{\n"
"\n"
"\n"
"return vector (\n"
"vector (DAV_CONCAT_PATH (detcol_path, path_parts), \'C\', 0, now (),\n"
"vector (UNAME\'CatFilter\', detcol_id, null, schema_uri, filter_data),\n"
"subcol_perms, 0, auth_uid, now (), \'dav/unix-directory\', path_parts [depth - 2] ) );\n"
"}\n"
"\n"
"\n"
"\n"
"if (length (filter_data) >= 4)\n"
"recursive := 0;\n"
"foreach (any prop in sch_props) do\n"
"{\n"
"declare subcol_fullpath varchar;\n"
"subcol_fullpath := DAV_CONCAT_PATH (DAV_CONCAT_PATH (detcol_path, path_parts), prop[1] || \'/\');\n"
"vectorbld_acc (res,\n"
"vector (subcol_fullpath, \'C\', 0, now (),\n"
"vector (UNAME\'CatFilter\', detcol_id, null, prop[0], null),\n"
"subcol_perms, 0, auth_uid, now (), \'dav/unix-directory\', prop[1]) );\n"
"if (recursive > 0)\n"
"vectorbld_concat_acc (res,\n"
"\"CatFilter_DAV_DIR_LIST\" (detcol_id,\n"
"vector_concat (subseq (path_parts, 0, length (path_parts) - 1), vector (prop[1], \'\')),\n"
"detcol_path,\n"
"name_mask, recursive, auth_uid ) );\n"
"}\n"
"}\n"
"\n"
"if (0 = length (filter_data))\n"
"{\n"
"\n"
"goto final_res;\n"
"}\n"
"\n"
"if ((length (get_keyword (\'\', rfc_list_cond)) = 0) and (length (filter_data) > 0) and (length (filter_data) <= 20))\n"
"{\n"
"declare res_ids, res_dir_single any;\n"
"res_ids := \"CatFilter_GET_RDF_INVERSE_HITS_RES_IDS\" (cfc_id, filter_data, auth_uid);\n"
"\n"
"itm_count := length (res_ids);\n"
"vectorbld_init (resources);\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare r_id integer;\n"
"r_id := res_ids [itm_ctr];\n"
"res_dir_single := coalesce ((\n"
"select\n"
"\n"
"vector (DAV_CONCAT_PATH (detcol_path, RES_NAME), \'R\', length (RES_CONTENT), RES_MOD_TIME,\n"
"\n"
"r_id, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME )\n"
"from WS.WS.SYS_DAV_RES\n"
"where RES_ID = r_id ) );\n"
"if (res_dir_single is not null)\n"
"vectorbld_acc (resources, res_dir_single);\n"
"}\n"
"for select CFD_DET_SUBCOL_ID, CFD_DET from WS.WS.SYS_DAV_CATFILTER_DETS where CFD_CF_ID = cfc_id do\n"
"{\n"
"declare det_res_ids any;\n"
"if (exists (select top 1 1 from SYS_PROCEDURES where P_NAME = fix_identifier_case(\'DB.DBA.\') || CFD_DET || \'_CF_GET_RDF_HITS\'))\n"
"{\n"
"det_res_ids := call (CFD_DET || \'_CF_GET_RDF_HITS\') (CFD_DET_SUBCOL_ID, cfc_id, rfc_spath, rfc_list_cond, schema_uri, filter_data, detcol_path, 1, auth_uid);\n"
"vectorbld_concat_acc (resources, det_res_ids);\n"
"}\n"
"}\n"
"vectorbld_final (resources);\n"
"}\n"
"else\n"
"{\n"
"vectorbld_init (filter);\n"
"\"CatFilter_ACC_FILTER_DATA\" (filter, filter_data);\n"
"vectorbld_concat_acc (filter, get_keyword (\'\', rfc_list_cond));\n"
"\n"
"if (\'%\' <> name_mask)\n"
"{\n"
"\n"
"vectorbld_acc (filter, vector (\'RES_NAME\', \'like\', name_mask));\n"
"}\n"
"vectorbld_final (filter);\n"
"filter := vector (\'\', filter);\n"
"resources := DAV_DIR_FILTER_INT (rfc_spath, 1, filter, null, null, auth_uid);\n"
"}\n"
"reps := dict_new ();\n"
"itm_count := length (resources);\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id any;\n"
"itm := resources [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"if (isarray (orig_id) or regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', rname, 0))\n"
"resources [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"dict_put (reps, rname, dict_get (reps, rname, 0) + 1);\n"
"}\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"itm := resources [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"resources[itm_ctr][4] := vector (UNAME\'CatFilter\', detcol_id, orig_id);\n"
"if (dict_get (reps, rname, 0) > 1)\n"
"resources [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"resources[itm_ctr][0] := DAV_CONCAT_PATH (DAV_CONCAT_PATH (detcol_path, path_parts), rname);\n"
"}\n"
"vectorbld_concat_acc (res, resources);\n"
"\n"
"\n"
"final_res:\n"
"vectorbld_final (res);\n"
"\n"
"\n"
"return res;\n"
"}\n"
"--src DET_CatFilter.sql:1223\n";

static const char *proc380 = 
"create function \"CatFilter_DAV_DIR_FILTER\" (in detcol_id any, in path_parts any, in detcol_path varchar, inout compilation any, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare davpath, prev_raw_name varchar;\n"
"declare res, itm, reps any;\n"
"declare itm_ctr, itm_count, prev_is_patched integer;\n"
"\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"if (0 = length (get_keyword (\'\', compilation)))\n"
"res := DAV_DIR_FILTER_INT (rfc_spath, 1, rfc_list_cond, null, null, auth_uid);\n"
"else\n"
"{\n"
"declare tmp_cond any;\n"
"tmp_cond := vector (\'\',\n"
"vector_concat (\n"
"get_keyword (\'\', compilation),\n"
"get_keyword (\'\', rfc_list_cond) ) );\n"
"res := DAV_DIR_FILTER_INT (rfc_spath, 1, tmp_cond, null, null, auth_uid);\n"
"}\n"
"reps := dict_new ();\n"
"itm_count := length (res);\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"itm := res [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"if (isarray (orig_id) or regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', rname, 0))\n"
"res [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"dict_put (reps, rname, dict_get (reps, rname, 0) + 1);\n"
"}\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"itm := res [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"res[itm_ctr][4] := vector (UNAME\'CatFilter\', detcol_id, orig_id);\n"
"if (dict_get (reps, rname, 0) > 1)\n"
"res [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"res[itm_ctr][0] := DAV_CONCAT_PATH (DAV_CONCAT_PATH (detcol_path, path_parts), rname);\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_CatFilter.sql:1468\n";

static const char *proc381 = 
"create function \"CatFilter_DAV_SEARCH_ID\" (in detcol_id any, in path_parts any, in what char(1)) returns any\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare orig_id, filter_data any;\n"
"\n"
"rfc_spath := null;\n"
"orig_id := \"CatFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action, filter_data);\n"
"return orig_id;\n"
"}\n"
"--src DET_CatFilter.sql:1523\n";

static const char *proc382 = 
"create function \"CatFilter_DAV_SEARCH_PATH\" (in id any, in what char(1)) returns any\n"
"{\n"
"\n"
"if (\'R\' = what)\n"
"return coalesce ((select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_ID = id[2]), null);\n"
"if (\'C\' = what)\n"
"{\n"
"declare res varchar;\n"
"res := DAV_SEARCH_PATH (id[1], \'C\');\n"
"if (id[3] is not null)\n"
"{\n"
"\n"
" ;\n"
"}\n"
"if (id[4] is not null)\n"
"{\n"
"\n"
" ;\n"
"}\n"
"return res;\n"
"}\n"
"\n"
"return -14;\n"
"}\n"
"--src DET_CatFilter.sql:1537\n";

static const char *proc383 = 
"create function \"CatFilter_DAV_RES_UPLOAD_COPY\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath, schema_uri varchar;\n"
"declare rfc_list_cond, rfc_del_action, filter_data, fit_cond any;\n"
"declare rc integer;\n"
"\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -2;\n"
"}\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"\n"
"return -13;\n"
"}\n"
"rc := \"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"rc := \"CatFilter_FILTER_TO_CONDITION\" (schema_uri, filter_data, fit_cond);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"fit_cond := vector (\'\', vector_concat (fit_cond, get_keyword (\'\', rfc_list_cond)));\n"
"if (\'R\' <> what)\n"
"return -2;\n"
"if (\'\' = path_parts [length (path_parts) - 1])\n"
"return -2;\n"
"if (isinteger (source_id) and\n"
"exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_ID = source_id and RES_NAME = path_parts [length (path_parts) - 1] and (RES_FULL_PATH between rfc_spath and DAV_COL_PATH_BOUNDARY (rfc_spath)) ) )\n"
"{\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, fit_cond, auth_uid);\n"
"}\n"
"else\n"
"{\n"
"declare new_full_path varchar;\n"
"new_full_path := DAV_CONCAT_PATH (rfc_spath, path_parts [length (path_parts) - 1]);\n"
"rc := DAV_COPY_INT (DAV_SEARCH_PATH (source_id, what), new_full_path, overwrite, permissions,\n"
"coalesce ((select U_NAME from WS.WS.SYS_DAV_USER where U_ID = uid), \'\'),\n"
"coalesce ((select G_NAME from WS.WS.SYS_DAV_GROUP where G_ID = gid), \'\'),\n"
"null, null, 0);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"source_id := DAV_SEARCH_ID (new_full_path, what);\n"
"if (DAV_HIDE_ERROR (source_id) is null)\n"
"return source_id;\n"
"if (not (isinteger (source_id)))\n"
"return -13;\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, fit_cond, auth_uid);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_CatFilter.sql:1564\n";

static const char *proc384 = 
"create function \"CatFilter_DAV_RES_UPLOAD_MOVE\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"declare cfc_id integer;\n"
"declare rfc_spath, schema_uri varchar;\n"
"declare rfc_list_cond, rfc_del_action, filter_data, fit_cond any;\n"
"declare rc integer;\n"
"\n"
"if (0 > \"CatFilter_GET_CONDITION\" (detcol_id, cfc_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -2;\n"
"}\n"
"if (length (rfc_del_action) < length (rfc_list_cond))\n"
"{\n"
"\n"
"return -13;\n"
"}\n"
"rc := \"CatFilter_PATH_PARTS_TO_FILTER\" (path_parts, schema_uri, filter_data);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"rc := \"CatFilter_FILTER_TO_CONDITION\" (schema_uri, filter_data, fit_cond);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"fit_cond := vector (\'\', vector_concat (fit_cond, get_keyword (\'\', rfc_list_cond)));\n"
"if (\'R\' <> what)\n"
"return -2;\n"
"if (\'\' = path_parts [length (path_parts) - 1])\n"
"return -2;\n"
"if (isinteger (source_id) and\n"
"exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_ID = source_id and RES_NAME = path_parts [length (path_parts) - 1] and (RES_FULL_PATH between rfc_spath and DAV_COL_PATH_BOUNDARY (rfc_spath))))\n"
"{\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, fit_cond, auth_uid);\n"
"}\n"
"else\n"
"{\n"
"declare new_full_path varchar;\n"
"new_full_path := DAV_CONCAT_PATH (rfc_spath, path_parts [length (path_parts) - 1]);\n"
"rc := DAV_MOVE_INT (DAV_SEARCH_PATH (source_id, what), new_full_path, overwrite, null, null, 0, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"source_id := DAV_SEARCH_ID (new_full_path, what);\n"
"if (DAV_HIDE_ERROR (source_id) is null)\n"
"return source_id;\n"
"if (not (isinteger (source_id)))\n"
"return -13;\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, fit_cond, auth_uid);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_CatFilter.sql:1620\n";

static const char *proc385 = 
"create function \"CatFilter_DAV_RES_CONTENT\" (in id any, inout content any, out type varchar, in content_mode integer) returns integer\n"
"{\n"
"\n"
"declare cont any;\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"select RES_CONTENT, RES_TYPE into content, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"else if (content_mode = 1)\n"
"select http (RES_CONTENT, content), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"else if (content_mode = 3)\n"
"select http (RES_CONTENT), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"return id[2];\n"
"}\n"
"--src DET_CatFilter.sql:1673\n";

static const char *proc386 = 
"create function \"CatFilter_DAV_SYMLINK\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:1688\n";

static const char *proc387 = 
"create function \"CatFilter_DAV_LOCK\" (in path any, inout id any, in type char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid integer) returns any\n"
"{\n"
"declare rc, u_token, new_token varchar;\n"
"\n"
"if (\'R\' <> type)\n"
"return -20;\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return -20;\n"
"if (isarray (id))\n"
"return DAV_LOCK_INT (path, id[2], type, locktype, scope, token, owner_name, owned_tokens, depth, timeout_sec, null, null, auth_uid);\n"
"return -20;\n"
"}\n"
"--src DET_CatFilter.sql:1696\n";

static const char *proc388 = 
"create function \"CatFilter_DAV_UNLOCK\" (in id any, in type char(1), in token varchar, in auth_uid integer)\n"
"{\n"
"\n"
"if (isarray (id))\n"
"id := id [2];\n"
"return DAV_UNLOCK_INT (id, type, token, null, null, auth_uid);\n"
"}\n"
"--src DET_CatFilter.sql:1711\n";

static const char *proc389 = 
"create function \"CatFilter_DAV_IS_LOCKED\" (inout id any, inout type char(1), in owned_tokens varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare orig_id any;\n"
"declare orig_type char(1);\n"
"\n"
"orig_id := id;\n"
"id := orig_id[2];\n"
"rc := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"id := orig_id[1];\n"
"orig_type := type;\n"
"type := \'C\';\n"
"rc := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"id := orig_id;\n"
"type := orig_type;\n"
"return 0;\n"
"}\n"
"--src DET_CatFilter.sql:1721\n";

static const char *proc390 = 
"create function \"CatFilter_DAV_LIST_LOCKS\" (in id any, in type char(1), in recursive integer) returns any\n"
"{\n"
"declare res any;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_LIST_LOCKS\') (id, type, recursive);\n"
"res := vector();\n"
"for select LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO\n"
"from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = type do {\n"
"res := vector_concat (res, vector (vector (LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO)));\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_CatFilter.sql:1745\n";

static const char *proc391 = 
"create function \"CatFilter_CONFIGURE\" (in col any, in search_path varchar, in filter any, in auth_uname varchar := \'dav\', in auth_upwd varchar := \'dav\', in auth_uid integer := null) returns integer\n"
"{\n"
"declare cfid, rc, ctr integer;\n"
"declare colname varchar;\n"
"declare compilation, del_act any;\n"
"compilation := vector (\'\', filter);\n"
"rc := DAV_DIR_FILTER_INT (search_path, 1, compilation, auth_uname, auth_upwd, auth_uid);\n"
"if (isinteger (rc))\n"
"return rc;\n"
"if (not isinteger (col))\n"
"return -20;\n"
"colname := DAV_SEARCH_PATH (col, \'C\');\n"
"if (not (isstring (colname)))\n"
"return -23;\n"
"rc := DAV_SEARCH_ID (search_path, \'C\');\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"if (search_path <> DAV_SEARCH_PATH (rc, \'C\'))\n"
"return -2;\n"
"if (search_path between colname and (colname || \'\\255\\255\\255\\255\'))\n"
"return -28;\n"
"rc := DAV_PROP_SET_INT (colname, \'virt:ResFilter-SearchPath\', search_path, null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"rc := DAV_PROP_SET_INT (colname, \'virt:ResFilter-ListCond\', \"ResFilter_ENCODE_FILTER\" (compilation), null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"del_act := \"ResFilter_MAKE_DEL_ACTION_FROM_CONDITION\" (compilation);\n"
"\n"
"rc := DAV_PROP_SET_INT (colname, \'virt:ResFilter-DelAction\', \"ResFilter_ENCODE_FILTER\" (del_act), null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"\n"
"cfid := coalesce ((select CF_ID from WS.WS.SYS_DAV_CATFILTER where CF_SEARCH_PATH = search_path));\n"
"if (cfid is null)\n"
"{\n"
"declare search_path_z varchar;\n"
"cfid := WS.WS.GETID (\'CF\');\n"
"insert into WS.WS.SYS_DAV_CATFILTER (CF_ID, CF_SEARCH_PATH) values (cfid, search_path);\n"
"search_path_z := search_path || \'\\255\\255\\255\\255\';\n"
"for (select p.PROP_VALUE, p.PROP_PARENT_ID\n"
"from WS.WS.SYS_DAV_RES r join WS.WS.SYS_DAV_PROP p on (r.RES_ID = p.PROP_PARENT_ID)\n"
"where (r.RES_FULL_PATH between search_path and search_path_z) and (p.PROP_NAME = \'http://local.virt/DAV-RDF\') and (p.PROP_TYPE = \'R\')) do\n"
"{\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (PROP_VALUE, PROP_PARENT_ID, 0, cfid);\n"
"ctr := ctr + 1;\n"
"if (mod (ctr, 1000) = 0)\n"
"commit work;\n"
"}\n"
"commit work;\n"
"for (select COL_ID, COL_DET, WS.WS.COL_PATH (COL_ID) as _c_path from WS.WS.SYS_DAV_COL where COL_DET is not null and not (COL_DET like \'%Filter\')) do\n"
"{\n"
"if (\"LEFT\" (_c_path, length (search_path)) = search_path)\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_CATFILTER_DETS (CFD_CF_ID, CFD_DET_SUBCOL_ID, CFD_DET)\n"
"values (cfid, COL_ID, COL_DET);\n"
"}\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"rc := DAV_PROP_SET_INT (colname, \'virt:CatFilter-ID\', cast (cfid as varchar), null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"update WS.WS.SYS_DAV_COL set COL_DET=\'CatFilter\' where COL_ID=col;\n"
"\n"
"return 0;\n"
"}\n"
"--src DET_CatFilter.sql:1762\n";

static const char *proc392 = 
"create procedure \"CatFilter_FEED_DAV_RDF_INVERSE\" (inout propval any, inout propparent integer, in is_del integer := 0, in cfid integer := null)\n"
"{\n"
"declare resfullpath, path_head, pv varchar;\n"
"declare doc any;\n"
"declare triplets any;\n"
"\n"
"if (126 = __tag (propval))\n"
"pv := blob_to_string (propval);\n"
"else\n"
"{\n"
"if ((not isstring (propval)) or (propval = \'\'))\n"
"return;\n"
"pv := propval;\n"
"}\n"
"if (193 <> pv[0])\n"
"return;\n"
"doc := null;\n"
"if (cfid is not null)\n"
"{\n"
"path_head := \'/\';\n"
"goto cfid_found;\n"
"}\n"
"else\n"
"{\n"
"resfullpath := coalesce ((select r.RES_FULL_PATH from WS.WS.SYS_DAV_RES r where r.RES_ID = propparent));\n"
"if (resfullpath is null)\n"
"return;\n"
"path_head := subseq (resfullpath, 0, strrchr (resfullpath, \'/\'));\n"
"}\n"
"\n"
"next_cfid:\n"
"while (1)\n"
"{\n"
"if (length (path_head) <= 1)\n"
"return;\n"
"cfid := coalesce ((select CF_ID from WS.WS.SYS_DAV_CATFILTER where CF_SEARCH_PATH = (path_head || \'/\')));\n"
"path_head := subseq (path_head, 0, strrchr (path_head, \'/\'));\n"
"if (cfid is not null)\n"
"goto cfid_found;\n"
"}\n"
"\n"
"cfid_found:\n"
"if (doc is null)\n"
"{\n"
"doc := deserialize (pv);\n"
"if (0 = length (doc))\n"
"return;\n"
"doc := xml_tree_doc (doc);\n"
"}\n"
"\n"
"triplets := xpath_eval (\'[xmlns:virt=\"virt\"] /virt:rdf/virt:top-res/virt:prop[virt:value]\', doc, 0);\n"
"foreach (any prop in triplets) do\n"
"{\n"
"declare propname varchar;\n"
"declare prop_catid integer;\n"
"propname := cast (xpath_eval (\'name(*[1])\', prop) as varchar);\n"
"prop_catid := coalesce ((select RPN_CATID from WS.WS.SYS_RDF_PROP_NAME where RPN_URI = propname));\n"
"if (prop_catid is null)\n"
"{\n"
"prop_catid := WS.WS.GETID (\'RPN\');\n"
"\n"
"insert into WS.WS.SYS_RDF_PROP_NAME (RPN_URI, RPN_CATID) values (propname, prop_catid);\n"
"}\n"
"if (is_del)\n"
"delete from WS.WS.SYS_DAV_RDF_INVERSE\n"
"where\n"
"(DRI_CATF_ID = cfid) and (DRI_PROP_CATID = prop_catid) and\n"
"(DRI_CATVALUE = \"CatFilter_ENCODE_CATVALUE\" (cast (xpath_eval (\'[xmlns:virt=\"virt\"] virt:value\', prop) as varchar))) and\n"
"(DRI_RES_ID = propparent);\n"
"else\n"
"insert soft WS.WS.SYS_DAV_RDF_INVERSE (DRI_CATF_ID, DRI_PROP_CATID, DRI_CATVALUE, DRI_RES_ID)\n"
"values (\n"
"cfid,\n"
"prop_catid,\n"
"\"CatFilter_ENCODE_CATVALUE\" (cast (xpath_eval (\'[xmlns:virt=\"virt\"] virt:value\', prop) as varchar)),\n"
"propparent );\n"
"}\n"
"goto next_cfid;\n"
"}\n"
"--src DET_CatFilter.sql:1835\n";

static const char *trig34 = 
"create trigger SYS_DAV_PROP_VALUE_RDF_I after insert on WS.WS.SYS_DAV_PROP order 10 referencing new as NP\n"
"{\n"
"if (NP.PROP_NAME <> \'http://local.virt/DAV-RDF\')\n"
"return;\n"
"if (NP.PROP_TYPE <> \'R\')\n"
"return;\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (NP.PROP_VALUE, NP.PROP_PARENT_ID);\n"
"}\n"
"--src DET_CatFilter.sql:1917\n";

static const char *trig35 = 
"create trigger SYS_DAV_PROP_VALUE_RDF_D before delete on WS.WS.SYS_DAV_PROP order 10 referencing old as OP\n"
"{\n"
"declare pv varchar;\n"
"declare doc any;\n"
"if (OP.PROP_NAME <> \'http://local.virt/DAV-RDF\')\n"
"return;\n"
"if (OP.PROP_TYPE <> \'R\')\n"
"return;\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (OP.PROP_VALUE, OP.PROP_PARENT_ID, 1);\n"
"}\n"
"--src DET_CatFilter.sql:1928\n";

static const char *trig36 = 
"create trigger SYS_DAV_PROP_VALUE_RDF_U after update on WS.WS.SYS_DAV_PROP order 10 referencing old as OP, new as NP\n"
"{\n"
"declare pv varchar;\n"
"declare doc any;\n"
"if (OP.PROP_NAME <> \'http://local.virt/DAV-RDF\')\n"
"goto register_new_propvals;\n"
"if (OP.PROP_TYPE <> \'R\')\n"
"goto register_new_propvals;\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (OP.PROP_VALUE, OP.PROP_PARENT_ID, 1);\n"
"\n"
"register_new_propvals:\n"
"if (NP.PROP_NAME <> \'http://local.virt/DAV-RDF\')\n"
"return;\n"
"if (NP.PROP_TYPE <> \'R\')\n"
"return;\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (NP.PROP_VALUE, NP.PROP_PARENT_ID);\n"
"}\n"
"--src DET_CatFilter.sql:1941\n";

static const char *proc393 = 
"create procedure \"CatFilter_INIT_SYS_DAV_RDF_INVERSE\" (in run_if_once integer)\n"
"{\n"
"declare ctr integer;\n"
"set isolation = \'committed\';\n"
"if (run_if_once)\n"
"{\n"
"if (0 <> sequence_next(\'CatFilter_INIT_SYS_DAV_RDF_INVERSE\'))\n"
"return;\n"
"}\n"
"else\n"
"{\n"
"\n"
"update WS.WS.SYS_RDF_SCHEMAS set RS_PRECOMPILED = null, RS_PROP_CATNAMES = null;\n"
"commit work;\n"
"delete from WS.WS.SYS_DAV_RDF_INVERSE;\n"
"}\n"
"commit work;\n"
"for (select PROP_VALUE, PROP_PARENT_ID from WS.WS.SYS_DAV_PROP where PROP_NAME = \'http://local.virt/DAV-RDF\' and PROP_TYPE = \'R\') do\n"
"{\n"
"\"CatFilter_FEED_DAV_RDF_INVERSE\" (PROP_VALUE, PROP_PARENT_ID);\n"
"ctr := ctr + 1;\n"
"if (mod (ctr, 1000) = 0)\n"
"commit work;\n"
"}\n"
"}\n"
"--src DET_CatFilter.sql:1961\n";

/* DET_HostFs.sql */

static const char *tbl1 = 
"create table WS.WS.HOSTFS_COL\n"
"(\n"
"COL_ID		integer not null primary key,\n"
"COL_FULL_PATH		varchar not null,\n"
"COL_PARENT_ID		integer,\n"
"COL_CR_TIME		datetime,\n"
"COL_MOD_TIME		datetime,\n"
"COL_SCAN_TIME		datetime,\n"
"COL_NEXT_SCAN_TIME	datetime,\n"
"COL_NAME		varchar not null\n"
")\n"
"create index HOSTFS_COL_PARENT_ID on WS.WS.HOSTFS_COL (COL_PARENT_ID)\n"
"create index HOSTFS_COL_FULL_PATH on WS.WS.HOSTFS_COL (COL_FULL_PATH)\n"
"create index HOSTFS_COL_NEXT_SCAN_TIME on WS.WS.HOSTFS_COL (COL_NEXT_SCAN_TIME)\n";

static const char *alter0 = 
"alter table WS.WS.HOSTFS_COL add COL_NAME varchar not null\n";

static const char *tbl2 = 
"create table WS.WS.HOSTFS_RES\n"
"(\n"
"RES_ID 		integer not null primary key,\n"
"RES_NAME 		varchar (256),\n"
"RES_COL 		integer,\n"
"RES_TYPE 		varchar,\n"
"RES_FT_MODE		char (1),\n"
"RES_LENGTH		integer,\n"
"RES_CR_TIME		datetime,\n"
"RES_MOD_TIME		datetime,\n"
"RES_SCAN_TIME		datetime,\n"
"RES_NEXT_SCAN_TIME	datetime,\n"
"RES_PERMS 		char (11)\n"
")\n"
"create index HOSTFS_RES_COL on WS.WS.HOSTFS_RES (RES_COL, RES_NAME)\n"
"create index HOSTFS_RES_NEXT_SCAN_TIME on WS.WS.HOSTFS_RES (RES_NEXT_SCAN_TIME)\n";

static const char *tbl3 = 
"create table WS.WS.HOSTFS_RES_CACHE\n"
"(\n"
"RESC_ID		integer not null primary key,\n"
"RESC_MOD_SCAN_TIME	datetime,\n"
"RESC_DATA		long varchar,\n"
"RESC_TOPCOL_ID	integer not null\n"
")\n"
"create index HOSTFS_RES_CACHE_TOPCOL_ID on WS.WS.HOSTFS_RES_CACHE (RESC_TOPCOL_ID)\n";

static const char *alter1 = 
"alter table WS.WS.HOSTFS_RES_CACHE add RESC_TOPCOL_ID integer not null\n";

static const char *tbl4 = 
"create table WS.WS.HOSTFS_RES_META\n"
"(\n"
"RESM_ID		integer not null primary key,\n"
"RESM_DATA		long XML,\n"
"RESM_TOPCOL_ID	integer not null\n"
")\n"
"create index HOSTFS_RES_META_TOPCOL_ID on WS.WS.HOSTFS_RES_META (RESM_TOPCOL_ID)\n";

static const char *alter2 = 
"alter table WS.WS.HOSTFS_RES_META add RESM_TOPCOL_ID integer not null\n";

static const char *tbl5 = 
"create table WS.WS.HOSTFS_RDF_INVERSE\n"
"(\n"
"HRI_TOPCOL_ID integer not null,\n"
"HRI_PROP_CATID integer not null,\n"
"HRI_CATVALUE varchar not null,\n"
"HRI_RES_ID integer not null,\n"
"primary key (HRI_TOPCOL_ID, HRI_PROP_CATID, HRI_CATVALUE, HRI_RES_ID)\n"
")\n";

static const char *proc394 = 
"create procedure WS.WS.HOSTFS_FEED_RDF_INVERSE (inout propval any, in r_id integer, in is_del integer, in topcol_id integer)\n"
"{\n"
"declare resfullpath, path_head, pv varchar;\n"
"declare triplets any;\n"
"triplets := xpath_eval (\'[xmlns:virt=\"virt\"] /virt:rdf/virt:top-res/virt:prop[virt:value]\', propval, 0);\n"
"foreach (any prop in triplets) do\n"
"{\n"
"declare propname varchar;\n"
"declare prop_catid integer;\n"
"propname := cast (xpath_eval (\'name(*[1])\', prop) as varchar);\n"
"prop_catid := coalesce ((select RPN_CATID from WS.WS.SYS_RDF_PROP_NAME where RPN_URI = propname));\n"
"if (prop_catid is null)\n"
"{\n"
"prop_catid := WS.WS.GETID (\'RPN\');\n"
"\n"
"insert into WS.WS.SYS_RDF_PROP_NAME (RPN_URI, RPN_CATID) values (propname, prop_catid);\n"
"}\n"
"if (is_del)\n"
"delete from WS.WS.HOSTFS_RDF_INVERSE\n"
"where\n"
"(HRI_TOPCOL_ID = topcol_id) and (HRI_PROP_CATID = prop_catid) and\n"
"(HRI_CATVALUE = \"CatFilter_ENCODE_CATVALUE\" (cast (xpath_eval (\'[xmlns:virt=\"virt\"] virt:value\', prop) as varchar))) and\n"
"(HRI_RES_ID = r_id);\n"
"else\n"
"insert soft WS.WS.HOSTFS_RDF_INVERSE (HRI_TOPCOL_ID, HRI_PROP_CATID, HRI_CATVALUE, HRI_RES_ID)\n"
"values (\n"
"topcol_id,\n"
"prop_catid,\n"
"\"CatFilter_ENCODE_CATVALUE\" (cast (xpath_eval (\'[xmlns:virt=\"virt\"] virt:value\', prop) as varchar)),\n"
"r_id );\n"
"}\n"
"}\n"
"--src DET_HostFs.sql:97\n";

static const char *trig37 = 
"create trigger HOSTFS_RES_META_I after insert on WS.WS.HOSTFS_RES_META referencing new as NP\n"
"{\n"
"if (NP.RESM_DATA is not null)\n"
"WS.WS.HOSTFS_FEED_RDF_INVERSE (NP.RESM_DATA, NP.RESM_ID, 0, NP.RESM_TOPCOL_ID);\n"
"}\n"
"--src DET_HostFs.sql:132\n";

static const char *trig38 = 
"create trigger HOSTFS_RES_META_D before delete on WS.WS.HOSTFS_RES_META referencing old as OP\n"
"{\n"
"if (OP.RESM_DATA is not null)\n"
"WS.WS.HOSTFS_FEED_RDF_INVERSE (OP.RESM_DATA, OP.RESM_ID, 1, OP.RESM_TOPCOL_ID);\n"
"}\n"
"--src DET_HostFs.sql:140\n";

static const char *trig39 = 
"create trigger HOSTFS_RES_META_U after update on WS.WS.HOSTFS_RES_META referencing old as OP, new as NP\n"
"{\n"
"if (OP.RESM_DATA is not null)\n"
"WS.WS.HOSTFS_FEED_RDF_INVERSE (OP.RESM_DATA, OP.RESM_ID, 1, OP.RESM_TOPCOL_ID);\n"
"if (NP.RESM_DATA is not null)\n"
"WS.WS.HOSTFS_FEED_RDF_INVERSE (NP.RESM_DATA, NP.RESM_ID, 0, NP.RESM_TOPCOL_ID);\n"
"}\n"
"--src DET_HostFs.sql:148\n";

static const char *other10 = 
"DB.DBA.vt_create_text_index (fix_identifier_case (\'WS.WS.HOSTFS_RES_META\'), fix_identifier_case (\'RESM_DATA\'), fix_identifier_case (\'RESM_ID\'), 2, 0, NULL, 0, \'*ini*\', \'*ini*\')\n";
static const char *other11 = 
"DB.DBA.vt_batch_update (fix_identifier_case (\'WS.WS.HOSTFS_RES_META\'), \'ON\', 1)\n";
static const char *proc395 = 
"create function WS.WS.HOSTFS_RES_TOPCOL_ID (in r_id integer) returns integer\n"
"{\n"
"declare res, parent integer;\n"
"whenever not found goto nf;\n"
"res := parent := (select RES_COL from WS.WS.HOSTFS_RES where RES_ID = r_id);\n"
"while (parent is not null)\n"
"{\n"
"res := parent;\n"
"parent := (select COL_PARENT_ID from WS.WS.HOSTFS_COL where COL_ID = res);\n"
"}\n"
"return res;\n"
"nf:\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:170\n";

static const char *proc396 = 
"create procedure WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (in resid integer, in resname varchar, in restype varchar, inout rescontent any, in topcol_id integer)\n"
"{\n"
"declare resttype varchar;\n"
"declare old_prop_id integer;\n"
"declare html_start, full_xml any;\n"
"declare old_n3, addon_n3 any;\n"
"\n"
"html_start := null;\n"
"full_xml := null;\n"
"\n"
"restype := DAV_GUESS_MIME_TYPE (resname, rescontent, html_start);\n"
"\n"
"if (restype is null)\n"
"return;\n"
"addon_n3 := call (\'DAV_EXTRACT_RDF_\' || restype)(resname, rescontent, html_start);\n"
"\n"
"if (addon_n3 is null)\n"
"return;\n"
"insert replacing WS.WS.HOSTFS_RES_META (RESM_ID, RESM_DATA, RESM_TOPCOL_ID)\n"
"values\n"
"(resid, xml_tree_doc (DAV_RDF_PREPROCESS_RDFXML (addon_n3, N\'http://local.virt/this\', 1)), topcol_id);\n"
"return;\n"
"\n"
"no_op:\n"
" ;\n"
"}\n"
"--src DET_HostFs.sql:186\n";

static const char *proc397 = 
"create procedure WS.WS.HOSTFS_TEST_RDF (in d_id integer)\n"
"{\n"
"\n"
"for select RES_COL, RES_NAME, RES_TYPE, RES_FT_MODE from WS.WS.HOSTFS_RES where RES_ID = d_id do\n"
"{\n"
"\n"
"if (\'N\' = RES_FT_MODE)\n"
"{\n"
"return 1;\n"
"}\n"
"else if ((\'T\' = RES_FT_MODE) or (\'X\' = RES_FT_MODE))\n"
"{\n"
"for select RESC_DATA, RESC_TOPCOL_ID from WS.WS.HOSTFS_RES_CACHE where RESC_ID = d_id do\n"
"{\n"
"WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (d_id, RES_NAME, RES_TYPE, RESC_DATA, RESC_TOPCOL_ID);\n"
"}\n"
"return 1;\n"
"}\n"
"else if ((\'t\' = RES_FT_MODE) or (\'x\' = RES_FT_MODE))\n"
"{\n"
"for select COL_FULL_PATH from WS.WS.HOSTFS_COL where COL_ID = RES_COL do\n"
"{\n"
"declare ses any;\n"
"\n"
"ses := file_to_string_output (COL_FULL_PATH || RES_NAME);\n"
"WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (d_id, RES_NAME, RES_TYPE, ses, WS.WS.HOSTFS_RES_TOPCOL_ID (d_id));\n"
"}\n"
"return 1;\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:214\n";

static const char *proc398 = 
"create function\n"
"WS.WS.HOSTFS_RES_CACHE_RESC_DATA_INDEX_HOOK (inout vtb any, inout d_id integer) returns integer\n"
"{\n"
"\n"
"whenever sqlstate \'*\' goto done;\n"
"for select RES_COL, RES_NAME, RES_TYPE, RES_FT_MODE from WS.WS.HOSTFS_RES where RES_ID = d_id do\n"
"{\n"
"\n"
"if (\'N\' = RES_FT_MODE)\n"
"{\n"
"vt_batch_feed (vtb, RES_NAME, 0, 0);\n"
"return 1;\n"
"}\n"
"else if ((\'T\' = RES_FT_MODE) or (\'X\' = RES_FT_MODE))\n"
"{\n"
"for select RESC_DATA, RESC_TOPCOL_ID from WS.WS.HOSTFS_RES_CACHE where RESC_ID = d_id do\n"
"{\n"
"vt_batch_feed (vtb, RESC_DATA, 0, case (RES_FT_MODE) when \'X\' then 2 else 0 end);\n"
"WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (d_id, RES_NAME, RES_TYPE, RESC_DATA, RESC_TOPCOL_ID);\n"
"}\n"
"return 1;\n"
"}\n"
"else if ((\'t\' = RES_FT_MODE) or (\'x\' = RES_FT_MODE))\n"
"{\n"
"for select COL_FULL_PATH from WS.WS.HOSTFS_COL where COL_ID = RES_COL do\n"
"{\n"
"declare ses any;\n"
"\n"
"ses := file_to_string_output (COL_FULL_PATH || RES_NAME);\n"
"vt_batch_feed (vtb, ses, 0, case (RES_FT_MODE) when \'x\' then 2 else 0 end);\n"
"WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF (d_id, RES_NAME, RES_TYPE, ses, WS.WS.HOSTFS_RES_TOPCOL_ID (d_id));\n"
"}\n"
"return 1;\n"
"}\n"
"}\n"
"done:\n"
"\n"
"return 1;\n"
"}\n"
"--src DET_HostFs.sql:248\n";

static const char *proc399 = 
"create function\n"
"WS.WS.HOSTFS_RES_CACHE_RESC_DATA_UNINDEX_HOOK (inout vtb any, inout d_id integer) returns integer\n"
"{\n"
"whenever sqlstate \'*\' goto done;\n"
"for select RES_COL, RES_NAME, RES_TYPE, RES_FT_MODE from WS.WS.HOSTFS_RES where RES_ID = d_id do\n"
"{\n"
"if (\'N\' = RES_FT_MODE)\n"
"{\n"
"vt_batch_feed (vtb, RES_NAME, 1, 0);\n"
"return 1;\n"
"}\n"
"else if ((\'T\' = RES_FT_MODE) or (\'X\' = RES_FT_MODE))\n"
"{\n"
"for select RESC_DATA from WS.WS.HOSTFS_RES_CACHE where RESC_ID = d_id do\n"
"vt_batch_feed (vtb, RESC_DATA, 1, case (RES_FT_MODE) when \'X\' then 2 else 0 end);\n"
"return 1;\n"
"}\n"
"}\n"
"done:\n"
"return 1;\n"
"}\n"
"--src DET_HostFs.sql:289\n";

static const char *other12 = 
"DB.DBA.vt_create_text_index (fix_identifier_case (\'WS.WS.HOSTFS_RES_CACHE\'), fix_identifier_case (\'RESC_DATA\'), fix_identifier_case (\'RESC_ID\'), 2, 0, NULL, 1, \'*ini*\', \'*ini*\')\n";
static const char *other13 = 
"DB.DBA.vt_batch_update (fix_identifier_case (\'WS.WS.HOSTFS_RES_CACHE\'), \'ON\', 5)\n";
static const char *proc400 = 
"create function\n"
"WS.WS.HOSTFS_FIND_COL (in full_path varchar) returns integer\n"
"{\n"
"declare slash_pos, parent, len, res integer;\n"
"declare parent_path, cname, tmp varchar;\n"
"declare cr_time datetime;\n"
"len := length (full_path);\n"
"if ((len > 0) and full_path[len-1] = 47)\n"
"full_path := subseq (full_path, 0, len-1);\n"
"whenever not found goto not_found;\n"
"select COL_ID into res from WS.WS.HOSTFS_COL where COL_FULL_PATH = full_path || \'/\';\n"
"return res;\n"
"not_found:\n"
"slash_pos := strrchr (full_path, \'/\');\n"
"if (slash_pos is null)\n"
"{\n"
"parent := null;\n"
"cname := full_path;\n"
"}\n"
"else\n"
"{\n"
"parent := WS.WS.HOSTFS_FIND_COL (subseq (full_path, 0, slash_pos));\n"
"cname := subseq (full_path, slash_pos + 1);\n"
"}\n"
"tmp := file_stat (full_path);\n"
"if (isstring (tmp))\n"
"cr_time := cast (tmp as datetime);\n"
"else\n"
"cr_time := null;\n"
"res := sequence_next (\'WS.WS.HOSTFS_COL_ID\') + 1;\n"
"insert into WS.WS.HOSTFS_COL\n"
"(COL_ID	, COL_FULL_PATH		, COL_PARENT_ID	, COL_CR_TIME	, COL_MOD_TIME	, COL_SCAN_TIME	, COL_NEXT_SCAN_TIME	, COL_NAME	)\n"
"values\n"
"(res	, full_path || \'/\'	, parent	, cr_time	, cr_time	, NULL		, now ()		, cname		);\n"
"return res;\n"
"}\n"
"--src DET_HostFs.sql:324\n";

static const char *proc401 = 
"create procedure\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (in full_path varchar)\n"
"{\n"
"declare len integer;\n"
"len := length (full_path);\n"
"if ((len > 0) and full_path[len-1] = 47)\n"
"full_path := subseq (full_path, 0, len-1);\n"
"for select COL_ID from WS.WS.HOSTFS_COL where COL_FULL_PATH between full_path || \'/\' and full_path || \'0\' do\n"
"{\n"
"for select RES_ID from WS.WS.HOSTFS_RES where RES_COL = COL_ID do\n"
"{\n"
"delete from WS.WS.HOSTFS_RES_META where RESM_ID = RES_ID;\n"
"delete from WS.WS.HOSTFS_RES_CACHE where RESC_ID = RES_ID;\n"
"}\n"
"delete from WS.WS.HOSTFS_RES where RES_COL = COL_ID;\n"
"}\n"
"delete from WS.WS.HOSTFS_COL where COL_FULL_PATH between full_path || \'/\' and full_path || \'0\';\n"
"}\n"
"--src DET_HostFs.sql:362\n";

static const char *proc402 = 
"create procedure\n"
"WS.WS.HOSTFS_HANDLE_RES_SCAN (in full_path varchar, in c_id integer, in flen integer, in cr_time datetime, in mod_time datetime, in mimetype varchar, in ft_mode varchar)\n"
"{\n"
"declare len, slash_pos integer;\n"
"declare r_id integer;\n"
"len := length (full_path);\n"
"if ((len = 0) or (full_path[len-1] = 47))\n"
"return;\n"
"slash_pos := strrchr (full_path, \'/\');\n"
"if (c_id is null)\n"
"{\n"
"if (slash_pos is null)\n"
"c_id := WS.WS.HOSTFS_FIND_COL (\'\');\n"
"else\n"
"c_id := WS.WS.HOSTFS_FIND_COL (subseq (full_path, 0, slash_pos));\n"
"}\n"
"r_id := coalesce ((select RES_ID from WS.WS.HOSTFS_RES where RES_NAME = subseq (full_path, slash_pos + 1) and RES_COL = c_id));\n"
"if (r_id is null)\n"
"{\n"
"r_id := sequence_next (\'WS.WS.HOSTFS_RES_ID\') + 1;\n"
"insert into WS.WS.HOSTFS_RES\n"
"(RES_ID	, RES_NAME, RES_COL, RES_TYPE, RES_FT_MODE, RES_LENGTH, RES_CR_TIME, RES_MOD_TIME, RES_SCAN_TIME, RES_NEXT_SCAN_TIME, RES_PERMS)\n"
"values\n"
"(r_id	, subseq (full_path, slash_pos + 1), c_id, mimetype, ft_mode, flen, cr_time, mod_time, now(), null, null);\n"
"\n"
"insert replacing WS.WS.HOSTFS_RES_CACHE\n"
"(RESC_ID	, RESC_MOD_SCAN_TIME	, RESC_DATA	, RESC_TOPCOL_ID			)\n"
"values\n"
"(r_id		, now()			, null		, WS.WS.HOSTFS_RES_TOPCOL_ID (r_id)	);\n"
"}\n"
"else\n"
"{\n"
"if (exists (select top 1 1 from WS.WS.HOSTFS_RES\n"
"where RES_ID = r_id and\n"
"((RES_LENGTH <> flen) or (RES_MOD_TIME <> mod_time) or (RES_TYPE <> mimetype) or (RES_FT_MODE <> ft_mode)) ) )\n"
"{\n"
"update WS.WS.HOSTFS_RES set RES_LENGTH = flen, RES_MOD_TIME = mod_time, RES_TYPE = mimetype, RES_FT_MODE = ft_mode, RES_SCAN_TIME = now() where RES_ID = r_id;\n"
"\n"
"update WS.WS.HOSTFS_RES_CACHE set RESC_MOD_SCAN_TIME = now();\n"
"}\n"
"else\n"
"{\n"
"update WS.WS.HOSTFS_RES set RES_SCAN_TIME = now() where (RES_ID = r_id) and RES_SCAN_TIME <> now ();\n"
"}\n"
"}\n"
"}\n"
"--src DET_HostFs.sql:382\n";

static const char *proc403 = 
"create procedure\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (in full_path varchar)\n"
"{\n"
"declare len, slash_pos integer;\n"
"declare c_id, r_id integer;\n"
"len := length (full_path);\n"
"if ((len = 0) or full_path[len-1] = 47)\n"
"return;\n"
"slash_pos := strrchr (full_path, \'/\');\n"
"c_id := coalesce ((select COL_ID from WS.WS.HOSTFS_COL where COL_FULL_PATH = subseq (full_path, 0, slash_pos + 1)));\n"
"if (c_id is null)\n"
"return;\n"
"r_id := coalesce ((select RES_ID from WS.WS.HOSTFS_RES where RES_NAME = subseq (full_path, slash_pos + 1) and RES_COL = c_id));\n"
"if (r_id is null)\n"
"return;\n"
"delete from WS.WS.HOSTFS_RES_CACHE where RESC_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES where RES_ID = r_id;\n"
"update WS.WS.HOSTFS_COL set COL_MOD_TIME = now() where COL_ID = c_id and COL_MOD_TIME < now();\n"
"}\n"
"--src DET_HostFs.sql:430\n";

static const char *proc404 = 
"create function\n"
"WS.WS.HOSTFS_TOUCH_RES (in ospath varchar) returns integer\n"
"{\n"
"declare mimetype, ft_mode varchar;\n"
"declare cr_time, mod_time datetime;\n"
"declare flen, rc integer;\n"
"\n"
"rc := WS.WS.HOSTFS_PATH_STAT (ospath, flen, cr_time, mod_time);\n"
"if (rc < 0)\n"
"{\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"WS.WS.HOSTFS_READ_TYPEINFO (ospath, mimetype, ft_mode);\n"
"WS.WS.HOSTFS_HANDLE_RES_SCAN (ospath, null, flen, cr_time, mod_time, mimetype, ft_mode);\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:451\n";

static const char *proc405 = 
"create procedure\n"
"WS.WS.HOSTFS_GLOBAL_RESET ()\n"
"{\n"
"set isolation = \'serializable\';\n"
"delete from WS.WS.HOSTFS_RES_META;\n"
"delete from WS.WS.HOSTFS_RES_CACHE;\n"
"delete from WS.WS.HOSTFS_RES;\n"
"delete from WS.WS.HOSTFS_COL;\n"
"sequence_set (\'WS.WS.HOSTFS_COL_ID\', 0, 0);\n"
"sequence_set (\'WS.WS.HOSTFS_RES_ID\', 0, 0);\n"
"}\n"
"--src DET_HostFs.sql:470\n";

static const char *proc406 = 
"create function\n"
"WS.WS.HOSTFS_PATH_STAT (in full_path varchar, out flen integer, out cr_time datetime, out mod_time datetime) returns integer\n"
"{\n"
"declare tmp varchar;\n"
"tmp := file_stat (full_path);\n"
"if (not isstring (tmp))\n"
"return -1;\n"
"cr_time := mod_time := cast (tmp as datetime);\n"
"flen := cast (file_stat (full_path, 1) as integer);\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:483\n";

static const char *proc407 = 
"create procedure\n"
"WS.WS.HOSTFS_READ_TYPEINFO (in full_path varchar, out mimetype varchar, out ft_mode varchar)\n"
"{\n"
"declare mt varchar;\n"
"mt := http_mime_type (full_path);\n"
"mimetype := mt;\n"
"if (\'text/html\' = mt)\n"
"ft_mode := \'x\';\n"
"else if (\'text/xml\' = mt)\n"
"ft_mode := \'x\';\n"
"else if (\'text/xhtml\' = mt)\n"
"ft_mode := \'x\';\n"
"else if (\'%+xml\' = mt)\n"
"ft_mode := \'x\';\n"
"else if (mt like \'text/%\')\n"
"ft_mode := \'t\';\n"
"else\n"
"ft_mode := \'N\';\n"
"}\n"
"--src DET_HostFs.sql:496\n";

static const char *proc408 = 
"create function \"HostFs_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"\n"
"declare puid, pgid integer;\n"
"declare pperms varchar;\n"
"if (auth_uid < 0)\n"
"return auth_uid;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'HostFs_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'HostFs\'), \'\')\n"
"), http_admin_gid() );\n"
"pperms := \'110100100RR\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"if (DAV_CHECK_PERM (pperms, req, auth_uid, null, pgid, puid))\n"
"return auth_uid;\n"
"return -13;\n"
"}\n"
"--src DET_HostFs.sql:518\n";

static const char *proc409 = 
"create function \"HostFs_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare puid, pgid integer;\n"
"declare u_password, pperms varchar;\n"
"declare allow_anon integer;\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"whenever not found goto nf_col_or_res;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'HostFs_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'HostFs\'), \'\')\n"
"), http_admin_gid() );\n"
"pperms := \'110100100RR\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"allow_anon := WS.WS.PERM_COMP (substring (cast (pperms as varchar), 7, 3), req);\n"
"if (a_uid is null)\n"
"{\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"}\n"
"if (DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"return a_uid;\n"
"return -13;\n"
"\n"
"nf_col_or_res:\n"
"return -1;\n"
"}\n"
"--src DET_HostFs.sql:539\n";

static const char *proc410 = 
"create function \"HostFs_DAV_GET_PARENT\" (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:584\n";

static const char *proc411 = 
"create function \"HostFs_DAV_COL_CREATE\" (in detcol_id any, in path_parts any, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare ospath varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"\n"
"system (sprintf (\'mkdir \'\'%s\'\'\', ospath));\n"
"WS.WS.HOSTFS_FIND_COL (ospath);\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"--src DET_HostFs.sql:591\n";

static const char *proc412 = 
"create function \"HostFs_DAV_COL_MOUNT\" (in detcol_id any, in path_parts any, in full_mount_path varchar, in mount_det varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:603\n";

static const char *proc413 = 
"create function \"HostFs_DAV_COL_MOUNT_HERE\" (in parent_id any, in full_mount_path varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:610\n";

static const char *proc414 = 
"create function \"HostFs_DAV_DELETE\" (in detcol_id any, in path_parts any, in what char(1), in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"declare ospath varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"\n"
"system (sprintf (\'rm -rf \'\'%s\'\'\', ospath));\n"
"return 1;\n"
"}\n"
"--src DET_HostFs.sql:617\n";

static const char *tbl6 = 
"create table \"HostFs_DAV_RES_UPLOAD\" (ID varchar primary key, DT datetime, CNT long varchar)\n";

static const char *proc415 = 
"create function \"HostFs_DAV_RES_UPLOAD\" (in detcol_id any, in path_parts any, inout content any, in type varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare ospath varchar;\n"
"declare rc integer;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"if (__tag (content) = 126)\n"
"{\n"
"declare p varchar;\n"
"p := \'[\' || serialize (now()) || \'][\' || serialize (detcol_id) || \'][\' || serialize (path_parts) || \']\';\n"
"insert into \"HostFs_DAV_RES_UPLOAD\" values (p, now(), content);\n"
"\n"
"string_to_file (ospath, coalesce ((select CNT from \"HostFs_DAV_RES_UPLOAD\" where ID=p), 1), -2);\n"
"}\n"
"else\n"
"string_to_file (ospath, content, -2);\n"
"rc := WS.WS.HOSTFS_TOUCH_RES (ospath);\n"
"if (rc < 0)\n"
"return -28;\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"--src DET_HostFs.sql:631\n";

static const char *proc416 = 
"create function \"HostFs_DAV_PROP_REMOVE\" (in id any, in what char(0), in propname varchar, in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:654\n";

static const char *proc417 = 
"create function \"HostFs_DAV_PROP_SET\" (in id any, in what char(0), in propname varchar, in propvalue any, in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (propname[0] = 58)\n"
"{\n"
"return -16;\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:661\n";

static const char *proc418 = 
"create function \"HostFs_DAV_PROP_GET\" (in id any, in what char(0), in propname varchar, in auth_uid integer)\n"
"{\n"
"declare ospath varchar;\n"
"ospath := id[2];\n"
"\n"
"if (not isstring (file_stat (ospath)))\n"
"{\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"return -11;\n"
"}\n"
"--src DET_HostFs.sql:672\n";

static const char *proc419 = 
"create function \"HostFs_DAV_PROP_LIST\" (in id any, in what char(0), in propmask varchar, in auth_uid integer)\n"
"{\n"
"declare ospath varchar;\n"
"ospath := id[2];\n"
"\n"
"if (not isstring (file_stat (ospath)))\n"
"{\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"return vector ();\n"
"}\n"
"--src DET_HostFs.sql:687\n";

static const char *proc420 = 
"create function \"HostFs_ID_TO_OSPATH\" (in col any)\n"
"{\n"
"declare res varchar;\n"
"declare ctr, len integer;\n"
"if (isinteger (col))\n"
"return coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = col), \' no such \');\n"
"return col[2];\n"
"}\n"
"--src DET_HostFs.sql:702\n";

static const char *proc421 = 
"create function \"HostFs_DAV_DIR_SINGLE\" (in id any, in what char(0), in path any, in auth_uid integer) returns any\n"
"{\n"
"declare fullname, name, tmp, mimetype, ft_mode varchar;\n"
"declare cr_time, mod_time datetime;\n"
"declare puid, pgid, flen, rc integer;\n"
"\n"
"fullname := id[2];\n"
"rc := WS.WS.HOSTFS_PATH_STAT (fullname, flen, cr_time, mod_time);\n"
"if (rc < 0)\n"
"{\n"
"if (\'R\' = what)\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (fullname);\n"
"else\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (fullname);\n"
"return -1;\n"
"}\n"
"name := subseq (fullname, strrchr (fullname, \'/\') + 1);\n"
"if (path is null)\n"
"path := \"HostFs_DAV_SEARCH_PATH\" (id, what);\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'HostFs_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'HostFs\'), \'\')\n"
"), puid+1);\n"
"if (\'R\' = what)\n"
"{\n"
"WS.WS.HOSTFS_READ_TYPEINFO (fullname, mimetype, ft_mode);\n"
"WS.WS.HOSTFS_HANDLE_RES_SCAN (fullname, null, flen, cr_time, mod_time, mimetype, ft_mode);\n"
"return vector (path, \'R\',	flen, mod_time, id, \'110000000RR\', pgid, puid, cr_time, mimetype, name);\n"
"}\n"
"if (\'C\' = what)\n"
"{\n"
"return vector (DAV_CONCAT_PATH (path, \'/\'), \'C\', flen, mod_time, id, \'110000000RR\', pgid, puid, cr_time, \'dav/unix-directory\', name);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:712\n";

static const char *proc422 = 
"create function \"HostFs_DAV_DIR_LIST\" (in detcol_id any, in path_parts any, in detcol_path varchar, in name_mask varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare ospath, name, fullname, top_davpath varchar;\n"
"declare stale_files, files, stale_dirs, dirs, res any;\n"
"declare ctr, len integer;\n"
"declare tmp, mimetype, ft_mode varchar;\n"
"declare cr_time, mod_time datetime;\n"
"declare puid, pgid, flen, rc, parent_c_id, r_id integer;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"top_davpath := DAV_CONCAT_PATH (detcol_path, path_parts);\n"
"whenever sqlstate \'39000\' goto no_dir;\n"
"dirs := sys_dirlist (ospath, 0);\n"
"parent_c_id := WS.WS.HOSTFS_FIND_COL (ospath);\n"
"if (parent_c_id is null)\n"
"select VECTOR_AGG (COL_FULL_PATH) into stale_dirs from WS.WS.HOSTFS_COL where COL_PARENT_ID is null and 0 = position (COL_NAME, dirs);\n"
"else\n"
"select VECTOR_AGG (COL_FULL_PATH) into stale_dirs from WS.WS.HOSTFS_COL where COL_PARENT_ID = parent_c_id and 0 = position (COL_NAME, dirs);\n"
"foreach (varchar stale_fullname in stale_dirs) do\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (stale_fullname);\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'HostFs_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = detcol_id and COL_DET=\'HostFs\'), \'\')\n"
"), puid+1);\n"
"vectorbld_init (res);\n"
"len := length (dirs);\n"
"ctr := 0;\n"
"while (ctr < len)\n"
"{\n"
"name := dirs [ctr];\n"
"if ((name <> \'.\') and (name <> \'..\'))\n"
"{\n"
"fullname := DAV_CONCAT_PATH (ospath, name);\n"
"\n"
"rc := WS.WS.HOSTFS_PATH_STAT (fullname, flen, cr_time, mod_time);\n"
"if (rc < 0)\n"
"{\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (fullname);\n"
"}\n"
"else\n"
"{\n"
"vectorbld_acc (res, vector (\n"
"DAV_CONCAT_PATH (top_davpath, name) || \'/\', \'C\',\n"
"flen,\n"
"mod_time,\n"
"vector (UNAME\'HostFs\', detcol_id, fullname),\n"
"\'110100000RR\', pgid, puid,\n"
"cr_time,\n"
"\'dav/unix-directory\',\n"
"name ) );\n"
"if (recursive > 0)\n"
"vectorbld_concat_acc (res,\n"
"\"HostFs_DAV_DIR_LIST\" (detcol_id,\n"
"vector_concat (subseq (path_parts, 0, length (path_parts)-1), vector (name, \'\')),\n"
"concat (DAV_CONCAT_PATH (detcol_path, name), \'/\'), name_mask, recursive, auth_uid) );\n"
"}\n"
"}\n"
"ctr := ctr + 1;\n"
"}\n"
"files := sys_dirlist (ospath, 1);\n"
"if (parent_c_id is null)\n"
"select VECTOR_AGG (RES_NAME) into stale_files from WS.WS.HOSTFS_RES where RES_COL is null and 0 = position (RES_NAME, files);\n"
"else\n"
"select VECTOR_AGG (RES_NAME) into stale_files from WS.WS.HOSTFS_RES where RES_COL = parent_c_id and 0 = position (RES_NAME, files);\n"
"foreach (varchar stale_name in stale_files) do\n"
"{\n"
"r_id := coalesce ((select RES_ID from WS.WS.HOSTFS_RES where RES_COL = parent_c_id and RES_NAME = stale_name));\n"
"delete from WS.WS.HOSTFS_RES_META where RESM_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES_CACHE where RESC_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES where RES_ID = r_id;\n"
"}\n"
"len := length (files);\n"
"ctr := 0;\n"
"while (ctr < len)\n"
"{\n"
"name := files [ctr];\n"
"fullname := DAV_CONCAT_PATH (ospath, name);\n"
"rc := WS.WS.HOSTFS_PATH_STAT (fullname, flen, cr_time, mod_time);\n"
"if (rc < 0)\n"
"{\n"
"delete from WS.WS.HOSTFS_RES_META where RESM_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES_CACHE where RESC_ID = r_id;\n"
"delete from WS.WS.HOSTFS_RES where RES_ID = r_id;\n"
"}\n"
"else\n"
"{\n"
"WS.WS.HOSTFS_READ_TYPEINFO (fullname, mimetype, ft_mode);\n"
"WS.WS.HOSTFS_HANDLE_RES_SCAN (fullname, parent_c_id, flen, cr_time, mod_time, mimetype, ft_mode);\n"
"if (name like name_mask)\n"
"{\n"
"\n"
"vectorbld_acc (res, vector (\n"
"DAV_CONCAT_PATH (top_davpath, name), \'R\',\n"
"flen,\n"
"mod_time,\n"
"vector (UNAME\'HostFs\', detcol_id, fullname),\n"
"\'110100000RR\', pgid, puid,\n"
"cr_time,\n"
"mimetype,\n"
"name ) );\n"
"}\n"
"}\n"
"ctr := ctr + 1;\n"
"}\n"
"update WS.WS.HOSTFS_COL set COL_MOD_TIME = now() where COL_ID = parent_c_id and COL_MOD_TIME < now();\n"
"vectorbld_final (res);\n"
"\n"
"return res;\n"
"\n"
"no_dir:\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"return vector();\n"
"}\n"
"--src DET_HostFs.sql:750\n";

static const char *proc423 = 
"create function \"HostFs_DAV_DIR_FILTER\" (in detcol_id any, in path_parts any, in detcol_path varchar, in compilation varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"--src DET_HostFs.sql:867\n";

static const char *proc424 = 
"create function \"HostFs_DAV_SEARCH_ID\" (in detcol_id any, in path_parts any, in what char(1)) returns any\n"
"{\n"
"declare ospath, stat varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"stat := file_stat (ospath, 2);\n"
"if (not isstring (stat))\n"
"{\n"
"\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"if (what = \'R\')\n"
"{\n"
"if (0 = bit_and (32768, cast (stat as integer)))\n"
"{\n"
"\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (0 = bit_and (16384, cast (stat as integer)))\n"
"{\n"
"\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"return -1;\n"
"}\n"
"}\n"
"\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"--src DET_HostFs.sql:875\n";

static const char *proc425 = 
"create function \"HostFs_DAV_SEARCH_PATH\" (in id any, in what char(1)) returns any\n"
"{\n"
"declare ospath varchar;\n"
"declare slash_pos, detcol_fullpath integer;\n"
"\n"
"ospath := id[2];\n"
"slash_pos := strchr (ospath, \'/\');\n"
"detcol_fullpath := coalesce ((select WS.WS.COL_PATH (COL_ID) from WS.WS.SYS_DAV_COL where COL_ID = id[1] and COL_DET=\'HostFs\'));\n"
"if (detcol_fullpath is null)\n"
"return -23;\n"
"if (not isstring (file_stat (ospath)))\n"
"{\n"
"WS.WS.HOSTFS_COL_DISAPPEARS (ospath);\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (ospath);\n"
"return -23;\n"
"}\n"
"return detcol_fullpath || subseq (ospath, slash_pos + 1);\n"
"}\n"
"--src DET_HostFs.sql:911\n";

static const char *proc426 = 
"create function \"HostFs_DAV_RES_UPLOAD_COPY\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare ospath varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"if (what = \'R\')\n"
"{\n"
"declare cnt any;\n"
"declare mime_type varchar;\n"
"declare rc integer;\n"
"rc := DAV_RES_CONTENT_INT (source_id, cnt, mime_type, 0, 0);\n"
"if (rc < 0)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"string_to_file (ospath, case (__tag (cnt)) when 126 then blob_to_string (cnt) else cnt end, -2);\n"
"rc := WS.WS.HOSTFS_TOUCH_RES (ospath);\n"
"if (rc < 0)\n"
"return -28;\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:931\n";

static const char *proc427 = 
"create function \"HostFs_DAV_RES_UPLOAD_MOVE\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"declare ospath, src_path varchar;\n"
"\n"
"ospath := DAV_CONCAT_PATH (\"HostFs_ID_TO_OSPATH\" (detcol_id), path_parts);\n"
"if (what = \'R\')\n"
"{\n"
"declare cnt any;\n"
"declare mime_type varchar;\n"
"declare rc integer;\n"
"rc := DAV_RES_CONTENT_INT (source_id, cnt, mime_type, 0, 0);\n"
"if (rc < 0)\n"
"{\n"
"\n"
"return rc;\n"
"}\n"
"string_to_file (ospath, case (__tag (cnt)) when 126 then blob_to_string (cnt) else cnt end, -2);\n"
"rc := WS.WS.HOSTFS_TOUCH_RES (ospath);\n"
"if (rc < 0)\n"
"return -28;\n"
"src_path := DAV_SEARCH_PATH (source_id, \'R\');\n"
"if (src_path is not null)\n"
"DAV_DELETE_INT (src_path, 1, null, null, 0);\n"
"return vector (UNAME\'HostFs\', detcol_id, ospath);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:957\n";

static const char *proc428 = 
"create function \"HostFs_DAV_RES_CONTENT\" (in id any, inout content any, out type varchar, in content_mode integer) returns integer\n"
"{\n"
"\n"
"whenever sqlstate \'*\' goto no_res;\n"
"declare ft_mode varchar;\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"content := file_to_string (id[2]);\n"
"else if (content_mode = 1)\n"
"file_append_to_string_output (id[2], content);\n"
"else if (content_mode = 3)\n"
"http_file (id[2]);\n"
"WS.WS.HOSTFS_READ_TYPEINFO (id[2], type, ft_mode);\n"
"return 0;\n"
"\n"
"no_res:\n"
"\n"
"WS.WS.HOSTFS_RES_DISAPPEARS (id[2]);\n"
"return -1;\n"
"}\n"
"--src DET_HostFs.sql:986\n";

static const char *proc429 = 
"create function \"HostFs_DAV_SYMLINK\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:1007\n";

static const char *proc430 = 
"create function \"HostFs_DAV_LOCK\" (in path any, in id any, in type char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_HostFs.sql:1014\n";

static const char *proc431 = 
"create function \"HostFs_DAV_UNLOCK\" (in id any, in type char(1), in token varchar, in auth_uid integer)\n"
"{\n"
"\n"
"return -27;\n"
"}\n"
"--src DET_HostFs.sql:1021\n";

static const char *proc432 = 
"create function \"HostFs_DAV_IS_LOCKED\" (inout id any, inout type char(1), in owned_tokens varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare orig_id any;\n"
"declare orig_type char(1);\n"
"\n"
"orig_id := id;\n"
"id := orig_id[1];\n"
"orig_type := type;\n"
"type := \'C\';\n"
"rc := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"id := orig_id;\n"
"type := orig_type;\n"
"return 0;\n"
"}\n"
"--src DET_HostFs.sql:1028\n";

static const char *proc433 = 
"create function \"HostFs_DAV_LIST_LOCKS\" (in id any, in type char(1), in recursive integer) returns any\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"--src DET_HostFs.sql:1047\n";

static const char *proc434 = 
"create procedure \"HostFs_CF_LIST_PROP_DISTVALS\" (in detcol_id integer, in cfc_id integer, in rfc_spath varchar, inout rfc_list_cond any, in schema_uri varchar, inout filter_data any, inout distval_dict any, in auth_uid integer)\n"
"{\n"
"declare topcol_name varchar;\n"
"declare topcol_id integer;\n"
"declare filter_length, p0_id, p1_id, p2_id, p3_id, p4_id, res0_id, res1_id, res2_id, res3_id, res4_id, res_last_id, res_id_max integer;\n"
"declare plast_id integer;\n"
"declare p0_val, p1_val, p2_val, p3_val, p4_val, v_last, v_max varchar;\n"
"\n"
"\n"
"declare hit_ids any;\n"
"declare c_last1 cursor for select             HRI_CATVALUE from WS.WS.HOSTFS_RDF_INVERSE\n"
"where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = plast_id and (v_max is null or HRI_CATVALUE > v_max)\n"
"\n"
"\n"
" ;\n"
"declare c_last2 cursor for select HRI_RES_ID, HRI_CATVALUE from WS.WS.HOSTFS_RDF_INVERSE\n"
"where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = plast_id and (v_max is null or HRI_CATVALUE > v_max)\n"
"\n"
"\n"
" ;\n"
"declare c0 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p0_id and HRI_CATVALUE = p0_val and HRI_RES_ID >= res_id_max;\n"
"declare c1 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p1_id and HRI_CATVALUE = p1_val and HRI_RES_ID >= res_id_max;\n"
"declare c2 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p2_id and HRI_CATVALUE = p2_val and HRI_RES_ID >= res_id_max;\n"
"declare c3 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p3_id and HRI_CATVALUE = p3_val and HRI_RES_ID >= res_id_max;\n"
"declare c4 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p4_id and HRI_CATVALUE = p4_val and HRI_RES_ID >= res_id_max;\n"
"\n"
"topcol_name := coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = detcol_id and COL_DET = \'HostFs\'));\n"
"if (topcol_name is null)\n"
"{\n"
"\n"
"return;\n"
"}\n"
"topcol_id := coalesce ((select COL_ID from WS.WS.HOSTFS_COL where COL_PARENT_ID is null and COL_NAME = topcol_name), WS.WS.HOSTFS_FIND_COL (topcol_name));\n"
"filter_length := length (filter_data);\n"
"plast_id := filter_data [filter_length - 1];\n"
"res_id_max := 0;\n"
"v_max := null;\n"
"\n"
"\n"
"\n"
"if (filter_length = 2)\n"
"{\n"
"whenever not found goto nf_c_last1;\n"
"\n"
"open c_last1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch c_last1 into v_last;\n"
"\n"
"if (v_max is null or (v_last > v_max))\n"
"{\n"
"v_max := v_last;\n"
"dict_put (distval_dict, v_last, 1);\n"
"}\n"
"}\n"
"nf_c_last1:\n"
"close c_last1;\n"
"return;\n"
"}\n"
"\n"
"res0_id := 0;\n"
"res1_id := 0;\n"
"res2_id := 0;\n"
"res3_id := 0;\n"
"res4_id := 0;\n"
"hit_ids := dict_new ();\n"
"\n"
"p0_id := filter_data [1];\n"
"p0_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [2]);\n"
"if (filter_length = 6)\n"
"{\n"
"whenever not found goto get_distincts_0;\n"
"open c0 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max)\n"
"fetch c0 into res0_id;\n"
"res_id_max := res0_id;\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"\n"
"p1_id := filter_data [4+1];\n"
"p1_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [4+2]);\n"
"if (filter_length = 10)\n"
"{\n"
"whenever not found goto get_distincts_1;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"else\n"
"res_id_max := res_id_max + 1;\n"
"\n"
"}\n"
"}\n"
"\n"
"p2_id := filter_data [8+1];\n"
"p2_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [8+2]);\n"
"if (filter_length = 14)\n"
"{\n"
"whenever not found goto get_distincts_2;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"\n"
"\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"p3_id := filter_data [12+1];\n"
"p3_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [12+2]);\n"
"if (filter_length = 18)\n"
"{\n"
"whenever not found goto get_distincts_3;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max))\n"
"{\n"
"\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"}\n"
"\n"
"p4_id := filter_data [16+1];\n"
"p4_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [16+2]);\n"
"if (filter_length = 22)\n"
"{\n"
"whenever not found goto get_distincts_4;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"open c4 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res4_id < res_id_max) fetch c4 into res4_id;\n"
"if (res4_id > res_id_max) res_id_max := res4_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max) and (res4_id = res_id_max))\n"
"dict_put (hit_ids, res_id_max, 1);\n"
"}\n"
"}\n"
"\n"
"get_distincts_4:\n"
"\n"
"close c4;\n"
"get_distincts_3:\n"
"\n"
"close c3;\n"
"get_distincts_2:\n"
"\n"
"close c2;\n"
"get_distincts_1:\n"
"\n"
"close c1;\n"
"get_distincts_0:\n"
"\n"
"close c0;\n"
"\n"
"\n"
"whenever not found goto nf_c_last2;\n"
"open c_last2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch c_last2 into res_last_id, v_last;\n"
"if (v_max is null or (v_last > v_max))\n"
"{\n"
"\n"
"if (dict_get (hit_ids, res_last_id, 0))\n"
"{\n"
"\n"
"v_max := v_last;\n"
"dict_put (distval_dict, v_last, 1);\n"
"}\n"
"}\n"
"}\n"
"nf_c_last2:\n"
"close c_last2;\n"
"}\n"
"--src DET_HostFs.sql:1054\n";

static const char *proc435 = 
"create function \"HostFs_CF_GET_RDF_HITS\" (in detcol_id integer, in cfc_id integer, in rfc_spath varchar, inout rfc_list_cond any, in schema_uri varchar, inout filter_data any, in detcol_path varchar, in make_diritems integer, in auth_uid integer) returns any\n"
"{\n"
"declare topcol_name varchar;\n"
"declare topcol_id, acc_ctr, acc_len integer;\n"
"declare filter_length, p0_id, p1_id, p2_id, p3_id, p4_id, res0_id, res1_id, res2_id, res3_id, res4_id, res_id_max integer;\n"
"declare acc any;\n"
"declare p0_val, p1_val, p2_val, p3_val, p4_val varchar;\n"
"\n"
"\n"
"declare c0 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p0_id and HRI_CATVALUE = p0_val and HRI_RES_ID >= res_id_max\n"
"\n"
"\n"
" ;\n"
"declare c1 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p1_id and HRI_CATVALUE = p1_val and HRI_RES_ID >= res_id_max;\n"
"declare c2 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p2_id and HRI_CATVALUE = p2_val and HRI_RES_ID >= res_id_max;\n"
"declare c3 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p3_id and HRI_CATVALUE = p3_val and HRI_RES_ID >= res_id_max;\n"
"declare c4 cursor for select HRI_RES_ID from WS.WS.HOSTFS_RDF_INVERSE where HRI_TOPCOL_ID = topcol_id and HRI_PROP_CATID = p4_id and HRI_CATVALUE = p4_val and HRI_RES_ID >= res_id_max;\n"
"\n"
"topcol_name := coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID = detcol_id and COL_DET = \'HostFs\'));\n"
"if (topcol_name is null)\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"topcol_id := coalesce ((select COL_ID from WS.WS.HOSTFS_COL where COL_PARENT_ID is null and COL_NAME = topcol_name), WS.WS.HOSTFS_FIND_COL (topcol_name));\n"
"filter_length := length (filter_data);\n"
"vectorbld_init (acc);\n"
"\n"
"res0_id := -1;\n"
"res1_id := -1;\n"
"res2_id := -1;\n"
"res3_id := -1;\n"
"res4_id := -1;\n"
"res_id_max := 0;\n"
"\n"
"\n"
"\n"
"\n"
"p0_id := filter_data [1];\n"
"p0_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [2]);\n"
"if (filter_length = 4)\n"
"{\n"
"whenever not found goto get_distincts_0;\n"
"open c0 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res0_id <= res_id_max)\n"
"fetch c0 into res0_id;\n"
"res_id_max := res0_id;\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"}\n"
"}\n"
"\n"
"p1_id := filter_data [4+1];\n"
"p1_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [4+2]);\n"
"if (filter_length = 8)\n"
"{\n"
"whenever not found goto get_distincts_1;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p2_id := filter_data [8+1];\n"
"p2_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [8+2]);\n"
"if (filter_length = 12)\n"
"{\n"
"whenever not found goto get_distincts_2;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p3_id := filter_data [12+1];\n"
"p3_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [12+2]);\n"
"if (filter_length = 16)\n"
"{\n"
"whenever not found goto get_distincts_3;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"p4_id := filter_data [16+1];\n"
"p4_val := \"CatFilter_ENCODE_CATVALUE\" (filter_data [16+2]);\n"
"if (filter_length = 20)\n"
"{\n"
"whenever not found goto get_distincts_4;\n"
"open c0 (prefetch 1);\n"
"open c1 (prefetch 1);\n"
"open c2 (prefetch 1);\n"
"open c3 (prefetch 1);\n"
"open c4 (prefetch 1);\n"
"while (1)\n"
"{\n"
"while (res1_id < res_id_max) fetch c1 into res1_id;\n"
"if (res1_id > res_id_max) res_id_max := res1_id;\n"
"while (res2_id < res_id_max) fetch c2 into res2_id;\n"
"if (res2_id > res_id_max) res_id_max := res2_id;\n"
"while (res3_id < res_id_max) fetch c3 into res3_id;\n"
"if (res3_id > res_id_max) res_id_max := res3_id;\n"
"while (res4_id < res_id_max) fetch c4 into res4_id;\n"
"if (res4_id > res_id_max) res_id_max := res4_id;\n"
"while (res0_id < res_id_max) fetch c0 into res0_id;\n"
"if (res0_id > res_id_max) res_id_max := res0_id;\n"
"if ((res0_id = res_id_max) and (res1_id = res_id_max) and (res2_id = res_id_max) and (res3_id = res_id_max) and (res4_id = res_id_max))\n"
"{\n"
"\n"
"vectorbld_acc (acc, res0_id);\n"
"res_id_max := res_id_max + 1;\n"
"}\n"
"}\n"
"}\n"
"\n"
"get_distincts_4:\n"
"close c4;\n"
"get_distincts_3:\n"
"close c3;\n"
"get_distincts_2:\n"
"close c2;\n"
"get_distincts_1:\n"
"close c1;\n"
"get_distincts_0:\n"
"close c0;\n"
"\n"
"finalize:\n"
"vectorbld_final (acc);\n"
"acc_len := length (acc);\n"
"acc_ctr := 0;\n"
"while (acc_ctr < acc_len)\n"
"{\n"
"declare r_id integer;\n"
"declare fullname varchar;\n"
"declare full_id, diritm any;\n"
"r_id := acc [acc_ctr];\n"
"fullname := coalesce ((select top 1 COL_FULL_PATH || RES_NAME from WS.WS.HOSTFS_RES join WS.WS.HOSTFS_COL on (RES_COL = COL_ID) where RES_ID = r_id), \'\\377\\377\\377dead\');\n"
"full_id := vector (UNAME\'HostFs\', detcol_id, fullname);\n"
"if (make_diritems = 1)\n"
"{\n"
"diritm := \"HostFs_DAV_DIR_SINGLE\" (full_id, \'R\', \'(fake path)\', auth_uid);\n"
"if (DAV_HIDE_ERROR (diritm) is not null)\n"
"{\n"
"diritm [0] := DAV_CONCAT_PATH (detcol_path, diritm[10]);\n"
"acc [acc_ctr] := diritm;\n"
"acc_ctr := acc_ctr + 1;\n"
"}\n"
"else\n"
"{\n"
"if (acc_len > 1)\n"
"{\n"
"acc [acc_ctr] := acc [acc_len - 1];\n"
"acc_len := acc_len - 1;\n"
"\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"acc [acc_ctr] := full_id;\n"
"acc_ctr := acc_ctr + 1;\n"
"}\n"
"}\n"
"if (acc_len < length (acc))\n"
"{\n"
"acc := subseq (acc, 0, acc_len);\n"
"}\n"
"\n"
"return acc;\n"
"}\n"
"--src DET_HostFs.sql:1283\n";

static const char *proc436 = 
"create procedure \"HostFs_RF_ID2SUFFIX\" (in id any, in what char(1))\n"
"{\n"
"if (what=\'C\')\n"
"{\n"
"return sprintf (\'HostDir-%d-%d\',\n"
"id[1], WS.WS.HOSTFS_FIND_COL (id[2]));\n"
"}\n"
"if (what=\'R\')\n"
"{\n"
"declare full_path varchar;\n"
"declare len, slash_pos integer;\n"
"declare r_id, c_id integer;\n"
"full_path := id[2];\n"
"len := length (full_path);\n"
"if ((len = 0) or (full_path[len-1] = 47))\n"
"r_id := 0;\n"
"else\n"
"{\n"
"slash_pos := strrchr (full_path, \'/\');\n"
"if (c_id is null)\n"
"{\n"
"if (slash_pos is null)\n"
"c_id := WS.WS.HOSTFS_FIND_COL (\'\');\n"
"else\n"
"c_id := WS.WS.HOSTFS_FIND_COL (subseq (full_path, 0, slash_pos));\n"
"}\n"
"r_id := coalesce ((select RES_ID from WS.WS.HOSTFS_RES where RES_NAME = subseq (full_path, slash_pos + 1) and RES_COL = c_id), 0);\n"
"}\n"
"return sprintf (\'HostFile-%d-%d\', id[1], r_id);\n"
"}\n"
"signal (\'OBLOM\', \'Invalid arguments for HostFs_RF_ID2SUFFIX\');\n"
"}\n"
"--src DET_HostFs.sql:1501\n";

static const char *proc437 = 
"create procedure \"HostFile_RF_SUFFIX2ID\" (in suffix varchar, in what char(1))\n"
"{\n"
"declare pairs any;\n"
"declare r_id varchar;\n"
"declare detcol_id integer;\n"
"if (\'R\' <> what)\n"
"return null;\n"
"pairs := regexp_parse (\'^([1-9][0-9]*)-([1-9][0-9]*)\\044\', suffix, 0);\n"
"if (pairs is null)\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"detcol_id := cast (subseq (suffix, pairs[2], pairs[3]) as integer);\n"
"whenever not found goto oblom;\n"
"select vector (UNAME\'HostFs\', detcol_id, COL_FULL_PATH || RES_NAME) into r_id\n"
"from WS.WS.HOSTFS_RES join WS.WS.HOSTFS_COL on (RES_COL = COL_ID)\n"
"where RES_ID = cast (subseq (suffix, pairs[4], pairs[5]) as integer);\n"
"return r_id;\n"
"oblom:\n"
"return null;\n"
"}\n"
"--src DET_HostFs.sql:1535\n";

static const char *proc438 = 
"create procedure \"HostDir_RF_SUFFIX2ID\" (in suffix varchar, in what char(1))\n"
"{\n"
"declare pairs any;\n"
"declare c_id varchar;\n"
"declare detcol_id integer;\n"
"if (\'C\' <> what)\n"
"return null;\n"
"pairs := regexp_parse (\'^([1-9][0-9]*)-([1-9][0-9]*)\\044\', suffix, 0);\n"
"if (pairs is null)\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"detcol_id := cast (subseq (suffix, pairs[2], pairs[3]) as integer);\n"
"whenever not found goto oblom;\n"
"select vector (UNAME\'HostFs\', detcol_id, COL_FULL_PATH) into c_id\n"
"from WS.WS.HOSTFS_RES join WS.WS.HOSTFS_COL on (RES_COL = COL_ID);\n"
"return c_id;\n"
"oblom:\n"
"return NULL;\n"
"}\n"
"--src DET_HostFs.sql:1559\n";

/* DET_ResFilter.sql */

static const char *proc439 = 
"create function \"ResFilter_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare spath_id integer;\n"
"\n"
"rfc_spath := null;\n"
"if (DAV_HIDE_ERROR (\"ResFilter_GET_CONDITION\" (id[1], rfc_spath, rfc_list_cond, rfc_del_action)) is null)\n"
"return -1;\n"
"if (not (\'110\' like req))\n"
"return -13;\n"
"if (\'C\' = what)\n"
"{\n"
"spath_id := DAV_SEARCH_ID (rfc_spath, \'C\');\n"
"return DAV_AUTHENTICATE (spath_id, \'C\', req, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"if (\'R\' = what)\n"
"{\n"
"return DAV_AUTHENTICATE (id [2], \'R\', req, auth_uname, auth_pwd, auth_uid);\n"
"}\n"
"return -14;\n"
"}\n"
"--src DET_ResFilter.sql:25\n";

static const char *proc440 = 
"create function \"ResFilter_NORM\" (in value any) returns varchar\n"
"{\n"
"value := blob_to_string (value);\n"
"if ((\'\' = value) or (193 <> value[0]))\n"
"return value;\n"
"value := deserialize (value)[1];\n"
"if (isstring (value))\n"
"return value;\n"
"return cast (xml_tree_doc(value) as varchar);\n"
"}\n"
"--src DET_ResFilter.sql:50\n";

static const char *proc441 = 
"create function \"ResFilter_ENCODE_FILTER\" (in filt any) returns varchar\n"
"{\n"
"if (193 <> __tag (filt))\n"
"signal (\'.....\', \'Invalid filter passed to ResFilter_ENCODE_FILTER\');\n"
"filt := serialize (filt);\n"
"filt[0] := 2;\n"
"return filt;\n"
"}\n"
"--src DET_ResFilter.sql:63\n";

static const char *proc442 = 
"create function \"ResFilter_DECODE_FILTER\" (in value any) returns any\n"
"{\n"
"value := blob_to_string (value);\n"
"if ((\'\' = value) or (value[0] <> 2))\n"
"signal (\'.....\', \'Invalid filter serialization passed to ResFilter_DECODE_FILTER\');\n"
"value [0] := 193;\n"
"return deserialize (value);\n"
"}\n"
"--src DET_ResFilter.sql:74\n";

static const char *proc443 = 
"create function \"ResFilter_GET_CONDITION\" (in detcol_id integer, out rfc_spath varchar, out rfc_list_cond any, out rfc_del_action any)\n"
"{\n"
"\n"
"whenever not found goto nf;\n"
"if (isarray (detcol_id))\n"
"return -20;\n"
"select \"ResFilter_NORM\" (PROP_VALUE) into rfc_spath from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-SearchPath\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"ResFilter_DECODE_FILTER\" (PROP_VALUE) into rfc_list_cond from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-ListCond\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"ResFilter_DECODE_FILTER\" (PROP_VALUE) into rfc_del_action from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:ResFilter-DelAction\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"return 0;\n"
"nf:\n"
"return -1;\n"
"}\n"
"--src DET_ResFilter.sql:85\n";

static const char *proc444 = 
"create procedure \"ResFilter_FIT_INTO_CONDITION\" (in id any, in what char (1), inout rfc_list_cond any, in auth_uid integer)\n"
"{\n"
"\n"
"declare has_rdf_preds integer;\n"
"declare raw_filter any;\n"
"has_rdf_preds := 0;\n"
"raw_filter := get_keyword (\'\', rfc_list_cond);\n"
"foreach (any pred in raw_filter) do\n"
"{\n"
"declare propid integer;\n"
"declare old_value, pred_name, pred_cmp varchar;\n"
"pred_name := pred [0];\n"
"pred_cmp := pred [1];\n"
"if ((\'PROP_VALUE\' = pred_name) and (\'=\' = pred_cmp))\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"call (cast (id[0] as varchar) || \'_DAV_PROP_SET\')(id, what, pred[3], pred[2], 1, auth_uid);\n"
"goto next_pred;\n"
"}\n"
"whenever not found goto ins_prop;\n"
"select p.PROP_ID, \"ResFilter_NORM\" (p.PROP_VALUE) into propid, old_value from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r where p.PROP_NAME = pred[3] and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id;\n"
"if (old_value <> pred[2])\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = pred[2] where PROP_ID = propid;\n"
"goto next_pred;\n"
"ins_prop:\n"
"propid := WS.WS.GETID (\'P\');\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_VALUE, PROP_PARENT_ID, PROP_TYPE)\n"
"values (propid, pred[3], pred[2], id, what);\n"
"goto next_pred;\n"
"}\n"
"if ((\'PROP_VALUE\' = pred_name) and (\'<>\' = pred_cmp))\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\')(id, what, pred[3], 1, auth_uid);\n"
"goto next_pred;\n"
"}\n"
"whenever not found goto next_pred;\n"
"select p.PROP_ID into propid from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r where p.PROP_NAME = pred[3] and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id and \"ResFilter_NORM\" (p.PROP_VALUE) = pred[2];\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_ID = propid;\n"
"goto next_pred;\n"
"}\n"
"if ((\'PROP_NAME\' = pred_name) and (\'not_exists\' = pred_cmp))\n"
"{\n"
"if (isarray (id))\n"
"{\n"
"call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\')(id, what, pred[3], 1, auth_uid);\n"
"goto next_pred;\n"
"}\n"
"whenever not found goto next_pred;\n"
"select p.PROP_ID into propid from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r where p.PROP_NAME = pred[2] and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id;\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_ID = propid;\n"
"goto next_pred;\n"
"}\n"
"else if ((\'RDF_VALUE\' = pred_name) and ((\'=\' = pred_cmp) or (\'<>\' = pred_cmp)) and (5 = length (pred)) and (\'http://local.virt/DAV-RDF\' = pred [3]))\n"
"{\n"
"has_rdf_preds := 1;\n"
"goto next_pred;\n"
"}\n"
"else if ((\'RDF_PRED\' = pred_name) and (\'not_exists\' = pred_cmp) and (4 = length (pred)) and (\'http://local.virt/DAV-RDF\' = pred [3]))\n"
"{\n"
"has_rdf_preds := 1;\n"
"goto next_pred;\n"
"}\n"
"else\n"
"{\n"
"\n"
"signal (\'.....\', \'Unsupported predicate in ResFilter_FIT_INTO_CONDITION\');\n"
"}\n"
"next_pred: ;\n"
"}\n"
"if (has_rdf_preds)\n"
"{\n"
"declare propid integer;\n"
"declare old_prop, old_n3, acc_n3, new_n3, new_davxml any;\n"
"declare top_path nvarchar;\n"
"top_path := cast (DAV_SEARCH_PATH (id, what) as nvarchar);\n"
"xte_nodebld_init (acc_n3);\n"
"foreach (any pred in raw_filter) do\n"
"{\n"
"declare pred_name, pred_cmp varchar;\n"
"pred_name := pred [0];\n"
"pred_cmp := pred [1];\n"
"if ((\'RDF_VALUE\' = pred_name) and (\'=\' = pred_cmp))\n"
"{\n"
"xte_nodebld_acc (acc_n3,\n"
"xte_node (\n"
"xte_head (\'N3\', \'N3S\', top_path, \'N3P\', pred [4]),\n"
"pred [2] ) );\n"
"}\n"
"}\n"
"xte_nodebld_final (acc_n3, xte_head (\' root\'));\n"
"acc_n3 := xml_tree_doc (acc_n3);\n"
"old_n3 := null;\n"
"propid := null;\n"
"if (isarray (id))\n"
"{\n"
"old_prop := call (cast (id[0] as varchar) || \'_DAV_PROP_GET\')(id, what, \'http://local.virt/DAV-RDF\', auth_uid);\n"
"if (DAV_HIDE_ERROR (old_prop) is null)\n"
"{\n"
"goto do_merge;\n"
"}\n"
"if (isentity (old_prop))\n"
"{\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', old_prop);\n"
"goto do_merge;\n"
"}\n"
"goto old_prop_found;\n"
"}\n"
"whenever not found goto do_merge;\n"
"select p.PROP_ID, blob_to_string (p.PROP_VALUE) into propid, old_prop\n"
"from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r\n"
"where p.PROP_NAME = \'http://local.virt/DAV-RDF\' and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id;\n"
"goto do_merge;\n"
"old_prop_found:\n"
"old_prop := deserialize (cast (old_prop as varchar));\n"
"old_n3 := xslt (\'http://local.virt/davxml2n3xml\', xml_tree_doc (old_prop));\n"
"do_merge:\n"
"new_n3 := DAV_RDF_MERGE (old_n3, acc_n3, null, -1);\n"
"foreach (any pred in raw_filter) do\n"
"{\n"
"declare pred_name, pred_cmp varchar;\n"
"pred_name := pred [0];\n"
"pred_cmp := pred [1];\n"
"if ((\'RDF_PRED\' = pred_name) and (\'<>\' = pred_cmp))\n"
"{\n"
"new_n3 := XMLUpdate (new_n3, \'/N3[N3P=\' || WS.WS.STR_SQL_APOS (pred[4]) || \'][string (.) =\' || WS.WS.STR_SQL_APOS (pred[2]) || \']\', null);\n"
"}\n"
"else\n"
"if ((\'RDF_PRED\' = pred_name) and (\'not_exists\' = pred_cmp))\n"
"{\n"
"new_n3 := XMLUpdate (new_n3, \'/N3[N3P=\' || WS.WS.STR_SQL_APOS (pred[2]) || \']\', null);\n"
"}\n"
"}\n"
"new_davxml := DAV_RDF_PREPROCESS_RDFXML (new_n3, top_path, 1);\n"
"if (isarray (id))\n"
"{\n"
"call (cast (id[0] as varchar) || \'_DAV_PROP_SET\')(id, what, \'http://local.virt/DAV-RDF\', new_davxml, 1, auth_uid);\n"
"goto next_pred;\n"
"}\n"
"else if (propid is null)\n"
"{\n"
"propid := WS.WS.GETID (\'P\');\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_VALUE, PROP_PARENT_ID, PROP_TYPE)\n"
"values (propid, \'http://local.virt/DAV-RDF\', serialize (new_davxml), id, what);\n"
"}\n"
"else\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = serialize (new_davxml) where PROP_ID = propid;\n"
"}\n"
"}\n"
"--src DET_ResFilter.sql:101\n";

static const char *proc445 = 
"create function \"ResFilter_MAKE_DEL_ACTION_FROM_CONDITION\" (inout rfc_list_cond any) returns any\n"
"{\n"
"\n"
"declare raw_filter, res any;\n"
"res := vector ();\n"
"raw_filter := get_keyword (\'\', rfc_list_cond);\n"
"foreach (any pred in raw_filter) do\n"
"{\n"
"declare propid integer;\n"
"declare old_value, pred_name, pred_cmp varchar;\n"
"pred_name := pred [0];\n"
"pred_cmp := pred [1];\n"
"if ((\'PROP_VALUE\' = pred_name) and (\'=\' = pred_cmp))\n"
"{\n"
"res := vector_concat (res, vector (vector (\'PROP_VALUE\', \'<>\', pred[2], pred [3])));\n"
"}\n"
"else if ((\'PROP_VALUE\' = pred_name) and (\'<>\' = pred_cmp))\n"
"{\n"
"res := vector_concat (res, vector (vector (\'PROP_VALUE\', \'=\', pred[2], pred [3])));\n"
"}\n"
"else if ((\'RDF_VALUE\' = pred_name) and (\'=\' = pred_cmp) and (5 = length (pred)) and (\'http://local.virt/DAV-RDF\' = pred [3]))\n"
"{\n"
"res := vector_concat (res, vector (vector (\'RDF_VALUE\', \'<>\', pred [2], \'http://local.virt/DAV-RDF\', pred [4])));\n"
"}\n"
"else if ((\'RDF_VALUE\' = pred_name) and (\'<>\' = pred_cmp) and (5 = length (pred)) and (\'http://local.virt/DAV-RDF\' = pred [3]))\n"
"{\n"
"res := vector_concat (res, vector (vector (\'RDF_VALUE\', \'=\', pred [2], \'http://local.virt/DAV-RDF\', pred [4])));\n"
"}\n"
"else return vector ();\n"
"}\n"
"return vector (\'\', res);\n"
"}\n"
"--src DET_ResFilter.sql:255\n";

static const char *proc446 = 
"create function \"ResFilter_LEAVE_CONDITION\" (in id integer, in what char (1), in rfc_del_action any, in auth_uid integer) returns integer\n"
"{\n"
"\"ResFilter_FIT_INTO_CONDITION\" (id, what, rfc_del_action, auth_uid);\n"
"return 0;\n"
"}\n"
"--src DET_ResFilter.sql:290\n";

static const char *proc447 = 
"create function \"ResFilter_FNMERGE\" (in path any, in id any) returns varchar\n"
"{\n"
"declare pairs any;\n"
"declare res varchar;\n"
"pairs := regexp_parse (\'^(.*[/])?([^/][^./]*)([^/]*)\\044\', path, 0);\n"
"if (pairs is null)\n"
"signal (\'.....\', sprintf (\'Internal error: failed \"ResFilter_FNMERGE\" (%s, %d)\', path, id));\n"
"if (isinteger (id))\n"
"return sprintf (\'%s -RfId%d%s\', subseq (path, 0, pairs[5]), id, subseq (path, pairs[6]));\n"
"id[0] := cast (id[0] as varchar);\n"
"res := sprintf (\'%s -Rf%s%s\',\n"
"subseq (path, 0, pairs[5]),\n"
"call (cast (id[0] as varchar) || \'_RF_ID2SUFFIX\')(id, \'R\'),\n"
"subseq (path, pairs[6]) );\n"
"\n"
"return res;\n"
"}\n"
"--src DET_ResFilter.sql:298\n";

static const char *proc448 = 
"create procedure \"ResFilter_FNSPLIT\" (in path any, out colpath varchar, out orig_fnameext varchar, out id any)\n"
"{\n"
"declare pairs any;\n"
"declare fname, fext varchar;\n"
"\n"
"pairs := regexp_parse (\'^(.*[/])?([^/][^./]*)([^/]*)\\044\', path, 0);\n"
"if (pairs is null)\n"
"signal (\'.....\', sprintf (\'Internal error: failed \"ResFilter_FNSPLIT\" (%s)\', path));\n"
"colpath := subseq (path, 0, pairs[4]);\n"
"fname := subseq (path, pairs[4], pairs[5]);\n"
"fext := subseq (path, pairs[6], pairs[7]);\n"
"\n"
"pairs := regexp_parse (\'^(.*) -RfId([1-9][0-9]*)\\044\', fname, 0);\n"
"if (pairs is not null)\n"
"{\n"
"orig_fnameext := subseq (fname, pairs[2], pairs[3]) || fext;\n"
"id := cast (subseq (fname, pairs[4], pairs[5]) as integer);\n"
"\n"
"return;\n"
"}\n"
"pairs := regexp_parse (\'^(.*) -Rf([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*)\\044\', fname, 0);\n"
"if (pairs is not null)\n"
"{\n"
"whenever sqlstate \'*\' goto oblom;\n"
"orig_fnameext := subseq (fname, pairs[2], pairs[3]) || fext;\n"
"id := call (subseq (fname, pairs[4], pairs[5]) || \'_RF_SUFFIX2ID\')(subseq (fname, pairs[6], pairs[7]), \'R\');\n"
"\n"
"return;\n"
"}\n"
"oblom:\n"
"orig_fnameext := fname || fext;\n"
"id := null;\n"
"\n"
"}\n"
"--src DET_ResFilter.sql:318\n";

static const char *proc449 = 
"create function \"ResFilter_DAV_SEARCH_ID_IMPL\" (in detcol_id any, in path_parts any, in what char(1), inout rfc_spath varchar, inout rfc_list_cond any, inout rfc_del_action any) returns any\n"
"{\n"
"declare colpath, orig_fnameext varchar;\n"
"declare orig_id any;\n"
"declare hitlist any;\n"
"declare ext_cond any;\n"
"\n"
"if (\'R\' <> what)\n"
"return -1;\n"
"if (not (isstring (rfc_spath)))\n"
"{\n"
"if (0 > \"ResFilter_GET_CONDITION\" (detcol_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"}\n"
"if (1 <> length(path_parts) or (\'\' = path_parts[0]))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"\"ResFilter_FNSPLIT\" (path_parts[0], colpath, orig_fnameext, orig_id);\n"
"\n"
"if (orig_id is null)\n"
"{\n"
"ext_cond := vector (vector (\'RES_NAME\', \'=\', orig_fnameext));\n"
"}\n"
"else\n"
"{\n"
"if (isinteger (orig_id))\n"
"ext_cond := vector (vector (\'RES_NAME\', \'=\', orig_fnameext), vector (\'RES_ID\', \'=\', orig_id));\n"
"else\n"
"ext_cond := vector (vector (\'RES_NAME\', \'=\', orig_fnameext), vector (\'RES_ID_SERIALIZED\', \'=\', serialize (orig_id)));\n"
"}\n"
"ext_cond := vector (\'\',\n"
"vector_concat (ext_cond, get_keyword (\'\', rfc_list_cond) ) );\n"
"hitlist := DAV_DIR_FILTER_INT (rfc_spath, 1, ext_cond, null, null, http_dav_uid ());\n"
"\n"
"if (length (hitlist) <> 1)\n"
"return -1;\n"
"return hitlist[0][4];\n"
"}\n"
"--src DET_ResFilter.sql:355\n";

static const char *proc450 = 
"create function \"ResFilter_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare puid, pgid, ruid, rgid integer;\n"
"declare u_password, pperms varchar;\n"
"declare allow_anon integer;\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"whenever not found goto nf_col_or_res;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'ResFilter_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'ResFilter\'), \'\')\n"
"), puid+1);\n"
"pperms := \'110100100NN\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"allow_anon := WS.WS.PERM_COMP (substring (cast (pperms as varchar), 7, 3), req);\n"
"if (a_uid is null)\n"
"{\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := 0;\n"
"a_gid := 0;\n"
"}\n"
"}\n"
"if (not DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"return -13;\n"
"\n"
"if (isarray (id[2]))\n"
"return -1;\n"
"select RES_OWNER, RES_GROUP into ruid, rgid from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"if (not DAV_CHECK_PERM (pperms, req, a_uid, a_gid, rgid, ruid))\n"
"return -13;\n"
"\n"
"return a_uid;\n"
"\n"
"nf_col_or_res:\n"
"return -1;\n"
"}\n"
"--src DET_ResFilter.sql:401\n";

static const char *proc451 = 
"create function \"ResFilter_DAV_GET_PARENT\" (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"\n"
"if (st = \'R\')\n"
"return id [1];\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:454\n";

static const char *proc452 = 
"create function \"ResFilter_DAV_COL_CREATE\" (in detcol_id any, in path_parts any, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:464\n";

static const char *proc453 = 
"create function \"ResFilter_DAV_COL_MOUNT\" (in detcol_id any, in path_parts any, in full_mount_path varchar, in mount_det varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:472\n";

static const char *proc454 = 
"create function \"ResFilter_DAV_COL_MOUNT_HERE\" (in parent_id any, in full_mount_path varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:480\n";

static const char *proc455 = 
"create function \"ResFilter_DAV_DELETE\" (in detcol_id any, in path_parts any, in what char(1), in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"declare rc, orig_id integer;\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"\n"
"rfc_spath := null;\n"
"orig_id := \"ResFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, rfc_spath, rfc_list_cond, rfc_del_action);\n"
"if (orig_id < 0)\n"
"return orig_id;\n"
"if (0 = length (rfc_del_action))\n"
"return -20;\n"
"return \"ResFilter_LEAVE_CONDITION\" (orig_id, what, rfc_del_action, auth_uid);\n"
"}\n"
"--src DET_ResFilter.sql:488\n";

static const char *proc456 = 
"create function \"ResFilter_DAV_RES_UPLOAD\" (in detcol_id any, in path_parts any, inout content any, in type varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:504\n";

static const char *proc457 = 
"create function \"ResFilter_DAV_PROP_REMOVE\" (in id any, in st char(0), in propname varchar, in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"\n"
"if (st <> \'R\')\n"
"return -1;\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\') (id, st, propname, silent, auth_uid);\n"
"return DAV_PROP_REMOVE_RAW (id, st, propname, silent, auth_uid);\n"
"}\n"
"--src DET_ResFilter.sql:512\n";

static const char *proc458 = 
"create function \"ResFilter_DAV_PROP_SET\" (in id any, in st char(0), in propname varchar, in propvalue any, in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"declare pid integer;\n"
"declare resv any;\n"
"\n"
"if (st <> \'R\')\n"
"return -1;\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_SET\') (id, st, propname, propvalue, overwrite, auth_uid);\n"
"return DAV_PROP_SET_RAW (id, st, propname, propvalue, overwrite, auth_uid);\n"
"}\n"
"--src DET_ResFilter.sql:525\n";

static const char *proc459 = 
"create function \"ResFilter_DAV_PROP_GET\" (in id any, in what char(0), in propname varchar, in auth_uid integer)\n"
"{\n"
"declare ret varchar;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"if (propname[0] = 58)\n"
"return DAV_PROP_GET_INT (id, what, propname, 0, null, null, auth_uid);\n"
"whenever not found goto no_prop;\n"
"select blob_to_string (PROP_VALUE) into ret from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = what;\n"
"return ret;\n"
"\n"
"no_prop:\n"
"return -11;\n"
"}\n"
"--src DET_ResFilter.sql:540\n";

static const char *proc460 = 
"create function \"ResFilter_DAV_PROP_LIST\" (in id any, in what char(0), in propmask varchar, in auth_uid integer)\n"
"{\n"
"declare ret any;\n"
"\n"
"id := id[2];\n"
"vectorbld_init (ret);\n"
"for select PROP_NAME, PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME like propmask and PROP_PARENT_ID = id and PROP_TYPE = what do {\n"
"vectorbld_acc (ret, vector (PROP_NAME, blob_to_string (PROP_VALUE)));\n"
"}\n"
"vectorbld_final (ret);\n"
"return ret;\n"
"}\n"
"--src DET_ResFilter.sql:559\n";

static const char *proc461 = 
"create function \"ResFilter_DAV_DIR_SINGLE\" (in id any, in what char(0), in path any, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (\'R\' <> what)\n"
"return -1;\n"
"for select RES_FULL_PATH, RES_ID, length (RES_CONTENT) as clen, RES_MOD_TIME,\n"
"RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME as r1_RES_NAME\n"
"from WS.WS.SYS_DAV_RES r1\n"
"where RES_ID = id[2]\n"
"do\n"
"{\n"
"declare merged varchar;\n"
"\n"
"if (regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', r1_RES_NAME, 0))\n"
"{\n"
"merged := \"ResFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"}\n"
"else\n"
"{\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action varchar;\n"
"declare tmp_comp, namesakes any;\n"
"declare namesakes_no integer;\n"
"if (0 > \"ResFilter_GET_CONDITION\" (id[1], rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"tmp_comp := vector (\'\',\n"
"vector_concat (\n"
"vector (vector (\'RES_NAME\', \'=\', r1_RES_NAME)),\n"
"get_keyword (\'\', rfc_list_cond) ) );\n"
"namesakes := DAV_DIR_FILTER_INT (rfc_spath, 1, tmp_comp, null, null, auth_uid);\n"
"namesakes_no := length (namesakes);\n"
"if (0 = namesakes_no)\n"
"return -1;\n"
"if (1 < namesakes_no)\n"
"merged := \"ResFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"else\n"
"merged := r1_RES_NAME;\n"
"}\n"
"\n"
"return vector (DAV_CONCAT_PATH (DAV_SEARCH_PATH (id[1], \'C\'), merged), \'R\', clen, RES_MOD_TIME,\n"
"\n"
"id, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, merged);\n"
"}\n"
"return -1;\n"
"}\n"
"--src DET_ResFilter.sql:574\n";

static const char *proc462 = 
"create function \"ResFilter_DAV_DIR_LIST\" (in detcol_id any, in path_parts any, in detcol_path varchar, in name_mask varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_dec_action any;\n"
"declare davpath, prev_raw_name varchar;\n"
"declare res, itm, reps any;\n"
"declare itm_ctr, itm_count, prev_is_patched integer;\n"
"\n"
"if (0 > \"ResFilter_GET_CONDITION\" (detcol_id, rfc_spath, rfc_list_cond, rfc_dec_action))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"if (1 <> length(path_parts) or (\'\' <> path_parts[0]))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"if (\'%\' = name_mask)\n"
"res := DAV_DIR_FILTER_INT (rfc_spath, 1, rfc_list_cond, null, null, auth_uid);\n"
"else\n"
"{\n"
"declare tmp_cond any;\n"
"tmp_cond := vector (\'\',\n"
"vector_concat (\n"
"vector (vector (\'RES_NAME\', \'like\', name_mask)),\n"
"get_keyword (\'\', rfc_list_cond) ) );\n"
"res := DAV_DIR_FILTER_INT (rfc_spath, 1, tmp_cond, null, null, auth_uid);\n"
"}\n"
"reps := dict_new ();\n"
"itm_count := length (res);\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"itm := res [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"if (regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', rname, 0))\n"
"res [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"dict_put (reps, rname, dict_get (reps, rname, 0) + 1);\n"
"}\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"itm := res [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"res[itm_ctr][4] := vector (UNAME\'ResFilter\', detcol_id, orig_id);\n"
"if (dict_get (reps, rname, 0) > 1)\n"
"res [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"res[itm_ctr][0] := DAV_CONCAT_PATH (detcol_path, rname);\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_ResFilter.sql:625\n";

static const char *proc463 = 
"create function \"ResFilter_DAV_DIR_FILTER\" (in detcol_id any, in path_parts any, in detcol_path varchar, inout compilation any, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_dec_action any;\n"
"declare davpath, prev_raw_name varchar;\n"
"declare res, itm, reps any;\n"
"declare itm_ctr, itm_count, prev_is_patched integer;\n"
"\n"
"if (0 > \"ResFilter_GET_CONDITION\" (detcol_id, rfc_spath, rfc_list_cond, rfc_dec_action))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"if (1 <> length(path_parts) or (\'\' <> path_parts[0]))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"if (0 = length (get_keyword (\'\', compilation)))\n"
"res := DAV_DIR_FILTER_INT (rfc_spath, 1, rfc_list_cond, null, null, auth_uid);\n"
"else\n"
"{\n"
"declare tmp_cond any;\n"
"tmp_cond := vector (\'\',\n"
"vector_concat (\n"
"get_keyword (\'\', compilation),\n"
"get_keyword (\'\', rfc_list_cond) ) );\n"
"res := DAV_DIR_FILTER_INT (rfc_spath, 1, tmp_cond, null, null, auth_uid);\n"
"}\n"
"reps := dict_new ();\n"
"itm_count := length (res);\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"itm := res [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"if (regexp_parse (\'^([^/][^./]*) -Rf((Id[1-9][0-9]*)|([A-Z][A-Za-z0-9]+)-([A-Za-z0-9~+-]*))([.][^/]*)?\\044\', rname, 0))\n"
"res [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"dict_put (reps, rname, dict_get (reps, rname, 0) + 1);\n"
"}\n"
"for (itm_ctr := 0; itm_ctr < itm_count; itm_ctr := itm_ctr + 1)\n"
"{\n"
"declare rname varchar;\n"
"declare orig_id integer;\n"
"itm := res [itm_ctr];\n"
"rname := itm [10];\n"
"orig_id := itm[4];\n"
"res[itm_ctr][4] := vector (UNAME\'ResFilter\', detcol_id, orig_id);\n"
"if (dict_get (reps, rname, 0) > 1)\n"
"res [itm_ctr][10] := rname := \"ResFilter_FNMERGE\" (rname, orig_id);\n"
"res[itm_ctr][0] := DAV_CONCAT_PATH (detcol_path, rname);\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_ResFilter.sql:684\n";

static const char *proc464 = 
"create function \"ResFilter_DAV_SEARCH_ID\" (in detcol_id any, in path_parts any, in what char(1)) returns any\n"
"{\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare orig_id integer;\n"
"\n"
"rfc_spath := null;\n"
"orig_id := \"ResFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, rfc_spath, rfc_list_cond, rfc_del_action);\n"
"if (orig_id < 0)\n"
"return orig_id;\n"
"return vector (UNAME\'ResFilter\', detcol_id, orig_id);\n"
"}\n"
"--src DET_ResFilter.sql:743\n";

static const char *proc465 = 
"create function \"ResFilter_DAV_SEARCH_PATH\" (in id any, in what char(1)) returns any\n"
"{\n"
"\n"
"return coalesce ((select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_ID = id[2]), null);\n"
"}\n"
"--src DET_ResFilter.sql:758\n";

static const char *proc466 = 
"create function \"ResFilter_DAV_RES_UPLOAD_COPY\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare rc integer;\n"
"\n"
"if (0 > \"ResFilter_GET_CONDITION\" (detcol_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -2;\n"
"}\n"
"if (0 = length (rfc_del_action))\n"
"return -20;\n"
"if (1 <> length (path_parts))\n"
"return -2;\n"
"if (\'R\' <> what)\n"
"return -2;\n"
"if (\'\' = path_parts[0])\n"
"return -2;\n"
"if (isinteger (source_id) and\n"
"exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_ID = source_id and RES_NAME = path_parts[0] and (RES_FULL_PATH between rfc_spath and DAV_COL_PATH_BOUNDARY (rfc_spath)) ) )\n"
"{\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, rfc_list_cond, auth_uid);\n"
"}\n"
"else\n"
"{\n"
"declare new_full_path varchar;\n"
"new_full_path := DAV_CONCAT_PATH (rfc_spath, path_parts[0]);\n"
"rc := DAV_COPY_INT (DAV_SEARCH_PATH (source_id, what), new_full_path, overwrite, permissions,\n"
"coalesce ((select U_NAME from WS.WS.SYS_DAV_USER where U_ID = uid), \'\'),\n"
"coalesce ((select G_NAME from WS.WS.SYS_DAV_GROUP where G_ID = gid), \'\'),\n"
"null, null, 0);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"source_id := DAV_SEARCH_ID (new_full_path, what);\n"
"if (DAV_HIDE_ERROR (source_id) is null)\n"
"return source_id;\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, rfc_list_cond, auth_uid);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_ResFilter.sql:766\n";

static const char *proc467 = 
"create function \"ResFilter_DAV_RES_UPLOAD_MOVE\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"declare rfc_spath varchar;\n"
"declare rfc_list_cond, rfc_del_action any;\n"
"declare rc integer;\n"
"\n"
"if (0 > \"ResFilter_GET_CONDITION\" (detcol_id, rfc_spath, rfc_list_cond, rfc_del_action))\n"
"{\n"
"\n"
"return -2;\n"
"}\n"
"if (0 = length (rfc_del_action))\n"
"return -20;\n"
"if (1 <> length (path_parts))\n"
"return -2;\n"
"if (\'R\' <> what)\n"
"return -2;\n"
"if (\'\' = path_parts[0])\n"
"return -2;\n"
"if (isinteger (source_id) and\n"
"exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_ID = source_id and RES_NAME = path_parts[0] and (RES_FULL_PATH between rfc_spath and DAV_COL_PATH_BOUNDARY (rfc_spath))))\n"
"{\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, rfc_list_cond, auth_uid);\n"
"}\n"
"else\n"
"{\n"
"declare new_full_path varchar;\n"
"new_full_path := DAV_CONCAT_PATH (rfc_spath, path_parts[0]);\n"
"rc := DAV_MOVE_INT (DAV_SEARCH_PATH (source_id, what), new_full_path, overwrite, null, null, 0, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"source_id := DAV_SEARCH_ID (new_full_path, what);\n"
"if (DAV_HIDE_ERROR (source_id) is null)\n"
"return source_id;\n"
"\"ResFilter_FIT_INTO_CONDITION\" (source_id, what, rfc_list_cond, auth_uid);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_ResFilter.sql:811\n";

static const char *proc468 = 
"create function \"ResFilter_DAV_RES_CONTENT\" (in id any, inout content any, out type varchar, in content_mode integer) returns integer\n"
"{\n"
"\n"
"declare cont any;\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"select RES_CONTENT, RES_TYPE into content, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"else if (content_mode = 1)\n"
"select http (RES_CONTENT, content), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"else if (content_mode = 3)\n"
"select http (RES_CONTENT), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"return id[2];\n"
"}\n"
"--src DET_ResFilter.sql:853\n";

static const char *proc469 = 
"create function \"ResFilter_DAV_SYMLINK\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:868\n";

static const char *proc470 = 
"create function \"ResFilter_DAV_LOCK\" (in path any, in id any, in type char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid integer) returns any\n"
"{\n"
"declare rc, u_token, new_token varchar;\n"
"\n"
"if (\'R\' <> type)\n"
"return -20;\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return -20;\n"
"if (isarray (id))\n"
"return DAV_LOCK_INT (path, id[2], type, locktype, scope, token, owner_name, owned_tokens, depth, timeout_sec, null, null, auth_uid);\n"
"return -20;\n"
"}\n"
"--src DET_ResFilter.sql:876\n";

static const char *proc471 = 
"create function \"ResFilter_DAV_UNLOCK\" (in id any, in type char(1), in token varchar, in auth_uid integer)\n"
"{\n"
"\n"
"if (isarray (id))\n"
"id := id [2];\n"
"return DAV_UNLOCK_INT (id, type, token, null, null, auth_uid);\n"
"}\n"
"--src DET_ResFilter.sql:891\n";

static const char *proc472 = 
"create function \"ResFilter_DAV_IS_LOCKED\" (inout id any, inout type char(1), in owned_tokens varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare orig_id any;\n"
"declare orig_type char(1);\n"
"\n"
"orig_id := id;\n"
"id := orig_id[2];\n"
"rc := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"id := orig_id[1];\n"
"orig_type := type;\n"
"type := \'C\';\n"
"rc := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"id := orig_id;\n"
"type := orig_type;\n"
"return 0;\n"
"}\n"
"--src DET_ResFilter.sql:901\n";

static const char *proc473 = 
"create function \"ResFilter_DAV_LIST_LOCKS\" (in id any, in type char(1), in recursive integer) returns any\n"
"{\n"
"declare res any;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_LIST_LOCKS\') (id, type, recursive);\n"
"res := vector();\n"
"for select LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO\n"
"from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = type do {\n"
"res := vector_concat (res, vector (vector (LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO)));\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_ResFilter.sql:925\n";

static const char *proc474 = 
"create function \"ResFilter_CONFIGURE\" (in col any, in search_path varchar, in filter any) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare colname varchar;\n"
"declare compilation, del_act any;\n"
"compilation := vector (\'\', filter);\n"
"rc := DAV_DIR_FILTER_INT (search_path, 1, compilation, null, null, http_dav_uid ());\n"
"if (isinteger (rc))\n"
"return rc;\n"
"if (not isinteger (col))\n"
"return -20;\n"
"colname := DAV_SEARCH_PATH (col, \'C\');\n"
"if (not (isstring (colname)))\n"
"return -23;\n"
"rc := DAV_SEARCH_ID (search_path, \'C\');\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"if (search_path <> DAV_SEARCH_PATH (rc, \'C\'))\n"
"return -2;\n"
"if (search_path between colname and (colname || \'\\255\\255\\255\\255\'))\n"
"return -28;\n"
"rc := DAV_PROP_SET_INT (colname, \'virt:ResFilter-SearchPath\', search_path, null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"rc := DAV_PROP_SET_INT (colname, \'virt:ResFilter-ListCond\', \"ResFilter_ENCODE_FILTER\" (compilation), null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"del_act := \"ResFilter_MAKE_DEL_ACTION_FROM_CONDITION\" (compilation);\n"
"\n"
"rc := DAV_PROP_SET_INT (colname, \'virt:ResFilter-DelAction\', \"ResFilter_ENCODE_FILTER\" (del_act), null, null, 0, 1, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"update WS.WS.SYS_DAV_COL set COL_DET=\'ResFilter\' where COL_ID=col;\n"
"return 0;\n"
"}\n"
"--src DET_ResFilter.sql:942\n";

/* DET_PropFilter.sql */

static const char *proc475 = 
"create function \"PropFilter_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"\n"
"if (auth_uid >= 0)\n"
"return auth_uid;\n"
"return -12;\n"
"}\n"
"--src DET_PropFilter.sql:25\n";

static const char *proc476 = 
"create function \"PropFilter_NORM\" (in value any) returns varchar\n"
"{\n"
"value := blob_to_string (value);\n"
"if ((\'\' = value) or (193 <> value[0]))\n"
"return value;\n"
"value := deserialize (value)[1];\n"
"if (isstring (value))\n"
"return value;\n"
"return cast (xml_tree_doc(value) as varchar);\n"
"}\n"
"--src DET_PropFilter.sql:35\n";

static const char *proc477 = 
"create function \"PropFilter_GET_CONDITION\" (in detcol_id integer, out pfc_spath varchar, out pfc_name varchar, out pfc_value varchar)\n"
"{\n"
"\n"
"whenever not found goto nf;\n"
"if (isarray (detcol_id))\n"
"return -20;\n"
"select \"PropFilter_NORM\" (PROP_VALUE) into pfc_spath from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:PropFilter-SearchPath\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"PropFilter_NORM\" (PROP_VALUE) into pfc_name from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:PropFilter-PropName\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"select \"PropFilter_NORM\" (PROP_VALUE) into pfc_value from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:PropFilter-PropValue\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\';\n"
"return 0;\n"
"nf:\n"
"return -1;\n"
"}\n"
"--src DET_PropFilter.sql:48\n";

static const char *proc478 = 
"create function \"PropFilter_FIT_INTO_CONDITION\" (in id integer, in what char (1), in pfc_name varchar, in pfc_value varchar)\n"
"{\n"
"declare old_value varchar;\n"
"declare propid integer;\n"
"if (__tag (pfc_value) = 193)\n"
"pfc_value := serialize (pfc_value);\n"
"else if (not isstring (pfc_value))\n"
"return -17;\n"
"whenever not found goto ins;\n"
"select p.PROP_ID, \"PropFilter_NORM\" (p.PROP_VALUE) into propid, old_value from WS.WS.SYS_DAV_PROP p, WS.WS.SYS_DAV_RES r where p.PROP_NAME = pfc_name and p.PROP_PARENT_ID = id and p.PROP_TYPE = what and r.RES_ID = id;\n"
"if (old_value <> pfc_value)\n"
"update WS.WS.SYS_DAV_PROP set PROP_VALUE = pfc_value where PROP_ID = propid;\n"
"return propid;\n"
"\n"
"ins:\n"
"propid := WS.WS.GETID (\'P\');\n"
"insert replacing WS.WS.SYS_DAV_PROP (PROP_ID, PROP_NAME, PROP_VALUE, PROP_PARENT_ID, PROP_TYPE)\n"
"values (propid, pfc_name, pfc_value, id, what);\n"
"return propid;\n"
"}\n"
"--src DET_PropFilter.sql:64\n";

static const char *proc479 = 
"create function \"PropFilter_LEAVE_CONDITION\" (in id integer, in what char (1), in pfc_name varchar, in pfc_value varchar) returns integer\n"
"{\n"
"delete from WS.WS.SYS_DAV_PROP where PROP_NAME = pfc_name and PROP_PARENT_ID = id and PROP_TYPE = what and \"PropFilter_NORM\" (PROP_VALUE) = pfc_value;\n"
"return 0;\n"
"}\n"
"--src DET_PropFilter.sql:87\n";

static const char *proc480 = 
"create function \"PropFilter_FNMERGE\" (in path any, in id integer) returns varchar\n"
"{\n"
"declare pairs any;\n"
"pairs := regexp_parse (\'^(.*[/])?([^/][^./]*)([^/]*)\\044\', path, 0);\n"
"if (pairs is null)\n"
"signal (\'.....\', sprintf (\'Internal error: failed \"PropFilter_FNMERGE\" (%s, %d)\', path, id));\n"
"return sprintf (\'%s-PfId%d%s\', subseq (path, 0, pairs[5]), id, subseq (path, pairs[6]));\n"
"}\n"
"--src DET_PropFilter.sql:95\n";

static const char *proc481 = 
"create procedure \"PropFilter_FNSPLIT\" (in path any, out colpath varchar, out orig_fnameext varchar, out id integer)\n"
"{\n"
"declare pairs any;\n"
"declare fname, fext varchar;\n"
"pairs := regexp_parse (\'^(.*[/])?([^/][^./]*)([^/]*)\\044\', path, 0);\n"
"if (pairs is null)\n"
"signal (\'.....\', sprintf (\'Internal error: failed \"PropFilter_FNSPLIT\" (%s)\', path));\n"
"colpath := subseq (path, 0, pairs[4]);\n"
"fname := subseq (path, pairs[4], pairs[5]);\n"
"fext := subseq (path, pairs[6], pairs[7]);\n"
"\n"
"pairs := regexp_parse (\'^(.*)-PfId([1-9][0-9]*)\\044\', fname, 0);\n"
"if (pairs is null)\n"
"{\n"
"orig_fnameext := fname || fext;\n"
"id := null;\n"
"}\n"
"else\n"
"{\n"
"orig_fnameext := subseq (fname, pairs[2], pairs[3]) || fext;\n"
"id := cast (subseq (fname, pairs[4], pairs[5]) as integer);\n"
"}\n"
"}\n"
"--src DET_PropFilter.sql:106\n";

static const char *proc482 = 
"create function \"PropFilter_DAV_SEARCH_ID_IMPL\" (in detcol_id any, in path_parts any, in what char(1), inout pfc_spath varchar, inout pfc_name varchar, inout pfc_value varchar) returns any\n"
"{\n"
"declare colpath, orig_fnameext varchar;\n"
"declare orig_id integer;\n"
"declare hitlist any;\n"
"\n"
"if (\'R\' <> what)\n"
"return -1;\n"
"if (not (isstring (pfc_spath)))\n"
"{\n"
"if (0 > \"PropFilter_GET_CONDITION\" (detcol_id, pfc_spath, pfc_name, pfc_value))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"}\n"
"if (1 <> length(path_parts) or (\'\' = path_parts[0]))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"\"PropFilter_FNSPLIT\" (path_parts[0], colpath, orig_fnameext, orig_id);\n"
"\n"
"hitlist := vector();\n"
"if (orig_id is null)\n"
"{\n"
"for select RES_ID from WS.WS.SYS_DAV_RES inner join WS.WS.SYS_DAV_PROP on (RES_ID = PROP_PARENT_ID)\n"
"where RES_NAME = orig_fnameext and (RES_FULL_PATH between pfc_spath and DAV_COL_PATH_BOUNDARY (pfc_spath)) and\n"
"PROP_NAME = pfc_name and PROP_TYPE = \'R\' and \"PropFilter_NORM\" (PROP_VALUE) = pfc_value\n"
"do\n"
"{\n"
"\n"
"hitlist := vector_concat (hitlist, vector (RES_ID));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"for select RES_ID from WS.WS.SYS_DAV_RES inner join WS.WS.SYS_DAV_PROP on (RES_ID = PROP_PARENT_ID)\n"
"where RES_ID = orig_id and\n"
"RES_NAME = orig_fnameext and (RES_FULL_PATH between pfc_spath and DAV_COL_PATH_BOUNDARY (pfc_spath)) and\n"
"PROP_NAME = pfc_name and PROP_TYPE = \'R\' and \"PropFilter_NORM\" (PROP_VALUE) = pfc_value\n"
"do\n"
"{\n"
"\n"
"hitlist := vector_concat (hitlist, vector (RES_ID));\n"
"}\n"
"}\n"
"if (length (hitlist) <> 1)\n"
"return -1;\n"
"return hitlist[0];\n"
"}\n"
"--src DET_PropFilter.sql:132\n";

static const char *proc483 = 
"create function \"PropFilter_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare puid, pgid, ruid, rgid integer;\n"
"declare u_password, pperms varchar;\n"
"declare allow_anon integer;\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"whenever not found goto nf_col_or_res;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'PropFilter_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'PropFilter\'), \'\')\n"
"), puid+1);\n"
"pperms := \'110100100R\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"allow_anon := WS.WS.PERM_COMP (substring (cast (pperms as varchar), 7, 3), req);\n"
"if (a_uid is null)\n"
"{\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"}\n"
"if (not DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"return -13;\n"
"\n"
"if (isarray (id[2]))\n"
"return -1;\n"
"select RES_OWNER, RES_GROUP into ruid, rgid from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"if (not DAV_CHECK_PERM (pperms, req, a_uid, a_gid, rgid, ruid))\n"
"return -13;\n"
"\n"
"return a_uid;\n"
"\n"
"nf_col_or_res:\n"
"return -1;\n"
"}\n"
"--src DET_PropFilter.sql:186\n";

static const char *proc484 = 
"create function \"PropFilter_DAV_GET_PARENT\" (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"\n"
"if (st = \'R\')\n"
"return id [1];\n"
"return -20;\n"
"}\n"
"--src DET_PropFilter.sql:239\n";

static const char *proc485 = 
"create function \"PropFilter_DAV_COL_CREATE\" (in detcol_id any, in path_parts any, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_PropFilter.sql:249\n";

static const char *proc486 = 
"create function \"PropFilter_DAV_COL_MOUNT\" (in detcol_id any, in path_parts any, in full_mount_path varchar, in mount_det varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_PropFilter.sql:257\n";

static const char *proc487 = 
"create function \"PropFilter_DAV_COL_MOUNT_HERE\" (in parent_id any, in full_mount_path varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_PropFilter.sql:265\n";

static const char *proc488 = 
"create function \"PropFilter_DAV_DELETE\" (in detcol_id any, in path_parts any, in what char(1), in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"declare rc, orig_id integer;\n"
"declare pfc_spath, pfc_name, pfc_value varchar;\n"
"\n"
"pfc_spath := null;\n"
"orig_id := \"PropFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, pfc_spath, pfc_name, pfc_value);\n"
"if (orig_id < 0)\n"
"return orig_id;\n"
"return \"PropFilter_LEAVE_CONDITION\" (orig_id, what, pfc_name, pfc_value);\n"
"}\n"
"--src DET_PropFilter.sql:273\n";

static const char *proc489 = 
"create function \"PropFilter_DAV_RES_UPLOAD\" (in detcol_id any, in path_parts any, inout content any, in type varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_PropFilter.sql:287\n";

static const char *proc490 = 
"create function \"PropFilter_DAV_PROP_REMOVE\" (in id any, in st char(0), in propname varchar, in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"\n"
"if (st <> \'R\')\n"
"return -1;\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_REMOVE\') (id, st, propname, silent, auth_uid);\n"
"return DAV_PROP_REMOVE_RAW (id, st, propname, silent, auth_uid);\n"
"}\n"
"--src DET_PropFilter.sql:295\n";

static const char *proc491 = 
"create function \"PropFilter_DAV_PROP_SET\" (in id any, in st char(0), in propname varchar, in propvalue any, in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"declare pid integer;\n"
"declare resv any;\n"
"\n"
"if (st <> \'R\')\n"
"return -1;\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_SET\') (id, st, propname, propvalue, overwrite, auth_uid);\n"
"return DAV_PROP_SET_RAW (id, st, propname, propvalue, overwrite, auth_uid);\n"
"}\n"
"--src DET_PropFilter.sql:308\n";

static const char *proc492 = 
"create function \"PropFilter_DAV_PROP_GET\" (in id any, in what char(0), in propname varchar, in auth_uid integer)\n"
"{\n"
"declare ret varchar;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_PROP_GET\') (id, what, propname, auth_uid);\n"
"if (propname[0] = 58)\n"
"return DAV_PROP_GET_INT (id, what, propname, 0, null, null, auth_uid);\n"
"whenever not found goto no_prop;\n"
"select blob_to_string (PROP_VALUE) into ret from WS.WS.SYS_DAV_PROP where PROP_NAME = propname and PROP_PARENT_ID = id and PROP_TYPE = what;\n"
"return ret;\n"
"\n"
"no_prop:\n"
"return -11;\n"
"}\n"
"--src DET_PropFilter.sql:323\n";

static const char *proc493 = 
"create function \"PropFilter_DAV_PROP_LIST\" (in id any, in what char(0), in propmask varchar, in auth_uid integer)\n"
"{\n"
"declare ret any;\n"
"\n"
"id := id[2];\n"
"ret := vector();\n"
"for select PROP_NAME, PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME like propmask and PROP_PARENT_ID = id and PROP_TYPE = what do {\n"
"ret := vector_concat (ret, vector (vector (PROP_NAME, blob_to_string (PROP_VALUE))));\n"
"}\n"
"return ret;\n"
"}\n"
"--src DET_PropFilter.sql:342\n";

static const char *proc494 = 
"create function \"PropFilter_DAV_DIR_SINGLE\" (in id any, in what char(0), in path any, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (\'R\' <> what)\n"
"return -1;\n"
"for select RES_FULL_PATH, RES_ID, length (RES_CONTENT) as clen, RES_MOD_TIME,\n"
"RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME as r1_RES_NAME\n"
"from WS.WS.SYS_DAV_RES r1\n"
"where RES_ID = id[2]\n"
"do\n"
"{\n"
"declare merged varchar;\n"
"\n"
"if (regexp_parse (\'^([^/][^./]*)-PfId([1-9][0-9]*)([^/]*)\\044\', r1_RES_NAME, 0))\n"
"{\n"
"merged := \"PropFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"}\n"
"else\n"
"{\n"
"declare pfc_spath, pfc_name, pfc_value varchar;\n"
"declare namesakes_no integer;\n"
"if (0 > \"PropFilter_GET_CONDITION\" (id[1], pfc_spath, pfc_name, pfc_value))\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"select count(1) into namesakes_no\n"
"from WS.WS.SYS_DAV_RES r2 inner join WS.WS.SYS_DAV_PROP p2 on (r2.RES_ID = p2.PROP_PARENT_ID)\n"
"where r2.RES_NAME = r1_RES_NAME and (r2.RES_FULL_PATH between pfc_spath and DAV_COL_PATH_BOUNDARY (pfc_spath)) and\n"
"p2.PROP_NAME = pfc_name and p2.PROP_TYPE = \'R\' and \"PropFilter_NORM\" (p2.PROP_VALUE) = pfc_value;\n"
"if (0 = namesakes_no)\n"
"return -1;\n"
"if (1 < namesakes_no)\n"
"merged := \"PropFilter_FNMERGE\" (r1_RES_NAME, RES_ID);\n"
"else\n"
"merged := r1_RES_NAME;\n"
"}\n"
"\n"
"return vector (DAV_CONCAT_PATH (DAV_SEARCH_PATH (id[1], \'C\'), merged), \'R\', clen, RES_MOD_TIME,\n"
"\n"
"id, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, merged);\n"
"}\n"
"return -1;\n"
"}\n"
"--src DET_PropFilter.sql:356\n";

static const char *proc495 = 
"create function \"PropFilter_DAV_DIR_LIST\" (in detcol_id any, in path_parts any, in detcol_path varchar, in name_mask varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare pfc_spath, pfc_name, pfc_value varchar;\n"
"declare davpath, prev_raw_name varchar;\n"
"declare files, filtered_files, res any;\n"
"declare reslen, prev_is_patched integer;\n"
"\n"
"if (0 > \"PropFilter_GET_CONDITION\" (detcol_id, pfc_spath, pfc_name, pfc_value))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"if (1 <> length(path_parts) or (\'\' <> path_parts[0]))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"res := vector();\n"
"reslen := 0;\n"
"prev_raw_name := \'\';\n"
"prev_is_patched := 1;\n"
"for select RES_FULL_PATH, RES_ID, length (RES_CONTENT) as clen, RES_MOD_TIME,\n"
"RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME\n"
"from WS.WS.SYS_DAV_RES inner join WS.WS.SYS_DAV_PROP on (RES_ID = PROP_PARENT_ID)\n"
"where RES_NAME like name_mask and (RES_FULL_PATH between pfc_spath and DAV_COL_PATH_BOUNDARY (pfc_spath)) and\n"
"PROP_NAME = pfc_name and PROP_TYPE = \'R\' and \"PropFilter_NORM\" (PROP_VALUE) = pfc_value\n"
"order by RES_NAME, RES_ID\n"
"do\n"
"{\n"
"declare merged varchar;\n"
"\n"
"if (regexp_parse (\'^([^/][^./]*)-PfId([1-9][0-9]*)([^/]*)\\044\', RES_NAME, 0))\n"
"{\n"
"merged := \"PropFilter_FNMERGE\" (RES_NAME, RES_ID);\n"
"prev_is_patched := 1;\n"
"\n"
"}\n"
"else if (RES_NAME = prev_raw_name)\n"
"{\n"
"merged := \"PropFilter_FNMERGE\" (RES_NAME, RES_ID);\n"
"if (not prev_is_patched)\n"
"{\n"
"declare prev_id integer;\n"
"declare prev_merged varchar;\n"
"prev_id := res[reslen-1][4][2];\n"
"prev_merged := \"PropFilter_FNMERGE\" (RES_NAME, prev_id);\n"
"res[reslen-1][10] := prev_merged;\n"
"res[reslen-1][0] := DAV_CONCAT_PATH (detcol_path, prev_merged);\n"
"\n"
"}\n"
"prev_is_patched := 1;\n"
"}\n"
"else\n"
"{\n"
"merged := RES_NAME;\n"
"prev_is_patched := 0;\n"
"\n"
"}\n"
"\n"
"res := vector_concat (res, vector (vector (DAV_CONCAT_PATH (detcol_path, merged), \'R\', clen, RES_MOD_TIME,\n"
"\n"
"vector (UNAME\'PropFilter\', detcol_id, RES_ID), RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, merged ) ) );\n"
"prev_raw_name := RES_NAME;\n"
"reslen := reslen + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_PropFilter.sql:403\n";

static const char *proc496 = 
"create function \"PropFilter_DAV_DIR_FILTER\" (in detcol_id any, in path_parts any, in detcol_path varchar, inout compilation any, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare pfc_spath, pfc_name, pfc_value varchar;\n"
"declare davpath, prev_raw_name varchar;\n"
"declare reslen, prev_is_patched integer;\n"
"declare execstate, execmessage, execmeta, execrows any;\n"
"declare davcond varchar;\n"
"\n"
"davcond := get_keyword (\'DAV\', compilation);\n"
"if (\'\' <> davcond)\n"
"davcond := \' and \' || davcond;\n"
"execstate := \'00000\';\n"
"if (0 > \"PropFilter_GET_CONDITION\" (detcol_id, pfc_spath, pfc_name, pfc_value))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"if (1 <> length(path_parts) or (\'\' <> path_parts[0]))\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"exec (\'select\n"
"\n"
"RES_NAME, \'\'R\'\', length (RES_CONTENT), RES_MOD_TIME,\n"
"\n"
"RES_ID, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_TYPE, RES_NAME\n"
"from WS.WS.SYS_DAV_RES inner join WS.WS.SYS_DAV_PROP on (RES_ID = PROP_PARENT_ID)\n"
"where (RES_FULL_PATH between ? and ?) and\n"
"(PROP_NAME = ?) and (PROP_TYPE = \'\'R\'\') and (\"PropFilter_NORM\" (PROP_VALUE) = ?)\' || davcond || \'\n"
"order by RES_NAME, RES_ID\',\n"
"execstate, execmessage, vector (pfc_spath, DAV_COL_PATH_BOUNDARY (pfc_spath), pfc_name, pfc_value), 100000000, execmeta, execrows );\n"
"\n"
"reslen := 0;\n"
"prev_raw_name := \'\';\n"
"prev_is_patched := 1;\n"
"foreach (any itm in execrows) do\n"
"{\n"
"declare orig_name varchar;\n"
"declare orig_id integer;\n"
"declare merged varchar;\n"
"orig_name := itm[0];\n"
"orig_id := itm[4];\n"
"\n"
"if (regexp_parse (\'^([^/][^./]*)-PfId([1-9][0-9]*)([^/]*)\\044\', orig_name, 0))\n"
"{\n"
"merged := \"PropFilter_FNMERGE\" (orig_name, orig_id);\n"
"prev_is_patched := 1;\n"
"\n"
"}\n"
"else if (orig_name = prev_raw_name)\n"
"{\n"
"merged := \"PropFilter_FNMERGE\" (orig_name, orig_id);\n"
"if (not prev_is_patched)\n"
"{\n"
"declare prev_id integer;\n"
"declare prev_merged varchar;\n"
"prev_id := execrows[reslen-1][4][2];\n"
"prev_merged := \"PropFilter_FNMERGE\" (orig_name, prev_id);\n"
"execrows[reslen-1][10] := prev_merged;\n"
"execrows[reslen-1][0] := DAV_CONCAT_PATH (detcol_path, prev_merged);\n"
"\n"
"}\n"
"prev_is_patched := 1;\n"
"}\n"
"else\n"
"{\n"
"merged := orig_name;\n"
"prev_is_patched := 0;\n"
"\n"
"}\n"
"execrows[reslen][0] := DAV_CONCAT_PATH (detcol_path, merged);\n"
"execrows[reslen][4] := vector (UNAME\'PropFilter\', detcol_id, orig_id);\n"
"prev_raw_name := orig_name;\n"
"reslen := reslen + 1;\n"
"}\n"
"\n"
"return execrows;\n"
"}\n"
"--src DET_PropFilter.sql:473\n";

static const char *proc497 = 
"create function \"PropFilter_DAV_SEARCH_ID\" (in detcol_id any, in path_parts any, in what char(1)) returns any\n"
"{\n"
"declare pfc_spath, pfc_name, pfc_value varchar;\n"
"declare orig_id integer;\n"
"\n"
"pfc_spath := null;\n"
"orig_id := \"PropFilter_DAV_SEARCH_ID_IMPL\" (detcol_id, path_parts, what, pfc_spath, pfc_name, pfc_value);\n"
"if (orig_id < 0)\n"
"return orig_id;\n"
"return vector (UNAME\'PropFilter\', detcol_id, orig_id);\n"
"}\n"
"--src DET_PropFilter.sql:555\n";

static const char *proc498 = 
"create function \"PropFilter_DAV_SEARCH_PATH\" (in id any, in what char(1)) returns any\n"
"{\n"
"\n"
"return coalesce ((select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_ID = id[2]), null);\n"
"}\n"
"--src DET_PropFilter.sql:569\n";

static const char *proc499 = 
"create function \"PropFilter_DAV_RES_UPLOAD_COPY\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"declare pfc_spath, pfc_name, pfc_value varchar;\n"
"declare rc integer;\n"
"\n"
"if (0 > \"PropFilter_GET_CONDITION\" (detcol_id, pfc_spath, pfc_name, pfc_value))\n"
"{\n"
"\n"
"return -2;\n"
"}\n"
"if (1 <> length (path_parts))\n"
"return -2;\n"
"if (\'R\' <> what)\n"
"return -2;\n"
"if (\'\' = path_parts[0])\n"
"return -2;\n"
"if (isinteger (source_id) and\n"
"exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_ID = source_id and RES_NAME = path_parts[0] and (RES_FULL_PATH between pfc_spath and DAV_COL_PATH_BOUNDARY (pfc_spath)) ) )\n"
"{\n"
"\"PropFilter_FIT_INTO_CONDITION\" (source_id, what, pfc_name, pfc_value);\n"
"}\n"
"else\n"
"{\n"
"declare new_full_path varchar;\n"
"new_full_path := DAV_CONCAT_PATH (pfc_spath, path_parts[0]);\n"
"rc := DAV_COPY_INT (DAV_SEARCH_PATH (source_id, what), new_full_path, overwrite, permissions,\n"
"coalesce ((select U_NAME from WS.WS.SYS_DAV_USER where U_ID = uid), \'\'),\n"
"coalesce ((select G_NAME from WS.WS.SYS_DAV_GROUP where G_ID = gid), \'\'),\n"
"null, null, 0);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"source_id := DAV_SEARCH_ID (new_full_path, what);\n"
"if (DAV_HIDE_ERROR (source_id) is null)\n"
"return source_id;\n"
"\"PropFilter_FIT_INTO_CONDITION\" (source_id, what, pfc_name, pfc_value);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_PropFilter.sql:577\n";

static const char *proc500 = 
"create function \"PropFilter_DAV_RES_UPLOAD_MOVE\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"declare pfc_spath, pfc_name, pfc_value varchar;\n"
"declare rc integer;\n"
"\n"
"if (0 > \"PropFilter_GET_CONDITION\" (detcol_id, pfc_spath, pfc_name, pfc_value))\n"
"{\n"
"\n"
"return -2;\n"
"}\n"
"if (1 <> length (path_parts))\n"
"return -2;\n"
"if (\'R\' <> what)\n"
"return -2;\n"
"if (\'\' = path_parts[0])\n"
"return -2;\n"
"if (isinteger (source_id) and\n"
"exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_ID = source_id and RES_NAME = path_parts[0] and (RES_FULL_PATH between pfc_spath and DAV_COL_PATH_BOUNDARY (pfc_spath))))\n"
"{\n"
"\"PropFilter_FIT_INTO_CONDITION\" (source_id, what, pfc_name, pfc_value);\n"
"}\n"
"else\n"
"{\n"
"declare new_full_path varchar;\n"
"new_full_path := DAV_CONCAT_PATH (pfc_spath, path_parts[0]);\n"
"rc := DAV_MOVE_INT (DAV_SEARCH_PATH (source_id, what),  new_full_path, overwrite, null, null, 0, 1);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"return rc;\n"
"source_id := DAV_SEARCH_ID (new_full_path, what);\n"
"if (DAV_HIDE_ERROR (source_id) is null)\n"
"return source_id;\n"
"\"PropFilter_FIT_INTO_CONDITION\" (source_id, what, pfc_name, pfc_value);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_PropFilter.sql:619\n";

static const char *proc501 = 
"create function \"PropFilter_DAV_RES_CONTENT\" (in id any, inout content any, out type varchar, in content_mode integer) returns integer\n"
"{\n"
"\n"
"declare cont any;\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"select RES_CONTENT, RES_TYPE into content, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"else if (content_mode = 1)\n"
"select http (RES_CONTENT, content), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"else if (content_mode = 3)\n"
"select http (RES_CONTENT), RES_TYPE into cont, type from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"return id[2];\n"
"}\n"
"--src DET_PropFilter.sql:658\n";

static const char *proc502 = 
"create function \"PropFilter_DAV_SYMLINK\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_PropFilter.sql:673\n";

static const char *proc503 = 
"create function \"PropFilter_DAV_LOCK\" (in path any, inout id any, in type char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid integer) returns any\n"
"{\n"
"declare rc, u_token, new_token varchar;\n"
"\n"
"if (\'R\' <> type)\n"
"return -20;\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return -20;\n"
"if (isarray (id))\n"
"return DAV_LOCK_INT (path, id[2], type, locktype, scope, token, owner_name, owned_tokens, depth, timeout_sec, null, null, auth_uid);\n"
"return -20;\n"
"}\n"
"--src DET_PropFilter.sql:681\n";

static const char *proc504 = 
"create function \"PropFilter_DAV_UNLOCK\" (in id any, in type char(1), in token varchar, in auth_uid integer)\n"
"{\n"
"\n"
"if (isarray (id))\n"
"id := id [2];\n"
"return DAV_UNLOCK_INT (id, type, token, null, null, auth_uid);\n"
"}\n"
"--src DET_PropFilter.sql:696\n";

static const char *proc505 = 
"create function \"PropFilter_DAV_IS_LOCKED\" (inout id any, inout type char(1), in owned_tokens varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare orig_id any;\n"
"declare orig_type char(1);\n"
"\n"
"orig_id := id;\n"
"id := orig_id[2];\n"
"rc := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"id := orig_id[1];\n"
"orig_type := type;\n"
"type := \'C\';\n"
"rc := DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"if (rc <> 0)\n"
"return rc;\n"
"id := orig_id;\n"
"type := orig_type;\n"
"return 0;\n"
"}\n"
"--src DET_PropFilter.sql:706\n";

static const char *proc506 = 
"create function \"PropFilter_DAV_LIST_LOCKS\" (in id any, in type char(1), in recursive integer) returns any\n"
"{\n"
"declare res any;\n"
"\n"
"id := id[2];\n"
"if (isarray (id))\n"
"return call (cast (id[0] as varchar) || \'_DAV_LIST_LOCKS\') (id, type, recursive);\n"
"res := vector();\n"
"for select LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO\n"
"from WS.WS.SYS_DAV_LOCK where LOCK_PARENT_ID = id and LOCK_PARENT_TYPE = type do {\n"
"res := vector_concat (res, vector (vector (LOCK_TYPE, LOCK_SCOPE, LOCK_TOKEN, LOCK_TIMEOUT, LOCK_OWNER, LOCK_OWNER_INFO)));\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_PropFilter.sql:730\n";

/* DET_RDFData.sql */

static const char *proc507 = 
"create procedure DB.DBA.RDFData_log_message (in x varchar)\n"
"{\n"
"if (0)\n"
"log_message (cast (x as varchar));\n"
"}\n"
"--src DET_RDFData.sql:25\n";

static const char *proc508 = 
"create function DB.DBA.\"RDFData_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"\n"
"\n"
"if (not (\'110\' like req))\n"
"{\n"
"return -13;\n"
"}\n"
"if (\'100\' like req and auth_uid >= 0)\n"
"return auth_uid;\n"
"\n"
"if ((auth_uid <> id[3]) and (auth_uid <> http_dav_uid()))\n"
"{\n"
"\n"
"return -13;\n"
"}\n"
"if (auth_uid >= 0)\n"
"return auth_uid;\n"
"return -12;\n"
"}\n"
"--src DET_RDFData.sql:32\n";

static const char *proc509 = 
"create function DB.DBA.\"RDFData_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"\n"
"declare rc integer;\n"
"declare puid, pgid integer;\n"
"declare u_password, pperms varchar;\n"
"declare allow_anon integer;\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"whenever not found goto nf_col_or_res;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'RDFData_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'RDFData\'), \'\')\n"
"), puid+1);\n"
"pperms := \'110100100NN\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"allow_anon := WS.WS.PERM_COMP (substring (cast (pperms as varchar), 7, 3), req);\n"
"if (a_uid is null)\n"
"{\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"}\n"
"if (DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"return a_uid;\n"
"return -13;\n"
"\n"
"nf_col_or_res:\n"
"return -1;\n"
"}\n"
"--src DET_RDFData.sql:55\n";

static const char *proc510 = 
"create function DB.DBA.\"RDFData_DAV_GET_PARENT\" (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:103\n";

static const char *proc511 = 
"create function DB.DBA.\"RDFData_DAV_COL_CREATE\" (in detcol_id any, in path_parts any, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:110\n";

static const char *proc512 = 
"create function DB.DBA.\"RDFData_DAV_COL_MOUNT\" (in detcol_id any, in path_parts any, in full_mount_path varchar, in mount_det varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:117\n";

static const char *proc513 = 
"create function DB.DBA.\"RDFData_DAV_COL_MOUNT_HERE\" (in parent_id any, in full_mount_path varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:124\n";

static const char *proc514 = 
"create function DB.DBA.\"RDFData_DAV_DELETE\" (in detcol_id any, in path_parts any, in what char(1), in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:132\n";

static const char *proc515 = 
"create function DB.DBA.\"RDFData_DAV_RES_UPLOAD\" (in detcol_id any, in path_parts any, inout content any, in type varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:139\n";

static const char *proc516 = 
"create function DB.DBA.\"RDFData_DAV_PROP_REMOVE\" (in id any, in what char(0), in propname varchar, in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:147\n";

static const char *proc517 = 
"create function DB.DBA.\"RDFData_DAV_PROP_SET\" (in id any, in what char(0), in propname varchar, in propvalue any, in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"if (propname[0] = 58)\n"
"{\n"
"return -16;\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:154\n";

static const char *proc518 = 
"create function DB.DBA.\"RDFData_DAV_PROP_GET\" (in id any, in what char(0), in propname varchar, in auth_uid integer)\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -11;\n"
"}\n"
"--src DET_RDFData.sql:165\n";

static const char *proc519 = 
"create function DB.DBA.\"RDFData_DAV_PROP_LIST\" (in id any, in what char(0), in propmask varchar, in auth_uid integer)\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return vector ();\n"
"}\n"
"--src DET_RDFData.sql:173\n";

static const char *proc520 = 
"create function DB.DBA.\"RDFData_ACCESS_PARAMS\" (in detcol_id any, out access varchar, out gid integer, out uid integer)\n"
"{\n"
"declare access_tmp varchar;\n"
"whenever not found goto ret;\n"
"access := \'000100100N\';\n"
"gid := http_nogroup_gid ();\n"
"uid := http_nobody_uid ();\n"
"if (isinteger (detcol_id))\n"
"{\n"
"select COL_PERMS, COL_GROUP, COL_OWNER into access_tmp, gid, uid from WS.WS.SYS_DAV_COL where COL_ID = detcol_id;\n"
"}\n"
"access[0] := access_tmp[0];\n"
"access[1] := access_tmp[1];\n"
"ret:\n"
" ;\n"
"}\n"
"--src DET_RDFData.sql:180\n";

static const char *proc521 = 
"create procedure DB.DBA.RDFData_cast_dt_silent (in d any)\n"
"{\n"
"if (__tag (d) = 211)\n"
"return d;\n"
"else\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return now ();\n"
"};\n"
"return cast (d as datetime);\n"
"}\n"
"}\n"
"--src DET_RDFData.sql:198\n";

static const char *proc522 = 
"create function DB.DBA.\"RDFData_DAV_DIR_SINGLE\" (in id any, in what char(0), in path any, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"\n"
"declare path_parts any;\n"
"declare access, ownergid, owner_uid, mime any;\n"
"declare len int;\n"
"\n"
"DB.DBA.\"RDFData_ACCESS_PARAMS\" (id[1], access, ownergid, owner_uid);\n"
"\n"
"if (isstring (path))\n"
"path_parts := split_and_decode (path, 0, \'\\0\\0/\');\n"
"else\n"
"path_parts := path;\n"
"len := length (path_parts);\n"
"if (what = \'C\')\n"
"return vector (DAV_CONCAT_PATH (path, \'\'), \'C\', 0, now (), id, access, ownergid, owner_uid, now (), \'dav/unix-directory\', path_parts [len - 2]);\n"
"mime := \'application/rdf+xml\';\n"
"if (is_http_ctx ())\n"
"{\n"
"declare lpath varchar;\n"
"lpath := http_path ();\n"
"if (lpath like \'%.ttl\' or lpath like \'%.n3\')\n"
"mime := \'text/rdf+n3\';\n"
"}\n"
"return vector (DAV_CONCAT_PATH (path, \'\'), \'R\', 0, now (), id, access, ownergid, owner_uid, now (), mime, path_parts [len - 1]);\n"
"}\n"
"--src DET_RDFData.sql:213\n";

static const char *proc523 = 
"create function DB.DBA.\"RDFData_DAV_DIR_LIST\" (in detcol_id any, in path_parts any, in detcol_path varchar, in name_mask varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"declare top_davpath varchar;\n"
"declare res any;\n"
"declare top_id, descnames any;\n"
"declare what char (1);\n"
"declare access, filt_lg varchar;\n"
"declare ownergid, owner_uid, dn_ctr, dn_count integer;\n"
"declare gr, u_name any;\n"
"\n"
"vectorbld_init (res);\n"
"\n"
"DB.DBA.\"RDFData_ACCESS_PARAMS\" (detcol_id, access, ownergid, owner_uid);\n"
"\n"
"\n"
"\n"
"if ((0 = length (path_parts)) or (\'\' = path_parts[length (path_parts) - 1]))\n"
"what := \'C\';\n"
"else\n"
"what := \'R\';\n"
"if (\'C\' = what and 1 = length(path_parts))\n"
"top_id := vector (UNAME\'RDFData\', detcol_id, null, owner_uid, null, null);\n"
"else\n"
"top_id := DB.DBA.\"RDFData_DAV_SEARCH_ID\" (detcol_id, path_parts, what);\n"
"if (DAV_HIDE_ERROR (top_id) is null)\n"
"{\n"
"return vector();\n"
"}\n"
"top_davpath := DAV_CONCAT_PATH (detcol_path, path_parts);\n"
"if (\'R\' = what)\n"
"{\n"
"return vector (DB.DBA.\"RDFData_DAV_DIR_SINGLE\" (top_id, what, top_davpath, auth_uid));\n"
"}\n"
"gr := DAV_PROP_GET_INT (detcol_id, \'C\', \'virt:rdfdata_graph\', 0);\n"
"filt_lg := DAV_PROP_GET_INT (detcol_id, \'C\', \'virt:rdfdata_lang\', 0);\n"
"if (not isstring (gr) or length (gr) = 0)\n"
"{\n"
"u_name := (select p.COL_NAME from WS.WS.SYS_DAV_COL p, WS.WS.SYS_DAV_COL c\n"
"where c.COL_ID = detcol_id and p.COL_ID = c.COL_PARENT);\n"
"gr := sioc..user_doc_iri (u_name);\n"
"}\n"
"if (not isstring (filt_lg))\n"
"filt_lg := \'\';\n"
"if (is_http_ctx () and filt_lg = \'*http*\')\n"
"{\n"
"filt_lg := http_request_header (http_request_header (), \'Accept-Language\', null, \'\');\n"
"}\n"
"\n"
"if (top_id[2] is null)\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"FOR SELECT CLS FROM (\n"
"sparql\n"
"select distinct ?CLS\n"
"where {\n"
"graph `iri(?:gr)`\n"
"{\n"
"?x a ?CLS .\n"
"} } ) sub do\n"
"{\n"
"declare tmp, tit, pref any;\n"
"declare p1, p2, p3, pos int;\n"
"p1 := coalesce (strrchr (cls, \'#\'), -1);\n"
"p2 := coalesce (strrchr (cls, \'/\'), -1);\n"
"p3 := coalesce (strrchr (cls, \':\'), -1);\n"
"pos := __max (p1, p2, p3);\n"
"if (pos > 0)\n"
"{\n"
"tit := subseq (CLS, pos + 1);\n"
"tmp := subseq (CLS, 0, pos + 1);\n"
"pref := RDFData_std_pref (tmp);\n"
"if (pref is not null)\n"
"tit := pref || \':\' || tit;\n"
"else\n"
"tit := CLS;\n"
"}\n"
"else\n"
"tit := CLS;\n"
"tit := replace (tit, \'/\', \'^2f\');\n"
"tit := replace (tit, \'#\', \'^23\');\n"
"\n"
"vectorbld_acc (res,\n"
"vector (\n"
"DAV_CONCAT_PATH (top_davpath, tit) || \'/\',\n"
"\'C\',\n"
"0,\n"
"now (),\n"
"vector (UNAME\'RDFData\', detcol_id, iri_to_id (CLS)),\n"
"access,\n"
"ownergid,\n"
"owner_uid,\n"
"now (),\n"
"\'dav/unix-directory\',\n"
"tit)\n"
");\n"
"}\n"
"}\n"
"else if (top_id[2] is not null and length (top_id) = 4)\n"
"{\n"
"declare cs any;\n"
"declare qr, rset, mdta, h, dict, is_all any;\n"
"declare inc, limit int;\n"
"\n"
"limit := 1000;\n"
"inc := 0;\n"
"is_all := 0;\n"
"cs := top_id[2];\n"
"cs := id_to_iri (cs);\n"
"if (cs = \'All\')\n"
"{\n"
"is_all := 1;\n"
"cs := \'?cls\';\n"
"return vector ();\n"
"}\n"
"else\n"
"cs := sprintf (\'<%S>\', cs);\n"
"\n"
"\n"
"qr := sprintf (\'sparql\n"
"define output:valmode \"LONG\"\n"
"prefix dc: <http://purl.org/dc/elements/1.1/>\n"
"prefix dct: <http://purl.org/dc/terms/>\n"
"prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n"
"prefix skos: <http://www.w3.org/2004/02/skos/core#>\n"
"SELECT ?X ?L ?T ?PL ?CR ?MOD\n"
"where\n"
"{\n"
"graph <%S>\n"
"{\n"
"?X a %s\n"
"optional { ?X rdfs:label ?L } .\n"
"optional { ?X dc:title ?T } .\n"
"optional { ?X skos:prefLabel ?PL } .\n"
"optional { ?X dct:created ?CR } .\n"
"optional { ?X dct:modified ?MOD } .\n"
"}\n"
"}\', gr, cs);\n"
"\n"
"dict := dict_new ();\n"
"exec (qr, null, null, vector (), 0, null, null, h);\n"
"while (0 = exec_next (h, null, null, rset))\n"
"{\n"
"declare tit, lg any;\n"
"declare X,L,T,PL,CR,MOD any;\n"
"\n"
"X := rset[0];\n"
"L := rset[1];\n"
"T := rset[2];\n"
"PL := rset[3];\n"
"CR := rset[4];\n"
"MOD := rset[5];\n"
"\n"
"cr := coalesce (cr, now ());\n"
"mod := coalesce (mod, now ());\n"
"cr := RDFData_cast_dt_silent (cr);\n"
"mod := RDFData_cast_dt_silent (mod);\n"
"\n"
"tit := coalesce (L, T, PL);\n"
"\n"
"lg := \'\';\n"
"if (is_all)\n"
"tit := \'iid\';\n"
"else if (tit is null)\n"
"tit := \'~unnamed~\';\n"
"else\n"
"{\n"
"lg := DB.DBA.RDF_LANGUAGE_OF_LONG (tit, \'\');\n"
"tit := DB.DBA.RDF_SQLVAL_OF_LONG (tit);\n"
"}\n"
"\n"
"if (filt_lg <> \'\' and lg <> \'\' and strstr (filt_lg, lg) is null)\n"
"goto next_row;\n"
"if (dict_get (dict, X) = 1)\n"
"goto next_row;\n"
"tit := sprintf (\'%s (%i).rdf\', tit, iri_id_num (iri_to_id (X)));\n"
"\n"
"\n"
"vectorbld_acc (res,\n"
"vector (\n"
"DAV_CONCAT_PATH (top_davpath, tit),\n"
"\'R\',\n"
"0,\n"
"mod,\n"
"vector (UNAME\'RDFData\', detcol_id, cs, iri_to_id (X)),\n"
"access,\n"
"ownergid,\n"
"owner_uid,\n"
"cr,\n"
"\'application/rdf+xml\',\n"
"tit)\n"
");\n"
"dict_put (dict, X, 1);\n"
"inc := inc + 1;\n"
"if (inc > limit)\n"
"goto end_loop;\n"
"next_row:;\n"
"}\n"
"end_loop:;\n"
"exec_close (h);\n"
"}\n"
"finalize_res:\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src DET_RDFData.sql:243\n";

static const char *proc524 = 
"create function RDFData_std_pref (in iri varchar, in rev int := 0)\n"
"{\n"
"declare v any;\n"
"v := vector (\n"
"\'http://xmlns.com/foaf/0.1/\', \'foaf\',\n"
"\'http://rdfs.org/sioc/ns#\', \'sioc\',\n"
"\'http://www.w3.org/1999/02/22-rdf-syntax-ns#\', \'rdf\',\n"
"\'http://www.w3.org/2000/01/rdf-schema#\', \'rdfs\',\n"
"\'http://www.w3.org/2003/01/geo/wgs84_pos#\', \'geo\',\n"
"\'http://atomowl.org/ontologies/atomrdf#\', \'aowl\',\n"
"\'http://purl.org/dc/elements/1.1/\', \'dc\',\n"
"\'http://purl.org/dc/terms/\', \'dct\',\n"
"\'http://www.w3.org/2004/02/skos/core#\', \'skos\',\n"
"\'http://rdfs.org/sioc/types#\', \'sioct\',\n"
"\'http://sw.deri.org/2005/04/wikipedia/wikiont.owl#\', \'wiki\',\n"
"\'http://www.w3.org/2002/01/bookmark#\', \'bm\',\n"
"\'http://www.w3.org/2003/12/exif/ns/\', \'exif\',\n"
"\'http://www.w3.org/2000/10/annotation-ns#\', \'ann\',\n"
"\'http://purl.org/vocab/bio/0.1/\', \'bio\',\n"
"\'http://www.w3.org/2001/vcard-rdf/3.0#\', \'vcard\',\n"
"\'http://www.w3.org/2002/12/cal#\', \'vcal\',\n"
"\'http://www.w3.org/2002/07/owl#\', \'owl\',\n"
"\'http://web.resource.org/cc/\', \'cc\',\n"
"\'http://dbpedia.org/class/yago/\', \'dbp\'\n"
"\n"
");\n"
"if (rev)\n"
"{\n"
"declare nv, l any;\n"
"nv := make_array (length (v), \'any\');\n"
"for (declare i, j int, j := 0, i := length (v) - 1; i >= 0; i := i - 2, j := j + 2)\n"
"{\n"
"nv[j] := v[i];\n"
"nv[j+1] := v[i-1];\n"
"}\n"
"return get_keyword (iri, nv, null);\n"
"}\n"
"else\n"
"return get_keyword (iri, v, null);\n"
"}\n"
"--src DET_RDFData.sql:464\n";

static const char *proc525 = 
"create function DB.DBA.\"RDFData_DAV_DIR_FILTER\" (in detcol_id any, in path_parts any, in detcol_path varchar, inout compilation any, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"\n"
"return vector();\n"
"}\n"
"--src DET_RDFData.sql:506\n";

static const char *proc526 = 
"create function DB.DBA.\"RDFData_DAV_SEARCH_ID\" (in detcol_id any, in path_parts any, in what char(1)) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"\n"
"declare orig_id, ctr, len integer;\n"
"declare r_id, cl_id, cl any;\n"
"declare access, ownergid, owner_uid any;\n"
"DB.DBA.\"RDFData_ACCESS_PARAMS\" (detcol_id, access, ownergid, owner_uid);\n"
"\n"
"if (path_parts[0] = \'\' or path_parts[0] is null)\n"
"return -1;\n"
"if (path_parts[0] <> \'\')\n"
"{\n"
"declare x, pos, pref, url any;\n"
"cl := path_parts[0];\n"
"pos := strchr (cl, \':\');\n"
"pref := subseq (cl, 0, pos);\n"
"url := RDFData_std_pref (pref, 1);\n"
"if (url is null)\n"
"{\n"
"cl := replace (cl, \'^2f\', \'/\');\n"
"cl := replace (cl, \'^23\', \'#\');\n"
"cl_id := iri_to_id (cl);\n"
"\n"
"}\n"
"else\n"
"{\n"
"cl := subseq (cl, pos + 1);\n"
"cl := url || cl;\n"
"cl_id := iri_to_id (cl);\n"
"}\n"
"}\n"
"if (length (path_parts) = 2 and what = \'C\')\n"
"{\n"
"return vector (UNAME\'RDFData\', detcol_id, cl_id, owner_uid);\n"
"}\n"
"else if (length (path_parts) = 2 and path_parts[1] <> \'\' and what = \'R\')\n"
"{\n"
"declare t, arr any;\n"
"t := path_parts[1];\n"
"arr := sprintf_inverse (t, \'%s (%d).%s\', 1);\n"
"if (3 > length (arr))\n"
"return -1;\n"
"r_id := iri_id_from_num (arr [1]);\n"
"\n"
"return vector (UNAME\'RDFData\', detcol_id, cl_id, owner_uid, r_id);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:514\n";

static const char *proc527 = 
"create function DB.DBA.\"RDFData_DAV_SEARCH_PATH\" (in id any, in what char(1)) returns any\n"
"{\n"
"declare col_path varchar;\n"
"declare ret any;\n"
"RDFData_log_message (current_proc_name ());\n"
"\n"
"col_path := WS.WS.COL_PATH (id[1]);\n"
"ret := sprintf (\'%s%s/iid (%d).rdf\', col_path, id_to_iri (id[2]), iri_id_num (id[4]));\n"
"\n"
"return ret;\n"
"}\n"
"--src DET_RDFData.sql:565\n";

static const char *proc528 = 
"create function DB.DBA.\"RDFData_DAV_RES_UPLOAD_COPY\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite_flags integer, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:578\n";

static const char *proc529 = 
"create function DB.DBA.\"RDFData_DAV_RES_UPLOAD_MOVE\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite_flags integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:585\n";

static const char *proc530 = 
"create function DB.DBA.\"RDFData_DAV_RES_CONTENT\" (in id any, inout content any, out type varchar, in content_mode integer) returns integer\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"declare iri, url, qr, _from any;\n"
"declare path, params, lines, ses, gr any;\n"
"\n"
"if (id [4] is null)\n"
"return -20;\n"
"type := \'application/rdf+xml\';\n"
"if (is_http_ctx ())\n"
"{\n"
"declare lpath varchar;\n"
"lpath := http_path ();\n"
"if (lpath like \'%.rdf\')\n"
"type := \'application/rdf+xml\';\n"
"else\n"
"type := \'text/rdf+n3\';\n"
"}\n"
"iri := id_to_iri (id [4]);\n"
"\n"
"_from := \'\';\n"
"gr := DAV_PROP_GET_INT (id[1], \'C\', \'virt:rdfdata_graph\', 0);\n"
"if (__proc_exists (\'sioc.DBA.get_graph\') is not null and gr = sioc.DBA.get_graph ())\n"
"{\n"
"declare pg any;\n"
"declare tmp, uname any;\n"
"declare pos int;\n"
"pg := http_param (\'page\');\n"
"if (not isstring (pg))\n"
"pg := \'0\';\n"
"pg := atoi (pg);\n"
"\n"
"\n"
"if (regexp_match (\'https?://([^/]*)/dataspace/(person|organization)/(.*)\', iri) is not null and iri not like \'%/online_account/%\')\n"
"{\n"
"tmp := sprintf_inverse (iri, \'http%s://%s/dataspace/%s/%s\', 0);\n"
"tmp := tmp[3];\n"
"pos := coalesce (strchr (tmp, \'#\'), strchr (tmp, \'/\'));\n"
"if (pos is not null)\n"
"uname := subseq (tmp, 0, pos);\n"
"else\n"
"uname := tmp;\n"
"ses := sioc..compose_foaf (uname, type, pg);\n"
"goto ret_place2;\n"
"}\n"
"else if (regexp_match (\'https?://([^/]*)/dataspace/([^/]*)(#this|/sioc.rdf|/sioc.n3)?\\x24\', iri) is not null\n"
"and __proc_exists (\'sioc.DBA.ods_sioc_obj_describe\') is not null)\n"
"{\n"
"tmp := sprintf_inverse (iri, \'http%s://%s/dataspace/%s\', 0);\n"
"tmp := tmp[2];\n"
"pos := coalesce (strchr (tmp, \'#\'), strchr (tmp, \'/\'));\n"
"if (pos is not null)\n"
"uname := subseq (tmp, 0, pos);\n"
"else\n"
"uname := tmp;\n"
"ses := sioc..ods_sioc_obj_describe (uname, type, pg);\n"
"goto ret_place2;\n"
"}\n"
"if (__proc_exists (\'sioc.DBA.ods_sioc_container_obj_describe\') is not null)\n"
"{\n"
"ses := sioc..ods_sioc_container_obj_describe (iri, type, pg);\n"
"goto ret_place2;\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.OdsIriDescribe (iri, type);\n"
"goto ret_place;\n"
"}\n"
"}\n"
"if (isstring (gr) and length (gr))\n"
"_from := sprintf (\' FROM <%s>\', gr);\n"
"\n"
"qr := sprintf (\'describe <%s> %s\', iri, _from);\n"
"path := vector ();\n"
"\n"
"params := vector (\'query\', qr, \'format\', \'application/rdf+xml\');\n"
"lines := vector ();\n"
"WS.WS.\"/!sparql/\" (path, params, lines);\n"
"ret_place:\n"
"ses := http_get_string_output (1);\n"
"ret_place2:\n"
"\n"
"http_rewrite ();\n"
"if (content_mode = 1)\n"
"http (ses, content);\n"
"else\n"
"content := string_output_string (ses);\n"
"return 0;\n"
"}\n"
"--src DET_RDFData.sql:592\n";

static const char *proc531 = 
"create function DB.DBA.\"RDFData_DAV_SYMLINK\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:683\n";

static const char *proc532 = 
"create function DB.DBA.\"RDFData_DAV_DEREFERENCE_LIST\" (in detcol_id any, inout report_array any) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:690\n";

static const char *proc533 = 
"create function DB.DBA.\"RDFData_DAV_RESOLVE_PATH\" (in detcol_id any, inout reference_item any, inout old_base varchar, inout new_base varchar) returns any\n"
"{\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:697\n";

static const char *proc534 = 
"create function DB.DBA.\"RDFData_DAV_LOCK\" (in path any, in id any, in type char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -20;\n"
"}\n"
"--src DET_RDFData.sql:703\n";

static const char *proc535 = 
"create function DB.DBA.\"RDFData_DAV_UNLOCK\" (in id any, in type char(1), in token varchar, in auth_uid integer)\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return -27;\n"
"}\n"
"--src DET_RDFData.sql:711\n";

static const char *proc536 = 
"create function DB.DBA.\"RDFData_DAV_IS_LOCKED\" (inout id any, inout type char(1), in owned_tokens varchar) returns integer\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return 0;\n"
"}\n"
"--src DET_RDFData.sql:718\n";

static const char *proc537 = 
"create function DB.DBA.\"RDFData_DAV_LIST_LOCKS\" (in id any, in type char(1), in recursive integer) returns any\n"
"{\n"
"RDFData_log_message (current_proc_name ());\n"
"return vector ();\n"
"}\n"
"--src DET_RDFData.sql:726\n";

static const char *proc538 = 
"create procedure DB.DBA.\"RDFData_MAKE_DET_COL\" (in path varchar, in gr varchar := null, in lg varchar := null)\n"
"{\n"
"declare colid int;\n"
"colid := DAV_MAKE_DIR (path, http_dav_uid (), null, \'110100100N\');\n"
"if (colid < 0)\n"
"signal (\'42000\', \'Unable to create RDFData DET collection\');\n"
"update WS.WS.SYS_DAV_COL set COL_DET=\'RDFData\' where COL_ID = colid;\n"
"if (gr is not null)\n"
"DAV_PROP_SET_INT (path, \'virt:rdfdata_graph\', gr, null, null, 0, 0, 1, http_dav_uid ());\n"
"if (lg is not null)\n"
"DAV_PROP_SET_INT (path, \'virt:rdfdata_lang\', lg, null, null, 0, 0, 1, http_dav_uid ());\n"
"}\n"
"--src DET_RDFData.sql:733\n";

/* DET_S3.sql */

static const char *proc539 = 
"create function DB.DBA.S3__encode (\n"
"in S varchar)\n"
"{\n"
"S := sprintf (\'%U\', S);\n"
"S := replace(S, \'\'\'\', \'%27\');\n"
"S := replace(S, \'%2F\', \'/\');\n"
"return S;\n"
"}\n"
"--src DET_S3.sql:24\n";

static const char *proc540 = 
"create function DB.DBA.S3__params (\n"
"in colID integer,\n"
"out bucket varchar,\n"
"out accessCode varchar,\n"
"out secretKey varchar)\n"
"{\n"
"bucket := DB.DBA.DAV_PROP_GET_INT (colID, \'C\', \'virt:S3-BucketName\', 0);\n"
"accessCode := DB.DBA.DAV_PROP_GET_INT (colID, \'C\', \'virt:S3-AccessKeyID\', 0);\n"
"secretKey := DB.DBA.DAV_PROP_GET_INT (colID, \'C\', \'virt:S3-SecretKey\', 0);\n"
"}\n"
"--src DET_S3.sql:36\n";

static const char *proc541 = 
"create function DB.DBA.S3__parts2path (\n"
"in bucket varchar,\n"
"in pathParts any,\n"
"in what any)\n"
"{\n"
"\n"
"declare path varchar;\n"
"\n"
"path := DB.DBA.DAV_CONCAT_PATH (pathParts, null);\n"
"if ((path <> \'\') and (chr (path[0]) <> \'/\'))\n"
"path := \'/\' || path;\n"
"if (bucket <> \'\')\n"
"path := \'/\' || bucket || path;\n"
"\n"
"path := rtrim (path, \'/\') || case when (what = \'C\') then \'/\' end;\n"
"return path;\n"
"}\n"
"--src DET_S3.sql:50\n";

static const char *proc542 = 
"create function DB.DBA.S3__item2entry (\n"
"in detcolID integer,\n"
"in detcolPath varchar,\n"
"in bucket varchar,\n"
"in item any)\n"
"{\n"
"\n"
"declare entryPath, entryType varchar;\n"
"declare detcolEntry any;\n"
"\n"
"if (item is null)\n"
"return null;\n"
"\n"
"detcolEntry := DB.DBA.DAV_DIR_SINGLE_INT (detcolID, \'C\', \'\', null, null, http_dav_uid ());\n"
"entryPath := get_keyword (\'path\', item);\n"
"if (not is_empty_or_null (bucket))\n"
"entryPath := subseq (entryPath, length (bucket)+1);\n"
"\n"
"entryType := get_keyword (\'type\', item);\n"
"if (\'C\' = entryType)\n"
"return vector (detcolPath || ltrim (entryPath, \'/\'),\n"
"entryType,\n"
"get_keyword (\'size\', item),\n"
"get_keyword (\'updated\', item),\n"
"vector (UNAME\'S3\', detcolID, entryPath),\n"
"detcolEntry[5],\n"
"detcolEntry[6],\n"
"detcolEntry[7],\n"
"get_keyword (\'updated\', item),\n"
"\'dav/unix-directory\',\n"
"get_keyword (\'name\', item)\n"
");\n"
"if (\'R\' = entryType)\n"
"return vector (detcolPath || ltrim (entryPath, \'/\'),\n"
"entryType,\n"
"get_keyword (\'size\', item),\n"
"get_keyword (\'updated\', item),\n"
"vector (UNAME\'S3\', detcolID, entryPath),\n"
"detcolEntry[5],\n"
"detcolEntry[6],\n"
"detcolEntry[7],\n"
"get_keyword (\'updated\', item),\n"
"http_mime_type (detcolPath || entryPath),\n"
"get_keyword (\'name\', item)\n"
");\n"
"}\n"
"--src DET_S3.sql:71\n";

static const char *proc543 = 
"create function DB.DBA.S3__headers2item (\n"
"in headers varchat,\n"
"in s3Path varchar,\n"
"in what varchar)\n"
"{\n"
"declare item any;\n"
"\n"
"item := vector (\'path\', s3Path,\n"
"\'name\', DB.DBA.S3__getNameFromUrl (s3Path),\n"
"\'type\', what,\n"
"\'etag\', http_request_header (headers, \'ETag\'),\n"
"\'size\', cast (http_request_header (headers, \'Content-Length\') as integer),\n"
"\'mimeType\', http_request_header (headers, \'Content-Type\'),\n"
"\'updated\', http_string_date (http_request_header (headers, \'Last-Modified\'))\n"
");\n"
"return item;\n"
"}\n"
"--src DET_S3.sql:120\n";

static const char *proc544 = 
"create function DB.DBA.S3__makeHostUrl (\n"
"in path varchar,\n"
"in isSecure integer := 1)\n"
"{\n"
"declare hostUrl, bucket, dir varchar;\n"
"declare s3Protocol, s3URL varchar;\n"
"\n"
"if (isSecure)\n"
"{\n"
"s3Protocol := \'http://\';\n"
"s3URL := \'http://s3.amazonaws.com\';\n"
"} else {\n"
"s3Protocol := \'http://\';\n"
"s3URL := \'http://s3.amazonaws.com\';\n"
"}\n"
"path := ltrim (path, \'/\');\n"
"bucket := DB.DBA.S3__getBucketFromUrl (path);\n"
"dir := \'\';\n"
"if (length (bucket) < length (path))\n"
"dir := subseq (path, length (bucket)+1);\n"
"if ((lcase (bucket) = bucket) and (bucket <> \'\'))\n"
"{\n"
"hostUrl := s3Protocol || bucket || \'.s3.amazonaws.com/\' || dir;\n"
"} else {\n"
"if (bucket <> \'\')\n"
"bucket := bucket || \'/\';\n"
"hostUrl := s3Protocol || \'s3.amazonaws.com/\' || bucket || dir;\n"
"}\n"
"return hostUrl;\n"
"}\n"
"--src DET_S3.sql:142\n";

static const char *proc545 = 
"create function DB.DBA.S3__getBucketFromUrl (\n"
"in url varchar)\n"
"{\n"
"declare parts any;\n"
"\n"
"parts := split_and_decode (trim (url, \'/\'), 0, \'\\0\\0/\');\n"
"if (length (parts) <> 0)\n"
"return parts[0];\n"
"return \'\';\n"
"}\n"
"--src DET_S3.sql:176\n";

static const char *proc546 = 
"create function DB.DBA.S3__getNameFromUrl (\n"
"in url varchar)\n"
"{\n"
"declare parts any;\n"
"\n"
"parts := split_and_decode (trim (url, \'/\'), 0, \'\\0\\0/\');\n"
"if (length (parts) <> 0)\n"
"return parts[length (parts) - 1];\n"
"return \'\';\n"
"}\n"
"--src DET_S3.sql:190\n";

static const char *proc547 = 
"create function DB.DBA.S3__getPathFromUrl (\n"
"in url varchar)\n"
"{\n"
"declare bucket any;\n"
"\n"
"bucket := DB.DBA.S3__getBucketFromUrl (url);\n"
"if (isnull (bucket))\n"
"return \'\';\n"
"return ltrim (subseq (url, length (bucket)+1), \'/\');\n"
"}\n"
"--src DET_S3.sql:204\n";

static const char *proc548 = 
"create function DB.DBA.S3__makeAWSHeader (\n"
"in accessCode varchar,\n"
"in secretKey varchar,\n"
"in authHeader varchar,\n"
"in authMode integer := 0)\n"
"{\n"
"declare S, T, hmacKey varchar;\n"
"\n"
"hmacKey := xenc_key_RAW_read (null, encode_base64 (secretKey));\n"
"S := xenc_hmac_sha1_digest (authHeader, hmacKey);\n"
"xenc_key_remove (hmacKey);\n"
"T := sprintf (\'AWS %s:%s\', accessCode, S);\n"
"if (authMode)\n"
"T := \'Authorization:\' || T;\n"
"\n"
"return T;\n"
"}\n"
"--src DET_S3.sql:218\n";

static const char *proc549 = 
"create function DB.DBA.S3__getBuckets (\n"
"in accessCode varchar,\n"
"in secretKey varchar,\n"
"in bucket varchar := null)\n"
"{\n"
"\n"
"declare dateUTC, authHeader, path, S varchar;\n"
"declare reqHdr, resHdr varchar;\n"
"declare xt, xtItems, buckets any;\n"
"\n"
"path := \'/\';\n"
"dateUTC := date_rfc1123 (now());\n"
"S := sprintf (\'GET\\n\\n\\n%s\\n%s\', dateUTC, path);\n"
"authHeader := DB.DBA.S3__makeAWSHeader (accessCode, secretKey, S);\n"
"reqHdr := sprintf (\'Authorization: %s\\r\\nDate: %s\', authHeader, dateUTC);\n"
"commit work;\n"
"xt := http_client_ext (DB.DBA.S3__makeHostUrl (path),\n"
"http_method=>\'GET\',\n"
"http_headers=>reqHdr,\n"
"headers=>resHdr);\n"
"\n"
"if (resHdr[0] like \'HTTP/1._ 4__ %\' or resHdr[0] like \'HTTP/1._ 5__ %\')\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"buckets := vector ();\n"
"xt := xml_tree_doc (xt);\n"
"xtItems := xpath_eval (\'//Buckets/Bucket\', xt, 0);\n"
"foreach (any xtItem in xtItems) do\n"
"{\n"
"declare name, creationDate any;\n"
"\n"
"name := cast (xpath_eval (\'./Name\', xtItem) as varchar);\n"
"if ((name = bucket) or isnull (bucket))\n"
"{\n"
"creationDate := stringdate (cast (xpath_eval (\'./CreationDate\', xtItem) as varchar));\n"
"buckets := vector_concat (buckets, vector (\n"
"vector (\'path\', \'/\' || name || \'/\',\n"
"\'name\', name,\n"
"\'type\', \'C\',\n"
"\'updated\', creationDate,\n"
"\'size\', 0\n"
")\n"
")\n"
");\n"
"}\n"
"}\n"
"return buckets;\n"
"}\n"
"--src DET_S3.sql:239\n";

static const char *proc550 = 
"create function DB.DBA.S3__getBucket (\n"
"in accessCode varchar,\n"
"in secretKey varchar,\n"
"in url varchar,\n"
"in delimiter varchar := \'/\')\n"
"{\n"
"\n"
"declare N integer;\n"
"declare dateUTC, authHeader, S, bucket, bucketPath varchar;\n"
"declare reqHdr, resHdr, params varchar;\n"
"declare xt, xtItems, buckets any;\n"
"\n"
"\n"
"\n"
"bucket := \'/\' || DB.DBA.S3__getBucketFromUrl (url) || \'/\';\n"
"bucketPath := DB.DBA.S3__getPathFromUrl (url);\n"
"dateUTC := date_rfc1123 (now());\n"
"S := sprintf (\'GET\\n\\n\\n%s\\n%s\', dateUTC, bucket);\n"
"authHeader := DB.DBA.S3__makeAWSHeader (accessCode, secretKey, S);\n"
"reqHdr := sprintf (\'Authorization: %s\\r\\nDate: %s\', authHeader, dateUTC);\n"
"params := sprintf (\'?prefix=%U&marker=%s&delimiter=%s\', bucketPath, \'\', delimiter);\n"
"commit work;\n"
"xt := http_client_ext (url=>DB.DBA.S3__makeHostUrl (bucket) || params,\n"
"http_method=>\'GET\',\n"
"http_headers=>reqHdr,\n"
"headers=>resHdr);\n"
"\n"
"if (resHdr[0] like \'HTTP/1._ 4__ %\' or resHdr[0] like \'HTTP/1._ 5__ %\')\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"\n"
"buckets := vector ();\n"
"xt := xml_tree_doc (xt);\n"
"xtItems := xpath_eval (\'//Contents\', xt, 0);\n"
"foreach (any xtItem in xtItems) do\n"
"{\n"
"declare keyName, itemPath, itemName, itemType, lastModified, itemSize, itemETag any;\n"
"\n"
"keyName := cast (xpath_eval (\'./Key\', xtItem) as varchar);\n"
"keyName := replace (keyName, bucketPath, \'\');\n"
"itemName := replace (keyName, \'_\\$folder\\$\', \'\');\n"
"itemType := case when (itemName <> keyName) then \'C\' else \'R\' end;\n"
"itemPath := url || itemName || case when (itemType = \'C\') then \'/\' end;\n"
"lastModified := stringdate (cast (xpath_eval (\'./LastModified\', xtItem) as varchar));\n"
"itemSize := cast (xpath_eval (\'./Size\', xtItem) as integer);\n"
"itemETag := cast (xpath_eval (\'./ETag\', xtItem) as varchar);\n"
"buckets := vector_concat (buckets, vector (\n"
"vector (\'path\', itemPath,\n"
"\'name\', itemName,\n"
"\'type\', itemType,\n"
"\'updated\', lastModified,\n"
"\'size\', itemSize,\n"
"\'etag\', itemETag\n"
")\n"
")\n"
");\n"
"}\n"
"return buckets;\n"
"}\n"
"--src DET_S3.sql:295\n";

static const char *proc551 = 
"create function DB.DBA.S3__putObject (\n"
"in accessCode varchar,\n"
"in secretKey varchar,\n"
"in s3Path varchar,\n"
"inout s3Content any,\n"
"inout s3Type any)\n"
"{\n"
"\n"
"declare dateUTC, authHeader, S, what, workPath varchar;\n"
"declare reqHdr, resHdr, xt varchar;\n"
"\n"
"what := case when (chr (s3Path [length (s3Path) - 1]) = \'/\') then \'C\' else \'R\' end;\n"
"workPath := DB.DBA.S3__encode (s3Path);\n"
"if (trim (s3Path, \'/\') <> DB.DBA.S3__getBucketFromUrl (s3Path))\n"
"workPath := rtrim (workPath, \'/\') || case when (what = \'C\') then \'_\\$folder\\$\' end;\n"
"dateUTC := date_rfc1123 (now());\n"
"S := sprintf (\'PUT\\n\\n%s\\n%s\\n%s\', coalesce (s3Type, \'\'), dateUTC, workPath);\n"
"authHeader := DB.DBA.S3__makeAWSHeader (accessCode, secretKey, S);\n"
"reqHdr := sprintf (\'Authorization: %s\\r\\nDate: %s\', authHeader, dateUTC);\n"
"if (not isnull (s3Type))\n"
"reqHdr := sprintf (\'%s\\r\\nContent-Type: %s\', reqHdr, s3Type);\n"
"if (not isnull (s3Content))\n"
"reqHdr := sprintf (\'%s\\r\\nContent-Length: %d\', reqHdr, length(s3Content));\n"
"commit work;\n"
"\n"
"xt := http_client_ext (url=>DB.DBA.S3__makeHostUrl (workPath),\n"
"http_method=>\'PUT\',\n"
"http_headers=>reqHdr,\n"
"headers=>resHdr,\n"
"body=>s3Content);\n"
"if (resHdr[0] like \'HTTP/1._ 4__ %\' or resHdr[0] like \'HTTP/1._ 5__ %\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_S3.sql:360\n";

static const char *proc552 = 
"create function DB.DBA.S3__headObject (\n"
"in accessCode varchar,\n"
"in secretKey varchar,\n"
"in s3Path varchar,\n"
"in what varchar,\n"
"in s3Mode integer := 1)\n"
"{\n"
"\n"
"declare dateUTC, authHeader, S, workPath varchar;\n"
"declare reqHdr, resHdr varchar;\n"
"declare item, xt any;\n"
"\n"
"item := connection_get (\'S3__\' || s3Path);\n"
"if (isnull (item))\n"
"{\n"
"if (trim (s3Path, \'/\') = DB.DBA.S3__getBucketFromUrl (s3Path))\n"
"{\n"
"\n"
"item := DB.DBA.S3__getBuckets (accessCode, secretKey, trim (s3Path, \'/\'));\n"
"if (length (item) < 1)\n"
"return null;\n"
"item := item[0];\n"
"} else {\n"
"\n"
"workPath := DB.DBA.S3__encode (s3Path);\n"
"workPath := rtrim (workPath, \'/\') || case when (what = \'C\') then \'_\\$folder\\$\' end;\n"
"dateUTC := date_rfc1123 (now());\n"
"S := sprintf (\'HEAD\\n\\n\\n%s\\n%s\', dateUTC, workPath);\n"
"authHeader := DB.DBA.S3__makeAWSHeader (accessCode, secretKey, S);\n"
"reqHdr := sprintf (\'Authorization: %s\\r\\nDate: %s\', authHeader, dateUTC);\n"
"commit work;\n"
"xt := http_client_ext (url=>DB.DBA.S3__makeHostUrl (workPath),\n"
"http_method=>\'HEAD\',\n"
"http_headers=>reqHdr,\n"
"headers=>resHdr);\n"
"if (resHdr[0] like \'HTTP/1._ 4__ %\' or resHdr[0] like \'HTTP/1._ 5__ %\')\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"item := DB.DBA.S3__headers2item (resHdr, s3Path, what);\n"
"}\n"
"connection_set (\'S3__\' || s3Path, item);\n"
"}\n"
"if (s3Mode)\n"
"return 1;\n"
"return item;\n"
"}\n"
"--src DET_S3.sql:401\n";

static const char *proc553 = 
"create function DB.DBA.S3__getObject (\n"
"in accessCode varchar,\n"
"in secretKey varchar,\n"
"in s3Path varchar)\n"
"{\n"
"\n"
"declare dateUTC, authHeader, S, what, workPath varchar;\n"
"declare reqHdr, resHdr varchar;\n"
"declare xt, item any;\n"
"\n"
"workPath := DB.DBA.S3__encode (s3Path);\n"
"what := case when (chr (s3Path [length (s3Path) - 1]) = \'/\') then \'C\' else \'R\' end;\n"
"workPath := rtrim (workPath, \'/\') || case when (what = \'C\') then \'_\\$folder\\$\' end;\n"
"dateUTC := date_rfc1123 (now());\n"
"S := sprintf (\'GET\\n\\n\\n%s\\n%s\', dateUTC, workPath);\n"
"authHeader := DB.DBA.S3__makeAWSHeader (accessCode, secretKey, S);\n"
"reqHdr := sprintf (\'Authorization: %s\\r\\nDate: %s\', authHeader, dateUTC);\n"
"commit work;\n"
"xt := http_client_ext (url=>DB.DBA.S3__makeHostUrl (workPath),\n"
"http_method=>\'GET\',\n"
"http_headers=>reqHdr,\n"
"headers=>resHdr);\n"
"if (resHdr[0] like \'HTTP/1._ 4__ %\' or resHdr[0] like \'HTTP/1._ 5__ %\')\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"\n"
"item := vector_concat (vector (\'content\', xt), DB.DBA.S3__headers2item (resHdr, s3Path, what));\n"
"return item;\n"
"}\n"
"--src DET_S3.sql:453\n";

static const char *proc554 = 
"create function DB.DBA.S3__deleteObject (\n"
"in accessCode varchar,\n"
"in secretKey varchar,\n"
"in s3Path varchar)\n"
"{\n"
"\n"
"declare dateUTC, authHeader, S, what, workPath varchar;\n"
"declare reqHdr, resHdr varchar;\n"
"declare items, xt any;\n"
"\n"
"dateUTC := date_rfc1123 (now());\n"
"what := case when (chr (s3Path [length (s3Path) - 1]) = \'/\') then \'C\' else \'R\' end;\n"
"items := vector (vector (\'path\', s3Path));\n"
"if (what = \'c\')\n"
"items := vector_concat (items, DB.DBA.S3__getBucket (accessCode, secretKey, s3Path, \'\'));\n"
"\n"
"foreach (any item in items) do\n"
"{\n"
"s3Path := get_keyword (\'path\', item);\n"
"what := case when (chr (s3Path [length (s3Path) - 1]) = \'/\') then \'C\' else \'R\' end;\n"
"workPath := DB.DBA.S3__encode (s3Path);\n"
"if (trim (s3Path, \'/\') <> DB.DBA.S3__getBucketFromUrl (s3Path))\n"
"workPath := rtrim (workPath, \'/\') || case when (what = \'C\') then \'_\\$folder\\$\' end;\n"
"S := sprintf (\'DELETE\\n\\n\\n%s\\n%s\', dateUTC, workPath);\n"
"authHeader := DB.DBA.S3__makeAWSHeader (accessCode, secretKey, S);\n"
"reqHdr := sprintf (\'Authorization: %s\\r\\nDate: %s\', authHeader, dateUTC);\n"
"commit work;\n"
"http_client_ext (url=>DB.DBA.S3__makeHostUrl (workPath),\n"
"http_method=>\'DELETE\',\n"
"http_headers=>reqHdr,\n"
"headers=>resHdr);\n"
"if (resHdr[0] like \'HTTP/1._ 4__ %\' or resHdr[0] like \'HTTP/1._ 5__ %\')\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"connection_set (\'S3__\' || s3Path, null);\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_S3.sql:488\n";

static const char *proc555 = 
"create function DB.DBA.\"S3_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"\n"
"if (auth_uid >= 0)\n"
"return auth_uid;\n"
"return -12;\n"
"}\n"
"--src DET_S3.sql:532\n";

static const char *proc556 = 
"create function DB.DBA.\"S3_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare puid, pgid integer;\n"
"declare u_password, pperms varchar;\n"
"declare allow_anon integer;\n"
"\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"whenever not found goto nf_col_or_res;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce\n"
"(\n"
"( select G_ID\n"
"from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'S3_\' || coalesce ((select COL_NAME\n"
"from WS.WS.SYS_DAV_COL\n"
"where COL_ID = id[1] and COL_DET = \'S3\'), \'\')\n"
"),\n"
"puid+1\n"
");\n"
"pperms := \'110100100NN\';\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"allow_anon := WS.WS.PERM_COMP (substring (cast (pperms as varchar), 7, 3), req);\n"
"if (a_uid is null)\n"
"{\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (isinteger (a_uid))\n"
"{\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1)\n"
"{\n"
"a_uid := http_nobody_uid ();\n"
"a_gid := http_nogroup_gid ();\n"
"}\n"
"}\n"
"if (DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"return a_uid;\n"
"return -13;\n"
"\n"
"nf_col_or_res:\n"
"return -1;\n"
"}\n"
"--src DET_S3.sql:546\n";

static const char *proc557 = 
"create function DB.DBA.\"S3_DAV_GET_PARENT\" (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:602\n";

static const char *proc558 = 
"create function DB.DBA.\"S3_DAV_COL_CREATE\" (in detcolID any, in pathParts any, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare bucket, accessCode, secretKey, s3Path, s3Content, s3Type varchar;\n"
"\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"s3Path := DB.DBA.S3__parts2path (bucket, pathParts, \'C\');\n"
"s3Content := null;\n"
"s3Type := null;\n"
"if (DB.DBA.S3__putObject (accessCode, secretKey, s3Path, s3Content, s3Type) < 1)\n"
"return -1;\n"
"return vector (UNAME\'S3\', detcolID, s3Path);\n"
"}\n"
"--src DET_S3.sql:611\n";

static const char *proc559 = 
"create function DB.DBA.\"S3_DAV_DELETE\" (\n"
"in detcolID any,\n"
"in pathParts any,\n"
"in what char(1),\n"
"in silent integer,\n"
"in auth_uid integer) returns integer\n"
"{\n"
"\n"
"declare bucket, accessCode, secretKey, s3Path varchar;\n"
"\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"s3Path := DB.DBA.S3__parts2path (bucket, pathParts, what);\n"
"return DB.DBA.S3__deleteObject (accessCode, secretKey, s3Path);\n"
"}\n"
"--src DET_S3.sql:627\n";

static const char *proc560 = 
"create function DB.DBA.\"S3_DAV_RES_UPLOAD\" (in detcolID any, in pathParts any, inout content any, in type varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:647\n";

static const char *proc561 = 
"create function DB.DBA.\"S3_DAV_PROP_REMOVE\" (in id any, in what char(0), in propname varchar, in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:657\n";

static const char *proc562 = 
"create function DB.DBA.\"S3_DAV_PROP_SET\" (in id any, in what char(0), in propname varchar, in propvalue any, in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (propname[0] = 58)\n"
"return -16;\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:666\n";

static const char *proc563 = 
"create function DB.DBA.\"S3_DAV_PROP_GET\" (in id any, in what char(0), in propname varchar, in auth_uid integer)\n"
"{\n"
"\n"
"return -11;\n"
"}\n"
"--src DET_S3.sql:677\n";

static const char *proc564 = 
"create function DB.DBA.\"S3_DAV_PROP_LIST\" (in id any, in what char(0), in propmask varchar, in auth_uid integer)\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"--src DET_S3.sql:686\n";

static const char *proc565 = 
"create function DB.DBA.\"S3_DAV_DIR_SINGLE\" (\n"
"in id any,\n"
"in what char(0),\n"
"in path any,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare detcolID integer;\n"
"declare bucket, accessCode, secretKey, detcolPath, s3Path varchar;\n"
"declare s3Object any;\n"
"\n"
"detcolID := id[1];\n"
"s3Path := id[2];\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"s3Object := DB.DBA.S3__headObject (accessCode, secretKey, s3Path, what, 0);\n"
"if (isnull (s3Object))\n"
"return -1;\n"
"detcolPath := DB.DBA.DAV_SEARCH_PATH (detcolID, \'C\');\n"
"return DB.DBA.S3__item2entry (detcolID, detcolPath, bucket, s3Object);\n"
"}\n"
"--src DET_S3.sql:694\n";

static const char *proc566 = 
"create function DB.DBA.\"S3_DAV_DIR_LIST\" (\n"
"in detcolID any,\n"
"in pathParts any,\n"
"in detcol_pathParts any,\n"
"in name_mask varchar,\n"
"in recursive integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare N integer;\n"
"declare bucket, accessCode, secretKey, s3Path varchar;\n"
"declare detcolPath varchar;\n"
"declare res, items any;\n"
"\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"if (is_empty_or_null (bucket) and (length (pathParts) = 1) and pathParts[0] = \'\')\n"
"{\n"
"s3Path := \'/\';\n"
"items := DB.DBA.S3__getBuckets (accessCode, secretKey);\n"
"}\n"
"else\n"
"{\n"
"s3Path := DB.DBA.S3__parts2path (bucket, pathParts, \'C\');\n"
"items := DB.DBA.S3__getBucket (accessCode, secretKey, s3Path);\n"
"}\n"
"detcolPath := DB.DBA.DAV_CONCAT_PATH (detcol_pathParts, \'/\');\n"
"res := vector ();\n"
"for (N := 0; N < length (items); N := N + 1)\n"
"{\n"
"res := vector_concat (res, vector (DB.DBA.S3__item2entry (detcolID, detcolPath, bucket, items[N])));\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_S3.sql:717\n";

static const char *proc567 = 
"create function DB.DBA.\"S3_DAV_DIR_FILTER\" (in detcolID any, in pathParts any, in detcol_path varchar, inout compilation any, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"--src DET_S3.sql:753\n";

static const char *proc568 = 
"create function DB.DBA.\"S3_DAV_SEARCH_ID\" (\n"
"in detcolID any,\n"
"in pathParts any,\n"
"in what char(1)) returns any\n"
"{\n"
"\n"
"declare bucket, accessCode, secretKey, s3Path varchar;\n"
"declare s3Object any;\n"
"\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"s3Path := DB.DBA.S3__parts2path (bucket, pathParts, what);\n"
"s3Object := DB.DBA.S3__headObject (accessCode, secretKey, s3Path, what, 1);\n"
"if (isnull (s3Object))\n"
"return -1;\n"
"return vector (UNAME\'S3\', detcolID, s3Path);\n"
"}\n"
"--src DET_S3.sql:761\n";

static const char *proc569 = 
"create function DB.DBA.\"S3_DAV_SEARCH_PATH\" (\n"
"in id any,\n"
"in what char(1)) returns any\n"
"{\n"
"\n"
"declare detcolID integer;\n"
"declare bucket, accessCode, secretKey, detcolPath, s3Path varchar;\n"
"declare s3Object any;\n"
"\n"
"detcolID := id[1];\n"
"detcolPath := coalesce ((select WS.WS.COL_PATH (COL_ID) from WS.WS.SYS_DAV_COL where COL_ID = detcolID and COL_DET = \'S3\'));\n"
"if (detcolPath is null)\n"
"return -23;\n"
"s3Path := id[2];\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"s3Object := DB.DBA.S3__headObject (accessCode, secretKey, s3Path, what, 0);\n"
"if (isnull (s3Object))\n"
"return -23;\n"
"return rtrim (detcolPath, \'/\') || get_keyword (\'path\', s3Object);\n"
"}\n"
"--src DET_S3.sql:780\n";

static const char *proc570 = 
"create function DB.DBA.\"S3_DAV_RES_UPLOAD\" (\n"
"in detcolID any,\n"
"in pathParts any,\n"
"inout content any,\n"
"in type varchar,\n"
"in permissions varchar,\n"
"in uid integer,\n"
"in gid integer,\n"
"in auth_uid integer) returns any\n"
"{\n"
"\n"
"declare bucket, accessCode, secretKey, s3Path varchar;\n"
"\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"s3Path := DB.DBA.S3__parts2path (bucket, pathParts, \'R\');\n"
"if (DB.DBA.S3__putObject (accessCode, secretKey, s3Path, content, type) < 1)\n"
"return -1;\n"
"return vector (UNAME\'S3\', detcolID, s3Path);\n"
"}\n"
"--src DET_S3.sql:802\n";

static const char *proc571 = 
"create function DB.DBA.\"S3_DAV_RES_UPLOAD_COPY\" (in detcolID any, in pathParts any, in sourceID any, in what char(1), in overwrite_flags integer, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (what = \'R\')\n"
"{\n"
"declare bucket, accessCode, secretKey, s3Path varchar;\n"
"\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"s3Path := DB.DBA.S3__parts2path (bucket, pathParts, \'R\');\n"
"\n"
"declare rc integer;\n"
"declare sourceContent, sourceMimeType any;\n"
"\n"
"rc := DB.DBA.DAV_RES_CONTENT_INT (sourceID, sourceContent, sourceMimeType, 0, 0);\n"
"if (rc < 0)\n"
"return rc;\n"
"\n"
"sourceContent := case when (__tag (sourceContent) = 126) then blob_to_string (sourceContent) else sourceContent end;\n"
"if (DB.DBA.S3__putObject (accessCode, secretKey, s3Path, sourceContent, sourceMimeType) < 1)\n"
"return -28;\n"
"\n"
"return vector (UNAME\'S3\', detcolID, s3Path);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:824\n";

static const char *proc572 = 
"create function DB.DBA.\"S3_DAV_RES_UPLOAD_MOVE\" (in detcolID any, in pathParts any, in sourceID any, in what char(1), in overwrite_flags integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (what = \'R\')\n"
"{\n"
"declare rc integer;\n"
"declare sourcePath, sourceContent, sourceMimeType any;\n"
"declare bucket, accessCode, secretKey, s3Path varchar;\n"
"\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"s3Path := DB.DBA.S3__parts2path (bucket, pathParts, \'R\');\n"
"\n"
"rc := DB.DBA.DAV_RES_CONTENT_INT (sourceID, sourceContent, sourceMimeType, 0, 0);\n"
"if (rc < 0)\n"
"return rc;\n"
"\n"
"sourceContent := case when (__tag (sourceContent) = 126) then blob_to_string (sourceContent) else sourceContent end;\n"
"if (DB.DBA.S3__putObject (accessCode, secretKey, s3Path, sourceContent, sourceMimeType) < 1)\n"
"return -28;\n"
"\n"
"sourcePath := DB.DBA.DAV_SEARCH_PATH (sourceID, \'R\');\n"
"if (not isnull (sourcePath))\n"
"DB.DBA.DAV_DELETE_INT (sourcePath, 1, null, null, 0);\n"
"\n"
"return vector (UNAME\'S3\', detcolID, s3Path);\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:852\n";

static const char *proc573 = 
"create function DB.DBA.\"S3_DAV_RES_CONTENT\" (\n"
"in id any,\n"
"inout content any,\n"
"out type varchar,\n"
"in content_mode integer) returns integer\n"
"{\n"
"\n"
"declare detcolID integer;\n"
"declare bucket, accessCode, secretKey, s3Path varchar;\n"
"declare s3Object, s3Content any;\n"
"\n"
"detcolID := id[1];\n"
"s3Path := id[2];\n"
"DB.DBA.S3__params (detcolID, bucket, accessCode, secretKey);\n"
"\n"
"s3Object := DB.DBA.S3__getObject (accessCode, secretKey, s3Path);\n"
"if (isnull (s3Object))\n"
"return -1;\n"
"\n"
"s3Content := get_keyword (\'content\', s3Object);\n"
"type := get_keyword (\'mimeType\', s3Object);\n"
"if ((content_mode = 0) or (content_mode = 2))\n"
"content := s3Content;\n"
"else if (content_mode = 1)\n"
"http (s3Content, content);\n"
"else if (content_mode = 3)\n"
"http (s3Content);\n"
"\n"
"return 0;\n"
"}\n"
"--src DET_S3.sql:884\n";

static const char *proc574 = 
"create function DB.DBA.\"S3_DAV_SYMLINK\" (in detcolID any, in pathParts any, in sourceID any, in what char(1), in overwrite integer, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:917\n";

static const char *proc575 = 
"create function DB.DBA.\"S3_DAV_DEREFERENCE_LIST\" (in detcolID any, inout report_array any) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:925\n";

static const char *proc576 = 
"create function DB.DBA.\"S3_DAV_RESOLVE_PATH\" (in detcolID any, inout reference_item any, inout old_base varchar, inout new_base varchar) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:933\n";

static const char *proc577 = 
"create function DB.DBA.\"S3_DAV_LOCK\" (in path any, in id any, in type char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_S3.sql:941\n";

static const char *proc578 = 
"create function DB.DBA.\"S3_DAV_UNLOCK\" (in id any, in type char(1), in token varchar, in auth_uid integer)\n"
"{\n"
"\n"
"return -27;\n"
"}\n"
"--src DET_S3.sql:949\n";

static const char *proc579 = 
"create function DB.DBA.\"S3_DAV_IS_LOCKED\" (inout id any, inout Type char(1), in owned_tokens varchar) returns integer\n"
"{\n"
"\n"
"declare rc integer;\n"
"declare orig_id any;\n"
"declare orig_type char(1);\n"
"\n"
"\n"
"orig_id := id;\n"
"orig_type := type;\n"
"\n"
"ID := orig_id[1];\n"
"Type := \'C\';\n"
"rc := DB.DBA.DAV_IS_LOCKED_INT (id, type, owned_tokens);\n"
"\n"
"\n"
"id := orig_id;\n"
"Type := orig_type;\n"
"if (rc <> 0)\n"
"return rc;\n"
"return 0;\n"
"}\n"
"--src DET_S3.sql:958\n";

static const char *proc580 = 
"create function DB.DBA.\"S3_DAV_LIST_LOCKS\" (in id any, in type char(1), in recursive integer) returns any\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"--src DET_S3.sql:984\n";

/* DET_Versioning.sql */

static const char *tbl7 = 
"CREATE TABLE WS.WS.SYS_DAV_RES_VERSION (\n"
"RV_RES_ID INTEGER NOT NULL,\n"
"RV_ID INTEGER NOT NULL,\n"
"RV_NODE_NAME VARCHAR,\n"
"RV_PREV_ID INTEGER,\n"
"RV_ACT_ID INTEGER,\n"
"RV_RES_TYPE VARCHAR,\n"
"RV_CR_TIME  DATETIME,\n"
"RV_MOD_TIME DATETIME,\n"
"RV_WHO VARCHAR,\n"
"RV_SIZE INTEGER NOT NULL,\n"
"PRIMARY KEY (RV_RES_ID, RV_ID)\n"
")\n"
"alter index SYS_DAV_RES_VERSION on WS.WS.SYS_DAV_RES_VERSION partition (RV_RES_ID int)\n";

static const char *tbl8 = 
"CREATE TABLE WS.WS.SYS_DAV_RES_DIFF (\n"
"RD_RES_ID       INTEGER NOT NULL,\n"
"RD_TO_ID        INTEGER NOT NULL,\n"
"RD_FROM_ID      INTEGER,\n"
"RD_PROPS    LONG XML,\n"
"RD_DELTA    LONG VARBINARY,\n"
"RD_MODE     CHAR(1),\n"
"RD_ARGS     VARCHAR DEFAULT \'\',\n"
"PRIMARY KEY (RD_RES_ID, RD_TO_ID, RD_FROM_ID)\n"
")\n"
"alter index SYS_DAV_RES_DIFF on WS.WS.SYS_DAV_RES_DIFF partition (RD_RES_ID int)\n";

static const char *tbl9 = 
"CREATE TABLE WS.WS.SYS_DAV_RES_MERGE (\n"
"RM_RES_ID INTEGER NOT NULL,\n"
"RM_ID INTEGER NOT NULL,\n"
"RM_BRANCH_PREV_ID INTEGER NOT NULL,\n"
"RM_ACT_ID INTEGER,\n"
"PRIMARY KEY (RM_RES_ID, RM_ID, RM_BRANCH_PREV_ID)\n"
")\n"
"alter index SYS_DAV_RES_MERGE on WS.WS.SYS_DAV_RES_MERGE partition (RM_RES_ID int)\n";

static const char *tbl10 = 
"CREATE TABLE WS.WS.SYS_DAV_ACTIVITY (\n"
"ACT_ID        INTEGER NOT NULL,\n"
"ACT_NAME      VARCHAR(256) NOT NULL,\n"
"ACT_CR_TIME   DATETIME NOT NULL,\n"
"ACT_CR_USER   VARCHAR NOT NULL,\n"
"PRIMARY KEY (ACT_ID)\n"
")\n"
"alter index SYS_DAV_ACTIVITY on WS.WS.SYS_DAV_ACTIVITY partition (ACT_ID int)\n";

static const char *tbl11 = 
"CREATE TABLE WS.WS.SYS_DAV_WORKSPACE (\n"
"WS_COL_ID  INTEGER NOT NULL,\n"
"WS_NAME    VARCHAR(256) NOT NULL,\n"
"WS_CR_TIME DATETIME NOT NULL,\n"
"WS_CR_USER VARCHAR NOT NULL,\n"
"PRIMARY KEY (WS_COL_ID)\n"
")\n"
"alter index SYS_DAV_WORKSPACE on WS.WS.SYS_DAV_WORKSPACE partition (WS_COL_ID int)\n";

static const char *tbl12 = 
"CREATE TABLE WS.WS.SYS_DAV_CONFOBJ (\n"
"CONFO_ID INTEGER NOT NULL,\n"
"CONFO_NAME VARCHAR(256) NOT NULL,\n"
"CONFO_CR_TIME DATETIME NOT NULL,\n"
"CONFO_CR_USER VARCHAR NOT NULL,\n"
"PRIMARY KEY (CONFO_ID)\n"
")\n"
"alter index SYS_DAV_CONFOBJ on WS.WS.SYS_DAV_CONFOBJ partition (CONFO_ID int)\n";

static const char *tbl13 = 
"CREATE TABLE WS.WS.SYS_DAV_BASELINE (\n"
"BL_CONFO_ID INTEGER NOT NULL UNIQUE,\n"
"BL_ID      INTEGER NOT NULL UNIQUE,\n"
"BL_NAME    VARCHAR(256) NOT NULL,\n"
"BL_CR_TIME DATETIME,\n"
"BL_CR_USER VARCHAR,\n"
"PRIMARY KEY (BL_CONFO_ID, BL_ID)\n"
")\n"
"alter index SYS_DAV_BASELINE on WS.WS.SYS_DAV_BASELINE partition (BL_CONFO_ID int)\n";

static const char *tbl14 = 
"CREATE TABLE WS.WS.SYS_DAV_BASELINE_RES (\n"
"BR_CONFO_ID     INTEGER NOT NULL,\n"
"BR_BL_ID      INTEGER NOT NULL,\n"
"BR_RES_ID     INTEGER NOT NULL,\n"
"BR_VERSION_ID INTEGER NOT NULL,\n"
"PRIMARY KEY (BR_CONFO_ID, BR_BL_ID, BR_RES_ID)\n"
")\n"
"alter index SYS_DAV_BASELINE_RES on WS.WS.SYS_DAV_BASELINE_RES partition (BR_RES_ID int)\n";

static const char *trig40 = 
"CREATE TRIGGER \"Versioning_DAV_DELETE\" BEFORE DELETE ON WS.WS.SYS_DAV_RES REFERENCING OLD AS O\n"
"{\n"
"\n"
"\n"
"\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = O.RES_ID;\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = O.RES_ID;\n"
"}\n"
"--src DET_Versioning.sql:147\n";

static const char *trig41 = 
"CREATE TRIGGER \"Versioning_DAV_DELETE_AFT\" AFTER DELETE ON WS.WS.SYS_DAV_RES REFERENCING OLD AS O\n"
"{\n"
"\n"
"connection_set (\'Versioning REM PROP\', NULL);\n"
"}\n"
"--src DET_Versioning.sql:158\n";

static const char *trig42 = 
"CREATE TRIGGER \"Versioning_PROP_DELETE\" BEFORE DELETE ON WS.WS.SYS_DAV_PROP REFERENCING OLD AS O\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"\n"
"resignal;\n"
"}\n"
" ;\n"
"\n"
"\n"
"\n"
"if (connection_get (\'Versioning REM PROP\') is null and O.PROP_NAME in (\'DAV:checked-in\', \'DAV:checked-out\', \'DAV:version-history\', \'DAV:author\'))\n"
"signal (\'VR004\', O.PROP_NAME || \' property belongs to Versioning control and it is read-only\');\n"
"}\n"
"--src DET_Versioning.sql:166\n";

static const char *proc581 = 
"create procedure \"Versioning_ADD_NEW_DIFF\" (in _res_id int,\n"
"in version_id int,\n"
"in version_prev_id int,\n"
"inout _curr_content any,\n"
"in _type char(1),\n"
"in _diff varchar:=NULL)\n"
"{\n"
"declare _ver_id, _ver_prev_id int;\n"
"if (version_id is null)\n"
"_ver_id := 1;\n"
"else\n"
"_ver_id := version_id;\n"
"if (version_prev_id is null)\n"
"_ver_prev_id := 0;\n"
"else\n"
"_ver_prev_id := version_prev_id;\n"
"\n"
"if (\'c\' = _type) {\n"
"update WS.WS.SYS_DAV_RES_DIFF\n"
"set RD_FROM_ID = _ver_id\n"
"where RD_RES_ID = _res_id\n"
"and RD_TO_ID = _ver_prev_id;\n"
"}\n"
"else if ( (\'D\' = _type) and (_diff is not null) ) {\n"
"update WS.WS.SYS_DAV_RES_DIFF\n"
"set RD_FROM_ID = _ver_id,\n"
"RD_DELTA = _diff,\n"
"RD_MODE = _type\n"
"where RD_RES_ID = _res_id\n"
"and RD_TO_ID = _ver_prev_id;\n"
"}\n"
"else\n"
"signal (\'VR001\', \'Unsupported delta algorithm: \' || _type );\n"
"\n"
"\n"
"declare _props any;\n"
"_props := (select XMLELEMENT (\'Props\',\n"
"XMLAGG (\n"
"XMLELEMENT (\'property\',\n"
"XMLATTRIBUTES (PROP_NAME as \"name\"),\n"
"PROP_VALUE)))\n"
"from WS.WS.SYS_DAV_PROP\n"
"where PROP_PARENT_ID = _res_id\n"
"and PROP_NAME not like \'DAV:%\'\n"
"and PROP_NAME not like \':%\'\n"
"and PROP_NAME not like \'virt:\');\n"
"insert into WS.WS.SYS_DAV_RES_DIFF (\n"
"RD_RES_ID,\n"
"RD_TO_ID,\n"
"RD_FROM_ID,\n"
"RD_PROPS,\n"
"RD_DELTA,\n"
"RD_MODE )\n"
"values\n"
"( _res_id, _ver_id, 0, _props, _curr_content, \'c\');\n"
"\n"
"}\n"
"--src DET_Versioning.sql:181\n";

static const char *trig43 = 
"CREATE TRIGGER \"Versioning_DAV_RES_INSERT\" AFTER INSERT ON WS.WS.SYS_DAV_RES ORDER 10 REFERENCING NEW AS N\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"rollback work;\n"
"\n"
"resignal;\n"
"}\n"
" ;\n"
"if (exists (select 1 from WS.WS.SYS_DAV_COL where COL_ID = N.RES_COL and COL_AUTO_VERSIONING is not null)) {\n"
"\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"rollback work;\n"
"\n"
"resignal;\n"
"}\n"
" ;\n"
"declare dt datetime;\n"
"dt := now();\n"
"set triggers off;\n"
"update WS.WS.SYS_DAV_RES set RES_STATUS = \'AV\' where RES_ID = N.RES_ID;\n"
"set triggers on;\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = N.RES_ID;\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = N.RES_ID;\n"
"insert replacing WS.WS.SYS_DAV_RES_VERSION (RV_RES_ID ,\n"
"RV_ID,\n"
"RV_NODE_NAME,\n"
"RV_PREV_ID,\n"
"RV_ACT_ID,\n"
"RV_RES_TYPE,\n"
"RV_CR_TIME,\n"
"RV_MOD_TIME,\n"
"RV_WHO,\n"
"RV_SIZE)\n"
"values (N.RES_ID, 1, NULL, NULL, NULL, N.RES_TYPE, dt, dt, connection_get (\'HTTP_CLI_UID\'), length(N.RES_CONTENT));\n"
"\"Versioning_ADD_NEW_DIFF\" (N.RES_ID, NULL, NULL, N.RES_CONTENT, \'c\');\n"
"\n"
"\n"
"declare _hist_col varchar;\n"
"declare _props any;\n"
"_props := vector (\'DAV:auto-version\',\n"
"(select \"Versioning_AUTO_VERSION_PROP\" (COL_AUTO_VERSIONING)\n"
"from WS.WS.SYS_DAV_COL where COL_ID = N.RES_COL),\n"
"\'DAV:author\',\n"
"(select U_NAME from DB.DBA.SYS_USERS where U_ID = N.RES_OWNER));\n"
"_hist_col := DAV_PROP_GET_INT (N.RES_COL, \'C\',\'virt:Versioning-History\', 0);\n"
"\n"
"\n"
"if (not isinteger (_hist_col))\n"
"_props := vector_concat (_props, vector (\'DAV:checked-in\', _hist_col || N.RES_NAME || \'/last\', \'DAV:version-history\', _hist_col || N.RES_NAME || \'/history.xml\'));\n"
"DAV_SET_VERSIONING_PROPERTIES (N.RES_FULL_PATH, _props);\n"
"\n"
"}\n"
"}\n"
"--src DET_Versioning.sql:240\n";

static const char *trig44 = 
"CREATE TRIGGER \"Versioning_DAV_RES_UPDATE\" AFTER UPDATE ON WS.WS.SYS_DAV_RES ORDER 10 REFERENCING NEW AS N, OLD AS O\n"
"{\n"
"declare _diff, _diff_type varchar;\n"
"_diff := NULL;\n"
"_diff_type := \'c\';\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"if (__SQL_STATE like \'DF*\')\n"
"goto _next;\n"
"resignal;\n"
"}\n"
" ;\n"
"\n"
"declare _auto_version_type varchar;\n"
"_auto_version_type := coalesce (\n"
"\"Versioning_AUTO_VERSION_PROP\" ((select COL_AUTO_VERSIONING from WS.WS.SYS_DAV_COL where COL_ID = N.RES_COL and COL_AUTO_VERSIONING is not null)),\n"
"DAV_HIDE_ERROR(DAV_PROP_GET_INT (N.RES_ID, \'R\', \'DAV:auto-version\', 0)));\n"
"\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (N.RES_ID,\'R\',\'DAV:checked-out\')) is null and _auto_version_type is not null) {\n"
"if ((length (N.RES_CONTENT) < 10000000) and (length (O.RES_CONTENT) < 10000000)) {\n"
"if (cast (N.RES_CONTENT as varchar) = cast (O.RES_CONTENT as varchar)) {\n"
"if (N.RES_NAME <> O.RES_NAME) {\n"
"declare _hist_col varchar;\n"
"_hist_col := DAV_PROP_GET_INT (N.RES_COL, \'C\',\'virt:Versioning-History\', 0);\n"
"if (not isinteger (_hist_col))\n"
"DAV_SET_VERSIONING_PROPERTIES (N.RES_FULL_PATH,\n"
"vector (\'DAV:checked-in\', _hist_col || N.RES_NAME || \'/last\',\n"
"\'DAV:version-history\', _hist_col || N.RES_NAME || \'/history.xml\'));\n"
"}\n"
"return;\n"
"};\n"
"if ( (N.RES_TYPE = O.RES_TYPE) and (N.RES_TYPE like \'text/%\') ) {\n"
"\n"
"_diff := diff (cast (N.RES_CONTENT as varchar), cast (O.RES_CONTENT as varchar), \'--normal\');\n"
"_diff_type := \'D\';\n"
"\n"
"}\n"
"};\n"
"_next:\n"
"\n"
"declare dt datetime;\n"
"dt:=now();\n"
"declare _ver_id, _ver_prev_id int;\n"
"_ver_prev_id := coalesce ((select max (RV_ID) from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = N.RES_ID),0);\n"
"_ver_id := _ver_prev_id + 1;\n"
"\n"
"declare _id int;\n"
"declare _type varchar;\n"
"_id := N.RES_ID;\n"
"_type := \'R\';\n"
"\n"
"if (_auto_version_type = \'DAV:checkout-checkin\'\n"
"or (_auto_version_type = \'DAV:checkout-unlocked-checkin\'))\n"
"{\n"
"insert replacing WS.WS.SYS_DAV_RES_VERSION (RV_RES_ID ,\n"
"RV_ID,\n"
"RV_NODE_NAME,\n"
"RV_PREV_ID,\n"
"RV_ACT_ID,\n"
"RV_RES_TYPE,\n"
"RV_CR_TIME,\n"
"RV_MOD_TIME,\n"
"RV_WHO,\n"
"RV_SIZE)\n"
"values (N.RES_ID, _ver_id, NULL, _ver_prev_id, NULL, N.RES_TYPE, dt, dt, connection_get (\'HTTP_CLI_UID\'), length (N.RES_CONTENT));\n"
"\n"
"\"Versioning_ADD_NEW_DIFF\" (N.RES_ID, _ver_id, _ver_prev_id, N.RES_CONTENT, _diff_type, _diff);\n"
"}\n"
"}\n"
"else if (DAV_HIDE_ERROR(DAV_PROP_GET_INT (N.RES_ID, \'R\', \'DAV:checked-in\', 0)) is not null)\n"
"signal (\'VR003\', \'Resource can not be updated when it has been checked-in\');\n"
"}\n"
"--src DET_Versioning.sql:296\n";

static const char *proc582 = 
"create function DAV_GET_VERSION_CONTENT (in res_id integer, in ver integer, inout content any, out type varchar, inout mode any)\n"
"{\n"
"declare ver_path any;\n"
"declare curr_ver, next_ver_copy, next_ver, prev_ver integer;\n"
"next_ver := -1;\n"
"\n"
"\n"
"for select RV_RES_TYPE, RD_DELTA, RD_MODE, RD_ARGS from WS.WS.SYS_DAV_RES_DIFF\n"
"inner join WS.WS.SYS_DAV_RES_VERSION\n"
"on (RV_RES_ID = RD_RES_ID and RV_ID = RD_TO_ID)\n"
"where RD_RES_ID = res_id and RD_TO_ID = ver and RD_FROM_ID = 0 do\n"
"{\n"
"\n"
"content := RD_DELTA;\n"
"type := RV_RES_TYPE;\n"
"return 0;\n"
"}\n"
"vectorbld_init (ver_path);\n"
"next_ver_copy := ver;\n"
"vectorbld_acc (ver_path, next_ver_copy);\n"
"curr_ver := ver;\n"
"\n"
"find_next_ver:\n"
"for select RD_DELTA, RD_MODE, RD_ARGS from WS.WS.SYS_DAV_RES_DIFF\n"
"where RD_RES_ID = res_id and RD_TO_ID = curr_ver and RD_FROM_ID = 0 do {\n"
"\n"
"goto key_found;\n"
"}\n"
"next_ver_copy := null;\n"
"next_ver := null;\n"
"for select RD_FROM_ID from WS.WS.SYS_DAV_RES_DIFF\n"
"where RD_RES_ID = res_id and RD_TO_ID = curr_ver and RD_FROM_ID <> 0 do {\n"
"next_ver_copy := rd_from_id;\n"
"next_ver := rd_from_id;\n"
"}\n"
"if (next_ver is null)\n"
"goto report_invalid_version_number;\n"
"vectorbld_acc (ver_path, next_ver_copy);\n"
"curr_ver := next_ver;\n"
"goto find_next_ver;\n"
"\n"
"key_found:\n"
"vectorbld_final (ver_path);\n"
"\n"
"\n"
"whenever not found goto report_invalid_version_number;\n"
"declare ctr int;\n"
"curr_ver := 0;\n"
"for (ctr := length (ver_path)-1; ctr >= 0; ctr := ctr - 1) {\n"
"declare curr_delta any;\n"
"declare curr_mode, curr_args varchar;\n"
"prev_ver := ver_path [ctr];\n"
"\n"
"select RD_DELTA, RD_MODE, RD_ARGS into curr_delta, curr_mode, curr_args from WS.WS.SYS_DAV_RES_DIFF\n"
"where RD_RES_ID = res_id and RD_TO_ID = prev_ver and RD_FROM_ID = curr_ver;\n"
"\n"
"\n"
"if (curr_mode = \'c\')\n"
"content := curr_delta;\n"
"else if (curr_mode = \'D\')\n"
"content := diff_apply (cast (content as varchar), cast (curr_delta as varchar), \'--virt2\');\n"
"else\n"
"signal (\'VR002\', \'Versioning: diff mode [\' || curr_mode || \'] is not supported\');\n"
"curr_ver := prev_ver;\n"
"}\n"
"\n"
"type := (select RV_RES_TYPE from WS.WS.SYS_DAV_RES_VERSION V where V.RV_RES_ID = res_id and V.RV_ID = ver);\n"
"return 0;\n"
"report_invalid_version_number:\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:370\n";

static const char *proc583 = 
"create function DAV_RES_RESTORE (in VVCfolder varchar, in file varchar, in auth varchar, in pwd varchar)\n"
"{\n"
"declare _attic, _base varchar;\n"
"declare vvc_id int;\n"
"vvc_id := DAV_SEARCH_ID (VVCfolder, \'C\');\n"
"_attic := \"Versioning_GET_ATTIC_PATH\" (vvc_id);\n"
"_base := \"Versioning_GET_BASE_PATH\" (vvc_id);\n"
"if ((_attic is null) or (_base is null))\n"
"return -36;\n"
"declare _base_id int;\n"
"_base_id := DAV_SEARCH_ID (_base, \'C\');\n"
"if (_base_id < 0)\n"
"return _base_id;\n"
"declare _res_id int;\n"
"_res_id := DAV_SEARCH_ID (_attic || file, \'R\');\n"
"if (_res_id < 0)\n"
"return _res_id;\n"
"declare new_res_id int;\n"
"declare _content any;\n"
"declare _type, _perms varchar;\n"
"declare _owner, _group int;\n"
"select RES_CONTENT, RES_TYPE, RES_PERMS, RES_OWNER, RES_GROUP\n"
"into _content, _type, _perms, _owner, _group\n"
"from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"new_res_id := DAV_RES_UPLOAD_STRSES_INT (_base || file, _content, _type, _perms, _owner, _group, auth, pwd, 1);\n"
"if (new_res_id > 0) {\n"
"DAV_VERSION_CONTROL (_base || file, auth, pwd);\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = new_res_id;\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = new_res_id;\n"
"update WS.WS.SYS_DAV_RES_VERSION set RV_RES_ID = new_res_id\n"
"where RV_RES_ID = _res_id;\n"
"update WS.WS.SYS_DAV_RES_DIFF set RD_RES_ID = new_res_id\n"
"where RD_RES_ID = _res_id;\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"return 1;\n"
"}\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:444\n";

static const char *proc584 = 
"create function \"Versioning_DAV_AUTHENTICATE\" (in id any, in what char(1), in req varchar, in auth_uname varchar, in auth_pwd varchar, in auth_uid integer)\n"
"{\n"
"\n"
"if (auth_uid >= 0)\n"
"return auth_uid;\n"
"return -12;\n"
"}\n"
"--src DET_Versioning.sql:488\n";

static const char *proc585 = 
"create function \"Versioning_DAV_AUTHENTICATE_HTTP\" (in id any, in what char(1), in req varchar, in can_write_http integer, inout a_lines any, inout a_uname varchar, inout a_pwd varchar, inout a_uid integer, inout a_gid integer, inout _perms varchar) returns integer\n"
"{\n"
"declare rc integer;\n"
"declare puid, pgid integer;\n"
"declare u_password, pperms varchar;\n"
"declare allow_anon integer;\n"
"if (length (req) <> 3)\n"
"return -15;\n"
"\n"
"whenever not found goto nf_col_or_res;\n"
"puid := http_dav_uid();\n"
"pgid := coalesce (\n"
"( select G_ID from WS.WS.SYS_DAV_GROUP\n"
"where G_NAME = \'Versioning_\' || coalesce ((select COL_NAME from WS.WS.SYS_DAV_COL where COL_ID=id[1] and COL_DET=\'HostFs\'), \'\')\n"
"), puid+1);\n"
"if ((what <> \'R\') and (what <> \'C\'))\n"
"return -14;\n"
"if (\'R\' = what and (length(id) > 2)) {\n"
"select RES_PERMS, RES_OWNER, RES_GROUP into pperms, puid, pgid from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"}\n"
"else {\n"
"pperms := \'110100100NN\';\n"
"}\n"
"allow_anon := WS.WS.PERM_COMP (substring (cast (pperms as varchar), 7, 3), req);\n"
"if (a_uid is null) {\n"
"if ((not allow_anon) or (\'\' <> WS.WS.FINDPARAM (a_lines, \'Authorization:\')))\n"
"rc := WS.WS.GET_DAV_AUTH (a_lines, allow_anon, can_write_http, a_uname, u_password, a_uid, a_gid, _perms);\n"
"if (rc < 0)\n"
"return rc;\n"
"}\n"
"if (isinteger (a_uid)) {\n"
"if (a_uid < 0)\n"
"return a_uid;\n"
"if (a_uid = 1) {\n"
"a_uid := 0;\n"
"a_gid := 0;\n"
"}\n"
"}\n"
"if (DAV_CHECK_PERM (pperms, req, a_uid, a_gid, pgid, puid))\n"
"return a_uid;\n"
"return -13;\n"
"\n"
"nf_col_or_res:\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:502\n";

static const char *proc586 = 
"create function \"Versioning_DAV_GET_PARENT\" (in id any, in st char(1), in path varchar) returns any\n"
"{\n"
"\n"
"if (st = \'R\' and isarray (id) and length (id) = 4)\n"
"return subseq (id, 0, length (id) - 1);\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:551\n";

static const char *proc587 = 
"create function \"Versioning_DAV_COL_CREATE\" (in detcol_id any, in path_parts any, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:562\n";

static const char *proc588 = 
"create function \"Versioning_DAV_COL_MOUNT\" (in detcol_id any, in path_parts any, in full_mount_path varchar, in mount_det varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:570\n";

static const char *proc589 = 
"create function \"Versioning_DAV_COL_MOUNT_HERE\" (in parent_id any, in full_mount_path varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:578\n";

static const char *proc590 = 
"create function \"Versioning_DAV_DELETE\" (in detcol_id any, in path_parts any, in what char(1), in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"\n"
"if (\'R\' = what) {\n"
"if (length (path_parts) <> 2)\n"
"return -20;\n"
"\n"
"declare _base_path varchar;\n"
"_base_path := \"Versioning_GET_BASE_PATH\" (detcol_id);\n"
"if (_base_path is null)\n"
"return -20;\n"
"declare _res_id int;\n"
"_res_id := DAV_SEARCH_ID (_base_path || path_parts[0], \'R\');\n"
"if (_res_id < 0)\n"
"return -1;\n"
"if (path_parts[1] = \'last\') {\n"
"\n"
"declare _attic varchar;\n"
"_attic := \"Versioning_GET_ATTIC_PATH\" (detcol_id);\n"
"if (_attic is not null) {\n"
"declare _attic_id int;\n"
"_attic_id := DAV_SEARCH_ID (_attic, \'C\');\n"
"if (_attic_id >= 0) {\n"
"declare new_res_id int;\n"
"declare _content any;\n"
"declare _type, _perms varchar;\n"
"declare _owner, _group int;\n"
"select RES_CONTENT, RES_TYPE, RES_PERMS, RES_OWNER, RES_GROUP\n"
"into _content, _type, _perms, _owner, _group\n"
"from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"new_res_id := DAV_RES_UPLOAD_STRSES_INT (_attic || path_parts[0], _content, _type, _perms, _owner, _group, null, null, 0);\n"
"if (new_res_id > 0) {\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = new_res_id;\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = new_res_id;\n"
"\n"
"update WS.WS.SYS_DAV_RES_VERSION set RV_RES_ID = new_res_id\n"
"where RV_RES_ID = _res_id;\n"
"update WS.WS.SYS_DAV_RES_DIFF set RD_RES_ID = new_res_id\n"
"where RD_RES_ID = _res_id;\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"}\n"
"return 1;\n"
"}\n"
"}\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"}\n"
"else {\n"
"declare ver_id int;\n"
"ver_id := atoi (path_parts[1]);\n"
"if (cast (ver_id as varchar) = path_parts[1]) {\n"
"\n"
"declare cnt int;\n"
"cnt := coalesce ((select count (*) from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = _res_id and RV_ID > ver_id), 0);\n"
"if (cnt = 0)\n"
"return -38;\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = _res_id\n"
"and RV_ID <= ver_id;\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = _res_id\n"
"and RD_TO_ID <= ver_id;\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:587\n";

static const char *proc591 = 
"create function \"Versioning_DAV_RES_UPLOAD\" (in detcol_id any, in path_parts any, inout content any, in type varchar, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:658\n";

static const char *proc592 = 
"create function \"Versioning_DAV_PROP_REMOVE\" (in id any, in what char(0), in propname varchar, in silent integer, in auth_uid integer) returns integer\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:668\n";

static const char *proc593 = 
"create function \"Versioning_DAV_PROP_SET\" (in id any, in what char(0), in propname varchar, in propvalue any, in overwrite integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (propname[0] = 58) {\n"
"return -16;\n"
"}\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:677\n";

static const char *proc594 = 
"create function \"Versioning_DAV_PROP_GET\" (in id any, in what char(0), in propname varchar, in auth_uid integer)\n"
"{\n"
"\n"
"if (isarray (id) and length (id) = 4) {\n"
"if (id[3] = -1) {\n"
"declare _hist_col, _res_name varchar;\n"
"if (propname = \'DAV:root-version\') {\n"
"declare _root_ver int;\n"
"_res_name := (select RES_NAME from WS.WS.SYS_DAV_RES where RES_ID = id[2]);\n"
"_hist_col := DAV_SEARCH_PATH (id[1], \'C\');\n"
"_root_ver := (select min (RV_ID) from ws.ws.sys_dav_res_version where RV_ID > 0 and RV_RES_ID = id[2]);\n"
"return \'<D:href>\' || _hist_col || _res_name || \'/\' || cast (_root_ver as varchar) || \'</D:href>\';\n"
"}\n"
"else if (propname = \'DAV:version-set\') {\n"
"declare _res any;\n"
"_res := string_output ();\n"
"_hist_col := DAV_SEARCH_PATH (id[1], \'C\');\n"
"_res_name := (select RES_NAME from WS.WS.SYS_DAV_RES where RES_ID = id[2]);\n"
"for select RV_ID from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = id[2] and RV_ID <> 0 order by RV_ID\n"
"do {\n"
"http (\'<D:href>\', _res);\n"
"http (_hist_col || _res_name || \'/\' ||  cast (RV_ID as varchar), _res);\n"
"http (\'</D:href>\', _res);\n"
"}\n"
"return string_output_string (_res);\n"
"}\n"
"}\n"
"else {\n"
"declare exit handler for not found {\n"
"return -1;\n"
"};\n"
"declare _props any;\n"
"if (id[3] = -2)\n"
"select RD_PROPS into _props from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = id[2] and RD_FROM_ID = 0;\n"
"else if (id[3] > 0) {\n"
"if (propname = \':creationdate\') {\n"
"declare dt datetime;\n"
"select RV_CR_TIME into dt from WS.WS.SYS_DAV_RES_VERSION\n"
"where RV_RES_ID = id[2] and RV_ID = id[3];\n"
"return dt;\n"
"}\n"
"else\n"
"select RD_PROPS into _props from WS.WS.SYS_DAV_RES_DIFF\n"
"where RD_RES_ID = id[2] and RD_TO_ID = id[3];\n"
"}\n"
"\n"
"if (_props is not null)\n"
"return coalesce (xpath_eval (\'//property[@name=\"\' || propname || \'\"]/text()\', _props), -11);\n"
"}\n"
"}\n"
"return -11;\n"
"}\n"
"--src DET_Versioning.sql:688\n";

static const char *proc595 = 
"create function \"Versioning_root_version\" (in _res_id int, in _hist_col varchar)\n"
"{\n"
"declare ss any;\n"
"ss := string_output();\n"
"http (\'<D:root-version><D:href>\' || _hist_col, ss);\n"
"http_value( (select min (RV_ID) from ws.ws.sys_dav_res_version where RV_ID > 0\n"
"and RV_RES_ID = _res_id), NULL, ss);\n"
"http (\'</D:href></D:root-version>\', ss);\n"
"\n"
"return string_output_string (ss);\n"
"}\n"
"--src DET_Versioning.sql:742\n";

static const char *proc596 = 
"create function \"Versioning_version_set\" (in _res_id int, in _hist_col varchar)\n"
"{\n"
"declare ss any;\n"
"ss := string_output ();\n"
"http (\'<D:version-set>\', ss);\n"
"for select RV_ID, RES_NAME from WS.WS.SYS_DAV_RES_VERSION inner join WS.WS.SYS_DAV_RES\n"
"on (RV_RES_ID = RES_ID)\n"
"where RES_ID = _res_id\n"
"do {\n"
"http (\'<D:href>\', ss);\n"
"http (_hist_col || RES_NAME || \'/\' ||  cast (RV_ID as varchar), ss);\n"
"http (\'</D:href>\', ss);\n"
"}\n"
"http (\'</D:version-set>\',ss);\n"
"return string_output_string (ss);\n"
"}\n"
"--src DET_Versioning.sql:755\n";

static const char *proc597 = 
"create function \"Versioning_DAV_PROP_LIST\" (in id any, in what char(0), in propmask varchar, in auth_uid integer)\n"
"{\n"
"\n"
"if (isarray (id) and length (id) = 4 and id[3] = -1) {\n"
"declare _hist_col varchar;\n"
"_hist_col := DAV_SEARCH_PATH (id[1], \'C\');\n"
"return vector (\n"
"vector (\'DAV:version-set\', \"Versioning_version_set\" (id[2], _hist_col)),\n"
"vector (\'DAV:root-version\', \"Versioning_root_version\" (id[2], _hist_col)));\n"
"}\n"
"return vector ();\n"
"}\n"
"--src DET_Versioning.sql:775\n";

static const char *proc598 = 
"create function \"Versioning_DAV_DIR_SINGLE\" (in id any, in what char(0), in path any, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (what = \'C\') {\n"
"if (isarray (id) and length (id) = 3) {\n"
"declare _res_name, _col_path varchar;\n"
"declare dirlist any;\n"
"_res_name := (select RES_NAME from WS.WS.SYS_DAV_RES where RES_ID = id[2]);\n"
"_col_path := DAV_SEARCH_PATH (id[1], \'C\') || _res_name || \'/\';\n"
"for select RES_MOD_TIME, RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME, RES_NAME\n"
"from WS.WS.SYS_DAV_RES where RES_ID = id[2]\n"
"do {\n"
"return\n"
"\n"
"vector (_col_path,        \'C\',  0,    RES_MOD_TIME,\n"
"\n"
"vector (UNAME\'Versioning\', id[1], id[2]),\n"
"\n"
"RES_PERMS, RES_GROUP, RES_OWNER, RES_CR_TIME,    \'dav/unix-directory\', RES_NAME);\n"
"}\n"
"}\n"
"}\n"
"else if (what = \'R\') {\n"
"if (not isarray(id))\n"
"return -20;\n"
"if (length (id) = 4 and isinteger(id[3]) and id[3] > 0) {\n"
"declare res any;\n"
"for select RV_ID, RES_NAME, RES_FULL_PATH, RV_SIZE as l,\n"
"RES_PERMS, RV_CR_TIME, RV_MOD_TIME, RES_GROUP, RES_OWNER,\n"
"RV_RES_TYPE, cast (RV_ID as VARCHAR) as ver_id\n"
"from WS.WS.SYS_DAV_RES INNER JOIN WS.WS.SYS_DAV_RES_VERSION ON (RV_RES_ID = RES_ID)\n"
"where RES_ID = id[2] and RV_ID = id[3]\n"
"do {\n"
"return vector (\n"
"\n"
"DAV_SEARCH_PATH (id[1], \'C\') || RES_NAME || \'/\' || ver_id,\n"
"\n"
"\'R\',    l,    RV_CR_TIME,  vector (UNAME\'Versioning\', id[1], id[2], RV_ID),\n"
"\n"
"RES_PERMS,  RES_GROUP,  RES_OWNER,  RV_MOD_TIME,\n"
"\n"
"RV_RES_TYPE,  ver_id);\n"
"}\n"
"}\n"
"if (length (id) = 4) {\n"
"if (isinteger (id[3]) and id[3] < 0) {\n"
"declare _target varchar;\n"
"declare _res_name, _type, _perms varchar;\n"
"declare _cr_time, _mod_time datetime;\n"
"declare _owner, _group int;\n"
"select RES_NAME, RES_TYPE, RES_PERMS, RES_CR_TIME, RES_MOD_TIME, RES_OWNER, RES_GROUP\n"
"into _res_name, _type, _perms, _cr_time, _mod_time, _owner, _group\n"
"from WS.WS.SYS_DAV_RES where RES_ID = id[2];\n"
"if (id[3] = -1)\n"
"_target := \'history.xml\';\n"
"else if (id[3] = -2)\n"
"_target := \'last\';\n"
"else\n"
"return -20;\n"
"return vector (\n"
"\n"
"DAV_SEARCH_PATH (id[1], \'C\') || _res_name || \'/\' || _target,\n"
"\n"
"\'R\',    1000,    _cr_time,  id,\n"
"\n"
"_perms,  _group,    _owner,    _mod_time,\n"
"\n"
"_type,    _target);\n"
"}\n"
"}\n"
"else if (length(id) = 5 and isstring(id[4]) and id[4] = \'diff\') {\n"
"declare res any;\n"
"for select RV_ID, RES_NAME, RES_FULL_PATH, RV_SIZE as l,\n"
"RES_PERMS, RV_CR_TIME, RV_MOD_TIME, RES_GROUP, RES_OWNER,\n"
"RV_RES_TYPE, cast (RV_ID as VARCHAR) as ver_id\n"
"from WS.WS.SYS_DAV_RES INNER JOIN WS.WS.SYS_DAV_RES_VERSION\n"
"ON (RV_RES_ID = RES_ID) inner join WS.WS.SYS_DAV_RES_DIFF\n"
"on (RD_RES_ID = RES_ID)\n"
"where RES_ID = id[2]\n"
"and RV_ID = id[3]\n"
"do {\n"
"return vector (\n"
"\n"
"DAV_SEARCH_PATH (id[1], \'C\') || RES_NAME || \'/\' || ver_id,\n"
"\n"
"\'R\',    l,    RV_CR_TIME,  vector (UNAME\'Versioning\', id[1], id[2], RV_ID),\n"
"\n"
"RES_PERMS,  RES_GROUP,  RES_OWNER,  RV_MOD_TIME,\n"
"\n"
"RV_RES_TYPE,  ver_id);\n"
"}\n"
"\n"
"}\n"
"}\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:790\n";

static const char *proc599 = 
"create function \"Versioning_GET_BASE_PATH\" (in detcol_id int)\n"
"{\n"
"return (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:Versioning-Collection\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\');\n"
"}\n"
"--src DET_Versioning.sql:889\n";

static const char *proc600 = 
"create function \"Versioning_GET_ATTIC_PATH\" (in detcol_id int)\n"
"{\n"
"return (select PROP_VALUE from WS.WS.SYS_DAV_PROP where PROP_NAME = \'virt:Versioning-Attic\' and PROP_PARENT_ID = detcol_id and PROP_TYPE = \'C\');\n"
"}\n"
"--src DET_Versioning.sql:895\n";

static const char *proc601 = 
"create function \"Versioning_SET_LIST\" (in detcol_id int, in _res_id int, in virt_base_path varchar, inout res any)\n"
"{\n"
"declare max_ver int;\n"
"max_ver := 0;\n"
"for select RV_ID, RES_NAME, RES_FULL_PATH, RV_SIZE as l,\n"
"RES_PERMS, RV_CR_TIME, RV_MOD_TIME, RES_GROUP, RES_OWNER,\n"
"RV_RES_TYPE, cast (RV_ID as VARCHAR) as ver_id\n"
"from WS.WS.SYS_DAV_RES INNER JOIN WS.WS.SYS_DAV_RES_VERSION ON (RV_RES_ID = RES_ID)\n"
"where RES_ID = _res_id\n"
"order by ver_id\n"
"do {\n"
"vectorbld_acc (res, vector (\n"
"\n"
"virt_base_path || RES_NAME || \'/\' || ver_id,\n"
"\n"
"\'R\',    l,    RV_CR_TIME,  vector (UNAME\'Versioning\', detcol_id, _res_id, RV_ID),\n"
"\n"
"RES_PERMS,  RES_GROUP,  RES_OWNER,  RV_MOD_TIME,\n"
"\n"
"RV_RES_TYPE,  ver_id ) );\n"
"\n"
"vectorbld_acc (res, vector (\n"
"\n"
"virt_base_path || RES_NAME || \'/\' || ver_id || \'.diff\',\n"
"\n"
"\'R\',    l,    RV_CR_TIME,  vector (UNAME\'Versioning\', detcol_id, _res_id, RV_ID, \'diff\'),\n"
"\n"
"RES_PERMS,  RES_GROUP,  RES_OWNER,  RV_MOD_TIME,\n"
"\n"
"RV_RES_TYPE,  ver_id || \'.diff\' ) );\n"
"max_ver := case when max_ver > ver_id then max_ver else ver_id end;\n"
"}\n"
"return max_ver;\n"
"}\n"
"--src DET_Versioning.sql:903\n";

static const char *proc602 = 
"create function \"Versioning_DAV_DIR_LIST\" (in detcol_id any, in path_parts any, in detcol_path varchar, in name_mask varchar, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"declare base_path, virt_base_path varchar;\n"
"base_path := \"Versioning_GET_BASE_PATH\" (detcol_id);\n"
"if (base_path is null)\n"
"return -20;\n"
"virt_base_path := DAV_SEARCH_PATH (detcol_id, \'C\');\n"
"\n"
"declare res any;\n"
"vectorbld_init (res);\n"
"if (length (path_parts) = 1) {\n"
"for select RES_ID, RES_NAME, RES_CONTENT, RES_FULL_PATH, RES_PERMS, RES_OWNER, RES_MOD_TIME, RES_TYPE, RES_GROUP, RES_CR_TIME\n"
"from WS.WS.SYS_DAV_RES, WS.WS.SYS_DAV_PROP\n"
"where RES_COL = DAV_SEARCH_ID (base_path, \'C\')\n"
"and PROP_PARENT_ID = RES_ID\n"
"and (PROP_NAME = \'DAV:checked-in\' or PROP_NAME = \'DAV:checked-out\')\n"
"do {\n"
"vectorbld_acc (res, vector (virt_base_path || RES_NAME || \'/\', \'C\', 0, RES_CR_TIME,\n"
"\n"
"vector (UNAME\'Versioning\', cast (detcol_id as integer), RES_ID),\n"
"\n"
"RES_PERMS,     RES_GROUP,      RES_OWNER,      RES_MOD_TIME,   \'dav/unix-directory\',\n"
"\n"
"RES_NAME ) );\n"
"}\n"
"}\n"
"else if (length (path_parts) = 2) {\n"
"declare _res_id int;\n"
"_res_id := DAV_SEARCH_ID (base_path || aref (path_parts, 0), \'R\');\n"
"if (_res_id < 0)\n"
"return -1;\n"
"declare _res_name, _res_perms, _rv_res_type varchar;\n"
"declare _rv_mod_time, _rv_cr_time datetime;\n"
"declare _len, _res_group, _res_owner int;\n"
"_res_name := null;\n"
"\n"
"declare _max_ver int;\n"
"_max_ver := \"Versioning_SET_LIST\" (detcol_id, _res_id, virt_base_path, res);\n"
"\n"
"select RES_NAME, RES_PERMS, RES_GROUP, RES_OWNER, RV_RES_TYPE, RV_MOD_TIME, RV_CR_TIME, RV_SIZE\n"
"into _res_name,\n"
"_res_perms,\n"
"_res_group,\n"
"_res_owner,\n"
"_rv_res_type,\n"
"_rv_mod_time,\n"
"_rv_cr_time,\n"
"_len\n"
"from WS.WS.SYS_DAV_RES inner join WS.WS.SYS_DAV_RES_VERSION on (RV_RES_ID = RES_ID)\n"
"where RES_ID = _res_id and RV_ID = _max_ver;\n"
"\n"
"\n"
"declare _owner, _group int;\n"
"declare _name varchar;\n"
"select RES_GROUP, RES_OWNER, RES_NAME into _group, _owner, _name from WS.WS.SYS_DAV_RES\n"
"where RES_ID = _res_id;\n"
"vectorbld_acc (res, vector (\n"
"\n"
"virt_base_path || _name || \'/history.xml\',\n"
"\n"
"\'R\',    1000,    now(),    vector (UNAME\'Versioning\', detcol_id, _res_id, -1),\n"
"\n"
"\'100100100NN\',  _group,    _owner,  now(),\n"
"\n"
"\'plain/xml\',  \'history.xml\' ) );\n"
"\n"
"if (_res_name is not null)\n"
"vectorbld_acc (res, vector (\n"
"\n"
"virt_base_path || _res_name || \'/last\',\n"
"\n"
"\'R\',    _len,    _rv_cr_time,  vector (UNAME\'Versioning\', detcol_id, _res_id, -2),\n"
"\n"
"_res_perms,  _res_group,  _res_owner,  _rv_mod_time,\n"
"\n"
"_rv_res_type,  \'last\' ) );\n"
"}\n"
"vectorbld_final (res);\n"
"\n"
"return res;\n"
"}\n"
"--src DET_Versioning.sql:942\n";

static const char *proc603 = 
"create function \"Versioning_DAV_DIR_FILTER\" (in detcol_id any, in path_parts any, in detcol_path varchar, inout compilation any, in recursive integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return vector();\n"
"}\n"
"--src DET_Versioning.sql:1026\n";

static const char *proc604 = 
"create function \"Versioning_DAV_SEARCH_ID\" (in detcol_id any, in path_parts any, in what char(1)) returns any\n"
"{\n"
"declare base_path varchar;\n"
"base_path := \"Versioning_GET_BASE_PATH\" (detcol_id);\n"
"if (base_path is null)\n"
"return -20;\n"
"\n"
"if (\'C\' = what) {\n"
"if ( (length (path_parts) = 3) )\n"
"return -1;\n"
"declare base_id int;\n"
"base_id := DAV_SEARCH_ID (base_path, \'C\');\n"
"if (base_id > 0) {\n"
"declare _res_id int;\n"
"_res_id :=  (select RES_ID from WS.WS.SYS_DAV_RES where RES_COL = base_id\n"
"and RES_NAME = aref (path_parts, 0) );\n"
"\n"
"if (_res_id is not null) {\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'DAV:checked-in\', 0)) is null\n"
"and DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'DAV:checked-out\', 0)) is null)\n"
"return -1;\n"
"return vector (UNAME\'Versioning\', cast (detcol_id as integer), _res_id);\n"
"}\n"
"}\n"
"return -1;\n"
"}\n"
"else if (\'R\' = what) {\n"
"if (length (path_parts) = 2) {\n"
"declare _res_id, _ver_id, _id int;\n"
"_res_id := DAV_SEARCH_ID (base_path || path_parts[0], \'R\');\n"
"\n"
"if (_res_id < 0)\n"
"return -1;\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'DAV:checked-in\', 0)) is null\n"
"and DAV_HIDE_ERROR (DAV_PROP_GET_INT (_res_id, \'R\', \'DAV:checked-out\', 0)) is null)\n"
"return -1;\n"
"if (path_parts[1] = \'history.xml\')\n"
"_ver_id := -1;\n"
"else if (path_parts[1] = \'last\')\n"
"_ver_id := -2;\n"
"else if (path_parts[1] like \'%.diff\') {\n"
"_ver_id := atoi (path_parts[1]);\n"
"return vector (UNAME\'Versioning\', detcol_id, _res_id, _ver_id, \'diff\');\n"
"}\n"
"else {\n"
"_ver_id := cast (path_parts[1] as integer);\n"
"if (not exists (select 1 from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = _res_id and RV_ID = _ver_id))\n"
"return -1;\n"
"}\n"
"return vector (UNAME\'Versioning\', detcol_id, _res_id, _ver_id);\n"
"}\n"
"return -1;\n"
"}\n"
"else\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:1034\n";

static const char *proc605 = 
"create function \"Versioning_DAV_SEARCH_PATH\" (in id any, in what char(1)) returns any\n"
"{\n"
"\n"
"if (what = \'C\' and isarray (id) and length (id) = 3) {\n"
"declare base_coll varchar;\n"
"base_coll := DAV_PROP_GET_INT (id[1], \'C\',\'virt:Versioning-Collection\', 0);\n"
"if (isinteger (base_coll))\n"
"return -1;\n"
"return base_coll || (select RES_NAME from WS.WS.SYS_DAV_RES where RES_ID = id[2]) || \'/\';\n"
"}\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:1093\n";

static const char *proc606 = 
"create function \"Versioning_DAV_RES_UPLOAD_COPY\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite_flags integer, in permissions varchar, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:1108\n";

static const char *proc607 = 
"create function \"Versioning_DAV_RES_UPLOAD_MOVE\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite_flags integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"if (not isarray (source_id))\n"
"return -20;\n"
"if (source_id[0] <> UNAME\'Versioning\')\n"
"return -20;\n"
"if (source_id[3] <> -2)\n"
"return -20;\n"
"if (what <> \'R\')\n"
"return -20;\n"
"declare _target_col varchar;\n"
"_target_col := (select PROP_VALUE from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'virt:Versioning-Collection\' and PROP_PARENT_ID = detcol_id);\n"
"if (_target_col is null)\n"
"return -1;\n"
"declare _old_res_id, _target_col_id int;\n"
"_target_col_id := DAV_SEARCH_ID (_target_col, \'C\');\n"
"if (_target_col_id > 0) {\n"
"\n"
"_old_res_id := DAV_SEARCH_ID (_target_col || path_parts[0], \'R\');\n"
"if (_old_res_id > 0) {\n"
"\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = _old_res_id;\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = _old_res_id;\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = _old_res_id;\n"
"}\n"
"declare _t_path varchar;\n"
"declare _res_id int;\n"
"_res_id := source_id[2];\n"
"_t_path := DAV_SEARCH_PATH (_target_col_id, \'C\');\n"
"declare new_res_id int;\n"
"declare _content any;\n"
"declare _type, _perms varchar;\n"
"declare _owner, _group int;\n"
"select RES_CONTENT, RES_TYPE, RES_PERMS, RES_OWNER, RES_GROUP\n"
"into _content, _type, _perms, _owner, _group\n"
"from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"new_res_id := DAV_RES_UPLOAD_STRSES_INT (\n"
"_t_path || path_parts[0],\n"
"_content,\n"
"_type,\n"
"_perms,\n"
"_owner,\n"
"_group,\n"
"null,\n"
"null,\n"
"0);\n"
"if (new_res_id < 0)\n"
"return new_res_id;\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = new_res_id;\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = new_res_id;\n"
"update WS.WS.SYS_DAV_RES_VERSION set RV_RES_ID = new_res_id\n"
"where RV_RES_ID = _res_id;\n"
"update WS.WS.SYS_DAV_RES_DIFF set RD_RES_ID = new_res_id\n"
"where RD_RES_ID = _res_id;\n"
"update WS.WS.SYS_DAV_PROP\n"
"set PROP_PARENT_ID = new_res_id\n"
"where PROP_PARENT_ID = _res_id\n"
"and PROP_NAME not in (\'DAV:author\', \'DAV:auto-version\', \'DAV:checked-in\', \'DAV:version-history\', \'DAV:checked-out\');\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = _res_id;\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_Versioning.sql:1116\n";

static const char *proc608 = 
"create function \"Versioning_DAV_RES_CONTENT\" (in id any, inout content any, out type varchar, in content_mode integer) returns integer\n"
"{\n"
"\n"
"declare _res int;\n"
"if (aref (id, 3) = -1) {\n"
"declare _xml any;\n"
"_xml := ( select XMLELEMENT (\'history\',\n"
"XMLAGG ( XMLELEMENT (\'version\',\n"
"XMLATTRIBUTES (RV_ID as \"Number\",\n"
"RV_MOD_TIME as \"ModDate\",\n"
"RES_NAME as \"Name\",\n"
"coalesce (RV_WHO,\'Unknown\') as \"Who\") ) ) )\n"
"from WS.WS.SYS_DAV_RES_VERSION inner join WS.WS.SYS_DAV_RES\n"
"on (RV_RES_ID = RES_ID)\n"
"inner join DB.DBA.SYS_USERS\n"
"on (RES_OWNER = U_ID)\n"
"where RES_ID = aref (id, 2));\n"
"content := serialize_to_UTF8_xml(_xml);\n"
"type := \'plain/xml\';\n"
"return 1;\n"
"}\n"
"else if (aref (id, 3) = -2) {\n"
"select RD_DELTA, RES_TYPE into content, type from WS.WS.SYS_DAV_RES_DIFF inner join\n"
"WS.WS.SYS_DAV_RES on (RD_RES_ID = RES_ID)\n"
"where RD_RES_ID = aref (id, 2)\n"
"and RD_FROM_ID = 0;\n"
"return 1;\n"
"}\n"
"else if (length (id) = 5) {\n"
"if (id[4] <> \'diff\')\n"
"return -1;\n"
"content := (select RD_DELTA from WS.WS.SYS_DAV_RES_DIFF where\n"
"RD_RES_ID = id[2]\n"
"and RD_TO_ID = id[3]);\n"
"type := \'application/gdiff\';\n"
"if (_res is not null)\n"
"return 1;\n"
"}\n"
"else {\n"
"_res := DAV_GET_VERSION_CONTENT (aref (id, 2), aref (id, 3), content, type, content_mode);\n"
"if (_res >= 0)\n"
"return 1;\n"
"}\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:1184\n";

static const char *proc609 = 
"create function \"Versioning_DAV_SYMLINK\" (in detcol_id any, in path_parts any, in source_id any, in what char(1), in overwrite integer, in uid integer, in gid integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:1232\n";

static const char *proc610 = 
"create function \"Versioning_DAV_DEREFERENCE_LIST\" (in detcol_id any, inout report_array any) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:1240\n";

static const char *proc611 = 
"create function \"Versioning_DAV_RESOLVE_PATH\" (in detcol_id any, inout reference_item any, inout old_base varchar, inout new_base varchar) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:1248\n";

static const char *proc612 = 
"create function \"Versioning_DAV_LOCK\" (in path any, in id any, in type char(1), inout locktype varchar, inout scope varchar, in token varchar, inout owner_name varchar, inout owned_tokens varchar, in depth varchar, in timeout_sec integer, in auth_uid integer) returns any\n"
"{\n"
"\n"
"return -20;\n"
"}\n"
"--src DET_Versioning.sql:1256\n";

static const char *proc613 = 
"create function \"Versioning_DAV_UNLOCK\" (in id any, in type char(1), in token varchar, in auth_uid integer)\n"
"{\n"
"\n"
"return -27;\n"
"}\n"
"--src DET_Versioning.sql:1265\n";

static const char *proc614 = 
"create function \"Versioning_DAV_IS_LOCKED\" (inout id any, inout type char(1), in owned_tokens varchar) returns integer\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"--src DET_Versioning.sql:1274\n";

static const char *proc615 = 
"create function \"Versioning_DAV_LIST_LOCKS\" (in id any, in type char(1), in recursive integer) returns any\n"
"{\n"
"\n"
"return vector ();\n"
"}\n"
"--src DET_Versioning.sql:1284\n";

static const char *proc616 = 
"create function \"Versioning_AUTO_VERSION_PROP\" (in _auto_version varchar)\n"
"{\n"
"if (_auto_version = \'A\')\n"
"return \'DAV:checkout-checkin\';\n"
"if (_auto_version = \'B\')\n"
"return \'DAV:checkout-unlocked-checkin\';\n"
"if (_auto_version = \'C\')\n"
"return \'DAV:checkout\';\n"
"if (_auto_version = \'D\')\n"
"return \'DAV:locked-checkout\';\n"
"if (_auto_version is null)\n"
"return null;\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:1291\n";

static const char *proc617 = 
"create procedure DAV_SET_VERSIONING_PROPERTIES (in path varchar, in props any)\n"
"{\n"
"declare idx, res int;\n"
"for (idx := 0; idx < length (props) / 2; idx := idx + 1) {\n"
"\n"
"res := DAV_PROP_SET_INT (path,\n"
"props[2*idx],\n"
"props[2*idx + 1], NULL, NULL, 0, 1, 1);\n"
"\n"
"if (res < 0)\n"
"return res;\n"
"}\n"
"return 1;\n"
"}\n"
"--src DET_Versioning.sql:1309\n";

static const char *proc618 = 
"create procedure \"Versioning_REMOVE_V_PROPERTIES\" (in _path varchar)\n"
"{\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"DAV_PROP_REMOVE_INT (_PATH, \'DAV:author\', null, null, 0);\n"
"DAV_PROP_REMOVE_INT (_PATH, \'DAV:version-history\', null, null, 0);\n"
"DAV_PROP_REMOVE_INT (_PATH, \'DAV:checked-in\', null, null, 0);\n"
"DAV_PROP_REMOVE_INT (_PATH, \'DAV:auto-version\', null, null, 0);\n"
"connection_set (\'Versioning REM PROP\', NULL);\n"
"}\n"
"--src DET_Versioning.sql:1325\n";

static const char *proc619 = 
"create function DAV_REMOVE_VERSIONING_CONTROL_INT (in _main varchar, in _auth varchar, in _pwd varchar) returns integer\n"
"{\n"
"declare _vvc any;\n"
"_vvc := DAV_PROP_GET (_main, \'virt:Versioning-History\', \'dav\', \'dav\');\n"
"if (DAV_HIDE_ERROR (_vvc) is null)\n"
"return _vvc;\n"
"declare _col_id int;\n"
"_col_id := DAV_SEARCH_ID (_main, \'C\');\n"
"update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING=NULL where COL_ID = DAV_SEARCH_ID (_main, \'C\');\n"
"for select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_COL = _col_id\n"
"do {\n"
"\"Versioning_REMOVE_V_PROPERTIES\" (RES_FULL_PATH);\n"
"}\n"
"\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"DAV_PROP_REMOVE (_main, \'virt:Versioning-History\', _auth, _pwd);\n"
"DAV_PROP_REMOVE (_vvc, \'virt:Versioning-Collection\', _auth, _pwd);\n"
"DAV_PROP_REMOVE (_vvc, \'virt:Versioning-Attic\', _auth, _pwd);\n"
"connection_set (\'Versioning REM PROP\', NULL);\n"
"return 1;\n"
"}\n"
"--src DET_Versioning.sql:1337\n";

static const char *proc620 = 
"create function \"Versioning_SETPROP\" (in _resource varchar, in _propname varchar, in _value varchar,\n"
"in _auth varchar,\n"
"in _pwd varchar)\n"
"{\n"
"declare res int;\n"
"res := DAV_PROP_SET (_resource, _propname, _value, _auth, _pwd);\n"
"if (DAV_HIDE_ERROR (res) is null) {\n"
"if (res = -16 and (DAV_PROP_GET (_resource, _propname, _auth, _pwd) = _value))\n"
"return _value;\n"
"}\n"
"return res;\n"
"}\n"
"--src DET_Versioning.sql:1360\n";

static const char *proc621 = 
"create function DAV_SET_VERSIONING_CONTROL (in _main varchar, in _vvc varchar, in _auto_version varchar, in _auth varchar, in _pwd varchar)\n"
"{\n"
"if (_vvc is null)\n"
"_vvc := _main || \'VVC/\';\n"
"\n"
"declare _auto_version_val varchar;\n"
"_auto_version_val := \"Versioning_AUTO_VERSION_PROP\" (_auto_version);\n"
"if (DAV_HIDE_ERROR (_auto_version) is null)\n"
"return -17;\n"
"declare _main_id, _vvc_id int;\n"
"_main_id := DB.DBA.DAV_SEARCH_ID ( _main, \'C\');\n"
"\n"
"if (DAV_HIDE_ERROR (_main_id) is null)\n"
"return _main_id;\n"
"_vvc_id := DB.DBA.DAV_SEARCH_ID ( _vvc, \'C\');\n"
"\n"
"if (DAV_HIDE_ERROR (_vvc_id) is null)\n"
"return _vvc_id;\n"
"update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING = _auto_version where COL_ID = _main_id;\n"
"update WS.WS.SYS_DAV_COL set COL_DET = \'Versioning\' where COL_ID = _vvc_id;\n"
"declare res int;\n"
"\n"
"res := \"Versioning_SETPROP\" (_vvc,\n"
"\'virt:Versioning-Collection\',\n"
"_main,\n"
"_auth, _pwd);\n"
"if (DAV_HIDE_ERROR (res) is null)\n"
"goto err;\n"
"\n"
"res := \"Versioning_SETPROP\" (_main,\n"
"\'virt:Versioning-History\',\n"
"_vvc,\n"
"_auth, _pwd );\n"
"if (DAV_HIDE_ERROR (res) is null)\n"
"goto err;\n"
"\n"
"for select RES_NAME, RES_FULL_PATH, U_NAME from WS.WS.SYS_DAV_RES inner join DB.DBA.SYS_USERS\n"
"on U_ID = RES_OWNER\n"
"where RES_COL = _main_id\n"
"do {\n"
"declare props_vect any;\n"
"props_vect := vector (\'DAV:checked-in\',  _vvc || RES_NAME || \'/last\',\n"
"\'DAV:version-history\', _vvc || RES_NAME || \'/history.xml\',\n"
"\'DAV:author\', U_NAME );\n"
"\n"
"if (_auto_version_val is not null)\n"
"props_vect := vector_concat ( props_vect,\n"
"vector (\'DAV:auto-version\', _auto_version_val));\n"
"res := DAV_SET_VERSIONING_PROPERTIES (RES_FULL_PATH,\n"
"props_vect);\n"
"if (DAV_HIDE_ERROR (res) is null)\n"
"goto err;\n"
"}\n"
"return _vvc_id;\n"
"err:\n"
"rollback work;\n"
"\n"
"return res;\n"
"}\n"
"--src DET_Versioning.sql:1375\n";

static const char *proc622 = 
"create procedure DAV_MKWORKSPACE (in path varchar)\n"
"{\n"
"declare _id any;\n"
"_id := DAV_SEARCH_ID (path, \'R\');\n"
"if (DAV_HIDE_ERROR (_id) is null)\n"
"return _id;\n"
"if (not isinteger (_id))\n"
"return -20;\n"
"declare _parent int;\n"
"declare _owner, _group int;\n"
"declare _name, _type, _perms varchar;\n"
"declare _res int;\n"
"declare _owner_name, _group_name varchar;\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (_id, \'R\',\'DAV:workspace\', 0)) is not null)\n"
"return -3;\n"
"select RES_COL, RES_OWNER, RES_GROUP, RES_NAME, RES_TYPE, RES_PERMS into\n"
"_parent, _owner, _group, _name, _type, _perms\n"
"from WS.WS.SYS_DAV_RES where RES_ID = _id;\n"
"_owner_name := (select U_NAME from DB.DBA.SYS_USERS where U_ID = _owner);\n"
"_group_name := (select U_NAME from DB.DBA.SYS_USERS where U_ID = _group);\n"
"if (exists (select PROP_VALUE from WS.WS.SYS_DAV_PROP where\n"
"PROP_NAME = \'virt:Versioning-History\' and PROP_PARENT_ID = _parent)) {\n"
"declare _parent_path, _copy_path varchar;\n"
"_parent_path := DAV_SEARCH_PATH (_parent, \'C\');\n"
"_copy_path := _parent_path || \'workspace!/\' || _name;\n"
"if (0 > DAV_SEARCH_ID (_parent_path || \'workspace!/\', \'C\')) {\n"
"\n"
"_res := DAV_COL_CREATE_INT (_parent_path || \'workspace!/\', \'110000000--\',\n"
"_owner_name, _group_name,\n"
"null, null, 1, 0, 1);\n"
"if (_res < 0)\n"
"return _res;\n"
"}\n"
"else if (0 < DAV_SEARCH_ID (_copy_path, \'R\'))\n"
"return -3;\n"
"if (0 > (_res := DAV_PROP_SET_INT (path, \'DAV:workspace\', _copy_path, NULL, NULL, 0, 0, 1)))\n"
"return _res;\n"
"return _copy_path;\n"
"}\n"
"else\n"
"return -11;\n"
"}\n"
"--src DET_Versioning.sql:1438\n";

static const char *proc623 = 
"create procedure DAV_CHECKOUT (in path varchar, in auth varchar, in pwd varchar)\n"
"{\n"
"return DAV_CHECKOUT_INT (path, auth, pwd);\n"
"}\n"
"--src DET_Versioning.sql:1482\n";

static const char *proc624 = 
"create procedure DAV_CHECKOUT_INT (in path_or_id any, in auth varchar, in pwd varchar, in extern int := 0)\n"
"{\n"
"declare _id int;\n"
"declare _checked_in varchar;\n"
"declare path varchar;\n"
"if (isstring (path_or_id)) {\n"
"path := path_or_id;\n"
"_id := DAV_SEARCH_ID (path, \'R\');\n"
"if (_id < 0)\n"
"return _id;\n"
"}\n"
"else if (isinteger (path_or_id)) {\n"
"_id := path_or_id;\n"
"path := DAV_SEARCH_PATH (_id, \'R\');\n"
"if (DAV_HIDE_ERROR (path) is null)\n"
"return path;\n"
"}\n"
"\n"
"if (DAV_HIDE_ERROR (_id) is null)\n"
"return _id;\n"
"if (extern and (DAV_HIDE_ERROR (DAV_AUTHENTICATE (_id, \'R\', \'_1_\', auth, pwd)) is null))\n"
"return -13;\n"
"if (not isinteger (_id))\n"
"return -20;\n"
"_checked_in := DAV_PROP_GET_INT (_id, \'R\', \'DAV:checked-in\', 0);\n"
"\n"
"if (DAV_HIDE_ERROR (_checked_in) is null)\n"
"return -1;\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (_id, \'R\', \'DAV:checked-out\', 0)) is not null)\n"
"return -11;\n"
"\n"
"declare _owner, _group int;\n"
"declare _name, _type, _perms varchar;\n"
"declare _rc int;\n"
"declare _owner_name, _group_name varchar;\n"
"select RES_OWNER, RES_GROUP, RES_NAME, RES_TYPE, RES_PERMS into\n"
"_owner, _group, _name, _type, _perms\n"
"from WS.WS.SYS_DAV_RES where RES_ID = _id;\n"
"_rc := DAV_PROP_SET_INT (path, \'DAV:checked-out\', _checked_in, NULL, NULL, 0, 0, 1);\n"
"if (DAV_HIDE_ERROR (_rc) is null)\n"
"return _rc;\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"DAV_PROP_REMOVE_INT (path, \'DAV:checked-in\', null, null, 0, 0);\n"
"connection_set (\'Versioning REM PROP\', NULL);\n"
"return _id;\n"
"}\n"
"--src DET_Versioning.sql:1488\n";

static const char *proc625 = 
"create procedure DAV_CHECKIN (in path varchar, in auth varchar, in pwd varchar)\n"
"{\n"
"return DAV_CHECKIN_INT (path, auth, pwd);\n"
"}\n"
"--src DET_Versioning.sql:1536\n";

static const char *proc626 = 
"create procedure DAV_CHECKIN_INT (in path varchar, in auth varchar, in pwd varchar, in extern int:=1)\n"
"{\n"
"\n"
"declare _id int;\n"
"declare _checked_out varchar;\n"
"if (auth is null)\n"
"auth := connection_get (\'HTTP_CLI_UID\');\n"
"_id := DAV_SEARCH_ID (path, \'R\');\n"
"if (DAV_HIDE_ERROR (_id) is null)\n"
"return _id;\n"
"\n"
"if (extern and (DAV_HIDE_ERROR (DAV_AUTHENTICATE (_id, \'R\', \'_1_\', auth, pwd)) is null))\n"
"return -13;\n"
"\n"
"if (not isinteger (_id))\n"
"return -20;\n"
"_checked_out := DAV_PROP_GET_INT (_id, \'R\', \'DAV:checked-out\', 0);\n"
"if (DAV_HIDE_ERROR (_checked_out) is null)\n"
"return -38;\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (_id, \'R\', \'DAV:checked-in\', 0)) is not null)\n"
"return -11;\n"
"\n"
"declare _content any;\n"
"declare _type varchar;\n"
"declare _rc int;\n"
"\n"
"select RES_CONTENT, RES_TYPE into _content, _type from WS.WS.SYS_DAV_RES where RES_ID = _id;\n"
"\n"
"declare dt datetime;\n"
"dt := now();\n"
"\n"
"declare _ver_id, _ver_next_id int;\n"
"_ver_id := (select max (RV_ID) from WS.WS.SYS_DAV_RES_VERSION where\n"
"RV_RES_ID = _id);\n"
"if (_ver_id is null) {\n"
"insert into WS.WS.SYS_DAV_RES_VERSION (RV_RES_ID ,\n"
"RV_ID,\n"
"RV_NODE_NAME,\n"
"RV_PREV_ID,\n"
"RV_ACT_ID,\n"
"RV_RES_TYPE,\n"
"RV_CR_TIME,\n"
"RV_MOD_TIME,\n"
"RV_WHO,\n"
"RV_SIZE)\n"
"values (_id, 1,\n"
"NULL, NULL, NULL, _type, dt, dt, auth, length (_content));\n"
"\"Versioning_ADD_NEW_DIFF\" (_id, NULL, NULL, _content, \'c\');\n"
"}\n"
"else {\n"
"declare _old_content any;\n"
"select RD_DELTA into _old_content from WS.WS.SYS_DAV_RES_DIFF\n"
"where RD_FROM_ID = 0 and RD_RES_ID = _id;\n"
"\n"
"declare _diff, _diff_type varchar;\n"
"if (_type like \'text/%\') {\n"
"whenever sqlstate \'DF*\' goto full_copy;\n"
"whenever sqlstate \'22*\' goto full_copy;\n"
"_diff := diff (_content, _old_content, \'--normal\');\n"
"_diff_type := \'D\';\n"
"}\n"
"else {\n"
"full_copy:\n"
"\n"
"_diff := NULL;\n"
"_diff_type := \'c\';\n"
"}\n"
"_ver_next_id := _ver_id + 1;\n"
"insert into WS.WS.SYS_DAV_RES_VERSION (RV_RES_ID ,\n"
"RV_ID,\n"
"RV_NODE_NAME,\n"
"RV_PREV_ID,\n"
"RV_ACT_ID,\n"
"RV_RES_TYPE,\n"
"RV_CR_TIME,\n"
"RV_MOD_TIME,\n"
"RV_WHO,\n"
"RV_SIZE)\n"
"values (_id, _ver_next_id,\n"
"NULL, _ver_id, NULL, _type, dt, dt, auth, length (_content));\n"
"\"Versioning_ADD_NEW_DIFF\" (_id, _ver_next_id, _ver_id, _content, _diff_type, _diff);\n"
"}\n"
"_rc := DAV_PROP_SET_INT (path, \'DAV:checked-in\', _checked_out, NULL, NULL, 0, 0, 1);\n"
"if (DAV_HIDE_ERROR (_rc) is null)\n"
"return _rc;\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"DAV_PROP_REMOVE_INT (path, \'DAV:checked-out\', null, null, 0, 0);\n"
"connection_set (\'Versioning REM PROP\', NULL);\n"
"return _id;\n"
"nf:\n"
"\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:1542\n";

static const char *proc627 = 
"create procedure \"Versioning_CHECKOUT_INT\" (\n"
"in _id int,\n"
"in _content any,\n"
"in _type varchar,\n"
"in _perms varchar,\n"
"in _owner integer,\n"
"in _group integer)\n"
"{\n"
"declare _res int;\n"
"declare _path varchar;\n"
"_path := DAV_SEARCH_PATH (_id, \'R\');\n"
"\n"
"if (not isstring (_path))\n"
"return _path;\n"
"_res := DAV_CHECKOUT_INT (_path, null, null, 0);\n"
"\n"
"if (_res > 0)\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = _content where RES_ID = _id;\n"
"else\n"
"return _res;\n"
"return _id;\n"
"}\n"
"--src DET_Versioning.sql:1637\n";

static const char *trig45 = 
"CREATE TRIGGER \"Versioning_UNLOCK\" BEFORE DELETE ON WS.WS.SYS_DAV_LOCK REFERENCING OLD AS O\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"\n"
"\n"
"resignal;\n"
"};\n"
"\n"
"\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (O.LOCK_PARENT_ID, \'R\', \'DAV:checked-out\', 0)) is null)\n"
"return;\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (O.LOCK_PARENT_ID, \'R\', \'DAV:checked-in\', 0)) is not null)\n"
"return;\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (O.LOCK_PARENT_ID, \'R\', \'DAV:auto-version\', 0)) <> \'DAV:locked-checkout\')\n"
"return;\n"
"declare _rc int;\n"
"_rc := DAV_CHECKIN_INT ( DAV_SEARCH_PATH (O.LOCK_PARENT_ID, \'R\'), null, null, 0 );\n"
"\n"
"}\n"
"--src DET_Versioning.sql:1661\n";

static const char *proc628 = 
"create function DAV_VERSION_CONTROL (in path varchar, in auth varchar, in pwd varchar)\n"
"{\n"
"\n"
"declare _id int;\n"
"_id := DAV_SEARCH_ID (path, \'R\');\n"
"if (DAV_HIDE_ERROR (_id) is null)\n"
"return _id;\n"
"if (not isinteger (_id))\n"
"return -37;\n"
"\n"
"declare _attic_id, _vvc_id, _main_id, _rc, ouid, guid int;\n"
"declare _attic, _vvc, _main, oname, gname, resource varchar;\n"
"select RES_NAME, RES_COL, RES_OWNER, RES_GROUP into resource, _main_id, ouid, guid from WS.WS.SYS_DAV_RES where RES_FULL_PATH = path;\n"
"_main := DAV_SEARCH_PATH (_main_id, \'C\');\n"
"_vvc := _main || \'VVC/\';\n"
"_vvc_id := DAV_SEARCH_ID (_vvc, \'C\');\n"
"oname := (select U_NAME from DB.DBA.SYS_USERS where U_ID = ouid);\n"
"gname := (select U_NAME from DB.DBA.SYS_USERS where U_ID = guid);\n"
"if (DAV_HIDE_ERROR (_vvc_id) is null) {\n"
"\n"
"_vvc_id := DB.DBA.DAV_COL_CREATE (_vvc, \'110100000--\', oname, gname, auth, pwd);\n"
"if (_vvc_id < 0)\n"
"return _vvc_id;\n"
"if (DAV_HIDE_ERROR(_rc := DAV_PROP_SET (_vvc,\n"
"\'virt:Versioning-Collection\',\n"
"_main,\n"
"auth, pwd ) ) is null)\n"
"{\n"
"\n"
"return _rc;\n"
"}\n"
"if (DAV_HIDE_ERROR(_rc := DAV_PROP_SET (_main,\n"
"\'virt:Versioning-History\',\n"
"_vvc,\n"
"auth, pwd )) is null)\n"
"{\n"
"\n"
"return _rc;\n"
"}\n"
"update WS.WS.SYS_DAV_COL set COL_DET = \'Versioning\' where COL_ID = _vvc_id;\n"
"}\n"
"_attic := _main || \'Attic/\';\n"
"_attic_id := DAV_SEARCH_ID (_attic, \'C\');\n"
"if (DAV_HIDE_ERROR (_attic_id) is null)\n"
"{\n"
"\n"
"_attic_id := DB.DBA.DAV_COL_CREATE (_attic, \'110100000--\', oname, gname, auth, pwd);\n"
"if (DAV_HIDE_ERROR (_attic_id) is null) {\n"
"\n"
"return _attic_id;\n"
"}\n"
"_rc := DAV_PROP_SET (_vvc, \'virt:Versioning-Attic\', _attic, auth, pwd);\n"
"if (DAV_HIDE_ERROR (_rc) is null) {\n"
"\n"
"return _rc;\n"
"}\n"
"}\n"
"\n"
"if (DAV_HIDE_ERROR(DAV_PROP_GET_INT (_id, \'R\', \'DAV:checked-in\', 0))\n"
"or (DAV_HIDE_ERROR(DAV_PROP_GET_INT(_id, \'R\', \'DAV:checked-out\', 0))))\n"
"return _id;\n"
"\n"
"declare props_vect any;\n"
"props_vect := vector (\'DAV:checked-in\',  _vvc || resource || \'/last\',\n"
"\'DAV:version-history\', _vvc || resource || \'/history.xml\',\n"
"\'DAV:author\', oname );\n"
"\n"
"_rc := DAV_SET_VERSIONING_PROPERTIES (path, props_vect);\n"
"if (DAV_HIDE_ERROR (_rc) is null)\n"
"return _rc;\n"
"declare dt datetime;\n"
"dt := now();\n"
"declare _type varchar;\n"
"declare _content any;\n"
"select RES_TYPE, RES_CONTENT into _type, _content from WS.WS.SYS_DAV_RES where RES_ID = _id;\n"
"\n"
"insert into WS.WS.SYS_DAV_RES_VERSION (RV_RES_ID ,\n"
"RV_ID,\n"
"RV_NODE_NAME,\n"
"RV_PREV_ID,\n"
"RV_ACT_ID,\n"
"RV_RES_TYPE,\n"
"RV_CR_TIME,\n"
"RV_MOD_TIME,\n"
"RV_WHO,\n"
"RV_SIZE)\n"
"values (_id, 1,\n"
"NULL, NULL, NULL, _type, dt, dt, auth, length (_content));\n"
"\"Versioning_ADD_NEW_DIFF\" (_id, NULL, NULL, _content, \'c\');\n"
"\n"
"return _id;\n"
"}\n"
"--src DET_Versioning.sql:1684\n";

static const char *proc629 = 
"create function DAV_UNCHECKOUT (in path varchar, in auth varchar, in pwd varchar)\n"
"{\n"
"\n"
"declare _content, _props any;\n"
"declare _id int;\n"
"_id := DAV_SEARCH_ID (path, \'R\');\n"
"if (DAV_HIDE_ERROR (_id) is null)\n"
"return _id;\n"
"if (DAV_HIDE_ERROR (DAV_AUTHENTICATE (_id, \'R\', \'_1_\', auth, pwd)) is null)\n"
"return -13;\n"
"if (DAV_HIDE_ERROR(DAV_PROP_GET_INT (_id, \'R\', \'DAV:checked-out\', 0)) is null\n"
"or (DAV_HIDE_ERROR(DAV_PROP_GET_INT(_id, \'R\', \'DAV:checked-in\', 0))))\n"
"return -38;\n"
"whenever not found goto nf;\n"
"select RD_DELTA,RD_PROPS into _content, _props from WS.WS.SYS_DAV_RES_DIFF\n"
"inner join WS.WS.SYS_DAV_RES on (RD_RES_ID = RES_ID)\n"
"where RES_FULL_PATH = path and RD_FROM_ID = 0;\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = _content where RES_ID = _id;\n"
"declare _rc int;\n"
"if (_props is not null and isentity (_props)) {\n"
"declare idx int;\n"
"declare _ent any;\n"
"idx := 1;\n"
"for select PROP_NAME from WS.WS.SYS_DAV_PROP\n"
"where PROP_PARENT_ID = _id\n"
"and PROP_NAME not like \'DAV:%\'\n"
"and PROP_NAME not like \':%\'\n"
"and PROP_NAME not like \'virt:\'\n"
"do {\n"
"if ( 0 > (_rc := DAV_PROP_REMOVE_INT (path, PROP_NAME, null, null, 0, 0)))\n"
"{\n"
"rollback work;\n"
"return _rc;\n"
"}\n"
"}\n"
"while ( (_ent := xpath_eval (\'//property\', _props, idx)) is not null)\n"
"{\n"
"if ( 0 > (_rc := DAV_PROP_SET_INT (path,\n"
"cast (xpath_eval (\'@name\', _ent) as varchar),\n"
"cast (xpath_eval (\'text()\', _ent) as varchar),\n"
"NULL, NULL, 0, 0, 1)))\n"
"{\n"
"rollback work;\n"
"return _rc;\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"declare _checked_out varchar;\n"
"_checked_out := DAV_PROP_GET_INT (_id, \'R\', \'DAV:checked-out\', 0);\n"
"if (DAV_HIDE_ERROR (_checked_out) is null) {\n"
"rollback work;\n"
"return _checked_out;\n"
"}\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"_rc :=  DAV_PROP_REMOVE_INT (path, \'DAV:checked-out\', null, null, 0, 0);\n"
"connection_set (\'Versioning REM PROP\', NULL);\n"
"if (DAV_HIDE_ERROR (_rc) is null) {\n"
"rollback work;\n"
"return _rc;\n"
"}\n"
"_rc := DAV_PROP_SET_INT (path, \'DAV:checked-in\', _checked_out, NULL, NULL, 0, 0, 1);\n"
"if (DAV_HIDE_ERROR (_rc) is null) {\n"
"rollback work;\n"
"return _rc;\n"
"}\n"
"return _id;\n"
"nf:\n"
"\n"
"return -1;\n"
"}\n"
"--src DET_Versioning.sql:1779\n";

static const char *proc630 = 
"create procedure \"Versioning_Attic\" (in _resource varchar)\n"
"{\n"
"declare _col int;\n"
"_col := (select RES_COL from WS.WS.SYS_DAV_RES where RES_FULL_PATH = _resource);\n"
"if (_col is null)\n"
"return null;\n"
"declare _hist_col varchar;\n"
"_hist_col := DAV_PROP_GET_INT (_col, \'C\', \'virt:Versioning-History\', 0);\n"
"if (DAV_HIDE_ERROR (_hist_col) is null)\n"
"return NULL;\n"
"_hist_col := DAV_SEARCH_ID (_hist_col, \'C\');\n"
"if (DAV_HIDE_ERROR (_hist_col) is null)\n"
"return NULL;\n"
"return DAV_HIDE_ERROR (DAV_PROP_GET_INT (_hist_col, \'C\', \'virt:Versioning-Attic\', 0));\n"
"}\n"
"--src DET_Versioning.sql:1853\n";

static const char *proc631 = 
"create procedure \"Versioning_OTHER_FILES_IN_VVC\" (in _res varchar)\n"
"{\n"
"\n"
"return 1;\n"
"}\n"
"--src DET_Versioning.sql:1870\n";

static const char *proc632 = 
" create procedure DAV_REMOVE_VERSION_CONTROL (in _resource varchar, in auth varchar, in pwd varchar, in tokens any := 1)\n"
"{\n"
"declare _err int;\n"
"if ((DAV_HIDE_ERROR ( (_err := DAV_PROP_GET (_resource, \'DAV:checked-out\', auth, pwd))) is null) and\n"
"(_err = -11))\n"
"{\n"
"declare checkin varchar;\n"
"declare locked int;\n"
"declare _id int;\n"
"if (DAV_HIDE_ERROR ( (checkin := DAV_PROP_GET (_resource, \'DAV:checked-in\', auth, pwd))) is null)\n"
"return checkin;\n"
"_id := DAV_SEARCH_ID (_resource, \'R\');\n"
"if (_id < 0)\n"
"return _id;\n"
"if(DAV_HIDE_ERROR ( (locked := DAV_IS_LOCKED (_id, \'R\', tokens))) is null)\n"
"return locked;\n"
"if (locked)\n"
"return -8;\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"_err := DAV_PROP_REMOVE (_resource, \'DAV:checked-in\', auth, pwd);\n"
"connection_set (\'Versioning REM PROP\', NULL);\n"
"if (DAV_HIDE_ERROR (_err) is null)\n"
"return _err;\n"
"declare _attic varchar;\n"
"_attic := \"Versioning_Attic\" (_resource);\n"
"if (_attic is not null) {\n"
"declare _name varchar;\n"
"select RES_NAME into _name from WS.WS.SYS_DAV_RES where RES_FULL_PATH = _resource;\n"
"DAV_DELETE (_attic || _name, 1, pwd, auth);\n"
"}\n"
"if (not \"Versioning_OTHER_FILES_IN_VVC\" (_resource)) {\n"
"if (_attic is not null)\n"
"DAV_DELETE (_attic, 1, pwd, auth);\n"
"}\n"
"\n"
"\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"DAV_PROP_REMOVE (_resource, \'DAV:auto-version\', auth, pwd);\n"
"DAV_PROP_REMOVE (_resource, \'DAV:author\', auth, pwd);\n"
"DAV_PROP_REMOVE (_resource, \'DAV:version-history\', auth, pwd);\n"
"connection_set (\'Versioning REM PROP\', NULL);\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = _id;\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = _id;\n"
"return _id;\n"
"}\n"
"else {\n"
"if (isinteger (_err))\n"
"return _err;\n"
"else\n"
"return -37;\n"
"}\n"
"}\n"
"--src DET_Versioning.sql:1878\n";

static const char *proc633 = 
" create procedure DAV_VERSION_FOLD_INT (in path varchar, in target_version int, in auth varchar)\n"
"{\n"
"if (target_version <= 0)\n"
"return -17;\n"
"declare id, res int;\n"
"id := DAV_SEARCH_ID (path, \'R\');\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"return id;\n"
"\n"
"\n"
"declare _curr_content, _type varchar;\n"
"declare _curr_cr_time, _curr_mod_time datetime;\n"
"declare cr cursor for select RES_CONTENT, RES_TYPE, RES_CR_TIME, RES_MOD_TIME from WS.WS.SYS_DAV_RES\n"
"where RES_ID = id;\n"
"open cr (prefetch 1, exclusive);\n"
"fetch cr into _curr_content, _type, _curr_cr_time, _curr_mod_time;\n"
"close cr;\n"
"\n"
"declare _prev_version int;\n"
"declare exit handler for not found {\n"
"return -17;\n"
"};\n"
"select RV_PREV_ID into _prev_version from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = id and RV_ID = target_version;\n"
"if (_prev_version is null) {\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = id and RD_TO_ID <> target_version;\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = id and RV_ID <> target_version;\n"
"update WS.WS.SYS_DAV_RES_DIFF set RD_DELTA = _curr_content where RD_RES_ID = id and RD_TO_ID = target_version;\n"
"return id;\n"
"}\n"
"else {\n"
"declare _prev_content, _prev_type, _prev_mode varchar;\n"
"DAV_GET_VERSION_CONTENT (id, _prev_version, _prev_content, _prev_type, _prev_mode);\n"
"whenever sqlstate \'DF*\' goto full_copy;\n"
"declare _diff, _diff_type varchar;\n"
"if (_type like \'text/%\') {\n"
"_diff := diff (cast (_curr_content as varchar), cast (_prev_content as varchar), \'--normal\');\n"
"_diff_type := \'D\';\n"
"}\n"
"else {\n"
"full_copy:\n"
"\n"
"_diff := NULL;\n"
"_diff_type := \'c\';\n"
"}\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RD_RES_ID = id and RD_TO_ID > _prev_version;\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = id and RV_ID > _prev_version;\n"
"insert replacing WS.WS.SYS_DAV_RES_VERSION (RV_RES_ID ,\n"
"RV_ID,\n"
"RV_NODE_NAME,\n"
"RV_PREV_ID,\n"
"RV_ACT_ID,\n"
"RV_RES_TYPE,\n"
"RV_CR_TIME,\n"
"RV_MOD_TIME,\n"
"RV_WHO,\n"
"RV_SIZE)\n"
"values (id, target_version,\n"
"NULL, _prev_version, NULL, _type, _curr_cr_time, _curr_mod_time, auth, length (_curr_content));\n"
"\"Versioning_ADD_NEW_DIFF\" (id, target_version, _prev_version, _curr_content, _diff_type, _diff);\n"
"return id;\n"
"}\n"
"}\n"
"--src DET_Versioning.sql:1934\n";

static const char *trig46 = 
"CREATE TRIGGER \"Versioning_DELETE_COL_B\" BEFORE DELETE ON WS.WS.SYS_DAV_COL ORDER 50 REFERENCING OLD AS O\n"
"{\n"
"\n"
"if (DAV_HIDE_ERROR (DAV_PROP_GET_INT (O.COL_ID, \'C\', \'virt:Versioning-Collection\', 0)) is not null)\n"
"{\n"
"declare _col_id int;\n"
"declare _attic varchar;\n"
"_col_id := DAV_SEARCH_ID (DAV_PROP_GET_INT (O.COL_ID, \'C\', \'virt:Versioning-Collection\', 0), \'C\');\n"
"_attic := DAV_HIDE_ERROR (DAV_PROP_GET_INT (O.COL_ID, \'C\', \'virt:Versioning-Attic\', 0));\n"
"\n"
"\n"
"connection_set (\'Versioning REM PROP\', 1);\n"
"for select RES_FULL_PATH, RES_ID from WS.WS.SYS_DAV_RES\n"
"where RES_COL = _col_id and exists (select 1 from WS.WS.SYS_DAV_RES_VERSION where RV_RES_ID = RES_ID)\n"
"do {\n"
"delete from WS.WS.SYS_DAV_RES_DIFF where RES_ID = RD_RES_ID;\n"
"delete from WS.WS.SYS_DAV_RES_VERSION where  RES_ID = RV_RES_ID;\n"
"\"Versioning_REMOVE_V_PROPERTIES\" (RES_FULL_PATH);\n"
"}\n"
"update WS.WS.SYS_DAV_COL set COL_AUTO_VERSIONING = NULL where COL_ID = _col_id;\n"
"\n"
"if (_attic is not null)\n"
"DAV_DELETE_INT (_attic, 0, null, null, 0);\n"
"}\n"
"}\n"
"--src DET_Versioning.sql:1998\n";

/* xml_view.sql */

static const char *proc634 = 
"create procedure XML_VIEW_PUBLISH\n"
"(\n"
"in view_name varchar,\n"
"in dav_path varchar,\n"
"in dav_owner varchar,\n"
"in is_persistent integer,\n"
"in refresh_interval integer,\n"
"in meta_mode integer,\n"
"in meta_data varchar\n"
")\n"
"{\n"
"declare path, _body any;\n"
"declare _col_id, _id integer;\n"
"declare _u_id, _u_grp integer;\n"
"declare _u_perm, _r_name, _pf varchar;\n"
"declare _update_call1, _update_call2 varchar;\n"
"declare _full_path varchar;\n"
"declare _meta_body any;\n"
"declare _meta_path_suffix varchar;\n"
"declare _meta_mime varchar;\n"
"declare _ondemand_data varchar;\n"
"declare _procprefix varchar;\n"
"_procprefix := concat (name_part (view_name, 0), \'.\', name_part (view_name, 1), \'.\');\n"
"if (not exists (select 1 from SYS_PROCEDURES\n"
"where P_NAME like concat ( _procprefix, \'http_\', name_part (view_name, 2), \'_%\')))\n"
"signal (\'S1000\', concat (\'the XML view \', view_name, \' does not exist\'));\n"
"\n"
"if (not exists (select 1 from SYS_PROCEDURES\n"
"where P_NAME = concat ( _procprefix, \'http_view_\', name_part (view_name, 2))))\n"
"signal (\'S1000\', concat (\'the XML view \', view_name, \' does not exist\'));\n"
"\n"
"if (aref (dav_path, 0) <> ascii (\'/\'))\n"
"signal (\'42000\', \'The DAV path should be absolute\');\n"
"\n"
"if (dav_root () <> \'\')\n"
"_full_path := concat (\'/\', dav_root (), dav_path);\n"
"else\n"
"_full_path := dav_path;\n"
"\n"
"path := WS.WS.HREF_TO_ARRAY (concat (\'/DAV\', dav_path), \'\');\n"
"\n"
"if (WS.WS.FINDCOL (path, _col_id) <> length (path) - 1)\n"
"signal (\'S1000\', \'the DAV collection of the view does not exist or is invalid\');\n"
"\n"
"\n"
"\n"
"whenever not found goto nfu;\n"
"_u_id := null;\n"
"select U_ID, U_GROUP, U_DEF_PERMS into _u_id, _u_grp, _u_perm from WS.WS.SYS_DAV_USER where U_NAME = dav_owner;\n"
"nfu:\n"
"if (_u_id is null)\n"
"signal (\'42000\', \'a DAV user with that name does not exist\');\n"
"\n"
"if (is_persistent = 0)\n"
"{\n"
"_ondemand_data := concat (\n"
"view_name, \'{view_name}\\n\',\n"
"cast (meta_mode as varchar), \'{meta_mode}\\n\',\n"
"meta_data );\n"
"}\n"
"\n"
"if (refresh_interval > 0)\n"
"{\n"
"\n"
"_update_call1 := concat (\n"
"\'WS.WS.XML_VIEW_UPDATE (\',\n"
"WS.WS.STR_SQL_APOS(view_name), \', \'\n"
");\n"
"\n"
"_update_call2 := concat ( \', \',\n"
"WS.WS.STR_SQL_APOS(_full_path), \', \',\n"
"cast (meta_mode as varchar), \', \',\n"
"WS.WS.STR_SQL_APOS(meta_data), \')\'\n"
");\n"
"}\n"
"\n"
"_meta_body := string_output ();\n"
"WS.WS.XML_VIEW_EXTERNAL_META(\n"
"view_name, name_part (view_name, 2), meta_mode, meta_data,\n"
"_meta_body, _meta_path_suffix, _meta_mime );\n"
"if(_meta_path_suffix <> \'\')\n"
"{\n"
"_meta_path_suffix := concat( aref (path, length (path) - 1), _meta_path_suffix);\n"
"_meta_body := string_output_string (_meta_body);\n"
"if (exists (select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_COL = _col_id and RES_NAME = _meta_path_suffix))\n"
"{\n"
"update WS.WS.SYS_DAV_RES set\n"
"RES_CONTENT = _meta_body,\n"
"RES_TYPE = _meta_mime,\n"
"RES_MOD_TIME = now (),\n"
"RES_OWNER = _u_id,\n"
"RES_GROUP = _u_grp,\n"
"RES_PERMS = _u_perm\n"
"where RES_COL = _col_id and RES_NAME = _meta_path_suffix;\n"
"} else {\n"
"insert into WS.WS.SYS_DAV_RES\n"
"(\n"
"RES_ID, RES_NAME, RES_COL,\n"
"RES_TYPE, RES_CONTENT,\n"
"RES_CR_TIME, RES_MOD_TIME,\n"
"RES_OWNER, RES_PERMS, RES_GROUP\n"
")\n"
"values\n"
"(\n"
"WS.WS.GETID (\'R\'), _meta_path_suffix, _col_id,\n"
"_meta_mime, _meta_body,\n"
"now (), now (),\n"
"_u_id, _u_perm, _u_grp\n"
");\n"
"}\n"
"}\n"
"\n"
"if (not WS.WS.ISRES (path))\n"
"{\n"
"if (is_persistent = 0)\n"
"{\n"
"insert\n"
"into WS.WS.SYS_DAV_RES\n"
"(\n"
"RES_ID, RES_NAME, RES_COL,\n"
"RES_TYPE,\n"
"RES_CONTENT,\n"
"RES_CR_TIME, RES_MOD_TIME,\n"
"RES_OWNER, RES_PERMS, RES_GROUP\n"
")\n"
"values\n"
"(\n"
"WS.WS.GETID (\'R\'), aref (path, length (path) - 1), _col_id,\n"
"\'xml/view\',\n"
"_ondemand_data,\n"
"now (), now (),\n"
"_u_id, _u_perm, _u_grp\n"
");\n"
"}\n"
"else\n"
"{\n"
"_body := string_output ();\n"
"WS.WS.XML_VIEW_HEADER(view_name, name_part (view_name, 2), _full_path, meta_mode, meta_data, _body);\n"
"_pf := concat (_procprefix, \'http_view_\', name_part (view_name, 2));\n"
"call (_pf) (_body);\n"
"http (concat (\'</\', name_part (view_name, 2), \'>\'), _body);\n"
"_body := string_output_string (_body);\n"
"_id := WS.WS.GETID (\'R\');\n"
"insert\n"
"into WS.WS.SYS_DAV_RES\n"
"(\n"
"RES_ID, RES_NAME, RES_COL,\n"
"RES_TYPE, RES_CONTENT,\n"
"RES_CR_TIME, RES_MOD_TIME,\n"
"RES_OWNER, RES_PERMS, RES_GROUP\n"
")\n"
"values\n"
"(\n"
"_id, aref (path, length (path) - 1), _col_id,\n"
"\'xml/persistent-view\', _body,\n"
"now (), now (),\n"
"_u_id, _u_perm, _u_grp\n"
");\n"
"if (refresh_interval > 0)\n"
"insert into DB.DBA.SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_INTERVAL, SE_SQL)\n"
"values (\n"
"concat (\'/DAV\', dav_path), now (), refresh_interval,\n"
"concat(_update_call1, cast (_id as varchar), _update_call2)\n"
");\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare _type varchar;\n"
"WS.WS.FINDRES (path, _col_id, _r_name);\n"
"whenever not found goto nfri;\n"
"select RES_ID into _id from WS.WS.SYS_DAV_RES where RES_COL = _col_id and RES_NAME = _r_name;\n"
"nfri:\n"
"if (is_persistent = 0)\n"
"{\n"
"_body := _ondemand_data;\n"
"_type := \'xml/view\';\n"
"if (exists (select 1 from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = concat (\'/DAV\', dav_path)))\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where  SE_NAME = concat (\'/DAV\', dav_path);\n"
"}\n"
"else\n"
"{\n"
"_body := string_output ();\n"
"WS.WS.XML_VIEW_HEADER(view_name, name_part (view_name, 2), _full_path, meta_mode, meta_data, _body);\n"
"_pf := concat (_procprefix, \'http_view_\', name_part (view_name, 2));\n"
"call (_pf) (_body);\n"
"http (concat (\'</\', name_part (view_name, 2), \'>\'), _body);\n"
"_body := string_output_string (_body);\n"
"_type :=  \'xml/persistent-view\';\n"
"if (exists (select 1 from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = concat (\'/DAV\', dav_path)))\n"
"{\n"
"if (refresh_interval > 0)\n"
"update DB.DBA.SYS_SCHEDULED_EVENT\n"
"set\n"
"SE_INTERVAL = refresh_interval,\n"
"SE_START = now (),\n"
"SE_SQL = concat(_update_call1, cast (_id as varchar), _update_call2)\n"
"where  SE_NAME = concat (\'/DAV\', dav_path);\n"
"else\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where  SE_NAME = concat (\'/DAV\', dav_path);\n"
"}\n"
"else if (refresh_interval > 0)\n"
"insert into DB.DBA.SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_INTERVAL, SE_SQL)\n"
"values (\n"
"concat (\'/DAV\', dav_path), now (), refresh_interval,\n"
"concat(_update_call1, cast (_id as varchar), _update_call2)\n"
");\n"
"}\n"
"update WS.WS.SYS_DAV_RES set\n"
"RES_CONTENT = _body,\n"
"RES_TYPE = _type,\n"
"RES_MOD_TIME = now (),\n"
"RES_OWNER = _u_id,\n"
"RES_GROUP = _u_grp,\n"
"RES_PERMS = _u_perm\n"
"where RES_COL = _col_id and RES_NAME = _r_name;\n"
"}\n"
"}\n"
"--src xml_view.sql:31\n";

static const char *proc635 = 
"create procedure XML_VIEW_DROP (in view_name varchar)\n"
"{\n"
"declare _p_name varchar;\n"
"declare _update_call1 varchar;\n"
"declare _ondemand varchar;\n"
"declare _procprefix varchar;\n"
"view_name := cast (view_name as varchar);\n"
"_procprefix := concat (name_part (view_name, 0), \'.\', name_part (view_name, 1), \'.\');\n"
"delete from WS.WS.SYS_DAV_RES where RES_TYPE = \'xml/view\' and cast(RES_CONTENT as varchar) = view_name;\n"
"_ondemand := concat (view_name, \'{view_name}\\n\');\n"
"delete from WS.WS.SYS_DAV_RES\n"
"where RES_TYPE = \'xml/view\' and\n"
"substring (cast (RES_CONTENT as varchar), 1, length (_ondemand)) = _ondemand;\n"
"\n"
"_update_call1 := concat (\n"
"\'WS.WS.XML_VIEW_UPDATE (\',\n"
"WS.WS.STR_SQL_APOS(view_name), \', \'\n"
");\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT\n"
"where substring (SE_SQL, 1, length (_update_call1)) = _update_call1;\n"
"\n"
"if (not exists (select 1 from SYS_VIEWS where\n"
"V_NAME = view_name or\n"
"V_NAME = concat (_procprefix, name_part (view_name, 2)) ) )\n"
"signal (\'S1000\', concat (\'The XML view \'\'\', view_name, \'\'\' does not exist\'));\n"
"\n"
"XML_VIEW_DROP_PROCS (view_name);\n"
"delete from SYS_VIEWS where\n"
"V_NAME = view_name or\n"
"V_NAME = concat (_procprefix, name_part (view_name, 2));\n"
"xmls_viewremove (view_name);\n"
"xmls_viewremove (concat (_procprefix, name_part (view_name, 2)));\n"
"}\n"
"--src xml_view.sql:252\n";

static const char * xslt_define = "xslt_sheet (?, xtree_doc (?, 128, ?, 'LATIN-1', 'x-any', 'BuildStandalone=ENABLE'))";
static query_t *xslt_define_qr;

#define XSLT_DEFINE(name, text1) \
  { \
    caddr_t text = NULL;\
    static const char *elm;\
    int inx, len = 0;\
    for (inx = 0; ; inx++) { \
        elm = text1[inx];\
        if (!elm) break;\
        len += (int) strlen (elm);\
      }\
    text = dk_alloc_box (len + 1, DV_STRING);\
    text[0] = 0;\
    for (inx = 0; ; inx++) { \
        elm = text1[inx];\
        if (!elm) break;\
        strcat_box_ck (text, elm);\
      }\
    \
    if (!xslt_define_qr) \
      xslt_define_qr = sql_compile (xslt_define, bootstrap_cli, NULL, SQLC_DEFAULT); \
    if (xslt_define_qr) \
      { \
        caddr_t err = NULL; \
        err = qr_quick_exec (xslt_define_qr, bootstrap_cli, NULL, NULL, 3, \
               ":0", name, QRP_STR, ":1", text, QRP_STR, ":2", name, QRP_STR); \
        if (err) { \
          log_error ("Error executing a server init statement : %s: %s -- %.50s", \
          ((caddr_t *) err)[QC_ERRNO], ((caddr_t *) err)[QC_ERROR_STRING], \
                      text); \
          dk_free_tree (err); \
	    } \
	  local_commit (bootstrap_cli); \
      } \
    dk_free_box (text);\
  }

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_dav (void)
{
  caddr_t saved_qualifier = bootstrap_cli->cli_qualifier;

  /* dav.sql */

  DEFINE_PROC ("WS.WS.OPTIONS", proc0);
  DEFINE_PROC ("WS.WS.PROPFIND", proc1);
  DEFINE_PROC ("WS.WS.PROPFIND_RESPONSE", proc2);
  DEFINE_PROC ("WS.WS.PROPFIND_RESPONSE_FORMAT", proc3);
  DEFINE_PROC ("WS.WS.PROPNAMES", proc4);
  DEFINE_PROC ("WS.WS.CUSTOM_PROP", proc5);
  DEFINE_PROC ("WS.WS.PROPPATCH", proc6);
  DEFINE_PROC ("WS.WS.FINDPARAM", proc7);
  DEFINE_PROC ("WS.WS.MKCOL", proc8);
  DEFINE_PROC ("WS.WS.FINDCOL", proc9);
  DEFINE_PROC ("WS.WS.FINDRES", proc10);
  DEFINE_PROC ("WS.WS.DELCHILDREN", proc11);
  DEFINE_PROC ("WS.WS.DELETE", proc12);
  DEFINE_PROC ("WS.WS.ISCOL", proc13);
  DEFINE_PROC ("WS.WS.ISRES", proc14);
  DEFINE_PROC ("WS.WS.ETAG", proc15);
  DEFINE_PROC ("WS.WS.HEAD", proc16);
  DEFINE_PROC ("DAV_SET_HTTP_REQUEST_STATUS", proc17);
  DEFINE_PROC ("WS.WS.PUT", proc18);
  DEFINE_PROC ("WS.WS.HEX_TO_DEC", proc19);
  DEFINE_PROC ("WS.WS.STR_TO_URI", proc20);
  DEFINE_PROC ("WS.WS.PATHREF", proc21);
  DEFINE_PROC ("WS.WS.IS_ACTIVE_CONTENT", proc22);
  DEFINE_PROC ("WS.WS.GET_DAV_DEFAULT_PAGE", proc23);
  DEFINE_PROC ("WS.WS.GET_DAV_CHUNKED_QUOTA", proc24);
  DEFINE_PROC ("WS.WS.GET", proc25);
  DEFINE_PROC ("WS.WS.POST", proc26);
  DEFINE_PROC ("WS.WS.SPARQL_QUERY_POST", proc27);
  DEFINE_PROC ("WS.WS.SPARQL_QUERY_GET", proc28);
  DEFINE_PROC ("WS.WS.LOCK", proc29);
  DEFINE_PROC ("WS.WS.UNLOCK", proc30);
  DEFINE_PROC ("WS.WS.OPLOCKTOKEN", proc31);
  DEFINE_PROC ("WS.WS.PARENT_PATH", proc32);
  DEFINE_PROC ("WS.WS.HREF_TO_ARRAY", proc33);
  DEFINE_PROC ("WS.WS.HREF_TO_PATH_ARRAY", proc34);
  DEFINE_PROC ("WS.WS.DSTIS", proc35);
  DEFINE_PROC ("WS.WS.MOVE", proc36);
  DEFINE_PROC ("WS.WS.COPY", proc37);
  DEFINE_PROC ("WS.WS.COPY_OR_MOVE", proc38);
  DEFINE_PROC ("WS.WS.ISLOCKED", proc39);
  DEFINE_PROC ("WS.WS.CHECK_AUTH", proc40);
  DEFINE_PROC ("WS.WS.GET_IF_AUTH", proc41);
  DEFINE_PROC ("WS.WS.GET_DAV_AUTH", proc42);
  DEFINE_PROC ("WS.WS.PERM_COMP", proc43);
  DEFINE_PROC ("WS.WS.CHECKPERM", proc44);
  DEFINE_PROC ("WS.WS.ISPUBLIC", proc45);
  DEFINE_PROC ("WS.WS.DAV_VSP_DEF_REMOVE", proc46);
  DEFINE_PROC ("DAV_PERMS_SET_CHAR", proc47);
  DEFINE_PROC ("DAV_PERMS_FIX", proc48);
  DEFINE_PROC ("DAV_PERMS_INHERIT", proc49);
  ddl_std_proc (trig0, 0x0);
  ddl_std_proc (trig1, 0x0);
  ddl_std_proc (trig2, 0x0);
  ddl_std_proc (trig3, 0x0);
  DEFINE_PROC ("WS.WS.UPDCHILD", proc50);
  ddl_std_proc (trig4, 0x0);
  DEFINE_PROC ("WS.WS.DAV_VSP_INCLUDES_CHANGED", proc51);
  DEFINE_PROC ("WS.WS.EXPAND_INCLUDES", proc52);
  ddl_std_proc (trig5, 0x0);
  ddl_std_proc (trig6, 0x0);
  DEFINE_PROC ("WS.WS.XML_VIEW_HEADER", proc53);
  DEFINE_PROC ("WS.WS.XML_VIEW_EXTERNAL_META", proc54);
  DEFINE_PROC ("WS.WS.XML_VIEW_UPDATE", proc55);
  DEFINE_PROC ("WS.WS.FIXPATH", proc56);
  DEFINE_PROC ("WS.WS.ISPUBL", proc57);
  DEFINE_PROC ("WS.WS.BODY_ARR", proc58);
  DEFINE_PROC ("WS.WS.XML_AUTO_SCHED", proc59);
  DEFINE_PROC ("WS.WS.DAV_LOGIN", proc60);
  DEFINE_PROC ("WS.WS.HTTP_RESP", proc61);
  DEFINE_PROC ("WS.WS.COPY_TO_OTHER", proc62);
  DEFINE_PROC ("WS.WS.CHECK_READ_ACCESS", proc63);
  DEFINE_PROC ("WS.WS.IS_REDIRECT_REF", proc64);
  DEFINE_PROC ("WS.WS.DAV_DIR_LIST", proc65);
  DEFINE_PROC ("WS.WS.DAV_CHECK_ASMX", proc66);
  DEFINE_PROC ("WS.WS.DAV_REMOVE_ASMX", proc67);
  DEFINE_PROC ("WS.WS.XMLSQL_TO_STRSES", proc68);

  /* dav_api.sql */

  DEFINE_PROC ("DAV_PERROR", proc69);
  DEFINE_PROC ("DAV_ADD_USER_INT", proc70); 
  DEFINE_PUBLIC_PROC ("DAV_ADD_USER", proc71); 
  DEFINE_PUBLIC_PROC ("DAV_DELETE_USER", proc72); 
  DEFINE_PUBLIC_PROC ("DAV_REGEXP_PATTERN_FOR_PERM", proc73);
  DEFINE_PROC ("DAV_REGEXP_PATTERN_FOR_UNIX_PERM", proc74); 
  DEFINE_PUBLIC_PROC ("DAV_PERM_D2U", proc75); 
  DEFINE_PUBLIC_PROC ("DAV_PERM_U2D", proc76);
  DEFINE_PROC ("DAV_CHECK_AUTH", proc77); 
  DEFINE_PUBLIC_PROC ("DAV_HOME_DIR", proc78);
  DEFINE_PROC ("DAV_HOME_DIR_CREATE", proc79);
  DEFINE_PROC ("DAV_ADD_GROUP_INT", proc80); 
  DEFINE_PUBLIC_PROC ("DAV_ADD_GROUP", proc81); 
  DEFINE_PUBLIC_PROC ("DAV_DELETE_GROUP", proc82); 
  DEFINE_PUBLIC_PROC ("DAV_DIR_LIST", proc83); 
  DEFINE_PUBLIC_PROC ("DAV_DIR_FILTER", proc84);
  DEFINE_PROC ("DAV_GET_PARENT", proc85);
  DEFINE_PROC ("DAV_DIR_SINGLE_INT", proc86);
  DEFINE_PROC ("DAV_DIR_LIST_INT", proc87);
  DEFINE_PROC ("DAV_DIR_FILTER_INT", proc88); 
  DEFINE_PUBLIC_PROC ("DAV_SEARCH_PATH", proc89); 
  DEFINE_PUBLIC_PROC ("DAV_SEARCH_ID", proc90); 
  DEFINE_PUBLIC_PROC ("DAV_SEARCH_SOME_ID", proc91); 
  DEFINE_PUBLIC_PROC ("DAV_HIDE_ERROR", proc92); 
  DEFINE_PUBLIC_PROC ("DAV_HIDE_ERROR_OR_DET", proc93); 
  DEFINE_PUBLIC_PROC ("DAV_CONCAT_PATH", proc94);
  DEFINE_PROC ("DAV_SEARCH_SOME_ID_OR_DET", proc95);
  DEFINE_PROC ("DAV_SEARCH_ID_OR_DET", proc96);
  DEFINE_PROC ("DAV_OWNER_ID", proc97);
  DEFINE_PROC ("DAV_IS_LOCKED_INT", proc98); 
  DEFINE_PUBLIC_PROC ("DAV_IS_LOCKED", proc99); 
  DEFINE_PUBLIC_PROC ("DAV_LIST_LOCKS", proc100);
  DEFINE_PROC ("DAV_LIST_LOCKS_INT", proc101);
  DEFINE_PROC ("DAV_LOCK", proc102);
  DEFINE_PROC ("DAV_LOCK_INT", proc103);
  DEFINE_PROC ("DAV_UNLOCK", proc104);
  DEFINE_PROC ("DAV_UNLOCK_INT", proc105); 
  DEFINE_PUBLIC_PROC ("DAV_REQ_CHARS_TO_BITMASK", proc106); 
  DEFINE_PUBLIC_PROC ("DAV_AUTHENTICATE", proc107);
  DEFINE_PROC ("DAV_AUTHENTICATE_HTTP", proc108); 
  DEFINE_PUBLIC_PROC ("DAV_COL_CREATE", proc109);
  DEFINE_PROC ("DAV_COL_CREATE_INT", proc110);
  DEFINE_PROC ("DB.DBA.IS_REDIRECT_REF", proc111); 
  DEFINE_PUBLIC_PROC ("DAV_RES_UPLOAD", proc112); 
  DEFINE_PUBLIC_PROC ("DAV_RES_UPLOAD_STRSES", proc113);
  DEFINE_PROC ("DAV_RES_UPLOAD_STRSES_INT", proc114);
  DEFINE_PROC ("RDF_SINK_UPLOAD", proc115);
  DEFINE_PROC ("RDF_SINK_DELETE", proc116); 
  DEFINE_PUBLIC_PROC ("DAV_DELETE", proc117);
  DEFINE_PROC ("DAV_DELETE_INT", proc118);
  DEFINE_PROC ("DAV_TAG_LIST", proc119);
  DEFINE_PROC ("DAV_TAG_SET", proc120); 
  DEFINE_PUBLIC_PROC ("DAV_COPY", proc121);
  DEFINE_PROC ("DAV_COPY_INT", proc122);
  DEFINE_PROC ("DAV_COPY_SUBTREE", proc123); 
  DEFINE_PUBLIC_PROC ("DAV_MOVE", proc124);
  DEFINE_PROC ("DAV_MOVE_INT", proc125);
  DEFINE_PROC ("DAV_GET_OWNER", proc126);
  DEFINE_PROC ("DAV_PREPARE_PROP_WRITE", proc127); 
  DEFINE_PUBLIC_PROC ("DAV_PROP_SET", proc128);
  DEFINE_PROC ("DAV_PROP_SET_INT", proc129);
  DEFINE_PROC ("DAV_PROP_SET_RAW", proc130); 
  DEFINE_PUBLIC_PROC ("DAV_PROP_REMOVE", proc131);
  DEFINE_PROC ("DAV_PROP_REMOVE_INT", proc132);
  DEFINE_PROC ("DAV_PROP_REMOVE_RAW", proc133); 
  DEFINE_PUBLIC_PROC ("DAV_PROP_GET", proc134);
  DEFINE_PROC ("DAV_PROP_GET_INT", proc135); 
  DEFINE_PUBLIC_PROC ("DAV_PROP_LIST", proc136);
  DEFINE_PROC ("DAV_PROP_LIST_INT", proc137);
  DEFINE_PROC ("DAV_MAKE_DIR", proc138);
  DEFINE_PROC ("DAV_CHECK_PERM", proc139); 
  DEFINE_PUBLIC_PROC ("DAV_CHECK_USER", proc140); 
  DEFINE_PUBLIC_PROC ("DAV_RES_CONTENT", proc141); 
  DEFINE_PUBLIC_PROC ("DAV_RES_CONTENT_STRSES", proc142);
  DEFINE_PROC ("DAV_RES_CONTENT_INT", proc143);
  DEFINE_PROC ("DAV_COL_IS_ANCESTOR_OF", proc144);
  DEFINE_PROC ("DAV_COL_PATH_BOUNDARY", proc145);
  ddl_std_proc (trig7, 0x0);
  ddl_std_proc (trig8, 0x0);
  ddl_std_proc (trig9, 0x0);
  ddl_std_proc (trig10, 0x0);
  ddl_std_proc (trig11, 0x0);
  ddl_std_proc (trig12, 0x0);
  DEFINE_PROC ("WS.WS.WAC_INSERT", proc146);
  DEFINE_PROC ("WS.WS.WAC_DELETE", proc147);
  ddl_std_proc (trig13, 0x0);
  DEFINE_PROC ("WS.WS.ACL_CONTAINS_GRANTEE_AND_FLAG", proc148);
  ddl_std_proc (trig14, 0x0);
  ddl_std_proc (trig15, 0x0);
  ddl_std_proc (trig16, 0x0);
  ddl_std_proc (trig17, 0x0);
  ddl_std_proc (trig18, 0x0);
  DEFINE_PROC ("WS.WS.ACL_UPDATE", proc149);
  DEFINE_PROC ("WS.WS.ACL_MAKE_INHERITED", proc150);
  DEFINE_PROC ("WS.WS.ACL_DBG", proc151);
  DEFINE_PROC ("WS.WS.ACL_SERIALIZE_INT", proc152);
  DEFINE_PROC ("WS.WS.ACL_DESERIALIZE_INT", proc153);
  DEFINE_PROC ("WS.WS.ACL_GET_ACLLENGTH", proc154);
  DEFINE_PROC ("WS.WS.ACL_GET_ACESIZE", proc155);
  DEFINE_PROC ("WS.WS.ACL_CREATE", proc156);
  DEFINE_PROC ("WS.WS.ACL_IS_VALID", proc157);
  DEFINE_PROC ("WS.WS.ACL_ADD_ENTRY", proc158);
  DEFINE_PROC ("WS.WS.ACL_REMOVE_ENTRY", proc159);
  DEFINE_PROC ("WS.WS.ACL_IS_GRANTED", proc160);
  DEFINE_PROC ("WS.WS.ACL_SET_OWNER", proc161);
  DEFINE_PROC ("WS.WS.ACL_OWNER", proc162);
  DEFINE_PROC ("WS.WS.ACL_PARSE", proc163);
  DEFINE_PROC ("WS.WS.ACL_COMPOSE", proc164);
  DEFINE_PROC ("DAV_CAST_STRING_TO_INTEGER", proc165);
  DEFINE_PROC ("DAV_CAST_STRING_TO_DATETIME", proc166);
  DEFINE_PROC ("DAV_CAST_TEXT_TO_VARCHAR", proc167);
  DEFINE_PROC ("DAV_CAST_TEXT_TO_INTEGER", proc168);
  DEFINE_PROC ("DAV_CAST_TEXT_TO_DATETIME", proc169);
  DEFINE_PROC ("DAV_FC_CONST_AS_SQL", proc170);
  DEFINE_PROC ("DAV_FC_PRED_METAS", proc171);
  DEFINE_PROC ("DAV_FC_CMP_METAS", proc172);
  DEFINE_PROC ("DAV_FC_TABLE_METAS", proc173);
  DEFINE_PROC ("DAV_FC_PRINT_COMPARISON", proc174);
  DEFINE_PROC ("DAV_FC_PRINT_WHERE", proc175);
  DEFINE_PROC ("DAV_FC_PRINT_WHERE_INT", proc176);
  DEFINE_PROC ("DAV_REGISTER_RDF_SCHEMA", proc177); 
  DEFINE_PUBLIC_PROC ("DAV_RDF_SCHEMA_N3_LIST_PROPERTIES", proc178);
  DEFINE_PROC ("DAV_CROP_URI_TO_CATNAME", proc179); 
  DEFINE_PUBLIC_PROC ("DAV_GET_RDF_SCHEMA_N3", proc180);
  DEFINE_PROC ("DAV_DEPRECATE_RDF_SCHEMA", proc181);
  DEFINE_PROC ("DAV_REGISTER_MIME_TYPE", proc182);
  DEFINE_PROC ("DAV_REGISTER_MIME_RDF", proc183);
  DEFINE_PROC ("DAV_DEPRECATE_MIME_RDF", proc184); 
  DEFINE_PUBLIC_PROC ("DAV_RDF_PROP_SET", proc185); 
  DEFINE_PUBLIC_PROC ("DAV_RDF_PROP_GET", proc186);
  DEFINE_PROC ("DAV_RDF_PREPROCESS_RDFXML_SUB", proc187);
  DEFINE_PROC ("DAV_RDF_PREPROCESS_RDFXML", proc188);
  DEFINE_PROC ("DAV_RDF_PROP_SET_INT", proc189);
  DEFINE_PROC ("DAV_RDF_PROP_GET_INT", proc190);
  DEFINE_PROC ("DAV_RDF_MERGE", proc191);
  DEFINE_PROC ("DAV_RDF_SUBTRACT", proc192);
  ddl_std_proc (trig19, 0x0);
  ddl_std_proc (trig20, 0x0);
  ddl_std_proc (trig21, 0x0);
  DEFINE_PROC ("DAV_EXTRACT_AND_SAVE_RDF", proc193);
  DEFINE_PROC ("DAV_GET_RES_TYPE_URI_BY_MIME_TYPE", proc194);
  DEFINE_PROC ("DAV_EXTRACT_AND_SAVE_RDF_INT", proc195);
  DEFINE_PROC ("DAV_HOME_DIR_UPDATE", proc196);

  /* dav_meta.sql */

  DEFINE_PROC ("DAV_GUESS_MIME_TYPE_BY_NAME", proc197);
  DEFINE_PROC ("DAV_GUESS_MIME_TYPE", proc198);
  DEFINE_PROC ("file_space_fmt", proc199);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/x-openlink-license", proc200);
  DEFINE_PROC ("DAV_EXTRACT_RDF_opendocument", proc201);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.text", proc202);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.database", proc203);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.graphics", proc204);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.presentation", proc205);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.spreadsheet", proc206);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.chart", proc207);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.formula", proc208);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/vnd.oasis.opendocument.image", proc209);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/x-openlink-image", proc210);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/x-openlink-photo", proc211);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/audio", proc212);
  DEFINE_PROC ("DAV_EXTRACT_RDF_audio/mpeg", proc213);
  DEFINE_PROC ("DAV_EXTRACT_RDF_audio/x-flac", proc214);
  DEFINE_PROC ("DAV_EXTRACT_RDF_audio/x-mp3", proc215);
  DEFINE_PROC ("DAV_EXTRACT_RDF_audio/x-m4a", proc216);
  DEFINE_PROC ("DAV_EXTRACT_RDF_audio/x-m4p", proc217);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/ogg", proc218);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msoffice+xml", proc219);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msexcel", proc220);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msaccess", proc221);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msproject", proc222);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/mspowerpoint", proc223);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msword", proc224);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/pdf", proc225);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/xbrl+xml", proc226);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/doap+rdf", proc227);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/xddl+xml", proc228);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/archive", proc229);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/tar", proc230);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/taz", proc231);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/gz", proc232);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msi", proc233);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/dmg", proc234);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/arj", proc235);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/bz", proc236);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/bz2", proc237);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/tgz", proc238);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/rar", proc239);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/zip", proc240);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/cab", proc241);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/lzh", proc242);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/ace", proc243);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/iso", proc244);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msword+xml", proc245);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msexcel+xml", proc246);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msproject+xml", proc247);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/msvisio+xml", proc248);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/rss+xml", proc249);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/atom+xml", proc250);
  DEFINE_PROC ("DAV_EXTRACT_RDF_text/eml", proc251);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/xbel+xml", proc252);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/rdf+xml", proc253);
  DEFINE_PROC ("DAV_EXTRACT_RDF_text/rdf+ttl", proc254);
  DEFINE_PROC ("DAV_EXTRACT_RDF_text/rdf+n3", proc255);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/foaf+xml", proc256);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/mods+xml", proc257);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/opml+xml", proc258);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/ocs+xml", proc259);
  DEFINE_PROC ("DAV_EXTRACT_RDF_text/html", proc260);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/x-openlinksw-vsp", proc261);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/x-openlinksw-vspx+xml", proc262);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/bpel+xml", proc263);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/annotea+xml", proc264);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/google-kinds+xml", proc265);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/wsdl+xml", proc266);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/google-base+xml", proc267);
  DEFINE_PROC ("DAV_EXTRACT_RDF_application/x-openlinksw-vad", proc268);
  DEFINE_PROC ("DAV_EXTRACT_RDF_text/wiki", proc269);
  DEFINE_PROC ("IMC_TO_XML", proc270);
  DEFINE_PROC ("DAV_EXTRACT_RDF_text/directory", proc271);
  DEFINE_PROC ("DAV_EXTRACT_RDF_BY_METAS", proc272);
  DEFINE_PROC ("DB.DBA.UNIX_DATETIME_PARSER", proc273);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("do this always", other2);
  DEFINE_PROC ("DB.DBA.UNIX_DATE_PARSER", proc274);
  ddl_ensure_table ("do this always", other3);
  ddl_ensure_table ("do this always", other4);
  DEFINE_PROC ("DB.DBA.BPEL_SPLIT_LIST", proc275);
  ddl_ensure_table ("do this always", other5);
  ddl_ensure_table ("do this always", other6);
  DEFINE_PROC ("DAV_EXTRACT_SPOTLIGHT", proc276);
  DEFINE_PROC ("DAV_CONVERT_SPOTLIGHT_TO_VIRTUOSO", proc277);
  DEFINE_PROC ("DAV_SPOTLIGHT_ADD", proc278); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_UNIX_DATE_TO_ISO", proc279);
  ddl_ensure_table ("do this always", other7);
  ddl_ensure_table ("do this always", other8);
  DEFINE_PROC ("DAV_EXTRACT_META_AS_RDF_XML", proc280);

  /* dav_acct.sql */

  DEFINE_PROC ("DAV_SPACE_QUOTA_PARENT", proc281);
  DEFINE_PROC ("DAV_ADD_SPACE_QUOTA", proc282);
  DEFINE_PROC ("DAV_DEL_SPACE_QUOTA", proc283);
  DEFINE_PROC ("DAV_SPACE_QUOTA_YELLOW_TRACK", proc284);
  DEFINE_PROC ("DAV_SPACE_QUOTA_SIGNAL", proc285);
  DEFINE_PROC ("DAV_OWNER_DISABLED_SIGNAL", proc286);
  DEFINE_PROC ("DAV_HOME_DISABLED_SIGNAL", proc287);
  DEFINE_PROC ("DAV_SPACE_QUOTA_RES_INSERT", proc288);
  DEFINE_PROC ("DAV_SPACE_QUOTA_RES_DELETE", proc289);
  DEFINE_PROC ("DAV_SPACE_QUOTA_RES_UPDATE", proc290);

  /* dav_rdf_quad.sql */

  DEFINE_PROC ("DB.DBA.RDF_DELETE_ENTIRE_GRAPH", proc291);
  DEFINE_PROC ("DB.DBA.DAV_FULL_PATH_TO_IRI", proc292);
  DEFINE_PROC ("DB.DBA.DAV_AUTO_REPLICATE_TO_RDF_QUAD", proc293);
  DEFINE_PROC ("DB.DBA.DAV_REPLICATE_ALL_TO_RDF_QUAD", proc294);
  DEFINE_PROC ("DB.DBA.RDF_CBD_DELETE", proc295);
  DEFINE_PROC ("DB.DBA.DAV_RDF_URI_RESOLVE", proc296);
  DEFINE_PROC ("DB.DBA.DAV_RDF_REPLICATE_INT", proc297);
  DEFINE_PROC ("DB.DBA.DAV_RDF_CBD_DELETE_PROP", proc298);
  DEFINE_PROC ("DB.DBA.DAV_MAKE_USER_IRI", proc299);
  DEFINE_PROC ("DB.DBA.DAV_REPLICATE_RES_TO_RDF_QUAD", proc300);
  DEFINE_PROC ("DB.DBA.DAV_REPLICATE_COL_TO_RDF_QUAD", proc301);
  ddl_std_proc (trig22, 0x0);
  ddl_std_proc (trig23, 0x0);
  ddl_std_proc (trig24, 0x0);
  ddl_std_proc (trig25, 0x0);
  ddl_std_proc (trig26, 0x0);
  ddl_std_proc (trig27, 0x0);
  ddl_std_proc (trig28, 0x0);
  ddl_std_proc (trig29, 0x0);
  ddl_std_proc (trig30, 0x0);
  ddl_std_proc (trig31, 0x0);
  DEFINE_PROC ("DB.DBA.DAV_RDF_PROPAGATE_COL_PATH_CHANGE", proc302);
  ddl_std_proc (trig32, 0x0);
  ddl_std_proc (trig33, 0x0);

  /* vfs.sql */
  bootstrap_cli->cli_qualifier = box_string ("WS");

  DEFINE_PROC ("WS.WS.COPY_PAGE", proc303);
  DEFINE_PROC ("WS.WS.VFS_HTTP_RESP_CODE", proc304);
  DEFINE_PROC ("WS.WS.VFS_ENSURE_NEW_SITE", proc305);
  DEFINE_PROC ("WS.WS.COPY_PAGE_1", proc306);
  DEFINE_PROC ("WS.WS.DELETE_LOCAL_COPY", proc307);
  DEFINE_PROC ("WS.WS.SERV_QUEUE_TOP", proc308);
  DEFINE_PROC ("WS.WS.SERV_QUEUE", proc309);
  DEFINE_PROC ("ERR_MAIL_SEND", proc310);
  DEFINE_PROC ("WS.WS.LOCAL_STORE", proc311);
  DEFINE_PROC ("WS.WS.GET_URLS", proc312);
  DEFINE_PROC ("WS.WS.MAKE_URL", proc313);
  DEFINE_PROC ("WS.WS.SPLIT_URL", proc314);
  DEFINE_PROC ("WS.WS.EXPAND_URL_OLD", proc315);
  DEFINE_PROC ("WS.WS.MKPATH", proc316);
  DEFINE_PROC ("WS.WS.FOLLOW", proc317);
  DEFINE_PROC ("WS.WS.REPLACE_HREF", proc318);
  DEFINE_PROC ("WS.WS.FIND_URI", proc319);
  DEFINE_PROC ("WS.WS.LFS_EXP", proc320);
  DEFINE_PROC ("WS.WS.FIND_KEYWORD", proc321);
  DEFINE_PROC ("WS.WS.GET_HREF_IN_ARRAY", proc322);
  DEFINE_PROC ("WS.WS.DAV_EXP", proc323);
  DEFINE_PROC ("WS.WS.DAV_HEAD", proc324);
  DEFINE_PROC ("WS.WS.DAV_MKCOL", proc325);
  DEFINE_PROC ("WS.WS.DAV_PUT", proc326);
  DEFINE_PROC ("WS.WS.DAV_PROP", proc327);
  DEFINE_PROC ("WS.WS.GET_HREF_FROM_XML", proc328);
  DEFINE_PROC ("WS.WS.ISEMPTY", proc329);
  DEFINE_PROC ("WS.WS.URL_BY_DATE", proc330);
  DEFINE_PROC ("WS.WS.VFS_MAKE_ENTRY", proc331);
  DEFINE_PROC ("WS.WS.VFS_GO", proc332);
  DEFINE_PROC ("WS.WS.VFS_URI_COMPOSE", proc333);
  DEFINE_PROC ("WS.WS.VFS_EXTRACT_RDF", proc334);
  DEFINE_PROC ("WS.WS.SITEMAP_ENSURE_NEW_SITE", proc335);
  DEFINE_PROC ("WS.WS.SITEMAP_URLS_REGISTER", proc336);
  DEFINE_PROC ("WS.WS.SITEMAP_XML_PARSE", proc337);
  DEFINE_PROC ("WS.WS.SITEMAP_RDF_STORE", proc338);

  dk_free_box (bootstrap_cli->cli_qualifier);
  bootstrap_cli->cli_qualifier =  saved_qualifier;

  /* davxml2rdfxml.xsl */

  XSLT_DEFINE ("http://local.virt/davxml2rdfxml", xsl7);

  /* davxml2n3xml.xsl */

  XSLT_DEFINE ("http://local.virt/davxml2n3xml", xsl8);

  /* rdfxml2n3xml.xsl */

  XSLT_DEFINE ("http://local.virt/rdfxml2n3xml", xsl9);

  /* n3xml2uriqahtml.xsl */

  XSLT_DEFINE ("http://local.virt/n3xml2uriqahtml", xsl10);

  /* uriqa.sql */

  ddl_ensure_table ("WS.WS.URIQA_HANDLER", tbl0);
  DEFINE_PROC ("WS.WS.URIQA_CFG_ITEM_VALUE", proc339);
  DEFINE_PROC ("WS.WS.URIQA_LOAD_FROM_INI", proc340);
  ddl_ensure_table ("do this always", other9);
  DEFINE_PROC ("WS.WS.URIQA_FULL_URI", proc341);
  DEFINE_PROC ("WS.WS.URIQA_APPLY_TRIGGERS", proc342);
  DEFINE_PROC ("WS.WS.URIQA_N3_DIR_LIST", proc343);
  DEFINE_PROC ("DB.DBA.DAV_EXTRACT_DYN_RDF_application/xbel+xml", proc344);
  DEFINE_PROC ("WS.WS.URIQA_HANDLER_LOCALDAV", proc345);
  DEFINE_PROC ("WS.WS.URIQA_HANDLER_NATIVE_HTTP", proc346);
  DEFINE_PROC ("WS.WS.URIQA_STATUS", proc347);
  DEFINE_PROC ("WS.WS.MPUT", proc348);
  DEFINE_PROC ("WS.WS.MGET", proc349);
  DEFINE_PROC ("WS.WS.MDELETE", proc350);
  DEFINE_PROC ("WS.WS./!URIQA/", proc351);
  DEFINE_PROC ("WS.WS.URIQA_VHOST_RESET", proc352);

  /* DET_CatFilter.sql */

  DEFINE_PROC ("CatFilter_DAV_AUTHENTICATE", proc353);
  DEFINE_PROC ("CatFilter_GET_CONDITION", proc354);
  DEFINE_PROC ("CatFilter_ENCODE_CATVALUE", proc355);
  DEFINE_PROC ("CatFilter_DECODE_CATVALUE", proc356);
  DEFINE_PROC ("CatFilter_PATH_PARTS_TO_FILTER", proc357);
  DEFINE_PROC ("CatFilter_ACC_FILTER_DATA", proc358);
  DEFINE_PROC ("CatFilter_DAV_SEARCH_ID_IMPL", proc359);
  DEFINE_PROC ("CatFilter_DAV_AUTHENTICATE_HTTP", proc360);
  DEFINE_PROC ("CatFilter_DAV_GET_PARENT", proc361);
  DEFINE_PROC ("CatFilter_DAV_COL_CREATE", proc362);
  DEFINE_PROC ("CatFilter_DAV_COL_MOUNT", proc363);
  DEFINE_PROC ("CatFilter_DAV_COL_MOUNT_HERE", proc364);
  DEFINE_PROC ("CatFilter_DAV_DELETE", proc365);
  DEFINE_PROC ("CatFilter_FILTER_TO_CONDITION", proc366);
  DEFINE_PROC ("CatFilter_DAV_RES_UPLOAD", proc367);
  DEFINE_PROC ("CatFilter_DAV_PROP_REMOVE", proc368);
  DEFINE_PROC ("CatFilter_DAV_PROP_SET", proc369);
  DEFINE_PROC ("CatFilter_DAV_PROP_GET", proc370);
  DEFINE_PROC ("CatFilter_DAV_PROP_LIST", proc371);
  DEFINE_PROC ("CatFilter_DAV_DIR_SINGLE", proc372);
  DEFINE_PROC ("CatFilter_LIST_SCHEMAS", proc373);
  DEFINE_PROC ("CatFilter_LIST_SCHEMA_PROPS", proc374);
  DEFINE_PROC ("CatFilter_GET_RDF_INVERSE_HITS_DISTVALS", proc375);
  DEFINE_PROC ("CatFilter_GET_RDF_INVERSE_HITS_RES_IDS", proc376);
  DEFINE_PROC ("CatFilter_LIST_PROP_DISTVALS_AUX", proc377);
  DEFINE_PROC ("CatFilter_LIST_PROP_DISTVALS", proc378);
  DEFINE_PROC ("CatFilter_DAV_DIR_LIST", proc379);
  DEFINE_PROC ("CatFilter_DAV_DIR_FILTER", proc380);
  DEFINE_PROC ("CatFilter_DAV_SEARCH_ID", proc381);
  DEFINE_PROC ("CatFilter_DAV_SEARCH_PATH", proc382);
  DEFINE_PROC ("CatFilter_DAV_RES_UPLOAD_COPY", proc383);
  DEFINE_PROC ("CatFilter_DAV_RES_UPLOAD_MOVE", proc384);
  DEFINE_PROC ("CatFilter_DAV_RES_CONTENT", proc385);
  DEFINE_PROC ("CatFilter_DAV_SYMLINK", proc386);
  DEFINE_PROC ("CatFilter_DAV_LOCK", proc387);
  DEFINE_PROC ("CatFilter_DAV_UNLOCK", proc388);
  DEFINE_PROC ("CatFilter_DAV_IS_LOCKED", proc389);
  DEFINE_PROC ("CatFilter_DAV_LIST_LOCKS", proc390);
  DEFINE_PROC ("CatFilter_CONFIGURE", proc391);
  DEFINE_PROC ("CatFilter_FEED_DAV_RDF_INVERSE", proc392);
  ddl_std_proc (trig34, 0x0);
  ddl_std_proc (trig35, 0x0);
  ddl_std_proc (trig36, 0x0);
  DEFINE_PROC ("CatFilter_INIT_SYS_DAV_RDF_INVERSE", proc393);

  /* DET_HostFs.sql */

  ddl_ensure_table ("WS.WS.HOSTFS_COL", tbl1);
  ddl_ensure_column ("WS.WS.HOSTFS_COL", "COL_NAME", alter0, 0);
  ddl_ensure_table ("WS.WS.HOSTFS_RES", tbl2);
  ddl_ensure_table ("WS.WS.HOSTFS_RES_CACHE", tbl3);
  ddl_ensure_column ("WS.WS.HOSTFS_RES_CACHE", "RESC_TOPCOL_ID", alter1, 0);
  ddl_ensure_table ("WS.WS.HOSTFS_RES_META", tbl4);
  ddl_ensure_column ("WS.WS.HOSTFS_RES_META", "RESM_TOPCOL_ID", alter2, 0);
  ddl_ensure_table ("WS.WS.HOSTFS_RDF_INVERSE", tbl5);
  DEFINE_PROC ("WS.WS.HOSTFS_FEED_RDF_INVERSE", proc394);
  ddl_std_proc (trig37, 0x0);
  ddl_std_proc (trig38, 0x0);
  ddl_std_proc (trig39, 0x0);
  ddl_ensure_table ("do this always", other10);
  ddl_ensure_table ("do this always", other11);
  DEFINE_PROC ("WS.WS.HOSTFS_RES_TOPCOL_ID", proc395);
  DEFINE_PROC ("WS.WS.HOSTFS_EXTRACT_AND_SAVE_RDF", proc396);
  DEFINE_PROC ("WS.WS.HOSTFS_TEST_RDF", proc397);
  DEFINE_PROC ("WS.WS.HOSTFS_RES_CACHE_RESC_DATA_INDEX_HOOK", proc398);
  DEFINE_PROC ("WS.WS.HOSTFS_RES_CACHE_RESC_DATA_UNINDEX_HOOK", proc399);
  ddl_ensure_table ("do this always", other12);
  ddl_ensure_table ("do this always", other13);
  DEFINE_PROC ("WS.WS.HOSTFS_FIND_COL", proc400);
  DEFINE_PROC ("WS.WS.HOSTFS_COL_DISAPPEARS", proc401);
  DEFINE_PROC ("WS.WS.HOSTFS_HANDLE_RES_SCAN", proc402);
  DEFINE_PROC ("WS.WS.HOSTFS_RES_DISAPPEARS", proc403);
  DEFINE_PROC ("WS.WS.HOSTFS_TOUCH_RES", proc404);
  DEFINE_PROC ("WS.WS.HOSTFS_GLOBAL_RESET", proc405);
  DEFINE_PROC ("WS.WS.HOSTFS_PATH_STAT", proc406);
  DEFINE_PROC ("WS.WS.HOSTFS_READ_TYPEINFO", proc407);
  DEFINE_PROC ("HostFs_DAV_AUTHENTICATE", proc408);
  DEFINE_PROC ("HostFs_DAV_AUTHENTICATE_HTTP", proc409);
  DEFINE_PROC ("HostFs_DAV_GET_PARENT", proc410);
  DEFINE_PROC ("HostFs_DAV_COL_CREATE", proc411);
  DEFINE_PROC ("HostFs_DAV_COL_MOUNT", proc412);
  DEFINE_PROC ("HostFs_DAV_COL_MOUNT_HERE", proc413);
  DEFINE_PROC ("HostFs_DAV_DELETE", proc414);
  ddl_ensure_table ("DB.DBA.HostFs_DAV_RES_UPLOAD", tbl6);
  DEFINE_PROC ("HostFs_DAV_RES_UPLOAD", proc415);
  DEFINE_PROC ("HostFs_DAV_PROP_REMOVE", proc416);
  DEFINE_PROC ("HostFs_DAV_PROP_SET", proc417);
  DEFINE_PROC ("HostFs_DAV_PROP_GET", proc418);
  DEFINE_PROC ("HostFs_DAV_PROP_LIST", proc419);
  DEFINE_PROC ("HostFs_ID_TO_OSPATH", proc420);
  DEFINE_PROC ("HostFs_DAV_DIR_SINGLE", proc421);
  DEFINE_PROC ("HostFs_DAV_DIR_LIST", proc422);
  DEFINE_PROC ("HostFs_DAV_DIR_FILTER", proc423);
  DEFINE_PROC ("HostFs_DAV_SEARCH_ID", proc424);
  DEFINE_PROC ("HostFs_DAV_SEARCH_PATH", proc425);
  DEFINE_PROC ("HostFs_DAV_RES_UPLOAD_COPY", proc426);
  DEFINE_PROC ("HostFs_DAV_RES_UPLOAD_MOVE", proc427);
  DEFINE_PROC ("HostFs_DAV_RES_CONTENT", proc428);
  DEFINE_PROC ("HostFs_DAV_SYMLINK", proc429);
  DEFINE_PROC ("HostFs_DAV_LOCK", proc430);
  DEFINE_PROC ("HostFs_DAV_UNLOCK", proc431);
  DEFINE_PROC ("HostFs_DAV_IS_LOCKED", proc432);
  DEFINE_PROC ("HostFs_DAV_LIST_LOCKS", proc433);
  DEFINE_PROC ("HostFs_CF_LIST_PROP_DISTVALS", proc434);
  DEFINE_PROC ("HostFs_CF_GET_RDF_HITS", proc435);
  DEFINE_PROC ("HostFs_RF_ID2SUFFIX", proc436);
  DEFINE_PROC ("HostFile_RF_SUFFIX2ID", proc437);
  DEFINE_PROC ("HostDir_RF_SUFFIX2ID", proc438);

  /* DET_ResFilter.sql */

  DEFINE_PROC ("ResFilter_DAV_AUTHENTICATE", proc439);
  DEFINE_PROC ("ResFilter_NORM", proc440);
  DEFINE_PROC ("ResFilter_ENCODE_FILTER", proc441);
  DEFINE_PROC ("ResFilter_DECODE_FILTER", proc442);
  DEFINE_PROC ("ResFilter_GET_CONDITION", proc443);
  DEFINE_PROC ("ResFilter_FIT_INTO_CONDITION", proc444);
  DEFINE_PROC ("ResFilter_MAKE_DEL_ACTION_FROM_CONDITION", proc445);
  DEFINE_PROC ("ResFilter_LEAVE_CONDITION", proc446);
  DEFINE_PROC ("ResFilter_FNMERGE", proc447);
  DEFINE_PROC ("ResFilter_FNSPLIT", proc448);
  DEFINE_PROC ("ResFilter_DAV_SEARCH_ID_IMPL", proc449);
  DEFINE_PROC ("ResFilter_DAV_AUTHENTICATE_HTTP", proc450);
  DEFINE_PROC ("ResFilter_DAV_GET_PARENT", proc451);
  DEFINE_PROC ("ResFilter_DAV_COL_CREATE", proc452);
  DEFINE_PROC ("ResFilter_DAV_COL_MOUNT", proc453);
  DEFINE_PROC ("ResFilter_DAV_COL_MOUNT_HERE", proc454);
  DEFINE_PROC ("ResFilter_DAV_DELETE", proc455);
  DEFINE_PROC ("ResFilter_DAV_RES_UPLOAD", proc456);
  DEFINE_PROC ("ResFilter_DAV_PROP_REMOVE", proc457);
  DEFINE_PROC ("ResFilter_DAV_PROP_SET", proc458);
  DEFINE_PROC ("ResFilter_DAV_PROP_GET", proc459);
  DEFINE_PROC ("ResFilter_DAV_PROP_LIST", proc460);
  DEFINE_PROC ("ResFilter_DAV_DIR_SINGLE", proc461);
  DEFINE_PROC ("ResFilter_DAV_DIR_LIST", proc462);
  DEFINE_PROC ("ResFilter_DAV_DIR_FILTER", proc463);
  DEFINE_PROC ("ResFilter_DAV_SEARCH_ID", proc464);
  DEFINE_PROC ("ResFilter_DAV_SEARCH_PATH", proc465);
  DEFINE_PROC ("ResFilter_DAV_RES_UPLOAD_COPY", proc466);
  DEFINE_PROC ("ResFilter_DAV_RES_UPLOAD_MOVE", proc467);
  DEFINE_PROC ("ResFilter_DAV_RES_CONTENT", proc468);
  DEFINE_PROC ("ResFilter_DAV_SYMLINK", proc469);
  DEFINE_PROC ("ResFilter_DAV_LOCK", proc470);
  DEFINE_PROC ("ResFilter_DAV_UNLOCK", proc471);
  DEFINE_PROC ("ResFilter_DAV_IS_LOCKED", proc472);
  DEFINE_PROC ("ResFilter_DAV_LIST_LOCKS", proc473);
  DEFINE_PROC ("ResFilter_CONFIGURE", proc474);

  /* DET_PropFilter.sql */

  DEFINE_PROC ("PropFilter_DAV_AUTHENTICATE", proc475);
  DEFINE_PROC ("PropFilter_NORM", proc476);
  DEFINE_PROC ("PropFilter_GET_CONDITION", proc477);
  DEFINE_PROC ("PropFilter_FIT_INTO_CONDITION", proc478);
  DEFINE_PROC ("PropFilter_LEAVE_CONDITION", proc479);
  DEFINE_PROC ("PropFilter_FNMERGE", proc480);
  DEFINE_PROC ("PropFilter_FNSPLIT", proc481);
  DEFINE_PROC ("PropFilter_DAV_SEARCH_ID_IMPL", proc482);
  DEFINE_PROC ("PropFilter_DAV_AUTHENTICATE_HTTP", proc483);
  DEFINE_PROC ("PropFilter_DAV_GET_PARENT", proc484);
  DEFINE_PROC ("PropFilter_DAV_COL_CREATE", proc485);
  DEFINE_PROC ("PropFilter_DAV_COL_MOUNT", proc486);
  DEFINE_PROC ("PropFilter_DAV_COL_MOUNT_HERE", proc487);
  DEFINE_PROC ("PropFilter_DAV_DELETE", proc488);
  DEFINE_PROC ("PropFilter_DAV_RES_UPLOAD", proc489);
  DEFINE_PROC ("PropFilter_DAV_PROP_REMOVE", proc490);
  DEFINE_PROC ("PropFilter_DAV_PROP_SET", proc491);
  DEFINE_PROC ("PropFilter_DAV_PROP_GET", proc492);
  DEFINE_PROC ("PropFilter_DAV_PROP_LIST", proc493);
  DEFINE_PROC ("PropFilter_DAV_DIR_SINGLE", proc494);
  DEFINE_PROC ("PropFilter_DAV_DIR_LIST", proc495);
  DEFINE_PROC ("PropFilter_DAV_DIR_FILTER", proc496);
  DEFINE_PROC ("PropFilter_DAV_SEARCH_ID", proc497);
  DEFINE_PROC ("PropFilter_DAV_SEARCH_PATH", proc498);
  DEFINE_PROC ("PropFilter_DAV_RES_UPLOAD_COPY", proc499);
  DEFINE_PROC ("PropFilter_DAV_RES_UPLOAD_MOVE", proc500);
  DEFINE_PROC ("PropFilter_DAV_RES_CONTENT", proc501);
  DEFINE_PROC ("PropFilter_DAV_SYMLINK", proc502);
  DEFINE_PROC ("PropFilter_DAV_LOCK", proc503);
  DEFINE_PROC ("PropFilter_DAV_UNLOCK", proc504);
  DEFINE_PROC ("PropFilter_DAV_IS_LOCKED", proc505);
  DEFINE_PROC ("PropFilter_DAV_LIST_LOCKS", proc506);

  /* DET_RDFData.sql */

  DEFINE_PROC ("DB.DBA.RDFData_log_message", proc507);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_AUTHENTICATE", proc508);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_AUTHENTICATE_HTTP", proc509);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_GET_PARENT", proc510);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_COL_CREATE", proc511);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_COL_MOUNT", proc512);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_COL_MOUNT_HERE", proc513);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_DELETE", proc514);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_RES_UPLOAD", proc515);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_PROP_REMOVE", proc516);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_PROP_SET", proc517);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_PROP_GET", proc518);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_PROP_LIST", proc519);
  DEFINE_PROC ("DB.DBA.RDFData_ACCESS_PARAMS", proc520);
  DEFINE_PROC ("DB.DBA.RDFData_cast_dt_silent", proc521);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_DIR_SINGLE", proc522);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_DIR_LIST", proc523);
  DEFINE_PROC ("RDFData_std_pref", proc524);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_DIR_FILTER", proc525);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_SEARCH_ID", proc526);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_SEARCH_PATH", proc527);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_RES_UPLOAD_COPY", proc528);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_RES_UPLOAD_MOVE", proc529);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_RES_CONTENT", proc530);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_SYMLINK", proc531);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_DEREFERENCE_LIST", proc532);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_RESOLVE_PATH", proc533);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_LOCK", proc534);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_UNLOCK", proc535);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_IS_LOCKED", proc536);
  DEFINE_PROC ("DB.DBA.RDFData_DAV_LIST_LOCKS", proc537);
  DEFINE_PROC ("DB.DBA.RDFData_MAKE_DET_COL", proc538);

  /* DET_S3.sql */

  DEFINE_PROC ("DB.DBA.S3__encode", proc539);
  DEFINE_PROC ("DB.DBA.S3__params", proc540);
  DEFINE_PROC ("DB.DBA.S3__parts2path", proc541);
  DEFINE_PROC ("DB.DBA.S3__item2entry", proc542);
  DEFINE_PROC ("DB.DBA.S3__headers2item", proc543);
  DEFINE_PROC ("DB.DBA.S3__makeHostUrl", proc544);
  DEFINE_PROC ("DB.DBA.S3__getBucketFromUrl", proc545);
  DEFINE_PROC ("DB.DBA.S3__getNameFromUrl", proc546);
  DEFINE_PROC ("DB.DBA.S3__getPathFromUrl", proc547);
  DEFINE_PROC ("DB.DBA.S3__makeAWSHeader", proc548);
  DEFINE_PROC ("DB.DBA.S3__getBuckets", proc549);
  DEFINE_PROC ("DB.DBA.S3__getBucket", proc550);
  DEFINE_PROC ("DB.DBA.S3__putObject", proc551);
  DEFINE_PROC ("DB.DBA.S3__headObject", proc552);
  DEFINE_PROC ("DB.DBA.S3__getObject", proc553);
  DEFINE_PROC ("DB.DBA.S3__deleteObject", proc554);
  DEFINE_PROC ("DB.DBA.S3_DAV_AUTHENTICATE", proc555);
  DEFINE_PROC ("DB.DBA.S3_DAV_AUTHENTICATE_HTTP", proc556);
  DEFINE_PROC ("DB.DBA.S3_DAV_GET_PARENT", proc557);
  DEFINE_PROC ("DB.DBA.S3_DAV_COL_CREATE", proc558);
  DEFINE_PROC ("DB.DBA.S3_DAV_DELETE", proc559);
  DEFINE_PROC ("DB.DBA.S3_DAV_RES_UPLOAD", proc560);
  DEFINE_PROC ("DB.DBA.S3_DAV_PROP_REMOVE", proc561);
  DEFINE_PROC ("DB.DBA.S3_DAV_PROP_SET", proc562);
  DEFINE_PROC ("DB.DBA.S3_DAV_PROP_GET", proc563);
  DEFINE_PROC ("DB.DBA.S3_DAV_PROP_LIST", proc564);
  DEFINE_PROC ("DB.DBA.S3_DAV_DIR_SINGLE", proc565);
  DEFINE_PROC ("DB.DBA.S3_DAV_DIR_LIST", proc566);
  DEFINE_PROC ("DB.DBA.S3_DAV_DIR_FILTER", proc567);
  DEFINE_PROC ("DB.DBA.S3_DAV_SEARCH_ID", proc568);
  DEFINE_PROC ("DB.DBA.S3_DAV_SEARCH_PATH", proc569);
  DEFINE_PROC ("DB.DBA.S3_DAV_RES_UPLOAD", proc570);
  DEFINE_PROC ("DB.DBA.S3_DAV_RES_UPLOAD_COPY", proc571);
  DEFINE_PROC ("DB.DBA.S3_DAV_RES_UPLOAD_MOVE", proc572);
  DEFINE_PROC ("DB.DBA.S3_DAV_RES_CONTENT", proc573);
  DEFINE_PROC ("DB.DBA.S3_DAV_SYMLINK", proc574);
  DEFINE_PROC ("DB.DBA.S3_DAV_DEREFERENCE_LIST", proc575);
  DEFINE_PROC ("DB.DBA.S3_DAV_RESOLVE_PATH", proc576);
  DEFINE_PROC ("DB.DBA.S3_DAV_LOCK", proc577);
  DEFINE_PROC ("DB.DBA.S3_DAV_UNLOCK", proc578);
  DEFINE_PROC ("DB.DBA.S3_DAV_IS_LOCKED", proc579);
  DEFINE_PROC ("DB.DBA.S3_DAV_LIST_LOCKS", proc580);

  /* DET_Versioning.sql */

  ddl_ensure_table ("WS.WS.SYS_DAV_RES_VERSION", tbl7);
  ddl_ensure_table ("WS.WS.SYS_DAV_RES_DIFF", tbl8);
  ddl_ensure_table ("WS.WS.SYS_DAV_RES_MERGE", tbl9);
  ddl_ensure_table ("WS.WS.SYS_DAV_ACTIVITY", tbl10);
  ddl_ensure_table ("WS.WS.SYS_DAV_WORKSPACE", tbl11);
  ddl_ensure_table ("WS.WS.SYS_DAV_CONFOBJ", tbl12);
  ddl_ensure_table ("WS.WS.SYS_DAV_BASELINE", tbl13);
  ddl_ensure_table ("WS.WS.SYS_DAV_BASELINE_RES", tbl14);
  ddl_std_proc (trig40, 0x0);
  ddl_std_proc (trig41, 0x0);
  ddl_std_proc (trig42, 0x0);
  DEFINE_PROC ("Versioning_ADD_NEW_DIFF", proc581);
  ddl_std_proc (trig43, 0x0);
  ddl_std_proc (trig44, 0x0);
  DEFINE_PROC ("DAV_GET_VERSION_CONTENT", proc582);
  DEFINE_PROC ("DAV_RES_RESTORE", proc583);
  DEFINE_PROC ("Versioning_DAV_AUTHENTICATE", proc584);
  DEFINE_PROC ("Versioning_DAV_AUTHENTICATE_HTTP", proc585);
  DEFINE_PROC ("Versioning_DAV_GET_PARENT", proc586);
  DEFINE_PROC ("Versioning_DAV_COL_CREATE", proc587);
  DEFINE_PROC ("Versioning_DAV_COL_MOUNT", proc588);
  DEFINE_PROC ("Versioning_DAV_COL_MOUNT_HERE", proc589);
  DEFINE_PROC ("Versioning_DAV_DELETE", proc590);
  DEFINE_PROC ("Versioning_DAV_RES_UPLOAD", proc591);
  DEFINE_PROC ("Versioning_DAV_PROP_REMOVE", proc592);
  DEFINE_PROC ("Versioning_DAV_PROP_SET", proc593);
  DEFINE_PROC ("Versioning_DAV_PROP_GET", proc594);
  DEFINE_PROC ("Versioning_root_version", proc595);
  DEFINE_PROC ("Versioning_version_set", proc596);
  DEFINE_PROC ("Versioning_DAV_PROP_LIST", proc597);
  DEFINE_PROC ("Versioning_DAV_DIR_SINGLE", proc598);
  DEFINE_PROC ("Versioning_GET_BASE_PATH", proc599);
  DEFINE_PROC ("Versioning_GET_ATTIC_PATH", proc600);
  DEFINE_PROC ("Versioning_SET_LIST", proc601);
  DEFINE_PROC ("Versioning_DAV_DIR_LIST", proc602);
  DEFINE_PROC ("Versioning_DAV_DIR_FILTER", proc603);
  DEFINE_PROC ("Versioning_DAV_SEARCH_ID", proc604);
  DEFINE_PROC ("Versioning_DAV_SEARCH_PATH", proc605);
  DEFINE_PROC ("Versioning_DAV_RES_UPLOAD_COPY", proc606);
  DEFINE_PROC ("Versioning_DAV_RES_UPLOAD_MOVE", proc607);
  DEFINE_PROC ("Versioning_DAV_RES_CONTENT", proc608);
  DEFINE_PROC ("Versioning_DAV_SYMLINK", proc609);
  DEFINE_PROC ("Versioning_DAV_DEREFERENCE_LIST", proc610);
  DEFINE_PROC ("Versioning_DAV_RESOLVE_PATH", proc611);
  DEFINE_PROC ("Versioning_DAV_LOCK", proc612);
  DEFINE_PROC ("Versioning_DAV_UNLOCK", proc613);
  DEFINE_PROC ("Versioning_DAV_IS_LOCKED", proc614);
  DEFINE_PROC ("Versioning_DAV_LIST_LOCKS", proc615);
  DEFINE_PROC ("Versioning_AUTO_VERSION_PROP", proc616);
  DEFINE_PROC ("DAV_SET_VERSIONING_PROPERTIES", proc617);
  DEFINE_PROC ("Versioning_REMOVE_V_PROPERTIES", proc618);
  DEFINE_PROC ("DAV_REMOVE_VERSIONING_CONTROL_INT", proc619);
  DEFINE_PROC ("Versioning_SETPROP", proc620);
  DEFINE_PROC ("DAV_SET_VERSIONING_CONTROL", proc621);
  DEFINE_PROC ("DAV_MKWORKSPACE", proc622);
  DEFINE_PROC ("DAV_CHECKOUT", proc623);
  DEFINE_PROC ("DAV_CHECKOUT_INT", proc624);
  DEFINE_PROC ("DAV_CHECKIN", proc625);
  DEFINE_PROC ("DAV_CHECKIN_INT", proc626);
  DEFINE_PROC ("Versioning_CHECKOUT_INT", proc627);
  ddl_std_proc (trig45, 0x0);
  DEFINE_PROC ("DAV_VERSION_CONTROL", proc628);
  DEFINE_PROC ("DAV_UNCHECKOUT", proc629);
  DEFINE_PROC ("Versioning_Attic", proc630);
  DEFINE_PROC ("Versioning_OTHER_FILES_IN_VVC", proc631); 
  DEFINE_PUBLIC_PROC ("DAV_REMOVE_VERSION_CONTROL", proc632); 
  DEFINE_PUBLIC_PROC ("DAV_VERSION_FOLD_INT", proc633);
  ddl_std_proc (trig46, 0x0);

  /* xml_view.sql */

  DEFINE_PROC ("XML_VIEW_PUBLISH", proc634);
  DEFINE_PROC ("XML_VIEW_DROP", proc635);
}


void
sqls_arfw_define_dav (void)
{
  /* dav_api.sql */

  ddl_ensure_table ("do this always", other0);

}
