/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gidlparser.h>
#include <gidlmodule.h>
#include <gidlnode.h>
#include <float.h>
#include <math.h>
#include <gmetadata.h>
#include <stdio.h>


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_idl_module_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_idl_module_free0_ (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	ValaMap* codenode_attributes_map;
	ValaMap* codenode_attributes_patterns;
	ValaSet* current_type_symbol_set;
	ValaMap* cname_type_map;
};


static gpointer vala_gidl_parser_parent_class = NULL;
static GRegex* vala_gidl_parser_type_from_string_regex;
static GRegex* vala_gidl_parser_type_from_string_regex = NULL;

GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
#define VALA_GIDL_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIDL_PARSER, ValaGIdlParserPrivate))
enum  {
	VALA_GIDL_PARSER_DUMMY_PROPERTY
};
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static gchar* vala_gidl_parser_get_cname (ValaGIdlParser* self, ValaSymbol* sym, ValaSymbol* container);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module);
static void _g_idl_module_free0_ (gpointer var);
static void _g_list_free__g_idl_module_free0_ (GList* self);
static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1);
static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s);
gchar* vala_gidl_parser_get_cprefix (ValaGIdlParser* self, ValaSymbol* sym);
static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container);
static gchar* vala_gidl_parser_get_lower_case_cprefix (ValaGIdlParser* self, ValaSymbol* sym);
static gchar* vala_gidl_parser_get_cheader_filename (ValaGIdlParser* self, ValaSymbol* sym);
static gchar* vala_gidl_parser_get_finish_cname (ValaGIdlParser* self, ValaMethod* m);
static gchar* vala_gidl_parser_get_lower_case_cname (ValaGIdlParser* self, ValaSymbol* sym);
static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1);
static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym);
static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface);
static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction);
static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self, const gchar* type_string, gboolean owned_by_default, ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self, ValaDataType* parent_type, const gchar* type_arguments, ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name);
static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self, const gchar* symbol_string, ValaSourceReference* source_reference);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface);
static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Parse all source files in the specified code context and build a
 * code tree.
 *
 * @param context a code context
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = (ValaMap*) _tmp3_;
	_tmp4_ = context;
	_tmp5_ = _vala_code_context_ref0 (_tmp4_);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp5_;
	_tmp6_ = context;
	vala_code_context_accept (_tmp6_, (ValaCodeVisitor*) self);
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = NULL;
}


static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIdlParser * self;
	ValaNamespace* _tmp0_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIdlParser * self;
	ValaClass* _tmp0_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIdlParser * self;
	ValaStruct* _tmp0_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIdlParser * self;
	ValaInterface* _tmp0_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIdlParser * self;
	ValaEnum* _tmp0_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaGIdlParser * self;
	ValaErrorDomain* _tmp0_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	_tmp0_ = ed;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaGIdlParser * self;
	ValaDelegate* _tmp0_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t) {
	ValaMap* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->cname_type_map;
	_tmp1_ = t;
	_tmp2_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_map_contains (_tmp0_, _tmp3_);
	_tmp5_ = !_tmp4_;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		ValaMap* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		ValaTypeSymbol* _tmp10_;
		_tmp6_ = self->priv->cname_type_map;
		_tmp7_ = t;
		_tmp8_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = t;
		vala_map_set (_tmp6_, _tmp9_, _tmp10_);
		_g_free0 (_tmp9_);
	}
}


static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGIdlParser * self;
	ValaSourceFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = source_file;
	_tmp1_ = vala_source_file_get_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_suffix (_tmp2_, ".gi");
	if (_tmp3_) {
		ValaSourceFile* _tmp4_;
		_tmp4_ = source_file;
		vala_gidl_parser_parse_file (self, _tmp4_);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void _g_idl_module_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_idl_module_free (var), NULL));
}


static void _g_list_free__g_idl_module_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_idl_module_free0_, NULL);
	g_list_free (self);
}


static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file) {
	ValaSourceFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaSourceFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* metadata_filename;
	ValaSourceFile* _tmp14_;
	ValaSourceFile* _tmp15_;
	GHashFunc _tmp16_;
	GEqualFunc _tmp17_;
	GEqualFunc _tmp18_;
	ValaHashMap* _tmp19_;
	GHashFunc _tmp20_;
	GEqualFunc _tmp21_;
	ValaHashMap* _tmp22_;
	const gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = source_file;
	_tmp1_ = vala_source_file_get_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = source_file;
	_tmp4_ = vala_source_file_get_filename (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = strlen (".gi");
	_tmp9_ = _tmp8_;
	_tmp10_ = string_substring (_tmp2_, (glong) 0, (glong) (_tmp7_ - _tmp9_));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%s.metadata", _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	metadata_filename = _tmp13_;
	_tmp14_ = source_file;
	_tmp15_ = _vala_source_file_ref0 (_tmp14_);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp15_;
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp16_, _tmp17_, _tmp18_);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	self->priv->codenode_attributes_map = (ValaMap*) _tmp19_;
	_tmp20_ = g_direct_hash;
	_tmp21_ = g_direct_equal;
	_tmp22_ = vala_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp20_, (GEqualFunc) g_pattern_spec_equal, _tmp21_);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	self->priv->codenode_attributes_patterns = (ValaMap*) _tmp22_;
	_tmp23_ = metadata_filename;
	_tmp24_ = g_file_test (_tmp23_, G_FILE_TEST_EXISTS);
	if (_tmp24_) {
		{
			gchar* metadata = NULL;
			const gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_ = NULL;
			_tmp25_ = metadata_filename;
			g_file_get_contents (_tmp25_, &_tmp26_, NULL, &_inner_error_);
			_g_free0 (metadata);
			metadata = _tmp26_;
			if (_inner_error_ != NULL) {
				_g_free0 (metadata);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (metadata);
				_g_free0 (metadata_filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp27_ = metadata;
			_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "\n", 0);
			{
				gchar** line_collection = NULL;
				gint line_collection_length1 = 0;
				gint _line_collection_size_ = 0;
				gint line_it = 0;
				line_collection = _tmp29_;
				line_collection_length1 = _vala_array_length (_tmp28_);
				for (line_it = 0; line_it < _vala_array_length (_tmp28_); line_it = line_it + 1) {
					gchar* _tmp30_;
					gchar* line = NULL;
					_tmp30_ = g_strdup (line_collection[line_it]);
					line = _tmp30_;
					{
						const gchar* _tmp31_;
						gboolean _tmp32_ = FALSE;
						const gchar* _tmp33_;
						gchar** _tmp34_;
						gchar** _tmp35_ = NULL;
						gchar** tokens;
						gint tokens_length1;
						gint _tokens_size_;
						gchar** _tmp36_;
						gint _tmp36__length1;
						const gchar* _tmp37_;
						gchar** _tmp38_;
						gint _tmp38__length1;
						const gchar* _tmp39_;
						gint _tmp40_ = 0;
						ValaMap* _tmp48_;
						gchar** _tmp49_;
						gint _tmp49__length1;
						const gchar* _tmp50_;
						gchar** _tmp51_;
						gint _tmp51__length1;
						const gchar* _tmp52_;
						_tmp31_ = line;
						_tmp32_ = g_str_has_prefix (_tmp31_, "#");
						if (_tmp32_) {
							_g_free0 (line);
							continue;
						}
						_tmp33_ = line;
						_tmp35_ = _tmp34_ = g_strsplit (_tmp33_, " ", 2);
						tokens = _tmp35_;
						tokens_length1 = _vala_array_length (_tmp34_);
						_tokens_size_ = tokens_length1;
						_tmp36_ = tokens;
						_tmp36__length1 = tokens_length1;
						_tmp37_ = _tmp36_[0];
						if (NULL == _tmp37_) {
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (line);
							continue;
						}
						_tmp38_ = tokens;
						_tmp38__length1 = tokens_length1;
						_tmp39_ = _tmp38_[0];
						_tmp40_ = string_index_of_char (_tmp39_, (gunichar) '*', 0);
						if ((-1) != _tmp40_) {
							gchar** _tmp41_;
							gint _tmp41__length1;
							const gchar* _tmp42_;
							GPatternSpec* _tmp43_;
							GPatternSpec* pattern;
							ValaMap* _tmp44_;
							GPatternSpec* _tmp45_;
							gchar** _tmp46_;
							gint _tmp46__length1;
							const gchar* _tmp47_;
							_tmp41_ = tokens;
							_tmp41__length1 = tokens_length1;
							_tmp42_ = _tmp41_[0];
							_tmp43_ = g_pattern_spec_new (_tmp42_);
							pattern = _tmp43_;
							_tmp44_ = self->priv->codenode_attributes_patterns;
							_tmp45_ = pattern;
							_tmp46_ = tokens;
							_tmp46__length1 = tokens_length1;
							_tmp47_ = _tmp46_[0];
							vala_map_set (_tmp44_, _tmp45_, _tmp47_);
						}
						_tmp48_ = self->priv->codenode_attributes_map;
						_tmp49_ = tokens;
						_tmp49__length1 = tokens_length1;
						_tmp50_ = _tmp49_[0];
						_tmp51_ = tokens;
						_tmp51__length1 = tokens_length1;
						_tmp52_ = _tmp51_[1];
						vala_map_set (_tmp48_, _tmp50_, _tmp52_);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
					}
				}
				line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (metadata);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp53_ = e;
			_tmp54_ = _tmp53_->message;
			_tmp55_ = g_strdup_printf ("Unable to read metadata file: %s", _tmp54_);
			_tmp56_ = _tmp55_;
			vala_report_error (NULL, _tmp56_);
			_g_free0 (_tmp56_);
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		ValaSourceFile* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		GList* _tmp60_ = NULL;
		GList* modules;
		ValaSourceFile* _tmp61_;
		ValaSourceLocation _tmp62_ = {0};
		ValaSourceLocation _tmp63_ = {0};
		ValaSourceReference* _tmp64_;
		_tmp57_ = source_file;
		_tmp58_ = vala_source_file_get_filename (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_idl_parse_file (_tmp59_, &_inner_error_);
		modules = _tmp60_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_MARKUP_ERROR) {
				goto __catch1_g_markup_error;
			}
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp61_ = source_file;
		vala_source_location_init (&_tmp62_, NULL, 0, 0);
		vala_source_location_init (&_tmp63_, NULL, 0, 0);
		_tmp64_ = vala_source_reference_new (_tmp61_, &_tmp62_, &_tmp63_);
		_vala_source_reference_unref0 (self->priv->current_source_reference);
		self->priv->current_source_reference = _tmp64_;
		{
			GList* module_collection = NULL;
			GList* module_it = NULL;
			module_collection = modules;
			for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
				GIdlModule* module = NULL;
				module = (GIdlModule*) module_it->data;
				{
					GIdlModule* _tmp65_;
					ValaNamespace* _tmp66_ = NULL;
					ValaNamespace* ns;
					ValaNamespace* _tmp67_;
					_tmp65_ = module;
					_tmp66_ = vala_gidl_parser_parse_module (self, _tmp65_);
					ns = _tmp66_;
					_tmp67_ = ns;
					if (_tmp67_ != NULL) {
						ValaCodeContext* _tmp68_;
						ValaNamespace* _tmp69_;
						ValaNamespace* _tmp70_;
						ValaNamespace* _tmp71_;
						_tmp68_ = self->priv->context;
						_tmp69_ = vala_code_context_get_root (_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp70_, _tmp71_);
					}
					_vala_code_node_unref0 (ns);
				}
			}
		}
		__g_list_free__g_idl_module_free0_0 (modules);
	}
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp72_;
		const gchar* _tmp73_;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp72_ = e;
		_tmp73_ = _tmp72_->message;
		_tmp74_ = g_strdup_printf ("Unable to parse GIDL file: %s", _tmp73_);
		_tmp75_ = _tmp74_;
		vala_report_error (NULL, _tmp75_);
		_g_free0 (_tmp75_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (metadata_filename);
}


static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp14_;
	ValaSymbol* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = type_name;
	_tmp2_ = vala_gidl_parser_get_attributes (self, _tmp0_, &_tmp1_);
	attributes = _tmp2_;
	attributes_length1 = _tmp1_;
	_attributes_size_ = attributes_length1;
	_tmp3_ = attributes;
	_tmp3__length1 = attributes_length1;
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = attributes;
		_tmp4__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp4_;
			attr_collection_length1 = _tmp4__length1;
			for (attr_it = 0; attr_it < _tmp4__length1; attr_it = attr_it + 1) {
				gchar* _tmp5_;
				gchar* attr = NULL;
				_tmp5_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp5_;
				{
					const gchar* _tmp6_;
					gchar** _tmp7_;
					gchar** _tmp8_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					_tmp6_ = attr;
					_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "=", 2);
					nv = _tmp8_;
					nv_length1 = _vala_array_length (_tmp7_);
					_nv_size_ = nv_length1;
					_tmp9_ = nv;
					_tmp9__length1 = nv_length1;
					_tmp10_ = _tmp9_[0];
					if (g_strcmp0 (_tmp10_, "name") == 0) {
						gchar** _tmp11_;
						gint _tmp11__length1;
						const gchar* _tmp12_;
						gchar* _tmp13_ = NULL;
						_tmp11_ = nv;
						_tmp11__length1 = nv_length1;
						_tmp12_ = _tmp11_[1];
						_tmp13_ = vala_gidl_parser_eval (self, _tmp12_);
						result = _tmp13_;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp14_ = type_name;
	_tmp15_ = container;
	_tmp16_ = vala_symbol_get_name (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_str_has_prefix (_tmp14_, _tmp17_);
	if (_tmp18_) {
		const gchar* _tmp19_;
		ValaSymbol* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		_tmp19_ = type_name;
		_tmp20_ = container;
		_tmp21_ = vala_symbol_get_name (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = string_substring (_tmp19_, (glong) _tmp24_, (glong) (-1));
		result = _tmp25_;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		ValaSymbol* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* cprefix;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp26_ = container;
		_tmp27_ = vala_gidl_parser_get_cprefix (self, _tmp26_);
		cprefix = _tmp27_;
		_tmp28_ = type_name;
		_tmp29_ = cprefix;
		_tmp30_ = g_str_has_prefix (_tmp28_, _tmp29_);
		if (_tmp30_) {
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_ = NULL;
			_tmp31_ = type_name;
			_tmp32_ = cprefix;
			_tmp33_ = strlen (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = string_substring (_tmp31_, (glong) _tmp34_, (glong) (-1));
			result = _tmp35_;
			_g_free0 (cprefix);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_free0 (cprefix);
	}
	_tmp36_ = type_name;
	_tmp37_ = g_strdup (_tmp36_);
	result = _tmp37_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* pref;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = container;
	_tmp1_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strup (_tmp2_, (gssize) (-1));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	pref = _tmp4_;
	_tmp5_ = const_name;
	_tmp6_ = pref;
	_tmp7_ = g_str_has_prefix (_tmp5_, _tmp6_);
	if (_tmp7_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		_tmp8_ = const_name;
		_tmp9_ = pref;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp8_, (glong) _tmp11_, (glong) (-1));
		result = _tmp12_;
		_g_free0 (pref);
		return result;
	}
	_tmp13_ = const_name;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_free0 (pref);
	return result;
}


static gchar* vala_gidl_parser_get_cheader_filename (ValaGIdlParser* self, ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* cheader_filename;
	const gchar* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "cheader_filename");
	cheader_filename = _tmp1_;
	_tmp2_ = cheader_filename;
	if (_tmp2_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp3_ = sym;
	_tmp4_ = vala_symbol_get_parent_symbol (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp6_ = sym;
		_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_gidl_parser_get_cheader_filename (self, _tmp8_);
		result = _tmp9_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSymbol* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		_tmp10_ = sym;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaSymbol* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceFile* _tmp16_;
			ValaSourceFile* _tmp17_;
			gchar* _tmp18_ = NULL;
			_tmp13_ = sym;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_source_reference_get_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_cinclude_filename (_tmp17_);
			result = _tmp18_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (cheader_filename);
	return result;
}


static gchar* vala_gidl_parser_get_cname (ValaGIdlParser* self, ValaSymbol* sym, ValaSymbol* container) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* cname;
	const gchar* _tmp6_;
	ValaSymbol* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = container;
	if (_tmp0_ == NULL) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp1_ = sym;
		_tmp2_ = vala_symbol_get_parent_symbol (_tmp1_);
		_tmp3_ = _tmp2_;
		container = _tmp3_;
	}
	_tmp4_ = sym;
	_tmp5_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp4_, "CCode", "cname");
	cname = _tmp5_;
	_tmp6_ = cname;
	if (_tmp6_ != NULL) {
		result = cname;
		return result;
	}
	_tmp7_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_METHOD)) {
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* name;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp20_;
		_tmp8_ = sym;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		name = _tmp11_;
		_tmp12_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CREATION_METHOD)) {
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			gboolean _tmp16_;
			_tmp14_ = name;
			if (_tmp14_ == NULL) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = name;
				_tmp13_ = g_strcmp0 (_tmp15_, ".new") == 0;
			}
			_tmp16_ = _tmp13_;
			if (_tmp16_) {
				gchar* _tmp17_;
				_tmp17_ = g_strdup ("new");
				_g_free0 (name);
				name = _tmp17_;
			} else {
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = name;
				_tmp19_ = g_strconcat ("new_", _tmp18_, NULL);
				_g_free0 (name);
				name = _tmp19_;
			}
		}
		_tmp20_ = container;
		if (_tmp20_ != NULL) {
			ValaSymbol* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			_tmp21_ = container;
			_tmp22_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = name;
			_tmp25_ = g_strdup_printf ("%s%s", _tmp23_, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp23_);
			result = _tmp26_;
			_g_free0 (name);
			_g_free0 (cname);
			return result;
		} else {
			result = name;
			_g_free0 (cname);
			return result;
		}
		_g_free0 (name);
	} else {
		ValaSymbol* _tmp27_;
		_tmp27_ = container;
		if (_tmp27_ != NULL) {
			ValaSymbol* _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			ValaSymbol* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			_tmp28_ = container;
			_tmp29_ = vala_gidl_parser_get_cprefix (self, _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = sym;
			_tmp32_ = vala_symbol_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strdup_printf ("%s%s", _tmp30_, _tmp33_);
			_tmp35_ = _tmp34_;
			_g_free0 (_tmp30_);
			result = _tmp35_;
			_g_free0 (cname);
			return result;
		} else {
			ValaSymbol* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp36_ = sym;
			_tmp37_ = vala_symbol_get_name (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strdup (_tmp38_);
			result = _tmp39_;
			_g_free0 (cname);
			return result;
		}
	}
	_g_free0 (cname);
}


static gchar* vala_gidl_parser_get_finish_cname (ValaGIdlParser* self, ValaMethod* m) {
	gchar* result = NULL;
	ValaMethod* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* finish_cname;
	const gchar* _tmp2_;
	ValaMethod* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _result_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "finish_name");
	finish_cname = _tmp1_;
	_tmp2_ = finish_cname;
	if (_tmp2_ != NULL) {
		result = finish_cname;
		return result;
	}
	_tmp3_ = m;
	_tmp4_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp3_, NULL);
	_result_ = _tmp4_;
	_tmp5_ = _result_;
	_tmp6_ = g_str_has_suffix (_tmp5_, "_async");
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp7_ = _result_;
		_tmp8_ = _result_;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = strlen ("_async");
		_tmp12_ = _tmp11_;
		_tmp13_ = string_substring (_tmp7_, (glong) 0, (glong) (_tmp10_ - _tmp12_));
		_g_free0 (_result_);
		_result_ = _tmp13_;
	}
	_tmp14_ = _result_;
	_tmp15_ = g_strconcat (_tmp14_, "_finish", NULL);
	result = _tmp15_;
	_g_free0 (_result_);
	_g_free0 (finish_cname);
	return result;
}


static gchar* vala_gidl_parser_get_lower_case_cname (ValaGIdlParser* self, ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* lower_case_csuffix;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_symbol_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_camel_case_to_lower_case (_tmp2_);
	lower_case_csuffix = _tmp3_;
	_tmp4_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp5_ = lower_case_csuffix;
		_tmp6_ = g_str_has_prefix (_tmp5_, "type_");
		if (_tmp6_) {
			const gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp7_ = lower_case_csuffix;
			_tmp8_ = strlen ("type_");
			_tmp9_ = _tmp8_;
			_tmp10_ = string_substring (_tmp7_, (glong) _tmp9_, (glong) (-1));
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat ("type", _tmp11_, NULL);
			_g_free0 (lower_case_csuffix);
			lower_case_csuffix = _tmp12_;
			_g_free0 (_tmp11_);
		} else {
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = lower_case_csuffix;
			_tmp14_ = g_str_has_prefix (_tmp13_, "is_");
			if (_tmp14_) {
				const gchar* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp15_ = lower_case_csuffix;
				_tmp16_ = strlen ("is_");
				_tmp17_ = _tmp16_;
				_tmp18_ = string_substring (_tmp15_, (glong) _tmp17_, (glong) (-1));
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat ("is", _tmp19_, NULL);
				_g_free0 (lower_case_csuffix);
				lower_case_csuffix = _tmp20_;
				_g_free0 (_tmp19_);
			}
		}
		_tmp21_ = lower_case_csuffix;
		_tmp22_ = g_str_has_suffix (_tmp21_, "_class");
		if (_tmp22_) {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp23_ = lower_case_csuffix;
			_tmp24_ = lower_case_csuffix;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = strlen ("_class");
			_tmp28_ = _tmp27_;
			_tmp29_ = string_substring (_tmp23_, (glong) 0, (glong) (_tmp26_ - _tmp28_));
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp30_, "class", NULL);
			_g_free0 (lower_case_csuffix);
			lower_case_csuffix = _tmp31_;
			_g_free0 (_tmp30_);
		}
	}
	_tmp32_ = sym;
	_tmp33_ = vala_symbol_get_parent_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		ValaSymbol* _tmp37_;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_;
		_tmp35_ = sym;
		_tmp36_ = vala_symbol_get_parent_symbol (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = lower_case_csuffix;
		_tmp41_ = g_strdup_printf ("%s%s", _tmp39_, _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp39_);
		result = _tmp42_;
		_g_free0 (lower_case_csuffix);
		return result;
	} else {
		result = lower_case_csuffix;
		return result;
	}
	_g_free0 (lower_case_csuffix);
}


static gchar* vala_gidl_parser_get_lower_case_cprefix (ValaGIdlParser* self, ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* cprefix = NULL;
	ValaSymbol* _tmp4_;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp12_;
	const gchar* _tmp15_;
	ValaSymbol* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_symbol_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = sym;
	_tmp5_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp4_, "CCode", "lower_case_cprefix");
	_g_free0 (cprefix);
	cprefix = _tmp5_;
	_tmp7_ = cprefix;
	if (_tmp7_ == NULL) {
		gboolean _tmp8_ = FALSE;
		ValaSymbol* _tmp9_;
		gboolean _tmp11_;
		_tmp9_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
			_tmp8_ = TRUE;
		} else {
			ValaSymbol* _tmp10_;
			_tmp10_ = sym;
			_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_STRUCT);
		}
		_tmp11_ = _tmp8_;
		_tmp6_ = _tmp11_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp12_ = _tmp6_;
	if (_tmp12_) {
		ValaSymbol* _tmp13_;
		gchar* _tmp14_ = NULL;
		_tmp13_ = sym;
		_tmp14_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp13_, "CCode", "cprefix");
		_g_free0 (cprefix);
		cprefix = _tmp14_;
	}
	_tmp15_ = cprefix;
	if (_tmp15_ != NULL) {
		result = cprefix;
		return result;
	}
	_tmp16_ = sym;
	_tmp17_ = vala_gidl_parser_get_lower_case_cname (self, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "_", NULL);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	result = _tmp20_;
	_g_free0 (cprefix);
	return result;
}


gchar* vala_gidl_parser_get_cprefix (ValaGIdlParser* self, ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp46_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		ValaSymbol* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp1_ = sym;
		_tmp2_ = vala_gidl_parser_get_cname (self, _tmp1_, NULL);
		result = _tmp2_;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		ValaSymbol* _tmp4_;
		gboolean _tmp6_;
		_tmp4_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ENUM)) {
			_tmp3_ = TRUE;
		} else {
			ValaSymbol* _tmp5_;
			_tmp5_ = sym;
			_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ERROR_DOMAIN);
		}
		_tmp6_ = _tmp3_;
		if (_tmp6_) {
			ValaSymbol* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp7_ = sym;
			_tmp8_ = vala_gidl_parser_get_lower_case_cname (self, _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_utf8_strup (_tmp9_, (gssize) (-1));
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup_printf ("%s_", _tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			result = _tmp13_;
			return result;
		} else {
			ValaSymbol* _tmp14_;
			_tmp14_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_NAMESPACE)) {
				ValaSymbol* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = sym;
				_tmp16_ = vala_symbol_get_name (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_ != NULL) {
					ValaSymbol* _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* cprefix;
					const gchar* _tmp20_;
					ValaSymbol* _tmp21_;
					ValaSymbol* _tmp22_;
					ValaSymbol* _tmp23_;
					_tmp18_ = sym;
					_tmp19_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp18_, "CCode", "cprefix");
					cprefix = _tmp19_;
					_tmp20_ = cprefix;
					if (_tmp20_ != NULL) {
						result = cprefix;
						return result;
					}
					_tmp21_ = sym;
					_tmp22_ = vala_symbol_get_parent_symbol (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_ != NULL) {
						ValaSymbol* _tmp24_;
						ValaSymbol* _tmp25_;
						ValaSymbol* _tmp26_;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_;
						ValaSymbol* _tmp29_;
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						_tmp24_ = sym;
						_tmp25_ = vala_symbol_get_parent_symbol (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = vala_gidl_parser_get_cprefix (self, _tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = sym;
						_tmp30_ = vala_symbol_get_name (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = g_strdup_printf ("%s%s", _tmp28_, _tmp31_);
						_tmp33_ = _tmp32_;
						_g_free0 (_tmp28_);
						result = _tmp33_;
						_g_free0 (cprefix);
						return result;
					} else {
						ValaSymbol* _tmp34_;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp34_ = sym;
						_tmp35_ = vala_symbol_get_name (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_strdup (_tmp36_);
						result = _tmp37_;
						_g_free0 (cprefix);
						return result;
					}
					_g_free0 (cprefix);
				} else {
					gchar* _tmp38_;
					_tmp38_ = g_strdup ("");
					result = _tmp38_;
					return result;
				}
			} else {
				ValaSymbol* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp39_ = sym;
				_tmp40_ = vala_symbol_get_name (_tmp39_);
				_tmp41_ = _tmp40_;
				if (_tmp41_ != NULL) {
					ValaSymbol* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					_tmp42_ = sym;
					_tmp43_ = vala_symbol_get_name (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = g_strdup (_tmp44_);
					result = _tmp45_;
					return result;
				}
			}
		}
	}
	_tmp46_ = g_strdup ("");
	result = _tmp46_;
	return result;
}


static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1) {
	gchar** result = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp0_;
	GIdlNodeTypeId _tmp1_;
	const gchar* _tmp32_;
	gint _tmp33_ = 0;
	gchar** _tmp34_ = NULL;
	gchar** _tmp35_;
	gint _tmp35__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == G_IDL_NODE_FUNCTION) {
		GIdlNode* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = node;
		_tmp3_ = ((GIdlNodeFunction*) _tmp2_)->symbol;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (name);
		name = _tmp4_;
	} else {
		GIdlNode* _tmp5_;
		GIdlNodeTypeId _tmp6_;
		_tmp5_ = node;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ == G_IDL_NODE_SIGNAL) {
			ValaTypeSymbol* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			GIdlNode* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			_tmp7_ = self->priv->current_data_type;
			_tmp8_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp7_, NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = node;
			_tmp11_ = _tmp10_->name;
			_tmp12_ = g_strdup_printf ("%s::%s", _tmp9_, _tmp11_);
			_g_free0 (name);
			name = _tmp12_;
			_g_free0 (_tmp9_);
		} else {
			GIdlNode* _tmp13_;
			GIdlNodeTypeId _tmp14_;
			_tmp13_ = node;
			_tmp14_ = _tmp13_->type;
			if (_tmp14_ == G_IDL_NODE_PROPERTY) {
				ValaTypeSymbol* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				GIdlNode* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				_tmp15_ = self->priv->current_data_type;
				_tmp16_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp15_, NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = node;
				_tmp19_ = _tmp18_->name;
				_tmp20_ = g_strdup_printf ("%s:%s", _tmp17_, _tmp19_);
				_g_free0 (name);
				name = _tmp20_;
				_g_free0 (_tmp17_);
			} else {
				GIdlNode* _tmp21_;
				GIdlNodeTypeId _tmp22_;
				_tmp21_ = node;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ == G_IDL_NODE_FIELD) {
					ValaTypeSymbol* _tmp23_;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					GIdlNode* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_ = NULL;
					_tmp23_ = self->priv->current_data_type;
					_tmp24_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp23_, NULL);
					_tmp25_ = _tmp24_;
					_tmp26_ = node;
					_tmp27_ = _tmp26_->name;
					_tmp28_ = g_strdup_printf ("%s.%s", _tmp25_, _tmp27_);
					_g_free0 (name);
					name = _tmp28_;
					_g_free0 (_tmp25_);
				} else {
					GIdlNode* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp29_ = node;
					_tmp30_ = _tmp29_->name;
					_tmp31_ = g_strdup (_tmp30_);
					_g_free0 (name);
					name = _tmp31_;
				}
			}
		}
	}
	_tmp32_ = name;
	_tmp34_ = vala_gidl_parser_get_attributes (self, _tmp32_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_free0 (name);
	return result;
}


static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym) {
	ValaSymbol* _tmp0_;
	gboolean _tmp112_ = FALSE;
	ValaSymbol* _tmp113_;
	gboolean _tmp115_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = container;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp1_;
		ValaClass* cl;
		ValaSymbol* _tmp2_;
		_tmp1_ = container;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
		_tmp2_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS)) {
			ValaClass* _tmp3_;
			ValaSymbol* _tmp4_;
			_tmp3_ = cl;
			_tmp4_ = sym;
			vala_symbol_add_class ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
		} else {
			ValaSymbol* _tmp5_;
			_tmp5_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CONSTANT)) {
				ValaClass* _tmp6_;
				ValaSymbol* _tmp7_;
				_tmp6_ = cl;
				_tmp7_ = sym;
				vala_symbol_add_constant ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				ValaSymbol* _tmp8_;
				_tmp8_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_ENUM)) {
					ValaClass* _tmp9_;
					ValaSymbol* _tmp10_;
					_tmp9_ = cl;
					_tmp10_ = sym;
					vala_symbol_add_enum ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_ENUM, ValaEnum));
				} else {
					ValaSymbol* _tmp11_;
					_tmp11_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_FIELD)) {
						ValaClass* _tmp12_;
						ValaSymbol* _tmp13_;
						_tmp12_ = cl;
						_tmp13_ = sym;
						vala_symbol_add_field ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_FIELD, ValaField));
					} else {
						ValaSymbol* _tmp14_;
						_tmp14_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_METHOD)) {
							ValaClass* _tmp15_;
							ValaSymbol* _tmp16_;
							_tmp15_ = cl;
							_tmp16_ = sym;
							vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_METHOD, ValaMethod));
						} else {
							ValaSymbol* _tmp17_;
							_tmp17_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_PROPERTY)) {
								ValaClass* _tmp18_;
								ValaSymbol* _tmp19_;
								_tmp18_ = cl;
								_tmp19_ = sym;
								vala_symbol_add_property ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								ValaSymbol* _tmp20_;
								_tmp20_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_SIGNAL)) {
									ValaClass* _tmp21_;
									ValaSymbol* _tmp22_;
									_tmp21_ = cl;
									_tmp22_ = sym;
									vala_symbol_add_signal ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									ValaSymbol* _tmp23_;
									_tmp23_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_STRUCT)) {
										ValaClass* _tmp24_;
										ValaSymbol* _tmp25_;
										_tmp24_ = cl;
										_tmp25_ = sym;
										vala_symbol_add_struct ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		ValaSymbol* _tmp26_;
		_tmp26_ = container;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_ENUM)) {
			ValaSymbol* _tmp27_;
			ValaEnum* en;
			ValaSymbol* _tmp28_;
			_tmp27_ = container;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_ENUM, ValaEnum);
			_tmp28_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_ENUM_VALUE)) {
				ValaEnum* _tmp29_;
				ValaSymbol* _tmp30_;
				_tmp29_ = en;
				_tmp30_ = sym;
				vala_enum_add_value (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				ValaSymbol* _tmp31_;
				_tmp31_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_CONSTANT)) {
					ValaEnum* _tmp32_;
					ValaSymbol* _tmp33_;
					_tmp32_ = en;
					_tmp33_ = sym;
					vala_symbol_add_constant ((ValaSymbol*) _tmp32_, G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					ValaSymbol* _tmp34_;
					_tmp34_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_METHOD)) {
						ValaEnum* _tmp35_;
						ValaSymbol* _tmp36_;
						_tmp35_ = en;
						_tmp36_ = sym;
						vala_symbol_add_method ((ValaSymbol*) _tmp35_, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			ValaSymbol* _tmp37_;
			_tmp37_ = container;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALA_TYPE_INTERFACE)) {
				ValaSymbol* _tmp38_;
				ValaInterface* iface;
				ValaSymbol* _tmp39_;
				_tmp38_ = container;
				iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_INTERFACE, ValaInterface);
				_tmp39_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_CLASS)) {
					ValaInterface* _tmp40_;
					ValaSymbol* _tmp41_;
					_tmp40_ = iface;
					_tmp41_ = sym;
					vala_symbol_add_class ((ValaSymbol*) _tmp40_, G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_CLASS, ValaClass));
				} else {
					ValaSymbol* _tmp42_;
					_tmp42_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_CONSTANT)) {
						ValaInterface* _tmp43_;
						ValaSymbol* _tmp44_;
						_tmp43_ = iface;
						_tmp44_ = sym;
						vala_symbol_add_constant ((ValaSymbol*) _tmp43_, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						ValaSymbol* _tmp45_;
						_tmp45_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, VALA_TYPE_ENUM)) {
							ValaInterface* _tmp46_;
							ValaSymbol* _tmp47_;
							_tmp46_ = iface;
							_tmp47_ = sym;
							vala_symbol_add_enum ((ValaSymbol*) _tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ENUM, ValaEnum));
						} else {
							ValaSymbol* _tmp48_;
							_tmp48_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_FIELD)) {
								ValaInterface* _tmp49_;
								ValaSymbol* _tmp50_;
								_tmp49_ = iface;
								_tmp50_ = sym;
								vala_symbol_add_field ((ValaSymbol*) _tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_FIELD, ValaField));
							} else {
								ValaSymbol* _tmp51_;
								_tmp51_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_METHOD)) {
									ValaInterface* _tmp52_;
									ValaSymbol* _tmp53_;
									_tmp52_ = iface;
									_tmp53_ = sym;
									vala_symbol_add_method ((ValaSymbol*) _tmp52_, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_METHOD, ValaMethod));
								} else {
									ValaSymbol* _tmp54_;
									_tmp54_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_PROPERTY)) {
										ValaInterface* _tmp55_;
										ValaSymbol* _tmp56_;
										_tmp55_ = iface;
										_tmp56_ = sym;
										vala_symbol_add_property ((ValaSymbol*) _tmp55_, G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										ValaSymbol* _tmp57_;
										_tmp57_ = sym;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_SIGNAL)) {
											ValaInterface* _tmp58_;
											ValaSymbol* _tmp59_;
											_tmp58_ = iface;
											_tmp59_ = sym;
											vala_symbol_add_signal ((ValaSymbol*) _tmp58_, G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											ValaSymbol* _tmp60_;
											_tmp60_ = sym;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_STRUCT)) {
												ValaInterface* _tmp61_;
												ValaSymbol* _tmp62_;
												_tmp61_ = iface;
												_tmp62_ = sym;
												vala_symbol_add_struct ((ValaSymbol*) _tmp61_, G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				ValaSymbol* _tmp63_;
				_tmp63_ = container;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, VALA_TYPE_NAMESPACE)) {
					ValaSymbol* _tmp64_;
					ValaNamespace* ns;
					ValaSymbol* _tmp65_;
					_tmp64_ = container;
					ns = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_NAMESPACE, ValaNamespace);
					_tmp65_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, VALA_TYPE_NAMESPACE)) {
						ValaNamespace* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = ns;
						_tmp67_ = sym;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp66_, G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						ValaSymbol* _tmp68_;
						_tmp68_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_CLASS)) {
							ValaNamespace* _tmp69_;
							ValaSymbol* _tmp70_;
							_tmp69_ = ns;
							_tmp70_ = sym;
							vala_symbol_add_class ((ValaSymbol*) _tmp69_, G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_CLASS, ValaClass));
						} else {
							ValaSymbol* _tmp71_;
							_tmp71_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_CONSTANT)) {
								ValaNamespace* _tmp72_;
								ValaSymbol* _tmp73_;
								_tmp72_ = ns;
								_tmp73_ = sym;
								vala_symbol_add_constant ((ValaSymbol*) _tmp72_, G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								ValaSymbol* _tmp74_;
								_tmp74_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_DELEGATE)) {
									ValaNamespace* _tmp75_;
									ValaSymbol* _tmp76_;
									_tmp75_ = ns;
									_tmp76_ = sym;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp75_, G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									ValaSymbol* _tmp77_;
									_tmp77_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_ENUM)) {
										ValaNamespace* _tmp78_;
										ValaSymbol* _tmp79_;
										_tmp78_ = ns;
										_tmp79_ = sym;
										vala_symbol_add_enum ((ValaSymbol*) _tmp78_, G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_ENUM, ValaEnum));
									} else {
										ValaSymbol* _tmp80_;
										_tmp80_ = sym;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALA_TYPE_ERROR_DOMAIN)) {
											ValaNamespace* _tmp81_;
											ValaSymbol* _tmp82_;
											_tmp81_ = ns;
											_tmp82_ = sym;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp81_, G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											ValaSymbol* _tmp83_;
											_tmp83_ = sym;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_FIELD)) {
												ValaNamespace* _tmp84_;
												ValaSymbol* _tmp85_;
												_tmp84_ = ns;
												_tmp85_ = sym;
												vala_symbol_add_field ((ValaSymbol*) _tmp84_, G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_FIELD, ValaField));
											} else {
												ValaSymbol* _tmp86_;
												_tmp86_ = sym;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, VALA_TYPE_INTERFACE)) {
													ValaNamespace* _tmp87_;
													ValaSymbol* _tmp88_;
													_tmp87_ = ns;
													_tmp88_ = sym;
													vala_symbol_add_interface ((ValaSymbol*) _tmp87_, G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													ValaSymbol* _tmp89_;
													_tmp89_ = sym;
													if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp89_, VALA_TYPE_METHOD)) {
														ValaNamespace* _tmp90_;
														ValaSymbol* _tmp91_;
														_tmp90_ = ns;
														_tmp91_ = sym;
														vala_symbol_add_method ((ValaSymbol*) _tmp90_, G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_METHOD, ValaMethod));
													} else {
														ValaSymbol* _tmp92_;
														_tmp92_ = sym;
														if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_NAMESPACE)) {
															ValaNamespace* _tmp93_;
															ValaSymbol* _tmp94_;
															_tmp93_ = ns;
															_tmp94_ = sym;
															vala_symbol_add_namespace ((ValaSymbol*) _tmp93_, G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_NAMESPACE, ValaNamespace));
														} else {
															ValaSymbol* _tmp95_;
															_tmp95_ = sym;
															if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_STRUCT)) {
																ValaNamespace* _tmp96_;
																ValaSymbol* _tmp97_;
																_tmp96_ = ns;
																_tmp97_ = sym;
																vala_symbol_add_struct ((ValaSymbol*) _tmp96_, G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_STRUCT, ValaStruct));
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					ValaSymbol* _tmp98_;
					_tmp98_ = container;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_STRUCT)) {
						ValaSymbol* _tmp99_;
						ValaStruct* st;
						ValaSymbol* _tmp100_;
						_tmp99_ = container;
						st = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp100_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, VALA_TYPE_CONSTANT)) {
							ValaStruct* _tmp101_;
							ValaSymbol* _tmp102_;
							_tmp101_ = st;
							_tmp102_ = sym;
							vala_symbol_add_constant ((ValaSymbol*) _tmp101_, G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							ValaSymbol* _tmp103_;
							_tmp103_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp103_, VALA_TYPE_FIELD)) {
								ValaStruct* _tmp104_;
								ValaSymbol* _tmp105_;
								_tmp104_ = st;
								_tmp105_ = sym;
								vala_symbol_add_field ((ValaSymbol*) _tmp104_, G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, VALA_TYPE_FIELD, ValaField));
							} else {
								ValaSymbol* _tmp106_;
								_tmp106_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_METHOD)) {
									ValaStruct* _tmp107_;
									ValaSymbol* _tmp108_;
									_tmp107_ = st;
									_tmp108_ = sym;
									vala_symbol_add_method ((ValaSymbol*) _tmp107_, G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, VALA_TYPE_METHOD, ValaMethod));
								} else {
									ValaSymbol* _tmp109_;
									_tmp109_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, VALA_TYPE_PROPERTY)) {
										ValaStruct* _tmp110_;
										ValaSymbol* _tmp111_;
										_tmp110_ = st;
										_tmp111_ = sym;
										vala_symbol_add_property ((ValaSymbol*) _tmp110_, G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp113_ = sym;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp113_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp114_;
		_tmp114_ = container;
		_tmp112_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp114_, VALA_TYPE_NAMESPACE);
	} else {
		_tmp112_ = FALSE;
	}
	_tmp115_ = _tmp112_;
	if (_tmp115_) {
		ValaSymbol* _tmp116_;
		ValaSymbol* _tmp117_;
		gchar* _tmp118_ = NULL;
		gchar* _tmp119_;
		_tmp116_ = sym;
		_tmp117_ = sym;
		_tmp118_ = vala_gidl_parser_get_cheader_filename (self, _tmp117_);
		_tmp119_ = _tmp118_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp116_, "CCode", "cheader_filename", _tmp119_, NULL);
		_g_free0 (_tmp119_);
	}
}


static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container) {
	GIdlNode* _tmp0_;
	GIdlNodeTypeId _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (module != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == G_IDL_NODE_CALLBACK) {
		GIdlNode* _tmp2_;
		ValaDelegate* _tmp3_ = NULL;
		ValaDelegate* cb;
		ValaDelegate* _tmp4_;
		ValaDelegate* _tmp5_;
		ValaDelegate* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		ValaSymbol* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaDelegate* _tmp13_;
		ValaSourceFile* _tmp14_;
		ValaDelegate* _tmp15_;
		_tmp2_ = node;
		_tmp3_ = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) _tmp2_);
		cb = _tmp3_;
		_tmp4_ = cb;
		if (_tmp4_ == NULL) {
			_vala_code_node_unref0 (cb);
			return;
		}
		_tmp5_ = cb;
		_tmp6_ = cb;
		_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = container;
		_tmp10_ = vala_gidl_parser_fix_type_name (self, _tmp8_, _tmp9_);
		_tmp11_ = _tmp10_;
		vala_symbol_set_name ((ValaSymbol*) _tmp5_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = container;
		_tmp13_ = cb;
		vala_gidl_parser_add_symbol_to_container (self, _tmp12_, (ValaSymbol*) _tmp13_);
		_tmp14_ = self->priv->current_source_file;
		_tmp15_ = cb;
		vala_source_file_add_node (_tmp14_, (ValaCodeNode*) _tmp15_);
		_vala_code_node_unref0 (cb);
	} else {
		GIdlNode* _tmp16_;
		GIdlNodeTypeId _tmp17_;
		_tmp16_ = node;
		_tmp17_ = _tmp16_->type;
		if (_tmp17_ == G_IDL_NODE_STRUCT) {
			GIdlNode* _tmp18_;
			ValaSymbol* _tmp19_;
			GIdlModule* _tmp20_;
			_tmp18_ = node;
			_tmp19_ = container;
			_tmp20_ = module;
			vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) _tmp18_, _tmp19_, _tmp20_);
		} else {
			GIdlNode* _tmp21_;
			GIdlNodeTypeId _tmp22_;
			_tmp21_ = node;
			_tmp22_ = _tmp21_->type;
			if (_tmp22_ == G_IDL_NODE_UNION) {
				GIdlNode* _tmp23_;
				ValaSymbol* _tmp24_;
				GIdlModule* _tmp25_;
				_tmp23_ = node;
				_tmp24_ = container;
				_tmp25_ = module;
				vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) _tmp23_, _tmp24_, _tmp25_);
			} else {
				GIdlNode* _tmp26_;
				GIdlNodeTypeId _tmp27_;
				_tmp26_ = node;
				_tmp27_ = _tmp26_->type;
				if (_tmp27_ == G_IDL_NODE_BOXED) {
					GIdlNode* _tmp28_;
					ValaSymbol* _tmp29_;
					GIdlModule* _tmp30_;
					_tmp28_ = node;
					_tmp29_ = container;
					_tmp30_ = module;
					vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) _tmp28_, _tmp29_, _tmp30_);
				} else {
					GIdlNode* _tmp31_;
					GIdlNodeTypeId _tmp32_;
					_tmp31_ = node;
					_tmp32_ = _tmp31_->type;
					if (_tmp32_ == G_IDL_NODE_ENUM) {
						GIdlNode* _tmp33_;
						ValaSymbol* _tmp34_;
						GIdlModule* _tmp35_;
						_tmp33_ = node;
						_tmp34_ = container;
						_tmp35_ = module;
						vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) _tmp33_, _tmp34_, _tmp35_, FALSE);
					} else {
						GIdlNode* _tmp36_;
						GIdlNodeTypeId _tmp37_;
						_tmp36_ = node;
						_tmp37_ = _tmp36_->type;
						if (_tmp37_ == G_IDL_NODE_FLAGS) {
							GIdlNode* _tmp38_;
							ValaSymbol* _tmp39_;
							GIdlModule* _tmp40_;
							_tmp38_ = node;
							_tmp39_ = container;
							_tmp40_ = module;
							vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) _tmp38_, _tmp39_, _tmp40_, TRUE);
						} else {
							GIdlNode* _tmp41_;
							GIdlNodeTypeId _tmp42_;
							_tmp41_ = node;
							_tmp42_ = _tmp41_->type;
							if (_tmp42_ == G_IDL_NODE_OBJECT) {
								GIdlNode* _tmp43_;
								ValaSymbol* _tmp44_;
								GIdlModule* _tmp45_;
								_tmp43_ = node;
								_tmp44_ = container;
								_tmp45_ = module;
								vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) _tmp43_, _tmp44_, _tmp45_);
							} else {
								GIdlNode* _tmp46_;
								GIdlNodeTypeId _tmp47_;
								_tmp46_ = node;
								_tmp47_ = _tmp46_->type;
								if (_tmp47_ == G_IDL_NODE_INTERFACE) {
									GIdlNode* _tmp48_;
									ValaSymbol* _tmp49_;
									GIdlModule* _tmp50_;
									_tmp48_ = node;
									_tmp49_ = container;
									_tmp50_ = module;
									vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) _tmp48_, _tmp49_, _tmp50_);
								} else {
									GIdlNode* _tmp51_;
									GIdlNodeTypeId _tmp52_;
									_tmp51_ = node;
									_tmp52_ = _tmp51_->type;
									if (_tmp52_ == G_IDL_NODE_CONSTANT) {
										GIdlNode* _tmp53_;
										ValaConstant* _tmp54_ = NULL;
										ValaConstant* c;
										ValaConstant* _tmp55_;
										_tmp53_ = node;
										_tmp54_ = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) _tmp53_);
										c = _tmp54_;
										_tmp55_ = c;
										if (_tmp55_ != NULL) {
											ValaConstant* _tmp56_;
											ValaConstant* _tmp57_;
											const gchar* _tmp58_;
											const gchar* _tmp59_;
											ValaSymbol* _tmp60_;
											gchar* _tmp61_ = NULL;
											gchar* _tmp62_;
											ValaSymbol* _tmp63_;
											ValaConstant* _tmp64_;
											ValaSourceFile* _tmp65_;
											ValaConstant* _tmp66_;
											_tmp56_ = c;
											_tmp57_ = c;
											_tmp58_ = vala_symbol_get_name ((ValaSymbol*) _tmp57_);
											_tmp59_ = _tmp58_;
											_tmp60_ = container;
											_tmp61_ = vala_gidl_parser_fix_const_name (self, _tmp59_, _tmp60_);
											_tmp62_ = _tmp61_;
											vala_symbol_set_name ((ValaSymbol*) _tmp56_, _tmp62_);
											_g_free0 (_tmp62_);
											_tmp63_ = container;
											_tmp64_ = c;
											vala_gidl_parser_add_symbol_to_container (self, _tmp63_, (ValaSymbol*) _tmp64_);
											_tmp65_ = self->priv->current_source_file;
											_tmp66_ = c;
											vala_source_file_add_node (_tmp65_, (ValaCodeNode*) _tmp66_);
										}
										_vala_code_node_unref0 (c);
									} else {
										GIdlNode* _tmp67_;
										GIdlNodeTypeId _tmp68_;
										_tmp67_ = node;
										_tmp68_ = _tmp67_->type;
										if (_tmp68_ == G_IDL_NODE_FUNCTION) {
											GIdlNode* _tmp69_;
											ValaMethod* _tmp70_ = NULL;
											ValaMethod* m;
											ValaMethod* _tmp71_;
											_tmp69_ = node;
											_tmp70_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp69_, FALSE);
											m = _tmp70_;
											_tmp71_ = m;
											if (_tmp71_ != NULL) {
												ValaMethod* _tmp72_;
												ValaSymbol* _tmp73_;
												ValaMethod* _tmp74_;
												ValaSourceFile* _tmp75_;
												ValaMethod* _tmp76_;
												_tmp72_ = m;
												vala_method_set_binding (_tmp72_, VALA_MEMBER_BINDING_STATIC);
												_tmp73_ = container;
												_tmp74_ = m;
												vala_gidl_parser_add_symbol_to_container (self, _tmp73_, (ValaSymbol*) _tmp74_);
												_tmp75_ = self->priv->current_source_file;
												_tmp76_ = m;
												vala_source_file_add_node (_tmp75_, (ValaCodeNode*) _tmp76_);
											}
											_vala_code_node_unref0 (m);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name) {
	ValaSymbol* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** path;
	gint path_length1;
	gint _path_size_;
	ValaNamespace* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* cp;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaCodeContext* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaNamespace* _tmp10_;
	ValaSymbol* cc;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	path = _tmp2_;
	path_length1 = _vala_array_length (_tmp1_);
	_path_size_ = path_length1;
	_tmp3_ = self->priv->current_namespace;
	_tmp4_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp3_);
	cp = _tmp4_;
	_tmp5_ = cp;
	_tmp6_ = vala_symbol_get_parent_symbol (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_root (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp7_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SYMBOL, ValaSymbol)) {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaSymbol* _tmp14_;
		_tmp11_ = cp;
		_tmp12_ = vala_symbol_get_parent_symbol (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (cp);
		cp = _tmp14_;
	}
	cc = NULL;
	_tmp15_ = path;
	_tmp15__length1 = path_length1;
	{
		gchar** tok_collection = NULL;
		gint tok_collection_length1 = 0;
		gint _tok_collection_size_ = 0;
		gint tok_it = 0;
		tok_collection = _tmp15_;
		tok_collection_length1 = _tmp15__length1;
		for (tok_it = 0; tok_it < _tmp15__length1; tok_it = tok_it + 1) {
			const gchar* tok = NULL;
			tok = tok_collection[tok_it];
			{
				ValaSymbol* _tmp16_;
				ValaScope* _tmp17_;
				ValaScope* _tmp18_;
				const gchar* _tmp19_;
				ValaSymbol* _tmp20_ = NULL;
				ValaSymbol* _tmp21_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				_tmp16_ = cp;
				_tmp17_ = vala_symbol_get_scope (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = tok;
				_tmp20_ = vala_scope_lookup (_tmp18_, _tmp19_);
				_vala_code_node_unref0 (cc);
				cc = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) _tmp20_) : NULL;
				_tmp21_ = cc;
				if (_tmp21_ == NULL) {
					const gchar* _tmp22_;
					ValaSourceReference* _tmp23_;
					ValaNamespace* _tmp24_;
					ValaSymbol* _tmp25_;
					ValaSymbol* _tmp26_;
					_tmp22_ = tok;
					_tmp23_ = self->priv->current_source_reference;
					_tmp24_ = vala_namespace_new (_tmp22_, _tmp23_);
					_vala_code_node_unref0 (cc);
					cc = (ValaSymbol*) _tmp24_;
					_tmp25_ = cp;
					_tmp26_ = cc;
					vala_gidl_parser_add_symbol_to_container (self, _tmp25_, _tmp26_);
				}
				_tmp27_ = cc;
				_tmp28_ = _vala_code_node_ref0 (_tmp27_);
				_vala_code_node_unref0 (cp);
				cp = _tmp28_;
			}
		}
	}
	result = cc;
	_vala_code_node_unref0 (cp);
	path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module) {
	ValaNamespace* result = NULL;
	ValaCodeContext* _tmp0_;
	ValaNamespace* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	GIdlModule* _tmp5_;
	const gchar* _tmp6_;
	ValaSymbol* _tmp7_ = NULL;
	ValaSymbol* sym;
	ValaNamespace* ns = NULL;
	ValaSymbol* _tmp8_;
	ValaNamespace* _tmp21_;
	ValaNamespace* _tmp22_;
	ValaNamespace* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gint _tmp26_ = 0;
	gchar** _tmp27_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	GEqualFunc _tmp109_;
	ValaArrayList* _tmp110_;
	ValaArrayList* deferred;
	GIdlModule* _tmp111_;
	GList* _tmp112_;
	ValaSymbol* _tmp167_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = module;
	_tmp6_ = _tmp5_->name;
	_tmp7_ = vala_scope_lookup (_tmp4_, _tmp6_);
	sym = _tmp7_;
	_tmp8_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp9_;
		ValaNamespace* _tmp10_;
		ValaNamespace* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = sym;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp10_;
		_tmp11_ = ns;
		_tmp12_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			ValaNamespace* _tmp14_;
			ValaNamespace* _tmp15_;
			ValaSourceReference* _tmp16_;
			_tmp14_ = ns;
			__g_list_free__vala_code_node_unref0_0 (((ValaCodeNode*) _tmp14_)->attributes);
			((ValaCodeNode*) _tmp14_)->attributes = NULL;
			_tmp15_ = ns;
			_tmp16_ = self->priv->current_source_reference;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp15_, _tmp16_);
		}
	} else {
		GIdlModule* _tmp17_;
		const gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaNamespace* _tmp20_;
		_tmp17_ = module;
		_tmp18_ = _tmp17_->name;
		_tmp19_ = self->priv->current_source_reference;
		_tmp20_ = vala_namespace_new (_tmp18_, _tmp19_);
		_vala_code_node_unref0 (ns);
		ns = _tmp20_;
	}
	_tmp21_ = ns;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp22_;
	_tmp23_ = ns;
	_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp27_ = vala_gidl_parser_get_attributes (self, _tmp25_, &_tmp26_);
	attributes = _tmp27_;
	attributes_length1 = _tmp26_;
	_attributes_size_ = attributes_length1;
	_tmp28_ = attributes;
	_tmp28__length1 = attributes_length1;
	if (_tmp28_ != NULL) {
		gchar** _tmp29_;
		gint _tmp29__length1;
		_tmp29_ = attributes;
		_tmp29__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp29_;
			attr_collection_length1 = _tmp29__length1;
			for (attr_it = 0; attr_it < _tmp29__length1; attr_it = attr_it + 1) {
				gchar* _tmp30_;
				gchar* attr = NULL;
				_tmp30_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp30_;
				{
					const gchar* _tmp31_;
					gchar** _tmp32_;
					gchar** _tmp33_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp34_;
					gint _tmp34__length1;
					const gchar* _tmp35_;
					_tmp31_ = attr;
					_tmp33_ = _tmp32_ = g_strsplit (_tmp31_, "=", 2);
					nv = _tmp33_;
					nv_length1 = _vala_array_length (_tmp32_);
					_nv_size_ = nv_length1;
					_tmp34_ = nv;
					_tmp34__length1 = nv_length1;
					_tmp35_ = _tmp34_[0];
					if (g_strcmp0 (_tmp35_, "cheader_filename") == 0) {
						ValaNamespace* _tmp36_;
						gchar** _tmp37_;
						gint _tmp37__length1;
						const gchar* _tmp38_;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_;
						_tmp36_ = ns;
						_tmp37_ = nv;
						_tmp37__length1 = nv_length1;
						_tmp38_ = _tmp37_[1];
						_tmp39_ = vala_gidl_parser_eval (self, _tmp38_);
						_tmp40_ = _tmp39_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp36_, "CCode", "cheader_filename", _tmp40_, NULL);
						_g_free0 (_tmp40_);
					} else {
						gchar** _tmp41_;
						gint _tmp41__length1;
						const gchar* _tmp42_;
						_tmp41_ = nv;
						_tmp41__length1 = nv_length1;
						_tmp42_ = _tmp41_[0];
						if (g_strcmp0 (_tmp42_, "cprefix") == 0) {
							ValaNamespace* _tmp43_;
							gchar** _tmp44_;
							gint _tmp44__length1;
							const gchar* _tmp45_;
							gchar* _tmp46_ = NULL;
							gchar* _tmp47_;
							_tmp43_ = ns;
							_tmp44_ = nv;
							_tmp44__length1 = nv_length1;
							_tmp45_ = _tmp44_[1];
							_tmp46_ = vala_gidl_parser_eval (self, _tmp45_);
							_tmp47_ = _tmp46_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp43_, "CCode", "cprefix", _tmp47_, NULL);
							_g_free0 (_tmp47_);
						} else {
							gchar** _tmp48_;
							gint _tmp48__length1;
							const gchar* _tmp49_;
							_tmp48_ = nv;
							_tmp48__length1 = nv_length1;
							_tmp49_ = _tmp48_[0];
							if (g_strcmp0 (_tmp49_, "lower_case_cprefix") == 0) {
								ValaNamespace* _tmp50_;
								gchar** _tmp51_;
								gint _tmp51__length1;
								const gchar* _tmp52_;
								gchar* _tmp53_ = NULL;
								gchar* _tmp54_;
								_tmp50_ = ns;
								_tmp51_ = nv;
								_tmp51__length1 = nv_length1;
								_tmp52_ = _tmp51_[1];
								_tmp53_ = vala_gidl_parser_eval (self, _tmp52_);
								_tmp54_ = _tmp53_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp50_, "CCode", "lower_case_cprefix", _tmp54_, NULL);
								_g_free0 (_tmp54_);
							} else {
								gchar** _tmp55_;
								gint _tmp55__length1;
								const gchar* _tmp56_;
								_tmp55_ = nv;
								_tmp55__length1 = nv_length1;
								_tmp56_ = _tmp55_[0];
								if (g_strcmp0 (_tmp56_, "gir_namespace") == 0) {
									ValaNamespace* _tmp57_;
									ValaSourceReference* _tmp58_;
									ValaSourceReference* _tmp59_;
									ValaSourceFile* _tmp60_;
									ValaSourceFile* _tmp61_;
									gchar** _tmp62_;
									gint _tmp62__length1;
									const gchar* _tmp63_;
									gchar* _tmp64_ = NULL;
									gchar* _tmp65_;
									ValaNamespace* _tmp66_;
									gchar** _tmp67_;
									gint _tmp67__length1;
									const gchar* _tmp68_;
									gchar* _tmp69_ = NULL;
									gchar* _tmp70_;
									_tmp57_ = ns;
									_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
									_tmp59_ = _tmp58_;
									_tmp60_ = vala_source_reference_get_file (_tmp59_);
									_tmp61_ = _tmp60_;
									_tmp62_ = nv;
									_tmp62__length1 = nv_length1;
									_tmp63_ = _tmp62_[1];
									_tmp64_ = vala_gidl_parser_eval (self, _tmp63_);
									_tmp65_ = _tmp64_;
									vala_source_file_set_gir_namespace (_tmp61_, _tmp65_);
									_g_free0 (_tmp65_);
									_tmp66_ = ns;
									_tmp67_ = nv;
									_tmp67__length1 = nv_length1;
									_tmp68_ = _tmp67_[1];
									_tmp69_ = vala_gidl_parser_eval (self, _tmp68_);
									_tmp70_ = _tmp69_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp66_, "CCode", "gir_namespace", _tmp70_, NULL);
									_g_free0 (_tmp70_);
								} else {
									gchar** _tmp71_;
									gint _tmp71__length1;
									const gchar* _tmp72_;
									_tmp71_ = nv;
									_tmp71__length1 = nv_length1;
									_tmp72_ = _tmp71_[0];
									if (g_strcmp0 (_tmp72_, "gir_version") == 0) {
										ValaNamespace* _tmp73_;
										ValaSourceReference* _tmp74_;
										ValaSourceReference* _tmp75_;
										ValaSourceFile* _tmp76_;
										ValaSourceFile* _tmp77_;
										gchar** _tmp78_;
										gint _tmp78__length1;
										const gchar* _tmp79_;
										gchar* _tmp80_ = NULL;
										gchar* _tmp81_;
										ValaNamespace* _tmp82_;
										gchar** _tmp83_;
										gint _tmp83__length1;
										const gchar* _tmp84_;
										gchar* _tmp85_ = NULL;
										gchar* _tmp86_;
										_tmp73_ = ns;
										_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
										_tmp75_ = _tmp74_;
										_tmp76_ = vala_source_reference_get_file (_tmp75_);
										_tmp77_ = _tmp76_;
										_tmp78_ = nv;
										_tmp78__length1 = nv_length1;
										_tmp79_ = _tmp78_[1];
										_tmp80_ = vala_gidl_parser_eval (self, _tmp79_);
										_tmp81_ = _tmp80_;
										vala_source_file_set_gir_version (_tmp77_, _tmp81_);
										_g_free0 (_tmp81_);
										_tmp82_ = ns;
										_tmp83_ = nv;
										_tmp83__length1 = nv_length1;
										_tmp84_ = _tmp83_[1];
										_tmp85_ = vala_gidl_parser_eval (self, _tmp84_);
										_tmp86_ = _tmp85_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp82_, "CCode", "gir_version", _tmp86_, NULL);
										_g_free0 (_tmp86_);
									} else {
										gchar** _tmp87_;
										gint _tmp87__length1;
										const gchar* _tmp88_;
										_tmp87_ = nv;
										_tmp87__length1 = nv_length1;
										_tmp88_ = _tmp87_[0];
										if (g_strcmp0 (_tmp88_, "deprecated") == 0) {
											gchar** _tmp89_;
											gint _tmp89__length1;
											const gchar* _tmp90_;
											gchar* _tmp91_ = NULL;
											gchar* _tmp92_;
											gboolean _tmp93_;
											_tmp89_ = nv;
											_tmp89__length1 = nv_length1;
											_tmp90_ = _tmp89_[1];
											_tmp91_ = vala_gidl_parser_eval (self, _tmp90_);
											_tmp92_ = _tmp91_;
											_tmp93_ = g_strcmp0 (_tmp92_, "1") == 0;
											_g_free0 (_tmp92_);
											if (_tmp93_) {
												ValaNamespace* _tmp94_;
												_tmp94_ = ns;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp94_, "Deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp95_;
											gint _tmp95__length1;
											const gchar* _tmp96_;
											_tmp95_ = nv;
											_tmp95__length1 = nv_length1;
											_tmp96_ = _tmp95_[0];
											if (g_strcmp0 (_tmp96_, "replacement") == 0) {
												ValaNamespace* _tmp97_;
												gchar** _tmp98_;
												gint _tmp98__length1;
												const gchar* _tmp99_;
												gchar* _tmp100_ = NULL;
												gchar* _tmp101_;
												_tmp97_ = ns;
												_tmp98_ = nv;
												_tmp98__length1 = nv_length1;
												_tmp99_ = _tmp98_[1];
												_tmp100_ = vala_gidl_parser_eval (self, _tmp99_);
												_tmp101_ = _tmp100_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp97_, "Deprecated", "replacement", _tmp101_, NULL);
												_g_free0 (_tmp101_);
											} else {
												gchar** _tmp102_;
												gint _tmp102__length1;
												const gchar* _tmp103_;
												_tmp102_ = nv;
												_tmp102__length1 = nv_length1;
												_tmp103_ = _tmp102_[0];
												if (g_strcmp0 (_tmp103_, "deprecated_since") == 0) {
													ValaNamespace* _tmp104_;
													gchar** _tmp105_;
													gint _tmp105__length1;
													const gchar* _tmp106_;
													gchar* _tmp107_ = NULL;
													gchar* _tmp108_;
													_tmp104_ = ns;
													_tmp105_ = nv;
													_tmp105__length1 = nv_length1;
													_tmp106_ = _tmp105_[1];
													_tmp107_ = vala_gidl_parser_eval (self, _tmp106_);
													_tmp108_ = _tmp107_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp104_, "Deprecated", "since", _tmp108_, NULL);
													_g_free0 (_tmp108_);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp109_ = g_direct_equal;
	_tmp110_ = vala_array_list_new (G_TYPE_POINTER, NULL, NULL, _tmp109_);
	deferred = _tmp110_;
	_tmp111_ = module;
	_tmp112_ = _tmp111_->entries;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp112_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node = NULL;
			node = (GIdlNode*) node_it->data;
			{
				gboolean is_deferred;
				GIdlNode* _tmp113_;
				gint _tmp114_ = 0;
				gchar** _tmp115_ = NULL;
				gchar** child_attributes;
				gint child_attributes_length1;
				gint _child_attributes_size_;
				gchar** _tmp116_;
				gint _tmp116__length1;
				gboolean _tmp125_;
				is_deferred = FALSE;
				_tmp113_ = node;
				_tmp115_ = vala_gidl_parser_get_attributes_for_node (self, _tmp113_, &_tmp114_);
				child_attributes = _tmp115_;
				child_attributes_length1 = _tmp114_;
				_child_attributes_size_ = child_attributes_length1;
				_tmp116_ = child_attributes;
				_tmp116__length1 = child_attributes_length1;
				if (_tmp116_ != NULL) {
					gchar** _tmp117_;
					gint _tmp117__length1;
					_tmp117_ = child_attributes;
					_tmp117__length1 = child_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp117_;
						attr_collection_length1 = _tmp117__length1;
						for (attr_it = 0; attr_it < _tmp117__length1; attr_it = attr_it + 1) {
							const gchar* attr = NULL;
							attr = attr_collection[attr_it];
							{
								const gchar* _tmp118_;
								gchar** _tmp119_;
								gchar** _tmp120_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp121_;
								gint _tmp121__length1;
								const gchar* _tmp122_;
								_tmp118_ = attr;
								_tmp120_ = _tmp119_ = g_strsplit (_tmp118_, "=", 2);
								nv = _tmp120_;
								nv_length1 = _vala_array_length (_tmp119_);
								_nv_size_ = nv_length1;
								_tmp121_ = nv;
								_tmp121__length1 = nv_length1;
								_tmp122_ = _tmp121_[0];
								if (g_strcmp0 (_tmp122_, "parent") == 0) {
									ValaArrayList* _tmp123_;
									GIdlNode* _tmp124_;
									_tmp123_ = deferred;
									_tmp124_ = node;
									vala_collection_add ((ValaCollection*) _tmp123_, _tmp124_);
									is_deferred = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
				_tmp125_ = is_deferred;
				if (!_tmp125_) {
					GIdlNode* _tmp126_;
					GIdlModule* _tmp127_;
					ValaNamespace* _tmp128_;
					_tmp126_ = node;
					_tmp127_ = module;
					_tmp128_ = ns;
					vala_gidl_parser_parse_node (self, _tmp126_, _tmp127_, (ValaSymbol*) _tmp128_);
				}
				child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	{
		ValaArrayList* _tmp129_;
		ValaArrayList* _tmp130_;
		ValaArrayList* _node_list;
		ValaArrayList* _tmp131_;
		gint _tmp132_;
		gint _tmp133_;
		gint _node_size;
		gint _node_index;
		_tmp129_ = deferred;
		_tmp130_ = _vala_iterable_ref0 (_tmp129_);
		_node_list = _tmp130_;
		_tmp131_ = _node_list;
		_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
		_tmp133_ = _tmp132_;
		_node_size = _tmp133_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp134_;
			gint _tmp135_;
			gint _tmp136_;
			ValaArrayList* _tmp137_;
			gint _tmp138_;
			gpointer _tmp139_ = NULL;
			GIdlNode* node;
			ValaNamespace* _tmp140_;
			ValaSymbol* _tmp141_;
			ValaSymbol* container;
			GIdlNode* _tmp142_;
			gint _tmp143_ = 0;
			gchar** _tmp144_ = NULL;
			gchar** child_attributes;
			gint child_attributes_length1;
			gint _child_attributes_size_;
			gchar** _tmp145_;
			gint _tmp145__length1;
			ValaSymbol* _tmp157_;
			GIdlNode* _tmp162_;
			GIdlModule* _tmp163_;
			ValaSymbol* _tmp164_;
			ValaNamespace* _tmp165_;
			ValaNamespace* _tmp166_;
			_tmp134_ = _node_index;
			_node_index = _tmp134_ + 1;
			_tmp135_ = _node_index;
			_tmp136_ = _node_size;
			if (!(_tmp135_ < _tmp136_)) {
				break;
			}
			_tmp137_ = _node_list;
			_tmp138_ = _node_index;
			_tmp139_ = vala_list_get ((ValaList*) _tmp137_, _tmp138_);
			node = (GIdlNode*) _tmp139_;
			_tmp140_ = ns;
			_tmp141_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp140_);
			container = _tmp141_;
			_tmp142_ = node;
			_tmp144_ = vala_gidl_parser_get_attributes_for_node (self, _tmp142_, &_tmp143_);
			child_attributes = _tmp144_;
			child_attributes_length1 = _tmp143_;
			_child_attributes_size_ = child_attributes_length1;
			_tmp145_ = child_attributes;
			_tmp145__length1 = child_attributes_length1;
			if (_tmp145_ != NULL) {
				gchar** _tmp146_;
				gint _tmp146__length1;
				_tmp146_ = child_attributes;
				_tmp146__length1 = child_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp146_;
					attr_collection_length1 = _tmp146__length1;
					for (attr_it = 0; attr_it < _tmp146__length1; attr_it = attr_it + 1) {
						const gchar* attr = NULL;
						attr = attr_collection[attr_it];
						{
							const gchar* _tmp147_;
							gchar** _tmp148_;
							gchar** _tmp149_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp150_;
							gint _tmp150__length1;
							const gchar* _tmp151_;
							_tmp147_ = attr;
							_tmp149_ = _tmp148_ = g_strsplit (_tmp147_, "=", 2);
							nv = _tmp149_;
							nv_length1 = _vala_array_length (_tmp148_);
							_nv_size_ = nv_length1;
							_tmp150_ = nv;
							_tmp150__length1 = nv_length1;
							_tmp151_ = _tmp150_[0];
							if (g_strcmp0 (_tmp151_, "parent") == 0) {
								gchar** _tmp152_;
								gint _tmp152__length1;
								const gchar* _tmp153_;
								gchar* _tmp154_ = NULL;
								gchar* _tmp155_;
								ValaSymbol* _tmp156_ = NULL;
								_tmp152_ = nv;
								_tmp152__length1 = nv_length1;
								_tmp153_ = _tmp152_[1];
								_tmp154_ = vala_gidl_parser_eval (self, _tmp153_);
								_tmp155_ = _tmp154_;
								_tmp156_ = vala_gidl_parser_get_container_from_name (self, _tmp155_);
								_vala_code_node_unref0 (container);
								container = _tmp156_;
								_g_free0 (_tmp155_);
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			_tmp157_ = container;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp157_, VALA_TYPE_NAMESPACE)) {
				ValaSymbol* _tmp158_;
				ValaNamespace* _tmp159_;
				_tmp158_ = container;
				_tmp159_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_NAMESPACE, ValaNamespace));
				_vala_code_node_unref0 (self->priv->current_namespace);
				self->priv->current_namespace = _tmp159_;
			} else {
				ValaSymbol* _tmp160_;
				ValaTypeSymbol* _tmp161_;
				_tmp160_ = container;
				_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (self->priv->current_data_type);
				self->priv->current_data_type = _tmp161_;
			}
			_tmp162_ = node;
			_tmp163_ = module;
			_tmp164_ = container;
			vala_gidl_parser_parse_node (self, _tmp162_, _tmp163_, _tmp164_);
			_tmp165_ = ns;
			_tmp166_ = _vala_code_node_ref0 (_tmp165_);
			_vala_code_node_unref0 (self->priv->current_namespace);
			self->priv->current_namespace = _tmp166_;
			_vala_code_node_unref0 (self->priv->current_data_type);
			self->priv->current_data_type = NULL;
			child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (container);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = NULL;
	_tmp167_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp167_, VALA_TYPE_NAMESPACE)) {
		result = NULL;
		_vala_iterable_unref0 (deferred);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (ns);
		_vala_code_node_unref0 (sym);
		return result;
	}
	result = ns;
	_vala_iterable_unref0 (deferred);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (sym);
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node) {
	ValaDelegate* result = NULL;
	GIdlNodeFunction* _tmp0_;
	GIdlNode* node;
	GIdlNodeFunction* _tmp1_;
	GIdlNodeParam* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* return_type;
	GIdlNode* _tmp4_;
	const gchar* _tmp5_;
	ValaDataType* _tmp6_;
	ValaSourceReference* _tmp7_;
	ValaDelegate* _tmp8_;
	ValaDelegate* cb;
	ValaDelegate* _tmp9_;
	ValaDelegate* _tmp10_;
	gboolean check_has_target;
	gboolean suppress_throws;
	gchar* error_types;
	GIdlNode* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GIdlNodeFunction* _tmp161_;
	GList* _tmp162_;
	guint _tmp163_ = 0U;
	guint remaining_params;
	GIdlNodeFunction* _tmp164_;
	GList* _tmp165_;
	gboolean _tmp352_ = FALSE;
	gboolean _tmp353_;
	gboolean _tmp355_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	_tmp0_ = f_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = f_node;
	_tmp2_ = _tmp1_->result;
	_tmp3_ = vala_gidl_parser_parse_param (self, _tmp2_, NULL);
	return_type = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = return_type;
	_tmp7_ = self->priv->current_source_reference;
	_tmp8_ = vala_delegate_new (_tmp5_, _tmp6_, _tmp7_, NULL);
	cb = _tmp8_;
	_tmp9_ = cb;
	vala_symbol_set_access ((ValaSymbol*) _tmp9_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp10_ = cb;
	vala_delegate_set_has_target (_tmp10_, FALSE);
	check_has_target = TRUE;
	suppress_throws = FALSE;
	error_types = NULL;
	_tmp11_ = node;
	_tmp12_ = _tmp11_->name;
	_tmp14_ = vala_gidl_parser_get_attributes (self, _tmp12_, &_tmp13_);
	attributes = _tmp14_;
	attributes_length1 = _tmp13_;
	_attributes_size_ = attributes_length1;
	_tmp15_ = attributes;
	_tmp15__length1 = attributes_length1;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = attributes;
		_tmp16__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp16_;
			attr_collection_length1 = _tmp16__length1;
			for (attr_it = 0; attr_it < _tmp16__length1; attr_it = attr_it + 1) {
				gchar* _tmp17_;
				gchar* attr = NULL;
				_tmp17_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp17_;
				{
					const gchar* _tmp18_;
					gchar** _tmp19_;
					gchar** _tmp20_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					_tmp18_ = attr;
					_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
					nv = _tmp20_;
					nv_length1 = _vala_array_length (_tmp19_);
					_nv_size_ = nv_length1;
					_tmp21_ = nv;
					_tmp21__length1 = nv_length1;
					_tmp22_ = _tmp21_[0];
					if (g_strcmp0 (_tmp22_, "hidden") == 0) {
						gchar** _tmp23_;
						gint _tmp23__length1;
						const gchar* _tmp24_;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_;
						gboolean _tmp27_;
						_tmp23_ = nv;
						_tmp23__length1 = nv_length1;
						_tmp24_ = _tmp23_[1];
						_tmp25_ = vala_gidl_parser_eval (self, _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strcmp0 (_tmp26_, "1") == 0;
						_g_free0 (_tmp26_);
						if (_tmp27_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (error_types);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (return_type);
							return result;
						}
					} else {
						gchar** _tmp28_;
						gint _tmp28__length1;
						const gchar* _tmp29_;
						_tmp28_ = nv;
						_tmp28__length1 = nv_length1;
						_tmp29_ = _tmp28_[0];
						if (g_strcmp0 (_tmp29_, "cheader_filename") == 0) {
							ValaDelegate* _tmp30_;
							gchar** _tmp31_;
							gint _tmp31__length1;
							const gchar* _tmp32_;
							gchar* _tmp33_ = NULL;
							gchar* _tmp34_;
							_tmp30_ = cb;
							_tmp31_ = nv;
							_tmp31__length1 = nv_length1;
							_tmp32_ = _tmp31_[1];
							_tmp33_ = vala_gidl_parser_eval (self, _tmp32_);
							_tmp34_ = _tmp33_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp30_, "CCode", "cheader_filename", _tmp34_, NULL);
							_g_free0 (_tmp34_);
						} else {
							gchar** _tmp35_;
							gint _tmp35__length1;
							const gchar* _tmp36_;
							_tmp35_ = nv;
							_tmp35__length1 = nv_length1;
							_tmp36_ = _tmp35_[0];
							if (g_strcmp0 (_tmp36_, "has_target") == 0) {
								gchar** _tmp37_;
								gint _tmp37__length1;
								const gchar* _tmp38_;
								gchar* _tmp39_ = NULL;
								gchar* _tmp40_;
								gboolean _tmp41_;
								_tmp37_ = nv;
								_tmp37__length1 = nv_length1;
								_tmp38_ = _tmp37_[1];
								_tmp39_ = vala_gidl_parser_eval (self, _tmp38_);
								_tmp40_ = _tmp39_;
								_tmp41_ = g_strcmp0 (_tmp40_, "0") == 0;
								_g_free0 (_tmp40_);
								if (_tmp41_) {
									check_has_target = FALSE;
								} else {
									gchar** _tmp42_;
									gint _tmp42__length1;
									const gchar* _tmp43_;
									gchar* _tmp44_ = NULL;
									gchar* _tmp45_;
									gboolean _tmp46_;
									_tmp42_ = nv;
									_tmp42__length1 = nv_length1;
									_tmp43_ = _tmp42_[1];
									_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
									_tmp45_ = _tmp44_;
									_tmp46_ = g_strcmp0 (_tmp45_, "1") == 0;
									_g_free0 (_tmp45_);
									if (_tmp46_) {
										ValaDelegate* _tmp47_;
										_tmp47_ = cb;
										vala_delegate_set_has_target (_tmp47_, TRUE);
									}
								}
							} else {
								gchar** _tmp48_;
								gint _tmp48__length1;
								const gchar* _tmp49_;
								_tmp48_ = nv;
								_tmp48__length1 = nv_length1;
								_tmp49_ = _tmp48_[0];
								if (g_strcmp0 (_tmp49_, "transfer_ownership") == 0) {
									gchar** _tmp50_;
									gint _tmp50__length1;
									const gchar* _tmp51_;
									gchar* _tmp52_ = NULL;
									gchar* _tmp53_;
									gboolean _tmp54_;
									_tmp50_ = nv;
									_tmp50__length1 = nv_length1;
									_tmp51_ = _tmp50_[1];
									_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
									_tmp53_ = _tmp52_;
									_tmp54_ = g_strcmp0 (_tmp53_, "1") == 0;
									_g_free0 (_tmp53_);
									if (_tmp54_) {
										ValaDataType* _tmp55_;
										_tmp55_ = return_type;
										vala_data_type_set_value_owned (_tmp55_, TRUE);
									}
								} else {
									gchar** _tmp56_;
									gint _tmp56__length1;
									const gchar* _tmp57_;
									_tmp56_ = nv;
									_tmp56__length1 = nv_length1;
									_tmp57_ = _tmp56_[0];
									if (g_strcmp0 (_tmp57_, "is_array") == 0) {
										gchar** _tmp58_;
										gint _tmp58__length1;
										const gchar* _tmp59_;
										gchar* _tmp60_ = NULL;
										gchar* _tmp61_;
										gboolean _tmp62_;
										_tmp58_ = nv;
										_tmp58__length1 = nv_length1;
										_tmp59_ = _tmp58_[1];
										_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
										_tmp61_ = _tmp60_;
										_tmp62_ = g_strcmp0 (_tmp61_, "1") == 0;
										_g_free0 (_tmp61_);
										if (_tmp62_) {
											ValaDataType* _tmp63_;
											ValaDataType* _tmp64_;
											ValaSourceReference* _tmp65_;
											ValaSourceReference* _tmp66_;
											ValaArrayType* _tmp67_;
											ValaDelegate* _tmp68_;
											ValaDataType* _tmp69_;
											_tmp63_ = return_type;
											_tmp64_ = return_type;
											_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
											_tmp66_ = _tmp65_;
											_tmp67_ = vala_array_type_new (_tmp63_, 1, _tmp66_);
											_vala_code_node_unref0 (return_type);
											return_type = (ValaDataType*) _tmp67_;
											_tmp68_ = cb;
											_tmp69_ = return_type;
											vala_delegate_set_return_type (_tmp68_, _tmp69_);
										}
									} else {
										gchar** _tmp70_;
										gint _tmp70__length1;
										const gchar* _tmp71_;
										_tmp70_ = nv;
										_tmp70__length1 = nv_length1;
										_tmp71_ = _tmp70_[0];
										if (g_strcmp0 (_tmp71_, "throws") == 0) {
											gchar** _tmp72_;
											gint _tmp72__length1;
											const gchar* _tmp73_;
											gchar* _tmp74_ = NULL;
											gchar* _tmp75_;
											gboolean _tmp76_;
											_tmp72_ = nv;
											_tmp72__length1 = nv_length1;
											_tmp73_ = _tmp72_[1];
											_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
											_tmp75_ = _tmp74_;
											_tmp76_ = g_strcmp0 (_tmp75_, "0") == 0;
											_g_free0 (_tmp75_);
											if (_tmp76_) {
												suppress_throws = TRUE;
											}
										} else {
											gchar** _tmp77_;
											gint _tmp77__length1;
											const gchar* _tmp78_;
											_tmp77_ = nv;
											_tmp77__length1 = nv_length1;
											_tmp78_ = _tmp77_[0];
											if (g_strcmp0 (_tmp78_, "error_types") == 0) {
												gchar** _tmp79_;
												gint _tmp79__length1;
												const gchar* _tmp80_;
												gchar* _tmp81_ = NULL;
												_tmp79_ = nv;
												_tmp79__length1 = nv_length1;
												_tmp80_ = _tmp79_[1];
												_tmp81_ = vala_gidl_parser_eval (self, _tmp80_);
												_g_free0 (error_types);
												error_types = _tmp81_;
											} else {
												gchar** _tmp82_;
												gint _tmp82__length1;
												const gchar* _tmp83_;
												_tmp82_ = nv;
												_tmp82__length1 = nv_length1;
												_tmp83_ = _tmp82_[0];
												if (g_strcmp0 (_tmp83_, "array_length_type") == 0) {
													ValaDelegate* _tmp84_;
													gchar** _tmp85_;
													gint _tmp85__length1;
													const gchar* _tmp86_;
													gchar* _tmp87_ = NULL;
													gchar* _tmp88_;
													_tmp84_ = cb;
													_tmp85_ = nv;
													_tmp85__length1 = nv_length1;
													_tmp86_ = _tmp85_[1];
													_tmp87_ = vala_gidl_parser_eval (self, _tmp86_);
													_tmp88_ = _tmp87_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp84_, "CCode", "array_length_type", _tmp88_, NULL);
													_g_free0 (_tmp88_);
												} else {
													gchar** _tmp89_;
													gint _tmp89__length1;
													const gchar* _tmp90_;
													_tmp89_ = nv;
													_tmp89__length1 = nv_length1;
													_tmp90_ = _tmp89_[0];
													if (g_strcmp0 (_tmp90_, "type_name") == 0) {
														ValaDelegate* _tmp91_;
														gchar** _tmp92_;
														gint _tmp92__length1;
														const gchar* _tmp93_;
														gchar* _tmp94_ = NULL;
														gchar* _tmp95_;
														ValaDataType* _tmp96_;
														gboolean _tmp97_;
														gboolean _tmp98_;
														ValaDataType* _tmp99_ = NULL;
														ValaDataType* _tmp100_;
														_tmp91_ = cb;
														_tmp92_ = nv;
														_tmp92__length1 = nv_length1;
														_tmp93_ = _tmp92_[1];
														_tmp94_ = vala_gidl_parser_eval (self, _tmp93_);
														_tmp95_ = _tmp94_;
														_tmp96_ = return_type;
														_tmp97_ = vala_data_type_get_value_owned (_tmp96_);
														_tmp98_ = _tmp97_;
														_tmp99_ = vala_gidl_parser_parse_type_from_string (self, _tmp95_, _tmp98_, NULL);
														_vala_code_node_unref0 (return_type);
														return_type = _tmp99_;
														_tmp100_ = return_type;
														vala_delegate_set_return_type (_tmp91_, _tmp100_);
														_g_free0 (_tmp95_);
													} else {
														gchar** _tmp101_;
														gint _tmp101__length1;
														const gchar* _tmp102_;
														_tmp101_ = nv;
														_tmp101__length1 = nv_length1;
														_tmp102_ = _tmp101_[0];
														if (g_strcmp0 (_tmp102_, "deprecated") == 0) {
															gchar** _tmp103_;
															gint _tmp103__length1;
															const gchar* _tmp104_;
															gchar* _tmp105_ = NULL;
															gchar* _tmp106_;
															gboolean _tmp107_;
															_tmp103_ = nv;
															_tmp103__length1 = nv_length1;
															_tmp104_ = _tmp103_[1];
															_tmp105_ = vala_gidl_parser_eval (self, _tmp104_);
															_tmp106_ = _tmp105_;
															_tmp107_ = g_strcmp0 (_tmp106_, "1") == 0;
															_g_free0 (_tmp106_);
															if (_tmp107_) {
																ValaDelegate* _tmp108_;
																_tmp108_ = cb;
																vala_code_node_set_attribute ((ValaCodeNode*) _tmp108_, "Deprecated", TRUE, NULL);
															}
														} else {
															gchar** _tmp109_;
															gint _tmp109__length1;
															const gchar* _tmp110_;
															_tmp109_ = nv;
															_tmp109__length1 = nv_length1;
															_tmp110_ = _tmp109_[0];
															if (g_strcmp0 (_tmp110_, "replacement") == 0) {
																ValaDelegate* _tmp111_;
																gchar** _tmp112_;
																gint _tmp112__length1;
																const gchar* _tmp113_;
																gchar* _tmp114_ = NULL;
																gchar* _tmp115_;
																_tmp111_ = cb;
																_tmp112_ = nv;
																_tmp112__length1 = nv_length1;
																_tmp113_ = _tmp112_[1];
																_tmp114_ = vala_gidl_parser_eval (self, _tmp113_);
																_tmp115_ = _tmp114_;
																vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp111_, "Deprecated", "replacement", _tmp115_, NULL);
																_g_free0 (_tmp115_);
															} else {
																gchar** _tmp116_;
																gint _tmp116__length1;
																const gchar* _tmp117_;
																_tmp116_ = nv;
																_tmp116__length1 = nv_length1;
																_tmp117_ = _tmp116_[0];
																if (g_strcmp0 (_tmp117_, "deprecated_since") == 0) {
																	ValaDelegate* _tmp118_;
																	gchar** _tmp119_;
																	gint _tmp119__length1;
																	const gchar* _tmp120_;
																	gchar* _tmp121_ = NULL;
																	gchar* _tmp122_;
																	_tmp118_ = cb;
																	_tmp119_ = nv;
																	_tmp119__length1 = nv_length1;
																	_tmp120_ = _tmp119_[1];
																	_tmp121_ = vala_gidl_parser_eval (self, _tmp120_);
																	_tmp122_ = _tmp121_;
																	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp118_, "Deprecated", "since", _tmp122_, NULL);
																	_g_free0 (_tmp122_);
																} else {
																	gchar** _tmp123_;
																	gint _tmp123__length1;
																	const gchar* _tmp124_;
																	_tmp123_ = nv;
																	_tmp123__length1 = nv_length1;
																	_tmp124_ = _tmp123_[0];
																	if (g_strcmp0 (_tmp124_, "type_arguments") == 0) {
																		ValaDataType* _tmp125_;
																		gchar** _tmp126_;
																		gint _tmp126__length1;
																		const gchar* _tmp127_;
																		gchar* _tmp128_ = NULL;
																		gchar* _tmp129_;
																		_tmp125_ = return_type;
																		_tmp126_ = nv;
																		_tmp126__length1 = nv_length1;
																		_tmp127_ = _tmp126_[1];
																		_tmp128_ = vala_gidl_parser_eval (self, _tmp127_);
																		_tmp129_ = _tmp128_;
																		vala_gidl_parser_parse_type_arguments_from_string (self, _tmp125_, _tmp129_, NULL);
																		_g_free0 (_tmp129_);
																	} else {
																		gchar** _tmp130_;
																		gint _tmp130__length1;
																		const gchar* _tmp131_;
																		_tmp130_ = nv;
																		_tmp130__length1 = nv_length1;
																		_tmp131_ = _tmp130_[0];
																		if (g_strcmp0 (_tmp131_, "instance_pos") == 0) {
																			ValaDelegate* _tmp132_;
																			gchar** _tmp133_;
																			gint _tmp133__length1;
																			const gchar* _tmp134_;
																			gchar* _tmp135_ = NULL;
																			gchar* _tmp136_;
																			gdouble _tmp137_ = 0.0;
																			_tmp132_ = cb;
																			_tmp133_ = nv;
																			_tmp133__length1 = nv_length1;
																			_tmp134_ = _tmp133_[1];
																			_tmp135_ = vala_gidl_parser_eval (self, _tmp134_);
																			_tmp136_ = _tmp135_;
																			_tmp137_ = double_parse (_tmp136_);
																			vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp132_, "CCode", "instance_pos", _tmp137_, NULL);
																			_g_free0 (_tmp136_);
																		} else {
																			gchar** _tmp138_;
																			gint _tmp138__length1;
																			const gchar* _tmp139_;
																			_tmp138_ = nv;
																			_tmp138__length1 = nv_length1;
																			_tmp139_ = _tmp138_[0];
																			if (g_strcmp0 (_tmp139_, "type_parameters") == 0) {
																				gchar** _tmp140_;
																				gint _tmp140__length1;
																				const gchar* _tmp141_;
																				gchar* _tmp142_ = NULL;
																				gchar* _tmp143_;
																				gchar** _tmp144_;
																				gchar** _tmp145_ = NULL;
																				gchar** _tmp146_;
																				gint _tmp146__length1;
																				_tmp140_ = nv;
																				_tmp140__length1 = nv_length1;
																				_tmp141_ = _tmp140_[1];
																				_tmp142_ = vala_gidl_parser_eval (self, _tmp141_);
																				_tmp143_ = _tmp142_;
																				_tmp145_ = _tmp144_ = g_strsplit (_tmp143_, ",", 0);
																				_tmp146_ = _tmp145_;
																				_tmp146__length1 = _vala_array_length (_tmp144_);
																				_g_free0 (_tmp143_);
																				{
																					gchar** type_param_name_collection = NULL;
																					gint type_param_name_collection_length1 = 0;
																					gint _type_param_name_collection_size_ = 0;
																					gint type_param_name_it = 0;
																					type_param_name_collection = _tmp146_;
																					type_param_name_collection_length1 = _tmp146__length1;
																					for (type_param_name_it = 0; type_param_name_it < _tmp146__length1; type_param_name_it = type_param_name_it + 1) {
																						gchar* _tmp147_;
																						gchar* type_param_name = NULL;
																						_tmp147_ = g_strdup (type_param_name_collection[type_param_name_it]);
																						type_param_name = _tmp147_;
																						{
																							ValaDelegate* _tmp148_;
																							const gchar* _tmp149_;
																							ValaSourceReference* _tmp150_;
																							ValaTypeParameter* _tmp151_;
																							ValaTypeParameter* _tmp152_;
																							_tmp148_ = cb;
																							_tmp149_ = type_param_name;
																							_tmp150_ = self->priv->current_source_reference;
																							_tmp151_ = vala_typeparameter_new (_tmp149_, _tmp150_);
																							_tmp152_ = _tmp151_;
																							vala_delegate_add_type_parameter (_tmp148_, _tmp152_);
																							_vala_code_node_unref0 (_tmp152_);
																							_g_free0 (type_param_name);
																						}
																					}
																					type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																				}
																			} else {
																				gchar** _tmp153_;
																				gint _tmp153__length1;
																				const gchar* _tmp154_;
																				_tmp153_ = nv;
																				_tmp153__length1 = nv_length1;
																				_tmp154_ = _tmp153_[0];
																				if (g_strcmp0 (_tmp154_, "experimental") == 0) {
																					gchar** _tmp155_;
																					gint _tmp155__length1;
																					const gchar* _tmp156_;
																					gchar* _tmp157_ = NULL;
																					gchar* _tmp158_;
																					gboolean _tmp159_;
																					_tmp155_ = nv;
																					_tmp155__length1 = nv_length1;
																					_tmp156_ = _tmp155_[1];
																					_tmp157_ = vala_gidl_parser_eval (self, _tmp156_);
																					_tmp158_ = _tmp157_;
																					_tmp159_ = g_strcmp0 (_tmp158_, "1") == 0;
																					_g_free0 (_tmp158_);
																					if (_tmp159_) {
																						ValaDelegate* _tmp160_;
																						_tmp160_ = cb;
																						vala_code_node_set_attribute ((ValaCodeNode*) _tmp160_, "Experimental", TRUE, NULL);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp161_ = f_node;
	_tmp162_ = _tmp161_->parameters;
	_tmp163_ = g_list_length (_tmp162_);
	remaining_params = _tmp163_;
	_tmp164_ = f_node;
	_tmp165_ = _tmp164_->parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp165_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNodeParam* _tmp166_;
				GIdlNode* param_node;
				gboolean _tmp167_ = FALSE;
				gboolean _tmp168_ = FALSE;
				gboolean _tmp169_;
				gboolean _tmp171_;
				gboolean _tmp178_;
				guint _tmp351_;
				_tmp166_ = param;
				param_node = (GIdlNode*) _tmp166_;
				_tmp169_ = check_has_target;
				if (_tmp169_) {
					guint _tmp170_;
					_tmp170_ = remaining_params;
					_tmp168_ = _tmp170_ == ((guint) 1);
				} else {
					_tmp168_ = FALSE;
				}
				_tmp171_ = _tmp168_;
				if (_tmp171_) {
					gboolean _tmp172_ = FALSE;
					GIdlNode* _tmp173_;
					const gchar* _tmp174_;
					gboolean _tmp177_;
					_tmp173_ = param_node;
					_tmp174_ = _tmp173_->name;
					if (g_strcmp0 (_tmp174_, "user_data") == 0) {
						_tmp172_ = TRUE;
					} else {
						GIdlNode* _tmp175_;
						const gchar* _tmp176_;
						_tmp175_ = param_node;
						_tmp176_ = _tmp175_->name;
						_tmp172_ = g_strcmp0 (_tmp176_, "data") == 0;
					}
					_tmp177_ = _tmp172_;
					_tmp167_ = _tmp177_;
				} else {
					_tmp167_ = FALSE;
				}
				_tmp178_ = _tmp167_;
				if (_tmp178_) {
					ValaDelegate* _tmp179_;
					_tmp179_ = cb;
					vala_delegate_set_has_target (_tmp179_, TRUE);
				} else {
					gboolean _tmp180_ = FALSE;
					gboolean _tmp181_;
					gboolean _tmp184_;
					GIdlNode* _tmp192_;
					const gchar* _tmp193_;
					gchar* _tmp194_;
					gchar* param_name;
					const gchar* _tmp195_;
					ValaParameterDirection direction = 0;
					GIdlNodeParam* _tmp199_;
					ValaParameterDirection _tmp200_ = 0;
					ValaDataType* _tmp201_ = NULL;
					ValaDataType* param_type;
					const gchar* _tmp202_;
					ValaDataType* _tmp203_;
					ValaParameter* _tmp204_;
					ValaParameter* p;
					ValaParameter* _tmp205_;
					ValaParameterDirection _tmp206_;
					gboolean hide_param;
					gboolean show_param;
					gboolean array_requested;
					gboolean out_requested;
					GIdlNode* _tmp207_;
					const gchar* _tmp208_;
					GIdlNode* _tmp209_;
					const gchar* _tmp210_;
					gchar* _tmp211_ = NULL;
					gchar* _tmp212_;
					gint _tmp213_ = 0;
					gchar** _tmp214_ = NULL;
					gchar** _tmp215_;
					gint _tmp215__length1;
					gboolean _tmp345_ = FALSE;
					gboolean _tmp346_;
					gboolean _tmp348_;
					_tmp181_ = suppress_throws;
					if (_tmp181_ == FALSE) {
						GIdlNodeParam* _tmp182_;
						gboolean _tmp183_ = FALSE;
						_tmp182_ = param;
						_tmp183_ = vala_gidl_parser_param_is_exception (self, _tmp182_);
						_tmp180_ = _tmp183_;
					} else {
						_tmp180_ = FALSE;
					}
					_tmp184_ = _tmp180_;
					if (_tmp184_) {
						const gchar* _tmp185_;
						guint _tmp191_;
						_tmp185_ = error_types;
						if (_tmp185_ == NULL) {
							ValaDelegate* _tmp186_;
							GIdlNodeParam* _tmp187_;
							GIdlNodeType* _tmp188_;
							ValaDataType* _tmp189_ = NULL;
							ValaDataType* _tmp190_;
							_tmp186_ = cb;
							_tmp187_ = param;
							_tmp188_ = _tmp187_->type;
							_tmp189_ = vala_gidl_parser_parse_type (self, _tmp188_, NULL);
							_tmp190_ = _tmp189_;
							vala_code_node_add_error_type ((ValaCodeNode*) _tmp186_, _tmp190_);
							_vala_code_node_unref0 (_tmp190_);
						}
						_tmp191_ = remaining_params;
						remaining_params = _tmp191_ - 1;
						continue;
					}
					_tmp192_ = param_node;
					_tmp193_ = _tmp192_->name;
					_tmp194_ = g_strdup (_tmp193_);
					param_name = _tmp194_;
					_tmp195_ = param_name;
					if (g_strcmp0 (_tmp195_, "string") == 0) {
						gchar* _tmp196_;
						_tmp196_ = g_strdup ("str");
						_g_free0 (param_name);
						param_name = _tmp196_;
					} else {
						const gchar* _tmp197_;
						_tmp197_ = param_name;
						if (g_strcmp0 (_tmp197_, "self") == 0) {
							gchar* _tmp198_;
							_tmp198_ = g_strdup ("_self");
							_g_free0 (param_name);
							param_name = _tmp198_;
						}
					}
					_tmp199_ = param;
					_tmp201_ = vala_gidl_parser_parse_param (self, _tmp199_, &_tmp200_);
					direction = _tmp200_;
					param_type = _tmp201_;
					_tmp202_ = param_name;
					_tmp203_ = param_type;
					_tmp204_ = vala_parameter_new (_tmp202_, _tmp203_, NULL);
					p = _tmp204_;
					_tmp205_ = p;
					_tmp206_ = direction;
					vala_parameter_set_direction (_tmp205_, _tmp206_);
					hide_param = FALSE;
					show_param = FALSE;
					array_requested = FALSE;
					out_requested = FALSE;
					_tmp207_ = node;
					_tmp208_ = _tmp207_->name;
					_tmp209_ = param_node;
					_tmp210_ = _tmp209_->name;
					_tmp211_ = g_strdup_printf ("%s.%s", _tmp208_, _tmp210_);
					_tmp212_ = _tmp211_;
					_tmp214_ = vala_gidl_parser_get_attributes (self, _tmp212_, &_tmp213_);
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					attributes = _tmp214_;
					attributes_length1 = _tmp213_;
					_attributes_size_ = attributes_length1;
					_g_free0 (_tmp212_);
					_tmp215_ = attributes;
					_tmp215__length1 = attributes_length1;
					if (_tmp215_ != NULL) {
						gchar** _tmp216_;
						gint _tmp216__length1;
						_tmp216_ = attributes;
						_tmp216__length1 = attributes_length1;
						{
							gchar** attr_collection = NULL;
							gint attr_collection_length1 = 0;
							gint _attr_collection_size_ = 0;
							gint attr_it = 0;
							attr_collection = _tmp216_;
							attr_collection_length1 = _tmp216__length1;
							for (attr_it = 0; attr_it < _tmp216__length1; attr_it = attr_it + 1) {
								gchar* _tmp217_;
								gchar* attr = NULL;
								_tmp217_ = g_strdup (attr_collection[attr_it]);
								attr = _tmp217_;
								{
									const gchar* _tmp218_;
									gchar** _tmp219_;
									gchar** _tmp220_ = NULL;
									gchar** nv;
									gint nv_length1;
									gint _nv_size_;
									gchar** _tmp221_;
									gint _tmp221__length1;
									const gchar* _tmp222_;
									_tmp218_ = attr;
									_tmp220_ = _tmp219_ = g_strsplit (_tmp218_, "=", 2);
									nv = _tmp220_;
									nv_length1 = _vala_array_length (_tmp219_);
									_nv_size_ = nv_length1;
									_tmp221_ = nv;
									_tmp221__length1 = nv_length1;
									_tmp222_ = _tmp221_[0];
									if (g_strcmp0 (_tmp222_, "hidden") == 0) {
										gchar** _tmp223_;
										gint _tmp223__length1;
										const gchar* _tmp224_;
										gchar* _tmp225_ = NULL;
										gchar* _tmp226_;
										gboolean _tmp227_;
										_tmp223_ = nv;
										_tmp223__length1 = nv_length1;
										_tmp224_ = _tmp223_[1];
										_tmp225_ = vala_gidl_parser_eval (self, _tmp224_);
										_tmp226_ = _tmp225_;
										_tmp227_ = g_strcmp0 (_tmp226_, "1") == 0;
										_g_free0 (_tmp226_);
										if (_tmp227_) {
											hide_param = TRUE;
										} else {
											gchar** _tmp228_;
											gint _tmp228__length1;
											const gchar* _tmp229_;
											gchar* _tmp230_ = NULL;
											gchar* _tmp231_;
											gboolean _tmp232_;
											_tmp228_ = nv;
											_tmp228__length1 = nv_length1;
											_tmp229_ = _tmp228_[1];
											_tmp230_ = vala_gidl_parser_eval (self, _tmp229_);
											_tmp231_ = _tmp230_;
											_tmp232_ = g_strcmp0 (_tmp231_, "0") == 0;
											_g_free0 (_tmp231_);
											if (_tmp232_) {
												show_param = TRUE;
											}
										}
									} else {
										gchar** _tmp233_;
										gint _tmp233__length1;
										const gchar* _tmp234_;
										_tmp233_ = nv;
										_tmp233__length1 = nv_length1;
										_tmp234_ = _tmp233_[0];
										if (g_strcmp0 (_tmp234_, "is_array") == 0) {
											gchar** _tmp235_;
											gint _tmp235__length1;
											const gchar* _tmp236_;
											gchar* _tmp237_ = NULL;
											gchar* _tmp238_;
											gboolean _tmp239_;
											_tmp235_ = nv;
											_tmp235__length1 = nv_length1;
											_tmp236_ = _tmp235_[1];
											_tmp237_ = vala_gidl_parser_eval (self, _tmp236_);
											_tmp238_ = _tmp237_;
											_tmp239_ = g_strcmp0 (_tmp238_, "1") == 0;
											_g_free0 (_tmp238_);
											if (_tmp239_) {
												ValaDataType* _tmp240_;
												ValaDataType* _tmp241_;
												ValaSourceReference* _tmp242_;
												ValaSourceReference* _tmp243_;
												ValaArrayType* _tmp244_;
												ValaParameter* _tmp245_;
												ValaDataType* _tmp246_;
												gboolean _tmp247_;
												_tmp240_ = param_type;
												_tmp241_ = param_type;
												_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp241_);
												_tmp243_ = _tmp242_;
												_tmp244_ = vala_array_type_new (_tmp240_, 1, _tmp243_);
												_vala_code_node_unref0 (param_type);
												param_type = (ValaDataType*) _tmp244_;
												_tmp245_ = p;
												_tmp246_ = param_type;
												vala_variable_set_variable_type ((ValaVariable*) _tmp245_, _tmp246_);
												_tmp247_ = out_requested;
												if (!_tmp247_) {
													ValaParameter* _tmp248_;
													_tmp248_ = p;
													vala_parameter_set_direction (_tmp248_, VALA_PARAMETER_DIRECTION_IN);
												}
												array_requested = TRUE;
											}
										} else {
											gchar** _tmp249_;
											gint _tmp249__length1;
											const gchar* _tmp250_;
											_tmp249_ = nv;
											_tmp249__length1 = nv_length1;
											_tmp250_ = _tmp249_[0];
											if (g_strcmp0 (_tmp250_, "is_out") == 0) {
												gchar** _tmp251_;
												gint _tmp251__length1;
												const gchar* _tmp252_;
												gchar* _tmp253_ = NULL;
												gchar* _tmp254_;
												gboolean _tmp255_;
												_tmp251_ = nv;
												_tmp251__length1 = nv_length1;
												_tmp252_ = _tmp251_[1];
												_tmp253_ = vala_gidl_parser_eval (self, _tmp252_);
												_tmp254_ = _tmp253_;
												_tmp255_ = g_strcmp0 (_tmp254_, "1") == 0;
												_g_free0 (_tmp254_);
												if (_tmp255_) {
													ValaParameter* _tmp256_;
													gboolean _tmp257_ = FALSE;
													gboolean _tmp258_;
													gboolean _tmp260_;
													_tmp256_ = p;
													vala_parameter_set_direction (_tmp256_, VALA_PARAMETER_DIRECTION_OUT);
													out_requested = TRUE;
													_tmp258_ = array_requested;
													if (!_tmp258_) {
														ValaDataType* _tmp259_;
														_tmp259_ = param_type;
														_tmp257_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp259_, VALA_TYPE_ARRAY_TYPE);
													} else {
														_tmp257_ = FALSE;
													}
													_tmp260_ = _tmp257_;
													if (_tmp260_) {
														ValaDataType* _tmp261_;
														ValaArrayType* _tmp262_;
														ValaArrayType* array_type;
														ValaArrayType* _tmp263_;
														ValaDataType* _tmp264_;
														ValaDataType* _tmp265_;
														ValaDataType* _tmp266_;
														ValaParameter* _tmp267_;
														ValaDataType* _tmp268_;
														_tmp261_ = param_type;
														_tmp262_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp261_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
														array_type = _tmp262_;
														_tmp263_ = array_type;
														_tmp264_ = vala_array_type_get_element_type (_tmp263_);
														_tmp265_ = _tmp264_;
														_tmp266_ = _vala_code_node_ref0 (_tmp265_);
														_vala_code_node_unref0 (param_type);
														param_type = _tmp266_;
														_tmp267_ = p;
														_tmp268_ = param_type;
														vala_variable_set_variable_type ((ValaVariable*) _tmp267_, _tmp268_);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												gchar** _tmp269_;
												gint _tmp269__length1;
												const gchar* _tmp270_;
												_tmp269_ = nv;
												_tmp269__length1 = nv_length1;
												_tmp270_ = _tmp269_[0];
												if (g_strcmp0 (_tmp270_, "is_ref") == 0) {
													gchar** _tmp271_;
													gint _tmp271__length1;
													const gchar* _tmp272_;
													gchar* _tmp273_ = NULL;
													gchar* _tmp274_;
													gboolean _tmp275_;
													_tmp271_ = nv;
													_tmp271__length1 = nv_length1;
													_tmp272_ = _tmp271_[1];
													_tmp273_ = vala_gidl_parser_eval (self, _tmp272_);
													_tmp274_ = _tmp273_;
													_tmp275_ = g_strcmp0 (_tmp274_, "1") == 0;
													_g_free0 (_tmp274_);
													if (_tmp275_) {
														ValaParameter* _tmp276_;
														gboolean _tmp277_ = FALSE;
														gboolean _tmp278_;
														gboolean _tmp280_;
														_tmp276_ = p;
														vala_parameter_set_direction (_tmp276_, VALA_PARAMETER_DIRECTION_REF);
														_tmp278_ = array_requested;
														if (!_tmp278_) {
															ValaDataType* _tmp279_;
															_tmp279_ = param_type;
															_tmp277_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp279_, VALA_TYPE_ARRAY_TYPE);
														} else {
															_tmp277_ = FALSE;
														}
														_tmp280_ = _tmp277_;
														if (_tmp280_) {
															ValaDataType* _tmp281_;
															ValaArrayType* _tmp282_;
															ValaArrayType* array_type;
															ValaArrayType* _tmp283_;
															ValaDataType* _tmp284_;
															ValaDataType* _tmp285_;
															ValaDataType* _tmp286_;
															ValaParameter* _tmp287_;
															ValaDataType* _tmp288_;
															_tmp281_ = param_type;
															_tmp282_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp281_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
															array_type = _tmp282_;
															_tmp283_ = array_type;
															_tmp284_ = vala_array_type_get_element_type (_tmp283_);
															_tmp285_ = _tmp284_;
															_tmp286_ = _vala_code_node_ref0 (_tmp285_);
															_vala_code_node_unref0 (param_type);
															param_type = _tmp286_;
															_tmp287_ = p;
															_tmp288_ = param_type;
															vala_variable_set_variable_type ((ValaVariable*) _tmp287_, _tmp288_);
															_vala_code_node_unref0 (array_type);
														}
													}
												} else {
													gchar** _tmp289_;
													gint _tmp289__length1;
													const gchar* _tmp290_;
													_tmp289_ = nv;
													_tmp289__length1 = nv_length1;
													_tmp290_ = _tmp289_[0];
													if (g_strcmp0 (_tmp290_, "takes_ownership") == 0) {
														gchar** _tmp291_;
														gint _tmp291__length1;
														const gchar* _tmp292_;
														gchar* _tmp293_ = NULL;
														gchar* _tmp294_;
														gboolean _tmp295_;
														_tmp291_ = nv;
														_tmp291__length1 = nv_length1;
														_tmp292_ = _tmp291_[1];
														_tmp293_ = vala_gidl_parser_eval (self, _tmp292_);
														_tmp294_ = _tmp293_;
														_tmp295_ = g_strcmp0 (_tmp294_, "1") == 0;
														_g_free0 (_tmp294_);
														if (_tmp295_) {
															ValaDataType* _tmp296_;
															_tmp296_ = param_type;
															vala_data_type_set_value_owned (_tmp296_, TRUE);
														}
													} else {
														gchar** _tmp297_;
														gint _tmp297__length1;
														const gchar* _tmp298_;
														_tmp297_ = nv;
														_tmp297__length1 = nv_length1;
														_tmp298_ = _tmp297_[0];
														if (g_strcmp0 (_tmp298_, "nullable") == 0) {
															gchar** _tmp299_;
															gint _tmp299__length1;
															const gchar* _tmp300_;
															gchar* _tmp301_ = NULL;
															gchar* _tmp302_;
															gboolean _tmp303_;
															_tmp299_ = nv;
															_tmp299__length1 = nv_length1;
															_tmp300_ = _tmp299_[1];
															_tmp301_ = vala_gidl_parser_eval (self, _tmp300_);
															_tmp302_ = _tmp301_;
															_tmp303_ = g_strcmp0 (_tmp302_, "1") == 0;
															_g_free0 (_tmp302_);
															if (_tmp303_) {
																ValaDataType* _tmp304_;
																_tmp304_ = param_type;
																vala_data_type_set_nullable (_tmp304_, TRUE);
															}
														} else {
															gchar** _tmp305_;
															gint _tmp305__length1;
															const gchar* _tmp306_;
															_tmp305_ = nv;
															_tmp305__length1 = nv_length1;
															_tmp306_ = _tmp305_[0];
															if (g_strcmp0 (_tmp306_, "type_arguments") == 0) {
																ValaDataType* _tmp307_;
																gchar** _tmp308_;
																gint _tmp308__length1;
																const gchar* _tmp309_;
																gchar* _tmp310_ = NULL;
																gchar* _tmp311_;
																_tmp307_ = param_type;
																_tmp308_ = nv;
																_tmp308__length1 = nv_length1;
																_tmp309_ = _tmp308_[1];
																_tmp310_ = vala_gidl_parser_eval (self, _tmp309_);
																_tmp311_ = _tmp310_;
																vala_gidl_parser_parse_type_arguments_from_string (self, _tmp307_, _tmp311_, NULL);
																_g_free0 (_tmp311_);
															} else {
																gchar** _tmp312_;
																gint _tmp312__length1;
																const gchar* _tmp313_;
																_tmp312_ = nv;
																_tmp312__length1 = nv_length1;
																_tmp313_ = _tmp312_[0];
																if (g_strcmp0 (_tmp313_, "no_array_length") == 0) {
																	gchar** _tmp314_;
																	gint _tmp314__length1;
																	const gchar* _tmp315_;
																	gchar* _tmp316_ = NULL;
																	gchar* _tmp317_;
																	gboolean _tmp318_;
																	_tmp314_ = nv;
																	_tmp314__length1 = nv_length1;
																	_tmp315_ = _tmp314_[1];
																	_tmp316_ = vala_gidl_parser_eval (self, _tmp315_);
																	_tmp317_ = _tmp316_;
																	_tmp318_ = g_strcmp0 (_tmp317_, "1") == 0;
																	_g_free0 (_tmp317_);
																	if (_tmp318_) {
																		ValaParameter* _tmp319_;
																		_tmp319_ = p;
																		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp319_, "CCode", "array_length", FALSE, NULL);
																	}
																} else {
																	gchar** _tmp320_;
																	gint _tmp320__length1;
																	const gchar* _tmp321_;
																	_tmp320_ = nv;
																	_tmp320__length1 = nv_length1;
																	_tmp321_ = _tmp320_[0];
																	if (g_strcmp0 (_tmp321_, "array_length_type") == 0) {
																		ValaParameter* _tmp322_;
																		gchar** _tmp323_;
																		gint _tmp323__length1;
																		const gchar* _tmp324_;
																		gchar* _tmp325_ = NULL;
																		gchar* _tmp326_;
																		_tmp322_ = p;
																		_tmp323_ = nv;
																		_tmp323__length1 = nv_length1;
																		_tmp324_ = _tmp323_[1];
																		_tmp325_ = vala_gidl_parser_eval (self, _tmp324_);
																		_tmp326_ = _tmp325_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp322_, "CCode", "array_length_type", _tmp326_, NULL);
																		_g_free0 (_tmp326_);
																	} else {
																		gchar** _tmp327_;
																		gint _tmp327__length1;
																		const gchar* _tmp328_;
																		_tmp327_ = nv;
																		_tmp327__length1 = nv_length1;
																		_tmp328_ = _tmp327_[0];
																		if (g_strcmp0 (_tmp328_, "array_null_terminated") == 0) {
																			gchar** _tmp329_;
																			gint _tmp329__length1;
																			const gchar* _tmp330_;
																			gchar* _tmp331_ = NULL;
																			gchar* _tmp332_;
																			gboolean _tmp333_;
																			_tmp329_ = nv;
																			_tmp329__length1 = nv_length1;
																			_tmp330_ = _tmp329_[1];
																			_tmp331_ = vala_gidl_parser_eval (self, _tmp330_);
																			_tmp332_ = _tmp331_;
																			_tmp333_ = g_strcmp0 (_tmp332_, "1") == 0;
																			_g_free0 (_tmp332_);
																			if (_tmp333_) {
																				ValaParameter* _tmp334_;
																				ValaParameter* _tmp335_;
																				_tmp334_ = p;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp334_, "CCode", "array_length", FALSE, NULL);
																				_tmp335_ = p;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp335_, "CCode", "array_null_terminated", TRUE, NULL);
																			}
																		} else {
																			gchar** _tmp336_;
																			gint _tmp336__length1;
																			const gchar* _tmp337_;
																			_tmp336_ = nv;
																			_tmp336__length1 = nv_length1;
																			_tmp337_ = _tmp336_[0];
																			if (g_strcmp0 (_tmp337_, "type_name") == 0) {
																				ValaParameter* _tmp338_;
																				gchar** _tmp339_;
																				gint _tmp339__length1;
																				const gchar* _tmp340_;
																				gchar* _tmp341_ = NULL;
																				gchar* _tmp342_;
																				ValaDataType* _tmp343_ = NULL;
																				ValaDataType* _tmp344_;
																				_tmp338_ = p;
																				_tmp339_ = nv;
																				_tmp339__length1 = nv_length1;
																				_tmp340_ = _tmp339_[1];
																				_tmp341_ = vala_gidl_parser_eval (self, _tmp340_);
																				_tmp342_ = _tmp341_;
																				_tmp343_ = vala_gidl_parser_parse_type_from_string (self, _tmp342_, FALSE, NULL);
																				_vala_code_node_unref0 (param_type);
																				param_type = _tmp343_;
																				_tmp344_ = param_type;
																				vala_variable_set_variable_type ((ValaVariable*) _tmp338_, _tmp344_);
																				_g_free0 (_tmp342_);
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
								}
							}
						}
					}
					_tmp346_ = show_param;
					if (_tmp346_) {
						_tmp345_ = TRUE;
					} else {
						gboolean _tmp347_;
						_tmp347_ = hide_param;
						_tmp345_ = !_tmp347_;
					}
					_tmp348_ = _tmp345_;
					if (_tmp348_) {
						ValaDelegate* _tmp349_;
						ValaParameter* _tmp350_;
						_tmp349_ = cb;
						_tmp350_ = p;
						vala_delegate_add_parameter (_tmp349_, _tmp350_);
					}
					_vala_code_node_unref0 (p);
					_vala_code_node_unref0 (param_type);
					_g_free0 (param_name);
				}
				_tmp351_ = remaining_params;
				remaining_params = _tmp351_ - 1;
			}
		}
	}
	_tmp353_ = suppress_throws;
	if (_tmp353_ == FALSE) {
		const gchar* _tmp354_;
		_tmp354_ = error_types;
		_tmp352_ = _tmp354_ != NULL;
	} else {
		_tmp352_ = FALSE;
	}
	_tmp355_ = _tmp352_;
	if (_tmp355_) {
		const gchar* _tmp356_;
		gchar* _tmp357_ = NULL;
		gchar* _tmp358_;
		gchar** _tmp359_;
		gchar** _tmp360_ = NULL;
		gchar** _tmp361_;
		gint _tmp361__length1;
		gchar** type_args;
		gint type_args_length1;
		gint _type_args_size_;
		gchar** _tmp362_;
		gint _tmp362__length1;
		_tmp356_ = error_types;
		_tmp357_ = vala_gidl_parser_eval (self, _tmp356_);
		_tmp358_ = _tmp357_;
		_tmp360_ = _tmp359_ = g_strsplit (_tmp358_, ",", 0);
		_tmp361_ = _tmp360_;
		_tmp361__length1 = _vala_array_length (_tmp359_);
		_g_free0 (_tmp358_);
		type_args = _tmp361_;
		type_args_length1 = _tmp361__length1;
		_type_args_size_ = type_args_length1;
		_tmp362_ = type_args;
		_tmp362__length1 = type_args_length1;
		{
			gchar** type_arg_collection = NULL;
			gint type_arg_collection_length1 = 0;
			gint _type_arg_collection_size_ = 0;
			gint type_arg_it = 0;
			type_arg_collection = _tmp362_;
			type_arg_collection_length1 = _tmp362__length1;
			for (type_arg_it = 0; type_arg_it < _tmp362__length1; type_arg_it = type_arg_it + 1) {
				gchar* _tmp363_;
				gchar* type_arg = NULL;
				_tmp363_ = g_strdup (type_arg_collection[type_arg_it]);
				type_arg = _tmp363_;
				{
					ValaDelegate* _tmp364_;
					const gchar* _tmp365_;
					ValaDataType* _tmp366_ = NULL;
					ValaDataType* _tmp367_;
					_tmp364_ = cb;
					_tmp365_ = type_arg;
					_tmp366_ = vala_gidl_parser_parse_type_from_string (self, _tmp365_, TRUE, NULL);
					_tmp367_ = _tmp366_;
					vala_code_node_add_error_type ((ValaCodeNode*) _tmp364_, _tmp367_);
					_vala_code_node_unref0 (_tmp367_);
					_g_free0 (type_arg);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	result = cb;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** st_attributes;
	gint st_attributes_length1;
	gint _st_attributes_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	_tmp0_ = cname;
	_tmp2_ = vala_gidl_parser_get_attributes (self, _tmp0_, &_tmp1_);
	st_attributes = _tmp2_;
	st_attributes_length1 = _tmp1_;
	_st_attributes_size_ = st_attributes_length1;
	_tmp3_ = st_attributes;
	_tmp3__length1 = st_attributes_length1;
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = st_attributes;
		_tmp4__length1 = st_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp4_;
			attr_collection_length1 = _tmp4__length1;
			for (attr_it = 0; attr_it < _tmp4__length1; attr_it = attr_it + 1) {
				gchar* _tmp5_;
				gchar* attr = NULL;
				_tmp5_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp5_;
				{
					const gchar* _tmp6_;
					gchar** _tmp7_;
					gchar** _tmp8_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gboolean _tmp9_ = FALSE;
					gchar** _tmp10_;
					gint _tmp10__length1;
					const gchar* _tmp11_;
					gboolean _tmp16_;
					_tmp6_ = attr;
					_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "=", 2);
					nv = _tmp8_;
					nv_length1 = _vala_array_length (_tmp7_);
					_nv_size_ = nv_length1;
					_tmp10_ = nv;
					_tmp10__length1 = nv_length1;
					_tmp11_ = _tmp10_[0];
					if (g_strcmp0 (_tmp11_, "is_value_type") == 0) {
						gchar** _tmp12_;
						gint _tmp12__length1;
						const gchar* _tmp13_;
						gchar* _tmp14_ = NULL;
						gchar* _tmp15_;
						_tmp12_ = nv;
						_tmp12__length1 = nv_length1;
						_tmp13_ = _tmp12_[1];
						_tmp14_ = vala_gidl_parser_eval (self, _tmp13_);
						_tmp15_ = _tmp14_;
						_tmp9_ = g_strcmp0 (_tmp15_, "1") == 0;
						_g_free0 (_tmp15_);
					} else {
						_tmp9_ = FALSE;
					}
					_tmp16_ = _tmp9_;
					if (_tmp16_) {
						result = FALSE;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNodeStruct* _tmp0_;
	GIdlNode* node;
	GIdlNodeStruct* _tmp1_;
	gboolean _tmp2_;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* name;
	GIdlNode* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = st_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = st_node;
	_tmp2_ = _tmp1_->deprecated;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = container;
	_tmp6_ = vala_gidl_parser_fix_type_name (self, _tmp4_, _tmp5_);
	name = _tmp6_;
	_tmp7_ = node;
	_tmp8_ = _tmp7_->name;
	_tmp9_ = vala_gidl_parser_is_reference_type (self, _tmp8_);
	if (!_tmp9_) {
		ValaSymbol* _tmp10_;
		ValaScope* _tmp11_;
		ValaScope* _tmp12_;
		const gchar* _tmp13_;
		ValaSymbol* _tmp14_ = NULL;
		ValaStruct* st;
		ValaStruct* _tmp15_;
		ValaStruct* _tmp142_;
		ValaTypeSymbol* _tmp143_;
		GIdlNodeStruct* _tmp144_;
		GList* _tmp145_;
		_tmp10_ = container;
		_tmp11_ = vala_symbol_get_scope (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = name;
		_tmp14_ = vala_scope_lookup (_tmp12_, _tmp13_);
		st = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp14_) : NULL;
		_tmp15_ = st;
		if (_tmp15_ == NULL) {
			const gchar* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaStruct* _tmp18_;
			ValaStruct* _tmp19_;
			GIdlNode* _tmp20_;
			const gchar* _tmp21_;
			gint _tmp22_ = 0;
			gchar** _tmp23_ = NULL;
			gchar** st_attributes;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			ValaSymbol* _tmp138_;
			ValaStruct* _tmp139_;
			ValaSourceFile* _tmp140_;
			ValaStruct* _tmp141_;
			_tmp16_ = name;
			_tmp17_ = self->priv->current_source_reference;
			_tmp18_ = vala_struct_new (_tmp16_, _tmp17_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp18_;
			_tmp19_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp19_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp20_ = node;
			_tmp21_ = _tmp20_->name;
			_tmp23_ = vala_gidl_parser_get_attributes (self, _tmp21_, &_tmp22_);
			st_attributes = _tmp23_;
			st_attributes_length1 = _tmp22_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp24_ = st_attributes;
			_tmp24__length1 = st_attributes_length1;
			if (_tmp24_ != NULL) {
				gchar** _tmp25_;
				gint _tmp25__length1;
				_tmp25_ = st_attributes;
				_tmp25__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp25_;
					attr_collection_length1 = _tmp25__length1;
					for (attr_it = 0; attr_it < _tmp25__length1; attr_it = attr_it + 1) {
						gchar* _tmp26_;
						gchar* attr = NULL;
						_tmp26_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp26_;
						{
							const gchar* _tmp27_;
							gchar** _tmp28_;
							gchar** _tmp29_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							_tmp27_ = attr;
							_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "=", 2);
							nv = _tmp29_;
							nv_length1 = _vala_array_length (_tmp28_);
							_nv_size_ = nv_length1;
							_tmp30_ = nv;
							_tmp30__length1 = nv_length1;
							_tmp31_ = _tmp30_[0];
							if (g_strcmp0 (_tmp31_, "cheader_filename") == 0) {
								ValaStruct* _tmp32_;
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_;
								_tmp32_ = st;
								_tmp33_ = nv;
								_tmp33__length1 = nv_length1;
								_tmp34_ = _tmp33_[1];
								_tmp35_ = vala_gidl_parser_eval (self, _tmp34_);
								_tmp36_ = _tmp35_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp32_, "CCode", "cheader_filename", _tmp36_, NULL);
								_g_free0 (_tmp36_);
							} else {
								gchar** _tmp37_;
								gint _tmp37__length1;
								const gchar* _tmp38_;
								_tmp37_ = nv;
								_tmp37__length1 = nv_length1;
								_tmp38_ = _tmp37_[0];
								if (g_strcmp0 (_tmp38_, "hidden") == 0) {
									gchar** _tmp39_;
									gint _tmp39__length1;
									const gchar* _tmp40_;
									gchar* _tmp41_ = NULL;
									gchar* _tmp42_;
									gboolean _tmp43_;
									_tmp39_ = nv;
									_tmp39__length1 = nv_length1;
									_tmp40_ = _tmp39_[1];
									_tmp41_ = vala_gidl_parser_eval (self, _tmp40_);
									_tmp42_ = _tmp41_;
									_tmp43_ = g_strcmp0 (_tmp42_, "1") == 0;
									_g_free0 (_tmp42_);
									if (_tmp43_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									gchar** _tmp44_;
									gint _tmp44__length1;
									const gchar* _tmp45_;
									_tmp44_ = nv;
									_tmp44__length1 = nv_length1;
									_tmp45_ = _tmp44_[0];
									if (g_strcmp0 (_tmp45_, "base_type") == 0) {
										ValaStruct* _tmp46_;
										gchar** _tmp47_;
										gint _tmp47__length1;
										const gchar* _tmp48_;
										gchar* _tmp49_ = NULL;
										gchar* _tmp50_;
										ValaDataType* _tmp51_ = NULL;
										ValaDataType* _tmp52_;
										_tmp46_ = st;
										_tmp47_ = nv;
										_tmp47__length1 = nv_length1;
										_tmp48_ = _tmp47_[1];
										_tmp49_ = vala_gidl_parser_eval (self, _tmp48_);
										_tmp50_ = _tmp49_;
										_tmp51_ = vala_gidl_parser_parse_type_string (self, _tmp50_);
										_tmp52_ = _tmp51_;
										vala_struct_set_base_type (_tmp46_, _tmp52_);
										_vala_code_node_unref0 (_tmp52_);
										_g_free0 (_tmp50_);
									} else {
										gchar** _tmp53_;
										gint _tmp53__length1;
										const gchar* _tmp54_;
										_tmp53_ = nv;
										_tmp53__length1 = nv_length1;
										_tmp54_ = _tmp53_[0];
										if (g_strcmp0 (_tmp54_, "rank") == 0) {
											ValaStruct* _tmp55_;
											gchar** _tmp56_;
											gint _tmp56__length1;
											const gchar* _tmp57_;
											gchar* _tmp58_ = NULL;
											gchar* _tmp59_;
											gint _tmp60_ = 0;
											_tmp55_ = st;
											_tmp56_ = nv;
											_tmp56__length1 = nv_length1;
											_tmp57_ = _tmp56_[1];
											_tmp58_ = vala_gidl_parser_eval (self, _tmp57_);
											_tmp59_ = _tmp58_;
											_tmp60_ = atoi (_tmp59_);
											vala_struct_set_rank (_tmp55_, _tmp60_);
											_g_free0 (_tmp59_);
										} else {
											gchar** _tmp61_;
											gint _tmp61__length1;
											const gchar* _tmp62_;
											_tmp61_ = nv;
											_tmp61__length1 = nv_length1;
											_tmp62_ = _tmp61_[0];
											if (g_strcmp0 (_tmp62_, "simple_type") == 0) {
												gchar** _tmp63_;
												gint _tmp63__length1;
												const gchar* _tmp64_;
												gchar* _tmp65_ = NULL;
												gchar* _tmp66_;
												gboolean _tmp67_;
												_tmp63_ = nv;
												_tmp63__length1 = nv_length1;
												_tmp64_ = _tmp63_[1];
												_tmp65_ = vala_gidl_parser_eval (self, _tmp64_);
												_tmp66_ = _tmp65_;
												_tmp67_ = g_strcmp0 (_tmp66_, "1") == 0;
												_g_free0 (_tmp66_);
												if (_tmp67_) {
													ValaStruct* _tmp68_;
													_tmp68_ = st;
													vala_struct_set_simple_type (_tmp68_, TRUE);
												}
											} else {
												gchar** _tmp69_;
												gint _tmp69__length1;
												const gchar* _tmp70_;
												_tmp69_ = nv;
												_tmp69__length1 = nv_length1;
												_tmp70_ = _tmp69_[0];
												if (g_strcmp0 (_tmp70_, "immutable") == 0) {
													gchar** _tmp71_;
													gint _tmp71__length1;
													const gchar* _tmp72_;
													gchar* _tmp73_ = NULL;
													gchar* _tmp74_;
													gboolean _tmp75_;
													_tmp71_ = nv;
													_tmp71__length1 = nv_length1;
													_tmp72_ = _tmp71_[1];
													_tmp73_ = vala_gidl_parser_eval (self, _tmp72_);
													_tmp74_ = _tmp73_;
													_tmp75_ = g_strcmp0 (_tmp74_, "1") == 0;
													_g_free0 (_tmp74_);
													if (_tmp75_) {
														ValaStruct* _tmp76_;
														_tmp76_ = st;
														vala_code_node_set_attribute ((ValaCodeNode*) _tmp76_, "Immutable", TRUE, NULL);
													}
												} else {
													gchar** _tmp77_;
													gint _tmp77__length1;
													const gchar* _tmp78_;
													_tmp77_ = nv;
													_tmp77__length1 = nv_length1;
													_tmp78_ = _tmp77_[0];
													if (g_strcmp0 (_tmp78_, "has_type_id") == 0) {
														gchar** _tmp79_;
														gint _tmp79__length1;
														const gchar* _tmp80_;
														gchar* _tmp81_ = NULL;
														gchar* _tmp82_;
														gboolean _tmp83_;
														_tmp79_ = nv;
														_tmp79__length1 = nv_length1;
														_tmp80_ = _tmp79_[1];
														_tmp81_ = vala_gidl_parser_eval (self, _tmp80_);
														_tmp82_ = _tmp81_;
														_tmp83_ = g_strcmp0 (_tmp82_, "0") == 0;
														_g_free0 (_tmp82_);
														if (_tmp83_) {
															ValaStruct* _tmp84_;
															_tmp84_ = st;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp84_, "CCode", "has_type_id", FALSE, NULL);
														}
													} else {
														gchar** _tmp85_;
														gint _tmp85__length1;
														const gchar* _tmp86_;
														_tmp85_ = nv;
														_tmp85__length1 = nv_length1;
														_tmp86_ = _tmp85_[0];
														if (g_strcmp0 (_tmp86_, "type_id") == 0) {
															ValaStruct* _tmp87_;
															gchar** _tmp88_;
															gint _tmp88__length1;
															const gchar* _tmp89_;
															gchar* _tmp90_ = NULL;
															gchar* _tmp91_;
															_tmp87_ = st;
															_tmp88_ = nv;
															_tmp88__length1 = nv_length1;
															_tmp89_ = _tmp88_[1];
															_tmp90_ = vala_gidl_parser_eval (self, _tmp89_);
															_tmp91_ = _tmp90_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp87_, "CCode", "type_id", _tmp91_, NULL);
															_g_free0 (_tmp91_);
														} else {
															gchar** _tmp92_;
															gint _tmp92__length1;
															const gchar* _tmp93_;
															_tmp92_ = nv;
															_tmp92__length1 = nv_length1;
															_tmp93_ = _tmp92_[0];
															if (g_strcmp0 (_tmp93_, "has_copy_function") == 0) {
																gchar** _tmp94_;
																gint _tmp94__length1;
																const gchar* _tmp95_;
																gchar* _tmp96_ = NULL;
																gchar* _tmp97_;
																gboolean _tmp98_;
																_tmp94_ = nv;
																_tmp94__length1 = nv_length1;
																_tmp95_ = _tmp94_[1];
																_tmp96_ = vala_gidl_parser_eval (self, _tmp95_);
																_tmp97_ = _tmp96_;
																_tmp98_ = g_strcmp0 (_tmp97_, "0") == 0;
																_g_free0 (_tmp97_);
																if (_tmp98_) {
																	ValaStruct* _tmp99_;
																	_tmp99_ = st;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp99_, "CCode", "has_copy_function", FALSE, NULL);
																}
															} else {
																gchar** _tmp100_;
																gint _tmp100__length1;
																const gchar* _tmp101_;
																_tmp100_ = nv;
																_tmp100__length1 = nv_length1;
																_tmp101_ = _tmp100_[0];
																if (g_strcmp0 (_tmp101_, "deprecated") == 0) {
																	gchar** _tmp102_;
																	gint _tmp102__length1;
																	const gchar* _tmp103_;
																	gchar* _tmp104_ = NULL;
																	gchar* _tmp105_;
																	gboolean _tmp106_;
																	_tmp102_ = nv;
																	_tmp102__length1 = nv_length1;
																	_tmp103_ = _tmp102_[1];
																	_tmp104_ = vala_gidl_parser_eval (self, _tmp103_);
																	_tmp105_ = _tmp104_;
																	_tmp106_ = g_strcmp0 (_tmp105_, "1") == 0;
																	_g_free0 (_tmp105_);
																	if (_tmp106_) {
																		ValaStruct* _tmp107_;
																		_tmp107_ = st;
																		vala_code_node_set_attribute ((ValaCodeNode*) _tmp107_, "Deprecated", TRUE, NULL);
																	}
																} else {
																	gchar** _tmp108_;
																	gint _tmp108__length1;
																	const gchar* _tmp109_;
																	_tmp108_ = nv;
																	_tmp108__length1 = nv_length1;
																	_tmp109_ = _tmp108_[0];
																	if (g_strcmp0 (_tmp109_, "replacement") == 0) {
																		ValaStruct* _tmp110_;
																		gchar** _tmp111_;
																		gint _tmp111__length1;
																		const gchar* _tmp112_;
																		gchar* _tmp113_ = NULL;
																		gchar* _tmp114_;
																		_tmp110_ = st;
																		_tmp111_ = nv;
																		_tmp111__length1 = nv_length1;
																		_tmp112_ = _tmp111_[1];
																		_tmp113_ = vala_gidl_parser_eval (self, _tmp112_);
																		_tmp114_ = _tmp113_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp110_, "Deprecated", "replacement", _tmp114_, NULL);
																		_g_free0 (_tmp114_);
																	} else {
																		gchar** _tmp115_;
																		gint _tmp115__length1;
																		const gchar* _tmp116_;
																		_tmp115_ = nv;
																		_tmp115__length1 = nv_length1;
																		_tmp116_ = _tmp115_[0];
																		if (g_strcmp0 (_tmp116_, "deprecated_since") == 0) {
																			ValaStruct* _tmp117_;
																			gchar** _tmp118_;
																			gint _tmp118__length1;
																			const gchar* _tmp119_;
																			gchar* _tmp120_ = NULL;
																			gchar* _tmp121_;
																			_tmp117_ = st;
																			_tmp118_ = nv;
																			_tmp118__length1 = nv_length1;
																			_tmp119_ = _tmp118_[1];
																			_tmp120_ = vala_gidl_parser_eval (self, _tmp119_);
																			_tmp121_ = _tmp120_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp117_, "Deprecated", "since", _tmp121_, NULL);
																			_g_free0 (_tmp121_);
																		} else {
																			gchar** _tmp122_;
																			gint _tmp122__length1;
																			const gchar* _tmp123_;
																			_tmp122_ = nv;
																			_tmp122__length1 = nv_length1;
																			_tmp123_ = _tmp122_[0];
																			if (g_strcmp0 (_tmp123_, "has_destroy_function") == 0) {
																				gchar** _tmp124_;
																				gint _tmp124__length1;
																				const gchar* _tmp125_;
																				gchar* _tmp126_ = NULL;
																				gchar* _tmp127_;
																				gboolean _tmp128_;
																				_tmp124_ = nv;
																				_tmp124__length1 = nv_length1;
																				_tmp125_ = _tmp124_[1];
																				_tmp126_ = vala_gidl_parser_eval (self, _tmp125_);
																				_tmp127_ = _tmp126_;
																				_tmp128_ = g_strcmp0 (_tmp127_, "0") == 0;
																				_g_free0 (_tmp127_);
																				if (_tmp128_) {
																					ValaStruct* _tmp129_;
																					_tmp129_ = st;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp129_, "CCode", "has_destroy_function", FALSE, NULL);
																				}
																			} else {
																				gchar** _tmp130_;
																				gint _tmp130__length1;
																				const gchar* _tmp131_;
																				_tmp130_ = nv;
																				_tmp130__length1 = nv_length1;
																				_tmp131_ = _tmp130_[0];
																				if (g_strcmp0 (_tmp131_, "experimental") == 0) {
																					gchar** _tmp132_;
																					gint _tmp132__length1;
																					const gchar* _tmp133_;
																					gchar* _tmp134_ = NULL;
																					gchar* _tmp135_;
																					gboolean _tmp136_;
																					_tmp132_ = nv;
																					_tmp132__length1 = nv_length1;
																					_tmp133_ = _tmp132_[1];
																					_tmp134_ = vala_gidl_parser_eval (self, _tmp133_);
																					_tmp135_ = _tmp134_;
																					_tmp136_ = g_strcmp0 (_tmp135_, "1") == 0;
																					_g_free0 (_tmp135_);
																					if (_tmp136_) {
																						ValaStruct* _tmp137_;
																						_tmp137_ = st;
																						vala_code_node_set_attribute ((ValaCodeNode*) _tmp137_, "Experimental", TRUE, NULL);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp138_ = container;
			_tmp139_ = st;
			vala_gidl_parser_add_symbol_to_container (self, _tmp138_, (ValaSymbol*) _tmp139_);
			_tmp140_ = self->priv->current_source_file;
			_tmp141_ = st;
			vala_source_file_add_node (_tmp140_, (ValaCodeNode*) _tmp141_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp142_ = st;
		_tmp143_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp142_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp143_;
		_tmp144_ = st_node;
		_tmp145_ = _tmp144_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp145_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp146_;
					GIdlNodeTypeId _tmp147_;
					_tmp146_ = member;
					_tmp147_ = _tmp146_->type;
					if (_tmp147_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp148_;
						ValaMethod* _tmp149_ = NULL;
						ValaMethod* m;
						ValaMethod* _tmp150_;
						_tmp148_ = member;
						_tmp149_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp148_, FALSE);
						m = _tmp149_;
						_tmp150_ = m;
						if (_tmp150_ != NULL) {
							ValaStruct* _tmp151_;
							ValaMethod* _tmp152_;
							_tmp151_ = st;
							_tmp152_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp151_, _tmp152_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp153_;
						GIdlNodeTypeId _tmp154_;
						_tmp153_ = member;
						_tmp154_ = _tmp153_->type;
						if (_tmp154_ == G_IDL_NODE_FIELD) {
							GIdlNode* _tmp155_;
							ValaField* _tmp156_ = NULL;
							ValaField* f;
							ValaField* _tmp157_;
							_tmp155_ = member;
							_tmp156_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp155_);
							f = _tmp156_;
							_tmp157_ = f;
							if (_tmp157_ != NULL) {
								ValaStruct* _tmp158_;
								ValaField* _tmp159_;
								_tmp158_ = st;
								_tmp159_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp158_, _tmp159_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaSymbol* _tmp160_;
		ValaScope* _tmp161_;
		ValaScope* _tmp162_;
		const gchar* _tmp163_;
		ValaSymbol* _tmp164_ = NULL;
		ValaClass* cl;
		ValaClass* _tmp165_;
		ValaClass* _tmp318_;
		ValaTypeSymbol* _tmp319_;
		GIdlNodeStruct* _tmp320_;
		GList* _tmp321_;
		const gchar* _tmp377_;
		const gchar* _tmp386_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp160_ = container;
		_tmp161_ = vala_symbol_get_scope (_tmp160_);
		_tmp162_ = _tmp161_;
		_tmp163_ = name;
		_tmp164_ = vala_scope_lookup (_tmp162_, _tmp163_);
		cl = G_TYPE_CHECK_INSTANCE_TYPE (_tmp164_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp164_) : NULL;
		_tmp165_ = cl;
		if (_tmp165_ == NULL) {
			gchar* base_class;
			gboolean is_fundamental;
			const gchar* _tmp166_;
			ValaSourceReference* _tmp167_;
			ValaClass* _tmp168_;
			ValaClass* _tmp169_;
			GIdlNode* _tmp170_;
			const gchar* _tmp171_;
			gint _tmp172_ = 0;
			gchar** _tmp173_ = NULL;
			gchar** cl_attributes;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp174_;
			gint _tmp174__length1;
			ValaSymbol* _tmp304_;
			ValaClass* _tmp305_;
			ValaSourceFile* _tmp306_;
			ValaClass* _tmp307_;
			const gchar* _tmp308_;
			gboolean _tmp313_ = FALSE;
			const gchar* _tmp314_;
			gboolean _tmp316_;
			base_class = NULL;
			is_fundamental = FALSE;
			_tmp166_ = name;
			_tmp167_ = self->priv->current_source_reference;
			_tmp168_ = vala_class_new (_tmp166_, _tmp167_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp168_;
			_tmp169_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp169_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp170_ = node;
			_tmp171_ = _tmp170_->name;
			_tmp173_ = vala_gidl_parser_get_attributes (self, _tmp171_, &_tmp172_);
			cl_attributes = _tmp173_;
			cl_attributes_length1 = _tmp172_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp174_ = cl_attributes;
			_tmp174__length1 = cl_attributes_length1;
			if (_tmp174_ != NULL) {
				gchar** _tmp175_;
				gint _tmp175__length1;
				_tmp175_ = cl_attributes;
				_tmp175__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp175_;
					attr_collection_length1 = _tmp175__length1;
					for (attr_it = 0; attr_it < _tmp175__length1; attr_it = attr_it + 1) {
						gchar* _tmp176_;
						gchar* attr = NULL;
						_tmp176_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp176_;
						{
							const gchar* _tmp177_;
							gchar** _tmp178_;
							gchar** _tmp179_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp180_;
							gint _tmp180__length1;
							const gchar* _tmp181_;
							_tmp177_ = attr;
							_tmp179_ = _tmp178_ = g_strsplit (_tmp177_, "=", 2);
							nv = _tmp179_;
							nv_length1 = _vala_array_length (_tmp178_);
							_nv_size_ = nv_length1;
							_tmp180_ = nv;
							_tmp180__length1 = nv_length1;
							_tmp181_ = _tmp180_[0];
							if (g_strcmp0 (_tmp181_, "cheader_filename") == 0) {
								ValaClass* _tmp182_;
								gchar** _tmp183_;
								gint _tmp183__length1;
								const gchar* _tmp184_;
								gchar* _tmp185_ = NULL;
								gchar* _tmp186_;
								_tmp182_ = cl;
								_tmp183_ = nv;
								_tmp183__length1 = nv_length1;
								_tmp184_ = _tmp183_[1];
								_tmp185_ = vala_gidl_parser_eval (self, _tmp184_);
								_tmp186_ = _tmp185_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp182_, "CCode", "cheader_filename", _tmp186_, NULL);
								_g_free0 (_tmp186_);
							} else {
								gchar** _tmp187_;
								gint _tmp187__length1;
								const gchar* _tmp188_;
								_tmp187_ = nv;
								_tmp187__length1 = nv_length1;
								_tmp188_ = _tmp187_[0];
								if (g_strcmp0 (_tmp188_, "base_class") == 0) {
									gchar** _tmp189_;
									gint _tmp189__length1;
									const gchar* _tmp190_;
									gchar* _tmp191_ = NULL;
									_tmp189_ = nv;
									_tmp189__length1 = nv_length1;
									_tmp190_ = _tmp189_[1];
									_tmp191_ = vala_gidl_parser_eval (self, _tmp190_);
									_g_free0 (base_class);
									base_class = _tmp191_;
								} else {
									gchar** _tmp192_;
									gint _tmp192__length1;
									const gchar* _tmp193_;
									_tmp192_ = nv;
									_tmp192__length1 = nv_length1;
									_tmp193_ = _tmp192_[0];
									if (g_strcmp0 (_tmp193_, "hidden") == 0) {
										gchar** _tmp194_;
										gint _tmp194__length1;
										const gchar* _tmp195_;
										gchar* _tmp196_ = NULL;
										gchar* _tmp197_;
										gboolean _tmp198_;
										_tmp194_ = nv;
										_tmp194__length1 = nv_length1;
										_tmp195_ = _tmp194_[1];
										_tmp196_ = vala_gidl_parser_eval (self, _tmp195_);
										_tmp197_ = _tmp196_;
										_tmp198_ = g_strcmp0 (_tmp197_, "1") == 0;
										_g_free0 (_tmp197_);
										if (_tmp198_) {
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											_vala_code_node_unref0 (cl);
											_g_free0 (free_function);
											_g_free0 (copy_function);
											_g_free0 (unref_function);
											_g_free0 (ref_function);
											_g_free0 (name);
											return;
										}
									} else {
										gchar** _tmp199_;
										gint _tmp199__length1;
										const gchar* _tmp200_;
										_tmp199_ = nv;
										_tmp199__length1 = nv_length1;
										_tmp200_ = _tmp199_[0];
										if (g_strcmp0 (_tmp200_, "is_immutable") == 0) {
											gchar** _tmp201_;
											gint _tmp201__length1;
											const gchar* _tmp202_;
											gchar* _tmp203_ = NULL;
											gchar* _tmp204_;
											gboolean _tmp205_;
											_tmp201_ = nv;
											_tmp201__length1 = nv_length1;
											_tmp202_ = _tmp201_[1];
											_tmp203_ = vala_gidl_parser_eval (self, _tmp202_);
											_tmp204_ = _tmp203_;
											_tmp205_ = g_strcmp0 (_tmp204_, "1") == 0;
											_g_free0 (_tmp204_);
											if (_tmp205_) {
												ValaClass* _tmp206_;
												_tmp206_ = cl;
												vala_class_set_is_immutable (_tmp206_, TRUE);
											}
										} else {
											gchar** _tmp207_;
											gint _tmp207__length1;
											const gchar* _tmp208_;
											_tmp207_ = nv;
											_tmp207__length1 = nv_length1;
											_tmp208_ = _tmp207_[0];
											if (g_strcmp0 (_tmp208_, "const_cname") == 0) {
												ValaClass* _tmp209_;
												gchar** _tmp210_;
												gint _tmp210__length1;
												const gchar* _tmp211_;
												gchar* _tmp212_ = NULL;
												gchar* _tmp213_;
												_tmp209_ = cl;
												_tmp210_ = nv;
												_tmp210__length1 = nv_length1;
												_tmp211_ = _tmp210_[1];
												_tmp212_ = vala_gidl_parser_eval (self, _tmp211_);
												_tmp213_ = _tmp212_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp209_, "CCode", "const_cname", _tmp213_, NULL);
												_g_free0 (_tmp213_);
											} else {
												gchar** _tmp214_;
												gint _tmp214__length1;
												const gchar* _tmp215_;
												_tmp214_ = nv;
												_tmp214__length1 = nv_length1;
												_tmp215_ = _tmp214_[0];
												if (g_strcmp0 (_tmp215_, "is_fundamental") == 0) {
													gchar** _tmp216_;
													gint _tmp216__length1;
													const gchar* _tmp217_;
													gchar* _tmp218_ = NULL;
													gchar* _tmp219_;
													gboolean _tmp220_;
													_tmp216_ = nv;
													_tmp216__length1 = nv_length1;
													_tmp217_ = _tmp216_[1];
													_tmp218_ = vala_gidl_parser_eval (self, _tmp217_);
													_tmp219_ = _tmp218_;
													_tmp220_ = g_strcmp0 (_tmp219_, "1") == 0;
													_g_free0 (_tmp219_);
													if (_tmp220_) {
														is_fundamental = TRUE;
													}
												} else {
													gboolean _tmp221_ = FALSE;
													gchar** _tmp222_;
													gint _tmp222__length1;
													const gchar* _tmp223_;
													gboolean _tmp225_;
													_tmp222_ = nv;
													_tmp222__length1 = nv_length1;
													_tmp223_ = _tmp222_[0];
													if (g_strcmp0 (_tmp223_, "abstract") == 0) {
														const gchar* _tmp224_;
														_tmp224_ = base_class;
														_tmp221_ = _tmp224_ != NULL;
													} else {
														_tmp221_ = FALSE;
													}
													_tmp225_ = _tmp221_;
													if (_tmp225_) {
														gchar** _tmp226_;
														gint _tmp226__length1;
														const gchar* _tmp227_;
														gchar* _tmp228_ = NULL;
														gchar* _tmp229_;
														gboolean _tmp230_;
														_tmp226_ = nv;
														_tmp226__length1 = nv_length1;
														_tmp227_ = _tmp226_[1];
														_tmp228_ = vala_gidl_parser_eval (self, _tmp227_);
														_tmp229_ = _tmp228_;
														_tmp230_ = g_strcmp0 (_tmp229_, "1") == 0;
														_g_free0 (_tmp229_);
														if (_tmp230_) {
															ValaClass* _tmp231_;
															_tmp231_ = cl;
															vala_class_set_is_abstract (_tmp231_, TRUE);
														}
													} else {
														gchar** _tmp232_;
														gint _tmp232__length1;
														const gchar* _tmp233_;
														_tmp232_ = nv;
														_tmp232__length1 = nv_length1;
														_tmp233_ = _tmp232_[0];
														if (g_strcmp0 (_tmp233_, "free_function") == 0) {
															gchar** _tmp234_;
															gint _tmp234__length1;
															const gchar* _tmp235_;
															gchar* _tmp236_ = NULL;
															_tmp234_ = nv;
															_tmp234__length1 = nv_length1;
															_tmp235_ = _tmp234_[1];
															_tmp236_ = vala_gidl_parser_eval (self, _tmp235_);
															_g_free0 (free_function);
															free_function = _tmp236_;
														} else {
															gchar** _tmp237_;
															gint _tmp237__length1;
															const gchar* _tmp238_;
															_tmp237_ = nv;
															_tmp237__length1 = nv_length1;
															_tmp238_ = _tmp237_[0];
															if (g_strcmp0 (_tmp238_, "ref_function") == 0) {
																gchar** _tmp239_;
																gint _tmp239__length1;
																const gchar* _tmp240_;
																gchar* _tmp241_ = NULL;
																_tmp239_ = nv;
																_tmp239__length1 = nv_length1;
																_tmp240_ = _tmp239_[1];
																_tmp241_ = vala_gidl_parser_eval (self, _tmp240_);
																_g_free0 (ref_function);
																ref_function = _tmp241_;
															} else {
																gchar** _tmp242_;
																gint _tmp242__length1;
																const gchar* _tmp243_;
																_tmp242_ = nv;
																_tmp242__length1 = nv_length1;
																_tmp243_ = _tmp242_[0];
																if (g_strcmp0 (_tmp243_, "unref_function") == 0) {
																	gchar** _tmp244_;
																	gint _tmp244__length1;
																	const gchar* _tmp245_;
																	gchar* _tmp246_ = NULL;
																	_tmp244_ = nv;
																	_tmp244__length1 = nv_length1;
																	_tmp245_ = _tmp244_[1];
																	_tmp246_ = vala_gidl_parser_eval (self, _tmp245_);
																	_g_free0 (unref_function);
																	unref_function = _tmp246_;
																} else {
																	gchar** _tmp247_;
																	gint _tmp247__length1;
																	const gchar* _tmp248_;
																	_tmp247_ = nv;
																	_tmp247__length1 = nv_length1;
																	_tmp248_ = _tmp247_[0];
																	if (g_strcmp0 (_tmp248_, "copy_function") == 0) {
																		gchar** _tmp249_;
																		gint _tmp249__length1;
																		const gchar* _tmp250_;
																		gchar* _tmp251_ = NULL;
																		_tmp249_ = nv;
																		_tmp249__length1 = nv_length1;
																		_tmp250_ = _tmp249_[1];
																		_tmp251_ = vala_gidl_parser_eval (self, _tmp250_);
																		_g_free0 (copy_function);
																		copy_function = _tmp251_;
																	} else {
																		gchar** _tmp252_;
																		gint _tmp252__length1;
																		const gchar* _tmp253_;
																		_tmp252_ = nv;
																		_tmp252__length1 = nv_length1;
																		_tmp253_ = _tmp252_[0];
																		if (g_strcmp0 (_tmp253_, "ref_function_void") == 0) {
																			gchar** _tmp254_;
																			gint _tmp254__length1;
																			const gchar* _tmp255_;
																			gchar* _tmp256_ = NULL;
																			gchar* _tmp257_;
																			gboolean _tmp258_;
																			_tmp254_ = nv;
																			_tmp254__length1 = nv_length1;
																			_tmp255_ = _tmp254_[1];
																			_tmp256_ = vala_gidl_parser_eval (self, _tmp255_);
																			_tmp257_ = _tmp256_;
																			_tmp258_ = g_strcmp0 (_tmp257_, "1") == 0;
																			_g_free0 (_tmp257_);
																			if (_tmp258_) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			gchar** _tmp259_;
																			gint _tmp259__length1;
																			const gchar* _tmp260_;
																			_tmp259_ = nv;
																			_tmp259__length1 = nv_length1;
																			_tmp260_ = _tmp259_[0];
																			if (g_strcmp0 (_tmp260_, "deprecated") == 0) {
																				gchar** _tmp261_;
																				gint _tmp261__length1;
																				const gchar* _tmp262_;
																				gchar* _tmp263_ = NULL;
																				gchar* _tmp264_;
																				gboolean _tmp265_;
																				_tmp261_ = nv;
																				_tmp261__length1 = nv_length1;
																				_tmp262_ = _tmp261_[1];
																				_tmp263_ = vala_gidl_parser_eval (self, _tmp262_);
																				_tmp264_ = _tmp263_;
																				_tmp265_ = g_strcmp0 (_tmp264_, "1") == 0;
																				_g_free0 (_tmp264_);
																				if (_tmp265_) {
																					ValaClass* _tmp266_;
																					_tmp266_ = cl;
																					vala_code_node_set_attribute ((ValaCodeNode*) _tmp266_, "Deprecated", TRUE, NULL);
																				}
																			} else {
																				gchar** _tmp267_;
																				gint _tmp267__length1;
																				const gchar* _tmp268_;
																				_tmp267_ = nv;
																				_tmp267__length1 = nv_length1;
																				_tmp268_ = _tmp267_[0];
																				if (g_strcmp0 (_tmp268_, "replacement") == 0) {
																					ValaClass* _tmp269_;
																					gchar** _tmp270_;
																					gint _tmp270__length1;
																					const gchar* _tmp271_;
																					gchar* _tmp272_ = NULL;
																					gchar* _tmp273_;
																					_tmp269_ = cl;
																					_tmp270_ = nv;
																					_tmp270__length1 = nv_length1;
																					_tmp271_ = _tmp270_[1];
																					_tmp272_ = vala_gidl_parser_eval (self, _tmp271_);
																					_tmp273_ = _tmp272_;
																					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp269_, "Deprecated", "replacement", _tmp273_, NULL);
																					_g_free0 (_tmp273_);
																				} else {
																					gchar** _tmp274_;
																					gint _tmp274__length1;
																					const gchar* _tmp275_;
																					_tmp274_ = nv;
																					_tmp274__length1 = nv_length1;
																					_tmp275_ = _tmp274_[0];
																					if (g_strcmp0 (_tmp275_, "deprecated_since") == 0) {
																						ValaClass* _tmp276_;
																						gchar** _tmp277_;
																						gint _tmp277__length1;
																						const gchar* _tmp278_;
																						gchar* _tmp279_ = NULL;
																						gchar* _tmp280_;
																						_tmp276_ = cl;
																						_tmp277_ = nv;
																						_tmp277__length1 = nv_length1;
																						_tmp278_ = _tmp277_[1];
																						_tmp279_ = vala_gidl_parser_eval (self, _tmp278_);
																						_tmp280_ = _tmp279_;
																						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp276_, "Deprecated", "since", _tmp280_, NULL);
																						_g_free0 (_tmp280_);
																					} else {
																						gchar** _tmp281_;
																						gint _tmp281__length1;
																						const gchar* _tmp282_;
																						_tmp281_ = nv;
																						_tmp281__length1 = nv_length1;
																						_tmp282_ = _tmp281_[0];
																						if (g_strcmp0 (_tmp282_, "type_parameters") == 0) {
																							gchar** _tmp283_;
																							gint _tmp283__length1;
																							const gchar* _tmp284_;
																							gchar* _tmp285_ = NULL;
																							gchar* _tmp286_;
																							gchar** _tmp287_;
																							gchar** _tmp288_ = NULL;
																							gchar** _tmp289_;
																							gint _tmp289__length1;
																							_tmp283_ = nv;
																							_tmp283__length1 = nv_length1;
																							_tmp284_ = _tmp283_[1];
																							_tmp285_ = vala_gidl_parser_eval (self, _tmp284_);
																							_tmp286_ = _tmp285_;
																							_tmp288_ = _tmp287_ = g_strsplit (_tmp286_, ",", 0);
																							_tmp289_ = _tmp288_;
																							_tmp289__length1 = _vala_array_length (_tmp287_);
																							_g_free0 (_tmp286_);
																							{
																								gchar** type_param_name_collection = NULL;
																								gint type_param_name_collection_length1 = 0;
																								gint _type_param_name_collection_size_ = 0;
																								gint type_param_name_it = 0;
																								type_param_name_collection = _tmp289_;
																								type_param_name_collection_length1 = _tmp289__length1;
																								for (type_param_name_it = 0; type_param_name_it < _tmp289__length1; type_param_name_it = type_param_name_it + 1) {
																									gchar* _tmp290_;
																									gchar* type_param_name = NULL;
																									_tmp290_ = g_strdup (type_param_name_collection[type_param_name_it]);
																									type_param_name = _tmp290_;
																									{
																										ValaClass* _tmp291_;
																										const gchar* _tmp292_;
																										ValaSourceReference* _tmp293_;
																										ValaTypeParameter* _tmp294_;
																										ValaTypeParameter* _tmp295_;
																										_tmp291_ = cl;
																										_tmp292_ = type_param_name;
																										_tmp293_ = self->priv->current_source_reference;
																										_tmp294_ = vala_typeparameter_new (_tmp292_, _tmp293_);
																										_tmp295_ = _tmp294_;
																										vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) _tmp291_, _tmp295_);
																										_vala_code_node_unref0 (_tmp295_);
																										_g_free0 (type_param_name);
																									}
																								}
																								type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						} else {
																							gchar** _tmp296_;
																							gint _tmp296__length1;
																							const gchar* _tmp297_;
																							_tmp296_ = nv;
																							_tmp296__length1 = nv_length1;
																							_tmp297_ = _tmp296_[0];
																							if (g_strcmp0 (_tmp297_, "experimental") == 0) {
																								gchar** _tmp298_;
																								gint _tmp298__length1;
																								const gchar* _tmp299_;
																								gchar* _tmp300_ = NULL;
																								gchar* _tmp301_;
																								gboolean _tmp302_;
																								_tmp298_ = nv;
																								_tmp298__length1 = nv_length1;
																								_tmp299_ = _tmp298_[1];
																								_tmp300_ = vala_gidl_parser_eval (self, _tmp299_);
																								_tmp301_ = _tmp300_;
																								_tmp302_ = g_strcmp0 (_tmp301_, "1") == 0;
																								_g_free0 (_tmp301_);
																								if (_tmp302_) {
																									ValaClass* _tmp303_;
																									_tmp303_ = cl;
																									vala_code_node_set_attribute ((ValaCodeNode*) _tmp303_, "Experimental", TRUE, NULL);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp304_ = container;
			_tmp305_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, _tmp304_, (ValaSymbol*) _tmp305_);
			_tmp306_ = self->priv->current_source_file;
			_tmp307_ = cl;
			vala_source_file_add_node (_tmp306_, (ValaCodeNode*) _tmp307_);
			_tmp308_ = base_class;
			if (_tmp308_ != NULL) {
				const gchar* _tmp309_;
				ValaDataType* _tmp310_ = NULL;
				ValaDataType* parent;
				ValaClass* _tmp311_;
				ValaDataType* _tmp312_;
				_tmp309_ = base_class;
				_tmp310_ = vala_gidl_parser_parse_type_string (self, _tmp309_);
				parent = _tmp310_;
				_tmp311_ = cl;
				_tmp312_ = parent;
				vala_class_add_base_type (_tmp311_, _tmp312_);
				_vala_code_node_unref0 (parent);
			}
			_tmp314_ = base_class;
			if (_tmp314_ == NULL) {
				gboolean _tmp315_;
				_tmp315_ = is_fundamental;
				_tmp313_ = !_tmp315_;
			} else {
				_tmp313_ = FALSE;
			}
			_tmp316_ = _tmp313_;
			if (_tmp316_) {
				ValaClass* _tmp317_;
				_tmp317_ = cl;
				vala_class_set_is_compact (_tmp317_, TRUE);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp318_ = cl;
		_tmp319_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp318_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp319_;
		_tmp320_ = st_node;
		_tmp321_ = _tmp320_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp321_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp322_;
					GIdlNodeTypeId _tmp323_;
					_tmp322_ = member;
					_tmp323_ = _tmp322_->type;
					if (_tmp323_ == G_IDL_NODE_FUNCTION) {
						gboolean _tmp324_ = FALSE;
						const gchar* _tmp325_;
						gboolean _tmp328_;
						_tmp325_ = ref_function;
						if (_tmp325_ == NULL) {
							GIdlNode* _tmp326_;
							const gchar* _tmp327_;
							_tmp326_ = member;
							_tmp327_ = _tmp326_->name;
							_tmp324_ = g_strcmp0 (_tmp327_, "ref") == 0;
						} else {
							_tmp324_ = FALSE;
						}
						_tmp328_ = _tmp324_;
						if (_tmp328_) {
							GIdlNode* _tmp329_;
							const gchar* _tmp330_;
							gchar* _tmp331_;
							GIdlNode* _tmp332_;
							GIdlNodeParam* _tmp333_;
							GIdlNodeType* _tmp334_;
							ValaDataType* _tmp335_ = NULL;
							ValaDataType* _tmp336_;
							_tmp329_ = member;
							_tmp330_ = ((GIdlNodeFunction*) _tmp329_)->symbol;
							_tmp331_ = g_strdup (_tmp330_);
							_g_free0 (ref_function);
							ref_function = _tmp331_;
							_tmp332_ = member;
							_tmp333_ = ((GIdlNodeFunction*) _tmp332_)->result;
							_tmp334_ = _tmp333_->type;
							_tmp335_ = vala_gidl_parser_parse_type (self, _tmp334_, NULL);
							_tmp336_ = _tmp335_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp336_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp336_);
						} else {
							gboolean _tmp337_ = FALSE;
							const gchar* _tmp338_;
							gboolean _tmp341_;
							_tmp338_ = unref_function;
							if (_tmp338_ == NULL) {
								GIdlNode* _tmp339_;
								const gchar* _tmp340_;
								_tmp339_ = member;
								_tmp340_ = _tmp339_->name;
								_tmp337_ = g_strcmp0 (_tmp340_, "unref") == 0;
							} else {
								_tmp337_ = FALSE;
							}
							_tmp341_ = _tmp337_;
							if (_tmp341_) {
								GIdlNode* _tmp342_;
								const gchar* _tmp343_;
								gchar* _tmp344_;
								_tmp342_ = member;
								_tmp343_ = ((GIdlNodeFunction*) _tmp342_)->symbol;
								_tmp344_ = g_strdup (_tmp343_);
								_g_free0 (unref_function);
								unref_function = _tmp344_;
							} else {
								gboolean _tmp345_ = FALSE;
								const gchar* _tmp346_;
								gboolean _tmp353_;
								_tmp346_ = free_function;
								if (_tmp346_ == NULL) {
									gboolean _tmp347_ = FALSE;
									GIdlNode* _tmp348_;
									const gchar* _tmp349_;
									gboolean _tmp352_;
									_tmp348_ = member;
									_tmp349_ = _tmp348_->name;
									if (g_strcmp0 (_tmp349_, "free") == 0) {
										_tmp347_ = TRUE;
									} else {
										GIdlNode* _tmp350_;
										const gchar* _tmp351_;
										_tmp350_ = member;
										_tmp351_ = _tmp350_->name;
										_tmp347_ = g_strcmp0 (_tmp351_, "destroy") == 0;
									}
									_tmp352_ = _tmp347_;
									_tmp345_ = _tmp352_;
								} else {
									_tmp345_ = FALSE;
								}
								_tmp353_ = _tmp345_;
								if (_tmp353_) {
									GIdlNode* _tmp354_;
									const gchar* _tmp355_;
									gchar* _tmp356_;
									_tmp354_ = member;
									_tmp355_ = ((GIdlNodeFunction*) _tmp354_)->symbol;
									_tmp356_ = g_strdup (_tmp355_);
									_g_free0 (free_function);
									free_function = _tmp356_;
								} else {
									gboolean _tmp357_ = FALSE;
									const gchar* _tmp358_;
									gboolean _tmp361_;
									GIdlNode* _tmp365_;
									ValaMethod* _tmp366_ = NULL;
									ValaMethod* m;
									ValaMethod* _tmp367_;
									_tmp358_ = copy_function;
									if (_tmp358_ == NULL) {
										GIdlNode* _tmp359_;
										const gchar* _tmp360_;
										_tmp359_ = member;
										_tmp360_ = _tmp359_->name;
										_tmp357_ = g_strcmp0 (_tmp360_, "copy") == 0;
									} else {
										_tmp357_ = FALSE;
									}
									_tmp361_ = _tmp357_;
									if (_tmp361_) {
										GIdlNode* _tmp362_;
										const gchar* _tmp363_;
										gchar* _tmp364_;
										_tmp362_ = member;
										_tmp363_ = ((GIdlNodeFunction*) _tmp362_)->symbol;
										_tmp364_ = g_strdup (_tmp363_);
										_g_free0 (copy_function);
										copy_function = _tmp364_;
									}
									_tmp365_ = member;
									_tmp366_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp365_, FALSE);
									m = _tmp366_;
									_tmp367_ = m;
									if (_tmp367_ != NULL) {
										ValaClass* _tmp368_;
										ValaMethod* _tmp369_;
										_tmp368_ = cl;
										_tmp369_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp368_, _tmp369_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp370_;
						GIdlNodeTypeId _tmp371_;
						_tmp370_ = member;
						_tmp371_ = _tmp370_->type;
						if (_tmp371_ == G_IDL_NODE_FIELD) {
							GIdlNode* _tmp372_;
							ValaField* _tmp373_ = NULL;
							ValaField* f;
							ValaField* _tmp374_;
							_tmp372_ = member;
							_tmp373_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp372_);
							f = _tmp373_;
							_tmp374_ = f;
							if (_tmp374_ != NULL) {
								ValaClass* _tmp375_;
								ValaField* _tmp376_;
								_tmp375_ = cl;
								_tmp376_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp375_, _tmp376_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp377_ = ref_function;
		if (_tmp377_ != NULL) {
			ValaClass* _tmp378_;
			const gchar* _tmp379_;
			gboolean _tmp380_;
			_tmp378_ = cl;
			_tmp379_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp378_, "CCode", "ref_function", _tmp379_, NULL);
			_tmp380_ = ref_function_void;
			if (_tmp380_) {
				ValaClass* _tmp381_;
				gboolean _tmp382_;
				_tmp381_ = cl;
				_tmp382_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp381_, "CCode", "ref_function_void", _tmp382_, NULL);
			}
		} else {
			const gchar* _tmp383_;
			_tmp383_ = copy_function;
			if (_tmp383_ != NULL) {
				ValaClass* _tmp384_;
				const gchar* _tmp385_;
				_tmp384_ = cl;
				_tmp385_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp384_, "CCode", "copy_function", _tmp385_, NULL);
			}
		}
		_tmp386_ = unref_function;
		if (_tmp386_ != NULL) {
			ValaClass* _tmp387_;
			const gchar* _tmp388_;
			_tmp387_ = cl;
			_tmp388_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp387_, "CCode", "unref_function", _tmp388_, NULL);
		} else {
			gboolean _tmp389_ = FALSE;
			const gchar* _tmp390_;
			gboolean _tmp397_;
			_tmp390_ = free_function;
			if (_tmp390_ != NULL) {
				const gchar* _tmp391_;
				ValaClass* _tmp392_;
				gchar* _tmp393_ = NULL;
				gchar* _tmp394_;
				gchar* _tmp395_ = NULL;
				gchar* _tmp396_;
				_tmp391_ = free_function;
				_tmp392_ = cl;
				_tmp393_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp392_);
				_tmp394_ = _tmp393_;
				_tmp395_ = g_strdup_printf ("%sfree", _tmp394_);
				_tmp396_ = _tmp395_;
				_tmp389_ = g_strcmp0 (_tmp391_, _tmp396_) != 0;
				_g_free0 (_tmp396_);
				_g_free0 (_tmp394_);
			} else {
				_tmp389_ = FALSE;
			}
			_tmp397_ = _tmp389_;
			if (_tmp397_) {
				ValaClass* _tmp398_;
				const gchar* _tmp399_;
				_tmp398_ = cl;
				_tmp399_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp398_, "CCode", "free_function", _tmp399_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNodeUnion* _tmp0_;
	GIdlNode* node;
	GIdlNodeUnion* _tmp1_;
	gboolean _tmp2_;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* name;
	GIdlNode* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = un_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = un_node;
	_tmp2_ = _tmp1_->deprecated;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = container;
	_tmp6_ = vala_gidl_parser_fix_type_name (self, _tmp4_, _tmp5_);
	name = _tmp6_;
	_tmp7_ = node;
	_tmp8_ = _tmp7_->name;
	_tmp9_ = vala_gidl_parser_is_reference_type (self, _tmp8_);
	if (!_tmp9_) {
		ValaSymbol* _tmp10_;
		ValaScope* _tmp11_;
		ValaScope* _tmp12_;
		const gchar* _tmp13_;
		ValaSymbol* _tmp14_ = NULL;
		ValaStruct* st;
		ValaStruct* _tmp15_;
		ValaStruct* _tmp78_;
		ValaTypeSymbol* _tmp79_;
		GIdlNodeUnion* _tmp80_;
		GList* _tmp81_;
		_tmp10_ = container;
		_tmp11_ = vala_symbol_get_scope (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = name;
		_tmp14_ = vala_scope_lookup (_tmp12_, _tmp13_);
		st = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp14_) : NULL;
		_tmp15_ = st;
		if (_tmp15_ == NULL) {
			const gchar* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaStruct* _tmp18_;
			ValaStruct* _tmp19_;
			GIdlNode* _tmp20_;
			const gchar* _tmp21_;
			gint _tmp22_ = 0;
			gchar** _tmp23_ = NULL;
			gchar** st_attributes;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			ValaSymbol* _tmp74_;
			ValaStruct* _tmp75_;
			ValaSourceFile* _tmp76_;
			ValaStruct* _tmp77_;
			_tmp16_ = name;
			_tmp17_ = self->priv->current_source_reference;
			_tmp18_ = vala_struct_new (_tmp16_, _tmp17_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp18_;
			_tmp19_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp19_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp20_ = node;
			_tmp21_ = _tmp20_->name;
			_tmp23_ = vala_gidl_parser_get_attributes (self, _tmp21_, &_tmp22_);
			st_attributes = _tmp23_;
			st_attributes_length1 = _tmp22_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp24_ = st_attributes;
			_tmp24__length1 = st_attributes_length1;
			if (_tmp24_ != NULL) {
				gchar** _tmp25_;
				gint _tmp25__length1;
				_tmp25_ = st_attributes;
				_tmp25__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp25_;
					attr_collection_length1 = _tmp25__length1;
					for (attr_it = 0; attr_it < _tmp25__length1; attr_it = attr_it + 1) {
						gchar* _tmp26_;
						gchar* attr = NULL;
						_tmp26_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp26_;
						{
							const gchar* _tmp27_;
							gchar** _tmp28_;
							gchar** _tmp29_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							_tmp27_ = attr;
							_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "=", 2);
							nv = _tmp29_;
							nv_length1 = _vala_array_length (_tmp28_);
							_nv_size_ = nv_length1;
							_tmp30_ = nv;
							_tmp30__length1 = nv_length1;
							_tmp31_ = _tmp30_[0];
							if (g_strcmp0 (_tmp31_, "cheader_filename") == 0) {
								ValaStruct* _tmp32_;
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_;
								_tmp32_ = st;
								_tmp33_ = nv;
								_tmp33__length1 = nv_length1;
								_tmp34_ = _tmp33_[1];
								_tmp35_ = vala_gidl_parser_eval (self, _tmp34_);
								_tmp36_ = _tmp35_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp32_, "CCode", "cheader_filename", _tmp36_, NULL);
								_g_free0 (_tmp36_);
							} else {
								gchar** _tmp37_;
								gint _tmp37__length1;
								const gchar* _tmp38_;
								_tmp37_ = nv;
								_tmp37__length1 = nv_length1;
								_tmp38_ = _tmp37_[0];
								if (g_strcmp0 (_tmp38_, "deprecated") == 0) {
									gchar** _tmp39_;
									gint _tmp39__length1;
									const gchar* _tmp40_;
									gchar* _tmp41_ = NULL;
									gchar* _tmp42_;
									gboolean _tmp43_;
									_tmp39_ = nv;
									_tmp39__length1 = nv_length1;
									_tmp40_ = _tmp39_[1];
									_tmp41_ = vala_gidl_parser_eval (self, _tmp40_);
									_tmp42_ = _tmp41_;
									_tmp43_ = g_strcmp0 (_tmp42_, "1") == 0;
									_g_free0 (_tmp42_);
									if (_tmp43_) {
										ValaStruct* _tmp44_;
										_tmp44_ = st;
										vala_code_node_set_attribute ((ValaCodeNode*) _tmp44_, "Deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp45_;
									gint _tmp45__length1;
									const gchar* _tmp46_;
									_tmp45_ = nv;
									_tmp45__length1 = nv_length1;
									_tmp46_ = _tmp45_[0];
									if (g_strcmp0 (_tmp46_, "replacement") == 0) {
										ValaStruct* _tmp47_;
										gchar** _tmp48_;
										gint _tmp48__length1;
										const gchar* _tmp49_;
										gchar* _tmp50_ = NULL;
										gchar* _tmp51_;
										_tmp47_ = st;
										_tmp48_ = nv;
										_tmp48__length1 = nv_length1;
										_tmp49_ = _tmp48_[1];
										_tmp50_ = vala_gidl_parser_eval (self, _tmp49_);
										_tmp51_ = _tmp50_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp47_, "Deprecated", "replacement", _tmp51_, NULL);
										_g_free0 (_tmp51_);
									} else {
										gchar** _tmp52_;
										gint _tmp52__length1;
										const gchar* _tmp53_;
										_tmp52_ = nv;
										_tmp52__length1 = nv_length1;
										_tmp53_ = _tmp52_[0];
										if (g_strcmp0 (_tmp53_, "deprecated_since") == 0) {
											ValaStruct* _tmp54_;
											gchar** _tmp55_;
											gint _tmp55__length1;
											const gchar* _tmp56_;
											gchar* _tmp57_ = NULL;
											gchar* _tmp58_;
											_tmp54_ = st;
											_tmp55_ = nv;
											_tmp55__length1 = nv_length1;
											_tmp56_ = _tmp55_[1];
											_tmp57_ = vala_gidl_parser_eval (self, _tmp56_);
											_tmp58_ = _tmp57_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp54_, "Deprecated", "since", _tmp58_, NULL);
											_g_free0 (_tmp58_);
										} else {
											gchar** _tmp59_;
											gint _tmp59__length1;
											const gchar* _tmp60_;
											_tmp59_ = nv;
											_tmp59__length1 = nv_length1;
											_tmp60_ = _tmp59_[0];
											if (g_strcmp0 (_tmp60_, "hidden") == 0) {
												gchar** _tmp61_;
												gint _tmp61__length1;
												const gchar* _tmp62_;
												gchar* _tmp63_ = NULL;
												gchar* _tmp64_;
												gboolean _tmp65_;
												_tmp61_ = nv;
												_tmp61__length1 = nv_length1;
												_tmp62_ = _tmp61_[1];
												_tmp63_ = vala_gidl_parser_eval (self, _tmp62_);
												_tmp64_ = _tmp63_;
												_tmp65_ = g_strcmp0 (_tmp64_, "1") == 0;
												_g_free0 (_tmp64_);
												if (_tmp65_) {
													nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (attr);
													st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
													_vala_code_node_unref0 (st);
													_g_free0 (name);
													return;
												}
											} else {
												gchar** _tmp66_;
												gint _tmp66__length1;
												const gchar* _tmp67_;
												_tmp66_ = nv;
												_tmp66__length1 = nv_length1;
												_tmp67_ = _tmp66_[0];
												if (g_strcmp0 (_tmp67_, "experimental") == 0) {
													gchar** _tmp68_;
													gint _tmp68__length1;
													const gchar* _tmp69_;
													gchar* _tmp70_ = NULL;
													gchar* _tmp71_;
													gboolean _tmp72_;
													_tmp68_ = nv;
													_tmp68__length1 = nv_length1;
													_tmp69_ = _tmp68_[1];
													_tmp70_ = vala_gidl_parser_eval (self, _tmp69_);
													_tmp71_ = _tmp70_;
													_tmp72_ = g_strcmp0 (_tmp71_, "1") == 0;
													_g_free0 (_tmp71_);
													if (_tmp72_) {
														ValaStruct* _tmp73_;
														_tmp73_ = st;
														vala_code_node_set_attribute ((ValaCodeNode*) _tmp73_, "Experimental", TRUE, NULL);
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp74_ = container;
			_tmp75_ = st;
			vala_gidl_parser_add_symbol_to_container (self, _tmp74_, (ValaSymbol*) _tmp75_);
			_tmp76_ = self->priv->current_source_file;
			_tmp77_ = st;
			vala_source_file_add_node (_tmp76_, (ValaCodeNode*) _tmp77_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp78_ = st;
		_tmp79_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp78_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp79_;
		_tmp80_ = un_node;
		_tmp81_ = _tmp80_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp81_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp82_;
					GIdlNodeTypeId _tmp83_;
					_tmp82_ = member;
					_tmp83_ = _tmp82_->type;
					if (_tmp83_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp84_;
						ValaMethod* _tmp85_ = NULL;
						ValaMethod* m;
						ValaMethod* _tmp86_;
						_tmp84_ = member;
						_tmp85_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp84_, FALSE);
						m = _tmp85_;
						_tmp86_ = m;
						if (_tmp86_ != NULL) {
							ValaStruct* _tmp87_;
							ValaMethod* _tmp88_;
							_tmp87_ = st;
							_tmp88_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp87_, _tmp88_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp89_;
						GIdlNodeTypeId _tmp90_;
						_tmp89_ = member;
						_tmp90_ = _tmp89_->type;
						if (_tmp90_ == G_IDL_NODE_FIELD) {
							GIdlNode* _tmp91_;
							ValaField* _tmp92_ = NULL;
							ValaField* f;
							ValaField* _tmp93_;
							_tmp91_ = member;
							_tmp92_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp91_);
							f = _tmp92_;
							_tmp93_ = f;
							if (_tmp93_ != NULL) {
								ValaStruct* _tmp94_;
								ValaField* _tmp95_;
								_tmp94_ = st;
								_tmp95_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp94_, _tmp95_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp96_;
		ValaScope* _tmp97_;
		ValaScope* _tmp98_;
		const gchar* _tmp99_;
		ValaSymbol* _tmp100_ = NULL;
		ValaClass* cl;
		ValaClass* _tmp101_;
		ValaClass* _tmp135_;
		ValaTypeSymbol* _tmp136_;
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		GIdlNodeUnion* _tmp137_;
		GList* _tmp138_;
		const gchar* _tmp182_;
		const gchar* _tmp191_;
		_tmp96_ = container;
		_tmp97_ = vala_symbol_get_scope (_tmp96_);
		_tmp98_ = _tmp97_;
		_tmp99_ = name;
		_tmp100_ = vala_scope_lookup (_tmp98_, _tmp99_);
		cl = G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp100_) : NULL;
		_tmp101_ = cl;
		if (_tmp101_ == NULL) {
			const gchar* _tmp102_;
			ValaSourceReference* _tmp103_;
			ValaClass* _tmp104_;
			ValaClass* _tmp105_;
			ValaClass* _tmp106_;
			GIdlNode* _tmp107_;
			const gchar* _tmp108_;
			gint _tmp109_ = 0;
			gchar** _tmp110_ = NULL;
			gchar** cl_attributes;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp111_;
			gint _tmp111__length1;
			ValaSymbol* _tmp131_;
			ValaClass* _tmp132_;
			ValaSourceFile* _tmp133_;
			ValaClass* _tmp134_;
			_tmp102_ = name;
			_tmp103_ = self->priv->current_source_reference;
			_tmp104_ = vala_class_new (_tmp102_, _tmp103_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp104_;
			_tmp105_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp105_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp106_ = cl;
			vala_class_set_is_compact (_tmp106_, TRUE);
			_tmp107_ = node;
			_tmp108_ = _tmp107_->name;
			_tmp110_ = vala_gidl_parser_get_attributes (self, _tmp108_, &_tmp109_);
			cl_attributes = _tmp110_;
			cl_attributes_length1 = _tmp109_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp111_ = cl_attributes;
			_tmp111__length1 = cl_attributes_length1;
			if (_tmp111_ != NULL) {
				gchar** _tmp112_;
				gint _tmp112__length1;
				_tmp112_ = cl_attributes;
				_tmp112__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp112_;
					attr_collection_length1 = _tmp112__length1;
					for (attr_it = 0; attr_it < _tmp112__length1; attr_it = attr_it + 1) {
						gchar* _tmp113_;
						gchar* attr = NULL;
						_tmp113_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp113_;
						{
							const gchar* _tmp114_;
							gchar** _tmp115_;
							gchar** _tmp116_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp117_;
							gint _tmp117__length1;
							const gchar* _tmp118_;
							_tmp114_ = attr;
							_tmp116_ = _tmp115_ = g_strsplit (_tmp114_, "=", 2);
							nv = _tmp116_;
							nv_length1 = _vala_array_length (_tmp115_);
							_nv_size_ = nv_length1;
							_tmp117_ = nv;
							_tmp117__length1 = nv_length1;
							_tmp118_ = _tmp117_[0];
							if (g_strcmp0 (_tmp118_, "cheader_filename") == 0) {
								ValaClass* _tmp119_;
								gchar** _tmp120_;
								gint _tmp120__length1;
								const gchar* _tmp121_;
								gchar* _tmp122_ = NULL;
								gchar* _tmp123_;
								_tmp119_ = cl;
								_tmp120_ = nv;
								_tmp120__length1 = nv_length1;
								_tmp121_ = _tmp120_[1];
								_tmp122_ = vala_gidl_parser_eval (self, _tmp121_);
								_tmp123_ = _tmp122_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp119_, "CCode", "cheader_filename", _tmp123_, NULL);
								_g_free0 (_tmp123_);
							} else {
								gchar** _tmp124_;
								gint _tmp124__length1;
								const gchar* _tmp125_;
								_tmp124_ = nv;
								_tmp124__length1 = nv_length1;
								_tmp125_ = _tmp124_[0];
								if (g_strcmp0 (_tmp125_, "hidden") == 0) {
									gchar** _tmp126_;
									gint _tmp126__length1;
									const gchar* _tmp127_;
									gchar* _tmp128_ = NULL;
									gchar* _tmp129_;
									gboolean _tmp130_;
									_tmp126_ = nv;
									_tmp126__length1 = nv_length1;
									_tmp127_ = _tmp126_[1];
									_tmp128_ = vala_gidl_parser_eval (self, _tmp127_);
									_tmp129_ = _tmp128_;
									_tmp130_ = g_strcmp0 (_tmp129_, "1") == 0;
									_g_free0 (_tmp129_);
									if (_tmp130_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp131_ = container;
			_tmp132_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, _tmp131_, (ValaSymbol*) _tmp132_);
			_tmp133_ = self->priv->current_source_file;
			_tmp134_ = cl;
			vala_source_file_add_node (_tmp133_, (ValaCodeNode*) _tmp134_);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp135_ = cl;
		_tmp136_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp135_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp136_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp137_ = un_node;
		_tmp138_ = _tmp137_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp138_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp139_;
					GIdlNodeTypeId _tmp140_;
					_tmp139_ = member;
					_tmp140_ = _tmp139_->type;
					if (_tmp140_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp141_;
						const gchar* _tmp142_;
						_tmp141_ = member;
						_tmp142_ = _tmp141_->name;
						if (g_strcmp0 (_tmp142_, "ref") == 0) {
							GIdlNode* _tmp143_;
							const gchar* _tmp144_;
							gchar* _tmp145_;
							GIdlNode* _tmp146_;
							GIdlNodeParam* _tmp147_;
							GIdlNodeType* _tmp148_;
							ValaDataType* _tmp149_ = NULL;
							ValaDataType* _tmp150_;
							_tmp143_ = member;
							_tmp144_ = ((GIdlNodeFunction*) _tmp143_)->symbol;
							_tmp145_ = g_strdup (_tmp144_);
							_g_free0 (ref_function);
							ref_function = _tmp145_;
							_tmp146_ = member;
							_tmp147_ = ((GIdlNodeFunction*) _tmp146_)->result;
							_tmp148_ = _tmp147_->type;
							_tmp149_ = vala_gidl_parser_parse_type (self, _tmp148_, NULL);
							_tmp150_ = _tmp149_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp150_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp150_);
						} else {
							GIdlNode* _tmp151_;
							const gchar* _tmp152_;
							_tmp151_ = member;
							_tmp152_ = _tmp151_->name;
							if (g_strcmp0 (_tmp152_, "unref") == 0) {
								GIdlNode* _tmp153_;
								const gchar* _tmp154_;
								gchar* _tmp155_;
								_tmp153_ = member;
								_tmp154_ = ((GIdlNodeFunction*) _tmp153_)->symbol;
								_tmp155_ = g_strdup (_tmp154_);
								_g_free0 (unref_function);
								unref_function = _tmp155_;
							} else {
								gboolean _tmp156_ = FALSE;
								GIdlNode* _tmp157_;
								const gchar* _tmp158_;
								gboolean _tmp161_;
								_tmp157_ = member;
								_tmp158_ = _tmp157_->name;
								if (g_strcmp0 (_tmp158_, "free") == 0) {
									_tmp156_ = TRUE;
								} else {
									GIdlNode* _tmp159_;
									const gchar* _tmp160_;
									_tmp159_ = member;
									_tmp160_ = _tmp159_->name;
									_tmp156_ = g_strcmp0 (_tmp160_, "destroy") == 0;
								}
								_tmp161_ = _tmp156_;
								if (_tmp161_) {
									GIdlNode* _tmp162_;
									const gchar* _tmp163_;
									gchar* _tmp164_;
									_tmp162_ = member;
									_tmp163_ = ((GIdlNodeFunction*) _tmp162_)->symbol;
									_tmp164_ = g_strdup (_tmp163_);
									_g_free0 (free_function);
									free_function = _tmp164_;
								} else {
									GIdlNode* _tmp165_;
									const gchar* _tmp166_;
									GIdlNode* _tmp170_;
									ValaMethod* _tmp171_ = NULL;
									ValaMethod* m;
									ValaMethod* _tmp172_;
									_tmp165_ = member;
									_tmp166_ = _tmp165_->name;
									if (g_strcmp0 (_tmp166_, "copy") == 0) {
										GIdlNode* _tmp167_;
										const gchar* _tmp168_;
										gchar* _tmp169_;
										_tmp167_ = member;
										_tmp168_ = ((GIdlNodeFunction*) _tmp167_)->symbol;
										_tmp169_ = g_strdup (_tmp168_);
										_g_free0 (copy_function);
										copy_function = _tmp169_;
									}
									_tmp170_ = member;
									_tmp171_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp170_, FALSE);
									m = _tmp171_;
									_tmp172_ = m;
									if (_tmp172_ != NULL) {
										ValaClass* _tmp173_;
										ValaMethod* _tmp174_;
										_tmp173_ = cl;
										_tmp174_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp173_, _tmp174_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp175_;
						GIdlNodeTypeId _tmp176_;
						_tmp175_ = member;
						_tmp176_ = _tmp175_->type;
						if (_tmp176_ == G_IDL_NODE_FIELD) {
							GIdlNode* _tmp177_;
							ValaField* _tmp178_ = NULL;
							ValaField* f;
							ValaField* _tmp179_;
							_tmp177_ = member;
							_tmp178_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp177_);
							f = _tmp178_;
							_tmp179_ = f;
							if (_tmp179_ != NULL) {
								ValaClass* _tmp180_;
								ValaField* _tmp181_;
								_tmp180_ = cl;
								_tmp181_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp180_, _tmp181_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp182_ = ref_function;
		if (_tmp182_ != NULL) {
			ValaClass* _tmp183_;
			const gchar* _tmp184_;
			gboolean _tmp185_;
			_tmp183_ = cl;
			_tmp184_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp183_, "CCode", "ref_function", _tmp184_, NULL);
			_tmp185_ = ref_function_void;
			if (_tmp185_) {
				ValaClass* _tmp186_;
				gboolean _tmp187_;
				_tmp186_ = cl;
				_tmp187_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp186_, "CCode", "ref_function_void", _tmp187_, NULL);
			}
		} else {
			const gchar* _tmp188_;
			_tmp188_ = copy_function;
			if (_tmp188_ != NULL) {
				ValaClass* _tmp189_;
				const gchar* _tmp190_;
				_tmp189_ = cl;
				_tmp190_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp189_, "CCode", "copy_function", _tmp190_, NULL);
			}
		}
		_tmp191_ = unref_function;
		if (_tmp191_ != NULL) {
			ValaClass* _tmp192_;
			const gchar* _tmp193_;
			_tmp192_ = cl;
			_tmp193_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp192_, "CCode", "unref_function", _tmp193_, NULL);
		} else {
			gboolean _tmp194_ = FALSE;
			const gchar* _tmp195_;
			gboolean _tmp202_;
			_tmp195_ = free_function;
			if (_tmp195_ != NULL) {
				const gchar* _tmp196_;
				ValaClass* _tmp197_;
				gchar* _tmp198_ = NULL;
				gchar* _tmp199_;
				gchar* _tmp200_ = NULL;
				gchar* _tmp201_;
				_tmp196_ = free_function;
				_tmp197_ = cl;
				_tmp198_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = g_strdup_printf ("%sfree", _tmp199_);
				_tmp201_ = _tmp200_;
				_tmp194_ = g_strcmp0 (_tmp196_, _tmp201_) != 0;
				_g_free0 (_tmp201_);
				_g_free0 (_tmp199_);
			} else {
				_tmp194_ = FALSE;
			}
			_tmp202_ = _tmp194_;
			if (_tmp202_) {
				ValaClass* _tmp203_;
				const gchar* _tmp204_;
				_tmp203_ = cl;
				_tmp204_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp203_, "CCode", "free_function", _tmp204_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNodeBoxed* _tmp0_;
	GIdlNode* node;
	GIdlNode* _tmp1_;
	const gchar* _tmp2_;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* name;
	GIdlNode* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	gchar** _tmp8_ = NULL;
	gchar** node_attributes;
	gint node_attributes_length1;
	gint _node_attributes_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GIdlNode* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = boxed_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = container;
	_tmp4_ = vala_gidl_parser_fix_type_name (self, _tmp2_, _tmp3_);
	name = _tmp4_;
	_tmp5_ = node;
	_tmp6_ = _tmp5_->name;
	_tmp8_ = vala_gidl_parser_get_attributes (self, _tmp6_, &_tmp7_);
	node_attributes = _tmp8_;
	node_attributes_length1 = _tmp7_;
	_node_attributes_size_ = node_attributes_length1;
	_tmp9_ = node_attributes;
	_tmp9__length1 = node_attributes_length1;
	if (_tmp9_ != NULL) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = node_attributes;
		_tmp10__length1 = node_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp10_;
			attr_collection_length1 = _tmp10__length1;
			for (attr_it = 0; attr_it < _tmp10__length1; attr_it = attr_it + 1) {
				gchar* _tmp11_;
				gchar* attr = NULL;
				_tmp11_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp11_;
				{
					const gchar* _tmp12_;
					gchar** _tmp13_;
					gchar** _tmp14_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					_tmp12_ = attr;
					_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, "=", 2);
					nv = _tmp14_;
					nv_length1 = _vala_array_length (_tmp13_);
					_nv_size_ = nv_length1;
					_tmp15_ = nv;
					_tmp15__length1 = nv_length1;
					_tmp16_ = _tmp15_[0];
					if (g_strcmp0 (_tmp16_, "hidden") == 0) {
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						return;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp17_ = node;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = vala_gidl_parser_is_reference_type (self, _tmp18_);
	if (!_tmp19_) {
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_ = NULL;
		ValaStruct* st;
		ValaStruct* _tmp25_;
		ValaStruct* _tmp105_;
		ValaTypeSymbol* _tmp106_;
		GIdlNodeBoxed* _tmp107_;
		GList* _tmp108_;
		_tmp20_ = container;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		st = G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp24_) : NULL;
		_tmp25_ = st;
		if (_tmp25_ == NULL) {
			const gchar* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaStruct* _tmp28_;
			ValaStruct* _tmp29_;
			GIdlNode* _tmp30_;
			const gchar* _tmp31_;
			gint _tmp32_ = 0;
			gchar** _tmp33_ = NULL;
			gchar** st_attributes;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp34_;
			gint _tmp34__length1;
			ValaSymbol* _tmp101_;
			ValaStruct* _tmp102_;
			ValaSourceFile* _tmp103_;
			ValaStruct* _tmp104_;
			_tmp26_ = name;
			_tmp27_ = self->priv->current_source_reference;
			_tmp28_ = vala_struct_new (_tmp26_, _tmp27_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp28_;
			_tmp29_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp29_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp30_ = node;
			_tmp31_ = _tmp30_->name;
			_tmp33_ = vala_gidl_parser_get_attributes (self, _tmp31_, &_tmp32_);
			st_attributes = _tmp33_;
			st_attributes_length1 = _tmp32_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp34_ = st_attributes;
			_tmp34__length1 = st_attributes_length1;
			if (_tmp34_ != NULL) {
				gchar** _tmp35_;
				gint _tmp35__length1;
				_tmp35_ = st_attributes;
				_tmp35__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp35_;
					attr_collection_length1 = _tmp35__length1;
					for (attr_it = 0; attr_it < _tmp35__length1; attr_it = attr_it + 1) {
						gchar* _tmp36_;
						gchar* attr = NULL;
						_tmp36_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp36_;
						{
							const gchar* _tmp37_;
							gchar** _tmp38_;
							gchar** _tmp39_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp40_;
							gint _tmp40__length1;
							const gchar* _tmp41_;
							_tmp37_ = attr;
							_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, "=", 2);
							nv = _tmp39_;
							nv_length1 = _vala_array_length (_tmp38_);
							_nv_size_ = nv_length1;
							_tmp40_ = nv;
							_tmp40__length1 = nv_length1;
							_tmp41_ = _tmp40_[0];
							if (g_strcmp0 (_tmp41_, "cheader_filename") == 0) {
								ValaStruct* _tmp42_;
								gchar** _tmp43_;
								gint _tmp43__length1;
								const gchar* _tmp44_;
								gchar* _tmp45_ = NULL;
								gchar* _tmp46_;
								_tmp42_ = st;
								_tmp43_ = nv;
								_tmp43__length1 = nv_length1;
								_tmp44_ = _tmp43_[1];
								_tmp45_ = vala_gidl_parser_eval (self, _tmp44_);
								_tmp46_ = _tmp45_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp42_, "CCode", "cheader_filename", _tmp46_, NULL);
								_g_free0 (_tmp46_);
							} else {
								gchar** _tmp47_;
								gint _tmp47__length1;
								const gchar* _tmp48_;
								_tmp47_ = nv;
								_tmp47__length1 = nv_length1;
								_tmp48_ = _tmp47_[0];
								if (g_strcmp0 (_tmp48_, "deprecated") == 0) {
									gchar** _tmp49_;
									gint _tmp49__length1;
									const gchar* _tmp50_;
									gchar* _tmp51_ = NULL;
									gchar* _tmp52_;
									gboolean _tmp53_;
									_tmp49_ = nv;
									_tmp49__length1 = nv_length1;
									_tmp50_ = _tmp49_[1];
									_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
									_tmp52_ = _tmp51_;
									_tmp53_ = g_strcmp0 (_tmp52_, "1") == 0;
									_g_free0 (_tmp52_);
									if (_tmp53_) {
										ValaStruct* _tmp54_;
										_tmp54_ = st;
										vala_code_node_set_attribute ((ValaCodeNode*) _tmp54_, "Deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp55_;
									gint _tmp55__length1;
									const gchar* _tmp56_;
									_tmp55_ = nv;
									_tmp55__length1 = nv_length1;
									_tmp56_ = _tmp55_[0];
									if (g_strcmp0 (_tmp56_, "replacement") == 0) {
										ValaStruct* _tmp57_;
										gchar** _tmp58_;
										gint _tmp58__length1;
										const gchar* _tmp59_;
										gchar* _tmp60_ = NULL;
										gchar* _tmp61_;
										_tmp57_ = st;
										_tmp58_ = nv;
										_tmp58__length1 = nv_length1;
										_tmp59_ = _tmp58_[1];
										_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
										_tmp61_ = _tmp60_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp57_, "Deprecated", "replacement", _tmp61_, NULL);
										_g_free0 (_tmp61_);
									} else {
										gchar** _tmp62_;
										gint _tmp62__length1;
										const gchar* _tmp63_;
										_tmp62_ = nv;
										_tmp62__length1 = nv_length1;
										_tmp63_ = _tmp62_[0];
										if (g_strcmp0 (_tmp63_, "deprecated_since") == 0) {
											ValaStruct* _tmp64_;
											gchar** _tmp65_;
											gint _tmp65__length1;
											const gchar* _tmp66_;
											gchar* _tmp67_ = NULL;
											gchar* _tmp68_;
											_tmp64_ = st;
											_tmp65_ = nv;
											_tmp65__length1 = nv_length1;
											_tmp66_ = _tmp65_[1];
											_tmp67_ = vala_gidl_parser_eval (self, _tmp66_);
											_tmp68_ = _tmp67_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp64_, "Deprecated", "since", _tmp68_, NULL);
											_g_free0 (_tmp68_);
										} else {
											gchar** _tmp69_;
											gint _tmp69__length1;
											const gchar* _tmp70_;
											_tmp69_ = nv;
											_tmp69__length1 = nv_length1;
											_tmp70_ = _tmp69_[0];
											if (g_strcmp0 (_tmp70_, "immutable") == 0) {
												gchar** _tmp71_;
												gint _tmp71__length1;
												const gchar* _tmp72_;
												gchar* _tmp73_ = NULL;
												gchar* _tmp74_;
												gboolean _tmp75_;
												_tmp71_ = nv;
												_tmp71__length1 = nv_length1;
												_tmp72_ = _tmp71_[1];
												_tmp73_ = vala_gidl_parser_eval (self, _tmp72_);
												_tmp74_ = _tmp73_;
												_tmp75_ = g_strcmp0 (_tmp74_, "1") == 0;
												_g_free0 (_tmp74_);
												if (_tmp75_) {
													ValaStruct* _tmp76_;
													_tmp76_ = st;
													vala_code_node_set_attribute ((ValaCodeNode*) _tmp76_, "Immutable", TRUE, NULL);
												}
											} else {
												gchar** _tmp77_;
												gint _tmp77__length1;
												const gchar* _tmp78_;
												_tmp77_ = nv;
												_tmp77__length1 = nv_length1;
												_tmp78_ = _tmp77_[0];
												if (g_strcmp0 (_tmp78_, "has_copy_function") == 0) {
													gchar** _tmp79_;
													gint _tmp79__length1;
													const gchar* _tmp80_;
													gchar* _tmp81_ = NULL;
													gchar* _tmp82_;
													gboolean _tmp83_;
													_tmp79_ = nv;
													_tmp79__length1 = nv_length1;
													_tmp80_ = _tmp79_[1];
													_tmp81_ = vala_gidl_parser_eval (self, _tmp80_);
													_tmp82_ = _tmp81_;
													_tmp83_ = g_strcmp0 (_tmp82_, "0") == 0;
													_g_free0 (_tmp82_);
													if (_tmp83_) {
														ValaStruct* _tmp84_;
														_tmp84_ = st;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp84_, "CCode", "has_copy_function", FALSE, NULL);
													}
												} else {
													gchar** _tmp85_;
													gint _tmp85__length1;
													const gchar* _tmp86_;
													_tmp85_ = nv;
													_tmp85__length1 = nv_length1;
													_tmp86_ = _tmp85_[0];
													if (g_strcmp0 (_tmp86_, "has_destroy_function") == 0) {
														gchar** _tmp87_;
														gint _tmp87__length1;
														const gchar* _tmp88_;
														gchar* _tmp89_ = NULL;
														gchar* _tmp90_;
														gboolean _tmp91_;
														_tmp87_ = nv;
														_tmp87__length1 = nv_length1;
														_tmp88_ = _tmp87_[1];
														_tmp89_ = vala_gidl_parser_eval (self, _tmp88_);
														_tmp90_ = _tmp89_;
														_tmp91_ = g_strcmp0 (_tmp90_, "0") == 0;
														_g_free0 (_tmp90_);
														if (_tmp91_) {
															ValaStruct* _tmp92_;
															_tmp92_ = st;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp92_, "CCode", "has_destroy_function", FALSE, NULL);
														}
													} else {
														gchar** _tmp93_;
														gint _tmp93__length1;
														const gchar* _tmp94_;
														_tmp93_ = nv;
														_tmp93__length1 = nv_length1;
														_tmp94_ = _tmp93_[0];
														if (g_strcmp0 (_tmp94_, "experimental") == 0) {
															gchar** _tmp95_;
															gint _tmp95__length1;
															const gchar* _tmp96_;
															gchar* _tmp97_ = NULL;
															gchar* _tmp98_;
															gboolean _tmp99_;
															_tmp95_ = nv;
															_tmp95__length1 = nv_length1;
															_tmp96_ = _tmp95_[1];
															_tmp97_ = vala_gidl_parser_eval (self, _tmp96_);
															_tmp98_ = _tmp97_;
															_tmp99_ = g_strcmp0 (_tmp98_, "1") == 0;
															_g_free0 (_tmp98_);
															if (_tmp99_) {
																ValaStruct* _tmp100_;
																_tmp100_ = st;
																vala_code_node_set_attribute ((ValaCodeNode*) _tmp100_, "Experimental", TRUE, NULL);
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp101_ = container;
			_tmp102_ = st;
			vala_gidl_parser_add_symbol_to_container (self, _tmp101_, (ValaSymbol*) _tmp102_);
			_tmp103_ = self->priv->current_source_file;
			_tmp104_ = st;
			vala_source_file_add_node (_tmp103_, (ValaCodeNode*) _tmp104_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp105_ = st;
		_tmp106_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp105_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp106_;
		_tmp107_ = boxed_node;
		_tmp108_ = _tmp107_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp108_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp109_;
					GIdlNodeTypeId _tmp110_;
					_tmp109_ = member;
					_tmp110_ = _tmp109_->type;
					if (_tmp110_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp111_;
						ValaMethod* _tmp112_ = NULL;
						ValaMethod* m;
						ValaMethod* _tmp113_;
						_tmp111_ = member;
						_tmp112_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp111_, FALSE);
						m = _tmp112_;
						_tmp113_ = m;
						if (_tmp113_ != NULL) {
							ValaStruct* _tmp114_;
							ValaMethod* _tmp115_;
							_tmp114_ = st;
							_tmp115_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp114_, _tmp115_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp116_;
						GIdlNodeTypeId _tmp117_;
						_tmp116_ = member;
						_tmp117_ = _tmp116_->type;
						if (_tmp117_ == G_IDL_NODE_FIELD) {
							GIdlNode* _tmp118_;
							ValaField* _tmp119_ = NULL;
							ValaField* f;
							ValaField* _tmp120_;
							_tmp118_ = member;
							_tmp119_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp118_);
							f = _tmp119_;
							_tmp120_ = f;
							if (_tmp120_ != NULL) {
								ValaStruct* _tmp121_;
								ValaField* _tmp122_;
								_tmp121_ = st;
								_tmp122_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp121_, _tmp122_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaSymbol* _tmp123_;
		ValaScope* _tmp124_;
		ValaScope* _tmp125_;
		const gchar* _tmp126_;
		ValaSymbol* _tmp127_ = NULL;
		ValaClass* cl;
		ValaClass* _tmp128_;
		ValaClass* _tmp244_;
		ValaTypeSymbol* _tmp245_;
		GIdlNodeBoxed* _tmp246_;
		GList* _tmp247_;
		const gchar* _tmp291_;
		const gchar* _tmp300_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp123_ = container;
		_tmp124_ = vala_symbol_get_scope (_tmp123_);
		_tmp125_ = _tmp124_;
		_tmp126_ = name;
		_tmp127_ = vala_scope_lookup (_tmp125_, _tmp126_);
		cl = G_TYPE_CHECK_INSTANCE_TYPE (_tmp127_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp127_) : NULL;
		_tmp128_ = cl;
		if (_tmp128_ == NULL) {
			gchar* base_class;
			const gchar* _tmp129_;
			ValaSourceReference* _tmp130_;
			ValaClass* _tmp131_;
			ValaClass* _tmp132_;
			ValaClass* _tmp133_;
			GIdlNodeBoxed* _tmp134_;
			const gchar* _tmp135_;
			GIdlNode* _tmp141_;
			const gchar* _tmp142_;
			gint _tmp143_ = 0;
			gchar** _tmp144_ = NULL;
			gchar** cl_attributes;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp145_;
			gint _tmp145__length1;
			ValaSymbol* _tmp235_;
			ValaClass* _tmp236_;
			ValaSourceFile* _tmp237_;
			ValaClass* _tmp238_;
			const gchar* _tmp239_;
			base_class = NULL;
			_tmp129_ = name;
			_tmp130_ = self->priv->current_source_reference;
			_tmp131_ = vala_class_new (_tmp129_, _tmp130_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp131_;
			_tmp132_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp132_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp133_ = cl;
			vala_class_set_is_compact (_tmp133_, TRUE);
			_tmp134_ = boxed_node;
			_tmp135_ = _tmp134_->gtype_init;
			if (_tmp135_ != NULL) {
				ValaClass* _tmp136_;
				GIdlNodeBoxed* _tmp137_;
				const gchar* _tmp138_;
				gchar* _tmp139_ = NULL;
				gchar* _tmp140_;
				_tmp136_ = cl;
				_tmp137_ = boxed_node;
				_tmp138_ = _tmp137_->gtype_init;
				_tmp139_ = g_strdup_printf ("%s ()", _tmp138_);
				_tmp140_ = _tmp139_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp136_, "CCode", "type_id", _tmp140_, NULL);
				_g_free0 (_tmp140_);
			}
			_tmp141_ = node;
			_tmp142_ = _tmp141_->name;
			_tmp144_ = vala_gidl_parser_get_attributes (self, _tmp142_, &_tmp143_);
			cl_attributes = _tmp144_;
			cl_attributes_length1 = _tmp143_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp145_ = cl_attributes;
			_tmp145__length1 = cl_attributes_length1;
			if (_tmp145_ != NULL) {
				gchar** _tmp146_;
				gint _tmp146__length1;
				_tmp146_ = cl_attributes;
				_tmp146__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp146_;
					attr_collection_length1 = _tmp146__length1;
					for (attr_it = 0; attr_it < _tmp146__length1; attr_it = attr_it + 1) {
						gchar* _tmp147_;
						gchar* attr = NULL;
						_tmp147_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp147_;
						{
							const gchar* _tmp148_;
							gchar** _tmp149_;
							gchar** _tmp150_ = NULL;
							gchar** nv;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp151_;
							gint _tmp151__length1;
							const gchar* _tmp152_;
							_tmp148_ = attr;
							_tmp150_ = _tmp149_ = g_strsplit (_tmp148_, "=", 2);
							nv = _tmp150_;
							nv_length1 = _vala_array_length (_tmp149_);
							_nv_size_ = nv_length1;
							_tmp151_ = nv;
							_tmp151__length1 = nv_length1;
							_tmp152_ = _tmp151_[0];
							if (g_strcmp0 (_tmp152_, "cheader_filename") == 0) {
								ValaClass* _tmp153_;
								gchar** _tmp154_;
								gint _tmp154__length1;
								const gchar* _tmp155_;
								gchar* _tmp156_ = NULL;
								gchar* _tmp157_;
								_tmp153_ = cl;
								_tmp154_ = nv;
								_tmp154__length1 = nv_length1;
								_tmp155_ = _tmp154_[1];
								_tmp156_ = vala_gidl_parser_eval (self, _tmp155_);
								_tmp157_ = _tmp156_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp153_, "CCode", "cheader_filename", _tmp157_, NULL);
								_g_free0 (_tmp157_);
							} else {
								gchar** _tmp158_;
								gint _tmp158__length1;
								const gchar* _tmp159_;
								_tmp158_ = nv;
								_tmp158__length1 = nv_length1;
								_tmp159_ = _tmp158_[0];
								if (g_strcmp0 (_tmp159_, "base_class") == 0) {
									gchar** _tmp160_;
									gint _tmp160__length1;
									const gchar* _tmp161_;
									gchar* _tmp162_ = NULL;
									_tmp160_ = nv;
									_tmp160__length1 = nv_length1;
									_tmp161_ = _tmp160_[1];
									_tmp162_ = vala_gidl_parser_eval (self, _tmp161_);
									_g_free0 (base_class);
									base_class = _tmp162_;
								} else {
									gchar** _tmp163_;
									gint _tmp163__length1;
									const gchar* _tmp164_;
									_tmp163_ = nv;
									_tmp163__length1 = nv_length1;
									_tmp164_ = _tmp163_[0];
									if (g_strcmp0 (_tmp164_, "is_immutable") == 0) {
										gchar** _tmp165_;
										gint _tmp165__length1;
										const gchar* _tmp166_;
										gchar* _tmp167_ = NULL;
										gchar* _tmp168_;
										gboolean _tmp169_;
										_tmp165_ = nv;
										_tmp165__length1 = nv_length1;
										_tmp166_ = _tmp165_[1];
										_tmp167_ = vala_gidl_parser_eval (self, _tmp166_);
										_tmp168_ = _tmp167_;
										_tmp169_ = g_strcmp0 (_tmp168_, "1") == 0;
										_g_free0 (_tmp168_);
										if (_tmp169_) {
											ValaClass* _tmp170_;
											_tmp170_ = cl;
											vala_class_set_is_immutable (_tmp170_, TRUE);
										}
									} else {
										gchar** _tmp171_;
										gint _tmp171__length1;
										const gchar* _tmp172_;
										_tmp171_ = nv;
										_tmp171__length1 = nv_length1;
										_tmp172_ = _tmp171_[0];
										if (g_strcmp0 (_tmp172_, "deprecated") == 0) {
											gchar** _tmp173_;
											gint _tmp173__length1;
											const gchar* _tmp174_;
											gchar* _tmp175_ = NULL;
											gchar* _tmp176_;
											gboolean _tmp177_;
											_tmp173_ = nv;
											_tmp173__length1 = nv_length1;
											_tmp174_ = _tmp173_[1];
											_tmp175_ = vala_gidl_parser_eval (self, _tmp174_);
											_tmp176_ = _tmp175_;
											_tmp177_ = g_strcmp0 (_tmp176_, "1") == 0;
											_g_free0 (_tmp176_);
											if (_tmp177_) {
												ValaClass* _tmp178_;
												_tmp178_ = cl;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp178_, "Deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp179_;
											gint _tmp179__length1;
											const gchar* _tmp180_;
											_tmp179_ = nv;
											_tmp179__length1 = nv_length1;
											_tmp180_ = _tmp179_[0];
											if (g_strcmp0 (_tmp180_, "replacement") == 0) {
												ValaClass* _tmp181_;
												gchar** _tmp182_;
												gint _tmp182__length1;
												const gchar* _tmp183_;
												gchar* _tmp184_ = NULL;
												gchar* _tmp185_;
												_tmp181_ = cl;
												_tmp182_ = nv;
												_tmp182__length1 = nv_length1;
												_tmp183_ = _tmp182_[1];
												_tmp184_ = vala_gidl_parser_eval (self, _tmp183_);
												_tmp185_ = _tmp184_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp181_, "Deprecated", "replacement", _tmp185_, NULL);
												_g_free0 (_tmp185_);
											} else {
												gchar** _tmp186_;
												gint _tmp186__length1;
												const gchar* _tmp187_;
												_tmp186_ = nv;
												_tmp186__length1 = nv_length1;
												_tmp187_ = _tmp186_[0];
												if (g_strcmp0 (_tmp187_, "deprecated_since") == 0) {
													ValaClass* _tmp188_;
													gchar** _tmp189_;
													gint _tmp189__length1;
													const gchar* _tmp190_;
													gchar* _tmp191_ = NULL;
													gchar* _tmp192_;
													_tmp188_ = cl;
													_tmp189_ = nv;
													_tmp189__length1 = nv_length1;
													_tmp190_ = _tmp189_[1];
													_tmp191_ = vala_gidl_parser_eval (self, _tmp190_);
													_tmp192_ = _tmp191_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp188_, "Deprecated", "since", _tmp192_, NULL);
													_g_free0 (_tmp192_);
												} else {
													gchar** _tmp193_;
													gint _tmp193__length1;
													const gchar* _tmp194_;
													_tmp193_ = nv;
													_tmp193__length1 = nv_length1;
													_tmp194_ = _tmp193_[0];
													if (g_strcmp0 (_tmp194_, "const_cname") == 0) {
														ValaClass* _tmp195_;
														gchar** _tmp196_;
														gint _tmp196__length1;
														const gchar* _tmp197_;
														gchar* _tmp198_ = NULL;
														gchar* _tmp199_;
														_tmp195_ = cl;
														_tmp196_ = nv;
														_tmp196__length1 = nv_length1;
														_tmp197_ = _tmp196_[1];
														_tmp198_ = vala_gidl_parser_eval (self, _tmp197_);
														_tmp199_ = _tmp198_;
														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp195_, "CCode", "const_cname", _tmp199_, NULL);
														_g_free0 (_tmp199_);
													} else {
														gchar** _tmp200_;
														gint _tmp200__length1;
														const gchar* _tmp201_;
														_tmp200_ = nv;
														_tmp200__length1 = nv_length1;
														_tmp201_ = _tmp200_[0];
														if (g_strcmp0 (_tmp201_, "free_function") == 0) {
															gchar** _tmp202_;
															gint _tmp202__length1;
															const gchar* _tmp203_;
															gchar* _tmp204_ = NULL;
															_tmp202_ = nv;
															_tmp202__length1 = nv_length1;
															_tmp203_ = _tmp202_[1];
															_tmp204_ = vala_gidl_parser_eval (self, _tmp203_);
															_g_free0 (free_function);
															free_function = _tmp204_;
														} else {
															gchar** _tmp205_;
															gint _tmp205__length1;
															const gchar* _tmp206_;
															_tmp205_ = nv;
															_tmp205__length1 = nv_length1;
															_tmp206_ = _tmp205_[0];
															if (g_strcmp0 (_tmp206_, "ref_function") == 0) {
																gchar** _tmp207_;
																gint _tmp207__length1;
																const gchar* _tmp208_;
																gchar* _tmp209_ = NULL;
																_tmp207_ = nv;
																_tmp207__length1 = nv_length1;
																_tmp208_ = _tmp207_[1];
																_tmp209_ = vala_gidl_parser_eval (self, _tmp208_);
																_g_free0 (ref_function);
																ref_function = _tmp209_;
															} else {
																gchar** _tmp210_;
																gint _tmp210__length1;
																const gchar* _tmp211_;
																_tmp210_ = nv;
																_tmp210__length1 = nv_length1;
																_tmp211_ = _tmp210_[0];
																if (g_strcmp0 (_tmp211_, "unref_function") == 0) {
																	gchar** _tmp212_;
																	gint _tmp212__length1;
																	const gchar* _tmp213_;
																	gchar* _tmp214_ = NULL;
																	_tmp212_ = nv;
																	_tmp212__length1 = nv_length1;
																	_tmp213_ = _tmp212_[1];
																	_tmp214_ = vala_gidl_parser_eval (self, _tmp213_);
																	_g_free0 (unref_function);
																	unref_function = _tmp214_;
																} else {
																	gchar** _tmp215_;
																	gint _tmp215__length1;
																	const gchar* _tmp216_;
																	_tmp215_ = nv;
																	_tmp215__length1 = nv_length1;
																	_tmp216_ = _tmp215_[0];
																	if (g_strcmp0 (_tmp216_, "copy_function") == 0) {
																		gchar** _tmp217_;
																		gint _tmp217__length1;
																		const gchar* _tmp218_;
																		gchar* _tmp219_ = NULL;
																		_tmp217_ = nv;
																		_tmp217__length1 = nv_length1;
																		_tmp218_ = _tmp217_[1];
																		_tmp219_ = vala_gidl_parser_eval (self, _tmp218_);
																		_g_free0 (copy_function);
																		copy_function = _tmp219_;
																	} else {
																		gchar** _tmp220_;
																		gint _tmp220__length1;
																		const gchar* _tmp221_;
																		_tmp220_ = nv;
																		_tmp220__length1 = nv_length1;
																		_tmp221_ = _tmp220_[0];
																		if (g_strcmp0 (_tmp221_, "ref_function_void") == 0) {
																			gchar** _tmp222_;
																			gint _tmp222__length1;
																			const gchar* _tmp223_;
																			gchar* _tmp224_ = NULL;
																			gchar* _tmp225_;
																			gboolean _tmp226_;
																			_tmp222_ = nv;
																			_tmp222__length1 = nv_length1;
																			_tmp223_ = _tmp222_[1];
																			_tmp224_ = vala_gidl_parser_eval (self, _tmp223_);
																			_tmp225_ = _tmp224_;
																			_tmp226_ = g_strcmp0 (_tmp225_, "1") == 0;
																			_g_free0 (_tmp225_);
																			if (_tmp226_) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			gchar** _tmp227_;
																			gint _tmp227__length1;
																			const gchar* _tmp228_;
																			_tmp227_ = nv;
																			_tmp227__length1 = nv_length1;
																			_tmp228_ = _tmp227_[0];
																			if (g_strcmp0 (_tmp228_, "experimental") == 0) {
																				gchar** _tmp229_;
																				gint _tmp229__length1;
																				const gchar* _tmp230_;
																				gchar* _tmp231_ = NULL;
																				gchar* _tmp232_;
																				gboolean _tmp233_;
																				_tmp229_ = nv;
																				_tmp229__length1 = nv_length1;
																				_tmp230_ = _tmp229_[1];
																				_tmp231_ = vala_gidl_parser_eval (self, _tmp230_);
																				_tmp232_ = _tmp231_;
																				_tmp233_ = g_strcmp0 (_tmp232_, "1") == 0;
																				_g_free0 (_tmp232_);
																				if (_tmp233_) {
																					ValaClass* _tmp234_;
																					_tmp234_ = cl;
																					vala_code_node_set_attribute ((ValaCodeNode*) _tmp234_, "Experimental", TRUE, NULL);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp235_ = container;
			_tmp236_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, _tmp235_, (ValaSymbol*) _tmp236_);
			_tmp237_ = self->priv->current_source_file;
			_tmp238_ = cl;
			vala_source_file_add_node (_tmp237_, (ValaCodeNode*) _tmp238_);
			_tmp239_ = base_class;
			if (_tmp239_ != NULL) {
				const gchar* _tmp240_;
				ValaDataType* _tmp241_ = NULL;
				ValaDataType* parent;
				ValaClass* _tmp242_;
				ValaDataType* _tmp243_;
				_tmp240_ = base_class;
				_tmp241_ = vala_gidl_parser_parse_type_string (self, _tmp240_);
				parent = _tmp241_;
				_tmp242_ = cl;
				_tmp243_ = parent;
				vala_class_add_base_type (_tmp242_, _tmp243_);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp244_ = cl;
		_tmp245_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp244_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp245_;
		_tmp246_ = boxed_node;
		_tmp247_ = _tmp246_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp247_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp248_;
					GIdlNodeTypeId _tmp249_;
					_tmp248_ = member;
					_tmp249_ = _tmp248_->type;
					if (_tmp249_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp250_;
						const gchar* _tmp251_;
						_tmp250_ = member;
						_tmp251_ = _tmp250_->name;
						if (g_strcmp0 (_tmp251_, "ref") == 0) {
							GIdlNode* _tmp252_;
							const gchar* _tmp253_;
							gchar* _tmp254_;
							GIdlNode* _tmp255_;
							GIdlNodeParam* _tmp256_;
							GIdlNodeType* _tmp257_;
							ValaDataType* _tmp258_ = NULL;
							ValaDataType* _tmp259_;
							_tmp252_ = member;
							_tmp253_ = ((GIdlNodeFunction*) _tmp252_)->symbol;
							_tmp254_ = g_strdup (_tmp253_);
							_g_free0 (ref_function);
							ref_function = _tmp254_;
							_tmp255_ = member;
							_tmp256_ = ((GIdlNodeFunction*) _tmp255_)->result;
							_tmp257_ = _tmp256_->type;
							_tmp258_ = vala_gidl_parser_parse_type (self, _tmp257_, NULL);
							_tmp259_ = _tmp258_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp259_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp259_);
						} else {
							GIdlNode* _tmp260_;
							const gchar* _tmp261_;
							_tmp260_ = member;
							_tmp261_ = _tmp260_->name;
							if (g_strcmp0 (_tmp261_, "unref") == 0) {
								GIdlNode* _tmp262_;
								const gchar* _tmp263_;
								gchar* _tmp264_;
								_tmp262_ = member;
								_tmp263_ = ((GIdlNodeFunction*) _tmp262_)->symbol;
								_tmp264_ = g_strdup (_tmp263_);
								_g_free0 (unref_function);
								unref_function = _tmp264_;
							} else {
								gboolean _tmp265_ = FALSE;
								GIdlNode* _tmp266_;
								const gchar* _tmp267_;
								gboolean _tmp270_;
								_tmp266_ = member;
								_tmp267_ = _tmp266_->name;
								if (g_strcmp0 (_tmp267_, "free") == 0) {
									_tmp265_ = TRUE;
								} else {
									GIdlNode* _tmp268_;
									const gchar* _tmp269_;
									_tmp268_ = member;
									_tmp269_ = _tmp268_->name;
									_tmp265_ = g_strcmp0 (_tmp269_, "destroy") == 0;
								}
								_tmp270_ = _tmp265_;
								if (_tmp270_) {
									GIdlNode* _tmp271_;
									const gchar* _tmp272_;
									gchar* _tmp273_;
									_tmp271_ = member;
									_tmp272_ = ((GIdlNodeFunction*) _tmp271_)->symbol;
									_tmp273_ = g_strdup (_tmp272_);
									_g_free0 (free_function);
									free_function = _tmp273_;
								} else {
									GIdlNode* _tmp274_;
									const gchar* _tmp275_;
									GIdlNode* _tmp279_;
									ValaMethod* _tmp280_ = NULL;
									ValaMethod* m;
									ValaMethod* _tmp281_;
									_tmp274_ = member;
									_tmp275_ = _tmp274_->name;
									if (g_strcmp0 (_tmp275_, "copy") == 0) {
										GIdlNode* _tmp276_;
										const gchar* _tmp277_;
										gchar* _tmp278_;
										_tmp276_ = member;
										_tmp277_ = ((GIdlNodeFunction*) _tmp276_)->symbol;
										_tmp278_ = g_strdup (_tmp277_);
										_g_free0 (copy_function);
										copy_function = _tmp278_;
									}
									_tmp279_ = member;
									_tmp280_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp279_, FALSE);
									m = _tmp280_;
									_tmp281_ = m;
									if (_tmp281_ != NULL) {
										ValaClass* _tmp282_;
										ValaMethod* _tmp283_;
										_tmp282_ = cl;
										_tmp283_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp282_, _tmp283_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp284_;
						GIdlNodeTypeId _tmp285_;
						_tmp284_ = member;
						_tmp285_ = _tmp284_->type;
						if (_tmp285_ == G_IDL_NODE_FIELD) {
							GIdlNode* _tmp286_;
							ValaField* _tmp287_ = NULL;
							ValaField* f;
							ValaField* _tmp288_;
							_tmp286_ = member;
							_tmp287_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp286_);
							f = _tmp287_;
							_tmp288_ = f;
							if (_tmp288_ != NULL) {
								ValaClass* _tmp289_;
								ValaField* _tmp290_;
								_tmp289_ = cl;
								_tmp290_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp289_, _tmp290_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp291_ = ref_function;
		if (_tmp291_ != NULL) {
			ValaClass* _tmp292_;
			const gchar* _tmp293_;
			gboolean _tmp294_;
			_tmp292_ = cl;
			_tmp293_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp292_, "CCode", "ref_function", _tmp293_, NULL);
			_tmp294_ = ref_function_void;
			if (_tmp294_) {
				ValaClass* _tmp295_;
				gboolean _tmp296_;
				_tmp295_ = cl;
				_tmp296_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp295_, "CCode", "ref_function_void", _tmp296_, NULL);
			}
		} else {
			const gchar* _tmp297_;
			_tmp297_ = copy_function;
			if (_tmp297_ != NULL) {
				ValaClass* _tmp298_;
				const gchar* _tmp299_;
				_tmp298_ = cl;
				_tmp299_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp298_, "CCode", "copy_function", _tmp299_, NULL);
			}
		}
		_tmp300_ = unref_function;
		if (_tmp300_ != NULL) {
			ValaClass* _tmp301_;
			const gchar* _tmp302_;
			_tmp301_ = cl;
			_tmp302_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp301_, "CCode", "unref_function", _tmp302_, NULL);
		} else {
			gboolean _tmp303_ = FALSE;
			const gchar* _tmp304_;
			gboolean _tmp311_;
			_tmp304_ = free_function;
			if (_tmp304_ != NULL) {
				const gchar* _tmp305_;
				ValaClass* _tmp306_;
				gchar* _tmp307_ = NULL;
				gchar* _tmp308_;
				gchar* _tmp309_ = NULL;
				gchar* _tmp310_;
				_tmp305_ = free_function;
				_tmp306_ = cl;
				_tmp307_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp306_);
				_tmp308_ = _tmp307_;
				_tmp309_ = g_strdup_printf ("%sfree", _tmp308_);
				_tmp310_ = _tmp309_;
				_tmp303_ = g_strcmp0 (_tmp305_, _tmp310_) != 0;
				_g_free0 (_tmp310_);
				_g_free0 (_tmp308_);
			} else {
				_tmp303_ = FALSE;
			}
			_tmp311_ = _tmp303_;
			if (_tmp311_) {
				ValaClass* _tmp312_;
				const gchar* _tmp313_;
				_tmp312_ = cl;
				_tmp313_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp312_, "CCode", "free_function", _tmp313_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags) {
	GIdlNodeEnum* _tmp0_;
	GIdlNode* node;
	GIdlNode* _tmp1_;
	const gchar* _tmp2_;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* name;
	gboolean existing;
	ValaSymbol* _tmp5_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	const gchar* _tmp8_;
	ValaSymbol* _tmp9_ = NULL;
	ValaEnum* en;
	ValaEnum* _tmp10_;
	gboolean _tmp27_ = FALSE;
	GIdlNodeEnum* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp32_;
	gchar* common_prefix;
	GIdlNodeEnum* _tmp34_;
	GList* _tmp35_;
	gboolean is_errordomain;
	gchar* cheader_filename;
	GIdlNode* _tmp110_;
	const gchar* _tmp111_;
	gint _tmp112_ = 0;
	gchar** _tmp113_ = NULL;
	gchar** en_attributes;
	gint en_attributes_length1;
	gint _en_attributes_size_;
	gchar** _tmp114_;
	gint _tmp114__length1;
	ValaEnum* _tmp208_;
	const gchar* _tmp209_;
	GIdlNodeEnum* _tmp210_;
	GList* _tmp211_;
	gboolean _tmp264_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = en_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = container;
	_tmp4_ = vala_gidl_parser_fix_type_name (self, _tmp2_, _tmp3_);
	name = _tmp4_;
	existing = TRUE;
	_tmp5_ = container;
	_tmp6_ = vala_symbol_get_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = name;
	_tmp9_ = vala_scope_lookup (_tmp7_, _tmp8_);
	en = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ENUM) ? ((ValaEnum*) _tmp9_) : NULL;
	_tmp10_ = en;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaEnum* _tmp13_;
		ValaEnum* _tmp14_;
		_tmp11_ = name;
		_tmp12_ = self->priv->current_source_reference;
		_tmp13_ = vala_enum_new (_tmp11_, _tmp12_, NULL);
		_vala_code_node_unref0 (en);
		en = _tmp13_;
		_tmp14_ = en;
		vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		existing = FALSE;
	} else {
		ValaEnum* _tmp15_;
		ValaScope* _tmp16_;
		ValaScope* _tmp17_;
		ValaSymbol* _tmp18_ = NULL;
		ValaEnumValue* dummy;
		ValaEnumValue* _tmp19_;
		_tmp15_ = en;
		_tmp16_ = vala_symbol_get_scope ((ValaSymbol*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_scope_lookup (_tmp17_, "__DUMMY__");
		dummy = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_ENUM_VALUE, ValaEnumValue);
		_tmp19_ = dummy;
		if (_tmp19_ != NULL) {
			ValaEnum* _tmp20_;
			ValaList* _tmp21_ = NULL;
			ValaList* _tmp22_;
			ValaEnumValue* _tmp23_;
			ValaEnum* _tmp24_;
			ValaScope* _tmp25_;
			ValaScope* _tmp26_;
			_tmp20_ = en;
			_tmp21_ = vala_enum_get_values (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = dummy;
			vala_collection_remove ((ValaCollection*) _tmp22_, _tmp23_);
			_vala_iterable_unref0 (_tmp22_);
			_tmp24_ = en;
			_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) _tmp24_);
			_tmp26_ = _tmp25_;
			vala_scope_remove (_tmp26_, "__DUMMY__");
		}
		_vala_code_node_unref0 (dummy);
	}
	_tmp28_ = en_node;
	_tmp29_ = _tmp28_->gtype_name;
	if (_tmp29_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		GIdlNodeEnum* _tmp30_;
		const gchar* _tmp31_;
		_tmp30_ = en_node;
		_tmp31_ = _tmp30_->gtype_name;
		_tmp27_ = g_strcmp0 (_tmp31_, "") == 0;
	}
	_tmp32_ = _tmp27_;
	if (_tmp32_) {
		ValaEnum* _tmp33_;
		_tmp33_ = en;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp33_, "CCode", "has_type_id", FALSE, NULL);
	}
	common_prefix = NULL;
	_tmp34_ = en_node;
	_tmp35_ = _tmp34_->values;
	{
		GList* value_collection = NULL;
		GList* value_it = NULL;
		value_collection = _tmp35_;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value = NULL;
			value = (GIdlNode*) value_it->data;
			{
				GIdlNode* _tmp36_;
				const gchar* _tmp37_;
				gint _tmp38_ = 0;
				gchar** _tmp39_ = NULL;
				gchar** val_attributes;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gboolean is_hidden;
				gchar** _tmp40_;
				gint _tmp40__length1;
				gboolean _tmp54_;
				const gchar* _tmp55_;
				_tmp36_ = value;
				_tmp37_ = _tmp36_->name;
				_tmp39_ = vala_gidl_parser_get_attributes (self, _tmp37_, &_tmp38_);
				val_attributes = _tmp39_;
				val_attributes_length1 = _tmp38_;
				_val_attributes_size_ = val_attributes_length1;
				is_hidden = FALSE;
				_tmp40_ = val_attributes;
				_tmp40__length1 = val_attributes_length1;
				if (_tmp40_ != NULL) {
					gchar** _tmp41_;
					gint _tmp41__length1;
					_tmp41_ = val_attributes;
					_tmp41__length1 = val_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp41_;
						attr_collection_length1 = _tmp41__length1;
						for (attr_it = 0; attr_it < _tmp41__length1; attr_it = attr_it + 1) {
							gchar* _tmp42_;
							gchar* attr = NULL;
							_tmp42_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp42_;
							{
								const gchar* _tmp43_;
								gchar** _tmp44_;
								gchar** _tmp45_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								gboolean _tmp46_ = FALSE;
								gchar** _tmp47_;
								gint _tmp47__length1;
								const gchar* _tmp48_;
								gboolean _tmp53_;
								_tmp43_ = attr;
								_tmp45_ = _tmp44_ = g_strsplit (_tmp43_, "=", 2);
								nv = _tmp45_;
								nv_length1 = _vala_array_length (_tmp44_);
								_nv_size_ = nv_length1;
								_tmp47_ = nv;
								_tmp47__length1 = nv_length1;
								_tmp48_ = _tmp47_[0];
								if (g_strcmp0 (_tmp48_, "hidden") == 0) {
									gchar** _tmp49_;
									gint _tmp49__length1;
									const gchar* _tmp50_;
									gchar* _tmp51_ = NULL;
									gchar* _tmp52_;
									_tmp49_ = nv;
									_tmp49__length1 = nv_length1;
									_tmp50_ = _tmp49_[1];
									_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
									_tmp52_ = _tmp51_;
									_tmp46_ = g_strcmp0 (_tmp52_, "1") == 0;
									_g_free0 (_tmp52_);
								} else {
									_tmp46_ = FALSE;
								}
								_tmp53_ = _tmp46_;
								if (_tmp53_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp54_ = is_hidden;
				if (_tmp54_) {
					val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				_tmp55_ = common_prefix;
				if (_tmp55_ == NULL) {
					GIdlNode* _tmp56_;
					const gchar* _tmp57_;
					gchar* _tmp58_;
					_tmp56_ = value;
					_tmp57_ = _tmp56_->name;
					_tmp58_ = g_strdup (_tmp57_);
					_g_free0 (common_prefix);
					common_prefix = _tmp58_;
					while (TRUE) {
						gboolean _tmp59_ = FALSE;
						const gchar* _tmp60_;
						gint _tmp61_;
						gint _tmp62_;
						gboolean _tmp65_;
						const gchar* _tmp66_;
						const gchar* _tmp67_;
						gint _tmp68_;
						gint _tmp69_;
						gchar* _tmp70_ = NULL;
						_tmp60_ = common_prefix;
						_tmp61_ = strlen (_tmp60_);
						_tmp62_ = _tmp61_;
						if (_tmp62_ > 0) {
							const gchar* _tmp63_;
							gboolean _tmp64_ = FALSE;
							_tmp63_ = common_prefix;
							_tmp64_ = g_str_has_suffix (_tmp63_, "_");
							_tmp59_ = !_tmp64_;
						} else {
							_tmp59_ = FALSE;
						}
						_tmp65_ = _tmp59_;
						if (!_tmp65_) {
							break;
						}
						_tmp66_ = common_prefix;
						_tmp67_ = common_prefix;
						_tmp68_ = strlen (_tmp67_);
						_tmp69_ = _tmp68_;
						_tmp70_ = string_substring (_tmp66_, (glong) 0, (glong) (_tmp69_ - 1));
						_g_free0 (common_prefix);
						common_prefix = _tmp70_;
					}
				} else {
					while (TRUE) {
						GIdlNode* _tmp71_;
						const gchar* _tmp72_;
						const gchar* _tmp73_;
						gboolean _tmp74_ = FALSE;
						const gchar* _tmp75_;
						const gchar* _tmp76_;
						gint _tmp77_;
						gint _tmp78_;
						gchar* _tmp79_ = NULL;
						_tmp71_ = value;
						_tmp72_ = _tmp71_->name;
						_tmp73_ = common_prefix;
						_tmp74_ = g_str_has_prefix (_tmp72_, _tmp73_);
						if (!(!_tmp74_)) {
							break;
						}
						_tmp75_ = common_prefix;
						_tmp76_ = common_prefix;
						_tmp77_ = strlen (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = string_substring (_tmp75_, (glong) 0, (glong) (_tmp78_ - 1));
						_g_free0 (common_prefix);
						common_prefix = _tmp79_;
					}
				}
				while (TRUE) {
					gboolean _tmp80_ = FALSE;
					const gchar* _tmp81_;
					gint _tmp82_;
					gint _tmp83_;
					gboolean _tmp104_;
					const gchar* _tmp105_;
					const gchar* _tmp106_;
					gint _tmp107_;
					gint _tmp108_;
					gchar* _tmp109_ = NULL;
					_tmp81_ = common_prefix;
					_tmp82_ = strlen (_tmp81_);
					_tmp83_ = _tmp82_;
					if (_tmp83_ > 0) {
						gboolean _tmp84_ = FALSE;
						const gchar* _tmp85_;
						gboolean _tmp86_ = FALSE;
						gboolean _tmp103_;
						_tmp85_ = common_prefix;
						_tmp86_ = g_str_has_suffix (_tmp85_, "_");
						if (!_tmp86_) {
							_tmp84_ = TRUE;
						} else {
							gboolean _tmp87_ = FALSE;
							GIdlNode* _tmp88_;
							const gchar* _tmp89_;
							const gchar* _tmp90_;
							gint _tmp91_;
							gint _tmp92_;
							gunichar _tmp93_ = 0U;
							gboolean _tmp94_ = FALSE;
							gboolean _tmp102_;
							_tmp88_ = value;
							_tmp89_ = _tmp88_->name;
							_tmp90_ = common_prefix;
							_tmp91_ = strlen (_tmp90_);
							_tmp92_ = _tmp91_;
							_tmp93_ = string_get_char (_tmp89_, (glong) _tmp92_);
							_tmp94_ = g_unichar_isdigit (_tmp93_);
							if (_tmp94_) {
								GIdlNode* _tmp95_;
								const gchar* _tmp96_;
								gint _tmp97_;
								gint _tmp98_;
								const gchar* _tmp99_;
								gint _tmp100_;
								gint _tmp101_;
								_tmp95_ = value;
								_tmp96_ = _tmp95_->name;
								_tmp97_ = strlen (_tmp96_);
								_tmp98_ = _tmp97_;
								_tmp99_ = common_prefix;
								_tmp100_ = strlen (_tmp99_);
								_tmp101_ = _tmp100_;
								_tmp87_ = (_tmp98_ - _tmp101_) <= 1;
							} else {
								_tmp87_ = FALSE;
							}
							_tmp102_ = _tmp87_;
							_tmp84_ = _tmp102_;
						}
						_tmp103_ = _tmp84_;
						_tmp80_ = _tmp103_;
					} else {
						_tmp80_ = FALSE;
					}
					_tmp104_ = _tmp80_;
					if (!_tmp104_) {
						break;
					}
					_tmp105_ = common_prefix;
					_tmp106_ = common_prefix;
					_tmp107_ = strlen (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = string_substring (_tmp105_, (glong) 0, (glong) (_tmp108_ - 1));
					_g_free0 (common_prefix);
					common_prefix = _tmp109_;
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	is_errordomain = FALSE;
	cheader_filename = NULL;
	_tmp110_ = node;
	_tmp111_ = _tmp110_->name;
	_tmp113_ = vala_gidl_parser_get_attributes (self, _tmp111_, &_tmp112_);
	en_attributes = _tmp113_;
	en_attributes_length1 = _tmp112_;
	_en_attributes_size_ = en_attributes_length1;
	_tmp114_ = en_attributes;
	_tmp114__length1 = en_attributes_length1;
	if (_tmp114_ != NULL) {
		gchar** _tmp115_;
		gint _tmp115__length1;
		_tmp115_ = en_attributes;
		_tmp115__length1 = en_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp115_;
			attr_collection_length1 = _tmp115__length1;
			for (attr_it = 0; attr_it < _tmp115__length1; attr_it = attr_it + 1) {
				gchar* _tmp116_;
				gchar* attr = NULL;
				_tmp116_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp116_;
				{
					const gchar* _tmp117_;
					gchar** _tmp118_;
					gchar** _tmp119_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp120_;
					gint _tmp120__length1;
					const gchar* _tmp121_;
					_tmp117_ = attr;
					_tmp119_ = _tmp118_ = g_strsplit (_tmp117_, "=", 2);
					nv = _tmp119_;
					nv_length1 = _vala_array_length (_tmp118_);
					_nv_size_ = nv_length1;
					_tmp120_ = nv;
					_tmp120__length1 = nv_length1;
					_tmp121_ = _tmp120_[0];
					if (g_strcmp0 (_tmp121_, "common_prefix") == 0) {
						gchar** _tmp122_;
						gint _tmp122__length1;
						const gchar* _tmp123_;
						gchar* _tmp124_ = NULL;
						_tmp122_ = nv;
						_tmp122__length1 = nv_length1;
						_tmp123_ = _tmp122_[1];
						_tmp124_ = vala_gidl_parser_eval (self, _tmp123_);
						_g_free0 (common_prefix);
						common_prefix = _tmp124_;
					} else {
						gchar** _tmp125_;
						gint _tmp125__length1;
						const gchar* _tmp126_;
						_tmp125_ = nv;
						_tmp125__length1 = nv_length1;
						_tmp126_ = _tmp125_[0];
						if (g_strcmp0 (_tmp126_, "cheader_filename") == 0) {
							gchar** _tmp127_;
							gint _tmp127__length1;
							const gchar* _tmp128_;
							gchar* _tmp129_ = NULL;
							ValaEnum* _tmp130_;
							const gchar* _tmp131_;
							_tmp127_ = nv;
							_tmp127__length1 = nv_length1;
							_tmp128_ = _tmp127_[1];
							_tmp129_ = vala_gidl_parser_eval (self, _tmp128_);
							_g_free0 (cheader_filename);
							cheader_filename = _tmp129_;
							_tmp130_ = en;
							_tmp131_ = cheader_filename;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp130_, "CCode", "cheader_filename", _tmp131_, NULL);
						} else {
							gchar** _tmp132_;
							gint _tmp132__length1;
							const gchar* _tmp133_;
							_tmp132_ = nv;
							_tmp132__length1 = nv_length1;
							_tmp133_ = _tmp132_[0];
							if (g_strcmp0 (_tmp133_, "hidden") == 0) {
								gchar** _tmp134_;
								gint _tmp134__length1;
								const gchar* _tmp135_;
								gchar* _tmp136_ = NULL;
								gchar* _tmp137_;
								gboolean _tmp138_;
								_tmp134_ = nv;
								_tmp134__length1 = nv_length1;
								_tmp135_ = _tmp134_[1];
								_tmp136_ = vala_gidl_parser_eval (self, _tmp135_);
								_tmp137_ = _tmp136_;
								_tmp138_ = g_strcmp0 (_tmp137_, "1") == 0;
								_g_free0 (_tmp137_);
								if (_tmp138_) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (cheader_filename);
									_g_free0 (common_prefix);
									_vala_code_node_unref0 (en);
									_g_free0 (name);
									return;
								}
							} else {
								gchar** _tmp139_;
								gint _tmp139__length1;
								const gchar* _tmp140_;
								_tmp139_ = nv;
								_tmp139__length1 = nv_length1;
								_tmp140_ = _tmp139_[0];
								if (g_strcmp0 (_tmp140_, "deprecated") == 0) {
									gchar** _tmp141_;
									gint _tmp141__length1;
									const gchar* _tmp142_;
									gchar* _tmp143_ = NULL;
									gchar* _tmp144_;
									gboolean _tmp145_;
									_tmp141_ = nv;
									_tmp141__length1 = nv_length1;
									_tmp142_ = _tmp141_[1];
									_tmp143_ = vala_gidl_parser_eval (self, _tmp142_);
									_tmp144_ = _tmp143_;
									_tmp145_ = g_strcmp0 (_tmp144_, "1") == 0;
									_g_free0 (_tmp144_);
									if (_tmp145_) {
										ValaEnum* _tmp146_;
										_tmp146_ = en;
										vala_code_node_set_attribute ((ValaCodeNode*) _tmp146_, "Deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp147_;
									gint _tmp147__length1;
									const gchar* _tmp148_;
									_tmp147_ = nv;
									_tmp147__length1 = nv_length1;
									_tmp148_ = _tmp147_[0];
									if (g_strcmp0 (_tmp148_, "default_value") == 0) {
										ValaEnum* _tmp149_;
										gchar** _tmp150_;
										gint _tmp150__length1;
										const gchar* _tmp151_;
										gchar* _tmp152_ = NULL;
										gchar* _tmp153_;
										_tmp149_ = en;
										_tmp150_ = nv;
										_tmp150__length1 = nv_length1;
										_tmp151_ = _tmp150_[1];
										_tmp152_ = vala_gidl_parser_eval (self, _tmp151_);
										_tmp153_ = _tmp152_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp149_, "CCode", "default_value", _tmp153_, NULL);
										_g_free0 (_tmp153_);
									} else {
										gchar** _tmp154_;
										gint _tmp154__length1;
										const gchar* _tmp155_;
										_tmp154_ = nv;
										_tmp154__length1 = nv_length1;
										_tmp155_ = _tmp154_[0];
										if (g_strcmp0 (_tmp155_, "replacement") == 0) {
											ValaEnum* _tmp156_;
											gchar** _tmp157_;
											gint _tmp157__length1;
											const gchar* _tmp158_;
											gchar* _tmp159_ = NULL;
											gchar* _tmp160_;
											_tmp156_ = en;
											_tmp157_ = nv;
											_tmp157__length1 = nv_length1;
											_tmp158_ = _tmp157_[1];
											_tmp159_ = vala_gidl_parser_eval (self, _tmp158_);
											_tmp160_ = _tmp159_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp156_, "Deprecated", "replacement", _tmp160_, NULL);
											_g_free0 (_tmp160_);
										} else {
											gchar** _tmp161_;
											gint _tmp161__length1;
											const gchar* _tmp162_;
											_tmp161_ = nv;
											_tmp161__length1 = nv_length1;
											_tmp162_ = _tmp161_[0];
											if (g_strcmp0 (_tmp162_, "deprecated_since") == 0) {
												ValaEnum* _tmp163_;
												gchar** _tmp164_;
												gint _tmp164__length1;
												const gchar* _tmp165_;
												gchar* _tmp166_ = NULL;
												gchar* _tmp167_;
												_tmp163_ = en;
												_tmp164_ = nv;
												_tmp164__length1 = nv_length1;
												_tmp165_ = _tmp164_[1];
												_tmp166_ = vala_gidl_parser_eval (self, _tmp165_);
												_tmp167_ = _tmp166_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp163_, "Deprecated", "since", _tmp167_, NULL);
												_g_free0 (_tmp167_);
											} else {
												gchar** _tmp168_;
												gint _tmp168__length1;
												const gchar* _tmp169_;
												_tmp168_ = nv;
												_tmp168__length1 = nv_length1;
												_tmp169_ = _tmp168_[0];
												if (g_strcmp0 (_tmp169_, "rename_to") == 0) {
													ValaEnum* _tmp170_;
													gchar** _tmp171_;
													gint _tmp171__length1;
													const gchar* _tmp172_;
													gchar* _tmp173_ = NULL;
													gchar* _tmp174_;
													_tmp170_ = en;
													_tmp171_ = nv;
													_tmp171__length1 = nv_length1;
													_tmp172_ = _tmp171_[1];
													_tmp173_ = vala_gidl_parser_eval (self, _tmp172_);
													_tmp174_ = _tmp173_;
													vala_symbol_set_name ((ValaSymbol*) _tmp170_, _tmp174_);
													_g_free0 (_tmp174_);
												} else {
													gchar** _tmp175_;
													gint _tmp175__length1;
													const gchar* _tmp176_;
													_tmp175_ = nv;
													_tmp175__length1 = nv_length1;
													_tmp176_ = _tmp175_[0];
													if (g_strcmp0 (_tmp176_, "errordomain") == 0) {
														gchar** _tmp177_;
														gint _tmp177__length1;
														const gchar* _tmp178_;
														gchar* _tmp179_ = NULL;
														gchar* _tmp180_;
														gboolean _tmp181_;
														_tmp177_ = nv;
														_tmp177__length1 = nv_length1;
														_tmp178_ = _tmp177_[1];
														_tmp179_ = vala_gidl_parser_eval (self, _tmp178_);
														_tmp180_ = _tmp179_;
														_tmp181_ = g_strcmp0 (_tmp180_, "1") == 0;
														_g_free0 (_tmp180_);
														if (_tmp181_) {
															is_errordomain = TRUE;
														}
													} else {
														gchar** _tmp182_;
														gint _tmp182__length1;
														const gchar* _tmp183_;
														_tmp182_ = nv;
														_tmp182__length1 = nv_length1;
														_tmp183_ = _tmp182_[0];
														if (g_strcmp0 (_tmp183_, "to_string") == 0) {
															ValaUnresolvedType* _tmp184_;
															ValaUnresolvedType* return_type;
															ValaUnresolvedType* _tmp185_;
															ValaUnresolvedSymbol* _tmp186_;
															ValaUnresolvedSymbol* _tmp187_;
															ValaUnresolvedType* _tmp188_;
															ValaUnresolvedType* _tmp189_;
															ValaSourceReference* _tmp190_;
															ValaMethod* _tmp191_;
															ValaMethod* m;
															ValaMethod* _tmp192_;
															ValaMethod* _tmp193_;
															gchar** _tmp194_;
															gint _tmp194__length1;
															const gchar* _tmp195_;
															gchar* _tmp196_ = NULL;
															gchar* _tmp197_;
															ValaEnum* _tmp198_;
															ValaMethod* _tmp199_;
															_tmp184_ = vala_unresolved_type_new ();
															return_type = _tmp184_;
															_tmp185_ = return_type;
															_tmp186_ = vala_unresolved_symbol_new (NULL, "string", NULL);
															_tmp187_ = _tmp186_;
															vala_unresolved_type_set_unresolved_symbol (_tmp185_, _tmp187_);
															_vala_code_node_unref0 (_tmp187_);
															_tmp188_ = return_type;
															vala_data_type_set_value_owned ((ValaDataType*) _tmp188_, FALSE);
															_tmp189_ = return_type;
															_tmp190_ = self->priv->current_source_reference;
															_tmp191_ = vala_method_new ("to_string", (ValaDataType*) _tmp189_, _tmp190_, NULL);
															m = _tmp191_;
															_tmp192_ = m;
															vala_symbol_set_access ((ValaSymbol*) _tmp192_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
															_tmp193_ = m;
															_tmp194_ = nv;
															_tmp194__length1 = nv_length1;
															_tmp195_ = _tmp194_[1];
															_tmp196_ = vala_gidl_parser_eval (self, _tmp195_);
															_tmp197_ = _tmp196_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp193_, "CCode", "cname", _tmp197_, NULL);
															_g_free0 (_tmp197_);
															_tmp198_ = en;
															_tmp199_ = m;
															vala_symbol_add_method ((ValaSymbol*) _tmp198_, _tmp199_);
															_vala_code_node_unref0 (m);
															_vala_code_node_unref0 (return_type);
														} else {
															gchar** _tmp200_;
															gint _tmp200__length1;
															const gchar* _tmp201_;
															_tmp200_ = nv;
															_tmp200__length1 = nv_length1;
															_tmp201_ = _tmp200_[0];
															if (g_strcmp0 (_tmp201_, "experimental") == 0) {
																gchar** _tmp202_;
																gint _tmp202__length1;
																const gchar* _tmp203_;
																gchar* _tmp204_ = NULL;
																gchar* _tmp205_;
																gboolean _tmp206_;
																_tmp202_ = nv;
																_tmp202__length1 = nv_length1;
																_tmp203_ = _tmp202_[1];
																_tmp204_ = vala_gidl_parser_eval (self, _tmp203_);
																_tmp205_ = _tmp204_;
																_tmp206_ = g_strcmp0 (_tmp205_, "1") == 0;
																_g_free0 (_tmp205_);
																if (_tmp206_) {
																	ValaEnum* _tmp207_;
																	_tmp207_ = en;
																	vala_code_node_set_attribute ((ValaCodeNode*) _tmp207_, "Experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp208_ = en;
	_tmp209_ = common_prefix;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp208_, "CCode", "cprefix", _tmp209_, NULL);
	_tmp210_ = en_node;
	_tmp211_ = _tmp210_->values;
	{
		GList* value2_collection = NULL;
		GList* value2_it = NULL;
		value2_collection = _tmp211_;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2 = NULL;
			value2 = (GIdlNode*) value2_it->data;
			{
				GIdlNode* _tmp212_;
				const gchar* _tmp213_;
				const gchar* _tmp214_;
				gint _tmp215_;
				gint _tmp216_;
				gchar* _tmp217_ = NULL;
				gchar* _tmp218_;
				ValaEnumValue* _tmp219_;
				ValaEnumValue* _tmp220_;
				ValaEnumValue* ev;
				GIdlNode* _tmp221_;
				const gchar* _tmp222_;
				gint _tmp223_ = 0;
				gchar** _tmp224_ = NULL;
				gchar** val_attributes;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gboolean is_hidden;
				gchar** _tmp225_;
				gint _tmp225__length1;
				gboolean _tmp261_;
				_tmp212_ = value2;
				_tmp213_ = _tmp212_->name;
				_tmp214_ = common_prefix;
				_tmp215_ = strlen (_tmp214_);
				_tmp216_ = _tmp215_;
				_tmp217_ = string_substring (_tmp213_, (glong) _tmp216_, (glong) (-1));
				_tmp218_ = _tmp217_;
				_tmp219_ = vala_enum_value_new (_tmp218_, NULL, NULL, NULL);
				_tmp220_ = _tmp219_;
				_g_free0 (_tmp218_);
				ev = _tmp220_;
				_tmp221_ = value2;
				_tmp222_ = _tmp221_->name;
				_tmp224_ = vala_gidl_parser_get_attributes (self, _tmp222_, &_tmp223_);
				val_attributes = _tmp224_;
				val_attributes_length1 = _tmp223_;
				_val_attributes_size_ = val_attributes_length1;
				is_hidden = FALSE;
				_tmp225_ = val_attributes;
				_tmp225__length1 = val_attributes_length1;
				if (_tmp225_ != NULL) {
					gchar** _tmp226_;
					gint _tmp226__length1;
					_tmp226_ = val_attributes;
					_tmp226__length1 = val_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp226_;
						attr_collection_length1 = _tmp226__length1;
						for (attr_it = 0; attr_it < _tmp226__length1; attr_it = attr_it + 1) {
							gchar* _tmp227_;
							gchar* attr = NULL;
							_tmp227_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp227_;
							{
								const gchar* _tmp228_;
								gchar** _tmp229_;
								gchar** _tmp230_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								gboolean _tmp231_ = FALSE;
								gchar** _tmp232_;
								gint _tmp232__length1;
								const gchar* _tmp233_;
								gboolean _tmp238_;
								_tmp228_ = attr;
								_tmp230_ = _tmp229_ = g_strsplit (_tmp228_, "=", 2);
								nv = _tmp230_;
								nv_length1 = _vala_array_length (_tmp229_);
								_nv_size_ = nv_length1;
								_tmp232_ = nv;
								_tmp232__length1 = nv_length1;
								_tmp233_ = _tmp232_[0];
								if (g_strcmp0 (_tmp233_, "hidden") == 0) {
									gchar** _tmp234_;
									gint _tmp234__length1;
									const gchar* _tmp235_;
									gchar* _tmp236_ = NULL;
									gchar* _tmp237_;
									_tmp234_ = nv;
									_tmp234__length1 = nv_length1;
									_tmp235_ = _tmp234_[1];
									_tmp236_ = vala_gidl_parser_eval (self, _tmp235_);
									_tmp237_ = _tmp236_;
									_tmp231_ = g_strcmp0 (_tmp237_, "1") == 0;
									_g_free0 (_tmp237_);
								} else {
									_tmp231_ = FALSE;
								}
								_tmp238_ = _tmp231_;
								if (_tmp238_) {
									is_hidden = TRUE;
								} else {
									gchar** _tmp239_;
									gint _tmp239__length1;
									const gchar* _tmp240_;
									_tmp239_ = nv;
									_tmp239__length1 = nv_length1;
									_tmp240_ = _tmp239_[0];
									if (g_strcmp0 (_tmp240_, "deprecated") == 0) {
										gchar** _tmp241_;
										gint _tmp241__length1;
										const gchar* _tmp242_;
										gchar* _tmp243_ = NULL;
										gchar* _tmp244_;
										gboolean _tmp245_;
										_tmp241_ = nv;
										_tmp241__length1 = nv_length1;
										_tmp242_ = _tmp241_[1];
										_tmp243_ = vala_gidl_parser_eval (self, _tmp242_);
										_tmp244_ = _tmp243_;
										_tmp245_ = g_strcmp0 (_tmp244_, "1") == 0;
										_g_free0 (_tmp244_);
										if (_tmp245_) {
											ValaEnumValue* _tmp246_;
											_tmp246_ = ev;
											vala_code_node_set_attribute ((ValaCodeNode*) _tmp246_, "Deprecated", TRUE, NULL);
										}
									} else {
										gchar** _tmp247_;
										gint _tmp247__length1;
										const gchar* _tmp248_;
										_tmp247_ = nv;
										_tmp247__length1 = nv_length1;
										_tmp248_ = _tmp247_[0];
										if (g_strcmp0 (_tmp248_, "replacement") == 0) {
											ValaEnumValue* _tmp249_;
											gchar** _tmp250_;
											gint _tmp250__length1;
											const gchar* _tmp251_;
											gchar* _tmp252_ = NULL;
											gchar* _tmp253_;
											_tmp249_ = ev;
											_tmp250_ = nv;
											_tmp250__length1 = nv_length1;
											_tmp251_ = _tmp250_[1];
											_tmp252_ = vala_gidl_parser_eval (self, _tmp251_);
											_tmp253_ = _tmp252_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp249_, "Deprecated", "replacement", _tmp253_, NULL);
											_g_free0 (_tmp253_);
										} else {
											gchar** _tmp254_;
											gint _tmp254__length1;
											const gchar* _tmp255_;
											_tmp254_ = nv;
											_tmp254__length1 = nv_length1;
											_tmp255_ = _tmp254_[0];
											if (g_strcmp0 (_tmp255_, "deprecated_since") == 0) {
												ValaEnumValue* _tmp256_;
												gchar** _tmp257_;
												gint _tmp257__length1;
												const gchar* _tmp258_;
												gchar* _tmp259_ = NULL;
												gchar* _tmp260_;
												_tmp256_ = ev;
												_tmp257_ = nv;
												_tmp257__length1 = nv_length1;
												_tmp258_ = _tmp257_[1];
												_tmp259_ = vala_gidl_parser_eval (self, _tmp258_);
												_tmp260_ = _tmp259_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp256_, "Deprecated", "since", _tmp260_, NULL);
												_g_free0 (_tmp260_);
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp261_ = is_hidden;
				if (!_tmp261_) {
					ValaEnum* _tmp262_;
					ValaEnumValue* _tmp263_;
					_tmp262_ = en;
					_tmp263_ = ev;
					vala_enum_add_value (_tmp262_, _tmp263_);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
				_vala_code_node_unref0 (ev);
			}
		}
	}
	_tmp264_ = is_errordomain;
	if (_tmp264_) {
		ValaEnum* _tmp265_;
		const gchar* _tmp266_;
		const gchar* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaErrorDomain* _tmp269_;
		ValaErrorDomain* ed;
		ValaErrorDomain* _tmp270_;
		ValaErrorDomain* _tmp271_;
		const gchar* _tmp272_;
		const gchar* _tmp273_;
		ValaSourceFile* _tmp293_;
		ValaErrorDomain* _tmp294_;
		gboolean _tmp295_;
		_tmp265_ = en;
		_tmp266_ = vala_symbol_get_name ((ValaSymbol*) _tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = self->priv->current_source_reference;
		_tmp269_ = vala_error_domain_new (_tmp267_, _tmp268_, NULL);
		ed = _tmp269_;
		_tmp270_ = ed;
		vala_symbol_set_access ((ValaSymbol*) _tmp270_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp271_ = ed;
		_tmp272_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp271_, "CCode", "cprefix", _tmp272_, NULL);
		_tmp273_ = cheader_filename;
		if (_tmp273_ != NULL) {
			ValaErrorDomain* _tmp274_;
			const gchar* _tmp275_;
			_tmp274_ = ed;
			_tmp275_ = cheader_filename;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp274_, "CCode", "cheader_filename", _tmp275_, NULL);
		}
		{
			ValaEnum* _tmp276_;
			ValaList* _tmp277_ = NULL;
			ValaList* _ev_list;
			ValaList* _tmp278_;
			gint _tmp279_;
			gint _tmp280_;
			gint _ev_size;
			gint _ev_index;
			_tmp276_ = en;
			_tmp277_ = vala_enum_get_values (_tmp276_);
			_ev_list = _tmp277_;
			_tmp278_ = _ev_list;
			_tmp279_ = vala_collection_get_size ((ValaCollection*) _tmp278_);
			_tmp280_ = _tmp279_;
			_ev_size = _tmp280_;
			_ev_index = -1;
			while (TRUE) {
				gint _tmp281_;
				gint _tmp282_;
				gint _tmp283_;
				ValaList* _tmp284_;
				gint _tmp285_;
				gpointer _tmp286_ = NULL;
				ValaEnumValue* ev;
				ValaErrorDomain* _tmp287_;
				ValaEnumValue* _tmp288_;
				const gchar* _tmp289_;
				const gchar* _tmp290_;
				ValaErrorCode* _tmp291_;
				ValaErrorCode* _tmp292_;
				_tmp281_ = _ev_index;
				_ev_index = _tmp281_ + 1;
				_tmp282_ = _ev_index;
				_tmp283_ = _ev_size;
				if (!(_tmp282_ < _tmp283_)) {
					break;
				}
				_tmp284_ = _ev_list;
				_tmp285_ = _ev_index;
				_tmp286_ = vala_list_get (_tmp284_, _tmp285_);
				ev = (ValaEnumValue*) _tmp286_;
				_tmp287_ = ed;
				_tmp288_ = ev;
				_tmp289_ = vala_symbol_get_name ((ValaSymbol*) _tmp288_);
				_tmp290_ = _tmp289_;
				_tmp291_ = vala_error_code_new (_tmp290_, NULL, NULL);
				_tmp292_ = _tmp291_;
				vala_error_domain_add_code (_tmp287_, _tmp292_);
				_vala_code_node_unref0 (_tmp292_);
				_vala_code_node_unref0 (ev);
			}
			_vala_iterable_unref0 (_ev_list);
		}
		_tmp293_ = self->priv->current_source_file;
		_tmp294_ = ed;
		vala_source_file_add_node (_tmp293_, (ValaCodeNode*) _tmp294_);
		_tmp295_ = existing;
		if (!_tmp295_) {
			ValaSymbol* _tmp296_;
			ValaErrorDomain* _tmp297_;
			_tmp296_ = container;
			_tmp297_ = ed;
			vala_gidl_parser_add_symbol_to_container (self, _tmp296_, (ValaSymbol*) _tmp297_);
		}
		_vala_code_node_unref0 (ed);
	} else {
		ValaEnum* _tmp298_;
		gboolean _tmp299_;
		ValaSourceFile* _tmp300_;
		ValaEnum* _tmp301_;
		gboolean _tmp302_;
		_tmp298_ = en;
		_tmp299_ = is_flags;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp298_, "Flags", _tmp299_, NULL);
		_tmp300_ = self->priv->current_source_file;
		_tmp301_ = en;
		vala_source_file_add_node (_tmp300_, (ValaCodeNode*) _tmp301_);
		_tmp302_ = existing;
		if (!_tmp302_) {
			ValaSymbol* _tmp303_;
			ValaEnum* _tmp304_;
			_tmp303_ = container;
			_tmp304_ = en;
			vala_gidl_parser_add_symbol_to_container (self, _tmp303_, (ValaSymbol*) _tmp304_);
		}
	}
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cheader_filename);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (en);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	GIdlNodeInterface* _tmp0_;
	const gchar* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* name;
	gchar* base_class;
	ValaSymbol* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	const gchar* _tmp7_;
	ValaSymbol* _tmp8_ = NULL;
	ValaClass* cl;
	ValaClass* _tmp9_;
	const gchar* _tmp99_;
	GIdlNodeInterface* _tmp119_;
	GList* _tmp120_;
	ValaClass* _tmp143_;
	ValaTypeSymbol* _tmp144_;
	GHashFunc _tmp145_;
	GEqualFunc _tmp146_;
	ValaHashSet* _tmp147_;
	GHashFunc _tmp148_;
	GEqualFunc _tmp149_;
	GEqualFunc _tmp150_;
	ValaHashMap* _tmp151_;
	ValaHashMap* current_type_func_map;
	GHashFunc _tmp152_;
	GEqualFunc _tmp153_;
	GEqualFunc _tmp154_;
	ValaHashMap* _tmp155_;
	ValaHashMap* current_type_vfunc_map;
	GIdlNodeInterface* _tmp156_;
	GList* _tmp157_;
	GIdlNodeInterface* _tmp169_;
	GList* _tmp170_;
	GIdlNodeInterface* _tmp207_;
	GList* _tmp208_;
	ValaClass* _tmp278_;
	ValaClass* _tmp279_;
	ValaMethod* _tmp280_;
	ValaMethod* _tmp281_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = node;
	_tmp1_ = ((GIdlNode*) _tmp0_)->name;
	_tmp2_ = container;
	_tmp3_ = vala_gidl_parser_fix_type_name (self, _tmp1_, _tmp2_);
	name = _tmp3_;
	base_class = NULL;
	_tmp4_ = container;
	_tmp5_ = vala_symbol_get_scope (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = name;
	_tmp8_ = vala_scope_lookup (_tmp6_, _tmp7_);
	cl = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp8_) : NULL;
	_tmp9_ = cl;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaClass* _tmp12_;
		ValaClass* _tmp13_;
		GIdlNodeInterface* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_ = 0;
		gchar** _tmp17_ = NULL;
		gchar** attributes;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		ValaSymbol* _tmp95_;
		ValaClass* _tmp96_;
		ValaSourceFile* _tmp97_;
		ValaClass* _tmp98_;
		_tmp10_ = name;
		_tmp11_ = self->priv->current_source_reference;
		_tmp12_ = vala_class_new (_tmp10_, _tmp11_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp12_;
		_tmp13_ = cl;
		vala_symbol_set_access ((ValaSymbol*) _tmp13_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp14_ = node;
		_tmp15_ = _tmp14_->gtype_name;
		_tmp17_ = vala_gidl_parser_get_attributes (self, _tmp15_, &_tmp16_);
		attributes = _tmp17_;
		attributes_length1 = _tmp16_;
		_attributes_size_ = attributes_length1;
		_tmp18_ = attributes;
		_tmp18__length1 = attributes_length1;
		if (_tmp18_ != NULL) {
			gchar** _tmp19_;
			gint _tmp19__length1;
			_tmp19_ = attributes;
			_tmp19__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp19_;
				attr_collection_length1 = _tmp19__length1;
				for (attr_it = 0; attr_it < _tmp19__length1; attr_it = attr_it + 1) {
					gchar* _tmp20_;
					gchar* attr = NULL;
					_tmp20_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp20_;
					{
						const gchar* _tmp21_;
						gchar** _tmp22_;
						gchar** _tmp23_ = NULL;
						gchar** nv;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp24_;
						gint _tmp24__length1;
						const gchar* _tmp25_;
						_tmp21_ = attr;
						_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, "=", 2);
						nv = _tmp23_;
						nv_length1 = _vala_array_length (_tmp22_);
						_nv_size_ = nv_length1;
						_tmp24_ = nv;
						_tmp24__length1 = nv_length1;
						_tmp25_ = _tmp24_[0];
						if (g_strcmp0 (_tmp25_, "cheader_filename") == 0) {
							ValaClass* _tmp26_;
							gchar** _tmp27_;
							gint _tmp27__length1;
							const gchar* _tmp28_;
							gchar* _tmp29_ = NULL;
							gchar* _tmp30_;
							_tmp26_ = cl;
							_tmp27_ = nv;
							_tmp27__length1 = nv_length1;
							_tmp28_ = _tmp27_[1];
							_tmp29_ = vala_gidl_parser_eval (self, _tmp28_);
							_tmp30_ = _tmp29_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp26_, "CCode", "cheader_filename", _tmp30_, NULL);
							_g_free0 (_tmp30_);
						} else {
							gchar** _tmp31_;
							gint _tmp31__length1;
							const gchar* _tmp32_;
							_tmp31_ = nv;
							_tmp31__length1 = nv_length1;
							_tmp32_ = _tmp31_[0];
							if (g_strcmp0 (_tmp32_, "base_class") == 0) {
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								gchar* _tmp35_ = NULL;
								_tmp33_ = nv;
								_tmp33__length1 = nv_length1;
								_tmp34_ = _tmp33_[1];
								_tmp35_ = vala_gidl_parser_eval (self, _tmp34_);
								_g_free0 (base_class);
								base_class = _tmp35_;
							} else {
								gchar** _tmp36_;
								gint _tmp36__length1;
								const gchar* _tmp37_;
								_tmp36_ = nv;
								_tmp36__length1 = nv_length1;
								_tmp37_ = _tmp36_[0];
								if (g_strcmp0 (_tmp37_, "hidden") == 0) {
									gchar** _tmp38_;
									gint _tmp38__length1;
									const gchar* _tmp39_;
									gchar* _tmp40_ = NULL;
									gchar* _tmp41_;
									gboolean _tmp42_;
									_tmp38_ = nv;
									_tmp38__length1 = nv_length1;
									_tmp39_ = _tmp38_[1];
									_tmp40_ = vala_gidl_parser_eval (self, _tmp39_);
									_tmp41_ = _tmp40_;
									_tmp42_ = g_strcmp0 (_tmp41_, "1") == 0;
									_g_free0 (_tmp41_);
									if (_tmp42_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (base_class);
										_g_free0 (name);
										return;
									}
								} else {
									gchar** _tmp43_;
									gint _tmp43__length1;
									const gchar* _tmp44_;
									_tmp43_ = nv;
									_tmp43__length1 = nv_length1;
									_tmp44_ = _tmp43_[0];
									if (g_strcmp0 (_tmp44_, "type_check_function") == 0) {
										ValaClass* _tmp45_;
										gchar** _tmp46_;
										gint _tmp46__length1;
										const gchar* _tmp47_;
										gchar* _tmp48_ = NULL;
										gchar* _tmp49_;
										_tmp45_ = cl;
										_tmp46_ = nv;
										_tmp46__length1 = nv_length1;
										_tmp47_ = _tmp46_[1];
										_tmp48_ = vala_gidl_parser_eval (self, _tmp47_);
										_tmp49_ = _tmp48_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp45_, "CCode", "type_check_function", _tmp49_, NULL);
										_g_free0 (_tmp49_);
									} else {
										gchar** _tmp50_;
										gint _tmp50__length1;
										const gchar* _tmp51_;
										_tmp50_ = nv;
										_tmp50__length1 = nv_length1;
										_tmp51_ = _tmp50_[0];
										if (g_strcmp0 (_tmp51_, "deprecated") == 0) {
											gchar** _tmp52_;
											gint _tmp52__length1;
											const gchar* _tmp53_;
											gchar* _tmp54_ = NULL;
											gchar* _tmp55_;
											gboolean _tmp56_;
											_tmp52_ = nv;
											_tmp52__length1 = nv_length1;
											_tmp53_ = _tmp52_[1];
											_tmp54_ = vala_gidl_parser_eval (self, _tmp53_);
											_tmp55_ = _tmp54_;
											_tmp56_ = g_strcmp0 (_tmp55_, "1") == 0;
											_g_free0 (_tmp55_);
											if (_tmp56_) {
												ValaClass* _tmp57_;
												_tmp57_ = cl;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp57_, "Deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp58_;
											gint _tmp58__length1;
											const gchar* _tmp59_;
											_tmp58_ = nv;
											_tmp58__length1 = nv_length1;
											_tmp59_ = _tmp58_[0];
											if (g_strcmp0 (_tmp59_, "replacement") == 0) {
												ValaClass* _tmp60_;
												gchar** _tmp61_;
												gint _tmp61__length1;
												const gchar* _tmp62_;
												gchar* _tmp63_ = NULL;
												gchar* _tmp64_;
												_tmp60_ = cl;
												_tmp61_ = nv;
												_tmp61__length1 = nv_length1;
												_tmp62_ = _tmp61_[1];
												_tmp63_ = vala_gidl_parser_eval (self, _tmp62_);
												_tmp64_ = _tmp63_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp60_, "Deprecated", "replacement", _tmp64_, NULL);
												_g_free0 (_tmp64_);
											} else {
												gchar** _tmp65_;
												gint _tmp65__length1;
												const gchar* _tmp66_;
												_tmp65_ = nv;
												_tmp65__length1 = nv_length1;
												_tmp66_ = _tmp65_[0];
												if (g_strcmp0 (_tmp66_, "deprecated_since") == 0) {
													ValaClass* _tmp67_;
													gchar** _tmp68_;
													gint _tmp68__length1;
													const gchar* _tmp69_;
													gchar* _tmp70_ = NULL;
													gchar* _tmp71_;
													_tmp67_ = cl;
													_tmp68_ = nv;
													_tmp68__length1 = nv_length1;
													_tmp69_ = _tmp68_[1];
													_tmp70_ = vala_gidl_parser_eval (self, _tmp69_);
													_tmp71_ = _tmp70_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp67_, "Deprecated", "since", _tmp71_, NULL);
													_g_free0 (_tmp71_);
												} else {
													gchar** _tmp72_;
													gint _tmp72__length1;
													const gchar* _tmp73_;
													_tmp72_ = nv;
													_tmp72__length1 = nv_length1;
													_tmp73_ = _tmp72_[0];
													if (g_strcmp0 (_tmp73_, "type_id") == 0) {
														ValaClass* _tmp74_;
														gchar** _tmp75_;
														gint _tmp75__length1;
														const gchar* _tmp76_;
														gchar* _tmp77_ = NULL;
														gchar* _tmp78_;
														_tmp74_ = cl;
														_tmp75_ = nv;
														_tmp75__length1 = nv_length1;
														_tmp76_ = _tmp75_[1];
														_tmp77_ = vala_gidl_parser_eval (self, _tmp76_);
														_tmp78_ = _tmp77_;
														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp74_, "CCode", "type_id", _tmp78_, NULL);
														_g_free0 (_tmp78_);
													} else {
														gchar** _tmp79_;
														gint _tmp79__length1;
														const gchar* _tmp80_;
														_tmp79_ = nv;
														_tmp79__length1 = nv_length1;
														_tmp80_ = _tmp79_[0];
														if (g_strcmp0 (_tmp80_, "abstract") == 0) {
															gchar** _tmp81_;
															gint _tmp81__length1;
															const gchar* _tmp82_;
															gchar* _tmp83_ = NULL;
															gchar* _tmp84_;
															gboolean _tmp85_;
															_tmp81_ = nv;
															_tmp81__length1 = nv_length1;
															_tmp82_ = _tmp81_[1];
															_tmp83_ = vala_gidl_parser_eval (self, _tmp82_);
															_tmp84_ = _tmp83_;
															_tmp85_ = g_strcmp0 (_tmp84_, "1") == 0;
															_g_free0 (_tmp84_);
															if (_tmp85_) {
																ValaClass* _tmp86_;
																_tmp86_ = cl;
																vala_class_set_is_abstract (_tmp86_, TRUE);
															}
														} else {
															gchar** _tmp87_;
															gint _tmp87__length1;
															const gchar* _tmp88_;
															_tmp87_ = nv;
															_tmp87__length1 = nv_length1;
															_tmp88_ = _tmp87_[0];
															if (g_strcmp0 (_tmp88_, "experimental") == 0) {
																gchar** _tmp89_;
																gint _tmp89__length1;
																const gchar* _tmp90_;
																gchar* _tmp91_ = NULL;
																gchar* _tmp92_;
																gboolean _tmp93_;
																_tmp89_ = nv;
																_tmp89__length1 = nv_length1;
																_tmp90_ = _tmp89_[1];
																_tmp91_ = vala_gidl_parser_eval (self, _tmp90_);
																_tmp92_ = _tmp91_;
																_tmp93_ = g_strcmp0 (_tmp92_, "1") == 0;
																_g_free0 (_tmp92_);
																if (_tmp93_) {
																	ValaClass* _tmp94_;
																	_tmp94_ = cl;
																	vala_code_node_set_attribute ((ValaCodeNode*) _tmp94_, "Experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp95_ = container;
		_tmp96_ = cl;
		vala_gidl_parser_add_symbol_to_container (self, _tmp95_, (ValaSymbol*) _tmp96_);
		_tmp97_ = self->priv->current_source_file;
		_tmp98_ = cl;
		vala_source_file_add_node (_tmp97_, (ValaCodeNode*) _tmp98_);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp99_ = base_class;
	if (_tmp99_ != NULL) {
		const gchar* _tmp100_;
		ValaDataType* _tmp101_ = NULL;
		ValaDataType* parent;
		ValaClass* _tmp102_;
		ValaDataType* _tmp103_;
		_tmp100_ = base_class;
		_tmp101_ = vala_gidl_parser_parse_type_string (self, _tmp100_);
		parent = _tmp101_;
		_tmp102_ = cl;
		_tmp103_ = parent;
		vala_class_add_base_type (_tmp102_, _tmp103_);
		_vala_code_node_unref0 (parent);
	} else {
		GIdlNodeInterface* _tmp104_;
		const gchar* _tmp105_;
		_tmp104_ = node;
		_tmp105_ = _tmp104_->parent;
		if (_tmp105_ != NULL) {
			GIdlNodeInterface* _tmp106_;
			const gchar* _tmp107_;
			ValaDataType* _tmp108_ = NULL;
			ValaDataType* parent;
			ValaClass* _tmp109_;
			ValaDataType* _tmp110_;
			_tmp106_ = node;
			_tmp107_ = _tmp106_->parent;
			_tmp108_ = vala_gidl_parser_parse_type_string (self, _tmp107_);
			parent = _tmp108_;
			_tmp109_ = cl;
			_tmp110_ = parent;
			vala_class_add_base_type (_tmp109_, _tmp110_);
			_vala_code_node_unref0 (parent);
		} else {
			ValaUnresolvedSymbol* _tmp111_;
			ValaUnresolvedSymbol* _tmp112_;
			ValaUnresolvedSymbol* _tmp113_;
			ValaUnresolvedSymbol* _tmp114_;
			ValaUnresolvedSymbol* gobject_symbol;
			ValaClass* _tmp115_;
			ValaUnresolvedSymbol* _tmp116_;
			ValaUnresolvedType* _tmp117_;
			ValaUnresolvedType* _tmp118_;
			_tmp111_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_unresolved_symbol_new (_tmp112_, "Object", NULL);
			_tmp114_ = _tmp113_;
			_vala_code_node_unref0 (_tmp112_);
			gobject_symbol = _tmp114_;
			_tmp115_ = cl;
			_tmp116_ = gobject_symbol;
			_tmp117_ = vala_unresolved_type_new_from_symbol (_tmp116_, NULL);
			_tmp118_ = _tmp117_;
			vala_class_add_base_type (_tmp115_, (ValaDataType*) _tmp118_);
			_vala_code_node_unref0 (_tmp118_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	_tmp119_ = node;
	_tmp120_ = _tmp119_->interfaces;
	{
		GList* iface_name_collection = NULL;
		GList* iface_name_it = NULL;
		iface_name_collection = _tmp120_;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			gchar* _tmp121_;
			gchar* iface_name = NULL;
			_tmp121_ = g_strdup ((const gchar*) iface_name_it->data);
			iface_name = _tmp121_;
			{
				gboolean skip_iface;
				const gchar* _tmp122_;
				gint _tmp123_ = 0;
				gchar** _tmp124_ = NULL;
				gchar** attributes;
				gint attributes_length1;
				gint _attributes_size_;
				gchar** _tmp125_;
				gint _tmp125__length1;
				gboolean _tmp138_;
				const gchar* _tmp139_;
				ValaDataType* _tmp140_ = NULL;
				ValaDataType* iface;
				ValaClass* _tmp141_;
				ValaDataType* _tmp142_;
				skip_iface = FALSE;
				_tmp122_ = iface_name;
				_tmp124_ = vala_gidl_parser_get_attributes (self, _tmp122_, &_tmp123_);
				attributes = _tmp124_;
				attributes_length1 = _tmp123_;
				_attributes_size_ = attributes_length1;
				_tmp125_ = attributes;
				_tmp125__length1 = attributes_length1;
				if (_tmp125_ != NULL) {
					gchar** _tmp126_;
					gint _tmp126__length1;
					_tmp126_ = attributes;
					_tmp126__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp126_;
						attr_collection_length1 = _tmp126__length1;
						for (attr_it = 0; attr_it < _tmp126__length1; attr_it = attr_it + 1) {
							gchar* _tmp127_;
							gchar* attr = NULL;
							_tmp127_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp127_;
							{
								const gchar* _tmp128_;
								gchar** _tmp129_;
								gchar** _tmp130_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp131_;
								gint _tmp131__length1;
								const gchar* _tmp132_;
								_tmp128_ = attr;
								_tmp130_ = _tmp129_ = g_strsplit (_tmp128_, "=", 2);
								nv = _tmp130_;
								nv_length1 = _vala_array_length (_tmp129_);
								_nv_size_ = nv_length1;
								_tmp131_ = nv;
								_tmp131__length1 = nv_length1;
								_tmp132_ = _tmp131_[0];
								if (g_strcmp0 (_tmp132_, "hidden") == 0) {
									gchar** _tmp133_;
									gint _tmp133__length1;
									const gchar* _tmp134_;
									gchar* _tmp135_ = NULL;
									gchar* _tmp136_;
									gboolean _tmp137_;
									_tmp133_ = nv;
									_tmp133__length1 = nv_length1;
									_tmp134_ = _tmp133_[1];
									_tmp135_ = vala_gidl_parser_eval (self, _tmp134_);
									_tmp136_ = _tmp135_;
									_tmp137_ = g_strcmp0 (_tmp136_, "1") == 0;
									_g_free0 (_tmp136_);
									if (_tmp137_) {
										skip_iface = TRUE;
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp138_ = skip_iface;
				if (_tmp138_) {
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (iface_name);
					continue;
				}
				_tmp139_ = iface_name;
				_tmp140_ = vala_gidl_parser_parse_type_string (self, _tmp139_);
				iface = _tmp140_;
				_tmp141_ = cl;
				_tmp142_ = iface;
				vala_class_add_base_type (_tmp141_, _tmp142_);
				_vala_code_node_unref0 (iface);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (iface_name);
			}
		}
	}
	_tmp143_ = cl;
	_tmp144_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp143_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp144_;
	_tmp145_ = g_str_hash;
	_tmp146_ = g_str_equal;
	_tmp147_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp145_, _tmp146_);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = (ValaSet*) _tmp147_;
	_tmp148_ = g_str_hash;
	_tmp149_ = g_str_equal;
	_tmp150_ = g_direct_equal;
	_tmp151_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, _tmp148_, _tmp149_, _tmp150_);
	current_type_func_map = _tmp151_;
	_tmp152_ = g_str_hash;
	_tmp153_ = g_str_equal;
	_tmp154_ = g_direct_equal;
	_tmp155_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp152_, _tmp153_, _tmp154_);
	current_type_vfunc_map = _tmp155_;
	_tmp156_ = node;
	_tmp157_ = _tmp156_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp157_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp158_;
				GIdlNodeTypeId _tmp159_;
				GIdlNode* _tmp164_;
				GIdlNodeTypeId _tmp165_;
				_tmp158_ = member;
				_tmp159_ = _tmp158_->type;
				if (_tmp159_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp160_;
					GIdlNode* _tmp161_;
					const gchar* _tmp162_;
					GIdlNode* _tmp163_;
					_tmp160_ = current_type_func_map;
					_tmp161_ = member;
					_tmp162_ = _tmp161_->name;
					_tmp163_ = member;
					vala_map_set ((ValaMap*) _tmp160_, _tmp162_, (GIdlNodeFunction*) _tmp163_);
				}
				_tmp164_ = member;
				_tmp165_ = _tmp164_->type;
				if (_tmp165_ == G_IDL_NODE_VFUNC) {
					ValaHashMap* _tmp166_;
					GIdlNode* _tmp167_;
					const gchar* _tmp168_;
					_tmp166_ = current_type_vfunc_map;
					_tmp167_ = member;
					_tmp168_ = _tmp167_->name;
					vala_map_set ((ValaMap*) _tmp166_, _tmp168_, "1");
				}
			}
		}
	}
	_tmp169_ = node;
	_tmp170_ = _tmp169_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp170_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp171_;
				GIdlNodeTypeId _tmp172_;
				_tmp171_ = member;
				_tmp172_ = _tmp171_->type;
				if (_tmp172_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp173_;
					GIdlNode* _tmp174_;
					const gchar* _tmp175_;
					gboolean _tmp176_ = FALSE;
					_tmp173_ = current_type_vfunc_map;
					_tmp174_ = member;
					_tmp175_ = _tmp174_->name;
					_tmp176_ = vala_map_contains ((ValaMap*) _tmp173_, _tmp175_);
					if (!_tmp176_) {
						GIdlNode* _tmp177_;
						ValaMethod* _tmp178_ = NULL;
						ValaMethod* m;
						ValaMethod* _tmp179_;
						_tmp177_ = member;
						_tmp178_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp177_, FALSE);
						m = _tmp178_;
						_tmp179_ = m;
						if (_tmp179_ != NULL) {
							ValaClass* _tmp180_;
							ValaMethod* _tmp181_;
							_tmp180_ = cl;
							_tmp181_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp180_, _tmp181_);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					GIdlNode* _tmp182_;
					GIdlNodeTypeId _tmp183_;
					_tmp182_ = member;
					_tmp183_ = _tmp182_->type;
					if (_tmp183_ == G_IDL_NODE_VFUNC) {
						GIdlNode* _tmp184_;
						ValaHashMap* _tmp185_;
						GIdlNode* _tmp186_;
						const gchar* _tmp187_;
						gpointer _tmp188_ = NULL;
						ValaMethod* _tmp189_ = NULL;
						ValaMethod* m;
						ValaMethod* _tmp190_;
						_tmp184_ = member;
						_tmp185_ = current_type_func_map;
						_tmp186_ = member;
						_tmp187_ = _tmp186_->name;
						_tmp188_ = vala_map_get ((ValaMap*) _tmp185_, _tmp187_);
						_tmp189_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) _tmp184_, (GIdlNodeFunction*) _tmp188_, FALSE);
						m = _tmp189_;
						_tmp190_ = m;
						if (_tmp190_ != NULL) {
							ValaClass* _tmp191_;
							ValaMethod* _tmp192_;
							_tmp191_ = cl;
							_tmp192_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp191_, _tmp192_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp193_;
						GIdlNodeTypeId _tmp194_;
						_tmp193_ = member;
						_tmp194_ = _tmp193_->type;
						if (_tmp194_ == G_IDL_NODE_PROPERTY) {
							GIdlNode* _tmp195_;
							ValaProperty* _tmp196_ = NULL;
							ValaProperty* prop;
							ValaProperty* _tmp197_;
							_tmp195_ = member;
							_tmp196_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) _tmp195_);
							prop = _tmp196_;
							_tmp197_ = prop;
							if (_tmp197_ != NULL) {
								ValaClass* _tmp198_;
								ValaProperty* _tmp199_;
								_tmp198_ = cl;
								_tmp199_ = prop;
								vala_symbol_add_property ((ValaSymbol*) _tmp198_, _tmp199_);
							}
							_vala_code_node_unref0 (prop);
						} else {
							GIdlNode* _tmp200_;
							GIdlNodeTypeId _tmp201_;
							_tmp200_ = member;
							_tmp201_ = _tmp200_->type;
							if (_tmp201_ == G_IDL_NODE_SIGNAL) {
								GIdlNode* _tmp202_;
								ValaSignal* _tmp203_ = NULL;
								ValaSignal* sig;
								ValaSignal* _tmp204_;
								_tmp202_ = member;
								_tmp203_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) _tmp202_);
								sig = _tmp203_;
								_tmp204_ = sig;
								if (_tmp204_ != NULL) {
									ValaClass* _tmp205_;
									ValaSignal* _tmp206_;
									_tmp205_ = cl;
									_tmp206_ = sig;
									vala_symbol_add_signal ((ValaSymbol*) _tmp205_, _tmp206_);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	_tmp207_ = node;
	_tmp208_ = _tmp207_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp208_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp209_;
				GIdlNodeTypeId _tmp210_;
				_tmp209_ = member;
				_tmp210_ = _tmp209_->type;
				if (_tmp210_ == G_IDL_NODE_FIELD) {
					ValaSet* _tmp211_;
					GIdlNode* _tmp212_;
					const gchar* _tmp213_;
					gboolean _tmp214_ = FALSE;
					_tmp211_ = self->priv->current_type_symbol_set;
					_tmp212_ = member;
					_tmp213_ = _tmp212_->name;
					_tmp214_ = vala_collection_contains ((ValaCollection*) _tmp211_, _tmp213_);
					if (!_tmp214_) {
						GIdlNode* _tmp215_;
						ValaField* _tmp216_ = NULL;
						ValaField* f;
						ValaField* _tmp217_;
						_tmp215_ = member;
						_tmp216_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp215_);
						f = _tmp216_;
						_tmp217_ = f;
						if (_tmp217_ != NULL) {
							ValaClass* _tmp218_;
							ValaField* _tmp219_;
							_tmp218_ = cl;
							_tmp219_ = f;
							vala_symbol_add_field ((ValaSymbol*) _tmp218_, _tmp219_);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		ValaClass* _tmp220_;
		ValaList* _tmp221_ = NULL;
		ValaList* _prop_list;
		ValaList* _tmp222_;
		gint _tmp223_;
		gint _tmp224_;
		gint _prop_size;
		gint _prop_index;
		_tmp220_ = cl;
		_tmp221_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp220_);
		_prop_list = _tmp221_;
		_tmp222_ = _prop_list;
		_tmp223_ = vala_collection_get_size ((ValaCollection*) _tmp222_);
		_tmp224_ = _tmp223_;
		_prop_size = _tmp224_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp225_;
			gint _tmp226_;
			gint _tmp227_;
			ValaList* _tmp228_;
			gint _tmp229_;
			gpointer _tmp230_ = NULL;
			ValaProperty* prop;
			ValaProperty* _tmp231_;
			const gchar* _tmp232_;
			const gchar* _tmp233_;
			gchar* _tmp234_ = NULL;
			gchar* getter;
			gboolean _tmp235_ = FALSE;
			ValaProperty* _tmp236_;
			ValaPropertyAccessor* _tmp237_;
			ValaPropertyAccessor* _tmp238_;
			gboolean _tmp242_;
			ValaProperty* _tmp244_;
			const gchar* _tmp245_;
			const gchar* _tmp246_;
			gchar* _tmp247_ = NULL;
			gchar* setter;
			gboolean _tmp248_ = FALSE;
			gboolean _tmp249_ = FALSE;
			ValaProperty* _tmp250_;
			ValaPropertyAccessor* _tmp251_;
			ValaPropertyAccessor* _tmp252_;
			gboolean _tmp258_;
			gboolean _tmp262_;
			gboolean _tmp264_ = FALSE;
			ValaProperty* _tmp265_;
			ValaAttribute* _tmp266_ = NULL;
			ValaAttribute* _tmp267_;
			gboolean _tmp268_;
			gboolean _tmp272_;
			_tmp225_ = _prop_index;
			_prop_index = _tmp225_ + 1;
			_tmp226_ = _prop_index;
			_tmp227_ = _prop_size;
			if (!(_tmp226_ < _tmp227_)) {
				break;
			}
			_tmp228_ = _prop_list;
			_tmp229_ = _prop_index;
			_tmp230_ = vala_list_get (_tmp228_, _tmp229_);
			prop = (ValaProperty*) _tmp230_;
			_tmp231_ = prop;
			_tmp232_ = vala_symbol_get_name ((ValaSymbol*) _tmp231_);
			_tmp233_ = _tmp232_;
			_tmp234_ = g_strdup_printf ("get_%s", _tmp233_);
			getter = _tmp234_;
			_tmp236_ = prop;
			_tmp237_ = vala_property_get_get_accessor (_tmp236_);
			_tmp238_ = _tmp237_;
			if (_tmp238_ != NULL) {
				ValaSet* _tmp239_;
				const gchar* _tmp240_;
				gboolean _tmp241_ = FALSE;
				_tmp239_ = self->priv->current_type_symbol_set;
				_tmp240_ = getter;
				_tmp241_ = vala_collection_contains ((ValaCollection*) _tmp239_, _tmp240_);
				_tmp235_ = !_tmp241_;
			} else {
				_tmp235_ = FALSE;
			}
			_tmp242_ = _tmp235_;
			if (_tmp242_) {
				ValaProperty* _tmp243_;
				_tmp243_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp243_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp244_ = prop;
			_tmp245_ = vala_symbol_get_name ((ValaSymbol*) _tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = g_strdup_printf ("set_%s", _tmp246_);
			setter = _tmp247_;
			_tmp250_ = prop;
			_tmp251_ = vala_property_get_set_accessor (_tmp250_);
			_tmp252_ = _tmp251_;
			if (_tmp252_ != NULL) {
				ValaProperty* _tmp253_;
				ValaPropertyAccessor* _tmp254_;
				ValaPropertyAccessor* _tmp255_;
				gboolean _tmp256_;
				gboolean _tmp257_;
				_tmp253_ = prop;
				_tmp254_ = vala_property_get_set_accessor (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_property_accessor_get_writable (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp249_ = _tmp257_;
			} else {
				_tmp249_ = FALSE;
			}
			_tmp258_ = _tmp249_;
			if (_tmp258_) {
				ValaSet* _tmp259_;
				const gchar* _tmp260_;
				gboolean _tmp261_ = FALSE;
				_tmp259_ = self->priv->current_type_symbol_set;
				_tmp260_ = setter;
				_tmp261_ = vala_collection_contains ((ValaCollection*) _tmp259_, _tmp260_);
				_tmp248_ = !_tmp261_;
			} else {
				_tmp248_ = FALSE;
			}
			_tmp262_ = _tmp248_;
			if (_tmp262_) {
				ValaProperty* _tmp263_;
				_tmp263_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp263_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp265_ = prop;
			_tmp266_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp265_, "NoAccessorMethod");
			_tmp267_ = _tmp266_;
			_tmp268_ = _tmp267_ != NULL;
			_vala_code_node_unref0 (_tmp267_);
			if (_tmp268_) {
				ValaProperty* _tmp269_;
				ValaPropertyAccessor* _tmp270_;
				ValaPropertyAccessor* _tmp271_;
				_tmp269_ = prop;
				_tmp270_ = vala_property_get_get_accessor (_tmp269_);
				_tmp271_ = _tmp270_;
				_tmp264_ = _tmp271_ != NULL;
			} else {
				_tmp264_ = FALSE;
			}
			_tmp272_ = _tmp264_;
			if (_tmp272_) {
				ValaProperty* _tmp273_;
				ValaPropertyAccessor* _tmp274_;
				ValaPropertyAccessor* _tmp275_;
				ValaDataType* _tmp276_;
				ValaDataType* _tmp277_;
				_tmp273_ = prop;
				_tmp274_ = vala_property_get_get_accessor (_tmp273_);
				_tmp275_ = _tmp274_;
				_tmp276_ = vala_property_accessor_get_value_type (_tmp275_);
				_tmp277_ = _tmp276_;
				vala_data_type_set_value_owned (_tmp277_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp278_ = cl;
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) _tmp278_);
	_tmp279_ = cl;
	_tmp280_ = vala_class_get_default_construction_method (_tmp279_);
	_tmp281_ = _tmp280_;
	if (_tmp281_ == NULL) {
		ValaClass* _tmp282_;
		ValaSourceReference* _tmp283_;
		ValaSourceReference* _tmp284_;
		ValaCreationMethod* _tmp285_;
		ValaCreationMethod* cm;
		ValaCreationMethod* _tmp286_;
		ValaCreationMethod* _tmp287_;
		ValaClass* _tmp288_;
		ValaCreationMethod* _tmp289_;
		_tmp282_ = cl;
		_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp282_);
		_tmp284_ = _tmp283_;
		_tmp285_ = vala_creation_method_new (NULL, NULL, _tmp284_, NULL);
		cm = _tmp285_;
		_tmp286_ = cm;
		vala_method_set_has_construct_function ((ValaMethod*) _tmp286_, FALSE);
		_tmp287_ = cm;
		vala_symbol_set_access ((ValaSymbol*) _tmp287_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		_tmp288_ = cl;
		_tmp289_ = cm;
		vala_symbol_add_method ((ValaSymbol*) _tmp288_, (ValaMethod*) _tmp289_);
		_vala_code_node_unref0 (cm);
	}
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = NULL;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = NULL;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (cl);
	_g_free0 (base_class);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	GIdlNodeInterface* _tmp0_;
	const gchar* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* name;
	ValaSymbol* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	const gchar* _tmp7_;
	ValaSymbol* _tmp8_ = NULL;
	ValaInterface* iface;
	ValaInterface* _tmp9_;
	ValaInterface* _tmp63_;
	ValaTypeSymbol* _tmp64_;
	GHashFunc _tmp65_;
	GEqualFunc _tmp66_;
	ValaHashSet* _tmp67_;
	GHashFunc _tmp68_;
	GEqualFunc _tmp69_;
	GEqualFunc _tmp70_;
	ValaHashMap* _tmp71_;
	ValaHashMap* current_type_func_map;
	GHashFunc _tmp72_;
	GEqualFunc _tmp73_;
	GEqualFunc _tmp74_;
	ValaHashMap* _tmp75_;
	ValaHashMap* current_type_vfunc_map;
	GIdlNodeInterface* _tmp76_;
	GList* _tmp77_;
	GIdlNodeInterface* _tmp89_;
	GList* _tmp90_;
	ValaInterface* _tmp186_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->gtype_name;
	_tmp2_ = container;
	_tmp3_ = vala_gidl_parser_fix_type_name (self, _tmp1_, _tmp2_);
	name = _tmp3_;
	_tmp4_ = container;
	_tmp5_ = vala_symbol_get_scope (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = name;
	_tmp8_ = vala_scope_lookup (_tmp6_, _tmp7_);
	iface = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_INTERFACE) ? ((ValaInterface*) _tmp8_) : NULL;
	_tmp9_ = iface;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaInterface* _tmp12_;
		ValaInterface* _tmp13_;
		GIdlNodeInterface* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_ = 0;
		gchar** _tmp17_ = NULL;
		gchar** attributes;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		GIdlNodeInterface* _tmp52_;
		GList* _tmp53_;
		ValaSymbol* _tmp59_;
		ValaInterface* _tmp60_;
		ValaSourceFile* _tmp61_;
		ValaInterface* _tmp62_;
		_tmp10_ = name;
		_tmp11_ = self->priv->current_source_reference;
		_tmp12_ = vala_interface_new (_tmp10_, _tmp11_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp12_;
		_tmp13_ = iface;
		vala_symbol_set_access ((ValaSymbol*) _tmp13_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp14_ = node;
		_tmp15_ = _tmp14_->gtype_name;
		_tmp17_ = vala_gidl_parser_get_attributes (self, _tmp15_, &_tmp16_);
		attributes = _tmp17_;
		attributes_length1 = _tmp16_;
		_attributes_size_ = attributes_length1;
		_tmp18_ = attributes;
		_tmp18__length1 = attributes_length1;
		if (_tmp18_ != NULL) {
			gchar** _tmp19_;
			gint _tmp19__length1;
			_tmp19_ = attributes;
			_tmp19__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp19_;
				attr_collection_length1 = _tmp19__length1;
				for (attr_it = 0; attr_it < _tmp19__length1; attr_it = attr_it + 1) {
					gchar* _tmp20_;
					gchar* attr = NULL;
					_tmp20_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp20_;
					{
						const gchar* _tmp21_;
						gchar** _tmp22_;
						gchar** _tmp23_ = NULL;
						gchar** nv;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp24_;
						gint _tmp24__length1;
						const gchar* _tmp25_;
						_tmp21_ = attr;
						_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, "=", 2);
						nv = _tmp23_;
						nv_length1 = _vala_array_length (_tmp22_);
						_nv_size_ = nv_length1;
						_tmp24_ = nv;
						_tmp24__length1 = nv_length1;
						_tmp25_ = _tmp24_[0];
						if (g_strcmp0 (_tmp25_, "cheader_filename") == 0) {
							ValaInterface* _tmp26_;
							gchar** _tmp27_;
							gint _tmp27__length1;
							const gchar* _tmp28_;
							gchar* _tmp29_ = NULL;
							gchar* _tmp30_;
							_tmp26_ = iface;
							_tmp27_ = nv;
							_tmp27__length1 = nv_length1;
							_tmp28_ = _tmp27_[1];
							_tmp29_ = vala_gidl_parser_eval (self, _tmp28_);
							_tmp30_ = _tmp29_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp26_, "CCode", "cheader_filename", _tmp30_, NULL);
							_g_free0 (_tmp30_);
						} else {
							gchar** _tmp31_;
							gint _tmp31__length1;
							const gchar* _tmp32_;
							_tmp31_ = nv;
							_tmp31__length1 = nv_length1;
							_tmp32_ = _tmp31_[0];
							if (g_strcmp0 (_tmp32_, "hidden") == 0) {
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_;
								gboolean _tmp37_;
								_tmp33_ = nv;
								_tmp33__length1 = nv_length1;
								_tmp34_ = _tmp33_[1];
								_tmp35_ = vala_gidl_parser_eval (self, _tmp34_);
								_tmp36_ = _tmp35_;
								_tmp37_ = g_strcmp0 (_tmp36_, "1") == 0;
								_g_free0 (_tmp36_);
								if (_tmp37_) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (iface);
									_g_free0 (name);
									return;
								}
							} else {
								gchar** _tmp38_;
								gint _tmp38__length1;
								const gchar* _tmp39_;
								_tmp38_ = nv;
								_tmp38__length1 = nv_length1;
								_tmp39_ = _tmp38_[0];
								if (g_strcmp0 (_tmp39_, "type_cname") == 0) {
									ValaInterface* _tmp40_;
									gchar** _tmp41_;
									gint _tmp41__length1;
									const gchar* _tmp42_;
									gchar* _tmp43_ = NULL;
									gchar* _tmp44_;
									_tmp40_ = iface;
									_tmp41_ = nv;
									_tmp41__length1 = nv_length1;
									_tmp42_ = _tmp41_[1];
									_tmp43_ = vala_gidl_parser_eval (self, _tmp42_);
									_tmp44_ = _tmp43_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp40_, "CCode", "type_cname", _tmp44_, NULL);
									_g_free0 (_tmp44_);
								} else {
									gchar** _tmp45_;
									gint _tmp45__length1;
									const gchar* _tmp46_;
									_tmp45_ = nv;
									_tmp45__length1 = nv_length1;
									_tmp46_ = _tmp45_[0];
									if (g_strcmp0 (_tmp46_, "lower_case_csuffix") == 0) {
										ValaInterface* _tmp47_;
										gchar** _tmp48_;
										gint _tmp48__length1;
										const gchar* _tmp49_;
										gchar* _tmp50_ = NULL;
										gchar* _tmp51_;
										_tmp47_ = iface;
										_tmp48_ = nv;
										_tmp48__length1 = nv_length1;
										_tmp49_ = _tmp48_[1];
										_tmp50_ = vala_gidl_parser_eval (self, _tmp49_);
										_tmp51_ = _tmp50_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp47_, "CCode", "lower_case_csuffix", _tmp51_, NULL);
										_g_free0 (_tmp51_);
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp52_ = node;
		_tmp53_ = _tmp52_->prerequisites;
		{
			GList* prereq_name_collection = NULL;
			GList* prereq_name_it = NULL;
			prereq_name_collection = _tmp53_;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				gchar* _tmp54_;
				gchar* prereq_name = NULL;
				_tmp54_ = g_strdup ((const gchar*) prereq_name_it->data);
				prereq_name = _tmp54_;
				{
					const gchar* _tmp55_;
					ValaDataType* _tmp56_ = NULL;
					ValaDataType* prereq;
					ValaInterface* _tmp57_;
					ValaDataType* _tmp58_;
					_tmp55_ = prereq_name;
					_tmp56_ = vala_gidl_parser_parse_type_string (self, _tmp55_);
					prereq = _tmp56_;
					_tmp57_ = iface;
					_tmp58_ = prereq;
					vala_interface_add_prerequisite (_tmp57_, _tmp58_);
					_vala_code_node_unref0 (prereq);
					_g_free0 (prereq_name);
				}
			}
		}
		_tmp59_ = container;
		_tmp60_ = iface;
		vala_gidl_parser_add_symbol_to_container (self, _tmp59_, (ValaSymbol*) _tmp60_);
		_tmp61_ = self->priv->current_source_file;
		_tmp62_ = iface;
		vala_source_file_add_node (_tmp61_, (ValaCodeNode*) _tmp62_);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp63_ = iface;
	_tmp64_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp63_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp64_;
	_tmp65_ = g_str_hash;
	_tmp66_ = g_str_equal;
	_tmp67_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp65_, _tmp66_);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = (ValaSet*) _tmp67_;
	_tmp68_ = g_str_hash;
	_tmp69_ = g_str_equal;
	_tmp70_ = g_direct_equal;
	_tmp71_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, _tmp68_, _tmp69_, _tmp70_);
	current_type_func_map = _tmp71_;
	_tmp72_ = g_str_hash;
	_tmp73_ = g_str_equal;
	_tmp74_ = g_direct_equal;
	_tmp75_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp72_, _tmp73_, _tmp74_);
	current_type_vfunc_map = _tmp75_;
	_tmp76_ = node;
	_tmp77_ = _tmp76_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp77_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp78_;
				GIdlNodeTypeId _tmp79_;
				GIdlNode* _tmp84_;
				GIdlNodeTypeId _tmp85_;
				_tmp78_ = member;
				_tmp79_ = _tmp78_->type;
				if (_tmp79_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp80_;
					GIdlNode* _tmp81_;
					const gchar* _tmp82_;
					GIdlNode* _tmp83_;
					_tmp80_ = current_type_func_map;
					_tmp81_ = member;
					_tmp82_ = _tmp81_->name;
					_tmp83_ = member;
					vala_map_set ((ValaMap*) _tmp80_, _tmp82_, (GIdlNodeFunction*) _tmp83_);
				}
				_tmp84_ = member;
				_tmp85_ = _tmp84_->type;
				if (_tmp85_ == G_IDL_NODE_VFUNC) {
					ValaHashMap* _tmp86_;
					GIdlNode* _tmp87_;
					const gchar* _tmp88_;
					_tmp86_ = current_type_vfunc_map;
					_tmp87_ = member;
					_tmp88_ = _tmp87_->name;
					vala_map_set ((ValaMap*) _tmp86_, _tmp88_, "1");
				}
			}
		}
	}
	_tmp89_ = node;
	_tmp90_ = _tmp89_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp90_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp91_;
				GIdlNodeTypeId _tmp92_;
				_tmp91_ = member;
				_tmp92_ = _tmp91_->type;
				if (_tmp92_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp93_;
					GIdlNode* _tmp94_;
					const gchar* _tmp95_;
					gboolean _tmp96_ = FALSE;
					_tmp93_ = current_type_vfunc_map;
					_tmp94_ = member;
					_tmp95_ = _tmp94_->name;
					_tmp96_ = vala_map_contains ((ValaMap*) _tmp93_, _tmp95_);
					if (!_tmp96_) {
						GIdlNode* _tmp97_;
						ValaMethod* _tmp98_ = NULL;
						ValaMethod* m;
						ValaMethod* _tmp99_;
						_tmp97_ = member;
						_tmp98_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp97_, TRUE);
						m = _tmp98_;
						_tmp99_ = m;
						if (_tmp99_ != NULL) {
							ValaInterface* _tmp100_;
							ValaMethod* _tmp101_;
							_tmp100_ = iface;
							_tmp101_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp100_, _tmp101_);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					GIdlNode* _tmp102_;
					GIdlNodeTypeId _tmp103_;
					_tmp102_ = member;
					_tmp103_ = _tmp102_->type;
					if (_tmp103_ == G_IDL_NODE_VFUNC) {
						GIdlNode* _tmp104_;
						ValaHashMap* _tmp105_;
						GIdlNode* _tmp106_;
						const gchar* _tmp107_;
						gpointer _tmp108_ = NULL;
						ValaMethod* _tmp109_ = NULL;
						ValaMethod* m;
						ValaMethod* _tmp110_;
						_tmp104_ = member;
						_tmp105_ = current_type_func_map;
						_tmp106_ = member;
						_tmp107_ = _tmp106_->name;
						_tmp108_ = vala_map_get ((ValaMap*) _tmp105_, _tmp107_);
						_tmp109_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) _tmp104_, (GIdlNodeFunction*) _tmp108_, TRUE);
						m = _tmp109_;
						_tmp110_ = m;
						if (_tmp110_ != NULL) {
							ValaInterface* _tmp111_;
							ValaMethod* _tmp112_;
							_tmp111_ = iface;
							_tmp112_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp111_, _tmp112_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp113_;
						GIdlNodeTypeId _tmp114_;
						_tmp113_ = member;
						_tmp114_ = _tmp113_->type;
						if (_tmp114_ == G_IDL_NODE_PROPERTY) {
							GIdlNode* _tmp115_;
							ValaProperty* _tmp116_ = NULL;
							ValaProperty* prop;
							ValaProperty* _tmp117_;
							_tmp115_ = member;
							_tmp116_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) _tmp115_);
							prop = _tmp116_;
							_tmp117_ = prop;
							if (_tmp117_ != NULL) {
								ValaInterface* _tmp118_;
								ValaProperty* _tmp119_;
								_tmp118_ = iface;
								_tmp119_ = prop;
								vala_symbol_add_property ((ValaSymbol*) _tmp118_, _tmp119_);
							}
							_vala_code_node_unref0 (prop);
						} else {
							GIdlNode* _tmp120_;
							GIdlNodeTypeId _tmp121_;
							_tmp120_ = member;
							_tmp121_ = _tmp120_->type;
							if (_tmp121_ == G_IDL_NODE_SIGNAL) {
								GIdlNode* _tmp122_;
								ValaSignal* _tmp123_ = NULL;
								ValaSignal* sig;
								ValaSignal* _tmp124_;
								_tmp122_ = member;
								_tmp123_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) _tmp122_);
								sig = _tmp123_;
								_tmp124_ = sig;
								if (_tmp124_ != NULL) {
									ValaInterface* _tmp125_;
									ValaSignal* _tmp126_;
									ValaSignal* _tmp127_;
									_tmp125_ = iface;
									_tmp126_ = sig;
									vala_symbol_add_signal ((ValaSymbol*) _tmp125_, _tmp126_);
									_tmp127_ = sig;
									vala_signal_set_is_virtual (_tmp127_, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		ValaInterface* _tmp128_;
		ValaList* _tmp129_ = NULL;
		ValaList* _prop_list;
		ValaList* _tmp130_;
		gint _tmp131_;
		gint _tmp132_;
		gint _prop_size;
		gint _prop_index;
		_tmp128_ = iface;
		_tmp129_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp128_);
		_prop_list = _tmp129_;
		_tmp130_ = _prop_list;
		_tmp131_ = vala_collection_get_size ((ValaCollection*) _tmp130_);
		_tmp132_ = _tmp131_;
		_prop_size = _tmp132_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			ValaList* _tmp136_;
			gint _tmp137_;
			gpointer _tmp138_ = NULL;
			ValaProperty* prop;
			ValaProperty* _tmp139_;
			const gchar* _tmp140_;
			const gchar* _tmp141_;
			gchar* _tmp142_ = NULL;
			gchar* getter;
			gboolean _tmp143_ = FALSE;
			ValaProperty* _tmp144_;
			ValaPropertyAccessor* _tmp145_;
			ValaPropertyAccessor* _tmp146_;
			gboolean _tmp150_;
			ValaProperty* _tmp152_;
			const gchar* _tmp153_;
			const gchar* _tmp154_;
			gchar* _tmp155_ = NULL;
			gchar* setter;
			gboolean _tmp156_ = FALSE;
			gboolean _tmp157_ = FALSE;
			ValaProperty* _tmp158_;
			ValaPropertyAccessor* _tmp159_;
			ValaPropertyAccessor* _tmp160_;
			gboolean _tmp166_;
			gboolean _tmp170_;
			gboolean _tmp172_ = FALSE;
			ValaProperty* _tmp173_;
			ValaAttribute* _tmp174_ = NULL;
			ValaAttribute* _tmp175_;
			gboolean _tmp176_;
			gboolean _tmp180_;
			_tmp133_ = _prop_index;
			_prop_index = _tmp133_ + 1;
			_tmp134_ = _prop_index;
			_tmp135_ = _prop_size;
			if (!(_tmp134_ < _tmp135_)) {
				break;
			}
			_tmp136_ = _prop_list;
			_tmp137_ = _prop_index;
			_tmp138_ = vala_list_get (_tmp136_, _tmp137_);
			prop = (ValaProperty*) _tmp138_;
			_tmp139_ = prop;
			_tmp140_ = vala_symbol_get_name ((ValaSymbol*) _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("get_%s", _tmp141_);
			getter = _tmp142_;
			_tmp144_ = prop;
			_tmp145_ = vala_property_get_get_accessor (_tmp144_);
			_tmp146_ = _tmp145_;
			if (_tmp146_ != NULL) {
				ValaSet* _tmp147_;
				const gchar* _tmp148_;
				gboolean _tmp149_ = FALSE;
				_tmp147_ = self->priv->current_type_symbol_set;
				_tmp148_ = getter;
				_tmp149_ = vala_collection_contains ((ValaCollection*) _tmp147_, _tmp148_);
				_tmp143_ = !_tmp149_;
			} else {
				_tmp143_ = FALSE;
			}
			_tmp150_ = _tmp143_;
			if (_tmp150_) {
				ValaProperty* _tmp151_;
				_tmp151_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp151_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp152_ = prop;
			_tmp153_ = vala_symbol_get_name ((ValaSymbol*) _tmp152_);
			_tmp154_ = _tmp153_;
			_tmp155_ = g_strdup_printf ("set_%s", _tmp154_);
			setter = _tmp155_;
			_tmp158_ = prop;
			_tmp159_ = vala_property_get_set_accessor (_tmp158_);
			_tmp160_ = _tmp159_;
			if (_tmp160_ != NULL) {
				ValaProperty* _tmp161_;
				ValaPropertyAccessor* _tmp162_;
				ValaPropertyAccessor* _tmp163_;
				gboolean _tmp164_;
				gboolean _tmp165_;
				_tmp161_ = prop;
				_tmp162_ = vala_property_get_set_accessor (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_property_accessor_get_writable (_tmp163_);
				_tmp165_ = _tmp164_;
				_tmp157_ = _tmp165_;
			} else {
				_tmp157_ = FALSE;
			}
			_tmp166_ = _tmp157_;
			if (_tmp166_) {
				ValaSet* _tmp167_;
				const gchar* _tmp168_;
				gboolean _tmp169_ = FALSE;
				_tmp167_ = self->priv->current_type_symbol_set;
				_tmp168_ = setter;
				_tmp169_ = vala_collection_contains ((ValaCollection*) _tmp167_, _tmp168_);
				_tmp156_ = !_tmp169_;
			} else {
				_tmp156_ = FALSE;
			}
			_tmp170_ = _tmp156_;
			if (_tmp170_) {
				ValaProperty* _tmp171_;
				_tmp171_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp171_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp173_ = prop;
			_tmp174_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp173_, "NoAccessorMethod");
			_tmp175_ = _tmp174_;
			_tmp176_ = _tmp175_ != NULL;
			_vala_code_node_unref0 (_tmp175_);
			if (_tmp176_) {
				ValaProperty* _tmp177_;
				ValaPropertyAccessor* _tmp178_;
				ValaPropertyAccessor* _tmp179_;
				_tmp177_ = prop;
				_tmp178_ = vala_property_get_get_accessor (_tmp177_);
				_tmp179_ = _tmp178_;
				_tmp172_ = _tmp179_ != NULL;
			} else {
				_tmp172_ = FALSE;
			}
			_tmp180_ = _tmp172_;
			if (_tmp180_) {
				ValaProperty* _tmp181_;
				ValaPropertyAccessor* _tmp182_;
				ValaPropertyAccessor* _tmp183_;
				ValaDataType* _tmp184_;
				ValaDataType* _tmp185_;
				_tmp181_ = prop;
				_tmp182_ = vala_property_get_get_accessor (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_property_accessor_get_value_type (_tmp183_);
				_tmp185_ = _tmp184_;
				vala_data_type_set_value_owned (_tmp185_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp186_ = iface;
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) _tmp186_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = NULL;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (iface);
	_g_free0 (name);
}


static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaSet* finish_methods;
	ValaObjectTypeSymbol* _tmp3_;
	ValaList* _tmp4_ = NULL;
	ValaList* methods;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_hash_set_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_, _tmp1_);
	finish_methods = (ValaSet*) _tmp2_;
	_tmp3_ = type_symbol;
	_tmp4_ = vala_object_type_symbol_get_methods (_tmp3_);
	methods = _tmp4_;
	{
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		ValaList* _m_list;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _m_size;
		gint _m_index;
		_tmp5_ = methods;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_m_list = _tmp6_;
		_tmp7_ = _m_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_m_size = _tmp9_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_ = NULL;
			ValaMethod* m;
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp10_ = _m_index;
			_m_index = _tmp10_ + 1;
			_tmp11_ = _m_index;
			_tmp12_ = _m_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _m_list;
			_tmp14_ = _m_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			m = (ValaMethod*) _tmp15_;
			_tmp16_ = m;
			_tmp17_ = vala_method_get_coroutine (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				gchar* finish_method_base = NULL;
				ValaMethod* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gboolean _tmp22_ = FALSE;
				ValaObjectTypeSymbol* _tmp38_;
				ValaScope* _tmp39_;
				ValaScope* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				ValaSymbol* _tmp44_ = NULL;
				ValaMethod* _tmp45_;
				ValaMethod* finish_method;
				ValaMethod* _tmp46_;
				ValaMethod* _tmp67_;
				_tmp19_ = m;
				_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_str_has_suffix (_tmp21_, "_async");
				if (_tmp22_) {
					ValaMethod* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					ValaMethod* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					gchar* _tmp33_ = NULL;
					_tmp23_ = m;
					_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = m;
					_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = strlen ("_async");
					_tmp32_ = _tmp31_;
					_tmp33_ = string_substring (_tmp25_, (glong) 0, (glong) (_tmp30_ - _tmp32_));
					_g_free0 (finish_method_base);
					finish_method_base = _tmp33_;
				} else {
					ValaMethod* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp34_ = m;
					_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strdup (_tmp36_);
					_g_free0 (finish_method_base);
					finish_method_base = _tmp37_;
				}
				_tmp38_ = type_symbol;
				_tmp39_ = vala_symbol_get_scope ((ValaSymbol*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = finish_method_base;
				_tmp42_ = g_strconcat (_tmp41_, "_finish", NULL);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_scope_lookup (_tmp40_, _tmp43_);
				_tmp45_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp44_) : NULL;
				_g_free0 (_tmp43_);
				finish_method = _tmp45_;
				_tmp46_ = finish_method;
				if (_tmp46_ == NULL) {
					ValaMethod* _tmp47_;
					gchar* _tmp48_ = NULL;
					gchar* method_cname;
					_tmp47_ = m;
					_tmp48_ = vala_gidl_parser_get_finish_cname (self, _tmp47_);
					method_cname = _tmp48_;
					{
						ValaObjectTypeSymbol* _tmp49_;
						ValaList* _tmp50_ = NULL;
						ValaList* _method_list;
						ValaList* _tmp51_;
						gint _tmp52_;
						gint _tmp53_;
						gint _method_size;
						gint _method_index;
						_tmp49_ = type_symbol;
						_tmp50_ = vala_object_type_symbol_get_methods (_tmp49_);
						_method_list = _tmp50_;
						_tmp51_ = _method_list;
						_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
						_tmp53_ = _tmp52_;
						_method_size = _tmp53_;
						_method_index = -1;
						while (TRUE) {
							gint _tmp54_;
							gint _tmp55_;
							gint _tmp56_;
							ValaList* _tmp57_;
							gint _tmp58_;
							gpointer _tmp59_ = NULL;
							ValaMethod* method;
							ValaMethod* _tmp60_;
							gchar* _tmp61_ = NULL;
							gchar* _tmp62_;
							const gchar* _tmp63_;
							gboolean _tmp64_;
							_tmp54_ = _method_index;
							_method_index = _tmp54_ + 1;
							_tmp55_ = _method_index;
							_tmp56_ = _method_size;
							if (!(_tmp55_ < _tmp56_)) {
								break;
							}
							_tmp57_ = _method_list;
							_tmp58_ = _method_index;
							_tmp59_ = vala_list_get (_tmp57_, _tmp58_);
							method = (ValaMethod*) _tmp59_;
							_tmp60_ = method;
							_tmp61_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp60_, NULL);
							_tmp62_ = _tmp61_;
							_tmp63_ = method_cname;
							_tmp64_ = g_strcmp0 (_tmp62_, _tmp63_) == 0;
							_g_free0 (_tmp62_);
							if (_tmp64_) {
								ValaMethod* _tmp65_;
								ValaMethod* _tmp66_;
								_tmp65_ = method;
								_tmp66_ = _vala_code_node_ref0 (_tmp65_);
								_vala_code_node_unref0 (finish_method);
								finish_method = _tmp66_;
								_vala_code_node_unref0 (method);
								break;
							}
							_vala_code_node_unref0 (method);
						}
						_vala_iterable_unref0 (_method_list);
					}
					_g_free0 (method_cname);
				}
				_tmp67_ = finish_method;
				if (_tmp67_ != NULL) {
					ValaMethod* _tmp68_;
					ValaMethod* _tmp69_;
					ValaDataType* _tmp70_;
					ValaDataType* _tmp71_;
					ValaDataType* _tmp72_ = NULL;
					ValaDataType* _tmp73_;
					ValaMethod* _tmp74_;
					ValaAttribute* _tmp75_ = NULL;
					ValaAttribute* a;
					gboolean _tmp76_ = FALSE;
					ValaAttribute* _tmp77_;
					gboolean _tmp80_;
					gboolean _tmp84_ = FALSE;
					ValaAttribute* _tmp85_;
					gboolean _tmp88_;
					ValaSet* _tmp140_;
					ValaMethod* _tmp141_;
					_tmp68_ = m;
					_tmp69_ = finish_method;
					_tmp70_ = vala_method_get_return_type (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = vala_data_type_copy (_tmp71_);
					_tmp73_ = _tmp72_;
					vala_method_set_return_type (_tmp68_, _tmp73_);
					_vala_code_node_unref0 (_tmp73_);
					_tmp74_ = finish_method;
					_tmp75_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp74_, "CCode");
					a = _tmp75_;
					_tmp77_ = a;
					if (_tmp77_ != NULL) {
						ValaAttribute* _tmp78_;
						gboolean _tmp79_ = FALSE;
						_tmp78_ = a;
						_tmp79_ = vala_attribute_has_argument (_tmp78_, "array_length");
						_tmp76_ = _tmp79_;
					} else {
						_tmp76_ = FALSE;
					}
					_tmp80_ = _tmp76_;
					if (_tmp80_) {
						ValaMethod* _tmp81_;
						ValaAttribute* _tmp82_;
						gboolean _tmp83_ = FALSE;
						_tmp81_ = m;
						_tmp82_ = a;
						_tmp83_ = vala_attribute_get_bool (_tmp82_, "array_length", FALSE);
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp81_, "CCode", "array_length", _tmp83_, NULL);
					}
					_tmp85_ = a;
					if (_tmp85_ != NULL) {
						ValaAttribute* _tmp86_;
						gboolean _tmp87_ = FALSE;
						_tmp86_ = a;
						_tmp87_ = vala_attribute_has_argument (_tmp86_, "array_null_terminated");
						_tmp84_ = _tmp87_;
					} else {
						_tmp84_ = FALSE;
					}
					_tmp88_ = _tmp84_;
					if (_tmp88_) {
						ValaMethod* _tmp89_;
						ValaAttribute* _tmp90_;
						gboolean _tmp91_ = FALSE;
						_tmp89_ = m;
						_tmp90_ = a;
						_tmp91_ = vala_attribute_get_bool (_tmp90_, "array_null_terminated", FALSE);
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp89_, "CCode", "array_null_terminated", _tmp91_, NULL);
					}
					{
						ValaMethod* _tmp92_;
						ValaList* _tmp93_ = NULL;
						ValaList* _param_list;
						ValaList* _tmp94_;
						gint _tmp95_;
						gint _tmp96_;
						gint _param_size;
						gint _param_index;
						_tmp92_ = finish_method;
						_tmp93_ = vala_method_get_parameters (_tmp92_);
						_param_list = _tmp93_;
						_tmp94_ = _param_list;
						_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
						_tmp96_ = _tmp95_;
						_param_size = _tmp96_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp97_;
							gint _tmp98_;
							gint _tmp99_;
							ValaList* _tmp100_;
							gint _tmp101_;
							gpointer _tmp102_ = NULL;
							ValaParameter* param;
							ValaParameter* _tmp103_;
							ValaParameterDirection _tmp104_;
							ValaParameterDirection _tmp105_;
							_tmp97_ = _param_index;
							_param_index = _tmp97_ + 1;
							_tmp98_ = _param_index;
							_tmp99_ = _param_size;
							if (!(_tmp98_ < _tmp99_)) {
								break;
							}
							_tmp100_ = _param_list;
							_tmp101_ = _param_index;
							_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
							param = (ValaParameter*) _tmp102_;
							_tmp103_ = param;
							_tmp104_ = vala_parameter_get_direction (_tmp103_);
							_tmp105_ = _tmp104_;
							if (_tmp105_ == VALA_PARAMETER_DIRECTION_OUT) {
								ValaParameter* _tmp106_;
								ValaParameter* _tmp107_ = NULL;
								ValaParameter* async_param;
								ValaMethod* _tmp108_;
								ValaScope* _tmp109_;
								ValaScope* _tmp110_;
								ValaParameter* _tmp111_;
								const gchar* _tmp112_;
								const gchar* _tmp113_;
								ValaSymbol* _tmp114_ = NULL;
								ValaSymbol* _tmp115_;
								gboolean _tmp116_;
								ValaMethod* _tmp123_;
								ValaParameter* _tmp124_;
								_tmp106_ = param;
								_tmp107_ = vala_parameter_copy (_tmp106_);
								async_param = _tmp107_;
								_tmp108_ = m;
								_tmp109_ = vala_symbol_get_scope ((ValaSymbol*) _tmp108_);
								_tmp110_ = _tmp109_;
								_tmp111_ = param;
								_tmp112_ = vala_symbol_get_name ((ValaSymbol*) _tmp111_);
								_tmp113_ = _tmp112_;
								_tmp114_ = vala_scope_lookup (_tmp110_, _tmp113_);
								_tmp115_ = _tmp114_;
								_tmp116_ = _tmp115_ != NULL;
								_vala_code_node_unref0 (_tmp115_);
								if (_tmp116_) {
									ValaParameter* _tmp117_;
									ValaParameter* _tmp118_;
									const gchar* _tmp119_;
									const gchar* _tmp120_;
									gchar* _tmp121_;
									gchar* _tmp122_;
									_tmp117_ = async_param;
									_tmp118_ = async_param;
									_tmp119_ = vala_symbol_get_name ((ValaSymbol*) _tmp118_);
									_tmp120_ = _tmp119_;
									_tmp121_ = g_strconcat (_tmp120_, "_out", NULL);
									_tmp122_ = _tmp121_;
									vala_symbol_set_name ((ValaSymbol*) _tmp118_, _tmp122_);
									_g_free0 (_tmp122_);
								}
								_tmp123_ = m;
								_tmp124_ = async_param;
								vala_method_add_parameter (_tmp123_, _tmp124_);
								_vala_code_node_unref0 (async_param);
							}
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					{
						ValaMethod* _tmp125_;
						ValaList* _tmp126_ = NULL;
						ValaList* _error_type_list;
						ValaList* _tmp127_;
						gint _tmp128_;
						gint _tmp129_;
						gint _error_type_size;
						gint _error_type_index;
						_tmp125_ = finish_method;
						_tmp126_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp125_);
						_error_type_list = _tmp126_;
						_tmp127_ = _error_type_list;
						_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
						_tmp129_ = _tmp128_;
						_error_type_size = _tmp129_;
						_error_type_index = -1;
						while (TRUE) {
							gint _tmp130_;
							gint _tmp131_;
							gint _tmp132_;
							ValaList* _tmp133_;
							gint _tmp134_;
							gpointer _tmp135_ = NULL;
							ValaDataType* error_type;
							ValaMethod* _tmp136_;
							ValaDataType* _tmp137_;
							ValaDataType* _tmp138_ = NULL;
							ValaDataType* _tmp139_;
							_tmp130_ = _error_type_index;
							_error_type_index = _tmp130_ + 1;
							_tmp131_ = _error_type_index;
							_tmp132_ = _error_type_size;
							if (!(_tmp131_ < _tmp132_)) {
								break;
							}
							_tmp133_ = _error_type_list;
							_tmp134_ = _error_type_index;
							_tmp135_ = vala_list_get (_tmp133_, _tmp134_);
							error_type = (ValaDataType*) _tmp135_;
							_tmp136_ = m;
							_tmp137_ = error_type;
							_tmp138_ = vala_data_type_copy (_tmp137_);
							_tmp139_ = _tmp138_;
							vala_code_node_add_error_type ((ValaCodeNode*) _tmp136_, _tmp139_);
							_vala_code_node_unref0 (_tmp139_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					_tmp140_ = finish_methods;
					_tmp141_ = finish_method;
					vala_collection_add ((ValaCollection*) _tmp140_, _tmp141_);
					_vala_code_node_unref0 (a);
				}
				_vala_code_node_unref0 (finish_method);
				_g_free0 (finish_method_base);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaSet* _tmp142_;
		ValaIterator* _tmp143_ = NULL;
		ValaIterator* _m_it;
		_tmp142_ = finish_methods;
		_tmp143_ = vala_iterable_iterator ((ValaIterable*) _tmp142_);
		_m_it = _tmp143_;
		while (TRUE) {
			ValaIterator* _tmp144_;
			gboolean _tmp145_ = FALSE;
			ValaIterator* _tmp146_;
			gpointer _tmp147_ = NULL;
			ValaMethod* m;
			ValaObjectTypeSymbol* _tmp148_;
			ValaScope* _tmp149_;
			ValaScope* _tmp150_;
			ValaMethod* _tmp151_;
			const gchar* _tmp152_;
			const gchar* _tmp153_;
			ValaList* _tmp154_;
			ValaMethod* _tmp155_;
			_tmp144_ = _m_it;
			_tmp145_ = vala_iterator_next (_tmp144_);
			if (!_tmp145_) {
				break;
			}
			_tmp146_ = _m_it;
			_tmp147_ = vala_iterator_get (_tmp146_);
			m = (ValaMethod*) _tmp147_;
			_tmp148_ = type_symbol;
			_tmp149_ = vala_symbol_get_scope ((ValaSymbol*) _tmp148_);
			_tmp150_ = _tmp149_;
			_tmp151_ = m;
			_tmp152_ = vala_symbol_get_name ((ValaSymbol*) _tmp151_);
			_tmp153_ = _tmp152_;
			vala_scope_remove (_tmp150_, _tmp153_);
			_tmp154_ = methods;
			_tmp155_ = m;
			vala_collection_remove ((ValaCollection*) _tmp154_, _tmp155_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterator_unref0 (_m_it);
	}
	_vala_iterable_unref0 (methods);
	_vala_iterable_unref0 (finish_methods);
}


static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction) {
	ValaParameterDirection _vala_direction = 0;
	ValaDataType* result = NULL;
	ValaUnresolvedType* _tmp0_;
	ValaUnresolvedType* type;
	GIdlNodeType* _tmp1_;
	GITypeTag _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	_vala_direction = VALA_PARAMETER_DIRECTION_IN;
	_tmp0_ = vala_unresolved_type_new ();
	type = _tmp0_;
	_tmp1_ = type_node;
	_tmp2_ = _tmp1_->tag;
	if (_tmp2_ == TYPE_TAG_VOID) {
		GIdlNodeType* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = type_node;
		_tmp4_ = _tmp3_->is_pointer;
		if (_tmp4_) {
			ValaVoidType* _tmp5_;
			ValaVoidType* _tmp6_;
			ValaPointerType* _tmp7_;
			ValaDataType* _tmp8_;
			_tmp5_ = vala_void_type_new (NULL);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_pointer_type_new ((ValaDataType*) _tmp6_, NULL);
			_tmp8_ = (ValaDataType*) _tmp7_;
			_vala_code_node_unref0 (_tmp6_);
			result = _tmp8_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _vala_direction;
			}
			return result;
		} else {
			ValaVoidType* _tmp9_;
			_tmp9_ = vala_void_type_new (NULL);
			result = (ValaDataType*) _tmp9_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _vala_direction;
			}
			return result;
		}
	} else {
		GIdlNodeType* _tmp10_;
		GITypeTag _tmp11_;
		_tmp10_ = type_node;
		_tmp11_ = _tmp10_->tag;
		if (_tmp11_ == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedType* _tmp12_;
			ValaUnresolvedSymbol* _tmp13_;
			ValaUnresolvedSymbol* _tmp14_;
			_tmp12_ = type;
			_tmp13_ = vala_unresolved_symbol_new (NULL, "bool", NULL);
			_tmp14_ = _tmp13_;
			vala_unresolved_type_set_unresolved_symbol (_tmp12_, _tmp14_);
			_vala_code_node_unref0 (_tmp14_);
		} else {
			GIdlNodeType* _tmp15_;
			GITypeTag _tmp16_;
			_tmp15_ = type_node;
			_tmp16_ = _tmp15_->tag;
			if (_tmp16_ == TYPE_TAG_INT8) {
				ValaUnresolvedType* _tmp17_;
				ValaUnresolvedSymbol* _tmp18_;
				ValaUnresolvedSymbol* _tmp19_;
				_tmp17_ = type;
				_tmp18_ = vala_unresolved_symbol_new (NULL, "char", NULL);
				_tmp19_ = _tmp18_;
				vala_unresolved_type_set_unresolved_symbol (_tmp17_, _tmp19_);
				_vala_code_node_unref0 (_tmp19_);
			} else {
				GIdlNodeType* _tmp20_;
				GITypeTag _tmp21_;
				_tmp20_ = type_node;
				_tmp21_ = _tmp20_->tag;
				if (_tmp21_ == TYPE_TAG_UINT8) {
					ValaUnresolvedType* _tmp22_;
					ValaUnresolvedSymbol* _tmp23_;
					ValaUnresolvedSymbol* _tmp24_;
					_tmp22_ = type;
					_tmp23_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
					_tmp24_ = _tmp23_;
					vala_unresolved_type_set_unresolved_symbol (_tmp22_, _tmp24_);
					_vala_code_node_unref0 (_tmp24_);
				} else {
					GIdlNodeType* _tmp25_;
					GITypeTag _tmp26_;
					_tmp25_ = type_node;
					_tmp26_ = _tmp25_->tag;
					if (_tmp26_ == TYPE_TAG_INT16) {
						ValaUnresolvedType* _tmp27_;
						ValaUnresolvedSymbol* _tmp28_;
						ValaUnresolvedSymbol* _tmp29_;
						_tmp27_ = type;
						_tmp28_ = vala_unresolved_symbol_new (NULL, "int16", NULL);
						_tmp29_ = _tmp28_;
						vala_unresolved_type_set_unresolved_symbol (_tmp27_, _tmp29_);
						_vala_code_node_unref0 (_tmp29_);
					} else {
						GIdlNodeType* _tmp30_;
						GITypeTag _tmp31_;
						_tmp30_ = type_node;
						_tmp31_ = _tmp30_->tag;
						if (_tmp31_ == TYPE_TAG_UINT16) {
							ValaUnresolvedType* _tmp32_;
							ValaUnresolvedSymbol* _tmp33_;
							ValaUnresolvedSymbol* _tmp34_;
							_tmp32_ = type;
							_tmp33_ = vala_unresolved_symbol_new (NULL, "uint16", NULL);
							_tmp34_ = _tmp33_;
							vala_unresolved_type_set_unresolved_symbol (_tmp32_, _tmp34_);
							_vala_code_node_unref0 (_tmp34_);
						} else {
							GIdlNodeType* _tmp35_;
							GITypeTag _tmp36_;
							_tmp35_ = type_node;
							_tmp36_ = _tmp35_->tag;
							if (_tmp36_ == TYPE_TAG_INT32) {
								ValaUnresolvedType* _tmp37_;
								ValaUnresolvedSymbol* _tmp38_;
								ValaUnresolvedSymbol* _tmp39_;
								_tmp37_ = type;
								_tmp38_ = vala_unresolved_symbol_new (NULL, "int32", NULL);
								_tmp39_ = _tmp38_;
								vala_unresolved_type_set_unresolved_symbol (_tmp37_, _tmp39_);
								_vala_code_node_unref0 (_tmp39_);
							} else {
								GIdlNodeType* _tmp40_;
								GITypeTag _tmp41_;
								_tmp40_ = type_node;
								_tmp41_ = _tmp40_->tag;
								if (_tmp41_ == TYPE_TAG_UINT32) {
									ValaUnresolvedType* _tmp42_;
									ValaUnresolvedSymbol* _tmp43_;
									ValaUnresolvedSymbol* _tmp44_;
									_tmp42_ = type;
									_tmp43_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
									_tmp44_ = _tmp43_;
									vala_unresolved_type_set_unresolved_symbol (_tmp42_, _tmp44_);
									_vala_code_node_unref0 (_tmp44_);
								} else {
									GIdlNodeType* _tmp45_;
									GITypeTag _tmp46_;
									_tmp45_ = type_node;
									_tmp46_ = _tmp45_->tag;
									if (_tmp46_ == TYPE_TAG_INT64) {
										ValaUnresolvedType* _tmp47_;
										ValaUnresolvedSymbol* _tmp48_;
										ValaUnresolvedSymbol* _tmp49_;
										_tmp47_ = type;
										_tmp48_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
										_tmp49_ = _tmp48_;
										vala_unresolved_type_set_unresolved_symbol (_tmp47_, _tmp49_);
										_vala_code_node_unref0 (_tmp49_);
									} else {
										GIdlNodeType* _tmp50_;
										GITypeTag _tmp51_;
										_tmp50_ = type_node;
										_tmp51_ = _tmp50_->tag;
										if (_tmp51_ == TYPE_TAG_UINT64) {
											ValaUnresolvedType* _tmp52_;
											ValaUnresolvedSymbol* _tmp53_;
											ValaUnresolvedSymbol* _tmp54_;
											_tmp52_ = type;
											_tmp53_ = vala_unresolved_symbol_new (NULL, "uint64", NULL);
											_tmp54_ = _tmp53_;
											vala_unresolved_type_set_unresolved_symbol (_tmp52_, _tmp54_);
											_vala_code_node_unref0 (_tmp54_);
										} else {
											GIdlNodeType* _tmp55_;
											GITypeTag _tmp56_;
											_tmp55_ = type_node;
											_tmp56_ = _tmp55_->tag;
											if (_tmp56_ == TYPE_TAG_INT) {
												ValaUnresolvedType* _tmp57_;
												ValaUnresolvedSymbol* _tmp58_;
												ValaUnresolvedSymbol* _tmp59_;
												_tmp57_ = type;
												_tmp58_ = vala_unresolved_symbol_new (NULL, "int", NULL);
												_tmp59_ = _tmp58_;
												vala_unresolved_type_set_unresolved_symbol (_tmp57_, _tmp59_);
												_vala_code_node_unref0 (_tmp59_);
											} else {
												GIdlNodeType* _tmp60_;
												GITypeTag _tmp61_;
												_tmp60_ = type_node;
												_tmp61_ = _tmp60_->tag;
												if (_tmp61_ == TYPE_TAG_UINT) {
													ValaUnresolvedType* _tmp62_;
													ValaUnresolvedSymbol* _tmp63_;
													ValaUnresolvedSymbol* _tmp64_;
													_tmp62_ = type;
													_tmp63_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
													_tmp64_ = _tmp63_;
													vala_unresolved_type_set_unresolved_symbol (_tmp62_, _tmp64_);
													_vala_code_node_unref0 (_tmp64_);
												} else {
													GIdlNodeType* _tmp65_;
													GITypeTag _tmp66_;
													_tmp65_ = type_node;
													_tmp66_ = _tmp65_->tag;
													if (_tmp66_ == TYPE_TAG_LONG) {
														ValaUnresolvedType* _tmp67_;
														ValaUnresolvedSymbol* _tmp68_;
														ValaUnresolvedSymbol* _tmp69_;
														_tmp67_ = type;
														_tmp68_ = vala_unresolved_symbol_new (NULL, "long", NULL);
														_tmp69_ = _tmp68_;
														vala_unresolved_type_set_unresolved_symbol (_tmp67_, _tmp69_);
														_vala_code_node_unref0 (_tmp69_);
													} else {
														GIdlNodeType* _tmp70_;
														GITypeTag _tmp71_;
														_tmp70_ = type_node;
														_tmp71_ = _tmp70_->tag;
														if (_tmp71_ == TYPE_TAG_ULONG) {
															ValaUnresolvedType* _tmp72_;
															ValaUnresolvedSymbol* _tmp73_;
															ValaUnresolvedSymbol* _tmp74_;
															_tmp72_ = type;
															_tmp73_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
															_tmp74_ = _tmp73_;
															vala_unresolved_type_set_unresolved_symbol (_tmp72_, _tmp74_);
															_vala_code_node_unref0 (_tmp74_);
														} else {
															GIdlNodeType* _tmp75_;
															GITypeTag _tmp76_;
															_tmp75_ = type_node;
															_tmp76_ = _tmp75_->tag;
															if (_tmp76_ == TYPE_TAG_SSIZE) {
																ValaUnresolvedType* _tmp77_;
																ValaUnresolvedSymbol* _tmp78_;
																ValaUnresolvedSymbol* _tmp79_;
																_tmp77_ = type;
																_tmp78_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL);
																_tmp79_ = _tmp78_;
																vala_unresolved_type_set_unresolved_symbol (_tmp77_, _tmp79_);
																_vala_code_node_unref0 (_tmp79_);
															} else {
																GIdlNodeType* _tmp80_;
																GITypeTag _tmp81_;
																_tmp80_ = type_node;
																_tmp81_ = _tmp80_->tag;
																if (_tmp81_ == TYPE_TAG_SIZE) {
																	ValaUnresolvedType* _tmp82_;
																	ValaUnresolvedSymbol* _tmp83_;
																	ValaUnresolvedSymbol* _tmp84_;
																	_tmp82_ = type;
																	_tmp83_ = vala_unresolved_symbol_new (NULL, "size_t", NULL);
																	_tmp84_ = _tmp83_;
																	vala_unresolved_type_set_unresolved_symbol (_tmp82_, _tmp84_);
																	_vala_code_node_unref0 (_tmp84_);
																} else {
																	GIdlNodeType* _tmp85_;
																	GITypeTag _tmp86_;
																	_tmp85_ = type_node;
																	_tmp86_ = _tmp85_->tag;
																	if (_tmp86_ == TYPE_TAG_FLOAT) {
																		ValaUnresolvedType* _tmp87_;
																		ValaUnresolvedSymbol* _tmp88_;
																		ValaUnresolvedSymbol* _tmp89_;
																		_tmp87_ = type;
																		_tmp88_ = vala_unresolved_symbol_new (NULL, "float", NULL);
																		_tmp89_ = _tmp88_;
																		vala_unresolved_type_set_unresolved_symbol (_tmp87_, _tmp89_);
																		_vala_code_node_unref0 (_tmp89_);
																	} else {
																		GIdlNodeType* _tmp90_;
																		GITypeTag _tmp91_;
																		_tmp90_ = type_node;
																		_tmp91_ = _tmp90_->tag;
																		if (_tmp91_ == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedType* _tmp92_;
																			ValaUnresolvedSymbol* _tmp93_;
																			ValaUnresolvedSymbol* _tmp94_;
																			_tmp92_ = type;
																			_tmp93_ = vala_unresolved_symbol_new (NULL, "double", NULL);
																			_tmp94_ = _tmp93_;
																			vala_unresolved_type_set_unresolved_symbol (_tmp92_, _tmp94_);
																			_vala_code_node_unref0 (_tmp94_);
																		} else {
																			GIdlNodeType* _tmp95_;
																			GITypeTag _tmp96_;
																			_tmp95_ = type_node;
																			_tmp96_ = _tmp95_->tag;
																			if (_tmp96_ == TYPE_TAG_UTF8) {
																				ValaUnresolvedType* _tmp97_;
																				ValaUnresolvedSymbol* _tmp98_;
																				ValaUnresolvedSymbol* _tmp99_;
																				_tmp97_ = type;
																				_tmp98_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																				_tmp99_ = _tmp98_;
																				vala_unresolved_type_set_unresolved_symbol (_tmp97_, _tmp99_);
																				_vala_code_node_unref0 (_tmp99_);
																			} else {
																				GIdlNodeType* _tmp100_;
																				GITypeTag _tmp101_;
																				_tmp100_ = type_node;
																				_tmp101_ = _tmp100_->tag;
																				if (_tmp101_ == TYPE_TAG_FILENAME) {
																					ValaUnresolvedType* _tmp102_;
																					ValaUnresolvedSymbol* _tmp103_;
																					ValaUnresolvedSymbol* _tmp104_;
																					_tmp102_ = type;
																					_tmp103_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																					_tmp104_ = _tmp103_;
																					vala_unresolved_type_set_unresolved_symbol (_tmp102_, _tmp104_);
																					_vala_code_node_unref0 (_tmp104_);
																				} else {
																					GIdlNodeType* _tmp105_;
																					GITypeTag _tmp106_;
																					_tmp105_ = type_node;
																					_tmp106_ = _tmp105_->tag;
																					if (_tmp106_ == TYPE_TAG_ARRAY) {
																						GIdlNodeType* _tmp107_;
																						GIdlNodeType* _tmp108_;
																						ValaDataType* _tmp109_ = NULL;
																						ValaDataType* element_type;
																						ValaDataType* _tmp110_;
																						ValaUnresolvedType* _tmp111_;
																						ValaUnresolvedType* _tmp112_;
																						ValaDataType* _tmp113_;
																						ValaDataType* _tmp114_;
																						ValaSourceReference* _tmp115_;
																						ValaSourceReference* _tmp116_;
																						ValaArrayType* _tmp117_;
																						_tmp107_ = type_node;
																						_tmp108_ = _tmp107_->parameter_type1;
																						_tmp109_ = vala_gidl_parser_parse_type (self, _tmp108_, NULL);
																						element_type = _tmp109_;
																						_tmp110_ = element_type;
																						_tmp111_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp110_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp110_) : NULL);
																						_vala_code_node_unref0 (type);
																						type = _tmp111_;
																						_tmp112_ = type;
																						if (_tmp112_ == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							if (direction) {
																								*direction = _vala_direction;
																							}
																							return result;
																						}
																						_tmp113_ = element_type;
																						_tmp114_ = element_type;
																						_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp114_);
																						_tmp116_ = _tmp115_;
																						_tmp117_ = vala_array_type_new (_tmp113_, 1, _tmp116_);
																						result = (ValaDataType*) _tmp117_;
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						if (direction) {
																							*direction = _vala_direction;
																						}
																						return result;
																					} else {
																						GIdlNodeType* _tmp118_;
																						GITypeTag _tmp119_;
																						_tmp118_ = type_node;
																						_tmp119_ = _tmp118_->tag;
																						if (_tmp119_ == TYPE_TAG_LIST) {
																							ValaUnresolvedType* _tmp120_;
																							ValaUnresolvedSymbol* _tmp121_;
																							ValaUnresolvedSymbol* _tmp122_;
																							ValaUnresolvedSymbol* _tmp123_;
																							ValaUnresolvedSymbol* _tmp124_;
																							_tmp120_ = type;
																							_tmp121_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																							_tmp122_ = _tmp121_;
																							_tmp123_ = vala_unresolved_symbol_new (_tmp122_, "List", NULL);
																							_tmp124_ = _tmp123_;
																							vala_unresolved_type_set_unresolved_symbol (_tmp120_, _tmp124_);
																							_vala_code_node_unref0 (_tmp124_);
																							_vala_code_node_unref0 (_tmp122_);
																						} else {
																							GIdlNodeType* _tmp125_;
																							GITypeTag _tmp126_;
																							_tmp125_ = type_node;
																							_tmp126_ = _tmp125_->tag;
																							if (_tmp126_ == TYPE_TAG_SLIST) {
																								ValaUnresolvedType* _tmp127_;
																								ValaUnresolvedSymbol* _tmp128_;
																								ValaUnresolvedSymbol* _tmp129_;
																								ValaUnresolvedSymbol* _tmp130_;
																								ValaUnresolvedSymbol* _tmp131_;
																								_tmp127_ = type;
																								_tmp128_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																								_tmp129_ = _tmp128_;
																								_tmp130_ = vala_unresolved_symbol_new (_tmp129_, "SList", NULL);
																								_tmp131_ = _tmp130_;
																								vala_unresolved_type_set_unresolved_symbol (_tmp127_, _tmp131_);
																								_vala_code_node_unref0 (_tmp131_);
																								_vala_code_node_unref0 (_tmp129_);
																							} else {
																								GIdlNodeType* _tmp132_;
																								GITypeTag _tmp133_;
																								_tmp132_ = type_node;
																								_tmp133_ = _tmp132_->tag;
																								if (_tmp133_ == TYPE_TAG_HASH) {
																									ValaUnresolvedType* _tmp134_;
																									ValaUnresolvedSymbol* _tmp135_;
																									ValaUnresolvedSymbol* _tmp136_;
																									ValaUnresolvedSymbol* _tmp137_;
																									ValaUnresolvedSymbol* _tmp138_;
																									_tmp134_ = type;
																									_tmp135_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																									_tmp136_ = _tmp135_;
																									_tmp137_ = vala_unresolved_symbol_new (_tmp136_, "HashTable", NULL);
																									_tmp138_ = _tmp137_;
																									vala_unresolved_type_set_unresolved_symbol (_tmp134_, _tmp138_);
																									_vala_code_node_unref0 (_tmp138_);
																									_vala_code_node_unref0 (_tmp136_);
																								} else {
																									GIdlNodeType* _tmp139_;
																									GITypeTag _tmp140_;
																									_tmp139_ = type_node;
																									_tmp140_ = _tmp139_->tag;
																									if (_tmp140_ == TYPE_TAG_ERROR) {
																										ValaUnresolvedType* _tmp141_;
																										ValaUnresolvedSymbol* _tmp142_;
																										ValaUnresolvedSymbol* _tmp143_;
																										ValaUnresolvedSymbol* _tmp144_;
																										ValaUnresolvedSymbol* _tmp145_;
																										_tmp141_ = type;
																										_tmp142_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																										_tmp143_ = _tmp142_;
																										_tmp144_ = vala_unresolved_symbol_new (_tmp143_, "Error", NULL);
																										_tmp145_ = _tmp144_;
																										vala_unresolved_type_set_unresolved_symbol (_tmp141_, _tmp145_);
																										_vala_code_node_unref0 (_tmp145_);
																										_vala_code_node_unref0 (_tmp143_);
																									} else {
																										GIdlNodeType* _tmp146_;
																										gboolean _tmp147_;
																										_tmp146_ = type_node;
																										_tmp147_ = _tmp146_->is_interface;
																										if (_tmp147_) {
																											GIdlNodeType* _tmp148_;
																											const gchar* _tmp149_;
																											gchar* _tmp150_;
																											gchar* n;
																											const gchar* _tmp151_;
																											const gchar* _tmp152_;
																											gboolean _tmp153_ = FALSE;
																											gboolean _tmp158_ = FALSE;
																											GIdlNodeType* _tmp159_;
																											gboolean _tmp160_;
																											gboolean _tmp165_;
																											_tmp148_ = type_node;
																											_tmp149_ = _tmp148_->interface;
																											_tmp150_ = g_strdup (_tmp149_);
																											n = _tmp150_;
																											_tmp151_ = n;
																											if (g_strcmp0 (_tmp151_, "") == 0) {
																												result = NULL;
																												_g_free0 (n);
																												_vala_code_node_unref0 (type);
																												if (direction) {
																													*direction = _vala_direction;
																												}
																												return result;
																											}
																											_tmp152_ = n;
																											_tmp153_ = g_str_has_prefix (_tmp152_, "const-");
																											if (_tmp153_) {
																												const gchar* _tmp154_;
																												gint _tmp155_;
																												gint _tmp156_;
																												gchar* _tmp157_ = NULL;
																												_tmp154_ = n;
																												_tmp155_ = strlen ("const-");
																												_tmp156_ = _tmp155_;
																												_tmp157_ = string_substring (_tmp154_, (glong) _tmp156_, (glong) (-1));
																												_g_free0 (n);
																												n = _tmp157_;
																											}
																											_tmp159_ = type_node;
																											_tmp160_ = _tmp159_->is_pointer;
																											if (_tmp160_) {
																												gboolean _tmp161_ = FALSE;
																												const gchar* _tmp162_;
																												gboolean _tmp164_;
																												_tmp162_ = n;
																												if (g_strcmp0 (_tmp162_, "gchar") == 0) {
																													_tmp161_ = TRUE;
																												} else {
																													const gchar* _tmp163_;
																													_tmp163_ = n;
																													_tmp161_ = g_strcmp0 (_tmp163_, "char") == 0;
																												}
																												_tmp164_ = _tmp161_;
																												_tmp158_ = _tmp164_;
																											} else {
																												_tmp158_ = FALSE;
																											}
																											_tmp165_ = _tmp158_;
																											if (_tmp165_) {
																												ValaUnresolvedType* _tmp166_;
																												ValaUnresolvedSymbol* _tmp167_;
																												ValaUnresolvedSymbol* _tmp168_;
																												GIdlNodeType* _tmp169_;
																												const gchar* _tmp170_;
																												gboolean _tmp171_ = FALSE;
																												_tmp166_ = type;
																												_tmp167_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																												_tmp168_ = _tmp167_;
																												vala_unresolved_type_set_unresolved_symbol (_tmp166_, _tmp168_);
																												_vala_code_node_unref0 (_tmp168_);
																												_tmp169_ = type_node;
																												_tmp170_ = _tmp169_->unparsed;
																												_tmp171_ = g_str_has_suffix (_tmp170_, "**");
																												if (_tmp171_) {
																													_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																												}
																											} else {
																												const gchar* _tmp172_;
																												_tmp172_ = n;
																												if (g_strcmp0 (_tmp172_, "gunichar") == 0) {
																													ValaUnresolvedType* _tmp173_;
																													ValaUnresolvedSymbol* _tmp174_;
																													ValaUnresolvedSymbol* _tmp175_;
																													_tmp173_ = type;
																													_tmp174_ = vala_unresolved_symbol_new (NULL, "unichar", NULL);
																													_tmp175_ = _tmp174_;
																													vala_unresolved_type_set_unresolved_symbol (_tmp173_, _tmp175_);
																													_vala_code_node_unref0 (_tmp175_);
																												} else {
																													const gchar* _tmp176_;
																													_tmp176_ = n;
																													if (g_strcmp0 (_tmp176_, "gchar") == 0) {
																														ValaUnresolvedType* _tmp177_;
																														ValaUnresolvedSymbol* _tmp178_;
																														ValaUnresolvedSymbol* _tmp179_;
																														_tmp177_ = type;
																														_tmp178_ = vala_unresolved_symbol_new (NULL, "char", NULL);
																														_tmp179_ = _tmp178_;
																														vala_unresolved_type_set_unresolved_symbol (_tmp177_, _tmp179_);
																														_vala_code_node_unref0 (_tmp179_);
																													} else {
																														gboolean _tmp180_ = FALSE;
																														const gchar* _tmp181_;
																														gboolean _tmp183_;
																														_tmp181_ = n;
																														if (g_strcmp0 (_tmp181_, "guchar") == 0) {
																															_tmp180_ = TRUE;
																														} else {
																															const gchar* _tmp182_;
																															_tmp182_ = n;
																															_tmp180_ = g_strcmp0 (_tmp182_, "guint8") == 0;
																														}
																														_tmp183_ = _tmp180_;
																														if (_tmp183_) {
																															ValaUnresolvedType* _tmp184_;
																															ValaUnresolvedSymbol* _tmp185_;
																															ValaUnresolvedSymbol* _tmp186_;
																															GIdlNodeType* _tmp187_;
																															gboolean _tmp188_;
																															_tmp184_ = type;
																															_tmp185_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
																															_tmp186_ = _tmp185_;
																															vala_unresolved_type_set_unresolved_symbol (_tmp184_, _tmp186_);
																															_vala_code_node_unref0 (_tmp186_);
																															_tmp187_ = type_node;
																															_tmp188_ = _tmp187_->is_pointer;
																															if (_tmp188_) {
																																ValaUnresolvedType* _tmp189_;
																																ValaUnresolvedType* _tmp190_;
																																ValaSourceReference* _tmp191_;
																																ValaSourceReference* _tmp192_;
																																ValaArrayType* _tmp193_;
																																_tmp189_ = type;
																																_tmp190_ = type;
																																_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
																																_tmp192_ = _tmp191_;
																																_tmp193_ = vala_array_type_new ((ValaDataType*) _tmp189_, 1, _tmp192_);
																																result = (ValaDataType*) _tmp193_;
																																_g_free0 (n);
																																_vala_code_node_unref0 (type);
																																if (direction) {
																																	*direction = _vala_direction;
																																}
																																return result;
																															}
																														} else {
																															const gchar* _tmp194_;
																															_tmp194_ = n;
																															if (g_strcmp0 (_tmp194_, "gushort") == 0) {
																																ValaUnresolvedType* _tmp195_;
																																ValaUnresolvedSymbol* _tmp196_;
																																ValaUnresolvedSymbol* _tmp197_;
																																_tmp195_ = type;
																																_tmp196_ = vala_unresolved_symbol_new (NULL, "ushort", NULL);
																																_tmp197_ = _tmp196_;
																																vala_unresolved_type_set_unresolved_symbol (_tmp195_, _tmp197_);
																																_vala_code_node_unref0 (_tmp197_);
																															} else {
																																const gchar* _tmp198_;
																																_tmp198_ = n;
																																if (g_strcmp0 (_tmp198_, "gshort") == 0) {
																																	ValaUnresolvedType* _tmp199_;
																																	ValaUnresolvedSymbol* _tmp200_;
																																	ValaUnresolvedSymbol* _tmp201_;
																																	_tmp199_ = type;
																																	_tmp200_ = vala_unresolved_symbol_new (NULL, "short", NULL);
																																	_tmp201_ = _tmp200_;
																																	vala_unresolved_type_set_unresolved_symbol (_tmp199_, _tmp201_);
																																	_vala_code_node_unref0 (_tmp201_);
																																} else {
																																	gboolean _tmp202_ = FALSE;
																																	const gchar* _tmp203_;
																																	gboolean _tmp205_;
																																	_tmp203_ = n;
																																	if (g_strcmp0 (_tmp203_, "gconstpointer") == 0) {
																																		_tmp202_ = TRUE;
																																	} else {
																																		const gchar* _tmp204_;
																																		_tmp204_ = n;
																																		_tmp202_ = g_strcmp0 (_tmp204_, "void") == 0;
																																	}
																																	_tmp205_ = _tmp202_;
																																	if (_tmp205_) {
																																		ValaVoidType* _tmp206_;
																																		ValaVoidType* _tmp207_;
																																		ValaPointerType* _tmp208_;
																																		ValaDataType* _tmp209_;
																																		_tmp206_ = vala_void_type_new (NULL);
																																		_tmp207_ = _tmp206_;
																																		_tmp208_ = vala_pointer_type_new ((ValaDataType*) _tmp207_, NULL);
																																		_tmp209_ = (ValaDataType*) _tmp208_;
																																		_vala_code_node_unref0 (_tmp207_);
																																		result = _tmp209_;
																																		_g_free0 (n);
																																		_vala_code_node_unref0 (type);
																																		if (direction) {
																																			*direction = _vala_direction;
																																		}
																																		return result;
																																	} else {
																																		gboolean _tmp210_ = FALSE;
																																		const gchar* _tmp211_;
																																		gboolean _tmp213_;
																																		_tmp211_ = n;
																																		if (g_strcmp0 (_tmp211_, "goffset") == 0) {
																																			_tmp210_ = TRUE;
																																		} else {
																																			const gchar* _tmp212_;
																																			_tmp212_ = n;
																																			_tmp210_ = g_strcmp0 (_tmp212_, "off_t") == 0;
																																		}
																																		_tmp213_ = _tmp210_;
																																		if (_tmp213_) {
																																			ValaUnresolvedType* _tmp214_;
																																			ValaUnresolvedSymbol* _tmp215_;
																																			ValaUnresolvedSymbol* _tmp216_;
																																			_tmp214_ = type;
																																			_tmp215_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
																																			_tmp216_ = _tmp215_;
																																			vala_unresolved_type_set_unresolved_symbol (_tmp214_, _tmp216_);
																																			_vala_code_node_unref0 (_tmp216_);
																																		} else {
																																			const gchar* _tmp217_;
																																			_tmp217_ = n;
																																			if (g_strcmp0 (_tmp217_, "value_array") == 0) {
																																				ValaUnresolvedType* _tmp218_;
																																				ValaUnresolvedSymbol* _tmp219_;
																																				ValaUnresolvedSymbol* _tmp220_;
																																				ValaUnresolvedSymbol* _tmp221_;
																																				ValaUnresolvedSymbol* _tmp222_;
																																				_tmp218_ = type;
																																				_tmp219_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																				_tmp220_ = _tmp219_;
																																				_tmp221_ = vala_unresolved_symbol_new (_tmp220_, "ValueArray", NULL);
																																				_tmp222_ = _tmp221_;
																																				vala_unresolved_type_set_unresolved_symbol (_tmp218_, _tmp222_);
																																				_vala_code_node_unref0 (_tmp222_);
																																				_vala_code_node_unref0 (_tmp220_);
																																			} else {
																																				const gchar* _tmp223_;
																																				_tmp223_ = n;
																																				if (g_strcmp0 (_tmp223_, "time_t") == 0) {
																																					ValaUnresolvedType* _tmp224_;
																																					ValaUnresolvedSymbol* _tmp225_;
																																					ValaUnresolvedSymbol* _tmp226_;
																																					_tmp224_ = type;
																																					_tmp225_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
																																					_tmp226_ = _tmp225_;
																																					vala_unresolved_type_set_unresolved_symbol (_tmp224_, _tmp226_);
																																					_vala_code_node_unref0 (_tmp226_);
																																				} else {
																																					const gchar* _tmp227_;
																																					_tmp227_ = n;
																																					if (g_strcmp0 (_tmp227_, "socklen_t") == 0) {
																																						ValaUnresolvedType* _tmp228_;
																																						ValaUnresolvedSymbol* _tmp229_;
																																						ValaUnresolvedSymbol* _tmp230_;
																																						_tmp228_ = type;
																																						_tmp229_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
																																						_tmp230_ = _tmp229_;
																																						vala_unresolved_type_set_unresolved_symbol (_tmp228_, _tmp230_);
																																						_vala_code_node_unref0 (_tmp230_);
																																					} else {
																																						const gchar* _tmp231_;
																																						_tmp231_ = n;
																																						if (g_strcmp0 (_tmp231_, "mode_t") == 0) {
																																							ValaUnresolvedType* _tmp232_;
																																							ValaUnresolvedSymbol* _tmp233_;
																																							ValaUnresolvedSymbol* _tmp234_;
																																							_tmp232_ = type;
																																							_tmp233_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																							_tmp234_ = _tmp233_;
																																							vala_unresolved_type_set_unresolved_symbol (_tmp232_, _tmp234_);
																																							_vala_code_node_unref0 (_tmp234_);
																																						} else {
																																							gboolean _tmp235_ = FALSE;
																																							const gchar* _tmp236_;
																																							gboolean _tmp238_;
																																							_tmp236_ = n;
																																							if (g_strcmp0 (_tmp236_, "gint") == 0) {
																																								_tmp235_ = TRUE;
																																							} else {
																																								const gchar* _tmp237_;
																																								_tmp237_ = n;
																																								_tmp235_ = g_strcmp0 (_tmp237_, "pid_t") == 0;
																																							}
																																							_tmp238_ = _tmp235_;
																																							if (_tmp238_) {
																																								ValaUnresolvedType* _tmp239_;
																																								ValaUnresolvedSymbol* _tmp240_;
																																								ValaUnresolvedSymbol* _tmp241_;
																																								_tmp239_ = type;
																																								_tmp240_ = vala_unresolved_symbol_new (NULL, "int", NULL);
																																								_tmp241_ = _tmp240_;
																																								vala_unresolved_type_set_unresolved_symbol (_tmp239_, _tmp241_);
																																								_vala_code_node_unref0 (_tmp241_);
																																							} else {
																																								gboolean _tmp242_ = FALSE;
																																								const gchar* _tmp243_;
																																								gboolean _tmp245_;
																																								_tmp243_ = n;
																																								if (g_strcmp0 (_tmp243_, "unsigned") == 0) {
																																									_tmp242_ = TRUE;
																																								} else {
																																									const gchar* _tmp244_;
																																									_tmp244_ = n;
																																									_tmp242_ = g_strcmp0 (_tmp244_, "unsigned-int") == 0;
																																								}
																																								_tmp245_ = _tmp242_;
																																								if (_tmp245_) {
																																									ValaUnresolvedType* _tmp246_;
																																									ValaUnresolvedSymbol* _tmp247_;
																																									ValaUnresolvedSymbol* _tmp248_;
																																									_tmp246_ = type;
																																									_tmp247_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																									_tmp248_ = _tmp247_;
																																									vala_unresolved_type_set_unresolved_symbol (_tmp246_, _tmp248_);
																																									_vala_code_node_unref0 (_tmp248_);
																																								} else {
																																									const gchar* _tmp249_;
																																									_tmp249_ = n;
																																									if (g_strcmp0 (_tmp249_, "FILE") == 0) {
																																										ValaUnresolvedType* _tmp250_;
																																										ValaUnresolvedSymbol* _tmp251_;
																																										ValaUnresolvedSymbol* _tmp252_;
																																										ValaUnresolvedSymbol* _tmp253_;
																																										ValaUnresolvedSymbol* _tmp254_;
																																										_tmp250_ = type;
																																										_tmp251_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																										_tmp252_ = _tmp251_;
																																										_tmp253_ = vala_unresolved_symbol_new (_tmp252_, "FileStream", NULL);
																																										_tmp254_ = _tmp253_;
																																										vala_unresolved_type_set_unresolved_symbol (_tmp250_, _tmp254_);
																																										_vala_code_node_unref0 (_tmp254_);
																																										_vala_code_node_unref0 (_tmp252_);
																																									} else {
																																										const gchar* _tmp255_;
																																										_tmp255_ = n;
																																										if (g_strcmp0 (_tmp255_, "struct") == 0) {
																																											ValaVoidType* _tmp256_;
																																											ValaVoidType* _tmp257_;
																																											ValaPointerType* _tmp258_;
																																											ValaDataType* _tmp259_;
																																											_tmp256_ = vala_void_type_new (NULL);
																																											_tmp257_ = _tmp256_;
																																											_tmp258_ = vala_pointer_type_new ((ValaDataType*) _tmp257_, NULL);
																																											_tmp259_ = (ValaDataType*) _tmp258_;
																																											_vala_code_node_unref0 (_tmp257_);
																																											result = _tmp259_;
																																											_g_free0 (n);
																																											_vala_code_node_unref0 (type);
																																											if (direction) {
																																												*direction = _vala_direction;
																																											}
																																											return result;
																																										} else {
																																											const gchar* _tmp260_;
																																											_tmp260_ = n;
																																											if (g_strcmp0 (_tmp260_, "iconv_t") == 0) {
																																												ValaVoidType* _tmp261_;
																																												ValaVoidType* _tmp262_;
																																												ValaPointerType* _tmp263_;
																																												ValaDataType* _tmp264_;
																																												_tmp261_ = vala_void_type_new (NULL);
																																												_tmp262_ = _tmp261_;
																																												_tmp263_ = vala_pointer_type_new ((ValaDataType*) _tmp262_, NULL);
																																												_tmp264_ = (ValaDataType*) _tmp263_;
																																												_vala_code_node_unref0 (_tmp262_);
																																												result = _tmp264_;
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												if (direction) {
																																													*direction = _vala_direction;
																																												}
																																												return result;
																																											} else {
																																												const gchar* _tmp265_;
																																												_tmp265_ = n;
																																												if (g_strcmp0 (_tmp265_, "GType") == 0) {
																																													ValaUnresolvedType* _tmp266_;
																																													ValaUnresolvedSymbol* _tmp267_;
																																													ValaUnresolvedSymbol* _tmp268_;
																																													ValaUnresolvedSymbol* _tmp269_;
																																													ValaUnresolvedSymbol* _tmp270_;
																																													GIdlNodeType* _tmp271_;
																																													gboolean _tmp272_;
																																													_tmp266_ = type;
																																													_tmp267_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																													_tmp268_ = _tmp267_;
																																													_tmp269_ = vala_unresolved_symbol_new (_tmp268_, "Type", NULL);
																																													_tmp270_ = _tmp269_;
																																													vala_unresolved_type_set_unresolved_symbol (_tmp266_, _tmp270_);
																																													_vala_code_node_unref0 (_tmp270_);
																																													_vala_code_node_unref0 (_tmp268_);
																																													_tmp271_ = type_node;
																																													_tmp272_ = _tmp271_->is_pointer;
																																													if (_tmp272_) {
																																														ValaUnresolvedType* _tmp273_;
																																														ValaUnresolvedType* _tmp274_;
																																														ValaSourceReference* _tmp275_;
																																														ValaSourceReference* _tmp276_;
																																														ValaArrayType* _tmp277_;
																																														_tmp273_ = type;
																																														_tmp274_ = type;
																																														_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp274_);
																																														_tmp276_ = _tmp275_;
																																														_tmp277_ = vala_array_type_new ((ValaDataType*) _tmp273_, 1, _tmp276_);
																																														result = (ValaDataType*) _tmp277_;
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														if (direction) {
																																															*direction = _vala_direction;
																																														}
																																														return result;
																																													}
																																												} else {
																																													const gchar* _tmp278_;
																																													_tmp278_ = n;
																																													if (g_strcmp0 (_tmp278_, "GStrv") == 0) {
																																														ValaUnresolvedType* _tmp279_;
																																														ValaUnresolvedSymbol* _tmp280_;
																																														ValaUnresolvedSymbol* _tmp281_;
																																														ValaUnresolvedType* _tmp282_;
																																														ValaUnresolvedType* _tmp283_;
																																														ValaSourceReference* _tmp284_;
																																														ValaSourceReference* _tmp285_;
																																														ValaArrayType* _tmp286_;
																																														_tmp279_ = type;
																																														_tmp280_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																																														_tmp281_ = _tmp280_;
																																														vala_unresolved_type_set_unresolved_symbol (_tmp279_, _tmp281_);
																																														_vala_code_node_unref0 (_tmp281_);
																																														_tmp282_ = type;
																																														_tmp283_ = type;
																																														_tmp284_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp283_);
																																														_tmp285_ = _tmp284_;
																																														_tmp286_ = vala_array_type_new ((ValaDataType*) _tmp282_, 1, _tmp285_);
																																														result = (ValaDataType*) _tmp286_;
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														if (direction) {
																																															*direction = _vala_direction;
																																														}
																																														return result;
																																													} else {
																																														const gchar* _tmp287_;
																																														ValaDataType* _tmp288_ = NULL;
																																														ValaDataType* named_type;
																																														ValaDataType* _tmp289_;
																																														ValaUnresolvedType* _tmp290_;
																																														ValaUnresolvedType* _tmp291_;
																																														const gchar* _tmp292_;
																																														gboolean _tmp293_ = FALSE;
																																														_tmp287_ = n;
																																														_tmp288_ = vala_gidl_parser_parse_type_string (self, _tmp287_);
																																														named_type = _tmp288_;
																																														_tmp289_ = named_type;
																																														_tmp290_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp289_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp289_) : NULL);
																																														_vala_code_node_unref0 (type);
																																														type = _tmp290_;
																																														_tmp291_ = type;
																																														if (_tmp291_ == NULL) {
																																															result = named_type;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _vala_direction;
																																															}
																																															return result;
																																														}
																																														_tmp292_ = n;
																																														_tmp293_ = vala_gidl_parser_is_simple_type (self, _tmp292_);
																																														if (_tmp293_) {
																																															GIdlNodeType* _tmp294_;
																																															gboolean _tmp295_;
																																															_tmp294_ = type_node;
																																															_tmp295_ = _tmp294_->is_pointer;
																																															if (_tmp295_) {
																																																_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														} else {
																																															GIdlNodeType* _tmp296_;
																																															const gchar* _tmp297_;
																																															gboolean _tmp298_ = FALSE;
																																															_tmp296_ = type_node;
																																															_tmp297_ = _tmp296_->unparsed;
																																															_tmp298_ = g_str_has_suffix (_tmp297_, "**");
																																															if (_tmp298_) {
																																																_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														}
																																														_vala_code_node_unref0 (named_type);
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (n);
																										} else {
																											FILE* _tmp299_;
																											GIdlNodeType* _tmp300_;
																											GITypeTag _tmp301_;
																											_tmp299_ = stdout;
																											_tmp300_ = type_node;
																											_tmp301_ = _tmp300_->tag;
																											fprintf (_tmp299_, "%d\n", (gint) _tmp301_);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = (ValaDataType*) type;
	if (direction) {
		*direction = _vala_direction;
	}
	return result;
}


static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name) {
	gboolean result = FALSE;
	ValaMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	ValaStruct* st;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	_tmp0_ = self->priv->cname_type_map;
	_tmp1_ = type_name;
	_tmp2_ = vala_map_get (_tmp0_, _tmp1_);
	st = G_TYPE_CHECK_INSTANCE_TYPE ((ValaTypeSymbol*) _tmp2_, VALA_TYPE_STRUCT) ? ((ValaStruct*) ((ValaTypeSymbol*) _tmp2_)) : NULL;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_simple_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n) {
	ValaDataType* result = NULL;
	const gchar* _tmp0_;
	ValaUnresolvedType* _tmp5_;
	ValaUnresolvedType* type;
	ValaMap* _tmp6_;
	const gchar* _tmp7_;
	gpointer _tmp8_ = NULL;
	ValaTypeSymbol* dt;
	ValaTypeSymbol* _tmp9_;
	const gchar* _tmp28_;
	gint _tmp29_ = 0;
	gchar** _tmp30_ = NULL;
	gchar** type_attributes;
	gint type_attributes_length1;
	gint _type_attributes_size_;
	gchar* ns_name;
	gchar** _tmp31_;
	gint _tmp31__length1;
	ValaUnresolvedType* _tmp74_;
	ValaUnresolvedSymbol* _tmp75_;
	ValaUnresolvedSymbol* _tmp76_;
	const gchar* _tmp93_;
	ValaNamespace* _tmp94_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	gboolean _tmp97_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = n;
	if (g_strcmp0 (_tmp0_, "va_list") == 0) {
		ValaVoidType* _tmp1_;
		ValaVoidType* _tmp2_;
		ValaPointerType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp1_ = vala_void_type_new (NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_pointer_type_new ((ValaDataType*) _tmp2_, NULL);
		_tmp4_ = (ValaDataType*) _tmp3_;
		_vala_code_node_unref0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = vala_unresolved_type_new ();
	type = _tmp5_;
	_tmp6_ = self->priv->cname_type_map;
	_tmp7_ = n;
	_tmp8_ = vala_map_get (_tmp6_, _tmp7_);
	dt = (ValaTypeSymbol*) _tmp8_;
	_tmp9_ = dt;
	if (_tmp9_ != NULL) {
		ValaUnresolvedSymbol* parent_symbol;
		ValaTypeSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		ValaUnresolvedType* _tmp21_;
		ValaUnresolvedSymbol* _tmp22_;
		ValaTypeSymbol* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		ValaUnresolvedSymbol* _tmp26_;
		ValaUnresolvedSymbol* _tmp27_;
		parent_symbol = NULL;
		_tmp10_ = dt;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_symbol_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ != NULL) {
			ValaTypeSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaSymbol* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			ValaUnresolvedSymbol* _tmp20_;
			_tmp15_ = dt;
			_tmp16_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_unresolved_symbol_new (NULL, _tmp19_, NULL);
			_vala_code_node_unref0 (parent_symbol);
			parent_symbol = _tmp20_;
		}
		_tmp21_ = type;
		_tmp22_ = parent_symbol;
		_tmp23_ = dt;
		_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_unresolved_symbol_new (_tmp22_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_unresolved_type_set_unresolved_symbol (_tmp21_, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp28_ = n;
	_tmp30_ = vala_gidl_parser_get_attributes (self, _tmp28_, &_tmp29_);
	type_attributes = _tmp30_;
	type_attributes_length1 = _tmp29_;
	_type_attributes_size_ = type_attributes_length1;
	ns_name = NULL;
	_tmp31_ = type_attributes;
	_tmp31__length1 = type_attributes_length1;
	if (NULL != _tmp31_) {
		gchar** _tmp32_;
		gint _tmp32__length1;
		_tmp32_ = type_attributes;
		_tmp32__length1 = type_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp32_;
			attr_collection_length1 = _tmp32__length1;
			for (attr_it = 0; attr_it < _tmp32__length1; attr_it = attr_it + 1) {
				gchar* _tmp33_;
				gchar* attr = NULL;
				_tmp33_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp33_;
				{
					const gchar* _tmp34_;
					gchar** _tmp35_;
					gchar** _tmp36_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp37_;
					gint _tmp37__length1;
					const gchar* _tmp38_;
					_tmp34_ = attr;
					_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, "=", 2);
					nv = _tmp36_;
					nv_length1 = _vala_array_length (_tmp35_);
					_nv_size_ = nv_length1;
					_tmp37_ = nv;
					_tmp37__length1 = nv_length1;
					_tmp38_ = _tmp37_[0];
					if (g_strcmp0 (_tmp38_, "cprefix") == 0) {
						ValaUnresolvedType* _tmp39_;
						const gchar* _tmp40_;
						gchar** _tmp41_;
						gint _tmp41__length1;
						const gchar* _tmp42_;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_;
						gint _tmp45_;
						gint _tmp46_;
						gchar* _tmp47_ = NULL;
						gchar* _tmp48_;
						ValaUnresolvedSymbol* _tmp49_;
						ValaUnresolvedSymbol* _tmp50_;
						_tmp39_ = type;
						_tmp40_ = n;
						_tmp41_ = nv;
						_tmp41__length1 = nv_length1;
						_tmp42_ = _tmp41_[1];
						_tmp43_ = vala_gidl_parser_eval (self, _tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = strlen (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = string_substring (_tmp40_, (glong) _tmp46_, (glong) (-1));
						_tmp48_ = _tmp47_;
						_tmp49_ = vala_unresolved_symbol_new (NULL, _tmp48_, NULL);
						_tmp50_ = _tmp49_;
						vala_unresolved_type_set_unresolved_symbol (_tmp39_, _tmp50_);
						_vala_code_node_unref0 (_tmp50_);
						_g_free0 (_tmp48_);
						_g_free0 (_tmp44_);
					} else {
						gchar** _tmp51_;
						gint _tmp51__length1;
						const gchar* _tmp52_;
						_tmp51_ = nv;
						_tmp51__length1 = nv_length1;
						_tmp52_ = _tmp51_[0];
						if (g_strcmp0 (_tmp52_, "name") == 0) {
							ValaUnresolvedType* _tmp53_;
							gchar** _tmp54_;
							gint _tmp54__length1;
							const gchar* _tmp55_;
							gchar* _tmp56_ = NULL;
							gchar* _tmp57_;
							ValaUnresolvedSymbol* _tmp58_;
							ValaUnresolvedSymbol* _tmp59_;
							_tmp53_ = type;
							_tmp54_ = nv;
							_tmp54__length1 = nv_length1;
							_tmp55_ = _tmp54_[1];
							_tmp56_ = vala_gidl_parser_eval (self, _tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = vala_unresolved_symbol_new (NULL, _tmp57_, NULL);
							_tmp59_ = _tmp58_;
							vala_unresolved_type_set_unresolved_symbol (_tmp53_, _tmp59_);
							_vala_code_node_unref0 (_tmp59_);
							_g_free0 (_tmp57_);
						} else {
							gchar** _tmp60_;
							gint _tmp60__length1;
							const gchar* _tmp61_;
							_tmp60_ = nv;
							_tmp60__length1 = nv_length1;
							_tmp61_ = _tmp60_[0];
							if (g_strcmp0 (_tmp61_, "namespace") == 0) {
								gchar** _tmp62_;
								gint _tmp62__length1;
								const gchar* _tmp63_;
								gchar* _tmp64_ = NULL;
								_tmp62_ = nv;
								_tmp62__length1 = nv_length1;
								_tmp63_ = _tmp62_[1];
								_tmp64_ = vala_gidl_parser_eval (self, _tmp63_);
								_g_free0 (ns_name);
								ns_name = _tmp64_;
							} else {
								gchar** _tmp65_;
								gint _tmp65__length1;
								const gchar* _tmp66_;
								_tmp65_ = nv;
								_tmp65__length1 = nv_length1;
								_tmp66_ = _tmp65_[0];
								if (g_strcmp0 (_tmp66_, "rename_to") == 0) {
									ValaUnresolvedType* _tmp67_;
									gchar** _tmp68_;
									gint _tmp68__length1;
									const gchar* _tmp69_;
									gchar* _tmp70_ = NULL;
									gchar* _tmp71_;
									ValaUnresolvedSymbol* _tmp72_;
									ValaUnresolvedSymbol* _tmp73_;
									_tmp67_ = type;
									_tmp68_ = nv;
									_tmp68__length1 = nv_length1;
									_tmp69_ = _tmp68_[1];
									_tmp70_ = vala_gidl_parser_eval (self, _tmp69_);
									_tmp71_ = _tmp70_;
									_tmp72_ = vala_unresolved_symbol_new (NULL, _tmp71_, NULL);
									_tmp73_ = _tmp72_;
									vala_unresolved_type_set_unresolved_symbol (_tmp67_, _tmp73_);
									_vala_code_node_unref0 (_tmp73_);
									_g_free0 (_tmp71_);
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp74_ = type;
	_tmp75_ = vala_unresolved_type_get_unresolved_symbol (_tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp76_ != NULL) {
		ValaUnresolvedType* _tmp77_;
		ValaUnresolvedSymbol* _tmp78_;
		ValaUnresolvedSymbol* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		const gchar* _tmp86_;
		_tmp77_ = type;
		_tmp78_ = vala_unresolved_type_get_unresolved_symbol (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_symbol_get_name ((ValaSymbol*) _tmp79_);
		_tmp81_ = _tmp80_;
		if (g_strcmp0 (_tmp81_, "pointer") == 0) {
			ValaVoidType* _tmp82_;
			ValaVoidType* _tmp83_;
			ValaPointerType* _tmp84_;
			ValaDataType* _tmp85_;
			_tmp82_ = vala_void_type_new (NULL);
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_pointer_type_new ((ValaDataType*) _tmp83_, NULL);
			_tmp85_ = (ValaDataType*) _tmp84_;
			_vala_code_node_unref0 (_tmp83_);
			result = _tmp85_;
			_g_free0 (ns_name);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (dt);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp86_ = ns_name;
		if (_tmp86_ != NULL) {
			ValaUnresolvedType* _tmp87_;
			ValaUnresolvedSymbol* _tmp88_;
			ValaUnresolvedSymbol* _tmp89_;
			const gchar* _tmp90_;
			ValaUnresolvedSymbol* _tmp91_;
			ValaUnresolvedSymbol* _tmp92_;
			_tmp87_ = type;
			_tmp88_ = vala_unresolved_type_get_unresolved_symbol (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = ns_name;
			_tmp91_ = vala_unresolved_symbol_new (NULL, _tmp90_, NULL);
			_tmp92_ = _tmp91_;
			vala_unresolved_symbol_set_inner (_tmp89_, _tmp92_);
			_vala_code_node_unref0 (_tmp92_);
		}
		result = (ValaDataType*) type;
		_g_free0 (ns_name);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp93_ = n;
	_tmp94_ = self->priv->current_namespace;
	_tmp95_ = vala_symbol_get_name ((ValaSymbol*) _tmp94_);
	_tmp96_ = _tmp95_;
	_tmp97_ = g_str_has_prefix (_tmp93_, _tmp96_);
	if (_tmp97_) {
		ValaUnresolvedType* _tmp98_;
		ValaNamespace* _tmp99_;
		const gchar* _tmp100_;
		const gchar* _tmp101_;
		ValaUnresolvedSymbol* _tmp102_;
		ValaUnresolvedSymbol* _tmp103_;
		const gchar* _tmp104_;
		ValaNamespace* _tmp105_;
		const gchar* _tmp106_;
		const gchar* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_;
		ValaUnresolvedSymbol* _tmp112_;
		ValaUnresolvedSymbol* _tmp113_;
		_tmp98_ = type;
		_tmp99_ = self->priv->current_namespace;
		_tmp100_ = vala_symbol_get_name ((ValaSymbol*) _tmp99_);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_unresolved_symbol_new (NULL, _tmp101_, NULL);
		_tmp103_ = _tmp102_;
		_tmp104_ = n;
		_tmp105_ = self->priv->current_namespace;
		_tmp106_ = vala_symbol_get_name ((ValaSymbol*) _tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = strlen (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = string_substring (_tmp104_, (glong) _tmp109_, (glong) (-1));
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_unresolved_symbol_new (_tmp103_, _tmp111_, NULL);
		_tmp113_ = _tmp112_;
		vala_unresolved_type_set_unresolved_symbol (_tmp98_, _tmp113_);
		_vala_code_node_unref0 (_tmp113_);
		_g_free0 (_tmp111_);
		_vala_code_node_unref0 (_tmp103_);
	} else {
		gboolean _tmp114_ = FALSE;
		gboolean _tmp115_ = FALSE;
		ValaNamespace* _tmp116_;
		ValaSymbol* _tmp117_;
		ValaSymbol* _tmp118_;
		gboolean _tmp124_;
		gboolean _tmp132_;
		_tmp116_ = self->priv->current_namespace;
		_tmp117_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp116_);
		_tmp118_ = _tmp117_;
		if (_tmp118_ != NULL) {
			ValaNamespace* _tmp119_;
			ValaSymbol* _tmp120_;
			ValaSymbol* _tmp121_;
			const gchar* _tmp122_;
			const gchar* _tmp123_;
			_tmp119_ = self->priv->current_namespace;
			_tmp120_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp119_);
			_tmp121_ = _tmp120_;
			_tmp122_ = vala_symbol_get_name (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp115_ = _tmp123_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		_tmp124_ = _tmp115_;
		if (_tmp124_) {
			const gchar* _tmp125_;
			ValaNamespace* _tmp126_;
			ValaSymbol* _tmp127_;
			ValaSymbol* _tmp128_;
			const gchar* _tmp129_;
			const gchar* _tmp130_;
			gboolean _tmp131_ = FALSE;
			_tmp125_ = n;
			_tmp126_ = self->priv->current_namespace;
			_tmp127_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_symbol_get_name (_tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = g_str_has_prefix (_tmp125_, _tmp130_);
			_tmp114_ = _tmp131_;
		} else {
			_tmp114_ = FALSE;
		}
		_tmp132_ = _tmp114_;
		if (_tmp132_) {
			ValaUnresolvedType* _tmp133_;
			ValaNamespace* _tmp134_;
			ValaSymbol* _tmp135_;
			ValaSymbol* _tmp136_;
			const gchar* _tmp137_;
			const gchar* _tmp138_;
			ValaUnresolvedSymbol* _tmp139_;
			ValaUnresolvedSymbol* _tmp140_;
			const gchar* _tmp141_;
			ValaNamespace* _tmp142_;
			ValaSymbol* _tmp143_;
			ValaSymbol* _tmp144_;
			const gchar* _tmp145_;
			const gchar* _tmp146_;
			gint _tmp147_;
			gint _tmp148_;
			gchar* _tmp149_ = NULL;
			gchar* _tmp150_;
			ValaUnresolvedSymbol* _tmp151_;
			ValaUnresolvedSymbol* _tmp152_;
			_tmp133_ = type;
			_tmp134_ = self->priv->current_namespace;
			_tmp135_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_symbol_get_name (_tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_unresolved_symbol_new (NULL, _tmp138_, NULL);
			_tmp140_ = _tmp139_;
			_tmp141_ = n;
			_tmp142_ = self->priv->current_namespace;
			_tmp143_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_symbol_get_name (_tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = strlen (_tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = string_substring (_tmp141_, (glong) _tmp148_, (glong) (-1));
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_unresolved_symbol_new (_tmp140_, _tmp150_, NULL);
			_tmp152_ = _tmp151_;
			vala_unresolved_type_set_unresolved_symbol (_tmp133_, _tmp152_);
			_vala_code_node_unref0 (_tmp152_);
			_g_free0 (_tmp150_);
			_vala_code_node_unref0 (_tmp140_);
		} else {
			const gchar* _tmp153_;
			gboolean _tmp154_ = FALSE;
			_tmp153_ = n;
			_tmp154_ = g_str_has_prefix (_tmp153_, "G");
			if (_tmp154_) {
				ValaUnresolvedType* _tmp155_;
				ValaUnresolvedSymbol* _tmp156_;
				ValaUnresolvedSymbol* _tmp157_;
				const gchar* _tmp158_;
				gchar* _tmp159_ = NULL;
				gchar* _tmp160_;
				ValaUnresolvedSymbol* _tmp161_;
				ValaUnresolvedSymbol* _tmp162_;
				_tmp155_ = type;
				_tmp156_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
				_tmp157_ = _tmp156_;
				_tmp158_ = n;
				_tmp159_ = string_substring (_tmp158_, (glong) 1, (glong) (-1));
				_tmp160_ = _tmp159_;
				_tmp161_ = vala_unresolved_symbol_new (_tmp157_, _tmp160_, NULL);
				_tmp162_ = _tmp161_;
				vala_unresolved_type_set_unresolved_symbol (_tmp155_, _tmp162_);
				_vala_code_node_unref0 (_tmp162_);
				_g_free0 (_tmp160_);
				_vala_code_node_unref0 (_tmp157_);
			} else {
				const gchar* _tmp163_;
				gchar** _tmp164_;
				gchar** _tmp165_ = NULL;
				gchar** name_parts;
				gint name_parts_length1;
				gint _name_parts_size_;
				gchar** _tmp166_;
				gint _tmp166__length1;
				const gchar* _tmp167_;
				_tmp163_ = n;
				_tmp165_ = _tmp164_ = g_strsplit (_tmp163_, ".", 2);
				name_parts = _tmp165_;
				name_parts_length1 = _vala_array_length (_tmp164_);
				_name_parts_size_ = name_parts_length1;
				_tmp166_ = name_parts;
				_tmp166__length1 = name_parts_length1;
				_tmp167_ = _tmp166_[1];
				if (_tmp167_ == NULL) {
					ValaUnresolvedType* _tmp168_;
					gchar** _tmp169_;
					gint _tmp169__length1;
					const gchar* _tmp170_;
					ValaUnresolvedSymbol* _tmp171_;
					ValaUnresolvedSymbol* _tmp172_;
					_tmp168_ = type;
					_tmp169_ = name_parts;
					_tmp169__length1 = name_parts_length1;
					_tmp170_ = _tmp169_[0];
					_tmp171_ = vala_unresolved_symbol_new (NULL, _tmp170_, NULL);
					_tmp172_ = _tmp171_;
					vala_unresolved_type_set_unresolved_symbol (_tmp168_, _tmp172_);
					_vala_code_node_unref0 (_tmp172_);
				} else {
					ValaUnresolvedType* _tmp173_;
					gchar** _tmp174_;
					gint _tmp174__length1;
					const gchar* _tmp175_;
					ValaUnresolvedSymbol* _tmp176_;
					ValaUnresolvedSymbol* _tmp177_;
					gchar** _tmp178_;
					gint _tmp178__length1;
					const gchar* _tmp179_;
					ValaUnresolvedSymbol* _tmp180_;
					ValaUnresolvedSymbol* _tmp181_;
					_tmp173_ = type;
					_tmp174_ = name_parts;
					_tmp174__length1 = name_parts_length1;
					_tmp175_ = _tmp174_[0];
					_tmp176_ = vala_unresolved_symbol_new (NULL, _tmp175_, NULL);
					_tmp177_ = _tmp176_;
					_tmp178_ = name_parts;
					_tmp178__length1 = name_parts_length1;
					_tmp179_ = _tmp178_[1];
					_tmp180_ = vala_unresolved_symbol_new (_tmp177_, _tmp179_, NULL);
					_tmp181_ = _tmp180_;
					vala_unresolved_type_set_unresolved_symbol (_tmp173_, _tmp181_);
					_vala_code_node_unref0 (_tmp181_);
					_vala_code_node_unref0 (_tmp177_);
				}
				name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = (ValaDataType*) type;
	_g_free0 (ns_name);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (dt);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction) {
	ValaParameterDirection _vala_direction = 0;
	ValaDataType* result = NULL;
	GIdlNodeParam* _tmp0_;
	GIdlNodeType* _tmp1_;
	ValaParameterDirection _tmp2_ = 0;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp0_ = param;
	_tmp1_ = _tmp0_->type;
	_tmp3_ = vala_gidl_parser_parse_type (self, _tmp1_, &_tmp2_);
	_vala_direction = _tmp2_;
	type = _tmp3_;
	result = type;
	if (direction) {
		*direction = _vala_direction;
	}
	return result;
}


static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self, const gchar* symbol_string, ValaSourceReference* source_reference) {
	ValaUnresolvedSymbol* result = NULL;
	ValaUnresolvedSymbol* sym;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	ValaUnresolvedSymbol* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp0_ = symbol_string;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp2_;
		s_collection_length1 = _vala_array_length (_tmp1_);
		for (s_it = 0; s_it < _vala_array_length (_tmp1_); s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp3_;
				const gchar* _tmp4_;
				ValaSourceReference* _tmp5_;
				ValaUnresolvedSymbol* _tmp6_;
				_tmp3_ = sym;
				_tmp4_ = s;
				_tmp5_ = source_reference;
				_tmp6_ = vala_unresolved_symbol_new (_tmp3_, _tmp4_, _tmp5_);
				_vala_code_node_unref0 (sym);
				sym = _tmp6_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp7_ = sym;
	if (_tmp7_ == NULL) {
		ValaSourceReference* _tmp8_;
		_tmp8_ = source_reference;
		vala_report_error (_tmp8_, "a symbol must be specified");
	}
	result = sym;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self, ValaDataType* parent_type, const gchar* type_arguments, ValaSourceReference* source_reference) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint type_arguments_length;
	gint _tmp3_;
	GString* _tmp4_;
	GString* current;
	gint depth;
	GString* _tmp56_;
	const gchar* _tmp57_;
	ValaSourceReference* _tmp58_;
	ValaDataType* _tmp59_ = NULL;
	ValaDataType* dt;
	ValaDataType* _tmp60_;
	ValaDataType* _tmp61_;
	ValaDataType* _tmp62_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = type_arguments;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	type_arguments_length = (gint) _tmp2_;
	_tmp3_ = type_arguments_length;
	_tmp4_ = g_string_sized_new ((gsize) _tmp3_);
	current = _tmp4_;
	depth = 0;
	{
		gint c;
		c = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				gint _tmp9_;
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_;
				gint _tmp12_;
				gchar _tmp13_ = '\0';
				gboolean _tmp17_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = c;
					c = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = c;
				_tmp9_ = type_arguments_length;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp11_ = type_arguments;
				_tmp12_ = c;
				_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
				if (_tmp13_ == '<') {
					_tmp10_ = TRUE;
				} else {
					const gchar* _tmp14_;
					gint _tmp15_;
					gchar _tmp16_ = '\0';
					_tmp14_ = type_arguments;
					_tmp15_ = c;
					_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
					_tmp10_ = _tmp16_ == '[';
				}
				_tmp17_ = _tmp10_;
				if (_tmp17_) {
					gint _tmp18_;
					GString* _tmp19_;
					const gchar* _tmp20_;
					gint _tmp21_;
					gchar _tmp22_ = '\0';
					_tmp18_ = depth;
					depth = _tmp18_ + 1;
					_tmp19_ = current;
					_tmp20_ = type_arguments;
					_tmp21_ = c;
					_tmp22_ = string_get (_tmp20_, (glong) _tmp21_);
					g_string_append_unichar (_tmp19_, (gunichar) _tmp22_);
				} else {
					gboolean _tmp23_ = FALSE;
					const gchar* _tmp24_;
					gint _tmp25_;
					gchar _tmp26_ = '\0';
					gboolean _tmp30_;
					_tmp24_ = type_arguments;
					_tmp25_ = c;
					_tmp26_ = string_get (_tmp24_, (glong) _tmp25_);
					if (_tmp26_ == '>') {
						_tmp23_ = TRUE;
					} else {
						const gchar* _tmp27_;
						gint _tmp28_;
						gchar _tmp29_ = '\0';
						_tmp27_ = type_arguments;
						_tmp28_ = c;
						_tmp29_ = string_get (_tmp27_, (glong) _tmp28_);
						_tmp23_ = _tmp29_ == ']';
					}
					_tmp30_ = _tmp23_;
					if (_tmp30_) {
						gint _tmp31_;
						GString* _tmp32_;
						const gchar* _tmp33_;
						gint _tmp34_;
						gchar _tmp35_ = '\0';
						_tmp31_ = depth;
						depth = _tmp31_ - 1;
						_tmp32_ = current;
						_tmp33_ = type_arguments;
						_tmp34_ = c;
						_tmp35_ = string_get (_tmp33_, (glong) _tmp34_);
						g_string_append_unichar (_tmp32_, (gunichar) _tmp35_);
					} else {
						const gchar* _tmp36_;
						gint _tmp37_;
						gchar _tmp38_ = '\0';
						_tmp36_ = type_arguments;
						_tmp37_ = c;
						_tmp38_ = string_get (_tmp36_, (glong) _tmp37_);
						if (_tmp38_ == ',') {
							gint _tmp39_;
							_tmp39_ = depth;
							if (_tmp39_ == 0) {
								GString* _tmp40_;
								const gchar* _tmp41_;
								ValaSourceReference* _tmp42_;
								ValaDataType* _tmp43_ = NULL;
								ValaDataType* dt;
								ValaDataType* _tmp44_;
								ValaDataType* _tmp45_;
								ValaDataType* _tmp46_;
								GString* _tmp47_;
								_tmp40_ = current;
								_tmp41_ = _tmp40_->str;
								_tmp42_ = source_reference;
								_tmp43_ = vala_gidl_parser_parse_type_from_string (self, _tmp41_, TRUE, _tmp42_);
								dt = _tmp43_;
								_tmp44_ = dt;
								if (_tmp44_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp45_ = parent_type;
								_tmp46_ = dt;
								vala_data_type_add_type_argument (_tmp45_, _tmp46_);
								_tmp47_ = current;
								g_string_truncate (_tmp47_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp48_;
								const gchar* _tmp49_;
								gint _tmp50_;
								gchar _tmp51_ = '\0';
								_tmp48_ = current;
								_tmp49_ = type_arguments;
								_tmp50_ = c;
								_tmp51_ = string_get (_tmp49_, (glong) _tmp50_);
								g_string_append_unichar (_tmp48_, (gunichar) _tmp51_);
							}
						} else {
							GString* _tmp52_;
							const gchar* _tmp53_;
							gint _tmp54_;
							gchar _tmp55_ = '\0';
							_tmp52_ = current;
							_tmp53_ = type_arguments;
							_tmp54_ = c;
							_tmp55_ = string_get (_tmp53_, (glong) _tmp54_);
							g_string_append_unichar (_tmp52_, (gunichar) _tmp55_);
						}
					}
				}
			}
		}
	}
	_tmp56_ = current;
	_tmp57_ = _tmp56_->str;
	_tmp58_ = source_reference;
	_tmp59_ = vala_gidl_parser_parse_type_from_string (self, _tmp57_, TRUE, _tmp58_);
	dt = _tmp59_;
	_tmp60_ = dt;
	if (_tmp60_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp61_ = parent_type;
	_tmp62_ = dt;
	vala_data_type_add_type_argument (_tmp61_, _tmp62_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self, const gchar* type_string, gboolean owned_by_default, ValaSourceReference* source_reference) {
	ValaDataType* result = NULL;
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	ValaDataType* type;
	GMatchInfo* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* ownership_data;
	GMatchInfo* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* type_name;
	GMatchInfo* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* type_arguments_data;
	GMatchInfo* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* pointers_data;
	GMatchInfo* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* array_data;
	GMatchInfo* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* array_dimension_data;
	GMatchInfo* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* nullable_data;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_;
	gboolean _tmp28_;
	gboolean nullable;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	gboolean _tmp32_;
	gboolean _tmp50_;
	gboolean value_owned;
	const gchar* _tmp51_;
	const gchar* _tmp53_;
	ValaSourceReference* _tmp54_;
	ValaUnresolvedSymbol* _tmp55_ = NULL;
	ValaUnresolvedSymbol* sym;
	ValaUnresolvedSymbol* _tmp56_;
	ValaUnresolvedSymbol* _tmp57_;
	ValaSourceReference* _tmp58_;
	ValaUnresolvedType* _tmp59_;
	gboolean _tmp60_ = FALSE;
	const gchar* _tmp61_;
	gboolean _tmp65_;
	const gchar* _tmp70_;
	gboolean _tmp80_ = FALSE;
	const gchar* _tmp81_;
	gboolean _tmp85_;
	ValaDataType* _tmp92_;
	gboolean _tmp93_;
	ValaDataType* _tmp94_;
	gboolean _tmp95_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gidl_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_;
			GRegex* _tmp2_;
			_tmp1_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[(," \
"*)?\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch2_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_regex_unref0 (vala_gidl_parser_type_from_string_regex);
			vala_gidl_parser_type_from_string_regex = _tmp2_;
		}
		goto __finally2;
		__catch2_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp3_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = e->message;
			g_error ("valagidlparser.vala:2097: Unable to compile regex: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = vala_gidl_parser_type_from_string_regex;
	_tmp5_ = type_string;
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
	_g_match_info_free0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		ValaSourceReference* _tmp8_;
		_tmp8_ = source_reference;
		vala_report_error (_tmp8_, "unable to parse type");
		result = NULL;
		_g_match_info_free0 (match);
		return result;
	}
	type = NULL;
	_tmp9_ = match;
	_tmp10_ = g_match_info_fetch (_tmp9_, 1);
	ownership_data = _tmp10_;
	_tmp11_ = match;
	_tmp12_ = g_match_info_fetch (_tmp11_, 2);
	type_name = _tmp12_;
	_tmp13_ = match;
	_tmp14_ = g_match_info_fetch (_tmp13_, 3);
	type_arguments_data = _tmp14_;
	_tmp15_ = match;
	_tmp16_ = g_match_info_fetch (_tmp15_, 4);
	pointers_data = _tmp16_;
	_tmp17_ = match;
	_tmp18_ = g_match_info_fetch (_tmp17_, 5);
	array_data = _tmp18_;
	_tmp19_ = match;
	_tmp20_ = g_match_info_fetch (_tmp19_, 6);
	array_dimension_data = _tmp20_;
	_tmp21_ = match;
	_tmp22_ = g_match_info_fetch (_tmp21_, 7);
	nullable_data = _tmp22_;
	_tmp24_ = nullable_data;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp25_ = nullable_data;
		_tmp26_ = strlen (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp23_ = _tmp27_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp28_ = _tmp23_;
	nullable = _tmp28_;
	_tmp30_ = ownership_data;
	if (_tmp30_ == NULL) {
		const gchar* _tmp31_;
		_tmp31_ = type_name;
		_tmp29_ = g_strcmp0 (_tmp31_, "void") == 0;
	} else {
		_tmp29_ = FALSE;
	}
	_tmp32_ = _tmp29_;
	if (_tmp32_) {
		gboolean _tmp33_ = FALSE;
		const gchar* _tmp34_;
		gboolean _tmp36_;
		_tmp34_ = array_data;
		if (_tmp34_ == NULL) {
			gboolean _tmp35_;
			_tmp35_ = nullable;
			_tmp33_ = !_tmp35_;
		} else {
			_tmp33_ = FALSE;
		}
		_tmp36_ = _tmp33_;
		if (_tmp36_) {
			ValaSourceReference* _tmp37_;
			ValaVoidType* _tmp38_;
			const gchar* _tmp39_;
			_tmp37_ = source_reference;
			_tmp38_ = vala_void_type_new (_tmp37_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp38_;
			_tmp39_ = pointers_data;
			if (_tmp39_ != NULL) {
				{
					gint i;
					i = 0;
					{
						gboolean _tmp40_;
						_tmp40_ = TRUE;
						while (TRUE) {
							gboolean _tmp41_;
							gint _tmp43_;
							const gchar* _tmp44_;
							gint _tmp45_;
							gint _tmp46_;
							ValaDataType* _tmp47_;
							ValaPointerType* _tmp48_;
							_tmp41_ = _tmp40_;
							if (!_tmp41_) {
								gint _tmp42_;
								_tmp42_ = i;
								i = _tmp42_ + 1;
							}
							_tmp40_ = FALSE;
							_tmp43_ = i;
							_tmp44_ = pointers_data;
							_tmp45_ = strlen (_tmp44_);
							_tmp46_ = _tmp45_;
							if (!(_tmp43_ < _tmp46_)) {
								break;
							}
							_tmp47_ = type;
							_tmp48_ = vala_pointer_type_new (_tmp47_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp48_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_free0 (match);
			return result;
		} else {
			ValaSourceReference* _tmp49_;
			_tmp49_ = source_reference;
			vala_report_error (_tmp49_, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_free0 (match);
			return result;
		}
	}
	_tmp50_ = owned_by_default;
	value_owned = _tmp50_;
	_tmp51_ = ownership_data;
	if (g_strcmp0 (_tmp51_, "owned") == 0) {
		value_owned = TRUE;
	} else {
		const gchar* _tmp52_;
		_tmp52_ = ownership_data;
		if (g_strcmp0 (_tmp52_, "unowned") == 0) {
			value_owned = FALSE;
		}
	}
	_tmp53_ = type_name;
	_tmp54_ = source_reference;
	_tmp55_ = vala_gidl_parser_parse_symbol_from_string (self, _tmp53_, _tmp54_);
	sym = _tmp55_;
	_tmp56_ = sym;
	if (_tmp56_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_dimension_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_free0 (match);
		return result;
	}
	_tmp57_ = sym;
	_tmp58_ = source_reference;
	_tmp59_ = vala_unresolved_type_new_from_symbol (_tmp57_, _tmp58_);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp59_;
	_tmp61_ = type_arguments_data;
	if (_tmp61_ != NULL) {
		const gchar* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		_tmp62_ = type_arguments_data;
		_tmp63_ = strlen (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp60_ = _tmp64_ > 0;
	} else {
		_tmp60_ = FALSE;
	}
	_tmp65_ = _tmp60_;
	if (_tmp65_) {
		ValaDataType* _tmp66_;
		const gchar* _tmp67_;
		ValaSourceReference* _tmp68_;
		gboolean _tmp69_ = FALSE;
		_tmp66_ = type;
		_tmp67_ = type_arguments_data;
		_tmp68_ = source_reference;
		_tmp69_ = vala_gidl_parser_parse_type_arguments_from_string (self, _tmp66_, _tmp67_, _tmp68_);
		if (!_tmp69_) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_free0 (match);
			return result;
		}
	}
	_tmp70_ = pointers_data;
	if (_tmp70_ != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp71_;
				_tmp71_ = TRUE;
				while (TRUE) {
					gboolean _tmp72_;
					gint _tmp74_;
					const gchar* _tmp75_;
					gint _tmp76_;
					gint _tmp77_;
					ValaDataType* _tmp78_;
					ValaPointerType* _tmp79_;
					_tmp72_ = _tmp71_;
					if (!_tmp72_) {
						gint _tmp73_;
						_tmp73_ = i;
						i = _tmp73_ + 1;
					}
					_tmp71_ = FALSE;
					_tmp74_ = i;
					_tmp75_ = pointers_data;
					_tmp76_ = strlen (_tmp75_);
					_tmp77_ = _tmp76_;
					if (!(_tmp74_ < _tmp77_)) {
						break;
					}
					_tmp78_ = type;
					_tmp79_ = vala_pointer_type_new (_tmp78_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp79_;
				}
			}
		}
	}
	_tmp81_ = array_data;
	if (_tmp81_ != NULL) {
		const gchar* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		_tmp82_ = array_data;
		_tmp83_ = strlen (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp80_ = _tmp84_ > 0;
	} else {
		_tmp80_ = FALSE;
	}
	_tmp85_ = _tmp80_;
	if (_tmp85_) {
		ValaDataType* _tmp86_;
		const gchar* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		ValaSourceReference* _tmp90_;
		ValaArrayType* _tmp91_;
		_tmp86_ = type;
		_tmp87_ = array_dimension_data;
		_tmp88_ = strlen (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = source_reference;
		_tmp91_ = vala_array_type_new (_tmp86_, _tmp89_ + 1, _tmp90_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp91_;
	}
	_tmp92_ = type;
	_tmp93_ = nullable;
	vala_data_type_set_nullable (_tmp92_, _tmp93_);
	_tmp94_ = type;
	_tmp95_ = value_owned;
	vala_data_type_set_value_owned (_tmp94_, _tmp95_);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_dimension_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_free0 (match);
	return result;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean double_try_parse (const gchar* str, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtod (_tmp0_, &_tmp1_);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface) {
	ValaMethod* result = NULL;
	ValaDataType* return_type;
	GIdlNodeParam* _tmp0_;
	ValaMethod* m = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp10_;
	ValaMethod* _tmp52_;
	ValaSet* _tmp53_;
	ValaTypeSymbol* _tmp56_;
	gboolean add_ellipsis;
	gboolean suppress_throws;
	gchar* error_types;
	ValaSymbol* container;
	const gchar* _tmp80_;
	gint _tmp81_ = 0;
	gchar** _tmp82_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	gboolean first;
	ValaParameter* last_param;
	ValaDataType* last_param_type;
	GList* _tmp344_;
	gboolean _tmp769_ = FALSE;
	gboolean _tmp770_;
	gboolean _tmp772_;
	gboolean _tmp785_;
	gboolean _tmp787_ = FALSE;
	ValaParameter* _tmp788_;
	gboolean _tmp793_;
	ValaSymbol* _tmp799_;
	const gchar* _tmp805_;
	ValaMethod* _tmp806_;
	ValaSymbol* _tmp807_;
	gchar* _tmp808_ = NULL;
	gchar* _tmp809_;
	gboolean _tmp810_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	_tmp0_ = res;
	if (_tmp0_ != NULL) {
		GIdlNodeParam* _tmp1_;
		ValaDataType* _tmp2_ = NULL;
		_tmp1_ = res;
		_tmp2_ = vala_gidl_parser_parse_param (self, _tmp1_, NULL);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp2_;
	}
	_tmp4_ = is_interface;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp9_;
		_tmp6_ = is_constructor;
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			_tmp7_ = name;
			_tmp8_ = g_str_has_prefix (_tmp7_, "new");
			_tmp5_ = _tmp8_;
		}
		_tmp9_ = _tmp5_;
		_tmp3_ = _tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = _tmp3_;
	if (_tmp10_) {
		const gchar* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaCreationMethod* _tmp13_;
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gboolean _tmp31_ = FALSE;
		ValaTypeSymbol* _tmp32_;
		gboolean _tmp34_;
		_tmp11_ = name;
		_tmp12_ = self->priv->current_source_reference;
		_tmp13_ = vala_creation_method_new (NULL, _tmp11_, _tmp12_, NULL);
		_vala_code_node_unref0 (m);
		m = (ValaMethod*) _tmp13_;
		_tmp14_ = m;
		vala_method_set_has_construct_function (_tmp14_, FALSE);
		_tmp15_ = m;
		_tmp16_ = vala_symbol_get_name ((ValaSymbol*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (g_strcmp0 (_tmp17_, "new") == 0) {
			ValaMethod* _tmp18_;
			_tmp18_ = m;
			vala_symbol_set_name ((ValaSymbol*) _tmp18_, NULL);
		} else {
			ValaMethod* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp19_ = m;
			_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_str_has_prefix (_tmp21_, "new_");
			if (_tmp22_) {
				ValaMethod* _tmp23_;
				ValaMethod* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				_tmp23_ = m;
				_tmp24_ = m;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = strlen ("new_");
				_tmp28_ = _tmp27_;
				_tmp29_ = string_substring (_tmp26_, (glong) _tmp28_, (glong) (-1));
				_tmp30_ = _tmp29_;
				vala_symbol_set_name ((ValaSymbol*) _tmp23_, _tmp30_);
				_g_free0 (_tmp30_);
			}
		}
		_tmp32_ = self->priv->current_data_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, VALA_TYPE_CLASS)) {
			GIdlNodeParam* _tmp33_;
			_tmp33_ = res;
			_tmp31_ = _tmp33_ != NULL;
		} else {
			_tmp31_ = FALSE;
		}
		_tmp34_ = _tmp31_;
		if (_tmp34_) {
			ValaTypeSymbol* _tmp35_;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			GIdlNodeParam* _tmp40_;
			GIdlNodeType* _tmp41_;
			const gchar* _tmp42_;
			gboolean _tmp43_;
			_tmp35_ = self->priv->current_data_type;
			_tmp36_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strdup_printf ("%s*", _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = res;
			_tmp41_ = _tmp40_->type;
			_tmp42_ = _tmp41_->unparsed;
			_tmp43_ = g_strcmp0 (_tmp39_, _tmp42_) != 0;
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			if (_tmp43_) {
				ValaMethod* _tmp44_;
				GIdlNodeParam* _tmp45_;
				GIdlNodeType* _tmp46_;
				const gchar* _tmp47_;
				_tmp44_ = m;
				_tmp45_ = res;
				_tmp46_ = _tmp45_->type;
				_tmp47_ = _tmp46_->unparsed;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp44_, "CCode", "type", _tmp47_, NULL);
			}
		}
	} else {
		const gchar* _tmp48_;
		ValaDataType* _tmp49_;
		ValaSourceReference* _tmp50_;
		ValaMethod* _tmp51_;
		_tmp48_ = name;
		_tmp49_ = return_type;
		_tmp50_ = self->priv->current_source_reference;
		_tmp51_ = vala_method_new (_tmp48_, _tmp49_, _tmp50_, NULL);
		_vala_code_node_unref0 (m);
		m = _tmp51_;
	}
	_tmp52_ = m;
	vala_symbol_set_access ((ValaSymbol*) _tmp52_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp53_ = self->priv->current_type_symbol_set;
	if (_tmp53_ != NULL) {
		ValaSet* _tmp54_;
		const gchar* _tmp55_;
		_tmp54_ = self->priv->current_type_symbol_set;
		_tmp55_ = name;
		vala_collection_add ((ValaCollection*) _tmp54_, _tmp55_);
	}
	_tmp56_ = self->priv->current_data_type;
	if (_tmp56_ != NULL) {
		ValaTypeSymbol* _tmp57_;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_;
		gint _tmp63_ = 0;
		gchar** _tmp64_ = NULL;
		gchar** _tmp65_;
		gint _tmp65__length1;
		gchar** sig_attributes;
		gint sig_attributes_length1;
		gint _sig_attributes_size_;
		gchar** _tmp66_;
		gint _tmp66__length1;
		_tmp57_ = self->priv->current_data_type;
		_tmp58_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp57_, NULL);
		_tmp59_ = _tmp58_;
		_tmp60_ = name;
		_tmp61_ = g_strdup_printf ("%s::%s", _tmp59_, _tmp60_);
		_tmp62_ = _tmp61_;
		_tmp64_ = vala_gidl_parser_get_attributes (self, _tmp62_, &_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp65__length1 = _tmp63_;
		_g_free0 (_tmp62_);
		_g_free0 (_tmp59_);
		sig_attributes = _tmp65_;
		sig_attributes_length1 = _tmp65__length1;
		_sig_attributes_size_ = sig_attributes_length1;
		_tmp66_ = sig_attributes;
		_tmp66__length1 = sig_attributes_length1;
		if (_tmp66_ != NULL) {
			gchar** _tmp67_;
			gint _tmp67__length1;
			_tmp67_ = sig_attributes;
			_tmp67__length1 = sig_attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp67_;
				attr_collection_length1 = _tmp67__length1;
				for (attr_it = 0; attr_it < _tmp67__length1; attr_it = attr_it + 1) {
					gchar* _tmp68_;
					gchar* attr = NULL;
					_tmp68_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp68_;
					{
						const gchar* _tmp69_;
						gchar** _tmp70_;
						gchar** _tmp71_ = NULL;
						gchar** nv;
						gint nv_length1;
						gint _nv_size_;
						gboolean _tmp72_ = FALSE;
						gchar** _tmp73_;
						gint _tmp73__length1;
						const gchar* _tmp74_;
						gboolean _tmp79_;
						_tmp69_ = attr;
						_tmp71_ = _tmp70_ = g_strsplit (_tmp69_, "=", 2);
						nv = _tmp71_;
						nv_length1 = _vala_array_length (_tmp70_);
						_nv_size_ = nv_length1;
						_tmp73_ = nv;
						_tmp73__length1 = nv_length1;
						_tmp74_ = _tmp73_[0];
						if (g_strcmp0 (_tmp74_, "has_emitter") == 0) {
							gchar** _tmp75_;
							gint _tmp75__length1;
							const gchar* _tmp76_;
							gchar* _tmp77_ = NULL;
							gchar* _tmp78_;
							_tmp75_ = nv;
							_tmp75__length1 = nv_length1;
							_tmp76_ = _tmp75_[1];
							_tmp77_ = vala_gidl_parser_eval (self, _tmp76_);
							_tmp78_ = _tmp77_;
							_tmp72_ = g_strcmp0 (_tmp78_, "1") == 0;
							_g_free0 (_tmp78_);
						} else {
							_tmp72_ = FALSE;
						}
						_tmp79_ = _tmp72_;
						if (_tmp79_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (return_type);
							return result;
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	error_types = NULL;
	container = NULL;
	_tmp80_ = symbol;
	_tmp82_ = vala_gidl_parser_get_attributes (self, _tmp80_, &_tmp81_);
	attributes = _tmp82_;
	attributes_length1 = _tmp81_;
	_attributes_size_ = attributes_length1;
	_tmp83_ = attributes;
	_tmp83__length1 = attributes_length1;
	if (_tmp83_ != NULL) {
		gchar** _tmp84_;
		gint _tmp84__length1;
		_tmp84_ = attributes;
		_tmp84__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp84_;
			attr_collection_length1 = _tmp84__length1;
			for (attr_it = 0; attr_it < _tmp84__length1; attr_it = attr_it + 1) {
				gchar* _tmp85_;
				gchar* attr = NULL;
				_tmp85_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp85_;
				{
					const gchar* _tmp86_;
					gchar** _tmp87_;
					gchar** _tmp88_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp89_;
					gint _tmp89__length1;
					const gchar* _tmp90_;
					_tmp86_ = attr;
					_tmp88_ = _tmp87_ = g_strsplit (_tmp86_, "=", 2);
					nv = _tmp88_;
					nv_length1 = _vala_array_length (_tmp87_);
					_nv_size_ = nv_length1;
					_tmp89_ = nv;
					_tmp89__length1 = nv_length1;
					_tmp90_ = _tmp89_[0];
					if (g_strcmp0 (_tmp90_, "name") == 0) {
						ValaMethod* _tmp91_;
						gchar** _tmp92_;
						gint _tmp92__length1;
						const gchar* _tmp93_;
						gchar* _tmp94_ = NULL;
						gchar* _tmp95_;
						_tmp91_ = m;
						_tmp92_ = nv;
						_tmp92__length1 = nv_length1;
						_tmp93_ = _tmp92_[1];
						_tmp94_ = vala_gidl_parser_eval (self, _tmp93_);
						_tmp95_ = _tmp94_;
						vala_symbol_set_name ((ValaSymbol*) _tmp91_, _tmp95_);
						_g_free0 (_tmp95_);
					} else {
						gchar** _tmp96_;
						gint _tmp96__length1;
						const gchar* _tmp97_;
						_tmp96_ = nv;
						_tmp96__length1 = nv_length1;
						_tmp97_ = _tmp96_[0];
						if (g_strcmp0 (_tmp97_, "hidden") == 0) {
							gchar** _tmp98_;
							gint _tmp98__length1;
							const gchar* _tmp99_;
							gchar* _tmp100_ = NULL;
							gchar* _tmp101_;
							gboolean _tmp102_;
							_tmp98_ = nv;
							_tmp98__length1 = nv_length1;
							_tmp99_ = _tmp98_[1];
							_tmp100_ = vala_gidl_parser_eval (self, _tmp99_);
							_tmp101_ = _tmp100_;
							_tmp102_ = g_strcmp0 (_tmp101_, "1") == 0;
							_g_free0 (_tmp101_);
							if (_tmp102_) {
								result = NULL;
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (container);
								_g_free0 (error_types);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (return_type);
								return result;
							}
						} else {
							gchar** _tmp103_;
							gint _tmp103__length1;
							const gchar* _tmp104_;
							_tmp103_ = nv;
							_tmp103__length1 = nv_length1;
							_tmp104_ = _tmp103_[0];
							if (g_strcmp0 (_tmp104_, "ellipsis") == 0) {
								gchar** _tmp105_;
								gint _tmp105__length1;
								const gchar* _tmp106_;
								gchar* _tmp107_ = NULL;
								gchar* _tmp108_;
								gboolean _tmp109_;
								_tmp105_ = nv;
								_tmp105__length1 = nv_length1;
								_tmp106_ = _tmp105_[1];
								_tmp107_ = vala_gidl_parser_eval (self, _tmp106_);
								_tmp108_ = _tmp107_;
								_tmp109_ = g_strcmp0 (_tmp108_, "1") == 0;
								_g_free0 (_tmp108_);
								if (_tmp109_) {
									add_ellipsis = TRUE;
								}
							} else {
								gchar** _tmp110_;
								gint _tmp110__length1;
								const gchar* _tmp111_;
								_tmp110_ = nv;
								_tmp110__length1 = nv_length1;
								_tmp111_ = _tmp110_[0];
								if (g_strcmp0 (_tmp111_, "printf_format") == 0) {
									gchar** _tmp112_;
									gint _tmp112__length1;
									const gchar* _tmp113_;
									gchar* _tmp114_ = NULL;
									gchar* _tmp115_;
									gboolean _tmp116_;
									_tmp112_ = nv;
									_tmp112__length1 = nv_length1;
									_tmp113_ = _tmp112_[1];
									_tmp114_ = vala_gidl_parser_eval (self, _tmp113_);
									_tmp115_ = _tmp114_;
									_tmp116_ = g_strcmp0 (_tmp115_, "1") == 0;
									_g_free0 (_tmp115_);
									if (_tmp116_) {
										ValaMethod* _tmp117_;
										_tmp117_ = m;
										vala_code_node_set_attribute ((ValaCodeNode*) _tmp117_, "PrintfFormat", TRUE, NULL);
									}
								} else {
									gchar** _tmp118_;
									gint _tmp118__length1;
									const gchar* _tmp119_;
									_tmp118_ = nv;
									_tmp118__length1 = nv_length1;
									_tmp119_ = _tmp118_[0];
									if (g_strcmp0 (_tmp119_, "transfer_ownership") == 0) {
										gchar** _tmp120_;
										gint _tmp120__length1;
										const gchar* _tmp121_;
										gchar* _tmp122_ = NULL;
										gchar* _tmp123_;
										gboolean _tmp124_;
										_tmp120_ = nv;
										_tmp120__length1 = nv_length1;
										_tmp121_ = _tmp120_[1];
										_tmp122_ = vala_gidl_parser_eval (self, _tmp121_);
										_tmp123_ = _tmp122_;
										_tmp124_ = g_strcmp0 (_tmp123_, "1") == 0;
										_g_free0 (_tmp123_);
										if (_tmp124_) {
											ValaDataType* _tmp125_;
											_tmp125_ = return_type;
											vala_data_type_set_value_owned (_tmp125_, TRUE);
										}
									} else {
										gchar** _tmp126_;
										gint _tmp126__length1;
										const gchar* _tmp127_;
										_tmp126_ = nv;
										_tmp126__length1 = nv_length1;
										_tmp127_ = _tmp126_[0];
										if (g_strcmp0 (_tmp127_, "destroys_instance") == 0) {
											gchar** _tmp128_;
											gint _tmp128__length1;
											const gchar* _tmp129_;
											gchar* _tmp130_ = NULL;
											gchar* _tmp131_;
											gboolean _tmp132_;
											_tmp128_ = nv;
											_tmp128__length1 = nv_length1;
											_tmp129_ = _tmp128_[1];
											_tmp130_ = vala_gidl_parser_eval (self, _tmp129_);
											_tmp131_ = _tmp130_;
											_tmp132_ = g_strcmp0 (_tmp131_, "1") == 0;
											_g_free0 (_tmp131_);
											if (_tmp132_) {
												ValaMethod* _tmp133_;
												ValaMethod* _tmp134_;
												ValaSourceReference* _tmp135_;
												ValaSourceReference* _tmp136_;
												_tmp133_ = m;
												_tmp134_ = m;
												_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp134_);
												_tmp136_ = _tmp135_;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp133_, "DestroysInstance", TRUE, _tmp136_);
											}
										} else {
											gchar** _tmp137_;
											gint _tmp137__length1;
											const gchar* _tmp138_;
											_tmp137_ = nv;
											_tmp137__length1 = nv_length1;
											_tmp138_ = _tmp137_[0];
											if (g_strcmp0 (_tmp138_, "nullable") == 0) {
												gchar** _tmp139_;
												gint _tmp139__length1;
												const gchar* _tmp140_;
												gchar* _tmp141_ = NULL;
												gchar* _tmp142_;
												gboolean _tmp143_;
												_tmp139_ = nv;
												_tmp139__length1 = nv_length1;
												_tmp140_ = _tmp139_[1];
												_tmp141_ = vala_gidl_parser_eval (self, _tmp140_);
												_tmp142_ = _tmp141_;
												_tmp143_ = g_strcmp0 (_tmp142_, "1") == 0;
												_g_free0 (_tmp142_);
												if (_tmp143_) {
													ValaDataType* _tmp144_;
													_tmp144_ = return_type;
													vala_data_type_set_nullable (_tmp144_, TRUE);
												}
											} else {
												gchar** _tmp145_;
												gint _tmp145__length1;
												const gchar* _tmp146_;
												_tmp145_ = nv;
												_tmp145__length1 = nv_length1;
												_tmp146_ = _tmp145_[0];
												if (g_strcmp0 (_tmp146_, "sentinel") == 0) {
													ValaMethod* _tmp147_;
													gchar** _tmp148_;
													gint _tmp148__length1;
													const gchar* _tmp149_;
													gchar* _tmp150_ = NULL;
													gchar* _tmp151_;
													_tmp147_ = m;
													_tmp148_ = nv;
													_tmp148__length1 = nv_length1;
													_tmp149_ = _tmp148_[1];
													_tmp150_ = vala_gidl_parser_eval (self, _tmp149_);
													_tmp151_ = _tmp150_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp147_, "CCode", "sentinel", _tmp151_, NULL);
													_g_free0 (_tmp151_);
												} else {
													gchar** _tmp152_;
													gint _tmp152__length1;
													const gchar* _tmp153_;
													_tmp152_ = nv;
													_tmp152__length1 = nv_length1;
													_tmp153_ = _tmp152_[0];
													if (g_strcmp0 (_tmp153_, "is_array") == 0) {
														gchar** _tmp154_;
														gint _tmp154__length1;
														const gchar* _tmp155_;
														gchar* _tmp156_ = NULL;
														gchar* _tmp157_;
														gboolean _tmp158_;
														_tmp154_ = nv;
														_tmp154__length1 = nv_length1;
														_tmp155_ = _tmp154_[1];
														_tmp156_ = vala_gidl_parser_eval (self, _tmp155_);
														_tmp157_ = _tmp156_;
														_tmp158_ = g_strcmp0 (_tmp157_, "1") == 0;
														_g_free0 (_tmp157_);
														if (_tmp158_) {
															ValaDataType* _tmp159_;
															ValaDataType* _tmp160_;
															ValaSourceReference* _tmp161_;
															ValaSourceReference* _tmp162_;
															ValaArrayType* _tmp163_;
															ValaMethod* _tmp164_;
															ValaDataType* _tmp165_;
															_tmp159_ = return_type;
															_tmp160_ = return_type;
															_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp160_);
															_tmp162_ = _tmp161_;
															_tmp163_ = vala_array_type_new (_tmp159_, 1, _tmp162_);
															_vala_code_node_unref0 (return_type);
															return_type = (ValaDataType*) _tmp163_;
															_tmp164_ = m;
															_tmp165_ = return_type;
															vala_method_set_return_type (_tmp164_, _tmp165_);
														}
													} else {
														gchar** _tmp166_;
														gint _tmp166__length1;
														const gchar* _tmp167_;
														_tmp166_ = nv;
														_tmp166__length1 = nv_length1;
														_tmp167_ = _tmp166_[0];
														if (g_strcmp0 (_tmp167_, "is_pointer") == 0) {
															gchar** _tmp168_;
															gint _tmp168__length1;
															const gchar* _tmp169_;
															gchar* _tmp170_ = NULL;
															gchar* _tmp171_;
															gboolean _tmp172_;
															_tmp168_ = nv;
															_tmp168__length1 = nv_length1;
															_tmp169_ = _tmp168_[1];
															_tmp170_ = vala_gidl_parser_eval (self, _tmp169_);
															_tmp171_ = _tmp170_;
															_tmp172_ = g_strcmp0 (_tmp171_, "1") == 0;
															_g_free0 (_tmp171_);
															if (_tmp172_) {
																ValaDataType* _tmp173_;
																ValaDataType* _tmp174_;
																ValaSourceReference* _tmp175_;
																ValaSourceReference* _tmp176_;
																ValaPointerType* _tmp177_;
																ValaMethod* _tmp178_;
																ValaDataType* _tmp179_;
																_tmp173_ = return_type;
																_tmp174_ = return_type;
																_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp174_);
																_tmp176_ = _tmp175_;
																_tmp177_ = vala_pointer_type_new (_tmp173_, _tmp176_);
																_vala_code_node_unref0 (return_type);
																return_type = (ValaDataType*) _tmp177_;
																_tmp178_ = m;
																_tmp179_ = return_type;
																vala_method_set_return_type (_tmp178_, _tmp179_);
															}
														} else {
															gchar** _tmp180_;
															gint _tmp180__length1;
															const gchar* _tmp181_;
															_tmp180_ = nv;
															_tmp180__length1 = nv_length1;
															_tmp181_ = _tmp180_[0];
															if (g_strcmp0 (_tmp181_, "throws") == 0) {
																gchar** _tmp182_;
																gint _tmp182__length1;
																const gchar* _tmp183_;
																gchar* _tmp184_ = NULL;
																gchar* _tmp185_;
																gboolean _tmp186_;
																_tmp182_ = nv;
																_tmp182__length1 = nv_length1;
																_tmp183_ = _tmp182_[1];
																_tmp184_ = vala_gidl_parser_eval (self, _tmp183_);
																_tmp185_ = _tmp184_;
																_tmp186_ = g_strcmp0 (_tmp185_, "0") == 0;
																_g_free0 (_tmp185_);
																if (_tmp186_) {
																	suppress_throws = TRUE;
																}
															} else {
																gchar** _tmp187_;
																gint _tmp187__length1;
																const gchar* _tmp188_;
																_tmp187_ = nv;
																_tmp187__length1 = nv_length1;
																_tmp188_ = _tmp187_[0];
																if (g_strcmp0 (_tmp188_, "error_types") == 0) {
																	gchar** _tmp189_;
																	gint _tmp189__length1;
																	const gchar* _tmp190_;
																	gchar* _tmp191_ = NULL;
																	_tmp189_ = nv;
																	_tmp189__length1 = nv_length1;
																	_tmp190_ = _tmp189_[1];
																	_tmp191_ = vala_gidl_parser_eval (self, _tmp190_);
																	_g_free0 (error_types);
																	error_types = _tmp191_;
																} else {
																	gchar** _tmp192_;
																	gint _tmp192__length1;
																	const gchar* _tmp193_;
																	_tmp192_ = nv;
																	_tmp192__length1 = nv_length1;
																	_tmp193_ = _tmp192_[0];
																	if (g_strcmp0 (_tmp193_, "no_array_length") == 0) {
																		gchar** _tmp194_;
																		gint _tmp194__length1;
																		const gchar* _tmp195_;
																		gchar* _tmp196_ = NULL;
																		gchar* _tmp197_;
																		gboolean _tmp198_;
																		_tmp194_ = nv;
																		_tmp194__length1 = nv_length1;
																		_tmp195_ = _tmp194_[1];
																		_tmp196_ = vala_gidl_parser_eval (self, _tmp195_);
																		_tmp197_ = _tmp196_;
																		_tmp198_ = g_strcmp0 (_tmp197_, "1") == 0;
																		_g_free0 (_tmp197_);
																		if (_tmp198_) {
																			ValaMethod* _tmp199_;
																			_tmp199_ = m;
																			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp199_, "CCode", "array_length", FALSE, NULL);
																		}
																	} else {
																		gchar** _tmp200_;
																		gint _tmp200__length1;
																		const gchar* _tmp201_;
																		_tmp200_ = nv;
																		_tmp200__length1 = nv_length1;
																		_tmp201_ = _tmp200_[0];
																		if (g_strcmp0 (_tmp201_, "array_null_terminated") == 0) {
																			gchar** _tmp202_;
																			gint _tmp202__length1;
																			const gchar* _tmp203_;
																			gchar* _tmp204_ = NULL;
																			gchar* _tmp205_;
																			gboolean _tmp206_;
																			_tmp202_ = nv;
																			_tmp202__length1 = nv_length1;
																			_tmp203_ = _tmp202_[1];
																			_tmp204_ = vala_gidl_parser_eval (self, _tmp203_);
																			_tmp205_ = _tmp204_;
																			_tmp206_ = g_strcmp0 (_tmp205_, "1") == 0;
																			_g_free0 (_tmp205_);
																			if (_tmp206_) {
																				ValaMethod* _tmp207_;
																				ValaMethod* _tmp208_;
																				_tmp207_ = m;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp207_, "CCode", "array_length", FALSE, NULL);
																				_tmp208_ = m;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp208_, "CCode", "array_null_terminated", TRUE, NULL);
																			}
																		} else {
																			gchar** _tmp209_;
																			gint _tmp209__length1;
																			const gchar* _tmp210_;
																			_tmp209_ = nv;
																			_tmp209__length1 = nv_length1;
																			_tmp210_ = _tmp209_[0];
																			if (g_strcmp0 (_tmp210_, "array_length_type") == 0) {
																				ValaMethod* _tmp211_;
																				gchar** _tmp212_;
																				gint _tmp212__length1;
																				const gchar* _tmp213_;
																				gchar* _tmp214_ = NULL;
																				gchar* _tmp215_;
																				_tmp211_ = m;
																				_tmp212_ = nv;
																				_tmp212__length1 = nv_length1;
																				_tmp213_ = _tmp212_[1];
																				_tmp214_ = vala_gidl_parser_eval (self, _tmp213_);
																				_tmp215_ = _tmp214_;
																				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp211_, "CCode", "array_length_type", _tmp215_, NULL);
																				_g_free0 (_tmp215_);
																			} else {
																				gchar** _tmp216_;
																				gint _tmp216__length1;
																				const gchar* _tmp217_;
																				_tmp216_ = nv;
																				_tmp216__length1 = nv_length1;
																				_tmp217_ = _tmp216_[0];
																				if (g_strcmp0 (_tmp217_, "type_name") == 0) {
																					ValaMethod* _tmp218_;
																					gchar** _tmp219_;
																					gint _tmp219__length1;
																					const gchar* _tmp220_;
																					gchar* _tmp221_ = NULL;
																					gchar* _tmp222_;
																					ValaDataType* _tmp223_;
																					gboolean _tmp224_;
																					gboolean _tmp225_;
																					ValaDataType* _tmp226_ = NULL;
																					ValaDataType* _tmp227_;
																					_tmp218_ = m;
																					_tmp219_ = nv;
																					_tmp219__length1 = nv_length1;
																					_tmp220_ = _tmp219_[1];
																					_tmp221_ = vala_gidl_parser_eval (self, _tmp220_);
																					_tmp222_ = _tmp221_;
																					_tmp223_ = return_type;
																					_tmp224_ = vala_data_type_get_value_owned (_tmp223_);
																					_tmp225_ = _tmp224_;
																					_tmp226_ = vala_gidl_parser_parse_type_from_string (self, _tmp222_, _tmp225_, NULL);
																					_vala_code_node_unref0 (return_type);
																					return_type = _tmp226_;
																					_tmp227_ = return_type;
																					vala_method_set_return_type (_tmp218_, _tmp227_);
																					_g_free0 (_tmp222_);
																				} else {
																					gchar** _tmp228_;
																					gint _tmp228__length1;
																					const gchar* _tmp229_;
																					_tmp228_ = nv;
																					_tmp228__length1 = nv_length1;
																					_tmp229_ = _tmp228_[0];
																					if (g_strcmp0 (_tmp229_, "ctype") == 0) {
																						ValaMethod* _tmp230_;
																						gchar** _tmp231_;
																						gint _tmp231__length1;
																						const gchar* _tmp232_;
																						gchar* _tmp233_ = NULL;
																						gchar* _tmp234_;
																						_tmp230_ = m;
																						_tmp231_ = nv;
																						_tmp231__length1 = nv_length1;
																						_tmp232_ = _tmp231_[1];
																						_tmp233_ = vala_gidl_parser_eval (self, _tmp232_);
																						_tmp234_ = _tmp233_;
																						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp230_, "CCode", "type", _tmp234_, NULL);
																						_g_free0 (_tmp234_);
																					} else {
																						gchar** _tmp235_;
																						gint _tmp235__length1;
																						const gchar* _tmp236_;
																						_tmp235_ = nv;
																						_tmp235__length1 = nv_length1;
																						_tmp236_ = _tmp235_[0];
																						if (g_strcmp0 (_tmp236_, "type_arguments") == 0) {
																							ValaDataType* _tmp237_;
																							gchar** _tmp238_;
																							gint _tmp238__length1;
																							const gchar* _tmp239_;
																							gchar* _tmp240_ = NULL;
																							gchar* _tmp241_;
																							_tmp237_ = return_type;
																							_tmp238_ = nv;
																							_tmp238__length1 = nv_length1;
																							_tmp239_ = _tmp238_[1];
																							_tmp240_ = vala_gidl_parser_eval (self, _tmp239_);
																							_tmp241_ = _tmp240_;
																							vala_gidl_parser_parse_type_arguments_from_string (self, _tmp237_, _tmp241_, NULL);
																							_g_free0 (_tmp241_);
																						} else {
																							gchar** _tmp242_;
																							gint _tmp242__length1;
																							const gchar* _tmp243_;
																							_tmp242_ = nv;
																							_tmp242__length1 = nv_length1;
																							_tmp243_ = _tmp242_[0];
																							if (g_strcmp0 (_tmp243_, "deprecated") == 0) {
																								gchar** _tmp244_;
																								gint _tmp244__length1;
																								const gchar* _tmp245_;
																								gchar* _tmp246_ = NULL;
																								gchar* _tmp247_;
																								gboolean _tmp248_;
																								_tmp244_ = nv;
																								_tmp244__length1 = nv_length1;
																								_tmp245_ = _tmp244_[1];
																								_tmp246_ = vala_gidl_parser_eval (self, _tmp245_);
																								_tmp247_ = _tmp246_;
																								_tmp248_ = g_strcmp0 (_tmp247_, "1") == 0;
																								_g_free0 (_tmp247_);
																								if (_tmp248_) {
																									ValaMethod* _tmp249_;
																									_tmp249_ = m;
																									vala_code_node_set_attribute ((ValaCodeNode*) _tmp249_, "Deprecated", TRUE, NULL);
																								}
																							} else {
																								gchar** _tmp250_;
																								gint _tmp250__length1;
																								const gchar* _tmp251_;
																								_tmp250_ = nv;
																								_tmp250__length1 = nv_length1;
																								_tmp251_ = _tmp250_[0];
																								if (g_strcmp0 (_tmp251_, "replacement") == 0) {
																									ValaMethod* _tmp252_;
																									gchar** _tmp253_;
																									gint _tmp253__length1;
																									const gchar* _tmp254_;
																									gchar* _tmp255_ = NULL;
																									gchar* _tmp256_;
																									_tmp252_ = m;
																									_tmp253_ = nv;
																									_tmp253__length1 = nv_length1;
																									_tmp254_ = _tmp253_[1];
																									_tmp255_ = vala_gidl_parser_eval (self, _tmp254_);
																									_tmp256_ = _tmp255_;
																									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp252_, "Deprecated", "replacement", _tmp256_, NULL);
																									_g_free0 (_tmp256_);
																								} else {
																									gchar** _tmp257_;
																									gint _tmp257__length1;
																									const gchar* _tmp258_;
																									_tmp257_ = nv;
																									_tmp257__length1 = nv_length1;
																									_tmp258_ = _tmp257_[0];
																									if (g_strcmp0 (_tmp258_, "deprecated_since") == 0) {
																										ValaMethod* _tmp259_;
																										gchar** _tmp260_;
																										gint _tmp260__length1;
																										const gchar* _tmp261_;
																										gchar* _tmp262_ = NULL;
																										gchar* _tmp263_;
																										_tmp259_ = m;
																										_tmp260_ = nv;
																										_tmp260__length1 = nv_length1;
																										_tmp261_ = _tmp260_[1];
																										_tmp262_ = vala_gidl_parser_eval (self, _tmp261_);
																										_tmp263_ = _tmp262_;
																										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp259_, "Deprecated", "since", _tmp263_, NULL);
																										_g_free0 (_tmp263_);
																									} else {
																										gchar** _tmp264_;
																										gint _tmp264__length1;
																										const gchar* _tmp265_;
																										_tmp264_ = nv;
																										_tmp264__length1 = nv_length1;
																										_tmp265_ = _tmp264_[0];
																										if (g_strcmp0 (_tmp265_, "cheader_filename") == 0) {
																											ValaMethod* _tmp266_;
																											gchar** _tmp267_;
																											gint _tmp267__length1;
																											const gchar* _tmp268_;
																											gchar* _tmp269_ = NULL;
																											gchar* _tmp270_;
																											_tmp266_ = m;
																											_tmp267_ = nv;
																											_tmp267__length1 = nv_length1;
																											_tmp268_ = _tmp267_[1];
																											_tmp269_ = vala_gidl_parser_eval (self, _tmp268_);
																											_tmp270_ = _tmp269_;
																											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp266_, "CCode", "cheader_filename", _tmp270_, NULL);
																											_g_free0 (_tmp270_);
																										} else {
																											gchar** _tmp271_;
																											gint _tmp271__length1;
																											const gchar* _tmp272_;
																											_tmp271_ = nv;
																											_tmp271__length1 = nv_length1;
																											_tmp272_ = _tmp271_[0];
																											if (g_strcmp0 (_tmp272_, "abstract") == 0) {
																												gchar** _tmp273_;
																												gint _tmp273__length1;
																												const gchar* _tmp274_;
																												gchar* _tmp275_ = NULL;
																												gchar* _tmp276_;
																												gboolean _tmp277_;
																												_tmp273_ = nv;
																												_tmp273__length1 = nv_length1;
																												_tmp274_ = _tmp273_[1];
																												_tmp275_ = vala_gidl_parser_eval (self, _tmp274_);
																												_tmp276_ = _tmp275_;
																												_tmp277_ = g_strcmp0 (_tmp276_, "1") == 0;
																												_g_free0 (_tmp276_);
																												if (_tmp277_) {
																													ValaMethod* _tmp278_;
																													_tmp278_ = m;
																													vala_method_set_is_abstract (_tmp278_, TRUE);
																												}
																											} else {
																												gchar** _tmp279_;
																												gint _tmp279__length1;
																												const gchar* _tmp280_;
																												_tmp279_ = nv;
																												_tmp279__length1 = nv_length1;
																												_tmp280_ = _tmp279_[0];
																												if (g_strcmp0 (_tmp280_, "virtual") == 0) {
																													gchar** _tmp281_;
																													gint _tmp281__length1;
																													const gchar* _tmp282_;
																													gchar* _tmp283_ = NULL;
																													gchar* _tmp284_;
																													gboolean _tmp285_;
																													_tmp281_ = nv;
																													_tmp281__length1 = nv_length1;
																													_tmp282_ = _tmp281_[1];
																													_tmp283_ = vala_gidl_parser_eval (self, _tmp282_);
																													_tmp284_ = _tmp283_;
																													_tmp285_ = g_strcmp0 (_tmp284_, "1") == 0;
																													_g_free0 (_tmp284_);
																													if (_tmp285_) {
																														ValaMethod* _tmp286_;
																														_tmp286_ = m;
																														vala_method_set_is_virtual (_tmp286_, TRUE);
																													}
																												} else {
																													gchar** _tmp287_;
																													gint _tmp287__length1;
																													const gchar* _tmp288_;
																													_tmp287_ = nv;
																													_tmp287__length1 = nv_length1;
																													_tmp288_ = _tmp287_[0];
																													if (g_strcmp0 (_tmp288_, "vfunc_name") == 0) {
																														ValaMethod* _tmp289_;
																														gchar** _tmp290_;
																														gint _tmp290__length1;
																														const gchar* _tmp291_;
																														gchar* _tmp292_ = NULL;
																														gchar* _tmp293_;
																														_tmp289_ = m;
																														_tmp290_ = nv;
																														_tmp290__length1 = nv_length1;
																														_tmp291_ = _tmp290_[1];
																														_tmp292_ = vala_gidl_parser_eval (self, _tmp291_);
																														_tmp293_ = _tmp292_;
																														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp289_, "CCode", "vfunc_name", _tmp293_, NULL);
																														_g_free0 (_tmp293_);
																													} else {
																														gchar** _tmp294_;
																														gint _tmp294__length1;
																														const gchar* _tmp295_;
																														_tmp294_ = nv;
																														_tmp294__length1 = nv_length1;
																														_tmp295_ = _tmp294_[0];
																														if (g_strcmp0 (_tmp295_, "finish_name") == 0) {
																															ValaMethod* _tmp296_;
																															gchar** _tmp297_;
																															gint _tmp297__length1;
																															const gchar* _tmp298_;
																															gchar* _tmp299_ = NULL;
																															gchar* _tmp300_;
																															_tmp296_ = m;
																															_tmp297_ = nv;
																															_tmp297__length1 = nv_length1;
																															_tmp298_ = _tmp297_[1];
																															_tmp299_ = vala_gidl_parser_eval (self, _tmp298_);
																															_tmp300_ = _tmp299_;
																															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp296_, "CCode", "finish_name", _tmp300_, NULL);
																															_g_free0 (_tmp300_);
																														} else {
																															gchar** _tmp301_;
																															gint _tmp301__length1;
																															const gchar* _tmp302_;
																															_tmp301_ = nv;
																															_tmp301__length1 = nv_length1;
																															_tmp302_ = _tmp301_[0];
																															if (g_strcmp0 (_tmp302_, "async") == 0) {
																																gchar** _tmp303_;
																																gint _tmp303__length1;
																																const gchar* _tmp304_;
																																gchar* _tmp305_ = NULL;
																																gchar* _tmp306_;
																																gboolean _tmp307_;
																																_tmp303_ = nv;
																																_tmp303__length1 = nv_length1;
																																_tmp304_ = _tmp303_[1];
																																_tmp305_ = vala_gidl_parser_eval (self, _tmp304_);
																																_tmp306_ = _tmp305_;
																																_tmp307_ = g_strcmp0 (_tmp306_, "1") == 0;
																																_g_free0 (_tmp306_);
																																if (_tmp307_) {
																																	ValaMethod* _tmp308_;
																																	_tmp308_ = m;
																																	vala_method_set_coroutine (_tmp308_, TRUE);
																																}
																															} else {
																																gchar** _tmp309_;
																																gint _tmp309__length1;
																																const gchar* _tmp310_;
																																_tmp309_ = nv;
																																_tmp309__length1 = nv_length1;
																																_tmp310_ = _tmp309_[0];
																																if (g_strcmp0 (_tmp310_, "parent") == 0) {
																																	gchar** _tmp311_;
																																	gint _tmp311__length1;
																																	const gchar* _tmp312_;
																																	gchar* _tmp313_ = NULL;
																																	gchar* _tmp314_;
																																	ValaSymbol* _tmp315_ = NULL;
																																	ValaSymbol* _tmp316_;
																																	gchar* _tmp317_ = NULL;
																																	gchar* prefix;
																																	const gchar* _tmp318_;
																																	const gchar* _tmp319_;
																																	gboolean _tmp320_ = FALSE;
																																	_tmp311_ = nv;
																																	_tmp311__length1 = nv_length1;
																																	_tmp312_ = _tmp311_[1];
																																	_tmp313_ = vala_gidl_parser_eval (self, _tmp312_);
																																	_tmp314_ = _tmp313_;
																																	_tmp315_ = vala_gidl_parser_get_container_from_name (self, _tmp314_);
																																	_vala_code_node_unref0 (container);
																																	container = _tmp315_;
																																	_g_free0 (_tmp314_);
																																	_tmp316_ = container;
																																	_tmp317_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp316_);
																																	prefix = _tmp317_;
																																	_tmp318_ = symbol;
																																	_tmp319_ = prefix;
																																	_tmp320_ = g_str_has_prefix (_tmp318_, _tmp319_);
																																	if (_tmp320_) {
																																		ValaMethod* _tmp321_;
																																		const gchar* _tmp322_;
																																		const gchar* _tmp323_;
																																		gint _tmp324_;
																																		gint _tmp325_;
																																		gchar* _tmp326_ = NULL;
																																		gchar* _tmp327_;
																																		_tmp321_ = m;
																																		_tmp322_ = symbol;
																																		_tmp323_ = prefix;
																																		_tmp324_ = strlen (_tmp323_);
																																		_tmp325_ = _tmp324_;
																																		_tmp326_ = string_substring (_tmp322_, (glong) _tmp325_, (glong) (-1));
																																		_tmp327_ = _tmp326_;
																																		vala_symbol_set_name ((ValaSymbol*) _tmp321_, _tmp327_);
																																		_g_free0 (_tmp327_);
																																	}
																																	_g_free0 (prefix);
																																} else {
																																	gchar** _tmp328_;
																																	gint _tmp328__length1;
																																	const gchar* _tmp329_;
																																	_tmp328_ = nv;
																																	_tmp328__length1 = nv_length1;
																																	_tmp329_ = _tmp328_[0];
																																	if (g_strcmp0 (_tmp329_, "experimental") == 0) {
																																		gchar** _tmp330_;
																																		gint _tmp330__length1;
																																		const gchar* _tmp331_;
																																		gchar* _tmp332_ = NULL;
																																		gchar* _tmp333_;
																																		gboolean _tmp334_;
																																		_tmp330_ = nv;
																																		_tmp330__length1 = nv_length1;
																																		_tmp331_ = _tmp330_[1];
																																		_tmp332_ = vala_gidl_parser_eval (self, _tmp331_);
																																		_tmp333_ = _tmp332_;
																																		_tmp334_ = g_strcmp0 (_tmp333_, "1") == 0;
																																		_g_free0 (_tmp333_);
																																		if (_tmp334_) {
																																			ValaMethod* _tmp335_;
																																			_tmp335_ = m;
																																			vala_code_node_set_attribute ((ValaCodeNode*) _tmp335_, "Experimental", TRUE, NULL);
																																		}
																																	} else {
																																		gchar** _tmp336_;
																																		gint _tmp336__length1;
																																		const gchar* _tmp337_;
																																		_tmp336_ = nv;
																																		_tmp336__length1 = nv_length1;
																																		_tmp337_ = _tmp336_[0];
																																		if (g_strcmp0 (_tmp337_, "simple_generics") == 0) {
																																			gchar** _tmp338_;
																																			gint _tmp338__length1;
																																			const gchar* _tmp339_;
																																			gchar* _tmp340_ = NULL;
																																			gchar* _tmp341_;
																																			gboolean _tmp342_;
																																			_tmp338_ = nv;
																																			_tmp338__length1 = nv_length1;
																																			_tmp339_ = _tmp338_[1];
																																			_tmp340_ = vala_gidl_parser_eval (self, _tmp339_);
																																			_tmp341_ = _tmp340_;
																																			_tmp342_ = g_strcmp0 (_tmp341_, "1") == 0;
																																			_g_free0 (_tmp341_);
																																			if (_tmp342_) {
																																				ValaMethod* _tmp343_;
																																				_tmp343_ = m;
																																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp343_, "CCode", "simple_generics", TRUE, NULL);
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	_tmp344_ = parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp344_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNodeParam* _tmp345_;
				GIdlNode* param_node;
				gboolean _tmp346_;
				gboolean _tmp414_ = FALSE;
				GIdlNodeParam* _tmp415_;
				GIdlNodeType* _tmp416_;
				const gchar* _tmp417_;
				gboolean _tmp425_;
				gboolean _tmp427_ = FALSE;
				gboolean _tmp428_;
				gboolean _tmp431_;
				GIdlNode* _tmp438_;
				const gchar* _tmp439_;
				gchar* _tmp440_;
				gchar* param_name;
				const gchar* _tmp441_;
				ValaParameterDirection direction = 0;
				GIdlNodeParam* _tmp445_;
				ValaParameterDirection _tmp446_ = 0;
				ValaDataType* _tmp447_ = NULL;
				ValaDataType* param_type;
				const gchar* _tmp448_;
				ValaDataType* _tmp449_;
				ValaParameter* _tmp450_;
				ValaParameter* p;
				ValaParameter* _tmp451_;
				ValaParameterDirection _tmp452_;
				gboolean hide_param;
				gboolean show_param;
				gboolean set_array_length_pos;
				gdouble array_length_pos;
				gboolean set_delegate_target_pos;
				gdouble delegate_target_pos;
				gboolean array_requested;
				gboolean out_requested;
				const gchar* _tmp453_;
				GIdlNode* _tmp454_;
				const gchar* _tmp455_;
				gchar* _tmp456_ = NULL;
				gchar* _tmp457_;
				gint _tmp458_ = 0;
				gchar** _tmp459_ = NULL;
				gchar** _tmp460_;
				gint _tmp460__length1;
				gboolean _tmp727_ = FALSE;
				ValaParameter* _tmp728_;
				gboolean _tmp737_;
				gboolean _tmp753_ = FALSE;
				gboolean _tmp754_;
				gboolean _tmp756_;
				ValaParameter* _tmp765_;
				ValaParameter* _tmp766_;
				ValaDataType* _tmp767_;
				ValaDataType* _tmp768_;
				_tmp345_ = param;
				param_node = (GIdlNode*) _tmp345_;
				_tmp346_ = first;
				if (_tmp346_) {
					gboolean _tmp347_ = FALSE;
					gboolean _tmp348_ = FALSE;
					gboolean _tmp349_ = FALSE;
					ValaMethod* _tmp350_;
					gboolean _tmp352_;
					gboolean _tmp356_;
					gboolean _tmp368_;
					first = FALSE;
					_tmp350_ = m;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp350_, VALA_TYPE_CREATION_METHOD)) {
						ValaTypeSymbol* _tmp351_;
						_tmp351_ = self->priv->current_data_type;
						_tmp349_ = _tmp351_ != NULL;
					} else {
						_tmp349_ = FALSE;
					}
					_tmp352_ = _tmp349_;
					if (_tmp352_) {
						GIdlNodeParam* _tmp353_;
						GIdlNodeType* _tmp354_;
						gboolean _tmp355_;
						_tmp353_ = param;
						_tmp354_ = _tmp353_->type;
						_tmp355_ = _tmp354_->is_interface;
						_tmp348_ = _tmp355_;
					} else {
						_tmp348_ = FALSE;
					}
					_tmp356_ = _tmp348_;
					if (_tmp356_) {
						gboolean _tmp357_ = FALSE;
						GIdlNode* _tmp358_;
						const gchar* _tmp359_;
						gboolean _tmp367_;
						_tmp358_ = param_node;
						_tmp359_ = _tmp358_->name;
						if (g_strcmp0 (_tmp359_, "self") == 0) {
							_tmp357_ = TRUE;
						} else {
							GIdlNodeParam* _tmp360_;
							GIdlNodeType* _tmp361_;
							const gchar* _tmp362_;
							ValaTypeSymbol* _tmp363_;
							gchar* _tmp364_ = NULL;
							gchar* _tmp365_;
							gboolean _tmp366_ = FALSE;
							_tmp360_ = param;
							_tmp361_ = _tmp360_->type;
							_tmp362_ = _tmp361_->interface;
							_tmp363_ = self->priv->current_data_type;
							_tmp364_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp363_, NULL);
							_tmp365_ = _tmp364_;
							_tmp366_ = g_str_has_suffix (_tmp362_, _tmp365_);
							_tmp357_ = _tmp366_;
							_g_free0 (_tmp365_);
						}
						_tmp367_ = _tmp357_;
						_tmp347_ = _tmp367_;
					} else {
						_tmp347_ = FALSE;
					}
					_tmp368_ = _tmp347_;
					if (_tmp368_) {
						continue;
					} else {
						gboolean _tmp369_ = FALSE;
						gboolean _tmp370_ = FALSE;
						gboolean _tmp371_ = FALSE;
						ValaMethod* _tmp372_;
						gboolean _tmp374_;
						gboolean _tmp378_;
						gboolean _tmp392_;
						_tmp372_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp372_, VALA_TYPE_CREATION_METHOD)) {
							ValaTypeSymbol* _tmp373_;
							_tmp373_ = self->priv->current_data_type;
							_tmp371_ = _tmp373_ != NULL;
						} else {
							_tmp371_ = FALSE;
						}
						_tmp374_ = _tmp371_;
						if (_tmp374_) {
							GIdlNodeParam* _tmp375_;
							GIdlNodeType* _tmp376_;
							gboolean _tmp377_;
							_tmp375_ = param;
							_tmp376_ = _tmp375_->type;
							_tmp377_ = _tmp376_->is_interface;
							_tmp370_ = _tmp377_;
						} else {
							_tmp370_ = FALSE;
						}
						_tmp378_ = _tmp370_;
						if (_tmp378_) {
							gboolean _tmp379_ = FALSE;
							GIdlNode* _tmp380_;
							const gchar* _tmp381_;
							gboolean _tmp391_;
							_tmp380_ = param_node;
							_tmp381_ = _tmp380_->name;
							if (g_strcmp0 (_tmp381_, "klass") == 0) {
								_tmp379_ = TRUE;
							} else {
								GIdlNodeParam* _tmp382_;
								GIdlNodeType* _tmp383_;
								const gchar* _tmp384_;
								ValaTypeSymbol* _tmp385_;
								gchar* _tmp386_ = NULL;
								gchar* _tmp387_;
								gchar* _tmp388_ = NULL;
								gchar* _tmp389_;
								gboolean _tmp390_ = FALSE;
								_tmp382_ = param;
								_tmp383_ = _tmp382_->type;
								_tmp384_ = _tmp383_->interface;
								_tmp385_ = self->priv->current_data_type;
								_tmp386_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp385_, NULL);
								_tmp387_ = _tmp386_;
								_tmp388_ = g_strdup_printf ("%sClass", _tmp387_);
								_tmp389_ = _tmp388_;
								_tmp390_ = g_str_has_suffix (_tmp384_, _tmp389_);
								_tmp379_ = _tmp390_;
								_g_free0 (_tmp389_);
								_g_free0 (_tmp387_);
							}
							_tmp391_ = _tmp379_;
							_tmp369_ = _tmp391_;
						} else {
							_tmp369_ = FALSE;
						}
						_tmp392_ = _tmp369_;
						if (_tmp392_) {
							ValaMethod* _tmp393_;
							ValaMethod* _tmp394_;
							const gchar* _tmp395_;
							const gchar* _tmp396_;
							gboolean _tmp397_ = FALSE;
							_tmp393_ = m;
							vala_method_set_binding (_tmp393_, VALA_MEMBER_BINDING_CLASS);
							_tmp394_ = m;
							_tmp395_ = vala_symbol_get_name ((ValaSymbol*) _tmp394_);
							_tmp396_ = _tmp395_;
							_tmp397_ = g_str_has_prefix (_tmp396_, "class_");
							if (_tmp397_) {
								ValaMethod* _tmp398_;
								ValaMethod* _tmp399_;
								const gchar* _tmp400_;
								const gchar* _tmp401_;
								gint _tmp402_;
								gint _tmp403_;
								ValaMethod* _tmp404_;
								const gchar* _tmp405_;
								const gchar* _tmp406_;
								gint _tmp407_;
								gint _tmp408_;
								gint _tmp409_;
								gint _tmp410_;
								gchar* _tmp411_ = NULL;
								gchar* _tmp412_;
								_tmp398_ = m;
								_tmp399_ = m;
								_tmp400_ = vala_symbol_get_name ((ValaSymbol*) _tmp399_);
								_tmp401_ = _tmp400_;
								_tmp402_ = strlen ("class_");
								_tmp403_ = _tmp402_;
								_tmp404_ = m;
								_tmp405_ = vala_symbol_get_name ((ValaSymbol*) _tmp404_);
								_tmp406_ = _tmp405_;
								_tmp407_ = strlen (_tmp406_);
								_tmp408_ = _tmp407_;
								_tmp409_ = strlen ("class_");
								_tmp410_ = _tmp409_;
								_tmp411_ = string_substring (_tmp401_, (glong) _tmp403_, (glong) (_tmp408_ - _tmp410_));
								_tmp412_ = _tmp411_;
								vala_symbol_set_name ((ValaSymbol*) _tmp398_, _tmp412_);
								_g_free0 (_tmp412_);
							}
							continue;
						} else {
							ValaMethod* _tmp413_;
							_tmp413_ = m;
							vala_method_set_binding (_tmp413_, VALA_MEMBER_BINDING_STATIC);
						}
					}
				}
				_tmp415_ = param;
				_tmp416_ = _tmp415_->type;
				_tmp417_ = _tmp416_->interface;
				if (g_strcmp0 (_tmp417_, "GAsyncReadyCallback") == 0) {
					gboolean _tmp418_ = FALSE;
					const gchar* _tmp419_;
					gboolean _tmp420_ = FALSE;
					gboolean _tmp424_;
					_tmp419_ = symbol;
					_tmp420_ = g_str_has_suffix (_tmp419_, "_async");
					if (_tmp420_) {
						_tmp418_ = TRUE;
					} else {
						ValaMethod* _tmp421_;
						gboolean _tmp422_;
						gboolean _tmp423_;
						_tmp421_ = m;
						_tmp422_ = vala_method_get_coroutine (_tmp421_);
						_tmp423_ = _tmp422_;
						_tmp418_ = _tmp423_;
					}
					_tmp424_ = _tmp418_;
					_tmp414_ = _tmp424_;
				} else {
					_tmp414_ = FALSE;
				}
				_tmp425_ = _tmp414_;
				if (_tmp425_) {
					ValaMethod* _tmp426_;
					_tmp426_ = m;
					vala_method_set_coroutine (_tmp426_, TRUE);
					continue;
				}
				_tmp428_ = suppress_throws;
				if (_tmp428_ == FALSE) {
					GIdlNodeParam* _tmp429_;
					gboolean _tmp430_ = FALSE;
					_tmp429_ = param;
					_tmp430_ = vala_gidl_parser_param_is_exception (self, _tmp429_);
					_tmp427_ = _tmp430_;
				} else {
					_tmp427_ = FALSE;
				}
				_tmp431_ = _tmp427_;
				if (_tmp431_) {
					const gchar* _tmp432_;
					_tmp432_ = error_types;
					if (_tmp432_ == NULL) {
						ValaMethod* _tmp433_;
						GIdlNodeParam* _tmp434_;
						GIdlNodeType* _tmp435_;
						ValaDataType* _tmp436_ = NULL;
						ValaDataType* _tmp437_;
						_tmp433_ = m;
						_tmp434_ = param;
						_tmp435_ = _tmp434_->type;
						_tmp436_ = vala_gidl_parser_parse_type (self, _tmp435_, NULL);
						_tmp437_ = _tmp436_;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp433_, _tmp437_);
						_vala_code_node_unref0 (_tmp437_);
					}
					continue;
				}
				_tmp438_ = param_node;
				_tmp439_ = _tmp438_->name;
				_tmp440_ = g_strdup (_tmp439_);
				param_name = _tmp440_;
				_tmp441_ = param_name;
				if (g_strcmp0 (_tmp441_, "result") == 0) {
					gchar* _tmp442_;
					_tmp442_ = g_strdup ("_result");
					_g_free0 (param_name);
					param_name = _tmp442_;
				} else {
					const gchar* _tmp443_;
					_tmp443_ = param_name;
					if (g_strcmp0 (_tmp443_, "string") == 0) {
						gchar* _tmp444_;
						_tmp444_ = g_strdup ("str");
						_g_free0 (param_name);
						param_name = _tmp444_;
					}
				}
				_tmp445_ = param;
				_tmp447_ = vala_gidl_parser_parse_param (self, _tmp445_, &_tmp446_);
				direction = _tmp446_;
				param_type = _tmp447_;
				_tmp448_ = param_name;
				_tmp449_ = param_type;
				_tmp450_ = vala_parameter_new (_tmp448_, _tmp449_, NULL);
				p = _tmp450_;
				_tmp451_ = p;
				_tmp452_ = direction;
				vala_parameter_set_direction (_tmp451_, _tmp452_);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (gdouble) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (gdouble) 0;
				array_requested = FALSE;
				out_requested = FALSE;
				_tmp453_ = symbol;
				_tmp454_ = param_node;
				_tmp455_ = _tmp454_->name;
				_tmp456_ = g_strdup_printf ("%s.%s", _tmp453_, _tmp455_);
				_tmp457_ = _tmp456_;
				_tmp459_ = vala_gidl_parser_get_attributes (self, _tmp457_, &_tmp458_);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes = _tmp459_;
				attributes_length1 = _tmp458_;
				_attributes_size_ = attributes_length1;
				_g_free0 (_tmp457_);
				_tmp460_ = attributes;
				_tmp460__length1 = attributes_length1;
				if (_tmp460_ != NULL) {
					gchar** _tmp461_;
					gint _tmp461__length1;
					_tmp461_ = attributes;
					_tmp461__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp461_;
						attr_collection_length1 = _tmp461__length1;
						for (attr_it = 0; attr_it < _tmp461__length1; attr_it = attr_it + 1) {
							gchar* _tmp462_;
							gchar* attr = NULL;
							_tmp462_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp462_;
							{
								const gchar* _tmp463_;
								gchar** _tmp464_;
								gchar** _tmp465_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp466_;
								gint _tmp466__length1;
								const gchar* _tmp467_;
								_tmp463_ = attr;
								_tmp465_ = _tmp464_ = g_strsplit (_tmp463_, "=", 2);
								nv = _tmp465_;
								nv_length1 = _vala_array_length (_tmp464_);
								_nv_size_ = nv_length1;
								_tmp466_ = nv;
								_tmp466__length1 = nv_length1;
								_tmp467_ = _tmp466_[0];
								if (g_strcmp0 (_tmp467_, "is_array") == 0) {
									gchar** _tmp468_;
									gint _tmp468__length1;
									const gchar* _tmp469_;
									gchar* _tmp470_ = NULL;
									gchar* _tmp471_;
									gboolean _tmp472_;
									_tmp468_ = nv;
									_tmp468__length1 = nv_length1;
									_tmp469_ = _tmp468_[1];
									_tmp470_ = vala_gidl_parser_eval (self, _tmp469_);
									_tmp471_ = _tmp470_;
									_tmp472_ = g_strcmp0 (_tmp471_, "1") == 0;
									_g_free0 (_tmp471_);
									if (_tmp472_) {
										ValaDataType* _tmp473_;
										ValaDataType* _tmp474_;
										ValaSourceReference* _tmp475_;
										ValaSourceReference* _tmp476_;
										ValaArrayType* _tmp477_;
										ValaParameter* _tmp478_;
										ValaDataType* _tmp479_;
										gboolean _tmp480_;
										_tmp473_ = param_type;
										_tmp474_ = param_type;
										_tmp475_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp474_);
										_tmp476_ = _tmp475_;
										_tmp477_ = vala_array_type_new (_tmp473_, 1, _tmp476_);
										_vala_code_node_unref0 (param_type);
										param_type = (ValaDataType*) _tmp477_;
										_tmp478_ = p;
										_tmp479_ = param_type;
										vala_variable_set_variable_type ((ValaVariable*) _tmp478_, _tmp479_);
										_tmp480_ = out_requested;
										if (!_tmp480_) {
											ValaParameter* _tmp481_;
											_tmp481_ = p;
											vala_parameter_set_direction (_tmp481_, VALA_PARAMETER_DIRECTION_IN);
										}
										array_requested = TRUE;
									}
								} else {
									gchar** _tmp482_;
									gint _tmp482__length1;
									const gchar* _tmp483_;
									_tmp482_ = nv;
									_tmp482__length1 = nv_length1;
									_tmp483_ = _tmp482_[0];
									if (g_strcmp0 (_tmp483_, "is_pointer") == 0) {
										gchar** _tmp484_;
										gint _tmp484__length1;
										const gchar* _tmp485_;
										gchar* _tmp486_ = NULL;
										gchar* _tmp487_;
										gboolean _tmp488_;
										_tmp484_ = nv;
										_tmp484__length1 = nv_length1;
										_tmp485_ = _tmp484_[1];
										_tmp486_ = vala_gidl_parser_eval (self, _tmp485_);
										_tmp487_ = _tmp486_;
										_tmp488_ = g_strcmp0 (_tmp487_, "1") == 0;
										_g_free0 (_tmp487_);
										if (_tmp488_) {
											ValaDataType* _tmp489_;
											ValaDataType* _tmp490_;
											ValaSourceReference* _tmp491_;
											ValaSourceReference* _tmp492_;
											ValaPointerType* _tmp493_;
											ValaParameter* _tmp494_;
											ValaDataType* _tmp495_;
											gboolean _tmp496_;
											_tmp489_ = param_type;
											_tmp490_ = return_type;
											_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
											_tmp492_ = _tmp491_;
											_tmp493_ = vala_pointer_type_new (_tmp489_, _tmp492_);
											_vala_code_node_unref0 (param_type);
											param_type = (ValaDataType*) _tmp493_;
											_tmp494_ = p;
											_tmp495_ = param_type;
											vala_variable_set_variable_type ((ValaVariable*) _tmp494_, _tmp495_);
											_tmp496_ = out_requested;
											if (!_tmp496_) {
												ValaParameter* _tmp497_;
												_tmp497_ = p;
												vala_parameter_set_direction (_tmp497_, VALA_PARAMETER_DIRECTION_IN);
											}
										}
									} else {
										gchar** _tmp498_;
										gint _tmp498__length1;
										const gchar* _tmp499_;
										_tmp498_ = nv;
										_tmp498__length1 = nv_length1;
										_tmp499_ = _tmp498_[0];
										if (g_strcmp0 (_tmp499_, "is_out") == 0) {
											gchar** _tmp500_;
											gint _tmp500__length1;
											const gchar* _tmp501_;
											gchar* _tmp502_ = NULL;
											gchar* _tmp503_;
											gboolean _tmp504_;
											_tmp500_ = nv;
											_tmp500__length1 = nv_length1;
											_tmp501_ = _tmp500_[1];
											_tmp502_ = vala_gidl_parser_eval (self, _tmp501_);
											_tmp503_ = _tmp502_;
											_tmp504_ = g_strcmp0 (_tmp503_, "1") == 0;
											_g_free0 (_tmp503_);
											if (_tmp504_) {
												ValaParameter* _tmp505_;
												gboolean _tmp506_ = FALSE;
												gboolean _tmp507_;
												gboolean _tmp509_;
												_tmp505_ = p;
												vala_parameter_set_direction (_tmp505_, VALA_PARAMETER_DIRECTION_OUT);
												out_requested = TRUE;
												_tmp507_ = array_requested;
												if (!_tmp507_) {
													ValaDataType* _tmp508_;
													_tmp508_ = param_type;
													_tmp506_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp508_, VALA_TYPE_ARRAY_TYPE);
												} else {
													_tmp506_ = FALSE;
												}
												_tmp509_ = _tmp506_;
												if (_tmp509_) {
													ValaDataType* _tmp510_;
													ValaArrayType* _tmp511_;
													ValaArrayType* array_type;
													ValaArrayType* _tmp512_;
													ValaDataType* _tmp513_;
													ValaDataType* _tmp514_;
													ValaDataType* _tmp515_;
													ValaParameter* _tmp516_;
													ValaDataType* _tmp517_;
													_tmp510_ = param_type;
													_tmp511_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp510_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
													array_type = _tmp511_;
													_tmp512_ = array_type;
													_tmp513_ = vala_array_type_get_element_type (_tmp512_);
													_tmp514_ = _tmp513_;
													_tmp515_ = _vala_code_node_ref0 (_tmp514_);
													_vala_code_node_unref0 (param_type);
													param_type = _tmp515_;
													_tmp516_ = p;
													_tmp517_ = param_type;
													vala_variable_set_variable_type ((ValaVariable*) _tmp516_, _tmp517_);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											gchar** _tmp518_;
											gint _tmp518__length1;
											const gchar* _tmp519_;
											_tmp518_ = nv;
											_tmp518__length1 = nv_length1;
											_tmp519_ = _tmp518_[0];
											if (g_strcmp0 (_tmp519_, "is_ref") == 0) {
												gchar** _tmp520_;
												gint _tmp520__length1;
												const gchar* _tmp521_;
												gchar* _tmp522_ = NULL;
												gchar* _tmp523_;
												gboolean _tmp524_;
												_tmp520_ = nv;
												_tmp520__length1 = nv_length1;
												_tmp521_ = _tmp520_[1];
												_tmp522_ = vala_gidl_parser_eval (self, _tmp521_);
												_tmp523_ = _tmp522_;
												_tmp524_ = g_strcmp0 (_tmp523_, "1") == 0;
												_g_free0 (_tmp523_);
												if (_tmp524_) {
													ValaParameter* _tmp525_;
													gboolean _tmp526_ = FALSE;
													gboolean _tmp527_;
													gboolean _tmp529_;
													_tmp525_ = p;
													vala_parameter_set_direction (_tmp525_, VALA_PARAMETER_DIRECTION_REF);
													_tmp527_ = array_requested;
													if (!_tmp527_) {
														ValaDataType* _tmp528_;
														_tmp528_ = param_type;
														_tmp526_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp528_, VALA_TYPE_ARRAY_TYPE);
													} else {
														_tmp526_ = FALSE;
													}
													_tmp529_ = _tmp526_;
													if (_tmp529_) {
														ValaDataType* _tmp530_;
														ValaArrayType* _tmp531_;
														ValaArrayType* array_type;
														ValaArrayType* _tmp532_;
														ValaDataType* _tmp533_;
														ValaDataType* _tmp534_;
														ValaDataType* _tmp535_;
														ValaParameter* _tmp536_;
														ValaDataType* _tmp537_;
														_tmp530_ = param_type;
														_tmp531_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp530_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
														array_type = _tmp531_;
														_tmp532_ = array_type;
														_tmp533_ = vala_array_type_get_element_type (_tmp532_);
														_tmp534_ = _tmp533_;
														_tmp535_ = _vala_code_node_ref0 (_tmp534_);
														_vala_code_node_unref0 (param_type);
														param_type = _tmp535_;
														_tmp536_ = p;
														_tmp537_ = param_type;
														vala_variable_set_variable_type ((ValaVariable*) _tmp536_, _tmp537_);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												gchar** _tmp538_;
												gint _tmp538__length1;
												const gchar* _tmp539_;
												_tmp538_ = nv;
												_tmp538__length1 = nv_length1;
												_tmp539_ = _tmp538_[0];
												if (g_strcmp0 (_tmp539_, "nullable") == 0) {
													gchar** _tmp540_;
													gint _tmp540__length1;
													const gchar* _tmp541_;
													gchar* _tmp542_ = NULL;
													gchar* _tmp543_;
													gboolean _tmp544_;
													_tmp540_ = nv;
													_tmp540__length1 = nv_length1;
													_tmp541_ = _tmp540_[1];
													_tmp542_ = vala_gidl_parser_eval (self, _tmp541_);
													_tmp543_ = _tmp542_;
													_tmp544_ = g_strcmp0 (_tmp543_, "1") == 0;
													_g_free0 (_tmp543_);
													if (_tmp544_) {
														ValaDataType* _tmp545_;
														_tmp545_ = param_type;
														vala_data_type_set_nullable (_tmp545_, TRUE);
													}
												} else {
													gchar** _tmp546_;
													gint _tmp546__length1;
													const gchar* _tmp547_;
													_tmp546_ = nv;
													_tmp546__length1 = nv_length1;
													_tmp547_ = _tmp546_[0];
													if (g_strcmp0 (_tmp547_, "transfer_ownership") == 0) {
														gchar** _tmp548_;
														gint _tmp548__length1;
														const gchar* _tmp549_;
														gchar* _tmp550_ = NULL;
														gchar* _tmp551_;
														gboolean _tmp552_;
														_tmp548_ = nv;
														_tmp548__length1 = nv_length1;
														_tmp549_ = _tmp548_[1];
														_tmp550_ = vala_gidl_parser_eval (self, _tmp549_);
														_tmp551_ = _tmp550_;
														_tmp552_ = g_strcmp0 (_tmp551_, "1") == 0;
														_g_free0 (_tmp551_);
														if (_tmp552_) {
															ValaDataType* _tmp553_;
															_tmp553_ = param_type;
															vala_data_type_set_value_owned (_tmp553_, TRUE);
														}
													} else {
														gchar** _tmp554_;
														gint _tmp554__length1;
														const gchar* _tmp555_;
														_tmp554_ = nv;
														_tmp554__length1 = nv_length1;
														_tmp555_ = _tmp554_[0];
														if (g_strcmp0 (_tmp555_, "takes_ownership") == 0) {
															gchar** _tmp556_;
															gint _tmp556__length1;
															const gchar* _tmp557_;
															gchar* _tmp558_ = NULL;
															gchar* _tmp559_;
															gboolean _tmp560_;
															_tmp556_ = nv;
															_tmp556__length1 = nv_length1;
															_tmp557_ = _tmp556_[1];
															_tmp558_ = vala_gidl_parser_eval (self, _tmp557_);
															_tmp559_ = _tmp558_;
															_tmp560_ = g_strcmp0 (_tmp559_, "1") == 0;
															_g_free0 (_tmp559_);
															if (_tmp560_) {
																ValaDataType* _tmp561_;
																_tmp561_ = param_type;
																vala_data_type_set_value_owned (_tmp561_, TRUE);
															}
														} else {
															gchar** _tmp562_;
															gint _tmp562__length1;
															const gchar* _tmp563_;
															_tmp562_ = nv;
															_tmp562__length1 = nv_length1;
															_tmp563_ = _tmp562_[0];
															if (g_strcmp0 (_tmp563_, "value_owned") == 0) {
																gchar** _tmp564_;
																gint _tmp564__length1;
																const gchar* _tmp565_;
																gchar* _tmp566_ = NULL;
																gchar* _tmp567_;
																gboolean _tmp568_;
																_tmp564_ = nv;
																_tmp564__length1 = nv_length1;
																_tmp565_ = _tmp564_[1];
																_tmp566_ = vala_gidl_parser_eval (self, _tmp565_);
																_tmp567_ = _tmp566_;
																_tmp568_ = g_strcmp0 (_tmp567_, "0") == 0;
																_g_free0 (_tmp567_);
																if (_tmp568_) {
																	ValaDataType* _tmp569_;
																	_tmp569_ = param_type;
																	vala_data_type_set_value_owned (_tmp569_, FALSE);
																} else {
																	gchar** _tmp570_;
																	gint _tmp570__length1;
																	const gchar* _tmp571_;
																	gchar* _tmp572_ = NULL;
																	gchar* _tmp573_;
																	gboolean _tmp574_;
																	_tmp570_ = nv;
																	_tmp570__length1 = nv_length1;
																	_tmp571_ = _tmp570_[1];
																	_tmp572_ = vala_gidl_parser_eval (self, _tmp571_);
																	_tmp573_ = _tmp572_;
																	_tmp574_ = g_strcmp0 (_tmp573_, "1") == 0;
																	_g_free0 (_tmp573_);
																	if (_tmp574_) {
																		ValaDataType* _tmp575_;
																		_tmp575_ = param_type;
																		vala_data_type_set_value_owned (_tmp575_, TRUE);
																	}
																}
															} else {
																gchar** _tmp576_;
																gint _tmp576__length1;
																const gchar* _tmp577_;
																_tmp576_ = nv;
																_tmp576__length1 = nv_length1;
																_tmp577_ = _tmp576_[0];
																if (g_strcmp0 (_tmp577_, "hidden") == 0) {
																	gchar** _tmp578_;
																	gint _tmp578__length1;
																	const gchar* _tmp579_;
																	gchar* _tmp580_ = NULL;
																	gchar* _tmp581_;
																	gboolean _tmp582_;
																	_tmp578_ = nv;
																	_tmp578__length1 = nv_length1;
																	_tmp579_ = _tmp578_[1];
																	_tmp580_ = vala_gidl_parser_eval (self, _tmp579_);
																	_tmp581_ = _tmp580_;
																	_tmp582_ = g_strcmp0 (_tmp581_, "1") == 0;
																	_g_free0 (_tmp581_);
																	if (_tmp582_) {
																		hide_param = TRUE;
																	} else {
																		gchar** _tmp583_;
																		gint _tmp583__length1;
																		const gchar* _tmp584_;
																		gchar* _tmp585_ = NULL;
																		gchar* _tmp586_;
																		gboolean _tmp587_;
																		_tmp583_ = nv;
																		_tmp583__length1 = nv_length1;
																		_tmp584_ = _tmp583_[1];
																		_tmp585_ = vala_gidl_parser_eval (self, _tmp584_);
																		_tmp586_ = _tmp585_;
																		_tmp587_ = g_strcmp0 (_tmp586_, "0") == 0;
																		_g_free0 (_tmp586_);
																		if (_tmp587_) {
																			show_param = TRUE;
																		}
																	}
																} else {
																	gchar** _tmp588_;
																	gint _tmp588__length1;
																	const gchar* _tmp589_;
																	_tmp588_ = nv;
																	_tmp588__length1 = nv_length1;
																	_tmp589_ = _tmp588_[0];
																	if (g_strcmp0 (_tmp589_, "no_array_length") == 0) {
																		gchar** _tmp590_;
																		gint _tmp590__length1;
																		const gchar* _tmp591_;
																		gchar* _tmp592_ = NULL;
																		gchar* _tmp593_;
																		gboolean _tmp594_;
																		_tmp590_ = nv;
																		_tmp590__length1 = nv_length1;
																		_tmp591_ = _tmp590_[1];
																		_tmp592_ = vala_gidl_parser_eval (self, _tmp591_);
																		_tmp593_ = _tmp592_;
																		_tmp594_ = g_strcmp0 (_tmp593_, "1") == 0;
																		_g_free0 (_tmp593_);
																		if (_tmp594_) {
																			ValaParameter* _tmp595_;
																			_tmp595_ = p;
																			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp595_, "CCode", "array_length", FALSE, NULL);
																		}
																	} else {
																		gchar** _tmp596_;
																		gint _tmp596__length1;
																		const gchar* _tmp597_;
																		_tmp596_ = nv;
																		_tmp596__length1 = nv_length1;
																		_tmp597_ = _tmp596_[0];
																		if (g_strcmp0 (_tmp597_, "array_length_type") == 0) {
																			ValaParameter* _tmp598_;
																			gchar** _tmp599_;
																			gint _tmp599__length1;
																			const gchar* _tmp600_;
																			gchar* _tmp601_ = NULL;
																			gchar* _tmp602_;
																			_tmp598_ = p;
																			_tmp599_ = nv;
																			_tmp599__length1 = nv_length1;
																			_tmp600_ = _tmp599_[1];
																			_tmp601_ = vala_gidl_parser_eval (self, _tmp600_);
																			_tmp602_ = _tmp601_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp598_, "CCode", "array_length_type", _tmp602_, NULL);
																			_g_free0 (_tmp602_);
																		} else {
																			gchar** _tmp603_;
																			gint _tmp603__length1;
																			const gchar* _tmp604_;
																			_tmp603_ = nv;
																			_tmp603__length1 = nv_length1;
																			_tmp604_ = _tmp603_[0];
																			if (g_strcmp0 (_tmp604_, "array_null_terminated") == 0) {
																				gchar** _tmp605_;
																				gint _tmp605__length1;
																				const gchar* _tmp606_;
																				gchar* _tmp607_ = NULL;
																				gchar* _tmp608_;
																				gboolean _tmp609_;
																				_tmp605_ = nv;
																				_tmp605__length1 = nv_length1;
																				_tmp606_ = _tmp605_[1];
																				_tmp607_ = vala_gidl_parser_eval (self, _tmp606_);
																				_tmp608_ = _tmp607_;
																				_tmp609_ = g_strcmp0 (_tmp608_, "1") == 0;
																				_g_free0 (_tmp608_);
																				if (_tmp609_) {
																					ValaParameter* _tmp610_;
																					ValaParameter* _tmp611_;
																					_tmp610_ = p;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp610_, "CCode", "array_length", FALSE, NULL);
																					_tmp611_ = p;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp611_, "CCode", "array_null_terminated", TRUE, NULL);
																				}
																			} else {
																				gchar** _tmp612_;
																				gint _tmp612__length1;
																				const gchar* _tmp613_;
																				_tmp612_ = nv;
																				_tmp612__length1 = nv_length1;
																				_tmp613_ = _tmp612_[0];
																				if (g_strcmp0 (_tmp613_, "array_length_pos") == 0) {
																					gchar** _tmp614_;
																					gint _tmp614__length1;
																					const gchar* _tmp615_;
																					gchar* _tmp616_ = NULL;
																					gchar* _tmp617_;
																					gdouble _tmp618_ = 0.0;
																					set_array_length_pos = TRUE;
																					_tmp614_ = nv;
																					_tmp614__length1 = nv_length1;
																					_tmp615_ = _tmp614_[1];
																					_tmp616_ = vala_gidl_parser_eval (self, _tmp615_);
																					_tmp617_ = _tmp616_;
																					_tmp618_ = double_parse (_tmp617_);
																					array_length_pos = _tmp618_;
																					_g_free0 (_tmp617_);
																				} else {
																					gchar** _tmp619_;
																					gint _tmp619__length1;
																					const gchar* _tmp620_;
																					_tmp619_ = nv;
																					_tmp619__length1 = nv_length1;
																					_tmp620_ = _tmp619_[0];
																					if (g_strcmp0 (_tmp620_, "delegate_target_pos") == 0) {
																						gchar** _tmp621_;
																						gint _tmp621__length1;
																						const gchar* _tmp622_;
																						gchar* _tmp623_ = NULL;
																						gchar* _tmp624_;
																						gdouble _tmp625_ = 0.0;
																						set_delegate_target_pos = TRUE;
																						_tmp621_ = nv;
																						_tmp621__length1 = nv_length1;
																						_tmp622_ = _tmp621_[1];
																						_tmp623_ = vala_gidl_parser_eval (self, _tmp622_);
																						_tmp624_ = _tmp623_;
																						_tmp625_ = double_parse (_tmp624_);
																						delegate_target_pos = _tmp625_;
																						_g_free0 (_tmp624_);
																					} else {
																						gchar** _tmp626_;
																						gint _tmp626__length1;
																						const gchar* _tmp627_;
																						_tmp626_ = nv;
																						_tmp626__length1 = nv_length1;
																						_tmp627_ = _tmp626_[0];
																						if (g_strcmp0 (_tmp627_, "type_name") == 0) {
																							ValaParameter* _tmp628_;
																							gchar** _tmp629_;
																							gint _tmp629__length1;
																							const gchar* _tmp630_;
																							gchar* _tmp631_ = NULL;
																							gchar* _tmp632_;
																							ValaDataType* _tmp633_ = NULL;
																							ValaDataType* _tmp634_;
																							_tmp628_ = p;
																							_tmp629_ = nv;
																							_tmp629__length1 = nv_length1;
																							_tmp630_ = _tmp629_[1];
																							_tmp631_ = vala_gidl_parser_eval (self, _tmp630_);
																							_tmp632_ = _tmp631_;
																							_tmp633_ = vala_gidl_parser_parse_type_from_string (self, _tmp632_, FALSE, NULL);
																							_vala_code_node_unref0 (param_type);
																							param_type = _tmp633_;
																							_tmp634_ = param_type;
																							vala_variable_set_variable_type ((ValaVariable*) _tmp628_, _tmp634_);
																							_g_free0 (_tmp632_);
																						} else {
																							gchar** _tmp635_;
																							gint _tmp635__length1;
																							const gchar* _tmp636_;
																							_tmp635_ = nv;
																							_tmp635__length1 = nv_length1;
																							_tmp636_ = _tmp635_[0];
																							if (g_strcmp0 (_tmp636_, "ctype") == 0) {
																								ValaParameter* _tmp637_;
																								gchar** _tmp638_;
																								gint _tmp638__length1;
																								const gchar* _tmp639_;
																								gchar* _tmp640_ = NULL;
																								gchar* _tmp641_;
																								_tmp637_ = p;
																								_tmp638_ = nv;
																								_tmp638__length1 = nv_length1;
																								_tmp639_ = _tmp638_[1];
																								_tmp640_ = vala_gidl_parser_eval (self, _tmp639_);
																								_tmp641_ = _tmp640_;
																								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp637_, "CCode", "type", _tmp641_, NULL);
																								_g_free0 (_tmp641_);
																							} else {
																								gchar** _tmp642_;
																								gint _tmp642__length1;
																								const gchar* _tmp643_;
																								_tmp642_ = nv;
																								_tmp642__length1 = nv_length1;
																								_tmp643_ = _tmp642_[0];
																								if (g_strcmp0 (_tmp643_, "type_arguments") == 0) {
																									ValaDataType* _tmp644_;
																									gchar** _tmp645_;
																									gint _tmp645__length1;
																									const gchar* _tmp646_;
																									gchar* _tmp647_ = NULL;
																									gchar* _tmp648_;
																									_tmp644_ = param_type;
																									_tmp645_ = nv;
																									_tmp645__length1 = nv_length1;
																									_tmp646_ = _tmp645_[1];
																									_tmp647_ = vala_gidl_parser_eval (self, _tmp646_);
																									_tmp648_ = _tmp647_;
																									vala_gidl_parser_parse_type_arguments_from_string (self, _tmp644_, _tmp648_, NULL);
																									_g_free0 (_tmp648_);
																								} else {
																									gchar** _tmp649_;
																									gint _tmp649__length1;
																									const gchar* _tmp650_;
																									_tmp649_ = nv;
																									_tmp649__length1 = nv_length1;
																									_tmp650_ = _tmp649_[0];
																									if (g_strcmp0 (_tmp650_, "default_value") == 0) {
																										gchar** _tmp651_;
																										gint _tmp651__length1;
																										const gchar* _tmp652_;
																										gchar* _tmp653_ = NULL;
																										gchar* val;
																										const gchar* _tmp654_;
																										_tmp651_ = nv;
																										_tmp651__length1 = nv_length1;
																										_tmp652_ = _tmp651_[1];
																										_tmp653_ = vala_gidl_parser_eval (self, _tmp652_);
																										val = _tmp653_;
																										_tmp654_ = val;
																										if (g_strcmp0 (_tmp654_, "null") == 0) {
																											ValaParameter* _tmp655_;
																											ValaDataType* _tmp656_;
																											ValaSourceReference* _tmp657_;
																											ValaSourceReference* _tmp658_;
																											ValaNullLiteral* _tmp659_;
																											ValaNullLiteral* _tmp660_;
																											_tmp655_ = p;
																											_tmp656_ = param_type;
																											_tmp657_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp656_);
																											_tmp658_ = _tmp657_;
																											_tmp659_ = vala_null_literal_new (_tmp658_);
																											_tmp660_ = _tmp659_;
																											vala_variable_set_initializer ((ValaVariable*) _tmp655_, (ValaExpression*) _tmp660_);
																											_vala_code_node_unref0 (_tmp660_);
																										} else {
																											const gchar* _tmp661_;
																											_tmp661_ = val;
																											if (g_strcmp0 (_tmp661_, "true") == 0) {
																												ValaParameter* _tmp662_;
																												ValaDataType* _tmp663_;
																												ValaSourceReference* _tmp664_;
																												ValaSourceReference* _tmp665_;
																												ValaBooleanLiteral* _tmp666_;
																												ValaBooleanLiteral* _tmp667_;
																												_tmp662_ = p;
																												_tmp663_ = param_type;
																												_tmp664_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp663_);
																												_tmp665_ = _tmp664_;
																												_tmp666_ = vala_boolean_literal_new (TRUE, _tmp665_);
																												_tmp667_ = _tmp666_;
																												vala_variable_set_initializer ((ValaVariable*) _tmp662_, (ValaExpression*) _tmp667_);
																												_vala_code_node_unref0 (_tmp667_);
																											} else {
																												const gchar* _tmp668_;
																												_tmp668_ = val;
																												if (g_strcmp0 (_tmp668_, "false") == 0) {
																													ValaParameter* _tmp669_;
																													ValaDataType* _tmp670_;
																													ValaSourceReference* _tmp671_;
																													ValaSourceReference* _tmp672_;
																													ValaBooleanLiteral* _tmp673_;
																													ValaBooleanLiteral* _tmp674_;
																													_tmp669_ = p;
																													_tmp670_ = param_type;
																													_tmp671_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp670_);
																													_tmp672_ = _tmp671_;
																													_tmp673_ = vala_boolean_literal_new (FALSE, _tmp672_);
																													_tmp674_ = _tmp673_;
																													vala_variable_set_initializer ((ValaVariable*) _tmp669_, (ValaExpression*) _tmp674_);
																													_vala_code_node_unref0 (_tmp674_);
																												} else {
																													const gchar* _tmp675_;
																													_tmp675_ = val;
																													if (g_strcmp0 (_tmp675_, "") == 0) {
																														ValaParameter* _tmp676_;
																														ValaDataType* _tmp677_;
																														ValaSourceReference* _tmp678_;
																														ValaSourceReference* _tmp679_;
																														ValaStringLiteral* _tmp680_;
																														ValaStringLiteral* _tmp681_;
																														_tmp676_ = p;
																														_tmp677_ = param_type;
																														_tmp678_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp677_);
																														_tmp679_ = _tmp678_;
																														_tmp680_ = vala_string_literal_new ("\"\"", _tmp679_);
																														_tmp681_ = _tmp680_;
																														vala_variable_set_initializer ((ValaVariable*) _tmp676_, (ValaExpression*) _tmp681_);
																														_vala_code_node_unref0 (_tmp681_);
																													} else {
																														const gchar* _tmp682_;
																														gboolean _tmp683_ = FALSE;
																														_tmp682_ = val;
																														_tmp683_ = int64_try_parse (_tmp682_, NULL);
																														if (_tmp683_) {
																															ValaParameter* _tmp684_;
																															const gchar* _tmp685_;
																															ValaDataType* _tmp686_;
																															ValaSourceReference* _tmp687_;
																															ValaSourceReference* _tmp688_;
																															ValaIntegerLiteral* _tmp689_;
																															ValaIntegerLiteral* _tmp690_;
																															_tmp684_ = p;
																															_tmp685_ = val;
																															_tmp686_ = param_type;
																															_tmp687_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp686_);
																															_tmp688_ = _tmp687_;
																															_tmp689_ = vala_integer_literal_new (_tmp685_, _tmp688_);
																															_tmp690_ = _tmp689_;
																															vala_variable_set_initializer ((ValaVariable*) _tmp684_, (ValaExpression*) _tmp690_);
																															_vala_code_node_unref0 (_tmp690_);
																														} else {
																															const gchar* _tmp691_;
																															gboolean _tmp692_ = FALSE;
																															_tmp691_ = val;
																															_tmp692_ = double_try_parse (_tmp691_, NULL);
																															if (_tmp692_) {
																																ValaParameter* _tmp693_;
																																const gchar* _tmp694_;
																																ValaDataType* _tmp695_;
																																ValaSourceReference* _tmp696_;
																																ValaSourceReference* _tmp697_;
																																ValaRealLiteral* _tmp698_;
																																ValaRealLiteral* _tmp699_;
																																_tmp693_ = p;
																																_tmp694_ = val;
																																_tmp695_ = param_type;
																																_tmp696_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp695_);
																																_tmp697_ = _tmp696_;
																																_tmp698_ = vala_real_literal_new (_tmp694_, _tmp697_);
																																_tmp699_ = _tmp698_;
																																vala_variable_set_initializer ((ValaVariable*) _tmp693_, (ValaExpression*) _tmp699_);
																																_vala_code_node_unref0 (_tmp699_);
																															} else {
																																gboolean _tmp700_ = FALSE;
																																const gchar* _tmp701_;
																																gboolean _tmp702_ = FALSE;
																																gboolean _tmp705_;
																																_tmp701_ = val;
																																_tmp702_ = g_str_has_prefix (_tmp701_, "\"");
																																if (_tmp702_) {
																																	const gchar* _tmp703_;
																																	gboolean _tmp704_ = FALSE;
																																	_tmp703_ = val;
																																	_tmp704_ = g_str_has_suffix (_tmp703_, "\"");
																																	_tmp700_ = _tmp704_;
																																} else {
																																	_tmp700_ = FALSE;
																																}
																																_tmp705_ = _tmp700_;
																																if (_tmp705_) {
																																	ValaParameter* _tmp706_;
																																	const gchar* _tmp707_;
																																	ValaDataType* _tmp708_;
																																	ValaSourceReference* _tmp709_;
																																	ValaSourceReference* _tmp710_;
																																	ValaStringLiteral* _tmp711_;
																																	ValaStringLiteral* _tmp712_;
																																	_tmp706_ = p;
																																	_tmp707_ = val;
																																	_tmp708_ = param_type;
																																	_tmp709_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp708_);
																																	_tmp710_ = _tmp709_;
																																	_tmp711_ = vala_string_literal_new (_tmp707_, _tmp710_);
																																	_tmp712_ = _tmp711_;
																																	vala_variable_set_initializer ((ValaVariable*) _tmp706_, (ValaExpression*) _tmp712_);
																																	_vala_code_node_unref0 (_tmp712_);
																																} else {
																																	const gchar* _tmp713_;
																																	gchar** _tmp714_;
																																	gchar** _tmp715_ = NULL;
																																	_tmp713_ = val;
																																	_tmp715_ = _tmp714_ = g_strsplit (_tmp713_, ".", 0);
																																	{
																																		gchar** member_collection = NULL;
																																		gint member_collection_length1 = 0;
																																		gint _member_collection_size_ = 0;
																																		gint member_it = 0;
																																		member_collection = _tmp715_;
																																		member_collection_length1 = _vala_array_length (_tmp714_);
																																		for (member_it = 0; member_it < _vala_array_length (_tmp714_); member_it = member_it + 1) {
																																			gchar* _tmp716_;
																																			gchar* member = NULL;
																																			_tmp716_ = g_strdup (member_collection[member_it]);
																																			member = _tmp716_;
																																			{
																																				ValaParameter* _tmp717_;
																																				ValaParameter* _tmp718_;
																																				ValaExpression* _tmp719_;
																																				ValaExpression* _tmp720_;
																																				const gchar* _tmp721_;
																																				ValaDataType* _tmp722_;
																																				ValaSourceReference* _tmp723_;
																																				ValaSourceReference* _tmp724_;
																																				ValaMemberAccess* _tmp725_;
																																				ValaMemberAccess* _tmp726_;
																																				_tmp717_ = p;
																																				_tmp718_ = p;
																																				_tmp719_ = vala_variable_get_initializer ((ValaVariable*) _tmp718_);
																																				_tmp720_ = _tmp719_;
																																				_tmp721_ = member;
																																				_tmp722_ = param_type;
																																				_tmp723_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp722_);
																																				_tmp724_ = _tmp723_;
																																				_tmp725_ = vala_member_access_new (_tmp720_, _tmp721_, _tmp724_);
																																				_tmp726_ = _tmp725_;
																																				vala_variable_set_initializer ((ValaVariable*) _tmp717_, (ValaExpression*) _tmp726_);
																																				_vala_code_node_unref0 (_tmp726_);
																																				_g_free0 (member);
																																			}
																																		}
																																		member_collection = (_vala_array_free (member_collection, member_collection_length1, (GDestroyNotify) g_free), NULL);
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																										_g_free0 (val);
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp728_ = last_param;
				if (_tmp728_ != NULL) {
					ValaParameter* _tmp729_;
					const gchar* _tmp730_;
					const gchar* _tmp731_;
					ValaParameter* _tmp732_;
					const gchar* _tmp733_;
					const gchar* _tmp734_;
					gchar* _tmp735_;
					gchar* _tmp736_;
					_tmp729_ = p;
					_tmp730_ = vala_symbol_get_name ((ValaSymbol*) _tmp729_);
					_tmp731_ = _tmp730_;
					_tmp732_ = last_param;
					_tmp733_ = vala_symbol_get_name ((ValaSymbol*) _tmp732_);
					_tmp734_ = _tmp733_;
					_tmp735_ = g_strconcat ("n_", _tmp734_, NULL);
					_tmp736_ = _tmp735_;
					_tmp727_ = g_strcmp0 (_tmp731_, _tmp736_) == 0;
					_g_free0 (_tmp736_);
				} else {
					_tmp727_ = FALSE;
				}
				_tmp737_ = _tmp727_;
				if (_tmp737_) {
					ValaDataType* _tmp738_;
					_tmp738_ = last_param_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp738_, VALA_TYPE_ARRAY_TYPE)) {
						ValaDataType* _tmp739_;
						ValaDataType* _tmp740_;
						ValaSourceReference* _tmp741_;
						ValaSourceReference* _tmp742_;
						ValaArrayType* _tmp743_;
						ValaParameter* _tmp744_;
						ValaDataType* _tmp745_;
						ValaParameter* _tmp746_;
						_tmp739_ = last_param_type;
						_tmp740_ = last_param_type;
						_tmp741_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp740_);
						_tmp742_ = _tmp741_;
						_tmp743_ = vala_array_type_new (_tmp739_, 1, _tmp742_);
						_vala_code_node_unref0 (last_param_type);
						last_param_type = (ValaDataType*) _tmp743_;
						_tmp744_ = last_param;
						_tmp745_ = last_param_type;
						vala_variable_set_variable_type ((ValaVariable*) _tmp744_, _tmp745_);
						_tmp746_ = last_param;
						vala_parameter_set_direction (_tmp746_, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp747_ = FALSE;
					ValaParameter* _tmp748_;
					gboolean _tmp752_;
					_tmp748_ = last_param;
					if (_tmp748_ != NULL) {
						ValaParameter* _tmp749_;
						const gchar* _tmp750_;
						const gchar* _tmp751_;
						_tmp749_ = p;
						_tmp750_ = vala_symbol_get_name ((ValaSymbol*) _tmp749_);
						_tmp751_ = _tmp750_;
						_tmp747_ = g_strcmp0 (_tmp751_, "user_data") == 0;
					} else {
						_tmp747_ = FALSE;
					}
					_tmp752_ = _tmp747_;
					if (_tmp752_) {
						hide_param = TRUE;
					}
				}
				_tmp754_ = show_param;
				if (_tmp754_) {
					_tmp753_ = TRUE;
				} else {
					gboolean _tmp755_;
					_tmp755_ = hide_param;
					_tmp753_ = !_tmp755_;
				}
				_tmp756_ = _tmp753_;
				if (_tmp756_) {
					ValaMethod* _tmp757_;
					ValaParameter* _tmp758_;
					gboolean _tmp759_;
					gboolean _tmp762_;
					_tmp757_ = m;
					_tmp758_ = p;
					vala_method_add_parameter (_tmp757_, _tmp758_);
					_tmp759_ = set_array_length_pos;
					if (_tmp759_) {
						ValaParameter* _tmp760_;
						gdouble _tmp761_;
						_tmp760_ = p;
						_tmp761_ = array_length_pos;
						vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp760_, "CCode", "array_length_pos", _tmp761_, NULL);
					}
					_tmp762_ = set_delegate_target_pos;
					if (_tmp762_) {
						ValaParameter* _tmp763_;
						gdouble _tmp764_;
						_tmp763_ = p;
						_tmp764_ = delegate_target_pos;
						vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp763_, "CCode", "delegate_target_pos", _tmp764_, NULL);
					}
				}
				_tmp765_ = p;
				_tmp766_ = _vala_code_node_ref0 (_tmp765_);
				_vala_code_node_unref0 (last_param);
				last_param = _tmp766_;
				_tmp767_ = param_type;
				_tmp768_ = _vala_code_node_ref0 (_tmp767_);
				_vala_code_node_unref0 (last_param_type);
				last_param_type = _tmp768_;
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	_tmp770_ = suppress_throws;
	if (_tmp770_ == FALSE) {
		const gchar* _tmp771_;
		_tmp771_ = error_types;
		_tmp769_ = _tmp771_ != NULL;
	} else {
		_tmp769_ = FALSE;
	}
	_tmp772_ = _tmp769_;
	if (_tmp772_) {
		const gchar* _tmp773_;
		gchar* _tmp774_ = NULL;
		gchar* _tmp775_;
		gchar** _tmp776_;
		gchar** _tmp777_ = NULL;
		gchar** _tmp778_;
		gint _tmp778__length1;
		gchar** type_args;
		gint type_args_length1;
		gint _type_args_size_;
		gchar** _tmp779_;
		gint _tmp779__length1;
		_tmp773_ = error_types;
		_tmp774_ = vala_gidl_parser_eval (self, _tmp773_);
		_tmp775_ = _tmp774_;
		_tmp777_ = _tmp776_ = g_strsplit (_tmp775_, ",", 0);
		_tmp778_ = _tmp777_;
		_tmp778__length1 = _vala_array_length (_tmp776_);
		_g_free0 (_tmp775_);
		type_args = _tmp778_;
		type_args_length1 = _tmp778__length1;
		_type_args_size_ = type_args_length1;
		_tmp779_ = type_args;
		_tmp779__length1 = type_args_length1;
		{
			gchar** type_arg_collection = NULL;
			gint type_arg_collection_length1 = 0;
			gint _type_arg_collection_size_ = 0;
			gint type_arg_it = 0;
			type_arg_collection = _tmp779_;
			type_arg_collection_length1 = _tmp779__length1;
			for (type_arg_it = 0; type_arg_it < _tmp779__length1; type_arg_it = type_arg_it + 1) {
				gchar* _tmp780_;
				gchar* type_arg = NULL;
				_tmp780_ = g_strdup (type_arg_collection[type_arg_it]);
				type_arg = _tmp780_;
				{
					ValaMethod* _tmp781_;
					const gchar* _tmp782_;
					ValaDataType* _tmp783_ = NULL;
					ValaDataType* _tmp784_;
					_tmp781_ = m;
					_tmp782_ = type_arg;
					_tmp783_ = vala_gidl_parser_parse_type_from_string (self, _tmp782_, TRUE, NULL);
					_tmp784_ = _tmp783_;
					vala_code_node_add_error_type ((ValaCodeNode*) _tmp781_, _tmp784_);
					_vala_code_node_unref0 (_tmp784_);
					_g_free0 (type_arg);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp785_ = first;
	if (_tmp785_) {
		ValaMethod* _tmp786_;
		_tmp786_ = m;
		vala_method_set_binding (_tmp786_, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp788_ = last_param;
	if (_tmp788_ != NULL) {
		ValaParameter* _tmp789_;
		const gchar* _tmp790_;
		const gchar* _tmp791_;
		gboolean _tmp792_ = FALSE;
		_tmp789_ = last_param;
		_tmp790_ = vala_symbol_get_name ((ValaSymbol*) _tmp789_);
		_tmp791_ = _tmp790_;
		_tmp792_ = g_str_has_prefix (_tmp791_, "first_");
		_tmp787_ = _tmp792_;
	} else {
		_tmp787_ = FALSE;
	}
	_tmp793_ = _tmp787_;
	if (_tmp793_) {
		ValaParameter* _tmp794_;
		_tmp794_ = last_param;
		vala_parameter_set_ellipsis (_tmp794_, TRUE);
	} else {
		gboolean _tmp795_;
		_tmp795_ = add_ellipsis;
		if (_tmp795_) {
			ValaMethod* _tmp796_;
			ValaParameter* _tmp797_;
			ValaParameter* _tmp798_;
			_tmp796_ = m;
			_tmp797_ = vala_parameter_new_with_ellipsis (NULL);
			_tmp798_ = _tmp797_;
			vala_method_add_parameter (_tmp796_, _tmp798_);
			_vala_code_node_unref0 (_tmp798_);
		}
	}
	_tmp799_ = container;
	if (_tmp799_ == NULL) {
		ValaTypeSymbol* _tmp800_;
		ValaSymbol* _tmp801_;
		ValaSymbol* _tmp802_;
		_tmp800_ = self->priv->current_data_type;
		_tmp801_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp800_);
		_vala_code_node_unref0 (container);
		container = _tmp801_;
		_tmp802_ = container;
		if (_tmp802_ == NULL) {
			ValaNamespace* _tmp803_;
			ValaSymbol* _tmp804_;
			_tmp803_ = self->priv->current_namespace;
			_tmp804_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp803_);
			_vala_code_node_unref0 (container);
			container = _tmp804_;
		}
	}
	_tmp805_ = symbol;
	_tmp806_ = m;
	_tmp807_ = container;
	_tmp808_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp806_, _tmp807_);
	_tmp809_ = _tmp808_;
	_tmp810_ = g_strcmp0 (_tmp805_, _tmp809_) != 0;
	_g_free0 (_tmp809_);
	if (_tmp810_) {
		ValaMethod* _tmp811_;
		const gchar* _tmp812_;
		_tmp811_ = m;
		_tmp812_ = symbol;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp811_, "CCode", "cname", _tmp812_, NULL);
	}
	result = m;
	_vala_code_node_unref0 (last_param_type);
	_vala_code_node_unref0 (last_param);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (container);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchomp (_tmp1_);
	result = _result_;
	return result;
}


static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param) {
	gboolean result = FALSE;
	GIdlNodeParam* _tmp0_;
	GIdlNodeType* _tmp1_;
	gboolean _tmp2_;
	GIdlNodeParam* _tmp3_;
	GIdlNodeType* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* s;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	_tmp0_ = param;
	_tmp1_ = _tmp0_->type;
	_tmp2_ = _tmp1_->is_error;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = param;
	_tmp4_ = _tmp3_->type;
	_tmp5_ = _tmp4_->unparsed;
	_tmp6_ = string_chomp (_tmp5_);
	s = _tmp6_;
	_tmp7_ = s;
	_tmp8_ = g_str_has_suffix (_tmp7_, "**");
	if (_tmp8_) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNodeFunction* _tmp0_;
	GIdlNode* node;
	GIdlNodeFunction* _tmp1_;
	gboolean _tmp2_;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	GIdlNodeFunction* _tmp5_;
	const gchar* _tmp6_;
	GIdlNodeFunction* _tmp7_;
	GIdlNodeParam* _tmp8_;
	GIdlNodeFunction* _tmp9_;
	GList* _tmp10_;
	GIdlNodeFunction* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	ValaMethod* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	_tmp0_ = f;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = f;
	_tmp2_ = _tmp1_->deprecated;
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = f;
	_tmp6_ = _tmp5_->symbol;
	_tmp7_ = f;
	_tmp8_ = _tmp7_->result;
	_tmp9_ = f;
	_tmp10_ = _tmp9_->parameters;
	_tmp11_ = f;
	_tmp12_ = _tmp11_->is_constructor;
	_tmp13_ = is_interface;
	_tmp14_ = vala_gidl_parser_create_method (self, _tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp12_, _tmp13_);
	result = _tmp14_;
	return result;
}


static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNodeVFunc* _tmp0_;
	GIdlNode* node;
	ValaTypeSymbol* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GIdlNode* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* symbol;
	GIdlNodeFunction* _tmp8_;
	GList* _tmp12_ = NULL;
	GIdlNodeFunction* _tmp13_;
	GIdlNode* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GIdlNodeVFunc* _tmp21_;
	GIdlNodeParam* _tmp22_;
	GList* _tmp23_;
	gboolean _tmp24_;
	ValaMethod* _tmp25_ = NULL;
	ValaMethod* m;
	ValaMethod* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = v;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = self->priv->current_data_type;
	_tmp2_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = g_strdup_printf ("%s%s", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	symbol = _tmp7_;
	_tmp8_ = func;
	if (_tmp8_ != NULL) {
		GIdlNodeFunction* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = func;
		_tmp10_ = _tmp9_->symbol;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (symbol);
		symbol = _tmp11_;
	}
	_tmp13_ = func;
	if (_tmp13_ != NULL) {
		GIdlNodeFunction* _tmp14_;
		GList* _tmp15_;
		_tmp14_ = func;
		_tmp15_ = _tmp14_->parameters;
		_tmp12_ = _tmp15_;
	} else {
		GIdlNodeVFunc* _tmp16_;
		GList* _tmp17_;
		_tmp16_ = v;
		_tmp17_ = _tmp16_->parameters;
		_tmp12_ = _tmp17_;
	}
	_tmp18_ = node;
	_tmp19_ = _tmp18_->name;
	_tmp20_ = symbol;
	_tmp21_ = v;
	_tmp22_ = _tmp21_->result;
	_tmp23_ = _tmp12_;
	_tmp24_ = is_interface;
	_tmp25_ = vala_gidl_parser_create_method (self, _tmp19_, _tmp20_, _tmp22_, _tmp23_, FALSE, _tmp24_);
	m = _tmp25_;
	_tmp26_ = m;
	if (_tmp26_ != NULL) {
		ValaMethod* _tmp27_;
		gboolean _tmp28_ = FALSE;
		ValaMethod* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		ValaMethod* _tmp33_;
		gboolean _tmp34_;
		gboolean _tmp35_ = FALSE;
		ValaMethod* _tmp36_;
		gboolean _tmp37_;
		gboolean _tmp38_;
		ValaMethod* _tmp40_;
		gboolean _tmp41_;
		const gchar* _tmp42_;
		gint _tmp43_ = 0;
		gchar** _tmp44_ = NULL;
		gchar** attributes;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		GIdlNodeFunction* _tmp62_;
		_tmp27_ = m;
		vala_method_set_binding (_tmp27_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp29_ = m;
		_tmp30_ = vala_method_get_is_abstract (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_) {
			_tmp28_ = TRUE;
		} else {
			gboolean _tmp32_;
			_tmp32_ = is_interface;
			_tmp28_ = _tmp32_;
		}
		_tmp33_ = m;
		_tmp34_ = _tmp28_;
		vala_method_set_is_virtual (_tmp33_, !_tmp34_);
		_tmp36_ = m;
		_tmp37_ = vala_method_get_is_abstract (_tmp36_);
		_tmp38_ = _tmp37_;
		if (_tmp38_) {
			_tmp35_ = TRUE;
		} else {
			gboolean _tmp39_;
			_tmp39_ = is_interface;
			_tmp35_ = _tmp39_;
		}
		_tmp40_ = m;
		_tmp41_ = _tmp35_;
		vala_method_set_is_abstract (_tmp40_, _tmp41_);
		_tmp42_ = symbol;
		_tmp44_ = vala_gidl_parser_get_attributes (self, _tmp42_, &_tmp43_);
		attributes = _tmp44_;
		attributes_length1 = _tmp43_;
		_attributes_size_ = attributes_length1;
		_tmp45_ = attributes;
		_tmp45__length1 = attributes_length1;
		if (_tmp45_ != NULL) {
			gchar** _tmp46_;
			gint _tmp46__length1;
			_tmp46_ = attributes;
			_tmp46__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp46_;
				attr_collection_length1 = _tmp46__length1;
				for (attr_it = 0; attr_it < _tmp46__length1; attr_it = attr_it + 1) {
					gchar* _tmp47_;
					gchar* attr = NULL;
					_tmp47_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp47_;
					{
						const gchar* _tmp48_;
						gchar** _tmp49_;
						gchar** _tmp50_ = NULL;
						gchar** nv;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp51_;
						gint _tmp51__length1;
						const gchar* _tmp52_;
						_tmp48_ = attr;
						_tmp50_ = _tmp49_ = g_strsplit (_tmp48_, "=", 2);
						nv = _tmp50_;
						nv_length1 = _vala_array_length (_tmp49_);
						_nv_size_ = nv_length1;
						_tmp51_ = nv;
						_tmp51__length1 = nv_length1;
						_tmp52_ = _tmp51_[0];
						if (g_strcmp0 (_tmp52_, "virtual") == 0) {
							gchar** _tmp53_;
							gint _tmp53__length1;
							const gchar* _tmp54_;
							gchar* _tmp55_ = NULL;
							gchar* _tmp56_;
							gboolean _tmp57_;
							_tmp53_ = nv;
							_tmp53__length1 = nv_length1;
							_tmp54_ = _tmp53_[1];
							_tmp55_ = vala_gidl_parser_eval (self, _tmp54_);
							_tmp56_ = _tmp55_;
							_tmp57_ = g_strcmp0 (_tmp56_, "0") == 0;
							_g_free0 (_tmp56_);
							if (_tmp57_) {
								ValaMethod* _tmp58_;
								ValaMethod* _tmp59_;
								_tmp58_ = m;
								vala_method_set_is_virtual (_tmp58_, FALSE);
								_tmp59_ = m;
								vala_method_set_is_abstract (_tmp59_, FALSE);
							} else {
								ValaMethod* _tmp60_;
								ValaMethod* _tmp61_;
								_tmp60_ = m;
								vala_method_set_is_virtual (_tmp60_, TRUE);
								_tmp61_ = m;
								vala_method_set_is_abstract (_tmp61_, FALSE);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp62_ = func;
		if (_tmp62_ == NULL) {
			ValaMethod* _tmp63_;
			_tmp63_ = m;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp63_, "NoWrapper", TRUE, NULL);
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}


static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* str;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* i;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	i = _tmp2_;
	while (TRUE) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		const gchar* _tmp6_;
		gunichar _tmp7_ = 0U;
		gunichar c;
		gunichar _tmp8_;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp3_ = i;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!(_tmp5_ > 0)) {
			break;
		}
		_tmp6_ = i;
		_tmp7_ = string_get_char (_tmp6_, (glong) 0);
		c = _tmp7_;
		_tmp8_ = c;
		if (_tmp8_ == ((gunichar) '-')) {
			GString* _tmp9_;
			_tmp9_ = str;
			g_string_append_c (_tmp9_, '_');
		} else {
			GString* _tmp10_;
			gunichar _tmp11_;
			_tmp10_ = str;
			_tmp11_ = c;
			g_string_append_unichar (_tmp10_, _tmp11_);
		}
		_tmp12_ = i;
		_tmp13_ = g_utf8_next_char (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (i);
		i = _tmp14_;
	}
	_tmp15_ = str;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node) {
	ValaProperty* result = NULL;
	GIdlNodeProperty* _tmp0_;
	GIdlNode* node;
	GIdlNodeProperty* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	GIdlNodeProperty* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	GIdlNode* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GIdlNodeProperty* _tmp15_;
	GIdlNodeType* _tmp16_;
	ValaDataType* _tmp17_ = NULL;
	ValaDataType* _tmp18_;
	ValaSourceReference* _tmp19_;
	ValaProperty* _tmp20_;
	ValaProperty* _tmp21_;
	ValaProperty* prop;
	ValaProperty* _tmp22_;
	ValaProperty* _tmp23_;
	gboolean _tmp24_ = FALSE;
	GIdlNodeProperty* _tmp25_;
	GIdlNodeType* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp31_;
	GIdlNodeProperty* _tmp34_;
	gboolean _tmp35_;
	GIdlNodeProperty* _tmp44_;
	gboolean _tmp45_;
	ValaTypeSymbol* _tmp67_;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_;
	GIdlNode* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_ = NULL;
	gchar* _tmp73_;
	gint _tmp74_ = 0;
	gchar** _tmp75_ = NULL;
	gchar** _tmp76_;
	gint _tmp76__length1;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp77_;
	gint _tmp77__length1;
	ValaSet* _tmp176_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	_tmp0_ = prop_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = prop_node;
	_tmp2_ = _tmp1_->deprecated;
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp4_ = prop_node;
	_tmp5_ = _tmp4_->readable;
	if (!_tmp5_) {
		GIdlNodeProperty* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = prop_node;
		_tmp7_ = _tmp6_->writable;
		_tmp3_ = !_tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		GIdlNodeProperty* _tmp9_;
		GIdlNodeProperty* _tmp10_;
		_tmp9_ = prop_node;
		_tmp9_->readable = TRUE;
		_tmp10_ = prop_node;
		_tmp10_->writable = TRUE;
	}
	_tmp11_ = node;
	_tmp12_ = _tmp11_->name;
	_tmp13_ = vala_gidl_parser_fix_prop_name (self, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = prop_node;
	_tmp16_ = _tmp15_->type;
	_tmp17_ = vala_gidl_parser_parse_type (self, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->current_source_reference;
	_tmp20_ = vala_property_new (_tmp14_, _tmp18_, NULL, NULL, _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_vala_code_node_unref0 (_tmp18_);
	_g_free0 (_tmp14_);
	prop = _tmp21_;
	_tmp22_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp22_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp23_ = prop;
	vala_property_set_interface_only (_tmp23_, TRUE);
	_tmp25_ = prop_node;
	_tmp26_ = _tmp25_->type;
	_tmp27_ = _tmp26_->is_interface;
	if (_tmp27_) {
		GIdlNodeProperty* _tmp28_;
		GIdlNodeType* _tmp29_;
		const gchar* _tmp30_;
		_tmp28_ = prop_node;
		_tmp29_ = _tmp28_->type;
		_tmp30_ = _tmp29_->interface;
		_tmp24_ = g_strcmp0 (_tmp30_, "GStrv") == 0;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp31_ = _tmp24_;
	if (_tmp31_) {
		ValaProperty* _tmp32_;
		ValaProperty* _tmp33_;
		_tmp32_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp32_, "CCode", "array_length", FALSE, NULL);
		_tmp33_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp33_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp34_ = prop_node;
	_tmp35_ = _tmp34_->readable;
	if (_tmp35_) {
		ValaProperty* _tmp36_;
		ValaProperty* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_ = NULL;
		ValaDataType* _tmp41_;
		ValaPropertyAccessor* _tmp42_;
		ValaPropertyAccessor* _tmp43_;
		_tmp36_ = prop;
		_tmp37_ = prop;
		_tmp38_ = vala_property_get_property_type (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp41_, NULL, NULL, NULL);
		_tmp43_ = _tmp42_;
		vala_property_set_get_accessor (_tmp36_, _tmp43_);
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp41_);
	}
	_tmp44_ = prop_node;
	_tmp45_ = _tmp44_->writable;
	if (_tmp45_) {
		ValaProperty* _tmp46_;
		ValaProperty* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaDataType* _tmp50_ = NULL;
		ValaDataType* _tmp51_;
		ValaPropertyAccessor* _tmp52_;
		ValaPropertyAccessor* _tmp53_;
		GIdlNodeProperty* _tmp54_;
		gboolean _tmp55_;
		_tmp46_ = prop;
		_tmp47_ = prop;
		_tmp48_ = vala_property_get_property_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_data_type_copy (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_property_accessor_new (FALSE, FALSE, FALSE, _tmp51_, NULL, NULL, NULL);
		_tmp53_ = _tmp52_;
		vala_property_set_set_accessor (_tmp46_, _tmp53_);
		_vala_code_node_unref0 (_tmp53_);
		_vala_code_node_unref0 (_tmp51_);
		_tmp54_ = prop_node;
		_tmp55_ = _tmp54_->construct_only;
		if (_tmp55_) {
			ValaProperty* _tmp56_;
			ValaPropertyAccessor* _tmp57_;
			ValaPropertyAccessor* _tmp58_;
			_tmp56_ = prop;
			_tmp57_ = vala_property_get_set_accessor (_tmp56_);
			_tmp58_ = _tmp57_;
			vala_property_accessor_set_construction (_tmp58_, TRUE);
		} else {
			ValaProperty* _tmp59_;
			ValaPropertyAccessor* _tmp60_;
			ValaPropertyAccessor* _tmp61_;
			ValaProperty* _tmp62_;
			ValaPropertyAccessor* _tmp63_;
			ValaPropertyAccessor* _tmp64_;
			GIdlNodeProperty* _tmp65_;
			gboolean _tmp66_;
			_tmp59_ = prop;
			_tmp60_ = vala_property_get_set_accessor (_tmp59_);
			_tmp61_ = _tmp60_;
			vala_property_accessor_set_writable (_tmp61_, TRUE);
			_tmp62_ = prop;
			_tmp63_ = vala_property_get_set_accessor (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = prop_node;
			_tmp66_ = _tmp65_->construct;
			vala_property_accessor_set_construction (_tmp64_, _tmp66_);
		}
	}
	_tmp67_ = self->priv->current_data_type;
	_tmp68_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp67_, NULL);
	_tmp69_ = _tmp68_;
	_tmp70_ = node;
	_tmp71_ = _tmp70_->name;
	_tmp72_ = g_strdup_printf ("%s:%s", _tmp69_, _tmp71_);
	_tmp73_ = _tmp72_;
	_tmp75_ = vala_gidl_parser_get_attributes (self, _tmp73_, &_tmp74_);
	_tmp76_ = _tmp75_;
	_tmp76__length1 = _tmp74_;
	_g_free0 (_tmp73_);
	_g_free0 (_tmp69_);
	attributes = _tmp76_;
	attributes_length1 = _tmp76__length1;
	_attributes_size_ = attributes_length1;
	_tmp77_ = attributes;
	_tmp77__length1 = attributes_length1;
	if (_tmp77_ != NULL) {
		gchar** _tmp78_;
		gint _tmp78__length1;
		_tmp78_ = attributes;
		_tmp78__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp78_;
			attr_collection_length1 = _tmp78__length1;
			for (attr_it = 0; attr_it < _tmp78__length1; attr_it = attr_it + 1) {
				gchar* _tmp79_;
				gchar* attr = NULL;
				_tmp79_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp79_;
				{
					const gchar* _tmp80_;
					gchar** _tmp81_;
					gchar** _tmp82_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp83_;
					gint _tmp83__length1;
					const gchar* _tmp84_;
					_tmp80_ = attr;
					_tmp82_ = _tmp81_ = g_strsplit (_tmp80_, "=", 2);
					nv = _tmp82_;
					nv_length1 = _vala_array_length (_tmp81_);
					_nv_size_ = nv_length1;
					_tmp83_ = nv;
					_tmp83__length1 = nv_length1;
					_tmp84_ = _tmp83_[0];
					if (g_strcmp0 (_tmp84_, "hidden") == 0) {
						gchar** _tmp85_;
						gint _tmp85__length1;
						const gchar* _tmp86_;
						gchar* _tmp87_ = NULL;
						gchar* _tmp88_;
						gboolean _tmp89_;
						_tmp85_ = nv;
						_tmp85__length1 = nv_length1;
						_tmp86_ = _tmp85_[1];
						_tmp87_ = vala_gidl_parser_eval (self, _tmp86_);
						_tmp88_ = _tmp87_;
						_tmp89_ = g_strcmp0 (_tmp88_, "1") == 0;
						_g_free0 (_tmp88_);
						if (_tmp89_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						gchar** _tmp90_;
						gint _tmp90__length1;
						const gchar* _tmp91_;
						_tmp90_ = nv;
						_tmp90__length1 = nv_length1;
						_tmp91_ = _tmp90_[0];
						if (g_strcmp0 (_tmp91_, "type_arguments") == 0) {
							ValaProperty* _tmp92_;
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							gchar** _tmp95_;
							gint _tmp95__length1;
							const gchar* _tmp96_;
							gchar* _tmp97_ = NULL;
							gchar* _tmp98_;
							_tmp92_ = prop;
							_tmp93_ = vala_property_get_property_type (_tmp92_);
							_tmp94_ = _tmp93_;
							_tmp95_ = nv;
							_tmp95__length1 = nv_length1;
							_tmp96_ = _tmp95_[1];
							_tmp97_ = vala_gidl_parser_eval (self, _tmp96_);
							_tmp98_ = _tmp97_;
							vala_gidl_parser_parse_type_arguments_from_string (self, _tmp94_, _tmp98_, NULL);
							_g_free0 (_tmp98_);
						} else {
							gchar** _tmp99_;
							gint _tmp99__length1;
							const gchar* _tmp100_;
							_tmp99_ = nv;
							_tmp99__length1 = nv_length1;
							_tmp100_ = _tmp99_[0];
							if (g_strcmp0 (_tmp100_, "deprecated") == 0) {
								gchar** _tmp101_;
								gint _tmp101__length1;
								const gchar* _tmp102_;
								gchar* _tmp103_ = NULL;
								gchar* _tmp104_;
								gboolean _tmp105_;
								_tmp101_ = nv;
								_tmp101__length1 = nv_length1;
								_tmp102_ = _tmp101_[1];
								_tmp103_ = vala_gidl_parser_eval (self, _tmp102_);
								_tmp104_ = _tmp103_;
								_tmp105_ = g_strcmp0 (_tmp104_, "1") == 0;
								_g_free0 (_tmp104_);
								if (_tmp105_) {
									ValaProperty* _tmp106_;
									_tmp106_ = prop;
									vala_code_node_set_attribute ((ValaCodeNode*) _tmp106_, "Deprecated", TRUE, NULL);
								}
							} else {
								gchar** _tmp107_;
								gint _tmp107__length1;
								const gchar* _tmp108_;
								_tmp107_ = nv;
								_tmp107__length1 = nv_length1;
								_tmp108_ = _tmp107_[0];
								if (g_strcmp0 (_tmp108_, "replacement") == 0) {
									ValaProperty* _tmp109_;
									gchar** _tmp110_;
									gint _tmp110__length1;
									const gchar* _tmp111_;
									gchar* _tmp112_ = NULL;
									gchar* _tmp113_;
									_tmp109_ = prop;
									_tmp110_ = nv;
									_tmp110__length1 = nv_length1;
									_tmp111_ = _tmp110_[1];
									_tmp112_ = vala_gidl_parser_eval (self, _tmp111_);
									_tmp113_ = _tmp112_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp109_, "Deprecated", "replacement", _tmp113_, NULL);
									_g_free0 (_tmp113_);
								} else {
									gchar** _tmp114_;
									gint _tmp114__length1;
									const gchar* _tmp115_;
									_tmp114_ = nv;
									_tmp114__length1 = nv_length1;
									_tmp115_ = _tmp114_[0];
									if (g_strcmp0 (_tmp115_, "deprecated_since") == 0) {
										ValaProperty* _tmp116_;
										gchar** _tmp117_;
										gint _tmp117__length1;
										const gchar* _tmp118_;
										gchar* _tmp119_ = NULL;
										gchar* _tmp120_;
										_tmp116_ = prop;
										_tmp117_ = nv;
										_tmp117__length1 = nv_length1;
										_tmp118_ = _tmp117_[1];
										_tmp119_ = vala_gidl_parser_eval (self, _tmp118_);
										_tmp120_ = _tmp119_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp116_, "Deprecated", "since", _tmp120_, NULL);
										_g_free0 (_tmp120_);
									} else {
										gchar** _tmp121_;
										gint _tmp121__length1;
										const gchar* _tmp122_;
										_tmp121_ = nv;
										_tmp121__length1 = nv_length1;
										_tmp122_ = _tmp121_[0];
										if (g_strcmp0 (_tmp122_, "accessor_method") == 0) {
											gchar** _tmp123_;
											gint _tmp123__length1;
											const gchar* _tmp124_;
											gchar* _tmp125_ = NULL;
											gchar* _tmp126_;
											gboolean _tmp127_;
											_tmp123_ = nv;
											_tmp123__length1 = nv_length1;
											_tmp124_ = _tmp123_[1];
											_tmp125_ = vala_gidl_parser_eval (self, _tmp124_);
											_tmp126_ = _tmp125_;
											_tmp127_ = g_strcmp0 (_tmp126_, "0") == 0;
											_g_free0 (_tmp126_);
											if (_tmp127_) {
												ValaProperty* _tmp128_;
												_tmp128_ = prop;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp128_, "NoAccessorMethod", TRUE, NULL);
											}
										} else {
											gchar** _tmp129_;
											gint _tmp129__length1;
											const gchar* _tmp130_;
											_tmp129_ = nv;
											_tmp129__length1 = nv_length1;
											_tmp130_ = _tmp129_[0];
											if (g_strcmp0 (_tmp130_, "owned_get") == 0) {
												gchar** _tmp131_;
												gint _tmp131__length1;
												const gchar* _tmp132_;
												gchar* _tmp133_ = NULL;
												gchar* _tmp134_;
												gboolean _tmp135_;
												_tmp131_ = nv;
												_tmp131__length1 = nv_length1;
												_tmp132_ = _tmp131_[1];
												_tmp133_ = vala_gidl_parser_eval (self, _tmp132_);
												_tmp134_ = _tmp133_;
												_tmp135_ = g_strcmp0 (_tmp134_, "1") == 0;
												_g_free0 (_tmp134_);
												if (_tmp135_) {
													ValaProperty* _tmp136_;
													ValaPropertyAccessor* _tmp137_;
													ValaPropertyAccessor* _tmp138_;
													ValaDataType* _tmp139_;
													ValaDataType* _tmp140_;
													_tmp136_ = prop;
													_tmp137_ = vala_property_get_get_accessor (_tmp136_);
													_tmp138_ = _tmp137_;
													_tmp139_ = vala_property_accessor_get_value_type (_tmp138_);
													_tmp140_ = _tmp139_;
													vala_data_type_set_value_owned (_tmp140_, TRUE);
												}
											} else {
												gchar** _tmp141_;
												gint _tmp141__length1;
												const gchar* _tmp142_;
												_tmp141_ = nv;
												_tmp141__length1 = nv_length1;
												_tmp142_ = _tmp141_[0];
												if (g_strcmp0 (_tmp142_, "type_name") == 0) {
													ValaProperty* _tmp143_;
													gchar** _tmp144_;
													gint _tmp144__length1;
													const gchar* _tmp145_;
													gchar* _tmp146_ = NULL;
													gchar* _tmp147_;
													ValaDataType* _tmp148_ = NULL;
													ValaDataType* _tmp149_;
													_tmp143_ = prop;
													_tmp144_ = nv;
													_tmp144__length1 = nv_length1;
													_tmp145_ = _tmp144_[1];
													_tmp146_ = vala_gidl_parser_eval (self, _tmp145_);
													_tmp147_ = _tmp146_;
													_tmp148_ = vala_gidl_parser_parse_type_from_string (self, _tmp147_, FALSE, NULL);
													_tmp149_ = _tmp148_;
													vala_property_set_property_type (_tmp143_, _tmp149_);
													_vala_code_node_unref0 (_tmp149_);
													_g_free0 (_tmp147_);
												} else {
													gchar** _tmp150_;
													gint _tmp150__length1;
													const gchar* _tmp151_;
													_tmp150_ = nv;
													_tmp150__length1 = nv_length1;
													_tmp151_ = _tmp150_[0];
													if (g_strcmp0 (_tmp151_, "experimental") == 0) {
														gchar** _tmp152_;
														gint _tmp152__length1;
														const gchar* _tmp153_;
														gchar* _tmp154_ = NULL;
														gchar* _tmp155_;
														gboolean _tmp156_;
														_tmp152_ = nv;
														_tmp152__length1 = nv_length1;
														_tmp153_ = _tmp152_[1];
														_tmp154_ = vala_gidl_parser_eval (self, _tmp153_);
														_tmp155_ = _tmp154_;
														_tmp156_ = g_strcmp0 (_tmp155_, "1") == 0;
														_g_free0 (_tmp155_);
														if (_tmp156_) {
															ValaProperty* _tmp157_;
															_tmp157_ = prop;
															vala_code_node_set_attribute ((ValaCodeNode*) _tmp157_, "Experimental", TRUE, NULL);
														}
													} else {
														gchar** _tmp158_;
														gint _tmp158__length1;
														const gchar* _tmp159_;
														_tmp158_ = nv;
														_tmp158__length1 = nv_length1;
														_tmp159_ = _tmp158_[0];
														if (g_strcmp0 (_tmp159_, "nullable") == 0) {
															gchar** _tmp160_;
															gint _tmp160__length1;
															const gchar* _tmp161_;
															gchar* _tmp162_ = NULL;
															gchar* _tmp163_;
															gboolean _tmp164_;
															_tmp160_ = nv;
															_tmp160__length1 = nv_length1;
															_tmp161_ = _tmp160_[1];
															_tmp162_ = vala_gidl_parser_eval (self, _tmp161_);
															_tmp163_ = _tmp162_;
															_tmp164_ = g_strcmp0 (_tmp163_, "1") == 0;
															_g_free0 (_tmp163_);
															if (_tmp164_) {
																ValaProperty* _tmp165_;
																ValaDataType* _tmp166_;
																ValaDataType* _tmp167_;
																_tmp165_ = prop;
																_tmp166_ = vala_property_get_property_type (_tmp165_);
																_tmp167_ = _tmp166_;
																vala_data_type_set_nullable (_tmp167_, TRUE);
															}
														} else {
															gchar** _tmp168_;
															gint _tmp168__length1;
															const gchar* _tmp169_;
															_tmp168_ = nv;
															_tmp168__length1 = nv_length1;
															_tmp169_ = _tmp168_[0];
															if (g_strcmp0 (_tmp169_, "abstract") == 0) {
																gchar** _tmp170_;
																gint _tmp170__length1;
																const gchar* _tmp171_;
																gchar* _tmp172_ = NULL;
																gchar* _tmp173_;
																gboolean _tmp174_;
																_tmp170_ = nv;
																_tmp170__length1 = nv_length1;
																_tmp171_ = _tmp170_[1];
																_tmp172_ = vala_gidl_parser_eval (self, _tmp171_);
																_tmp173_ = _tmp172_;
																_tmp174_ = g_strcmp0 (_tmp173_, "1") == 0;
																_g_free0 (_tmp173_);
																if (_tmp174_) {
																	ValaProperty* _tmp175_;
																	_tmp175_ = prop;
																	vala_property_set_is_abstract (_tmp175_, TRUE);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp176_ = self->priv->current_type_symbol_set;
	if (_tmp176_ != NULL) {
		ValaSet* _tmp177_;
		ValaProperty* _tmp178_;
		const gchar* _tmp179_;
		const gchar* _tmp180_;
		_tmp177_ = self->priv->current_type_symbol_set;
		_tmp178_ = prop;
		_tmp179_ = vala_symbol_get_name ((ValaSymbol*) _tmp178_);
		_tmp180_ = _tmp179_;
		vala_collection_add ((ValaCollection*) _tmp177_, _tmp180_);
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node) {
	ValaConstant* result = NULL;
	GIdlNodeConstant* _tmp0_;
	GIdlNode* node;
	GIdlNodeConstant* _tmp1_;
	GIdlNodeType* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* type;
	ValaDataType* _tmp4_;
	GIdlNode* _tmp5_;
	const gchar* _tmp6_;
	ValaDataType* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaConstant* _tmp9_;
	ValaConstant* c;
	ValaConstant* _tmp10_;
	GIdlNode* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	ValaConstant* _tmp65_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	_tmp0_ = const_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = const_node;
	_tmp2_ = _tmp1_->type;
	_tmp3_ = vala_gidl_parser_parse_type (self, _tmp2_, NULL);
	type = _tmp3_;
	_tmp4_ = type;
	if (_tmp4_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp5_ = node;
	_tmp6_ = _tmp5_->name;
	_tmp7_ = type;
	_tmp8_ = self->priv->current_source_reference;
	_tmp9_ = vala_constant_new (_tmp6_, _tmp7_, NULL, _tmp8_, NULL);
	c = _tmp9_;
	_tmp10_ = c;
	vala_symbol_set_external ((ValaSymbol*) _tmp10_, TRUE);
	_tmp11_ = node;
	_tmp12_ = _tmp11_->name;
	_tmp14_ = vala_gidl_parser_get_attributes (self, _tmp12_, &_tmp13_);
	attributes = _tmp14_;
	attributes_length1 = _tmp13_;
	_attributes_size_ = attributes_length1;
	_tmp15_ = attributes;
	_tmp15__length1 = attributes_length1;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = attributes;
		_tmp16__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp16_;
			attr_collection_length1 = _tmp16__length1;
			for (attr_it = 0; attr_it < _tmp16__length1; attr_it = attr_it + 1) {
				gchar* _tmp17_;
				gchar* attr = NULL;
				_tmp17_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp17_;
				{
					const gchar* _tmp18_;
					gchar** _tmp19_;
					gchar** _tmp20_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					_tmp18_ = attr;
					_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
					nv = _tmp20_;
					nv_length1 = _vala_array_length (_tmp19_);
					_nv_size_ = nv_length1;
					_tmp21_ = nv;
					_tmp21__length1 = nv_length1;
					_tmp22_ = _tmp21_[0];
					if (g_strcmp0 (_tmp22_, "cheader_filename") == 0) {
						ValaConstant* _tmp23_;
						gchar** _tmp24_;
						gint _tmp24__length1;
						const gchar* _tmp25_;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						_tmp23_ = c;
						_tmp24_ = nv;
						_tmp24__length1 = nv_length1;
						_tmp25_ = _tmp24_[1];
						_tmp26_ = vala_gidl_parser_eval (self, _tmp25_);
						_tmp27_ = _tmp26_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp23_, "CCode", "cheader_filename", _tmp27_, NULL);
						_g_free0 (_tmp27_);
					} else {
						gchar** _tmp28_;
						gint _tmp28__length1;
						const gchar* _tmp29_;
						_tmp28_ = nv;
						_tmp28__length1 = nv_length1;
						_tmp29_ = _tmp28_[0];
						if (g_strcmp0 (_tmp29_, "deprecated") == 0) {
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							gchar* _tmp32_ = NULL;
							gchar* _tmp33_;
							gboolean _tmp34_;
							_tmp30_ = nv;
							_tmp30__length1 = nv_length1;
							_tmp31_ = _tmp30_[1];
							_tmp32_ = vala_gidl_parser_eval (self, _tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = g_strcmp0 (_tmp33_, "1") == 0;
							_g_free0 (_tmp33_);
							if (_tmp34_) {
								ValaConstant* _tmp35_;
								_tmp35_ = c;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp35_, "Deprecated", TRUE, NULL);
							}
						} else {
							gchar** _tmp36_;
							gint _tmp36__length1;
							const gchar* _tmp37_;
							_tmp36_ = nv;
							_tmp36__length1 = nv_length1;
							_tmp37_ = _tmp36_[0];
							if (g_strcmp0 (_tmp37_, "replacement") == 0) {
								ValaConstant* _tmp38_;
								gchar** _tmp39_;
								gint _tmp39__length1;
								const gchar* _tmp40_;
								gchar* _tmp41_ = NULL;
								gchar* _tmp42_;
								_tmp38_ = c;
								_tmp39_ = nv;
								_tmp39__length1 = nv_length1;
								_tmp40_ = _tmp39_[1];
								_tmp41_ = vala_gidl_parser_eval (self, _tmp40_);
								_tmp42_ = _tmp41_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp38_, "Deprecated", "replacement", _tmp42_, NULL);
								_g_free0 (_tmp42_);
							} else {
								gchar** _tmp43_;
								gint _tmp43__length1;
								const gchar* _tmp44_;
								_tmp43_ = nv;
								_tmp43__length1 = nv_length1;
								_tmp44_ = _tmp43_[0];
								if (g_strcmp0 (_tmp44_, "deprecated_since") == 0) {
									ValaConstant* _tmp45_;
									gchar** _tmp46_;
									gint _tmp46__length1;
									const gchar* _tmp47_;
									gchar* _tmp48_ = NULL;
									gchar* _tmp49_;
									_tmp45_ = c;
									_tmp46_ = nv;
									_tmp46__length1 = nv_length1;
									_tmp47_ = _tmp46_[1];
									_tmp48_ = vala_gidl_parser_eval (self, _tmp47_);
									_tmp49_ = _tmp48_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp45_, "Deprecated", "since", _tmp49_, NULL);
									_g_free0 (_tmp49_);
								} else {
									gchar** _tmp50_;
									gint _tmp50__length1;
									const gchar* _tmp51_;
									_tmp50_ = nv;
									_tmp50__length1 = nv_length1;
									_tmp51_ = _tmp50_[0];
									if (g_strcmp0 (_tmp51_, "hidden") == 0) {
										gchar** _tmp52_;
										gint _tmp52__length1;
										const gchar* _tmp53_;
										gchar* _tmp54_ = NULL;
										gchar* _tmp55_;
										gboolean _tmp56_;
										_tmp52_ = nv;
										_tmp52__length1 = nv_length1;
										_tmp53_ = _tmp52_[1];
										_tmp54_ = vala_gidl_parser_eval (self, _tmp53_);
										_tmp55_ = _tmp54_;
										_tmp56_ = g_strcmp0 (_tmp55_, "1") == 0;
										_g_free0 (_tmp55_);
										if (_tmp56_) {
											result = NULL;
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
											_vala_code_node_unref0 (c);
											_vala_code_node_unref0 (type);
											return result;
										}
									} else {
										gchar** _tmp57_;
										gint _tmp57__length1;
										const gchar* _tmp58_;
										_tmp57_ = nv;
										_tmp57__length1 = nv_length1;
										_tmp58_ = _tmp57_[0];
										if (g_strcmp0 (_tmp58_, "experimental") == 0) {
											gchar** _tmp59_;
											gint _tmp59__length1;
											const gchar* _tmp60_;
											gchar* _tmp61_ = NULL;
											gchar* _tmp62_;
											gboolean _tmp63_;
											_tmp59_ = nv;
											_tmp59__length1 = nv_length1;
											_tmp60_ = _tmp59_[1];
											_tmp61_ = vala_gidl_parser_eval (self, _tmp60_);
											_tmp62_ = _tmp61_;
											_tmp63_ = g_strcmp0 (_tmp62_, "1") == 0;
											_g_free0 (_tmp62_);
											if (_tmp63_) {
												ValaConstant* _tmp64_;
												_tmp64_ = c;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp64_, "Experimental", TRUE, NULL);
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp65_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp65_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node) {
	ValaField* result = NULL;
	GIdlNodeField* _tmp0_;
	GIdlNode* node;
	gboolean unhidden;
	GIdlNodeField* _tmp1_;
	GIdlNodeType* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* type;
	ValaDataType* _tmp4_;
	gchar* cheader_filename;
	gchar* ctype;
	gchar* array_length_cname;
	gchar* array_length_type;
	gboolean array_null_terminated;
	gboolean deprecated;
	gchar* deprecated_since;
	gchar* replacement;
	gboolean experimental;
	gboolean no_delegate_target;
	ValaTypeSymbol* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GIdlNode* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint _tmp12_ = 0;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gboolean _tmp134_ = FALSE;
	GIdlNode* _tmp135_;
	const gchar* _tmp136_;
	gboolean _tmp137_ = FALSE;
	gboolean _tmp139_;
	ValaSet* _tmp140_;
	GIdlNode* _tmp144_;
	const gchar* _tmp145_;
	gchar* _tmp146_;
	gchar* field_name;
	const gchar* _tmp147_;
	const gchar* _tmp149_;
	ValaDataType* _tmp150_;
	ValaSourceReference* _tmp151_;
	ValaField* _tmp152_;
	ValaField* field;
	ValaField* _tmp153_;
	const gchar* _tmp154_;
	GIdlNode* _tmp155_;
	const gchar* _tmp156_;
	gboolean _tmp160_;
	gboolean _tmp168_;
	const gchar* _tmp170_;
	const gchar* _tmp173_;
	gboolean _tmp176_;
	gboolean _tmp178_ = FALSE;
	const gchar* _tmp179_;
	gboolean _tmp181_;
	gboolean _tmp192_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	_tmp0_ = field_node;
	node = (GIdlNode*) _tmp0_;
	unhidden = FALSE;
	_tmp1_ = field_node;
	_tmp2_ = _tmp1_->type;
	_tmp3_ = vala_gidl_parser_parse_type (self, _tmp2_, NULL);
	type = _tmp3_;
	_tmp4_ = type;
	if (_tmp4_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_length_cname = NULL;
	array_length_type = NULL;
	array_null_terminated = FALSE;
	deprecated = FALSE;
	deprecated_since = NULL;
	replacement = NULL;
	experimental = FALSE;
	no_delegate_target = FALSE;
	_tmp5_ = self->priv->current_data_type;
	_tmp6_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = node;
	_tmp9_ = _tmp8_->name;
	_tmp10_ = g_strdup_printf ("%s.%s", _tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = vala_gidl_parser_get_attributes (self, _tmp11_, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp7_);
	attributes = _tmp14_;
	attributes_length1 = _tmp14__length1;
	_attributes_size_ = attributes_length1;
	_tmp15_ = attributes;
	_tmp15__length1 = attributes_length1;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = attributes;
		_tmp16__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp16_;
			attr_collection_length1 = _tmp16__length1;
			for (attr_it = 0; attr_it < _tmp16__length1; attr_it = attr_it + 1) {
				gchar* _tmp17_;
				gchar* attr = NULL;
				_tmp17_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp17_;
				{
					const gchar* _tmp18_;
					gchar** _tmp19_;
					gchar** _tmp20_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					_tmp18_ = attr;
					_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
					nv = _tmp20_;
					nv_length1 = _vala_array_length (_tmp19_);
					_nv_size_ = nv_length1;
					_tmp21_ = nv;
					_tmp21__length1 = nv_length1;
					_tmp22_ = _tmp21_[0];
					if (g_strcmp0 (_tmp22_, "hidden") == 0) {
						gchar** _tmp23_;
						gint _tmp23__length1;
						const gchar* _tmp24_;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_;
						gboolean _tmp27_;
						_tmp23_ = nv;
						_tmp23__length1 = nv_length1;
						_tmp24_ = _tmp23_[1];
						_tmp25_ = vala_gidl_parser_eval (self, _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strcmp0 (_tmp26_, "1") == 0;
						_g_free0 (_tmp26_);
						if (_tmp27_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (replacement);
							_g_free0 (deprecated_since);
							_g_free0 (array_length_type);
							_g_free0 (array_length_cname);
							_g_free0 (ctype);
							_g_free0 (cheader_filename);
							_vala_code_node_unref0 (type);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						gchar** _tmp28_;
						gint _tmp28__length1;
						const gchar* _tmp29_;
						_tmp28_ = nv;
						_tmp28__length1 = nv_length1;
						_tmp29_ = _tmp28_[0];
						if (g_strcmp0 (_tmp29_, "is_array") == 0) {
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							gchar* _tmp32_ = NULL;
							gchar* _tmp33_;
							gboolean _tmp34_;
							_tmp30_ = nv;
							_tmp30__length1 = nv_length1;
							_tmp31_ = _tmp30_[1];
							_tmp32_ = vala_gidl_parser_eval (self, _tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = g_strcmp0 (_tmp33_, "1") == 0;
							_g_free0 (_tmp33_);
							if (_tmp34_) {
								ValaDataType* _tmp35_;
								ValaDataType* _tmp36_;
								ValaSourceReference* _tmp37_;
								ValaSourceReference* _tmp38_;
								ValaArrayType* _tmp39_;
								_tmp35_ = type;
								_tmp36_ = type;
								_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = vala_array_type_new (_tmp35_, 1, _tmp38_);
								_vala_code_node_unref0 (type);
								type = (ValaDataType*) _tmp39_;
							}
						} else {
							gchar** _tmp40_;
							gint _tmp40__length1;
							const gchar* _tmp41_;
							_tmp40_ = nv;
							_tmp40__length1 = nv_length1;
							_tmp41_ = _tmp40_[0];
							if (g_strcmp0 (_tmp41_, "weak") == 0) {
								gchar** _tmp42_;
								gint _tmp42__length1;
								const gchar* _tmp43_;
								gchar* _tmp44_ = NULL;
								gchar* _tmp45_;
								gboolean _tmp46_;
								_tmp42_ = nv;
								_tmp42__length1 = nv_length1;
								_tmp43_ = _tmp42_[1];
								_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
								_tmp45_ = _tmp44_;
								_tmp46_ = g_strcmp0 (_tmp45_, "0") == 0;
								_g_free0 (_tmp45_);
								if (_tmp46_) {
									ValaDataType* _tmp47_;
									_tmp47_ = type;
									vala_data_type_set_value_owned (_tmp47_, TRUE);
								}
							} else {
								gchar** _tmp48_;
								gint _tmp48__length1;
								const gchar* _tmp49_;
								_tmp48_ = nv;
								_tmp48__length1 = nv_length1;
								_tmp49_ = _tmp48_[0];
								if (g_strcmp0 (_tmp49_, "value_owned") == 0) {
									gchar** _tmp50_;
									gint _tmp50__length1;
									const gchar* _tmp51_;
									gchar* _tmp52_ = NULL;
									gchar* _tmp53_;
									gboolean _tmp54_;
									_tmp50_ = nv;
									_tmp50__length1 = nv_length1;
									_tmp51_ = _tmp50_[1];
									_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
									_tmp53_ = _tmp52_;
									_tmp54_ = g_strcmp0 (_tmp53_, "0") == 0;
									_g_free0 (_tmp53_);
									if (_tmp54_) {
										ValaDataType* _tmp55_;
										_tmp55_ = type;
										vala_data_type_set_value_owned (_tmp55_, FALSE);
									} else {
										gchar** _tmp56_;
										gint _tmp56__length1;
										const gchar* _tmp57_;
										gchar* _tmp58_ = NULL;
										gchar* _tmp59_;
										gboolean _tmp60_;
										_tmp56_ = nv;
										_tmp56__length1 = nv_length1;
										_tmp57_ = _tmp56_[1];
										_tmp58_ = vala_gidl_parser_eval (self, _tmp57_);
										_tmp59_ = _tmp58_;
										_tmp60_ = g_strcmp0 (_tmp59_, "1") == 0;
										_g_free0 (_tmp59_);
										if (_tmp60_) {
											ValaDataType* _tmp61_;
											_tmp61_ = type;
											vala_data_type_set_value_owned (_tmp61_, TRUE);
										}
									}
								} else {
									gchar** _tmp62_;
									gint _tmp62__length1;
									const gchar* _tmp63_;
									_tmp62_ = nv;
									_tmp62__length1 = nv_length1;
									_tmp63_ = _tmp62_[0];
									if (g_strcmp0 (_tmp63_, "type_name") == 0) {
										gchar** _tmp64_;
										gint _tmp64__length1;
										const gchar* _tmp65_;
										gchar* _tmp66_ = NULL;
										gchar* _tmp67_;
										ValaDataType* _tmp68_ = NULL;
										_tmp64_ = nv;
										_tmp64__length1 = nv_length1;
										_tmp65_ = _tmp64_[1];
										_tmp66_ = vala_gidl_parser_eval (self, _tmp65_);
										_tmp67_ = _tmp66_;
										_tmp68_ = vala_gidl_parser_parse_type_from_string (self, _tmp67_, TRUE, NULL);
										_vala_code_node_unref0 (type);
										type = _tmp68_;
										_g_free0 (_tmp67_);
									} else {
										gchar** _tmp69_;
										gint _tmp69__length1;
										const gchar* _tmp70_;
										_tmp69_ = nv;
										_tmp69__length1 = nv_length1;
										_tmp70_ = _tmp69_[0];
										if (g_strcmp0 (_tmp70_, "type_arguments") == 0) {
											ValaDataType* _tmp71_;
											gchar** _tmp72_;
											gint _tmp72__length1;
											const gchar* _tmp73_;
											gchar* _tmp74_ = NULL;
											gchar* _tmp75_;
											_tmp71_ = type;
											_tmp72_ = nv;
											_tmp72__length1 = nv_length1;
											_tmp73_ = _tmp72_[1];
											_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
											_tmp75_ = _tmp74_;
											vala_gidl_parser_parse_type_arguments_from_string (self, _tmp71_, _tmp75_, NULL);
											_g_free0 (_tmp75_);
										} else {
											gchar** _tmp76_;
											gint _tmp76__length1;
											const gchar* _tmp77_;
											_tmp76_ = nv;
											_tmp76__length1 = nv_length1;
											_tmp77_ = _tmp76_[0];
											if (g_strcmp0 (_tmp77_, "deprecated") == 0) {
												gchar** _tmp78_;
												gint _tmp78__length1;
												const gchar* _tmp79_;
												gchar* _tmp80_ = NULL;
												gchar* _tmp81_;
												gboolean _tmp82_;
												_tmp78_ = nv;
												_tmp78__length1 = nv_length1;
												_tmp79_ = _tmp78_[1];
												_tmp80_ = vala_gidl_parser_eval (self, _tmp79_);
												_tmp81_ = _tmp80_;
												_tmp82_ = g_strcmp0 (_tmp81_, "1") == 0;
												_g_free0 (_tmp81_);
												if (_tmp82_) {
													deprecated = TRUE;
												}
											} else {
												gchar** _tmp83_;
												gint _tmp83__length1;
												const gchar* _tmp84_;
												_tmp83_ = nv;
												_tmp83__length1 = nv_length1;
												_tmp84_ = _tmp83_[0];
												if (g_strcmp0 (_tmp84_, "replacement") == 0) {
													gchar** _tmp85_;
													gint _tmp85__length1;
													const gchar* _tmp86_;
													gchar* _tmp87_ = NULL;
													_tmp85_ = nv;
													_tmp85__length1 = nv_length1;
													_tmp86_ = _tmp85_[1];
													_tmp87_ = vala_gidl_parser_eval (self, _tmp86_);
													_g_free0 (replacement);
													replacement = _tmp87_;
												} else {
													gchar** _tmp88_;
													gint _tmp88__length1;
													const gchar* _tmp89_;
													_tmp88_ = nv;
													_tmp88__length1 = nv_length1;
													_tmp89_ = _tmp88_[0];
													if (g_strcmp0 (_tmp89_, "deprecated_since") == 0) {
														gchar** _tmp90_;
														gint _tmp90__length1;
														const gchar* _tmp91_;
														gchar* _tmp92_ = NULL;
														_tmp90_ = nv;
														_tmp90__length1 = nv_length1;
														_tmp91_ = _tmp90_[1];
														_tmp92_ = vala_gidl_parser_eval (self, _tmp91_);
														_g_free0 (deprecated_since);
														deprecated_since = _tmp92_;
													} else {
														gchar** _tmp93_;
														gint _tmp93__length1;
														const gchar* _tmp94_;
														_tmp93_ = nv;
														_tmp93__length1 = nv_length1;
														_tmp94_ = _tmp93_[0];
														if (g_strcmp0 (_tmp94_, "cheader_filename") == 0) {
															gchar** _tmp95_;
															gint _tmp95__length1;
															const gchar* _tmp96_;
															gchar* _tmp97_ = NULL;
															_tmp95_ = nv;
															_tmp95__length1 = nv_length1;
															_tmp96_ = _tmp95_[1];
															_tmp97_ = vala_gidl_parser_eval (self, _tmp96_);
															_g_free0 (cheader_filename);
															cheader_filename = _tmp97_;
														} else {
															gchar** _tmp98_;
															gint _tmp98__length1;
															const gchar* _tmp99_;
															_tmp98_ = nv;
															_tmp98__length1 = nv_length1;
															_tmp99_ = _tmp98_[0];
															if (g_strcmp0 (_tmp99_, "ctype") == 0) {
																gchar** _tmp100_;
																gint _tmp100__length1;
																const gchar* _tmp101_;
																gchar* _tmp102_ = NULL;
																_tmp100_ = nv;
																_tmp100__length1 = nv_length1;
																_tmp101_ = _tmp100_[1];
																_tmp102_ = vala_gidl_parser_eval (self, _tmp101_);
																_g_free0 (ctype);
																ctype = _tmp102_;
															} else {
																gchar** _tmp103_;
																gint _tmp103__length1;
																const gchar* _tmp104_;
																_tmp103_ = nv;
																_tmp103__length1 = nv_length1;
																_tmp104_ = _tmp103_[0];
																if (g_strcmp0 (_tmp104_, "array_null_terminated") == 0) {
																	gchar** _tmp105_;
																	gint _tmp105__length1;
																	const gchar* _tmp106_;
																	gchar* _tmp107_ = NULL;
																	gchar* _tmp108_;
																	gboolean _tmp109_;
																	_tmp105_ = nv;
																	_tmp105__length1 = nv_length1;
																	_tmp106_ = _tmp105_[1];
																	_tmp107_ = vala_gidl_parser_eval (self, _tmp106_);
																	_tmp108_ = _tmp107_;
																	_tmp109_ = g_strcmp0 (_tmp108_, "1") == 0;
																	_g_free0 (_tmp108_);
																	if (_tmp109_) {
																		array_null_terminated = TRUE;
																	}
																} else {
																	gchar** _tmp110_;
																	gint _tmp110__length1;
																	const gchar* _tmp111_;
																	_tmp110_ = nv;
																	_tmp110__length1 = nv_length1;
																	_tmp111_ = _tmp110_[0];
																	if (g_strcmp0 (_tmp111_, "array_length_cname") == 0) {
																		gchar** _tmp112_;
																		gint _tmp112__length1;
																		const gchar* _tmp113_;
																		gchar* _tmp114_ = NULL;
																		_tmp112_ = nv;
																		_tmp112__length1 = nv_length1;
																		_tmp113_ = _tmp112_[1];
																		_tmp114_ = vala_gidl_parser_eval (self, _tmp113_);
																		_g_free0 (array_length_cname);
																		array_length_cname = _tmp114_;
																	} else {
																		gchar** _tmp115_;
																		gint _tmp115__length1;
																		const gchar* _tmp116_;
																		_tmp115_ = nv;
																		_tmp115__length1 = nv_length1;
																		_tmp116_ = _tmp115_[0];
																		if (g_strcmp0 (_tmp116_, "array_length_type") == 0) {
																			gchar** _tmp117_;
																			gint _tmp117__length1;
																			const gchar* _tmp118_;
																			gchar* _tmp119_ = NULL;
																			_tmp117_ = nv;
																			_tmp117__length1 = nv_length1;
																			_tmp118_ = _tmp117_[1];
																			_tmp119_ = vala_gidl_parser_eval (self, _tmp118_);
																			_g_free0 (array_length_type);
																			array_length_type = _tmp119_;
																		} else {
																			gchar** _tmp120_;
																			gint _tmp120__length1;
																			const gchar* _tmp121_;
																			_tmp120_ = nv;
																			_tmp120__length1 = nv_length1;
																			_tmp121_ = _tmp120_[0];
																			if (g_strcmp0 (_tmp121_, "no_delegate_target") == 0) {
																				gchar** _tmp122_;
																				gint _tmp122__length1;
																				const gchar* _tmp123_;
																				gchar* _tmp124_ = NULL;
																				gchar* _tmp125_;
																				gboolean _tmp126_;
																				_tmp122_ = nv;
																				_tmp122__length1 = nv_length1;
																				_tmp123_ = _tmp122_[1];
																				_tmp124_ = vala_gidl_parser_eval (self, _tmp123_);
																				_tmp125_ = _tmp124_;
																				_tmp126_ = g_strcmp0 (_tmp125_, "1") == 0;
																				_g_free0 (_tmp125_);
																				if (_tmp126_) {
																					no_delegate_target = TRUE;
																				}
																			} else {
																				gchar** _tmp127_;
																				gint _tmp127__length1;
																				const gchar* _tmp128_;
																				_tmp127_ = nv;
																				_tmp127__length1 = nv_length1;
																				_tmp128_ = _tmp127_[0];
																				if (g_strcmp0 (_tmp128_, "experimental") == 0) {
																					gchar** _tmp129_;
																					gint _tmp129__length1;
																					const gchar* _tmp130_;
																					gchar* _tmp131_ = NULL;
																					gchar* _tmp132_;
																					gboolean _tmp133_;
																					_tmp129_ = nv;
																					_tmp129__length1 = nv_length1;
																					_tmp130_ = _tmp129_[1];
																					_tmp131_ = vala_gidl_parser_eval (self, _tmp130_);
																					_tmp132_ = _tmp131_;
																					_tmp133_ = g_strcmp0 (_tmp132_, "1") == 0;
																					_g_free0 (_tmp132_);
																					if (_tmp133_) {
																						experimental = TRUE;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp135_ = node;
	_tmp136_ = _tmp135_->name;
	_tmp137_ = g_str_has_prefix (_tmp136_, "_");
	if (_tmp137_) {
		gboolean _tmp138_;
		_tmp138_ = unhidden;
		_tmp134_ = !_tmp138_;
	} else {
		_tmp134_ = FALSE;
	}
	_tmp139_ = _tmp134_;
	if (_tmp139_) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_free0 (array_length_type);
		_g_free0 (array_length_cname);
		_g_free0 (ctype);
		_g_free0 (cheader_filename);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp140_ = self->priv->current_type_symbol_set;
	if (_tmp140_ != NULL) {
		ValaSet* _tmp141_;
		GIdlNode* _tmp142_;
		const gchar* _tmp143_;
		_tmp141_ = self->priv->current_type_symbol_set;
		_tmp142_ = node;
		_tmp143_ = _tmp142_->name;
		vala_collection_add ((ValaCollection*) _tmp141_, _tmp143_);
	}
	_tmp144_ = node;
	_tmp145_ = _tmp144_->name;
	_tmp146_ = g_strdup (_tmp145_);
	field_name = _tmp146_;
	_tmp147_ = field_name;
	if (g_strcmp0 (_tmp147_, "string") == 0) {
		gchar* _tmp148_;
		_tmp148_ = g_strdup ("str");
		_g_free0 (field_name);
		field_name = _tmp148_;
	}
	_tmp149_ = field_name;
	_tmp150_ = type;
	_tmp151_ = self->priv->current_source_reference;
	_tmp152_ = vala_field_new (_tmp149_, _tmp150_, NULL, _tmp151_, NULL);
	field = _tmp152_;
	_tmp153_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp153_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp154_ = field_name;
	_tmp155_ = node;
	_tmp156_ = _tmp155_->name;
	if (g_strcmp0 (_tmp154_, _tmp156_) != 0) {
		ValaField* _tmp157_;
		GIdlNode* _tmp158_;
		const gchar* _tmp159_;
		_tmp157_ = field;
		_tmp158_ = node;
		_tmp159_ = _tmp158_->name;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp157_, "CCode", "cname", _tmp159_, NULL);
	}
	_tmp160_ = deprecated;
	if (_tmp160_) {
		ValaField* _tmp161_;
		const gchar* _tmp162_;
		const gchar* _tmp165_;
		_tmp161_ = field;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp161_, "Deprecated", TRUE, NULL);
		_tmp162_ = deprecated_since;
		if (_tmp162_ != NULL) {
			ValaField* _tmp163_;
			const gchar* _tmp164_;
			_tmp163_ = field;
			_tmp164_ = deprecated_since;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp163_, "Deprecated", "since", _tmp164_, NULL);
		}
		_tmp165_ = replacement;
		if (_tmp165_ != NULL) {
			ValaField* _tmp166_;
			const gchar* _tmp167_;
			_tmp166_ = field;
			_tmp167_ = replacement;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp166_, "Deprecated", "replacement", _tmp167_, NULL);
		}
	}
	_tmp168_ = experimental;
	if (_tmp168_) {
		ValaField* _tmp169_;
		_tmp169_ = field;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp169_, "Experimental", TRUE, NULL);
	}
	_tmp170_ = ctype;
	if (_tmp170_ != NULL) {
		ValaField* _tmp171_;
		const gchar* _tmp172_;
		_tmp171_ = field;
		_tmp172_ = ctype;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp171_, "CCode", "type", _tmp172_, NULL);
	}
	_tmp173_ = cheader_filename;
	if (_tmp173_ != NULL) {
		ValaField* _tmp174_;
		const gchar* _tmp175_;
		_tmp174_ = field;
		_tmp175_ = cheader_filename;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp174_, "CCode", "cheader_filename", _tmp175_, NULL);
	}
	_tmp176_ = array_null_terminated;
	if (_tmp176_) {
		ValaField* _tmp177_;
		_tmp177_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp177_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp179_ = array_length_cname;
	if (_tmp179_ != NULL) {
		_tmp178_ = TRUE;
	} else {
		const gchar* _tmp180_;
		_tmp180_ = array_length_type;
		_tmp178_ = _tmp180_ != NULL;
	}
	_tmp181_ = _tmp178_;
	if (_tmp181_) {
		const gchar* _tmp182_;
		const gchar* _tmp185_;
		_tmp182_ = array_length_cname;
		if (_tmp182_ != NULL) {
			ValaField* _tmp183_;
			const gchar* _tmp184_;
			_tmp183_ = field;
			_tmp184_ = array_length_cname;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp183_, "CCode", "array_length_cname", _tmp184_, NULL);
		}
		_tmp185_ = array_length_type;
		if (_tmp185_ != NULL) {
			ValaField* _tmp186_;
			const gchar* _tmp187_;
			_tmp186_ = field;
			_tmp187_ = array_length_type;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp186_, "CCode", "array_length_type", _tmp187_, NULL);
		}
	} else {
		ValaField* _tmp188_;
		ValaDataType* _tmp189_;
		ValaDataType* _tmp190_;
		_tmp188_ = field;
		_tmp189_ = vala_variable_get_variable_type ((ValaVariable*) _tmp188_);
		_tmp190_ = _tmp189_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp190_, VALA_TYPE_ARRAY_TYPE)) {
			ValaField* _tmp191_;
			_tmp191_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp191_, "CCode", "array_length", FALSE, NULL);
		}
	}
	_tmp192_ = no_delegate_target;
	if (_tmp192_) {
		ValaField* _tmp193_;
		_tmp193_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp193_, "CCode", "delegate_target", FALSE, NULL);
	}
	result = field;
	_g_free0 (field_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (replacement);
	_g_free0 (deprecated_since);
	_g_free0 (array_length_type);
	_g_free0 (array_length_cname);
	_g_free0 (ctype);
	_g_free0 (cheader_filename);
	_vala_code_node_unref0 (type);
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1) {
	gchar** result = NULL;
	ValaMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	gchar* attributes;
	const gchar* _tmp3_;
	const gchar* _tmp38_;
	GSList* attr_list;
	const gchar* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GString* _tmp43_;
	GString* attr;
	const gchar* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint attributes_len;
	const gchar* _tmp47_;
	const gchar* remaining;
	gboolean quoted;
	gboolean escaped;
	GString* _tmp76_;
	gssize _tmp77_;
	GSList* _tmp81_;
	guint _tmp82_ = 0U;
	gchar** _tmp83_ = NULL;
	gchar** attrs;
	gint attrs_length1;
	gint _attrs_size_;
	GSList* _tmp84_;
	GSList* attr_i;
	gchar** _tmp99_;
	gint _tmp99__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	_tmp0_ = self->priv->codenode_attributes_map;
	_tmp1_ = codenode;
	_tmp2_ = vala_map_get (_tmp0_, _tmp1_);
	attributes = (gchar*) _tmp2_;
	_tmp3_ = attributes;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		gint _tmp5_ = 0;
		gboolean dot_required;
		const gchar* _tmp6_;
		gint _tmp7_ = 0;
		gboolean colon_required;
		ValaMap* _tmp8_;
		ValaSet* _tmp9_ = NULL;
		ValaSet* pattern_specs;
		_tmp4_ = codenode;
		_tmp5_ = string_index_of_char (_tmp4_, (gunichar) '.', 0);
		dot_required = (-1) != _tmp5_;
		_tmp6_ = codenode;
		_tmp7_ = string_index_of_char (_tmp6_, (gunichar) ':', 0);
		colon_required = (-1) != _tmp7_;
		_tmp8_ = self->priv->codenode_attributes_patterns;
		_tmp9_ = vala_map_get_keys (_tmp8_);
		pattern_specs = _tmp9_;
		{
			ValaSet* _tmp10_;
			ValaIterator* _tmp11_ = NULL;
			ValaIterator* _pattern_it;
			_tmp10_ = pattern_specs;
			_tmp11_ = vala_iterable_iterator ((ValaIterable*) _tmp10_);
			_pattern_it = _tmp11_;
			while (TRUE) {
				ValaIterator* _tmp12_;
				gboolean _tmp13_ = FALSE;
				ValaIterator* _tmp14_;
				gpointer _tmp15_ = NULL;
				GPatternSpec* pattern;
				ValaMap* _tmp16_;
				GPatternSpec* _tmp17_;
				gpointer _tmp18_ = NULL;
				gchar* pspec;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_;
				gboolean _tmp24_;
				gboolean _tmp30_;
				GPatternSpec* _tmp31_;
				const gchar* _tmp32_;
				gboolean _tmp33_ = FALSE;
				_tmp12_ = _pattern_it;
				_tmp13_ = vala_iterator_next (_tmp12_);
				if (!_tmp13_) {
					break;
				}
				_tmp14_ = _pattern_it;
				_tmp15_ = vala_iterator_get (_tmp14_);
				pattern = _tmp15_;
				_tmp16_ = self->priv->codenode_attributes_patterns;
				_tmp17_ = pattern;
				_tmp18_ = vala_map_get (_tmp16_, _tmp17_);
				pspec = (gchar*) _tmp18_;
				_tmp21_ = dot_required;
				if (_tmp21_) {
					const gchar* _tmp22_;
					gint _tmp23_ = 0;
					_tmp22_ = pspec;
					_tmp23_ = string_index_of_char (_tmp22_, (gunichar) '.', 0);
					_tmp20_ = (-1) == _tmp23_;
				} else {
					_tmp20_ = FALSE;
				}
				_tmp24_ = _tmp20_;
				if (_tmp24_) {
					_tmp19_ = TRUE;
				} else {
					gboolean _tmp25_ = FALSE;
					gboolean _tmp26_;
					gboolean _tmp29_;
					_tmp26_ = colon_required;
					if (_tmp26_) {
						const gchar* _tmp27_;
						gint _tmp28_ = 0;
						_tmp27_ = pspec;
						_tmp28_ = string_index_of_char (_tmp27_, (gunichar) ':', 0);
						_tmp25_ = (-1) == _tmp28_;
					} else {
						_tmp25_ = FALSE;
					}
					_tmp29_ = _tmp25_;
					_tmp19_ = _tmp29_;
				}
				_tmp30_ = _tmp19_;
				if (_tmp30_) {
					_g_free0 (pspec);
					continue;
				}
				_tmp31_ = pattern;
				_tmp32_ = codenode;
				_tmp33_ = g_pattern_match_string (_tmp31_, _tmp32_);
				if (_tmp33_) {
					const gchar* _tmp34_;
					gint _tmp35_ = 0;
					gchar** _tmp36_ = NULL;
					gchar** _tmp37_;
					gint _tmp37__length1;
					_tmp34_ = pspec;
					_tmp36_ = vala_gidl_parser_get_attributes (self, _tmp34_, &_tmp35_);
					_tmp37_ = _tmp36_;
					_tmp37__length1 = _tmp35_;
					if (result_length1) {
						*result_length1 = _tmp37__length1;
					}
					result = _tmp37_;
					_g_free0 (pspec);
					_vala_iterator_unref0 (_pattern_it);
					_vala_iterable_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_vala_iterator_unref0 (_pattern_it);
		}
		_vala_iterable_unref0 (pattern_specs);
	}
	_tmp38_ = attributes;
	if (_tmp38_ == NULL) {
		gchar** _tmp39_;
		gint _tmp39__length1;
		_tmp39_ = NULL;
		_tmp39__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp39__length1;
		}
		result = _tmp39_;
		_g_free0 (attributes);
		return result;
	}
	attr_list = NULL;
	_tmp40_ = attributes;
	_tmp41_ = strlen (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_string_sized_new ((gsize) _tmp42_);
	attr = _tmp43_;
	_tmp44_ = attributes;
	_tmp45_ = strlen (_tmp44_);
	_tmp46_ = _tmp45_;
	attributes_len = _tmp46_;
	_tmp47_ = attributes;
	remaining = _tmp47_;
	quoted = FALSE;
	escaped = FALSE;
	{
		gint b;
		b = 0;
		{
			gboolean _tmp48_;
			_tmp48_ = TRUE;
			while (TRUE) {
				gboolean _tmp49_;
				gint _tmp51_;
				gint _tmp52_;
				const gchar* _tmp53_;
				gunichar _tmp54_ = 0U;
				gunichar c;
				gboolean _tmp55_;
				const gchar* _tmp73_;
				const gchar* _tmp74_;
				gint _tmp75_ = 0;
				_tmp49_ = _tmp48_;
				if (!_tmp49_) {
					gint _tmp50_;
					_tmp50_ = b;
					b = _tmp50_ + 1;
				}
				_tmp48_ = FALSE;
				_tmp51_ = b;
				_tmp52_ = attributes_len;
				if (!(_tmp51_ < _tmp52_)) {
					break;
				}
				_tmp53_ = remaining;
				_tmp54_ = string_get_char (_tmp53_, (glong) 0);
				c = _tmp54_;
				_tmp55_ = escaped;
				if (_tmp55_) {
					GString* _tmp56_;
					gunichar _tmp57_;
					escaped = FALSE;
					_tmp56_ = attr;
					_tmp57_ = c;
					g_string_append_unichar (_tmp56_, _tmp57_);
				} else {
					gunichar _tmp58_;
					_tmp58_ = c;
					if (_tmp58_ == ((gunichar) '"')) {
						GString* _tmp59_;
						gunichar _tmp60_;
						gboolean _tmp61_;
						_tmp59_ = attr;
						_tmp60_ = c;
						g_string_append_unichar (_tmp59_, _tmp60_);
						_tmp61_ = quoted;
						quoted = !_tmp61_;
					} else {
						gunichar _tmp62_;
						_tmp62_ = c;
						if (_tmp62_ == ((gunichar) '\\')) {
							escaped = TRUE;
						} else {
							gboolean _tmp63_ = FALSE;
							gboolean _tmp64_;
							gboolean _tmp66_;
							_tmp64_ = quoted;
							if (!_tmp64_) {
								gunichar _tmp65_;
								_tmp65_ = c;
								_tmp63_ = _tmp65_ == ((gunichar) ' ');
							} else {
								_tmp63_ = FALSE;
							}
							_tmp66_ = _tmp63_;
							if (_tmp66_) {
								GString* _tmp67_;
								const gchar* _tmp68_;
								gchar* _tmp69_;
								GString* _tmp70_;
								_tmp67_ = attr;
								_tmp68_ = _tmp67_->str;
								_tmp69_ = g_strdup (_tmp68_);
								attr_list = g_slist_prepend (attr_list, _tmp69_);
								_tmp70_ = attr;
								g_string_truncate (_tmp70_, (gsize) 0);
							} else {
								GString* _tmp71_;
								gunichar _tmp72_;
								_tmp71_ = attr;
								_tmp72_ = c;
								g_string_append_unichar (_tmp71_, _tmp72_);
							}
						}
					}
				}
				_tmp73_ = remaining;
				_tmp74_ = remaining;
				_tmp75_ = string_index_of_nth_char (_tmp74_, (glong) 1);
				remaining = (const gchar*) (((gchar*) _tmp73_) + _tmp75_);
			}
		}
	}
	_tmp76_ = attr;
	_tmp77_ = _tmp76_->len;
	if (_tmp77_ > ((gssize) 0)) {
		GString* _tmp78_;
		const gchar* _tmp79_;
		gchar* _tmp80_;
		_tmp78_ = attr;
		_tmp79_ = _tmp78_->str;
		_tmp80_ = g_strdup (_tmp79_);
		attr_list = g_slist_prepend (attr_list, _tmp80_);
	}
	_tmp81_ = attr_list;
	_tmp82_ = g_slist_length (_tmp81_);
	_tmp83_ = g_new0 (gchar*, _tmp82_ + 1);
	attrs = _tmp83_;
	attrs_length1 = _tmp82_;
	_attrs_size_ = attrs_length1;
	_tmp84_ = attr_list;
	attr_i = _tmp84_;
	{
		gint a;
		a = 0;
		{
			gboolean _tmp85_;
			_tmp85_ = TRUE;
			while (TRUE) {
				gboolean _tmp86_;
				gint _tmp90_;
				gchar** _tmp91_;
				gint _tmp91__length1;
				gchar** _tmp92_;
				gint _tmp92__length1;
				gchar** _tmp93_;
				gint _tmp93__length1;
				gint _tmp94_;
				GSList* _tmp95_;
				gconstpointer _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				_tmp86_ = _tmp85_;
				if (!_tmp86_) {
					gint _tmp87_;
					GSList* _tmp88_;
					GSList* _tmp89_;
					_tmp87_ = a;
					a = _tmp87_ + 1;
					_tmp88_ = attr_i;
					_tmp89_ = _tmp88_->next;
					attr_i = _tmp89_;
				}
				_tmp85_ = FALSE;
				_tmp90_ = a;
				_tmp91_ = attrs;
				_tmp91__length1 = attrs_length1;
				if (!(_tmp90_ < _tmp91__length1)) {
					break;
				}
				_tmp92_ = attrs;
				_tmp92__length1 = attrs_length1;
				_tmp93_ = attrs;
				_tmp93__length1 = attrs_length1;
				_tmp94_ = a;
				_tmp95_ = attr_i;
				_tmp96_ = _tmp95_->data;
				_tmp97_ = g_strdup ((const gchar*) _tmp96_);
				_g_free0 (_tmp92_[(_tmp93__length1 - 1) - _tmp94_]);
				_tmp92_[(_tmp93__length1 - 1) - _tmp94_] = _tmp97_;
				_tmp98_ = _tmp92_[(_tmp93__length1 - 1) - _tmp94_];
			}
		}
	}
	_tmp99_ = attrs;
	_tmp99__length1 = attrs_length1;
	if (result_length1) {
		*result_length1 = _tmp99__length1;
	}
	result = _tmp99_;
	_g_string_free0 (attr);
	__g_slist_free__g_free0_0 (attr_list);
	_g_free0 (attributes);
	return result;
}


static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp3_ = s;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ >= 2) {
		const gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = s;
		_tmp7_ = g_str_has_prefix (_tmp6_, "\"");
		_tmp2_ = _tmp7_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = s;
		_tmp10_ = g_str_has_suffix (_tmp9_, "\"");
		_tmp1_ = _tmp10_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp11_ = _tmp1_;
	if (_tmp11_) {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		_tmp12_ = s;
		_tmp13_ = s;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_substring (_tmp12_, (glong) 1, (glong) (_tmp15_ - 2));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp16_;
	} else {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = s;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp18_;
	}
	result = _tmp0_;
	return result;
}


static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node) {
	ValaSignal* result = NULL;
	GIdlNodeSignal* _tmp0_;
	GIdlNode* node;
	gboolean _tmp1_ = FALSE;
	GIdlNodeSignal* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp6_;
	GIdlNode* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GIdlNodeSignal* _tmp11_;
	GIdlNodeParam* _tmp12_;
	ValaDataType* _tmp13_ = NULL;
	ValaDataType* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSignal* _tmp16_;
	ValaSignal* _tmp17_;
	ValaSignal* sig;
	ValaSignal* _tmp18_;
	ValaTypeSymbol* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	ValaSignal* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	gint _tmp27_ = 0;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar** attributes;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	ValaSignal* _tmp135_;
	gboolean first;
	GIdlNodeSignal* _tmp136_;
	GList* _tmp137_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	_tmp0_ = sig_node;
	node = (GIdlNode*) _tmp0_;
	_tmp2_ = sig_node;
	_tmp3_ = _tmp2_->deprecated;
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		GIdlNodeSignal* _tmp4_;
		GIdlNodeParam* _tmp5_;
		_tmp4_ = sig_node;
		_tmp5_ = _tmp4_->result;
		_tmp1_ = _tmp5_ == NULL;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		result = NULL;
		return result;
	}
	_tmp7_ = node;
	_tmp8_ = _tmp7_->name;
	_tmp9_ = vala_gidl_parser_fix_prop_name (self, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = sig_node;
	_tmp12_ = _tmp11_->result;
	_tmp13_ = vala_gidl_parser_parse_param (self, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->current_source_reference;
	_tmp16_ = vala_signal_new (_tmp10_, _tmp14_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp14_);
	_g_free0 (_tmp10_);
	sig = _tmp17_;
	_tmp18_ = sig;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp19_ = self->priv->current_data_type;
	_tmp20_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = sig;
	_tmp23_ = vala_symbol_get_name ((ValaSymbol*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf ("%s::%s", _tmp21_, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp28_ = vala_gidl_parser_get_attributes (self, _tmp26_, &_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp29__length1 = _tmp27_;
	_g_free0 (_tmp26_);
	_g_free0 (_tmp21_);
	attributes = _tmp29_;
	attributes_length1 = _tmp29__length1;
	_attributes_size_ = attributes_length1;
	_tmp30_ = attributes;
	_tmp30__length1 = attributes_length1;
	if (_tmp30_ != NULL) {
		gchar* ns_name;
		gchar** _tmp31_;
		gint _tmp31__length1;
		const gchar* _tmp126_;
		ns_name = NULL;
		_tmp31_ = attributes;
		_tmp31__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp31_;
			attr_collection_length1 = _tmp31__length1;
			for (attr_it = 0; attr_it < _tmp31__length1; attr_it = attr_it + 1) {
				gchar* _tmp32_;
				gchar* attr = NULL;
				_tmp32_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp32_;
				{
					const gchar* _tmp33_;
					gchar** _tmp34_;
					gchar** _tmp35_ = NULL;
					gchar** nv;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp36_;
					gint _tmp36__length1;
					const gchar* _tmp37_;
					_tmp33_ = attr;
					_tmp35_ = _tmp34_ = g_strsplit (_tmp33_, "=", 2);
					nv = _tmp35_;
					nv_length1 = _vala_array_length (_tmp34_);
					_nv_size_ = nv_length1;
					_tmp36_ = nv;
					_tmp36__length1 = nv_length1;
					_tmp37_ = _tmp36_[0];
					if (g_strcmp0 (_tmp37_, "name") == 0) {
						ValaSignal* _tmp38_;
						ValaSignal* _tmp39_;
						const gchar* _tmp40_;
						const gchar* _tmp41_;
						ValaSignal* _tmp42_;
						gchar** _tmp43_;
						gint _tmp43__length1;
						const gchar* _tmp44_;
						gchar* _tmp45_ = NULL;
						gchar* _tmp46_;
						_tmp38_ = sig;
						_tmp39_ = sig;
						_tmp40_ = vala_symbol_get_name ((ValaSymbol*) _tmp39_);
						_tmp41_ = _tmp40_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp38_, "CCode", "cname", _tmp41_, NULL);
						_tmp42_ = sig;
						_tmp43_ = nv;
						_tmp43__length1 = nv_length1;
						_tmp44_ = _tmp43_[1];
						_tmp45_ = vala_gidl_parser_eval (self, _tmp44_);
						_tmp46_ = _tmp45_;
						vala_symbol_set_name ((ValaSymbol*) _tmp42_, _tmp46_);
						_g_free0 (_tmp46_);
					} else {
						gboolean _tmp47_ = FALSE;
						gchar** _tmp48_;
						gint _tmp48__length1;
						const gchar* _tmp49_;
						gboolean _tmp54_;
						_tmp48_ = nv;
						_tmp48__length1 = nv_length1;
						_tmp49_ = _tmp48_[0];
						if (g_strcmp0 (_tmp49_, "has_emitter") == 0) {
							gchar** _tmp50_;
							gint _tmp50__length1;
							const gchar* _tmp51_;
							gchar* _tmp52_ = NULL;
							gchar* _tmp53_;
							_tmp50_ = nv;
							_tmp50__length1 = nv_length1;
							_tmp51_ = _tmp50_[1];
							_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
							_tmp53_ = _tmp52_;
							_tmp47_ = g_strcmp0 (_tmp53_, "1") == 0;
							_g_free0 (_tmp53_);
						} else {
							_tmp47_ = FALSE;
						}
						_tmp54_ = _tmp47_;
						if (_tmp54_) {
							ValaSignal* _tmp55_;
							_tmp55_ = sig;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp55_, "HasEmitter", TRUE, NULL);
						} else {
							gchar** _tmp56_;
							gint _tmp56__length1;
							const gchar* _tmp57_;
							_tmp56_ = nv;
							_tmp56__length1 = nv_length1;
							_tmp57_ = _tmp56_[0];
							if (g_strcmp0 (_tmp57_, "hidden") == 0) {
								gchar** _tmp58_;
								gint _tmp58__length1;
								const gchar* _tmp59_;
								gchar* _tmp60_ = NULL;
								gchar* _tmp61_;
								gboolean _tmp62_;
								_tmp58_ = nv;
								_tmp58__length1 = nv_length1;
								_tmp59_ = _tmp58_[1];
								_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
								_tmp61_ = _tmp60_;
								_tmp62_ = g_strcmp0 (_tmp61_, "1") == 0;
								_g_free0 (_tmp61_);
								if (_tmp62_) {
									result = NULL;
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									_g_free0 (ns_name);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									return result;
								}
							} else {
								gchar** _tmp63_;
								gint _tmp63__length1;
								const gchar* _tmp64_;
								_tmp63_ = nv;
								_tmp63__length1 = nv_length1;
								_tmp64_ = _tmp63_[0];
								if (g_strcmp0 (_tmp64_, "deprecated") == 0) {
									gchar** _tmp65_;
									gint _tmp65__length1;
									const gchar* _tmp66_;
									gchar* _tmp67_ = NULL;
									gchar* _tmp68_;
									gboolean _tmp69_;
									_tmp65_ = nv;
									_tmp65__length1 = nv_length1;
									_tmp66_ = _tmp65_[1];
									_tmp67_ = vala_gidl_parser_eval (self, _tmp66_);
									_tmp68_ = _tmp67_;
									_tmp69_ = g_strcmp0 (_tmp68_, "1") == 0;
									_g_free0 (_tmp68_);
									if (_tmp69_) {
										ValaSignal* _tmp70_;
										_tmp70_ = sig;
										vala_code_node_set_attribute ((ValaCodeNode*) _tmp70_, "Deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp71_;
									gint _tmp71__length1;
									const gchar* _tmp72_;
									_tmp71_ = nv;
									_tmp71__length1 = nv_length1;
									_tmp72_ = _tmp71_[0];
									if (g_strcmp0 (_tmp72_, "replacement") == 0) {
										ValaSignal* _tmp73_;
										gchar** _tmp74_;
										gint _tmp74__length1;
										const gchar* _tmp75_;
										gchar* _tmp76_ = NULL;
										gchar* _tmp77_;
										_tmp73_ = sig;
										_tmp74_ = nv;
										_tmp74__length1 = nv_length1;
										_tmp75_ = _tmp74_[1];
										_tmp76_ = vala_gidl_parser_eval (self, _tmp75_);
										_tmp77_ = _tmp76_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp73_, "Deprecated", "replacement", _tmp77_, NULL);
										_g_free0 (_tmp77_);
									} else {
										gchar** _tmp78_;
										gint _tmp78__length1;
										const gchar* _tmp79_;
										_tmp78_ = nv;
										_tmp78__length1 = nv_length1;
										_tmp79_ = _tmp78_[0];
										if (g_strcmp0 (_tmp79_, "deprecated_since") == 0) {
											ValaSignal* _tmp80_;
											gchar** _tmp81_;
											gint _tmp81__length1;
											const gchar* _tmp82_;
											gchar* _tmp83_ = NULL;
											gchar* _tmp84_;
											_tmp80_ = sig;
											_tmp81_ = nv;
											_tmp81__length1 = nv_length1;
											_tmp82_ = _tmp81_[1];
											_tmp83_ = vala_gidl_parser_eval (self, _tmp82_);
											_tmp84_ = _tmp83_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp80_, "Deprecated", "since", _tmp84_, NULL);
											_g_free0 (_tmp84_);
										} else {
											gchar** _tmp85_;
											gint _tmp85__length1;
											const gchar* _tmp86_;
											_tmp85_ = nv;
											_tmp85__length1 = nv_length1;
											_tmp86_ = _tmp85_[0];
											if (g_strcmp0 (_tmp86_, "transfer_ownership") == 0) {
												gchar** _tmp87_;
												gint _tmp87__length1;
												const gchar* _tmp88_;
												gchar* _tmp89_ = NULL;
												gchar* _tmp90_;
												gboolean _tmp91_;
												_tmp87_ = nv;
												_tmp87__length1 = nv_length1;
												_tmp88_ = _tmp87_[1];
												_tmp89_ = vala_gidl_parser_eval (self, _tmp88_);
												_tmp90_ = _tmp89_;
												_tmp91_ = g_strcmp0 (_tmp90_, "1") == 0;
												_g_free0 (_tmp90_);
												if (_tmp91_) {
													ValaSignal* _tmp92_;
													ValaDataType* _tmp93_;
													ValaDataType* _tmp94_;
													_tmp92_ = sig;
													_tmp93_ = vala_signal_get_return_type (_tmp92_);
													_tmp94_ = _tmp93_;
													vala_data_type_set_value_owned (_tmp94_, TRUE);
												}
											} else {
												gchar** _tmp95_;
												gint _tmp95__length1;
												const gchar* _tmp96_;
												_tmp95_ = nv;
												_tmp95__length1 = nv_length1;
												_tmp96_ = _tmp95_[0];
												if (g_strcmp0 (_tmp96_, "namespace_name") == 0) {
													gchar** _tmp97_;
													gint _tmp97__length1;
													const gchar* _tmp98_;
													gchar* _tmp99_ = NULL;
													_tmp97_ = nv;
													_tmp97__length1 = nv_length1;
													_tmp98_ = _tmp97_[1];
													_tmp99_ = vala_gidl_parser_eval (self, _tmp98_);
													_g_free0 (ns_name);
													ns_name = _tmp99_;
												} else {
													gchar** _tmp100_;
													gint _tmp100__length1;
													const gchar* _tmp101_;
													_tmp100_ = nv;
													_tmp100__length1 = nv_length1;
													_tmp101_ = _tmp100_[0];
													if (g_strcmp0 (_tmp101_, "type_name") == 0) {
														ValaSignal* _tmp102_;
														gchar** _tmp103_;
														gint _tmp103__length1;
														const gchar* _tmp104_;
														gchar* _tmp105_ = NULL;
														gchar* _tmp106_;
														ValaDataType* _tmp107_ = NULL;
														ValaDataType* _tmp108_;
														_tmp102_ = sig;
														_tmp103_ = nv;
														_tmp103__length1 = nv_length1;
														_tmp104_ = _tmp103_[1];
														_tmp105_ = vala_gidl_parser_eval (self, _tmp104_);
														_tmp106_ = _tmp105_;
														_tmp107_ = vala_gidl_parser_parse_type_from_string (self, _tmp106_, FALSE, NULL);
														_tmp108_ = _tmp107_;
														vala_signal_set_return_type (_tmp102_, _tmp108_);
														_vala_code_node_unref0 (_tmp108_);
														_g_free0 (_tmp106_);
													} else {
														gchar** _tmp109_;
														gint _tmp109__length1;
														const gchar* _tmp110_;
														_tmp109_ = nv;
														_tmp109__length1 = nv_length1;
														_tmp110_ = _tmp109_[0];
														if (g_strcmp0 (_tmp110_, "type_arguments") == 0) {
															ValaSignal* _tmp111_;
															ValaDataType* _tmp112_;
															ValaDataType* _tmp113_;
															gchar** _tmp114_;
															gint _tmp114__length1;
															const gchar* _tmp115_;
															gchar* _tmp116_ = NULL;
															gchar* _tmp117_;
															_tmp111_ = sig;
															_tmp112_ = vala_signal_get_return_type (_tmp111_);
															_tmp113_ = _tmp112_;
															_tmp114_ = nv;
															_tmp114__length1 = nv_length1;
															_tmp115_ = _tmp114_[1];
															_tmp116_ = vala_gidl_parser_eval (self, _tmp115_);
															_tmp117_ = _tmp116_;
															vala_gidl_parser_parse_type_arguments_from_string (self, _tmp113_, _tmp117_, NULL);
															_g_free0 (_tmp117_);
														} else {
															gchar** _tmp118_;
															gint _tmp118__length1;
															const gchar* _tmp119_;
															_tmp118_ = nv;
															_tmp118__length1 = nv_length1;
															_tmp119_ = _tmp118_[0];
															if (g_strcmp0 (_tmp119_, "experimental") == 0) {
																gchar** _tmp120_;
																gint _tmp120__length1;
																const gchar* _tmp121_;
																gchar* _tmp122_ = NULL;
																gchar* _tmp123_;
																gboolean _tmp124_;
																_tmp120_ = nv;
																_tmp120__length1 = nv_length1;
																_tmp121_ = _tmp120_[1];
																_tmp122_ = vala_gidl_parser_eval (self, _tmp121_);
																_tmp123_ = _tmp122_;
																_tmp124_ = g_strcmp0 (_tmp123_, "1") == 0;
																_g_free0 (_tmp123_);
																if (_tmp124_) {
																	ValaSignal* _tmp125_;
																	_tmp125_ = sig;
																	vala_code_node_set_attribute ((ValaCodeNode*) _tmp125_, "Experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
		_tmp126_ = ns_name;
		if (_tmp126_ != NULL) {
			ValaSignal* _tmp127_;
			ValaDataType* _tmp128_;
			ValaDataType* _tmp129_;
			ValaUnresolvedSymbol* _tmp130_;
			ValaUnresolvedSymbol* _tmp131_;
			const gchar* _tmp132_;
			ValaUnresolvedSymbol* _tmp133_;
			ValaUnresolvedSymbol* _tmp134_;
			_tmp127_ = sig;
			_tmp128_ = vala_signal_get_return_type (_tmp127_);
			_tmp129_ = _tmp128_;
			_tmp130_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp131_ = _tmp130_;
			_tmp132_ = ns_name;
			_tmp133_ = vala_unresolved_symbol_new (NULL, _tmp132_, NULL);
			_tmp134_ = _tmp133_;
			vala_unresolved_symbol_set_inner (_tmp131_, _tmp134_);
			_vala_code_node_unref0 (_tmp134_);
		}
		_g_free0 (ns_name);
	}
	_tmp135_ = sig;
	vala_signal_set_is_virtual (_tmp135_, TRUE);
	first = TRUE;
	_tmp136_ = sig_node;
	_tmp137_ = _tmp136_->parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp137_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				gboolean _tmp138_;
				GIdlNodeParam* _tmp139_;
				GIdlNode* param_node;
				ValaParameterDirection direction = 0;
				GIdlNodeParam* _tmp140_;
				ValaParameterDirection _tmp141_ = 0;
				ValaDataType* _tmp142_ = NULL;
				ValaDataType* param_type;
				GIdlNode* _tmp143_;
				const gchar* _tmp144_;
				ValaDataType* _tmp145_;
				ValaParameter* _tmp146_;
				ValaParameter* p;
				ValaParameter* _tmp147_;
				ValaParameterDirection _tmp148_;
				gboolean hide_param;
				gboolean show_param;
				ValaTypeSymbol* _tmp149_;
				gchar* _tmp150_ = NULL;
				gchar* _tmp151_;
				ValaSignal* _tmp152_;
				const gchar* _tmp153_;
				const gchar* _tmp154_;
				GIdlNode* _tmp155_;
				const gchar* _tmp156_;
				gchar* _tmp157_ = NULL;
				gchar* _tmp158_;
				gint _tmp159_ = 0;
				gchar** _tmp160_ = NULL;
				gchar** _tmp161_;
				gint _tmp161__length1;
				gboolean _tmp278_ = FALSE;
				gboolean _tmp279_;
				gboolean _tmp281_;
				_tmp138_ = first;
				if (_tmp138_) {
					first = FALSE;
					continue;
				}
				_tmp139_ = param;
				param_node = (GIdlNode*) _tmp139_;
				_tmp140_ = param;
				_tmp142_ = vala_gidl_parser_parse_param (self, _tmp140_, &_tmp141_);
				direction = _tmp141_;
				param_type = _tmp142_;
				_tmp143_ = param_node;
				_tmp144_ = _tmp143_->name;
				_tmp145_ = param_type;
				_tmp146_ = vala_parameter_new (_tmp144_, _tmp145_, NULL);
				p = _tmp146_;
				_tmp147_ = p;
				_tmp148_ = direction;
				vala_parameter_set_direction (_tmp147_, _tmp148_);
				hide_param = FALSE;
				show_param = FALSE;
				_tmp149_ = self->priv->current_data_type;
				_tmp150_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp149_, NULL);
				_tmp151_ = _tmp150_;
				_tmp152_ = sig;
				_tmp153_ = vala_symbol_get_name ((ValaSymbol*) _tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = param_node;
				_tmp156_ = _tmp155_->name;
				_tmp157_ = g_strdup_printf ("%s::%s.%s", _tmp151_, _tmp154_, _tmp156_);
				_tmp158_ = _tmp157_;
				_tmp160_ = vala_gidl_parser_get_attributes (self, _tmp158_, &_tmp159_);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes = _tmp160_;
				attributes_length1 = _tmp159_;
				_attributes_size_ = attributes_length1;
				_g_free0 (_tmp158_);
				_g_free0 (_tmp151_);
				_tmp161_ = attributes;
				_tmp161__length1 = attributes_length1;
				if (_tmp161_ != NULL) {
					gchar* ns_name;
					gchar** _tmp162_;
					gint _tmp162__length1;
					const gchar* _tmp271_;
					ns_name = NULL;
					_tmp162_ = attributes;
					_tmp162__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp162_;
						attr_collection_length1 = _tmp162__length1;
						for (attr_it = 0; attr_it < _tmp162__length1; attr_it = attr_it + 1) {
							gchar* _tmp163_;
							gchar* attr = NULL;
							_tmp163_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp163_;
							{
								const gchar* _tmp164_;
								gchar** _tmp165_;
								gchar** _tmp166_ = NULL;
								gchar** nv;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp167_;
								gint _tmp167__length1;
								const gchar* _tmp168_;
								_tmp164_ = attr;
								_tmp166_ = _tmp165_ = g_strsplit (_tmp164_, "=", 2);
								nv = _tmp166_;
								nv_length1 = _vala_array_length (_tmp165_);
								_nv_size_ = nv_length1;
								_tmp167_ = nv;
								_tmp167__length1 = nv_length1;
								_tmp168_ = _tmp167_[0];
								if (g_strcmp0 (_tmp168_, "hidden") == 0) {
									gchar** _tmp169_;
									gint _tmp169__length1;
									const gchar* _tmp170_;
									gchar* _tmp171_ = NULL;
									gchar* _tmp172_;
									gboolean _tmp173_;
									_tmp169_ = nv;
									_tmp169__length1 = nv_length1;
									_tmp170_ = _tmp169_[1];
									_tmp171_ = vala_gidl_parser_eval (self, _tmp170_);
									_tmp172_ = _tmp171_;
									_tmp173_ = g_strcmp0 (_tmp172_, "1") == 0;
									_g_free0 (_tmp172_);
									if (_tmp173_) {
										hide_param = TRUE;
									} else {
										gchar** _tmp174_;
										gint _tmp174__length1;
										const gchar* _tmp175_;
										gchar* _tmp176_ = NULL;
										gchar* _tmp177_;
										gboolean _tmp178_;
										_tmp174_ = nv;
										_tmp174__length1 = nv_length1;
										_tmp175_ = _tmp174_[1];
										_tmp176_ = vala_gidl_parser_eval (self, _tmp175_);
										_tmp177_ = _tmp176_;
										_tmp178_ = g_strcmp0 (_tmp177_, "0") == 0;
										_g_free0 (_tmp177_);
										if (_tmp178_) {
											show_param = TRUE;
										}
									}
								} else {
									gchar** _tmp179_;
									gint _tmp179__length1;
									const gchar* _tmp180_;
									_tmp179_ = nv;
									_tmp179__length1 = nv_length1;
									_tmp180_ = _tmp179_[0];
									if (g_strcmp0 (_tmp180_, "is_array") == 0) {
										gchar** _tmp181_;
										gint _tmp181__length1;
										const gchar* _tmp182_;
										gchar* _tmp183_ = NULL;
										gchar* _tmp184_;
										gboolean _tmp185_;
										_tmp181_ = nv;
										_tmp181__length1 = nv_length1;
										_tmp182_ = _tmp181_[1];
										_tmp183_ = vala_gidl_parser_eval (self, _tmp182_);
										_tmp184_ = _tmp183_;
										_tmp185_ = g_strcmp0 (_tmp184_, "1") == 0;
										_g_free0 (_tmp184_);
										if (_tmp185_) {
											ValaDataType* _tmp186_;
											ValaDataType* _tmp187_;
											ValaSourceReference* _tmp188_;
											ValaSourceReference* _tmp189_;
											ValaArrayType* _tmp190_;
											ValaParameter* _tmp191_;
											ValaDataType* _tmp192_;
											ValaParameter* _tmp193_;
											_tmp186_ = param_type;
											_tmp187_ = param_type;
											_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp187_);
											_tmp189_ = _tmp188_;
											_tmp190_ = vala_array_type_new (_tmp186_, 1, _tmp189_);
											_vala_code_node_unref0 (param_type);
											param_type = (ValaDataType*) _tmp190_;
											_tmp191_ = p;
											_tmp192_ = param_type;
											vala_variable_set_variable_type ((ValaVariable*) _tmp191_, _tmp192_);
											_tmp193_ = p;
											vala_parameter_set_direction (_tmp193_, VALA_PARAMETER_DIRECTION_IN);
										}
									} else {
										gchar** _tmp194_;
										gint _tmp194__length1;
										const gchar* _tmp195_;
										_tmp194_ = nv;
										_tmp194__length1 = nv_length1;
										_tmp195_ = _tmp194_[0];
										if (g_strcmp0 (_tmp195_, "no_array_length") == 0) {
											gchar** _tmp196_;
											gint _tmp196__length1;
											const gchar* _tmp197_;
											gchar* _tmp198_ = NULL;
											gchar* _tmp199_;
											gboolean _tmp200_;
											_tmp196_ = nv;
											_tmp196__length1 = nv_length1;
											_tmp197_ = _tmp196_[1];
											_tmp198_ = vala_gidl_parser_eval (self, _tmp197_);
											_tmp199_ = _tmp198_;
											_tmp200_ = g_strcmp0 (_tmp199_, "1") == 0;
											_g_free0 (_tmp199_);
											if (_tmp200_) {
												ValaParameter* _tmp201_;
												_tmp201_ = p;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp201_, "CCode", "array_length", FALSE, NULL);
											}
										} else {
											gchar** _tmp202_;
											gint _tmp202__length1;
											const gchar* _tmp203_;
											_tmp202_ = nv;
											_tmp202__length1 = nv_length1;
											_tmp203_ = _tmp202_[0];
											if (g_strcmp0 (_tmp203_, "array_length_type") == 0) {
												ValaParameter* _tmp204_;
												gchar** _tmp205_;
												gint _tmp205__length1;
												const gchar* _tmp206_;
												_tmp204_ = p;
												_tmp205_ = nv;
												_tmp205__length1 = nv_length1;
												_tmp206_ = _tmp205_[1];
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp204_, "CCode", "array_length_type", _tmp206_, NULL);
											} else {
												gchar** _tmp207_;
												gint _tmp207__length1;
												const gchar* _tmp208_;
												_tmp207_ = nv;
												_tmp207__length1 = nv_length1;
												_tmp208_ = _tmp207_[0];
												if (g_strcmp0 (_tmp208_, "array_null_terminated") == 0) {
													gchar** _tmp209_;
													gint _tmp209__length1;
													const gchar* _tmp210_;
													gchar* _tmp211_ = NULL;
													gchar* _tmp212_;
													gboolean _tmp213_;
													_tmp209_ = nv;
													_tmp209__length1 = nv_length1;
													_tmp210_ = _tmp209_[1];
													_tmp211_ = vala_gidl_parser_eval (self, _tmp210_);
													_tmp212_ = _tmp211_;
													_tmp213_ = g_strcmp0 (_tmp212_, "1") == 0;
													_g_free0 (_tmp212_);
													if (_tmp213_) {
														ValaParameter* _tmp214_;
														ValaParameter* _tmp215_;
														_tmp214_ = p;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp214_, "CCode", "array_length", FALSE, NULL);
														_tmp215_ = p;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp215_, "CCode", "array_null_terminated", TRUE, NULL);
													}
												} else {
													gchar** _tmp216_;
													gint _tmp216__length1;
													const gchar* _tmp217_;
													_tmp216_ = nv;
													_tmp216__length1 = nv_length1;
													_tmp217_ = _tmp216_[0];
													if (g_strcmp0 (_tmp217_, "is_out") == 0) {
														gchar** _tmp218_;
														gint _tmp218__length1;
														const gchar* _tmp219_;
														gchar* _tmp220_ = NULL;
														gchar* _tmp221_;
														gboolean _tmp222_;
														_tmp218_ = nv;
														_tmp218__length1 = nv_length1;
														_tmp219_ = _tmp218_[1];
														_tmp220_ = vala_gidl_parser_eval (self, _tmp219_);
														_tmp221_ = _tmp220_;
														_tmp222_ = g_strcmp0 (_tmp221_, "1") == 0;
														_g_free0 (_tmp221_);
														if (_tmp222_) {
															ValaParameter* _tmp223_;
															_tmp223_ = p;
															vala_parameter_set_direction (_tmp223_, VALA_PARAMETER_DIRECTION_OUT);
														}
													} else {
														gchar** _tmp224_;
														gint _tmp224__length1;
														const gchar* _tmp225_;
														_tmp224_ = nv;
														_tmp224__length1 = nv_length1;
														_tmp225_ = _tmp224_[0];
														if (g_strcmp0 (_tmp225_, "is_ref") == 0) {
															gchar** _tmp226_;
															gint _tmp226__length1;
															const gchar* _tmp227_;
															gchar* _tmp228_ = NULL;
															gchar* _tmp229_;
															gboolean _tmp230_;
															_tmp226_ = nv;
															_tmp226__length1 = nv_length1;
															_tmp227_ = _tmp226_[1];
															_tmp228_ = vala_gidl_parser_eval (self, _tmp227_);
															_tmp229_ = _tmp228_;
															_tmp230_ = g_strcmp0 (_tmp229_, "1") == 0;
															_g_free0 (_tmp229_);
															if (_tmp230_) {
																ValaParameter* _tmp231_;
																_tmp231_ = p;
																vala_parameter_set_direction (_tmp231_, VALA_PARAMETER_DIRECTION_REF);
															}
														} else {
															gchar** _tmp232_;
															gint _tmp232__length1;
															const gchar* _tmp233_;
															_tmp232_ = nv;
															_tmp232__length1 = nv_length1;
															_tmp233_ = _tmp232_[0];
															if (g_strcmp0 (_tmp233_, "nullable") == 0) {
																gchar** _tmp234_;
																gint _tmp234__length1;
																const gchar* _tmp235_;
																gchar* _tmp236_ = NULL;
																gchar* _tmp237_;
																gboolean _tmp238_;
																_tmp234_ = nv;
																_tmp234__length1 = nv_length1;
																_tmp235_ = _tmp234_[1];
																_tmp236_ = vala_gidl_parser_eval (self, _tmp235_);
																_tmp237_ = _tmp236_;
																_tmp238_ = g_strcmp0 (_tmp237_, "1") == 0;
																_g_free0 (_tmp237_);
																if (_tmp238_) {
																	ValaDataType* _tmp239_;
																	_tmp239_ = param_type;
																	vala_data_type_set_nullable (_tmp239_, TRUE);
																}
															} else {
																gchar** _tmp240_;
																gint _tmp240__length1;
																const gchar* _tmp241_;
																_tmp240_ = nv;
																_tmp240__length1 = nv_length1;
																_tmp241_ = _tmp240_[0];
																if (g_strcmp0 (_tmp241_, "transfer_ownership") == 0) {
																	gchar** _tmp242_;
																	gint _tmp242__length1;
																	const gchar* _tmp243_;
																	gchar* _tmp244_ = NULL;
																	gchar* _tmp245_;
																	gboolean _tmp246_;
																	_tmp242_ = nv;
																	_tmp242__length1 = nv_length1;
																	_tmp243_ = _tmp242_[1];
																	_tmp244_ = vala_gidl_parser_eval (self, _tmp243_);
																	_tmp245_ = _tmp244_;
																	_tmp246_ = g_strcmp0 (_tmp245_, "1") == 0;
																	_g_free0 (_tmp245_);
																	if (_tmp246_) {
																		ValaDataType* _tmp247_;
																		_tmp247_ = param_type;
																		vala_data_type_set_value_owned (_tmp247_, TRUE);
																	}
																} else {
																	gchar** _tmp248_;
																	gint _tmp248__length1;
																	const gchar* _tmp249_;
																	_tmp248_ = nv;
																	_tmp248__length1 = nv_length1;
																	_tmp249_ = _tmp248_[0];
																	if (g_strcmp0 (_tmp249_, "type_name") == 0) {
																		ValaParameter* _tmp250_;
																		gchar** _tmp251_;
																		gint _tmp251__length1;
																		const gchar* _tmp252_;
																		gchar* _tmp253_ = NULL;
																		gchar* _tmp254_;
																		ValaDataType* _tmp255_ = NULL;
																		ValaDataType* _tmp256_;
																		_tmp250_ = p;
																		_tmp251_ = nv;
																		_tmp251__length1 = nv_length1;
																		_tmp252_ = _tmp251_[1];
																		_tmp253_ = vala_gidl_parser_eval (self, _tmp252_);
																		_tmp254_ = _tmp253_;
																		_tmp255_ = vala_gidl_parser_parse_type_from_string (self, _tmp254_, FALSE, NULL);
																		_vala_code_node_unref0 (param_type);
																		param_type = _tmp255_;
																		_tmp256_ = param_type;
																		vala_variable_set_variable_type ((ValaVariable*) _tmp250_, _tmp256_);
																		_g_free0 (_tmp254_);
																	} else {
																		gchar** _tmp257_;
																		gint _tmp257__length1;
																		const gchar* _tmp258_;
																		_tmp257_ = nv;
																		_tmp257__length1 = nv_length1;
																		_tmp258_ = _tmp257_[0];
																		if (g_strcmp0 (_tmp258_, "type_arguments") == 0) {
																			ValaParameter* _tmp259_;
																			ValaDataType* _tmp260_;
																			ValaDataType* _tmp261_;
																			gchar** _tmp262_;
																			gint _tmp262__length1;
																			const gchar* _tmp263_;
																			gchar* _tmp264_ = NULL;
																			gchar* _tmp265_;
																			_tmp259_ = p;
																			_tmp260_ = vala_variable_get_variable_type ((ValaVariable*) _tmp259_);
																			_tmp261_ = _tmp260_;
																			_tmp262_ = nv;
																			_tmp262__length1 = nv_length1;
																			_tmp263_ = _tmp262_[1];
																			_tmp264_ = vala_gidl_parser_eval (self, _tmp263_);
																			_tmp265_ = _tmp264_;
																			vala_gidl_parser_parse_type_arguments_from_string (self, _tmp261_, _tmp265_, NULL);
																			_g_free0 (_tmp265_);
																		} else {
																			gchar** _tmp266_;
																			gint _tmp266__length1;
																			const gchar* _tmp267_;
																			_tmp266_ = nv;
																			_tmp266__length1 = nv_length1;
																			_tmp267_ = _tmp266_[0];
																			if (g_strcmp0 (_tmp267_, "namespace_name") == 0) {
																				gchar** _tmp268_;
																				gint _tmp268__length1;
																				const gchar* _tmp269_;
																				gchar* _tmp270_ = NULL;
																				_tmp268_ = nv;
																				_tmp268__length1 = nv_length1;
																				_tmp269_ = _tmp268_[1];
																				_tmp270_ = vala_gidl_parser_eval (self, _tmp269_);
																				_g_free0 (ns_name);
																				ns_name = _tmp270_;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
					_tmp271_ = ns_name;
					if (_tmp271_ != NULL) {
						ValaDataType* _tmp272_;
						ValaUnresolvedSymbol* _tmp273_;
						ValaUnresolvedSymbol* _tmp274_;
						const gchar* _tmp275_;
						ValaUnresolvedSymbol* _tmp276_;
						ValaUnresolvedSymbol* _tmp277_;
						_tmp272_ = param_type;
						_tmp273_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp272_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp274_ = _tmp273_;
						_tmp275_ = ns_name;
						_tmp276_ = vala_unresolved_symbol_new (NULL, _tmp275_, NULL);
						_tmp277_ = _tmp276_;
						vala_unresolved_symbol_set_inner (_tmp274_, _tmp277_);
						_vala_code_node_unref0 (_tmp277_);
					}
					_g_free0 (ns_name);
				}
				_tmp279_ = show_param;
				if (_tmp279_) {
					_tmp278_ = TRUE;
				} else {
					gboolean _tmp280_;
					_tmp280_ = hide_param;
					_tmp278_ = !_tmp280_;
				}
				_tmp281_ = _tmp278_;
				if (_tmp281_) {
					ValaSignal* _tmp282_;
					ValaParameter* _tmp283_;
					_tmp282_ = sig;
					_tmp283_ = p;
					vala_signal_add_parameter (_tmp282_, _tmp283_);
				}
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ValaGIdlParser* vala_gidl_parser_construct (GType object_type) {
	ValaGIdlParser* self = NULL;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIdlParser* vala_gidl_parser_new (void) {
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}


static void vala_gidl_parser_class_init (ValaGIdlParserClass * klass) {
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIdlParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gidl_parser_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gidl_parser_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gidl_parser_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gidl_parser_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gidl_parser_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gidl_parser_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gidl_parser_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_gidl_parser_real_visit_source_file;
}


static void vala_gidl_parser_instance_init (ValaGIdlParser * self) {
	self->priv = VALA_GIDL_PARSER_GET_PRIVATE (self);
}


static void vala_gidl_parser_finalize (ValaCodeVisitor* obj) {
	ValaGIdlParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIDL_PARSER, ValaGIdlParser);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	_vala_map_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all GIDL files.
 */
GType vala_gidl_parser_get_type (void) {
	static volatile gsize vala_gidl_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gidl_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
		GType vala_gidl_parser_type_id;
		vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gidl_parser_type_id__volatile, vala_gidl_parser_type_id);
	}
	return vala_gidl_parser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



