/**
 * @file geis_backend_protected.h
 * @brief internal GEIS back end base class "protected" interface
 *
 * This file contains the implementation interface for the various GEIS v2 back
 * ends.
 */

/*
 * Copyright 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef GEIS_BACKEND_PROTECTED_H_
#define GEIS_BACKEND_PROTECTED_H_

#include "geis/geis.h"
#include "geis_backend.h"


/**
 * The custom dispatch table for "derived" GEIS v2 backends.
 */
typedef struct _GeisBackendVtable
{
  void       (* finalize)(GeisBackend);
  GeisStatus (* subscribe)(GeisBackend, GeisSubscription);
  GeisStatus (* unsubscribe)(GeisBackend, GeisSubscription);
} *GeisBackendVtable;

/**
 * The "base" class of all the GEIS v2 backends.
 */
struct _GeisBackend {
  GeisString        be_name;
  GeisBackendVtable be_vtbl;
};


/**
 * Initializes the base portion of the GEIS v2 backends.
 *
 * @param[in] be_base  The GeisBackend portion of the back end object.
 * @param[in] be_vtbl  An initialized GeisBackendVtable.
 * @param[in] be_name  The name of the back end.
 */
void geis_backend_init_base(GeisBackend        be_base,
                            GeisBackendVtable  be_vtbl,
                            GeisString         be_name);

#endif /* GEIS_BACKEND_PROTECTED_H_ */
