/**
 * @file geis_backend_test_fixture.h
 * @brief internal GEIS test fixture back end class
 *
 * Copyright 2010, 2011 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef GEIS_BACKEND_TEST_FIXTURE_H_
#define GEIS_BACKEND_TEST_FIXTURE_H_

#include "geis/geis.h"

/**
 * Constructs a new GEIS Test Fuixture back end.
 *
 * @param[in] geis          The API instance the back end will run in.
 * @param[in] track_devices Indicates devices should be tracked.
 * @param[in] track_classes Indicates classes should be tracked.
 *
 * The Test Fixture back end is used in unit tests.
 */
GeisBackend geis_backend_new_test_fixture(Geis geis,
                                          GeisBoolean track_devices,
                                          GeisBoolean track_classes);

#endif /* GEIS_BACKEND_TEST_FIXTURE_H_ */
