/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 */

#ifndef UNITY_LENS_BAR_ICON_H_
#define UNITY_LENS_BAR_ICON_H_

#include <string>

#include <NuxGraphics/GraphicsEngine.h>
#include <Nux/Nux.h>
#include <Nux/HLayout.h>
#include <Nux/View.h>

#include "IconTexture.h"

namespace unity
{
namespace dash
{

class LensBarIcon : public IconTexture
{
  NUX_DECLARE_OBJECT_TYPE(LensBarIcon, IconTexture);
public:
  LensBarIcon(std::string id, std::string icon_hint);
  ~LensBarIcon();

  nux::Property<std::string> id;
  nux::Property<bool> active;

private:
  void Draw(nux::GraphicsEngine& gfx_context, bool force_draw);
  void OnActiveChanged(bool is_active);

private:
  const float inactive_opacity_;
};

}
}
#endif
