/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

namespace Unity.Testing
{
  public class Director : Object
  {
    public Clutter.Stage stage {
        get;
        construct;
    }
    
    private bool break_loop = false;

    public Director (Clutter.Stage stage)
    {
      Object (stage:stage);
    }

    construct
    {

    }

    private void do_event (Clutter.Actor actor,
                           Clutter.Event event,
                           bool          capture_phase)
    {
      actor.do_event (event, capture_phase);
      while (Gtk.events_pending ())
        Gtk.main_iteration ();
    }

    public void do_wait_for_animation (Clutter.Actor actor)
    {
      Clutter.Animation? anim = actor.get_animation ();

      while (anim is Clutter.Animation
             && anim.timeline.is_playing ())
        {
          Gtk.main_iteration ();
        }
    }
    
    public void do_wait_for_timeout (uint32 msecs)
    {
      break_loop = false;
      GLib.Timeout.add (msecs,
                        () => { this.break_loop = true; return false; });
      while (break_loop != true)
        {
          Gtk.main_iteration ();
        }                
    }
    
    public void button_press (Clutter.Actor actor,
                              uint32        button,
                              bool          autorelease,
                              float         relative_x,
                              float         relative_y,
                              bool          wait_for_animation)
    {
      float actor_x, actor_y;
      Clutter.ButtonEvent event = Clutter.ButtonEvent ();

      actor.get_transformed_position (out actor_x, out actor_y);

      event.type = Clutter.EventType.BUTTON_PRESS;
      event.time = Clutter.get_current_event_time ();
      event.flags &= Clutter.EventFlags.FLAG_SYNTHETIC;
      event.stage = actor.get_stage () as Clutter.Stage;
      event.source = actor;
      event.x = actor_x + relative_x;
      event.y = actor_y + relative_y;
      event.button = button;

      do_event (actor, (Clutter.Event)event, false);
      
      if (wait_for_animation)
        do_wait_for_animation(actor);
      
      if (autorelease)
        {
          event.type = Clutter.EventType.BUTTON_RELEASE;
          event.time = Clutter.get_current_event_time ();

          do_event (actor, (Clutter.Event)event, false);
          
          if (wait_for_animation)
            do_wait_for_animation(actor);

        }
    }

    public void button_release (Clutter.Actor actor,
                                uint32        button,
                                float         relative_x,
                                float         relative_y)
    {
      float actor_x, actor_y;
      Clutter.ButtonEvent event = Clutter.ButtonEvent ();

      actor.get_transformed_position (out actor_x, out actor_y);

      event.type = Clutter.EventType.BUTTON_RELEASE;
      event.time = Clutter.get_current_event_time ();
      event.flags &= Clutter.EventFlags.FLAG_SYNTHETIC;
      event.stage = actor.get_stage () as Clutter.Stage;
      event.source = actor;
      event.x = actor_x + relative_x;
      event.y = actor_y + relative_y;
      event.button = button;

      do_event (actor, (Clutter.Event)event, false);
    }

    public void enter_event (Clutter.Actor actor,
                             float         relative_x,
                             float         relative_y)
    {
      float actor_x, actor_y;
      Clutter.CrossingEvent event = Clutter.CrossingEvent ();

      actor.get_transformed_position (out actor_x, out actor_y);

      event.type = Clutter.EventType.ENTER;
      event.time = Clutter.get_current_event_time ();
      event.flags &= Clutter.EventFlags.FLAG_SYNTHETIC;
      event.stage = actor.get_stage () as Clutter.Stage;
      event.source = event.stage;
      event.x = actor_x + relative_x;
      event.y = actor_y + relative_y;

      do_event (actor, (Clutter.Event)event, false);
    }

    public void leave_event (Clutter.Actor actor,
                             float         relative_x,
                             float         relative_y)
    {
      float actor_x, actor_y;
      Clutter.CrossingEvent event = Clutter.CrossingEvent ();

      actor.get_transformed_position (out actor_x, out actor_y);

      event.type = Clutter.EventType.LEAVE;
      event.time = Clutter.get_current_event_time ();
      event.flags &= Clutter.EventFlags.FLAG_SYNTHETIC;
      event.stage = actor.get_stage () as Clutter.Stage;
      event.source = event.stage;
      event.x = actor_x + relative_x;
      event.y = actor_y + relative_y;

      do_event (actor, (Clutter.Event)event, false);
    }

    public void motion_event (Clutter.Actor actor,
                              float relative_startx,
                              float relative_starty,
                              float relative_endx,
                              float relative_endy)
    {
      /* FIXME: Need to fake a series of events to act a mouse has moved */
    }
  }
}
