/* utils.c generated by valac 0.11.7, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <zeitgeist.h>
#include <dee.h>
#include <gee.h>
#include <unity.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityFilesPlaceUtilsGetIconForUriAsyncData UnityFilesPlaceUtilsGetIconForUriAsyncData;

#define UNITY_FILES_PLACE_TYPE_GROUP (unity_files_place_group_get_type ())
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _UnityFilesPlaceUtilsListDirData UnityFilesPlaceUtilsListDirData;

#define UNITY_FILES_PLACE_TYPE_RESULTS_COLUMN (unity_files_place_results_column_get_type ())

struct _UnityFilesPlaceUtilsGetIconForUriAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* uri;
	gchar* mimetype;
	gchar* result;
	GFile* _tmp0_;
	GFile* f;
	GFileInfo* _tmp1_;
	GFileInfo* info;
	gchar* _tmp2_;
	GError * e;
	GIcon* _tmp3_;
	GIcon* icon2;
	gchar* _tmp4_;
	GError * _inner_error_;
};

typedef enum  {
	UNITY_FILES_PLACE_GROUP_TOP_RESULTS,
	UNITY_FILES_PLACE_GROUP_RECENT,
	UNITY_FILES_PLACE_GROUP_DOWNLOADS,
	UNITY_FILES_PLACE_GROUP_FAVORITE_FOLDERS,
	UNITY_FILES_PLACE_GROUP_FILES,
	UNITY_FILES_PLACE_GROUP_EMPTY_SEARCH,
	UNITY_FILES_PLACE_GROUP_EMPTY_SECTION,
	UNITY_FILES_PLACE_GROUP_TODAY,
	UNITY_FILES_PLACE_GROUP_YESTERDAY,
	UNITY_FILES_PLACE_GROUP_THIS_WEEK,
	UNITY_FILES_PLACE_GROUP_LAST_WEEK,
	UNITY_FILES_PLACE_GROUP_THIS_MONTH,
	UNITY_FILES_PLACE_GROUP_PAST_SIX_MONTHS,
	UNITY_FILES_PLACE_GROUP_THIS_YEAR,
	UNITY_FILES_PLACE_GROUP_LAST_YEAR
} UnityFilesPlaceGroup;

struct _UnityFilesPlaceUtilsListDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* folder;
	GSList* result;
	GSList* _result_;
	GFileEnumerator* _tmp0_;
	GFileEnumerator* e;
	GList* _tmp1_;
	GList* file_infos;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp2_;
	GFileInfo* info;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* colkey;
	GFileInfo* _tmp8_;
	GCompareFunc cmpfunc;
	GError * _inner_error_;
};

typedef enum  {
	UNITY_FILES_PLACE_RESULTS_COLUMN_URI = 0,
	UNITY_FILES_PLACE_RESULTS_COLUMN_ICON_HINT,
	UNITY_FILES_PLACE_RESULTS_COLUMN_GROUP_ID,
	UNITY_FILES_PLACE_RESULTS_COLUMN_MIMETYPE,
	UNITY_FILES_PLACE_RESULTS_COLUMN_DISPLAY_NAME,
	UNITY_FILES_PLACE_RESULTS_COLUMN_COMMENT
} UnityFilesPlaceResultsColumn;



#define UNITY_FILES_PLACE_UTILS_icon_attribs G_FILE_ATTRIBUTE_PREVIEW_ICON "," G_FILE_ATTRIBUTE_STANDARD_ICON "," G_FILE_ATTRIBUTE_THUMBNAIL_PATH
#define UNITY_FILES_PLACE_UTILS_file_attribs G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_TIME_ACCESS
#define UNITY_FILES_PLACE_UTILS_hide_attribs G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN
#define UNITY_FILES_PLACE_UTILS_all_attribs UNITY_FILES_PLACE_UTILS_icon_attribs "," UNITY_FILES_PLACE_UTILS_file_attribs "," UNITY_FILES_PLACE_UTILS_hide_attribs
gchar* unity_files_place_utils_get_icon_for_uri (const gchar* uri, const gchar* mimetype);
gchar* unity_files_place_utils_check_icon_string (const gchar* uri, const gchar* mimetype, GFileInfo* info);
static void unity_files_place_utils_get_icon_for_uri_async_data_free (gpointer _data);
void unity_files_place_utils_get_icon_for_uri_async (const gchar* uri, const gchar* mimetype, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* unity_files_place_utils_get_icon_for_uri_finish (GAsyncResult* _res_);
static gboolean unity_files_place_utils_get_icon_for_uri_async_co (UnityFilesPlaceUtilsGetIconForUriAsyncData* data);
static void unity_files_place_utils_get_icon_for_uri_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint unity_files_place_utils_cmp_file_info_by_mtime (GFileInfo* info1, GFileInfo* info2);
gchar* unity_files_place_utils_get_month_name (GDateMonth month);
gchar* unity_files_place_utils_get_day_name (GDateWeekday weekday);
guint unity_files_place_utils_get_time_group (ZeitgeistEvent* event, DeeModel* groups_model, gchar** comment);
GType unity_files_place_group_get_type (void) G_GNUC_CONST;
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void unity_files_place_utils_list_dir_data_free (gpointer _data);
void unity_files_place_utils_list_dir (GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_);
GSList* unity_files_place_utils_list_dir_finish (GAsyncResult* _res_, GError** error);
static gboolean unity_files_place_utils_list_dir_co (UnityFilesPlaceUtilsListDirData* data);
static void unity_files_place_utils_list_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free__g_object_unref0_ (GList* self);
static gint _lambda2_ (gconstpointer info1, gconstpointer info2);
static gint __lambda2__gcompare_func (gconstpointer a, gconstpointer b);
void unity_files_place_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set);
GType unity_files_place_results_column_get_type (void) G_GNUC_CONST;
gboolean unity_files_place_utils_check_is_filter_search (UnityPlaceSearch* new_search, UnityPlaceSearch* old_search);
GeeSet* unity_files_place_utils_get_uri_set (ZeitgeistResultSet* results);
gboolean unity_files_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search);
gchar* unity_files_place_utils_normalize_string (const gchar* input);


gchar* unity_files_place_utils_get_icon_for_uri (const gchar* uri, const gchar* mimetype) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* f;
	gboolean _tmp1_;
	GFileInfo* _tmp6_ = NULL;
	GFileInfo* info;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	f = _tmp0_;
	_tmp1_ = g_file_is_native (f);
	if (!_tmp1_) {
		GIcon* _tmp2_ = NULL;
		GIcon* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp2_ = g_content_type_get_icon (mimetype);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_icon_to_string (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		result = _tmp5_;
		_g_object_unref0 (f);
		return result;
	}
	_tmp6_ = g_file_query_info (f, UNITY_FILES_PLACE_UTILS_icon_attribs, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp6_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		goto __catch15_g_error;
	}
	_tmp7_ = unity_files_place_utils_check_icon_string (uri, mimetype, info);
	result = _tmp7_;
	_g_object_unref0 (info);
	_g_object_unref0 (f);
	return result;
	_g_object_unref0 (info);
	_g_object_unref0 (f);
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		GIcon* _tmp8_ = NULL;
		GIcon* icon2;
		gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = g_content_type_get_icon (mimetype);
		icon2 = _tmp8_;
		_tmp9_ = g_icon_to_string (icon2);
		result = _tmp9_;
		_g_object_unref0 (icon2);
		_g_error_free0 (e);
		return result;
	}
	__finally15:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void unity_files_place_utils_get_icon_for_uri_async_data_free (gpointer _data) {
	UnityFilesPlaceUtilsGetIconForUriAsyncData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_free0 (data->mimetype);
	_g_free0 (data->result);
	g_slice_free (UnityFilesPlaceUtilsGetIconForUriAsyncData, data);
}


void unity_files_place_utils_get_icon_for_uri_async (const gchar* uri, const gchar* mimetype, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceUtilsGetIconForUriAsyncData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceUtilsGetIconForUriAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_files_place_utils_get_icon_for_uri_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_utils_get_icon_for_uri_async_data_free);
	_data_->uri = g_strdup (uri);
	_data_->mimetype = g_strdup (mimetype);
	unity_files_place_utils_get_icon_for_uri_async_co (_data_);
}


gchar* unity_files_place_utils_get_icon_for_uri_finish (GAsyncResult* _res_) {
	gchar* result;
	UnityFilesPlaceUtilsGetIconForUriAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_files_place_utils_get_icon_for_uri_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceUtilsGetIconForUriAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_files_place_utils_get_icon_for_uri_async_co (data);
}


static gboolean unity_files_place_utils_get_icon_for_uri_async_co (UnityFilesPlaceUtilsGetIconForUriAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_new_for_uri (data->uri);
	data->f = data->_tmp0_;
	data->_state_ = 1;
	g_file_query_info_async (data->f, UNITY_FILES_PLACE_UTILS_icon_attribs, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, unity_files_place_utils_get_icon_for_uri_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_query_info_finish (data->f, data->_res_, &data->_inner_error_);
	data->info = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->f);
		goto __catch16_g_error;
	}
	data->_tmp2_ = NULL;
	data->_tmp2_ = unity_files_place_utils_check_icon_string (data->uri, data->mimetype, data->info);
	data->result = data->_tmp2_;
	_g_object_unref0 (data->info);
	_g_object_unref0 (data->f);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->info);
	_g_object_unref0 (data->f);
	goto __finally16;
	__catch16_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_content_type_get_icon (data->mimetype);
		data->icon2 = data->_tmp3_;
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_icon_to_string (data->icon2);
		data->result = data->_tmp4_;
		_g_object_unref0 (data->icon2);
		_g_error_free0 (data->e);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally16:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
	g_clear_error (&data->_inner_error_);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* unity_files_place_utils_check_icon_string (const gchar* uri, const gchar* mimetype, GFileInfo* info) {
	gchar* result = NULL;
	GIcon* _tmp0_ = NULL;
	GIcon* _tmp1_;
	GIcon* icon;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* thumbnail_path;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = g_file_info_get_icon (info);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon = _tmp1_;
	_tmp2_ = g_file_info_get_attribute_byte_string (info, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
	_tmp3_ = g_strdup (_tmp2_);
	thumbnail_path = _tmp3_;
	if (thumbnail_path == NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_icon_to_string (icon);
		result = _tmp4_;
		_g_free0 (thumbnail_path);
		_g_object_unref0 (icon);
		return result;
	} else {
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileIcon* _tmp7_ = NULL;
		GFileIcon* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp5_ = g_file_new_for_path (thumbnail_path);
		_tmp6_ = _tmp5_;
		_tmp7_ = (GFileIcon*) g_file_icon_new (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_icon_to_string ((GIcon*) _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		result = _tmp10_;
		_g_free0 (thumbnail_path);
		_g_object_unref0 (icon);
		return result;
	}
	_g_free0 (thumbnail_path);
	_g_object_unref0 (icon);
}


gint unity_files_place_utils_cmp_file_info_by_mtime (GFileInfo* info1, GFileInfo* info2) {
	gint result = 0;
	GTimeVal tv1 = {0};
	GTimeVal tv2 = {0};
	GTimeVal _tmp0_ = {0};
	GTimeVal _tmp1_ = {0};
	glong cmp;
	gint _tmp2_ = 0;
	g_return_val_if_fail (info1 != NULL, 0);
	g_return_val_if_fail (info2 != NULL, 0);
	g_file_info_get_modification_time (info1, &_tmp0_);
	tv1 = _tmp0_;
	g_file_info_get_modification_time (info2, &_tmp1_);
	tv2 = _tmp1_;
	cmp = tv1.tv_sec - tv2.tv_sec;
	if (cmp < 0) {
		_tmp2_ = 1;
	} else {
		gint _tmp3_ = 0;
		if (cmp > 0) {
			_tmp3_ = -1;
		} else {
			_tmp3_ = 0;
		}
		_tmp2_ = _tmp3_;
	}
	result = _tmp2_;
	return result;
}


gchar* unity_files_place_utils_get_month_name (GDateMonth month) {
	gchar* result = NULL;
	gchar* _tmp26_;
	switch (month) {
		case G_DATE_BAD_MONTH:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			_tmp0_ = _ ("Invalid Month");
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case G_DATE_JANUARY:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp2_ = _ ("January");
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case G_DATE_FEBRUARY:
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp4_ = _ ("February");
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case G_DATE_MARCH:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp6_ = _ ("March");
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case G_DATE_APRIL:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = _ ("April");
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		case G_DATE_MAY:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp10_ = _ ("May");
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		}
		case G_DATE_JUNE:
		{
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp12_ = _ ("June");
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
		case G_DATE_JULY:
		{
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp14_ = _ ("July");
			_tmp15_ = g_strdup (_tmp14_);
			result = _tmp15_;
			return result;
		}
		case G_DATE_AUGUST:
		{
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp16_ = _ ("August");
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			return result;
		}
		case G_DATE_SEPTEMBER:
		{
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			_tmp18_ = _ ("September");
			_tmp19_ = g_strdup (_tmp18_);
			result = _tmp19_;
			return result;
		}
		case G_DATE_OCTOBER:
		{
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			_tmp20_ = _ ("October");
			_tmp21_ = g_strdup (_tmp20_);
			result = _tmp21_;
			return result;
		}
		case G_DATE_NOVEMBER:
		{
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			_tmp22_ = _ ("November");
			_tmp23_ = g_strdup (_tmp22_);
			result = _tmp23_;
			return result;
		}
		case G_DATE_DECEMBER:
		{
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			_tmp24_ = _ ("December");
			_tmp25_ = g_strdup (_tmp24_);
			result = _tmp25_;
			return result;
		}
		default:
		break;
	}
	_tmp26_ = g_strdup ("Internal Error");
	result = _tmp26_;
	return result;
}


gchar* unity_files_place_utils_get_day_name (GDateWeekday weekday) {
	gchar* result = NULL;
	switch (weekday) {
		case G_DATE_MONDAY:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			_tmp0_ = _ ("Monday");
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case G_DATE_TUESDAY:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp2_ = _ ("Tuesday");
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case G_DATE_WEDNESDAY:
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp4_ = _ ("Wednesday");
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case G_DATE_THURSDAY:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp6_ = _ ("Thursday");
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case G_DATE_FRIDAY:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = _ ("Friday");
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		case G_DATE_SATURDAY:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp10_ = _ ("Saturday");
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		}
		case G_DATE_SUNDAY:
		{
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp12_ = _ ("Sunday");
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
		default:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("Internal Error");
			result = _tmp14_;
			return result;
		}
	}
}


guint unity_files_place_utils_get_time_group (ZeitgeistEvent* event, DeeModel* groups_model, gchar** comment) {
	gchar* _comment = NULL;
	guint result = 0U;
	gint64 _tmp0_;
	gint64 t;
	gint64 _tmp1_;
	gint64 now;
	gint64 delta;
	gint64 _tmp2_;
	gint64 limit;
	GDate date = {0};
	GDate _tmp19_ = {0};
	GDateWeekday _tmp20_;
	GDate datethen = {0};
	GDate _tmp21_ = {0};
	GDateWeekday _tmp22_;
	gchar* _tmp23_ = NULL;
	gint64 _tmp24_;
	GDateMonth _tmp30_;
	gchar* _tmp31_ = NULL;
	gint64 _tmp32_;
	GDate _tmp33_ = {0};
	gint64 _tmp34_;
	g_return_val_if_fail (event != NULL, 0U);
	g_return_val_if_fail (groups_model != NULL, 0U);
	_tmp0_ = zeitgeist_event_get_timestamp (event);
	t = _tmp0_;
	_tmp1_ = zeitgeist_timestamp_for_now ();
	now = _tmp1_;
	delta = now - t;
	_tmp2_ = zeitgeist_timestamp_prev_midnight (now);
	limit = _tmp2_;
	if (t > limit) {
		gint64 hour;
		hour = ZEITGEIST_TIMESTAMP_HOUR;
		if (delta > (hour * 7)) {
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = _ ("Earlier today");
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (_comment);
			_comment = _tmp4_;
		} else {
			if (delta > (hour * 6)) {
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				_tmp5_ = _ ("Five hours ago");
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (_comment);
				_comment = _tmp6_;
			} else {
				if (delta > (hour * 5)) {
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_;
					_tmp7_ = _ ("Four hours ago");
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (_comment);
					_comment = _tmp8_;
				} else {
					if (delta > (hour * 4)) {
						const gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						_tmp9_ = _ ("Three hours ago");
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (_comment);
						_comment = _tmp10_;
					} else {
						if (delta > (hour * 3)) {
							const gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							_tmp11_ = _ ("Two hours ago");
							_tmp12_ = g_strdup (_tmp11_);
							_g_free0 (_comment);
							_comment = _tmp12_;
						} else {
							if (delta > (hour * 2)) {
								const gchar* _tmp13_ = NULL;
								gchar* _tmp14_;
								_tmp13_ = _ ("1 hour ago");
								_tmp14_ = g_strdup (_tmp13_);
								_g_free0 (_comment);
								_comment = _tmp14_;
							} else {
								const gchar* _tmp15_ = NULL;
								gchar* _tmp16_;
								_tmp15_ = _ ("Past hour");
								_tmp16_ = g_strdup (_tmp15_);
								_g_free0 (_comment);
								_comment = _tmp16_;
							}
						}
					}
				}
			}
		}
		result = (guint) UNITY_FILES_PLACE_GROUP_TODAY;
		if (comment) {
			*comment = _comment;
		} else {
			_g_free0 (_comment);
		}
		return result;
	} else {
		if (t > (limit - ZEITGEIST_TIMESTAMP_DAY)) {
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp17_ = _ ("Yesterday");
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (_comment);
			_comment = _tmp18_;
			result = (guint) UNITY_FILES_PLACE_GROUP_YESTERDAY;
			if (comment) {
				*comment = _comment;
			} else {
				_g_free0 (_comment);
			}
			return result;
		}
	}
	memset (&date, 0, sizeof (GDate));
	zeitgeist_timestamp_to_date (now, &_tmp19_);
	date = _tmp19_;
	_tmp20_ = g_date_get_weekday (&date);
	limit = limit - ((_tmp20_ - 1) * ZEITGEIST_TIMESTAMP_DAY);
	memset (&datethen, 0, sizeof (GDate));
	zeitgeist_timestamp_to_date (t, &_tmp21_);
	datethen = _tmp21_;
	_tmp22_ = g_date_get_weekday (&datethen);
	_tmp23_ = unity_files_place_utils_get_day_name (_tmp22_);
	_g_free0 (_comment);
	_comment = _tmp23_;
	if (t > limit) {
		result = (guint) UNITY_FILES_PLACE_GROUP_THIS_WEEK;
		if (comment) {
			*comment = _comment;
		} else {
			_g_free0 (_comment);
		}
		return result;
	} else {
		if (t > (limit - ZEITGEIST_TIMESTAMP_WEEK)) {
			result = (guint) UNITY_FILES_PLACE_GROUP_LAST_WEEK;
			if (comment) {
				*comment = _comment;
			} else {
				_g_free0 (_comment);
			}
			return result;
		}
	}
	g_date_set_day (&date, (GDateDay) 1);
	_tmp24_ = zeitgeist_timestamp_from_date (&date);
	limit = _tmp24_;
	if (t > limit) {
		gint _tmp25_;
		gint days;
		_tmp25_ = g_date_days_between (&datethen, &date);
		days = _tmp25_;
		if (days < (7 * 3)) {
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp26_ = _ ("Three weeks ago");
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (_comment);
			_comment = _tmp27_;
		} else {
			if (days < (7 * 4)) {
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				_tmp28_ = _ ("A month ago");
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (_comment);
				_comment = _tmp29_;
			}
		}
		result = (guint) UNITY_FILES_PLACE_GROUP_THIS_MONTH;
		if (comment) {
			*comment = _comment;
		} else {
			_g_free0 (_comment);
		}
		return result;
	}
	_tmp30_ = g_date_get_month (&datethen);
	_tmp31_ = unity_files_place_utils_get_month_name (_tmp30_);
	_g_free0 (_comment);
	_comment = _tmp31_;
	g_date_subtract_months (&date, (guint) 1);
	_tmp32_ = zeitgeist_timestamp_from_date (&date);
	limit = _tmp32_;
	if (t > (now - ((6 * 30) * ZEITGEIST_TIMESTAMP_DAY))) {
		result = (guint) UNITY_FILES_PLACE_GROUP_PAST_SIX_MONTHS;
		if (comment) {
			*comment = _comment;
		} else {
			_g_free0 (_comment);
		}
		return result;
	}
	zeitgeist_timestamp_to_date (now, &_tmp33_);
	date = _tmp33_;
	g_date_set_month (&date, G_DATE_JANUARY);
	g_date_set_day (&date, (GDateDay) 1);
	_tmp34_ = zeitgeist_timestamp_from_date (&date);
	limit = _tmp34_;
	if (t > limit) {
		result = (guint) UNITY_FILES_PLACE_GROUP_THIS_YEAR;
		if (comment) {
			*comment = _comment;
		} else {
			_g_free0 (_comment);
		}
		return result;
	} else {
		result = (guint) UNITY_FILES_PLACE_GROUP_LAST_YEAR;
		if (comment) {
			*comment = _comment;
		} else {
			_g_free0 (_comment);
		}
		return result;
	}
	if (comment) {
		*comment = _comment;
	} else {
		_g_free0 (_comment);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static void unity_files_place_utils_list_dir_data_free (gpointer _data) {
	UnityFilesPlaceUtilsListDirData* data;
	data = _data;
	_g_object_unref0 (data->folder);
	__g_slist_free__g_object_unref0_0 (data->result);
	g_slice_free (UnityFilesPlaceUtilsListDirData, data);
}


void unity_files_place_utils_list_dir (GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesPlaceUtilsListDirData* _data_;
	_data_ = g_slice_new0 (UnityFilesPlaceUtilsListDirData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_files_place_utils_list_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_place_utils_list_dir_data_free);
	_data_->folder = _g_object_ref0 (folder);
	unity_files_place_utils_list_dir_co (_data_);
}


GSList* unity_files_place_utils_list_dir_finish (GAsyncResult* _res_, GError** error) {
	GSList* result;
	UnityFilesPlaceUtilsListDirData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Asynchrnously list the contents of a directory given by a path,
     * and return a list of FileInfos filled with the attributes specified
     * by Utils.all_attribs
     */
static void unity_files_place_utils_list_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesPlaceUtilsListDirData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_files_place_utils_list_dir_co (data);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gint _lambda2_ (gconstpointer info1, gconstpointer info2) {
	gint result = 0;
	gconstpointer _tmp0_;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_;
	_tmp0_ = info1;
	_tmp1_ = g_file_info_get_attribute_string (G_IS_FILE_INFO (_tmp0_) ? ((GFileInfo*) _tmp0_) : NULL, "unity::collation-key");
	_tmp2_ = info2;
	_tmp3_ = g_file_info_get_attribute_string (G_IS_FILE_INFO (_tmp2_) ? ((GFileInfo*) _tmp2_) : NULL, "unity::collation-key");
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_);
	result = _tmp4_;
	return result;
}


static gint __lambda2__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = _lambda2_ (a, b);
	return result;
}


static gboolean unity_files_place_utils_list_dir_co (UnityFilesPlaceUtilsListDirData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_result_ = NULL;
	data->_state_ = 1;
	g_file_enumerate_children_async (data->folder, UNITY_FILES_PLACE_UTILS_all_attribs, 0, G_PRIORITY_DEFAULT, NULL, unity_files_place_utils_list_dir_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_enumerate_children_finish (data->folder, data->_res_, &data->_inner_error_);
	data->e = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		__g_slist_free__g_object_unref0_0 (data->_result_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	while (TRUE) {
		data->_state_ = 2;
		g_file_enumerator_next_files_async (data->e, 10, G_PRIORITY_DEFAULT, NULL, unity_files_place_utils_list_dir_ready, data);
		return FALSE;
		_state_2:
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_file_enumerator_next_files_finish (data->e, data->_res_, &data->_inner_error_);
		data->file_infos = data->_tmp1_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->e);
			__g_slist_free__g_object_unref0_0 (data->_result_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		if (data->file_infos == NULL) {
			__g_list_free__g_object_unref0_0 (data->file_infos);
			break;
		}
		{
			data->info_collection = data->file_infos;
			for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
				data->_tmp2_ = _g_object_ref0 ((GFileInfo*) data->info_it->data);
				data->info = data->_tmp2_;
				{
					data->_tmp4_ = g_file_info_get_is_hidden (data->info);
					if (data->_tmp4_) {
						data->_tmp3_ = TRUE;
					} else {
						data->_tmp5_ = g_file_info_get_is_backup (data->info);
						data->_tmp3_ = data->_tmp5_;
					}
					if (data->_tmp3_) {
						_g_object_unref0 (data->info);
						continue;
					}
					data->_tmp6_ = NULL;
					data->_tmp6_ = g_file_info_get_display_name (data->info);
					data->_tmp7_ = NULL;
					data->_tmp7_ = g_utf8_collate_key_for_filename (data->_tmp6_, (gssize) (-1));
					data->colkey = data->_tmp7_;
					g_file_info_set_attribute_string (data->info, "unity::collation-key", data->colkey);
					data->_tmp8_ = _g_object_ref0 (data->info);
					data->_result_ = g_slist_prepend (data->_result_, data->_tmp8_);
					_g_free0 (data->colkey);
					_g_object_unref0 (data->info);
				}
			}
		}
		__g_list_free__g_object_unref0_0 (data->file_infos);
	}
	data->cmpfunc = __lambda2__gcompare_func;
	data->_result_ = g_slist_sort (data->_result_, data->cmpfunc);
	data->result = data->_result_;
	_g_object_unref0 (data->e);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->e);
	__g_slist_free__g_object_unref0_0 (data->_result_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void unity_files_place_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set) {
	DeeModel* _tmp0_ = NULL;
	DeeModel* _tmp1_;
	DeeModel* model;
	guint n_removed;
	gchar* uri = NULL;
	g_return_if_fail (valid_uris != NULL);
	g_return_if_fail (filter_set != NULL);
	_tmp0_ = dee_result_set_get_model (filter_set);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	n_removed = (guint) 0;
	{
		DeeResultSet* _tmp2_ = NULL;
		DeeResultSet* _row_it;
		DeeModelIter* row = NULL;
		_tmp2_ = _vala_dee_result_set_iterator (filter_set);
		_row_it = _tmp2_;
		while (TRUE) {
			DeeModelIter* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gboolean _tmp6_;
			_tmp3_ = _vala_dee_result_set_next_value (_row_it);
			row = _tmp3_;
			if (!(row != NULL)) {
				break;
			}
			_tmp4_ = dee_model_get_string (model, row, (guint) UNITY_FILES_PLACE_RESULTS_COLUMN_URI);
			_tmp5_ = g_strdup (_tmp4_);
			_g_free0 (uri);
			uri = _tmp5_;
			_tmp6_ = gee_collection_contains ((GeeCollection*) valid_uris, uri);
			if (!_tmp6_) {
				dee_model_remove (model, row);
				n_removed++;
			}
		}
		_g_object_unref0 (_row_it);
	}
	if (n_removed > 0) {
		g_debug ("utils.vala:325: Removed %u rows from result set", n_removed);
	}
	_g_free0 (uri);
	_g_object_unref0 (model);
}


gboolean unity_files_place_utils_check_is_filter_search (UnityPlaceSearch* new_search, UnityPlaceSearch* old_search) {
	gboolean result = FALSE;
	gboolean is_filter_search;
	g_return_val_if_fail (new_search != NULL, FALSE);
	is_filter_search = FALSE;
	if (old_search != NULL) {
		gchar* _tmp0_ = NULL;
		gchar* previous_search_string;
		gboolean _tmp1_ = FALSE;
		_tmp0_ = unity_place_search_get_search_string (old_search);
		previous_search_string = _tmp0_;
		if (previous_search_string != NULL) {
			_tmp1_ = g_strcmp0 (previous_search_string, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gboolean _tmp4_;
			_tmp2_ = unity_place_search_get_search_string (new_search);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_str_has_prefix (_tmp3_, previous_search_string);
			is_filter_search = _tmp4_;
			_g_free0 (_tmp3_);
		}
		_g_free0 (previous_search_string);
	}
	result = is_filter_search;
	return result;
}


GeeSet* unity_files_place_utils_get_uri_set (ZeitgeistResultSet* results) {
	GeeSet* result = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeSet* uris;
	g_return_val_if_fail (results != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	uris = (GeeSet*) _tmp0_;
	{
		ZeitgeistResultSet* _tmp1_ = NULL;
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev = NULL;
		_tmp1_ = _vala_zeitgeist_result_set_iterator (results);
		_ev_it = _tmp1_;
		while (TRUE) {
			ZeitgeistEvent* _tmp2_ = NULL;
			_tmp2_ = _vala_zeitgeist_result_set_next_value (_ev_it);
			ev = _tmp2_;
			if (!(ev != NULL)) {
				break;
			}
			{
				gint i;
				i = 0;
				{
					gboolean _tmp3_;
					_tmp3_ = TRUE;
					while (TRUE) {
						gint _tmp4_;
						ZeitgeistSubject* _tmp5_ = NULL;
						const gchar* _tmp6_ = NULL;
						if (!_tmp3_) {
							i++;
						}
						_tmp3_ = FALSE;
						_tmp4_ = zeitgeist_event_num_subjects (ev);
						if (!(i < _tmp4_)) {
							break;
						}
						_tmp5_ = zeitgeist_event_get_subject (ev, i);
						_tmp6_ = zeitgeist_subject_get_uri (_tmp5_);
						gee_collection_add ((GeeCollection*) uris, _tmp6_);
					}
				}
			}
		}
		_g_object_unref0 (_ev_it);
	}
	result = uris;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean unity_files_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* s1 = NULL;
	gchar* s2 = NULL;
	if (old_search == NULL) {
		_tmp0_ = new_search == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (old_search == NULL) {
		gchar* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = unity_place_search_get_search_string (new_search);
		_g_free0 (s1);
		s1 = _tmp1_;
		if (s1 == NULL) {
			_tmp2_ = TRUE;
		} else {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = string_strip (s1);
			_tmp4_ = _tmp3_;
			_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
			_g_free0 (_tmp4_);
		}
		if (_tmp2_) {
			result = FALSE;
			_g_free0 (s2);
			_g_free0 (s1);
			return result;
		} else {
			result = TRUE;
			_g_free0 (s2);
			_g_free0 (s1);
			return result;
		}
	} else {
		if (new_search == NULL) {
			gchar* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			_tmp5_ = unity_place_search_get_search_string (old_search);
			_g_free0 (s2);
			s2 = _tmp5_;
			if (s2 == NULL) {
				_tmp6_ = TRUE;
			} else {
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp7_ = string_strip (s2);
				_tmp8_ = _tmp7_;
				_tmp6_ = g_strcmp0 (_tmp8_, "") == 0;
				_g_free0 (_tmp8_);
			}
			if (_tmp6_) {
				result = FALSE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			} else {
				result = TRUE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			}
		} else {
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp9_ = unity_place_search_get_search_string (new_search);
			_g_free0 (s1);
			s1 = _tmp9_;
			_tmp10_ = unity_place_search_get_search_string (old_search);
			_g_free0 (s2);
			s2 = _tmp10_;
			if (s1 == NULL) {
				gboolean _tmp11_ = FALSE;
				if (s2 == NULL) {
					_tmp11_ = TRUE;
				} else {
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp12_ = string_strip (s2);
					_tmp13_ = _tmp12_;
					_tmp11_ = g_strcmp0 (_tmp13_, "") == 0;
					_g_free0 (_tmp13_);
				}
				if (_tmp11_) {
					result = FALSE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				} else {
					result = TRUE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			} else {
				if (s2 == NULL) {
					gboolean _tmp14_ = FALSE;
					if (s1 == NULL) {
						_tmp14_ = TRUE;
					} else {
						gchar* _tmp15_ = NULL;
						gchar* _tmp16_;
						_tmp15_ = string_strip (s1);
						_tmp16_ = _tmp15_;
						_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
						_g_free0 (_tmp16_);
					}
					if (_tmp14_) {
						result = FALSE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					} else {
						result = TRUE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					}
				} else {
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					gboolean _tmp21_;
					_tmp17_ = string_strip (s1);
					_tmp18_ = _tmp17_;
					_tmp19_ = string_strip (s2);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strcmp0 (_tmp18_, _tmp20_) != 0;
					_g_free0 (_tmp20_);
					_g_free0 (_tmp18_);
					result = _tmp21_;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			}
		}
	}
	_g_free0 (s2);
	_g_free0 (s1);
}


gchar* unity_files_place_utils_normalize_string (const gchar* input) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = g_utf8_normalize (input, (gssize) (-1), G_NORMALIZE_ALL_COMPOSE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}



