/* player.c generated by valac 0.16.1, the Vala compiler
 * generated from player.vala, do not modify */

/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Pawel Stolowski <pawel.stolowski@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gst/pbutils/pbutils.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER (preview_player_preview_player_get_type ())
#define PREVIEW_PLAYER_PREVIEW_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER, PreviewPlayerPreviewPlayer))
#define PREVIEW_PLAYER_PREVIEW_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER, PreviewPlayerPreviewPlayerClass))
#define PREVIEW_PLAYER_IS_PREVIEW_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER))
#define PREVIEW_PLAYER_IS_PREVIEW_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER))
#define PREVIEW_PLAYER_PREVIEW_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER, PreviewPlayerPreviewPlayerClass))

typedef struct _PreviewPlayerPreviewPlayer PreviewPlayerPreviewPlayer;
typedef struct _PreviewPlayerPreviewPlayerClass PreviewPlayerPreviewPlayerClass;
typedef struct _PreviewPlayerPreviewPlayerPrivate PreviewPlayerPreviewPlayerPrivate;

#define PREVIEW_PLAYER_PREVIEW_PLAYER_TYPE_TRACK_STATE (preview_player_preview_player_track_state_get_type ())
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _preview_player_preview_player_unref0(var) ((var == NULL) ? NULL : (var = (preview_player_preview_player_unref (var), NULL)))

#define PREVIEW_PLAYER_TYPE_DASH_PROXY (preview_player_dash_proxy_get_type ())
#define PREVIEW_PLAYER_DASH_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PREVIEW_PLAYER_TYPE_DASH_PROXY, PreviewPlayerDashProxy))
#define PREVIEW_PLAYER_DASH_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PREVIEW_PLAYER_TYPE_DASH_PROXY, PreviewPlayerDashProxyClass))
#define PREVIEW_PLAYER_IS_DASH_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PREVIEW_PLAYER_TYPE_DASH_PROXY))
#define PREVIEW_PLAYER_IS_DASH_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PREVIEW_PLAYER_TYPE_DASH_PROXY))
#define PREVIEW_PLAYER_DASH_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PREVIEW_PLAYER_TYPE_DASH_PROXY, PreviewPlayerDashProxyClass))

typedef struct _PreviewPlayerDashProxy PreviewPlayerDashProxy;
typedef struct _PreviewPlayerDashProxyClass PreviewPlayerDashProxyClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_mini_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL)))
#define __g_list_free__gst_mini_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gst_mini_object_unref0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _PreviewPlayerParamSpecPreviewPlayer PreviewPlayerParamSpecPreviewPlayer;

typedef enum  {
	PREVIEW_PLAYER_PREVIEW_PLAYER_ERROR_GST_INIT_FAILED
} PreviewPlayerPreviewPlayerError;
#define PREVIEW_PLAYER_PREVIEW_PLAYER_ERROR preview_player_preview_player_error_quark ()
struct _PreviewPlayerPreviewPlayer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PreviewPlayerPreviewPlayerPrivate * priv;
};

struct _PreviewPlayerPreviewPlayerClass {
	GTypeClass parent_class;
	void (*finalize) (PreviewPlayerPreviewPlayer *self);
};

struct _PreviewPlayerPreviewPlayerPrivate {
	GstPipeline* gst_pipeline;
	GstElement* gst_playbin;
	GstElement* gst_sink;
	GstBus* gst_bus;
	guint timer_id;
	gchar* uri;
	gboolean error;
	gboolean update_registry;
};

typedef enum  {
	PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_STOPPED,
	PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PLAYING,
	PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PAUSED
} PreviewPlayerPreviewPlayerTrackState;

struct _PreviewPlayerParamSpecPreviewPlayer {
	GParamSpec parent_instance;
};


static gpointer preview_player_preview_player_parent_class = NULL;
static guint preview_player_preview_player_GST_NETWORK_TIMEOUT_SECS;
static guint preview_player_preview_player_GST_NETWORK_TIMEOUT_SECS = (guint) 10;
static guint64 preview_player_preview_player_GST_STATE_QUERY_TIMEOUT;
static guint64 preview_player_preview_player_GST_STATE_QUERY_TIMEOUT = (guint64) 1000000;
static gint preview_player_preview_player_GST_PLAYBIN_AUDIO;
static gint preview_player_preview_player_GST_PLAYBIN_AUDIO = 0x02;
static gint preview_player_preview_player_GST_PLAYBIN_SOFT_VOLUME;
static gint preview_player_preview_player_GST_PLAYBIN_SOFT_VOLUME = 0x10;

GQuark preview_player_preview_player_error_quark (void);
gpointer preview_player_preview_player_ref (gpointer instance);
void preview_player_preview_player_unref (gpointer instance);
GParamSpec* preview_player_param_spec_preview_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void preview_player_value_set_preview_player (GValue* value, gpointer v_object);
void preview_player_value_take_preview_player (GValue* value, gpointer v_object);
gpointer preview_player_value_get_preview_player (const GValue* value);
GType preview_player_preview_player_get_type (void) G_GNUC_CONST;
#define PREVIEW_PLAYER_PREVIEW_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER, PreviewPlayerPreviewPlayerPrivate))
enum  {
	PREVIEW_PLAYER_PREVIEW_PLAYER_DUMMY_PROPERTY
};
static GType preview_player_preview_player_track_state_get_type (void) G_GNUC_UNUSED;
PreviewPlayerPreviewPlayer* preview_player_preview_player_new (GError** error);
PreviewPlayerPreviewPlayer* preview_player_preview_player_construct (GType object_type, GError** error);
void preview_player_preview_player_init_gst (PreviewPlayerPreviewPlayer* self, GError** error);
void preview_player_preview_player_playbin_setup (PreviewPlayerPreviewPlayer* self, GObject* source, GParamSpec* spec);
static void _preview_player_preview_player_playbin_setup_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean preview_player_preview_player_gst_bus_message_cb (PreviewPlayerPreviewPlayer* self, GstBus* bus, GstMessage* message);
static gboolean _preview_player_preview_player_gst_bus_message_cb_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static void preview_player_preview_player_handle_missing_plugin (PreviewPlayerPreviewPlayer* self, GstMessage* message);
static void preview_player_preview_player_codec_install_finished (PreviewPlayerPreviewPlayer* self, GstInstallPluginsReturn _result_);
static void _preview_player_preview_player_codec_install_finished_gst_install_plugins_result_func (GstInstallPluginsReturn _result_, gpointer self);
PreviewPlayerDashProxy* preview_player_dash_proxy_new (void);
PreviewPlayerDashProxy* preview_player_dash_proxy_construct (GType object_type);
GType preview_player_dash_proxy_get_type (void) G_GNUC_CONST;
void preview_player_dash_proxy_hide_dash (PreviewPlayerDashProxy* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void preview_player_dash_proxy_hide_dash_finish (PreviewPlayerDashProxy* self, GAsyncResult* _res_, GError** error);
static void preview_player_preview_player_remove_progress_cb (PreviewPlayerPreviewPlayer* self);
static gboolean preview_player_preview_player_progress_report_cb (PreviewPlayerPreviewPlayer* self);
static gdouble preview_player_preview_player_gst_progress (PreviewPlayerPreviewPlayer* self);
static gboolean preview_player_preview_player_is_playing (PreviewPlayerPreviewPlayer* self);
void preview_player_preview_player_play (PreviewPlayerPreviewPlayer* self, const gchar* uri);
static gboolean _preview_player_preview_player_progress_report_cb_gsource_func (gpointer self);
void preview_player_preview_player_stop (PreviewPlayerPreviewPlayer* self);
void preview_player_preview_player_pause (PreviewPlayerPreviewPlayer* self);
void preview_player_preview_player_resume (PreviewPlayerPreviewPlayer* self);
void preview_player_preview_player_pause_resume (PreviewPlayerPreviewPlayer* self);
GHashTable* preview_player_preview_player_get_video_file_props (PreviewPlayerPreviewPlayer* self, const gchar* uri);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void _gst_mini_object_unref0_ (gpointer var);
static void _g_list_free__gst_mini_object_unref0_ (GList* self);
static void g_cclosure_user_marshal_VOID__STRING_UINT_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void preview_player_preview_player_finalize (PreviewPlayerPreviewPlayer* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark preview_player_preview_player_error_quark (void) {
	return g_quark_from_static_string ("preview_player_preview_player_error-quark");
}


static GType preview_player_preview_player_track_state_get_type (void) {
	static volatile gsize preview_player_preview_player_track_state_type_id__volatile = 0;
	if (g_once_init_enter (&preview_player_preview_player_track_state_type_id__volatile)) {
		static const GEnumValue values[] = {{PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_STOPPED, "PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_STOPPED", "stopped"}, {PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PLAYING, "PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PLAYING", "playing"}, {PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PAUSED, "PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PAUSED", "paused"}, {0, NULL, NULL}};
		GType preview_player_preview_player_track_state_type_id;
		preview_player_preview_player_track_state_type_id = g_enum_register_static ("PreviewPlayerPreviewPlayerTrackState", values);
		g_once_init_leave (&preview_player_preview_player_track_state_type_id__volatile, preview_player_preview_player_track_state_type_id);
	}
	return preview_player_preview_player_track_state_type_id__volatile;
}


PreviewPlayerPreviewPlayer* preview_player_preview_player_construct (GType object_type, GError** error) {
	PreviewPlayerPreviewPlayer* self = NULL;
	GError * _inner_error_ = NULL;
	self = (PreviewPlayerPreviewPlayer*) g_type_create_instance (object_type);
	self->priv->timer_id = (guint) 0;
	preview_player_preview_player_init_gst (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == PREVIEW_PLAYER_PREVIEW_PLAYER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_preview_player_preview_player_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


PreviewPlayerPreviewPlayer* preview_player_preview_player_new (GError** error) {
	return preview_player_preview_player_construct (PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER, error);
}


static void _preview_player_preview_player_playbin_setup_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	preview_player_preview_player_playbin_setup (self, _sender, pspec);
}


static gboolean _preview_player_preview_player_gst_bus_message_cb_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = preview_player_preview_player_gst_bus_message_cb (self, bus, message);
	return result;
}


void preview_player_preview_player_init_gst (PreviewPlayerPreviewPlayer* self, GError** error) {
	GstPipeline* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GValue _tmp9_ = {0};
	GstElement* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GValue _tmp13_ = {0};
	GstElement* _tmp14_;
	GstPipeline* _tmp15_;
	GstElement* _tmp16_;
	GstPipeline* _tmp17_;
	GstBus* _tmp18_ = NULL;
	GstBus* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GstPipeline*) gst_pipeline_new ("preview-player-pipeline");
	gst_object_ref_sink (_tmp0_);
	_gst_object_unref0 (self->priv->gst_pipeline);
	self->priv->gst_pipeline = _tmp0_;
	_tmp1_ = gst_element_factory_make ("playbin2", "playbin2");
	gst_object_ref_sink (_tmp1_);
	_gst_object_unref0 (self->priv->gst_playbin);
	self->priv->gst_playbin = _tmp1_;
	_tmp2_ = gst_element_factory_make ("pulsesink", "sink");
	gst_object_ref_sink (_tmp2_);
	_gst_object_unref0 (self->priv->gst_sink);
	self->priv->gst_sink = _tmp2_;
	_tmp3_ = self->priv->gst_sink;
	if (_tmp3_ == NULL) {
		GstElement* _tmp4_ = NULL;
		GstElement* _tmp5_;
		_tmp4_ = gst_element_factory_make ("alsasink", "sink");
		gst_object_ref_sink (_tmp4_);
		_gst_object_unref0 (self->priv->gst_sink);
		self->priv->gst_sink = _tmp4_;
		_tmp5_ = self->priv->gst_sink;
		if (_tmp5_ == NULL) {
			GError* _tmp6_;
			_tmp6_ = g_error_new_literal (PREVIEW_PLAYER_PREVIEW_PLAYER_ERROR, PREVIEW_PLAYER_PREVIEW_PLAYER_ERROR_GST_INIT_FAILED, "Can't create backend sink");
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == PREVIEW_PLAYER_PREVIEW_PLAYER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp7_ = self->priv->gst_playbin;
	_tmp8_ = self->priv->gst_sink;
	g_value_init (&_tmp9_, GST_TYPE_ELEMENT);
	g_value_set_object (&_tmp9_, _tmp8_);
	g_object_set_property ((GObject*) _tmp7_, "audio-sink", &_tmp9_);
	G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
	_tmp10_ = self->priv->gst_playbin;
	_tmp11_ = preview_player_preview_player_GST_PLAYBIN_AUDIO;
	_tmp12_ = preview_player_preview_player_GST_PLAYBIN_SOFT_VOLUME;
	g_value_init (&_tmp13_, G_TYPE_INT);
	g_value_set_int (&_tmp13_, _tmp11_ | _tmp12_);
	g_object_set_property ((GObject*) _tmp10_, "flags", &_tmp13_);
	G_IS_VALUE (&_tmp13_) ? (g_value_unset (&_tmp13_), NULL) : NULL;
	_tmp14_ = self->priv->gst_playbin;
	g_signal_connect ((GObject*) _tmp14_, "notify::source", (GCallback) _preview_player_preview_player_playbin_setup_g_object_notify, self);
	_tmp15_ = self->priv->gst_pipeline;
	_tmp16_ = self->priv->gst_playbin;
	gst_bin_add ((GstBin*) _tmp15_, _tmp16_);
	_tmp17_ = self->priv->gst_pipeline;
	_tmp18_ = gst_pipeline_get_bus (_tmp17_);
	_gst_object_unref0 (self->priv->gst_bus);
	self->priv->gst_bus = _tmp18_;
	_tmp19_ = self->priv->gst_bus;
	gst_bus_add_watch_full (_tmp19_, G_PRIORITY_DEFAULT, _preview_player_preview_player_gst_bus_message_cb_gst_bus_func, preview_player_preview_player_ref (self), preview_player_preview_player_unref);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


void preview_player_preview_player_playbin_setup (PreviewPlayerPreviewPlayer* self, GObject* source, GParamSpec* spec) {
	GType _tmp0_ = 0UL;
	GValue source_element = {0};
	GstElement* _tmp1_;
	GObject* _tmp2_ = NULL;
	GstElement* _tmp3_;
	GstElement* obj;
	GstElement* _tmp4_;
	GObjectClass* _tmp5_ = NULL;
	GType _tmp6_ = 0UL;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = g_type_from_name ("GstElement");
	g_value_init (&source_element, _tmp0_);
	_tmp1_ = self->priv->gst_playbin;
	g_object_get_property ((GObject*) _tmp1_, "source", &source_element);
	_tmp2_ = g_value_get_object (&source_element);
	_tmp3_ = _gst_object_ref0 (GST_ELEMENT (_tmp2_));
	obj = _tmp3_;
	_tmp4_ = obj;
	_tmp5_ = G_OBJECT_GET_CLASS ((GObject*) _tmp4_);
	_tmp6_ = G_TYPE_FROM_CLASS ((GTypeClass*) _tmp5_);
	_tmp7_ = g_type_name (_tmp6_);
	if (g_strcmp0 (_tmp7_, "GstSoupHTTPSrc") == 0) {
		GstElement* _tmp8_;
		guint _tmp9_;
		GValue _tmp10_ = {0};
		_tmp8_ = obj;
		_tmp9_ = preview_player_preview_player_GST_NETWORK_TIMEOUT_SECS;
		g_value_init (&_tmp10_, G_TYPE_UINT);
		g_value_set_uint (&_tmp10_, _tmp9_);
		g_object_set_property ((GObject*) _tmp8_, "timeout", &_tmp10_);
		G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
	}
	_gst_object_unref0 (obj);
}


gboolean preview_player_preview_player_gst_bus_message_cb (PreviewPlayerPreviewPlayer* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_EOS:
		{
			GstPipeline* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = self->priv->gst_pipeline;
			gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_READY);
			_tmp3_ = self->priv->uri;
			g_signal_emit_by_name (self, "progress", _tmp3_, (guint32) PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PLAYING, (gdouble) 1.0f);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GstPipeline* _tmp4_;
			_tmp4_ = self->priv->gst_pipeline;
			gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_READY);
			self->priv->error = TRUE;
			break;
		}
		case GST_MESSAGE_ELEMENT:
		{
			GstMessage* _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp5_ = message;
			_tmp6_ = gst_is_missing_plugin_message (_tmp5_);
			if (_tmp6_) {
				GstMessage* _tmp7_;
				_tmp7_ = message;
				preview_player_preview_player_handle_missing_plugin (self, _tmp7_);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}


static void _preview_player_preview_player_codec_install_finished_gst_install_plugins_result_func (GstInstallPluginsReturn _result_, gpointer self) {
	preview_player_preview_player_codec_install_finished (self, _result_);
}


static void preview_player_preview_player_handle_missing_plugin (PreviewPlayerPreviewPlayer* self, GstMessage* message) {
	GstMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* detail;
	GstMessage* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* descr;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** details;
	gint details_length1;
	gint _details_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GstInstallPluginsReturn _tmp10_ = 0;
	GstInstallPluginsReturn status;
	GstInstallPluginsReturn _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	_tmp1_ = gst_missing_plugin_message_get_installer_detail (_tmp0_);
	detail = _tmp1_;
	_tmp2_ = message;
	_tmp3_ = gst_missing_plugin_message_get_description (_tmp2_);
	descr = _tmp3_;
	_tmp4_ = descr;
	_tmp5_ = detail;
	g_warning ("player.vala:127: Missing plugin: '%s': %s\n", _tmp4_, _tmp5_);
	_tmp6_ = detail;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	details = _tmp8_;
	details_length1 = 1;
	_details_size_ = details_length1;
	_tmp9_ = details;
	_tmp9__length1 = details_length1;
	_tmp10_ = gst_install_plugins_async (_tmp9_, NULL, _preview_player_preview_player_codec_install_finished_gst_install_plugins_result_func, self);
	status = _tmp10_;
	_tmp11_ = status;
	if (_tmp11_ == GST_INSTALL_PLUGINS_STARTED_OK) {
		PreviewPlayerDashProxy* _tmp12_;
		PreviewPlayerDashProxy* dash_proxy;
		_tmp12_ = preview_player_dash_proxy_new ();
		dash_proxy = _tmp12_;
		{
			PreviewPlayerDashProxy* _tmp13_;
			_tmp13_ = dash_proxy;
			preview_player_dash_proxy_hide_dash (_tmp13_, NULL, NULL);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_warning ("player.vala:140: Failed to hide dash: %s", _tmp15_);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dash_proxy);
			details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (descr);
			_g_free0 (detail);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dash_proxy);
	} else {
		g_warning ("player.vala:145: Failed to start codec installation");
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (descr);
	_g_free0 (detail);
}


static void preview_player_preview_player_codec_install_finished (PreviewPlayerPreviewPlayer* self, GstInstallPluginsReturn _result_) {
	GstInstallPluginsReturn _tmp0_;
	GstInstallPluginsReturn _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _result_;
	g_debug ("player.vala:151: Codec install returned: %d\n", (gint) _tmp0_);
	_tmp1_ = _result_;
	if (_tmp1_ == GST_INSTALL_PLUGINS_SUCCESS) {
		self->priv->update_registry = TRUE;
	}
}


static void preview_player_preview_player_remove_progress_cb (PreviewPlayerPreviewPlayer* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->timer_id;
		g_source_remove (_tmp1_);
		self->priv->timer_id = (guint) 0;
	}
}


static gboolean preview_player_preview_player_progress_report_cb (PreviewPlayerPreviewPlayer* self) {
	gboolean result = FALSE;
	GstState current_state = 0;
	GstState pending_state = 0;
	GstPipeline* _tmp0_;
	guint64 _tmp1_;
	GstState _tmp2_ = 0;
	GstState _tmp3_ = 0;
	GstStateChangeReturn _tmp4_ = 0;
	GstStateChangeReturn status;
	GstStateChangeReturn _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->gst_pipeline;
	_tmp1_ = preview_player_preview_player_GST_STATE_QUERY_TIMEOUT;
	_tmp4_ = gst_element_get_state ((GstElement*) _tmp0_, &_tmp2_, &_tmp3_, (GstClockTime) _tmp1_);
	current_state = _tmp2_;
	pending_state = _tmp3_;
	status = _tmp4_;
	_tmp5_ = status;
	if (_tmp5_ != GST_STATE_CHANGE_FAILURE) {
		gboolean _tmp6_ = FALSE;
		GstState _tmp7_;
		gboolean _tmp9_;
		gboolean _tmp12_ = FALSE;
		GstState _tmp13_;
		gboolean _tmp15_;
		const gchar* _tmp16_;
		_tmp7_ = current_state;
		if (_tmp7_ == GST_STATE_PLAYING) {
			_tmp6_ = TRUE;
		} else {
			GstState _tmp8_;
			_tmp8_ = pending_state;
			_tmp6_ = _tmp8_ == GST_STATE_PLAYING;
		}
		_tmp9_ = _tmp6_;
		if (_tmp9_) {
			const gchar* _tmp10_;
			gdouble _tmp11_ = 0.0;
			_tmp10_ = self->priv->uri;
			_tmp11_ = preview_player_preview_player_gst_progress (self);
			g_signal_emit_by_name (self, "progress", _tmp10_, (guint32) PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PLAYING, _tmp11_);
			result = TRUE;
			return result;
		}
		_tmp13_ = current_state;
		if (_tmp13_ == GST_STATE_PAUSED) {
			_tmp12_ = TRUE;
		} else {
			GstState _tmp14_;
			_tmp14_ = pending_state;
			_tmp12_ = _tmp14_ == GST_STATE_PAUSED;
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			result = TRUE;
			return result;
		}
		_tmp16_ = self->priv->uri;
		g_signal_emit_by_name (self, "progress", _tmp16_, (guint32) PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_STOPPED, (gdouble) 0.0f);
	}
	result = FALSE;
	return result;
}


static gdouble preview_player_preview_player_gst_progress (PreviewPlayerPreviewPlayer* self) {
	gdouble result = 0.0;
	gint64 pos = 0LL;
	gint64 dur = 0LL;
	GstFormat fmt;
	GstPipeline* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0.0);
	fmt = GST_FORMAT_TIME;
	_tmp0_ = self->priv->gst_pipeline;
	_tmp2_ = gst_element_query_position ((GstElement*) _tmp0_, &fmt, &_tmp1_);
	pos = _tmp1_;
	if (_tmp2_) {
		GstPipeline* _tmp3_;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = self->priv->gst_pipeline;
		_tmp5_ = gst_element_query_duration ((GstElement*) _tmp3_, &fmt, &_tmp4_);
		dur = _tmp4_;
		if (_tmp5_) {
			gint64 _tmp6_;
			_tmp6_ = dur;
			if (_tmp6_ > ((gint64) 0)) {
				gint64 _tmp7_;
				gint64 _tmp8_;
				_tmp7_ = pos;
				_tmp8_ = dur;
				result = _tmp7_ / ((gdouble) _tmp8_);
				return result;
			}
		}
	}
	result = (gdouble) 0.0f;
	return result;
}


static gboolean preview_player_preview_player_is_playing (PreviewPlayerPreviewPlayer* self) {
	gboolean result = FALSE;
	GstState current_state = 0;
	GstState pending_state = 0;
	GstPipeline* _tmp0_;
	guint64 _tmp1_;
	GstState _tmp2_ = 0;
	GstState _tmp3_ = 0;
	GstStateChangeReturn _tmp4_ = 0;
	GstStateChangeReturn status;
	gboolean _tmp5_ = FALSE;
	GstStateChangeReturn _tmp6_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->gst_pipeline;
	_tmp1_ = preview_player_preview_player_GST_STATE_QUERY_TIMEOUT;
	_tmp4_ = gst_element_get_state ((GstElement*) _tmp0_, &_tmp2_, &_tmp3_, (GstClockTime) _tmp1_);
	current_state = _tmp2_;
	pending_state = _tmp3_;
	status = _tmp4_;
	_tmp6_ = status;
	if (_tmp6_ != GST_STATE_CHANGE_FAILURE) {
		gboolean _tmp7_ = FALSE;
		GstState _tmp8_;
		gboolean _tmp10_;
		_tmp8_ = current_state;
		if (_tmp8_ == GST_STATE_PLAYING) {
			_tmp7_ = TRUE;
		} else {
			GstState _tmp9_;
			_tmp9_ = pending_state;
			_tmp7_ = _tmp9_ == GST_STATE_PLAYING;
		}
		_tmp10_ = _tmp7_;
		_tmp5_ = _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp11_ = _tmp5_;
	result = _tmp11_;
	return result;
}


static gboolean _preview_player_preview_player_progress_report_cb_gsource_func (gpointer self) {
	gboolean result;
	result = preview_player_preview_player_progress_report_cb (self);
	return result;
}


void preview_player_preview_player_play (PreviewPlayerPreviewPlayer* self, const gchar* uri) {
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GstPipeline* _tmp18_;
	GstElement* _tmp19_;
	const gchar* _tmp20_;
	GValue _tmp21_ = {0};
	GstPipeline* _tmp22_;
	guint _tmp23_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->update_registry;
	if (_tmp0_) {
		self->priv->update_registry = FALSE;
		g_debug ("player.vala:231: Updating gstreamer plugin registry\n");
		gst_update_registry ();
		g_debug ("player.vala:233: Finished gstreamer plugin registry update\n");
	}
	_tmp1_ = uri;
	_tmp2_ = self->priv->uri;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		GstState current_state = 0;
		GstState pending_state = 0;
		GstPipeline* _tmp3_;
		guint64 _tmp4_;
		GstState _tmp5_ = 0;
		GstState _tmp6_ = 0;
		GstStateChangeReturn _tmp7_ = 0;
		GstStateChangeReturn status;
		GstStateChangeReturn _tmp8_;
		_tmp3_ = self->priv->gst_pipeline;
		_tmp4_ = preview_player_preview_player_GST_STATE_QUERY_TIMEOUT;
		_tmp7_ = gst_element_get_state ((GstElement*) _tmp3_, &_tmp5_, &_tmp6_, (GstClockTime) _tmp4_);
		current_state = _tmp5_;
		pending_state = _tmp6_;
		status = _tmp7_;
		_tmp8_ = status;
		if (_tmp8_ != GST_STATE_CHANGE_FAILURE) {
			gboolean _tmp9_ = FALSE;
			GstState _tmp10_;
			gboolean _tmp12_;
			_tmp10_ = current_state;
			if (_tmp10_ == GST_STATE_PAUSED) {
				_tmp9_ = TRUE;
			} else {
				GstState _tmp11_;
				_tmp11_ = pending_state;
				_tmp9_ = _tmp11_ == GST_STATE_PAUSED;
			}
			_tmp12_ = _tmp9_;
			if (_tmp12_) {
				GstPipeline* _tmp13_;
				const gchar* _tmp14_;
				gdouble _tmp15_ = 0.0;
				_tmp13_ = self->priv->gst_pipeline;
				gst_element_set_state ((GstElement*) _tmp13_, GST_STATE_PLAYING);
				_tmp14_ = uri;
				_tmp15_ = preview_player_preview_player_gst_progress (self);
				g_signal_emit_by_name (self, "progress", _tmp14_, (guint32) PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PLAYING, _tmp15_);
				return;
			}
		}
	}
	preview_player_preview_player_remove_progress_cb (self);
	self->priv->error = FALSE;
	_tmp16_ = uri;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp17_;
	_tmp18_ = self->priv->gst_pipeline;
	gst_element_set_state ((GstElement*) _tmp18_, GST_STATE_NULL);
	_tmp19_ = self->priv->gst_playbin;
	_tmp20_ = uri;
	g_value_init (&_tmp21_, G_TYPE_STRING);
	g_value_set_string (&_tmp21_, _tmp20_);
	g_object_set_property ((GObject*) _tmp19_, "uri", &_tmp21_);
	G_IS_VALUE (&_tmp21_) ? (g_value_unset (&_tmp21_), NULL) : NULL;
	_tmp22_ = self->priv->gst_pipeline;
	gst_element_set_state ((GstElement*) _tmp22_, GST_STATE_PLAYING);
	_tmp23_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _preview_player_preview_player_progress_report_cb_gsource_func, preview_player_preview_player_ref (self), preview_player_preview_player_unref);
	self->priv->timer_id = _tmp23_;
}


void preview_player_preview_player_stop (PreviewPlayerPreviewPlayer* self) {
	GstState current_state = 0;
	GstState pending_state = 0;
	GstPipeline* _tmp0_;
	guint64 _tmp1_;
	GstState _tmp2_ = 0;
	GstState _tmp3_ = 0;
	GstStateChangeReturn _tmp4_ = 0;
	GstStateChangeReturn status;
	GstStateChangeReturn _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gst_pipeline;
	_tmp1_ = preview_player_preview_player_GST_STATE_QUERY_TIMEOUT;
	_tmp4_ = gst_element_get_state ((GstElement*) _tmp0_, &_tmp2_, &_tmp3_, (GstClockTime) _tmp1_);
	current_state = _tmp2_;
	pending_state = _tmp3_;
	status = _tmp4_;
	_tmp5_ = status;
	if (_tmp5_ != GST_STATE_CHANGE_FAILURE) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GstState _tmp9_;
		gboolean _tmp11_;
		gboolean _tmp13_;
		gboolean _tmp15_;
		_tmp9_ = current_state;
		if (_tmp9_ == GST_STATE_PAUSED) {
			_tmp8_ = TRUE;
		} else {
			GstState _tmp10_;
			_tmp10_ = current_state;
			_tmp8_ = _tmp10_ == GST_STATE_PLAYING;
		}
		_tmp11_ = _tmp8_;
		if (_tmp11_) {
			_tmp7_ = TRUE;
		} else {
			GstState _tmp12_;
			_tmp12_ = pending_state;
			_tmp7_ = _tmp12_ == GST_STATE_PAUSED;
		}
		_tmp13_ = _tmp7_;
		if (_tmp13_) {
			_tmp6_ = TRUE;
		} else {
			GstState _tmp14_;
			_tmp14_ = pending_state;
			_tmp6_ = _tmp14_ == GST_STATE_PLAYING;
		}
		_tmp15_ = _tmp6_;
		if (_tmp15_) {
			GstPipeline* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = self->priv->gst_pipeline;
			gst_element_set_state ((GstElement*) _tmp16_, GST_STATE_READY);
			_tmp17_ = self->priv->uri;
			g_signal_emit_by_name (self, "progress", _tmp17_, (guint32) PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_STOPPED, (gdouble) 0.0f);
		}
	}
}


void preview_player_preview_player_pause (PreviewPlayerPreviewPlayer* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = preview_player_preview_player_is_playing (self);
	if (_tmp0_) {
		GstPipeline* _tmp1_;
		const gchar* _tmp2_;
		gdouble _tmp3_ = 0.0;
		_tmp1_ = self->priv->gst_pipeline;
		gst_element_set_state ((GstElement*) _tmp1_, GST_STATE_PAUSED);
		_tmp2_ = self->priv->uri;
		_tmp3_ = preview_player_preview_player_gst_progress (self);
		g_signal_emit_by_name (self, "progress", _tmp2_, (guint32) PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PAUSED, _tmp3_);
	}
}


void preview_player_preview_player_resume (PreviewPlayerPreviewPlayer* self) {
	GstState current_state = 0;
	GstState pending_state = 0;
	GstPipeline* _tmp0_;
	guint64 _tmp1_;
	GstState _tmp2_ = 0;
	GstState _tmp3_ = 0;
	GstStateChangeReturn _tmp4_ = 0;
	GstStateChangeReturn status;
	GstStateChangeReturn _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gst_pipeline;
	_tmp1_ = preview_player_preview_player_GST_STATE_QUERY_TIMEOUT;
	_tmp4_ = gst_element_get_state ((GstElement*) _tmp0_, &_tmp2_, &_tmp3_, (GstClockTime) _tmp1_);
	current_state = _tmp2_;
	pending_state = _tmp3_;
	status = _tmp4_;
	_tmp5_ = status;
	if (_tmp5_ != GST_STATE_CHANGE_FAILURE) {
		gboolean _tmp6_ = FALSE;
		GstState _tmp7_;
		gboolean _tmp9_;
		_tmp7_ = current_state;
		if (_tmp7_ == GST_STATE_PAUSED) {
			_tmp6_ = TRUE;
		} else {
			GstState _tmp8_;
			_tmp8_ = pending_state;
			_tmp6_ = _tmp8_ == GST_STATE_PAUSED;
		}
		_tmp9_ = _tmp6_;
		if (_tmp9_) {
			GstPipeline* _tmp10_;
			const gchar* _tmp11_;
			gdouble _tmp12_ = 0.0;
			_tmp10_ = self->priv->gst_pipeline;
			gst_element_set_state ((GstElement*) _tmp10_, GST_STATE_PLAYING);
			_tmp11_ = self->priv->uri;
			_tmp12_ = preview_player_preview_player_gst_progress (self);
			g_signal_emit_by_name (self, "progress", _tmp11_, (guint32) PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PLAYING, _tmp12_);
		}
	}
}


void preview_player_preview_player_pause_resume (PreviewPlayerPreviewPlayer* self) {
	GstState current_state = 0;
	GstState pending_state = 0;
	GstPipeline* _tmp0_;
	guint64 _tmp1_;
	GstState _tmp2_ = 0;
	GstState _tmp3_ = 0;
	GstStateChangeReturn _tmp4_ = 0;
	GstStateChangeReturn status;
	GstStateChangeReturn _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gst_pipeline;
	_tmp1_ = preview_player_preview_player_GST_STATE_QUERY_TIMEOUT;
	_tmp4_ = gst_element_get_state ((GstElement*) _tmp0_, &_tmp2_, &_tmp3_, (GstClockTime) _tmp1_);
	current_state = _tmp2_;
	pending_state = _tmp3_;
	status = _tmp4_;
	_tmp5_ = status;
	if (_tmp5_ != GST_STATE_CHANGE_FAILURE) {
		PreviewPlayerPreviewPlayerTrackState track_state;
		GstState gst_state;
		gboolean _tmp6_ = FALSE;
		GstState _tmp7_;
		gboolean _tmp9_;
		GstState _tmp15_;
		track_state = PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_STOPPED;
		gst_state = GST_STATE_NULL;
		_tmp7_ = current_state;
		if (_tmp7_ == GST_STATE_PLAYING) {
			_tmp6_ = TRUE;
		} else {
			GstState _tmp8_;
			_tmp8_ = pending_state;
			_tmp6_ = _tmp8_ == GST_STATE_PLAYING;
		}
		_tmp9_ = _tmp6_;
		if (_tmp9_) {
			GstPipeline* _tmp10_;
			track_state = PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PAUSED;
			gst_state = GST_STATE_PAUSED;
			_tmp10_ = self->priv->gst_pipeline;
			gst_element_set_state ((GstElement*) _tmp10_, GST_STATE_PAUSED);
		} else {
			gboolean _tmp11_ = FALSE;
			GstState _tmp12_;
			gboolean _tmp14_;
			_tmp12_ = current_state;
			if (_tmp12_ == GST_STATE_PAUSED) {
				_tmp11_ = TRUE;
			} else {
				GstState _tmp13_;
				_tmp13_ = pending_state;
				_tmp11_ = _tmp13_ == GST_STATE_PAUSED;
			}
			_tmp14_ = _tmp11_;
			if (_tmp14_) {
				track_state = PREVIEW_PLAYER_PREVIEW_PLAYER_TRACK_STATE_PLAYING;
				gst_state = GST_STATE_PLAYING;
			}
		}
		_tmp15_ = gst_state;
		if (_tmp15_ != GST_STATE_NULL) {
			GstPipeline* _tmp16_;
			GstState _tmp17_;
			const gchar* _tmp18_;
			PreviewPlayerPreviewPlayerTrackState _tmp19_;
			gdouble _tmp20_ = 0.0;
			_tmp16_ = self->priv->gst_pipeline;
			_tmp17_ = gst_state;
			gst_element_set_state ((GstElement*) _tmp16_, _tmp17_);
			_tmp18_ = self->priv->uri;
			_tmp19_ = track_state;
			_tmp20_ = preview_player_preview_player_gst_progress (self);
			g_signal_emit_by_name (self, "progress", _tmp18_, (guint32) _tmp19_, _tmp20_);
		}
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gpointer _gst_mini_object_ref0 (gpointer self) {
	return self ? gst_mini_object_ref (self) : NULL;
}


static void _gst_mini_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL));
}


static void _g_list_free__gst_mini_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gst_mini_object_unref0_, NULL);
	g_list_free (self);
}


GHashTable* preview_player_preview_player_get_video_file_props (PreviewPlayerPreviewPlayer* self, const gchar* uri) {
	GHashTable* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* props;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	props = _tmp2_;
	{
		GstDiscoverer* _tmp3_;
		GstDiscoverer* discoverer;
		GstDiscoverer* _tmp4_;
		const gchar* _tmp5_;
		GstDiscovererInfo* _tmp6_ = NULL;
		GstDiscovererInfo* discoverer_info;
		GstDiscovererInfo* _tmp7_;
		GList* _tmp8_ = NULL;
		GList* video_streams;
		gboolean _tmp9_ = FALSE;
		GList* _tmp10_;
		gboolean _tmp13_;
		_tmp3_ = gst_discoverer_new ((GstClockTime) (2 * 1000000000), &_inner_error_);
		discoverer = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp4_ = discoverer;
		_tmp5_ = uri;
		_tmp6_ = gst_discoverer_discover_uri (_tmp4_, _tmp5_, &_inner_error_);
		discoverer_info = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (discoverer);
			goto __catch2_g_error;
		}
		_tmp7_ = discoverer_info;
		_tmp8_ = gst_discoverer_info_get_video_streams (_tmp7_);
		video_streams = _tmp8_;
		_tmp10_ = video_streams;
		if (_tmp10_ != NULL) {
			GList* _tmp11_;
			guint _tmp12_ = 0U;
			_tmp11_ = video_streams;
			_tmp12_ = g_list_length (_tmp11_);
			_tmp9_ = _tmp12_ > ((guint) 0);
		} else {
			_tmp9_ = FALSE;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			GList* _tmp14_;
			gconstpointer _tmp15_ = NULL;
			GstDiscovererVideoInfo* _tmp16_;
			GstDiscovererVideoInfo* vstream;
			GHashTable* _tmp17_;
			gchar* _tmp18_;
			GstDiscovererVideoInfo* _tmp19_;
			guint _tmp20_ = 0U;
			GVariant* _tmp21_;
			GVariant* _tmp22_;
			GHashTable* _tmp23_;
			gchar* _tmp24_;
			GstDiscovererVideoInfo* _tmp25_;
			guint _tmp26_ = 0U;
			GVariant* _tmp27_;
			GVariant* _tmp28_;
			GHashTable* _tmp29_;
			gchar* _tmp30_;
			GstDiscovererVideoInfo* _tmp31_;
			GstCaps* _tmp32_ = NULL;
			GstCaps* _tmp33_;
			const gchar* _tmp34_ = NULL;
			GVariant* _tmp35_;
			GVariant* _tmp36_;
			_tmp14_ = video_streams;
			_tmp15_ = g_list_nth_data (_tmp14_, (guint) 0);
			_tmp16_ = _gst_mini_object_ref0 ((GstDiscovererVideoInfo*) _tmp15_);
			vstream = _tmp16_;
			_tmp17_ = props;
			_tmp18_ = g_strdup ("width");
			_tmp19_ = vstream;
			_tmp20_ = gst_discoverer_video_info_get_width (_tmp19_);
			_tmp21_ = g_variant_new_uint32 ((guint32) _tmp20_);
			_tmp22_ = g_variant_ref_sink (_tmp21_);
			g_hash_table_insert (_tmp17_, _tmp18_, _tmp22_);
			_tmp23_ = props;
			_tmp24_ = g_strdup ("height");
			_tmp25_ = vstream;
			_tmp26_ = gst_discoverer_video_info_get_height (_tmp25_);
			_tmp27_ = g_variant_new_uint32 ((guint32) _tmp26_);
			_tmp28_ = g_variant_ref_sink (_tmp27_);
			g_hash_table_insert (_tmp23_, _tmp24_, _tmp28_);
			_tmp29_ = props;
			_tmp30_ = g_strdup ("codec");
			_tmp31_ = vstream;
			_tmp32_ = gst_discoverer_stream_info_get_caps ((GstDiscovererStreamInfo*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = gst_pb_utils_get_codec_description (_tmp33_);
			_tmp35_ = g_variant_new_string (_tmp34_);
			_tmp36_ = g_variant_ref_sink (_tmp35_);
			g_hash_table_insert (_tmp29_, _tmp30_, _tmp36_);
			_gst_caps_unref0 (_tmp33_);
			_gst_mini_object_unref0 (vstream);
		}
		__g_list_free__gst_mini_object_unref0_0 (video_streams);
		_gst_mini_object_unref0 (discoverer_info);
		_g_object_unref0 (discoverer);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp37_;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp37_ = uri;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("player.vala:360: Failed to get video file properties for '%s': '%s'\n", _tmp37_, _tmp39_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_hash_table_unref0 (props);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = props;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_UINT_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_UINT_DOUBLE) (gpointer data1, const char* arg_1, guint32 arg_2, gdouble arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_UINT_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_UINT_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_double (param_values + 3), data2);
}


static void preview_player_value_preview_player_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void preview_player_value_preview_player_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		preview_player_preview_player_unref (value->data[0].v_pointer);
	}
}


static void preview_player_value_preview_player_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = preview_player_preview_player_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer preview_player_value_preview_player_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* preview_player_value_preview_player_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PreviewPlayerPreviewPlayer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = preview_player_preview_player_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* preview_player_value_preview_player_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PreviewPlayerPreviewPlayer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = preview_player_preview_player_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* preview_player_param_spec_preview_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	PreviewPlayerParamSpecPreviewPlayer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer preview_player_value_get_preview_player (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER), NULL);
	return value->data[0].v_pointer;
}


void preview_player_value_set_preview_player (GValue* value, gpointer v_object) {
	PreviewPlayerPreviewPlayer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		preview_player_preview_player_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		preview_player_preview_player_unref (old);
	}
}


void preview_player_value_take_preview_player (GValue* value, gpointer v_object) {
	PreviewPlayerPreviewPlayer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		preview_player_preview_player_unref (old);
	}
}


static void preview_player_preview_player_class_init (PreviewPlayerPreviewPlayerClass * klass) {
	preview_player_preview_player_parent_class = g_type_class_peek_parent (klass);
	PREVIEW_PLAYER_PREVIEW_PLAYER_CLASS (klass)->finalize = preview_player_preview_player_finalize;
	g_type_class_add_private (klass, sizeof (PreviewPlayerPreviewPlayerPrivate));
	g_signal_new ("progress", PREVIEW_PLAYER_TYPE_PREVIEW_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_UINT_DOUBLE, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_DOUBLE);
}


static void preview_player_preview_player_instance_init (PreviewPlayerPreviewPlayer * self) {
	self->priv = PREVIEW_PLAYER_PREVIEW_PLAYER_GET_PRIVATE (self);
	self->priv->update_registry = FALSE;
	self->ref_count = 1;
}


static void preview_player_preview_player_finalize (PreviewPlayerPreviewPlayer* obj) {
	PreviewPlayerPreviewPlayer * self;
	self = PREVIEW_PLAYER_PREVIEW_PLAYER (obj);
	_gst_object_unref0 (self->priv->gst_pipeline);
	_gst_object_unref0 (self->priv->gst_playbin);
	_gst_object_unref0 (self->priv->gst_sink);
	_gst_object_unref0 (self->priv->gst_bus);
	_g_free0 (self->priv->uri);
}


GType preview_player_preview_player_get_type (void) {
	static volatile gsize preview_player_preview_player_type_id__volatile = 0;
	if (g_once_init_enter (&preview_player_preview_player_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { preview_player_value_preview_player_init, preview_player_value_preview_player_free_value, preview_player_value_preview_player_copy_value, preview_player_value_preview_player_peek_pointer, "p", preview_player_value_preview_player_collect_value, "p", preview_player_value_preview_player_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PreviewPlayerPreviewPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preview_player_preview_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreviewPlayerPreviewPlayer), 0, (GInstanceInitFunc) preview_player_preview_player_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType preview_player_preview_player_type_id;
		preview_player_preview_player_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PreviewPlayerPreviewPlayer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&preview_player_preview_player_type_id__volatile, preview_player_preview_player_type_id);
	}
	return preview_player_preview_player_type_id__volatile;
}


gpointer preview_player_preview_player_ref (gpointer instance) {
	PreviewPlayerPreviewPlayer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void preview_player_preview_player_unref (gpointer instance) {
	PreviewPlayerPreviewPlayer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PREVIEW_PLAYER_PREVIEW_PLAYER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



