/* greeter-list.c generated by valac 0.18.1, the Vala compiler
 * generated from greeter-list.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 *          Scott Sweeny <scott.sweeny@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <lightdm.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;
typedef struct _FadableBoxPrivate FadableBoxPrivate;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;
typedef struct _GreeterListPrivate GreeterListPrivate;

#define TYPE_PROMPT_BOX (prompt_box_get_type ())
#define PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT_BOX, PromptBox))
#define PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT_BOX, PromptBoxClass))
#define IS_PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT_BOX))
#define IS_PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT_BOX))
#define PROMPT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT_BOX, PromptBoxClass))

typedef struct _PromptBox PromptBox;
typedef struct _PromptBoxClass PromptBoxClass;

#define TYPE_DASH_BOX (dash_box_get_type ())
#define DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BOX, DashBox))
#define DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BOX, DashBoxClass))
#define IS_DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BOX))
#define IS_DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BOX))
#define DASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BOX, DashBoxClass))

typedef struct _DashBox DashBox;
typedef struct _DashBoxClass DashBoxClass;

#define GREETER_LIST_TYPE_MODE (greeter_list_mode_get_type ())

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;

#define TYPE_ANIMATE_TIMER (animate_timer_get_type ())
#define ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATE_TIMER, AnimateTimer))
#define ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATE_TIMER, AnimateTimerClass))
#define IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATE_TIMER))
#define IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATE_TIMER))
#define ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATE_TIMER, AnimateTimerClass))

typedef struct _AnimateTimer AnimateTimer;
typedef struct _AnimateTimerClass AnimateTimerClass;

#define GREETER_LIST_TYPE_SCROLL_TARGET (greeter_list_scroll_target_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_UNITY_GREETER (unity_greeter_get_type ())
#define UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNITY_GREETER, UnityGreeter))
#define UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNITY_GREETER, UnityGreeterClass))
#define IS_UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNITY_GREETER))
#define IS_UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNITY_GREETER))
#define UNITY_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNITY_GREETER, UnityGreeterClass))

typedef struct _UnityGreeter UnityGreeter;
typedef struct _UnityGreeterClass UnityGreeterClass;

#define TYPE_DASH_ENTRY (dash_entry_get_type ())
#define DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_ENTRY, DashEntry))
#define DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_ENTRY, DashEntryClass))
#define IS_DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_ENTRY))
#define IS_DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_ENTRY))
#define DASH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_ENTRY, DashEntryClass))

typedef struct _DashEntry DashEntry;
typedef struct _DashEntryClass DashEntryClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _UnityGreeterPrivate UnityGreeterPrivate;

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _FadableBox {
	GtkEventBox parent_instance;
	FadableBoxPrivate * priv;
};

struct _FadableBoxClass {
	GtkEventBoxClass parent_class;
	void (*draw_full_alpha) (FadableBox* self, cairo_t* c);
};

typedef enum  {
	GREETER_LIST_MODE_ENTRY,
	GREETER_LIST_MODE_SCROLLING
} GreeterListMode;

struct _GreeterList {
	FadableBox parent_instance;
	GreeterListPrivate * priv;
	gchar* greeter_authenticating_user;
	gboolean _always_show_manual;
	GList* entries;
	DashBox* greeter_box;
	GreeterListMode mode;
	gboolean will_clear;
	gboolean prompted;
	gchar* test_username;
	gboolean test_is_authenticated;
};

struct _GreeterListClass {
	FadableBoxClass parent_class;
	gchar* (*get_selected_id) (GreeterList* self);
	void (*focus_prompt) (GreeterList* self);
	void (*show_authenticated) (GreeterList* self, gboolean successful);
	void (*insert_entry) (GreeterList* self, PromptBox* entry);
	void (*add_manual_entry) (GreeterList* self);
	gint (*get_position_y) (GreeterList* self, gdouble position);
	void (*setup_prompt_box) (GreeterList* self, gboolean fade);
	void (*show_prompt_cb) (GreeterList* self, const gchar* text, LightDMPromptType type);
	void (*authentication_complete_cb) (GreeterList* self);
	void (*start_authentication) (GreeterList* self);
	gchar* (*get_lightdm_session) (GreeterList* self);
	void (*test_start_authentication) (GreeterList* self);
};

struct _GreeterListPrivate {
	Background* _background;
	MenuBar* _menubar;
	PromptBox* _selected_entry;
	gboolean _start_scrolling;
	gdouble scroll_target_location;
	gdouble scroll_start_location;
	gdouble scroll_location;
	gdouble scroll_direction;
	AnimateTimer* scroll_timer;
	GtkFixed* fixed;
	gint cached_box_height;
	guint n_above;
	guint n_below;
	gchar* _manual_name;
	PromptBox* _scrolling_entry;
};

typedef enum  {
	GREETER_LIST_SCROLL_TARGET_START,
	GREETER_LIST_SCROLL_TARGET_END,
	GREETER_LIST_SCROLL_TARGET_UP,
	GREETER_LIST_SCROLL_TARGET_DOWN
} GreeterListScrollTarget;

struct _UnityGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGreeterPrivate * priv;
	gboolean test_mode;
};

struct _UnityGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGreeter *self);
};

typedef gdouble (*AnimateTimerEasingFunc) (gdouble x, void* user_data);

static gpointer greeter_list_parent_class = NULL;
extern UnityGreeter* unity_greeter_singleton;

gint get_grid_offset (gint size);
#define grid_size 40
GType fade_tracker_get_type (void) G_GNUC_CONST;
GType fadable_get_type (void) G_GNUC_CONST;
GType fadable_box_get_type (void) G_GNUC_CONST;
GType greeter_list_get_type (void) G_GNUC_CONST;
GType prompt_box_get_type (void) G_GNUC_CONST;
GType dash_box_get_type (void) G_GNUC_CONST;
GType greeter_list_mode_get_type (void) G_GNUC_CONST;
GType background_get_type (void) G_GNUC_CONST;
GType menu_bar_get_type (void) G_GNUC_CONST;
GType animate_timer_get_type (void) G_GNUC_CONST;
#define GREETER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GREETER_LIST, GreeterListPrivate))
enum  {
	GREETER_LIST_DUMMY_PROPERTY,
	GREETER_LIST_BACKGROUND,
	GREETER_LIST_MENUBAR,
	GREETER_LIST_SELECTED_ENTRY,
	GREETER_LIST_START_SCROLLING,
	GREETER_LIST_ALWAYS_SHOW_MANUAL,
	GREETER_LIST_MANUAL_NAME
};
GType greeter_list_scroll_target_get_type (void) G_GNUC_CONST;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define GREETER_LIST_BORDER 4
#define GREETER_LIST_BOX_WIDTH 8
#define GREETER_LIST_DEFAULT_BOX_HEIGHT 3
gchar* greeter_list_get_selected_id (GreeterList* self);
static gchar* greeter_list_real_get_selected_id (GreeterList* self);
PromptBox* greeter_list_get_selected_entry (GreeterList* self);
const gchar* prompt_box_get_id (PromptBox* self);
GreeterList* greeter_list_construct (GType object_type, Background* bg, MenuBar* mb);
static void greeter_list_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
static void greeter_list_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat);
void greeter_list_cancel_authentication (GreeterList* self);
gpointer unity_greeter_ref (gpointer instance);
void unity_greeter_unref (gpointer instance);
GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_unity_greeter (GValue* value, gpointer v_object);
void value_take_unity_greeter (GValue* value, gpointer v_object);
gpointer value_get_unity_greeter (const GValue* value);
GType unity_greeter_get_type (void) G_GNUC_CONST;
void unity_greeter_cancel_authentication (UnityGreeter* self);
void greeter_list_scroll (GreeterList* self, GreeterListScrollTarget target);
void greeter_list_select_entry (GreeterList* self, PromptBox* entry, gdouble direction, gboolean do_scroll);
void greeter_list_add_with_class (GreeterList* self, GtkWidget* widget);
void unity_greeter_add_style_class (GtkWidget* widget);
void greeter_list_redraw_greeter_box (GreeterList* self);
void greeter_list_show_message (GreeterList* self, const gchar* text, gboolean is_error);
void prompt_box_clear (PromptBox* self);
void prompt_box_add_message (PromptBox* self, const gchar* text, gboolean is_error);
GType dash_entry_get_type (void) G_GNUC_CONST;
DashEntry* greeter_list_add_prompt (GreeterList* self, const gchar* text, gboolean secret);
const gchar* prompt_box_get_label (PromptBox* self);
DashEntry* prompt_box_add_prompt (PromptBox* self, const gchar* text, const gchar* accessible_text, gboolean is_secret);
void prompt_box_show_prompts (PromptBox* self);
void greeter_list_focus_prompt (GreeterList* self);
GtkComboBox* greeter_list_add_combo (GreeterList* self, GPtrArray* texts, gboolean read_only);
GtkComboBox* prompt_box_add_combo (PromptBox* self, GPtrArray* texts, gboolean read_only);
static void greeter_list_real_grab_focus (GtkWidget* base);
static void greeter_list_real_focus_prompt (GreeterList* self);
void greeter_list_show_authenticated (GreeterList* self, gboolean successful);
static void greeter_list_real_show_authenticated (GreeterList* self, gboolean successful);
PromptBox* greeter_list_find_entry (GreeterList* self, const gchar* id);
gint greeter_list_compare_entry (PromptBox* a, PromptBox* b);
gboolean greeter_list_have_entries (GreeterList* self);
void greeter_list_insert_entry (GreeterList* self, PromptBox* entry);
static void greeter_list_real_insert_entry (GreeterList* self, PromptBox* entry);
static gint _greeter_list_compare_entry_gcompare_func (gconstpointer a, gconstpointer b);
void greeter_list_add_manual_entry (GreeterList* self);
static void greeter_list_real_add_manual_entry (GreeterList* self);
void greeter_list_add_entry (GreeterList* self, PromptBox* entry);
static void greeter_list_entry_clicked_cb (GreeterList* self, PromptBox* entry);
static void _greeter_list_entry_clicked_cb_prompt_box_name_clicked (PromptBox* _sender, gpointer self);
void greeter_list_move_names (GreeterList* self);
void greeter_list_set_active_entry (GreeterList* self, const gchar* name);
void greeter_list_set_active_first_entry_with_prefix (GreeterList* self, const gchar* prefix);
void greeter_list_remove_entry (GreeterList* self, const gchar* name);
void greeter_list_remove_entry_by_entry (GreeterList* self, PromptBox* entry);
void greeter_list_remove_entries_with_prefix (GreeterList* self, const gchar* prefix);
gint greeter_list_get_greeter_box_height (GreeterList* self);
gint greeter_list_get_greeter_box_height_grids (GreeterList* self);
gint greeter_list_get_greeter_box_x (GreeterList* self);
static gint greeter_list_get_box_x (GreeterList* self);
gint greeter_list_get_greeter_box_y (GreeterList* self);
static gint greeter_list_get_box_y (GreeterList* self);
gint greeter_list_get_position_y (GreeterList* self, gdouble position);
static gint greeter_list_real_get_position_y (GreeterList* self, gdouble position);
static void greeter_list_move_entry (GreeterList* self, PromptBox* entry, gdouble position);
void fadable_set_alpha (Fadable* self, gdouble alpha);
void prompt_box_set_position (PromptBox* self, gdouble value);
void greeter_list_greeter_box_size_allocate_cb (GreeterList* self, GtkAllocation* allocation);
static PromptBox* greeter_list_get_scrolling_entry (GreeterList* self);
static gboolean ___lambda33_ (GreeterList* self);
static gboolean ____lambda33__gsource_func (gpointer self);
gboolean dash_box_get_has_base (DashBox* self);
gdouble dash_box_get_base_alpha (DashBox* self);
static void greeter_list_animate_scrolling (GreeterList* self, gdouble progress);
void greeter_list_setup_prompt_box (GreeterList* self, gboolean fade);
static void greeter_list_finished_scrolling (GreeterList* self);
static void greeter_list_set_scrolling_entry (GreeterList* self, PromptBox* value);
static void greeter_list_set_selected_entry (GreeterList* self, PromptBox* value);
void animate_timer_reset (AnimateTimer* self, gint temp_speed);
void dash_box_set_base (DashBox* self, GtkWidget* w);
static void greeter_list_real_setup_prompt_box (GreeterList* self, gboolean fade);
void prompt_box_add_static_prompts (PromptBox* self);
void prompt_box_fade_in_prompts (PromptBox* self);
static void greeter_list_real_realize (GtkWidget* base);
gboolean greeter_list_get_start_scrolling (GreeterList* self);
static void greeter_list_allocate_greeter_box (GreeterList* self);
void prompt_box_set_zone (PromptBox* self, GtkWidget* zone);
static void greeter_list_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static gboolean greeter_list_real_draw (GtkWidget* base, cairo_t* c);
FadeTracker* fadable_get_fade_tracker (Fadable* self);
gdouble fade_tracker_get_alpha (FadeTracker* self);
void greeter_list_connect_to_lightdm (GreeterList* self);
void greeter_list_show_message_cb (GreeterList* self, const gchar* text, LightDMMessageType type);
static void _greeter_list_show_message_cb_unity_greeter_show_message (UnityGreeter* _sender, const gchar* text, LightDMMessageType type, gpointer self);
void greeter_list_show_prompt_cb (GreeterList* self, const gchar* text, LightDMPromptType type);
static void _greeter_list_show_prompt_cb_unity_greeter_show_prompt (UnityGreeter* _sender, const gchar* text, LightDMPromptType type, gpointer self);
void greeter_list_authentication_complete_cb (GreeterList* self);
static void _greeter_list_authentication_complete_cb_unity_greeter_authentication_complete (UnityGreeter* _sender, gpointer self);
static void greeter_list_real_show_prompt_cb (GreeterList* self, const gchar* text, LightDMPromptType type);
const gchar* greeter_list_get_manual_name (GreeterList* self);
void greeter_list_set_manual_name (GreeterList* self, const gchar* value);
gchar* unity_greeter_authentication_user (UnityGreeter* self);
static void greeter_list_real_authentication_complete_cb (GreeterList* self);
gboolean unity_greeter_is_authenticated (UnityGreeter* self);
void greeter_list_login_complete (GreeterList* self);
static void greeter_list_start_session (GreeterList* self);
Background* greeter_list_get_background (GreeterList* self);
gdouble background_get_alpha (Background* self);
static void greeter_list_background_loaded_cb (GreeterList* self, GParamSpec* pspec);
static void _greeter_list_background_loaded_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void prompt_box_reset_spinners (PromptBox* self);
void greeter_list_start_authentication (GreeterList* self);
gboolean prompt_box_get_has_errors (PromptBox* self);
static void greeter_list_real_start_authentication (GreeterList* self);
void greeter_list_test_start_authentication (GreeterList* self);
void unity_greeter_authenticate (UnityGreeter* self, const gchar* userid);
void unity_greeter_authenticate_as_guest (UnityGreeter* self);
void background_set_draw_grid (Background* self, gboolean value);
void unity_greeter_start_session (UnityGreeter* self, const gchar* session, Background* bg);
gchar* greeter_list_get_lightdm_session (GreeterList* self);
static gchar* greeter_list_real_get_lightdm_session (GreeterList* self);
static void greeter_list_real_test_start_authentication (GreeterList* self);
static void greeter_list_set_background (GreeterList* self, Background* value);
MenuBar* greeter_list_get_menubar (GreeterList* self);
static void greeter_list_set_menubar (GreeterList* self, MenuBar* value);
void greeter_list_set_start_scrolling (GreeterList* self, gboolean value);
gboolean greeter_list_get_always_show_manual (GreeterList* self);
void greeter_list_set_always_show_manual (GreeterList* self, gboolean value);
#define MAIN_WINDOW_MENUBAR_HEIGHT 32
void prompt_box_set_options_image (PromptBox* self, GdkPixbuf* image);
static GObject * greeter_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
DashBox* dash_box_new (Background* bg);
DashBox* dash_box_construct (GType object_type, Background* bg);
static void _greeter_list___lambda34_ (GreeterList* self);
static void __greeter_list___lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _greeter_list_greeter_box_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
gdouble animate_timer_ease_out_quint (gdouble x);
static gdouble _animate_timer_ease_out_quint_animate_timer_easing_func (gdouble x, gpointer self);
#define ANIMATE_TIMER_FAST 250
AnimateTimer* animate_timer_new (AnimateTimerEasingFunc func, void* func_target, gint speed);
AnimateTimer* animate_timer_construct (GType object_type, AnimateTimerEasingFunc func, void* func_target, gint speed);
static void _greeter_list_animate_scrolling_animate_timer_animate (AnimateTimer* _sender, gdouble progress, gpointer self);
static void greeter_list_finalize (GObject* obj);
static void _vala_greeter_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_greeter_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gint get_grid_offset (gint size) {
	gint result = 0;
	gint _tmp0_;
	_tmp0_ = size;
	result = ((gint) (_tmp0_ % grid_size)) / 2;
	return result;
}


GType greeter_list_mode_get_type (void) {
	static volatile gsize greeter_list_mode_type_id__volatile = 0;
	if (g_once_init_enter (&greeter_list_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GREETER_LIST_MODE_ENTRY, "GREETER_LIST_MODE_ENTRY", "entry"}, {GREETER_LIST_MODE_SCROLLING, "GREETER_LIST_MODE_SCROLLING", "scrolling"}, {0, NULL, NULL}};
		GType greeter_list_mode_type_id;
		greeter_list_mode_type_id = g_enum_register_static ("GreeterListMode", values);
		g_once_init_leave (&greeter_list_mode_type_id__volatile, greeter_list_mode_type_id);
	}
	return greeter_list_mode_type_id__volatile;
}


GType greeter_list_scroll_target_get_type (void) {
	static volatile gsize greeter_list_scroll_target_type_id__volatile = 0;
	if (g_once_init_enter (&greeter_list_scroll_target_type_id__volatile)) {
		static const GEnumValue values[] = {{GREETER_LIST_SCROLL_TARGET_START, "GREETER_LIST_SCROLL_TARGET_START", "start"}, {GREETER_LIST_SCROLL_TARGET_END, "GREETER_LIST_SCROLL_TARGET_END", "end"}, {GREETER_LIST_SCROLL_TARGET_UP, "GREETER_LIST_SCROLL_TARGET_UP", "up"}, {GREETER_LIST_SCROLL_TARGET_DOWN, "GREETER_LIST_SCROLL_TARGET_DOWN", "down"}, {0, NULL, NULL}};
		GType greeter_list_scroll_target_type_id;
		greeter_list_scroll_target_type_id = g_enum_register_static ("GreeterListScrollTarget", values);
		g_once_init_leave (&greeter_list_scroll_target_type_id__volatile, greeter_list_scroll_target_type_id);
	}
	return greeter_list_scroll_target_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gchar* greeter_list_real_get_selected_id (GreeterList* self) {
	gchar* result = NULL;
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = self->priv->_selected_entry;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_selected_entry;
	_tmp2_ = prompt_box_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}


gchar* greeter_list_get_selected_id (GreeterList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GREETER_LIST_GET_CLASS (self)->get_selected_id (self);
}


GreeterList* greeter_list_construct (GType object_type, Background* bg, MenuBar* mb) {
	GreeterList * self = NULL;
	Background* _tmp0_;
	MenuBar* _tmp1_;
	g_return_val_if_fail (bg != NULL, NULL);
	g_return_val_if_fail (mb != NULL, NULL);
	_tmp0_ = bg;
	_tmp1_ = mb;
	self = (GreeterList*) g_object_new (object_type, "background", _tmp0_, "menubar", _tmp1_, NULL);
	return self;
}


static void greeter_list_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	GreeterList * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (GreeterList*) base;
	_vala_min = GREETER_LIST_BOX_WIDTH * grid_size;
	_vala_nat = GREETER_LIST_BOX_WIDTH * grid_size;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void greeter_list_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat) {
	GreeterList * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = (GreeterList*) base;
	GTK_WIDGET_CLASS (greeter_list_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FADABLE_BOX, FadableBox), &_tmp0_, &_tmp1_);
	_vala_min = _tmp0_;
	_vala_nat = _tmp1_;
	_vala_min = 0;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


void greeter_list_cancel_authentication (GreeterList* self) {
	UnityGreeter* _tmp0_;
	PromptBox* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_greeter_singleton;
	unity_greeter_cancel_authentication (_tmp0_);
	_tmp1_ = self->priv->_selected_entry;
	_tmp2_ = prompt_box_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (self, "entry-selected", _tmp3_);
}


void greeter_list_scroll (GreeterList* self, GreeterListScrollTarget target) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GreeterListScrollTarget _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_sensitive ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = target;
	switch (_tmp2_) {
		case GREETER_LIST_SCROLL_TARGET_START:
		{
			GList* _tmp3_;
			gconstpointer _tmp4_ = NULL;
			_tmp3_ = self->entries;
			_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
			greeter_list_select_entry (self, (PromptBox*) _tmp4_, -1.0, TRUE);
			break;
		}
		case GREETER_LIST_SCROLL_TARGET_END:
		{
			GList* _tmp5_;
			GList* _tmp6_;
			guint _tmp7_ = 0U;
			gconstpointer _tmp8_ = NULL;
			_tmp5_ = self->entries;
			_tmp6_ = self->entries;
			_tmp7_ = g_list_length (_tmp6_);
			_tmp8_ = g_list_nth_data (_tmp5_, _tmp7_ - 1);
			greeter_list_select_entry (self, (PromptBox*) _tmp8_, 1.0, TRUE);
			break;
		}
		case GREETER_LIST_SCROLL_TARGET_UP:
		{
			GList* _tmp9_;
			PromptBox* _tmp10_;
			gint _tmp11_ = 0;
			gint index;
			gint _tmp12_;
			GList* _tmp13_;
			gint _tmp14_;
			gconstpointer _tmp15_ = NULL;
			_tmp9_ = self->entries;
			_tmp10_ = self->priv->_selected_entry;
			_tmp11_ = g_list_index (_tmp9_, _tmp10_);
			index = _tmp11_ - 1;
			_tmp12_ = index;
			if (_tmp12_ < 0) {
				index = 0;
			}
			_tmp13_ = self->entries;
			_tmp14_ = index;
			_tmp15_ = g_list_nth_data (_tmp13_, (guint) _tmp14_);
			greeter_list_select_entry (self, (PromptBox*) _tmp15_, -1.0, TRUE);
			break;
		}
		case GREETER_LIST_SCROLL_TARGET_DOWN:
		{
			GList* _tmp16_;
			PromptBox* _tmp17_;
			gint _tmp18_ = 0;
			gint index;
			gint _tmp19_;
			GList* _tmp20_;
			guint _tmp21_ = 0U;
			GList* _tmp24_;
			gint _tmp25_;
			gconstpointer _tmp26_ = NULL;
			_tmp16_ = self->entries;
			_tmp17_ = self->priv->_selected_entry;
			_tmp18_ = g_list_index (_tmp16_, _tmp17_);
			index = _tmp18_ + 1;
			_tmp19_ = index;
			_tmp20_ = self->entries;
			_tmp21_ = g_list_length (_tmp20_);
			if (_tmp19_ >= ((gint) _tmp21_)) {
				GList* _tmp22_;
				guint _tmp23_ = 0U;
				_tmp22_ = self->entries;
				_tmp23_ = g_list_length (_tmp22_);
				index = ((gint) _tmp23_) - 1;
			}
			_tmp24_ = self->entries;
			_tmp25_ = index;
			_tmp26_ = g_list_nth_data (_tmp24_, (guint) _tmp25_);
			greeter_list_select_entry (self, (PromptBox*) _tmp26_, 1.0, TRUE);
			break;
		}
		default:
		break;
	}
}


void greeter_list_add_with_class (GreeterList* self, GtkWidget* widget) {
	GtkFixed* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->fixed;
	_tmp1_ = widget;
	gtk_container_add ((GtkContainer*) _tmp0_, _tmp1_);
	_tmp2_ = widget;
	unity_greeter_add_style_class (_tmp2_);
}


void greeter_list_redraw_greeter_box (GreeterList* self) {
	GtkAllocation allocation = {0};
	DashBox* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_;
	gint _tmp3_;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->greeter_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	allocation = _tmp1_;
	_tmp2_ = allocation;
	_tmp3_ = _tmp2_.x;
	_tmp4_ = allocation;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = allocation;
	_tmp7_ = _tmp6_.width;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.height;
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp3_, _tmp5_, _tmp7_, _tmp9_);
}


void greeter_list_show_message (GreeterList* self, const gchar* text, gboolean is_error) {
	gboolean _tmp0_;
	PromptBox* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->will_clear;
	if (_tmp0_) {
		PromptBox* _tmp1_;
		_tmp1_ = self->priv->_selected_entry;
		prompt_box_clear (_tmp1_);
		self->will_clear = FALSE;
	}
	_tmp2_ = self->priv->_selected_entry;
	_tmp3_ = text;
	_tmp4_ = is_error;
	prompt_box_add_message (_tmp2_, _tmp3_, _tmp4_);
}


DashEntry* greeter_list_add_prompt (GreeterList* self, const gchar* text, gboolean secret) {
	DashEntry* result = NULL;
	gboolean _tmp0_;
	gchar* accessible_text;
	gboolean _tmp2_ = FALSE;
	PromptBox* _tmp3_;
	gboolean _tmp7_;
	PromptBox* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	DashEntry* _tmp17_ = NULL;
	DashEntry* prompt;
	GreeterListMode _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = self->will_clear;
	if (_tmp0_) {
		PromptBox* _tmp1_;
		_tmp1_ = self->priv->_selected_entry;
		prompt_box_clear (_tmp1_);
		self->will_clear = FALSE;
	}
	accessible_text = NULL;
	_tmp3_ = self->priv->_selected_entry;
	if (_tmp3_ != NULL) {
		PromptBox* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->_selected_entry;
		_tmp5_ = prompt_box_get_label (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		PromptBox* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		_tmp8_ = _ ("Enter password for %s");
		_tmp9_ = self->priv->_selected_entry;
		_tmp10_ = prompt_box_get_label (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf (_tmp8_, _tmp11_);
		_g_free0 (accessible_text);
		accessible_text = _tmp12_;
	}
	_tmp13_ = self->priv->_selected_entry;
	_tmp14_ = text;
	_tmp15_ = accessible_text;
	_tmp16_ = secret;
	_tmp17_ = prompt_box_add_prompt (_tmp13_, _tmp14_, _tmp15_, _tmp16_);
	prompt = _tmp17_;
	_tmp18_ = self->mode;
	if (_tmp18_ != GREETER_LIST_MODE_SCROLLING) {
		PromptBox* _tmp19_;
		_tmp19_ = self->priv->_selected_entry;
		prompt_box_show_prompts (_tmp19_);
	}
	greeter_list_focus_prompt (self);
	greeter_list_redraw_greeter_box (self);
	result = prompt;
	_g_free0 (accessible_text);
	return result;
}


GtkComboBox* greeter_list_add_combo (GreeterList* self, GPtrArray* texts, gboolean read_only) {
	GtkComboBox* result = NULL;
	gboolean _tmp0_;
	PromptBox* _tmp2_;
	GPtrArray* _tmp3_;
	gboolean _tmp4_;
	GtkComboBox* _tmp5_ = NULL;
	GtkComboBox* combo;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (texts != NULL, NULL);
	_tmp0_ = self->will_clear;
	if (_tmp0_) {
		PromptBox* _tmp1_;
		_tmp1_ = self->priv->_selected_entry;
		prompt_box_clear (_tmp1_);
		self->will_clear = FALSE;
	}
	_tmp2_ = self->priv->_selected_entry;
	_tmp3_ = texts;
	_tmp4_ = read_only;
	_tmp5_ = prompt_box_add_combo (_tmp2_, _tmp3_, _tmp4_);
	combo = _tmp5_;
	greeter_list_focus_prompt (self);
	greeter_list_redraw_greeter_box (self);
	result = combo;
	return result;
}


static void greeter_list_real_grab_focus (GtkWidget* base) {
	GreeterList * self;
	self = (GreeterList*) base;
	greeter_list_focus_prompt (self);
}


static void greeter_list_real_focus_prompt (GreeterList* self) {
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	_tmp0_ = self->priv->_selected_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->_selected_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}


void greeter_list_focus_prompt (GreeterList* self) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->focus_prompt (self);
}


static void greeter_list_real_show_authenticated (GreeterList* self, gboolean successful) {
	g_critical ("Type `%s' does not implement abstract method `greeter_list_show_authenticated'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void greeter_list_show_authenticated (GreeterList* self, gboolean successful) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->show_authenticated (self, successful);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


PromptBox* greeter_list_find_entry (GreeterList* self, const gchar* id) {
	PromptBox* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp0_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			PromptBox* _tmp1_;
			PromptBox* entry = NULL;
			_tmp1_ = _g_object_ref0 ((PromptBox*) entry_it->data);
			entry = _tmp1_;
			{
				PromptBox* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp2_ = entry;
				_tmp3_ = prompt_box_get_id (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = id;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					result = entry;
					return result;
				}
				_g_object_unref0 (entry);
			}
		}
	}
	result = NULL;
	return result;
}


gint greeter_list_compare_entry (PromptBox* a, PromptBox* b) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	PromptBox* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_;
	PromptBox* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	PromptBox* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gint _tmp30_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = a;
	_tmp2_ = prompt_box_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_str_has_prefix (_tmp3_, "*");
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		PromptBox* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = b;
		_tmp6_ = prompt_box_get_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_str_has_prefix (_tmp7_, "*");
		_tmp0_ = _tmp8_;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		PromptBox* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		PromptBox* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp17_ = FALSE;
		PromptBox* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		PromptBox* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp10_ = a;
		_tmp11_ = prompt_box_get_id (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_str_has_prefix (_tmp12_, "*");
		if (!_tmp13_) {
			result = -1;
			return result;
		}
		_tmp14_ = b;
		_tmp15_ = prompt_box_get_id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_str_has_prefix (_tmp16_, "*");
		if (!_tmp17_) {
			result = 1;
			return result;
		}
		_tmp18_ = a;
		_tmp19_ = prompt_box_get_id (_tmp18_);
		_tmp20_ = _tmp19_;
		if (g_strcmp0 (_tmp20_, "*other") == 0) {
			result = -1;
			return result;
		}
		_tmp21_ = a;
		_tmp22_ = prompt_box_get_id (_tmp21_);
		_tmp23_ = _tmp22_;
		if (g_strcmp0 (_tmp23_, "*guest") == 0) {
			result = 1;
			return result;
		}
	}
	_tmp24_ = a;
	_tmp25_ = prompt_box_get_label (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = b;
	_tmp28_ = prompt_box_get_label (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_ascii_strcasecmp (_tmp26_, _tmp29_);
	result = _tmp30_;
	return result;
}


gboolean greeter_list_have_entries (GreeterList* self) {
	gboolean result = FALSE;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->entries;
	{
		GList* e_collection = NULL;
		GList* e_it = NULL;
		e_collection = _tmp0_;
		for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
			PromptBox* _tmp1_;
			PromptBox* e = NULL;
			_tmp1_ = _g_object_ref0 ((PromptBox*) e_it->data);
			e = _tmp1_;
			{
				PromptBox* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				gboolean _tmp5_ = FALSE;
				_tmp2_ = e;
				_tmp3_ = prompt_box_get_id (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_str_has_prefix (_tmp4_, "*");
				if (!_tmp5_) {
					result = TRUE;
					_g_object_unref0 (e);
					return result;
				}
				_g_object_unref0 (e);
			}
		}
	}
	result = FALSE;
	return result;
}


static gint _greeter_list_compare_entry_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = greeter_list_compare_entry (a, b);
	return result;
}


static void greeter_list_real_insert_entry (GreeterList* self, PromptBox* entry) {
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	g_return_if_fail (entry != NULL);
	_tmp0_ = entry;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	self->entries = g_list_insert_sorted (self->entries, _tmp1_, _greeter_list_compare_entry_gcompare_func);
}


void greeter_list_insert_entry (GreeterList* self, PromptBox* entry) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->insert_entry (self, entry);
}


static void greeter_list_real_add_manual_entry (GreeterList* self) {
	g_critical ("Type `%s' does not implement abstract method `greeter_list_add_manual_entry'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void greeter_list_add_manual_entry (GreeterList* self) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->add_manual_entry (self);
}


static void _greeter_list_entry_clicked_cb_prompt_box_name_clicked (PromptBox* _sender, gpointer self) {
	greeter_list_entry_clicked_cb (self, _sender);
}


void greeter_list_add_entry (GreeterList* self, PromptBox* entry) {
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	PromptBox* _tmp2_;
	PromptBox* _tmp3_;
	PromptBox* _tmp4_;
	PromptBox* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = entry;
	g_object_set ((GtkWidget*) _tmp0_, "expand", TRUE, NULL);
	_tmp1_ = entry;
	gtk_widget_set_size_request ((GtkWidget*) _tmp1_, (grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2), -1);
	_tmp2_ = entry;
	greeter_list_add_with_class (self, (GtkWidget*) _tmp2_);
	_tmp3_ = entry;
	greeter_list_insert_entry (self, _tmp3_);
	_tmp4_ = entry;
	g_signal_connect_object (_tmp4_, "name-clicked", (GCallback) _greeter_list_entry_clicked_cb_prompt_box_name_clicked, self, 0);
	_tmp5_ = self->priv->_selected_entry;
	if (_tmp5_ == NULL) {
		PromptBox* _tmp6_;
		_tmp6_ = entry;
		greeter_list_select_entry (self, _tmp6_, 1.0, TRUE);
	} else {
		PromptBox* _tmp7_;
		_tmp7_ = self->priv->_selected_entry;
		greeter_list_select_entry (self, _tmp7_, 1.0, TRUE);
	}
	greeter_list_move_names (self);
}


void greeter_list_set_active_entry (GreeterList* self, const gchar* name) {
	const gchar* _tmp0_;
	PromptBox* _tmp1_ = NULL;
	PromptBox* e;
	PromptBox* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = name;
	_tmp1_ = greeter_list_find_entry (self, _tmp0_);
	e = _tmp1_;
	_tmp2_ = e;
	if (_tmp2_ != NULL) {
		PromptBox* _tmp3_;
		_tmp3_ = e;
		greeter_list_select_entry (self, _tmp3_, 1.0, TRUE);
	}
	_g_object_unref0 (e);
}


void greeter_list_set_active_first_entry_with_prefix (GreeterList* self, const gchar* prefix) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prefix != NULL);
	_tmp0_ = self->entries;
	{
		GList* e_collection = NULL;
		GList* e_it = NULL;
		e_collection = _tmp0_;
		for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
			PromptBox* _tmp1_;
			PromptBox* e = NULL;
			_tmp1_ = _g_object_ref0 ((PromptBox*) e_it->data);
			e = _tmp1_;
			{
				PromptBox* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				gboolean _tmp6_ = FALSE;
				_tmp2_ = e;
				_tmp3_ = prompt_box_get_id (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = prefix;
				_tmp6_ = g_str_has_prefix (_tmp4_, _tmp5_);
				if (_tmp6_) {
					PromptBox* _tmp7_;
					_tmp7_ = e;
					greeter_list_select_entry (self, _tmp7_, 1.0, TRUE);
					_g_object_unref0 (e);
					break;
				}
				_g_object_unref0 (e);
			}
		}
	}
}


void greeter_list_remove_entry (GreeterList* self, const gchar* name) {
	const gchar* _tmp0_;
	PromptBox* _tmp1_ = NULL;
	PromptBox* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = name;
	_tmp1_ = greeter_list_find_entry (self, _tmp0_);
	_tmp2_ = _tmp1_;
	greeter_list_remove_entry_by_entry (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}


void greeter_list_remove_entries_with_prefix (GreeterList* self, const gchar* prefix) {
	gint i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prefix != NULL);
	i = 0;
	while (TRUE) {
		gint _tmp0_;
		GList* _tmp1_;
		guint _tmp2_ = 0U;
		GList* _tmp3_;
		gint _tmp4_;
		gconstpointer _tmp5_ = NULL;
		PromptBox* _tmp6_;
		PromptBox* e;
		PromptBox* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp0_ = i;
		_tmp1_ = self->entries;
		_tmp2_ = g_list_length (_tmp1_);
		if (!(((guint) _tmp0_) < _tmp2_)) {
			break;
		}
		_tmp3_ = self->entries;
		_tmp4_ = i;
		_tmp5_ = g_list_nth_data (_tmp3_, (guint) _tmp4_);
		_tmp6_ = _g_object_ref0 ((PromptBox*) _tmp5_);
		e = _tmp6_;
		_tmp7_ = e;
		_tmp8_ = prompt_box_get_id (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = prefix;
		_tmp11_ = g_str_has_prefix (_tmp9_, _tmp10_);
		if (_tmp11_) {
			PromptBox* _tmp12_;
			_tmp12_ = e;
			greeter_list_remove_entry_by_entry (self, _tmp12_);
		} else {
			gint _tmp13_;
			_tmp13_ = i;
			i = _tmp13_ + 1;
		}
		_g_object_unref0 (e);
	}
}


void greeter_list_remove_entry_by_entry (GreeterList* self, PromptBox* entry) {
	PromptBox* _tmp0_;
	GList* _tmp1_;
	PromptBox* _tmp2_;
	gint _tmp3_ = 0;
	gint index;
	PromptBox* _tmp4_;
	PromptBox* _tmp5_;
	gboolean _tmp6_ = FALSE;
	PromptBox* _tmp7_;
	PromptBox* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = entry;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->entries;
	_tmp2_ = entry;
	_tmp3_ = g_list_index (_tmp1_, _tmp2_);
	index = _tmp3_;
	_tmp4_ = entry;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = entry;
	self->entries = g_list_remove (self->entries, _tmp5_);
	_tmp6_ = greeter_list_have_entries (self);
	if (!_tmp6_) {
		greeter_list_add_manual_entry (self);
	}
	_tmp7_ = entry;
	_tmp8_ = self->priv->_selected_entry;
	if (_tmp7_ == _tmp8_) {
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		GList* _tmp11_;
		guint _tmp12_ = 0U;
		gboolean _tmp14_;
		GList* _tmp16_;
		gint _tmp17_;
		gconstpointer _tmp18_ = NULL;
		_tmp10_ = index;
		_tmp11_ = self->entries;
		_tmp12_ = g_list_length (_tmp11_);
		if (((guint) _tmp10_) >= _tmp12_) {
			gint _tmp13_;
			_tmp13_ = index;
			_tmp9_ = _tmp13_ > 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp14_ = _tmp9_;
		if (_tmp14_) {
			gint _tmp15_;
			_tmp15_ = index;
			index = _tmp15_ - 1;
		}
		_tmp16_ = self->entries;
		_tmp17_ = index;
		_tmp18_ = g_list_nth_data (_tmp16_, (guint) _tmp17_);
		greeter_list_select_entry (self, (PromptBox*) _tmp18_, -1.0, TRUE);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


gint greeter_list_get_greeter_box_height (GreeterList* self) {
	gint result = 0;
	gint height = 0;
	DashBox* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->greeter_box;
	gtk_widget_get_preferred_height ((GtkWidget*) _tmp0_, NULL, &_tmp1_);
	height = _tmp1_;
	result = height;
	return result;
}


gint greeter_list_get_greeter_box_height_grids (GreeterList* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint height;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = greeter_list_get_greeter_box_height (self);
	height = _tmp0_;
	result = (height / grid_size) + 1;
	return result;
}


gint greeter_list_get_greeter_box_x (GreeterList* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = greeter_list_get_box_x (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ + GREETER_LIST_BORDER;
	return result;
}


gint greeter_list_get_greeter_box_y (GreeterList* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = greeter_list_get_box_y (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ + GREETER_LIST_BORDER;
	return result;
}


static gint greeter_list_real_get_position_y (GreeterList* self, gdouble position) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint box_height;
	gdouble offset = 0.0;
	gdouble _tmp1_;
	gint _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_ = 0.0;
	_tmp0_ = greeter_list_get_greeter_box_height_grids (self);
	box_height = _tmp0_ * grid_size;
	_tmp1_ = position;
	if (_tmp1_ < ((gdouble) 0)) {
		gdouble _tmp2_;
		_tmp2_ = position;
		offset = _tmp2_ * grid_size;
	} else {
		gdouble _tmp3_;
		_tmp3_ = position;
		if (_tmp3_ < ((gdouble) 1)) {
			gdouble _tmp4_;
			gint _tmp5_;
			_tmp4_ = position;
			_tmp5_ = box_height;
			offset = _tmp4_ * _tmp5_;
		} else {
			gdouble _tmp6_;
			gint _tmp7_;
			_tmp6_ = position;
			_tmp7_ = box_height;
			offset = ((_tmp6_ - 1) * grid_size) + _tmp7_;
		}
	}
	_tmp8_ = greeter_list_get_box_y (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = offset;
	_tmp11_ = round (_tmp10_);
	result = _tmp9_ + ((gint) _tmp11_);
	return result;
}


gint greeter_list_get_position_y (GreeterList* self, gdouble position) {
	g_return_val_if_fail (self != NULL, 0);
	return GREETER_LIST_GET_CLASS (self)->get_position_y (self, position);
}


static void greeter_list_move_entry (GreeterList* self, PromptBox* entry, gdouble position) {
	gdouble alpha;
	gdouble _tmp0_;
	PromptBox* _tmp5_;
	gdouble _tmp6_;
	PromptBox* _tmp7_;
	gdouble _tmp8_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp9_ = {0};
	GtkAllocation child_allocation = {0};
	PromptBox* _tmp10_;
	GtkAllocation _tmp11_;
	gint _tmp12_;
	gint _tmp13_ = 0;
	GtkAllocation _tmp14_;
	gint _tmp15_;
	gint _tmp16_ = 0;
	GtkAllocation _tmp17_;
	gint _tmp18_;
	gdouble _tmp19_;
	gint _tmp20_ = 0;
	GtkFixed* _tmp21_;
	PromptBox* _tmp22_;
	GtkAllocation _tmp23_;
	gint _tmp24_;
	GtkAllocation _tmp25_;
	gint _tmp26_;
	PromptBox* _tmp27_;
	GtkAllocation _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	alpha = 1.0;
	_tmp0_ = position;
	if (_tmp0_ < ((gdouble) 0)) {
		gdouble _tmp1_;
		guint _tmp2_;
		_tmp1_ = position;
		_tmp2_ = self->priv->n_above;
		alpha = 1.0 + (_tmp1_ / (_tmp2_ + 1));
	} else {
		gdouble _tmp3_;
		guint _tmp4_;
		_tmp3_ = position;
		_tmp4_ = self->priv->n_below;
		alpha = 1.0 - (_tmp3_ / (_tmp4_ + 1));
	}
	_tmp5_ = entry;
	_tmp6_ = alpha;
	fadable_set_alpha ((Fadable*) _tmp5_, _tmp6_);
	_tmp7_ = entry;
	_tmp8_ = position;
	prompt_box_set_position (_tmp7_, _tmp8_);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp9_);
	allocation = _tmp9_;
	memset (&child_allocation, 0, sizeof (GtkAllocation));
	child_allocation.width = (grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2);
	_tmp10_ = entry;
	_tmp11_ = child_allocation;
	_tmp12_ = _tmp11_.width;
	gtk_widget_get_preferred_height_for_width ((GtkWidget*) _tmp10_, _tmp12_, NULL, &_tmp13_);
	child_allocation.height = _tmp13_;
	_tmp14_ = allocation;
	_tmp15_ = _tmp14_.x;
	_tmp16_ = greeter_list_get_greeter_box_x (self);
	child_allocation.x = _tmp15_ + _tmp16_;
	_tmp17_ = allocation;
	_tmp18_ = _tmp17_.y;
	_tmp19_ = position;
	_tmp20_ = greeter_list_get_position_y (self, _tmp19_);
	child_allocation.y = _tmp18_ + _tmp20_;
	_tmp21_ = self->priv->fixed;
	_tmp22_ = entry;
	_tmp23_ = child_allocation;
	_tmp24_ = _tmp23_.x;
	_tmp25_ = child_allocation;
	_tmp26_ = _tmp25_.y;
	gtk_fixed_move (_tmp21_, (GtkWidget*) _tmp22_, _tmp24_, _tmp26_);
	_tmp27_ = entry;
	_tmp28_ = child_allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp27_, &_tmp28_);
}


static gboolean ___lambda33_ (GreeterList* self) {
	gboolean result = FALSE;
	greeter_list_move_names (self);
	result = FALSE;
	return result;
}


static gboolean ____lambda33__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda33_ (self);
	return result;
}


void greeter_list_greeter_box_size_allocate_cb (GreeterList* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	PromptBox* _tmp1_;
	PromptBox* _tmp2_;
	gboolean _tmp6_;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp1_ = greeter_list_get_scrolling_entry (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		GtkAllocation _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = *allocation;
		_tmp4_ = _tmp3_.height;
		_tmp5_ = self->priv->cached_box_height;
		_tmp0_ = _tmp4_ != _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda33__gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp7_ = *allocation;
	_tmp8_ = _tmp7_.height;
	self->priv->cached_box_height = _tmp8_;
}


void greeter_list_move_names (GreeterList* self) {
	gint index;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	index = 0;
	_tmp0_ = self->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp0_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			PromptBox* _tmp1_;
			PromptBox* entry = NULL;
			_tmp1_ = _g_object_ref0 ((PromptBox*) entry_it->data);
			entry = _tmp1_;
			{
				gint _tmp2_;
				gdouble _tmp3_;
				gdouble position;
				gboolean _tmp4_ = FALSE;
				gdouble _tmp5_;
				guint _tmp6_;
				gboolean _tmp9_;
				gint _tmp26_;
				_tmp2_ = index;
				_tmp3_ = self->priv->scroll_location;
				position = _tmp2_ - _tmp3_;
				_tmp5_ = position;
				_tmp6_ = self->priv->n_above;
				if (_tmp5_ > ((gdouble) ((-1) * ((gint) (_tmp6_ + 1))))) {
					gdouble _tmp7_;
					guint _tmp8_;
					_tmp7_ = position;
					_tmp8_ = self->priv->n_below;
					_tmp4_ = _tmp7_ < ((gdouble) (_tmp8_ + 1));
				} else {
					_tmp4_ = FALSE;
				}
				_tmp9_ = _tmp4_;
				if (_tmp9_) {
					PromptBox* _tmp10_;
					gdouble _tmp11_;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					gdouble _tmp14_;
					gboolean _tmp18_;
					gboolean _tmp22_;
					gboolean is_hidden;
					gboolean _tmp23_;
					_tmp10_ = entry;
					_tmp11_ = position;
					greeter_list_move_entry (self, _tmp10_, _tmp11_);
					_tmp14_ = position;
					if (_tmp14_ == ((gdouble) 0)) {
						DashBox* _tmp15_;
						gboolean _tmp16_;
						gboolean _tmp17_;
						_tmp15_ = self->greeter_box;
						_tmp16_ = dash_box_get_has_base (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp13_ = _tmp17_;
					} else {
						_tmp13_ = FALSE;
					}
					_tmp18_ = _tmp13_;
					if (_tmp18_) {
						DashBox* _tmp19_;
						gdouble _tmp20_;
						gdouble _tmp21_;
						_tmp19_ = self->greeter_box;
						_tmp20_ = dash_box_get_base_alpha (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp12_ = _tmp21_ == 0.0;
					} else {
						_tmp12_ = FALSE;
					}
					_tmp22_ = _tmp12_;
					is_hidden = _tmp22_;
					_tmp23_ = is_hidden;
					if (!_tmp23_) {
						PromptBox* _tmp24_;
						_tmp24_ = entry;
						gtk_widget_show ((GtkWidget*) _tmp24_);
					}
				} else {
					PromptBox* _tmp25_;
					_tmp25_ = entry;
					gtk_widget_hide ((GtkWidget*) _tmp25_);
				}
				_tmp26_ = index;
				index = _tmp26_ + 1;
				_g_object_unref0 (entry);
			}
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void greeter_list_animate_scrolling (GreeterList* self, gdouble progress) {
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	guint h;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble distance;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	guint _tmp14_;
	gdouble _tmp17_;
	gboolean _tmp20_ = FALSE;
	gdouble _tmp21_;
	gboolean _tmp25_;
	gdouble _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->entries;
	_tmp1_ = g_list_length (_tmp0_);
	h = _tmp1_;
	_tmp2_ = self->priv->scroll_target_location;
	_tmp3_ = self->priv->scroll_start_location;
	distance = _tmp2_ - _tmp3_;
	_tmp4_ = self->priv->scroll_direction;
	_tmp5_ = distance;
	if ((_tmp4_ * _tmp5_) < ((gdouble) 0)) {
		gdouble _tmp6_;
		gdouble _tmp7_;
		guint _tmp8_;
		_tmp6_ = distance;
		_tmp7_ = self->priv->scroll_direction;
		_tmp8_ = h;
		distance = _tmp6_ + (_tmp7_ * _tmp8_);
	}
	_tmp9_ = distance;
	_tmp10_ = progress;
	distance = _tmp9_ * _tmp10_;
	_tmp11_ = self->priv->scroll_start_location;
	_tmp12_ = distance;
	self->priv->scroll_location = _tmp11_ + _tmp12_;
	_tmp13_ = self->priv->scroll_location;
	_tmp14_ = h;
	if (_tmp13_ > ((gdouble) _tmp14_)) {
		gdouble _tmp15_;
		guint _tmp16_;
		_tmp15_ = self->priv->scroll_location;
		_tmp16_ = h;
		self->priv->scroll_location = _tmp15_ - _tmp16_;
	}
	_tmp17_ = self->priv->scroll_location;
	if (_tmp17_ < ((gdouble) 0)) {
		gdouble _tmp18_;
		guint _tmp19_;
		_tmp18_ = self->priv->scroll_location;
		_tmp19_ = h;
		self->priv->scroll_location = _tmp18_ + _tmp19_;
	}
	greeter_list_move_names (self);
	_tmp21_ = progress;
	if (_tmp21_ >= 0.975) {
		DashBox* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp22_ = self->greeter_box;
		_tmp23_ = dash_box_get_has_base (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = !_tmp24_;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp25_ = _tmp20_;
	if (_tmp25_) {
		greeter_list_setup_prompt_box (self, TRUE);
		g_signal_emit_by_name (self, "entry-displayed-start");
	}
	_tmp26_ = progress;
	if (_tmp26_ >= 1.0) {
		greeter_list_finished_scrolling (self);
	}
}


static void greeter_list_finished_scrolling (GreeterList* self) {
	PromptBox* _tmp0_;
	g_return_if_fail (self != NULL);
	greeter_list_set_scrolling_entry (self, NULL);
	_tmp0_ = self->priv->_selected_entry;
	prompt_box_show_prompts (_tmp0_);
	greeter_list_focus_prompt (self);
	g_signal_emit_by_name (self, "entry-displayed-done");
	self->mode = GREETER_LIST_MODE_ENTRY;
}


void greeter_list_select_entry (GreeterList* self, PromptBox* entry, gdouble direction, gboolean do_scroll) {
	gboolean _tmp0_ = FALSE;
	gdouble _tmp2_;
	GList* _tmp3_;
	PromptBox* _tmp4_;
	gint _tmp5_ = 0;
	PromptBox* _tmp26_;
	PromptBox* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp0_) {
		PromptBox* _tmp1_;
		_tmp1_ = entry;
		greeter_list_set_selected_entry (self, _tmp1_);
		return;
	}
	_tmp2_ = self->priv->scroll_target_location;
	_tmp3_ = self->entries;
	_tmp4_ = entry;
	_tmp5_ = g_list_index (_tmp3_, _tmp4_);
	if (_tmp2_ != ((gdouble) _tmp5_)) {
		GList* _tmp6_;
		PromptBox* _tmp7_;
		gint _tmp8_ = 0;
		gint new_target;
		gdouble _tmp9_;
		gdouble new_direction;
		gdouble _tmp10_;
		gdouble new_start;
		gboolean _tmp11_ = FALSE;
		gdouble _tmp12_;
		gint _tmp13_;
		gboolean _tmp15_;
		PromptBox* _tmp22_;
		gint _tmp23_;
		gdouble _tmp24_;
		gdouble _tmp25_;
		_tmp6_ = self->entries;
		_tmp7_ = entry;
		_tmp8_ = g_list_index (_tmp6_, _tmp7_);
		new_target = _tmp8_;
		_tmp9_ = direction;
		new_direction = _tmp9_;
		_tmp10_ = self->priv->scroll_location;
		new_start = _tmp10_;
		_tmp12_ = self->priv->scroll_location;
		_tmp13_ = new_target;
		if (_tmp12_ != ((gdouble) _tmp13_)) {
			gboolean _tmp14_;
			_tmp14_ = do_scroll;
			_tmp11_ = _tmp14_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp15_ = _tmp11_;
		if (_tmp15_) {
			gdouble _tmp16_;
			gint _tmp17_;
			gdouble _tmp18_;
			gdouble new_distance;
			AnimateTimer* _tmp19_;
			gdouble _tmp20_;
			gint _tmp21_ = 0;
			_tmp16_ = new_direction;
			_tmp17_ = new_target;
			_tmp18_ = new_start;
			new_distance = _tmp16_ * (_tmp17_ - _tmp18_);
			_tmp19_ = self->priv->scroll_timer;
			_tmp20_ = new_distance;
			_tmp21_ = MIN ((gint) (100 * _tmp20_), 500);
			animate_timer_reset (_tmp19_, 250 + _tmp21_);
			self->mode = GREETER_LIST_MODE_SCROLLING;
		}
		_tmp22_ = self->priv->_selected_entry;
		greeter_list_set_scrolling_entry (self, _tmp22_);
		_tmp23_ = new_target;
		self->priv->scroll_target_location = (gdouble) _tmp23_;
		_tmp24_ = new_direction;
		self->priv->scroll_direction = _tmp24_;
		_tmp25_ = new_start;
		self->priv->scroll_start_location = _tmp25_;
	}
	_tmp26_ = self->priv->_selected_entry;
	_tmp27_ = entry;
	if (_tmp26_ != _tmp27_) {
		DashBox* _tmp28_;
		PromptBox* _tmp29_;
		PromptBox* _tmp31_;
		PromptBox* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		GreeterListMode _tmp35_;
		_tmp28_ = self->greeter_box;
		dash_box_set_base (_tmp28_, NULL);
		_tmp29_ = self->priv->_selected_entry;
		if (_tmp29_ != NULL) {
			PromptBox* _tmp30_;
			_tmp30_ = self->priv->_selected_entry;
			prompt_box_clear (_tmp30_);
		}
		_tmp31_ = entry;
		greeter_list_set_selected_entry (self, _tmp31_);
		_tmp32_ = self->priv->_selected_entry;
		_tmp33_ = prompt_box_get_id (_tmp32_);
		_tmp34_ = _tmp33_;
		g_signal_emit_by_name (self, "entry-selected", _tmp34_);
		_tmp35_ = self->mode;
		if (_tmp35_ == GREETER_LIST_MODE_ENTRY) {
			AnimateTimer* _tmp36_;
			greeter_list_setup_prompt_box (self, TRUE);
			_tmp36_ = self->priv->scroll_timer;
			animate_timer_reset (_tmp36_, 0);
		}
	}
}


static void greeter_list_real_setup_prompt_box (GreeterList* self, gboolean fade) {
	DashBox* _tmp0_;
	PromptBox* _tmp1_;
	PromptBox* _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->greeter_box;
	_tmp1_ = self->priv->_selected_entry;
	dash_box_set_base (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->_selected_entry;
	prompt_box_add_static_prompts (_tmp2_);
	_tmp3_ = fade;
	if (_tmp3_) {
		PromptBox* _tmp4_;
		_tmp4_ = self->priv->_selected_entry;
		prompt_box_fade_in_prompts (_tmp4_);
	} else {
		PromptBox* _tmp5_;
		_tmp5_ = self->priv->_selected_entry;
		prompt_box_show_prompts (_tmp5_);
	}
}


void greeter_list_setup_prompt_box (GreeterList* self, gboolean fade) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->setup_prompt_box (self, fade);
}


static void greeter_list_real_realize (GtkWidget* base) {
	GreeterList * self;
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	PromptBox* saved_entry;
	gboolean _tmp2_;
	self = (GreeterList*) base;
	GTK_WIDGET_CLASS (greeter_list_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FADABLE_BOX, FadableBox));
	_tmp0_ = self->priv->_selected_entry;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	saved_entry = _tmp1_;
	greeter_list_set_selected_entry (self, NULL);
	_tmp2_ = self->priv->_start_scrolling;
	greeter_list_select_entry (self, saved_entry, (gdouble) 1, _tmp2_);
	greeter_list_move_names (self);
	_g_object_unref0 (saved_entry);
}


static void greeter_list_allocate_greeter_box (GreeterList* self) {
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation child_allocation = {0};
	DashBox* _tmp1_;
	gint _tmp2_ = 0;
	DashBox* _tmp3_;
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	gint _tmp10_ = 0;
	GtkFixed* _tmp11_;
	DashBox* _tmp12_;
	GtkAllocation _tmp13_;
	gint _tmp14_;
	GtkAllocation _tmp15_;
	gint _tmp16_;
	DashBox* _tmp17_;
	GtkAllocation _tmp18_;
	GList* _tmp19_;
	g_return_if_fail (self != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	memset (&child_allocation, 0, sizeof (GtkAllocation));
	_tmp1_ = self->greeter_box;
	gtk_widget_get_preferred_width ((GtkWidget*) _tmp1_, NULL, &_tmp2_);
	child_allocation.width = _tmp2_;
	_tmp3_ = self->greeter_box;
	gtk_widget_get_preferred_height ((GtkWidget*) _tmp3_, NULL, &_tmp4_);
	child_allocation.height = _tmp4_;
	_tmp5_ = allocation;
	_tmp6_ = _tmp5_.x;
	_tmp7_ = greeter_list_get_greeter_box_x (self);
	child_allocation.x = _tmp6_ + _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.y;
	_tmp10_ = greeter_list_get_greeter_box_y (self);
	child_allocation.y = _tmp9_ + _tmp10_;
	_tmp11_ = self->priv->fixed;
	_tmp12_ = self->greeter_box;
	_tmp13_ = child_allocation;
	_tmp14_ = _tmp13_.x;
	_tmp15_ = child_allocation;
	_tmp16_ = _tmp15_.y;
	gtk_fixed_move (_tmp11_, (GtkWidget*) _tmp12_, _tmp14_, _tmp16_);
	_tmp17_ = self->greeter_box;
	_tmp18_ = child_allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp17_, &_tmp18_);
	_tmp19_ = self->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp19_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			PromptBox* _tmp20_;
			PromptBox* entry = NULL;
			_tmp20_ = _g_object_ref0 ((PromptBox*) entry_it->data);
			entry = _tmp20_;
			{
				PromptBox* _tmp21_;
				DashBox* _tmp22_;
				_tmp21_ = entry;
				_tmp22_ = self->greeter_box;
				prompt_box_set_zone (_tmp21_, (GtkWidget*) _tmp22_);
				_g_object_unref0 (entry);
			}
		}
	}
}


static void greeter_list_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	GreeterList * self;
	GtkAllocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (GreeterList*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (greeter_list_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FADABLE_BOX, FadableBox), &_tmp0_);
	_tmp1_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp1_) {
		return;
	}
	greeter_list_allocate_greeter_box (self);
	greeter_list_move_names (self);
}


static gboolean greeter_list_real_draw (GtkWidget* base, cairo_t* c) {
	GreeterList * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	GtkFixed* _tmp2_;
	DashBox* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	DashBox* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	FadeTracker* _tmp34_;
	FadeTracker* _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	self = (GreeterList*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	cairo_push_group (_tmp0_);
	_tmp1_ = c;
	cairo_save (_tmp1_);
	_tmp2_ = self->priv->fixed;
	_tmp3_ = self->greeter_box;
	_tmp4_ = c;
	gtk_container_propagate_draw ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_, _tmp4_);
	_tmp5_ = c;
	cairo_restore (_tmp5_);
	_tmp6_ = self->greeter_box;
	_tmp7_ = dash_box_get_base_alpha (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != 0.0) {
		cairo_t* _tmp9_;
		cairo_t* _tmp10_;
		cairo_t* _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		guint _tmp14_;
		guint _tmp15_;
		guint _tmp16_;
		gint _tmp17_ = 0;
		cairo_t* _tmp18_;
		GtkFixed* _tmp19_;
		GList* _tmp20_ = NULL;
		cairo_t* _tmp26_;
		cairo_t* _tmp27_;
		DashBox* _tmp28_;
		gdouble _tmp29_;
		gdouble _tmp30_;
		cairo_t* _tmp31_;
		_tmp9_ = c;
		cairo_save (_tmp9_);
		_tmp10_ = c;
		cairo_push_group (_tmp10_);
		_tmp11_ = c;
		_tmp12_ = greeter_list_get_greeter_box_x (self);
		_tmp13_ = greeter_list_get_greeter_box_y (self);
		_tmp14_ = self->priv->n_above;
		_tmp15_ = self->priv->n_above;
		_tmp16_ = self->priv->n_below;
		_tmp17_ = greeter_list_get_greeter_box_height_grids (self);
		cairo_rectangle (_tmp11_, (gdouble) _tmp12_, (gdouble) (_tmp13_ - (_tmp14_ * grid_size)), (gdouble) ((grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2)), (gdouble) (grid_size * ((_tmp15_ + _tmp16_) + _tmp17_)));
		_tmp18_ = c;
		cairo_clip (_tmp18_);
		_tmp19_ = self->priv->fixed;
		_tmp20_ = gtk_container_get_children ((GtkContainer*) _tmp19_);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp20_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* child = NULL;
				child = (GtkWidget*) child_it->data;
				{
					GtkWidget* _tmp21_;
					DashBox* _tmp22_;
					_tmp21_ = child;
					_tmp22_ = self->greeter_box;
					if (_tmp21_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_WIDGET, GtkWidget)) {
						GtkFixed* _tmp23_;
						GtkWidget* _tmp24_;
						cairo_t* _tmp25_;
						_tmp23_ = self->priv->fixed;
						_tmp24_ = child;
						_tmp25_ = c;
						gtk_container_propagate_draw ((GtkContainer*) _tmp23_, _tmp24_, _tmp25_);
					}
				}
			}
			_g_list_free0 (child_collection);
		}
		_tmp26_ = c;
		cairo_pop_group_to_source (_tmp26_);
		_tmp27_ = c;
		_tmp28_ = self->greeter_box;
		_tmp29_ = dash_box_get_base_alpha (_tmp28_);
		_tmp30_ = _tmp29_;
		cairo_paint_with_alpha (_tmp27_, _tmp30_);
		_tmp31_ = c;
		cairo_restore (_tmp31_);
	}
	_tmp32_ = c;
	cairo_pop_group_to_source (_tmp32_);
	_tmp33_ = c;
	_tmp34_ = fadable_get_fade_tracker ((Fadable*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = fade_tracker_get_alpha (_tmp35_);
	_tmp37_ = _tmp36_;
	cairo_paint_with_alpha (_tmp33_, _tmp37_);
	result = FALSE;
	return result;
}


static void greeter_list_entry_clicked_cb (GreeterList* self, PromptBox* entry) {
	GreeterListMode _tmp0_;
	GList* _tmp1_;
	PromptBox* _tmp2_;
	gint _tmp3_ = 0;
	gint index;
	gint _tmp4_;
	gdouble _tmp5_;
	gdouble position;
	gdouble _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->mode;
	if (_tmp0_ != GREETER_LIST_MODE_ENTRY) {
		return;
	}
	_tmp1_ = self->entries;
	_tmp2_ = entry;
	_tmp3_ = g_list_index (_tmp1_, _tmp2_);
	index = _tmp3_;
	_tmp4_ = index;
	_tmp5_ = self->priv->scroll_location;
	position = _tmp4_ - _tmp5_;
	_tmp6_ = position;
	if (_tmp6_ < 0.0) {
		PromptBox* _tmp7_;
		_tmp7_ = entry;
		greeter_list_select_entry (self, _tmp7_, -1.0, TRUE);
	} else {
		gdouble _tmp8_;
		_tmp8_ = position;
		if (_tmp8_ >= 1.0) {
			PromptBox* _tmp9_;
			_tmp9_ = entry;
			greeter_list_select_entry (self, _tmp9_, 1.0, TRUE);
		}
	}
}


static void _greeter_list_show_message_cb_unity_greeter_show_message (UnityGreeter* _sender, const gchar* text, LightDMMessageType type, gpointer self) {
	greeter_list_show_message_cb (self, text, type);
}


static void _greeter_list_show_prompt_cb_unity_greeter_show_prompt (UnityGreeter* _sender, const gchar* text, LightDMPromptType type, gpointer self) {
	greeter_list_show_prompt_cb (self, text, type);
}


static void _greeter_list_authentication_complete_cb_unity_greeter_authentication_complete (UnityGreeter* _sender, gpointer self) {
	greeter_list_authentication_complete_cb (self);
}


void greeter_list_connect_to_lightdm (GreeterList* self) {
	UnityGreeter* _tmp0_;
	UnityGreeter* _tmp1_;
	UnityGreeter* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_greeter_singleton;
	g_signal_connect_object (_tmp0_, "show-message", (GCallback) _greeter_list_show_message_cb_unity_greeter_show_message, self, 0);
	_tmp1_ = unity_greeter_singleton;
	g_signal_connect_object (_tmp1_, "show-prompt", (GCallback) _greeter_list_show_prompt_cb_unity_greeter_show_prompt, self, 0);
	_tmp2_ = unity_greeter_singleton;
	g_signal_connect_object (_tmp2_, "authentication-complete", (GCallback) _greeter_list_authentication_complete_cb_unity_greeter_authentication_complete, self, 0);
}


void greeter_list_show_message_cb (GreeterList* self, const gchar* text, LightDMMessageType type) {
	const gchar* _tmp0_;
	LightDMMessageType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = type;
	greeter_list_show_message (self, _tmp0_, _tmp1_ == LIGHTDM_MESSAGE_TYPE_ERROR);
}


static void greeter_list_real_show_prompt_cb (GreeterList* self, const gchar* text, LightDMPromptType type) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp6_;
	const gchar* _tmp13_;
	const gchar* _tmp15_;
	const gchar* _tmp17_;
	LightDMPromptType _tmp18_;
	DashEntry* _tmp19_ = NULL;
	DashEntry* _tmp20_;
	g_return_if_fail (text != NULL);
	_tmp1_ = greeter_list_get_selected_id (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "*other") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = greeter_list_get_manual_name (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		UnityGreeter* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = unity_greeter_singleton;
		_tmp8_ = _tmp7_->test_mode;
		if (_tmp8_) {
			const gchar* _tmp9_;
			_tmp9_ = self->test_username;
			greeter_list_set_manual_name (self, _tmp9_);
		} else {
			UnityGreeter* _tmp10_;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp10_ = unity_greeter_singleton;
			_tmp11_ = unity_greeter_authentication_user (_tmp10_);
			_tmp12_ = _tmp11_;
			greeter_list_set_manual_name (self, _tmp12_);
			_g_free0 (_tmp12_);
		}
	}
	self->prompted = TRUE;
	_tmp13_ = text;
	if (g_strcmp0 (_tmp13_, "Password: ") == 0) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = _ ("Password:");
		text = _tmp14_;
	}
	_tmp15_ = text;
	if (g_strcmp0 (_tmp15_, "login:") == 0) {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = _ ("Username:");
		text = _tmp16_;
	}
	_tmp17_ = text;
	_tmp18_ = type;
	_tmp19_ = greeter_list_add_prompt (self, _tmp17_, _tmp18_ == LIGHTDM_PROMPT_TYPE_SECRET);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp20_);
}


void greeter_list_show_prompt_cb (GreeterList* self, const gchar* text, LightDMPromptType type) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->show_prompt_cb (self, text, type);
}


static void _greeter_list_background_loaded_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	greeter_list_background_loaded_cb (self, pspec);
}


static void greeter_list_real_authentication_complete_cb (GreeterList* self) {
	const gchar* _tmp0_;
	PromptBox* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean is_authenticated = FALSE;
	UnityGreeter* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp9_;
	_tmp0_ = self->greeter_authenticating_user;
	_tmp1_ = self->priv->_selected_entry;
	_tmp2_ = prompt_box_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp0_, _tmp3_) != 0) {
		return;
	}
	_tmp4_ = unity_greeter_singleton;
	_tmp5_ = _tmp4_->test_mode;
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = self->test_is_authenticated;
		is_authenticated = _tmp6_;
	} else {
		UnityGreeter* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = unity_greeter_singleton;
		_tmp8_ = unity_greeter_is_authenticated (_tmp7_);
		is_authenticated = _tmp8_;
	}
	_tmp9_ = is_authenticated;
	if (_tmp9_) {
		gboolean _tmp10_;
		_tmp10_ = self->prompted;
		if (_tmp10_) {
			UnityGreeter* _tmp11_;
			gboolean _tmp12_;
			greeter_list_login_complete (self);
			_tmp11_ = unity_greeter_singleton;
			_tmp12_ = _tmp11_->test_mode;
			if (_tmp12_) {
				greeter_list_start_session (self);
			} else {
				Background* _tmp13_;
				gdouble _tmp14_;
				gdouble _tmp15_;
				_tmp13_ = self->priv->_background;
				_tmp14_ = background_get_alpha (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == 1.0) {
					greeter_list_start_session (self);
				} else {
					Background* _tmp16_;
					_tmp16_ = self->priv->_background;
					g_signal_connect_object ((GObject*) _tmp16_, "notify::alpha", (GCallback) _greeter_list_background_loaded_cb_g_object_notify, self, 0);
				}
			}
		} else {
			self->prompted = TRUE;
			greeter_list_show_authenticated (self, TRUE);
		}
	} else {
		gboolean _tmp17_;
		_tmp17_ = self->prompted;
		if (_tmp17_) {
			gboolean _tmp18_;
			PromptBox* _tmp20_;
			_tmp18_ = self->will_clear;
			if (_tmp18_) {
				const gchar* _tmp19_ = NULL;
				_tmp19_ = _ ("Invalid password, please try again");
				greeter_list_show_message (self, _tmp19_, TRUE);
			}
			_tmp20_ = self->priv->_selected_entry;
			prompt_box_reset_spinners (_tmp20_);
			greeter_list_start_authentication (self);
		} else {
			PromptBox* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = self->priv->_selected_entry;
			_tmp22_ = prompt_box_get_has_errors (_tmp21_);
			_tmp23_ = _tmp22_;
			if (!_tmp23_) {
				const gchar* _tmp24_ = NULL;
				_tmp24_ = _ ("Failed to authenticate");
				greeter_list_show_message (self, _tmp24_, TRUE);
			}
			greeter_list_show_authenticated (self, FALSE);
		}
	}
}


void greeter_list_authentication_complete_cb (GreeterList* self) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->authentication_complete_cb (self);
}


static void greeter_list_real_start_authentication (GreeterList* self) {
	gchar* _tmp0_ = NULL;
	UnityGreeter* _tmp1_;
	gboolean _tmp2_;
	self->prompted = FALSE;
	greeter_list_set_manual_name (self, NULL);
	self->will_clear = FALSE;
	_tmp0_ = greeter_list_get_selected_id (self);
	_g_free0 (self->greeter_authenticating_user);
	self->greeter_authenticating_user = _tmp0_;
	_tmp1_ = unity_greeter_singleton;
	_tmp2_ = _tmp1_->test_mode;
	if (_tmp2_) {
		greeter_list_test_start_authentication (self);
	} else {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = greeter_list_get_selected_id (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strcmp0 (_tmp4_, "*other") == 0;
		_g_free0 (_tmp4_);
		if (_tmp5_) {
			UnityGreeter* _tmp6_;
			_tmp6_ = unity_greeter_singleton;
			unity_greeter_authenticate (_tmp6_, NULL);
		} else {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = greeter_list_get_selected_id (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strcmp0 (_tmp8_, "*guest") == 0;
			_g_free0 (_tmp8_);
			if (_tmp9_) {
				UnityGreeter* _tmp10_;
				_tmp10_ = unity_greeter_singleton;
				unity_greeter_authenticate_as_guest (_tmp10_);
			} else {
				UnityGreeter* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp11_ = unity_greeter_singleton;
				_tmp12_ = greeter_list_get_selected_id (self);
				_tmp13_ = _tmp12_;
				unity_greeter_authenticate (_tmp11_, _tmp13_);
				_g_free0 (_tmp13_);
			}
		}
	}
}


void greeter_list_start_authentication (GreeterList* self) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->start_authentication (self);
}


static void greeter_list_background_loaded_cb (GreeterList* self, GParamSpec* pspec) {
	Background* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_background;
	_tmp1_ = background_get_alpha (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 1.0) {
		Background* _tmp3_;
		guint _tmp4_ = 0U;
		GQuark _tmp5_ = 0U;
		_tmp3_ = self->priv->_background;
		g_signal_parse_name ("notify::alpha", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _greeter_list_background_loaded_cb_g_object_notify, self);
		greeter_list_start_session (self);
	}
}


static void greeter_list_start_session (GreeterList* self) {
	Background* _tmp0_;
	Background* _tmp1_;
	UnityGreeter* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	Background* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background;
	background_set_draw_grid (_tmp0_, FALSE);
	_tmp1_ = self->priv->_background;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
	_tmp2_ = unity_greeter_singleton;
	_tmp3_ = greeter_list_get_lightdm_session (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_background;
	unity_greeter_start_session (_tmp2_, _tmp4_, _tmp5_);
	_g_free0 (_tmp4_);
}


void greeter_list_login_complete (GreeterList* self) {
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
	_tmp0_ = self->priv->_selected_entry;
	prompt_box_clear (_tmp0_);
	_tmp1_ = self->priv->_selected_entry;
	_tmp2_ = _ ("Logging in...");
	prompt_box_add_message (_tmp1_, _tmp2_, FALSE);
	greeter_list_redraw_greeter_box (self);
}


static gchar* greeter_list_real_get_lightdm_session (GreeterList* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("ubuntu");
	result = _tmp0_;
	return result;
}


gchar* greeter_list_get_lightdm_session (GreeterList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GREETER_LIST_GET_CLASS (self)->get_lightdm_session (self);
}


static void greeter_list_real_test_start_authentication (GreeterList* self) {
}


void greeter_list_test_start_authentication (GreeterList* self) {
	g_return_if_fail (self != NULL);
	GREETER_LIST_GET_CLASS (self)->test_start_authentication (self);
}


Background* greeter_list_get_background (GreeterList* self) {
	Background* result;
	Background* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background;
	result = _tmp0_;
	return result;
}


static void greeter_list_set_background (GreeterList* self, Background* value) {
	Background* _tmp0_;
	Background* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_background);
	self->priv->_background = _tmp1_;
	g_object_notify ((GObject *) self, "background");
}


MenuBar* greeter_list_get_menubar (GreeterList* self) {
	MenuBar* result;
	MenuBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_menubar;
	result = _tmp0_;
	return result;
}


static void greeter_list_set_menubar (GreeterList* self, MenuBar* value) {
	MenuBar* _tmp0_;
	MenuBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_menubar);
	self->priv->_menubar = _tmp1_;
	g_object_notify ((GObject *) self, "menubar");
}


PromptBox* greeter_list_get_selected_entry (GreeterList* self) {
	PromptBox* result;
	PromptBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_entry;
	result = _tmp0_;
	return result;
}


static void greeter_list_set_selected_entry (GreeterList* self, PromptBox* value) {
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_selected_entry);
	self->priv->_selected_entry = _tmp1_;
	g_object_notify ((GObject *) self, "selected-entry");
}


gboolean greeter_list_get_start_scrolling (GreeterList* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_start_scrolling;
	result = _tmp0_;
	return result;
}


void greeter_list_set_start_scrolling (GreeterList* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_scrolling = _tmp0_;
	g_object_notify ((GObject *) self, "start-scrolling");
}


gboolean greeter_list_get_always_show_manual (GreeterList* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->_always_show_manual;
	result = _tmp0_;
	return result;
}


void greeter_list_set_always_show_manual (GreeterList* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->_always_show_manual = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_) {
		greeter_list_add_manual_entry (self);
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = greeter_list_have_entries (self);
		if (_tmp2_) {
			greeter_list_remove_entry (self, "*other");
		}
	}
	g_object_notify ((GObject *) self, "always-show-manual");
}


static gint greeter_list_get_box_x (GreeterList* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}


static gint greeter_list_get_box_y (GreeterList* self) {
	gint result;
	gint _tmp0_ = 0;
	gint row;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	row = (MAIN_WINDOW_MENUBAR_HEIGHT + _tmp0_) / grid_size;
	_tmp1_ = row;
	row = _tmp1_ - GREETER_LIST_DEFAULT_BOX_HEIGHT;
	_tmp2_ = row;
	row = _tmp2_ / 2;
	_tmp3_ = row;
	result = (_tmp3_ * grid_size) - MAIN_WINDOW_MENUBAR_HEIGHT;
	return result;
}


const gchar* greeter_list_get_manual_name (GreeterList* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manual_name;
	result = _tmp0_;
	return result;
}


void greeter_list_set_manual_name (GreeterList* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	PromptBox* _tmp2_ = NULL;
	PromptBox* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_manual_name);
	self->priv->_manual_name = _tmp1_;
	_tmp2_ = greeter_list_find_entry (self, "*other");
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		greeter_list_add_manual_entry (self);
	}
	g_object_notify ((GObject *) self, "manual-name");
}


static PromptBox* greeter_list_get_scrolling_entry (GreeterList* self) {
	PromptBox* result;
	PromptBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scrolling_entry;
	result = _tmp0_;
	return result;
}


static void greeter_list_set_scrolling_entry (GreeterList* self, PromptBox* value) {
	PromptBox* _tmp0_;
	PromptBox* _tmp2_;
	PromptBox* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_scrolling_entry;
	if (_tmp0_ != NULL) {
		PromptBox* _tmp1_;
		_tmp1_ = self->priv->_scrolling_entry;
		prompt_box_set_options_image (_tmp1_, NULL);
	}
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_scrolling_entry);
	self->priv->_scrolling_entry = _tmp3_;
}


static void _greeter_list___lambda34_ (GreeterList* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __greeter_list___lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_greeter_list___lambda34_ (self);
}


static void _greeter_list_greeter_box_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	greeter_list_greeter_box_size_allocate_cb (self, allocation);
}


static gdouble _animate_timer_ease_out_quint_animate_timer_easing_func (gdouble x, gpointer self) {
	gdouble result;
	result = animate_timer_ease_out_quint (x);
	return result;
}


static void _greeter_list_animate_scrolling_animate_timer_animate (AnimateTimer* _sender, gdouble progress, gpointer self) {
	greeter_list_animate_scrolling (self, progress);
}


static GObject * greeter_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GreeterList * self;
	GtkFixed* _tmp0_;
	GtkFixed* _tmp1_;
	GtkFixed* _tmp2_;
	Background* _tmp3_;
	DashBox* _tmp4_;
	DashBox* _tmp5_;
	DashBox* _tmp6_;
	DashBox* _tmp7_;
	DashBox* _tmp8_;
	AnimateTimer* _tmp9_;
	AnimateTimer* _tmp10_;
	parent_class = G_OBJECT_CLASS (greeter_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GREETER_LIST, GreeterList);
	g_object_set ((GtkWidget*) self, "can-focus", FALSE, NULL);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	_tmp0_ = (GtkFixed*) gtk_fixed_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->fixed);
	self->priv->fixed = _tmp0_;
	_tmp1_ = self->priv->fixed;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->fixed;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->_background;
	_tmp4_ = dash_box_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->greeter_box);
	self->greeter_box = _tmp4_;
	_tmp5_ = self->greeter_box;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::base-alpha", (GCallback) __greeter_list___lambda34__g_object_notify, self, 0);
	_tmp6_ = self->greeter_box;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = self->greeter_box;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "size-allocate", (GCallback) _greeter_list_greeter_box_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp8_ = self->greeter_box;
	greeter_list_add_with_class (self, (GtkWidget*) _tmp8_);
	_tmp9_ = animate_timer_new (_animate_timer_ease_out_quint_animate_timer_easing_func, NULL, ANIMATE_TIMER_FAST);
	_g_object_unref0 (self->priv->scroll_timer);
	self->priv->scroll_timer = _tmp9_;
	_tmp10_ = self->priv->scroll_timer;
	g_signal_connect_object (_tmp10_, "animate", (GCallback) _greeter_list_animate_scrolling_animate_timer_animate, self, 0);
	return obj;
}


static void greeter_list_class_init (GreeterListClass * klass) {
	greeter_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GreeterListPrivate));
	GREETER_LIST_CLASS (klass)->get_selected_id = greeter_list_real_get_selected_id;
	GTK_WIDGET_CLASS (klass)->get_preferred_width = greeter_list_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = greeter_list_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->grab_focus = greeter_list_real_grab_focus;
	GREETER_LIST_CLASS (klass)->focus_prompt = greeter_list_real_focus_prompt;
	GREETER_LIST_CLASS (klass)->show_authenticated = greeter_list_real_show_authenticated;
	GREETER_LIST_CLASS (klass)->insert_entry = greeter_list_real_insert_entry;
	GREETER_LIST_CLASS (klass)->add_manual_entry = greeter_list_real_add_manual_entry;
	GREETER_LIST_CLASS (klass)->get_position_y = greeter_list_real_get_position_y;
	GREETER_LIST_CLASS (klass)->setup_prompt_box = greeter_list_real_setup_prompt_box;
	GTK_WIDGET_CLASS (klass)->realize = greeter_list_real_realize;
	GTK_WIDGET_CLASS (klass)->size_allocate = greeter_list_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->draw = greeter_list_real_draw;
	GREETER_LIST_CLASS (klass)->show_prompt_cb = greeter_list_real_show_prompt_cb;
	GREETER_LIST_CLASS (klass)->authentication_complete_cb = greeter_list_real_authentication_complete_cb;
	GREETER_LIST_CLASS (klass)->start_authentication = greeter_list_real_start_authentication;
	GREETER_LIST_CLASS (klass)->get_lightdm_session = greeter_list_real_get_lightdm_session;
	GREETER_LIST_CLASS (klass)->test_start_authentication = greeter_list_real_test_start_authentication;
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_BACKGROUND, g_param_spec_object ("background", "background", "background", TYPE_BACKGROUND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_MENUBAR, g_param_spec_object ("menubar", "menubar", "menubar", TYPE_MENU_BAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_SELECTED_ENTRY, g_param_spec_object ("selected-entry", "selected-entry", "selected-entry", TYPE_PROMPT_BOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_START_SCROLLING, g_param_spec_boolean ("start-scrolling", "start-scrolling", "start-scrolling", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_ALWAYS_SHOW_MANUAL, g_param_spec_boolean ("always-show-manual", "always-show-manual", "always-show-manual", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_MANUAL_NAME, g_param_spec_string ("manual-name", "manual-name", "manual-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("entry_selected", TYPE_GREETER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("entry_displayed_start", TYPE_GREETER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("entry_displayed_done", TYPE_GREETER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void greeter_list_instance_init (GreeterList * self) {
	self->priv = GREETER_LIST_GET_PRIVATE (self);
	self->priv->_selected_entry = NULL;
	self->priv->_start_scrolling = TRUE;
	self->_always_show_manual = FALSE;
	self->entries = NULL;
	self->priv->cached_box_height = -1;
	self->mode = GREETER_LIST_MODE_ENTRY;
	self->priv->n_above = (guint) 4;
	self->priv->n_below = (guint) 4;
	self->priv->_manual_name = NULL;
	self->priv->_scrolling_entry = NULL;
	self->will_clear = FALSE;
	self->prompted = FALSE;
	self->test_username = NULL;
	self->test_is_authenticated = FALSE;
}


static void greeter_list_finalize (GObject* obj) {
	GreeterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GREETER_LIST, GreeterList);
	_g_object_unref0 (self->priv->_background);
	_g_object_unref0 (self->priv->_menubar);
	_g_object_unref0 (self->priv->_selected_entry);
	_g_free0 (self->greeter_authenticating_user);
	__g_list_free__g_object_unref0_0 (self->entries);
	_g_object_unref0 (self->priv->scroll_timer);
	_g_object_unref0 (self->priv->fixed);
	_g_object_unref0 (self->greeter_box);
	_g_free0 (self->priv->_manual_name);
	_g_object_unref0 (self->priv->_scrolling_entry);
	_g_free0 (self->test_username);
	G_OBJECT_CLASS (greeter_list_parent_class)->finalize (obj);
}


GType greeter_list_get_type (void) {
	static volatile gsize greeter_list_type_id__volatile = 0;
	if (g_once_init_enter (&greeter_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GreeterListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterList), 0, (GInstanceInitFunc) greeter_list_instance_init, NULL };
		GType greeter_list_type_id;
		greeter_list_type_id = g_type_register_static (TYPE_FADABLE_BOX, "GreeterList", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&greeter_list_type_id__volatile, greeter_list_type_id);
	}
	return greeter_list_type_id__volatile;
}


static void _vala_greeter_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GreeterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GREETER_LIST, GreeterList);
	switch (property_id) {
		case GREETER_LIST_BACKGROUND:
		g_value_set_object (value, greeter_list_get_background (self));
		break;
		case GREETER_LIST_MENUBAR:
		g_value_set_object (value, greeter_list_get_menubar (self));
		break;
		case GREETER_LIST_SELECTED_ENTRY:
		g_value_set_object (value, greeter_list_get_selected_entry (self));
		break;
		case GREETER_LIST_START_SCROLLING:
		g_value_set_boolean (value, greeter_list_get_start_scrolling (self));
		break;
		case GREETER_LIST_ALWAYS_SHOW_MANUAL:
		g_value_set_boolean (value, greeter_list_get_always_show_manual (self));
		break;
		case GREETER_LIST_MANUAL_NAME:
		g_value_set_string (value, greeter_list_get_manual_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_greeter_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GreeterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GREETER_LIST, GreeterList);
	switch (property_id) {
		case GREETER_LIST_BACKGROUND:
		greeter_list_set_background (self, g_value_get_object (value));
		break;
		case GREETER_LIST_MENUBAR:
		greeter_list_set_menubar (self, g_value_get_object (value));
		break;
		case GREETER_LIST_SELECTED_ENTRY:
		greeter_list_set_selected_entry (self, g_value_get_object (value));
		break;
		case GREETER_LIST_START_SCROLLING:
		greeter_list_set_start_scrolling (self, g_value_get_boolean (value));
		break;
		case GREETER_LIST_ALWAYS_SHOW_MANUAL:
		greeter_list_set_always_show_manual (self, g_value_get_boolean (value));
		break;
		case GREETER_LIST_MANUAL_NAME:
		greeter_list_set_manual_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



