/* animate-timer.c generated by valac 0.18.1, the Vala compiler
 * generated from animate-timer.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>


#define TYPE_ANIMATE_TIMER (animate_timer_get_type ())
#define ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATE_TIMER, AnimateTimer))
#define ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATE_TIMER, AnimateTimerClass))
#define IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATE_TIMER))
#define IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATE_TIMER))
#define ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATE_TIMER, AnimateTimerClass))

typedef struct _AnimateTimer AnimateTimer;
typedef struct _AnimateTimerClass AnimateTimerClass;
typedef struct _AnimateTimerPrivate AnimateTimerPrivate;

struct _AnimateTimer {
	GObject parent_instance;
	AnimateTimerPrivate * priv;
};

struct _AnimateTimerClass {
	GObjectClass parent_class;
};

typedef gdouble (*AnimateTimerEasingFunc) (gdouble x, void* user_data);
struct _AnimateTimerPrivate {
	AnimateTimerEasingFunc _easing_func;
	gpointer _easing_func_target;
	gint _speed;
	gdouble _progress;
	guint timeout;
	GTimeSpan start_time;
	GTimeSpan length;
	GTimeSpan extra_time;
	gdouble extra_progress;
};


static gpointer animate_timer_parent_class = NULL;

GType animate_timer_get_type (void) G_GNUC_CONST;
#define ANIMATE_TIMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ANIMATE_TIMER, AnimateTimerPrivate))
enum  {
	ANIMATE_TIMER_DUMMY_PROPERTY,
	ANIMATE_TIMER_SPEED,
	ANIMATE_TIMER_IS_RUNNING,
	ANIMATE_TIMER_PROGRESS
};
#define ANIMATE_TIMER_INSTANT 150
#define ANIMATE_TIMER_FAST 250
#define ANIMATE_TIMER_NORMAL 500
#define ANIMATE_TIMER_SLOW 1000
AnimateTimer* animate_timer_new (AnimateTimerEasingFunc func, void* func_target, gint speed);
AnimateTimer* animate_timer_construct (GType object_type, AnimateTimerEasingFunc func, void* func_target, gint speed);
static void animate_timer_set_easing_func (AnimateTimer* self, AnimateTimerEasingFunc value, gpointer value_target);
void animate_timer_reset (AnimateTimer* self, gint temp_speed);
void animate_timer_stop (AnimateTimer* self);
static gboolean animate_timer_animate_cb (AnimateTimer* self);
static gboolean _animate_timer_animate_cb_gsource_func (gpointer self);
static void animate_timer_set_progress (AnimateTimer* self, gdouble value);
gint animate_timer_get_speed (AnimateTimer* self);
static gdouble animate_timer_calculate_progress (AnimateTimer* self, GTimeSpan time);
gdouble animate_timer_get_progress (AnimateTimer* self);
static gdouble animate_timer_normalize_time (AnimateTimer* self, GTimeSpan now);
AnimateTimerEasingFunc animate_timer_get_easing_func (AnimateTimer* self, gpointer* result_target);
gdouble animate_timer_ease_in_out (gdouble x);
gdouble animate_timer_ease_out_quint (gdouble x);
void animate_timer_set_speed (AnimateTimer* self, gint value);
gboolean animate_timer_get_is_running (AnimateTimer* self);
static void animate_timer_finalize (GObject* obj);
static void _vala_animate_timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_animate_timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


AnimateTimer* animate_timer_construct (GType object_type, AnimateTimerEasingFunc func, void* func_target, gint speed) {
	AnimateTimer * self = NULL;
	gint _tmp0_;
	AnimateTimerEasingFunc _tmp1_;
	void* _tmp1__target;
	_tmp0_ = speed;
	self = (AnimateTimer*) g_object_new (object_type, "speed", _tmp0_, NULL);
	_tmp1_ = func;
	_tmp1__target = func_target;
	animate_timer_set_easing_func (self, _tmp1_, _tmp1__target);
	return self;
}


AnimateTimer* animate_timer_new (AnimateTimerEasingFunc func, void* func_target, gint speed) {
	return animate_timer_construct (TYPE_ANIMATE_TIMER, func, func_target, speed);
}


static gboolean _animate_timer_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = animate_timer_animate_cb (self);
	return result;
}


void animate_timer_reset (AnimateTimer* self, gint temp_speed) {
	guint _tmp0_ = 0U;
	gint _tmp1_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	animate_timer_stop (self);
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 16, _animate_timer_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->timeout = _tmp0_;
	animate_timer_set_progress (self, (gdouble) 0);
	self->priv->start_time = (GTimeSpan) 0;
	self->priv->extra_time = (GTimeSpan) 0;
	self->priv->extra_progress = (gdouble) 0;
	_tmp1_ = temp_speed;
	if (_tmp1_ == (-1)) {
		gint _tmp2_;
		_tmp2_ = self->priv->_speed;
		temp_speed = _tmp2_;
	}
	_tmp3_ = temp_speed;
	self->priv->length = _tmp3_ * G_TIME_SPAN_MILLISECOND;
}


void animate_timer_stop (AnimateTimer* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->timeout;
		g_source_remove (_tmp1_);
	}
	self->priv->timeout = (guint) 0;
}


static gboolean animate_timer_animate_cb (AnimateTimer* self) {
	gboolean result = FALSE;
	GTimeSpan _tmp0_;
	gint64 _tmp2_ = 0LL;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->start_time;
	if (_tmp0_ == ((GTimeSpan) 0)) {
		gint64 _tmp1_ = 0LL;
		_tmp1_ = g_get_monotonic_time ();
		self->priv->start_time = (GTimeSpan) _tmp1_;
	}
	_tmp2_ = g_get_monotonic_time ();
	_tmp3_ = animate_timer_calculate_progress (self, (GTimeSpan) _tmp2_);
	animate_timer_set_progress (self, _tmp3_);
	_tmp4_ = self->priv->_progress;
	g_signal_emit_by_name (self, "animate", _tmp4_);
	_tmp5_ = self->priv->_progress;
	if (_tmp5_ >= 1.0) {
		self->priv->timeout = (guint) 0;
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}


static gdouble animate_timer_normalize_time (AnimateTimer* self, GTimeSpan now) {
	gdouble result = 0.0;
	GTimeSpan _tmp0_;
	GTimeSpan _tmp1_;
	GTimeSpan _tmp2_;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = now;
	_tmp1_ = self->priv->start_time;
	_tmp2_ = self->priv->length;
	_tmp3_ = CLAMP (((gdouble) (_tmp0_ - _tmp1_)) / _tmp2_, 0.0, 1.0);
	result = _tmp3_;
	return result;
}


static gdouble animate_timer_calculate_progress (AnimateTimer* self, GTimeSpan time) {
	gdouble result = 0.0;
	GTimeSpan _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble x;
	AnimateTimerEasingFunc _tmp2_;
	void* _tmp2__target;
	AnimateTimerEasingFunc _tmp3_;
	void* _tmp3__target;
	gdouble _tmp4_ = 0.0;
	gdouble y;
	gdouble _tmp5_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = time;
	_tmp1_ = animate_timer_normalize_time (self, _tmp0_);
	x = _tmp1_;
	_tmp2_ = animate_timer_get_easing_func (self, &_tmp2__target);
	_tmp3_ = _tmp2_;
	_tmp3__target = _tmp2__target;
	_tmp4_ = _tmp3_ (x, _tmp3__target);
	y = _tmp4_;
	_tmp5_ = CLAMP (y, 0.0, 1.0);
	result = _tmp5_;
	return result;
}


gdouble animate_timer_ease_in_out (gdouble x) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = x;
	_tmp1_ = cos (G_PI * _tmp0_);
	result = (1 - _tmp1_) / 2;
	return result;
}


gdouble animate_timer_ease_out_quint (gdouble x) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = x;
	_tmp1_ = pow (_tmp0_ - 1, (gdouble) 5);
	result = _tmp1_ + 1;
	return result;
}


AnimateTimerEasingFunc animate_timer_get_easing_func (AnimateTimer* self, gpointer* result_target) {
	AnimateTimerEasingFunc result;
	AnimateTimerEasingFunc _tmp0_;
	void* _tmp0__target;
	AnimateTimerEasingFunc _tmp1_;
	void* _tmp1__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_easing_func;
	_tmp0__target = self->priv->_easing_func_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


static void animate_timer_set_easing_func (AnimateTimer* self, AnimateTimerEasingFunc value, gpointer value_target) {
	AnimateTimerEasingFunc _tmp0_;
	void* _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__target = value_target;
	self->priv->_easing_func = _tmp0_;
	self->priv->_easing_func_target = _tmp0__target;
}


gint animate_timer_get_speed (AnimateTimer* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_speed;
	result = _tmp0_;
	return result;
}


void animate_timer_set_speed (AnimateTimer* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_speed = _tmp0_;
	g_object_notify ((GObject *) self, "speed");
}


gboolean animate_timer_get_is_running (AnimateTimer* self) {
	gboolean result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->timeout;
	result = _tmp0_ != ((guint) 0);
	return result;
}


gdouble animate_timer_get_progress (AnimateTimer* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_progress;
	result = _tmp0_;
	return result;
}


static void animate_timer_set_progress (AnimateTimer* self, gdouble value) {
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_progress = _tmp0_;
	g_object_notify ((GObject *) self, "progress");
}


static void animate_timer_class_init (AnimateTimerClass * klass) {
	animate_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AnimateTimerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_animate_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_animate_timer_set_property;
	G_OBJECT_CLASS (klass)->finalize = animate_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATE_TIMER_SPEED, g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATE_TIMER_IS_RUNNING, g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATE_TIMER_PROGRESS, g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("animate", TYPE_ANIMATE_TIMER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}


static void animate_timer_instance_init (AnimateTimer * self) {
	self->priv = ANIMATE_TIMER_GET_PRIVATE (self);
	self->priv->timeout = (guint) 0;
	self->priv->start_time = (GTimeSpan) 0;
	self->priv->length = (GTimeSpan) 0;
	self->priv->extra_time = (GTimeSpan) 0;
	self->priv->extra_progress = 0.0;
}


static void animate_timer_finalize (GObject* obj) {
	AnimateTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATE_TIMER, AnimateTimer);
	G_OBJECT_CLASS (animate_timer_parent_class)->finalize (obj);
}


GType animate_timer_get_type (void) {
	static volatile gsize animate_timer_type_id__volatile = 0;
	if (g_once_init_enter (&animate_timer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AnimateTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animate_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnimateTimer), 0, (GInstanceInitFunc) animate_timer_instance_init, NULL };
		GType animate_timer_type_id;
		animate_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "AnimateTimer", &g_define_type_info, 0);
		g_once_init_leave (&animate_timer_type_id__volatile, animate_timer_type_id);
	}
	return animate_timer_type_id__volatile;
}


static void _vala_animate_timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AnimateTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATE_TIMER, AnimateTimer);
	switch (property_id) {
		case ANIMATE_TIMER_SPEED:
		g_value_set_int (value, animate_timer_get_speed (self));
		break;
		case ANIMATE_TIMER_IS_RUNNING:
		g_value_set_boolean (value, animate_timer_get_is_running (self));
		break;
		case ANIMATE_TIMER_PROGRESS:
		g_value_set_double (value, animate_timer_get_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_animate_timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AnimateTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATE_TIMER, AnimateTimer);
	switch (property_id) {
		case ANIMATE_TIMER_SPEED:
		animate_timer_set_speed (self, g_value_get_int (value));
		break;
		case ANIMATE_TIMER_PROGRESS:
		animate_timer_set_progress (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



