/* remote-login-service.c generated by valac 0.16.1, the Vala compiler
 * generated from remote-login-service.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_REMOTE_SERVER_FIELD (remote_server_field_get_type ())
typedef struct _RemoteServerField RemoteServerField;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_REMOTE_SERVER_APPLICATION (remote_server_application_get_type ())
typedef struct _RemoteServerApplication RemoteServerApplication;

#define TYPE_REMOTE_SERVER (remote_server_get_type ())
typedef struct _RemoteServer RemoteServer;

#define TYPE_REMOTE_LOGIN_SERVICE (remote_login_service_get_type ())
#define REMOTE_LOGIN_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REMOTE_LOGIN_SERVICE, RemoteLoginService))
#define IS_REMOTE_LOGIN_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REMOTE_LOGIN_SERVICE))
#define REMOTE_LOGIN_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_REMOTE_LOGIN_SERVICE, RemoteLoginServiceIface))

typedef struct _RemoteLoginService RemoteLoginService;
typedef struct _RemoteLoginServiceIface RemoteLoginServiceIface;

#define TYPE_REMOTE_LOGIN_SERVICE_PROXY (remote_login_service_proxy_get_type ())
typedef GDBusProxy RemoteLoginServiceProxy;
typedef GDBusProxyClass RemoteLoginServiceProxyClass;

struct _RemoteServerField {
	gchar* type;
	gboolean required;
	GVariant* default_value;
	GHashTable* properties;
};

struct _RemoteServerApplication {
	gchar* application_id;
	gint pin_position;
};

struct _RemoteServer {
	gchar* type;
	gchar* name;
	gchar* url;
	gboolean last_used_server;
	RemoteServerField* fields;
	gint fields_length1;
	RemoteServerApplication* applications;
	gint applications_length1;
};

struct _RemoteLoginServiceIface {
	GTypeInterface parent_iface;
	void (*get_servers) (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_servers_finish) (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error);
	void (*get_servers_for_login) (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_servers_for_login_finish) (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error);
	void (*get_cached_domains_for_server) (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_cached_domains_for_server_finish) (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error);
	void (*set_last_used_server) (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_last_used_server_finish) (RemoteLoginService* self, GAsyncResult* _res_, GError** error);
};



GType remote_server_field_get_type (void) G_GNUC_CONST;
RemoteServerField* remote_server_field_dup (const RemoteServerField* self);
void remote_server_field_free (RemoteServerField* self);
void remote_server_field_copy (const RemoteServerField* self, RemoteServerField* dest);
void remote_server_field_destroy (RemoteServerField* self);
GType remote_server_application_get_type (void) G_GNUC_CONST;
RemoteServerApplication* remote_server_application_dup (const RemoteServerApplication* self);
void remote_server_application_free (RemoteServerApplication* self);
void remote_server_application_copy (const RemoteServerApplication* self, RemoteServerApplication* dest);
void remote_server_application_destroy (RemoteServerApplication* self);
GType remote_server_get_type (void) G_GNUC_CONST;
RemoteServer* remote_server_dup (const RemoteServer* self);
void remote_server_free (RemoteServer* self);
void remote_server_copy (const RemoteServer* self, RemoteServer* dest);
void remote_server_destroy (RemoteServer* self);
static void _vala_RemoteServerField_array_free (RemoteServerField* array, gint array_length);
static void _vala_RemoteServerApplication_array_free (RemoteServerApplication* array, gint array_length);
static RemoteServerField* _vala_array_dup4 (RemoteServerField* self, int length);
static RemoteServerApplication* _vala_array_dup5 (RemoteServerApplication* self, int length);
GType remote_login_service_proxy_get_type (void) G_GNUC_CONST;
guint remote_login_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType remote_login_service_get_type (void) G_GNUC_CONST;
void remote_login_service_get_servers (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void remote_login_service_get_servers_finish (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error);
void remote_login_service_get_servers_for_login (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_);
void remote_login_service_get_servers_for_login_finish (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error);
void remote_login_service_get_cached_domains_for_server (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
void remote_login_service_get_cached_domains_for_server_finish (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error);
void remote_login_service_set_last_used_server (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_);
void remote_login_service_set_last_used_server_finish (RemoteLoginService* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void remote_login_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_RemoteServer_array_free (RemoteServer* array, gint array_length);
static void _dbus_handle_remote_login_service_servers_updated (RemoteLoginService* self, GVariant* parameters);
static void _dbus_handle_remote_login_service_login_servers_updated (RemoteLoginService* self, GVariant* parameters);
static void _dbus_handle_remote_login_service_login_changed (RemoteLoginService* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void remote_login_service_proxy_get_servers_async (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void remote_login_service_proxy_get_servers_finish (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error);
static void remote_login_service_proxy_get_servers_for_login_async (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void remote_login_service_proxy_get_servers_for_login_finish (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error);
static void remote_login_service_proxy_get_cached_domains_for_server_async (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void remote_login_service_proxy_get_cached_domains_for_server_finish (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error);
static void remote_login_service_proxy_set_last_used_server_async (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void remote_login_service_proxy_set_last_used_server_finish (RemoteLoginService* self, GAsyncResult* _res_, GError** error);
static void remote_login_service_proxy_remote_login_service_interface_init (RemoteLoginServiceIface* iface);
static void _dbus_remote_login_service_get_servers (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_remote_login_service_get_servers_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_remote_login_service_get_servers_for_login (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_remote_login_service_get_servers_for_login_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_remote_login_service_get_cached_domains_for_server (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_remote_login_service_get_cached_domains_for_server_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_remote_login_service_set_last_used_server (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_remote_login_service_set_last_used_server_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void remote_login_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* remote_login_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean remote_login_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_remote_login_service_servers_updated (GObject* _sender, RemoteServer* serverList, int serverList_length1, gpointer* _data);
static void _dbus_remote_login_service_login_servers_updated (GObject* _sender, const gchar* url, const gchar* emailAddress, const gchar* dataType, RemoteServer* serverList, int serverList_length1, gpointer* _data);
static void _dbus_remote_login_service_login_changed (GObject* _sender, const gchar* url, const gchar* emailAddress, gpointer* _data);
static void _remote_login_service_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_serverList = {-1, "serverList", "a(sssba(sbva{sv})a(si))"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_servers_in[] = {NULL};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_servers_out[] = {&_remote_login_service_dbus_arg_info_get_servers_serverList, NULL};
static const GDBusMethodInfo _remote_login_service_dbus_method_info_get_servers = {-1, "GetServers", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_servers_in), (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_servers_out)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_url = {-1, "url", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_emailAddress = {-1, "emailAddress", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_password = {-1, "password", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_allowCache = {-1, "allowCache", "b"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_loginSuccess = {-1, "loginSuccess", "b"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_dataType = {-1, "dataType", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_serverList = {-1, "serverList", "a(sssba(sbva{sv})a(si))"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_servers_for_login_in[] = {&_remote_login_service_dbus_arg_info_get_servers_for_login_url, &_remote_login_service_dbus_arg_info_get_servers_for_login_emailAddress, &_remote_login_service_dbus_arg_info_get_servers_for_login_password, &_remote_login_service_dbus_arg_info_get_servers_for_login_allowCache, NULL};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_servers_for_login_out[] = {&_remote_login_service_dbus_arg_info_get_servers_for_login_loginSuccess, &_remote_login_service_dbus_arg_info_get_servers_for_login_dataType, &_remote_login_service_dbus_arg_info_get_servers_for_login_serverList, NULL};
static const GDBusMethodInfo _remote_login_service_dbus_method_info_get_servers_for_login = {-1, "GetServersForLogin", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_servers_for_login_in), (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_servers_for_login_out)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_cached_domains_for_server_url = {-1, "url", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_cached_domains_for_server_domains = {-1, "domains", "as"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_cached_domains_for_server_in[] = {&_remote_login_service_dbus_arg_info_get_cached_domains_for_server_url, NULL};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_cached_domains_for_server_out[] = {&_remote_login_service_dbus_arg_info_get_cached_domains_for_server_domains, NULL};
static const GDBusMethodInfo _remote_login_service_dbus_method_info_get_cached_domains_for_server = {-1, "GetCachedDomainsForServer", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_cached_domains_for_server_in), (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_cached_domains_for_server_out)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_set_last_used_server_uccsUrl = {-1, "uccsUrl", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_set_last_used_server_serverUrl = {-1, "serverUrl", "s"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_set_last_used_server_in[] = {&_remote_login_service_dbus_arg_info_set_last_used_server_uccsUrl, &_remote_login_service_dbus_arg_info_set_last_used_server_serverUrl, NULL};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_set_last_used_server_out[] = {NULL};
static const GDBusMethodInfo _remote_login_service_dbus_method_info_set_last_used_server = {-1, "SetLastUsedServer", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_set_last_used_server_in), (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_set_last_used_server_out)};
static const GDBusMethodInfo * const _remote_login_service_dbus_method_info[] = {&_remote_login_service_dbus_method_info_get_servers, &_remote_login_service_dbus_method_info_get_servers_for_login, &_remote_login_service_dbus_method_info_get_cached_domains_for_server, &_remote_login_service_dbus_method_info_set_last_used_server, NULL};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_servers_updated_serverList = {-1, "serverList", "a(sssba(sbva{sv})a(si))"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_servers_updated[] = {&_remote_login_service_dbus_arg_info_servers_updated_serverList, NULL};
static const GDBusSignalInfo _remote_login_service_dbus_signal_info_servers_updated = {-1, "ServersUpdated", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_servers_updated)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_servers_updated_url = {-1, "url", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_servers_updated_emailAddress = {-1, "emailAddress", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_servers_updated_dataType = {-1, "dataType", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_servers_updated_serverList = {-1, "serverList", "a(sssba(sbva{sv})a(si))"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_login_servers_updated[] = {&_remote_login_service_dbus_arg_info_login_servers_updated_url, &_remote_login_service_dbus_arg_info_login_servers_updated_emailAddress, &_remote_login_service_dbus_arg_info_login_servers_updated_dataType, &_remote_login_service_dbus_arg_info_login_servers_updated_serverList, NULL};
static const GDBusSignalInfo _remote_login_service_dbus_signal_info_login_servers_updated = {-1, "LoginServersUpdated", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_login_servers_updated)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_changed_url = {-1, "url", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_changed_emailAddress = {-1, "emailAddress", "s"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_login_changed[] = {&_remote_login_service_dbus_arg_info_login_changed_url, &_remote_login_service_dbus_arg_info_login_changed_emailAddress, NULL};
static const GDBusSignalInfo _remote_login_service_dbus_signal_info_login_changed = {-1, "LoginChanged", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_login_changed)};
static const GDBusSignalInfo * const _remote_login_service_dbus_signal_info[] = {&_remote_login_service_dbus_signal_info_servers_updated, &_remote_login_service_dbus_signal_info_login_servers_updated, &_remote_login_service_dbus_signal_info_login_changed, NULL};
static const GDBusPropertyInfo * const _remote_login_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _remote_login_service_dbus_interface_info = {-1, "com.canonical.RemoteLogin", (GDBusMethodInfo **) (&_remote_login_service_dbus_method_info), (GDBusSignalInfo **) (&_remote_login_service_dbus_signal_info), (GDBusPropertyInfo **) (&_remote_login_service_dbus_property_info)};
static const GDBusInterfaceVTable _remote_login_service_dbus_interface_vtable = {remote_login_service_dbus_interface_method_call, remote_login_service_dbus_interface_get_property, remote_login_service_dbus_interface_set_property};

static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void remote_server_field_copy (const RemoteServerField* self, RemoteServerField* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	_tmp0_ = (*self).type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).type);
	(*dest).type = _tmp1_;
	_tmp2_ = (*self).required;
	(*dest).required = _tmp2_;
	_tmp3_ = (*self).default_value;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 ((*dest).default_value);
	(*dest).default_value = _tmp4_;
	_tmp5_ = (*self).properties;
	_tmp6_ = _g_hash_table_ref0 (_tmp5_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp6_;
}


void remote_server_field_destroy (RemoteServerField* self) {
	_g_free0 ((*self).type);
	_g_variant_unref0 ((*self).default_value);
	_g_hash_table_unref0 ((*self).properties);
}


RemoteServerField* remote_server_field_dup (const RemoteServerField* self) {
	RemoteServerField* dup;
	dup = g_new0 (RemoteServerField, 1);
	remote_server_field_copy (self, dup);
	return dup;
}


void remote_server_field_free (RemoteServerField* self) {
	remote_server_field_destroy (self);
	g_free (self);
}


GType remote_server_field_get_type (void) {
	static volatile gsize remote_server_field_type_id__volatile = 0;
	if (g_once_init_enter (&remote_server_field_type_id__volatile)) {
		GType remote_server_field_type_id;
		remote_server_field_type_id = g_boxed_type_register_static ("RemoteServerField", (GBoxedCopyFunc) remote_server_field_dup, (GBoxedFreeFunc) remote_server_field_free);
		g_once_init_leave (&remote_server_field_type_id__volatile, remote_server_field_type_id);
	}
	return remote_server_field_type_id__volatile;
}


void remote_server_application_copy (const RemoteServerApplication* self, RemoteServerApplication* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	_tmp0_ = (*self).application_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).application_id);
	(*dest).application_id = _tmp1_;
	_tmp2_ = (*self).pin_position;
	(*dest).pin_position = _tmp2_;
}


void remote_server_application_destroy (RemoteServerApplication* self) {
	_g_free0 ((*self).application_id);
}


RemoteServerApplication* remote_server_application_dup (const RemoteServerApplication* self) {
	RemoteServerApplication* dup;
	dup = g_new0 (RemoteServerApplication, 1);
	remote_server_application_copy (self, dup);
	return dup;
}


void remote_server_application_free (RemoteServerApplication* self) {
	remote_server_application_destroy (self);
	g_free (self);
}


GType remote_server_application_get_type (void) {
	static volatile gsize remote_server_application_type_id__volatile = 0;
	if (g_once_init_enter (&remote_server_application_type_id__volatile)) {
		GType remote_server_application_type_id;
		remote_server_application_type_id = g_boxed_type_register_static ("RemoteServerApplication", (GBoxedCopyFunc) remote_server_application_dup, (GBoxedFreeFunc) remote_server_application_free);
		g_once_init_leave (&remote_server_application_type_id__volatile, remote_server_application_type_id);
	}
	return remote_server_application_type_id__volatile;
}


static void _vala_RemoteServerField_array_free (RemoteServerField* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			remote_server_field_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _vala_RemoteServerApplication_array_free (RemoteServerApplication* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			remote_server_application_destroy (&array[i]);
		}
	}
	g_free (array);
}


static RemoteServerField* _vala_array_dup4 (RemoteServerField* self, int length) {
	RemoteServerField* result;
	int i;
	result = g_new0 (RemoteServerField, length);
	for (i = 0; i < length; i++) {
		RemoteServerField _tmp0_ = {0};
		remote_server_field_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static RemoteServerApplication* _vala_array_dup5 (RemoteServerApplication* self, int length) {
	RemoteServerApplication* result;
	int i;
	result = g_new0 (RemoteServerApplication, length);
	for (i = 0; i < length; i++) {
		RemoteServerApplication _tmp0_ = {0};
		remote_server_application_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


void remote_server_copy (const RemoteServer* self, RemoteServer* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	RemoteServerField* _tmp7_;
	gint _tmp7__length1;
	RemoteServerField* _tmp8_;
	gint _tmp8__length1;
	RemoteServerApplication* _tmp9_;
	gint _tmp9__length1;
	RemoteServerApplication* _tmp10_;
	gint _tmp10__length1;
	_tmp0_ = (*self).type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).type);
	(*dest).type = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	_tmp4_ = (*self).url;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).url);
	(*dest).url = _tmp5_;
	_tmp6_ = (*self).last_used_server;
	(*dest).last_used_server = _tmp6_;
	_tmp7_ = (*self).fields;
	_tmp7__length1 = (*self).fields_length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup4 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	(*dest).fields = (_vala_RemoteServerField_array_free ((*dest).fields, (*dest).fields_length1), NULL);
	(*dest).fields = _tmp8_;
	(*dest).fields_length1 = _tmp8__length1;
	_tmp9_ = (*self).applications;
	_tmp9__length1 = (*self).applications_length1;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup5 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	(*dest).applications = (_vala_RemoteServerApplication_array_free ((*dest).applications, (*dest).applications_length1), NULL);
	(*dest).applications = _tmp10_;
	(*dest).applications_length1 = _tmp10__length1;
}


void remote_server_destroy (RemoteServer* self) {
	_g_free0 ((*self).type);
	_g_free0 ((*self).name);
	_g_free0 ((*self).url);
	(*self).fields = (_vala_RemoteServerField_array_free ((*self).fields, (*self).fields_length1), NULL);
	(*self).applications = (_vala_RemoteServerApplication_array_free ((*self).applications, (*self).applications_length1), NULL);
}


RemoteServer* remote_server_dup (const RemoteServer* self) {
	RemoteServer* dup;
	dup = g_new0 (RemoteServer, 1);
	remote_server_copy (self, dup);
	return dup;
}


void remote_server_free (RemoteServer* self) {
	remote_server_destroy (self);
	g_free (self);
}


GType remote_server_get_type (void) {
	static volatile gsize remote_server_type_id__volatile = 0;
	if (g_once_init_enter (&remote_server_type_id__volatile)) {
		GType remote_server_type_id;
		remote_server_type_id = g_boxed_type_register_static ("RemoteServer", (GBoxedCopyFunc) remote_server_dup, (GBoxedFreeFunc) remote_server_free);
		g_once_init_leave (&remote_server_type_id__volatile, remote_server_type_id);
	}
	return remote_server_type_id__volatile;
}


void remote_login_service_get_servers (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_servers (self, _callback_, _user_data_);
}


void remote_login_service_get_servers_finish (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_servers_finish (self, _res_, serverList, serverList_length1, error);
}


void remote_login_service_get_servers_for_login (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_servers_for_login (self, url, emailAddress, password, allowCache, _callback_, _user_data_);
}


void remote_login_service_get_servers_for_login_finish (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_servers_for_login_finish (self, _res_, loginSuccess, dataType, serverList, serverList_length1, error);
}


void remote_login_service_get_cached_domains_for_server (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_cached_domains_for_server (self, url, _callback_, _user_data_);
}


void remote_login_service_get_cached_domains_for_server_finish (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_cached_domains_for_server_finish (self, _res_, domains, domains_length1, error);
}


void remote_login_service_set_last_used_server (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->set_last_used_server (self, uccsUrl, serverUrl, _callback_, _user_data_);
}


void remote_login_service_set_last_used_server_finish (RemoteLoginService* self, GAsyncResult* _res_, GError** error) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->set_last_used_server_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_POINTER_INT) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_pointer (param_values + 4), g_value_get_int (param_values + 5), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void remote_login_service_base_init (RemoteLoginServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("servers_updated", TYPE_REMOTE_LOGIN_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT);
		g_signal_new ("login_servers_updated", TYPE_REMOTE_LOGIN_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_POINTER_INT, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_INT);
		g_signal_new ("login_changed", TYPE_REMOTE_LOGIN_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	}
}


GType remote_login_service_get_type (void) {
	static volatile gsize remote_login_service_type_id__volatile = 0;
	if (g_once_init_enter (&remote_login_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RemoteLoginServiceIface), (GBaseInitFunc) remote_login_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType remote_login_service_type_id;
		remote_login_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "RemoteLoginService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (remote_login_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (remote_login_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) remote_login_service_proxy_get_type);
		g_type_set_qdata (remote_login_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.RemoteLogin");
		g_type_set_qdata (remote_login_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) remote_login_service_register_object);
		g_once_init_leave (&remote_login_service_type_id__volatile, remote_login_service_type_id);
	}
	return remote_login_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (RemoteLoginServiceProxy, remote_login_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_REMOTE_LOGIN_SERVICE, remote_login_service_proxy_remote_login_service_interface_init) )
static void remote_login_service_proxy_class_init (RemoteLoginServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = remote_login_service_proxy_g_signal;
}


static void _vala_RemoteServer_array_free (RemoteServer* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			remote_server_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_handle_remote_login_service_servers_updated (RemoteLoginService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	RemoteServer* serverList = NULL;
	int serverList_length1;
	GVariant* _tmp0_;
	RemoteServer* _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	serverList_length1 = 0;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (RemoteServer, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		RemoteServer _tmp4_;
		GVariantIter _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		RemoteServerField* _tmp11_;
		int _tmp11__length;
		int _tmp11__size;
		int _tmp11__length1;
		GVariantIter _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp24_;
		RemoteServerApplication* _tmp25_;
		int _tmp25__length;
		int _tmp25__size;
		int _tmp25__length1;
		GVariantIter _tmp26_;
		GVariant* _tmp27_;
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (RemoteServer, _tmp1_, _tmp1__size + 1);
		}
		g_variant_iter_init (&_tmp5_, _tmp3_);
		_tmp6_ = g_variant_iter_next_value (&_tmp5_);
		_tmp4_.type = g_variant_dup_string (_tmp6_, NULL);
		g_variant_unref (_tmp6_);
		_tmp7_ = g_variant_iter_next_value (&_tmp5_);
		_tmp4_.name = g_variant_dup_string (_tmp7_, NULL);
		g_variant_unref (_tmp7_);
		_tmp8_ = g_variant_iter_next_value (&_tmp5_);
		_tmp4_.url = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
		_tmp9_ = g_variant_iter_next_value (&_tmp5_);
		_tmp4_.last_used_server = g_variant_get_boolean (_tmp9_);
		g_variant_unref (_tmp9_);
		_tmp10_ = g_variant_iter_next_value (&_tmp5_);
		_tmp11_ = g_new (RemoteServerField, 5);
		_tmp11__length = 0;
		_tmp11__size = 4;
		_tmp11__length1 = 0;
		g_variant_iter_init (&_tmp12_, _tmp10_);
		for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
			RemoteServerField _tmp14_;
			GVariantIter _tmp15_;
			GVariant* _tmp16_;
			GVariant* _tmp17_;
			GVariant* _tmp18_;
			GVariant* _tmp19_;
			GHashTable* _tmp20_;
			GVariantIter _tmp21_;
			GVariant* _tmp22_;
			GVariant* _tmp23_;
			if (_tmp11__size == _tmp11__length) {
				_tmp11__size = 2 * _tmp11__size;
				_tmp11_ = g_renew (RemoteServerField, _tmp11_, _tmp11__size + 1);
			}
			g_variant_iter_init (&_tmp15_, _tmp13_);
			_tmp16_ = g_variant_iter_next_value (&_tmp15_);
			_tmp14_.type = g_variant_dup_string (_tmp16_, NULL);
			g_variant_unref (_tmp16_);
			_tmp17_ = g_variant_iter_next_value (&_tmp15_);
			_tmp14_.required = g_variant_get_boolean (_tmp17_);
			g_variant_unref (_tmp17_);
			_tmp18_ = g_variant_iter_next_value (&_tmp15_);
			_tmp14_.default_value = g_variant_get_variant (_tmp18_);
			g_variant_unref (_tmp18_);
			_tmp19_ = g_variant_iter_next_value (&_tmp15_);
			_tmp20_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
			g_variant_iter_init (&_tmp21_, _tmp19_);
			while (g_variant_iter_loop (&_tmp21_, "{?*}", &_tmp22_, &_tmp23_)) {
				g_hash_table_insert (_tmp20_, g_variant_dup_string (_tmp22_, NULL), g_variant_get_variant (_tmp23_));
			}
			_tmp14_.properties = _tmp20_;
			g_variant_unref (_tmp19_);
			_tmp11_[_tmp11__length++] = _tmp14_;
			g_variant_unref (_tmp13_);
		}
		_tmp4_.fields_length1 = _tmp11__length1;
		_tmp4_.fields = _tmp11_;
		g_variant_unref (_tmp10_);
		_tmp24_ = g_variant_iter_next_value (&_tmp5_);
		_tmp25_ = g_new (RemoteServerApplication, 5);
		_tmp25__length = 0;
		_tmp25__size = 4;
		_tmp25__length1 = 0;
		g_variant_iter_init (&_tmp26_, _tmp24_);
		for (; (_tmp27_ = g_variant_iter_next_value (&_tmp26_)) != NULL; _tmp25__length1++) {
			RemoteServerApplication _tmp28_;
			GVariantIter _tmp29_;
			GVariant* _tmp30_;
			GVariant* _tmp31_;
			if (_tmp25__size == _tmp25__length) {
				_tmp25__size = 2 * _tmp25__size;
				_tmp25_ = g_renew (RemoteServerApplication, _tmp25_, _tmp25__size + 1);
			}
			g_variant_iter_init (&_tmp29_, _tmp27_);
			_tmp30_ = g_variant_iter_next_value (&_tmp29_);
			_tmp28_.application_id = g_variant_dup_string (_tmp30_, NULL);
			g_variant_unref (_tmp30_);
			_tmp31_ = g_variant_iter_next_value (&_tmp29_);
			_tmp28_.pin_position = g_variant_get_int32 (_tmp31_);
			g_variant_unref (_tmp31_);
			_tmp25_[_tmp25__length++] = _tmp28_;
			g_variant_unref (_tmp27_);
		}
		_tmp4_.applications_length1 = _tmp25__length1;
		_tmp4_.applications = _tmp25_;
		g_variant_unref (_tmp24_);
		_tmp1_[_tmp1__length++] = _tmp4_;
		g_variant_unref (_tmp3_);
	}
	serverList_length1 = _tmp1__length1;
	serverList = _tmp1_;
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "servers-updated", serverList, serverList_length1);
	serverList = (_vala_RemoteServer_array_free (serverList, serverList_length1), NULL);
}


static void _dbus_handle_remote_login_service_login_servers_updated (RemoteLoginService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp32_;
	gchar* emailAddress = NULL;
	GVariant* _tmp33_;
	gchar* dataType = NULL;
	GVariant* _tmp34_;
	RemoteServer* serverList = NULL;
	int serverList_length1;
	GVariant* _tmp35_;
	RemoteServer* _tmp36_;
	int _tmp36__length;
	int _tmp36__size;
	int _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp32_, NULL);
	g_variant_unref (_tmp32_);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	emailAddress = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	dataType = g_variant_dup_string (_tmp34_, NULL);
	g_variant_unref (_tmp34_);
	serverList_length1 = 0;
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (RemoteServer, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		RemoteServer _tmp39_;
		GVariantIter _tmp40_;
		GVariant* _tmp41_;
		GVariant* _tmp42_;
		GVariant* _tmp43_;
		GVariant* _tmp44_;
		GVariant* _tmp45_;
		RemoteServerField* _tmp46_;
		int _tmp46__length;
		int _tmp46__size;
		int _tmp46__length1;
		GVariantIter _tmp47_;
		GVariant* _tmp48_;
		GVariant* _tmp59_;
		RemoteServerApplication* _tmp60_;
		int _tmp60__length;
		int _tmp60__size;
		int _tmp60__length1;
		GVariantIter _tmp61_;
		GVariant* _tmp62_;
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (RemoteServer, _tmp36_, _tmp36__size + 1);
		}
		g_variant_iter_init (&_tmp40_, _tmp38_);
		_tmp41_ = g_variant_iter_next_value (&_tmp40_);
		_tmp39_.type = g_variant_dup_string (_tmp41_, NULL);
		g_variant_unref (_tmp41_);
		_tmp42_ = g_variant_iter_next_value (&_tmp40_);
		_tmp39_.name = g_variant_dup_string (_tmp42_, NULL);
		g_variant_unref (_tmp42_);
		_tmp43_ = g_variant_iter_next_value (&_tmp40_);
		_tmp39_.url = g_variant_dup_string (_tmp43_, NULL);
		g_variant_unref (_tmp43_);
		_tmp44_ = g_variant_iter_next_value (&_tmp40_);
		_tmp39_.last_used_server = g_variant_get_boolean (_tmp44_);
		g_variant_unref (_tmp44_);
		_tmp45_ = g_variant_iter_next_value (&_tmp40_);
		_tmp46_ = g_new (RemoteServerField, 5);
		_tmp46__length = 0;
		_tmp46__size = 4;
		_tmp46__length1 = 0;
		g_variant_iter_init (&_tmp47_, _tmp45_);
		for (; (_tmp48_ = g_variant_iter_next_value (&_tmp47_)) != NULL; _tmp46__length1++) {
			RemoteServerField _tmp49_;
			GVariantIter _tmp50_;
			GVariant* _tmp51_;
			GVariant* _tmp52_;
			GVariant* _tmp53_;
			GVariant* _tmp54_;
			GHashTable* _tmp55_;
			GVariantIter _tmp56_;
			GVariant* _tmp57_;
			GVariant* _tmp58_;
			if (_tmp46__size == _tmp46__length) {
				_tmp46__size = 2 * _tmp46__size;
				_tmp46_ = g_renew (RemoteServerField, _tmp46_, _tmp46__size + 1);
			}
			g_variant_iter_init (&_tmp50_, _tmp48_);
			_tmp51_ = g_variant_iter_next_value (&_tmp50_);
			_tmp49_.type = g_variant_dup_string (_tmp51_, NULL);
			g_variant_unref (_tmp51_);
			_tmp52_ = g_variant_iter_next_value (&_tmp50_);
			_tmp49_.required = g_variant_get_boolean (_tmp52_);
			g_variant_unref (_tmp52_);
			_tmp53_ = g_variant_iter_next_value (&_tmp50_);
			_tmp49_.default_value = g_variant_get_variant (_tmp53_);
			g_variant_unref (_tmp53_);
			_tmp54_ = g_variant_iter_next_value (&_tmp50_);
			_tmp55_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
			g_variant_iter_init (&_tmp56_, _tmp54_);
			while (g_variant_iter_loop (&_tmp56_, "{?*}", &_tmp57_, &_tmp58_)) {
				g_hash_table_insert (_tmp55_, g_variant_dup_string (_tmp57_, NULL), g_variant_get_variant (_tmp58_));
			}
			_tmp49_.properties = _tmp55_;
			g_variant_unref (_tmp54_);
			_tmp46_[_tmp46__length++] = _tmp49_;
			g_variant_unref (_tmp48_);
		}
		_tmp39_.fields_length1 = _tmp46__length1;
		_tmp39_.fields = _tmp46_;
		g_variant_unref (_tmp45_);
		_tmp59_ = g_variant_iter_next_value (&_tmp40_);
		_tmp60_ = g_new (RemoteServerApplication, 5);
		_tmp60__length = 0;
		_tmp60__size = 4;
		_tmp60__length1 = 0;
		g_variant_iter_init (&_tmp61_, _tmp59_);
		for (; (_tmp62_ = g_variant_iter_next_value (&_tmp61_)) != NULL; _tmp60__length1++) {
			RemoteServerApplication _tmp63_;
			GVariantIter _tmp64_;
			GVariant* _tmp65_;
			GVariant* _tmp66_;
			if (_tmp60__size == _tmp60__length) {
				_tmp60__size = 2 * _tmp60__size;
				_tmp60_ = g_renew (RemoteServerApplication, _tmp60_, _tmp60__size + 1);
			}
			g_variant_iter_init (&_tmp64_, _tmp62_);
			_tmp65_ = g_variant_iter_next_value (&_tmp64_);
			_tmp63_.application_id = g_variant_dup_string (_tmp65_, NULL);
			g_variant_unref (_tmp65_);
			_tmp66_ = g_variant_iter_next_value (&_tmp64_);
			_tmp63_.pin_position = g_variant_get_int32 (_tmp66_);
			g_variant_unref (_tmp66_);
			_tmp60_[_tmp60__length++] = _tmp63_;
			g_variant_unref (_tmp62_);
		}
		_tmp39_.applications_length1 = _tmp60__length1;
		_tmp39_.applications = _tmp60_;
		g_variant_unref (_tmp59_);
		_tmp36_[_tmp36__length++] = _tmp39_;
		g_variant_unref (_tmp38_);
	}
	serverList_length1 = _tmp36__length1;
	serverList = _tmp36_;
	g_variant_unref (_tmp35_);
	g_signal_emit_by_name (self, "login-servers-updated", url, emailAddress, dataType, serverList, serverList_length1);
	_g_free0 (url);
	_g_free0 (emailAddress);
	_g_free0 (dataType);
	serverList = (_vala_RemoteServer_array_free (serverList, serverList_length1), NULL);
}


static void _dbus_handle_remote_login_service_login_changed (RemoteLoginService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp67_;
	gchar* emailAddress = NULL;
	GVariant* _tmp68_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp67_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp67_, NULL);
	g_variant_unref (_tmp67_);
	_tmp68_ = g_variant_iter_next_value (&_arguments_iter);
	emailAddress = g_variant_dup_string (_tmp68_, NULL);
	g_variant_unref (_tmp68_);
	g_signal_emit_by_name (self, "login-changed", url, emailAddress);
	_g_free0 (url);
	_g_free0 (emailAddress);
}


static void remote_login_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "ServersUpdated") == 0) {
		_dbus_handle_remote_login_service_servers_updated ((RemoteLoginService*) proxy, parameters);
	} else if (strcmp (signal_name, "LoginServersUpdated") == 0) {
		_dbus_handle_remote_login_service_login_servers_updated ((RemoteLoginService*) proxy, parameters);
	} else if (strcmp (signal_name, "LoginChanged") == 0) {
		_dbus_handle_remote_login_service_login_changed ((RemoteLoginService*) proxy, parameters);
	}
}


static void remote_login_service_proxy_init (RemoteLoginServiceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void remote_login_service_proxy_get_servers_async (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.RemoteLogin", "GetServers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void remote_login_service_proxy_get_servers_finish (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	RemoteServer* _vala_serverList;
	int _vala_serverList_length1;
	GVariant* _tmp69_;
	RemoteServer* _tmp70_;
	int _tmp70__length;
	int _tmp70__size;
	int _tmp70__length1;
	GVariantIter _tmp71_;
	GVariant* _tmp72_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_serverList_length1 = 0;
	_tmp69_ = g_variant_iter_next_value (&_reply_iter);
	_tmp70_ = g_new (RemoteServer, 5);
	_tmp70__length = 0;
	_tmp70__size = 4;
	_tmp70__length1 = 0;
	g_variant_iter_init (&_tmp71_, _tmp69_);
	for (; (_tmp72_ = g_variant_iter_next_value (&_tmp71_)) != NULL; _tmp70__length1++) {
		RemoteServer _tmp73_;
		GVariantIter _tmp74_;
		GVariant* _tmp75_;
		GVariant* _tmp76_;
		GVariant* _tmp77_;
		GVariant* _tmp78_;
		GVariant* _tmp79_;
		RemoteServerField* _tmp80_;
		int _tmp80__length;
		int _tmp80__size;
		int _tmp80__length1;
		GVariantIter _tmp81_;
		GVariant* _tmp82_;
		GVariant* _tmp93_;
		RemoteServerApplication* _tmp94_;
		int _tmp94__length;
		int _tmp94__size;
		int _tmp94__length1;
		GVariantIter _tmp95_;
		GVariant* _tmp96_;
		if (_tmp70__size == _tmp70__length) {
			_tmp70__size = 2 * _tmp70__size;
			_tmp70_ = g_renew (RemoteServer, _tmp70_, _tmp70__size + 1);
		}
		g_variant_iter_init (&_tmp74_, _tmp72_);
		_tmp75_ = g_variant_iter_next_value (&_tmp74_);
		_tmp73_.type = g_variant_dup_string (_tmp75_, NULL);
		g_variant_unref (_tmp75_);
		_tmp76_ = g_variant_iter_next_value (&_tmp74_);
		_tmp73_.name = g_variant_dup_string (_tmp76_, NULL);
		g_variant_unref (_tmp76_);
		_tmp77_ = g_variant_iter_next_value (&_tmp74_);
		_tmp73_.url = g_variant_dup_string (_tmp77_, NULL);
		g_variant_unref (_tmp77_);
		_tmp78_ = g_variant_iter_next_value (&_tmp74_);
		_tmp73_.last_used_server = g_variant_get_boolean (_tmp78_);
		g_variant_unref (_tmp78_);
		_tmp79_ = g_variant_iter_next_value (&_tmp74_);
		_tmp80_ = g_new (RemoteServerField, 5);
		_tmp80__length = 0;
		_tmp80__size = 4;
		_tmp80__length1 = 0;
		g_variant_iter_init (&_tmp81_, _tmp79_);
		for (; (_tmp82_ = g_variant_iter_next_value (&_tmp81_)) != NULL; _tmp80__length1++) {
			RemoteServerField _tmp83_;
			GVariantIter _tmp84_;
			GVariant* _tmp85_;
			GVariant* _tmp86_;
			GVariant* _tmp87_;
			GVariant* _tmp88_;
			GHashTable* _tmp89_;
			GVariantIter _tmp90_;
			GVariant* _tmp91_;
			GVariant* _tmp92_;
			if (_tmp80__size == _tmp80__length) {
				_tmp80__size = 2 * _tmp80__size;
				_tmp80_ = g_renew (RemoteServerField, _tmp80_, _tmp80__size + 1);
			}
			g_variant_iter_init (&_tmp84_, _tmp82_);
			_tmp85_ = g_variant_iter_next_value (&_tmp84_);
			_tmp83_.type = g_variant_dup_string (_tmp85_, NULL);
			g_variant_unref (_tmp85_);
			_tmp86_ = g_variant_iter_next_value (&_tmp84_);
			_tmp83_.required = g_variant_get_boolean (_tmp86_);
			g_variant_unref (_tmp86_);
			_tmp87_ = g_variant_iter_next_value (&_tmp84_);
			_tmp83_.default_value = g_variant_get_variant (_tmp87_);
			g_variant_unref (_tmp87_);
			_tmp88_ = g_variant_iter_next_value (&_tmp84_);
			_tmp89_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
			g_variant_iter_init (&_tmp90_, _tmp88_);
			while (g_variant_iter_loop (&_tmp90_, "{?*}", &_tmp91_, &_tmp92_)) {
				g_hash_table_insert (_tmp89_, g_variant_dup_string (_tmp91_, NULL), g_variant_get_variant (_tmp92_));
			}
			_tmp83_.properties = _tmp89_;
			g_variant_unref (_tmp88_);
			_tmp80_[_tmp80__length++] = _tmp83_;
			g_variant_unref (_tmp82_);
		}
		_tmp73_.fields_length1 = _tmp80__length1;
		_tmp73_.fields = _tmp80_;
		g_variant_unref (_tmp79_);
		_tmp93_ = g_variant_iter_next_value (&_tmp74_);
		_tmp94_ = g_new (RemoteServerApplication, 5);
		_tmp94__length = 0;
		_tmp94__size = 4;
		_tmp94__length1 = 0;
		g_variant_iter_init (&_tmp95_, _tmp93_);
		for (; (_tmp96_ = g_variant_iter_next_value (&_tmp95_)) != NULL; _tmp94__length1++) {
			RemoteServerApplication _tmp97_;
			GVariantIter _tmp98_;
			GVariant* _tmp99_;
			GVariant* _tmp100_;
			if (_tmp94__size == _tmp94__length) {
				_tmp94__size = 2 * _tmp94__size;
				_tmp94_ = g_renew (RemoteServerApplication, _tmp94_, _tmp94__size + 1);
			}
			g_variant_iter_init (&_tmp98_, _tmp96_);
			_tmp99_ = g_variant_iter_next_value (&_tmp98_);
			_tmp97_.application_id = g_variant_dup_string (_tmp99_, NULL);
			g_variant_unref (_tmp99_);
			_tmp100_ = g_variant_iter_next_value (&_tmp98_);
			_tmp97_.pin_position = g_variant_get_int32 (_tmp100_);
			g_variant_unref (_tmp100_);
			_tmp94_[_tmp94__length++] = _tmp97_;
			g_variant_unref (_tmp96_);
		}
		_tmp73_.applications_length1 = _tmp94__length1;
		_tmp73_.applications = _tmp94_;
		g_variant_unref (_tmp93_);
		_tmp70_[_tmp70__length++] = _tmp73_;
		g_variant_unref (_tmp72_);
	}
	_vala_serverList_length1 = _tmp70__length1;
	_vala_serverList = _tmp70_;
	g_variant_unref (_tmp69_);
	*serverList = _vala_serverList;
	*serverList_length1 = _vala_serverList_length1;
	g_object_unref (_reply_message);
}


static void remote_login_service_proxy_get_servers_for_login_async (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.RemoteLogin", "GetServersForLogin");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (emailAddress));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (password));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (allowCache));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void remote_login_service_proxy_get_servers_for_login_finish (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _vala_loginSuccess;
	GVariant* _tmp101_;
	gchar* _vala_dataType;
	GVariant* _tmp102_;
	RemoteServer* _vala_serverList;
	int _vala_serverList_length1;
	GVariant* _tmp103_;
	RemoteServer* _tmp104_;
	int _tmp104__length;
	int _tmp104__size;
	int _tmp104__length1;
	GVariantIter _tmp105_;
	GVariant* _tmp106_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp101_ = g_variant_iter_next_value (&_reply_iter);
	_vala_loginSuccess = g_variant_get_boolean (_tmp101_);
	g_variant_unref (_tmp101_);
	*loginSuccess = _vala_loginSuccess;
	_tmp102_ = g_variant_iter_next_value (&_reply_iter);
	_vala_dataType = g_variant_dup_string (_tmp102_, NULL);
	g_variant_unref (_tmp102_);
	*dataType = _vala_dataType;
	_vala_serverList_length1 = 0;
	_tmp103_ = g_variant_iter_next_value (&_reply_iter);
	_tmp104_ = g_new (RemoteServer, 5);
	_tmp104__length = 0;
	_tmp104__size = 4;
	_tmp104__length1 = 0;
	g_variant_iter_init (&_tmp105_, _tmp103_);
	for (; (_tmp106_ = g_variant_iter_next_value (&_tmp105_)) != NULL; _tmp104__length1++) {
		RemoteServer _tmp107_;
		GVariantIter _tmp108_;
		GVariant* _tmp109_;
		GVariant* _tmp110_;
		GVariant* _tmp111_;
		GVariant* _tmp112_;
		GVariant* _tmp113_;
		RemoteServerField* _tmp114_;
		int _tmp114__length;
		int _tmp114__size;
		int _tmp114__length1;
		GVariantIter _tmp115_;
		GVariant* _tmp116_;
		GVariant* _tmp127_;
		RemoteServerApplication* _tmp128_;
		int _tmp128__length;
		int _tmp128__size;
		int _tmp128__length1;
		GVariantIter _tmp129_;
		GVariant* _tmp130_;
		if (_tmp104__size == _tmp104__length) {
			_tmp104__size = 2 * _tmp104__size;
			_tmp104_ = g_renew (RemoteServer, _tmp104_, _tmp104__size + 1);
		}
		g_variant_iter_init (&_tmp108_, _tmp106_);
		_tmp109_ = g_variant_iter_next_value (&_tmp108_);
		_tmp107_.type = g_variant_dup_string (_tmp109_, NULL);
		g_variant_unref (_tmp109_);
		_tmp110_ = g_variant_iter_next_value (&_tmp108_);
		_tmp107_.name = g_variant_dup_string (_tmp110_, NULL);
		g_variant_unref (_tmp110_);
		_tmp111_ = g_variant_iter_next_value (&_tmp108_);
		_tmp107_.url = g_variant_dup_string (_tmp111_, NULL);
		g_variant_unref (_tmp111_);
		_tmp112_ = g_variant_iter_next_value (&_tmp108_);
		_tmp107_.last_used_server = g_variant_get_boolean (_tmp112_);
		g_variant_unref (_tmp112_);
		_tmp113_ = g_variant_iter_next_value (&_tmp108_);
		_tmp114_ = g_new (RemoteServerField, 5);
		_tmp114__length = 0;
		_tmp114__size = 4;
		_tmp114__length1 = 0;
		g_variant_iter_init (&_tmp115_, _tmp113_);
		for (; (_tmp116_ = g_variant_iter_next_value (&_tmp115_)) != NULL; _tmp114__length1++) {
			RemoteServerField _tmp117_;
			GVariantIter _tmp118_;
			GVariant* _tmp119_;
			GVariant* _tmp120_;
			GVariant* _tmp121_;
			GVariant* _tmp122_;
			GHashTable* _tmp123_;
			GVariantIter _tmp124_;
			GVariant* _tmp125_;
			GVariant* _tmp126_;
			if (_tmp114__size == _tmp114__length) {
				_tmp114__size = 2 * _tmp114__size;
				_tmp114_ = g_renew (RemoteServerField, _tmp114_, _tmp114__size + 1);
			}
			g_variant_iter_init (&_tmp118_, _tmp116_);
			_tmp119_ = g_variant_iter_next_value (&_tmp118_);
			_tmp117_.type = g_variant_dup_string (_tmp119_, NULL);
			g_variant_unref (_tmp119_);
			_tmp120_ = g_variant_iter_next_value (&_tmp118_);
			_tmp117_.required = g_variant_get_boolean (_tmp120_);
			g_variant_unref (_tmp120_);
			_tmp121_ = g_variant_iter_next_value (&_tmp118_);
			_tmp117_.default_value = g_variant_get_variant (_tmp121_);
			g_variant_unref (_tmp121_);
			_tmp122_ = g_variant_iter_next_value (&_tmp118_);
			_tmp123_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
			g_variant_iter_init (&_tmp124_, _tmp122_);
			while (g_variant_iter_loop (&_tmp124_, "{?*}", &_tmp125_, &_tmp126_)) {
				g_hash_table_insert (_tmp123_, g_variant_dup_string (_tmp125_, NULL), g_variant_get_variant (_tmp126_));
			}
			_tmp117_.properties = _tmp123_;
			g_variant_unref (_tmp122_);
			_tmp114_[_tmp114__length++] = _tmp117_;
			g_variant_unref (_tmp116_);
		}
		_tmp107_.fields_length1 = _tmp114__length1;
		_tmp107_.fields = _tmp114_;
		g_variant_unref (_tmp113_);
		_tmp127_ = g_variant_iter_next_value (&_tmp108_);
		_tmp128_ = g_new (RemoteServerApplication, 5);
		_tmp128__length = 0;
		_tmp128__size = 4;
		_tmp128__length1 = 0;
		g_variant_iter_init (&_tmp129_, _tmp127_);
		for (; (_tmp130_ = g_variant_iter_next_value (&_tmp129_)) != NULL; _tmp128__length1++) {
			RemoteServerApplication _tmp131_;
			GVariantIter _tmp132_;
			GVariant* _tmp133_;
			GVariant* _tmp134_;
			if (_tmp128__size == _tmp128__length) {
				_tmp128__size = 2 * _tmp128__size;
				_tmp128_ = g_renew (RemoteServerApplication, _tmp128_, _tmp128__size + 1);
			}
			g_variant_iter_init (&_tmp132_, _tmp130_);
			_tmp133_ = g_variant_iter_next_value (&_tmp132_);
			_tmp131_.application_id = g_variant_dup_string (_tmp133_, NULL);
			g_variant_unref (_tmp133_);
			_tmp134_ = g_variant_iter_next_value (&_tmp132_);
			_tmp131_.pin_position = g_variant_get_int32 (_tmp134_);
			g_variant_unref (_tmp134_);
			_tmp128_[_tmp128__length++] = _tmp131_;
			g_variant_unref (_tmp130_);
		}
		_tmp107_.applications_length1 = _tmp128__length1;
		_tmp107_.applications = _tmp128_;
		g_variant_unref (_tmp127_);
		_tmp104_[_tmp104__length++] = _tmp107_;
		g_variant_unref (_tmp106_);
	}
	_vala_serverList_length1 = _tmp104__length1;
	_vala_serverList = _tmp104_;
	g_variant_unref (_tmp103_);
	*serverList = _vala_serverList;
	*serverList_length1 = _vala_serverList_length1;
	g_object_unref (_reply_message);
}


static void remote_login_service_proxy_get_cached_domains_for_server_async (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.RemoteLogin", "GetCachedDomainsForServer");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void remote_login_service_proxy_get_cached_domains_for_server_finish (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _vala_domains;
	int _vala_domains_length1;
	GVariant* _tmp135_;
	gchar** _tmp136_;
	int _tmp136__length;
	int _tmp136__size;
	int _tmp136__length1;
	GVariantIter _tmp137_;
	GVariant* _tmp138_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_domains_length1 = 0;
	_tmp135_ = g_variant_iter_next_value (&_reply_iter);
	_tmp136_ = g_new (gchar*, 5);
	_tmp136__length = 0;
	_tmp136__size = 4;
	_tmp136__length1 = 0;
	g_variant_iter_init (&_tmp137_, _tmp135_);
	for (; (_tmp138_ = g_variant_iter_next_value (&_tmp137_)) != NULL; _tmp136__length1++) {
		if (_tmp136__size == _tmp136__length) {
			_tmp136__size = 2 * _tmp136__size;
			_tmp136_ = g_renew (gchar*, _tmp136_, _tmp136__size + 1);
		}
		_tmp136_[_tmp136__length++] = g_variant_dup_string (_tmp138_, NULL);
		g_variant_unref (_tmp138_);
	}
	_vala_domains_length1 = _tmp136__length1;
	_tmp136_[_tmp136__length] = NULL;
	_vala_domains = _tmp136_;
	g_variant_unref (_tmp135_);
	*domains = _vala_domains;
	*domains_length1 = _vala_domains_length1;
	g_object_unref (_reply_message);
}


static void remote_login_service_proxy_set_last_used_server_async (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.RemoteLogin", "SetLastUsedServer");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uccsUrl));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (serverUrl));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void remote_login_service_proxy_set_last_used_server_finish (RemoteLoginService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void remote_login_service_proxy_remote_login_service_interface_init (RemoteLoginServiceIface* iface) {
	iface->get_servers = remote_login_service_proxy_get_servers_async;
	iface->get_servers_finish = remote_login_service_proxy_get_servers_finish;
	iface->get_servers_for_login = remote_login_service_proxy_get_servers_for_login_async;
	iface->get_servers_for_login_finish = remote_login_service_proxy_get_servers_for_login_finish;
	iface->get_cached_domains_for_server = remote_login_service_proxy_get_cached_domains_for_server_async;
	iface->get_cached_domains_for_server_finish = remote_login_service_proxy_get_cached_domains_for_server_finish;
	iface->set_last_used_server = remote_login_service_proxy_set_last_used_server_async;
	iface->set_last_used_server_finish = remote_login_service_proxy_set_last_used_server_finish;
}


static void _dbus_remote_login_service_get_servers (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	remote_login_service_get_servers (self, (GAsyncReadyCallback) _dbus_remote_login_service_get_servers_ready, invocation);
}


static void _dbus_remote_login_service_get_servers_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	RemoteServer* serverList = NULL;
	int serverList_length1 = 0;
	RemoteServer* _tmp139_;
	GVariantBuilder _tmp140_;
	int _tmp141_;
	invocation = _user_data_;
	remote_login_service_get_servers_finish ((RemoteLoginService*) source_object, _res_, &serverList, &serverList_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp139_ = serverList;
	g_variant_builder_init (&_tmp140_, G_VARIANT_TYPE ("a(sssba(sbva{sv})a(si))"));
	for (_tmp141_ = 0; _tmp141_ < serverList_length1; _tmp141_++) {
		GVariantBuilder _tmp142_;
		RemoteServerField* _tmp143_;
		GVariantBuilder _tmp144_;
		int _tmp145_;
		RemoteServerApplication* _tmp151_;
		GVariantBuilder _tmp152_;
		int _tmp153_;
		g_variant_builder_init (&_tmp142_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp142_, g_variant_new_string ((*_tmp139_).type));
		g_variant_builder_add_value (&_tmp142_, g_variant_new_string ((*_tmp139_).name));
		g_variant_builder_add_value (&_tmp142_, g_variant_new_string ((*_tmp139_).url));
		g_variant_builder_add_value (&_tmp142_, g_variant_new_boolean ((*_tmp139_).last_used_server));
		_tmp143_ = (*_tmp139_).fields;
		g_variant_builder_init (&_tmp144_, G_VARIANT_TYPE ("a(sbva{sv})"));
		for (_tmp145_ = 0; _tmp145_ < (*_tmp139_).fields_length1; _tmp145_++) {
			GVariantBuilder _tmp146_;
			GVariantBuilder _tmp147_;
			GHashTableIter _tmp148_;
			gpointer _tmp149_;
			gpointer _tmp150_;
			g_variant_builder_init (&_tmp146_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp146_, g_variant_new_string ((*_tmp143_).type));
			g_variant_builder_add_value (&_tmp146_, g_variant_new_boolean ((*_tmp143_).required));
			g_variant_builder_add_value (&_tmp146_, g_variant_new_variant ((*_tmp143_).default_value));
			g_hash_table_iter_init (&_tmp148_, (*_tmp143_).properties);
			g_variant_builder_init (&_tmp147_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp148_, &_tmp149_, &_tmp150_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp149_;
				_value = (GVariant*) _tmp150_;
				g_variant_builder_add (&_tmp147_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp146_, g_variant_builder_end (&_tmp147_));
			g_variant_builder_add_value (&_tmp144_, g_variant_builder_end (&_tmp146_));
			_tmp143_++;
		}
		g_variant_builder_add_value (&_tmp142_, g_variant_builder_end (&_tmp144_));
		_tmp151_ = (*_tmp139_).applications;
		g_variant_builder_init (&_tmp152_, G_VARIANT_TYPE ("a(si)"));
		for (_tmp153_ = 0; _tmp153_ < (*_tmp139_).applications_length1; _tmp153_++) {
			GVariantBuilder _tmp154_;
			g_variant_builder_init (&_tmp154_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp154_, g_variant_new_string ((*_tmp151_).application_id));
			g_variant_builder_add_value (&_tmp154_, g_variant_new_int32 ((*_tmp151_).pin_position));
			g_variant_builder_add_value (&_tmp152_, g_variant_builder_end (&_tmp154_));
			_tmp151_++;
		}
		g_variant_builder_add_value (&_tmp142_, g_variant_builder_end (&_tmp152_));
		g_variant_builder_add_value (&_tmp140_, g_variant_builder_end (&_tmp142_));
		_tmp139_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp140_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	serverList = (_vala_RemoteServer_array_free (serverList, serverList_length1), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_remote_login_service_get_servers_for_login (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp155_;
	gchar* emailAddress = NULL;
	GVariant* _tmp156_;
	gchar* password = NULL;
	GVariant* _tmp157_;
	gboolean allowCache = FALSE;
	GVariant* _tmp158_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp155_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp155_, NULL);
	g_variant_unref (_tmp155_);
	_tmp156_ = g_variant_iter_next_value (&_arguments_iter);
	emailAddress = g_variant_dup_string (_tmp156_, NULL);
	g_variant_unref (_tmp156_);
	_tmp157_ = g_variant_iter_next_value (&_arguments_iter);
	password = g_variant_dup_string (_tmp157_, NULL);
	g_variant_unref (_tmp157_);
	_tmp158_ = g_variant_iter_next_value (&_arguments_iter);
	allowCache = g_variant_get_boolean (_tmp158_);
	g_variant_unref (_tmp158_);
	remote_login_service_get_servers_for_login (self, url, emailAddress, password, allowCache, (GAsyncReadyCallback) _dbus_remote_login_service_get_servers_for_login_ready, invocation);
	_g_free0 (url);
	_g_free0 (emailAddress);
	_g_free0 (password);
}


static void _dbus_remote_login_service_get_servers_for_login_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean loginSuccess = FALSE;
	gchar* dataType = NULL;
	RemoteServer* serverList = NULL;
	int serverList_length1 = 0;
	RemoteServer* _tmp159_;
	GVariantBuilder _tmp160_;
	int _tmp161_;
	invocation = _user_data_;
	remote_login_service_get_servers_for_login_finish ((RemoteLoginService*) source_object, _res_, &loginSuccess, &dataType, &serverList, &serverList_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (loginSuccess));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (dataType));
	_tmp159_ = serverList;
	g_variant_builder_init (&_tmp160_, G_VARIANT_TYPE ("a(sssba(sbva{sv})a(si))"));
	for (_tmp161_ = 0; _tmp161_ < serverList_length1; _tmp161_++) {
		GVariantBuilder _tmp162_;
		RemoteServerField* _tmp163_;
		GVariantBuilder _tmp164_;
		int _tmp165_;
		RemoteServerApplication* _tmp171_;
		GVariantBuilder _tmp172_;
		int _tmp173_;
		g_variant_builder_init (&_tmp162_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp162_, g_variant_new_string ((*_tmp159_).type));
		g_variant_builder_add_value (&_tmp162_, g_variant_new_string ((*_tmp159_).name));
		g_variant_builder_add_value (&_tmp162_, g_variant_new_string ((*_tmp159_).url));
		g_variant_builder_add_value (&_tmp162_, g_variant_new_boolean ((*_tmp159_).last_used_server));
		_tmp163_ = (*_tmp159_).fields;
		g_variant_builder_init (&_tmp164_, G_VARIANT_TYPE ("a(sbva{sv})"));
		for (_tmp165_ = 0; _tmp165_ < (*_tmp159_).fields_length1; _tmp165_++) {
			GVariantBuilder _tmp166_;
			GVariantBuilder _tmp167_;
			GHashTableIter _tmp168_;
			gpointer _tmp169_;
			gpointer _tmp170_;
			g_variant_builder_init (&_tmp166_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp166_, g_variant_new_string ((*_tmp163_).type));
			g_variant_builder_add_value (&_tmp166_, g_variant_new_boolean ((*_tmp163_).required));
			g_variant_builder_add_value (&_tmp166_, g_variant_new_variant ((*_tmp163_).default_value));
			g_hash_table_iter_init (&_tmp168_, (*_tmp163_).properties);
			g_variant_builder_init (&_tmp167_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp168_, &_tmp169_, &_tmp170_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp169_;
				_value = (GVariant*) _tmp170_;
				g_variant_builder_add (&_tmp167_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp166_, g_variant_builder_end (&_tmp167_));
			g_variant_builder_add_value (&_tmp164_, g_variant_builder_end (&_tmp166_));
			_tmp163_++;
		}
		g_variant_builder_add_value (&_tmp162_, g_variant_builder_end (&_tmp164_));
		_tmp171_ = (*_tmp159_).applications;
		g_variant_builder_init (&_tmp172_, G_VARIANT_TYPE ("a(si)"));
		for (_tmp173_ = 0; _tmp173_ < (*_tmp159_).applications_length1; _tmp173_++) {
			GVariantBuilder _tmp174_;
			g_variant_builder_init (&_tmp174_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp174_, g_variant_new_string ((*_tmp171_).application_id));
			g_variant_builder_add_value (&_tmp174_, g_variant_new_int32 ((*_tmp171_).pin_position));
			g_variant_builder_add_value (&_tmp172_, g_variant_builder_end (&_tmp174_));
			_tmp171_++;
		}
		g_variant_builder_add_value (&_tmp162_, g_variant_builder_end (&_tmp172_));
		g_variant_builder_add_value (&_tmp160_, g_variant_builder_end (&_tmp162_));
		_tmp159_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp160_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (dataType);
	serverList = (_vala_RemoteServer_array_free (serverList, serverList_length1), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_remote_login_service_get_cached_domains_for_server (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp175_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp175_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp175_, NULL);
	g_variant_unref (_tmp175_);
	remote_login_service_get_cached_domains_for_server (self, url, (GAsyncReadyCallback) _dbus_remote_login_service_get_cached_domains_for_server_ready, invocation);
	_g_free0 (url);
}


static void _dbus_remote_login_service_get_cached_domains_for_server_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** domains = NULL;
	int domains_length1 = 0;
	gchar** _tmp176_;
	GVariantBuilder _tmp177_;
	int _tmp178_;
	invocation = _user_data_;
	remote_login_service_get_cached_domains_for_server_finish ((RemoteLoginService*) source_object, _res_, &domains, &domains_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp176_ = domains;
	g_variant_builder_init (&_tmp177_, G_VARIANT_TYPE ("as"));
	for (_tmp178_ = 0; _tmp178_ < domains_length1; _tmp178_++) {
		g_variant_builder_add_value (&_tmp177_, g_variant_new_string (*_tmp176_));
		_tmp176_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp177_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_remote_login_service_set_last_used_server (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uccsUrl = NULL;
	GVariant* _tmp179_;
	gchar* serverUrl = NULL;
	GVariant* _tmp180_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp179_ = g_variant_iter_next_value (&_arguments_iter);
	uccsUrl = g_variant_dup_string (_tmp179_, NULL);
	g_variant_unref (_tmp179_);
	_tmp180_ = g_variant_iter_next_value (&_arguments_iter);
	serverUrl = g_variant_dup_string (_tmp180_, NULL);
	g_variant_unref (_tmp180_);
	remote_login_service_set_last_used_server (self, uccsUrl, serverUrl, (GAsyncReadyCallback) _dbus_remote_login_service_set_last_used_server_ready, invocation);
	_g_free0 (uccsUrl);
	_g_free0 (serverUrl);
}


static void _dbus_remote_login_service_set_last_used_server_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	remote_login_service_set_last_used_server_finish ((RemoteLoginService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void remote_login_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetServers") == 0) {
		_dbus_remote_login_service_get_servers (object, parameters, invocation);
	} else if (strcmp (method_name, "GetServersForLogin") == 0) {
		_dbus_remote_login_service_get_servers_for_login (object, parameters, invocation);
	} else if (strcmp (method_name, "GetCachedDomainsForServer") == 0) {
		_dbus_remote_login_service_get_cached_domains_for_server (object, parameters, invocation);
	} else if (strcmp (method_name, "SetLastUsedServer") == 0) {
		_dbus_remote_login_service_set_last_used_server (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* remote_login_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean remote_login_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_remote_login_service_servers_updated (GObject* _sender, RemoteServer* serverList, int serverList_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	RemoteServer* _tmp181_;
	GVariantBuilder _tmp182_;
	int _tmp183_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp181_ = serverList;
	g_variant_builder_init (&_tmp182_, G_VARIANT_TYPE ("a(sssba(sbva{sv})a(si))"));
	for (_tmp183_ = 0; _tmp183_ < serverList_length1; _tmp183_++) {
		GVariantBuilder _tmp184_;
		RemoteServerField* _tmp185_;
		GVariantBuilder _tmp186_;
		int _tmp187_;
		RemoteServerApplication* _tmp193_;
		GVariantBuilder _tmp194_;
		int _tmp195_;
		g_variant_builder_init (&_tmp184_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp184_, g_variant_new_string ((*_tmp181_).type));
		g_variant_builder_add_value (&_tmp184_, g_variant_new_string ((*_tmp181_).name));
		g_variant_builder_add_value (&_tmp184_, g_variant_new_string ((*_tmp181_).url));
		g_variant_builder_add_value (&_tmp184_, g_variant_new_boolean ((*_tmp181_).last_used_server));
		_tmp185_ = (*_tmp181_).fields;
		g_variant_builder_init (&_tmp186_, G_VARIANT_TYPE ("a(sbva{sv})"));
		for (_tmp187_ = 0; _tmp187_ < (*_tmp181_).fields_length1; _tmp187_++) {
			GVariantBuilder _tmp188_;
			GVariantBuilder _tmp189_;
			GHashTableIter _tmp190_;
			gpointer _tmp191_;
			gpointer _tmp192_;
			g_variant_builder_init (&_tmp188_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp188_, g_variant_new_string ((*_tmp185_).type));
			g_variant_builder_add_value (&_tmp188_, g_variant_new_boolean ((*_tmp185_).required));
			g_variant_builder_add_value (&_tmp188_, g_variant_new_variant ((*_tmp185_).default_value));
			g_hash_table_iter_init (&_tmp190_, (*_tmp185_).properties);
			g_variant_builder_init (&_tmp189_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp190_, &_tmp191_, &_tmp192_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp191_;
				_value = (GVariant*) _tmp192_;
				g_variant_builder_add (&_tmp189_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp188_, g_variant_builder_end (&_tmp189_));
			g_variant_builder_add_value (&_tmp186_, g_variant_builder_end (&_tmp188_));
			_tmp185_++;
		}
		g_variant_builder_add_value (&_tmp184_, g_variant_builder_end (&_tmp186_));
		_tmp193_ = (*_tmp181_).applications;
		g_variant_builder_init (&_tmp194_, G_VARIANT_TYPE ("a(si)"));
		for (_tmp195_ = 0; _tmp195_ < (*_tmp181_).applications_length1; _tmp195_++) {
			GVariantBuilder _tmp196_;
			g_variant_builder_init (&_tmp196_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp196_, g_variant_new_string ((*_tmp193_).application_id));
			g_variant_builder_add_value (&_tmp196_, g_variant_new_int32 ((*_tmp193_).pin_position));
			g_variant_builder_add_value (&_tmp194_, g_variant_builder_end (&_tmp196_));
			_tmp193_++;
		}
		g_variant_builder_add_value (&_tmp184_, g_variant_builder_end (&_tmp194_));
		g_variant_builder_add_value (&_tmp182_, g_variant_builder_end (&_tmp184_));
		_tmp181_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp182_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.RemoteLogin", "ServersUpdated", _arguments, NULL);
}


static void _dbus_remote_login_service_login_servers_updated (GObject* _sender, const gchar* url, const gchar* emailAddress, const gchar* dataType, RemoteServer* serverList, int serverList_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	RemoteServer* _tmp197_;
	GVariantBuilder _tmp198_;
	int _tmp199_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (emailAddress));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (dataType));
	_tmp197_ = serverList;
	g_variant_builder_init (&_tmp198_, G_VARIANT_TYPE ("a(sssba(sbva{sv})a(si))"));
	for (_tmp199_ = 0; _tmp199_ < serverList_length1; _tmp199_++) {
		GVariantBuilder _tmp200_;
		RemoteServerField* _tmp201_;
		GVariantBuilder _tmp202_;
		int _tmp203_;
		RemoteServerApplication* _tmp209_;
		GVariantBuilder _tmp210_;
		int _tmp211_;
		g_variant_builder_init (&_tmp200_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp200_, g_variant_new_string ((*_tmp197_).type));
		g_variant_builder_add_value (&_tmp200_, g_variant_new_string ((*_tmp197_).name));
		g_variant_builder_add_value (&_tmp200_, g_variant_new_string ((*_tmp197_).url));
		g_variant_builder_add_value (&_tmp200_, g_variant_new_boolean ((*_tmp197_).last_used_server));
		_tmp201_ = (*_tmp197_).fields;
		g_variant_builder_init (&_tmp202_, G_VARIANT_TYPE ("a(sbva{sv})"));
		for (_tmp203_ = 0; _tmp203_ < (*_tmp197_).fields_length1; _tmp203_++) {
			GVariantBuilder _tmp204_;
			GVariantBuilder _tmp205_;
			GHashTableIter _tmp206_;
			gpointer _tmp207_;
			gpointer _tmp208_;
			g_variant_builder_init (&_tmp204_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp204_, g_variant_new_string ((*_tmp201_).type));
			g_variant_builder_add_value (&_tmp204_, g_variant_new_boolean ((*_tmp201_).required));
			g_variant_builder_add_value (&_tmp204_, g_variant_new_variant ((*_tmp201_).default_value));
			g_hash_table_iter_init (&_tmp206_, (*_tmp201_).properties);
			g_variant_builder_init (&_tmp205_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp206_, &_tmp207_, &_tmp208_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp207_;
				_value = (GVariant*) _tmp208_;
				g_variant_builder_add (&_tmp205_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp204_, g_variant_builder_end (&_tmp205_));
			g_variant_builder_add_value (&_tmp202_, g_variant_builder_end (&_tmp204_));
			_tmp201_++;
		}
		g_variant_builder_add_value (&_tmp200_, g_variant_builder_end (&_tmp202_));
		_tmp209_ = (*_tmp197_).applications;
		g_variant_builder_init (&_tmp210_, G_VARIANT_TYPE ("a(si)"));
		for (_tmp211_ = 0; _tmp211_ < (*_tmp197_).applications_length1; _tmp211_++) {
			GVariantBuilder _tmp212_;
			g_variant_builder_init (&_tmp212_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp212_, g_variant_new_string ((*_tmp209_).application_id));
			g_variant_builder_add_value (&_tmp212_, g_variant_new_int32 ((*_tmp209_).pin_position));
			g_variant_builder_add_value (&_tmp210_, g_variant_builder_end (&_tmp212_));
			_tmp209_++;
		}
		g_variant_builder_add_value (&_tmp200_, g_variant_builder_end (&_tmp210_));
		g_variant_builder_add_value (&_tmp198_, g_variant_builder_end (&_tmp200_));
		_tmp197_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp198_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.RemoteLogin", "LoginServersUpdated", _arguments, NULL);
}


static void _dbus_remote_login_service_login_changed (GObject* _sender, const gchar* url, const gchar* emailAddress, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (emailAddress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.RemoteLogin", "LoginChanged", _arguments, NULL);
}


guint remote_login_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_remote_login_service_dbus_interface_info), &_remote_login_service_dbus_interface_vtable, data, _remote_login_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "servers-updated", (GCallback) _dbus_remote_login_service_servers_updated, data);
	g_signal_connect (object, "login-servers-updated", (GCallback) _dbus_remote_login_service_login_servers_updated, data);
	g_signal_connect (object, "login-changed", (GCallback) _dbus_remote_login_service_login_changed, data);
	return result;
}


static void _remote_login_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_remote_login_service_servers_updated, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_remote_login_service_login_servers_updated, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_remote_login_service_login_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



