/* background.c generated by valac 0.16.1, the Vala compiler
 * generated from background.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BACKGROUND_LOADER (background_loader_get_type ())
#define BACKGROUND_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_LOADER, BackgroundLoader))
#define BACKGROUND_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_LOADER, BackgroundLoaderClass))
#define IS_BACKGROUND_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_LOADER))
#define IS_BACKGROUND_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_LOADER))
#define BACKGROUND_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_LOADER, BackgroundLoaderClass))

typedef struct _BackgroundLoader BackgroundLoader;
typedef struct _BackgroundLoaderClass BackgroundLoaderClass;
typedef struct _BackgroundLoaderPrivate BackgroundLoaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;
typedef struct _MonitorPrivate MonitorPrivate;
typedef struct _ParamSpecMonitor ParamSpecMonitor;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;
typedef struct _BackgroundPrivate BackgroundPrivate;

#define TYPE_ANIMATE_TIMER (animate_timer_get_type ())
#define ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATE_TIMER, AnimateTimer))
#define ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATE_TIMER, AnimateTimerClass))
#define IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATE_TIMER))
#define IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATE_TIMER))
#define ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATE_TIMER, AnimateTimerClass))

typedef struct _AnimateTimer AnimateTimer;
typedef struct _AnimateTimerClass AnimateTimerClass;

#define BACKGROUND_TYPE_DRAW_FLAGS (background_draw_flags_get_type ())
#define __g_list_free__monitor_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__monitor_unref0_ (var), NULL)))
#define _monitor_unref0(var) ((var == NULL) ? NULL : (var = (monitor_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _BackgroundLoader {
	GObject parent_instance;
	BackgroundLoaderPrivate * priv;
	gint* widths;
	gint widths_length1;
	gint _widths_size_;
	gint* heights;
	gint heights_length1;
	gint _heights_size_;
	cairo_pattern_t** patterns;
	gint patterns_length1;
	gint _patterns_size_;
	GdkRGBA average_color;
};

struct _BackgroundLoaderClass {
	GObjectClass parent_class;
};

struct _BackgroundLoaderPrivate {
	gchar* _filename;
	cairo_surface_t* _logo;
	cairo_surface_t* target_surface;
	gboolean draw_grid;
	GThread* thread;
	GdkPixbuf** images;
	gint images_length1;
	gint _images_size_;
	gboolean finished;
	guint ready_id;
};

struct _Monitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorPrivate * priv;
	gint x;
	gint y;
	gint width;
	gint height;
};

struct _MonitorClass {
	GTypeClass parent_class;
	void (*finalize) (Monitor *self);
};

struct _ParamSpecMonitor {
	GParamSpec parent_instance;
};

struct _Background {
	GtkFixed parent_instance;
	BackgroundPrivate * priv;
};

struct _BackgroundClass {
	GtkFixedClass parent_class;
};

struct _BackgroundPrivate {
	gchar* _default_background;
	gchar* _current_background;
	gboolean _draw_grid;
	gdouble _alpha;
	cairo_surface_t* target_surface;
	GList* monitors;
	Monitor* active_monitor;
	AnimateTimer* timer;
	BackgroundLoader* current;
	BackgroundLoader* old;
	GHashTable* loaders;
	cairo_surface_t* version_logo_surface;
	gint version_logo_width;
	gint version_logo_height;
	cairo_surface_t* background_logo_surface;
	gint background_logo_width;
	gint background_logo_height;
};

typedef enum  {
	BACKGROUND_DRAW_FLAGS_NONE,
	BACKGROUND_DRAW_FLAGS_GRID
} BackgroundDrawFlags;

typedef gdouble (*AnimateTimerEasingFunc) (gdouble x, void* user_data);

static gpointer background_loader_parent_class = NULL;
static gpointer monitor_parent_class = NULL;
static gpointer background_parent_class = NULL;

GType background_loader_get_type (void) G_GNUC_CONST;
#define BACKGROUND_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BACKGROUND_LOADER, BackgroundLoaderPrivate))
enum  {
	BACKGROUND_LOADER_DUMMY_PROPERTY,
	BACKGROUND_LOADER_FILENAME,
	BACKGROUND_LOADER_LOGO
};
#define BACKGROUND_LOADER_QUAD_MAX_LEVEL_OF_RECURSION 16
#define BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION 2
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW 3
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE 1
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE 1
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW 3
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER 2
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_TOTAL ((((BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW + BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE) + BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE) + BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW) + BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER)
BackgroundLoader* background_loader_new (cairo_surface_t* target_surface, const gchar* filename, gint* widths, int widths_length1, gint* heights, int heights_length1, gboolean draw_grid);
BackgroundLoader* background_loader_construct (GType object_type, cairo_surface_t* target_surface, const gchar* filename, gint* widths, int widths_length1, gint* heights, int heights_length1, gboolean draw_grid);
static void background_loader_set_filename (BackgroundLoader* self, const gchar* value);
static gint* _vala_array_dup1 (gint* self, int length);
static gint* _vala_array_dup2 (gint* self, int length);
gboolean background_loader_load (BackgroundLoader* self);
const gchar* background_loader_get_filename (BackgroundLoader* self);
static void* background_loader_load_and_scale (BackgroundLoader* self);
static gpointer _background_loader_load_and_scale_gthread_func (gpointer self);
cairo_pattern_t* background_loader_get_pattern (BackgroundLoader* self, gint width, gint height);
static gboolean background_loader_ready_cb (BackgroundLoader* self);
static cairo_pattern_t* background_loader_create_pattern (BackgroundLoader* self, GdkPixbuf* image);
static void background_loader_pixbuf_average_value (BackgroundLoader* self, GdkPixbuf* pixbuf, GdkRGBA* _result_);
static GdkPixbuf* background_loader_scale (BackgroundLoader* self, GdkPixbuf* image, gint width, gint height);
static gboolean _background_loader_ready_cb_gsource_func (gpointer self);
gint get_grid_offset (gint size);
cairo_surface_t* background_loader_get_logo (BackgroundLoader* self);
#define grid_size 40
static void background_loader_get_pixbuf_sample (BackgroundLoader* self, guint8* pixels, int pixels_length1, gint rowstride, gint channels, gint x, gint y, GdkRGBA* result);
static gboolean background_loader_is_color_different (BackgroundLoader* self, GdkRGBA* color_a, GdkRGBA* color_b);
static void background_loader_get_quad_average (BackgroundLoader* self, gint x, gint y, gint width, gint height, gint level_of_recursion, guint8* pixels, int pixels_length1, gint rowstride, gint channels, GdkRGBA* result);
void background_loader_set_logo (BackgroundLoader* self, cairo_surface_t* value);
static void background_loader_finalize (GObject* obj);
static void _vala_background_loader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_background_loader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer monitor_ref (gpointer instance);
void monitor_unref (gpointer instance);
GParamSpec* param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_monitor (GValue* value, gpointer v_object);
void value_take_monitor (GValue* value, gpointer v_object);
gpointer value_get_monitor (const GValue* value);
GType monitor_get_type (void) G_GNUC_CONST;
enum  {
	MONITOR_DUMMY_PROPERTY
};
Monitor* monitor_new (gint x, gint y, gint width, gint height);
Monitor* monitor_construct (GType object_type, gint x, gint y, gint width, gint height);
static void monitor_finalize (Monitor* obj);
GType background_get_type (void) G_GNUC_CONST;
GType animate_timer_get_type (void) G_GNUC_CONST;
#define BACKGROUND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BACKGROUND, BackgroundPrivate))
enum  {
	BACKGROUND_DUMMY_PROPERTY,
	BACKGROUND_DEFAULT_BACKGROUND,
	BACKGROUND_CURRENT_BACKGROUND,
	BACKGROUND_DRAW_GRID,
	BACKGROUND_ALPHA
};
GType background_draw_flags_get_type (void) G_GNUC_CONST;
gchar* ug_settings_get_string (const gchar* key);
#define UG_SETTINGS_KEY_BACKGROUND_COLOR "background-color"
static void _monitor_unref0_ (gpointer var);
static void _g_list_free__monitor_unref0_ (GList* self);
Background* background_new (cairo_surface_t* target_surface);
Background* background_construct (GType object_type, cairo_surface_t* target_surface);
gdouble animate_timer_ease_in_out (gdouble x);
static gdouble _animate_timer_ease_in_out_animate_timer_easing_func (gdouble x, gpointer self);
AnimateTimer* animate_timer_new (AnimateTimerEasingFunc func, void* func_target, gint speed);
AnimateTimer* animate_timer_construct (GType object_type, AnimateTimerEasingFunc func, void* func_target, gint speed);
static void background_animate_cb (Background* self, gdouble progress);
static void _background_animate_cb_animate_timer_animate (AnimateTimer* _sender, gdouble progress, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void __lambda2_ (Background* self);
static void background_reload (Background* self);
static void ___lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void background_set_logo (Background* self, const gchar* version_logo, const gchar* background_logo);
static cairo_surface_t* background_load_image (Background* self, const gchar* filename, gint* width, gint* height);
void background_set_monitors (Background* self, GList* monitors);
void background_set_active_monitor (Background* self, Monitor* monitor);
static void background_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static BackgroundLoader* background_load_background (Background* self, const gchar* filename);
static gboolean background_real_draw (GtkWidget* base, cairo_t* c);
gboolean background_get_draw_grid (Background* self);
void background_draw_full (Background* self, cairo_t* c, BackgroundDrawFlags flags);
static void background_publish_average_color (Background* self);
gboolean animate_timer_get_is_running (AnimateTimer* self);
static void background_set_alpha (Background* self, gdouble value);
void animate_timer_reset (AnimateTimer* self, gint temp_speed);
gdouble background_get_alpha (Background* self);
static void background_draw_background (Background* self, cairo_t* c, BackgroundLoader* background, gdouble alpha);
static void background_overlay_grid (Background* self, cairo_t* c);
const gchar* background_get_current_background (Background* self);
void animate_timer_stop (AnimateTimer* self);
const gchar* background_get_default_background (Background* self);
static gboolean background_monitor_is_unique_size (Background* self, Monitor* monitor);
static void ___lambda3_ (Background* self);
static void ____lambda3__background_loader_loaded (BackgroundLoader* _sender, gpointer self);
void background_set_default_background (Background* self, const gchar* value);
void background_set_current_background (Background* self, const gchar* value);
void background_set_draw_grid (Background* self, gboolean value);
static void background_finalize (GObject* obj);
static void _vala_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static gint* _vala_array_dup2 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


BackgroundLoader* background_loader_construct (GType object_type, cairo_surface_t* target_surface, const gchar* filename, gint* widths, int widths_length1, gint* heights, int heights_length1, gboolean draw_grid) {
	BackgroundLoader * self = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	const gchar* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint* _tmp7_;
	gint _tmp7__length1;
	cairo_pattern_t** _tmp8_ = NULL;
	gint* _tmp9_;
	gint _tmp9__length1;
	GdkPixbuf** _tmp10_ = NULL;
	gboolean _tmp11_;
	g_return_val_if_fail (target_surface != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (BackgroundLoader*) g_object_new (object_type, NULL);
	_tmp0_ = target_surface;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->target_surface);
	self->priv->target_surface = _tmp1_;
	_tmp2_ = filename;
	background_loader_set_filename (self, _tmp2_);
	_tmp3_ = widths;
	_tmp3__length1 = widths_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	self->widths = (g_free (self->widths), NULL);
	self->widths = _tmp4_;
	self->widths_length1 = _tmp4__length1;
	self->_widths_size_ = self->widths_length1;
	_tmp5_ = heights;
	_tmp5__length1 = heights_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	self->heights = (g_free (self->heights), NULL);
	self->heights = _tmp6_;
	self->heights_length1 = _tmp6__length1;
	self->_heights_size_ = self->heights_length1;
	_tmp7_ = widths;
	_tmp7__length1 = widths_length1;
	_tmp8_ = g_new0 (cairo_pattern_t*, _tmp7__length1 + 1);
	self->patterns = (_vala_array_free (self->patterns, self->patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	self->patterns = _tmp8_;
	self->patterns_length1 = _tmp7__length1;
	self->_patterns_size_ = self->patterns_length1;
	_tmp9_ = widths;
	_tmp9__length1 = widths_length1;
	_tmp10_ = g_new0 (GdkPixbuf*, _tmp9__length1 + 1);
	self->priv->images = (_vala_array_free (self->priv->images, self->priv->images_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->images = _tmp10_;
	self->priv->images_length1 = _tmp9__length1;
	self->priv->_images_size_ = self->priv->images_length1;
	_tmp11_ = draw_grid;
	self->priv->draw_grid = _tmp11_;
	return self;
}


BackgroundLoader* background_loader_new (cairo_surface_t* target_surface, const gchar* filename, gint* widths, int widths_length1, gint* heights, int heights_length1, gboolean draw_grid) {
	return background_loader_construct (TYPE_BACKGROUND_LOADER, target_surface, filename, widths, widths_length1, heights, heights_length1, draw_grid);
}


static gpointer _cairo_pattern_reference0 (gpointer self) {
	return self ? cairo_pattern_reference (self) : NULL;
}


static gpointer _background_loader_load_and_scale_gthread_func (gpointer self) {
	gpointer result;
	result = background_loader_load_and_scale (self);
	return result;
}


gboolean background_loader_load (BackgroundLoader* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GThread* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* text;
	const gchar* _tmp24_;
	GdkRGBA color = {0};
	const gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->finished;
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->thread;
	if (_tmp1_ != NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->widths;
	_tmp2__length1 = self->widths_length1;
	if (_tmp2__length1 == 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->_filename;
	_tmp4_ = self->widths;
	_tmp4__length1 = self->widths_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = self->heights;
	_tmp6__length1 = self->heights_length1;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = g_strdup_printf ("Making background %s at %dx%d", _tmp3_, _tmp5_, _tmp7_);
	text = _tmp8_;
	{
		gint i;
		i = 1;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				gint* _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gint* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint _tmp17_;
				gint* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				gint _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = self->widths;
				_tmp13__length1 = self->widths_length1;
				if (!(_tmp12_ < _tmp13__length1)) {
					break;
				}
				_tmp14_ = text;
				_tmp15_ = self->widths;
				_tmp15__length1 = self->widths_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp18_ = self->heights;
				_tmp18__length1 = self->heights_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp21_ = g_strdup_printf (",%dx%d", _tmp17_, _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strconcat (_tmp14_, _tmp22_, NULL);
				_g_free0 (text);
				text = _tmp23_;
				_g_free0 (_tmp22_);
			}
		}
	}
	_tmp24_ = text;
	g_debug ("background.vala:68: %s", _tmp24_);
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp25_ = self->priv->_filename;
	_tmp26_ = gdk_rgba_parse (&color, _tmp25_);
	if (_tmp26_) {
		GdkRGBA _tmp27_;
		gdouble _tmp28_;
		GdkRGBA _tmp29_;
		gdouble _tmp30_;
		GdkRGBA _tmp31_;
		gdouble _tmp32_;
		GdkRGBA _tmp33_;
		gdouble _tmp34_;
		cairo_pattern_t* _tmp35_;
		cairo_pattern_t* pattern;
		const gchar* _tmp46_;
		_tmp27_ = color;
		_tmp28_ = _tmp27_.red;
		_tmp29_ = color;
		_tmp30_ = _tmp29_.green;
		_tmp31_ = color;
		_tmp32_ = _tmp31_.blue;
		_tmp33_ = color;
		_tmp34_ = _tmp33_.alpha;
		_tmp35_ = cairo_pattern_create_rgba (_tmp28_, _tmp30_, _tmp32_, _tmp34_);
		pattern = _tmp35_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp36_;
				_tmp36_ = TRUE;
				while (TRUE) {
					gboolean _tmp37_;
					gint _tmp39_;
					gint* _tmp40_;
					gint _tmp40__length1;
					cairo_pattern_t** _tmp41_;
					gint _tmp41__length1;
					gint _tmp42_;
					cairo_pattern_t* _tmp43_;
					cairo_pattern_t* _tmp44_;
					cairo_pattern_t* _tmp45_;
					_tmp37_ = _tmp36_;
					if (!_tmp37_) {
						gint _tmp38_;
						_tmp38_ = i;
						i = _tmp38_ + 1;
					}
					_tmp36_ = FALSE;
					_tmp39_ = i;
					_tmp40_ = self->widths;
					_tmp40__length1 = self->widths_length1;
					if (!(_tmp39_ < _tmp40__length1)) {
						break;
					}
					_tmp41_ = self->patterns;
					_tmp41__length1 = self->patterns_length1;
					_tmp42_ = i;
					_tmp43_ = pattern;
					_tmp44_ = _cairo_pattern_reference0 (_tmp43_);
					_cairo_pattern_destroy0 (_tmp41_[_tmp42_]);
					_tmp41_[_tmp42_] = _tmp44_;
					_tmp45_ = _tmp41_[_tmp42_];
				}
			}
		}
		self->priv->finished = TRUE;
		_tmp46_ = self->priv->_filename;
		g_debug ("background.vala:77: Render of background %s complete", _tmp46_);
		result = TRUE;
		_cairo_pattern_destroy0 (pattern);
		_g_free0 (text);
		return result;
	} else {
		{
			GThread* _tmp47_;
			GThread* _tmp48_;
			g_object_ref ((GObject*) self);
			_tmp47_ = g_thread_try_new ("background-loader", _background_loader_load_and_scale_gthread_func, self, &_inner_error_);
			_tmp48_ = _tmp47_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			_g_thread_unref0 (self->priv->thread);
			self->priv->thread = _tmp48_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_object_unref ((GObject*) self);
			self->priv->finished = TRUE;
			result = TRUE;
			_g_error_free0 (e);
			_g_free0 (text);
			return result;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (text);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = FALSE;
	_g_free0 (text);
	return result;
}


cairo_pattern_t* background_loader_get_pattern (BackgroundLoader* self, gint width, gint height) {
	cairo_pattern_t* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint* _tmp4_;
				gint _tmp4__length1;
				gboolean _tmp5_ = FALSE;
				gint* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gboolean _tmp14_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->widths;
				_tmp4__length1 = self->widths_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp6_ = self->widths;
				_tmp6__length1 = self->widths_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				_tmp9_ = width;
				if (_tmp8_ == _tmp9_) {
					gint* _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					_tmp10_ = self->heights;
					_tmp10__length1 = self->heights_length1;
					_tmp11_ = i;
					_tmp12_ = _tmp10_[_tmp11_];
					_tmp13_ = height;
					_tmp5_ = _tmp12_ == _tmp13_;
				} else {
					_tmp5_ = FALSE;
				}
				_tmp14_ = _tmp5_;
				if (_tmp14_) {
					cairo_pattern_t** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					cairo_pattern_t* _tmp17_;
					cairo_pattern_t* _tmp18_;
					_tmp15_ = self->patterns;
					_tmp15__length1 = self->patterns_length1;
					_tmp16_ = i;
					_tmp17_ = _tmp15_[_tmp16_];
					_tmp18_ = _cairo_pattern_reference0 (_tmp17_);
					result = _tmp18_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean background_loader_ready_cb (BackgroundLoader* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GThread* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_filename;
	g_debug ("background.vala:117: Render of background %s complete", _tmp0_);
	_tmp1_ = self->priv->thread;
	g_thread_join (_tmp1_);
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = NULL;
	self->priv->finished = TRUE;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint* _tmp6_;
				gint _tmp6__length1;
				GdkPixbuf** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				GdkPixbuf* _tmp9_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->widths;
				_tmp6__length1 = self->widths_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = self->priv->images;
				_tmp7__length1 = self->priv->images_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				if (_tmp9_ != NULL) {
					cairo_pattern_t** _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					GdkPixbuf** _tmp12_;
					gint _tmp12__length1;
					gint _tmp13_;
					GdkPixbuf* _tmp14_;
					cairo_pattern_t* _tmp15_ = NULL;
					cairo_pattern_t* _tmp16_;
					gint _tmp17_;
					GdkPixbuf** _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					GdkPixbuf* _tmp24_;
					_tmp10_ = self->patterns;
					_tmp10__length1 = self->patterns_length1;
					_tmp11_ = i;
					_tmp12_ = self->priv->images;
					_tmp12__length1 = self->priv->images_length1;
					_tmp13_ = i;
					_tmp14_ = _tmp12_[_tmp13_];
					_tmp15_ = background_loader_create_pattern (self, _tmp14_);
					_cairo_pattern_destroy0 (_tmp10_[_tmp11_]);
					_tmp10_[_tmp11_] = _tmp15_;
					_tmp16_ = _tmp10_[_tmp11_];
					_tmp17_ = i;
					if (_tmp17_ == 0) {
						GdkPixbuf** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						GdkPixbuf* _tmp20_;
						GdkRGBA _tmp21_ = {0};
						_tmp18_ = self->priv->images;
						_tmp18__length1 = self->priv->images_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						background_loader_pixbuf_average_value (self, _tmp20_, &_tmp21_);
						self->average_color = _tmp21_;
					}
					_tmp22_ = self->priv->images;
					_tmp22__length1 = self->priv->images_length1;
					_tmp23_ = i;
					_g_object_unref0 (_tmp22_[_tmp23_]);
					_tmp22_[_tmp23_] = NULL;
					_tmp24_ = _tmp22_[_tmp23_];
				} else {
					gint _tmp25_;
					const gchar* _tmp26_;
					cairo_pattern_t** _tmp27_;
					gint _tmp27__length1;
					gint _tmp28_;
					cairo_pattern_t* _tmp29_;
					_tmp25_ = i;
					_tmp26_ = self->priv->_filename;
					g_debug ("background.vala:134: images[%d] was null for %s", _tmp25_, _tmp26_);
					_tmp27_ = self->patterns;
					_tmp27__length1 = self->patterns_length1;
					_tmp28_ = i;
					_cairo_pattern_destroy0 (_tmp27_[_tmp28_]);
					_tmp27_[_tmp28_] = NULL;
					_tmp29_ = _tmp27_[_tmp28_];
				}
			}
		}
	}
	g_signal_emit_by_name (self, "loaded");
	g_object_unref ((GObject*) self);
	result = FALSE;
	return result;
}


static gboolean _background_loader_ready_cb_gsource_func (gpointer self) {
	gboolean result;
	result = background_loader_ready_cb (self);
	return result;
}


static void* background_loader_load_and_scale (BackgroundLoader* self) {
	void* result = NULL;
	guint _tmp20_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		const gchar* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* image;
		_tmp0_ = self->priv->_filename;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		image = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					gboolean _tmp3_;
					gint _tmp5_;
					gint* _tmp6_;
					gint _tmp6__length1;
					GdkPixbuf** _tmp7_;
					gint _tmp7__length1;
					gint _tmp8_;
					GdkPixbuf* _tmp9_;
					gint* _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					gint _tmp12_;
					gint* _tmp13_;
					gint _tmp13__length1;
					gint _tmp14_;
					gint _tmp15_;
					GdkPixbuf* _tmp16_ = NULL;
					GdkPixbuf* _tmp17_;
					_tmp3_ = _tmp2_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp5_ = i;
					_tmp6_ = self->widths;
					_tmp6__length1 = self->widths_length1;
					if (!(_tmp5_ < _tmp6__length1)) {
						break;
					}
					_tmp7_ = self->priv->images;
					_tmp7__length1 = self->priv->images_length1;
					_tmp8_ = i;
					_tmp9_ = image;
					_tmp10_ = self->widths;
					_tmp10__length1 = self->widths_length1;
					_tmp11_ = i;
					_tmp12_ = _tmp10_[_tmp11_];
					_tmp13_ = self->heights;
					_tmp13__length1 = self->heights_length1;
					_tmp14_ = i;
					_tmp15_ = _tmp13_[_tmp14_];
					_tmp16_ = background_loader_scale (self, _tmp9_, _tmp12_, _tmp15_);
					_g_object_unref0 (_tmp7_[_tmp8_]);
					_tmp7_[_tmp8_] = _tmp16_;
					_tmp17_ = _tmp7_[_tmp8_];
				}
			}
		}
		_g_object_unref0 (image);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_debug ("background.vala:155: Error loading background: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp20_ = gdk_threads_add_idle (_background_loader_ready_cb_gsource_func, self);
	self->priv->ready_id = _tmp20_;
	result = NULL;
	return result;
}


static GdkPixbuf* background_loader_scale (BackgroundLoader* self, GdkPixbuf* image, gint width, gint height) {
	GdkPixbuf* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gdouble target_aspect;
	GdkPixbuf* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GdkPixbuf* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gdouble aspect;
	gdouble scale = 0.0;
	gdouble offset_x;
	gdouble offset_y;
	gdouble _tmp8_;
	gdouble _tmp9_;
	GdkPixbuf* _tmp28_;
	GdkColorspace _tmp29_;
	GdkColorspace _tmp30_;
	GdkPixbuf* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	GdkPixbuf* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GdkPixbuf* _tmp39_;
	GdkPixbuf* scaled_image;
	GdkPixbuf* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	target_aspect = ((gdouble) _tmp0_) / _tmp1_;
	_tmp2_ = image;
	_tmp3_ = gdk_pixbuf_get_width (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = image;
	_tmp6_ = gdk_pixbuf_get_height (_tmp5_);
	_tmp7_ = _tmp6_;
	aspect = ((gdouble) _tmp4_) / _tmp7_;
	offset_x = (gdouble) 0;
	offset_y = (gdouble) 0;
	_tmp8_ = aspect;
	_tmp9_ = target_aspect;
	if (_tmp8_ > _tmp9_) {
		gint _tmp10_;
		GdkPixbuf* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GdkPixbuf* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gdouble _tmp17_;
		gint _tmp18_;
		_tmp10_ = height;
		_tmp11_ = image;
		_tmp12_ = gdk_pixbuf_get_height (_tmp11_);
		_tmp13_ = _tmp12_;
		scale = ((gdouble) _tmp10_) / _tmp13_;
		_tmp14_ = image;
		_tmp15_ = gdk_pixbuf_get_width (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = scale;
		_tmp18_ = width;
		offset_x = ((_tmp16_ * _tmp17_) - _tmp18_) / 2;
	} else {
		gint _tmp19_;
		GdkPixbuf* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		GdkPixbuf* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gdouble _tmp26_;
		gint _tmp27_;
		_tmp19_ = width;
		_tmp20_ = image;
		_tmp21_ = gdk_pixbuf_get_width (_tmp20_);
		_tmp22_ = _tmp21_;
		scale = ((gdouble) _tmp19_) / _tmp22_;
		_tmp23_ = image;
		_tmp24_ = gdk_pixbuf_get_height (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = scale;
		_tmp27_ = height;
		offset_y = ((_tmp25_ * _tmp26_) - _tmp27_) / 2;
	}
	_tmp28_ = image;
	_tmp29_ = gdk_pixbuf_get_colorspace (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = image;
	_tmp32_ = gdk_pixbuf_get_has_alpha (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = image;
	_tmp35_ = gdk_pixbuf_get_bits_per_sample (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = width;
	_tmp38_ = height;
	_tmp39_ = gdk_pixbuf_new (_tmp30_, _tmp33_, _tmp36_, _tmp37_, _tmp38_);
	scaled_image = _tmp39_;
	_tmp40_ = image;
	_tmp41_ = width;
	_tmp42_ = height;
	_tmp43_ = offset_x;
	_tmp44_ = offset_y;
	_tmp45_ = scale;
	_tmp46_ = scale;
	gdk_pixbuf_scale (_tmp40_, scaled_image, 0, 0, _tmp41_, _tmp42_, -_tmp43_, -_tmp44_, _tmp45_, _tmp46_, GDK_INTERP_BILINEAR);
	result = scaled_image;
	return result;
}


static cairo_pattern_t* background_loader_create_pattern (BackgroundLoader* self, GdkPixbuf* image) {
	cairo_pattern_t* result = NULL;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint grid_x_offset;
	GdkPixbuf* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	gint grid_y_offset;
	cairo_surface_t* _tmp8_;
	GdkPixbuf* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GdkPixbuf* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_surface_t* surface;
	cairo_surface_t* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* bc;
	cairo_t* _tmp18_;
	GdkPixbuf* _tmp19_;
	cairo_t* _tmp20_;
	cairo_surface_t* _tmp21_;
	cairo_surface_t* _tmp34_;
	cairo_pattern_t* _tmp35_;
	cairo_pattern_t* pattern;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (image != NULL, NULL);
	_tmp0_ = image;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = get_grid_offset (_tmp2_);
	grid_x_offset = _tmp3_;
	_tmp4_ = image;
	_tmp5_ = gdk_pixbuf_get_height (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = get_grid_offset (_tmp6_);
	grid_y_offset = _tmp7_;
	_tmp8_ = self->priv->target_surface;
	_tmp9_ = image;
	_tmp10_ = gdk_pixbuf_get_width (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = image;
	_tmp13_ = gdk_pixbuf_get_height (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR, _tmp11_, _tmp14_);
	surface = _tmp15_;
	_tmp16_ = surface;
	_tmp17_ = cairo_create (_tmp16_);
	bc = _tmp17_;
	_tmp18_ = bc;
	_tmp19_ = image;
	gdk_cairo_set_source_pixbuf (_tmp18_, _tmp19_, (gdouble) 0, (gdouble) 0);
	_tmp20_ = bc;
	cairo_paint (_tmp20_);
	_tmp21_ = self->priv->_logo;
	if (_tmp21_ != NULL) {
		cairo_t* _tmp22_;
		GdkPixbuf* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint y;
		cairo_t* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		cairo_t* _tmp30_;
		cairo_surface_t* _tmp31_;
		cairo_t* _tmp32_;
		cairo_t* _tmp33_;
		_tmp22_ = bc;
		cairo_save (_tmp22_);
		_tmp23_ = image;
		_tmp24_ = gdk_pixbuf_get_height (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = grid_y_offset;
		y = (((gint) ((_tmp25_ / grid_size) - 2)) * grid_size) + _tmp26_;
		_tmp27_ = bc;
		_tmp28_ = grid_x_offset;
		_tmp29_ = y;
		cairo_translate (_tmp27_, (gdouble) _tmp28_, (gdouble) _tmp29_);
		_tmp30_ = bc;
		_tmp31_ = self->priv->_logo;
		cairo_set_source_surface (_tmp30_, _tmp31_, (gdouble) 0, (gdouble) 0);
		_tmp32_ = bc;
		cairo_paint_with_alpha (_tmp32_, 0.5);
		_tmp33_ = bc;
		cairo_restore (_tmp33_);
	}
	_tmp34_ = surface;
	_tmp35_ = cairo_pattern_create_for_surface (_tmp34_);
	pattern = _tmp35_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_cairo_destroy0 (bc);
	_cairo_surface_destroy0 (surface);
	return result;
}


static void background_loader_get_pixbuf_sample (BackgroundLoader* self, guint8* pixels, int pixels_length1, gint rowstride, gint channels, gint x, gint y, GdkRGBA* result) {
	GdkRGBA sample = {0};
	gdouble dd;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint offset;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	guint8 _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	guint8 _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	guint8 _tmp12_;
	g_return_if_fail (self != NULL);
	memset (&sample, 0, sizeof (GdkRGBA));
	dd = (gdouble) 0xFF;
	_tmp0_ = y;
	_tmp1_ = rowstride;
	_tmp2_ = x;
	_tmp3_ = channels;
	offset = (_tmp0_ * _tmp1_) + (_tmp2_ * _tmp3_);
	_tmp4_ = pixels;
	_tmp4__length1 = pixels_length1;
	_tmp5_ = offset;
	offset = _tmp5_ + 1;
	_tmp6_ = _tmp4_[_tmp5_];
	sample.red = _tmp6_ / dd;
	_tmp7_ = pixels;
	_tmp7__length1 = pixels_length1;
	_tmp8_ = offset;
	offset = _tmp8_ + 1;
	_tmp9_ = _tmp7_[_tmp8_];
	sample.green = _tmp9_ / dd;
	_tmp10_ = pixels;
	_tmp10__length1 = pixels_length1;
	_tmp11_ = offset;
	offset = _tmp11_ + 1;
	_tmp12_ = _tmp10_[_tmp11_];
	sample.blue = _tmp12_ / dd;
	sample.alpha = (gdouble) 1.0f;
	*result = sample;
	return;
}


static gboolean background_loader_is_color_different (BackgroundLoader* self, GdkRGBA* color_a, GdkRGBA* color_b) {
	gboolean result = FALSE;
	GdkRGBA diff = {0};
	GdkRGBA _tmp0_;
	gdouble _tmp1_;
	GdkRGBA _tmp2_;
	gdouble _tmp3_;
	GdkRGBA _tmp4_;
	gdouble _tmp5_;
	GdkRGBA _tmp6_;
	gdouble _tmp7_;
	GdkRGBA _tmp8_;
	gdouble _tmp9_;
	GdkRGBA _tmp10_;
	gdouble _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GdkRGBA _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_ = 0.0;
	gboolean _tmp20_;
	gboolean _tmp24_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (color_a != NULL, FALSE);
	g_return_val_if_fail (color_b != NULL, FALSE);
	memset (&diff, 0, sizeof (GdkRGBA));
	_tmp0_ = *color_a;
	_tmp1_ = _tmp0_.red;
	_tmp2_ = *color_b;
	_tmp3_ = _tmp2_.red;
	diff.red = _tmp1_ - _tmp3_;
	_tmp4_ = *color_a;
	_tmp5_ = _tmp4_.green;
	_tmp6_ = *color_b;
	_tmp7_ = _tmp6_.green;
	diff.green = _tmp5_ - _tmp7_;
	_tmp8_ = *color_a;
	_tmp9_ = _tmp8_.blue;
	_tmp10_ = *color_b;
	_tmp11_ = _tmp10_.blue;
	diff.blue = _tmp9_ - _tmp11_;
	diff.alpha = (gdouble) 1.0f;
	_tmp14_ = diff;
	_tmp15_ = _tmp14_.red;
	_tmp16_ = fabs (_tmp15_);
	if (_tmp16_ > 0.15) {
		_tmp13_ = TRUE;
	} else {
		GdkRGBA _tmp17_;
		gdouble _tmp18_;
		gdouble _tmp19_ = 0.0;
		_tmp17_ = diff;
		_tmp18_ = _tmp17_.green;
		_tmp19_ = fabs (_tmp18_);
		_tmp13_ = _tmp19_ > 0.15;
	}
	_tmp20_ = _tmp13_;
	if (_tmp20_) {
		_tmp12_ = TRUE;
	} else {
		GdkRGBA _tmp21_;
		gdouble _tmp22_;
		gdouble _tmp23_ = 0.0;
		_tmp21_ = diff;
		_tmp22_ = _tmp21_.blue;
		_tmp23_ = fabs (_tmp22_);
		_tmp12_ = _tmp23_ > 0.15;
	}
	_tmp24_ = _tmp12_;
	if (_tmp24_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void background_loader_get_quad_average (BackgroundLoader* self, gint x, gint y, gint width, gint height, gint level_of_recursion, guint8* pixels, int pixels_length1, gint rowstride, gint channels, GdkRGBA* result) {
	GdkRGBA average = {0};
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GdkRGBA _tmp5_ = {0};
	GdkRGBA corner1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GdkRGBA _tmp12_ = {0};
	GdkRGBA corner2;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GdkRGBA _tmp19_ = {0};
	GdkRGBA corner3;
	guint8* _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GdkRGBA _tmp27_ = {0};
	GdkRGBA corner4;
	guint8* _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GdkRGBA _tmp35_ = {0};
	GdkRGBA centre;
	gint _tmp36_;
	GdkRGBA _tmp101_;
	gdouble _tmp102_;
	GdkRGBA _tmp103_;
	gdouble _tmp104_;
	GdkRGBA _tmp105_;
	gdouble _tmp106_;
	GdkRGBA _tmp107_;
	gdouble _tmp108_;
	GdkRGBA _tmp109_;
	gdouble _tmp110_;
	GdkRGBA _tmp111_;
	gdouble _tmp112_;
	GdkRGBA _tmp113_;
	gdouble _tmp114_;
	GdkRGBA _tmp115_;
	gdouble _tmp116_;
	GdkRGBA _tmp117_;
	gdouble _tmp118_;
	GdkRGBA _tmp119_;
	gdouble _tmp120_;
	GdkRGBA _tmp121_;
	gdouble _tmp122_;
	GdkRGBA _tmp123_;
	gdouble _tmp124_;
	GdkRGBA _tmp125_;
	gdouble _tmp126_;
	GdkRGBA _tmp127_;
	gdouble _tmp128_;
	GdkRGBA _tmp129_;
	gdouble _tmp130_;
	g_return_if_fail (self != NULL);
	memset (&average, 0, sizeof (GdkRGBA));
	_tmp0_ = pixels;
	_tmp0__length1 = pixels_length1;
	_tmp1_ = rowstride;
	_tmp2_ = channels;
	_tmp3_ = x;
	_tmp4_ = y;
	background_loader_get_pixbuf_sample (self, _tmp0_, _tmp0__length1, _tmp1_, _tmp2_, _tmp3_, _tmp4_, &_tmp5_);
	corner1 = _tmp5_;
	_tmp6_ = pixels;
	_tmp6__length1 = pixels_length1;
	_tmp7_ = rowstride;
	_tmp8_ = channels;
	_tmp9_ = x;
	_tmp10_ = width;
	_tmp11_ = y;
	background_loader_get_pixbuf_sample (self, _tmp6_, _tmp6__length1, _tmp7_, _tmp8_, _tmp9_ + _tmp10_, _tmp11_, &_tmp12_);
	corner2 = _tmp12_;
	_tmp13_ = pixels;
	_tmp13__length1 = pixels_length1;
	_tmp14_ = rowstride;
	_tmp15_ = channels;
	_tmp16_ = x;
	_tmp17_ = y;
	_tmp18_ = height;
	background_loader_get_pixbuf_sample (self, _tmp13_, _tmp13__length1, _tmp14_, _tmp15_, _tmp16_, _tmp17_ + _tmp18_, &_tmp19_);
	corner3 = _tmp19_;
	_tmp20_ = pixels;
	_tmp20__length1 = pixels_length1;
	_tmp21_ = rowstride;
	_tmp22_ = channels;
	_tmp23_ = x;
	_tmp24_ = width;
	_tmp25_ = y;
	_tmp26_ = height;
	background_loader_get_pixbuf_sample (self, _tmp20_, _tmp20__length1, _tmp21_, _tmp22_, _tmp23_ + _tmp24_, _tmp25_ + _tmp26_, &_tmp27_);
	corner4 = _tmp27_;
	_tmp28_ = pixels;
	_tmp28__length1 = pixels_length1;
	_tmp29_ = rowstride;
	_tmp30_ = channels;
	_tmp31_ = x;
	_tmp32_ = width;
	_tmp33_ = y;
	_tmp34_ = height;
	background_loader_get_pixbuf_sample (self, _tmp28_, _tmp28__length1, _tmp29_, _tmp30_, _tmp31_ + (_tmp32_ / 2), _tmp33_ + (_tmp34_ / 2), &_tmp35_);
	centre = _tmp35_;
	_tmp36_ = level_of_recursion;
	if (_tmp36_ < BACKGROUND_LOADER_QUAD_MAX_LEVEL_OF_RECURSION) {
		gboolean _tmp37_ = FALSE;
		gint _tmp38_;
		gboolean _tmp42_;
		gboolean _tmp52_ = FALSE;
		gint _tmp53_;
		gboolean _tmp57_;
		gboolean _tmp68_ = FALSE;
		gint _tmp69_;
		gboolean _tmp73_;
		gboolean _tmp84_ = FALSE;
		gint _tmp85_;
		gboolean _tmp89_;
		_tmp38_ = level_of_recursion;
		if (_tmp38_ < BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION) {
			_tmp37_ = TRUE;
		} else {
			GdkRGBA _tmp39_;
			GdkRGBA _tmp40_;
			gboolean _tmp41_ = FALSE;
			_tmp39_ = corner1;
			_tmp40_ = centre;
			_tmp41_ = background_loader_is_color_different (self, &_tmp39_, &_tmp40_);
			_tmp37_ = _tmp41_;
		}
		_tmp42_ = _tmp37_;
		if (_tmp42_) {
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			guint8* _tmp48_;
			gint _tmp48__length1;
			gint _tmp49_;
			gint _tmp50_;
			GdkRGBA _tmp51_ = {0};
			_tmp43_ = x;
			_tmp44_ = y;
			_tmp45_ = width;
			_tmp46_ = height;
			_tmp47_ = level_of_recursion;
			_tmp48_ = pixels;
			_tmp48__length1 = pixels_length1;
			_tmp49_ = rowstride;
			_tmp50_ = channels;
			background_loader_get_quad_average (self, _tmp43_, _tmp44_, _tmp45_ / 2, _tmp46_ / 2, _tmp47_ + 1, _tmp48_, _tmp48__length1, _tmp49_, _tmp50_, &_tmp51_);
			corner1 = _tmp51_;
		}
		_tmp53_ = level_of_recursion;
		if (_tmp53_ < BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION) {
			_tmp52_ = TRUE;
		} else {
			GdkRGBA _tmp54_;
			GdkRGBA _tmp55_;
			gboolean _tmp56_ = FALSE;
			_tmp54_ = corner2;
			_tmp55_ = centre;
			_tmp56_ = background_loader_is_color_different (self, &_tmp54_, &_tmp55_);
			_tmp52_ = _tmp56_;
		}
		_tmp57_ = _tmp52_;
		if (_tmp57_) {
			gint _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			guint8* _tmp64_;
			gint _tmp64__length1;
			gint _tmp65_;
			gint _tmp66_;
			GdkRGBA _tmp67_ = {0};
			_tmp58_ = x;
			_tmp59_ = width;
			_tmp60_ = y;
			_tmp61_ = width;
			_tmp62_ = height;
			_tmp63_ = level_of_recursion;
			_tmp64_ = pixels;
			_tmp64__length1 = pixels_length1;
			_tmp65_ = rowstride;
			_tmp66_ = channels;
			background_loader_get_quad_average (self, _tmp58_ + (_tmp59_ / 2), _tmp60_, _tmp61_ / 2, _tmp62_ / 2, _tmp63_ + 1, _tmp64_, _tmp64__length1, _tmp65_, _tmp66_, &_tmp67_);
			corner2 = _tmp67_;
		}
		_tmp69_ = level_of_recursion;
		if (_tmp69_ < BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION) {
			_tmp68_ = TRUE;
		} else {
			GdkRGBA _tmp70_;
			GdkRGBA _tmp71_;
			gboolean _tmp72_ = FALSE;
			_tmp70_ = corner3;
			_tmp71_ = centre;
			_tmp72_ = background_loader_is_color_different (self, &_tmp70_, &_tmp71_);
			_tmp68_ = _tmp72_;
		}
		_tmp73_ = _tmp68_;
		if (_tmp73_) {
			gint _tmp74_;
			gint _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			guint8* _tmp80_;
			gint _tmp80__length1;
			gint _tmp81_;
			gint _tmp82_;
			GdkRGBA _tmp83_ = {0};
			_tmp74_ = x;
			_tmp75_ = y;
			_tmp76_ = height;
			_tmp77_ = width;
			_tmp78_ = height;
			_tmp79_ = level_of_recursion;
			_tmp80_ = pixels;
			_tmp80__length1 = pixels_length1;
			_tmp81_ = rowstride;
			_tmp82_ = channels;
			background_loader_get_quad_average (self, _tmp74_, _tmp75_ + (_tmp76_ / 2), _tmp77_ / 2, _tmp78_ / 2, _tmp79_ + 1, _tmp80_, _tmp80__length1, _tmp81_, _tmp82_, &_tmp83_);
			corner3 = _tmp83_;
		}
		_tmp85_ = level_of_recursion;
		if (_tmp85_ < BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION) {
			_tmp84_ = TRUE;
		} else {
			GdkRGBA _tmp86_;
			GdkRGBA _tmp87_;
			gboolean _tmp88_ = FALSE;
			_tmp86_ = corner4;
			_tmp87_ = centre;
			_tmp88_ = background_loader_is_color_different (self, &_tmp86_, &_tmp87_);
			_tmp84_ = _tmp88_;
		}
		_tmp89_ = _tmp84_;
		if (_tmp89_) {
			gint _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			guint8* _tmp97_;
			gint _tmp97__length1;
			gint _tmp98_;
			gint _tmp99_;
			GdkRGBA _tmp100_ = {0};
			_tmp90_ = x;
			_tmp91_ = width;
			_tmp92_ = y;
			_tmp93_ = height;
			_tmp94_ = width;
			_tmp95_ = height;
			_tmp96_ = level_of_recursion;
			_tmp97_ = pixels;
			_tmp97__length1 = pixels_length1;
			_tmp98_ = rowstride;
			_tmp99_ = channels;
			background_loader_get_quad_average (self, _tmp90_ + (_tmp91_ / 2), _tmp92_ + (_tmp93_ / 2), _tmp94_ / 2, _tmp95_ / 2, _tmp96_ + 1, _tmp97_, _tmp97__length1, _tmp98_, _tmp99_, &_tmp100_);
			corner4 = _tmp100_;
		}
	}
	_tmp101_ = corner1;
	_tmp102_ = _tmp101_.red;
	_tmp103_ = corner3;
	_tmp104_ = _tmp103_.red;
	_tmp105_ = centre;
	_tmp106_ = _tmp105_.red;
	_tmp107_ = corner2;
	_tmp108_ = _tmp107_.red;
	_tmp109_ = corner4;
	_tmp110_ = _tmp109_.red;
	average.red = (((((_tmp102_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW) + (_tmp104_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW)) + (_tmp106_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER)) + (_tmp108_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE)) + (_tmp110_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE)) / BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_TOTAL;
	_tmp111_ = corner1;
	_tmp112_ = _tmp111_.green;
	_tmp113_ = corner3;
	_tmp114_ = _tmp113_.green;
	_tmp115_ = centre;
	_tmp116_ = _tmp115_.green;
	_tmp117_ = corner2;
	_tmp118_ = _tmp117_.green;
	_tmp119_ = corner4;
	_tmp120_ = _tmp119_.green;
	average.green = (((((_tmp112_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW) + (_tmp114_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW)) + (_tmp116_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER)) + (_tmp118_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE)) + (_tmp120_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE)) / BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_TOTAL;
	_tmp121_ = corner1;
	_tmp122_ = _tmp121_.blue;
	_tmp123_ = corner3;
	_tmp124_ = _tmp123_.blue;
	_tmp125_ = centre;
	_tmp126_ = _tmp125_.blue;
	_tmp127_ = corner2;
	_tmp128_ = _tmp127_.blue;
	_tmp129_ = corner4;
	_tmp130_ = _tmp129_.blue;
	average.blue = (((((_tmp122_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW) + (_tmp124_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW)) + (_tmp126_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER)) + (_tmp128_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE)) + (_tmp130_ * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE)) / BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_TOTAL;
	average.alpha = (gdouble) 1.0f;
	*result = average;
	return;
}


static void background_loader_pixbuf_average_value (BackgroundLoader* self, GdkPixbuf* pixbuf, GdkRGBA* _result_) {
	GdkRGBA _vala_result = {0};
	GdkPixbuf* _tmp0_;
	gint _tmp1_ = 0;
	GdkPixbuf* _tmp2_;
	gint _tmp3_ = 0;
	GdkPixbuf* _tmp4_;
	guint8* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_;
	gint _tmp7_ = 0;
	GdkPixbuf* _tmp8_;
	gint _tmp9_ = 0;
	GdkRGBA _tmp10_ = {0};
	GdkRGBA average;
	GdkRGBA _tmp11_;
	gdouble _tmp12_;
	GdkRGBA _tmp13_;
	gdouble _tmp14_;
	GdkRGBA _tmp15_;
	gdouble _tmp16_;
	GdkRGBA _tmp17_;
	gdouble _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	_tmp2_ = pixbuf;
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
	_tmp4_ = pixbuf;
	_tmp5_ = gdk_pixbuf_get_pixels (_tmp4_);
	_tmp6_ = pixbuf;
	_tmp7_ = gdk_pixbuf_get_rowstride (_tmp6_);
	_tmp8_ = pixbuf;
	_tmp9_ = gdk_pixbuf_get_n_channels (_tmp8_);
	background_loader_get_quad_average (self, 0, 0, _tmp1_ - 1, _tmp3_ - 1, 1, _tmp5_, -1, _tmp7_, _tmp9_, &_tmp10_);
	average = _tmp10_;
	memset (&_vala_result, 0, sizeof (GdkRGBA));
	_tmp11_ = average;
	_tmp12_ = _tmp11_.red;
	_vala_result.red = _tmp12_;
	_tmp13_ = average;
	_tmp14_ = _tmp13_.green;
	_vala_result.green = _tmp14_;
	_tmp15_ = average;
	_tmp16_ = _tmp15_.blue;
	_vala_result.blue = _tmp16_;
	_tmp17_ = average;
	_tmp18_ = _tmp17_.alpha;
	_vala_result.alpha = _tmp18_;
	if (_result_) {
		*_result_ = _vala_result;
	}
}


const gchar* background_loader_get_filename (BackgroundLoader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void background_loader_set_filename (BackgroundLoader* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	g_object_notify ((GObject *) self, "filename");
}


cairo_surface_t* background_loader_get_logo (BackgroundLoader* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_logo;
	result = _tmp0_;
	return result;
}


void background_loader_set_logo (BackgroundLoader* self, cairo_surface_t* value) {
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->_logo);
	self->priv->_logo = _tmp1_;
	g_object_notify ((GObject *) self, "logo");
}


static void background_loader_class_init (BackgroundLoaderClass * klass) {
	background_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BackgroundLoaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_background_loader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_background_loader_set_property;
	G_OBJECT_CLASS (klass)->finalize = background_loader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_LOADER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_LOADER_LOGO, g_param_spec_pointer ("logo", "logo", "logo", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("loaded", TYPE_BACKGROUND_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void background_loader_instance_init (BackgroundLoader * self) {
	self->priv = BACKGROUND_LOADER_GET_PRIVATE (self);
}


static void background_loader_finalize (GObject* obj) {
	BackgroundLoader * self;
	guint _tmp0_;
	self = BACKGROUND_LOADER (obj);
	_tmp0_ = self->priv->ready_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->ready_id;
		g_source_remove (_tmp1_);
	}
	self->priv->ready_id = (guint) 0;
	_g_free0 (self->priv->_filename);
	_cairo_surface_destroy0 (self->priv->_logo);
	self->widths = (g_free (self->widths), NULL);
	self->heights = (g_free (self->heights), NULL);
	self->patterns = (_vala_array_free (self->patterns, self->patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	_cairo_surface_destroy0 (self->priv->target_surface);
	_g_thread_unref0 (self->priv->thread);
	self->priv->images = (_vala_array_free (self->priv->images, self->priv->images_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (background_loader_parent_class)->finalize (obj);
}


GType background_loader_get_type (void) {
	static volatile gsize background_loader_type_id__volatile = 0;
	if (g_once_init_enter (&background_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BackgroundLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundLoader), 0, (GInstanceInitFunc) background_loader_instance_init, NULL };
		GType background_loader_type_id;
		background_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "BackgroundLoader", &g_define_type_info, 0);
		g_once_init_leave (&background_loader_type_id__volatile, background_loader_type_id);
	}
	return background_loader_type_id__volatile;
}


static void _vala_background_loader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BackgroundLoader * self;
	self = BACKGROUND_LOADER (object);
	switch (property_id) {
		case BACKGROUND_LOADER_FILENAME:
		g_value_set_string (value, background_loader_get_filename (self));
		break;
		case BACKGROUND_LOADER_LOGO:
		g_value_set_pointer (value, background_loader_get_logo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_background_loader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BackgroundLoader * self;
	self = BACKGROUND_LOADER (object);
	switch (property_id) {
		case BACKGROUND_LOADER_FILENAME:
		background_loader_set_filename (self, g_value_get_string (value));
		break;
		case BACKGROUND_LOADER_LOGO:
		background_loader_set_logo (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Monitor* monitor_construct (GType object_type, gint x, gint y, gint width, gint height) {
	Monitor* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (Monitor*) g_type_create_instance (object_type);
	_tmp0_ = x;
	self->x = _tmp0_;
	_tmp1_ = y;
	self->y = _tmp1_;
	_tmp2_ = width;
	self->width = _tmp2_;
	_tmp3_ = height;
	self->height = _tmp3_;
	return self;
}


Monitor* monitor_new (gint x, gint y, gint width, gint height) {
	return monitor_construct (TYPE_MONITOR, x, y, width, height);
}


static void value_monitor_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_monitor_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		monitor_unref (value->data[0].v_pointer);
	}
}


static void value_monitor_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_monitor_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_monitor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Monitor* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_monitor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Monitor** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_monitor (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITOR), NULL);
	return value->data[0].v_pointer;
}


void value_set_monitor (GValue* value, gpointer v_object) {
	Monitor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		monitor_unref (old);
	}
}


void value_take_monitor (GValue* value, gpointer v_object) {
	Monitor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		monitor_unref (old);
	}
}


static void monitor_class_init (MonitorClass * klass) {
	monitor_parent_class = g_type_class_peek_parent (klass);
	MONITOR_CLASS (klass)->finalize = monitor_finalize;
}


static void monitor_instance_init (Monitor * self) {
	self->ref_count = 1;
}


static void monitor_finalize (Monitor* obj) {
	Monitor * self;
	self = MONITOR (obj);
}


GType monitor_get_type (void) {
	static volatile gsize monitor_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_monitor_init, value_monitor_free_value, value_monitor_copy_value, value_monitor_peek_pointer, "p", value_monitor_collect_value, "p", value_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Monitor), 0, (GInstanceInitFunc) monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType monitor_type_id;
		monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Monitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&monitor_type_id__volatile, monitor_type_id);
	}
	return monitor_type_id__volatile;
}


gpointer monitor_ref (gpointer instance) {
	Monitor* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void monitor_unref (gpointer instance) {
	Monitor* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType background_draw_flags_get_type (void) {
	static volatile gsize background_draw_flags_type_id__volatile = 0;
	if (g_once_init_enter (&background_draw_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{BACKGROUND_DRAW_FLAGS_NONE, "BACKGROUND_DRAW_FLAGS_NONE", "none"}, {BACKGROUND_DRAW_FLAGS_GRID, "BACKGROUND_DRAW_FLAGS_GRID", "grid"}, {0, NULL, NULL}};
		GType background_draw_flags_type_id;
		background_draw_flags_type_id = g_enum_register_static ("BackgroundDrawFlags", values);
		g_once_init_leave (&background_draw_flags_type_id__volatile, background_draw_flags_type_id);
	}
	return background_draw_flags_type_id__volatile;
}


static void _monitor_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (monitor_unref (var), NULL));
}


static void _g_list_free__monitor_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _monitor_unref0_, NULL);
	g_list_free (self);
}


static gdouble _animate_timer_ease_in_out_animate_timer_easing_func (gdouble x, gpointer self) {
	gdouble result;
	result = animate_timer_ease_in_out (x);
	return result;
}


static void _background_animate_cb_animate_timer_animate (AnimateTimer* _sender, gdouble progress, gpointer self) {
	background_animate_cb (self, progress);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void __lambda2_ (Background* self) {
	background_reload (self);
}


static void ___lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda2_ (self);
}


Background* background_construct (GType object_type, cairo_surface_t* target_surface) {
	Background * self = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	AnimateTimer* _tmp2_;
	AnimateTimer* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	g_return_val_if_fail (target_surface != NULL, NULL);
	self = (Background*) g_object_new (object_type, NULL);
	_tmp0_ = target_surface;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->target_surface);
	self->priv->target_surface = _tmp1_;
	_tmp2_ = animate_timer_new (_animate_timer_ease_in_out_animate_timer_easing_func, NULL, 700);
	_g_object_unref0 (self->priv->timer);
	self->priv->timer = _tmp2_;
	_tmp3_ = self->priv->timer;
	g_signal_connect_object (_tmp3_, "animate", (GCallback) _background_animate_cb_animate_timer_animate, self, 0);
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->loaders);
	self->priv->loaders = _tmp6_;
	g_signal_connect_object ((GObject*) self, "notify::current-background", (GCallback) ___lambda2__g_object_notify, self, 0);
	return self;
}


Background* background_new (cairo_surface_t* target_surface) {
	return background_construct (TYPE_BACKGROUND, target_surface);
}


void background_set_logo (Background* self, const gchar* version_logo, const gchar* background_logo) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	cairo_surface_t* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	cairo_surface_t* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (version_logo != NULL);
	g_return_if_fail (background_logo != NULL);
	_tmp0_ = version_logo;
	_tmp3_ = background_load_image (self, _tmp0_, &_tmp1_, &_tmp2_);
	self->priv->version_logo_width = _tmp1_;
	self->priv->version_logo_height = _tmp2_;
	_cairo_surface_destroy0 (self->priv->version_logo_surface);
	self->priv->version_logo_surface = _tmp3_;
	_tmp4_ = background_logo;
	_tmp7_ = background_load_image (self, _tmp4_, &_tmp5_, &_tmp6_);
	self->priv->background_logo_width = _tmp5_;
	self->priv->background_logo_height = _tmp6_;
	_cairo_surface_destroy0 (self->priv->background_logo_surface);
	self->priv->background_logo_surface = _tmp7_;
}


static cairo_surface_t* background_load_image (Background* self, const gchar* filename, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	cairo_surface_t* result = NULL;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_vala_height = 0;
	_tmp0_ = _vala_height;
	_vala_width = _tmp0_;
	{
		const gchar* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* image;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		cairo_surface_t* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		cairo_surface_t* _tmp12_;
		cairo_surface_t* surface;
		cairo_surface_t* _tmp13_;
		cairo_t* _tmp14_;
		cairo_t* c;
		cairo_t* _tmp15_;
		cairo_t* _tmp16_;
		_tmp1_ = filename;
		_tmp2_ = gdk_pixbuf_new_from_file (_tmp1_, &_inner_error_);
		image = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp3_ = gdk_pixbuf_get_width (image);
		_tmp4_ = _tmp3_;
		_vala_width = _tmp4_;
		_tmp5_ = gdk_pixbuf_get_height (image);
		_tmp6_ = _tmp5_;
		_vala_height = _tmp6_;
		_tmp7_ = self->priv->target_surface;
		_tmp8_ = gdk_pixbuf_get_width (image);
		_tmp9_ = _tmp8_;
		_tmp10_ = gdk_pixbuf_get_height (image);
		_tmp11_ = _tmp10_;
		_tmp12_ = cairo_surface_create_similar (_tmp7_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_, _tmp11_);
		surface = _tmp12_;
		_tmp13_ = surface;
		_tmp14_ = cairo_create (_tmp13_);
		c = _tmp14_;
		_tmp15_ = c;
		gdk_cairo_set_source_pixbuf (_tmp15_, image, (gdouble) 0, (gdouble) 0);
		_tmp16_ = c;
		cairo_paint (_tmp16_);
		result = surface;
		_cairo_destroy0 (c);
		_g_object_unref0 (image);
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = filename;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_debug ("background.vala:442: Failed to load background component %s: %s", _tmp17_, _tmp19_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}


static gpointer _monitor_ref0 (gpointer self) {
	return self ? monitor_ref (self) : NULL;
}


void background_set_monitors (Background* self, GList* monitors) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	__g_list_free__monitor_unref0_0 (self->priv->monitors);
	self->priv->monitors = NULL;
	_tmp0_ = monitors;
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp0_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			Monitor* _tmp1_;
			Monitor* m = NULL;
			_tmp1_ = _monitor_ref0 ((Monitor*) m_it->data);
			m = _tmp1_;
			{
				Monitor* _tmp2_;
				Monitor* _tmp3_;
				_tmp2_ = m;
				_tmp3_ = _monitor_ref0 (_tmp2_);
				self->priv->monitors = g_list_append (self->priv->monitors, _tmp3_);
				_monitor_unref0 (m);
			}
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void background_set_active_monitor (Background* self, Monitor* monitor) {
	Monitor* _tmp0_;
	Monitor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = monitor;
	_tmp1_ = _monitor_ref0 (_tmp0_);
	_monitor_unref0 (self->priv->active_monitor);
	self->priv->active_monitor = _tmp1_;
}


static void background_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	Background * self;
	gboolean _tmp0_ = FALSE;
	GtkAllocation _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gboolean _tmp7_;
	gboolean resized;
	GtkAllocation _tmp8_;
	gboolean _tmp9_;
	self = (Background*) base;
	g_return_if_fail (allocation != NULL);
	_tmp1_ = *allocation;
	_tmp2_ = _tmp1_.height;
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	if (_tmp2_ != _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkAllocation _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		_tmp4_ = *allocation;
		_tmp5_ = _tmp4_.width;
		_tmp6_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp0_ = _tmp5_ != _tmp6_;
	}
	_tmp7_ = _tmp0_;
	resized = _tmp7_;
	_tmp8_ = *allocation;
	GTK_WIDGET_CLASS (background_parent_class)->size_allocate ((GtkWidget*) GTK_FIXED (self), &_tmp8_);
	_tmp9_ = resized;
	if (_tmp9_) {
		GHashTable* _tmp10_;
		BackgroundLoader* _tmp11_ = NULL;
		BackgroundLoader* _tmp12_;
		g_debug ("background.vala:470: Regenerating backgrounds");
		_tmp10_ = self->priv->loaders;
		g_hash_table_remove_all (_tmp10_);
		_tmp11_ = background_load_background (self, NULL);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp12_);
		background_reload (self);
	}
}


static gboolean background_real_draw (GtkWidget* base, cairo_t* c) {
	Background * self;
	gboolean result = FALSE;
	BackgroundDrawFlags flags;
	gboolean _tmp0_;
	cairo_t* _tmp2_;
	BackgroundDrawFlags _tmp3_;
	cairo_t* _tmp4_;
	gboolean _tmp5_ = FALSE;
	self = (Background*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	flags = BACKGROUND_DRAW_FLAGS_NONE;
	_tmp0_ = self->priv->_draw_grid;
	if (_tmp0_) {
		BackgroundDrawFlags _tmp1_;
		_tmp1_ = flags;
		flags = _tmp1_ | BACKGROUND_DRAW_FLAGS_GRID;
	}
	_tmp2_ = c;
	_tmp3_ = flags;
	background_draw_full (self, _tmp2_, _tmp3_);
	_tmp4_ = c;
	_tmp5_ = GTK_WIDGET_CLASS (background_parent_class)->draw ((GtkWidget*) GTK_FIXED (self), _tmp4_);
	result = _tmp5_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void background_draw_full (Background* self, cairo_t* c, BackgroundDrawFlags flags) {
	cairo_t* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BackgroundLoader* _tmp2_;
	gboolean _tmp10_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	BackgroundLoader* _tmp28_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp32_;
	gboolean _tmp36_;
	cairo_t* _tmp38_;
	gboolean old_painted;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	BackgroundLoader* _tmp41_;
	gboolean _tmp44_;
	gboolean _tmp50_;
	gboolean _tmp53_ = FALSE;
	BackgroundLoader* _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp57_;
	cairo_t* _tmp64_;
	BackgroundDrawFlags _tmp65_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	cairo_save (_tmp0_);
	_tmp2_ = self->priv->current;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		BackgroundLoader* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp9_;
		_tmp4_ = self->priv->current;
		_tmp5_ = background_loader_load (_tmp4_);
		if (_tmp5_) {
			BackgroundLoader* _tmp6_;
			cairo_pattern_t** _tmp7_;
			gint _tmp7__length1;
			cairo_pattern_t* _tmp8_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_->patterns;
			_tmp7__length1 = _tmp6_->patterns_length1;
			_tmp8_ = _tmp7_[0];
			_tmp3_ = _tmp8_ == NULL;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp9_ = _tmp3_;
		_tmp1_ = _tmp9_;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		BackgroundLoader* _tmp11_ = NULL;
		BackgroundLoader* new_background;
		BackgroundLoader* _tmp12_;
		BackgroundLoader* _tmp20_;
		BackgroundLoader* _tmp21_;
		BackgroundLoader* _tmp24_;
		BackgroundLoader* _tmp25_;
		_tmp11_ = background_load_background (self, NULL);
		new_background = _tmp11_;
		_tmp12_ = self->priv->current;
		if (_tmp12_ != NULL) {
			GHashTable* _tmp13_;
			BackgroundLoader* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			BackgroundLoader* _tmp18_;
			BackgroundLoader* _tmp19_;
			_tmp13_ = self->priv->loaders;
			_tmp14_ = self->priv->current;
			_tmp15_ = background_loader_get_filename (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup (_tmp16_);
			_tmp18_ = new_background;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			g_hash_table_insert (_tmp13_, _tmp17_, _tmp19_);
		}
		_tmp20_ = self->priv->old;
		_tmp21_ = self->priv->current;
		if (_tmp20_ == _tmp21_) {
			BackgroundLoader* _tmp22_;
			BackgroundLoader* _tmp23_;
			_tmp22_ = new_background;
			_tmp23_ = _g_object_ref0 (_tmp22_);
			_g_object_unref0 (self->priv->old);
			self->priv->old = _tmp23_;
		}
		_tmp24_ = new_background;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_g_object_unref0 (self->priv->current);
		self->priv->current = _tmp25_;
		background_publish_average_color (self);
		_g_object_unref0 (new_background);
	}
	_tmp28_ = self->priv->current;
	_tmp29_ = background_loader_load (_tmp28_);
	if (_tmp29_) {
		BackgroundLoader* _tmp30_;
		BackgroundLoader* _tmp31_;
		_tmp30_ = self->priv->current;
		_tmp31_ = self->priv->old;
		_tmp27_ = _tmp30_ != _tmp31_;
	} else {
		_tmp27_ = FALSE;
	}
	_tmp32_ = _tmp27_;
	if (_tmp32_) {
		AnimateTimer* _tmp33_;
		gboolean _tmp34_;
		gboolean _tmp35_;
		_tmp33_ = self->priv->timer;
		_tmp34_ = animate_timer_get_is_running (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp26_ = !_tmp35_;
	} else {
		_tmp26_ = FALSE;
	}
	_tmp36_ = _tmp26_;
	if (_tmp36_) {
		AnimateTimer* _tmp37_;
		background_set_alpha (self, 0.0);
		_tmp37_ = self->priv->timer;
		animate_timer_reset (_tmp37_, -1);
	}
	_tmp38_ = c;
	cairo_set_source_rgba (_tmp38_, 0.0, 0.0, 0.0, 0.0);
	old_painted = FALSE;
	_tmp41_ = self->priv->old;
	if (_tmp41_ != NULL) {
		BackgroundLoader* _tmp42_;
		gboolean _tmp43_ = FALSE;
		_tmp42_ = self->priv->old;
		_tmp43_ = background_loader_load (_tmp42_);
		_tmp40_ = _tmp43_;
	} else {
		_tmp40_ = FALSE;
	}
	_tmp44_ = _tmp40_;
	if (_tmp44_) {
		gboolean _tmp45_ = FALSE;
		gdouble _tmp46_;
		gboolean _tmp49_;
		_tmp46_ = self->priv->_alpha;
		if (_tmp46_ < 1.0) {
			_tmp45_ = TRUE;
		} else {
			BackgroundLoader* _tmp47_;
			gboolean _tmp48_ = FALSE;
			_tmp47_ = self->priv->current;
			_tmp48_ = background_loader_load (_tmp47_);
			_tmp45_ = !_tmp48_;
		}
		_tmp49_ = _tmp45_;
		_tmp39_ = _tmp49_;
	} else {
		_tmp39_ = FALSE;
	}
	_tmp50_ = _tmp39_;
	if (_tmp50_) {
		cairo_t* _tmp51_;
		BackgroundLoader* _tmp52_;
		_tmp51_ = c;
		_tmp52_ = self->priv->old;
		background_draw_background (self, _tmp51_, _tmp52_, 1.0);
		old_painted = TRUE;
	}
	_tmp54_ = self->priv->current;
	_tmp55_ = background_loader_load (_tmp54_);
	if (_tmp55_) {
		gdouble _tmp56_;
		_tmp56_ = self->priv->_alpha;
		_tmp53_ = _tmp56_ > 0.0;
	} else {
		_tmp53_ = FALSE;
	}
	_tmp57_ = _tmp53_;
	if (_tmp57_) {
		gdouble _tmp58_ = 0.0;
		gboolean _tmp59_;
		cairo_t* _tmp61_;
		BackgroundLoader* _tmp62_;
		gdouble _tmp63_;
		_tmp59_ = old_painted;
		if (_tmp59_) {
			gdouble _tmp60_;
			_tmp60_ = self->priv->_alpha;
			_tmp58_ = _tmp60_;
		} else {
			_tmp58_ = 1.0;
		}
		_tmp61_ = c;
		_tmp62_ = self->priv->current;
		_tmp63_ = _tmp58_;
		background_draw_background (self, _tmp61_, _tmp62_, _tmp63_);
	}
	_tmp64_ = c;
	cairo_restore (_tmp64_);
	_tmp65_ = flags;
	if ((_tmp65_ & BACKGROUND_DRAW_FLAGS_GRID) != 0) {
		cairo_t* _tmp66_;
		_tmp66_ = c;
		background_overlay_grid (self, _tmp66_);
	}
}


static void background_draw_background (Background* self, cairo_t* c, BackgroundLoader* background, gdouble alpha) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (background != NULL);
	_tmp0_ = self->priv->monitors;
	{
		GList* monitor_collection = NULL;
		GList* monitor_it = NULL;
		monitor_collection = _tmp0_;
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
			Monitor* _tmp1_;
			Monitor* monitor = NULL;
			_tmp1_ = _monitor_ref0 ((Monitor*) monitor_it->data);
			monitor = _tmp1_;
			{
				BackgroundLoader* _tmp2_;
				Monitor* _tmp3_;
				gint _tmp4_;
				Monitor* _tmp5_;
				gint _tmp6_;
				cairo_pattern_t* _tmp7_ = NULL;
				cairo_pattern_t* pattern;
				cairo_pattern_t* _tmp8_;
				cairo_t* _tmp9_;
				BackgroundLoader* _tmp10_;
				Monitor* _tmp11_;
				gint _tmp12_;
				Monitor* _tmp13_;
				gint _tmp14_;
				cairo_pattern_t* _tmp15_ = NULL;
				cairo_matrix_t matrix = {0};
				Monitor* _tmp16_;
				gint _tmp17_;
				Monitor* _tmp18_;
				gint _tmp19_;
				cairo_pattern_t* _tmp20_;
				cairo_matrix_t _tmp21_;
				cairo_t* _tmp22_;
				cairo_pattern_t* _tmp23_;
				cairo_t* _tmp24_;
				Monitor* _tmp25_;
				gint _tmp26_;
				Monitor* _tmp27_;
				gint _tmp28_;
				Monitor* _tmp29_;
				gint _tmp30_;
				Monitor* _tmp31_;
				gint _tmp32_;
				cairo_t* _tmp33_;
				cairo_t* _tmp34_;
				gdouble _tmp35_;
				cairo_t* _tmp36_;
				gboolean _tmp37_ = FALSE;
				Monitor* _tmp38_;
				Monitor* _tmp39_;
				gboolean _tmp41_;
				_tmp2_ = background;
				_tmp3_ = monitor;
				_tmp4_ = _tmp3_->width;
				_tmp5_ = monitor;
				_tmp6_ = _tmp5_->height;
				_tmp7_ = background_loader_get_pattern (_tmp2_, _tmp4_, _tmp6_);
				pattern = _tmp7_;
				_tmp8_ = pattern;
				if (_tmp8_ == NULL) {
					_cairo_pattern_destroy0 (pattern);
					_monitor_unref0 (monitor);
					continue;
				}
				_tmp9_ = c;
				cairo_save (_tmp9_);
				_tmp10_ = background;
				_tmp11_ = monitor;
				_tmp12_ = _tmp11_->width;
				_tmp13_ = monitor;
				_tmp14_ = _tmp13_->height;
				_tmp15_ = background_loader_get_pattern (_tmp10_, _tmp12_, _tmp14_);
				_cairo_pattern_destroy0 (pattern);
				pattern = _tmp15_;
				cairo_matrix_init_identity (&matrix);
				_tmp16_ = monitor;
				_tmp17_ = _tmp16_->x;
				_tmp18_ = monitor;
				_tmp19_ = _tmp18_->y;
				cairo_matrix_translate (&matrix, (gdouble) (-_tmp17_), (gdouble) (-_tmp19_));
				_tmp20_ = pattern;
				_tmp21_ = matrix;
				cairo_pattern_set_matrix (_tmp20_, &_tmp21_);
				_tmp22_ = c;
				_tmp23_ = pattern;
				cairo_set_source (_tmp22_, _tmp23_);
				_tmp24_ = c;
				_tmp25_ = monitor;
				_tmp26_ = _tmp25_->x;
				_tmp27_ = monitor;
				_tmp28_ = _tmp27_->y;
				_tmp29_ = monitor;
				_tmp30_ = _tmp29_->width;
				_tmp31_ = monitor;
				_tmp32_ = _tmp31_->height;
				cairo_rectangle (_tmp24_, (gdouble) _tmp26_, (gdouble) _tmp28_, (gdouble) _tmp30_, (gdouble) _tmp32_);
				_tmp33_ = c;
				cairo_clip (_tmp33_);
				_tmp34_ = c;
				_tmp35_ = alpha;
				cairo_paint_with_alpha (_tmp34_, _tmp35_);
				_tmp36_ = c;
				cairo_restore (_tmp36_);
				_tmp38_ = monitor;
				_tmp39_ = self->priv->active_monitor;
				if (_tmp38_ != _tmp39_) {
					cairo_surface_t* _tmp40_;
					_tmp40_ = self->priv->background_logo_surface;
					_tmp37_ = _tmp40_ != NULL;
				} else {
					_tmp37_ = FALSE;
				}
				_tmp41_ = _tmp37_;
				if (_tmp41_) {
					gint _tmp42_;
					gint width;
					gint _tmp43_;
					gint height;
					cairo_t* _tmp44_;
					cairo_surface_t* _tmp45_;
					cairo_pattern_t* _tmp46_;
					Monitor* _tmp47_;
					gint _tmp48_;
					Monitor* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					gint x;
					Monitor* _tmp52_;
					gint _tmp53_;
					Monitor* _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					gint y;
					gint _tmp57_;
					gint _tmp58_;
					cairo_pattern_t* _tmp59_;
					cairo_matrix_t _tmp60_;
					cairo_t* _tmp61_;
					cairo_pattern_t* _tmp62_;
					cairo_t* _tmp63_;
					gint _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					cairo_t* _tmp68_;
					cairo_t* _tmp69_;
					gdouble _tmp70_;
					cairo_t* _tmp71_;
					_tmp42_ = self->priv->background_logo_width;
					width = _tmp42_;
					_tmp43_ = self->priv->background_logo_height;
					height = _tmp43_;
					_tmp44_ = c;
					cairo_save (_tmp44_);
					_tmp45_ = self->priv->background_logo_surface;
					_tmp46_ = cairo_pattern_create_for_surface (_tmp45_);
					_cairo_pattern_destroy0 (pattern);
					pattern = _tmp46_;
					cairo_matrix_init_identity (&matrix);
					_tmp47_ = monitor;
					_tmp48_ = _tmp47_->x;
					_tmp49_ = monitor;
					_tmp50_ = _tmp49_->width;
					_tmp51_ = width;
					x = _tmp48_ + ((_tmp50_ - _tmp51_) / 2);
					_tmp52_ = monitor;
					_tmp53_ = _tmp52_->y;
					_tmp54_ = monitor;
					_tmp55_ = _tmp54_->height;
					_tmp56_ = height;
					y = _tmp53_ + ((_tmp55_ - _tmp56_) / 2);
					_tmp57_ = x;
					_tmp58_ = y;
					cairo_matrix_translate (&matrix, (gdouble) (-_tmp57_), (gdouble) (-_tmp58_));
					_tmp59_ = pattern;
					_tmp60_ = matrix;
					cairo_pattern_set_matrix (_tmp59_, &_tmp60_);
					_tmp61_ = c;
					_tmp62_ = pattern;
					cairo_set_source (_tmp61_, _tmp62_);
					_tmp63_ = c;
					_tmp64_ = x;
					_tmp65_ = y;
					_tmp66_ = width;
					_tmp67_ = height;
					cairo_rectangle (_tmp63_, (gdouble) _tmp64_, (gdouble) _tmp65_, (gdouble) _tmp66_, (gdouble) _tmp67_);
					_tmp68_ = c;
					cairo_clip (_tmp68_);
					_tmp69_ = c;
					_tmp70_ = alpha;
					cairo_paint_with_alpha (_tmp69_, _tmp70_);
					_tmp71_ = c;
					cairo_restore (_tmp71_);
				}
				_cairo_pattern_destroy0 (pattern);
				_monitor_unref0 (monitor);
			}
		}
	}
}


static void background_animate_cb (Background* self, gdouble progress) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = progress;
	background_set_alpha (self, _tmp0_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp1_ = self->priv->_alpha;
	if (_tmp1_ >= 1.0) {
		BackgroundLoader* _tmp2_;
		BackgroundLoader* _tmp3_;
		_tmp2_ = self->priv->current;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->old);
		self->priv->old = _tmp3_;
	}
}


static void background_reload (Background* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (_tmp0_) {
		const gchar* _tmp1_;
		BackgroundLoader* _tmp2_ = NULL;
		BackgroundLoader* new_background;
		BackgroundLoader* _tmp3_;
		BackgroundLoader* _tmp4_;
		_tmp1_ = self->priv->_current_background;
		_tmp2_ = background_load_background (self, _tmp1_);
		new_background = _tmp2_;
		_tmp3_ = self->priv->current;
		_tmp4_ = new_background;
		if (_tmp3_ != _tmp4_) {
			BackgroundLoader* _tmp5_;
			BackgroundLoader* _tmp6_;
			BackgroundLoader* _tmp7_;
			BackgroundLoader* _tmp8_;
			AnimateTimer* _tmp9_;
			_tmp5_ = self->priv->current;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (self->priv->old);
			self->priv->old = _tmp6_;
			_tmp7_ = new_background;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			_g_object_unref0 (self->priv->current);
			self->priv->current = _tmp8_;
			background_set_alpha (self, 1.0);
			_tmp9_ = self->priv->timer;
			animate_timer_stop (_tmp9_);
		}
		gtk_widget_queue_draw ((GtkWidget*) self);
		background_publish_average_color (self);
		_g_object_unref0 (new_background);
	}
}


static void ___lambda3_ (Background* self) {
	background_reload (self);
}


static void ____lambda3__background_loader_loaded (BackgroundLoader* _sender, gpointer self) {
	___lambda3_ (self);
}


static BackgroundLoader* background_load_background (Background* self, const gchar* filename) {
	BackgroundLoader* result = NULL;
	const gchar* _tmp0_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	BackgroundLoader* _tmp5_;
	BackgroundLoader* b;
	BackgroundLoader* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = filename;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_default_background;
		filename = _tmp1_;
	}
	_tmp2_ = self->priv->loaders;
	_tmp3_ = filename;
	_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 ((BackgroundLoader*) _tmp4_);
	b = _tmp5_;
	_tmp6_ = b;
	if (_tmp6_ == NULL) {
		GList* _tmp7_;
		guint _tmp8_ = 0U;
		gint* _tmp9_ = NULL;
		gint* widths;
		gint widths_length1;
		gint _widths_size_;
		GList* _tmp10_;
		guint _tmp11_ = 0U;
		gint* _tmp12_ = NULL;
		gint* heights;
		gint heights_length1;
		gint _heights_size_;
		gint n_sizes;
		GList* _tmp13_;
		gint _tmp28_;
		gint _tmp29_ = 0;
		gint _tmp30_;
		gint _tmp31_ = 0;
		cairo_surface_t* _tmp32_;
		const gchar* _tmp33_;
		gint* _tmp34_;
		gint _tmp34__length1;
		gint* _tmp35_;
		gint _tmp35__length1;
		gboolean _tmp36_;
		BackgroundLoader* _tmp37_;
		BackgroundLoader* _tmp38_;
		cairo_surface_t* _tmp39_;
		BackgroundLoader* _tmp40_;
		BackgroundLoader* _tmp41_;
		GHashTable* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		BackgroundLoader* _tmp45_;
		BackgroundLoader* _tmp46_;
		_tmp7_ = self->priv->monitors;
		_tmp8_ = g_list_length (_tmp7_);
		_tmp9_ = g_new0 (gint, _tmp8_);
		widths = _tmp9_;
		widths_length1 = _tmp8_;
		_widths_size_ = widths_length1;
		_tmp10_ = self->priv->monitors;
		_tmp11_ = g_list_length (_tmp10_);
		_tmp12_ = g_new0 (gint, _tmp11_);
		heights = _tmp12_;
		heights_length1 = _tmp11_;
		_heights_size_ = heights_length1;
		n_sizes = 0;
		_tmp13_ = self->priv->monitors;
		{
			GList* monitor_collection = NULL;
			GList* monitor_it = NULL;
			monitor_collection = _tmp13_;
			for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
				Monitor* _tmp14_;
				Monitor* monitor = NULL;
				_tmp14_ = _monitor_ref0 ((Monitor*) monitor_it->data);
				monitor = _tmp14_;
				{
					Monitor* _tmp15_;
					gboolean _tmp16_ = FALSE;
					_tmp15_ = monitor;
					_tmp16_ = background_monitor_is_unique_size (self, _tmp15_);
					if (_tmp16_) {
						gint* _tmp17_;
						gint _tmp17__length1;
						gint _tmp18_;
						Monitor* _tmp19_;
						gint _tmp20_;
						gint _tmp21_;
						gint* _tmp22_;
						gint _tmp22__length1;
						gint _tmp23_;
						Monitor* _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						_tmp17_ = widths;
						_tmp17__length1 = widths_length1;
						_tmp18_ = n_sizes;
						_tmp19_ = monitor;
						_tmp20_ = _tmp19_->width;
						_tmp17_[_tmp18_] = _tmp20_;
						_tmp21_ = _tmp17_[_tmp18_];
						_tmp22_ = heights;
						_tmp22__length1 = heights_length1;
						_tmp23_ = n_sizes;
						_tmp24_ = monitor;
						_tmp25_ = _tmp24_->height;
						_tmp22_[_tmp23_] = _tmp25_;
						_tmp26_ = _tmp22_[_tmp23_];
						_tmp27_ = n_sizes;
						n_sizes = _tmp27_ + 1;
					}
					_monitor_unref0 (monitor);
				}
			}
		}
		_tmp28_ = n_sizes;
		_tmp29_ = _tmp28_;
		widths = g_renew (gint, widths, _tmp28_);
		(_tmp29_ > widths_length1) ? memset (widths + widths_length1, 0, sizeof (gint) * (_tmp29_ - widths_length1)) : NULL;
		widths_length1 = _tmp29_;
		_widths_size_ = _tmp29_;
		_tmp30_ = n_sizes;
		_tmp31_ = _tmp30_;
		heights = g_renew (gint, heights, _tmp30_);
		(_tmp31_ > heights_length1) ? memset (heights + heights_length1, 0, sizeof (gint) * (_tmp31_ - heights_length1)) : NULL;
		heights_length1 = _tmp31_;
		_heights_size_ = _tmp31_;
		_tmp32_ = self->priv->target_surface;
		_tmp33_ = filename;
		_tmp34_ = widths;
		_tmp34__length1 = widths_length1;
		_tmp35_ = heights;
		_tmp35__length1 = heights_length1;
		_tmp36_ = self->priv->_draw_grid;
		_tmp37_ = background_loader_new (_tmp32_, _tmp33_, _tmp34_, _tmp34__length1, _tmp35_, _tmp35__length1, _tmp36_);
		_g_object_unref0 (b);
		b = _tmp37_;
		_tmp38_ = b;
		_tmp39_ = self->priv->version_logo_surface;
		background_loader_set_logo (_tmp38_, _tmp39_);
		_tmp40_ = b;
		g_signal_connect_object (_tmp40_, "loaded", (GCallback) ____lambda3__background_loader_loaded, self, 0);
		_tmp41_ = b;
		background_loader_load (_tmp41_);
		_tmp42_ = self->priv->loaders;
		_tmp43_ = filename;
		_tmp44_ = g_strdup (_tmp43_);
		_tmp45_ = b;
		_tmp46_ = _g_object_ref0 (_tmp45_);
		g_hash_table_insert (_tmp42_, _tmp44_, _tmp46_);
		heights = (g_free (heights), NULL);
		widths = (g_free (widths), NULL);
	}
	result = b;
	return result;
}


static gboolean background_monitor_is_unique_size (Background* self, Monitor* monitor) {
	gboolean result = FALSE;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (monitor != NULL, FALSE);
	_tmp0_ = self->priv->monitors;
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp0_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			Monitor* _tmp1_;
			Monitor* m = NULL;
			_tmp1_ = _monitor_ref0 ((Monitor*) m_it->data);
			m = _tmp1_;
			{
				Monitor* _tmp2_;
				Monitor* _tmp3_;
				_tmp2_ = m;
				_tmp3_ = monitor;
				if (_tmp2_ == _tmp3_) {
					_monitor_unref0 (m);
					break;
				} else {
					gboolean _tmp4_ = FALSE;
					Monitor* _tmp5_;
					gint _tmp6_;
					Monitor* _tmp7_;
					gint _tmp8_;
					gboolean _tmp13_;
					_tmp5_ = m;
					_tmp6_ = _tmp5_->width;
					_tmp7_ = monitor;
					_tmp8_ = _tmp7_->width;
					if (_tmp6_ == _tmp8_) {
						Monitor* _tmp9_;
						gint _tmp10_;
						Monitor* _tmp11_;
						gint _tmp12_;
						_tmp9_ = m;
						_tmp10_ = _tmp9_->height;
						_tmp11_ = monitor;
						_tmp12_ = _tmp11_->height;
						_tmp4_ = _tmp10_ == _tmp12_;
					} else {
						_tmp4_ = FALSE;
					}
					_tmp13_ = _tmp4_;
					if (_tmp13_) {
						result = FALSE;
						_monitor_unref0 (m);
						return result;
					}
				}
				_monitor_unref0 (m);
			}
		}
	}
	result = TRUE;
	return result;
}


static void background_overlay_grid (Background* self, cairo_t* c) {
	gint _tmp0_ = 0;
	gint width;
	gint _tmp1_ = 0;
	gint height;
	gint _tmp2_ = 0;
	gint grid_x_offset;
	gint _tmp3_ = 0;
	gint grid_y_offset;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* overlay_surface;
	cairo_t* _tmp6_;
	cairo_t* oc;
	cairo_pattern_t* _tmp7_;
	cairo_pattern_t* overlay;
	cairo_matrix_t matrix = {0};
	cairo_matrix_t _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	height = _tmp1_;
	_tmp2_ = get_grid_offset (width);
	grid_x_offset = _tmp2_;
	_tmp3_ = get_grid_offset (height);
	grid_y_offset = _tmp3_;
	_tmp4_ = self->priv->target_surface;
	_tmp5_ = cairo_surface_create_similar (_tmp4_, CAIRO_CONTENT_COLOR_ALPHA, grid_size, grid_size);
	overlay_surface = _tmp5_;
	_tmp6_ = cairo_create (overlay_surface);
	oc = _tmp6_;
	cairo_rectangle (oc, (gdouble) 0, (gdouble) 0, (gdouble) 1, (gdouble) 1);
	cairo_rectangle (oc, (gdouble) (grid_size - 1), (gdouble) 0, (gdouble) 1, (gdouble) 1);
	cairo_rectangle (oc, (gdouble) 0, (gdouble) (grid_size - 1), (gdouble) 1, (gdouble) 1);
	cairo_rectangle (oc, (gdouble) (grid_size - 1), (gdouble) (grid_size - 1), (gdouble) 1, (gdouble) 1);
	cairo_set_source_rgba (oc, 1.0, 1.0, 1.0, 0.25);
	cairo_fill (oc);
	_tmp7_ = cairo_pattern_create_for_surface (overlay_surface);
	overlay = _tmp7_;
	cairo_matrix_init_identity (&matrix);
	cairo_matrix_translate (&matrix, (gdouble) (-grid_x_offset), (gdouble) (-grid_y_offset));
	_tmp8_ = matrix;
	cairo_pattern_set_matrix (overlay, &_tmp8_);
	cairo_pattern_set_extend (overlay, CAIRO_EXTEND_REPEAT);
	_tmp9_ = c;
	cairo_save (_tmp9_);
	_tmp10_ = c;
	cairo_set_source (_tmp10_, overlay);
	_tmp11_ = c;
	cairo_rectangle (_tmp11_, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	_tmp12_ = c;
	cairo_fill (_tmp12_);
	_tmp13_ = c;
	cairo_restore (_tmp13_);
	_cairo_pattern_destroy0 (overlay);
	_cairo_destroy0 (oc);
	_cairo_surface_destroy0 (overlay_surface);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void background_publish_average_color (Background* self) {
	BackgroundLoader* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* rgba;
	GdkScreen* _tmp2_ = NULL;
	GdkWindow* _tmp3_ = NULL;
	GdkWindow* _tmp4_;
	GdkWindow* root;
	GdkAtom _tmp5_ = 0U;
	GdkAtom _tmp6_ = 0U;
	guint8* _tmp7_;
	gint _tmp7__length1;
	guint8* _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = gdk_rgba_to_string (&_tmp0_->average_color);
	rgba = _tmp1_;
	_tmp2_ = gtk_widget_get_screen ((GtkWidget*) self);
	_tmp3_ = gdk_screen_get_root_window (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	root = _tmp4_;
	_tmp5_ = gdk_atom_intern_static_string ("_GNOME_BACKGROUND_REPRESENTATIVE_COLORS");
	_tmp6_ = gdk_atom_intern_static_string ("STRING");
	_tmp7_ = string_get_data (rgba, &_tmp7__length1);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	gdk_property_change (root, _tmp5_, _tmp6_, 8, GDK_PROP_MODE_REPLACE, (guchar*) _tmp8_, _tmp8__length1);
	_g_object_unref0 (root);
	_g_free0 (rgba);
}


const gchar* background_get_default_background (Background* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_background;
	result = _tmp0_;
	return result;
}


void background_set_default_background (Background* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_default_background);
	self->priv->_default_background = _tmp1_;
	g_object_notify ((GObject *) self, "default-background");
}


const gchar* background_get_current_background (Background* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_background;
	result = _tmp0_;
	return result;
}


void background_set_current_background (Background* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_background);
	self->priv->_current_background = _tmp1_;
	g_object_notify ((GObject *) self, "current-background");
}


gboolean background_get_draw_grid (Background* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_draw_grid;
	result = _tmp0_;
	return result;
}


void background_set_draw_grid (Background* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_draw_grid = _tmp0_;
	g_object_notify ((GObject *) self, "draw-grid");
}


gdouble background_get_alpha (Background* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_alpha;
	result = _tmp0_;
	return result;
}


static void background_set_alpha (Background* self, gdouble value) {
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_alpha = _tmp0_;
	g_object_notify ((GObject *) self, "alpha");
}


static void background_class_init (BackgroundClass * klass) {
	background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BackgroundPrivate));
	GTK_WIDGET_CLASS (klass)->size_allocate = background_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->draw = background_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_background_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_background_set_property;
	G_OBJECT_CLASS (klass)->finalize = background_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_DEFAULT_BACKGROUND, g_param_spec_string ("default-background", "default-background", "default-background", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_CURRENT_BACKGROUND, g_param_spec_string ("current-background", "current-background", "current-background", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_DRAW_GRID, g_param_spec_boolean ("draw-grid", "draw-grid", "draw-grid", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_ALPHA, g_param_spec_double ("alpha", "alpha", "alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void background_instance_init (Background * self) {
	gchar* _tmp0_ = NULL;
	self->priv = BACKGROUND_GET_PRIVATE (self);
	_tmp0_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND_COLOR);
	self->priv->_default_background = _tmp0_;
	self->priv->_current_background = NULL;
	self->priv->_draw_grid = TRUE;
	self->priv->_alpha = 1.0;
	self->priv->monitors = NULL;
	self->priv->active_monitor = NULL;
	self->priv->version_logo_surface = NULL;
	self->priv->background_logo_surface = NULL;
}


static void background_finalize (GObject* obj) {
	Background * self;
	self = BACKGROUND (obj);
	_g_free0 (self->priv->_default_background);
	_g_free0 (self->priv->_current_background);
	_cairo_surface_destroy0 (self->priv->target_surface);
	__g_list_free__monitor_unref0_0 (self->priv->monitors);
	_monitor_unref0 (self->priv->active_monitor);
	_g_object_unref0 (self->priv->timer);
	_g_object_unref0 (self->priv->current);
	_g_object_unref0 (self->priv->old);
	_g_hash_table_unref0 (self->priv->loaders);
	_cairo_surface_destroy0 (self->priv->version_logo_surface);
	_cairo_surface_destroy0 (self->priv->background_logo_surface);
	G_OBJECT_CLASS (background_parent_class)->finalize (obj);
}


GType background_get_type (void) {
	static volatile gsize background_type_id__volatile = 0;
	if (g_once_init_enter (&background_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Background), 0, (GInstanceInitFunc) background_instance_init, NULL };
		GType background_type_id;
		background_type_id = g_type_register_static (GTK_TYPE_FIXED, "Background", &g_define_type_info, 0);
		g_once_init_leave (&background_type_id__volatile, background_type_id);
	}
	return background_type_id__volatile;
}


static void _vala_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Background * self;
	self = BACKGROUND (object);
	switch (property_id) {
		case BACKGROUND_DEFAULT_BACKGROUND:
		g_value_set_string (value, background_get_default_background (self));
		break;
		case BACKGROUND_CURRENT_BACKGROUND:
		g_value_set_string (value, background_get_current_background (self));
		break;
		case BACKGROUND_DRAW_GRID:
		g_value_set_boolean (value, background_get_draw_grid (self));
		break;
		case BACKGROUND_ALPHA:
		g_value_set_double (value, background_get_alpha (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Background * self;
	self = BACKGROUND (object);
	switch (property_id) {
		case BACKGROUND_DEFAULT_BACKGROUND:
		background_set_default_background (self, g_value_get_string (value));
		break;
		case BACKGROUND_CURRENT_BACKGROUND:
		background_set_current_background (self, g_value_get_string (value));
		break;
		case BACKGROUND_DRAW_GRID:
		background_set_draw_grid (self, g_value_get_boolean (value));
		break;
		case BACKGROUND_ALPHA:
		background_set_alpha (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



