// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-
var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/ctypes.jsm");

Cu.import("resource://unity/unity-global-property-initializer.js");

var wm = Cc["@mozilla.org/appshell/window-mediator;1"];
var pbs = Cc["@mozilla.org/privatebrowsing;1"].getService(Ci.nsIPrivateBrowsingService);

function Observer() {
    this._init();
}

Observer.prototype = {
    _init: function () {
    },

    observe : function(aWindow, aTopic, aData) {
        if (aWindow instanceof Ci.nsIDOMWindow && aTopic == 'content-document-global-created') {
            if (pbs.privateBrowsingEnabled)
                return;

            UnityGlobalPropertyInitializer.handle(aWindow);
        }
    }
};

var EXPORTED_SYMBOLS = [ "Observer" ];
